package org.jboss.test.managed.factory.support.mcf;


import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;


/**
 * A ManagedConnectionEmptyContentAdapter.
 * 
 * @author <a href="weston.price@jboss.org">Weston Price</a>
 * @author <a href="alex@jboss.com">Alexey Loubyansky</a>
 * @version $Revision: 1.1 $
 */
public class ManagedConnectionEmptyContentAdapter extends XmlAdapter<ManagedConnectionEmptyContentAdapter.EmptyElement, Boolean>
{
   @XmlType(factoryMethod="instance")
   public static class EmptyElement
   {
      public static EmptyElement INSTANCE = new EmptyElement();
      
      public static EmptyElement instance()
      {
         return INSTANCE;
      }

      private EmptyElement(){}      
   }

   @Override
   public EmptyElement marshal(Boolean v) throws Exception
   {
      return Boolean.TRUE.equals(v) ? EmptyElement.INSTANCE : null;
   }

   @Override
   public Boolean unmarshal(EmptyElement v) throws Exception
   {
      return v == null ? Boolean.FALSE : Boolean.TRUE;
   }
}
