/*
 * @(#)TimedProcessUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.thread.v1;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the TimedProcess class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   Jan 6, 2002
 */
public class TimedProcessUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    private static final Class THIS_CLASS = TimedProcessUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public TimedProcessUTest( String name )
    {
        super( name );
    }



    //-------------------------------------------------------------------------
    // Tests
    
    
    
    public void testConstruction1()
    {
        assertNotNull(
            "GetInstance must never return null.",
            TimedProcess.getInstance() );
    }
    
    
    private int runCount = 0;
    
    public void testRunRight1() throws InterruptedException
    {
        Runnable r = new Runnable()
        {
            public void run()
            {
                ++runCount;
            }
        };
        this.runCount = 0;
        TimedProcess.getInstance().runTimed( r, 60 * 1000 );
        assertEquals(
            "did not run thread.",
            1,
            this.runCount );
    }
    
    public void testRunWrong1()
    {
        Runnable r = new Runnable()
        {
            public void run()
            {
                // sleep longer than the timer.
                // give it a bit of leeway
                try
                {
                    Thread.sleep( 2 * 1000 );
                }
                catch (InterruptedException ie)
                {
                    // ignore
                }
            }
        };
        try
        {
            TimedProcess.getInstance().runTimed( r, 1000 );
            fail( "Did not throw InterruptedException." );
        }
        catch (InterruptedException ie)
        {
            // test exception?
        }
    }


    private boolean stop = false;
    public void testRunOwn1()
    {
        Runnable r = new Runnable()
        {
            public void run()
            {
                while (stop == false)
                {
                    Thread.yield();
                }
            }
        };
        TimedProcess.RunnableKiller rk = new TimedProcess.RunnableKiller()
        {
            public void killRunnable( Runnable r, Thread t )
            {
                stop = true;
            }
        };
        try
        {
            TimedProcess.getInstance().runTimed( r, 1000, rk );
            fail( "Did not throw InterruptedException." );
        }
        catch (InterruptedException ie)
        {
            // test exception?
        }
    }
    
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

