/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.InstanceProfileRemoveRoleRequest;
import com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMInstanceProfileRemoveRoleDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMInstanceProfileRemoveRoleDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof InstanceProfileRemoveRoleRequest) {
            InstanceProfileRemoveRoleRequest removeRequest = (InstanceProfileRemoveRoleRequest)request;
            LOG.debug((Object)("Dissociating IAM role from Instance Profile: " + removeRequest));
            if (removeRequest.getInstanceProfileName() == null) {
                Utils.exit(1, "no Instance Profile name has been passed in.", null);
            }
            if (removeRequest.getRoleName() == null) {
                Utils.exit(1, "no role name has been passed in.", null);
            }
            RemoveRoleFromInstanceProfileRequest roleRemoveRequest = new RemoveRoleFromInstanceProfileRequest();
            roleRemoveRequest.setInstanceProfileName(removeRequest.getInstanceProfileName());
            roleRemoveRequest.setRoleName(removeRequest.getRoleName());
            this.getClient().removeRoleFromInstanceProfile(roleRemoveRequest);
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

