/* ************************************************
   File: simple.cpp

   Purpose:  Simple Program from Tutorial
   	This program will compile in Core Levels 1 and 3.
	In Level 3, there is no error.
	In Level 1, it is mostly error.
		
   Usage:
        % simple

   Core Library
   $Id: simple.cpp,v 1.2 2004/10/04 03:29:19 exact Exp $
 ************************************************ */  

#ifndef CORE_LEVEL
#   define CORE_LEVEL 3
#endif

#include "CORE/CORE.h"  // this must appear after the standard headers
using namespace std;

bool test(double x, double y, bool verbose=false) {
  double e = sqrt(x) + sqrt(y);
  double f = sqrt(x + y + 2 * sqrt(x*y));
  bool correct = ((e==f)? true : false);
  if (verbose) {
  cout << "==============================================" << endl;
  cout << ">>  x = " << x << endl;
  cout << ">>  y = " << y << endl;
  cout << ">>  e = sqrt(x) + sqrt(y)" << endl;
  cout << ">>  f = sqrt(x + y + 2*sqrt(x*y))" << endl;
  cout << ">>  e == f ? " << ((correct) ? 
           "  yes (CORRECT!)" :
           "  no (ERROR!)"  ) << endl;
  cout << "==============================================" << endl;
  }
  return correct;
}
  
int main() {

  double x = 1234567890; 
  double y = 1234567890.987654321; 

  test(x,y,true);

  int corr = 0;
  int incorr = 0;
  for (int i= 100; i<120; i++) {
	  for (int j = 117; j< 137; j++) {
		  if (test(i, j/7, false)) corr++;
		  else incorr++;
	  }
  }
  cout << "Correct Tests = " << corr << endl;
  cout << "Incorrect Tests = " << incorr << endl;
  if (incorr>0)
	  cout << "ERROR! There is at least one test with error!" << endl;
  else
	  cout << "CORRECT! There are no test with error!" << endl;
  return 0;
}

