.de IQ
.  br
.  ns
.  IP "\\$1"
..
.SS "VLOG COMMANDS"
These commands manage \fB\*(PN\fR's logging settings.
.IP "\fBvlog/set\fR [\fIspec\fR]"
Sets logging levels.  Without any \fIspec\fR, sets the log level for
every module and destination to \fBdbg\fR.  Otherwise, \fIspec\fR is a
list of words separated by spaces or commas or colons, up to one from
each category below:
.
.RS
.IP \(bu
A valid module name, as displayed by the \fBvlog/list\fR command on
\fBovs\-appctl\fR(8), limits the log level change to the specified
module.
.
.IP \(bu
\fBsyslog\fR, \fBconsole\fR, or \fBfile\fR, to limit the log level
change to only to the system log, to the console, or to a file,
respectively.
.IP
On Windows platform, \fBsyslog\fR is accepted as a word and is only
useful along with the \fB\-\-syslog\-target\fR option (the word has no
effect otherwise).
.
.IP \(bu 
\fBoff\fR, \fBemer\fR, \fBerr\fR, \fBwarn\fR, \fBinfo\fR, or
\fBdbg\fR, to control the log level.  Messages of the given severity
or higher will be logged, and messages of lower severity will be
filtered out.  \fBoff\fR filters out all messages.  See
\fBovs\-appctl\fR(8) for a definition of each log level.
.RE
.
.IP
Case is not significant within \fIspec\fR.
.IP
Regardless of the log levels set for \fBfile\fR, logging to a file
will not take place unless \fB\*(PN\fR was invoked with the
\fB\-\-log\-file\fR option.
.IP
For compatibility with older versions of OVS, \fBany\fR is accepted as
a word but has no effect.
.RE
.IP "\fBvlog/set PATTERN:\fIdestination\fB:\fIpattern\fR"
Sets the log pattern for \fIdestination\fR to \fIpattern\fR.  Refer to
\fBovs\-appctl\fR(8) for a description of the valid syntax for \fIpattern\fR.
.
.IP "\fBvlog/list\fR"
Lists the supported logging modules and their current levels.
.
.IP "\fBvlog/list-pattern\fR"
Lists logging patterns used for each destination.
.
.IP "\fBvlog/reopen\fR"
Causes \fB\*(PN\fR to close and reopen its log file.  (This is useful
after rotating log files, to cause a new log file to be used.)
.IP
This has no effect unless \fB\*(PN\fR was invoked with the
\fB\-\-log\-file\fR option.
.
.IP "\fBvlog/disable\-rate\-limit \fR[\fImodule\fR]..."
.IQ "\fBvlog/enable\-rate\-limit \fR[\fImodule\fR]..."
By default, \fB\*(PN\fR limits the rate at which certain messages can
be logged.  When a message would appear more frequently than the
limit, it is suppressed.  This saves disk space, makes logs easier to
read, and speeds up execution, but occasionally troubleshooting
requires more detail.  Therefore, \fBvlog/disable\-rate\-limit\fR
allows rate limits to be disabled at the level of an individual log
module.  Specify one or more module names, as displayed by the
\fBvlog/list\fR command.  Specifying either no module names at all or
the keyword \fBany\fR disables rate limits for every log module.
.
.IP
The \fBvlog/enable\-rate\-limit\fR command, whose syntax is the same
as \fBvlog/disable\-rate\-limit\fR, can be used to re-enable a rate
limit that was previously disabled.
