/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.ErrorMessages;
import JFlex.MacroException;
import JFlex.RegExp;
import JFlex.RegExp1;
import JFlex.RegExp2;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Macros {
    private Hashtable macros = new Hashtable();
    private Hashtable used = new Hashtable();

    public boolean insert(String name, RegExp definition) {
        this.used.put(name, Boolean.FALSE);
        return this.macros.put(name, definition) == null;
    }

    public boolean markUsed(String name) {
        return this.used.put(name, Boolean.TRUE) != null;
    }

    public boolean isUsed(String name) {
        return (Boolean)this.used.get(name);
    }

    public Enumeration unused() {
        Vector<String> unUsed = new Vector<String>();
        Enumeration names = this.used.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Boolean isUsed = (Boolean)this.used.get(name);
            if (isUsed.booleanValue()) continue;
            unUsed.addElement(name);
        }
        return unUsed.elements();
    }

    public RegExp getDefinition(String name) {
        return (RegExp)this.macros.get(name);
    }

    public void expand() throws MacroException {
        Enumeration names = this.macros.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!this.isUsed(name)) continue;
            this.macros.put(name, this.expandMacro(name, this.getDefinition(name)));
        }
    }

    private RegExp expandMacro(String name, RegExp definition) throws MacroException {
        switch (definition.type) {
            case 35: 
            case 45: {
                RegExp2 binary = (RegExp2)definition;
                binary.r1 = this.expandMacro(name, binary.r1);
                binary.r2 = this.expandMacro(name, binary.r2);
                return definition;
            }
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: {
                RegExp1 unary = (RegExp1)definition;
                unary.content = this.expandMacro(name, (RegExp)unary.content);
                return definition;
            }
            case 42: {
                String usename = (String)((RegExp1)definition).content;
                if (name.equals(usename)) {
                    throw new MacroException(ErrorMessages.get(ErrorMessages.MACRO_CYCLE, name));
                }
                RegExp usedef = this.getDefinition(usename);
                if (usedef == null) {
                    throw new MacroException(ErrorMessages.get(ErrorMessages.MACRO_DEF_MISSING, usename, name));
                }
                this.markUsed(usename);
                return this.expandMacro(name, usedef);
            }
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: {
                return definition;
            }
        }
        throw new MacroException("unknown expression type " + definition.type + " in macro expansion");
    }
}

