/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2007-2008  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_SESSION_H_
#define _SML_SESSION_H_

typedef enum SmlSessionType {
	SML_SESSION_TYPE_SERVER,
	SML_SESSION_TYPE_CLIENT
} SmlSessionType;

typedef enum SmlSessionEventType {
	SML_SESSION_EVENT_ERROR,
	SML_SESSION_EVENT_COMMAND_START,
	SML_SESSION_EVENT_CHILD_COMMAND,
	SML_SESSION_EVENT_HEADER_REPLY,
	SML_SESSION_EVENT_FINAL,
	SML_SESSION_EVENT_END,
	SML_SESSION_EVENT_FLUSH,
	SML_SESSION_EVENT_COMMAND_END,
	SML_SESSION_EVENT_RESPONSE_URI,
	SML_SESSION_EVENT_ESTABLISHED,
} SmlSessionEventType;

typedef void (* SmlSessionEventCallback) (SmlSession *session, SmlSessionEventType type, SmlCommand *command, SmlCommand *parent, SmlStatus *reply, SmlError *error, void *userdata);
typedef void (* SmlSessionDataCallback) (SmlSession *session, SmlTransportData *data, void *userdata);

/* Session Management */
SmlSession *smlSessionNew(SmlSessionType sessionType, SmlMimeType mimetype, SmlProtocolVersion version, SmlProtocolType protocol, SmlLocation *target, SmlLocation *source, const char *sessionID, unsigned int messageID, SmlError **error);
SmlSession *smlSessionRef(SmlSession *session);
void smlSessionUnref(SmlSession *session);
void smlSessionSetEventCallback(SmlSession *session, SmlSessionEventCallback callback, void *userdata);
void smlSessionSetDataCallback(SmlSession *session, SmlSessionDataCallback callback, void *userdata);

/* Session Control */
SmlBool smlSessionFlush(SmlSession *session, SmlBool final, SmlError **error);
SmlBool smlSessionEnd(SmlSession *session, SmlError **error);
void smlSessionUseStringTable(SmlSession *session, SmlBool useStringtable);
void smlSessionUseOnlyReplace(SmlSession *session, SmlBool onlyReplace);
void smlSessionUseNumberOfChanges(SmlSession *session, SmlBool support);
void smlSessionUseLargeObjects(SmlSession *session, SmlBool support);

void smlSessionSetRemoteMaxMsgSize(SmlSession *session, unsigned int size);
void smlSessionSetLocalMaxMsgSize(SmlSession *session, unsigned int size);
unsigned int smlSessionGetRemoteMaxMsgSize(SmlSession *session);
unsigned int smlSessionGetLocalMaxMsgSize(SmlSession *session);

void smlSessionSetLocalMaxObjSize(SmlSession *session, unsigned int limit);
void smlSessionSetRemoteMaxObjSize(SmlSession *session, unsigned int limit);
unsigned int smlSessionGetLocalMaxObjSize(SmlSession *session);
unsigned int smlSessionGetRemoteMaxObjSize(SmlSession *session);

const char *smlSessionGetSessionID(SmlSession *session);
void smlSessionSetSessionID(SmlSession *session, const char *sessionID);
SmlProtocolVersion smlSessionGetVersion(SmlSession *session);
void smlSessionDispatchEvent(SmlSession *session, SmlSessionEventType type, SmlCommand *cmd, SmlCommand *parent, SmlStatus *headerreply, SmlError *error);
SmlLocation *smlSessionGetSource(SmlSession *session);
SmlLocation *smlSessionGetTarget(SmlSession *session);
/* This function MUST NOT be used for servers.
 * This function is only used to set the credentials for a client.
 */
void smlSessionRegisterCred(SmlSession *session, SmlCred *cred);

/* Session Data input */
SmlBool smlSessionReceiveHeader(SmlSession *session, SmlHeader *header, SmlError **error);
SmlBool smlSessionReceiveBody(SmlSession *session, SmlParser *parser, SmlError **error);

/* Session Command input */
SmlBool smlSessionSendCommand(SmlSession *session, SmlCommand *cmd, SmlCommand *parent, SmlStatusReplyCb callback, void *userdata, SmlError **error);
SmlBool smlSessionStartCommand(SmlSession *session, SmlCommand *cmd, SmlCommand *parent, SmlStatusReplyCb callback, void *userdata, SmlError **error);
SmlBool smlSessionEndCommand(SmlSession *session, SmlCommand *parent, SmlError **error);
SmlBool smlSessionSendReply(SmlSession *session, SmlStatus *status, SmlError **error);

SmlBool smlSessionCheck(SmlSession *session);
void smlSessionDispatch(SmlSession *session);

/* expire date: 20090120 */
void smlSessionSetSendingLimit(SmlSession *session, unsigned int limit) LIBSYNCML_DEPRECATED;
void smlSessionSetReceivingLimit(SmlSession *session, unsigned int limit) LIBSYNCML_DEPRECATED;
unsigned int smlSessionGetSendingLimit(SmlSession *session) LIBSYNCML_DEPRECATED;

/* expire date: 20090626 */
void smlSessionSetSendingMaxMsgSize(SmlSession *session, unsigned int size) LIBSYNCML_DEPRECATED;
void smlSessionSetReceivingMaxMsgSize(SmlSession *session, unsigned int size) LIBSYNCML_DEPRECATED;
unsigned int smlSessionGetSendingMaxMsgSize(SmlSession *session) LIBSYNCML_DEPRECATED;

/* expire date: 20090626 */
void smlSessionSetSendingMaxObjSize(SmlSession *session, int limit) LIBSYNCML_DEPRECATED;
void smlSessionSetRequestedMaxObjSize(SmlSession *session, int limit) LIBSYNCML_DEPRECATED;
int smlSessionGetSendingMaxObjSize(SmlSession *session) LIBSYNCML_DEPRECATED;
void smlSessionSetReceivingMaxObjSize(SmlSession *session, unsigned int limit) LIBSYNCML_DEPRECATED;
unsigned int smlSessionGetReceivingMaxObjSize(SmlSession *session) LIBSYNCML_DEPRECATED;

#endif //_SML_SESSION_H_
