/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

public class CalendarDate {
    public static final int UNKNOWN = Integer.MIN_VALUE;
    private int year;
    private int month;
    private int mday;
    private int dow = Integer.MIN_VALUE;
    private int millis;

    public CalendarDate() {
    }

    public CalendarDate(int n, int n2, int n3) {
        this.year = n;
        this.month = n2;
        this.mday = n3;
    }

    public void setYear(int n) {
        this.year = n;
    }

    public int getYear() {
        return this.year;
    }

    public void setMonth(int n) {
        this.month = n;
    }

    public int getMonth() {
        return this.month;
    }

    public void setDate(int n) {
        this.mday = n;
    }

    public int getDate() {
        return this.mday;
    }

    public void setDayOfWeek(int n) {
        this.dow = n;
    }

    public int getDayOfWeek() {
        return this.dow;
    }

    public void setTimeOfDay(int n) {
        this.millis = n;
    }

    public int getTimeOfDay() {
        return this.millis;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CalendarDate)) {
            return false;
        }
        CalendarDate calendarDate = (CalendarDate)object;
        return this.year == calendarDate.year && this.month == calendarDate.month && this.mday == calendarDate.mday && this.millis == calendarDate.millis;
    }

    public int hashCode() {
        return this.year << 20 | this.month << 16 | this.mday << 11 | this.millis >> 10 & 0x3FF;
    }

    public String toString() {
        String string;
        String string2;
        int n = this.millis / 3600000;
        int n2 = this.millis % 3600000;
        int n3 = n2 / 60000;
        if ((n2 %= 60000) == 0) {
            string2 = "";
            string = "";
        } else {
            string2 = ":" + CalendarDate.sprintf02d(n2 / 1000);
            if ((n2 %= 1000) == 0) {
                string = "";
            } else {
                string = ".";
                if (n2 < 100) {
                    string = string + "0";
                }
                string = string + CalendarDate.sprintf02d(n2);
            }
        }
        return this.year + "/" + CalendarDate.sprintf02d(this.month + 1) + "/" + CalendarDate.sprintf02d(this.mday) + " " + CalendarDate.sprintf02d(n) + ":" + CalendarDate.sprintf02d(n3) + string2 + string;
    }

    private static final String sprintf02d(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toString(n));
        return stringBuffer.toString();
    }
}

