package org.jboss.cache.util;

import org.testng.annotations.Test;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

@Test(groups = "unit")
public class ImmutableListCopyTest
{
   public void testImmutability()
   {
      List<String> l = new ImmutableListCopy<String>(Collections.singletonList("one"));
      try
      {
         l.add("two");
         assert false;
      }
      catch (UnsupportedOperationException good)
      {

      }

      try
      {
         l.remove(0);
         assert false;
      }
      catch (UnsupportedOperationException good)
      {

      }

      try
      {
         l.clear();
         assert false;
      }
      catch (UnsupportedOperationException good)
      {

      }

      try
      {
         l.add(0, "x");
         assert false;
      }
      catch (UnsupportedOperationException good)
      {

      }

      try
      {
         l.set(0, "i");
         assert false;
      }
      catch (UnsupportedOperationException good)
      {

      }

      try
      {
         l.addAll(Collections.singletonList("l"));
         assert false;
      }
      catch (UnsupportedOperationException good)
      {

      }

      try
      {
         l.addAll(0, Collections.singletonList("l"));
         assert false;
      }
      catch (UnsupportedOperationException good)
      {

      }

      try
      {
         l.removeAll(Collections.singletonList("l"));
         assert false;
      }
      catch (UnsupportedOperationException good)
      {

      }

      try
      {
         l.retainAll(Collections.singletonList("l"));
         assert false;
      }
      catch (UnsupportedOperationException good)
      {

      }

      try
      {
         l.iterator().remove();
         assert false;
      }
      catch (UnsupportedOperationException good)
      {

      }

      try
      {
         l.listIterator().set("w");
         assert false;
      }
      catch (UnsupportedOperationException good)
      {

      }
   }

   public void testListIterator()
   {
      List<Integer> ints = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);

      List<Integer> list = new ImmutableListCopy<Integer>(ints);

      ListIterator<Integer> li = list.listIterator();

      int number = 1;
      while (li.hasNext()) assert li.next() == number++;
      assert number == 11;

      number = 10;
      li = list.listIterator(list.size());
      while (li.hasPrevious()) assert li.previous() == number--;
      assert number == 0;
   }
}
