package org.jboss.cache.notifications.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation should be used on methods that need to be notified when a node is activated.
 * <p/>
 * Methods annotated with this annotation should be public and take in a single parameter, a {@link org.jboss.cache.notifications.event.NodeActivatedEvent}
 * otherwise an {@link org.jboss.cache.notifications.IncorrectCacheListenerException} will be thrown when registering
 * your cache listener.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @see CacheListener
 * @see org.jboss.cache.notifications.annotation.NodePassivated
 * @since 2.0.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface NodeActivated
{
}
