/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc.example;

import java.sql.SQLException;

/**
 * This interface is used for provisioning names in a database.
 */
public class SqlProvisioningClient 
	implements ProvisioningInterface
{
	/**
	 * Construct a new SqlProvisioningClient.
	 */
	public SqlProvisioningClient() {
	}

	public ProvIterator addSubscribers(ProvIterator i)
		throws ProvException
	{
		java.util.Stack v = new java.util.Stack();
		while (i.hasNext()) {
			Subscriber s = (Subscriber)i.next();
			String sql = "insert into subscribers values (name, password)";
			try {
				execute(sql);
			} catch (SQLException se) {
				v.push(new ProvResult("" + se, s));	
			}
			if (v.size() > 100) {
				v.push(new ProvResult("*** TOO MANY ERRORS, ABORT ***", s));	
				break;
			}
		}
		return new IteratorAdapter(v.iterator());
	}

	void execute(String sql) 
		throws SQLException
	{
		throw new SQLException("not done yet");	
	}

	public ProvIterator deleteSubscribers(ProvIterator i)
		throws ProvException
	{
		java.util.Stack v = new java.util.Stack();
		while (i.hasNext()) {
			Subscriber s = (Subscriber)i.next();
			String sql = "delete from subscribers where name = " + s.getName();
			try {
				execute(sql);
			} catch (SQLException se) {
				v.push(new ProvResult("" + se, s));	
			}
			if (v.size() > 100) {
				v.push(new ProvResult("*** TOO MANY ERRORS, ABORT ***", s));	
				break;
			}
		}
		return new IteratorAdapter(v.iterator());
	}

	public ProvIterator findSubscribers(SubscriberSearch nameLike)
		throws ProvException
	{
		// String sql = "select * from subscribers where name like " + nameLike;
		// kind of fancy here
		throw new ProvException("Not done yet");
	}
}
