/**
 * -----------------------------------------------------------------------
 * Generated by build-library.php, Please DO NOT modify!
  +----------------------------------------------------------------------+
  | Swoole                                                               |
  +----------------------------------------------------------------------+
  | This source file is subject to version 2.0 of the Apache license,    |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.apache.org/licenses/LICENSE-2.0.html                      |
  | If you did not receive a copy of the Apache2.0 license and are unable|
  | to obtain it through the world-wide-web, please send a note to       |
  | license@swoole.com so we can mail you a copy immediately.            |
  +----------------------------------------------------------------------+
 */

/* $Id: 59666fa435d463ccd47641c5bff7c4dd684c0bc6 */

#ifndef SWOOLE_LIBRARY_H
#define SWOOLE_LIBRARY_H

#if PHP_VERSION_ID < 80000
typedef zval zend_source_string_t;
#else
typedef zend_string zend_source_string_t;
#endif

#if PHP_VERSION_ID < 80200
#define ZEND_COMPILE_POSITION_DC
#define ZEND_COMPILE_POSITION_RELAY_C
#else
#define ZEND_COMPILE_POSITION_DC , zend_compile_position position
#define ZEND_COMPILE_POSITION_RELAY_C , position
#endif

#if PHP_VERSION_ID < 80000
#define ZEND_STR_CONST
#else
#define ZEND_STR_CONST const
#endif


static zend_op_array *(*old_compile_string)(zend_source_string_t *source_string, ZEND_STR_CONST char *filename ZEND_COMPILE_POSITION_DC);

static inline zend_op_array *_compile_string(zend_source_string_t *source_string, ZEND_STR_CONST char *filename ZEND_COMPILE_POSITION_DC) {
    if (UNEXPECTED(EG(exception))) {
        zend_exception_error(EG(exception), E_ERROR);
        return NULL;
    }
    zend_op_array *opa = old_compile_string(source_string, filename ZEND_COMPILE_POSITION_RELAY_C);
    opa->type = ZEND_USER_FUNCTION;
    return opa;
}

static inline zend_bool _eval(const char *code, const char *filename) {
    if (!old_compile_string) {
        old_compile_string = zend_compile_string;
    }
    // overwrite
    zend_compile_string = _compile_string;
    int ret = (zend_eval_stringl((char *) code, strlen(code), NULL, (char *) filename) == SUCCESS);
    // recover
    zend_compile_string = old_compile_string;
    return ret;
}

#endif

static const char* swoole_library_source_constants =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "define('SWOOLE_LIBRARY', true);\n"
    "\n"
    "!defined('CURLOPT_HEADEROPT') && define('CURLOPT_HEADEROPT', 229);\n"
    "!defined('CURLOPT_PROXYHEADER') && define('CURLOPT_PROXYHEADER', 10228);\n"
    "!defined('CURLOPT_RESOLVE') && define('CURLOPT_RESOLVE', 10203);\n"
    "!defined('CURLOPT_UNIX_SOCKET_PATH') && define('CURLOPT_UNIX_SOCKET_PATH', 10231);\n";

static const char* swoole_library_source_std_exec =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "use Swoole\\Coroutine\\System;\n"
    "\n"
    "function swoole_exec(string $command, &$output = null, &$returnVar = null)\n"
    "{\n"
    "    $result = System::exec($command);\n"
    "    if ($result) {\n"
    "        $outputList = explode(PHP_EOL, $result['output']);\n"
    "        foreach ($outputList as &$value) {\n"
    "            $value = rtrim($value);\n"
    "        }\n"
    "        if (($endLine = end($outputList)) === '') {\n"
    "            array_pop($outputList);\n"
    "            $endLine = end($outputList);\n"
    "        }\n"
    "        if ($output) {\n"
    "            $output = array_merge($output, $outputList);\n"
    "        } else {\n"
    "            $output = $outputList;\n"
    "        }\n"
    "        $returnVar = $result['code'];\n"
    "        return $endLine;\n"
    "    }\n"
    "    return false;\n"
    "}\n"
    "\n"
    "function swoole_shell_exec(string $cmd)\n"
    "{\n"
    "    $result = System::exec($cmd);\n"
    "    if ($result && $result['output'] !== '') {\n"
    "        return $result['output'];\n"
    "    }\n"
    "    return null;\n"
    "}\n";

static const char* swoole_library_source_core_constant =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "class Constant\n"
    "{\n"
    "    /* {{{ EVENT */\n"
    "    public const EVENT_START = 'start';\n"
    "\n"
    "    public const EVENT_BEFORE_SHUTDOWN = 'beforeShutdown';\n"
    "\n"
    "    public const EVENT_SHUTDOWN = 'shutdown';\n"
    "\n"
    "    public const EVENT_WORKER_START = 'workerStart';\n"
    "\n"
    "    public const EVENT_WORKER_STOP = 'workerStop';\n"
    "\n"
    "    public const EVENT_BEFORE_RELOAD = 'beforeReload';\n"
    "\n"
    "    public const EVENT_AFTER_RELOAD = 'afterReload';\n"
    "\n"
    "    public const EVENT_TASK = 'task';\n"
    "\n"
    "    public const EVENT_FINISH = 'finish';\n"
    "\n"
    "    public const EVENT_WORKER_EXIT = 'workerExit';\n"
    "\n"
    "    public const EVENT_WORKER_ERROR = 'workerError';\n"
    "\n"
    "    public const EVENT_MANAGER_START = 'managerStart';\n"
    "\n"
    "    public const EVENT_MANAGER_STOP = 'managerStop';\n"
    "\n"
    "    public const EVENT_PIPE_MESSAGE = 'pipeMessage';\n"
    "\n"
    "    public const EVENT_CONNECT = 'connect';\n"
    "\n"
    "    public const EVENT_RECEIVE = 'receive';\n"
    "\n"
    "    public const EVENT_CLOSE = 'close';\n"
    "\n"
    "    public const EVENT_PACKET = 'packet';\n"
    "\n"
    "    public const EVENT_BUFFER_FULL = 'bufferFull';\n"
    "\n"
    "    public const EVENT_BUFFER_EMPTY = 'bufferEmpty';\n"
    "\n"
    "    public const EVENT_REQUEST = 'request';\n"
    "\n"
    "    public const EVENT_HANDSHAKE = 'handshake';\n"
    "\n"
    "    public const EVENT_BEFORE_HANDSHAKE_RESPONSE = 'beforeHandshakeResponse';\n"
    "\n"
    "    public const EVENT_OPEN = 'open';\n"
    "\n"
    "    public const EVENT_MESSAGE = 'message';\n"
    "\n"
    "    public const EVENT_DISCONNECT = 'disconnect';\n"
    "\n"
    "    /* }}} EVENT */\n"
    "\n"
    "    public const EVENT_ERROR = 'error';\n"
    "\n"
    "    /* {{{ OPTION */\n"
    "    public const OPTION_DEBUG_MODE = 'debug_mode';\n"
    "\n"
    "    public const OPTION_TRACE_FLAGS = 'trace_flags';\n"
    "\n"
    "    public const OPTION_LOG_FILE = 'log_file';\n"
    "\n"
    "    public const OPTION_LOG_LEVEL = 'log_level';\n"
    "\n"
    "    public const OPTION_LOG_DATE_FORMAT = 'log_date_format';\n"
    "\n"
    "    public const OPTION_LOG_DATE_WITH_MICROSECONDS = 'log_date_with_microseconds';\n"
    "\n"
    "    public const OPTION_LOG_ROTATION = 'log_rotation';\n"
    "\n"
    "    public const OPTION_DISPLAY_ERRORS = 'display_errors';\n"
    "\n"
    "    public const OPTION_DNS_SERVER = 'dns_server';\n"
    "\n"
    "    /**\n"
    "     * Socket DNS timeout in seconds.\n"
    "     */\n"
    "    public const OPTION_SOCKET_DNS_TIMEOUT = 'socket_dns_timeout';\n"
    "\n"
    "    /**\n"
    "     * Default socket connect timeout in seconds.\n"
    "     */\n"
    "    public const OPTION_SOCKET_CONNECT_TIMEOUT = 'socket_connect_timeout';\n"
    "\n"
    "    /**\n"
    "     * Default socket write timeout in seconds.\n"
    "     *\n"
    "     * This one works the same as option \"socket_send_timeout\", but has higher priority.\n"
    "     *\n"
    "     * @see \\Swoole\\Constant::OPTION_SOCKET_SEND_TIMEOUT\n"
    "     */\n"
    "    public const OPTION_SOCKET_WRITE_TIMEOUT = 'socket_write_timeout';\n"
    "\n"
    "    /**\n"
    "     * Default socket write timeout in seconds.\n"
    "     *\n"
    "     * This one works the same as option \"socket_write_timeout\", but has lower priority.\n"
    "     *\n"
    "     * @see \\Swoole\\Constant::OPTION_SOCKET_WRITE_TIMEOUT\n"
    "     */\n"
    "    public const OPTION_SOCKET_SEND_TIMEOUT = 'socket_send_timeout';\n"
    "\n"
    "    /**\n"
    "     * Default socket read timeout in seconds.\n"
    "     *\n"
    "     * This one works the same as option \"socket_recv_timeout\", but has higher priority.\n"
    "     *\n"
    "     * @see \\Swoole\\Constant::OPTION_SOCKET_RECV_TIMEOUT\n"
    "     */\n"
    "    public const OPTION_SOCKET_READ_TIMEOUT = 'socket_read_timeout';\n"
    "\n"
    "    /**\n"
    "     * Default socket read timeout in seconds.\n"
    "     *\n"
    "     * This one works the same as option \"socket_read_timeout\", but has lower priority.\n"
    "     *\n"
    "     * @see \\Swoole\\Constant::OPTION_SOCKET_READ_TIMEOUT\n"
    "     */\n"
    "    public const OPTION_SOCKET_RECV_TIMEOUT = 'socket_recv_timeout';\n"
    "\n"
    "    /**\n"
    "     * Default socket read/write timeout in seconds.\n"
    "     *\n"
    "     * This one has the highest priority than the other read/write timeout options:\n"
    "     * - \\Swoole\\Constant::OPTION_SOCKET_WRITE_TIMEOUT\n"
    "     * - \\Swoole\\Constant::OPTION_SOCKET_SEND_TIMEOUT\n"
    "     * - \\Swoole\\Constant::OPTION_SOCKET_READ_TIMEOUT\n"
    "     * - \\Swoole\\Constant::OPTION_SOCKET_RECV_TIMEOUT\n"
    "     *\n"
    "     * @see \\Swoole\\Constant::OPTION_SOCKET_SEND_TIMEOUT\n"
    "     * @see \\Swoole\\Constant::OPTION_SOCKET_WRITE_TIMEOUT\n"
    "     * @see \\Swoole\\Constant::OPTION_SOCKET_RECV_TIMEOUT\n"
    "     * @see \\Swoole\\Constant::OPTION_SOCKET_READ_TIMEOUT\n"
    "     */\n"
    "    public const OPTION_SOCKET_TIMEOUT = 'socket_timeout';\n"
    "\n"
    "    public const OPTION_SOCKET_BUFFER_SIZE = 'socket_buffer_size';\n"
    "\n"
    "    public const OPTION_HTTP2_HEADER_TABLE_SIZE = 'http2_header_table_size';\n"
    "\n"
    "    public const OPTION_HTTP2_ENABLE_PUSH = 'http2_enable_push';\n"
    "\n"
    "    public const OPTION_HTTP2_MAX_CONCURRENT_STREAMS = 'http2_max_concurrent_streams';\n"
    "\n"
    "    public const OPTION_HTTP2_INIT_WINDOW_SIZE = 'http2_init_window_size';\n"
    "\n"
    "    public const OPTION_HTTP2_MAX_FRAME_SIZE = 'http2_max_frame_size';\n"
    "\n"
    "    public const OPTION_HTTP2_MAX_HEADER_LIST_SIZE = 'http2_max_header_list_size';\n"
    "\n"
    "    public const OPTION_AIO_CORE_WORKER_NUM = 'aio_core_worker_num';\n"
    "\n"
    "    public const OPTION_AIO_WORKER_NUM = 'aio_worker_num';\n"
    "\n"
    "    public const OPTION_AIO_MAX_WAIT_TIME = 'aio_max_wait_time';\n"
    "\n"
    "    public const OPTION_AIO_MAX_IDLE_TIME = 'aio_max_idle_time';\n"
    "\n"
    "    /**\n"
    "     * @since 6.0.0-beta\n"
    "     */\n"
    "    public const OPTION_IOURING_ENTRIES = 'iouring_entries';\n"
    "\n"
    "    /**\n"
    "     * @since 6.0.0-rc1\n"
    "     */\n"
    "    public const OPTION_IOURING_WORKERS = 'iouring_workers';\n"
    "\n"
    "    /**\n"
    "     * @since 6.0.0-rc1\n"
    "     */\n"
    "    public const OPTION_IOURING_FLAG = 'iouring_flag';\n"
    "\n"
    "    public const OPTION_ENABLE_SIGNALFD = 'enable_signalfd';\n"
    "\n"
    "    public const OPTION_WAIT_SIGNAL = 'wait_signal';\n"
    "\n"
    "    public const OPTION_DNS_CACHE_REFRESH_TIME = 'dns_cache_refresh_time';\n"
    "\n"
    "    public const OPTION_THREAD_NUM = 'thread_num';\n"
    "\n"
    "    public const OPTION_MIN_THREAD_NUM = 'min_thread_num';\n"
    "\n"
    "    public const OPTION_MAX_THREAD_NUM = 'max_thread_num';\n"
    "\n"
    "    public const OPTION_SOCKET_DONTWAIT = 'socket_dontwait';\n"
    "\n"
    "    public const OPTION_DNS_LOOKUP_RANDOM = 'dns_lookup_random';\n"
    "\n"
    "    public const OPTION_USE_ASYNC_RESOLVER = 'use_async_resolver';\n"
    "\n"
    "    public const OPTION_ENABLE_COROUTINE = 'enable_coroutine';\n"
    "\n"
    "    public const OPTION_SSL_PROTOCOLS = 'ssl_protocols';\n"
    "\n"
    "    public const OPTION_SSL_COMPRESS = 'ssl_compress';\n"
    "\n"
    "    public const OPTION_SSL_CERT_FILE = 'ssl_cert_file';\n"
    "\n"
    "    public const OPTION_SSL_KEY_FILE = 'ssl_key_file';\n"
    "\n"
    "    public const OPTION_SSL_PASSPHRASE = 'ssl_passphrase';\n"
    "\n"
    "    public const OPTION_SSL_HOST_NAME = 'ssl_host_name';\n"
    "\n"
    "    public const OPTION_SSL_VERIFY_PEER = 'ssl_verify_peer';\n"
    "\n"
    "    public const OPTION_SSL_ALLOW_SELF_SIGNED = 'ssl_allow_self_signed';\n"
    "\n"
    "    public const OPTION_SSL_CAFILE = 'ssl_cafile';\n"
    "\n"
    "    public const OPTION_SSL_CAPATH = 'ssl_capath';\n"
    "\n"
    "    public const OPTION_SSL_VERIFY_DEPTH = 'ssl_verify_depth';\n"
    "\n"
    "    public const OPTION_SSL_CIPHERS = 'ssl_ciphers';\n"
    "\n"
    "    public const OPTION_OPEN_EOF_CHECK = 'open_eof_check';\n"
    "\n"
    "    public const OPTION_OPEN_EOF_SPLIT = 'open_eof_split';\n"
    "\n"
    "    public const OPTION_PACKAGE_EOF = 'package_eof';\n"
    "\n"
    "    public const OPTION_OPEN_MQTT_PROTOCOL = 'open_mqtt_protocol';\n"
    "\n"
    "    public const OPTION_OPEN_LENGTH_CHECK = 'open_length_check';\n"
    "\n"
    "    public const OPTION_PACKAGE_LENGTH_TYPE = 'package_length_type';\n"
    "\n"
    "    public const OPTION_PACKAGE_LENGTH_OFFSET = 'package_length_offset';\n"
    "\n"
    "    public const OPTION_PACKAGE_BODY_OFFSET = 'package_body_offset';\n"
    "\n"
    "    public const OPTION_PACKAGE_LENGTH_FUNC = 'package_length_func';\n"
    "\n"
    "    public const OPTION_PACKAGE_MAX_LENGTH = 'package_max_length';\n"
    "\n"
    "    public const OPTION_BUFFER_HIGH_WATERMARK = 'buffer_high_watermark';\n"
    "\n"
    "    public const OPTION_BUFFER_LOW_WATERMARK = 'buffer_low_watermark';\n"
    "\n"
    "    public const OPTION_BIND_PORT = 'bind_port';\n"
    "\n"
    "    public const OPTION_BIND_ADDRESS = 'bind_address';\n"
    "\n"
    "    public const OPTION_OPEN_TCP_NODELAY = 'open_tcp_nodelay';\n"
    "\n"
    "    public const OPTION_SOCKS5_HOST = 'socks5_host';\n"
    "\n"
    "    public const OPTION_SOCKS5_PORT = 'socks5_port';\n"
    "\n"
    "    public const OPTION_SOCKS5_USERNAME = 'socks5_username';\n"
    "\n"
    "    public const OPTION_SOCKS5_PASSWORD = 'socks5_password';\n"
    "\n"
    "    public const OPTION_HTTP_PROXY_HOST = 'http_proxy_host';\n"
    "\n"
    "    public const OPTION_HTTP_PROXY_PORT = 'http_proxy_port';\n"
    "\n"
    "    public const OPTION_HTTP_PROXY_USERNAME = 'http_proxy_username';\n"
    "\n"
    "    public const OPTION_HTTP_PROXY_USER = 'http_proxy_user';\n"
    "\n"
    "    public const OPTION_HTTP_PROXY_PASSWORD = 'http_proxy_password';\n"
    "\n"
    "    public const OPTION_MAX_CORO_NUM = 'max_coro_num';\n"
    "\n"
    "    public const OPTION_MAX_COROUTINE = 'max_coroutine';\n"
    "\n"
    "    public const OPTION_ENABLE_DEADLOCK_CHECK = 'enable_deadlock_check';\n"
    "\n"
    "    public const OPTION_HOOK_FLAGS = 'hook_flags';\n"
    "\n"
    "    public const OPTION_ENABLE_PREEMPTIVE_SCHEDULER = 'enable_preemptive_scheduler';\n"
    "\n"
    "    public const OPTION_C_STACK_SIZE = 'c_stack_size';\n"
    "\n"
    "    public const OPTION_STACK_SIZE = 'stack_size';\n"
    "\n"
    "    public const OPTION_NAME_RESOLVER = 'name_resolver';\n"
    "\n"
    "    public const OPTION_DNS_CACHE_EXPIRE = 'dns_cache_expire';\n"
    "\n"
    "    public const OPTION_DNS_CACHE_CAPACITY = 'dns_cache_capacity';\n"
    "\n"
    "    public const OPTION_CONNECT_TIMEOUT = 'connect_timeout';\n"
    "\n"
    "    public const OPTION_TIMEOUT = 'timeout';\n"
    "\n"
    "    public const OPTION_MAX_RETRIES = 'max_retries';\n"
    "\n"
    "    public const OPTION_DEFER = 'defer';\n"
    "\n"
    "    public const OPTION_LOWERCASE_HEADER = 'lowercase_header';\n"
    "\n"
    "    public const OPTION_KEEP_ALIVE = 'keep_alive';\n"
    "\n"
    "    public const OPTION_WEBSOCKET_MASK = 'websocket_mask';\n"
    "\n"
    "    public const OPTION_HTTP_COMPRESSION = 'http_compression';\n"
    "\n"
    "    public const OPTION_BODY_DECOMPRESSION = 'body_decompression';\n"
    "\n"
    "    public const OPTION_WEBSOCKET_COMPRESSION = 'websocket_compression';\n"
    "\n"
    "    public const OPTION_WRITE_FUNC = 'write_func';\n"
    "\n"
    "    public const OPTION_HTTP_PARSE_COOKIE = 'http_parse_cookie';\n"
    "\n"
    "    public const OPTION_HTTP_PARSE_POST = 'http_parse_post';\n"
    "\n"
    "    public const OPTION_HTTP_PARSE_FILES = 'http_parse_files';\n"
    "\n"
    "    public const OPTION_HTTP_COMPRESSION_LEVEL = 'http_compression_level';\n"
    "\n"
    "    public const OPTION_COMPRESSION_LEVEL = 'compression_level';\n"
    "\n"
    "    public const OPTION_HTTP_GZIP_LEVEL = 'http_gzip_level';\n"
    "\n"
    "    public const OPTION_HTTP_COMPRESSION_MIN_LENGTH = 'http_compression_min_length';\n"
    "\n"
    "    public const OPTION_COMPRESSION_MIN_LENGTH = 'compression_min_length';\n"
    "\n"
    "    public const OPTION_HTTP_COMPRESSION_TYPES = 'http_compression_types';\n"
    "\n"
    "    public const OPTION_COMPRESSION_TYPES = 'compression_types';\n"
    "\n"
    "    public const OPTION_UPLOAD_TMP_DIR = 'upload_tmp_dir';\n"
    "\n"
    "    public const OPTION_ENABLE_MESSAGE_BUS = 'enable_message_bus';\n"
    "\n"
    "    public const OPTION_MAX_PACKAGE_SIZE = 'max_package_size';\n"
    "\n"
    "    public const OPTION_SSL = 'ssl';\n"
    "\n"
    "    public const OPTION_CHROOT = 'chroot';\n"
    "\n"
    "    public const OPTION_USER = 'user';\n"
    "\n"
    "    public const OPTION_GROUP = 'group';\n"
    "\n"
    "    public const OPTION_DAEMONIZE = 'daemonize';\n"
    "\n"
    "    public const OPTION_PID_FILE = 'pid_file';\n"
    "\n"
    "    public const OPTION_REACTOR_NUM = 'reactor_num';\n"
    "\n"
    "    public const OPTION_SINGLE_THREAD = 'single_thread';\n"
    "\n"
    "    public const OPTION_WORKER_NUM = 'worker_num';\n"
    "\n"
    "    public const OPTION_MAX_WAIT_TIME = 'max_wait_time';\n"
    "\n"
    "    public const OPTION_MAX_QUEUED_BYTES = 'max_queued_bytes';\n"
    "\n"
    "    public const OPTION_MAX_CONCURRENCY = 'max_concurrency';\n"
    "\n"
    "    public const OPTION_WORKER_MAX_CONCURRENCY = 'worker_max_concurrency';\n"
    "\n"
    "    public const OPTION_SEND_TIMEOUT = 'send_timeout';\n"
    "\n"
    "    public const OPTION_DISPATCH_MODE = 'dispatch_mode';\n"
    "\n"
    "    public const OPTION_SEND_YIELD = 'send_yield';\n"
    "\n"
    "    public const OPTION_DISPATCH_FUNC = 'dispatch_func';\n"
    "\n"
    "    public const OPTION_DISCARD_TIMEOUT_REQUEST = 'discard_timeout_request';\n"
    "\n"
    "    public const OPTION_ENABLE_UNSAFE_EVENT = 'enable_unsafe_event';\n"
    "\n"
    "    public const OPTION_ENABLE_DELAY_RECEIVE = 'enable_delay_receive';\n"
    "\n"
    "    public const OPTION_ENABLE_REUSE_PORT = 'enable_reuse_port';\n"
    "\n"
    "    public const OPTION_TASK_USE_OBJECT = 'task_use_object';\n"
    "\n"
    "    public const OPTION_TASK_OBJECT = 'task_object';\n"
    "\n"
    "    public const OPTION_EVENT_OBJECT = 'event_object';\n"
    "\n"
    "    public const OPTION_TASK_ENABLE_COROUTINE = 'task_enable_coroutine';\n"
    "\n"
    "    public const OPTION_TASK_WORKER_NUM = 'task_worker_num';\n"
    "\n"
    "    public const OPTION_TASK_IPC_MODE = 'task_ipc_mode';\n"
    "\n"
    "    public const OPTION_TASK_TMPDIR = 'task_tmpdir';\n"
    "\n"
    "    public const OPTION_TASK_MAX_REQUEST = 'task_max_request';\n"
    "\n"
    "    public const OPTION_TASK_MAX_REQUEST_GRACE = 'task_max_request_grace';\n"
    "\n"
    "    public const OPTION_MAX_CONNECTION = 'max_connection';\n"
    "\n"
    "    public const OPTION_MAX_CONN = 'max_conn';\n"
    "\n"
    "    public const OPTION_START_SESSION_ID = 'start_session_id';\n"
    "\n"
    "    public const OPTION_HEARTBEAT_CHECK_INTERVAL = 'heartbeat_check_interval';\n"
    "\n"
    "    public const OPTION_HEARTBEAT_IDLE_TIME = 'heartbeat_idle_time';\n"
    "\n"
    "    public const OPTION_MAX_REQUEST = 'max_request';\n"
    "\n"
    "    public const OPTION_MAX_REQUEST_GRACE = 'max_request_grace';\n"
    "\n"
    "    public const OPTION_RELOAD_ASYNC = 'reload_async';\n"
    "\n"
    "    public const OPTION_OPEN_CPU_AFFINITY = 'open_cpu_affinity';\n"
    "\n"
    "    public const OPTION_CPU_AFFINITY_IGNORE = 'cpu_affinity_ignore';\n"
    "\n"
    "    public const OPTION_UPLOAD_MAX_FILESIZE = 'upload_max_filesize';\n"
    "\n"
    "    public const OPTION_ENABLE_STATIC_HANDLER = 'enable_static_handler';\n"
    "\n"
    "    public const OPTION_DOCUMENT_ROOT = 'document_root';\n"
    "\n"
    "    public const OPTION_HTTP_AUTOINDEX = 'http_autoindex';\n"
    "\n"
    "    public const OPTION_HTTP_INDEX_FILES = 'http_index_files';\n"
    "\n"
    "    public const OPTION_STATIC_HANDLER_LOCATIONS = 'static_handler_locations';\n"
    "\n"
    "    public const OPTION_INPUT_BUFFER_SIZE = 'input_buffer_size';\n"
    "\n"
    "    public const OPTION_BUFFER_INPUT_SIZE = 'buffer_input_size';\n"
    "\n"
    "    public const OPTION_OUTPUT_BUFFER_SIZE = 'output_buffer_size';\n"
    "\n"
    "    public const OPTION_BUFFER_OUTPUT_SIZE = 'buffer_output_size';\n"
    "\n"
    "    public const OPTION_MESSAGE_QUEUE_KEY = 'message_queue_key';\n"
    "\n"
    "    /**\n"
    "     * @since 6.0.0-beta\n"
    "     */\n"
    "    public const OPTION_BOOTSTRAP = 'bootstrap';\n"
    "\n"
    "    /**\n"
    "     * @since 6.0.0-beta\n"
    "     */\n"
    "    public const OPTION_INIT_ARGUMENTS = 'init_arguments';\n"
    "\n"
    "    public const OPTION_BACKLOG = 'backlog';\n"
    "\n"
    "    public const OPTION_KERNEL_SOCKET_RECV_BUFFER_SIZE = 'kernel_socket_recv_buffer_size';\n"
    "\n"
    "    public const OPTION_KERNEL_SOCKET_SEND_BUFFER_SIZE = 'kernel_socket_send_buffer_size';\n"
    "\n"
    "    public const OPTION_TCP_DEFER_ACCEPT = 'tcp_defer_accept';\n"
    "\n"
    "    public const OPTION_OPEN_TCP_KEEPALIVE = 'open_tcp_keepalive';\n"
    "\n"
    "    public const OPTION_OPEN_HTTP_PROTOCOL = 'open_http_protocol';\n"
    "\n"
    "    public const OPTION_OPEN_WEBSOCKET_PROTOCOL = 'open_websocket_protocol';\n"
    "\n"
    "    public const OPTION_WEBSOCKET_SUBPROTOCOL = 'websocket_subprotocol';\n"
    "\n"
    "    public const OPTION_OPEN_WEBSOCKET_CLOSE_FRAME = 'open_websocket_close_frame';\n"
    "\n"
    "    public const OPTION_OPEN_WEBSOCKET_PING_FRAME = 'open_websocket_ping_frame';\n"
    "\n"
    "    public const OPTION_OPEN_WEBSOCKET_PONG_FRAME = 'open_websocket_pong_frame';\n"
    "\n"
    "    public const OPTION_OPEN_HTTP2_PROTOCOL = 'open_http2_protocol';\n"
    "\n"
    "    public const OPTION_OPEN_REDIS_PROTOCOL = 'open_redis_protocol';\n"
    "\n"
    "    public const OPTION_MAX_IDLE_TIME = 'max_idle_time';\n"
    "\n"
    "    public const OPTION_TCP_KEEPIDLE = 'tcp_keepidle';\n"
    "\n"
    "    public const OPTION_TCP_KEEPINTERVAL = 'tcp_keepinterval';\n"
    "\n"
    "    public const OPTION_TCP_KEEPCOUNT = 'tcp_keepcount';\n"
    "\n"
    "    public const OPTION_TCP_USER_TIMEOUT = 'tcp_user_timeout';\n"
    "\n"
    "    public const OPTION_TCP_FASTOPEN = 'tcp_fastopen';\n"
    "\n"
    "    public const OPTION_PACKAGE_BODY_START = 'package_body_start';\n"
    "\n"
    "    public const OPTION_SSL_CLIENT_CERT_FILE = 'ssl_client_cert_file';\n"
    "\n"
    "    public const OPTION_SSL_PREFER_SERVER_CIPHERS = 'ssl_prefer_server_ciphers';\n"
    "\n"
    "    public const OPTION_SSL_ECDH_CURVE = 'ssl_ecdh_curve';\n"
    "\n"
    "    public const OPTION_SSL_DHPARAM = 'ssl_dhparam';\n"
    "\n"
    "    public const OPTION_SSL_SNI_CERTS = 'ssl_sni_certs';\n"
    "\n"
    "    public const OPTION_OPEN_SSL = 'open_ssl';\n"
    "\n"
    "    public const OPTION_OPEN_FASTCGI_PROTOCOL = 'open_fastcgi_protocol';\n"
    "\n"
    "    public const OPTION_READ_TIMEOUT = 'read_timeout';\n"
    "\n"
    "    public const OPTION_WRITE_TIMEOUT = 'write_timeout';\n"
    "\n"
    "    public const OPTION_SSL_DISABLE_COMPRESSION = 'ssl_disable_compression';\n"
    "\n"
    "    public const OPTION_SSL_GREASE = 'ssl_grease';\n"
    "\n"
    "    public const OPTION_EXIT_CONDITION = 'exit_condition';\n"
    "\n"
    "    public const OPTION_DEADLOCK_CHECK_DISABLE_TRACE = 'deadlock_check_disable_trace';\n"
    "\n"
    "    public const OPTION_DEADLOCK_CHECK_LIMIT = 'deadlock_check_limit';\n"
    "\n"
    "    public const OPTION_DEADLOCK_CHECK_DEPTH = 'deadlock_check_depth';\n"
    "\n"
    "    public const OPTION_STATS_FILE = 'stats_file';\n"
    "\n"
    "    public const OPTION_STATS_TIMER_INTERVAL = 'stats_timer_interval';\n"
    "\n"
    "    public const OPTION_ADMIN_SERVER = 'admin_server';\n"
    "\n"
    "    /* }}} OPTION */\n"
    "\n"
    "    public const OPTION_HTTP_CLIENT_DRIVER = 'http_client_driver';\n"
    "}\n";

static const char* swoole_library_source_core_string_object =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "class StringObject implements \\Stringable\n"
    "{\n"
    "    /**\n"
    "     * StringObject constructor.\n"
    "     */\n"
    "    public function __construct(protected string $string = '')\n"
    "    {\n"
    "    }\n"
    "\n"
    "    public function __toString(): string\n"
    "    {\n"
    "        return $this->string;\n"
    "    }\n"
    "\n"
    "    public static function from(string $string = ''): static\n"
    "    {\n"
    "        return new static($string); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    public function length(): int\n"
    "    {\n"
    "        return strlen($this->string);\n"
    "    }\n"
    "\n"
    "    public function indexOf(string $needle, int $offset = 0): false|int\n"
    "    {\n"
    "        return strpos($this->string, $needle, $offset);\n"
    "    }\n"
    "\n"
    "    public function lastIndexOf(string $needle, int $offset = 0): false|int\n"
    "    {\n"
    "        return strrpos($this->string, $needle, $offset);\n"
    "    }\n"
    "\n"
    "    public function pos(string $needle, int $offset = 0): false|int\n"
    "    {\n"
    "        return strpos($this->string, $needle, $offset);\n"
    "    }\n"
    "\n"
    "    public function rpos(string $needle, int $offset = 0): false|int\n"
    "    {\n"
    "        return strrpos($this->string, $needle, $offset);\n"
    "    }\n"
    "\n"
    "    public function reverse(): static\n"
    "    {\n"
    "        return new static(strrev($this->string)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function ipos(string $needle)\n"
    "    {\n"
    "        return stripos($this->string, $needle);\n"
    "    }\n"
    "\n"
    "    public function lower(): static\n"
    "    {\n"
    "        return new static(strtolower($this->string)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    public function upper(): static\n"
    "    {\n"
    "        return new static(strtoupper($this->string)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    public function trim(string $characters = ''): static\n"
    "    {\n"
    "        if ($characters) {\n"
    "            return new static(trim($this->string, $characters)); // @phpstan-ignore new.static\n"
    "        }\n"
    "        return new static(trim($this->string)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function ltrim(): self\n"
    "    {\n"
    "        return new static(ltrim($this->string)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function rtrim(): self\n"
    "    {\n"
    "        return new static(rtrim($this->string)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function substr(int $offset, ?int $length = null)\n"
    "    {\n"
    "        return new static(substr($this->string, $offset, $length)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    public function repeat(int $times): static\n"
    "    {\n"
    "        return new static(str_repeat($this->string, $times)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    public function append(mixed $str): static\n"
    "    {\n"
    "        return new static($this->string .= $str); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param int|null $count\n"
    "     */\n"
    "    public function replace(string $search, string $replace, &$count = null): static\n"
    "    {\n"
    "        return new static(str_replace($search, $replace, $this->string, $count)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    public function startsWith(string $needle): bool\n"
    "    {\n"
    "        return str_starts_with($this->string, $needle);\n"
    "    }\n"
    "\n"
    "    public function endsWith(string $needle): bool\n"
    "    {\n"
    "        return strrpos($this->string, $needle) === (strlen($this->string) - strlen($needle));\n"
    "    }\n"
    "\n"
    "    public function equals($str, bool $strict = false): bool\n"
    "    {\n"
    "        if ($str instanceof StringObject) {\n"
    "            $str = strval($str);\n"
    "        }\n"
    "        if ($strict) {\n"
    "            return $this->string === $str;\n"
    "        }\n"
    "        return $this->string == $str;\n"
    "    }\n"
    "\n"
    "    public function contains(string $subString): bool\n"
    "    {\n"
    "        return str_contains($this->string, $subString);\n"
    "    }\n"
    "\n"
    "    public function split(string $delimiter, int $limit = PHP_INT_MAX): ArrayObject\n"
    "    {\n"
    "        return static::detectArrayType(explode($delimiter, $this->string, $limit));\n"
    "    }\n"
    "\n"
    "    public function char(int $index): string\n"
    "    {\n"
    "        if ($index > strlen($this->string)) {\n"
    "            return '';\n"
    "        }\n"
    "        return $this->string[$index];\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Get a new string object by splitting the string of current object into smaller chunks.\n"
    "     *\n"
    "     * @param int $length The chunk length.\n"
    "     * @param string $separator The line ending sequence.\n"
    "     * @see https://www.php.net/chunk_split\n"
    "     */\n"
    "    public function chunkSplit(int $length = 76, string $separator = \"\\r\\n\"): static\n"
    "    {\n"
    "        return new static(chunk_split($this->string, $length, $separator)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Convert a string to an array object of class \\Swoole\\ArrayObject.\n"
    "     *\n"
    "     * @param int $length Maximum length of the chunk.\n"
    "     * @see https://www.php.net/str_split\n"
    "     */\n"
    "    public function chunk(int $length = 1): ArrayObject\n"
    "    {\n"
    "        return static::detectArrayType(str_split($this->string, $length));\n"
    "    }\n"
    "\n"
    "    public function toString(): string\n"
    "    {\n"
    "        return $this->string;\n"
    "    }\n"
    "\n"
    "    protected static function detectArrayType(array $value): ArrayObject\n"
    "    {\n"
    "        return new ArrayObject($value);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_multibyte_string_object =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "class MultibyteStringObject extends StringObject\n"
    "{\n"
    "    public function length(): int\n"
    "    {\n"
    "        return mb_strlen($this->string);\n"
    "    }\n"
    "\n"
    "    public function indexOf(string $needle, int $offset = 0, ?string $encoding = null): false|int\n"
    "    {\n"
    "        return mb_strpos($this->string, $needle, $offset, $encoding);\n"
    "    }\n"
    "\n"
    "    public function lastIndexOf(string $needle, int $offset = 0, ?string $encoding = null): false|int\n"
    "    {\n"
    "        return mb_strrpos($this->string, $needle, $offset, $encoding);\n"
    "    }\n"
    "\n"
    "    public function pos(string $needle, int $offset = 0, ?string $encoding = null): false|int\n"
    "    {\n"
    "        return mb_strpos($this->string, $needle, $offset, $encoding);\n"
    "    }\n"
    "\n"
    "    public function rpos(string $needle, int $offset = 0, ?string $encoding = null): false|int\n"
    "    {\n"
    "        return mb_strrpos($this->string, $needle, $offset, $encoding);\n"
    "    }\n"
    "\n"
    "    public function ipos(string $needle, int $offset = 0, ?string $encoding = null): int|false\n"
    "    {\n"
    "        return mb_stripos($this->string, $needle, $offset, $encoding);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @see https://www.php.net/mb_substr\n"
    "     */\n"
    "    public function substr(int $start, ?int $length = null, ?string $encoding = null): static\n"
    "    {\n"
    "        return new static(mb_substr($this->string, $start, $length, $encoding)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * {@inheritDoc}\n"
    "     * @see https://www.php.net/mb_str_split\n"
    "     */\n"
    "    public function chunk(int $length = 1): ArrayObject\n"
    "    {\n"
    "        return static::detectArrayType(mb_str_split($this->string, $length));\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_exception_array_key_not_exists =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Exception;\n"
    "\n"
    "class ArrayKeyNotExists extends \\RuntimeException\n"
    "{\n"
    "}\n";

static const char* swoole_library_source_core_array_object =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "use Swoole\\Exception\\ArrayKeyNotExists;\n"
    "\n"
    "class ArrayObject implements \\ArrayAccess, \\Serializable, \\Countable, \\Iterator\n"
    "{\n"
    "    /**\n"
    "     * @var array\n"
    "     */\n"
    "    protected $array;\n"
    "\n"
    "    /**\n"
    "     * ArrayObject constructor.\n"
    "     */\n"
    "    public function __construct(array $array = [])\n"
    "    {\n"
    "        $this->array = $array;\n"
    "    }\n"
    "\n"
    "    public function __toArray(): array\n"
    "    {\n"
    "        return $this->array;\n"
    "    }\n"
    "\n"
    "    public function __serialize(): array\n"
    "    {\n"
    "        return $this->array;\n"
    "    }\n"
    "\n"
    "    public function __unserialize(array $data): void\n"
    "    {\n"
    "        $this->array = $data;\n"
    "    }\n"
    "\n"
    "    public static function from(array $array = []): static\n"
    "    {\n"
    "        return new static($array); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    public function toArray(): array\n"
    "    {\n"
    "        return $this->array;\n"
    "    }\n"
    "\n"
    "    public function isEmpty(): bool\n"
    "    {\n"
    "        return empty($this->array);\n"
    "    }\n"
    "\n"
    "    public function count(): int\n"
    "    {\n"
    "        return count($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    #[\\ReturnTypeWillChange]\n"
    "    public function current()\n"
    "    {\n"
    "        return current($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    #[\\ReturnTypeWillChange]\n"
    "    public function key()\n"
    "    {\n"
    "        return key($this->array);\n"
    "    }\n"
    "\n"
    "    public function valid(): bool\n"
    "    {\n"
    "        return array_key_exists($this->key(), $this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    #[\\ReturnTypeWillChange]\n"
    "    public function rewind()\n"
    "    {\n"
    "        return reset($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    #[\\ReturnTypeWillChange]\n"
    "    public function next()\n"
    "    {\n"
    "        return next($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return ArrayObject|StringObject\n"
    "     */\n"
    "    public function get(mixed $key)\n"
    "    {\n"
    "        if (!$this->exists($key)) {\n"
    "            throw new ArrayKeyNotExists($key);\n"
    "        }\n"
    "        return static::detectType($this->array[$key]);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return ArrayObject|StringObject\n"
    "     */\n"
    "    public function getOr(mixed $key, mixed $default = null)\n"
    "    {\n"
    "        if (!$this->exists($key)) {\n"
    "            return $default;\n"
    "        }\n"
    "        return static::detectType($this->array[$key]);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function last()\n"
    "    {\n"
    "        $key = array_key_last($this->array);\n"
    "        if ($key === null) {\n"
    "            return null;\n"
    "        }\n"
    "        return $this->get($key);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return int|string|null\n"
    "     */\n"
    "    public function firstKey()\n"
    "    {\n"
    "        return array_key_first($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return int|string|null\n"
    "     */\n"
    "    public function lastKey()\n"
    "    {\n"
    "        return array_key_last($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function first()\n"
    "    {\n"
    "        $key = array_key_first($this->array);\n"
    "        if ($key === null) {\n"
    "            return null;\n"
    "        }\n"
    "        return $this->get($key);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function set(mixed $key, mixed $value): self\n"
    "    {\n"
    "        $this->array[$key] = $value;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function delete(mixed $key): self\n"
    "    {\n"
    "        unset($this->array[$key]);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function remove(mixed $value, bool $strict = true, bool $loop = false): self\n"
    "    {\n"
    "        do {\n"
    "            $key = $this->search($value, $strict);\n"
    "            if ($key === false) {\n"
    "                break;\n"
    "            }\n"
    "            unset($this->array[$key]);\n"
    "        } while ($loop);\n"
    "\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function clear(): self\n"
    "    {\n"
    "        $this->array = [];\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed|null\n"
    "     */\n"
    "    #[\\ReturnTypeWillChange]\n"
    "    public function offsetGet(mixed $key)\n"
    "    {\n"
    "        if (!array_key_exists($key, $this->array)) {\n"
    "            return null;\n"
    "        }\n"
    "        return $this->array[$key];\n"
    "    }\n"
    "\n"
    "    public function offsetSet(mixed $key, mixed $value): void\n"
    "    {\n"
    "        $this->array[$key] = $value;\n"
    "    }\n"
    "\n"
    "    public function offsetUnset(mixed $key): void\n"
    "    {\n"
    "        unset($this->array[$key]);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return bool\n"
    "     */\n"
    "    #[\\ReturnTypeWillChange]\n"
    "    public function offsetExists(mixed $key)\n"
    "    {\n"
    "        return isset($this->array[$key]);\n"
    "    }\n"
    "\n"
    "    public function exists(mixed $key): bool\n"
    "    {\n"
    "        return array_key_exists($key, $this->array);\n"
    "    }\n"
    "\n"
    "    public function contains(mixed $value, bool $strict = true): bool\n"
    "    {\n"
    "        return in_array($value, $this->array, $strict);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function indexOf(mixed $value, bool $strict = true)\n"
    "    {\n"
    "        return $this->search($value, $strict);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function lastIndexOf(mixed $value, bool $strict = true)\n"
    "    {\n"
    "        $array = $this->array;\n"
    "        for (end($array); ($currentKey = key($array)) !== null; prev($array)) {\n"
    "            $currentValue = current($array);\n"
    "            if ($currentValue == $value) {\n"
    "                if ($strict && $currentValue !== $value) {\n"
    "                    continue;\n"
    "                }\n"
    "                break;\n"
    "            }\n"
    "        }\n"
    "        return $currentKey;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function search(mixed $needle, bool $strict = true)\n"
    "    {\n"
    "        return array_search($needle, $this->array, $strict);\n"
    "    }\n"
    "\n"
    "    public function join(string $glue = ''): StringObject\n"
    "    {\n"
    "        return self::detectStringType(implode($glue, $this->array));\n"
    "    }\n"
    "\n"
    "    public function serialize(): string\n"
    "    {\n"
    "        return serialize($this->array);\n"
    "    }\n"
    "\n"
    "    public function unserialize(string|\\Stringable|StringObject $string): self\n"
    "    {\n"
    "        $this->array = (array) unserialize((string) $string);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return float|int\n"
    "     */\n"
    "    public function sum()\n"
    "    {\n"
    "        return array_sum($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return float|int\n"
    "     */\n"
    "    public function product()\n"
    "    {\n"
    "        return array_product($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return int\n"
    "     */\n"
    "    public function push(mixed $value)\n"
    "    {\n"
    "        return $this->pushBack($value);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return int\n"
    "     */\n"
    "    public function pushFront(mixed $value)\n"
    "    {\n"
    "        return array_unshift($this->array, $value);\n"
    "    }\n"
    "\n"
    "    public function append(...$values): ArrayObject\n"
    "    {\n"
    "        array_push($this->array, ...$values);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return int\n"
    "     */\n"
    "    public function pushBack(mixed $value)\n"
    "    {\n"
    "        return array_push($this->array, $value);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function insert(int $offset, mixed $value): self\n"
    "    {\n"
    "        if (is_array($value) || is_object($value) || is_null($value)) {\n"
    "            $value = [$value];\n"
    "        }\n"
    "        array_splice($this->array, $offset, 0, $value);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function pop()\n"
    "    {\n"
    "        return $this->popBack();\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function popFront()\n"
    "    {\n"
    "        return array_shift($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function popBack()\n"
    "    {\n"
    "        return array_pop($this->array);\n"
    "    }\n"
    "\n"
    "    public function slice(int $offset, ?int $length = null, bool $preserve_keys = false): static\n"
    "    {\n"
    "        return new static(array_slice($this->array, $offset, $length, $preserve_keys)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return ArrayObject|mixed|StringObject\n"
    "     */\n"
    "    public function randomGet()\n"
    "    {\n"
    "        return static::detectType($this->array[array_rand($this->array, 1)]);\n"
    "    }\n"
    "\n"
    "    public function each(callable $fn): self\n"
    "    {\n"
    "        array_walk($this->array, $fn);\n"
    "\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param array $args\n"
    "     */\n"
    "    public function map(callable $fn, ...$args): static\n"
    "    {\n"
    "        return new static(array_map($fn, $this->array, ...$args)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param null $initial\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function reduce(callable $fn, $initial = null)\n"
    "    {\n"
    "        return array_reduce($this->array, $fn, $initial);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param array $args\n"
    "     */\n"
    "    public function keys(...$args): static\n"
    "    {\n"
    "        return new static(array_keys($this->array, ...$args)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    public function values(): static\n"
    "    {\n"
    "        return new static(array_values($this->array)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    public function column(mixed $column_key, mixed $index = null): static\n"
    "    {\n"
    "        return new static(array_column($this->array, $column_key, $index)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    public function unique(int $sort_flags = SORT_STRING): static\n"
    "    {\n"
    "        return new static(array_unique($this->array, $sort_flags)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    public function reverse(bool $preserve_keys = false): static\n"
    "    {\n"
    "        return new static(array_reverse($this->array, $preserve_keys)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    public function chunk(int $size, bool $preserve_keys = false): static\n"
    "    {\n"
    "        return new static(array_chunk($this->array, $size, $preserve_keys)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Swap keys and values in an array.\n"
    "     */\n"
    "    public function flip(): static\n"
    "    {\n"
    "        return new static(array_flip($this->array)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    public function filter(callable $fn, int $flag = 0): static\n"
    "    {\n"
    "        return new static(array_filter($this->array, $fn, $flag)); // @phpstan-ignore new.static\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * | Function name     | Sorts by | Maintains key association   | Order of sort               | Related functions |\n"
    "     * | :---------------- | :------- | :-------------------------- | :-------------------------- | :---------------- |\n"
    "     * | array_multisort() | value    | associative yes, numeric no | first array or sort options | array_walk()      |\n"
    "     * | asort()           | value    | yes                         | low to high                 | arsort()          |\n"
    "     * | arsort()          | value    | yes                         | high to low                 | asort()           |\n"
    "     * | krsort()          | key      | yes                         | high to low                 | ksort()           |\n"
    "     * | ksort()           | key      | yes                         | low to high                 | asort()           |\n"
    "     * | natcasesort()     | value    | yes                         | natural, case insensitive   | natsort()         |\n"
    "     * | natsort()         | value    | yes                         | natural                     | natcasesort()     |\n"
    "     * | rsort()           | value    | no                          | high to low                 | sort()            |\n"
    "     * | shuffle()         | value    | no                          | random                      | array_rand()      |\n"
    "     * | sort()            | value    | no                          | low to high                 | rsort()           |\n"
    "     * | uasort()          | value    | yes                         | user defined                | uksort()          |\n"
    "     * | uksort()          | key      | yes                         | user defined                | uasort()          |\n"
    "     * | usort()           | value    | no                          | user defined                | uasort()          |\n"
    "     */\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function asort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        asort($this->array, $sort_flags);\n"
    "\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function arsort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        arsort($this->array, $sort_flags);\n"
    "\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function krsort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        krsort($this->array, $sort_flags);\n"
    "\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function ksort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        ksort($this->array, $sort_flags);\n"
    "\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function natcasesort(): self\n"
    "    {\n"
    "        if (natcasesort($this->array) !== true) { // @phpstan-ignore notIdentical.alwaysFalse\n"
    "            throw new \\RuntimeException('natcasesort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function natsort(): self\n"
    "    {\n"
    "        if (natsort($this->array) !== true) { // @phpstan-ignore notIdentical.alwaysFalse\n"
    "            throw new \\RuntimeException('natsort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function rsort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (rsort($this->array, $sort_flags) !== true) { // @phpstan-ignore notIdentical.alwaysFalse\n"
    "            throw new \\RuntimeException('rsort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function shuffle(): self\n"
    "    {\n"
    "        shuffle($this->array);\n"
    "\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function sort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        sort($this->array, $sort_flags);\n"
    "\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function uasort(callable $value_compare_func): self\n"
    "    {\n"
    "        uasort($this->array, $value_compare_func);\n"
    "\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function uksort(callable $value_compare_func): self\n"
    "    {\n"
    "        uksort($this->array, $value_compare_func);\n"
    "\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function usort(callable $value_compare_func): self\n"
    "    {\n"
    "        usort($this->array, $value_compare_func);\n"
    "\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return ArrayObject|mixed|StringObject\n"
    "     */\n"
    "    protected static function detectType(mixed $value)\n"
    "    {\n"
    "        if (is_string($value)) {\n"
    "            return static::detectStringType($value);\n"
    "        }\n"
    "        if (is_array($value)) {\n"
    "            return static::detectArrayType($value);\n"
    "        }\n"
    "        return $value;\n"
    "    }\n"
    "\n"
    "    protected static function detectStringType(string $value): StringObject\n"
    "    {\n"
    "        return new StringObject($value);\n"
    "    }\n"
    "\n"
    "    protected static function detectArrayType(array $value): static\n"
    "    {\n"
    "        return new static($value); // @phpstan-ignore new.static\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_object_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "class ObjectProxy\n"
    "{\n"
    "    /** @var object */\n"
    "    protected $__object;\n"
    "\n"
    "    public function __construct(object $object)\n"
    "    {\n"
    "        $this->__object = $object;\n"
    "    }\n"
    "\n"
    "    public function __getObject()\n"
    "    {\n"
    "        return $this->__object;\n"
    "    }\n"
    "\n"
    "    public function __get(string $name)\n"
    "    {\n"
    "        return $this->__object->{$name};\n"
    "    }\n"
    "\n"
    "    public function __set(string $name, $value): void\n"
    "    {\n"
    "        $this->__object->{$name} = $value;\n"
    "    }\n"
    "\n"
    "    public function __isset($name)\n"
    "    {\n"
    "        return isset($this->__object->{$name});\n"
    "    }\n"
    "\n"
    "    public function __unset(string $name): void\n"
    "    {\n"
    "        unset($this->__object->{$name});\n"
    "    }\n"
    "\n"
    "    public function __call(string $name, array $arguments)\n"
    "    {\n"
    "        return $this->__object->{$name}(...$arguments);\n"
    "    }\n"
    "\n"
    "    public function __invoke(...$arguments)\n"
    "    {\n"
    "        /** @var mixed $object */\n"
    "        $object = $this->__object;\n"
    "        return $object(...$arguments);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_wait_group =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine;\n"
    "\n"
    "class WaitGroup\n"
    "{\n"
    "    protected Channel $chan;\n"
    "\n"
    "    protected int $count = 0;\n"
    "\n"
    "    protected bool $waiting = false;\n"
    "\n"
    "    public function __construct(int $delta = 0)\n"
    "    {\n"
    "        $this->chan = new Channel(1);\n"
    "        if ($delta > 0) {\n"
    "            $this->add($delta);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function add(int $delta = 1): void\n"
    "    {\n"
    "        if ($this->waiting) {\n"
    "            throw new \\BadMethodCallException('WaitGroup misuse: add called concurrently with wait');\n"
    "        }\n"
    "        $count = $this->count + $delta;\n"
    "        if ($count < 0) {\n"
    "            throw new \\InvalidArgumentException('WaitGroup misuse: negative counter');\n"
    "        }\n"
    "        $this->count = $count;\n"
    "    }\n"
    "\n"
    "    public function done(): void\n"
    "    {\n"
    "        $count = $this->count - 1;\n"
    "        if ($count < 0) {\n"
    "            throw new \\BadMethodCallException('WaitGroup misuse: negative counter');\n"
    "        }\n"
    "        $this->count = $count;\n"
    "        if ($count === 0 && $this->waiting) {\n"
    "            $this->chan->push(true);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function wait(float $timeout = -1): bool\n"
    "    {\n"
    "        if ($this->waiting) {\n"
    "            throw new \\BadMethodCallException('WaitGroup misuse: reused before previous wait has returned');\n"
    "        }\n"
    "        if ($this->count > 0) {\n"
    "            $this->waiting = true;\n"
    "            $done          = $this->chan->pop($timeout);\n"
    "            $this->waiting = false;\n"
    "            return $done;\n"
    "        }\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    public function count(): int\n"
    "    {\n"
    "        return $this->count;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_server =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine;\n"
    "\n"
    "use Swoole\\Constant;\n"
    "use Swoole\\Coroutine;\n"
    "use Swoole\\Coroutine\\Server\\Connection;\n"
    "use Swoole\\Exception;\n"
    "\n"
    "class Server\n"
    "{\n"
    "    /** @var string */\n"
    "    public $host = '';\n"
    "\n"
    "    /** @var int */\n"
    "    public $port = 0;\n"
    "\n"
    "    /** @var int */\n"
    "    public $type = AF_INET;\n"
    "\n"
    "    /** @var int */\n"
    "    public $fd = -1;\n"
    "\n"
    "    /** @var int */\n"
    "    public $errCode = 0;\n"
    "\n"
    "    /** @var array */\n"
    "    public $setting = [];\n"
    "\n"
    "    /** @var bool */\n"
    "    protected $running = false;\n"
    "\n"
    "    /** @var callable|null */\n"
    "    protected $fn;\n"
    "\n"
    "    /** @var Socket */\n"
    "    protected $socket;\n"
    "\n"
    "    /**\n"
    "     * Server constructor.\n"
    "     * @throws Exception\n"
    "     */\n"
    "    public function __construct(string $host, int $port = 0, bool $ssl = false, bool $reuse_port = false)\n"
    "    {\n"
    "        $_host = swoole_string($host);\n"
    "        if ($_host->contains('::')) {\n"
    "            $this->type = AF_INET6;\n"
    "        } elseif ($_host->startsWith('unix:/')) {\n"
    "            $host       = $_host->substr(5)->__toString();\n"
    "            $this->type = AF_UNIX;\n"
    "        } else {\n"
    "            $this->type = AF_INET;\n"
    "        }\n"
    "        $this->host = $host;\n"
    "\n"
    "        $socket = new Socket($this->type, SOCK_STREAM, 0);\n"
    "        if ($reuse_port and defined('SO_REUSEPORT')) {\n"
    "            $socket->setOption(SOL_SOCKET, SO_REUSEPORT, true);\n"
    "        }\n"
    "        if (!$socket->bind($this->host, $port)) {\n"
    "            throw new Exception(\"bind({$this->host}:{$port}) failed\", $socket->errCode);\n"
    "        }\n"
    "        if (!$socket->listen()) {\n"
    "            throw new Exception('listen() failed', $socket->errCode);\n"
    "        }\n"
    "        $this->port                = $socket->getsockname()['port'] ?? 0;\n"
    "        $this->fd                  = $socket->fd;\n"
    "        $this->socket              = $socket;\n"
    "        $this->setting['open_ssl'] = $ssl;\n"
    "    }\n"
    "\n"
    "    public function set(array $setting): void\n"
    "    {\n"
    "        $this->setting = array_merge($this->setting, $setting);\n"
    "    }\n"
    "\n"
    "    public function handle(callable $fn): void\n"
    "    {\n"
    "        $this->fn = $fn;\n"
    "    }\n"
    "\n"
    "    public function shutdown(): bool\n"
    "    {\n"
    "        $this->running = false;\n"
    "        return $this->socket->cancel();\n"
    "    }\n"
    "\n"
    "    public function start(): bool\n"
    "    {\n"
    "        $this->running = true;\n"
    "        if ($this->fn === null) {\n"
    "            $this->errCode = SOCKET_EINVAL;\n"
    "            return false;\n"
    "        }\n"
    "        $socket = $this->socket;\n"
    "        if (!$socket->setProtocol($this->setting)) {\n"
    "            $this->errCode = SOCKET_EINVAL;\n"
    "            return false;\n"
    "        }\n"
    "\n"
    "        while ($this->running) { // @phpstan-ignore while.alwaysTrue\n"
    "            $conn = null;\n"
    "            /** @var Socket $conn */\n"
    "            $conn = $socket->accept();\n"
    "            if ($conn) { // @phpstan-ignore if.alwaysTrue\n"
    "                $conn->setProtocol($this->setting);\n"
    "                if (!empty($this->setting[Constant::OPTION_OPEN_SSL])) {\n"
    "                    $fn = static function ($fn, $connection) {\n"
    "                        /* @var $connection Connection */\n"
    "                        if (!$connection->exportSocket()->sslHandshake()) {\n"
    "                            return;\n"
    "                        }\n"
    "                        $fn($connection);\n"
    "                    };\n"
    "                    $arguments = [$this->fn, new Connection($conn)];\n"
    "                } else {\n"
    "                    $fn        = $this->fn;\n"
    "                    $arguments = [new Connection($conn)];\n"
    "                }\n"
    "                if (Coroutine::create($fn, ...$arguments) < 0) {\n"
    "                    goto _wait;\n"
    "                }\n"
    "            } else {\n"
    "                if ($socket->errCode == SOCKET_EMFILE or $socket->errCode == SOCKET_ENFILE) {\n"
    "                    _wait:\n"
    "                    Coroutine::sleep(1);\n"
    "                    continue;\n"
    "                }\n"
    "                if ($socket->errCode == SOCKET_ETIMEDOUT) {\n"
    "                    continue;\n"
    "                }\n"
    "                if ($socket->errCode == SOCKET_ECANCELED) {\n"
    "                    break;\n"
    "                }\n"
    "                trigger_error(\"accept failed, Error: {$socket->errMsg}[{$socket->errCode}]\", E_USER_WARNING);\n"
    "                break;\n"
    "            }\n"
    "        }\n"
    "\n"
    "        return true; // @phpstan-ignore deadCode.unreachable\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_server_connection =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine\\Server;\n"
    "\n"
    "use Swoole\\Coroutine\\Socket;\n"
    "\n"
    "class Connection\n"
    "{\n"
    "    protected $socket;\n"
    "\n"
    "    public function __construct(Socket $conn)\n"
    "    {\n"
    "        $this->socket = $conn;\n"
    "    }\n"
    "\n"
    "    public function recv(float $timeout = 0)\n"
    "    {\n"
    "        return $this->socket->recvPacket($timeout);\n"
    "    }\n"
    "\n"
    "    public function send(string $data)\n"
    "    {\n"
    "        return $this->socket->sendAll($data);\n"
    "    }\n"
    "\n"
    "    public function close(): bool\n"
    "    {\n"
    "        return $this->socket->close();\n"
    "    }\n"
    "\n"
    "    public function exportSocket(): Socket\n"
    "    {\n"
    "        return $this->socket;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_barrier =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine;\n"
    "\n"
    "use Swoole\\Coroutine;\n"
    "use Swoole\\Exception;\n"
    "use Swoole\\Timer;\n"
    "\n"
    "class Barrier\n"
    "{\n"
    "    private int $cid = -1;\n"
    "\n"
    "    private $timer = -1;\n"
    "\n"
    "    private static array $cancel_list = [];\n"
    "\n"
    "    public function __destruct()\n"
    "    {\n"
    "        if ($this->timer !== -1) {\n"
    "            Timer::clear($this->timer);\n"
    "            if (isset(self::$cancel_list[$this->cid])) {\n"
    "                unset(self::$cancel_list[$this->cid]);\n"
    "                return;\n"
    "            }\n"
    "        }\n"
    "        if ($this->cid !== -1 && $this->cid !== Coroutine::getCid()) {\n"
    "            Coroutine::resume($this->cid);\n"
    "        } else {\n"
    "            self::$cancel_list[$this->cid] = true;\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public static function make(): self\n"
    "    {\n"
    "        return new self();\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param-out null $barrier\n"
    "     */\n"
    "    public static function wait(Barrier &$barrier, float $timeout = -1): void\n"
    "    {\n"
    "        if ($barrier->cid !== -1) {\n"
    "            throw new Exception('The barrier is waiting, cannot wait again.');\n"
    "        }\n"
    "        $cid          = Coroutine::getCid();\n"
    "        $barrier->cid = $cid;\n"
    "        if ($timeout > 0 && ($timeout_ms = (int) ($timeout * 1000)) > 0) {\n"
    "            $barrier->timer = Timer::after($timeout_ms, function () use ($cid) {\n"
    "                self::$cancel_list[$cid] = true;\n"
    "                Coroutine::resume($cid);\n"
    "            });\n"
    "        }\n"
    "        $barrier = null;\n"
    "        if (!isset(self::$cancel_list[$cid])) {\n"
    "            Coroutine::yield();\n"
    "        } else {\n"
    "            unset(self::$cancel_list[$cid]);\n"
    "        }\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_http_client_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine\\Http;\n"
    "\n"
    "class ClientProxy\n"
    "{\n"
    "    private array $headers;\n"
    "\n"
    "    private array $cookies;\n"
    "\n"
    "    public function __construct(private string $body, private int $statusCode, ?array $headers, ?array $cookies)\n"
    "    {\n"
    "        $this->headers = $headers ?? [];\n"
    "        $this->cookies = $cookies ?? [];\n"
    "    }\n"
    "\n"
    "    public function getBody(): string\n"
    "    {\n"
    "        return $this->body;\n"
    "    }\n"
    "\n"
    "    public function getStatusCode(): int\n"
    "    {\n"
    "        return $this->statusCode;\n"
    "    }\n"
    "\n"
    "    public function getHeaders(): array\n"
    "    {\n"
    "        return $this->headers;\n"
    "    }\n"
    "\n"
    "    public function getCookies(): array\n"
    "    {\n"
    "        return $this->cookies;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_http_functions =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine\\Http;\n"
    "\n"
    "use Swoole\\Coroutine\\Http\\Client\\Exception;\n"
    "\n"
    "/**\n"
    " * @throws Exception\n"
    " */\n"
    "function request(\n"
    "    string $url,\n"
    "    string $method,\n"
    "    mixed $data = null,\n"
    "    ?array $options = null,\n"
    "    ?array $headers = null,\n"
    "    ?array $cookies = null,\n"
    "): ClientProxy {\n"
    "    $driver = swoole_library_get_option('http_client_driver');\n"
    "    return match ($driver) {\n"
    "        'curl'   => request_with_curl($url, $method, $data, $options, $headers, $cookies),\n"
    "        'stream' => request_with_stream($url, $method, $data, $options, $headers, $cookies),\n"
    "        default  => request_with_http_client($url, $method, $data, $options, $headers, $cookies),\n"
    "    };\n"
    "}\n"
    "\n"
    "/**\n"
    " * @throws Exception\n"
    " */\n"
    "function request_with_http_client(\n"
    "    string $url,\n"
    "    string $method,\n"
    "    mixed $data = null,\n"
    "    ?array $options = null,\n"
    "    ?array $headers = null,\n"
    "    ?array $cookies = null,\n"
    "): ClientProxy {\n"
    "    $info = parse_url($url);\n"
    "    if (empty($info['scheme'])) {\n"
    "        throw new Exception('The URL given is illegal [no scheme]');\n"
    "    }\n"
    "    if ($info['scheme'] == 'http') {\n"
    "        $client = new Client($info['host'], swoole_array_default_value($info, 'port', 80), false);\n"
    "    } elseif ($info['scheme'] == 'https') {\n"
    "        $client = new Client($info['host'], swoole_array_default_value($info, 'port', 443), true);\n"
    "    } else {\n"
    "        throw new Exception('unknown scheme \"' . $info['scheme'] . '\"');\n"
    "    }\n"
    "    $client->setMethod($method);\n"
    "    if ($data) {\n"
    "        $client->setData($data);\n"
    "    }\n"
    "    $client->set($options ?: []);\n"
    "    $client->setHeaders($headers ?: []);\n"
    "    $client->setCookies($cookies ?: []);\n"
    "    $request_url = swoole_array_default_value($info, 'path', '/');\n"
    "    if (!empty($info['query'])) {\n"
    "        $request_url .= '?' . $info['query'];\n"
    "    }\n"
    "    if ($client->execute($request_url)) {\n"
    "        return new ClientProxy(\n"
    "            $client->getBody(),\n"
    "            $client->getStatusCode(),\n"
    "            $client->getHeaders() ?: [],\n"
    "            $client->getCookies() ?: []\n"
    "        );\n"
    "    }\n"
    "    throw new Exception($client->errMsg, $client->errCode);\n"
    "}\n"
    "\n"
    "/**\n"
    " * @throws Exception\n"
    " */\n"
    "function request_with_curl(\n"
    "    string $url,\n"
    "    string $method,\n"
    "    mixed $data = null,\n"
    "    ?array $options = null,\n"
    "    ?array $headers = null,\n"
    "    ?array $cookies = null,\n"
    "): ClientProxy {\n"
    "    $ch = curl_init($url);\n"
    "    if (empty($ch)) {\n"
    "        throw new Exception('failed to curl_init');\n"
    "    }\n"
    "    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);\n"
    "    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, strtoupper($method));\n"
    "    $responseHeaders = $responseCookies = [];\n"
    "    curl_setopt($ch, CURLOPT_HEADERFUNCTION, function ($ch, $header) use (&$responseHeaders, &$responseCookies) {\n"
    "        $len    = strlen($header);\n"
    "        $header = explode(':', $header, 2);\n"
    "        if (count($header) < 2) {\n"
    "            return $len;\n"
    "        }\n"
    "        $headerKey = strtolower(trim($header[0]));\n"
    "        if ($headerKey == 'set-cookie') {\n"
    "            [$k, $v]             = explode('=', $header[1]);\n"
    "            $responseCookies[$k] = $v;\n"
    "        } else {\n"
    "            $responseHeaders[$headerKey][] = trim($header[1]);\n"
    "        }\n"
    "        return $len;\n"
    "    });\n"
    "    if ($data) {\n"
    "        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);\n"
    "    }\n"
    "    if ($headers) {\n"
    "        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);\n"
    "    }\n"
    "    if ($cookies) {\n"
    "        $cookie_str = '';\n"
    "        foreach ($cookies as $k => $v) {\n"
    "            $cookie_str .= \"{$k}={$v}; \";\n"
    "        }\n"
    "        curl_setopt($ch, CURLOPT_COOKIE, $cookie_str);\n"
    "    }\n"
    "    if (isset($options['timeout'])) {\n"
    "        if (is_float($options['timeout'])) {\n"
    "            curl_setopt($ch, CURLOPT_TIMEOUT_MS, intval($options['timeout'] * 1000));\n"
    "            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT_MS, intval($options['timeout'] * 1000));\n"
    "        } else {\n"
    "            curl_setopt($ch, CURLOPT_TIMEOUT, intval($options['timeout']));\n"
    "            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, intval($options['timeout']));\n"
    "        }\n"
    "    }\n"
    "    if (isset($options['connect_timeout'])) {\n"
    "        if (is_float($options['connect_timeout'])) {\n"
    "            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT_MS, intval($options['connect_timeout'] * 1000));\n"
    "        } else {\n"
    "            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, intval($options['connect_timeout']));\n"
    "        }\n"
    "    }\n"
    "    $body = curl_exec($ch);\n"
    "    if ($body !== false) {\n"
    "        return new ClientProxy($body, curl_getinfo($ch, CURLINFO_RESPONSE_CODE), $responseHeaders, $responseCookies);\n"
    "    }\n"
    "    throw new Exception(curl_error($ch), curl_errno($ch));\n"
    "}\n"
    "\n"
    "/**\n"
    " * @throws Exception\n"
    " */\n"
    "function request_with_stream(\n"
    "    string $url,\n"
    "    string $method,\n"
    "    mixed $data = null,\n"
    "    ?array $options = null,\n"
    "    ?array $headers = null,\n"
    "    ?array $cookies = null,\n"
    "): ClientProxy {\n"
    "    $stream_options = [\n"
    "        'http' => [\n"
    "            'method' => $method,\n"
    "        ],\n"
    "    ];\n"
    "    $headerStr = '';\n"
    "    if ($headers) {\n"
    "        foreach ($headers as $k => $v) {\n"
    "            $headerStr .= \"{$k}: {$v}\\r\\n\";\n"
    "        }\n"
    "    }\n"
    "    if ($cookies) {\n"
    "        foreach ($cookies as $k => $v) {\n"
    "            $headerStr .= \"Cookie: {$k}={$v}\\r\\n\";\n"
    "        }\n"
    "    }\n"
    "    if (isset($options['timeout'])) {\n"
    "        $stream_options['http']['timeout'] = intval($options['timeout']);\n"
    "    }\n"
    "    if ($data) {\n"
    "        if (is_array($data)) {\n"
    "            $headerStr .= \"Content-type: application/x-www-form-urlencoded\\r\\n\";\n"
    "            $stream_options['http']['content'] = http_build_query($data);\n"
    "        } else {\n"
    "            $stream_options['http']['content'] = strval($data);\n"
    "        }\n"
    "    }\n"
    "    if ($headerStr) {\n"
    "        $stream_options['http']['header'] = $headerStr;\n"
    "    }\n"
    "    $body = file_get_contents($url, false, stream_context_create($stream_options));\n"
    "    if ($body) {\n"
    "        return new ClientProxy($body, 200, [], []);\n"
    "    }\n"
    "    $error = error_get_last();\n"
    "    throw new Exception($error['message']);\n"
    "}\n"
    "\n"
    "/**\n"
    " * @throws Exception\n"
    " */\n"
    "function post(string $url, mixed $data, ?array $options = null, ?array $headers = null, ?array $cookies = null): ClientProxy\n"
    "{\n"
    "    return request($url, 'POST', $data, $options, $headers, $cookies);\n"
    "}\n"
    "\n"
    "/**\n"
    " * @throws Exception\n"
    " */\n"
    "function get(string $url, ?array $options = null, ?array $headers = null, ?array $cookies = null): ClientProxy\n"
    "{\n"
    "    return request($url, 'GET', null, $options, $headers, $cookies);\n"
    "}\n";

static const char* swoole_library_source_core_connection_pool =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "use Swoole\\Coroutine\\Channel;\n"
    "\n"
    "class ConnectionPool\n"
    "{\n"
    "    public const DEFAULT_SIZE = 64;\n"
    "\n"
    "    protected ?Channel $pool;\n"
    "\n"
    "    /** @var callable */\n"
    "    protected $constructor;\n"
    "\n"
    "    protected int $size;\n"
    "\n"
    "    protected int $num = 0;\n"
    "\n"
    "    public function __construct(callable $constructor, int $size = self::DEFAULT_SIZE, protected ?string $proxy = null)\n"
    "    {\n"
    "        $this->pool        = new Channel($this->size = $size);\n"
    "        $this->constructor = $constructor;\n"
    "    }\n"
    "\n"
    "    public function fill(): void\n"
    "    {\n"
    "        while ($this->size > $this->num) {\n"
    "            $this->make();\n"
    "        }\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Get a connection from the pool.\n"
    "     *\n"
    "     * @param float $timeout > 0 means waiting for the specified number of seconds. other means no waiting.\n"
    "     * @return mixed|false Returns a connection object from the pool, or false if the pool is full and the timeout is reached.\n"
    "     */\n"
    "    public function get(float $timeout = -1)\n"
    "    {\n"
    "        if ($this->pool === null) {\n"
    "            throw new \\RuntimeException('Pool has been closed');\n"
    "        }\n"
    "        if ($this->pool->isEmpty() && $this->num < $this->size) {\n"
    "            $this->make();\n"
    "        }\n"
    "        return $this->pool->pop($timeout);\n"
    "    }\n"
    "\n"
    "    public function put($connection): void\n"
    "    {\n"
    "        if ($this->pool === null) {\n"
    "            return;\n"
    "        }\n"
    "        if ($connection !== null) {\n"
    "            $this->pool->push($connection);\n"
    "        } else {\n"
    "            /* connection broken */\n"
    "            $this->num -= 1;\n"
    "            $this->make();\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function close(): void\n"
    "    {\n"
    "        $this->pool->close();\n"
    "        $this->pool = null;\n"
    "        $this->num  = 0;\n"
    "    }\n"
    "\n"
    "    protected function make(): void\n"
    "    {\n"
    "        $this->num++;\n"
    "        try {\n"
    "            if ($this->proxy) {\n"
    "                $connection = new $this->proxy($this->constructor);\n"
    "            } else {\n"
    "                $constructor = $this->constructor;\n"
    "                $connection  = $constructor();\n"
    "            }\n"
    "        } catch (\\Throwable $throwable) {\n"
    "            $this->num--;\n"
    "            throw $throwable;\n"
    "        }\n"
    "        $this->put($connection);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_object_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "class ObjectProxy extends \\Swoole\\ObjectProxy\n"
    "{\n"
    "    final public function __clone(): void\n"
    "    {\n"
    "        throw new \\Error('Trying to clone an uncloneable database proxy object');\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_mysqli_config =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "class MysqliConfig\n"
    "{\n"
    "    protected string $host = '127.0.0.1';\n"
    "\n"
    "    protected int $port = 3306;\n"
    "\n"
    "    protected ?string $unixSocket;\n"
    "\n"
    "    protected string $dbname = 'test';\n"
    "\n"
    "    protected string $charset = 'utf8mb4';\n"
    "\n"
    "    protected string $username = 'root';\n"
    "\n"
    "    protected string $password = 'root';\n"
    "\n"
    "    protected array $options = [];\n"
    "\n"
    "    public function getHost(): string\n"
    "    {\n"
    "        return $this->host;\n"
    "    }\n"
    "\n"
    "    public function withHost(string $host): self\n"
    "    {\n"
    "        $this->host = $host;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getPort(): int\n"
    "    {\n"
    "        return $this->port;\n"
    "    }\n"
    "\n"
    "    public function getUnixSocket(): ?string\n"
    "    {\n"
    "        return $this->unixSocket ?? null;\n"
    "    }\n"
    "\n"
    "    public function withUnixSocket(?string $unixSocket): self\n"
    "    {\n"
    "        $this->unixSocket = $unixSocket;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withPort(int $port): self\n"
    "    {\n"
    "        $this->port = $port;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getDbname(): string\n"
    "    {\n"
    "        return $this->dbname;\n"
    "    }\n"
    "\n"
    "    public function withDbname(string $dbname): self\n"
    "    {\n"
    "        $this->dbname = $dbname;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getCharset(): string\n"
    "    {\n"
    "        return $this->charset;\n"
    "    }\n"
    "\n"
    "    public function withCharset(string $charset): self\n"
    "    {\n"
    "        $this->charset = $charset;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getUsername(): string\n"
    "    {\n"
    "        return $this->username;\n"
    "    }\n"
    "\n"
    "    public function withUsername(string $username): self\n"
    "    {\n"
    "        $this->username = $username;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getPassword(): string\n"
    "    {\n"
    "        return $this->password;\n"
    "    }\n"
    "\n"
    "    public function withPassword(string $password): self\n"
    "    {\n"
    "        $this->password = $password;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getOptions(): array\n"
    "    {\n"
    "        return $this->options;\n"
    "    }\n"
    "\n"
    "    public function withOptions(array $options): self\n"
    "    {\n"
    "        $this->options = $options;\n"
    "        return $this;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_mysqli_exception =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "class MysqliException extends \\Exception\n"
    "{\n"
    "}\n";

static const char* swoole_library_source_core_database_mysqli_pool =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use mysqli;\n"
    "use Swoole\\ConnectionPool;\n"
    "\n"
    "/**\n"
    " * @method \\mysqli|MysqliProxy get()\n"
    " * @method void put(mysqli|MysqliProxy $connection)\n"
    " */\n"
    "class MysqliPool extends ConnectionPool\n"
    "{\n"
    "    public function __construct(protected MysqliConfig $config, int $size = self::DEFAULT_SIZE)\n"
    "    {\n"
    "        parent::__construct(function () {\n"
    "            $mysqli = new \\mysqli();\n"
    "            foreach ($this->config->getOptions() as $option => $value) {\n"
    "                $mysqli->set_opt($option, $value);\n"
    "            }\n"
    "            $mysqli->real_connect(\n"
    "                $this->config->getHost(),\n"
    "                $this->config->getUsername(),\n"
    "                $this->config->getPassword(),\n"
    "                $this->config->getDbname(),\n"
    "                $this->config->getPort(),\n"
    "                $this->config->getUnixSocket()\n"
    "            );\n"
    "            if ($mysqli->connect_errno) {\n"
    "                throw new MysqliException($mysqli->connect_error, $mysqli->connect_errno);\n"
    "            }\n"
    "            $mysqli->set_charset($this->config->getCharset());\n"
    "            return $mysqli;\n"
    "        }, $size, MysqliProxy::class);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_mysqli_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "/**\n"
    " * @method \\mysqli __getObject()\n"
    " */\n"
    "class MysqliProxy extends ObjectProxy\n"
    "{\n"
    "    public const IO_METHOD_REGEX = '/^autocommit|begin_transaction|change_user|close|commit|kill|multi_query|ping|prepare|query|real_connect|real_query|reap_async_query|refresh|release_savepoint|rollback|savepoint|select_db|send_query|set_charset|ssl_set$/i';\n"
    "\n"
    "    public const IO_ERRORS = [\n"
    "        2002, // MYSQLND_CR_CONNECTION_ERROR\n"
    "        2006, // MYSQLND_CR_SERVER_GONE_ERROR\n"
    "        2013, // MYSQLND_CR_SERVER_LOST\n"
    "    ];\n"
    "\n"
    "    /** @var \\mysqli */\n"
    "    protected $__object;\n"
    "\n"
    "    protected string $charsetContext;\n"
    "\n"
    "    protected array $setOptContext = [];\n"
    "\n"
    "    protected array $changeUserContext;\n"
    "\n"
    "    /** @var callable */\n"
    "    protected $constructor;\n"
    "\n"
    "    protected int $round = 0;\n"
    "\n"
    "    public function __construct(callable $constructor)\n"
    "    {\n"
    "        parent::__construct($constructor());\n"
    "        $this->constructor = $constructor;\n"
    "    }\n"
    "\n"
    "    public function __call(string $name, array $arguments)\n"
    "    {\n"
    "        for ($n = 3; $n--;) {\n"
    "            $ret = @$this->__object->{$name}(...$arguments);\n"
    "            if ($ret === false) {\n"
    "                /* non-IO method */\n"
    "                if (!preg_match(static::IO_METHOD_REGEX, $name)) {\n"
    "                    break;\n"
    "                }\n"
    "                /* no more chances or non-IO failures */\n"
    "                if (!in_array($this->__object->errno, static::IO_ERRORS, true) || ($n === 0)) {\n"
    "                    throw new MysqliException($this->__object->error, $this->__object->errno);\n"
    "                }\n"
    "                $this->reconnect();\n"
    "                continue;\n"
    "            }\n"
    "            if (strcasecmp($name, 'prepare') === 0) {\n"
    "                $ret = new MysqliStatementProxy($ret, $arguments[0], $this);\n"
    "            } elseif (strcasecmp($name, 'stmt_init') === 0) {\n"
    "                $ret = new MysqliStatementProxy($ret, null, $this);\n"
    "            }\n"
    "            break;\n"
    "        }\n"
    "        /* @noinspection PhpUndefinedVariableInspection */\n"
    "        return $ret;\n"
    "    }\n"
    "\n"
    "    public function getRound(): int\n"
    "    {\n"
    "        return $this->round;\n"
    "    }\n"
    "\n"
    "    public function reconnect(): void\n"
    "    {\n"
    "        $constructor = $this->constructor;\n"
    "        parent::__construct($constructor());\n"
    "        $this->round++;\n"
    "        /* restore context */\n"
    "        if (!empty($this->charsetContext)) {\n"
    "            $this->__object->set_charset($this->charsetContext);\n"
    "        }\n"
    "        foreach ($this->setOptContext as $opt => $val) {\n"
    "            $this->__object->set_opt($opt, $val);\n"
    "        }\n"
    "        if (!empty($this->changeUserContext)) {\n"
    "            $this->__object->change_user(...$this->changeUserContext);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function options(int $option, $value): bool\n"
    "    {\n"
    "        $this->setOptContext[$option] = $value;\n"
    "        return $this->__object->options($option, $value);\n"
    "    }\n"
    "\n"
    "    public function set_opt(int $option, $value): bool\n"
    "    {\n"
    "        return $this->options($option, $value);\n"
    "    }\n"
    "\n"
    "    public function set_charset(string $charset): bool\n"
    "    {\n"
    "        $this->charsetContext = $charset;\n"
    "        return $this->__object->set_charset($charset);\n"
    "    }\n"
    "\n"
    "    public function change_user(string $user, string $password, ?string $database): bool\n"
    "    {\n"
    "        $this->changeUserContext = [$user, $password, $database];\n"
    "        return $this->__object->change_user($user, $password, $database);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_mysqli_statement_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "class MysqliStatementProxy extends ObjectProxy\n"
    "{\n"
    "    public const IO_METHOD_REGEX = '/^close|execute|fetch|prepare$/i';\n"
    "\n"
    "    /** @var \\mysqli_stmt */\n"
    "    protected $__object;\n"
    "\n"
    "    protected ?string $queryString;\n"
    "\n"
    "    protected array $attrSetContext = [];\n"
    "\n"
    "    protected array $bindParamContext;\n"
    "\n"
    "    protected array $bindResultContext;\n"
    "\n"
    "    protected MysqliProxy $parent;\n"
    "\n"
    "    protected int $parentRound;\n"
    "\n"
    "    public function __construct(\\mysqli_stmt $object, ?string $queryString, MysqliProxy $parent)\n"
    "    {\n"
    "        parent::__construct($object);\n"
    "        $this->queryString = $queryString;\n"
    "        $this->parent      = $parent;\n"
    "        $this->parentRound = $parent->getRound();\n"
    "    }\n"
    "\n"
    "    public function __call(string $name, array $arguments)\n"
    "    {\n"
    "        for ($n = 3; $n--;) {\n"
    "            $ret = @$this->__object->{$name}(...$arguments);\n"
    "            if ($ret === false) {\n"
    "                /* non-IO method */\n"
    "                if (!preg_match(static::IO_METHOD_REGEX, $name)) {\n"
    "                    break;\n"
    "                }\n"
    "                /* no more chances or non-IO failures or in transaction */\n"
    "                if (!in_array($this->__object->errno, $this->parent::IO_ERRORS, true) || ($n === 0)) {\n"
    "                    throw new MysqliException($this->__object->error, $this->__object->errno);\n"
    "                }\n"
    "                if ($this->parent->getRound() === $this->parentRound) {\n"
    "                    /* if not equal, parent has reconnected */\n"
    "                    $this->parent->reconnect();\n"
    "                }\n"
    "                $parent         = $this->parent->__getObject();\n"
    "                $this->__object = $this->queryString ? @$parent->prepare($this->queryString) : @$parent->stmt_init();\n"
    "                if ($this->__object === false) {\n"
    "                    throw new MysqliException($parent->error, $parent->errno);\n"
    "                }\n"
    "                if (!empty($this->bindParamContext)) {\n"
    "                    $this->__object->bind_param($this->bindParamContext[0], ...$this->bindParamContext[1]);\n"
    "                }\n"
    "                if (!empty($this->bindResultContext)) {\n"
    "                    $this->__object->bind_result($this->bindResultContext);\n"
    "                }\n"
    "                foreach ($this->attrSetContext as $attr => $value) {\n"
    "                    $this->__object->attr_set($attr, $value);\n"
    "                }\n"
    "                continue;\n"
    "            }\n"
    "            if (strcasecmp($name, 'prepare') === 0) {\n"
    "                $this->queryString = $arguments[0];\n"
    "            }\n"
    "            break;\n"
    "        }\n"
    "        /* @noinspection PhpUndefinedVariableInspection */\n"
    "        return $ret;\n"
    "    }\n"
    "\n"
    "    public function attr_set($attr, $mode): bool\n"
    "    {\n"
    "        $this->attrSetContext[$attr] = $mode;\n"
    "        return $this->__object->attr_set($attr, $mode);\n"
    "    }\n"
    "\n"
    "    public function bind_param($types, &...$arguments): bool\n"
    "    {\n"
    "        $this->bindParamContext = [$types, $arguments];\n"
    "        return $this->__object->bind_param($types, ...$arguments);\n"
    "    }\n"
    "\n"
    "    public function bind_result(&...$arguments): bool\n"
    "    {\n"
    "        $this->bindResultContext = $arguments;\n"
    "        return $this->__object->bind_result(...$arguments);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_detects_lost_connections =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "class DetectsLostConnections\n"
    "{\n"
    "    /**\n"
    "     * @var array<string>\n"
    "     */\n"
    "    private const ERROR_MESSAGES = [\n"
    "        'server has gone away',\n"
    "        'no connection to the server',\n"
    "        'Lost connection',\n"
    "        'is dead or not enabled',\n"
    "        'Error while sending',\n"
    "        'decryption failed or bad record mac',\n"
    "        'server closed the connection unexpectedly',\n"
    "        'SSL connection has been closed unexpectedly',\n"
    "        'Error writing data to the connection',\n"
    "        'Resource deadlock avoided',\n"
    "        'Transaction() on null',\n"
    "        'child connection forced to terminate due to client_idle_limit',\n"
    "        'query_wait_timeout',\n"
    "        'reset by peer',\n"
    "        'Physical connection is not usable',\n"
    "        'TCP Provider: Error code 0x68',\n"
    "        'ORA-03113',\n"
    "        'ORA-03114',\n"
    "        'Packets out of order. Expected',\n"
    "        'Adaptive Server connection failed',\n"
    "        'Communication link failure',\n"
    "        'connection is no longer usable',\n"
    "        'Login timeout expired',\n"
    "        'SQLSTATE[HY000] [2002] Connection refused',\n"
    "        'running with the --read-only option so it cannot execute this statement',\n"
    "        'The connection is broken and recovery is not possible. The connection is marked by the client driver as unrecoverable. No attempt was made to restore the connection.',\n"
    "        'SQLSTATE[HY000] [2002] php_network_getaddresses: getaddrinfo failed: Try again',\n"
    "        'SQLSTATE[HY000] [2002] php_network_getaddresses: getaddrinfo failed: Name or service not known',\n"
    "        'SQLSTATE[HY000] [2002] php_network_getaddresses: getaddrinfo for',\n"
    "        'SQLSTATE[HY000]: General error: 7 SSL SYSCALL error: EOF detected',\n"
    "        'SQLSTATE[HY000]: General error: 1105 The last transaction was aborted due to Seamless Scaling. Please retry.',\n"
    "        'Temporary failure in name resolution',\n"
    "        'SQLSTATE[08S01]: Communication link failure',\n"
    "        'SQLSTATE[08006] [7] could not connect to server: Connection refused Is the server running on host',\n"
    "        'SQLSTATE[HY000]: General error: 7 SSL SYSCALL error: No route to host',\n"
    "        'The client was disconnected by the server because of inactivity. See wait_timeout and interactive_timeout for configuring this behavior.',\n"
    "        'SQLSTATE[08006] [7] could not translate host name',\n"
    "        'TCP Provider: Error code 0x274C',\n"
    "        'SQLSTATE[HY000] [2002] No such file or directory',\n"
    "        'Reason: Server is in script upgrade mode. Only administrator can connect at this time.',\n"
    "        'Unknown $curl_error_code: 77',\n"
    "        'SQLSTATE[08006] [7] SSL error: sslv3 alert unexpected message',\n"
    "        'SQLSTATE[08006] [7] unrecognized SSL error code:',\n"
    "        'SQLSTATE[HY000] [2002] No connection could be made because the target machine actively refused it',\n"
    "        'Broken pipe',\n"
    "        // PDO::prepare(): Send of 77 bytes failed with errno=110 Operation timed out\n"
    "        // SSL: Handshake timed out\n"
    "        // SSL: Operation timed out\n"
    "        // SSL: Connection timed out\n"
    "        // SQLSTATE[HY000] [2002] Connection timed out\n"
    "        'timed out',\n"
    "        'Error reading result',\n"
    "    ];\n"
    "\n"
    "    public static function causedByLostConnection(\\Throwable $e): bool\n"
    "    {\n"
    "        $message = $e->getMessage();\n"
    "        foreach (self::ERROR_MESSAGES as $needle) {\n"
    "            if (mb_strpos($message, $needle) !== false) {\n"
    "                return true;\n"
    "            }\n"
    "        }\n"
    "\n"
    "        return false;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_pdo_config =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "class PDOConfig\n"
    "{\n"
    "    public const DRIVER_MYSQL = 'mysql';\n"
    "\n"
    "    protected string $driver = self::DRIVER_MYSQL;\n"
    "\n"
    "    protected string $host = '127.0.0.1';\n"
    "\n"
    "    protected int $port = 3306;\n"
    "\n"
    "    protected ?string $unixSocket;\n"
    "\n"
    "    protected string $dbname = 'test';\n"
    "\n"
    "    protected string $charset = 'utf8mb4';\n"
    "\n"
    "    protected string $username = 'root';\n"
    "\n"
    "    protected string $password = 'root';\n"
    "\n"
    "    protected array $options = [];\n"
    "\n"
    "    public function getDriver(): string\n"
    "    {\n"
    "        return $this->driver;\n"
    "    }\n"
    "\n"
    "    public function withDriver(string $driver): self\n"
    "    {\n"
    "        $this->driver = $driver;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getHost(): string\n"
    "    {\n"
    "        return $this->host;\n"
    "    }\n"
    "\n"
    "    public function withHost(string $host): self\n"
    "    {\n"
    "        $this->host = $host;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getPort(): int\n"
    "    {\n"
    "        return $this->port;\n"
    "    }\n"
    "\n"
    "    public function hasUnixSocket(): bool\n"
    "    {\n"
    "        return !empty($this->unixSocket);\n"
    "    }\n"
    "\n"
    "    public function getUnixSocket(): ?string\n"
    "    {\n"
    "        return $this->unixSocket ?? null;\n"
    "    }\n"
    "\n"
    "    public function withUnixSocket(?string $unixSocket): self\n"
    "    {\n"
    "        $this->unixSocket = $unixSocket;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withPort(int $port): self\n"
    "    {\n"
    "        $this->port = $port;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getDbname(): string\n"
    "    {\n"
    "        return $this->dbname;\n"
    "    }\n"
    "\n"
    "    public function withDbname(string $dbname): self\n"
    "    {\n"
    "        $this->dbname = $dbname;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getCharset(): string\n"
    "    {\n"
    "        return $this->charset;\n"
    "    }\n"
    "\n"
    "    public function withCharset(string $charset): self\n"
    "    {\n"
    "        $this->charset = $charset;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getUsername(): string\n"
    "    {\n"
    "        return $this->username;\n"
    "    }\n"
    "\n"
    "    public function withUsername(string $username): self\n"
    "    {\n"
    "        $this->username = $username;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getPassword(): string\n"
    "    {\n"
    "        return $this->password;\n"
    "    }\n"
    "\n"
    "    public function withPassword(string $password): self\n"
    "    {\n"
    "        $this->password = $password;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getOptions(): array\n"
    "    {\n"
    "        return $this->options;\n"
    "    }\n"
    "\n"
    "    public function withOptions(array $options): self\n"
    "    {\n"
    "        $this->options = $options;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the list of available drivers\n"
    "     *\n"
    "     * @return string[]\n"
    "     */\n"
    "    public static function getAvailableDrivers(): array\n"
    "    {\n"
    "        return [\n"
    "            self::DRIVER_MYSQL,\n"
    "        ];\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_pdo_pool =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use PDO;\n"
    "use Swoole\\ConnectionPool;\n"
    "\n"
    "/**\n"
    " * @method void put(PDO|PDOProxy $connection)\n"
    " */\n"
    "class PDOPool extends ConnectionPool\n"
    "{\n"
    "    public function __construct(protected PDOConfig $config, int $size = self::DEFAULT_SIZE)\n"
    "    {\n"
    "        parent::__construct(function () {\n"
    "            $driver = $this->config->getDriver();\n"
    "            if ($driver === 'sqlite') {\n"
    "                return new \\PDO($this->createDSN('sqlite'));\n"
    "            }\n"
    "\n"
    "            return new \\PDO($this->createDSN($driver), $this->config->getUsername(), $this->config->getPassword(), $this->config->getOptions());\n"
    "        }, $size, PDOProxy::class);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Get a PDO connection from the pool. The PDO connection (a PDO object) is wrapped in a PDOProxy object returned.\n"
    "     *\n"
    "     * @param float $timeout > 0 means waiting for the specified number of seconds. other means no waiting.\n"
    "     * @return PDOProxy|false Returns a PDOProxy object from the pool, or false if the pool is full and the timeout is reached.\n"
    "     *                        {@inheritDoc}\n"
    "     */\n"
    "    public function get(float $timeout = -1)\n"
    "    {\n"
    "        /* @var \\Swoole\\Database\\PDOProxy|false $pdo */\n"
    "        $pdo = parent::get($timeout);\n"
    "        if ($pdo === false) {\n"
    "            return false;\n"
    "        }\n"
    "\n"
    "        $pdo->reset();\n"
    "\n"
    "        return $pdo;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @purpose create DSN\n"
    "     * @throws \\Exception\n"
    "     */\n"
    "    private function createDSN(string $driver): string\n"
    "    {\n"
    "        switch ($driver) {\n"
    "            case 'mysql':\n"
    "                if ($this->config->hasUnixSocket()) {\n"
    "                    $dsn = \"mysql:unix_socket={$this->config->getUnixSocket()};dbname={$this->config->getDbname()};charset={$this->config->getCharset()}\";\n"
    "                } else {\n"
    "                    $dsn = \"mysql:host={$this->config->getHost()};port={$this->config->getPort()};dbname={$this->config->getDbname()};charset={$this->config->getCharset()}\";\n"
    "                }\n"
    "                break;\n"
    "            case 'pgsql':\n"
    "                $dsn = 'pgsql:host=' . ($this->config->hasUnixSocket() ? $this->config->getUnixSocket() : $this->config->getHost()) . \";port={$this->config->getPort()};dbname={$this->config->getDbname()}\";\n"
    "                break;\n"
    "            case 'oci':\n"
    "                $dsn = 'oci:dbname=' . ($this->config->hasUnixSocket() ? $this->config->getUnixSocket() : $this->config->getHost()) . ':' . $this->config->getPort() . '/' . $this->config->getDbname() . ';charset=' . $this->config->getCharset();\n"
    "                break;\n"
    "            case 'sqlite':\n"
    "                // There are three types of SQLite databases: databases on disk, databases in memory, and temporary\n"
    "                // databases (which are deleted when the connections are closed). It doesn't make sense to use\n"
    "                // connection pool for the latter two types of databases, because each connection connects to a\n"
    "                //different in-memory or temporary SQLite database.\n"
    "                if ($this->config->getDbname() === '') {\n"
    "                    throw new \\Exception('Connection pool in Swoole does not support temporary SQLite databases.');\n"
    "                }\n"
    "                if ($this->config->getDbname() === ':memory:') {\n"
    "                    throw new \\Exception('Connection pool in Swoole does not support creating SQLite databases in memory.');\n"
    "                }\n"
    "                $dsn = 'sqlite:' . $this->config->getDbname();\n"
    "                break;\n"
    "            default:\n"
    "                throw new \\Exception('Unsupported Database Driver:' . $driver);\n"
    "        }\n"
    "        return $dsn;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_pdo_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "/**\n"
    " * @method \\PDO __getObject()\n"
    " */\n"
    "class PDOProxy extends ObjectProxy\n"
    "{\n"
    "    /** @var \\PDO */\n"
    "    protected $__object;\n"
    "\n"
    "    protected array $setAttributeContext = [];\n"
    "\n"
    "    /** @var callable */\n"
    "    protected $constructor;\n"
    "\n"
    "    protected int $round = 0;\n"
    "\n"
    "    protected int $inTransaction = 0;\n"
    "\n"
    "    public function __construct(callable $constructor)\n"
    "    {\n"
    "        parent::__construct($constructor());\n"
    "        $this->__object->setAttribute(\\PDO::ATTR_ERRMODE, \\PDO::ERRMODE_EXCEPTION);\n"
    "        $this->constructor = $constructor;\n"
    "    }\n"
    "\n"
    "    public function __call(string $name, array $arguments)\n"
    "    {\n"
    "        try {\n"
    "            $ret = $this->__object->{$name}(...$arguments);\n"
    "        } catch (\\PDOException $e) {\n"
    "            if (!$this->__object->inTransaction() && DetectsLostConnections::causedByLostConnection($e)) {\n"
    "                $this->reconnect();\n"
    "                $ret = $this->__object->{$name}(...$arguments);\n"
    "            } else {\n"
    "                throw $e;\n"
    "            }\n"
    "        }\n"
    "\n"
    "        if (strcasecmp($name, 'beginTransaction') === 0) {\n"
    "            $this->inTransaction++;\n"
    "        }\n"
    "\n"
    "        if ((strcasecmp($name, 'commit') === 0 || strcasecmp($name, 'rollback') === 0) && $this->inTransaction > 0) {\n"
    "            $this->inTransaction--;\n"
    "        }\n"
    "\n"
    "        if ((strcasecmp($name, 'prepare') === 0) || (strcasecmp($name, 'query') === 0)) {\n"
    "            $ret = new PDOStatementProxy($ret, $this);\n"
    "        }\n"
    "\n"
    "        return $ret;\n"
    "    }\n"
    "\n"
    "    public function getRound(): int\n"
    "    {\n"
    "        return $this->round;\n"
    "    }\n"
    "\n"
    "    public function reconnect(): void\n"
    "    {\n"
    "        $constructor = $this->constructor;\n"
    "        parent::__construct($constructor());\n"
    "        $this->__object->setAttribute(\\PDO::ATTR_ERRMODE, \\PDO::ERRMODE_EXCEPTION);\n"
    "        $this->round++;\n"
    "        /* restore context */\n"
    "        foreach ($this->setAttributeContext as $attribute => $value) {\n"
    "            $this->__object->setAttribute($attribute, $value);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function setAttribute(int $attribute, $value): bool\n"
    "    {\n"
    "        $this->setAttributeContext[$attribute] = $value;\n"
    "        return $this->__object->setAttribute($attribute, $value);\n"
    "    }\n"
    "\n"
    "    public function inTransaction(): bool\n"
    "    {\n"
    "        return $this->inTransaction > 0;\n"
    "    }\n"
    "\n"
    "    public function reset(): void\n"
    "    {\n"
    "        $this->inTransaction = 0;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_pdo_statement_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "/**\n"
    " * The proxy class for PHP class PDOStatement.\n"
    " *\n"
    " * @see https://www.php.net/PDOStatement The PDOStatement class\n"
    " */\n"
    "class PDOStatementProxy extends ObjectProxy\n"
    "{\n"
    "    /** @var \\PDOStatement */\n"
    "    protected $__object;\n"
    "\n"
    "    protected array $setAttributeContext = [];\n"
    "\n"
    "    protected array $setFetchModeContext;\n"
    "\n"
    "    protected array $bindParamContext = [];\n"
    "\n"
    "    protected array $bindColumnContext = [];\n"
    "\n"
    "    protected array $bindValueContext = [];\n"
    "\n"
    "    protected PDOProxy $parent;\n"
    "\n"
    "    /** @var int */\n"
    "    protected $parentRound;\n"
    "\n"
    "    public function __construct(\\PDOStatement $object, PDOProxy $parent)\n"
    "    {\n"
    "        parent::__construct($object);\n"
    "        $this->parent      = $parent;\n"
    "        $this->parentRound = $parent->getRound();\n"
    "    }\n"
    "\n"
    "    public function __call(string $name, array $arguments)\n"
    "    {\n"
    "        try {\n"
    "            $ret = $this->__object->{$name}(...$arguments);\n"
    "        } catch (\\PDOException $e) {\n"
    "            if (!$this->parent->inTransaction() && DetectsLostConnections::causedByLostConnection($e)) {\n"
    "                if ($this->parent->getRound() === $this->parentRound) {\n"
    "                    /* if not equal, parent has reconnected */\n"
    "                    $this->parent->reconnect();\n"
    "                }\n"
    "                $parent         = $this->parent->__getObject();\n"
    "                $this->__object = $parent->prepare($this->__object->queryString);\n"
    "\n"
    "                foreach ($this->setAttributeContext as $attribute => $value) {\n"
    "                    $this->__object->setAttribute($attribute, $value);\n"
    "                }\n"
    "                if (!empty($this->setFetchModeContext)) {\n"
    "                    $this->__object->setFetchMode(...$this->setFetchModeContext);\n"
    "                }\n"
    "                foreach ($this->bindParamContext as $param => $item) {\n"
    "                    $this->__object->bindParam($param, ...$item);\n"
    "                }\n"
    "                foreach ($this->bindColumnContext as $column => $item) {\n"
    "                    $this->__object->bindColumn($column, ...$item);\n"
    "                }\n"
    "                foreach ($this->bindValueContext as $value => $item) {\n"
    "                    $this->__object->bindParam($value, ...$item);\n"
    "                }\n"
    "                $ret = $this->__object->{$name}(...$arguments);\n"
    "            } else {\n"
    "                throw $e;\n"
    "            }\n"
    "        }\n"
    "\n"
    "        return $ret;\n"
    "    }\n"
    "\n"
    "    public function setAttribute(int $attribute, $value): bool\n"
    "    {\n"
    "        $this->setAttributeContext[$attribute] = $value;\n"
    "        return $this->__object->setAttribute($attribute, $value);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Set the default fetch mode for this statement.\n"
    "     *\n"
    "     * @see https://www.php.net/manual/en/pdostatement.setfetchmode.php\n"
    "     */\n"
    "    public function setFetchMode(int $mode, ...$params): bool\n"
    "    {\n"
    "        $this->setFetchModeContext = func_get_args();\n"
    "        return $this->__object->setFetchMode(...$this->setFetchModeContext);\n"
    "    }\n"
    "\n"
    "    public function bindParam($parameter, &$variable, $data_type = \\PDO::PARAM_STR, $length = 0, $driver_options = null): bool\n"
    "    {\n"
    "        $this->bindParamContext[$parameter] = [$variable, $data_type, $length, $driver_options];\n"
    "        return $this->__object->bindParam($parameter, $variable, $data_type, $length, $driver_options);\n"
    "    }\n"
    "\n"
    "    public function bindColumn($column, &$param, $type = null, $maxlen = null, $driverdata = null): bool\n"
    "    {\n"
    "        $this->bindColumnContext[$column] = [$param, $type, $maxlen, $driverdata];\n"
    "        return $this->__object->bindColumn($column, $param, $type, $maxlen, $driverdata);\n"
    "    }\n"
    "\n"
    "    public function bindValue($parameter, $value, $data_type = \\PDO::PARAM_STR): bool\n"
    "    {\n"
    "        $this->bindValueContext[$parameter] = [$value, $data_type];\n"
    "        return $this->__object->bindValue($parameter, $value, $data_type);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_redis_config =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "class RedisConfig\n"
    "{\n"
    "    protected string $host = '127.0.0.1';\n"
    "\n"
    "    protected int $port = 6379;\n"
    "\n"
    "    protected float $timeout = 0.0;\n"
    "\n"
    "    protected string $reserved = '';\n"
    "\n"
    "    protected int $retry_interval = 0;\n"
    "\n"
    "    protected float $read_timeout = 0.0;\n"
    "\n"
    "    protected string $auth = '';\n"
    "\n"
    "    protected int $dbIndex = 0;\n"
    "\n"
    "    /**\n"
    "     * @var array<int, mixed>\n"
    "     */\n"
    "    protected array $options = [];\n"
    "\n"
    "    public function getHost(): string\n"
    "    {\n"
    "        return $this->host;\n"
    "    }\n"
    "\n"
    "    public function withHost(string $host): self\n"
    "    {\n"
    "        $this->host = $host;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getPort(): int\n"
    "    {\n"
    "        return $this->port;\n"
    "    }\n"
    "\n"
    "    public function withPort(int $port): self\n"
    "    {\n"
    "        $this->port = $port;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getTimeout(): float\n"
    "    {\n"
    "        return $this->timeout;\n"
    "    }\n"
    "\n"
    "    public function withTimeout(float $timeout): self\n"
    "    {\n"
    "        $this->timeout = $timeout;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getReserved(): string\n"
    "    {\n"
    "        return $this->reserved;\n"
    "    }\n"
    "\n"
    "    public function withReserved(string $reserved): self\n"
    "    {\n"
    "        $this->reserved = $reserved;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getRetryInterval(): int\n"
    "    {\n"
    "        return $this->retry_interval;\n"
    "    }\n"
    "\n"
    "    public function withRetryInterval(int $retry_interval): self\n"
    "    {\n"
    "        $this->retry_interval = $retry_interval;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getReadTimeout(): float\n"
    "    {\n"
    "        return $this->read_timeout;\n"
    "    }\n"
    "\n"
    "    public function withReadTimeout(float $read_timeout): self\n"
    "    {\n"
    "        $this->read_timeout = $read_timeout;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getAuth(): string\n"
    "    {\n"
    "        return $this->auth;\n"
    "    }\n"
    "\n"
    "    public function withAuth(string $auth): self\n"
    "    {\n"
    "        $this->auth = $auth;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getDbIndex(): int\n"
    "    {\n"
    "        return $this->dbIndex;\n"
    "    }\n"
    "\n"
    "    public function withDbIndex(int $dbIndex): self\n"
    "    {\n"
    "        $this->dbIndex = $dbIndex;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Add a configurable option.\n"
    "     */\n"
    "    public function withOption(int $option, mixed $value): self\n"
    "    {\n"
    "        $this->options[$option] = $value;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Add/override configurable options.\n"
    "     *\n"
    "     * @param array<int, mixed> $options\n"
    "     */\n"
    "    public function setOptions(array $options): self\n"
    "    {\n"
    "        $this->options = $options;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Get configurable options.\n"
    "     *\n"
    "     * @return array<int, mixed>\n"
    "     */\n"
    "    public function getOptions(): array\n"
    "    {\n"
    "        return $this->options;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_redis_pool =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use Redis;\n"
    "use Swoole\\ConnectionPool;\n"
    "\n"
    "/**\n"
    " * @method \\Redis get(float $timeout = -1)\n"
    " * @method void put(Redis $connection)\n"
    " */\n"
    "class RedisPool extends ConnectionPool\n"
    "{\n"
    "    public function __construct(protected RedisConfig $config, int $size = self::DEFAULT_SIZE)\n"
    "    {\n"
    "        parent::__construct(function () {\n"
    "            $redis = new \\Redis();\n"
    "            /* Compatible with different versions of Redis extension as much as possible */\n"
    "            $arguments = [\n"
    "                $this->config->getHost(),\n"
    "                $this->config->getPort(),\n"
    "            ];\n"
    "            if ($this->config->getTimeout() !== 0.0) {\n"
    "                $arguments[] = $this->config->getTimeout();\n"
    "            }\n"
    "            if ($this->config->getRetryInterval() !== 0) {\n"
    "                /* reserved should always be NULL */\n"
    "                $arguments[] = null;\n"
    "                $arguments[] = $this->config->getRetryInterval();\n"
    "            }\n"
    "            if ($this->config->getReadTimeout() !== 0.0) {\n"
    "                $arguments[] = $this->config->getReadTimeout();\n"
    "            }\n"
    "            $redis->connect(...$arguments);\n"
    "            if ($this->config->getAuth()) {\n"
    "                $redis->auth($this->config->getAuth());\n"
    "            }\n"
    "            if ($this->config->getDbIndex() !== 0) {\n"
    "                $redis->select($this->config->getDbIndex());\n"
    "            }\n"
    "\n"
    "            /* Set Redis options. */\n"
    "            foreach ($this->config->getOptions() as $key => $value) {\n"
    "                $redis->setOption($key, $value);\n"
    "            }\n"
    "\n"
    "            return $redis;\n"
    "        }, $size);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_http_status =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Http;\n"
    "\n"
    "abstract class Status\n"
    "{\n"
    "    public const CONTINUE = 100;\n"
    "\n"
    "    public const SWITCHING_PROTOCOLS = 101;\n"
    "\n"
    "    public const PROCESSING = 102;\n"
    "\n"
    "    public const OK = 200;\n"
    "\n"
    "    public const CREATED = 201;\n"
    "\n"
    "    public const ACCEPTED = 202;\n"
    "\n"
    "    public const NON_AUTHORITATIVE_INFORMATION = 203;\n"
    "\n"
    "    public const NO_CONTENT = 204;\n"
    "\n"
    "    public const RESET_CONTENT = 205;\n"
    "\n"
    "    public const PARTIAL_CONTENT = 206;\n"
    "\n"
    "    public const MULTI_STATUS = 207;\n"
    "\n"
    "    public const ALREADY_REPORTED = 208;\n"
    "\n"
    "    public const IM_USED = 226;\n"
    "\n"
    "    public const MULTIPLE_CHOICES = 300;\n"
    "\n"
    "    public const MOVED_PERMANENTLY = 301;\n"
    "\n"
    "    public const FOUND = 302;\n"
    "\n"
    "    public const SEE_OTHER = 303;\n"
    "\n"
    "    public const NOT_MODIFIED = 304;\n"
    "\n"
    "    public const USE_PROXY = 305;\n"
    "\n"
    "    public const SWITCH_PROXY = 306;\n"
    "\n"
    "    public const TEMPORARY_REDIRECT = 307;\n"
    "\n"
    "    public const PERMANENT_REDIRECT = 308;\n"
    "\n"
    "    public const BAD_REQUEST = 400;\n"
    "\n"
    "    public const UNAUTHORIZED = 401;\n"
    "\n"
    "    public const PAYMENT_REQUIRED = 402;\n"
    "\n"
    "    public const FORBIDDEN = 403;\n"
    "\n"
    "    public const NOT_FOUND = 404;\n"
    "\n"
    "    public const METHOD_NOT_ALLOWED = 405;\n"
    "\n"
    "    public const NOT_ACCEPTABLE = 406;\n"
    "\n"
    "    public const PROXY_AUTHENTICATION_REQUIRED = 407;\n"
    "\n"
    "    public const REQUEST_TIME_OUT = 408;\n"
    "\n"
    "    public const CONFLICT = 409;\n"
    "\n"
    "    public const GONE = 410;\n"
    "\n"
    "    public const LENGTH_REQUIRED = 411;\n"
    "\n"
    "    public const PRECONDITION_FAILED = 412;\n"
    "\n"
    "    public const REQUEST_ENTITY_TOO_LARGE = 413;\n"
    "\n"
    "    public const REQUEST_URI_TOO_LARGE = 414;\n"
    "\n"
    "    public const UNSUPPORTED_MEDIA_TYPE = 415;\n"
    "\n"
    "    public const REQUESTED_RANGE_NOT_SATISFIABLE = 416;\n"
    "\n"
    "    public const EXPECTATION_FAILED = 417;\n"
    "\n"
    "    public const MISDIRECTED_REQUEST = 421;\n"
    "\n"
    "    public const UNPROCESSABLE_ENTITY = 422;\n"
    "\n"
    "    public const LOCKED = 423;\n"
    "\n"
    "    public const FAILED_DEPENDENCY = 424;\n"
    "\n"
    "    public const UNORDERED_COLLECTION = 425;\n"
    "\n"
    "    public const UPGRADE_REQUIRED = 426;\n"
    "\n"
    "    public const PRECONDITION_REQUIRED = 428;\n"
    "\n"
    "    public const TOO_MANY_REQUESTS = 429;\n"
    "\n"
    "    public const REQUEST_HEADER_FIELDS_TOO_LARGE = 431;\n"
    "\n"
    "    public const UNAVAILABLE_FOR_LEGAL_REASONS = 451;\n"
    "\n"
    "    public const INTERNAL_SERVER_ERROR = 500;\n"
    "\n"
    "    public const NOT_IMPLEMENTED = 501;\n"
    "\n"
    "    public const BAD_GATEWAY = 502;\n"
    "\n"
    "    public const SERVICE_UNAVAILABLE = 503;\n"
    "\n"
    "    public const GATEWAY_TIME_OUT = 504;\n"
    "\n"
    "    public const HTTP_VERSION_NOT_SUPPORTED = 505;\n"
    "\n"
    "    public const VARIANT_ALSO_NEGOTIATES = 506;\n"
    "\n"
    "    public const INSUFFICIENT_STORAGE = 507;\n"
    "\n"
    "    public const LOOP_DETECTED = 508;\n"
    "\n"
    "    public const NOT_EXTENDED = 510;\n"
    "\n"
    "    public const NETWORK_AUTHENTICATION_REQUIRED = 511;\n"
    "\n"
    "    protected static $reasonPhrases = [\n"
    "        self::CONTINUE                        => 'Continue',\n"
    "        self::SWITCHING_PROTOCOLS             => 'Switching Protocols',\n"
    "        self::PROCESSING                      => 'Processing',\n"
    "        self::OK                              => 'OK',\n"
    "        self::CREATED                         => 'Created',\n"
    "        self::ACCEPTED                        => 'Accepted',\n"
    "        self::NON_AUTHORITATIVE_INFORMATION   => 'Non-Authoritative Information',\n"
    "        self::NO_CONTENT                      => 'No Content',\n"
    "        self::RESET_CONTENT                   => 'Reset Content',\n"
    "        self::PARTIAL_CONTENT                 => 'Partial Content',\n"
    "        self::MULTI_STATUS                    => 'Multi-status',\n"
    "        self::ALREADY_REPORTED                => 'Already Reported',\n"
    "        self::IM_USED                         => 'IM Used',\n"
    "        self::MULTIPLE_CHOICES                => 'Multiple Choices',\n"
    "        self::MOVED_PERMANENTLY               => 'Moved Permanently',\n"
    "        self::FOUND                           => 'Found',\n"
    "        self::SEE_OTHER                       => 'See Other',\n"
    "        self::NOT_MODIFIED                    => 'Not Modified',\n"
    "        self::USE_PROXY                       => 'Use Proxy',\n"
    "        self::SWITCH_PROXY                    => 'Switch Proxy',\n"
    "        self::TEMPORARY_REDIRECT              => 'Temporary Redirect',\n"
    "        self::PERMANENT_REDIRECT              => 'Permanent Redirect',\n"
    "        self::BAD_REQUEST                     => 'Bad Request',\n"
    "        self::UNAUTHORIZED                    => 'Unauthorized',\n"
    "        self::PAYMENT_REQUIRED                => 'Payment Required',\n"
    "        self::FORBIDDEN                       => 'Forbidden',\n"
    "        self::NOT_FOUND                       => 'Not Found',\n"
    "        self::METHOD_NOT_ALLOWED              => 'Method Not Allowed',\n"
    "        self::NOT_ACCEPTABLE                  => 'Not Acceptable',\n"
    "        self::PROXY_AUTHENTICATION_REQUIRED   => 'Proxy Authentication Required',\n"
    "        self::REQUEST_TIME_OUT                => 'Request Time-out',\n"
    "        self::CONFLICT                        => 'Conflict',\n"
    "        self::GONE                            => 'Gone',\n"
    "        self::LENGTH_REQUIRED                 => 'Length Required',\n"
    "        self::PRECONDITION_FAILED             => 'Precondition Failed',\n"
    "        self::REQUEST_ENTITY_TOO_LARGE        => 'Request Entity Too Large',\n"
    "        self::REQUEST_URI_TOO_LARGE           => 'Request-URI Too Large',\n"
    "        self::UNSUPPORTED_MEDIA_TYPE          => 'Unsupported Media Type',\n"
    "        self::REQUESTED_RANGE_NOT_SATISFIABLE => 'Requested range not satisfiable',\n"
    "        self::EXPECTATION_FAILED              => 'Expectation Failed',\n"
    "        self::MISDIRECTED_REQUEST             => 'Misdirected Request',\n"
    "        self::UNPROCESSABLE_ENTITY            => 'Unprocessable Entity',\n"
    "        self::LOCKED                          => 'Locked',\n"
    "        self::FAILED_DEPENDENCY               => 'Failed Dependency',\n"
    "        self::UNORDERED_COLLECTION            => 'Unordered Collection',\n"
    "        self::UPGRADE_REQUIRED                => 'Upgrade Required',\n"
    "        self::PRECONDITION_REQUIRED           => 'Precondition Required',\n"
    "        self::TOO_MANY_REQUESTS               => 'Too Many Requests',\n"
    "        self::REQUEST_HEADER_FIELDS_TOO_LARGE => 'Request Header Fields Too Large',\n"
    "        self::UNAVAILABLE_FOR_LEGAL_REASONS   => 'Unavailable For Legal Reasons',\n"
    "        self::INTERNAL_SERVER_ERROR           => 'Internal Server Error',\n"
    "        self::NOT_IMPLEMENTED                 => 'Not Implemented',\n"
    "        self::BAD_GATEWAY                     => 'Bad Gateway',\n"
    "        self::SERVICE_UNAVAILABLE             => 'Service Unavailable',\n"
    "        self::GATEWAY_TIME_OUT                => 'Gateway Time-out',\n"
    "        self::HTTP_VERSION_NOT_SUPPORTED      => 'HTTP Version not supported',\n"
    "        self::VARIANT_ALSO_NEGOTIATES         => 'Variant Also Negotiates',\n"
    "        self::INSUFFICIENT_STORAGE            => 'Insufficient Storage',\n"
    "        self::LOOP_DETECTED                   => 'Loop Detected',\n"
    "        self::NOT_EXTENDED                    => 'Not Extended',\n"
    "        self::NETWORK_AUTHENTICATION_REQUIRED => 'Network Authentication Required',\n"
    "    ];\n"
    "\n"
    "    public static function getReasonPhrases(): array\n"
    "    {\n"
    "        return static::$reasonPhrases;\n"
    "    }\n"
    "\n"
    "    public static function getReasonPhrase(int $value): string\n"
    "    {\n"
    "        return static::$reasonPhrases[$value] ?? 'Unknown';\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_curl_exception =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Curl;\n"
    "\n"
    "use Swoole;\n"
    "\n"
    "class Exception extends Swoole\\Exception\n"
    "{\n"
    "}\n";

static const char* swoole_library_source_core_curl_handler =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "/* @noinspection PhpComposerExtensionStubsInspection, PhpDuplicateSwitchCaseBodyInspection, PhpInconsistentReturnPointsInspection */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Curl;\n"
    "\n"
    "use Swoole\\Constant;\n"
    "use Swoole\\Coroutine\\Http\\Client;\n"
    "use Swoole\\Coroutine\\System;\n"
    "use Swoole\\Curl\\Exception as CurlException;\n"
    "use Swoole\\Http\\Status;\n"
    "\n"
    "final class Handler implements \\Stringable\n"
    "{\n"
    "    /**\n"
    "     * @var Client|null\n"
    "     */\n"
    "    private $client;\n"
    "\n"
    "    private $info = [\n"
    "        'url'                     => '',\n"
    "        'content_type'            => '',\n"
    "        'http_code'               => 0,\n"
    "        'header_size'             => 0,\n"
    "        'request_size'            => 0,\n"
    "        'filetime'                => -1,\n"
    "        'ssl_verify_result'       => 0,\n"
    "        'redirect_count'          => 0,\n"
    "        'total_time'              => 5.3E-5,\n"
    "        'namelookup_time'         => 0.0,\n"
    "        'connect_time'            => 0.0,\n"
    "        'pretransfer_time'        => 0.0,\n"
    "        'size_upload'             => 0.0,\n"
    "        'size_download'           => 0.0,\n"
    "        'speed_download'          => 0.0,\n"
    "        'speed_upload'            => 0.0,\n"
    "        'download_content_length' => -1.0,\n"
    "        'upload_content_length'   => -1.0,\n"
    "        'starttransfer_time'      => 0.0,\n"
    "        'redirect_time'           => 0.0,\n"
    "        'redirect_url'            => '',\n"
    "        'primary_ip'              => '',\n"
    "        'certinfo'                => [],\n"
    "        'primary_port'            => 0,\n"
    "        'local_ip'                => '',\n"
    "        'local_port'              => 0,\n"
    "        'http_version'            => 0,\n"
    "        'protocol'                => 0,\n"
    "        'ssl_verifyresult'        => 0,\n"
    "        'scheme'                  => '',\n"
    "        'private'                 => '',\n"
    "    ];\n"
    "\n"
    "    private $withHeaderOut = false;\n"
    "\n"
    "    private $withFileTime = false;\n"
    "\n"
    "    private $urlInfo;\n"
    "\n"
    "    private $postData;\n"
    "\n"
    "    private $infile;\n"
    "\n"
    "    private $infileSize = PHP_INT_MAX;\n"
    "\n"
    "    private $outputStream;\n"
    "\n"
    "    private $proxyType;\n"
    "\n"
    "    private $proxy;\n"
    "\n"
    "    private $proxyPort = 1080;\n"
    "\n"
    "    private $proxyUsername;\n"
    "\n"
    "    private $proxyPassword;\n"
    "\n"
    "    private $clientOptions = [];\n"
    "\n"
    "    private $followLocation = false;\n"
    "\n"
    "    private $autoReferer = false;\n"
    "\n"
    "    private $maxRedirects;\n"
    "\n"
    "    private $withHeader = false;\n"
    "\n"
    "    private $nobody = false;\n"
    "\n"
    "    /** @var callable|null */\n"
    "    private $headerFunction;\n"
    "\n"
    "    /** @var callable|null */\n"
    "    private $readFunction;\n"
    "\n"
    "    /** @var callable|null */\n"
    "    private $writeFunction;\n"
    "\n"
    "    private $noProgress = true;\n"
    "\n"
    "    /** @var callable */\n"
    "    private $progressFunction;\n"
    "\n"
    "    private $returnTransfer = false;\n"
    "\n"
    "    private $method = '';\n"
    "\n"
    "    private $headers = [];\n"
    "\n"
    "    private $headerMap = [];\n"
    "\n"
    "    private $transfer;\n"
    "\n"
    "    private $errCode = 0;\n"
    "\n"
    "    private $errMsg = '';\n"
    "\n"
    "    private $failOnError = false;\n"
    "\n"
    "    private $closed = false;\n"
    "\n"
    "    private $cookieJar = '';\n"
    "\n"
    "    private $resolve = [];\n"
    "\n"
    "    private $unix_socket_path = '';\n"
    "\n"
    "    public function __construct(string $url = '')\n"
    "    {\n"
    "        if ($url) {\n"
    "            $this->setUrl($url);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function __toString(): string\n"
    "    {\n"
    "        $id = spl_object_id($this);\n"
    "        return \"Object({$id}) of type (curl)\";\n"
    "    }\n"
    "\n"
    "    /* ====== Public APIs ====== */\n"
    "\n"
    "    public function isAvailable(): bool\n"
    "    {\n"
    "        if ($this->closed) {\n"
    "            trigger_error('supplied resource is not a valid cURL handle resource', E_USER_WARNING);\n"
    "            return false;\n"
    "        }\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    public function setOpt(int $opt, $value): bool\n"
    "    {\n"
    "        return $this->isAvailable() and $this->setOption($opt, $value);\n"
    "    }\n"
    "\n"
    "    public function exec()\n"
    "    {\n"
    "        if (!$this->isAvailable()) {\n"
    "            return false;\n"
    "        }\n"
    "        return $this->execute();\n"
    "    }\n"
    "\n"
    "    public function getInfo()\n"
    "    {\n"
    "        return $this->isAvailable() ? $this->info : false;\n"
    "    }\n"
    "\n"
    "    public function errno(): int\n"
    "    {\n"
    "        return $this->isAvailable() ? $this->errCode : 0;\n"
    "    }\n"
    "\n"
    "    public function error(): string\n"
    "    {\n"
    "        return $this->isAvailable() ? $this->errMsg : '';\n"
    "    }\n"
    "\n"
    "    public function reset()\n"
    "    {\n"
    "        if (!$this->isAvailable()) {\n"
    "            return false;\n"
    "        }\n"
    "        foreach ((new \\ReflectionClass(self::class))->getDefaultProperties() as $name => $value) {\n"
    "            $this->{$name} = $value;\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function getContent()\n"
    "    {\n"
    "        if (!$this->isAvailable()) {\n"
    "            return false;\n"
    "        }\n"
    "        return $this->transfer;\n"
    "    }\n"
    "\n"
    "    public function close(): void\n"
    "    {\n"
    "        if (!$this->isAvailable()) {\n"
    "            return;\n"
    "        }\n"
    "        foreach ($this as &$property) { // @phpstan-ignore foreach.nonIterable\n"
    "            $property = null;\n"
    "        }\n"
    "        $this->closed = true;\n"
    "    }\n"
    "\n"
    "    private function create(?array $urlInfo = null): void\n"
    "    {\n"
    "        if ($urlInfo === null) {\n"
    "            $urlInfo = $this->urlInfo;\n"
    "        }\n"
    "        $host = $urlInfo['host'];\n"
    "        $port = $urlInfo['port'];\n"
    "        if (isset($this->resolve[$host])) {\n"
    "            if (!$this->hasHeader('Host')) {\n"
    "                $this->setHeader('Host', $host);\n"
    "            }\n"
    "            $this->urlInfo['host'] = $host = $this->resolve[$host][$port] ?? null ?: $host;\n"
    "        }\n"
    "        if ($this->unix_socket_path) {\n"
    "            $host = $this->unix_socket_path;\n"
    "            $port = 0;\n"
    "            if (stripos($host, 'unix:/') !== 0) {\n"
    "                $host = \"unix:/{$host}\";\n"
    "            }\n"
    "        }\n"
    "        $this->client = new Client($host, $port, $urlInfo['scheme'] === 'https');\n"
    "    }\n"
    "\n"
    "    private function getUrl(): string\n"
    "    {\n"
    "        if (empty($this->urlInfo['path'])) {\n"
    "            $url = '/';\n"
    "        } else {\n"
    "            $url = $this->urlInfo['path'];\n"
    "        }\n"
    "        if (!empty($this->urlInfo['query'])) {\n"
    "            $url .= '?' . $this->urlInfo['query'];\n"
    "        }\n"
    "        if (!empty($this->urlInfo['fragment'])) {\n"
    "            $url .= '#' . $this->urlInfo['fragment'];\n"
    "        }\n"
    "        return $url;\n"
    "    }\n"
    "\n"
    "    private function setUrl(string $url, bool $setInfo = true): bool\n"
    "    {\n"
    "        if (strlen($url) === 0) {\n"
    "            $this->setError(CURLE_URL_MALFORMAT, 'No URL set!');\n"
    "            return false;\n"
    "        }\n"
    "        if (!str_contains($url, '://') && $this->unix_socket_path === '') {\n"
    "            $url = 'http://' . $url;\n"
    "        }\n"
    "        if ($setInfo) {\n"
    "            $urlInfo = parse_url($url);\n"
    "            if ($this->unix_socket_path) {\n"
    "                if (empty($urlInfo['host']) && !empty($urlInfo['path'])) {\n"
    "                    $urlInfo['host'] = explode('/', $urlInfo['path'])[1] ?? null;\n"
    "                }\n"
    "                if (!$this->hasHeader('Host') && !empty($urlInfo['host'])) {\n"
    "                    $this->setHeader('Host', $urlInfo['host']);\n"
    "                }\n"
    "            }\n"
    "            if (!is_array($urlInfo)) {\n"
    "                $this->setError(CURLE_URL_MALFORMAT, \"URL[{$url}] using bad/illegal format\");\n"
    "                return false;\n"
    "            }\n"
    "            if (!$this->setUrlInfo($urlInfo)) {\n"
    "                return false;\n"
    "            }\n"
    "        }\n"
    "        $this->info['url'] = $url;\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    private function setUrlInfo(array $urlInfo): bool\n"
    "    {\n"
    "        if (empty($urlInfo['scheme'])) {\n"
    "            $urlInfo['scheme'] = 'http';\n"
    "        }\n"
    "        $scheme = $urlInfo['scheme'];\n"
    "        if ($scheme !== 'http' and $scheme !== 'https') {\n"
    "            $this->setError(CURLE_UNSUPPORTED_PROTOCOL, \"Protocol \\\"{$scheme}\\\" not supported or disabled in libcurl\");\n"
    "            return false;\n"
    "        }\n"
    "        $host = $urlInfo['host'];\n"
    "        if ($this->info['primary_port'] !== 0) {\n"
    "            /* keep same with cURL, primary_port has the highest priority */\n"
    "            $urlInfo['port'] = $this->info['primary_port'];\n"
    "        } elseif (empty($urlInfo['port'])) {\n"
    "            $urlInfo['port'] = $scheme === 'https' ? 443 : 80;\n"
    "        } else {\n"
    "            $urlInfo['port'] = intval($urlInfo['port']);\n"
    "        }\n"
    "        $port = $urlInfo['port'];\n"
    "        if (isset($this->client)) {\n"
    "            $oldUrlInfo = $this->urlInfo;\n"
    "            if (($host !== $oldUrlInfo['host']) || ($port !== $oldUrlInfo['port']) || ($scheme !== $oldUrlInfo['scheme'])) {\n"
    "                /* target changed */\n"
    "                $this->create($urlInfo);\n"
    "            }\n"
    "        }\n"
    "        $this->urlInfo = $urlInfo;\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    private function setPort(int $port): void\n"
    "    {\n"
    "        $this->info['primary_port'] = $port;\n"
    "        if (!isset($this->urlInfo['port']) || $this->urlInfo['port'] !== $port) {\n"
    "            $this->urlInfo['port'] = $port;\n"
    "            if (isset($this->client)) {\n"
    "                /* target changed */\n"
    "                $this->create();\n"
    "            }\n"
    "        }\n"
    "    }\n"
    "\n"
    "    private function setError($code, $msg = ''): void\n"
    "    {\n"
    "        $this->errCode = $code;\n"
    "        $this->errMsg  = $msg ?: curl_strerror($code);\n"
    "    }\n"
    "\n"
    "    private function hasHeader(string $headerName): bool\n"
    "    {\n"
    "        return isset($this->headerMap[strtolower($headerName)]);\n"
    "    }\n"
    "\n"
    "    private function setHeader(string $headerName, string $value): void\n"
    "    {\n"
    "        $lowerCaseHeaderName = strtolower($headerName);\n"
    "\n"
    "        if (isset($this->headerMap[$lowerCaseHeaderName])) {\n"
    "            unset($this->headers[$this->headerMap[$lowerCaseHeaderName]]);\n"
    "        }\n"
    "\n"
    "        if ($value !== '') {\n"
    "            $this->headers[$headerName]            = $value;\n"
    "            $this->headerMap[$lowerCaseHeaderName] = $headerName;\n"
    "        } else {\n"
    "            // remove empty headers (keep same with raw cURL)\n"
    "            unset($this->headerMap[$lowerCaseHeaderName]);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @throws Exception\n"
    "     */\n"
    "    private function setOption(int $opt, mixed $value): bool\n"
    "    {\n"
    "        switch ($opt) {\n"
    "            // case CURLOPT_STDERR:\n"
    "            // case CURLOPT_WRITEHEADER:\n"
    "            case CURLOPT_FILE:\n"
    "            case CURLOPT_INFILE:\n"
    "                if (!is_resource($value)) {\n"
    "                    trigger_error('swoole_curl_setopt(): supplied argument is not a valid File-Handle resource', E_USER_WARNING);\n"
    "                    return false;\n"
    "                }\n"
    "                break;\n"
    "        }\n"
    "\n"
    "        switch ($opt) {\n"
    "            /*\n"
    "             * Basic\n"
    "             */\n"
    "            case CURLOPT_URL:\n"
    "                return $this->setUrl((string) $value);\n"
    "            case CURLOPT_PORT:\n"
    "                $this->setPort((int) $value);\n"
    "                break;\n"
    "            case CURLOPT_FORBID_REUSE:\n"
    "                $this->clientOptions[Constant::OPTION_KEEP_ALIVE] = !$value;\n"
    "                break;\n"
    "            case CURLOPT_RETURNTRANSFER:\n"
    "                $this->returnTransfer = (bool) $value;\n"
    "                $this->transfer       = '';\n"
    "                break;\n"
    "            case CURLOPT_ENCODING:\n"
    "                if (empty($value)) {\n"
    "                    if (defined('SWOOLE_HAVE_ZLIB')) {\n"
    "                        $value = 'gzip, deflate';\n"
    "                    }\n"
    "                    if (defined('SWOOLE_HAVE_BROTLI')) {\n"
    "                        if (!empty($value)) {\n"
    "                            $value = 'br, ' . $value;\n"
    "                        } else {\n"
    "                            $value = 'br';\n"
    "                        }\n"
    "                    }\n"
    "                    if (empty($value)) {\n"
    "                        break;\n"
    "                    }\n"
    "                }\n"
    "                $this->setHeader('Accept-Encoding', $value);\n"
    "                break;\n"
    "            case CURLOPT_PROXYTYPE:\n"
    "                if ($value !== CURLPROXY_HTTP and $value !== CURLPROXY_SOCKS5) {\n"
    "                    throw new CurlException('swoole_curl_setopt(): Only support following CURLOPT_PROXYTYPE values: CURLPROXY_HTTP, CURLPROXY_SOCKS5');\n"
    "                }\n"
    "                $this->proxyType = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXY:\n"
    "                $this->proxy = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXYPORT:\n"
    "                $this->proxyPort = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXYUSERNAME:\n"
    "                $this->proxyUsername = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXYPASSWORD:\n"
    "                $this->proxyPassword = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXYUSERPWD:\n"
    "                $usernamePassword    = explode(':', $value);\n"
    "                $this->proxyUsername = urldecode($usernamePassword[0]);\n"
    "                $this->proxyPassword = urldecode($usernamePassword[1] ?? null);\n"
    "                break;\n"
    "            case CURLOPT_PROXYAUTH:\n"
    "                /* ignored temporarily */\n"
    "                break;\n"
    "            case CURLOPT_UNIX_SOCKET_PATH:\n"
    "                $realpath = realpath((string) $value);\n"
    "                if ($realpath) {\n"
    "                    $this->unix_socket_path = $realpath;\n"
    "                } else {\n"
    "                    $this->setError(CURLE_COULDNT_CONNECT);\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_NOBODY:\n"
    "                $this->nobody = boolval($value);\n"
    "                $this->method = 'HEAD';\n"
    "                break;\n"
    "            case CURLOPT_RESOLVE:\n"
    "                foreach ((array) $value as $resolve) {\n"
    "                    $flag = substr($resolve, 0, 1);\n"
    "                    if ($flag === '+' || $flag === '-') {\n"
    "                        // TODO: [+]HOST:PORT:ADDRESS\n"
    "                        $resolve = substr($resolve, 1);\n"
    "                    }\n"
    "                    $tmpResolve = explode(':', $resolve, 3);\n"
    "                    $host       = $tmpResolve[0];\n"
    "                    $port       = $tmpResolve[1] ?? 0;\n"
    "                    $ip         = $tmpResolve[2] ?? '';\n"
    "                    if ($flag === '-') {\n"
    "                        unset($this->resolve[$host][$port]);\n"
    "                    } else {\n"
    "                        // TODO: HOST:PORT:ADDRESS[,ADDRESS]...\n"
    "                        $this->resolve[$host][$port] = explode(',', $ip)[0];\n"
    "                    }\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_IPRESOLVE:\n"
    "                if ($value !== CURL_IPRESOLVE_WHATEVER and $value !== CURL_IPRESOLVE_V4) {\n"
    "                    throw new CurlException('swoole_curl_setopt(): Only support following CURLOPT_IPRESOLVE values: CURL_IPRESOLVE_WHATEVER, CURL_IPRESOLVE_V4');\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_TCP_NODELAY:\n"
    "                $this->clientOptions[Constant::OPTION_OPEN_TCP_NODELAY] = boolval($value);\n"
    "                break;\n"
    "            case CURLOPT_PRIVATE:\n"
    "                $this->info['private'] = $value;\n"
    "                break;\n"
    "                /*\n"
    "                 * Ignore options\n"
    "                 */\n"
    "            case CURLOPT_VERBOSE:\n"
    "                // trigger_error('swoole_curl_setopt(): CURLOPT_VERBOSE is not supported', E_USER_WARNING);\n"
    "            case CURLOPT_SSLVERSION:\n"
    "            case CURLOPT_NOSIGNAL:\n"
    "            case CURLOPT_FRESH_CONNECT:\n"
    "            case CURLOPT_DNS_USE_GLOBAL_CACHE:\n"
    "            case CURLOPT_DNS_CACHE_TIMEOUT:\n"
    "            case CURLOPT_STDERR:\n"
    "            case CURLOPT_WRITEHEADER:\n"
    "            case CURLOPT_BUFFERSIZE:\n"
    "            case CURLOPT_SSLCERTTYPE:\n"
    "            case CURLOPT_SSLKEYTYPE:\n"
    "            case CURLOPT_NOPROXY:\n"
    "            case CURLOPT_CERTINFO:\n"
    "            case CURLOPT_HEADEROPT:\n"
    "            case CURLOPT_PROXYHEADER:\n"
    "            case CURLOPT_HTTPPROXYTUNNEL:\n"
    "                break;\n"
    "                /*\n"
    "                 * SSL\n"
    "                 */\n"
    "            case CURLOPT_SSL_VERIFYHOST:\n"
    "                break;\n"
    "            case CURLOPT_SSL_VERIFYPEER:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_VERIFY_PEER] = $value;\n"
    "                break;\n"
    "            case CURLOPT_SSLCERT:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_CERT_FILE] = $value;\n"
    "                break;\n"
    "            case CURLOPT_SSLKEY:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_KEY_FILE] = $value;\n"
    "                break;\n"
    "            case CURLOPT_CAINFO:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_CAFILE] = $value;\n"
    "                break;\n"
    "            case CURLOPT_CAPATH:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_CAPATH] = $value;\n"
    "                break;\n"
    "            case CURLOPT_KEYPASSWD:\n"
    "            case CURLOPT_SSLCERTPASSWD:\n"
    "            case CURLOPT_SSLKEYPASSWD:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_PASSPHRASE] = $value;\n"
    "                break;\n"
    "                /*\n"
    "                 * Http POST\n"
    "                 */\n"
    "            case CURLOPT_POST:\n"
    "                $this->method = 'POST';\n"
    "                break;\n"
    "            case CURLOPT_POSTFIELDS:\n"
    "                $this->postData = $value;\n"
    "                if (!$this->method) {\n"
    "                    $this->method = 'POST';\n"
    "                }\n"
    "                break;\n"
    "                /*\n"
    "                 * Upload\n"
    "                 */\n"
    "            case CURLOPT_SAFE_UPLOAD:\n"
    "                if (!$value) {\n"
    "                    trigger_error('swoole_curl_setopt(): Disabling safe uploads is no longer supported', E_USER_WARNING);\n"
    "                    return false;\n"
    "                }\n"
    "                break;\n"
    "                /*\n"
    "                 * Http Header\n"
    "                 */\n"
    "            case CURLOPT_HTTPHEADER:\n"
    "                if (!is_array($value) and !is_iterable($value)) {\n"
    "                    trigger_error('swoole_curl_setopt(): You must pass either an object or an array with the CURLOPT_HTTPHEADER argument', E_USER_WARNING);\n"
    "                    return false;\n"
    "                }\n"
    "                foreach ($value as $header) {\n"
    "                    $header      = explode(':', $header, 2);\n"
    "                    $headerName  = $header[0];\n"
    "                    $headerValue = trim($header[1] ?? '');\n"
    "                    $this->setHeader($headerName, $headerValue);\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_REFERER:\n"
    "                $this->setHeader('Referer', $value);\n"
    "                break;\n"
    "            case CURLINFO_HEADER_OUT:\n"
    "                $this->withHeaderOut = boolval($value);\n"
    "                break;\n"
    "            case CURLOPT_FILETIME:\n"
    "                $this->withFileTime = boolval($value);\n"
    "                break;\n"
    "            case CURLOPT_USERAGENT:\n"
    "                $this->setHeader('User-Agent', $value);\n"
    "                break;\n"
    "            case CURLOPT_CUSTOMREQUEST:\n"
    "                $this->method = (string) $value;\n"
    "                break;\n"
    "            case CURLOPT_PROTOCOLS:\n"
    "                if (($value & ~(CURLPROTO_HTTP | CURLPROTO_HTTPS)) != 0) {\n"
    "                    throw new CurlException(\"swoole_curl_setopt(): CURLOPT_PROTOCOLS[{$value}] is not supported\");\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_REDIR_PROTOCOLS:\n"
    "                if (($value & ~(CURLPROTO_HTTP | CURLPROTO_HTTPS)) != 0) {\n"
    "                    throw new CurlException(\"swoole_curl_setopt(): CURLOPT_REDIR_PROTOCOLS[{$value}] is not supported\");\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_HTTP_VERSION:\n"
    "                if ($value != CURL_HTTP_VERSION_1_1) {\n"
    "                    trigger_error(\"swoole_curl_setopt(): CURLOPT_HTTP_VERSION[{$value}] is not supported\", E_USER_WARNING);\n"
    "                    return false;\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_FAILONERROR:\n"
    "                $this->failOnError = $value;\n"
    "                break;\n"
    "                /*\n"
    "                 * Http Cookie\n"
    "                 */\n"
    "            case CURLOPT_COOKIE:\n"
    "                $this->setHeader('Cookie', $value);\n"
    "                break;\n"
    "            case CURLOPT_COOKIEJAR:\n"
    "                $this->cookieJar = (string) $value;\n"
    "                break;\n"
    "            case CURLOPT_COOKIEFILE:\n"
    "                if (is_file((string) $value)) {\n"
    "                    $this->setHeader('Cookie', file_get_contents($value));\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_CONNECTTIMEOUT:\n"
    "                $this->clientOptions[Constant::OPTION_CONNECT_TIMEOUT] = $value;\n"
    "                break;\n"
    "            case CURLOPT_CONNECTTIMEOUT_MS:\n"
    "                $this->clientOptions[Constant::OPTION_CONNECT_TIMEOUT] = $value / 1000;\n"
    "                break;\n"
    "            case CURLOPT_TIMEOUT:\n"
    "                $this->clientOptions[Constant::OPTION_TIMEOUT] = $value;\n"
    "                break;\n"
    "            case CURLOPT_TIMEOUT_MS:\n"
    "                $this->clientOptions[Constant::OPTION_TIMEOUT] = $value / 1000;\n"
    "                break;\n"
    "            case CURLOPT_FILE:\n"
    "                $this->outputStream = $value;\n"
    "                break;\n"
    "            case CURLOPT_HEADER:\n"
    "                $this->withHeader = $value;\n"
    "                break;\n"
    "            case CURLOPT_HEADERFUNCTION:\n"
    "                $this->headerFunction = $value;\n"
    "                break;\n"
    "            case CURLOPT_READFUNCTION:\n"
    "                $this->readFunction = $value;\n"
    "                break;\n"
    "            case CURLOPT_WRITEFUNCTION:\n"
    "                if (SWOOLE_VERSION_ID >= 50100) {\n"
    "                    $this->clientOptions[Constant::OPTION_WRITE_FUNC] = function ($client, $data) use ($value) {\n"
    "                        return $value($this, $data);\n"
    "                    };\n"
    "                } else {\n"
    "                    $this->writeFunction = $value;\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_NOPROGRESS:\n"
    "                $this->noProgress = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROGRESSFUNCTION:\n"
    "                $this->progressFunction = $value;\n"
    "                break;\n"
    "            case CURLOPT_HTTPAUTH:\n"
    "                if (!($value & CURLAUTH_BASIC)) {\n"
    "                    trigger_error(\"swoole_curl_setopt(): CURLOPT_HTTPAUTH[{$value}] is not supported\", E_USER_WARNING);\n"
    "                    return false;\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_USERPWD:\n"
    "                $this->setHeader('Authorization', 'Basic ' . base64_encode($value));\n"
    "                break;\n"
    "            case CURLOPT_FOLLOWLOCATION:\n"
    "                $this->followLocation = $value;\n"
    "                break;\n"
    "            case CURLOPT_AUTOREFERER:\n"
    "                $this->autoReferer = $value;\n"
    "                break;\n"
    "            case CURLOPT_MAXREDIRS:\n"
    "                $this->maxRedirects = $value;\n"
    "                break;\n"
    "            case CURLOPT_PUT:\n"
    "            case CURLOPT_UPLOAD:\n"
    "                /* after libcurl 7.12, CURLOPT_PUT is replaced by CURLOPT_UPLOAD */\n"
    "                $this->method = 'PUT';\n"
    "                break;\n"
    "            case CURLOPT_INFILE:\n"
    "                $this->infile = $value;\n"
    "                break;\n"
    "            case CURLOPT_INFILESIZE:\n"
    "                $this->infileSize = $value;\n"
    "                break;\n"
    "            case CURLOPT_HTTPGET:\n"
    "                /* Since GET is the default, this is only necessary if the request method has been changed. */\n"
    "                $this->method = 'GET';\n"
    "                break;\n"
    "            default:\n"
    "                throw new CurlException(\"swoole_curl_setopt(): option[{$opt}] is not supported\");\n"
    "        }\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    private function execute()\n"
    "    {\n"
    "        $this->info['redirect_count'] = $this->info['starttransfer_time'] = 0;\n"
    "        $this->info['redirect_url']   = '';\n"
    "        $timeBegin                    = microtime(true);\n"
    "        /*\n"
    "         * Socket\n"
    "         */\n"
    "        if (!$this->urlInfo) {\n"
    "            $this->setError(CURLE_URL_MALFORMAT, 'No URL set or URL using bad/illegal format');\n"
    "            return false;\n"
    "        }\n"
    "        if (!isset($this->client)) {\n"
    "            $this->create();\n"
    "        }\n"
    "        while (true) {\n"
    "            $client = $this->client;\n"
    "            /*\n"
    "             * Http Proxy\n"
    "             */\n"
    "            if ($this->proxy) {\n"
    "                $parse         = parse_url($this->proxy);\n"
    "                $proxy         = $parse['host'] ?? $parse['path'];\n"
    "                $proxyPort     = $parse['port'] ?? $this->proxyPort;\n"
    "                $proxyUsername = $parse['user'] ?? $this->proxyUsername;\n"
    "                $proxyPassword = $parse['pass'] ?? $this->proxyPassword;\n"
    "                $proxyType     = $parse['scheme'] ?? $this->proxyType;\n"
    "                if (is_string($proxyType)) {\n"
    "                    if ($proxyType === 'socks5') {\n"
    "                        $proxyType = CURLPROXY_SOCKS5;\n"
    "                    } else {\n"
    "                        $proxyType = CURLPROXY_HTTP;\n"
    "                    }\n"
    "                }\n"
    "\n"
    "                if (!filter_var($proxy, FILTER_VALIDATE_IP)) {\n"
    "                    $ip = System::gethostbyname($proxy, AF_INET, $this->clientOptions['connect_timeout'] ?? -1);\n"
    "                    if (!$ip) {\n"
    "                        $this->setError(CURLE_COULDNT_RESOLVE_PROXY, 'Could not resolve proxy: ' . $proxy);\n"
    "                        return false;\n"
    "                    }\n"
    "                    $this->proxy = $proxy = $ip;\n"
    "                }\n"
    "                $proxyOptions = match ($proxyType) {\n"
    "                    CURLPROXY_HTTP => [\n"
    "                        'http_proxy_host'     => $proxy,\n"
    "                        'http_proxy_port'     => $proxyPort,\n"
    "                        'http_proxy_username' => $proxyUsername,\n"
    "                        'http_proxy_password' => $proxyPassword,\n"
    "                    ],\n"
    "                    CURLPROXY_SOCKS5 => [\n"
    "                        'socks5_host'     => $proxy,\n"
    "                        'socks5_port'     => $proxyPort,\n"
    "                        'socks5_username' => $proxyUsername,\n"
    "                        'socks5_password' => $proxyPassword,\n"
    "                    ],\n"
    "                    default => throw new CurlException(\"Unexpected proxy type [{$proxyType}]\"),\n"
    "                };\n"
    "            }\n"
    "            /*\n"
    "             * Client Options\n"
    "             */\n"
    "            $client->set(\n"
    "                $this->clientOptions +\n"
    "                ($proxyOptions ?? [])\n"
    "            );\n"
    "            /*\n"
    "             * Method\n"
    "             */\n"
    "            if ($this->method) {\n"
    "                $client->setMethod($this->method);\n"
    "            }\n"
    "            /*\n"
    "             * Data\n"
    "             */\n"
    "            if ($this->infile) {\n"
    "                // Infile\n"
    "                // Notice: we make its priority higher than postData but raw cURL will send both of them\n"
    "                $data = '';\n"
    "                while (true) {\n"
    "                    $nLength = $this->infileSize - strlen($data);\n"
    "                    if ($nLength === 0) {\n"
    "                        break;\n"
    "                    }\n"
    "                    if (feof($this->infile)) {\n"
    "                        break;\n"
    "                    }\n"
    "                    $data .= fread($this->infile, $nLength);\n"
    "                }\n"
    "                $client->setData($data);\n"
    "                // Notice: although we reset it, raw cURL never do this\n"
    "                $this->infile     = null;\n"
    "                $this->infileSize = PHP_INT_MAX;\n"
    "            } else {\n"
    "                // POST data\n"
    "                if ($this->postData) {\n"
    "                    if (is_string($this->postData)) {\n"
    "                        if (!$this->hasHeader('content-type')) {\n"
    "                            $this->setHeader('Content-Type', 'application/x-www-form-urlencoded');\n"
    "                        }\n"
    "                    } elseif (is_array($this->postData)) {\n"
    "                        foreach ($this->postData as $k => $v) {\n"
    "                            if ($v instanceof \\CURLFile) {\n"
    "                                $client->addFile($v->getFilename(), $k, $v->getMimeType() ?: 'application/octet-stream', $v->getPostFilename());\n"
    "                                unset($this->postData[$k]);\n"
    "                            }\n"
    "                        }\n"
    "                    }\n"
    "                    $client->setData($this->postData);\n"
    "                }\n"
    "            }\n"
    "            /*\n"
    "             * Headers\n"
    "             */\n"
    "            // Notice: setHeaders must be placed last, because headers may be changed by other parts\n"
    "            // As much as possible to ensure that Host is the first header.\n"
    "            // See: http://tools.ietf.org/html/rfc7230#section-5.4\n"
    "            $client->setHeaders($this->headers);\n"
    "            /**\n"
    "             * Execute.\n"
    "             */\n"
    "            $executeResult = $client->execute($this->getUrl());\n"
    "            if (!$executeResult) {\n"
    "                $errCode = $client->errCode;\n"
    "                if ($errCode == SWOOLE_ERROR_DNSLOOKUP_RESOLVE_FAILED or $errCode == SWOOLE_ERROR_DNSLOOKUP_RESOLVE_TIMEOUT) {\n"
    "                    $this->setError(CURLE_COULDNT_RESOLVE_HOST, 'Could not resolve host: ' . $client->host);\n"
    "                } else {\n"
    "                    $this->setError($errCode, $client->errMsg);\n"
    "                }\n"
    "                $this->info['total_time'] = microtime(true) - $timeBegin;\n"
    "                return false;\n"
    "            }\n"
    "            if ($client->statusCode >= 300 and $client->statusCode < 400 and isset($client->headers['location'])) {\n"
    "                $redirectParsedUrl = $this->getRedirectUrl($client->headers['location']);\n"
    "                $redirectUrl       = self::unparseUrl($redirectParsedUrl);\n"
    "                if ($this->followLocation and ($this->maxRedirects === null or $this->info['redirect_count'] < $this->maxRedirects)) {\n"
    "                    if ($this->info['redirect_count'] === 0) {\n"
    "                        $this->info['starttransfer_time'] = microtime(true) - $timeBegin;\n"
    "                        $redirectBeginTime                = microtime(true);\n"
    "                    }\n"
    "                    // force GET\n"
    "                    if (in_array($client->statusCode, [Status::MOVED_PERMANENTLY, Status::FOUND, Status::SEE_OTHER])) {\n"
    "                        $this->method = 'GET';\n"
    "                    }\n"
    "                    if ($this->autoReferer) {\n"
    "                        $this->setHeader('Referer', $this->info['url']);\n"
    "                    }\n"
    "                    $this->setUrl($redirectUrl, false);\n"
    "                    $this->setUrlInfo($redirectParsedUrl);\n"
    "                    $this->info['redirect_count']++;\n"
    "                } else {\n"
    "                    $this->info['redirect_url'] = $redirectUrl;\n"
    "                    break;\n"
    "                }\n"
    "            } elseif ($this->failOnError && $client->statusCode >= 400) {\n"
    "                $this->setError(CURLE_HTTP_RETURNED_ERROR, \"The requested URL returned error: {$client->statusCode} \" . Status::getReasonPhrase($client->statusCode));\n"
    "                return false;\n"
    "            } else {\n"
    "                break;\n"
    "            }\n"
    "        }\n"
    "        $this->info['total_time']     = microtime(true) - $timeBegin;\n"
    "        $this->info['http_code']      = $client->statusCode;\n"
    "        $this->info['content_type']   = $client->headers['content-type'] ?? '';\n"
    "        $this->info['size_download']  = $this->info['download_content_length'] = strlen($client->body);\n"
    "        $this->info['speed_download'] = 1 / $this->info['total_time'] * $this->info['size_download'];\n"
    "        if (isset($redirectBeginTime)) {\n"
    "            $this->info['redirect_time'] = microtime(true) - $redirectBeginTime;\n"
    "        }\n"
    "\n"
    "        if (filter_var($this->urlInfo['host'], FILTER_VALIDATE_IP)) {\n"
    "            $this->info['primary_ip'] = $this->urlInfo['host'];\n"
    "        }\n"
    "\n"
    "        if ($this->unix_socket_path) {\n"
    "            $this->info['primary_ip']   = $this->unix_socket_path;\n"
    "            $this->info['primary_port'] = $this->urlInfo['port'];\n"
    "        }\n"
    "\n"
    "        $headerContent = '';\n"
    "        if ($client->headers) {\n"
    "            $cb = $this->headerFunction;\n"
    "            if ($client->statusCode > 0) {\n"
    "                $row = \"HTTP/1.1 {$client->statusCode} \" . Status::getReasonPhrase($client->statusCode) . \"\\r\\n\";\n"
    "                if ($cb) {\n"
    "                    $cb($this, $row);\n"
    "                }\n"
    "                $headerContent .= $row;\n"
    "            }\n"
    "            foreach ($client->headers as $k => $v) {\n"
    "                $list = is_array($v) ? $v : [$v];\n"
    "                foreach ($list as $_v) {\n"
    "                    $row = \"{$k}: {$_v}\\r\\n\";\n"
    "                    if ($cb) {\n"
    "                        $cb($this, $row);\n"
    "                    }\n"
    "                    $headerContent .= $row;\n"
    "                }\n"
    "            }\n"
    "            $headerContent .= \"\\r\\n\";\n"
    "            $this->info['header_size'] = strlen($headerContent);\n"
    "            if ($cb) {\n"
    "                $cb($this, '');\n"
    "            }\n"
    "        } else {\n"
    "            $this->info['header_size'] = 0;\n"
    "        }\n"
    "\n"
    "        if ($client->body and $this->readFunction) {\n"
    "            $cb = $this->readFunction;\n"
    "            $cb($this, $this->outputStream, strlen($client->body));\n"
    "        }\n"
    "\n"
    "        if ($this->withHeader) {\n"
    "            $transfer = $headerContent . $client->body;\n"
    "        } else {\n"
    "            $transfer = $client->body;\n"
    "        }\n"
    "\n"
    "        if ($this->withHeaderOut) {\n"
    "            $headerOutContent             = $client->getHeaderOut();\n"
    "            $this->info['request_header'] = $headerOutContent ? $headerOutContent . \"\\r\\n\\r\\n\" : '';\n"
    "        }\n"
    "        if ($this->withFileTime) {\n"
    "            if (isset($client->headers['last-modified'])) {\n"
    "                $this->info['filetime'] = strtotime($client->headers['last-modified']);\n"
    "            } else {\n"
    "                $this->info['filetime'] = -1;\n"
    "            }\n"
    "        }\n"
    "\n"
    "        if (!empty($this->cookieJar)) {\n"
    "            if ($this->cookieJar === '-') {\n"
    "                foreach ((array) $client->set_cookie_headers as $cookie) {\n"
    "                    echo $cookie . PHP_EOL;\n"
    "                }\n"
    "            } else {\n"
    "                $cookies = '';\n"
    "                foreach ((array) $client->set_cookie_headers as $cookie) {\n"
    "                    $cookies .= \"{$cookie};\";\n"
    "                }\n"
    "                file_put_contents($this->cookieJar, $cookies);\n"
    "            }\n"
    "        }\n"
    "\n"
    "        if ($this->writeFunction) {\n"
    "            if (!is_callable($this->writeFunction)) { // @phpstan-ignore booleanNot.alwaysFalse\n"
    "                trigger_error('curl_exec(): Could not call the CURLOPT_WRITEFUNCTION', E_USER_WARNING);\n"
    "                $this->setError(CURLE_WRITE_ERROR, 'Failure writing output to destination');\n"
    "                return false;\n"
    "            }\n"
    "            call_user_func($this->writeFunction, $this, $transfer);\n"
    "            return true;\n"
    "        }\n"
    "\n"
    "        if ($this->returnTransfer) {\n"
    "            return $this->transfer = $transfer;\n"
    "        }\n"
    "        if ($this->outputStream) {\n"
    "            return fwrite($this->outputStream, $transfer) === strlen($transfer);\n"
    "        }\n"
    "        echo $transfer;\n"
    "\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    /* ====== Redirect helper ====== */\n"
    "\n"
    "    private static function unparseUrl(array $parsedUrl): string\n"
    "    {\n"
    "        $scheme   = ($parsedUrl['scheme'] ?? 'http') . '://';\n"
    "        $host     = $parsedUrl['host'] ?? '';\n"
    "        $port     = isset($parsedUrl['port']) ? ':' . $parsedUrl['port'] : '';\n"
    "        $user     = $parsedUrl['user'] ?? '';\n"
    "        $pass     = isset($parsedUrl['pass']) ? ':' . $parsedUrl['pass'] : '';\n"
    "        $pass     = ($user or $pass) ? \"{$pass}@\" : '';\n"
    "        $path     = $parsedUrl['path'] ?? '';\n"
    "        $query    = (isset($parsedUrl['query']) and $parsedUrl['query'] !== '') ? '?' . $parsedUrl['query'] : '';\n"
    "        $fragment = isset($parsedUrl['fragment']) ? '#' . $parsedUrl['fragment'] : '';\n"
    "        return $scheme . $user . $pass . $host . $port . $path . $query . $fragment;\n"
    "    }\n"
    "\n"
    "    private function getRedirectUrl(string $location): array\n"
    "    {\n"
    "        $uri = parse_url($location);\n"
    "        if (isset($uri['host'])) {\n"
    "            $redirectUri = $uri;\n"
    "        } else {\n"
    "            if (!isset($location[0])) {\n"
    "                return [];\n"
    "            }\n"
    "            $redirectUri          = $this->urlInfo;\n"
    "            $redirectUri['query'] = '';\n"
    "            if ($location[0] === '/') {\n"
    "                $redirectUri['path'] = $location;\n"
    "            } else {\n"
    "                $path = dirname($redirectUri['path'] ?? '');\n"
    "                if ($path === '.') {\n"
    "                    $path = '/';\n"
    "                }\n"
    "                if (isset($location[1]) and str_starts_with($location, './')) {\n"
    "                    $location = substr($location, 2);\n"
    "                }\n"
    "                $redirectUri['path'] = $path . $location;\n"
    "            }\n"
    "            if (is_array($uri)) {\n"
    "                foreach ($uri as $k => $v) {\n"
    "                    if (!in_array($k, ['path', 'query'])) {\n"
    "                        $redirectUri[$k] = $v;\n"
    "                    }\n"
    "                }\n"
    "            }\n"
    "        }\n"
    "        return $redirectUri;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "/**\n"
    " * FastCGI constants.\n"
    " */\n"
    "class FastCGI\n"
    "{\n"
    "    /**\n"
    "     * Number of bytes in a FCGI_Header.  Future versions of the protocol\n"
    "     * will not reduce this number.\n"
    "     */\n"
    "    public const HEADER_LEN = 8;\n"
    "\n"
    "    /**\n"
    "     * Format of FCGI_HEADER for unpacking in PHP\n"
    "     */\n"
    "    public const HEADER_FORMAT = 'Cversion/Ctype/nrequestId/ncontentLength/CpaddingLength/Creserved';\n"
    "\n"
    "    /**\n"
    "     * Max content length of a record\n"
    "     */\n"
    "    public const MAX_CONTENT_LENGTH = 65535;\n"
    "\n"
    "    /**\n"
    "     * Value for version component of FCGI_Header\n"
    "     */\n"
    "    public const VERSION_1 = 1;\n"
    "\n"
    "    /**\n"
    "     * Values for type component of FCGI_Header\n"
    "     */\n"
    "    public const BEGIN_REQUEST = 1;\n"
    "\n"
    "    public const ABORT_REQUEST = 2;\n"
    "\n"
    "    public const END_REQUEST = 3;\n"
    "\n"
    "    public const PARAMS = 4;\n"
    "\n"
    "    public const STDIN = 5;\n"
    "\n"
    "    public const STDOUT = 6;\n"
    "\n"
    "    public const STDERR = 7;\n"
    "\n"
    "    public const DATA = 8;\n"
    "\n"
    "    public const GET_VALUES = 9;\n"
    "\n"
    "    public const GET_VALUES_RESULT = 10;\n"
    "\n"
    "    public const UNKNOWN_TYPE = 11;\n"
    "\n"
    "    /**\n"
    "     * Value for requestId component of FCGI_Header\n"
    "     */\n"
    "    public const DEFAULT_REQUEST_ID = 1;\n"
    "\n"
    "    /**\n"
    "     * Mask for flags component of FCGI_BeginRequestBody\n"
    "     */\n"
    "    public const KEEP_CONN = 1;\n"
    "\n"
    "    /**\n"
    "     * Values for role component of FCGI_BeginRequestBody\n"
    "     */\n"
    "    public const RESPONDER = 1;\n"
    "\n"
    "    public const AUTHORIZER = 2;\n"
    "\n"
    "    public const FILTER = 3;\n"
    "\n"
    "    /**\n"
    "     * Values for protocolStatus component of FCGI_EndRequestBody\n"
    "     */\n"
    "    public const REQUEST_COMPLETE = 0;\n"
    "\n"
    "    public const CANT_MPX_CONN = 1;\n"
    "\n"
    "    public const OVERLOADED = 2;\n"
    "\n"
    "    public const UNKNOWN_ROLE = 3;\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "\n"
    "/**\n"
    " * FastCGI record.\n"
    " */\n"
    "class Record implements \\Stringable\n"
    "{\n"
    "    /**\n"
    "     * Identifies the FastCGI protocol version.\n"
    "     */\n"
    "    protected int $version = FastCGI::VERSION_1;\n"
    "\n"
    "    /**\n"
    "     * Identifies the FastCGI record type, i.e. the general function that the record performs.\n"
    "     */\n"
    "    protected int $type = FastCGI::UNKNOWN_TYPE;\n"
    "\n"
    "    /**\n"
    "     * Identifies the FastCGI request to which the record belongs.\n"
    "     */\n"
    "    protected int $requestId = FastCGI::DEFAULT_REQUEST_ID;\n"
    "\n"
    "    /**\n"
    "     * Reserved byte for future proposes\n"
    "     */\n"
    "    protected int $reserved = 0;\n"
    "\n"
    "    /**\n"
    "     * The number of bytes in the contentData component of the record.\n"
    "     */\n"
    "    private int $contentLength = 0;\n"
    "\n"
    "    /**\n"
    "     * The number of bytes in the paddingData component of the record.\n"
    "     */\n"
    "    private int $paddingLength = 0;\n"
    "\n"
    "    /**\n"
    "     * Binary data, between 0 and 65535 bytes of data, interpreted according to the record type.\n"
    "     */\n"
    "    private string $contentData = '';\n"
    "\n"
    "    /**\n"
    "     * Padding data, between 0 and 255 bytes of data, which are ignored.\n"
    "     */\n"
    "    private string $paddingData = '';\n"
    "\n"
    "    /**\n"
    "     * Returns the binary message representation of record\n"
    "     */\n"
    "    final public function __toString(): string\n"
    "    {\n"
    "        $headerPacket = pack(\n"
    "            'CCnnCC',\n"
    "            $this->version,\n"
    "            $this->type,\n"
    "            $this->requestId,\n"
    "            $this->contentLength,\n"
    "            $this->paddingLength,\n"
    "            $this->reserved\n"
    "        );\n"
    "\n"
    "        $payloadPacket = $this->packPayload();\n"
    "        $paddingPacket = pack(\"a{$this->paddingLength}\", $this->paddingData);\n"
    "\n"
    "        return $headerPacket . $payloadPacket . $paddingPacket;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Unpacks the message from the binary data buffer\n"
    "     */\n"
    "    final public static function unpack(string $binaryData): static\n"
    "    {\n"
    "        /** @var static $self */\n"
    "        $self = (new \\ReflectionClass(static::class))->newInstanceWithoutConstructor();\n"
    "\n"
    "        /** @phpstan-var false|array{version: int, type: int, requestId: int, contentLength: int, paddingLength: int, reserved: int} */\n"
    "        $packet = unpack(FastCGI::HEADER_FORMAT, $binaryData);\n"
    "        if ($packet === false) {\n"
    "            throw new \\RuntimeException('Can not unpack data from the binary buffer');\n"
    "        }\n"
    "        [\n"
    "            $self->version,\n"
    "            $self->type,\n"
    "            $self->requestId,\n"
    "            $self->contentLength,\n"
    "            $self->paddingLength,\n"
    "            $self->reserved,\n"
    "        ] = array_values($packet);\n"
    "\n"
    "        $payload = substr($binaryData, FastCGI::HEADER_LEN);\n"
    "        self::unpackPayload($self, $payload);\n"
    "        if (static::class !== self::class && $self->contentLength > 0) {\n"
    "            static::unpackPayload($self, $payload);\n"
    "        }\n"
    "\n"
    "        return $self;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Sets the content data and adjusts the length fields\n"
    "     *\n"
    "     * @return static\n"
    "     */\n"
    "    public function setContentData(string $data): self\n"
    "    {\n"
    "        $this->contentLength = strlen($data);\n"
    "        if ($this->contentLength > FastCGI::MAX_CONTENT_LENGTH) {\n"
    "            $this->contentLength = FastCGI::MAX_CONTENT_LENGTH;\n"
    "            $this->contentData   = substr($data, 0, FastCGI::MAX_CONTENT_LENGTH);\n"
    "        } else {\n"
    "            $this->contentData = $data;\n"
    "        }\n"
    "        $extraLength         = $this->contentLength % 8;\n"
    "        $this->paddingLength = $extraLength ? (8 - $extraLength) : 0;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the context data from the record\n"
    "     */\n"
    "    public function getContentData(): string\n"
    "    {\n"
    "        return $this->contentData;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the version of record\n"
    "     */\n"
    "    public function getVersion(): int\n"
    "    {\n"
    "        return $this->version;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns record type\n"
    "     */\n"
    "    public function getType(): int\n"
    "    {\n"
    "        return $this->type;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns request ID\n"
    "     */\n"
    "    public function getRequestId(): int\n"
    "    {\n"
    "        return $this->requestId;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Sets request ID\n"
    "     *\n"
    "     * There should be only one unique ID for all active requests,\n"
    "     * use random number or preferably resetting auto-increment.\n"
    "     *\n"
    "     * @return static\n"
    "     */\n"
    "    public function setRequestId(int $requestId): self\n"
    "    {\n"
    "        $this->requestId = $requestId;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the size of content length\n"
    "     */\n"
    "    final public function getContentLength(): int\n"
    "    {\n"
    "        return $this->contentLength;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the size of padding length\n"
    "     */\n"
    "    final public function getPaddingLength(): int\n"
    "    {\n"
    "        return $this->paddingLength;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Method to unpack the payload for the record.\n"
    "     *\n"
    "     * NB: Default implementation will be always called\n"
    "     */\n"
    "    protected static function unpackPayload(self $self, string $binaryData): void\n"
    "    {\n"
    "        /** @phpstan-var false|array{contentData: string, paddingData: string} */\n"
    "        $payload = unpack(\"a{$self->contentLength}contentData/a{$self->paddingLength}paddingData\", $binaryData);\n"
    "        if ($payload === false) {\n"
    "            throw new \\RuntimeException('Can not unpack data from the binary buffer');\n"
    "        }\n"
    "        [\n"
    "            $self->contentData,\n"
    "            $self->paddingData,\n"
    "        ] = array_values($payload);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Implementation of packing the payload\n"
    "     */\n"
    "    protected function packPayload(): string\n"
    "    {\n"
    "        return pack(\"a{$this->contentLength}\", $this->contentData);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_params =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * Params request record\n"
    " */\n"
    "class Params extends Record\n"
    "{\n"
    "    /**\n"
    "     * List of params\n"
    "     *\n"
    "     * @var string[]\n"
    "     * @phpstan-var array<string, string>\n"
    "     */\n"
    "    protected array $values = [];\n"
    "\n"
    "    /**\n"
    "     * Constructs a param request\n"
    "     *\n"
    "     * @phpstan-param array<string, string> $values\n"
    "     */\n"
    "    public function __construct(array $values)\n"
    "    {\n"
    "        $this->type   = FastCGI::PARAMS;\n"
    "        $this->values = $values;\n"
    "        $this->setContentData($this->packPayload());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns an associative list of parameters\n"
    "     *\n"
    "     * @phpstan-return array<string, string>\n"
    "     */\n"
    "    public function getValues(): array\n"
    "    {\n"
    "        return $this->values;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * {@inheritdoc}\n"
    "     * @param static $self\n"
    "     */\n"
    "    protected static function unpackPayload(Record $self, string $binaryData): void\n"
    "    {\n"
    "        assert($self instanceof self); // @phpstan-ignore function.alreadyNarrowedType,instanceof.alwaysTrue\n"
    "        $currentOffset = 0;\n"
    "        do {\n"
    "            /** @phpstan-var false|array{nameLengthHigh: int} */\n"
    "            $payload = unpack('CnameLengthHigh', $binaryData);\n"
    "            if ($payload === false) {\n"
    "                throw new \\RuntimeException('Can not unpack data from the binary buffer');\n"
    "            }\n"
    "            [$nameLengthHigh] = array_values($payload);\n"
    "            $isLongName       = ($nameLengthHigh >> 7 == 1);\n"
    "            $valueOffset      = $isLongName ? 4 : 1;\n"
    "\n"
    "            /** @phpstan-var false|array{valueLengthHigh: int} */\n"
    "            $payload = unpack('CvalueLengthHigh', substr($binaryData, $valueOffset));\n"
    "            if ($payload === false) {\n"
    "                throw new \\RuntimeException('Can not unpack data from the binary buffer');\n"
    "            }\n"
    "            [$valueLengthHigh] = array_values($payload);\n"
    "            $isLongValue       = ($valueLengthHigh >> 7 == 1);\n"
    "            $dataOffset        = $valueOffset + ($isLongValue ? 4 : 1);\n"
    "\n"
    "            $formatParts = [\n"
    "                $isLongName ? 'NnameLength' : 'CnameLength',\n"
    "                $isLongValue ? 'NvalueLength' : 'CvalueLength',\n"
    "            ];\n"
    "            $format      = join('/', $formatParts);\n"
    "\n"
    "            /** @phpstan-var false|array{nameLength: int, valueLength: int} */\n"
    "            $payload = unpack($format, $binaryData);\n"
    "            if ($payload === false) {\n"
    "                throw new \\RuntimeException('Can not unpack data from the binary buffer');\n"
    "            }\n"
    "            [$nameLength, $valueLength] = array_values($payload);\n"
    "\n"
    "            // Clear top bit for long record\n"
    "            $nameLength &= ($isLongName ? 0x7FFFFFFF : 0x7F);\n"
    "            $valueLength &= ($isLongValue ? 0x7FFFFFFF : 0x7F);\n"
    "\n"
    "            /** @phpstan-var false|array{nameData: string, valueData: string} */\n"
    "            $payload = unpack(\n"
    "                \"a{$nameLength}nameData/a{$valueLength}valueData\",\n"
    "                substr($binaryData, $dataOffset)\n"
    "            );\n"
    "            if ($payload === false) {\n"
    "                throw new \\RuntimeException('Can not unpack data from the binary buffer');\n"
    "            }\n"
    "            [$nameData, $valueData] = array_values($payload);\n"
    "\n"
    "            $self->values[$nameData] = $valueData;\n"
    "\n"
    "            $keyValueLength = $dataOffset + $nameLength + $valueLength;\n"
    "            $binaryData     = substr($binaryData, $keyValueLength);\n"
    "            $currentOffset += $keyValueLength;\n"
    "        } while ($currentOffset < $self->getContentLength());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * {@inheritdoc}\n"
    "     */\n"
    "    protected function packPayload(): string\n"
    "    {\n"
    "        $payload = '';\n"
    "        foreach ($this->values as $nameData => $valueData) {\n"
    "            if ($valueData === null) { // @phpstan-ignore identical.alwaysFalse\n"
    "                continue;\n"
    "            }\n"
    "            $nameLength  = strlen($nameData);\n"
    "            $valueLength = strlen((string) $valueData);\n"
    "            $isLongName  = $nameLength > 127;\n"
    "            $isLongValue = $valueLength > 127;\n"
    "            $formatParts = [\n"
    "                $isLongName ? 'N' : 'C',\n"
    "                $isLongValue ? 'N' : 'C',\n"
    "                \"a{$nameLength}\",\n"
    "                \"a{$valueLength}\",\n"
    "            ];\n"
    "\n"
    "            $format = join('', $formatParts);\n"
    "\n"
    "            $payload .= pack(\n"
    "                $format,\n"
    "                $isLongName ? ($nameLength | 0x80000000) : $nameLength,\n"
    "                $isLongValue ? ($valueLength | 0x80000000) : $valueLength,\n"
    "                $nameData,\n"
    "                $valueData\n"
    "            );\n"
    "        }\n"
    "\n"
    "        return $payload;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_abort_request =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * The Web server sends a FCGI_ABORT_REQUEST record to abort a request\n"
    " */\n"
    "class AbortRequest extends Record\n"
    "{\n"
    "    public function __construct(int $requestId)\n"
    "    {\n"
    "        $this->type = FastCGI::ABORT_REQUEST;\n"
    "        $this->setRequestId($requestId);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_begin_request =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * The Web server sends a FCGI_BEGIN_REQUEST record to start a request.\n"
    " */\n"
    "class BeginRequest extends Record\n"
    "{\n"
    "    /**\n"
    "     * The role component sets the role the Web server expects the application to play.\n"
    "     * The currently-defined roles are:\n"
    "     *   FCGI_RESPONDER\n"
    "     *   FCGI_AUTHORIZER\n"
    "     *   FCGI_FILTER\n"
    "     */\n"
    "    protected int $role = FastCGI::UNKNOWN_ROLE;\n"
    "\n"
    "    /**\n"
    "     * The flags component contains a bit that controls connection shutdown.\n"
    "     *\n"
    "     * flags & FCGI_KEEP_CONN:\n"
    "     *   If zero, the application closes the connection after responding to this request.\n"
    "     *   If not zero, the application does not close the connection after responding to this request;\n"
    "     *   the Web server retains responsibility for the connection.\n"
    "     */\n"
    "    protected int $flags;\n"
    "\n"
    "    /**\n"
    "     * Reserved data, 5 bytes maximum\n"
    "     */\n"
    "    protected string $reserved1;\n"
    "\n"
    "    public function __construct(int $role = FastCGI::UNKNOWN_ROLE, int $flags = 0, string $reserved = '')\n"
    "    {\n"
    "        $this->type      = FastCGI::BEGIN_REQUEST;\n"
    "        $this->role      = $role;\n"
    "        $this->flags     = $flags;\n"
    "        $this->reserved1 = $reserved;\n"
    "        $this->setContentData($this->packPayload());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the role\n"
    "     *\n"
    "     * The role component sets the role the Web server expects the application to play.\n"
    "     * The currently-defined roles are:\n"
    "     *   FCGI_RESPONDER\n"
    "     *   FCGI_AUTHORIZER\n"
    "     *   FCGI_FILTER\n"
    "     */\n"
    "    public function getRole(): int\n"
    "    {\n"
    "        return $this->role;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the flags\n"
    "     *\n"
    "     * The flags component contains a bit that controls connection shutdown.\n"
    "     *\n"
    "     * flags & FCGI_KEEP_CONN:\n"
    "     *   If zero, the application closes the connection after responding to this request.\n"
    "     *   If not zero, the application does not close the connection after responding to this request;\n"
    "     *   the Web server retains responsibility for the connection.\n"
    "     */\n"
    "    public function getFlags(): int\n"
    "    {\n"
    "        return $this->flags;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * {@inheritdoc}\n"
    "     * @param static $self\n"
    "     */\n"
    "    protected static function unpackPayload(Record $self, string $binaryData): void\n"
    "    {\n"
    "        assert($self instanceof self); // @phpstan-ignore function.alreadyNarrowedType,instanceof.alwaysTrue\n"
    "\n"
    "        /** @phpstan-var false|array{role: int, flags: int, reserved: string} */\n"
    "        $payload = unpack('nrole/Cflags/a5reserved', $binaryData);\n"
    "        if ($payload === false) {\n"
    "            throw new \\RuntimeException('Can not unpack data from the binary buffer');\n"
    "        }\n"
    "        [\n"
    "            $self->role,\n"
    "            $self->flags,\n"
    "            $self->reserved1,\n"
    "        ] = array_values($payload);\n"
    "    }\n"
    "\n"
    "    /** {@inheritdoc} */\n"
    "    protected function packPayload(): string\n"
    "    {\n"
    "        return pack(\n"
    "            'nCa5',\n"
    "            $this->role,\n"
    "            $this->flags,\n"
    "            $this->reserved1\n"
    "        );\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_data =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * Data binary stream\n"
    " *\n"
    " * FCGI_DATA is a second stream record type used to send additional data to the application.\n"
    " */\n"
    "class Data extends Record\n"
    "{\n"
    "    public function __construct(string $contentData)\n"
    "    {\n"
    "        $this->type = FastCGI::DATA;\n"
    "        $this->setContentData($contentData);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_end_request =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * The application sends a FCGI_END_REQUEST record to terminate a request, either because the application\n"
    " * has processed the request or because the application has rejected the request.\n"
    " */\n"
    "class EndRequest extends Record\n"
    "{\n"
    "    /**\n"
    "     * The appStatus component is an application-level status code. Each role documents its usage of appStatus.\n"
    "     */\n"
    "    protected int $appStatus = 0;\n"
    "\n"
    "    /**\n"
    "     * The protocolStatus component is a protocol-level status code.\n"
    "     *\n"
    "     * The possible protocolStatus values are:\n"
    "     *   FCGI_REQUEST_COMPLETE: normal end of request.\n"
    "     *   FCGI_CANT_MPX_CONN: rejecting a new request.\n"
    "     *      This happens when a Web server sends concurrent requests over one connection to an application that is\n"
    "     *      designed to process one request at a time per connection.\n"
    "     *   FCGI_OVERLOADED: rejecting a new request.\n"
    "     *      This happens when the application runs out of some resource, e.g. database connections.\n"
    "     *   FCGI_UNKNOWN_ROLE: rejecting a new request.\n"
    "     *      This happens when the Web server has specified a role that is unknown to the application.\n"
    "     */\n"
    "    protected int $protocolStatus = FastCGI::REQUEST_COMPLETE;\n"
    "\n"
    "    /**\n"
    "     * Reserved data, 3 bytes maximum\n"
    "     */\n"
    "    protected string $reserved1;\n"
    "\n"
    "    public function __construct(int $protocolStatus = FastCGI::REQUEST_COMPLETE, int $appStatus = 0, string $reserved = '')\n"
    "    {\n"
    "        $this->type           = FastCGI::END_REQUEST;\n"
    "        $this->protocolStatus = $protocolStatus;\n"
    "        $this->appStatus      = $appStatus;\n"
    "        $this->reserved1      = $reserved;\n"
    "        $this->setContentData($this->packPayload());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns app status\n"
    "     *\n"
    "     * The appStatus component is an application-level status code. Each role documents its usage of appStatus.\n"
    "     */\n"
    "    public function getAppStatus(): int\n"
    "    {\n"
    "        return $this->appStatus;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the protocol status\n"
    "     *\n"
    "     * The possible protocolStatus values are:\n"
    "     *   FCGI_REQUEST_COMPLETE: normal end of request.\n"
    "     *   FCGI_CANT_MPX_CONN: rejecting a new request.\n"
    "     *      This happens when a Web server sends concurrent requests over one connection to an application that is\n"
    "     *      designed to process one request at a time per connection.\n"
    "     *   FCGI_OVERLOADED: rejecting a new request.\n"
    "     *      This happens when the application runs out of some resource, e.g. database connections.\n"
    "     *   FCGI_UNKNOWN_ROLE: rejecting a new request.\n"
    "     *      This happens when the Web server has specified a role that is unknown to the application.\n"
    "     */\n"
    "    public function getProtocolStatus(): int\n"
    "    {\n"
    "        return $this->protocolStatus;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * {@inheritdoc}\n"
    "     * @param static $self\n"
    "     */\n"
    "    protected static function unpackPayload(Record $self, string $binaryData): void\n"
    "    {\n"
    "        assert($self instanceof self); // @phpstan-ignore function.alreadyNarrowedType,instanceof.alwaysTrue\n"
    "\n"
    "        /** @phpstan-var false|array{appStatus: int, protocolStatus: int, reserved: string} */\n"
    "        $payload = unpack('NappStatus/CprotocolStatus/a3reserved', $binaryData);\n"
    "        if ($payload === false) {\n"
    "            throw new \\RuntimeException('Can not unpack data from the binary buffer');\n"
    "        }\n"
    "        [\n"
    "            $self->appStatus,\n"
    "            $self->protocolStatus,\n"
    "            $self->reserved1,\n"
    "        ] = array_values($payload);\n"
    "    }\n"
    "\n"
    "    /** {@inheritdoc} */\n"
    "    protected function packPayload(): string\n"
    "    {\n"
    "        return pack(\n"
    "            'NCa3',\n"
    "            $this->appStatus,\n"
    "            $this->protocolStatus,\n"
    "            $this->reserved1\n"
    "        );\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_get_values =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "\n"
    "/**\n"
    " * GetValues API\n"
    " *\n"
    " * The Web server can query specific variables within the application.\n"
    " * The server will typically perform a query on application startup in order to to automate certain aspects of\n"
    " * system configuration.\n"
    " *\n"
    " * The application responds by sending a record {FCGI_GET_VALUES_RESULT, 0, ...} with the values supplied.\n"
    " * If the application doesn't understand a variable name that was included in the query, it omits that name from\n"
    " * the response.\n"
    " *\n"
    " * FCGI_GET_VALUES is designed to allow an open-ended set of variables.\n"
    " *\n"
    " * The initial set provides information to help the server perform application and connection management:\n"
    " *   FCGI_MAX_CONNS:  The maximum number of concurrent transport connections this application will accept,\n"
    " *                    e.g. \"1\" or \"10\".\n"
    " *   FCGI_MAX_REQS:   The maximum number of concurrent requests this application will accept, e.g. \"1\" or \"50\".\n"
    " *   FCGI_MPXS_CONNS: \"0\" if this application does not multiplex connections (i.e. handle concurrent requests\n"
    " *                    over each connection), \"1\" otherwise.\n"
    " */\n"
    "class GetValues extends Params\n"
    "{\n"
    "    /**\n"
    "     * Constructs a request\n"
    "     *\n"
    "     * @param array $keys List of keys to receive\n"
    "     *\n"
    "     * @phpstan-param list<string> $keys\n"
    "     */\n"
    "    public function __construct(array $keys)\n"
    "    {\n"
    "        parent::__construct(array_fill_keys($keys, ''));\n"
    "        $this->type = FastCGI::GET_VALUES;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_get_values_result =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "\n"
    "/**\n"
    " * GetValues API\n"
    " *\n"
    " * The Web server can query specific variables within the application.\n"
    " * The server will typically perform a query on application startup in order to to automate certain aspects of\n"
    " * system configuration.\n"
    " *\n"
    " * The application responds by sending a record {FCGI_GET_VALUES_RESULT, 0, ...} with the values supplied.\n"
    " * If the application doesn't understand a variable name that was included in the query, it omits that name from\n"
    " * the response.\n"
    " *\n"
    " * FCGI_GET_VALUES is designed to allow an open-ended set of variables.\n"
    " *\n"
    " * The initial set provides information to help the server perform application and connection management:\n"
    " *   FCGI_MAX_CONNS:  The maximum number of concurrent transport connections this application will accept,\n"
    " *                    e.g. \"1\" or \"10\".\n"
    " *   FCGI_MAX_REQS:   The maximum number of concurrent requests this application will accept, e.g. \"1\" or \"50\".\n"
    " *   FCGI_MPXS_CONNS: \"0\" if this application does not multiplex connections (i.e. handle concurrent requests\n"
    " *                    over each connection), \"1\" otherwise.\n"
    " */\n"
    "class GetValuesResult extends Params\n"
    "{\n"
    "    /**\n"
    "     * Constructs a param request\n"
    "     *\n"
    "     * @phpstan-param array<string, string> $values\n"
    "     */\n"
    "    public function __construct(array $values)\n"
    "    {\n"
    "        parent::__construct($values);\n"
    "        $this->type = FastCGI::GET_VALUES_RESULT;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_stdin =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * Stdin binary stream\n"
    " *\n"
    " * FCGI_STDIN is a stream record type used in sending arbitrary data from the Web server to the application\n"
    " */\n"
    "class Stdin extends Record\n"
    "{\n"
    "    public function __construct(string $contentData)\n"
    "    {\n"
    "        $this->type = FastCGI::STDIN;\n"
    "        $this->setContentData($contentData);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_stdout =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * Stdout binary stream\n"
    " *\n"
    " * FCGI_STDOUT is a stream record for sending arbitrary data from the application to the Web server\n"
    " */\n"
    "class Stdout extends Record\n"
    "{\n"
    "    public function __construct(string $contentData)\n"
    "    {\n"
    "        $this->type = FastCGI::STDOUT;\n"
    "        $this->setContentData($contentData);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_stderr =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * Stderr binary stream\n"
    " *\n"
    " * FCGI_STDERR is a stream record for sending arbitrary data from the application to the Web server\n"
    " */\n"
    "class Stderr extends Record\n"
    "{\n"
    "    public function __construct(string $contentData)\n"
    "    {\n"
    "        $this->type = FastCGI::STDERR;\n"
    "        $this->setContentData($contentData);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_unknown_type =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * Record for unknown queries\n"
    " *\n"
    " * The set of management record types is likely to grow in future versions of this protocol.\n"
    " * To provide for this evolution, the protocol includes the FCGI_UNKNOWN_TYPE management record.\n"
    " * When an application receives a management record whose type T it does not understand, the application responds\n"
    " * with {FCGI_UNKNOWN_TYPE, 0, {T}}.\n"
    " */\n"
    "class UnknownType extends Record\n"
    "{\n"
    "    /**\n"
    "     * Type of the unrecognized management record.\n"
    "     */\n"
    "    protected int $type1;\n"
    "\n"
    "    /**\n"
    "     * Reserved data, 7 bytes maximum\n"
    "     */\n"
    "    protected string $reserved1;\n"
    "\n"
    "    public function __construct(int $type, string $reserved = '')\n"
    "    {\n"
    "        $this->type      = FastCGI::UNKNOWN_TYPE;\n"
    "        $this->type1     = $type;\n"
    "        $this->reserved1 = $reserved;\n"
    "        $this->setContentData($this->packPayload());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the unrecognized type\n"
    "     */\n"
    "    public function getUnrecognizedType(): int\n"
    "    {\n"
    "        return $this->type1;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * {@inheritdoc}\n"
    "     * @param static $self\n"
    "     */\n"
    "    public static function unpackPayload(Record $self, string $binaryData): void\n"
    "    {\n"
    "        assert($self instanceof self); // @phpstan-ignore function.alreadyNarrowedType,instanceof.alwaysTrue\n"
    "\n"
    "        /** @phpstan-var false|array{type: int, reserved: string} */\n"
    "        $payload = unpack('Ctype/a7reserved', $binaryData);\n"
    "        if ($payload === false) {\n"
    "            throw new \\RuntimeException('Can not unpack data from the binary buffer');\n"
    "        }\n"
    "        [$self->type1, $self->reserved1] = array_values($payload);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * {@inheritdoc}\n"
    "     */\n"
    "    protected function packPayload(): string\n"
    "    {\n"
    "        return pack(\n"
    "            'Ca7',\n"
    "            $this->type1,\n"
    "            $this->reserved1\n"
    "        );\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_frame_parser =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record\\AbortRequest;\n"
    "use Swoole\\FastCGI\\Record\\BeginRequest;\n"
    "use Swoole\\FastCGI\\Record\\Data;\n"
    "use Swoole\\FastCGI\\Record\\EndRequest;\n"
    "use Swoole\\FastCGI\\Record\\GetValues;\n"
    "use Swoole\\FastCGI\\Record\\GetValuesResult;\n"
    "use Swoole\\FastCGI\\Record\\Params;\n"
    "use Swoole\\FastCGI\\Record\\Stderr;\n"
    "use Swoole\\FastCGI\\Record\\Stdin;\n"
    "use Swoole\\FastCGI\\Record\\Stdout;\n"
    "use Swoole\\FastCGI\\Record\\UnknownType;\n"
    "\n"
    "/**\n"
    " * Utility class to simplify parsing of FastCGI protocol data.\n"
    " */\n"
    "class FrameParser\n"
    "{\n"
    "    /**\n"
    "     * Mapping of constants to the classes\n"
    "     *\n"
    "     * @phpstan-var array<int, class-string>\n"
    "     */\n"
    "    protected static array $classMapping = [\n"
    "        FastCGI::BEGIN_REQUEST     => BeginRequest::class,\n"
    "        FastCGI::ABORT_REQUEST     => AbortRequest::class,\n"
    "        FastCGI::END_REQUEST       => EndRequest::class,\n"
    "        FastCGI::PARAMS            => Params::class,\n"
    "        FastCGI::STDIN             => Stdin::class,\n"
    "        FastCGI::STDOUT            => Stdout::class,\n"
    "        FastCGI::STDERR            => Stderr::class,\n"
    "        FastCGI::DATA              => Data::class,\n"
    "        FastCGI::GET_VALUES        => GetValues::class,\n"
    "        FastCGI::GET_VALUES_RESULT => GetValuesResult::class,\n"
    "        FastCGI::UNKNOWN_TYPE      => UnknownType::class,\n"
    "    ];\n"
    "\n"
    "    /**\n"
    "     * Checks if the buffer contains a valid frame to parse\n"
    "     */\n"
    "    public static function hasFrame(string $binaryBuffer): bool\n"
    "    {\n"
    "        $bufferLength = strlen($binaryBuffer);\n"
    "        if ($bufferLength < FastCGI::HEADER_LEN) {\n"
    "            return false;\n"
    "        }\n"
    "\n"
    "        /** @phpstan-var false|array{version: int, type: int, requestId: int, contentLength: int, paddingLength: int} */\n"
    "        $fastInfo = unpack(FastCGI::HEADER_FORMAT, $binaryBuffer);\n"
    "        if ($fastInfo === false) {\n"
    "            throw new \\RuntimeException('Can not unpack data from the binary buffer');\n"
    "        }\n"
    "        if ($bufferLength < FastCGI::HEADER_LEN + $fastInfo['contentLength'] + $fastInfo['paddingLength']) {\n"
    "            return false;\n"
    "        }\n"
    "\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Parses a frame from the binary buffer\n"
    "     *\n"
    "     * @return Record One of the corresponding FastCGI record\n"
    "     */\n"
    "    public static function parseFrame(string &$binaryBuffer): Record\n"
    "    {\n"
    "        $bufferLength = strlen($binaryBuffer);\n"
    "        if ($bufferLength < FastCGI::HEADER_LEN) {\n"
    "            throw new \\RuntimeException('Not enough data in the buffer to parse');\n"
    "        }\n"
    "        /** @phpstan-var false|array{version: int, type: int, requestId: int, contentLength: int, paddingLength: int} */\n"
    "        $recordHeader = unpack(FastCGI::HEADER_FORMAT, $binaryBuffer);\n"
    "        if ($recordHeader === false) {\n"
    "            throw new \\RuntimeException('Can not unpack data from the binary buffer');\n"
    "        }\n"
    "        $recordType = $recordHeader['type'];\n"
    "        if (!isset(self::$classMapping[$recordType])) {\n"
    "            throw new \\DomainException(\"Invalid FastCGI record type {$recordType} received\");\n"
    "        }\n"
    "\n"
    "        /** @var Record $className */\n"
    "        $className = self::$classMapping[$recordType];\n"
    "        $record    = $className::unpack($binaryBuffer);\n"
    "\n"
    "        $offset       = FastCGI::HEADER_LEN + $record->getContentLength() + $record->getPaddingLength();\n"
    "        $binaryBuffer = substr($binaryBuffer, $offset);\n"
    "\n"
    "        return $record;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_message =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI;\n"
    "\n"
    "class Message\n"
    "{\n"
    "    protected array $params = [];\n"
    "\n"
    "    protected string $body = '';\n"
    "\n"
    "    protected string $error = '';\n"
    "\n"
    "    public function getParam(string $name): ?string\n"
    "    {\n"
    "        return $this->params[$name] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withParam(string $name, string $value): static\n"
    "    {\n"
    "        $this->params[$name] = $value;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutParam(string $name): static\n"
    "    {\n"
    "        unset($this->params[$name]);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getParams(): array\n"
    "    {\n"
    "        return $this->params;\n"
    "    }\n"
    "\n"
    "    public function withParams(array $params): static\n"
    "    {\n"
    "        $this->params = $params;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withAddedParams(array $params): static\n"
    "    {\n"
    "        $this->params = $params + $this->params;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getBody(): string\n"
    "    {\n"
    "        return $this->body;\n"
    "    }\n"
    "\n"
    "    public function withBody(string|\\Stringable $body): self\n"
    "    {\n"
    "        $this->body = (string) $body;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getError(): string\n"
    "    {\n"
    "        return $this->error;\n"
    "    }\n"
    "\n"
    "    public function withError(string $error): static\n"
    "    {\n"
    "        $this->error = $error;\n"
    "        return $this;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_request =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record\\BeginRequest;\n"
    "use Swoole\\FastCGI\\Record\\Params;\n"
    "use Swoole\\FastCGI\\Record\\Stdin;\n"
    "\n"
    "class Request extends Message implements \\Stringable\n"
    "{\n"
    "    protected bool $keepConn = false;\n"
    "\n"
    "    public function __toString(): string\n"
    "    {\n"
    "        $body              = $this->getBody();\n"
    "        $beginRequestFrame = new BeginRequest(FastCGI::RESPONDER, $this->keepConn ? FastCGI::KEEP_CONN : 0);\n"
    "        $paramsFrame       = new Params($this->getParams());\n"
    "        $paramsEofFrame    = new Params([]);\n"
    "        if (empty($body)) {\n"
    "            $message = \"{$beginRequestFrame}{$paramsFrame}{$paramsEofFrame}\";\n"
    "        } else {\n"
    "            $stdinList = [];\n"
    "            while (true) {\n"
    "                $stdinList[] = $stdin = new Stdin($body);\n"
    "                $stdinLength = $stdin->getContentLength();\n"
    "                if ($stdinLength === strlen($body)) {\n"
    "                    break;\n"
    "                }\n"
    "                $body = substr($body, $stdinLength);\n"
    "            }\n"
    "            $stdinList[] = new Stdin('');\n"
    "            $stdin       = implode('', $stdinList);\n"
    "            $message     = \"{$beginRequestFrame}{$paramsFrame}{$paramsEofFrame}{$stdin}\";\n"
    "        }\n"
    "        return $message;\n"
    "    }\n"
    "\n"
    "    public function getKeepConn(): bool\n"
    "    {\n"
    "        return $this->keepConn;\n"
    "    }\n"
    "\n"
    "    public function withKeepConn(bool $keepConn): self\n"
    "    {\n"
    "        $this->keepConn = $keepConn;\n"
    "        return $this;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_response =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI;\n"
    "\n"
    "use Swoole\\FastCGI\\Record\\EndRequest;\n"
    "use Swoole\\FastCGI\\Record\\Stderr;\n"
    "use Swoole\\FastCGI\\Record\\Stdout;\n"
    "\n"
    "class Response extends Message\n"
    "{\n"
    "    /**\n"
    "     * @param array<Stdout|Stderr|EndRequest> $records\n"
    "     */\n"
    "    public function __construct(array $records)\n"
    "    {\n"
    "        if (!static::verify($records)) {\n"
    "            throw new \\InvalidArgumentException('Bad records');\n"
    "        }\n"
    "\n"
    "        $body = $error = '';\n"
    "        foreach ($records as $record) {\n"
    "            if ($record instanceof Stdout) {\n"
    "                if ($record->getContentLength() > 0) {\n"
    "                    $body .= $record->getContentData();\n"
    "                }\n"
    "            } elseif ($record instanceof Stderr) {\n"
    "                if ($record->getContentLength() > 0) {\n"
    "                    $error .= $record->getContentData();\n"
    "                }\n"
    "            }\n"
    "        }\n"
    "        $this->withBody($body)->withError($error);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param array<Stdout|Stderr|EndRequest> $records\n"
    "     */\n"
    "    protected static function verify(array $records): bool\n"
    "    {\n"
    "        return !empty($records) && $records[array_key_last($records)] instanceof EndRequest;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_http_request =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI;\n"
    "\n"
    "class HttpRequest extends Request\n"
    "{\n"
    "    protected array $params = [\n"
    "        'REQUEST_SCHEME'    => 'http',\n"
    "        'REQUEST_METHOD'    => 'GET',\n"
    "        'DOCUMENT_ROOT'     => '',\n"
    "        'SCRIPT_FILENAME'   => '',\n"
    "        'SCRIPT_NAME'       => '',\n"
    "        'DOCUMENT_URI'      => '/',\n"
    "        'REQUEST_URI'       => '/',\n"
    "        'QUERY_STRING'      => '',\n"
    "        'CONTENT_TYPE'      => 'text/plain',\n"
    "        'CONTENT_LENGTH'    => '0',\n"
    "        'GATEWAY_INTERFACE' => 'CGI/1.1',\n"
    "        'SERVER_PROTOCOL'   => 'HTTP/1.1',\n"
    "        'SERVER_SOFTWARE'   => 'swoole/' . SWOOLE_VERSION,\n"
    "        'REMOTE_ADDR'       => 'unknown',\n"
    "        'REMOTE_PORT'       => '0',\n"
    "        'SERVER_ADDR'       => 'unknown',\n"
    "        'SERVER_PORT'       => '0',\n"
    "        'SERVER_NAME'       => 'Swoole',\n"
    "        'REDIRECT_STATUS'   => '200',\n"
    "    ];\n"
    "\n"
    "    public function getScheme(): ?string\n"
    "    {\n"
    "        return $this->params['REQUEST_SCHEME'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withScheme(string $scheme): self\n"
    "    {\n"
    "        $this->params['REQUEST_SCHEME'] = $scheme;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutScheme(): void\n"
    "    {\n"
    "        unset($this->params['REQUEST_SCHEME']);\n"
    "    }\n"
    "\n"
    "    public function getMethod(): ?string\n"
    "    {\n"
    "        return $this->params['REQUEST_METHOD'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withMethod(string $method): self\n"
    "    {\n"
    "        $this->params['REQUEST_METHOD'] = $method;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutMethod(): void\n"
    "    {\n"
    "        unset($this->params['REQUEST_METHOD']);\n"
    "    }\n"
    "\n"
    "    public function getDocumentRoot(): ?string\n"
    "    {\n"
    "        return $this->params['DOCUMENT_ROOT'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withDocumentRoot(string $documentRoot): self\n"
    "    {\n"
    "        $this->params['DOCUMENT_ROOT'] = $documentRoot;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutDocumentRoot(): void\n"
    "    {\n"
    "        unset($this->params['DOCUMENT_ROOT']);\n"
    "    }\n"
    "\n"
    "    public function getScriptFilename(): ?string\n"
    "    {\n"
    "        return $this->params['SCRIPT_FILENAME'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withScriptFilename(string $scriptFilename): self\n"
    "    {\n"
    "        $this->params['SCRIPT_FILENAME'] = $scriptFilename;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutScriptFilename(): void\n"
    "    {\n"
    "        unset($this->params['SCRIPT_FILENAME']);\n"
    "    }\n"
    "\n"
    "    public function getScriptName(): ?string\n"
    "    {\n"
    "        return $this->params['SCRIPT_NAME'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withScriptName(string $scriptName): self\n"
    "    {\n"
    "        $this->params['SCRIPT_NAME'] = $scriptName;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutScriptName(): void\n"
    "    {\n"
    "        unset($this->params['SCRIPT_NAME']);\n"
    "    }\n"
    "\n"
    "    public function withUri(string $uri): self\n"
    "    {\n"
    "        $info = parse_url($uri);\n"
    "        return $this->withRequestUri($uri)\n"
    "            ->withDocumentUri($info['path'] ?? '')\n"
    "            ->withQueryString($info['query'] ?? '')\n"
    "        ;\n"
    "    }\n"
    "\n"
    "    public function getDocumentUri(): ?string\n"
    "    {\n"
    "        return $this->params['DOCUMENT_URI'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withDocumentUri(string $documentUri): self\n"
    "    {\n"
    "        $this->params['DOCUMENT_URI'] = $documentUri;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutDocumentUri(): void\n"
    "    {\n"
    "        unset($this->params['DOCUMENT_URI']);\n"
    "    }\n"
    "\n"
    "    public function getRequestUri(): ?string\n"
    "    {\n"
    "        return $this->params['REQUEST_URI'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withRequestUri(string $requestUri): self\n"
    "    {\n"
    "        $this->params['REQUEST_URI'] = $requestUri;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutRequestUri(): void\n"
    "    {\n"
    "        unset($this->params['REQUEST_URI']);\n"
    "    }\n"
    "\n"
    "    public function withQuery($query): self\n"
    "    {\n"
    "        if (is_array($query)) {\n"
    "            $query = http_build_query($query);\n"
    "        }\n"
    "        return $this->withQueryString($query);\n"
    "    }\n"
    "\n"
    "    public function getQueryString(): ?string\n"
    "    {\n"
    "        return $this->params['QUERY_STRING'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withQueryString(string $queryString): self\n"
    "    {\n"
    "        $this->params['QUERY_STRING'] = $queryString;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutQueryString(): void\n"
    "    {\n"
    "        unset($this->params['QUERY_STRING']);\n"
    "    }\n"
    "\n"
    "    public function getContentType(): ?string\n"
    "    {\n"
    "        return $this->params['CONTENT_TYPE'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withContentType(string $contentType): self\n"
    "    {\n"
    "        $this->params['CONTENT_TYPE'] = $contentType;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutContentType(): void\n"
    "    {\n"
    "        unset($this->params['CONTENT_TYPE']);\n"
    "    }\n"
    "\n"
    "    public function getContentLength(): ?int\n"
    "    {\n"
    "        return isset($this->params['CONTENT_LENGTH']) ? (int) $this->params['CONTENT_LENGTH'] : null;\n"
    "    }\n"
    "\n"
    "    public function withContentLength(int $contentLength): self\n"
    "    {\n"
    "        $this->params['CONTENT_LENGTH'] = (string) $contentLength;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutContentLength(): void\n"
    "    {\n"
    "        unset($this->params['CONTENT_LENGTH']);\n"
    "    }\n"
    "\n"
    "    public function getGatewayInterface(): ?string\n"
    "    {\n"
    "        return $this->params['GATEWAY_INTERFACE'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withGatewayInterface(string $gatewayInterface): self\n"
    "    {\n"
    "        $this->params['GATEWAY_INTERFACE'] = $gatewayInterface;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutGatewayInterface(): void\n"
    "    {\n"
    "        unset($this->params['GATEWAY_INTERFACE']);\n"
    "    }\n"
    "\n"
    "    public function getServerProtocol(): ?string\n"
    "    {\n"
    "        return $this->params['SERVER_PROTOCOL'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withServerProtocol(string $serverProtocol): self\n"
    "    {\n"
    "        $this->params['SERVER_PROTOCOL'] = $serverProtocol;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutServerProtocol(): void\n"
    "    {\n"
    "        unset($this->params['SERVER_PROTOCOL']);\n"
    "    }\n"
    "\n"
    "    public function withProtocolVersion(string $protocolVersion): self\n"
    "    {\n"
    "        if (!is_numeric($protocolVersion)) {\n"
    "            throw new \\InvalidArgumentException('Protocol version must be numeric');\n"
    "        }\n"
    "        $this->params['SERVER_PROTOCOL'] = \"HTTP/{$protocolVersion}\";\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getServerSoftware(): ?string\n"
    "    {\n"
    "        return $this->params['SERVER_SOFTWARE'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withServerSoftware(string $serverSoftware): self\n"
    "    {\n"
    "        $this->params['SERVER_SOFTWARE'] = $serverSoftware;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutServerSoftware(): void\n"
    "    {\n"
    "        unset($this->params['SERVER_SOFTWARE']);\n"
    "    }\n"
    "\n"
    "    public function getRemoteAddr(): ?string\n"
    "    {\n"
    "        return $this->params['REMOTE_ADDR'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withRemoteAddr(string $remoteAddr): self\n"
    "    {\n"
    "        $this->params['REMOTE_ADDR'] = $remoteAddr;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutRemoteAddr(): void\n"
    "    {\n"
    "        unset($this->params['REMOTE_ADDR']);\n"
    "    }\n"
    "\n"
    "    public function getRemotePort(): ?int\n"
    "    {\n"
    "        return isset($this->params['REMOTE_PORT']) ? (int) $this->params['REMOTE_PORT'] : null;\n"
    "    }\n"
    "\n"
    "    public function withRemotePort(int $remotePort): self\n"
    "    {\n"
    "        $this->params['REMOTE_PORT'] = (string) $remotePort;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutRemotePort(): void\n"
    "    {\n"
    "        unset($this->params['REMOTE_PORT']);\n"
    "    }\n"
    "\n"
    "    public function getServerAddr(): ?string\n"
    "    {\n"
    "        return $this->params['SERVER_ADDR'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withServerAddr(string $serverAddr): self\n"
    "    {\n"
    "        $this->params['SERVER_ADDR'] = $serverAddr;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutServerAddr(): void\n"
    "    {\n"
    "        unset($this->params['SERVER_ADDR']);\n"
    "    }\n"
    "\n"
    "    public function getServerPort(): ?int\n"
    "    {\n"
    "        return isset($this->params['SERVER_PORT']) ? (int) $this->params['SERVER_PORT'] : null;\n"
    "    }\n"
    "\n"
    "    public function withServerPort(int $serverPort): self\n"
    "    {\n"
    "        $this->params['SERVER_PORT'] = (string) $serverPort;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutServerPort(): void\n"
    "    {\n"
    "        unset($this->params['SERVER_PORT']);\n"
    "    }\n"
    "\n"
    "    public function getServerName(): ?string\n"
    "    {\n"
    "        return $this->params['SERVER_NAME'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withServerName(string $serverName): self\n"
    "    {\n"
    "        $this->params['SERVER_NAME'] = $serverName;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutServerName(): void\n"
    "    {\n"
    "        unset($this->params['SERVER_NAME']);\n"
    "    }\n"
    "\n"
    "    public function getRedirectStatus(): ?string\n"
    "    {\n"
    "        return $this->params['REDIRECT_STATUS'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withRedirectStatus(string $redirectStatus): self\n"
    "    {\n"
    "        $this->params['REDIRECT_STATUS'] = $redirectStatus;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutRedirectStatus(): void\n"
    "    {\n"
    "        unset($this->params['REDIRECT_STATUS']);\n"
    "    }\n"
    "\n"
    "    public function getHeader(string $name): ?string\n"
    "    {\n"
    "        return $this->params[static::convertHeaderNameToParamName($name)] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withHeader(string $name, string $value): self\n"
    "    {\n"
    "        $this->params[static::convertHeaderNameToParamName($name)] = $value;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutHeader(string $name): void\n"
    "    {\n"
    "        unset($this->params[static::convertHeaderNameToParamName($name)]);\n"
    "    }\n"
    "\n"
    "    public function getHeaders(): array\n"
    "    {\n"
    "        $headers = [];\n"
    "        foreach ($this->params as $name => $value) {\n"
    "            if (str_starts_with($name, 'HTTP_')) {\n"
    "                $headers[static::convertParamNameToHeaderName($name)] = $value;\n"
    "            }\n"
    "        }\n"
    "        return $headers;\n"
    "    }\n"
    "\n"
    "    public function withHeaders(array $headers): self\n"
    "    {\n"
    "        foreach ($headers as $name => $value) {\n"
    "            $this->withHeader($name, $value);\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withBody(array|string|\\Stringable $body): self\n"
    "    {\n"
    "        if (is_array($body)) {\n"
    "            $body = http_build_query($body);\n"
    "            $this->withContentType('application/x-www-form-urlencoded');\n"
    "        }\n"
    "        parent::withBody($body);\n"
    "\n"
    "        return $this->withContentLength(strlen($body));\n"
    "    }\n"
    "\n"
    "    protected static function convertHeaderNameToParamName(string $name)\n"
    "    {\n"
    "        return 'HTTP_' . str_replace('-', '_', strtoupper($name));\n"
    "    }\n"
    "\n"
    "    protected static function convertParamNameToHeaderName(string $name)\n"
    "    {\n"
    "        return ucwords(str_replace('_', '-', substr($name, strlen('HTTP_'))), '-');\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_http_response =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI;\n"
    "\n"
    "use Swoole\\FastCGI\\Record\\EndRequest;\n"
    "use Swoole\\FastCGI\\Record\\Stderr;\n"
    "use Swoole\\FastCGI\\Record\\Stdout;\n"
    "use Swoole\\Http\\Status;\n"
    "\n"
    "class HttpResponse extends Response\n"
    "{\n"
    "    /** @var int */\n"
    "    protected $statusCode;\n"
    "\n"
    "    /** @var string */\n"
    "    protected $reasonPhrase;\n"
    "\n"
    "    /**\n"
    "     * @var array<string, string>\n"
    "     */\n"
    "    protected array $headers = [];\n"
    "\n"
    "    /**\n"
    "     * @var array<string, string>\n"
    "     */\n"
    "    protected array $headersMap = [];\n"
    "\n"
    "    /**\n"
    "     * @var array<string>\n"
    "     */\n"
    "    protected array $setCookieHeaderLines = [];\n"
    "\n"
    "    /**\n"
    "     * @param array<Stdout|Stderr|EndRequest> $records\n"
    "     */\n"
    "    public function __construct(array $records = [])\n"
    "    {\n"
    "        parent::__construct($records);\n"
    "        $body = $this->getBody();\n"
    "        if (strlen($body) === 0) {\n"
    "            return;\n"
    "        }\n"
    "        $array = explode(\"\\r\\n\\r\\n\", $body, 2); // An array that contains the HTTP headers and the body.\n"
    "        if (count($array) != 2) {\n"
    "            $this->withStatusCode(Status::BAD_GATEWAY)->withReasonPhrase('Invalid FastCGI Response')->withError($body);\n"
    "            return;\n"
    "        }\n"
    "        $headers = explode(\"\\r\\n\", $array[0]);\n"
    "        $body    = $array[1];\n"
    "        foreach ($headers as $header) {\n"
    "            $array = explode(':', $header, 2); // An array that contains the name and the value of an HTTP header.\n"
    "            if (count($array) != 2) {\n"
    "                continue; // Invalid HTTP header? Ignore it!\n"
    "            }\n"
    "            $name  = trim($array[0]);\n"
    "            $value = trim($array[1]);\n"
    "            if (strcasecmp($name, 'Status') === 0) {\n"
    "                $array        = explode(' ', $value, 2); // An array that contains the status code (and the reason phrase).\n"
    "                $statusCode   = $array[0];\n"
    "                $reasonPhrase = $array[1] ?? null;\n"
    "            } elseif (strcasecmp($name, 'Set-Cookie') === 0) {\n"
    "                $this->withSetCookieHeaderLine($value);\n"
    "            } else {\n"
    "                $this->withHeader($name, $value);\n"
    "            }\n"
    "        }\n"
    "        $statusCode   = (int) ($statusCode ?? Status::OK);\n"
    "        $reasonPhrase = $reasonPhrase ?? Status::getReasonPhrase($statusCode);\n"
    "        $this->withStatusCode($statusCode)->withReasonPhrase($reasonPhrase);\n"
    "        $this->withBody($body);\n"
    "    }\n"
    "\n"
    "    public function getStatusCode(): int\n"
    "    {\n"
    "        return $this->statusCode;\n"
    "    }\n"
    "\n"
    "    public function withStatusCode(int $statusCode): self\n"
    "    {\n"
    "        $this->statusCode = $statusCode;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getReasonPhrase(): string\n"
    "    {\n"
    "        return $this->reasonPhrase;\n"
    "    }\n"
    "\n"
    "    public function withReasonPhrase(string $reasonPhrase): self\n"
    "    {\n"
    "        $this->reasonPhrase = $reasonPhrase;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getHeader(string $name): ?string\n"
    "    {\n"
    "        $name = $this->headersMap[strtolower($name)] ?? null;\n"
    "        return $name ? $this->headers[$name] : null;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return array<string, string>\n"
    "     */\n"
    "    public function getHeaders(): array\n"
    "    {\n"
    "        return $this->headers;\n"
    "    }\n"
    "\n"
    "    public function withHeader(string $name, string $value): self\n"
    "    {\n"
    "        $this->headers[$name]                = $value;\n"
    "        $this->headersMap[strtolower($name)] = $name;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param array<string, string> $headers\n"
    "     */\n"
    "    public function withHeaders(array $headers): self\n"
    "    {\n"
    "        foreach ($headers as $name => $value) {\n"
    "            $this->withHeader($name, $value);\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return array<string>\n"
    "     */\n"
    "    public function getSetCookieHeaderLines(): array\n"
    "    {\n"
    "        return $this->setCookieHeaderLines;\n"
    "    }\n"
    "\n"
    "    public function withSetCookieHeaderLine(string $value): self\n"
    "    {\n"
    "        $this->setCookieHeaderLines[] = $value;\n"
    "        return $this;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_fast_cgi_client =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine\\FastCGI;\n"
    "\n"
    "use Swoole\\Constant;\n"
    "use Swoole\\Coroutine\\FastCGI\\Client\\Exception;\n"
    "use Swoole\\Coroutine\\Socket;\n"
    "use Swoole\\FastCGI\\FrameParser;\n"
    "use Swoole\\FastCGI\\HttpRequest;\n"
    "use Swoole\\FastCGI\\HttpResponse;\n"
    "use Swoole\\FastCGI\\Record\\EndRequest;\n"
    "use Swoole\\FastCGI\\Request;\n"
    "use Swoole\\FastCGI\\Response;\n"
    "\n"
    "class Client\n"
    "{\n"
    "    protected int $af;\n"
    "\n"
    "    protected string $host;\n"
    "\n"
    "    protected int $port;\n"
    "\n"
    "    protected bool $ssl;\n"
    "\n"
    "    protected ?Socket $socket;\n"
    "\n"
    "    public function __construct(string $host, int $port = 0, bool $ssl = false)\n"
    "    {\n"
    "        if (stripos($host, 'unix:/') === 0) {\n"
    "            $this->af = AF_UNIX;\n"
    "            $host     = '/' . ltrim(substr($host, strlen('unix:/')), '/');\n"
    "            $port     = 0;\n"
    "        } elseif (str_contains($host, ':')) {\n"
    "            $this->af = AF_INET6;\n"
    "        } else {\n"
    "            $this->af = AF_INET;\n"
    "        }\n"
    "        $this->host = $host;\n"
    "        $this->port = $port;\n"
    "        $this->ssl  = $ssl;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return ($request is HttpRequest ? HttpResponse : Response)\n"
    "     * @throws Exception\n"
    "     */\n"
    "    public function execute(Request $request, float $timeout = -1): Response\n"
    "    {\n"
    "        if (!isset($this->socket)) {\n"
    "            $this->socket = $socket = new Socket($this->af, SOCK_STREAM, IPPROTO_IP);\n"
    "            $socket->setProtocol([\n"
    "                Constant::OPTION_OPEN_SSL              => $this->ssl,\n"
    "                Constant::OPTION_OPEN_FASTCGI_PROTOCOL => true,\n"
    "            ]);\n"
    "            if (!$socket->connect($this->host, $this->port, $timeout)) {\n"
    "                $this->ioException();\n"
    "            }\n"
    "        } else {\n"
    "            $socket = $this->socket;\n"
    "        }\n"
    "        $sendData = (string) $request;\n"
    "        if ($socket->sendAll($sendData) !== strlen($sendData)) {\n"
    "            $this->ioException();\n"
    "        }\n"
    "        $records = [];\n"
    "        while (true) {\n"
    "            $recvData = $socket->recvPacket($timeout);\n"
    "            if (!$recvData) {\n"
    "                if ($recvData === '') {\n"
    "                    $this->ioException(SOCKET_ECONNRESET);\n"
    "                }\n"
    "                $this->ioException();\n"
    "            }\n"
    "            if (!FrameParser::hasFrame($recvData)) {\n"
    "                $this->ioException(SOCKET_EPROTO);\n"
    "            }\n"
    "\n"
    "            do {\n"
    "                $records[] = $record = FrameParser::parseFrame($recvData);\n"
    "            } while (strlen($recvData) !== 0);\n"
    "            if ($record instanceof EndRequest) {\n"
    "                if (!$request->getKeepConn()) {\n"
    "                    $this->socket->close();\n"
    "                    $this->socket = null;\n"
    "                }\n"
    "                // @phpstan-ignore argument.type,argument.type\n"
    "                return ($request instanceof HttpRequest) ? new HttpResponse($records) : new Response($records);\n"
    "            }\n"
    "        }\n"
    "\n"
    "        // Code execution should never reach here. However, we still put an exit() statement here for safe purpose.\n"
    "        exit(1); // @phpstan-ignore deadCode.unreachable\n"
    "    }\n"
    "\n"
    "    public static function parseUrl(string $url): array\n"
    "    {\n"
    "        $url  = parse_url($url);\n"
    "        $host = $url['host'] ?? '';\n"
    "        $port = $url['port'] ?? 0;\n"
    "        if (empty($host)) {\n"
    "            $host = $url['path'] ?? '';\n"
    "            if (empty($host)) {\n"
    "                throw new \\InvalidArgumentException('Invalid url');\n"
    "            }\n"
    "            $host = \"unix:/{$host}\";\n"
    "        }\n"
    "        return [$host, $port];\n"
    "    }\n"
    "\n"
    "    public static function call(string $url, string $path, $data = '', float $timeout = -1): string\n"
    "    {\n"
    "        $client      = new Client(...static::parseUrl($url));\n"
    "        $pathInfo    = parse_url($path);\n"
    "        $path        = $pathInfo['path'] ?? '';\n"
    "        $root        = dirname($path);\n"
    "        $scriptName  = '/' . basename($path);\n"
    "        $documentUri = $scriptName;\n"
    "        $query       = $pathInfo['query'] ?? '';\n"
    "        $requestUri  = $query ? \"{$documentUri}?{$query}\" : $documentUri;\n"
    "        $request     = new HttpRequest();\n"
    "        $request->withDocumentRoot($root)\n"
    "            ->withScriptFilename($path)\n"
    "            ->withScriptName($documentUri)\n"
    "            ->withDocumentUri($documentUri)\n"
    "            ->withRequestUri($requestUri)\n"
    "            ->withQueryString($query)\n"
    "            ->withBody($data)\n"
    "            ->withMethod($request->getContentLength() === 0 ? 'GET' : 'POST')\n"
    "        ;\n"
    "        $response = $client->execute($request, $timeout);\n"
    "        return $response->getBody();\n"
    "    }\n"
    "\n"
    "    protected function ioException(?int $errno = null): void\n"
    "    {\n"
    "        $socket = $this->socket;\n"
    "        if ($errno !== null) {\n"
    "            $socket->errCode = $errno;\n"
    "            $socket->errMsg  = swoole_strerror($errno);\n"
    "        }\n"
    "        $socket->close();\n"
    "        $this->socket = null;\n"
    "        throw new Exception($socket->errMsg, $socket->errCode);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_fast_cgi_client_exception =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine\\FastCGI\\Client;\n"
    "\n"
    "class Exception extends \\Swoole\\Exception\n"
    "{\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_fast_cgi_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine\\FastCGI;\n"
    "\n"
    "use Swoole\\FastCGI\\HttpRequest;\n"
    "use Swoole\\FastCGI\\HttpResponse;\n"
    "use Swoole\\Http;\n"
    "use Swoole\\Http\\Request as SwooleHttpRequest;\n"
    "use Swoole\\Http\\Response as SwooleHttpResponse;\n"
    "\n"
    "class Proxy\n"
    "{\n"
    "    /* @var string */\n"
    "    protected $host;\n"
    "\n"
    "    /* @var int */\n"
    "    protected $port;\n"
    "\n"
    "    /* @var float */\n"
    "    protected $timeout = -1;\n"
    "\n"
    "    /* @var string */\n"
    "    protected $documentRoot;\n"
    "\n"
    "    /* @var bool */\n"
    "    protected $https = false;\n"
    "\n"
    "    /* @var string */\n"
    "    protected $index = 'index.php';\n"
    "\n"
    "    /* @var array */\n"
    "    protected $params = [];\n"
    "\n"
    "    /* @var null|callable */\n"
    "    protected $staticFileFilter;\n"
    "\n"
    "    public function __construct(string $url, string $documentRoot = '/')\n"
    "    {\n"
    "        [$this->host, $this->port] = Client::parseUrl($url);\n"
    "        $this->documentRoot        = $documentRoot;\n"
    "        $this->staticFileFilter    = [$this, 'staticFileFiltrate'];\n"
    "    }\n"
    "\n"
    "    public function withTimeout(float $timeout): self\n"
    "    {\n"
    "        $this->timeout = $timeout;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withHttps(bool $https): self\n"
    "    {\n"
    "        $this->https = $https;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withIndex(string $index): self\n"
    "    {\n"
    "        $this->index = $index;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getParam(string $name): ?string\n"
    "    {\n"
    "        return $this->params[$name] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withParam(string $name, string $value): self\n"
    "    {\n"
    "        $this->params[$name] = $value;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutParam(string $name): self\n"
    "    {\n"
    "        unset($this->params[$name]);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getParams(): array\n"
    "    {\n"
    "        return $this->params;\n"
    "    }\n"
    "\n"
    "    public function withParams(array $params): self\n"
    "    {\n"
    "        $this->params = $params;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withAddedParams(array $params): self\n"
    "    {\n"
    "        $this->params = $params + $this->params;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withStaticFileFilter(?callable $filter): self\n"
    "    {\n"
    "        $this->staticFileFilter = $filter;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function translateRequest(SwooleHttpRequest $userRequest): HttpRequest\n"
    "    {\n"
    "        $server   = $userRequest->server;\n"
    "        $headers  = $userRequest->header;\n"
    "        $pathInfo = $userRequest->server['path_info'];\n"
    "        $pathInfo = '/' . ltrim($pathInfo, '/');\n"
    "        if (strlen($this->index) !== 0) {\n"
    "            $extension = pathinfo($pathInfo, PATHINFO_EXTENSION);\n"
    "            if (empty($extension)) {\n"
    "                $pathInfo = rtrim($pathInfo, '/') . '/' . $this->index;\n"
    "            }\n"
    "        }\n"
    "        $requestUri  = $scriptName = $documentUri = $server['request_uri'];\n"
    "        $queryString = $server['query_string'] ?? '';\n"
    "        if (strlen($queryString) !== 0) {\n"
    "            $requestUri .= \"?{$server['query_string']}\";\n"
    "        }\n"
    "        $request = (new HttpRequest())\n"
    "            ->withDocumentRoot($this->documentRoot)\n"
    "            ->withScriptFilename($this->documentRoot . $pathInfo)\n"
    "            ->withScriptName($scriptName)\n"
    "            ->withDocumentUri($documentUri)\n"
    "            ->withServerProtocol($server['server_protocol'])\n"
    "            ->withServerAddr('127.0.0.1')\n"
    "            ->withServerPort($server['server_port'])\n"
    "            ->withRemoteAddr($server['remote_addr'])\n"
    "            ->withRemotePort($server['remote_port'])\n"
    "            ->withMethod($server['request_method'])\n"
    "            ->withRequestUri($requestUri)\n"
    "            ->withQueryString($queryString)\n"
    "            ->withContentType($headers['content-type'] ?? '')\n"
    "            ->withContentLength((int) ($headers['content-length'] ?? 0))\n"
    "            ->withHeaders($headers)\n"
    "            ->withBody($userRequest->rawContent())\n"
    "            ->withAddedParams($this->params)\n"
    "        ;\n"
    "        if ($this->https) {\n"
    "            $request->withParam('HTTPS', '1');\n"
    "        }\n"
    "\n"
    "        return $request;\n"
    "    }\n"
    "\n"
    "    public function translateResponse(HttpResponse $response, SwooleHttpResponse $userResponse): void\n"
    "    {\n"
    "        $userResponse->status($response->getStatusCode(), $response->getReasonPhrase());\n"
    "        $userResponse->header = $response->getHeaders();\n"
    "        $userResponse->cookie = $response->getSetCookieHeaderLines();\n"
    "        $userResponse->end($response->getBody());\n"
    "    }\n"
    "\n"
    "    public function pass(SwooleHttpRequest|HttpRequest $userRequest, SwooleHttpResponse $userResponse): void\n"
    "    {\n"
    "        if (!$userRequest instanceof HttpRequest) {\n"
    "            $request = $this->translateRequest($userRequest);\n"
    "        } else {\n"
    "            $request = $userRequest;\n"
    "        }\n"
    "        unset($userRequest);\n"
    "        if ($this->staticFileFilter) {\n"
    "            $filter = $this->staticFileFilter;\n"
    "            if ($filter($request, $userResponse)) {\n"
    "                return;\n"
    "            }\n"
    "        }\n"
    "        $response = (new Client($this->host, $this->port))->execute($request, $this->timeout);\n"
    "        $this->translateResponse($response, $userResponse);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Send content of a static file to the client, if the file is accessible and is not a PHP file.\n"
    "     *\n"
    "     * @return bool True if the file doesn't have an extension of 'php', false otherwise. Note that the file may not be\n"
    "     *              accessible even the return value is true.\n"
    "     */\n"
    "    public function staticFileFiltrate(HttpRequest $request, SwooleHttpResponse $userResponse): bool\n"
    "    {\n"
    "        $extension = pathinfo($request->getScriptFilename(), PATHINFO_EXTENSION);\n"
    "        if ($extension !== 'php') {\n"
    "            $realPath = realpath($request->getScriptFilename());\n"
    "            if (!$realPath || !str_starts_with($realPath, $this->documentRoot) || !is_file($realPath)) {\n"
    "                $userResponse->status(Http\\Status::NOT_FOUND);\n"
    "            } else {\n"
    "                $userResponse->sendfile($realPath);\n"
    "            }\n"
    "            return true;\n"
    "        }\n"
    "        return false;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_process_manager =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Process;\n"
    "\n"
    "use Swoole\\Constant;\n"
    "\n"
    "use function Swoole\\Coroutine\\run;\n"
    "\n"
    "class Manager\n"
    "{\n"
    "    /**\n"
    "     * @var Pool\n"
    "     */\n"
    "    protected $pool;\n"
    "\n"
    "    /**\n"
    "     * @var int\n"
    "     */\n"
    "    protected $ipcType = SWOOLE_IPC_NONE;\n"
    "\n"
    "    /**\n"
    "     * @var int\n"
    "     */\n"
    "    protected $msgQueueKey = 0;\n"
    "\n"
    "    /**\n"
    "     * @var array\n"
    "     */\n"
    "    protected $startFuncMap = [];\n"
    "\n"
    "    public function __construct(int $ipcType = SWOOLE_IPC_NONE, int $msgQueueKey = 0)\n"
    "    {\n"
    "        $this->setIPCType($ipcType)->setMsgQueueKey($msgQueueKey);\n"
    "    }\n"
    "\n"
    "    public function add(callable $func, bool $enableCoroutine = false): self\n"
    "    {\n"
    "        $this->addBatch(1, $func, $enableCoroutine);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function addBatch(int $workerNum, callable $func, bool $enableCoroutine = false): self\n"
    "    {\n"
    "        for ($i = 0; $i < $workerNum; $i++) {\n"
    "            $this->startFuncMap[] = [$func, $enableCoroutine];\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function start(): void\n"
    "    {\n"
    "        $this->pool = new Pool(count($this->startFuncMap), $this->ipcType, $this->msgQueueKey, false);\n"
    "\n"
    "        $this->pool->on(Constant::EVENT_WORKER_START, function (Pool $pool, int $workerId) {\n"
    "            [$func, $enableCoroutine] = $this->startFuncMap[$workerId];\n"
    "            if ($enableCoroutine) {\n"
    "                run($func, $pool, $workerId);\n"
    "            } else {\n"
    "                $func($pool, $workerId);\n"
    "            }\n"
    "        });\n"
    "\n"
    "        $this->pool->start();\n"
    "    }\n"
    "\n"
    "    public function setIPCType(int $ipcType): self\n"
    "    {\n"
    "        $this->ipcType = $ipcType;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getIPCType(): int\n"
    "    {\n"
    "        return $this->ipcType;\n"
    "    }\n"
    "\n"
    "    public function setMsgQueueKey(int $msgQueueKey): self\n"
    "    {\n"
    "        $this->msgQueueKey = $msgQueueKey;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getMsgQueueKey(): int\n"
    "    {\n"
    "        return $this->msgQueueKey;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_server_admin =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Server;\n"
    "\n"
    "use Swoole\\Coroutine;\n"
    "use Swoole\\Http\\Request;\n"
    "use Swoole\\Http\\Response;\n"
    "use Swoole\\Server;\n"
    "use Swoole\\StringObject;\n"
    "use Swoole\\Timer;\n"
    "\n"
    "class Admin\n"
    "{\n"
    "    /**\n"
    "     * gdb php\n"
    "     * (gdb) p sizeof(zval)\n"
    "     * $2 = 16\n"
    "     * (gdb) p sizeof(zend_array)\n"
    "     * $1 = 56\n"
    "     * (gdb) p sizeof(zend_string)\n"
    "     * $3 = 32\n"
    "     * (gdb) p sizeof(zend_object)\n"
    "     * $4 = 56\n"
    "     */\n"
    "    public const SIZE_OF_ZVAL = 16;\n"
    "\n"
    "    public const SIZE_OF_ZEND_STRING = 32;\n"
    "\n"
    "    public const SIZE_OF_ZEND_OBJECT = 56;\n"
    "\n"
    "    public const SIZE_OF_ZEND_ARRAY = 56;\n"
    "\n"
    "    private static array $map = [\n"
    "        'reactor'        => SWOOLE_SERVER_COMMAND_REACTOR_THREAD,\n"
    "        'reactor_thread' => SWOOLE_SERVER_COMMAND_REACTOR_THREAD,\n"
    "        'worker'         => SWOOLE_SERVER_COMMAND_EVENT_WORKER,\n"
    "        'event_worker'   => SWOOLE_SERVER_COMMAND_EVENT_WORKER,\n"
    "        'task'           => SWOOLE_SERVER_COMMAND_TASK_WORKER,\n"
    "        'task_worker'    => SWOOLE_SERVER_COMMAND_TASK_WORKER,\n"
    "    ];\n"
    "\n"
    "    private static array $allList = [\n"
    "        'all',\n"
    "        'all_reactor',\n"
    "        'all_reactor_thread',\n"
    "        'all_worker',\n"
    "        'all_event_worker',\n"
    "        'all_task',\n"
    "        'all_task_worker',\n"
    "        'specific',\n"
    "    ];\n"
    "\n"
    "    private static array $postMethodList = [\n"
    "        'server_reload',\n"
    "        'server_shutdown',\n"
    "        'close_session',\n"
    "    ];\n"
    "\n"
    "    private static string $accessToken = '';\n"
    "\n"
    "    public static function init(Server $server): void\n"
    "    {\n"
    "        $accepted_process_types = SWOOLE_SERVER_COMMAND_MASTER |\n"
    "            SWOOLE_SERVER_COMMAND_MANAGER |\n"
    "            SWOOLE_SERVER_COMMAND_EVENT_WORKER |\n"
    "            SWOOLE_SERVER_COMMAND_TASK_WORKER;\n"
    "\n"
    "        $server->addCommand(\n"
    "            'server_reload',\n"
    "            $accepted_process_types,\n"
    "            function (Server $server, string $msg) {\n"
    "                $server->reload();\n"
    "                return self::json('Operation succeeded');\n"
    "            }\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'server_shutdown',\n"
    "            $accepted_process_types,\n"
    "            function (Server $server, string $msg): void {\n"
    "                $server->shutdown();\n"
    "            }\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'coroutine_stats',\n"
    "            $accepted_process_types,\n"
    "            fn (Server $server, string $msg) => self::json(Coroutine::stats())\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'coroutine_list',\n"
    "            $accepted_process_types,\n"
    "            fn (Server $server, string $msg) => self::json(iterator_to_array(Coroutine::list()))\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'coroutine_bt',\n"
    "            $accepted_process_types,\n"
    "            function (Server $server, string $msg) {\n"
    "                $json = json_decode($msg, null, 512, JSON_THROW_ON_ERROR);\n"
    "                $cid  = empty($json->cid) ? 0 : intval($json->cid);\n"
    "                $bt   = Coroutine::getBackTrace($cid);\n"
    "                if ($bt === false) {\n"
    "                    return self::json(\"Coroutine#{$cid} not exists\", 4004);\n"
    "                }\n"
    "                return self::json($bt);\n"
    "            }\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'server_stats',\n"
    "            $accepted_process_types,\n"
    "            fn (Server $server, string $msg) => self::json($server->stats())\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'server_setting',\n"
    "            $accepted_process_types,\n"
    "            function (Server $server, string $msg) {\n"
    "                $setting                = $server->setting;\n"
    "                $setting['mode']        = $server->mode;\n"
    "                $setting['host']        = $server->host;\n"
    "                $setting['port']        = $server->port;\n"
    "                $setting['master_pid']  = $server->master_pid;\n"
    "                $setting['manager_pid'] = $server->manager_pid;\n"
    "                return self::json($setting);\n"
    "            }\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'get_client_info',\n"
    "            $accepted_process_types,\n"
    "            function (Server $server, string $msg) {\n"
    "                $json = json_decode($msg, true, 512, JSON_THROW_ON_ERROR);\n"
    "                if (empty($json['session_id'])) {\n"
    "                    return self::json('require session_id', 4003);\n"
    "                }\n"
    "                return self::json($server->getClientInfo(intval($json['session_id'])));\n"
    "            }\n"
    "        );\n"
    "\n"
    "        $server->addCommand('close_session', $accepted_process_types, [self::class, 'handlerCloseSession']);\n"
    "        $server->addCommand('get_version_info', $accepted_process_types, [self::class, 'handlerGetVersionInfo']);\n"
    "        $server->addCommand('get_worker_info', $accepted_process_types, [self::class, 'handlerGetWorkerInfo']);\n"
    "        $server->addCommand('get_timer_list', $accepted_process_types, [self::class, 'handlerGetTimerList']);\n"
    "        $server->addCommand('get_coroutine_list', $accepted_process_types, [self::class, 'handlerGetCoroutineList']);\n"
    "        $server->addCommand('get_objects', $accepted_process_types, [self::class, 'handlerGetObjects']);\n"
    "        $server->addCommand('get_class_info', $accepted_process_types, [self::class, 'handlerGetClassInfo']);\n"
    "        $server->addCommand('get_function_info', $accepted_process_types, [self::class, 'handlerGetFunctionInfo']);\n"
    "        $server->addCommand('get_object_by_handle', $accepted_process_types, [self::class, 'handlerGetObjectByHandle']);\n"
    "        $server->addCommand('get_server_cpu_usage', $accepted_process_types, [self::class, 'handlerGetServerCpuUsage']);\n"
    "        $server->addCommand(\n"
    "            'get_server_memory_usage',\n"
    "            $accepted_process_types,\n"
    "            [self::class, 'handlerGetServerMemoryUsage']\n"
    "        );\n"
    "        $server->addCommand(\n"
    "            'get_static_property_value',\n"
    "            $accepted_process_types,\n"
    "            [self::class, 'handlerGetStaticPropertyValue']\n"
    "        );\n"
    "        $server->addCommand(\n"
    "            'get_defined_functions',\n"
    "            $accepted_process_types,\n"
    "            [self::class, 'handlerGetDefinedFunctions']\n"
    "        );\n"
    "        $server->addCommand('get_declared_classes', $accepted_process_types, [self::class, 'handlerGetDeclaredClasses']);\n"
    "\n"
    "        $server->addCommand(\n"
    "            'gc_status',\n"
    "            $accepted_process_types,\n"
    "            function (Server $server, string $msg) {\n"
    "                return self::json(gc_status());\n"
    "            }\n"
    "        );\n"
    "\n"
    "        if (extension_loaded('opcache')) {\n"
    "            $server->addCommand(\n"
    "                'opcache_status',\n"
    "                $accepted_process_types,\n"
    "                fn (Server $server, string $msg) => self::json(opcache_get_status(true))\n"
    "            );\n"
    "        }\n"
    "\n"
    "        $server->addCommand(\n"
    "            'getpid',\n"
    "            $accepted_process_types,\n"
    "            fn (Server $server, string $msg) => self::json(['pid' => posix_getpid()])\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'memory_usage',\n"
    "            $accepted_process_types,\n"
    "            fn (Server $server, string $msg) => self::json([\n"
    "                'usage'      => memory_get_usage(),\n"
    "                'real_usage' => memory_get_usage(true),\n"
    "            ])\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'get_included_files',\n"
    "            $accepted_process_types,\n"
    "            fn (Server $server, string $msg) => self::json(['files' => get_included_files()])\n"
    "        );\n"
    "\n"
    "        $server->addCommand('get_resources', $accepted_process_types, [self::class, 'handlerGetResources']);\n"
    "\n"
    "        $server->addCommand(\n"
    "            'get_defined_constants',\n"
    "            $accepted_process_types,\n"
    "            function (Server $server, string $msg) {\n"
    "                $constants = get_defined_constants();\n"
    "                foreach ($constants as $k => $c) {\n"
    "                    if (is_resource($c)) {\n"
    "                        unset($constants[$k]);\n"
    "                    }\n"
    "                }\n"
    "                unset($constants['NULL'], $constants['NAN'], $constants['INF']);\n"
    "                return self::json($constants);\n"
    "            }\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'get_loaded_extensions',\n"
    "            $accepted_process_types,\n"
    "            function (Server $server, string $msg) {\n"
    "                $extensions = get_loaded_extensions();\n"
    "                $list       = [];\n"
    "                foreach ($extensions as $key => $extension) {\n"
    "                    $ext        = new \\ReflectionExtension($extension);\n"
    "                    $list[$key] = [\n"
    "                        'id'      => ++$key,\n"
    "                        'name'    => $extension,\n"
    "                        'version' => (string) $ext->getVersion(),\n"
    "                    ];\n"
    "                }\n"
    "                return self::json($list);\n"
    "            }\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'get_declared_interfaces',\n"
    "            $accepted_process_types,\n"
    "            fn (Server $server, string $msg) => self::json(get_declared_interfaces())\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'get_declared_traits',\n"
    "            $accepted_process_types,\n"
    "            fn (Server $server, string $msg) => self::json(get_declared_traits())\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'get_included_file_contents',\n"
    "            $accepted_process_types,\n"
    "            function (Server $server, string $msg) {\n"
    "                $json = json_decode($msg, true, 512, JSON_THROW_ON_ERROR);\n"
    "                if (empty($json['filename'])) {\n"
    "                    return self::json('require filename', 4003);\n"
    "                }\n"
    "\n"
    "                if (!file_exists($json['filename'])) {\n"
    "                    return self::json(\"{$json['filename']} not exist\", 4004);\n"
    "                }\n"
    "\n"
    "                if (!in_array($json['filename'], get_included_files())) {\n"
    "                    return self::json('no permission', 4003);\n"
    "                }\n"
    "\n"
    "                return self::json(file_get_contents($json['filename']));\n"
    "            }\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'get_globals',\n"
    "            $accepted_process_types,\n"
    "            function (Server $server, string $msg) {\n"
    "                $globals = [];\n"
    "                foreach ($GLOBALS as $key => $item) {\n"
    "                    if ($key === 'GLOBALS') {\n"
    "                        continue;\n"
    "                    }\n"
    "                    $type  = gettype($item);\n"
    "                    $other = [];\n"
    "                    if ($type === 'object') {\n"
    "                        $other = [\n"
    "                            'class_name'  => $item::class,\n"
    "                            'object_id'   => spl_object_id($item),\n"
    "                            'object_hash' => spl_object_hash($item),\n"
    "                        ];\n"
    "                    }\n"
    "                    if ($type == 'resource' || $type == 'resource (closed)') {\n"
    "                        $item = '';\n"
    "                    }\n"
    "                    $globals[] = [\n"
    "                        'key'   => $key,\n"
    "                        'value' => $item,\n"
    "                        'type'  => $type,\n"
    "                        'other' => $other,\n"
    "                    ];\n"
    "                }\n"
    "                return self::json($globals);\n"
    "            }\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'get_extension_info',\n"
    "            $accepted_process_types,\n"
    "            function (Server $server, string $msg) {\n"
    "                $json = json_decode($msg, true, 512, JSON_THROW_ON_ERROR);\n"
    "\n"
    "                if (empty($json['extension_name']) || !extension_loaded($json['extension_name'])) {\n"
    "                    return self::json('require extension_name', 4004);\n"
    "                }\n"
    "\n"
    "                $ext = new \\ReflectionExtension($json['extension_name']);\n"
    "\n"
    "                ob_start();\n"
    "                $ext->info();\n"
    "                $info = ob_get_clean();\n"
    "\n"
    "                $constants = $ext->getConstants();\n"
    "                foreach ($constants as $k => $c) {\n"
    "                    if (is_resource($c)) {\n"
    "                        unset($constants[$k]);\n"
    "                    }\n"
    "                }\n"
    "\n"
    "                unset($constants['NULL'], $constants['NAN'], $constants['INF']);\n"
    "\n"
    "                return self::json([\n"
    "                    'classes'      => $ext->getClassNames(),\n"
    "                    'version'      => $ext->getVersion(),\n"
    "                    'constants'    => $constants,\n"
    "                    'ini_entries'  => $ext->getINIEntries(),\n"
    "                    'dependencies' => $ext->getDependencies(),\n"
    "                    'functions'    => array_keys($ext->getFunctions()),\n"
    "                    'info'         => trim($info),\n"
    "                ]);\n"
    "            }\n"
    "        );\n"
    "\n"
    "        $server->addCommand(\n"
    "            'get_composer_packages',\n"
    "            $accepted_process_types,\n"
    "            function (Server $server, string $msg) {\n"
    "                if (!class_exists(\\Composer\\InstalledVersions::class)) {\n"
    "                    return self::json('require composer 2.0', 4003);\n"
    "                }\n"
    "\n"
    "                $list = [];\n"
    "                foreach (['getAllRawData', 'getRawData'] as $method) {\n"
    "                    if (!method_exists(\\Composer\\InstalledVersions::class, $method)) {\n"
    "                        continue;\n"
    "                    }\n"
    "\n"
    "                    $raw_data[] = \\Composer\\InstalledVersions::$method();\n"
    "                    if ($method === 'getAllRawData') {\n"
    "                        $raw_data = \\Composer\\InstalledVersions::$method();\n"
    "                        array_shift($raw_data);\n"
    "                    }\n"
    "\n"
    "                    foreach ($raw_data as $key => $package) {\n"
    "                        $key_name = $package['root']['name'];\n"
    "                        if ($package['root']['name'] === '__root__' && isset($list['__root__'])) {\n"
    "                            $key_name = \"__root__{$key}\";\n"
    "                        }\n"
    "                        $package['root']['install_path'] = !empty($package['root']['install_path']) ? realpath($package['root']['install_path']) : '';\n"
    "                        $list[$key_name]                 = $package;\n"
    "                    }\n"
    "                    break;\n"
    "                }\n"
    "                return self::json($list);\n"
    "            }\n"
    "        );\n"
    "    }\n"
    "\n"
    "    public static function getAccessToken(): string\n"
    "    {\n"
    "        return self::$accessToken;\n"
    "    }\n"
    "\n"
    "    public static function start(Server $server): void\n"
    "    {\n"
    "        $admin_server_uri = swoole_string($server->setting['admin_server']);\n"
    "        if ($admin_server_uri->startsWith('unix:/')) {\n"
    "            swoole_error_log(SWOOLE_LOG_ERROR, \"admin_server[{$server->setting['admin_server']}] is not supported\");\n"
    "            return;\n"
    "        }\n"
    "\n"
    "        if ($admin_server_uri->contains('@')) {\n"
    "            [$access_name, $access_secret] = $admin_server_uri->split('@', 2)->get(0)->split(':', 2)->toArray();\n"
    "            self::$accessToken             = sha1($access_name . $access_secret);\n"
    "            [$host, $port]                 = $admin_server_uri->split('@', 2)->get(1)->split(':', 2)->toArray();\n"
    "        } else {\n"
    "            [$host, $port] = $admin_server_uri->split(':', 2)->toArray();\n"
    "        }\n"
    "\n"
    "        $admin_server = new Coroutine\\Http\\Server($host, intval($port));\n"
    "\n"
    "        $admin_server->handle('/api', function (Request $req, Response $resp) use ($server) {\n"
    "            $path_array = swoole_string($req->server['request_uri'])->trim('/')->split('/');\n"
    "            if ($path_array->count() < 2 or $path_array->count() > 3) {\n"
    "                $resp->status(403);\n"
    "                $resp->end(self::json('Bad API path', 4003));\n"
    "                return;\n"
    "            }\n"
    "\n"
    "            $resp->header('Server', 'swoole-admin-server');\n"
    "            $resp->header('Access-Control-Allow-Origin', '*');\n"
    "            $resp->header('Access-Control-Allow-Methods', 'GET, POST, OPTIONS');\n"
    "            $resp->header('Access-Control-Allow-Headers', 'X-ACCESS-TOKEN, X-ADMIN-SERVER-ACCESS-TOKEN');\n"
    "\n"
    "            $method = $req->getMethod();\n"
    "\n"
    "            if ($method === 'OPTIONS') {\n"
    "                $resp->end();\n"
    "                return;\n"
    "            }\n"
    "\n"
    "            $token = self::getAccessToken();\n"
    "            if (!empty($token)) {\n"
    "                $token_header = $req->header['x-admin-server-access-token'] ?? '';\n"
    "                if ($token_header !== $token) {\n"
    "                    $resp->status(403);\n"
    "                    $resp->end(self::json('Bad access token', 4003));\n"
    "                    return;\n"
    "                }\n"
    "            }\n"
    "\n"
    "            $cmd = $path_array->get(1)->toString();\n"
    "\n"
    "            if (in_array($cmd, self::$postMethodList) && $method != 'POST') {\n"
    "                $resp->status(403);\n"
    "                $resp->end(self::json('Bad request method', 4003));\n"
    "                return;\n"
    "            }\n"
    "\n"
    "            if ($method == 'GET') {\n"
    "                $data = $req->get;\n"
    "            } else {\n"
    "                $data = $req->post;\n"
    "            }\n"
    "\n"
    "            if ($cmd === 'multi') {\n"
    "                $body = json_decode($req->getContent(), true, 512, JSON_THROW_ON_ERROR);\n"
    "                if (empty($body) || !is_array($body) || $method != 'POST') {\n"
    "                    goto _bad_process;\n"
    "                }\n"
    "\n"
    "                $result = self::handlerMulti($server, $body);\n"
    "                $resp->end(json_encode($result, JSON_INVALID_UTF8_IGNORE));\n"
    "                return;\n"
    "            }\n"
    "\n"
    "            if ($path_array->count() == 2) {\n"
    "                $process = swoole_string('master');\n"
    "            } else {\n"
    "                $process = $path_array->get(2);\n"
    "            }\n"
    "\n"
    "            if ($process->startsWith('master')) {\n"
    "                $process_type = SWOOLE_SERVER_COMMAND_MASTER;\n"
    "                $process_id   = 0;\n"
    "            } elseif ($process->startsWith('manager')) {\n"
    "                $process_type = SWOOLE_SERVER_COMMAND_MANAGER;\n"
    "                $process_id   = 0;\n"
    "            } elseif ($process->startsWith('all') || $process->equals('specific')) {\n"
    "                if (!in_array($process->toString(), self::$allList)) {\n"
    "                    goto _bad_process;\n"
    "                }\n"
    "\n"
    "                $result = self::handlerGetAll($server, $process, $cmd, $data);\n"
    "\n"
    "                $resp->end(self::json($result));\n"
    "                return;\n"
    "            } else {\n"
    "                $array = $process->split('-');\n"
    "                if ($array->count() != 2) {\n"
    "                    _bad_process:\n"
    "                    $resp->status(403);\n"
    "                    $resp->end(self::json('Bad process', 4003));\n"
    "                    return;\n"
    "                }\n"
    "\n"
    "                if (!isset(self::$map[$array->get(0)->toString()])) {\n"
    "                    goto _bad_process;\n"
    "                }\n"
    "\n"
    "                $process_type = self::$map[$array->get(0)->toString()];\n"
    "                $process_id   = intval($array->get(1)->toString());\n"
    "            }\n"
    "\n"
    "            $result = $server->command($cmd, $process_id, intval($process_type), $data, false);\n"
    "            if (!$result) {\n"
    "                $resp->end(json_encode([\n"
    "                    'code' => swoole_last_error(),\n"
    "                    'data' => swoole_strerror(swoole_last_error()),\n"
    "                ], JSON_THROW_ON_ERROR));\n"
    "            } else {\n"
    "                $resp->end($result);\n"
    "            }\n"
    "        });\n"
    "        $admin_server->handle('/', function (Request $req, Response $resp): void {\n"
    "            $resp->status(404);\n"
    "        });\n"
    "        $server->admin_server = $admin_server;\n"
    "        $admin_server->start();\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|string\n"
    "     */\n"
    "    public static function handlerGetResources(Server $server, string $msg)\n"
    "    {\n"
    "        $resources = get_resources();\n"
    "        $list      = [];\n"
    "        foreach ($resources as $r) {\n"
    "            $info = [\n"
    "                'id'   => get_resource_id($r),\n"
    "                'type' => get_resource_type($r),\n"
    "            ];\n"
    "            if ($info['type'] == 'stream') {\n"
    "                $info['info'] = stream_get_meta_data($r);\n"
    "            }\n"
    "            $list[] = $info;\n"
    "        }\n"
    "        return self::json($list);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|string\n"
    "     */\n"
    "    public static function handlerGetWorkerInfo(Server $server, string $msg)\n"
    "    {\n"
    "        $info = [\n"
    "            'id'                => $server->getWorkerId(),\n"
    "            'pid'               => $server->getWorkerPid(),\n"
    "            'gc_status'         => gc_status(),\n"
    "            'memory_usage'      => memory_get_usage(),\n"
    "            'memory_real_usage' => memory_get_usage(true),\n"
    "            'process_status'    => self::getProcessStatus(),\n"
    "            'coroutine_stats'   => Coroutine::stats(),\n"
    "            'timer_stats'       => Timer::stats(),\n"
    "            'vm_status'         => swoole_get_vm_status(),\n"
    "        ];\n"
    "        return self::json($info);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|string\n"
    "     */\n"
    "    public static function handlerCloseSession(Server $server, string $msg)\n"
    "    {\n"
    "        $json = json_decode($msg, true, 512, JSON_THROW_ON_ERROR);\n"
    "        if (empty($json['session_id'])) {\n"
    "            return self::json('require session_id', 4003);\n"
    "        }\n"
    "        if ($server->close(intval($json['session_id']), !empty($json['force']))) {\n"
    "            return self::json([]);\n"
    "        }\n"
    "        return self::json(['error' => swoole_last_error()], 4004);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|string\n"
    "     */\n"
    "    public static function handlerGetTimerList(Server $server, string $msg)\n"
    "    {\n"
    "        $list = [];\n"
    "        foreach (Timer::list() as $timer_id) {\n"
    "            $list[] = [\n"
    "                'id'   => $timer_id,\n"
    "                'info' => Timer::info($timer_id),\n"
    "            ];\n"
    "        }\n"
    "\n"
    "        return self::json($list);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|string\n"
    "     */\n"
    "    public static function handlerGetCoroutineList(Server $server, string $msg)\n"
    "    {\n"
    "        $list = [];\n"
    "        foreach (Coroutine::list() as $cid) {\n"
    "            $list[] = [\n"
    "                'id'          => $cid,\n"
    "                'elapsed'     => Coroutine::getElapsed($cid),\n"
    "                'stack_usage' => Coroutine::getStackUsage($cid),\n"
    "                'backTrace'   => Coroutine::getBackTrace($cid, DEBUG_BACKTRACE_IGNORE_ARGS, 1),\n"
    "            ];\n"
    "        }\n"
    "\n"
    "        return self::json($list);\n"
    "    }\n"
    "\n"
    "    public static function handlerGetObjects(Server $server, string $msg)\n"
    "    {\n"
    "        $list    = [];\n"
    "        $objects = swoole_get_objects();\n"
    "        foreach ($objects as $o) {\n"
    "            $class_name = $o::class;\n"
    "            $class      = new \\ReflectionClass($class_name);\n"
    "            $filename   = $class->getFileName();\n"
    "            $line       = $class->getStartLine();\n"
    "            $list[]     = [\n"
    "                'id'          => spl_object_id($o),\n"
    "                'hash'        => spl_object_hash($o),\n"
    "                'class'       => $class_name,\n"
    "                'filename'    => $filename ?: '',\n"
    "                'line'        => $line ?: '',\n"
    "                'memory_size' => self::getObjectMemorySize($o),\n"
    "            ];\n"
    "        }\n"
    "\n"
    "        return self::json($list);\n"
    "    }\n"
    "\n"
    "    public static function handlerGetClassInfo(Server $server, string $msg)\n"
    "    {\n"
    "        $json = json_decode($msg, true, 512, JSON_THROW_ON_ERROR);\n"
    "        if (!empty($json['class_name'])) {\n"
    "            if (!class_exists($json['class_name'], false) && !interface_exists($json['class_name'], false)) {\n"
    "                return self::json(\"{$json['class_name']} not exists\", 4003);\n"
    "            }\n"
    "            $name = $json['class_name'];\n"
    "        } elseif (!empty($json['interface_name'])) {\n"
    "            if (!interface_exists($json['interface_name'], false)) {\n"
    "                return self::json(\"{$json['interface_name']} not exists\", 4003);\n"
    "            }\n"
    "            $name = $json['interface_name'];\n"
    "        } else {\n"
    "            return self::json(['error' => 'require class_name or interface_name'], 4004);\n"
    "        }\n"
    "\n"
    "        $class = new \\ReflectionClass($name);\n"
    "\n"
    "        $filename = $class->getFileName();\n"
    "\n"
    "        $getTmpConstants = function ($data) {\n"
    "            $tmp = [];\n"
    "            foreach ($data as $k => $v) {\n"
    "                $tmp[] = [\n"
    "                    'name'  => $k,\n"
    "                    'value' => is_array($v) ? var_export($v, true) : $v,\n"
    "                    'type'  => is_array($v) ? 'detail' : 'default',\n"
    "                ];\n"
    "            }\n"
    "            return $tmp;\n"
    "        };\n"
    "\n"
    "        $tmpConstants = $class->getConstants();\n"
    "        $constants    = $tmpConstants ? $getTmpConstants($tmpConstants) : [];\n"
    "\n"
    "        $staticProperties = [];\n"
    "        $properties       = [];\n"
    "        $tmpProperties    = $class->getProperties();\n"
    "\n"
    "        $getTmpProperties = function ($class, $data) {\n"
    "            $static            = [];\n"
    "            $noStatic          = [];\n"
    "            $defaultProperties = $class->getDefaultProperties();\n"
    "            foreach ($data as $k => $v) {\n"
    "                $name      = $v->getName();\n"
    "                $modifiers = \\Reflection::getModifierNames($v->getModifiers());\n"
    "                if ($v->isStatic()) {\n"
    "                    $static[] = [\n"
    "                        'name'      => $name,\n"
    "                        'value'     => $defaultProperties[$name],\n"
    "                        'modifiers' => implode(' ', $modifiers),\n"
    "                    ];\n"
    "                } else {\n"
    "                    $noStatic[] = [\n"
    "                        'name'      => $name,\n"
    "                        'value'     => $defaultProperties[$name],\n"
    "                        'modifiers' => implode(' ', $modifiers),\n"
    "                    ];\n"
    "                }\n"
    "            }\n"
    "            return ['static' => $static, 'no_static' => $noStatic];\n"
    "        };\n"
    "\n"
    "        if ($tmpProperties) {\n"
    "            $tmpProperties    = $getTmpProperties($class, $tmpProperties);\n"
    "            $staticProperties = $tmpProperties['static'];\n"
    "            $properties       = $tmpProperties['no_static'];\n"
    "        }\n"
    "\n"
    "        $staticMethods    = [];\n"
    "        $methods          = [];\n"
    "        $tmpStaticMethods = $class->getMethods();\n"
    "\n"
    "        $getTmpMethods = function ($data) {\n"
    "            $static   = [];\n"
    "            $noStatic = [];\n"
    "            foreach ($data as $k => $v) {\n"
    "                $name      = $v->getName();\n"
    "                $line      = $v->getStartLine();\n"
    "                $modifiers = \\Reflection::getModifierNames($v->getModifiers());\n"
    "                if ($v->isStatic()) {\n"
    "                    $static[] = [\n"
    "                        'name'      => $name,\n"
    "                        'line'      => $line ?: '',\n"
    "                        'modifiers' => implode(' ', $modifiers),\n"
    "                    ];\n"
    "                } else {\n"
    "                    $noStatic[] = [\n"
    "                        'name'      => $name,\n"
    "                        'line'      => $line ?: '',\n"
    "                        'modifiers' => implode(' ', $modifiers),\n"
    "                    ];\n"
    "                }\n"
    "            }\n"
    "            return ['static' => $static, 'no_static' => $noStatic];\n"
    "        };\n"
    "\n"
    "        if ($tmpStaticMethods) {\n"
    "            $tmpStaticMethods = $getTmpMethods($tmpStaticMethods);\n"
    "            $staticMethods    = $tmpStaticMethods['static'];\n"
    "            $methods          = $tmpStaticMethods['no_static'];\n"
    "        }\n"
    "\n"
    "        $tmpParentClass = $class->getParentClass();\n"
    "        $parentClass    = $tmpParentClass ? $tmpParentClass->getName() : '';\n"
    "\n"
    "        $data = [\n"
    "            'filename'         => $filename,\n"
    "            'constants'        => $constants,\n"
    "            'staticProperties' => $staticProperties,\n"
    "            'properties'       => $properties,\n"
    "            'staticMethods'    => $staticMethods,\n"
    "            'methods'          => $methods,\n"
    "            'parentClass'      => $parentClass,\n"
    "            'interface'        => $class->getInterfaceNames(),\n"
    "        ];\n"
    "        return self::json($data);\n"
    "    }\n"
    "\n"
    "    public static function handlerGetFunctionInfo(Server $server, string $msg)\n"
    "    {\n"
    "        $json = json_decode($msg, true, 512, JSON_THROW_ON_ERROR);\n"
    "\n"
    "        $className    = $json['class_name'] ?? '';\n"
    "        $functionName = $json['function_name'] ?? '';\n"
    "\n"
    "        if (empty($json) || empty($functionName)) {\n"
    "            return self::json('require function_name', 4004);\n"
    "        }\n"
    "\n"
    "        $isStatic = false;\n"
    "        if (!empty($className)) {\n"
    "            if (!class_exists($className) && !interface_exists($className)) {\n"
    "                return self::json(\"{$className} not exists\", 4004);\n"
    "            }\n"
    "            if (!method_exists($className, $functionName)) {\n"
    "                return self::json(\"{$className}->{$functionName} not exists\", 4004);\n"
    "            }\n"
    "            $ref      = new \\ReflectionMethod($className, $functionName);\n"
    "            $isStatic = $ref->isStatic();\n"
    "        } else {\n"
    "            if (!function_exists($functionName)) {\n"
    "                return self::json(\"{$functionName} not exists\", 4004);\n"
    "            }\n"
    "            $ref = new \\ReflectionFunction($functionName);\n"
    "        }\n"
    "\n"
    "        $result = [\n"
    "            'filename'     => $ref->getFileName(),\n"
    "            'line'         => $ref->getStartLine() ?: '',\n"
    "            'num'          => $ref->getNumberOfParameters(),\n"
    "            'user_defined' => $ref->isUserDefined(),\n"
    "            'extension'    => $ref->getExtensionName(),\n"
    "            'is_static'    => $isStatic,\n"
    "        ];\n"
    "\n"
    "        $params = $ref->getParameters();\n"
    "\n"
    "        $list = [];\n"
    "        foreach ($params as $param) {\n"
    "            $type = $optional = $default = '';\n"
    "\n"
    "            $paramName = $param->getName();\n"
    "\n"
    "            if ($param->hasType()) {\n"
    "                /** @var \\ReflectionNamedType|\\ReflectionUnionType $reflection */\n"
    "                $reflection = $param->getType();\n"
    "                if ($reflection instanceof \\ReflectionUnionType) {\n"
    "                    $unionType = [];\n"
    "                    foreach ($reflection->getTypes() as $objType) {\n"
    "                        $unionType[] = $objType->getName();\n"
    "                    }\n"
    "                    $type = implode('|', $unionType);\n"
    "                } else {\n"
    "                    $type = $reflection->getName();\n"
    "                }\n"
    "            }\n"
    "\n"
    "            if ($param->isOptional() && !$param->isVariadic()) {\n"
    "                $optional = '?';\n"
    "                if ($param->isDefaultValueAvailable()) {\n"
    "                    $value = $param->getDefaultValue();\n"
    "                    if (in_array($value, [true, false, null, ''])) {\n"
    "                        if ($value === null) {\n"
    "                            $value = 'null';\n"
    "                        }\n"
    "                        if ($value === true) {\n"
    "                            $value = 'true';\n"
    "                        }\n"
    "                        if ($value === false) {\n"
    "                            $value = 'false';\n"
    "                        }\n"
    "                        if ($value === '') {\n"
    "                            $value = \"''\";\n"
    "                        }\n"
    "                    }\n"
    "                    $default = \" = {$value}\";\n"
    "                }\n"
    "            }\n"
    "\n"
    "            $isPassedByReference = $param->isPassedByReference() ? '&' : '';\n"
    "            $isVariadic          = $param->isVariadic() ? '...' : '';\n"
    "\n"
    "            $option = \"{$optional}{$type} {$isPassedByReference}{$isVariadic}\";\n"
    "            $param  = \"\\${$paramName}{$default}\";\n"
    "\n"
    "            $list[] = [\n"
    "                'optional'               => $optional,\n"
    "                'type'                   => $type,\n"
    "                'is_passed_by_reference' => $isPassedByReference,\n"
    "                'is_variadic'            => $isVariadic,\n"
    "                'name'                   => $paramName,\n"
    "                'default'                => $default,\n"
    "                'full'                   => $option !== ' ' ? \"{$option}{$param}\" : $param,\n"
    "            ];\n"
    "        }\n"
    "        $result['params'] = $list;\n"
    "\n"
    "        return self::json($result);\n"
    "    }\n"
    "\n"
    "    public static function handlerGetObjectByHandle(Server $server, string $msg)\n"
    "    {\n"
    "        $json = json_decode($msg, true, 512, JSON_THROW_ON_ERROR);\n"
    "        if (empty($json) || empty($json['object_id']) || empty($json['object_hash'])) {\n"
    "            return self::json(['error' => 'Params Error!'], 4004);\n"
    "        }\n"
    "\n"
    "        $object = swoole_get_object_by_handle((int) $json['object_id']);\n"
    "        if (!$object) {\n"
    "            return self::json(['error' => 'Object destroyed!'], 4004);\n"
    "        }\n"
    "\n"
    "        $object_hash = spl_object_hash($object); // @phpstan-ignore argument.type\n"
    "        if ($object_hash != $json['object_hash']) {\n"
    "            return self::json(['error' => 'Object destroyed!'], 4004);\n"
    "        }\n"
    "\n"
    "        return self::json(var_export($object, true));\n"
    "    }\n"
    "\n"
    "    public static function handlerGetVersionInfo(Server $server, string $msg)\n"
    "    {\n"
    "        $ip_arr = swoole_get_local_ip();\n"
    "        $host   = [];\n"
    "        $local  = [];\n"
    "        foreach ($ip_arr as $k => $ip) {\n"
    "            if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE)) {\n"
    "                $host[] = $ip;\n"
    "            } else {\n"
    "                $local[] = $ip;\n"
    "            }\n"
    "        }\n"
    "        $data = [\n"
    "            'os'     => php_uname('s') . '-' . php_uname('r'),\n"
    "            'swoole' => swoole_version(),\n"
    "            'php'    => phpversion(),\n"
    "            'ip'     => $host ? $host[0] : $local[0],\n"
    "        ];\n"
    "        return self::json($data);\n"
    "    }\n"
    "\n"
    "    public static function handlerGetDefinedFunctions(Server $server, string $msg)\n"
    "    {\n"
    "        $functions = get_defined_functions();\n"
    "        $arr       = [\n"
    "            'internal' => $functions['internal'],\n"
    "        ];\n"
    "        if (!empty($functions['user'])) {\n"
    "            foreach ($functions['user'] as $function_name) {\n"
    "                $function      = new \\ReflectionFunction($function_name);\n"
    "                $filename      = $function->getFileName();\n"
    "                $line          = $function->getStartLine();\n"
    "                $arr['user'][] = [\n"
    "                    'function' => $function_name,\n"
    "                    'filename' => $filename,\n"
    "                    'line'     => $line,\n"
    "                ];\n"
    "            }\n"
    "        }\n"
    "        return self::json($arr);\n"
    "    }\n"
    "\n"
    "    public static function handlerGetDeclaredClasses(Server $server, string $msg)\n"
    "    {\n"
    "        $classes = get_declared_classes();\n"
    "        $arr     = [];\n"
    "        if ($classes) {\n"
    "            foreach ($classes as $classes_name) {\n"
    "                $function = new \\ReflectionClass($classes_name);\n"
    "                $filename = $function->getFileName();\n"
    "                $line     = $function->getStartLine();\n"
    "                $arr[]    = [\n"
    "                    'class'    => $classes_name,\n"
    "                    'filename' => $filename ?: '',\n"
    "                    'line'     => $line ?: '',\n"
    "                ];\n"
    "            }\n"
    "        }\n"
    "        return self::json($arr);\n"
    "    }\n"
    "\n"
    "    public static function handlerGetServerMemoryUsage(Server $server, string $msg)\n"
    "    {\n"
    "        $total = 0;\n"
    "\n"
    "        $result['master'] = $result['manager'] = 0;\n"
    "        if (self::haveMasterProcess($server)) {\n"
    "            $result['master'] = self::getProcessMemoryRealUsage($server->master_pid);\n"
    "        }\n"
    "        $total += $result['master'];\n"
    "\n"
    "        if (self::haveManagerProcess($server)) {\n"
    "            $result['manager'] = self::getProcessMemoryRealUsage($server->manager_pid);\n"
    "        }\n"
    "        $total += $result['manager'];\n"
    "\n"
    "        $n = $server->setting['worker_num'] + $server->setting['task_worker_num'];\n"
    "        /** @var int $n */\n"
    "        for ($i = 0; $i < $n; $i++) {\n"
    "            $key          = 'worker-' . $i;\n"
    "            $result[$key] = self::getProcessMemoryRealUsage($server->getWorkerPid($i));\n"
    "            $total += $result[$key];\n"
    "        }\n"
    "\n"
    "        $result['total'] = $total;\n"
    "\n"
    "        $result['memory_size'] = 0;\n"
    "        // TODO: Support other OS\n"
    "        if (PHP_OS_FAMILY === 'Linux') {\n"
    "            preg_match('#MemTotal:\\s+(\\d+) kB#i', file_get_contents('/proc/meminfo'), $match);\n"
    "            $result['memory_size'] = intval($match[1]) * 1024;\n"
    "        }\n"
    "\n"
    "        return self::json($result);\n"
    "    }\n"
    "\n"
    "    public static function handlerGetServerCpuUsage(Server $server, string $msg)\n"
    "    {\n"
    "        $total = 0;\n"
    "\n"
    "        $result['master'] = $result['manager'] = 0;\n"
    "        if (self::haveMasterProcess($server)) {\n"
    "            $result['master'] = self::getProcessCpuUsage($server->master_pid);\n"
    "        }\n"
    "\n"
    "        $total += $result['master'][1] ?? 0;\n"
    "\n"
    "        if (self::haveManagerProcess($server)) {\n"
    "            $result['manager'] = self::getProcessCpuUsage($server->manager_pid);\n"
    "        }\n"
    "\n"
    "        $total += $result['manager'][1] ?? 0;\n"
    "\n"
    "        $n = $server->setting['worker_num'] + $server->setting['task_worker_num'];\n"
    "        /** @var int $n */\n"
    "        for ($i = 0; $i < $n; $i++) {\n"
    "            $key          = 'worker-' . $i;\n"
    "            $result[$key] = self::getProcessCpuUsage($server->getWorkerPid($i))[1] ?? 0;\n"
    "            $total += $result[$key];\n"
    "        }\n"
    "\n"
    "        $result['total']   = $total;\n"
    "        $result['cpu_num'] = swoole_cpu_num();\n"
    "\n"
    "        return self::json($result);\n"
    "    }\n"
    "\n"
    "    public static function handlerGetStaticPropertyValue(Server $server, string $msg)\n"
    "    {\n"
    "        $json = json_decode($msg, true, 512, JSON_THROW_ON_ERROR);\n"
    "        if (empty($json['class_name'])) {\n"
    "            return self::json(['error' => 'require class_name!'], 4004);\n"
    "        }\n"
    "        if (empty($json['property_name'])) {\n"
    "            return self::json(['error' => 'require property_name!'], 4004);\n"
    "        }\n"
    "\n"
    "        $className    = $json['class_name'];\n"
    "        $propertyName = $json['property_name'];\n"
    "\n"
    "        if (!class_exists($className)) {\n"
    "            return self::json(\"class[{$className}] not exists\", 4004);\n"
    "        }\n"
    "\n"
    "        $reflection = new \\ReflectionClass($className);\n"
    "        $value      = $reflection->getStaticPropertyValue($propertyName, []);\n"
    "\n"
    "        $result = [\n"
    "            'value' => var_export($value, true),\n"
    "        ];\n"
    "        return self::json($result);\n"
    "    }\n"
    "\n"
    "    private static function handlerMulti(Server $server, array $list)\n"
    "    {\n"
    "        $return_list = [];\n"
    "        foreach ($list as $key => $content) {\n"
    "            $path_array = swoole_string($content['path'])->trim('/')->split('/');\n"
    "            $cmd        = $path_array->get(1)->toString();\n"
    "\n"
    "            if ($path_array->count() == 2) {\n"
    "                $process = swoole_string('master');\n"
    "            } else {\n"
    "                $process = $path_array->get(2);\n"
    "            }\n"
    "\n"
    "            $data      = [];\n"
    "            $url_query = parse_url($process->toString(), PHP_URL_QUERY) ?? [];\n"
    "            if (!empty($url_query)) {\n"
    "                parse_str($url_query, $data);\n"
    "            }\n"
    "            $data = array_merge($data, $content['post'] ?? []);\n"
    "\n"
    "            if ($process->startsWith('master')) {\n"
    "                $process_type = SWOOLE_SERVER_COMMAND_MASTER;\n"
    "                $process_id   = 0;\n"
    "            } elseif ($process->startsWith('manager')) {\n"
    "                $process_type = SWOOLE_SERVER_COMMAND_MANAGER;\n"
    "                $process_id   = 0;\n"
    "            } elseif ($process->startsWith('all') || $process->startsWith('specific')) {\n"
    "                if (!in_array($process->toString(), self::$allList) && !$process->startsWith('specific')) {\n"
    "                    $return_list[$key] = json_decode('{}');\n"
    "                    continue;\n"
    "                }\n"
    "\n"
    "                $result = self::handlerGetAll($server, $process, $cmd, $data);\n"
    "\n"
    "                $return_list[$key] = ['code' => 0, 'data' => $result];\n"
    "                continue;\n"
    "            } else {\n"
    "                $array = $process->split('-');\n"
    "\n"
    "                if ($array->count() != 2 || !isset(self::$map[$array->get(0)->toString()])) {\n"
    "                    $return_list[$key] = json_decode('{}');\n"
    "                    continue;\n"
    "                }\n"
    "\n"
    "                $process_type = self::$map[$array->get(0)->toString()];\n"
    "                $process_id   = intval($array->get(1)->toString());\n"
    "            }\n"
    "\n"
    "            $return_list[$key] = $server->command($cmd, $process_id, intval($process_type), $data, true);\n"
    "        }\n"
    "\n"
    "        return $return_list;\n"
    "    }\n"
    "\n"
    "    private static function handlerGetAll(Server $server, StringObject $process, $cmd, $data, bool $json_decode = true)\n"
    "    {\n"
    "        if ($process->equals('all')) {\n"
    "            $result = self::handlerGetMaster($cmd, $data, $server, $json_decode) +\n"
    "                self::handlerGetManager($cmd, $data, $server, $json_decode) +\n"
    "                self::handlerGetAllWorker($cmd, $data, $server, $json_decode) +\n"
    "                self::handlerGetAllTaskWorker($cmd, $data, $server, $json_decode);\n"
    "        } elseif ($process->startsWith('all_reactor')) {\n"
    "            $result = self::handlerGetAllReactor($cmd, $data, $server, $json_decode);\n"
    "        } elseif ($process->equals('all_worker') || $process->equals('all_event_worker')) {\n"
    "            $result = self::handlerGetAllWorker($cmd, $data, $server, $json_decode);\n"
    "        } elseif ($process->startsWith('all_task')) {\n"
    "            $result = self::handlerGetAllTaskWorker($cmd, $data, $server, $json_decode);\n"
    "        } else {\n"
    "            // specific\n"
    "            $result = [];\n"
    "            if (!empty($data['workers']) && is_array($data['workers'])) {\n"
    "                foreach ($data['workers'] as $name) {\n"
    "                    $process = swoole_string($name);\n"
    "                    if ($process->startsWith('master')) {\n"
    "                        $result += self::handlerGetMaster($cmd, $data, $server, $json_decode);\n"
    "                    } elseif ($process->startsWith('manager')) {\n"
    "                        $result += self::handlerGetManager($cmd, $data, $server, $json_decode);\n"
    "                    } else {\n"
    "                        $array = $process->split('-');\n"
    "                        if ($array->count() != 2 || !isset(self::$map[$array->get(0)->toString()])) {\n"
    "                            $result[$name] = $json_decode ? json_decode('{}') : $json_decode;\n"
    "                        } else {\n"
    "                            $process_type  = self::$map[$array->get(0)->toString()];\n"
    "                            $process_id    = intval($array->get(1)->toString());\n"
    "                            $result[$name] = $server->command($cmd, $process_id, $process_type, $data, $json_decode);\n"
    "                        }\n"
    "                    }\n"
    "                }\n"
    "            }\n"
    "        }\n"
    "\n"
    "        return $result;\n"
    "    }\n"
    "\n"
    "    private static function handlerGetMaster($cmd, $data, Server $server, bool $json_decode = false)\n"
    "    {\n"
    "        $list['master'] = $server->command($cmd, 0, SWOOLE_SERVER_COMMAND_MASTER, $data, $json_decode);\n"
    "        return $list;\n"
    "    }\n"
    "\n"
    "    private static function handlerGetManager($cmd, $data, Server $server, bool $json_decode = false)\n"
    "    {\n"
    "        $list['manager'] = $server->command($cmd, 0, SWOOLE_SERVER_COMMAND_MANAGER, $data, $json_decode);\n"
    "        return $list;\n"
    "    }\n"
    "\n"
    "    private static function handlerGetAllReactor($cmd, $data, Server $server, bool $json_decode = false)\n"
    "    {\n"
    "        $list = [];\n"
    "        if ($server->mode === SWOOLE_BASE) {\n"
    "            return $list;\n"
    "        }\n"
    "        $process_type = SWOOLE_SERVER_COMMAND_REACTOR_THREAD;\n"
    "        if (empty($server->setting['reactor_num'])) {\n"
    "            $reactor_num = $server->setting['worker_num'];\n"
    "        } else {\n"
    "            $reactor_num = $server->setting['reactor_num'];\n"
    "        }\n"
    "        for ($process_id = 0; $process_id < $reactor_num; $process_id++) {\n"
    "            $list[\"reactor-{$process_id}\"] = $server->command($cmd, $process_id, $process_type, $data, $json_decode);\n"
    "        }\n"
    "        return $list;\n"
    "    }\n"
    "\n"
    "    private static function handlerGetAllWorker($cmd, $data, Server $server, bool $json_decode = false)\n"
    "    {\n"
    "        $process_type = SWOOLE_SERVER_COMMAND_EVENT_WORKER;\n"
    "        $worker_num   = $server->setting['worker_num'];\n"
    "        $list         = [];\n"
    "        for ($process_id = 0; $process_id < $worker_num; $process_id++) {\n"
    "            $list[\"worker-{$process_id}\"] = $server->command($cmd, $process_id, $process_type, $data, $json_decode);\n"
    "        }\n"
    "        return $list;\n"
    "    }\n"
    "\n"
    "    private static function handlerGetAllTaskWorker($cmd, $data, Server $server, bool $json_decode = false)\n"
    "    {\n"
    "        $process_type = SWOOLE_SERVER_COMMAND_TASK_WORKER;\n"
    "        $list         = [];\n"
    "        if (empty($server->setting['task_worker_num'])) {\n"
    "            return $list;\n"
    "        }\n"
    "        $task_worker_num = $server->setting['task_worker_num'];\n"
    "        for ($process_id = 0; $process_id < $task_worker_num; $process_id++) {\n"
    "            $list[\"task_worker-{$process_id}\"] = $server->command($cmd, $process_id, $process_type, $data, $json_decode);\n"
    "        }\n"
    "        return $list;\n"
    "    }\n"
    "\n"
    "    private static function getProcessCpuUsage($pid)\n"
    "    {\n"
    "        // TODO: Support other OS\n"
    "        if (PHP_OS_FAMILY !== 'Linux' || !file_exists(\"/proc/{$pid}/stat\")) {\n"
    "            return [0];\n"
    "        }\n"
    "\n"
    "        $statAll  = file_get_contents('/proc/stat');\n"
    "        $statProc = file_get_contents(\"/proc/{$pid}/stat\");\n"
    "\n"
    "        $dataAll = preg_split(\"/[ \\t]+/\", $statAll, 6);\n"
    "        assert($dataAll[0] === 'cpu', '/proc/stat malformed');\n"
    "        $dataProc = preg_split(\"/[ \\t]+/\", $statProc, 15);\n"
    "\n"
    "        if (isset($dataProc[13]) and isset($dataProc[14])) {\n"
    "            return [\n"
    "                (int) $dataAll[1] + (int) $dataAll[2] + (int) $dataAll[3] + (int) $dataAll[4],\n"
    "                (int) $dataProc[13] + (int) $dataProc[14],\n"
    "            ];\n"
    "        }\n"
    "        return [(int) $dataAll[1] + (int) $dataAll[2] + (int) $dataAll[3] + (int) $dataAll[4]];\n"
    "    }\n"
    "\n"
    "    private static function getProcessMemoryRealUsage($pid = 'self')\n"
    "    {\n"
    "        $status = self::getProcessStatus($pid);\n"
    "        if (!is_array($status) || !isset($status['VmRSS'])) {\n"
    "            return 0;\n"
    "        }\n"
    "        return intval($status['VmRSS']) * 1024;\n"
    "    }\n"
    "\n"
    "    private static function getProcessStatus($pid = 'self')\n"
    "    {\n"
    "        $array = [];\n"
    "        // TODO: Support other OS\n"
    "        if (PHP_OS_FAMILY !== 'Linux' || !file_exists(\"/proc/{$pid}/status\")) {\n"
    "            return $array;\n"
    "        }\n"
    "        $status = swoole_string(trim(file_get_contents(\"/proc/{$pid}/status\")));\n"
    "        $lines  = $status->split(\"\\n\");\n"
    "        foreach ($lines as $l) {\n"
    "            if (empty($l)) {\n"
    "                continue;\n"
    "            }\n"
    "            [$k, $v]   = swoole_string($l)->split(':');\n"
    "            $array[$k] = trim($v);\n"
    "        }\n"
    "        return $array;\n"
    "    }\n"
    "\n"
    "    private static function getArrayMemorySize(array $a): int\n"
    "    {\n"
    "        $size = self::SIZE_OF_ZVAL + self::SIZE_OF_ZEND_ARRAY;\n"
    "        foreach ($a as $k => $v) {\n"
    "            if (is_string($k)) {\n"
    "                $size += self::getStringMemorySize($k);\n"
    "            } else {\n"
    "                $size += self::SIZE_OF_ZVAL;\n"
    "            }\n"
    "            if (is_string($v)) {\n"
    "                $size += self::getStringMemorySize($v);\n"
    "            } elseif (is_array($v)) {\n"
    "                $size += self::getArrayMemorySize($v);\n"
    "            } else {\n"
    "                $size += self::SIZE_OF_ZVAL;\n"
    "            }\n"
    "        }\n"
    "        return $size;\n"
    "    }\n"
    "\n"
    "    private static function getStringMemorySize(string $s): int\n"
    "    {\n"
    "        return self::SIZE_OF_ZVAL + self::SIZE_OF_ZEND_STRING + strlen($s);\n"
    "    }\n"
    "\n"
    "    private static function getObjectMemorySize(object $o): int\n"
    "    {\n"
    "        $vars = get_object_vars($o);\n"
    "        $size = self::SIZE_OF_ZEND_OBJECT;\n"
    "\n"
    "        foreach ($vars as $v) {\n"
    "            if (is_array($v)) {\n"
    "                $size += self::getArrayMemorySize($v);\n"
    "            } elseif (is_string($v)) {\n"
    "                $size += self::getStringMemorySize($v);\n"
    "            } else {\n"
    "                $size += self::SIZE_OF_ZVAL;\n"
    "            }\n"
    "        }\n"
    "\n"
    "        return $size;\n"
    "    }\n"
    "\n"
    "    private static function haveMasterProcess(Server $server): bool\n"
    "    {\n"
    "        if ($server->mode === SWOOLE_BASE) {\n"
    "            return false;\n"
    "        }\n"
    "\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    private static function haveManagerProcess(Server $server): bool\n"
    "    {\n"
    "        if ($server->mode === SWOOLE_BASE && $server->getManagerPid() === 0) {\n"
    "            return false;\n"
    "        }\n"
    "\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    private static function json($data, $code = 0)\n"
    "    {\n"
    "        $result = json_encode(['code' => $code, 'data' => $data], JSON_INVALID_UTF8_IGNORE);\n"
    "        if (empty($result)) {\n"
    "            return json_encode([\n"
    "                'code' => 5010,\n"
    "                'data' => ['message' => json_last_error_msg(), 'code' => json_last_error()],\n"
    "            ]);\n"
    "        }\n"
    "        return $result;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_server_helper =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Server;\n"
    "\n"
    "use Swoole\\Constant;\n"
    "use Swoole\\Coroutine;\n"
    "use Swoole\\Server;\n"
    "use Swoole\\Timer;\n"
    "\n"
    "class Helper\n"
    "{\n"
    "    public const STATS_TIMER_INTERVAL_TIME = 1000;\n"
    "\n"
    "    public const GLOBAL_OPTIONS = [\n"
    "        'debug_mode'                   => true,\n"
    "        'trace_flags'                  => true,\n"
    "        'log_file'                     => true,\n"
    "        'log_level'                    => true,\n"
    "        'log_date_format'              => true,\n"
    "        'log_date_with_microseconds'   => true,\n"
    "        'log_rotation'                 => true,\n"
    "        'display_errors'               => true,\n"
    "        'dns_server'                   => true,\n"
    "        'socket_dns_timeout'           => true,\n"
    "        'socket_connect_timeout'       => true,\n"
    "        'socket_write_timeout'         => true,\n"
    "        'socket_send_timeout'          => true,\n"
    "        'socket_read_timeout'          => true,\n"
    "        'socket_recv_timeout'          => true,\n"
    "        'socket_buffer_size'           => true,\n"
    "        'socket_timeout'               => true,\n"
    "        'http2_header_table_size'      => true,\n"
    "        'http2_enable_push'            => true,\n"
    "        'http2_max_concurrent_streams' => true,\n"
    "        'http2_init_window_size'       => true,\n"
    "        'http2_max_frame_size'         => true,\n"
    "        'http2_max_header_list_size'   => true,\n"
    "    ];\n"
    "\n"
    "    public const SERVER_OPTIONS = [\n"
    "        'chroot'                      => true,\n"
    "        'user'                        => true,\n"
    "        'group'                       => true,\n"
    "        'daemonize'                   => true,\n"
    "        'pid_file'                    => true,\n"
    "        'reactor_num'                 => true,\n"
    "        'single_thread'               => true,\n"
    "        'worker_num'                  => true,\n"
    "        'max_wait_time'               => true,\n"
    "        'max_queued_bytes'            => true,\n"
    "        'max_concurrency'             => true,\n"
    "        'worker_max_concurrency'      => true,\n"
    "        'enable_coroutine'            => true,\n"
    "        'send_timeout'                => true,\n"
    "        'dispatch_mode'               => true,\n"
    "        'send_yield'                  => true,\n"
    "        'dispatch_func'               => true,\n"
    "        'discard_timeout_request'     => true,\n"
    "        'enable_unsafe_event'         => true,\n"
    "        'enable_delay_receive'        => true,\n"
    "        'enable_reuse_port'           => true,\n"
    "        'task_use_object'             => true,\n"
    "        'task_object'                 => true,\n"
    "        'event_object'                => true,\n"
    "        'task_enable_coroutine'       => true,\n"
    "        'task_worker_num'             => true,\n"
    "        'task_ipc_mode'               => true,\n"
    "        'task_tmpdir'                 => true,\n"
    "        'task_max_request'            => true,\n"
    "        'task_max_request_grace'      => true,\n"
    "        'max_connection'              => true,\n"
    "        'max_conn'                    => true,\n"
    "        'start_session_id'            => true,\n"
    "        'heartbeat_check_interval'    => true,\n"
    "        'heartbeat_idle_time'         => true,\n"
    "        'max_request'                 => true,\n"
    "        'max_request_grace'           => true,\n"
    "        'reload_async'                => true,\n"
    "        'open_cpu_affinity'           => true,\n"
    "        'cpu_affinity_ignore'         => true,\n"
    "        'http_parse_cookie'           => true,\n"
    "        'http_parse_post'             => true,\n"
    "        'http_parse_files'            => true,\n"
    "        'http_compression'            => true,\n"
    "        'http_compression_level'      => true,\n"
    "        'compression_level'           => true,\n"
    "        'http_gzip_level'             => true,\n"
    "        'http_compression_min_length' => true,\n"
    "        'compression_min_length'      => true,\n"
    "        'websocket_compression'       => true,\n"
    "        'upload_tmp_dir'              => true,\n"
    "        'upload_max_filesize'         => true,\n"
    "        'enable_static_handler'       => true,\n"
    "        'document_root'               => true,\n"
    "        'http_autoindex'              => true,\n"
    "        'http_index_files'            => true,\n"
    "        'http_compression_types'      => true,\n"
    "        'compression_types'           => true,\n"
    "        'static_handler_locations'    => true,\n"
    "        'input_buffer_size'           => true,\n"
    "        'buffer_input_size'           => true,\n"
    "        'output_buffer_size'          => true,\n"
    "        'buffer_output_size'          => true,\n"
    "        'message_queue_key'           => true,\n"
    "        'bootstrap'                   => true,\n"
    "        'init_arguments'              => true,\n"
    "    ];\n"
    "\n"
    "    public const PORT_OPTIONS = [\n"
    "        'ssl_cert_file'                  => true,\n"
    "        'ssl_key_file'                   => true,\n"
    "        'backlog'                        => true,\n"
    "        'socket_buffer_size'             => true,\n"
    "        'kernel_socket_recv_buffer_size' => true,\n"
    "        'kernel_socket_send_buffer_size' => true,\n"
    "        'heartbeat_idle_time'            => true,\n"
    "        'buffer_high_watermark'          => true,\n"
    "        'buffer_low_watermark'           => true,\n"
    "        'open_tcp_nodelay'               => true,\n"
    "        'tcp_defer_accept'               => true,\n"
    "        'open_tcp_keepalive'             => true,\n"
    "        'open_eof_check'                 => true,\n"
    "        'open_eof_split'                 => true,\n"
    "        'package_eof'                    => true,\n"
    "        'open_http_protocol'             => true,\n"
    "        'open_websocket_protocol'        => true,\n"
    "        'websocket_subprotocol'          => true,\n"
    "        'open_websocket_close_frame'     => true,\n"
    "        'open_websocket_ping_frame'      => true,\n"
    "        'open_websocket_pong_frame'      => true,\n"
    "        'open_http2_protocol'            => true,\n"
    "        'open_mqtt_protocol'             => true,\n"
    "        'open_redis_protocol'            => true,\n"
    "        'max_idle_time'                  => true,\n"
    "        'tcp_keepidle'                   => true,\n"
    "        'tcp_keepinterval'               => true,\n"
    "        'tcp_keepcount'                  => true,\n"
    "        'tcp_user_timeout'               => true,\n"
    "        'tcp_fastopen'                   => true,\n"
    "        'open_length_check'              => true,\n"
    "        'package_length_type'            => true,\n"
    "        'package_length_offset'          => true,\n"
    "        'package_body_offset'            => true,\n"
    "        'package_body_start'             => true,\n"
    "        'package_length_func'            => true,\n"
    "        'package_max_length'             => true,\n"
    "        'ssl_compress'                   => true,\n"
    "        'ssl_protocols'                  => true,\n"
    "        'ssl_verify_peer'                => true,\n"
    "        'ssl_allow_self_signed'          => true,\n"
    "        'ssl_client_cert_file'           => true,\n"
    "        'ssl_cafile'                     => true,\n"
    "        'ssl_capath'                     => true,\n"
    "        'ssl_verify_depth'               => true,\n"
    "        'ssl_prefer_server_ciphers'      => true,\n"
    "        'ssl_ciphers'                    => true,\n"
    "        'ssl_ecdh_curve'                 => true,\n"
    "        'ssl_dhparam'                    => true,\n"
    "        'ssl_sni_certs'                  => true,\n"
    "    ];\n"
    "\n"
    "    public const AIO_OPTIONS = [\n"
    "        'aio_core_worker_num'    => true,\n"
    "        'aio_worker_num'         => true,\n"
    "        'aio_max_wait_time'      => true,\n"
    "        'aio_max_idle_time'      => true,\n"
    "        'iouring_entries'        => true,\n"
    "        'iouring_workers'        => true,\n"
    "        'iouring_flag'           => true,\n"
    "        'enable_signalfd'        => true,\n"
    "        'wait_signal'            => true,\n"
    "        'dns_cache_refresh_time' => true,\n"
    "        'thread_num'             => true,\n"
    "        'min_thread_num'         => true,\n"
    "        'max_thread_num'         => true,\n"
    "        'socket_dontwait'        => true,\n"
    "        'dns_lookup_random'      => true,\n"
    "        'use_async_resolver'     => true,\n"
    "        'enable_coroutine'       => true,\n"
    "    ];\n"
    "\n"
    "    public const COROUTINE_OPTIONS = [\n"
    "        'max_coro_num'                => true,\n"
    "        'max_coroutine'               => true,\n"
    "        'enable_deadlock_check'       => true,\n"
    "        'hook_flags'                  => true,\n"
    "        'enable_preemptive_scheduler' => true,\n"
    "        'c_stack_size'                => true,\n"
    "        'stack_size'                  => true,\n"
    "        'name_resolver'               => true,\n"
    "        'dns_cache_expire'            => true,\n"
    "        'dns_cache_capacity'          => true,\n"
    "    ];\n"
    "\n"
    "    public const HELPER_OPTIONS = [\n"
    "        'stats_file'           => true,\n"
    "        'stats_timer_interval' => true,\n"
    "        'admin_server'         => true,\n"
    "    ];\n"
    "\n"
    "    public static function checkOptions(array $input_options): void\n"
    "    {\n"
    "        $const_options = self::GLOBAL_OPTIONS + self::SERVER_OPTIONS + self::PORT_OPTIONS\n"
    "            + self::AIO_OPTIONS + self::COROUTINE_OPTIONS + self::HELPER_OPTIONS;\n"
    "\n"
    "        foreach ($input_options as $k => $v) {\n"
    "            if (!array_key_exists(strtolower($k), $const_options)) {\n"
    "                // TODO throw exception\n"
    "                trigger_error(\"unsupported option [{$k}]\", E_USER_WARNING);\n"
    "                debug_print_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS);\n"
    "            }\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public static function onBeforeStart(Server $server): void\n"
    "    {\n"
    "        if (!empty($server->setting['admin_server'])) {\n"
    "            Admin::init($server);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public static function onBeforeShutdown(Server $server): void\n"
    "    {\n"
    "        if (isset($server->admin_server)) { // @phpstan-ignore isset.property\n"
    "            $server->admin_server->shutdown();\n"
    "            $server->admin_server = null; // @phpstan-ignore assign.propertyType\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public static function onWorkerStart(Server $server, int $workerId): void\n"
    "    {\n"
    "        if (!empty($server->setting['stats_file']) and $workerId == 0) {\n"
    "            $interval_ms = empty($server->setting['stats_timer_interval']) ? self::STATS_TIMER_INTERVAL_TIME : intval($server->setting['stats_timer_interval']);\n"
    "\n"
    "            $server->stats_timer = Timer::tick($interval_ms, function () use ($server) {\n"
    "                $stats      = $server->stats();\n"
    "                $stats_file = swoole_string($server->setting['stats_file']);\n"
    "                if ($stats_file->endsWith('.json')) {\n"
    "                    $out = json_encode($stats, JSON_THROW_ON_ERROR);\n"
    "                } elseif ($stats_file->endsWith('.php')) {\n"
    "                    $out = \"<?php\\nreturn \" . var_export($stats, true) . \";\\n\";\n"
    "                } else {\n"
    "                    $lines = [];\n"
    "                    foreach ($stats as $k => $v) {\n"
    "                        $lines[] = \"{$k}: {$v}\";\n"
    "                    }\n"
    "                    $out = implode(\"\\n\", $lines);\n"
    "                }\n"
    "                file_put_contents($server->setting['stats_file'], $out);\n"
    "            });\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public static function onWorkerExit(Server $server, int $workerId): void\n"
    "    {\n"
    "        if ($server->stats_timer) {\n"
    "            Timer::clear($server->stats_timer);\n"
    "            $server->stats_timer = null;\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public static function onWorkerStop(Server $server, int $workerId)\n"
    "    {\n"
    "    }\n"
    "\n"
    "    public static function onStart(Server $server): void\n"
    "    {\n"
    "        if (!empty($server->setting[Constant::OPTION_ADMIN_SERVER])) {\n"
    "            Coroutine::create(function () use ($server): void {\n"
    "                Admin::start($server);\n"
    "            });\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public static function onShutdown(Server $server)\n"
    "    {\n"
    "    }\n"
    "\n"
    "    public static function onBeforeReload(Server $server)\n"
    "    {\n"
    "    }\n"
    "\n"
    "    public static function onAfterReload(Server $server)\n"
    "    {\n"
    "    }\n"
    "\n"
    "    public static function onManagerStart(Server $server)\n"
    "    {\n"
    "    }\n"
    "\n"
    "    public static function onManagerStop(Server $server)\n"
    "    {\n"
    "    }\n"
    "\n"
    "    public static function onWorkerError(Server $server)\n"
    "    {\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_name_resolver =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "use Swoole\\Coroutine\\Http\\ClientProxy;\n"
    "use Swoole\\Http\\Status;\n"
    "use Swoole\\NameResolver\\Cluster;\n"
    "use Swoole\\NameResolver\\Exception;\n"
    "\n"
    "abstract class NameResolver\n"
    "{\n"
    "    protected $baseUrl;\n"
    "\n"
    "    protected $info;\n"
    "\n"
    "    private $filter_fn;\n"
    "\n"
    "    public function __construct($url, protected $prefix = 'swoole_service_')\n"
    "    {\n"
    "        $this->checkServerUrl($url);\n"
    "    }\n"
    "\n"
    "    abstract public function join(string $name, string $ip, int $port, array $options = []): bool;\n"
    "\n"
    "    abstract public function leave(string $name, string $ip, int $port): bool;\n"
    "\n"
    "    abstract public function getCluster(string $name): ?Cluster;\n"
    "\n"
    "    public function withFilter(callable $fn): self\n"
    "    {\n"
    "        $this->filter_fn = $fn;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getFilter()\n"
    "    {\n"
    "        return $this->filter_fn;\n"
    "    }\n"
    "\n"
    "    public function hasFilter(): bool\n"
    "    {\n"
    "        return !empty($this->filter_fn);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * return string: final result, non-empty string must be a valid IP address,\n"
    "     * and an empty string indicates name lookup failed, and lookup operation will not continue.\n"
    "     * return Cluster: has multiple nodes and failover is possible\n"
    "     * return false or null: try another name resolver\n"
    "     * @return Cluster|false|string|null\n"
    "     */\n"
    "    public function lookup(string $name)\n"
    "    {\n"
    "        if ($this->hasFilter() and ($this->getFilter())($name) !== true) {\n"
    "            return null;\n"
    "        }\n"
    "        $cluster = $this->getCluster($name);\n"
    "        // lookup failed, terminate execution\n"
    "        if ($cluster == null) {\n"
    "            return '';\n"
    "        }\n"
    "        // only one node, cannot retry\n"
    "        if ($cluster->count() == 1) {\n"
    "            return $cluster->pop();\n"
    "        }\n"
    "        return $cluster;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * !!! The host MUST BE IP ADDRESS\n"
    "     */\n"
    "    protected function checkServerUrl(string $url)\n"
    "    {\n"
    "        $info = parse_url($url);\n"
    "        if (empty($info['scheme']) or empty($info['host'])) {\n"
    "            throw new \\RuntimeException(\"invalid url parameter '{$url}'\");\n"
    "        }\n"
    "        if (!filter_var($info['host'], FILTER_VALIDATE_IP)) {\n"
    "            $info['ip'] = gethostbyname($info['host']);\n"
    "            if (!filter_var($info['ip'], FILTER_VALIDATE_IP)) {\n"
    "                throw new \\RuntimeException(\"Failed to resolve host '{$info['host']}'\");\n"
    "            }\n"
    "        } else {\n"
    "            $info['ip'] = $info['host'];\n"
    "        }\n"
    "        $baseUrl = $info['scheme'] . '://' . $info['ip'];\n"
    "        if (!empty($info['port'])) {\n"
    "            $baseUrl .= \":{$info['port']}\";\n"
    "        }\n"
    "        if (!empty($info['path'])) {\n"
    "            $baseUrl .= rtrim($info['path'], '/');\n"
    "        }\n"
    "        $this->baseUrl = $baseUrl;\n"
    "        $this->info    = $info;\n"
    "    }\n"
    "\n"
    "    protected function checkResponse(ClientProxy $response): bool\n"
    "    {\n"
    "        if ($response->getStatusCode() === Status::OK) {\n"
    "            return true;\n"
    "        }\n"
    "\n"
    "        throw new Exception('Http Body: ' . $response->getBody(), $response->getStatusCode());\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_name_resolver_exception =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @see     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "namespace Swoole\\NameResolver;\n"
    "\n"
    "class Exception extends \\RuntimeException\n"
    "{\n"
    "}\n";

static const char* swoole_library_source_core_name_resolver_cluster =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\NameResolver;\n"
    "\n"
    "use Swoole\\Exception;\n"
    "\n"
    "class Cluster\n"
    "{\n"
    "    private array $nodes = [];\n"
    "\n"
    "    /**\n"
    "     * @throws Exception\n"
    "     */\n"
    "    public function add(string $host, int $port, int $weight = 100): void\n"
    "    {\n"
    "        if (!filter_var($host, FILTER_VALIDATE_IP)) {\n"
    "            throw new Exception(\"Bad IP Address [{$host}]\");\n"
    "        }\n"
    "        if ($port < 0 or $port > 65535) {\n"
    "            throw new Exception(\"Bad Port [{$port}]\");\n"
    "        }\n"
    "        if ($weight < 0 or $weight > 100) {\n"
    "            throw new Exception(\"Bad Weight [{$weight}]\");\n"
    "        }\n"
    "        $this->nodes[] = ['host' => $host, 'port' => $port, 'weight' => $weight];\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|string\n"
    "     */\n"
    "    public function pop()\n"
    "    {\n"
    "        if (empty($this->nodes)) {\n"
    "            return false;\n"
    "        }\n"
    "        $index = array_rand($this->nodes, 1);\n"
    "        $node  = $this->nodes[$index];\n"
    "        unset($this->nodes[$index]);\n"
    "        return $node;\n"
    "    }\n"
    "\n"
    "    public function count(): int\n"
    "    {\n"
    "        return count($this->nodes);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_name_resolver_redis =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @see     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "namespace Swoole\\NameResolver;\n"
    "\n"
    "use Swoole\\NameResolver;\n"
    "\n"
    "class Redis extends NameResolver\n"
    "{\n"
    "    private $serverHost;\n"
    "\n"
    "    private $serverPort;\n"
    "\n"
    "    public function __construct($url, $prefix = 'swoole:service:')\n"
    "    {\n"
    "        parent::__construct($url, $prefix);\n"
    "        $this->serverHost = $this->info['ip'];\n"
    "        $this->serverPort = $this->info['port'] ?? 6379;\n"
    "    }\n"
    "\n"
    "    public function join(string $name, string $ip, int $port, array $options = []): bool\n"
    "    {\n"
    "        if (($redis = $this->connect()) === false) {\n"
    "            return false;\n"
    "        }\n"
    "        if ($redis->sAdd($this->prefix . $name, $ip . ':' . $port) === false) {\n"
    "            return false;\n"
    "        }\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    public function leave(string $name, string $ip, int $port): bool\n"
    "    {\n"
    "        if (($redis = $this->connect()) === false) {\n"
    "            return false;\n"
    "        }\n"
    "        if ($redis->sRem($this->prefix . $name, $ip . ':' . $port) === false) {\n"
    "            return false;\n"
    "        }\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    public function getCluster(string $name): ?Cluster\n"
    "    {\n"
    "        if (($redis = $this->connect()) === false) {\n"
    "            return null;\n"
    "        }\n"
    "        $members = $redis->sMembers($this->prefix . $name);\n"
    "        if (empty($members)) {\n"
    "            return null;\n"
    "        }\n"
    "        $cluster = new Cluster();\n"
    "        foreach ($members as $m) {\n"
    "            [$host, $port] = explode(':', $m);\n"
    "            $cluster->add($host, intval($port));\n"
    "        }\n"
    "        return $cluster;\n"
    "    }\n"
    "\n"
    "    protected function connect()\n"
    "    {\n"
    "        $redis = new \\Redis();\n"
    "        if ($redis->connect($this->serverHost, $this->serverPort) === false) {\n"
    "            return false;\n"
    "        }\n"
    "        return $redis;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_name_resolver_nacos =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @see     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "namespace Swoole\\NameResolver;\n"
    "\n"
    "use Swoole\\Coroutine;\n"
    "use Swoole\\NameResolver;\n"
    "\n"
    "class Nacos extends NameResolver\n"
    "{\n"
    "    /**\n"
    "     * @throws Coroutine\\Http\\Client\\Exception|Exception\n"
    "     */\n"
    "    public function join(string $name, string $ip, int $port, array $options = []): bool\n"
    "    {\n"
    "        $params['port']        = $port;\n"
    "        $params['ip']          = $ip;\n"
    "        $params['healthy']     = 'true';\n"
    "        $params['weight']      = $options['weight'] ?? 100;\n"
    "        $params['encoding']    = $options['encoding'] ?? 'utf-8';\n"
    "        $params['namespaceId'] = $options['namespaceId'] ?? 'public';\n"
    "        $params['serviceName'] = $this->prefix . $name;\n"
    "\n"
    "        $url = $this->baseUrl . '/nacos/v1/ns/instance?' . http_build_query($params);\n"
    "        $r   = Coroutine\\Http\\post($url, []);\n"
    "        return $this->checkResponse($r);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @throws Coroutine\\Http\\Client\\Exception|Exception\n"
    "     */\n"
    "    public function leave(string $name, string $ip, int $port): bool\n"
    "    {\n"
    "        $params['port']        = $port;\n"
    "        $params['ip']          = $ip;\n"
    "        $params['serviceName'] = $this->prefix . $name;\n"
    "\n"
    "        $url = $this->baseUrl . '/nacos/v1/ns/instance?' . http_build_query($params);\n"
    "        $r   = Coroutine\\Http\\request($this->baseUrl . '/nacos/v1/ns/instance?' . http_build_query($params), 'DELETE');\n"
    "        return $this->checkResponse($r);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @throws Coroutine\\Http\\Client\\Exception|Exception|\\Swoole\\Exception\n"
    "     */\n"
    "    public function getCluster(string $name): ?Cluster\n"
    "    {\n"
    "        $params['serviceName'] = $this->prefix . $name;\n"
    "\n"
    "        $url = $this->baseUrl . '/nacos/v1/ns/instance/list?' . http_build_query($params);\n"
    "        $r   = Coroutine\\Http\\get($url);\n"
    "        if (!$this->checkResponse($r)) {\n"
    "            return null;\n"
    "        }\n"
    "        $result = json_decode($r->getBody(), null, 512, JSON_THROW_ON_ERROR);\n"
    "        if (empty($result)) {\n"
    "            return null;\n"
    "        }\n"
    "        $cluster = new Cluster();\n"
    "        foreach ($result->hosts as $node) {\n"
    "            $cluster->add($node->ip, $node->port, $node->weight);\n"
    "        }\n"
    "        return $cluster;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_name_resolver_consul =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @see     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "namespace Swoole\\NameResolver;\n"
    "\n"
    "use Swoole\\NameResolver;\n"
    "\n"
    "use function Swoole\\Coroutine\\Http\\get;\n"
    "use function Swoole\\Coroutine\\Http\\request;\n"
    "\n"
    "class Consul extends NameResolver\n"
    "{\n"
    "    public function join(string $name, string $ip, int $port, array $options = []): bool\n"
    "    {\n"
    "        $weight = $options['weight'] ?? 100;\n"
    "        $data   = [\n"
    "            'ID'                => $this->getServiceId($name, $ip, $port),\n"
    "            'Name'              => $this->prefix . $name,\n"
    "            'Address'           => $ip,\n"
    "            'Port'              => $port,\n"
    "            'EnableTagOverride' => false,\n"
    "            'Weights'           => [\n"
    "                'Passing' => $weight,\n"
    "                'Warning' => 1,\n"
    "            ],\n"
    "        ];\n"
    "        $url = $this->baseUrl . '/v1/agent/service/register';\n"
    "        $r   = request($url, 'PUT', json_encode($data, JSON_THROW_ON_ERROR));\n"
    "        return $this->checkResponse($r);\n"
    "    }\n"
    "\n"
    "    public function leave(string $name, string $ip, int $port): bool\n"
    "    {\n"
    "        $url = $this->baseUrl . '/v1/agent/service/deregister/' . $this->getServiceId(\n"
    "            $name,\n"
    "            $ip,\n"
    "            $port\n"
    "        );\n"
    "        $r = request($url, 'PUT');\n"
    "        return $this->checkResponse($r);\n"
    "    }\n"
    "\n"
    "    public function enableMaintenanceMode(string $name, string $ip, int $port): bool\n"
    "    {\n"
    "        $url = $this->baseUrl . '/v1/agent/service/maintenance/' . $this->getServiceId(\n"
    "            $name,\n"
    "            $ip,\n"
    "            $port\n"
    "        );\n"
    "        $r = request($url, 'PUT');\n"
    "        return $this->checkResponse($r);\n"
    "    }\n"
    "\n"
    "    public function getCluster(string $name): ?Cluster\n"
    "    {\n"
    "        $url = $this->baseUrl . '/v1/catalog/service/' . $this->prefix . $name;\n"
    "        $r   = get($url);\n"
    "        if (!$this->checkResponse($r)) {\n"
    "            return null;\n"
    "        }\n"
    "        $list = json_decode($r->getBody(), null, 512, JSON_THROW_ON_ERROR);\n"
    "        if (empty($list)) {\n"
    "            return null;\n"
    "        }\n"
    "        $cluster = new Cluster();\n"
    "        foreach ($list as $li) {\n"
    "            $cluster->add($li->ServiceAddress, $li->ServicePort, $li->ServiceWeights->Passing);\n"
    "        }\n"
    "        return $cluster;\n"
    "    }\n"
    "\n"
    "    private function getServiceId(string $name, string $ip, int $port): string\n"
    "    {\n"
    "        return $this->prefix . $name . \"_{$ip}:{$port}\";\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_thread_pool =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Thread;\n"
    "\n"
    "use PhpParser\\Error;\n"
    "use PhpParser\\ParserFactory;\n"
    "use Swoole\\Thread;\n"
    "\n"
    "/**\n"
    " * @since 6.0.0-beta\n"
    " */\n"
    "class Pool\n"
    "{\n"
    "    private array $threads = [];\n"
    "\n"
    "    private string $autoloader = '';\n"
    "\n"
    "    private string $classDefinitionFile = '';\n"
    "\n"
    "    private string $runnableClass = '';\n"
    "\n"
    "    private int $threadNum = 0;\n"
    "\n"
    "    private string $proxyFile;\n"
    "\n"
    "    private array $arguments = [];\n"
    "\n"
    "    private object $running;\n"
    "\n"
    "    private object $queue;\n"
    "\n"
    "    private array $indexes = [];\n"
    "\n"
    "    public function __construct(string $runnableClass, int $threadNum)\n"
    "    {\n"
    "        if ($threadNum <= 0) {\n"
    "            throw new \\Exception('threadNum must be greater than 0');\n"
    "        }\n"
    "        $this->runnableClass = $runnableClass;\n"
    "        $this->threadNum     = $threadNum;\n"
    "    }\n"
    "\n"
    "    public function withArguments(...$arguments): static\n"
    "    {\n"
    "        $this->arguments = $arguments;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withAutoloader(string $autoloader): static\n"
    "    {\n"
    "        $this->autoloader = $autoloader;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withClassDefinitionFile(string $classDefinitionFile): static\n"
    "    {\n"
    "        $this->classDefinitionFile = $classDefinitionFile;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @throws \\ReflectionException\n"
    "     */\n"
    "    public function start(): void\n"
    "    {\n"
    "        if (empty($this->classDefinitionFile) and class_exists($this->runnableClass, false)) {\n"
    "            $file = (new \\ReflectionClass($this->runnableClass))->getFileName();\n"
    "            if (!$this->isValidPhpFile($file)) {\n"
    "                throw new \\Exception('class definition file must not contain any expressions.');\n"
    "            }\n"
    "            $this->classDefinitionFile = $file;\n"
    "        } elseif ($this->classDefinitionFile) {\n"
    "            require_once $this->classDefinitionFile;\n"
    "        }\n"
    "\n"
    "        if (!class_exists($this->runnableClass)) {\n"
    "            throw new \\Exception(\"class `{$this->runnableClass}` not found\");\n"
    "        }\n"
    "\n"
    "        if (!is_subclass_of($this->runnableClass, Runnable::class)) {\n"
    "            throw new \\Exception(\"class `{$this->runnableClass}` must implements Thread\\\\Runnable\");\n"
    "        }\n"
    "\n"
    "        if (empty($this->autoloader)) {\n"
    "            $include_files = get_included_files();\n"
    "            foreach ($include_files as $file) {\n"
    "                if (str_ends_with($file, 'vendor/autoload.php')) {\n"
    "                    $this->autoloader = $file;\n"
    "                    break;\n"
    "                }\n"
    "            }\n"
    "        }\n"
    "\n"
    "        if ($this->autoloader) {\n"
    "            $this->proxyFile = dirname($this->autoloader) . '/thread_runner.php';\n"
    "        } else {\n"
    "            $this->proxyFile = dirname($this->classDefinitionFile) . '/thread_runner.php';\n"
    "        }\n"
    "\n"
    "        if (!is_file($this->proxyFile)) {\n"
    "            $script = '<?php' . PHP_EOL;\n"
    "            $script .= '$arguments = Swoole\\Thread::getArguments();' . PHP_EOL;\n"
    "            $script .= '$threadId = Swoole\\Thread::getId();' . PHP_EOL;\n"
    "            $script .= '$autoloader = $arguments[0];' . PHP_EOL;\n"
    "            $script .= '$runnableClass = $arguments[1];' . PHP_EOL;\n"
    "            $script .= '$queue = $arguments[2];' . PHP_EOL;\n"
    "            $script .= '$classDefinitionFile = $arguments[3];' . PHP_EOL;\n"
    "            $script .= '$running = $arguments[4];' . PHP_EOL;\n"
    "            $script .= '$index = $arguments[5];' . PHP_EOL;\n"
    "            $script .= '$threadArguments = array_slice($arguments, 6);' . PHP_EOL;\n"
    "            $script .= 'if ($autoloader) require_once $autoloader;' . PHP_EOL;\n"
    "            $script .= 'if ($classDefinitionFile) require_once $classDefinitionFile;' . PHP_EOL;\n"
    "            $script .= '$runnable = new $runnableClass($running, $index);' . PHP_EOL;\n"
    "            $script .= 'try { $runnable->run($threadArguments); }' . PHP_EOL;\n"
    "            $script .= 'finally { $queue->push($threadId, Swoole\\Thread\\Queue::NOTIFY_ONE); }' . PHP_EOL;\n"
    "            $script .= PHP_EOL;\n"
    "            file_put_contents($this->proxyFile, $script);\n"
    "        }\n"
    "\n"
    "        $this->queue   = new Queue();\n"
    "        $this->running = new Atomic(1);\n"
    "\n"
    "        for ($index = 0; $index < $this->threadNum; $index++) {\n"
    "            $this->createThread($index);\n"
    "        }\n"
    "\n"
    "        while ($this->running->get()) {\n"
    "            $threadId = $this->queue->pop(-1);\n"
    "            $thread   = $this->threads[$threadId];\n"
    "            $index    = $this->indexes[$threadId];\n"
    "            $thread->join();\n"
    "            unset($this->threads[$threadId], $this->indexes[$threadId]);\n"
    "\n"
    "            $this->createThread($index);\n"
    "        }\n"
    "\n"
    "        foreach ($this->threads as $thread) {\n"
    "            $thread->join();\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function shutdown(): void\n"
    "    {\n"
    "        $this->running->set(0);\n"
    "    }\n"
    "\n"
    "    protected function isValidPhpFile($filePath): bool\n"
    "    {\n"
    "        $allowedNodeTypes = [\n"
    "            \\PhpParser\\Node\\Stmt\\Class_::class,\n"
    "            \\PhpParser\\Node\\Stmt\\Const_::class,\n"
    "            \\PhpParser\\Node\\Stmt\\Use_::class,\n"
    "            \\PhpParser\\Node\\Stmt\\Namespace_::class,\n"
    "            \\PhpParser\\Node\\Stmt\\Declare_::class,\n"
    "        ];\n"
    "\n"
    "        $parser = (new ParserFactory())->createForNewestSupportedVersion();\n"
    "        try {\n"
    "            $code     = file_get_contents($filePath);\n"
    "            $stmts    = $parser->parse($code);\n"
    "            $skipLine = -1;\n"
    "            foreach ($stmts as $stmt) {\n"
    "                $isAllowed = false;\n"
    "                foreach ($allowedNodeTypes as $allowedNodeType) {\n"
    "                    if ($stmt instanceof $allowedNodeType) {\n"
    "                        $isAllowed = true;\n"
    "                        break;\n"
    "                    }\n"
    "                }\n"
    "                if (!$isAllowed) {\n"
    "                    if ($stmt->getLine() == $skipLine) {\n"
    "                        continue;\n"
    "                    }\n"
    "                    return false;\n"
    "                }\n"
    "            }\n"
    "        } catch (Error $error) {\n"
    "            return false;\n"
    "        }\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    protected function createThread($index): void\n"
    "    {\n"
    "        $thread = new Thread($this->proxyFile,\n"
    "            $this->autoloader,\n"
    "            $this->runnableClass,\n"
    "            $this->queue,\n"
    "            $this->classDefinitionFile,\n"
    "            $this->running,\n"
    "            $index,\n"
    "            ...$this->arguments\n"
    "        );\n"
    "        $this->indexes[$thread->id] = $index;\n"
    "        $this->threads[$thread->id] = $thread;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_thread_runnable =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Thread;\n"
    "\n"
    "/**\n"
    " * @since 6.0.0-beta\n"
    " */\n"
    "abstract class Runnable\n"
    "{\n"
    "    protected Atomic $running;\n"
    "\n"
    "    protected int $id;\n"
    "\n"
    "    public function __construct($running, $index)\n"
    "    {\n"
    "        $this->running = $running;\n"
    "        $this->id      = $index;\n"
    "    }\n"
    "\n"
    "    abstract public function run(array $args): void;\n"
    "\n"
    "    protected function isRunning(): bool\n"
    "    {\n"
    "        return $this->running->get() === 1;\n"
    "    }\n"
    "\n"
    "    protected function shutdown(): void\n"
    "    {\n"
    "        $this->running->set(0);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_functions =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine;\n"
    "\n"
    "use Swoole\\Coroutine;\n"
    "\n"
    "function run(callable $fn, ...$args)\n"
    "{\n"
    "    $s       = new Scheduler();\n"
    "    $options = Coroutine::getOptions();\n"
    "    if (!isset($options['hook_flags'])) {\n"
    "        $s->set(['hook_flags' => SWOOLE_HOOK_ALL]);\n"
    "    }\n"
    "    $s->add($fn, ...$args);\n"
    "    return $s->start();\n"
    "}\n"
    "\n"
    "function go(callable $fn, ...$args)\n"
    "{\n"
    "    return Coroutine::create($fn, ...$args);\n"
    "}\n"
    "\n"
    "function defer(callable $fn)\n"
    "{\n"
    "    Coroutine::defer($fn);\n"
    "}\n"
    "\n"
    "function batch(array $tasks, float $timeout = -1): array\n"
    "{\n"
    "    $wg = new WaitGroup(count($tasks));\n"
    "    foreach ($tasks as $id => $task) {\n"
    "        Coroutine::create(function () use ($wg, &$tasks, $id, $task) {\n"
    "            $tasks[$id] = null;\n"
    "            $tasks[$id] = $task();\n"
    "            $wg->done();\n"
    "        });\n"
    "    }\n"
    "    $wg->wait($timeout);\n"
    "    return $tasks;\n"
    "}\n"
    "\n"
    "function parallel(int $n, callable $fn): void\n"
    "{\n"
    "    $count = $n;\n"
    "    $wg    = new WaitGroup($n);\n"
    "    while ($count--) {\n"
    "        Coroutine::create(function () use ($fn, $wg) {\n"
    "            $fn();\n"
    "            $wg->done();\n"
    "        });\n"
    "    }\n"
    "    $wg->wait();\n"
    "}\n"
    "\n"
    "/**\n"
    " * Applies the callback to the elements of the given list.\n"
    " *\n"
    " * The callback function takes on two parameters. The list parameter's value being the first, and the key/index second.\n"
    " * Each callback runs in a new coroutine, allowing the list to be processed in parallel.\n"
    " *\n"
    " * @param array $list A list of key/value paired input data.\n"
    " * @param callable $fn The callback function to apply to each item on the list. The callback takes on two parameters.\n"
    " *                     The list parameter's value being the first, and the key/index second.\n"
    " * @param float $timeout > 0 means waiting for the specified number of seconds. other means no waiting.\n"
    " * @return array Returns an array containing the results of applying the callback function to the corresponding value\n"
    " *               and key of the list (used as arguments for the callback). The returned array will preserve the keys of\n"
    " *               the list.\n"
    " */\n"
    "function map(array $list, callable $fn, float $timeout = -1): array\n"
    "{\n"
    "    $wg = new WaitGroup(count($list));\n"
    "    foreach ($list as $id => $elem) {\n"
    "        Coroutine::create(function () use ($wg, &$list, $id, $elem, $fn): void {\n"
    "            $list[$id] = null;\n"
    "            $list[$id] = $fn($elem, $id);\n"
    "            $wg->done();\n"
    "        });\n"
    "    }\n"
    "    $wg->wait($timeout);\n"
    "    return $list;\n"
    "}\n"
    "\n"
    "function deadlock_check()\n"
    "{\n"
    "    $all_coroutines = Coroutine::listCoroutines();\n"
    "    $count          = Coroutine::stats()['coroutine_num'];\n"
    "\n"
    "    // coroutine deadlock detected, header\n"
    "    $hr_width = 64 + strlen(strval($count));\n"
    "    $hr1      = str_repeat('=', $hr_width);\n"
    "    $hr2      = str_repeat('-', $hr_width);\n"
    "    echo '',\n"
    "    \"\\n {$hr1}\",\n"
    "    \"\\n  [FATAL ERROR]: all coroutines (count: {$count}) are asleep - deadlock!\",\n"
    "    \"\\n {$hr1}\",\n"
    "    \"\\n\";\n"
    "\n"
    "    // print all coroutine backtraces\n"
    "    $options = Coroutine::getOptions();\n"
    "    if (empty($options['deadlock_check_disable_trace'])) {\n"
    "        $index = 0;\n"
    "        $limit = empty($options['deadlock_check_limit']) ? 32 : intval($options['deadlock_check_limit']);\n"
    "        $depth = empty($options['deadlock_check_depth']) ? 32 : intval($options['deadlock_check_depth']);\n"
    "        foreach ($all_coroutines as $cid) {\n"
    "            echo \"\\n  [Coroutine-{$cid}]\";\n"
    "            echo \"\\n {$hr2}\\n\";\n"
    "            echo Coroutine::printBackTrace($cid, DEBUG_BACKTRACE_IGNORE_ARGS, $depth);\n"
    "            $index++;\n"
    "            // limit the number of maximum outputs\n"
    "            if ($index >= $limit) {\n"
    "                break;\n"
    "            }\n"
    "        }\n"
    "    }\n"
    "\n"
    "    // footer\n"
    "    echo \"\\n {$hr1}\\n\";\n"
    "}\n";

static const char* swoole_library_source_ext_curl =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "/* @noinspection PhpComposerExtensionStubsInspection */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "function swoole_curl_init(string $url = ''): Swoole\\Curl\\Handler\n"
    "{\n"
    "    return new Swoole\\Curl\\Handler($url);\n"
    "}\n"
    "\n"
    "function swoole_curl_setopt(Swoole\\Curl\\Handler $obj, int $opt, $value): bool\n"
    "{\n"
    "    return $obj->setOpt($opt, $value);\n"
    "}\n"
    "\n"
    "function swoole_curl_setopt_array(Swoole\\Curl\\Handler $obj, $array): bool\n"
    "{\n"
    "    foreach ($array as $k => $v) {\n"
    "        if ($obj->setOpt($k, $v) !== true) {\n"
    "            return false;\n"
    "        }\n"
    "    }\n"
    "    return true;\n"
    "}\n"
    "\n"
    "function swoole_curl_exec(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->exec();\n"
    "}\n"
    "\n"
    "function swoole_curl_getinfo(Swoole\\Curl\\Handler $obj, int $opt = 0)\n"
    "{\n"
    "    $info = $obj->getInfo();\n"
    "    if (is_array($info) and $opt) {\n"
    "        return match ($opt) {\n"
    "            CURLINFO_EFFECTIVE_URL      => $info['url'],\n"
    "            CURLINFO_HTTP_CODE          => $info['http_code'],\n"
    "            CURLINFO_CONTENT_TYPE       => $info['content_type'],\n"
    "            CURLINFO_REDIRECT_COUNT     => $info['redirect_count'],\n"
    "            CURLINFO_REDIRECT_URL       => $info['redirect_url'],\n"
    "            CURLINFO_TOTAL_TIME         => $info['total_time'],\n"
    "            CURLINFO_STARTTRANSFER_TIME => $info['starttransfer_time'],\n"
    "            CURLINFO_SIZE_DOWNLOAD      => $info['size_download'],\n"
    "            CURLINFO_SPEED_DOWNLOAD     => $info['speed_download'],\n"
    "            CURLINFO_REDIRECT_TIME      => $info['redirect_time'],\n"
    "            CURLINFO_HEADER_SIZE        => $info['header_size'],\n"
    "            CURLINFO_PRIMARY_IP         => $info['primary_ip'],\n"
    "            CURLINFO_PRIVATE            => $info['private'],\n"
    "            default                     => null,\n"
    "        };\n"
    "    }\n"
    "    return $info;\n"
    "}\n"
    "\n"
    "function swoole_curl_errno(Swoole\\Curl\\Handler $obj): int\n"
    "{\n"
    "    return $obj->errno();\n"
    "}\n"
    "\n"
    "function swoole_curl_error(Swoole\\Curl\\Handler $obj): string\n"
    "{\n"
    "    return $obj->error();\n"
    "}\n"
    "\n"
    "function swoole_curl_reset(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->reset();\n"
    "}\n"
    "\n"
    "function swoole_curl_close(Swoole\\Curl\\Handler $obj): void\n"
    "{\n"
    "    $obj->close();\n"
    "}\n"
    "\n"
    "function swoole_curl_multi_getcontent(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->getContent();\n"
    "}\n";

static const char* swoole_library_source_ext_sockets =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "use Swoole\\Coroutine\\Socket;\n"
    "\n"
    "function swoole_socket_create(int $domain, int $type, int $protocol)\n"
    "{\n"
    "    return new Socket($domain, $type, $protocol);\n"
    "}\n"
    "\n"
    "function swoole_socket_connect(Socket $socket, string $address, int $port = 0)\n"
    "{\n"
    "    return $socket->connect($address, $port);\n"
    "}\n"
    "\n"
    "function swoole_socket_read(Socket $socket, int $length, int $type = PHP_BINARY_READ)\n"
    "{\n"
    "    if ($type != PHP_BINARY_READ) {\n"
    "        return $socket->recvLine($length);\n"
    "    }\n"
    "    return $socket->recv($length);\n"
    "}\n"
    "\n"
    "function swoole_socket_write(Socket $socket, string $buffer, int $length = 0)\n"
    "{\n"
    "    if ($length > 0 and $length < strlen($buffer)) {\n"
    "        $buffer = substr($buffer, 0, $length);\n"
    "    }\n"
    "    return $socket->send($buffer);\n"
    "}\n"
    "\n"
    "function swoole_socket_send(Socket $socket, string $buffer, int $length, int $flags)\n"
    "{\n"
    "    if ($flags != 0) {\n"
    "        throw new RuntimeException(\"\\$flags[{$flags}] is not supported\");\n"
    "    }\n"
    "    return swoole_socket_write($socket, $buffer, $length);\n"
    "}\n"
    "\n"
    "function swoole_socket_recv(Socket $socket, &$buffer, int $length, int $flags)\n"
    "{\n"
    "    if ($flags & MSG_OOB) {\n"
    "        throw new RuntimeException('\\$flags[MSG_OOB] is not supported');\n"
    "    }\n"
    "    if ($flags & MSG_PEEK) {\n"
    "        $buffer = $socket->peek($length);\n"
    "    }\n"
    "    $timeout = $flags & MSG_DONTWAIT ? 0.001 : 0;\n"
    "    if ($flags & MSG_WAITALL) {\n"
    "        $buffer = $socket->recvAll($length, $timeout);\n"
    "    } else {\n"
    "        $buffer = $socket->recv($length, $timeout);\n"
    "    }\n"
    "    if ($buffer === false) {\n"
    "        return false;\n"
    "    }\n"
    "    return strlen($buffer);\n"
    "}\n"
    "\n"
    "function swoole_socket_sendto(Socket $socket, string $buffer, int $length, int $flags, string $addr, int $port = 0)\n"
    "{\n"
    "    if ($flags != 0) {\n"
    "        throw new RuntimeException(\"\\$flags[{$flags}] is not supported\");\n"
    "    }\n"
    "    if ($socket->type != SOCK_DGRAM) {\n"
    "        throw new RuntimeException('only supports dgram type socket');\n"
    "    }\n"
    "    if ($length > 0 and $length < strlen($buffer)) {\n"
    "        $buffer = substr($buffer, 0, $length);\n"
    "    }\n"
    "    return $socket->sendto($addr, $port, $buffer);\n"
    "}\n"
    "\n"
    "function swoole_socket_recvfrom(Socket $socket, &$buffer, int $length, int $flags, &$name, &$port = null)\n"
    "{\n"
    "    if ($flags != 0) {\n"
    "        throw new RuntimeException(\"\\$flags[{$flags}] is not supported\");\n"
    "    }\n"
    "    if ($length == 0) {\n"
    "        $socket->errCode = SOCKET_EAGAIN;\n"
    "        return false;\n"
    "    }\n"
    "    if ($socket->type != SOCK_DGRAM) {\n"
    "        throw new RuntimeException('only supports dgram type socket');\n"
    "    }\n"
    "    $data = $socket->recvfrom($peer);\n"
    "    if ($data === false) {\n"
    "        return false;\n"
    "    }\n"
    "    $name = $peer['address'];\n"
    "    if (func_num_args() == 6) {\n"
    "        $port = $peer['port'];\n"
    "    }\n"
    "    if ($length < strlen($data)) {\n"
    "        $buffer = substr($data, 0, $length);\n"
    "    } else {\n"
    "        $buffer = $data;\n"
    "    }\n"
    "    return strlen($buffer);\n"
    "}\n"
    "\n"
    "function swoole_socket_bind(Socket $socket, string $address, int $port = 0): bool\n"
    "{\n"
    "    return $socket->bind($address, $port);\n"
    "}\n"
    "\n"
    "function swoole_socket_listen(Socket $socket, int $backlog = 0): bool\n"
    "{\n"
    "    return $socket->listen($backlog);\n"
    "}\n"
    "\n"
    "function swoole_socket_create_listen(int $port, int $backlog = 128)\n"
    "{\n"
    "    $socket = new Socket(AF_INET, SOCK_STREAM, SOL_TCP);\n"
    "    if (!$socket->bind('0.0.0.0', $port)) {\n"
    "        return false;\n"
    "    }\n"
    "    if (!$socket->listen($backlog)) {\n"
    "        return false;\n"
    "    }\n"
    "    return $socket;\n"
    "}\n"
    "\n"
    "function swoole_socket_accept(Socket $socket)\n"
    "{\n"
    "    return $socket->accept();\n"
    "}\n"
    "\n"
    "function swoole_socket_getpeername(Socket $socket, &$address, &$port = null)\n"
    "{\n"
    "    $info = $socket->getpeername();\n"
    "    if (!$info) {\n"
    "        return false;\n"
    "    }\n"
    "    $address = $info['address'];\n"
    "    if (func_num_args() == 3) {\n"
    "        $port = $info['port'];\n"
    "    }\n"
    "    return true;\n"
    "}\n"
    "\n"
    "function swoole_socket_getsockname(Socket $socket, &$address, &$port = null)\n"
    "{\n"
    "    $info = $socket->getsockname();\n"
    "    if (!$info) {\n"
    "        return false;\n"
    "    }\n"
    "    $address = $info['address'];\n"
    "    if (func_num_args() == 3) {\n"
    "        $port = $info['port'];\n"
    "    }\n"
    "    return true;\n"
    "}\n"
    "\n"
    "function swoole_socket_set_option(Socket $socket, int $level, int $optname, $optval): bool\n"
    "{\n"
    "    return $socket->setOption($level, $optname, $optval);\n"
    "}\n"
    "\n"
    "function swoole_socket_setopt(Socket $socket, int $level, int $optname, $optval): bool\n"
    "{\n"
    "    return $socket->setOption($level, $optname, $optval);\n"
    "}\n"
    "\n"
    "function swoole_socket_get_option(Socket $socket, int $level, int $optname)\n"
    "{\n"
    "    return $socket->getOption($level, $optname);\n"
    "}\n"
    "\n"
    "function swoole_socket_getopt(Socket $socket, int $level, int $optname)\n"
    "{\n"
    "    return $socket->getOption($level, $optname);\n"
    "}\n"
    "\n"
    "function swoole_socket_shutdown(Socket $socket, int $how = 2): bool\n"
    "{\n"
    "    return $socket->shutdown($how);\n"
    "}\n"
    "\n"
    "function swoole_socket_close(Socket $socket)\n"
    "{\n"
    "    $socket->close();\n"
    "}\n"
    "\n"
    "function swoole_socket_clear_error(?Socket $socket = null)\n"
    "{\n"
    "    if ($socket) {\n"
    "        $socket->errCode = 0;\n"
    "    }\n"
    "    swoole_clear_error();\n"
    "}\n"
    "\n"
    "function swoole_socket_last_error(?Socket $socket = null): int\n"
    "{\n"
    "    if ($socket) {\n"
    "        return $socket->errCode;\n"
    "    }\n"
    "    return swoole_last_error();\n"
    "}\n"
    "\n"
    "function swoole_socket_set_block(Socket $socket)\n"
    "{\n"
    "    if ($socket->isClosed()) {\n"
    "        return false;\n"
    "    }\n"
    "    if (isset($socket->__ext_sockets_nonblock) and $socket->__ext_sockets_nonblock) {\n"
    "        $socket->setOption(SOL_SOCKET, SO_RCVTIMEO, $socket->__ext_sockets_timeout); // @phpstan-ignore property.notFound\n"
    "    }\n"
    "    $socket->__ext_sockets_nonblock = false; // @phpstan-ignore property.notFound\n"
    "    return true;\n"
    "}\n"
    "\n"
    "function swoole_socket_set_nonblock(Socket $socket)\n"
    "{\n"
    "    if ($socket->isClosed()) {\n"
    "        return false;\n"
    "    }\n"
    "    if (isset($socket->__ext_sockets_nonblock) and $socket->__ext_sockets_nonblock) {\n"
    "        return true;\n"
    "    }\n"
    "    $socket->__ext_sockets_nonblock = true; // @phpstan-ignore property.notFound\n"
    "    $socket->__ext_sockets_timeout  = $socket->getOption(SOL_SOCKET, SO_RCVTIMEO); // @phpstan-ignore property.notFound\n"
    "    $socket->setOption(SOL_SOCKET, SO_RCVTIMEO, ['sec' => 0, 'usec' => 1000]);\n"
    "    return true;\n"
    "}\n"
    "\n"
    "function swoole_socket_create_pair(\n"
    "    int $domain,\n"
    "    int $type,\n"
    "    int $protocol,\n"
    "    array &$pair,\n"
    ") {\n"
    "    $_pair = swoole_coroutine_socketpair($domain, $type, $protocol);\n"
    "    if ($_pair) {\n"
    "        $pair = $_pair;\n"
    "        return true;\n"
    "    }\n"
    "    return false;\n"
    "}\n"
    "\n"
    "/**\n"
    " * @since 5.0.0\n"
    " */\n"
    "function swoole_socket_import_stream(mixed $stream): Socket|false\n"
    "{\n"
    "    return Socket::import($stream); // @phpstan-ignore staticMethod.notFound\n"
    "}\n";

static const char* swoole_library_source_functions =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "if (PHP_VERSION_ID < 80100) { // @phpstan-ignore smaller.alwaysFalse\n"
    "    throw new RuntimeException('require PHP version 8.1 or later');\n"
    "}\n"
    "\n"
    "if (SWOOLE_USE_SHORTNAME) { // @phpstan-ignore if.alwaysTrue\n"
    "    function _string(string $string = ''): Swoole\\StringObject\n"
    "    {\n"
    "        return new Swoole\\StringObject($string);\n"
    "    }\n"
    "\n"
    "    function _mbstring(string $string = ''): Swoole\\MultibyteStringObject\n"
    "    {\n"
    "        return new Swoole\\MultibyteStringObject($string);\n"
    "    }\n"
    "\n"
    "    function _array(array $array = []): Swoole\\ArrayObject\n"
    "    {\n"
    "        return new Swoole\\ArrayObject($array);\n"
    "    }\n"
    "}\n"
    "\n"
    "class SwooleLibrary\n"
    "{\n"
    "    /**\n"
    "     * @var array<string, mixed>\n"
    "     */\n"
    "    public static array $options = [];\n"
    "}\n"
    "\n"
    "/**\n"
    " * @param array<string, mixed> $options\n"
    " */\n"
    "function swoole_library_set_options(array $options): void\n"
    "{\n"
    "    SwooleLibrary::$options = $options;\n"
    "}\n"
    "\n"
    "function swoole_library_get_options(): array\n"
    "{\n"
    "    return SwooleLibrary::$options;\n"
    "}\n"
    "\n"
    "function swoole_library_set_option(string $key, mixed $value): void\n"
    "{\n"
    "    SwooleLibrary::$options[$key] = $value;\n"
    "}\n"
    "\n"
    "function swoole_library_get_option(string $key): mixed\n"
    "{\n"
    "    return SwooleLibrary::$options[$key] ?? null;\n"
    "}\n"
    "\n"
    "function swoole_string(string $string = ''): Swoole\\StringObject\n"
    "{\n"
    "    return new Swoole\\StringObject($string);\n"
    "}\n"
    "\n"
    "function swoole_mbstring(string $string = ''): Swoole\\MultibyteStringObject\n"
    "{\n"
    "    return new Swoole\\MultibyteStringObject($string);\n"
    "}\n"
    "\n"
    "function swoole_array(array $array = []): Swoole\\ArrayObject\n"
    "{\n"
    "    return new Swoole\\ArrayObject($array);\n"
    "}\n"
    "\n"
    "function swoole_table(int $size, string $fields): Swoole\\Table\n"
    "{\n"
    "    $_fields = swoole_string($fields)->trim()->split(',');\n"
    "\n"
    "    $table = new Swoole\\Table($size, 0.25);\n"
    "\n"
    "    foreach ($_fields as $f) {\n"
    "        $_f   = swoole_string($f)->trim()->split(':');\n"
    "        $name = $_f->get(0)->trim()->toString();\n"
    "        $type = $_f->get(1)->trim();\n"
    "\n"
    "        switch ($type) {\n"
    "            case 'i':\n"
    "            case 'int':\n"
    "                $table->column($name, Swoole\\Table::TYPE_INT);\n"
    "                break;\n"
    "            case 'f':\n"
    "            case 'float':\n"
    "                $table->column($name, Swoole\\Table::TYPE_FLOAT);\n"
    "                break;\n"
    "            case 's':\n"
    "            case 'string':\n"
    "                if ($_f->count() < 3) {\n"
    "                    throw new RuntimeException('need to give string length');\n"
    "                }\n"
    "                $length = (int) $_f->get(2)->trim()->toString();\n"
    "                if ($length <= 0) {\n"
    "                    throw new RuntimeException(\"invalid string length[{$length}]\");\n"
    "                }\n"
    "                $table->column($name, Swoole\\Table::TYPE_STRING, $length);\n"
    "                break;\n"
    "            default:\n"
    "                throw new RuntimeException(\"unknown field type[{$type}]\");\n"
    "        }\n"
    "    }\n"
    "\n"
    "    if (!$table->create()) {\n"
    "        throw new RuntimeException('failed to create table');\n"
    "    }\n"
    "\n"
    "    return $table;\n"
    "}\n"
    "\n"
    "function swoole_array_list(...$arrray): Swoole\\ArrayObject\n"
    "{\n"
    "    return new Swoole\\ArrayObject($arrray);\n"
    "}\n"
    "\n"
    "function swoole_array_default_value(array $array, $key, $default_value = null)\n"
    "{\n"
    "    return array_key_exists($key, $array) ? $array[$key] : $default_value;\n"
    "}\n"
    "\n"
    "function swoole_is_in_container()\n"
    "{\n"
    "    $mountinfo = file_get_contents('/proc/self/mountinfo');\n"
    "    return strpos($mountinfo, 'kubepods') > 0 || strpos($mountinfo, 'docker') > 0;\n"
    "}\n"
    "\n"
    "function swoole_container_cpu_num()\n"
    "{\n"
    "    $swoole_cpu_num = intval(getenv('SWOOLE_CPU_NUM'));\n"
    "    if ($swoole_cpu_num > 0) {\n"
    "        return $swoole_cpu_num;\n"
    "    }\n"
    "    if (!swoole_is_in_container()) {\n"
    "        return swoole_cpu_num();\n"
    "    }\n"
    "    // cgroup v2\n"
    "    $cpu_max = '/sys/fs/cgroup/cpu.max';\n"
    "    if (file_exists($cpu_max)) {\n"
    "        $cpu_max  = file_get_contents($cpu_max);\n"
    "        $fields   = explode($cpu_max, ' ');\n"
    "        $quota_us = $fields[0];\n"
    "        if ($quota_us === 'max') { // @phpstan-ignore identical.alwaysFalse\n"
    "            return swoole_cpu_num();\n"
    "        }\n"
    "        $period_us = $fields[1] ?? 100000;\n"
    "    } else {\n"
    "        $quota_us  = file_get_contents('/sys/fs/cgroup/cpu,cpuacct/cpu.cfs_quota_us');\n"
    "        $period_us = file_get_contents('/sys/fs/cgroup/cpu,cpuacct/cpu.cfs_period_us');\n"
    "    }\n"
    "    $cpu_num = floatval($quota_us) / floatval($period_us);\n"
    "    if ($cpu_num < 1) {\n"
    "        return swoole_cpu_num();\n"
    "    }\n"
    "    return intval(floor($cpu_num));\n"
    "}\n";

static const char* swoole_library_source_alias =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "if (SWOOLE_USE_SHORTNAME) { // @phpstan-ignore if.alwaysTrue\n"
    "    class_alias(Swoole\\Coroutine\\WaitGroup::class, Co\\WaitGroup::class, true);\n"
    "    class_alias(Swoole\\Coroutine\\Server::class, Co\\Server::class, true);\n"
    "    class_alias(Swoole\\Coroutine\\Server\\Connection::class, Co\\Server\\Connection::class, true);\n"
    "    class_alias(Swoole\\Coroutine\\FastCGI\\Client::class, Co\\FastCGI\\Client::class, true);\n"
    "    class_alias(Swoole\\Coroutine\\FastCGI\\Client\\Exception::class, Co\\FastCGI\\Client\\Exception::class, true);\n"
    "    class_alias(Swoole\\Coroutine\\FastCGI\\Proxy::class, Co\\FastCGI\\Proxy::class, true);\n"
    "}\n"
    "\n"
    "class_alias(Swoole\\Process\\Manager::class, Swoole\\Process\\ProcessManager::class, true);\n";

static const char* swoole_library_source_alias_ns =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Co;\n"
    "\n"
    "use Swoole\\Coroutine;\n"
    "\n"
    "if (SWOOLE_USE_SHORTNAME) { // @phpstan-ignore if.alwaysTrue\n"
    "    function run(callable $fn, ...$args)\n"
    "    {\n"
    "        return \\Swoole\\Coroutine\\run($fn, ...$args);\n"
    "    }\n"
    "\n"
    "    function go(callable $fn, ...$args)\n"
    "    {\n"
    "        return Coroutine::create($fn, ...$args);\n"
    "    }\n"
    "\n"
    "    function defer(callable $fn)\n"
    "    {\n"
    "        Coroutine::defer($fn);\n"
    "    }\n"
    "}\n";

void php_swoole_load_library()
{
    _eval(swoole_library_source_constants, "@swoole/library/constants.php");
    _eval(swoole_library_source_std_exec, "@swoole/library/std/exec.php");
    _eval(swoole_library_source_core_constant, "@swoole/library/core/Constant.php");
    _eval(swoole_library_source_core_string_object, "@swoole/library/core/StringObject.php");
    _eval(swoole_library_source_core_multibyte_string_object, "@swoole/library/core/MultibyteStringObject.php");
    _eval(swoole_library_source_core_exception_array_key_not_exists, "@swoole/library/core/Exception/ArrayKeyNotExists.php");
    _eval(swoole_library_source_core_array_object, "@swoole/library/core/ArrayObject.php");
    _eval(swoole_library_source_core_object_proxy, "@swoole/library/core/ObjectProxy.php");
    _eval(swoole_library_source_core_coroutine_wait_group, "@swoole/library/core/Coroutine/WaitGroup.php");
    _eval(swoole_library_source_core_coroutine_server, "@swoole/library/core/Coroutine/Server.php");
    _eval(swoole_library_source_core_coroutine_server_connection, "@swoole/library/core/Coroutine/Server/Connection.php");
    _eval(swoole_library_source_core_coroutine_barrier, "@swoole/library/core/Coroutine/Barrier.php");
    _eval(swoole_library_source_core_coroutine_http_client_proxy, "@swoole/library/core/Coroutine/Http/ClientProxy.php");
    _eval(swoole_library_source_core_coroutine_http_functions, "@swoole/library/core/Coroutine/Http/functions.php");
    _eval(swoole_library_source_core_connection_pool, "@swoole/library/core/ConnectionPool.php");
    _eval(swoole_library_source_core_database_object_proxy, "@swoole/library/core/Database/ObjectProxy.php");
    _eval(swoole_library_source_core_database_mysqli_config, "@swoole/library/core/Database/MysqliConfig.php");
    _eval(swoole_library_source_core_database_mysqli_exception, "@swoole/library/core/Database/MysqliException.php");
    _eval(swoole_library_source_core_database_mysqli_pool, "@swoole/library/core/Database/MysqliPool.php");
    _eval(swoole_library_source_core_database_mysqli_proxy, "@swoole/library/core/Database/MysqliProxy.php");
    _eval(swoole_library_source_core_database_mysqli_statement_proxy, "@swoole/library/core/Database/MysqliStatementProxy.php");
    _eval(swoole_library_source_core_database_detects_lost_connections, "@swoole/library/core/Database/DetectsLostConnections.php");
    _eval(swoole_library_source_core_database_pdo_config, "@swoole/library/core/Database/PDOConfig.php");
    _eval(swoole_library_source_core_database_pdo_pool, "@swoole/library/core/Database/PDOPool.php");
    _eval(swoole_library_source_core_database_pdo_proxy, "@swoole/library/core/Database/PDOProxy.php");
    _eval(swoole_library_source_core_database_pdo_statement_proxy, "@swoole/library/core/Database/PDOStatementProxy.php");
    _eval(swoole_library_source_core_database_redis_config, "@swoole/library/core/Database/RedisConfig.php");
    _eval(swoole_library_source_core_database_redis_pool, "@swoole/library/core/Database/RedisPool.php");
    _eval(swoole_library_source_core_http_status, "@swoole/library/core/Http/Status.php");
    _eval(swoole_library_source_core_curl_exception, "@swoole/library/core/Curl/Exception.php");
    _eval(swoole_library_source_core_curl_handler, "@swoole/library/core/Curl/Handler.php");
    _eval(swoole_library_source_core_fast_cgi, "@swoole/library/core/FastCGI.php");
    _eval(swoole_library_source_core_fast_cgi_record, "@swoole/library/core/FastCGI/Record.php");
    _eval(swoole_library_source_core_fast_cgi_record_params, "@swoole/library/core/FastCGI/Record/Params.php");
    _eval(swoole_library_source_core_fast_cgi_record_abort_request, "@swoole/library/core/FastCGI/Record/AbortRequest.php");
    _eval(swoole_library_source_core_fast_cgi_record_begin_request, "@swoole/library/core/FastCGI/Record/BeginRequest.php");
    _eval(swoole_library_source_core_fast_cgi_record_data, "@swoole/library/core/FastCGI/Record/Data.php");
    _eval(swoole_library_source_core_fast_cgi_record_end_request, "@swoole/library/core/FastCGI/Record/EndRequest.php");
    _eval(swoole_library_source_core_fast_cgi_record_get_values, "@swoole/library/core/FastCGI/Record/GetValues.php");
    _eval(swoole_library_source_core_fast_cgi_record_get_values_result, "@swoole/library/core/FastCGI/Record/GetValuesResult.php");
    _eval(swoole_library_source_core_fast_cgi_record_stdin, "@swoole/library/core/FastCGI/Record/Stdin.php");
    _eval(swoole_library_source_core_fast_cgi_record_stdout, "@swoole/library/core/FastCGI/Record/Stdout.php");
    _eval(swoole_library_source_core_fast_cgi_record_stderr, "@swoole/library/core/FastCGI/Record/Stderr.php");
    _eval(swoole_library_source_core_fast_cgi_record_unknown_type, "@swoole/library/core/FastCGI/Record/UnknownType.php");
    _eval(swoole_library_source_core_fast_cgi_frame_parser, "@swoole/library/core/FastCGI/FrameParser.php");
    _eval(swoole_library_source_core_fast_cgi_message, "@swoole/library/core/FastCGI/Message.php");
    _eval(swoole_library_source_core_fast_cgi_request, "@swoole/library/core/FastCGI/Request.php");
    _eval(swoole_library_source_core_fast_cgi_response, "@swoole/library/core/FastCGI/Response.php");
    _eval(swoole_library_source_core_fast_cgi_http_request, "@swoole/library/core/FastCGI/HttpRequest.php");
    _eval(swoole_library_source_core_fast_cgi_http_response, "@swoole/library/core/FastCGI/HttpResponse.php");
    _eval(swoole_library_source_core_coroutine_fast_cgi_client, "@swoole/library/core/Coroutine/FastCGI/Client.php");
    _eval(swoole_library_source_core_coroutine_fast_cgi_client_exception, "@swoole/library/core/Coroutine/FastCGI/Client/Exception.php");
    _eval(swoole_library_source_core_coroutine_fast_cgi_proxy, "@swoole/library/core/Coroutine/FastCGI/Proxy.php");
    _eval(swoole_library_source_core_process_manager, "@swoole/library/core/Process/Manager.php");
    _eval(swoole_library_source_core_server_admin, "@swoole/library/core/Server/Admin.php");
    _eval(swoole_library_source_core_server_helper, "@swoole/library/core/Server/Helper.php");
    _eval(swoole_library_source_core_name_resolver, "@swoole/library/core/NameResolver.php");
    _eval(swoole_library_source_core_name_resolver_exception, "@swoole/library/core/NameResolver/Exception.php");
    _eval(swoole_library_source_core_name_resolver_cluster, "@swoole/library/core/NameResolver/Cluster.php");
    _eval(swoole_library_source_core_name_resolver_redis, "@swoole/library/core/NameResolver/Redis.php");
    _eval(swoole_library_source_core_name_resolver_nacos, "@swoole/library/core/NameResolver/Nacos.php");
    _eval(swoole_library_source_core_name_resolver_consul, "@swoole/library/core/NameResolver/Consul.php");
    _eval(swoole_library_source_core_thread_pool, "@swoole/library/core/Thread/Pool.php");
    _eval(swoole_library_source_core_thread_runnable, "@swoole/library/core/Thread/Runnable.php");
    _eval(swoole_library_source_core_coroutine_functions, "@swoole/library/core/Coroutine/functions.php");
    _eval(swoole_library_source_ext_curl, "@swoole/library/ext/curl.php");
    _eval(swoole_library_source_ext_sockets, "@swoole/library/ext/sockets.php");
    _eval(swoole_library_source_functions, "@swoole/library/functions.php");
    _eval(swoole_library_source_alias, "@swoole/library/alias.php");
    _eval(swoole_library_source_alias_ns, "@swoole/library/alias_ns.php");
}
