#ifdef WINNT
#include <stdio.h>
#include <windows.h>
#include "../conf/portability.h"
#include "../compat/lib/log.h"

void usage();

void
main(argc, argv)
	int argc;
	char *argv[];
{

#ifdef WINNT
char szMsgPath[255];
#endif

	DWORD ControlCode;
	HANDLE hSCManager = NULL, hDomainNameService = NULL;
	SERVICE_STATUS ServiceStatus;
	char *MachineName; // john@optimedia.co.il 

   // john@optimedia.co.il moved param checking before OpenSCManager,
   //                      added support for \\server param
	if (argc < 2 || argc > 3) {
		usage();
		exit(1);
	}

   if (argc == 2)
      MachineName = NULL;
   else
      MachineName = argv [2];

	if((hSCManager = OpenSCManager(
			MachineName, // john@optimedia.co.il Open SCManager on other machine
     		NULL,
     		SC_MANAGER_ALL_ACCESS)) == NULL) {
 		fprintf(stderr, "Unable to open Service Control Manager database on local machine: %u\n", GetLastError());
		exit(1);
	}

  	if((hDomainNameService = OpenService(
       		hSCManager,                              
       		TEXT("DomainNameService"),               
       		SERVICE_ALL_ACCESS)) == NULL) {
		fprintf(stderr, "Unable to open a handle to Domain Name Service: %u\n", GetLastError());
		exit(1);
	}

	if (!stricmp(argv[1], "start")) {
		if(!StartService(hDomainNameService, 0, NULL)) {
			if(GetLastError() == ERROR_SERVICE_ALREADY_RUNNING)
				fprintf(stderr, "Domain Name Service already running\n");
			else
				fprintf(stderr, "Unable to start the Domain Name Service: %u\n", GetLastError());
			exit(1);
		}
		fprintf(stdout, "Name Server Started\n");
		exit(0);
/* lgk add startup code here */
#ifdef WINNT
         /* Set the Event-ID message-file name. */
          GetCurrentDirectory(sizeof(szMsgPath), szMsgPath);
          strcat(szMsgPath, "\\named.exe");
          addSourceToRegistry("DNS", szMsgPath);
#endif
		
	} else if (!stricmp(argv[1], "stop")) {
		ControlCode = SERVICE_CONTROL_STOP;
		fprintf(stdout, "Name Server Stopped\n");
	} else if (!stricmp(argv[1], "restart")) {
		ControlCode = SERVICE_CONTROL_STOP;
	} else if (!stricmp(argv[1], "status")) {
		ControlCode = SERVICE_CONTROL_INTERROGATE;
	} else if (!stricmp(argv[1], "dumpdb")) {
		ControlCode = SERVICE_CONTROL_DUMPDB;
		fprintf(stdout, "Dumping Database\n");
	} else if (!stricmp(argv[1], "reload")) {
		ControlCode = SERVICE_CONTROL_RELOAD;
		fprintf(stdout, "Reloading Database\n");
	} else if (!stricmp(argv[1], "stats")) {
		ControlCode = SERVICE_CONTROL_STATS;
		fprintf(stdout, "Dumping Statistics\n");
	} else if (!stricmp(argv[1], "trace")) {
		ControlCode = SERVICE_CONTROL_TRACE;
		fprintf(stdout, "Trace Level Incremented\n");
	} else if (!stricmp(argv[1], "notrace")) {
		ControlCode = SERVICE_CONTROL_NOTRACE;
		fprintf(stdout, "Tracing Cleared\n");
	} else if (!stricmp(argv[1], "querylog")
			  || !stricmp(argv[1], "qrylog")) {
		ControlCode = SERVICE_CONTROL_QRYLOG;
		fprintf(stdout, "QueryLogging Toggled\n");
	} else {
		usage();
		exit(1);
	}

	if (!ControlService(hDomainNameService, ControlCode, &ServiceStatus)) {
		fprintf(stderr, "Unable to send requested code to the Domain Name Service: %u\n", GetLastError());
		exit(1);
	}
	
	if (!stricmp(argv[1], "status")) {
  		printf("\nStatus of Domain Name Service:\n");
  		printf("  Service Type: 0x%x\n", ServiceStatus.dwServiceType);
  		printf("  Current State: 0x%x\n", ServiceStatus.dwCurrentState);
  		printf("  Controls Accepted: 0x%x\n", ServiceStatus.dwControlsAccepted);
  		printf("  Exit Code: %d\n", ServiceStatus.dwWin32ExitCode);
  		printf("  Service Specific Exit Code: %d\n",
               ServiceStatus.dwServiceSpecificExitCode);
  		printf("  Check Point: %d\n", ServiceStatus.dwCheckPoint);
  		printf("  Wait Hint: %d\n", ServiceStatus.dwWaitHint);
	} else if (!stricmp(argv[1], "restart")) {
		Sleep(5*1000);
		if(!StartService(hDomainNameService, 0, NULL)) {
				fprintf(stderr, "Unable to restart the Domain Name Service: %u\n", GetLastError());
			exit(1);
		}
		fprintf(stdout, "Name Server Restarted\n");
	}
	exit(0);

}

void
usage()
{
   // john@optimedia.co.il added [\\server]
	fprintf(stderr, "usage: ndc (status|dumpdb|reload|stats|trace|notrace\
					|querylog|start|stop|restart) [\\\\server]\n");
	exit(1);
}

#endif

