//  $Id: rpsl_item.cc 1.10 Thu, 18 Feb 1999 10:59:11 -0800 cengiz $
//
//  Copyright (c) 1994 by the University of Southern California
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and its
//  documentation in source and binary forms for lawful non-commercial
//  purposes and without fee is hereby granted, provided that the above
//  copyright notice appear in all copies and that both the copyright
//  notice and this permission notice appear in supporting documentation,
//  and that any documentation, advertising materials, and other materials
//  related to such distribution and use acknowledge that the software was
//  developed by the University of Southern California, Information
//  Sciences Institute. The name of the USC may not be used to endorse or
//  promote products derived from this software without specific prior
//  written permission.
//
//  THE UNIVERSITY OF SOUTHERN CALIFORNIA DOES NOT MAKE ANY
//  REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY
//  PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
//  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE,
//  TITLE, AND NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT, TORT,
//  OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE
//  OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  ratoolset@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@ISI.EDU>

#include "config.h"
#include <iostream.h>
#include <iomanip.h>
#include "rpsl_item.hh"
#include "rpsl_filter.hh"

//// printing ////////////////////////////////////////////////////////

ostream &Item::print(ostream &out) const {
   return out;
}
ostream &ItemASNO::print(ostream &out) const {
   out << "AS" << asno;
   return out;
}

ostream &ItemMSItem::print(ostream &out) const {
   out << *item;
   switch (code) {
   case 0:
      out << "^-";
      break;
   case 1:
      out << "^+";
      break;
   case 2:
      if (n == m)
	 out << "^" << n;
      else
	 out << "^" << n << "-" << m;
   }
   return out;
}


ostream &ItemFilter::print(ostream &out) const {
   out << filter;
   return out;
}

ostream &ItemINT::print(ostream &out) const {
   out << i;
   return out;
}

ostream &ItemTimeStamp::print(ostream &out) const {
   tm *ts;
   ts = localtime(&stamp);
   out.form("%04d%02d%02d %02d%02d%02d +0000", 
	    ts->tm_year + 1900, ts->tm_mon+1, ts->tm_mday, 
	    ts->tm_hour, ts->tm_min, ts->tm_sec);
   return out;
}

ostream &ItemREAL::print(ostream &out) const {
   out << real;
   return out;
}

ostream &ItemSTRING::print(ostream &out) const {
   out << string;
   return out;
}

ostream &ItemBLOB::print(ostream &out) const {
   out << blob;
   return out;
}

ostream &ItemIPV4::print(ostream &out) const {
   out << *ipv4;
   return out;
}

ostream &ItemPRFXV4::print(ostream &out) const {
   out << *prfxv4;
   return out;
}

ostream &ItemPRFXV4Range::print(ostream &out) const {
   out << *prfxv4;
   return out;
}

ostream &ItemConnection::print(ostream &out) const {
   if (ip)
      out << *ip;
   else
      out << host;
   if (port)
      out << ":" << port;
   if (ttl)
      out << ":" << ttl;
   return out;
}

ostream &ItemSID::print(ostream &out) const {
   out << name;
   return out;
}

ostream &ItemBOOLEAN::print(ostream &out) const {
   out << (i ? "true" : "false");
   return out;
}

ostream &ItemWORD::print(ostream &out) const {
   out << word;
   return out;
}

ostream &ItemEMAIL::print(ostream &out) const {
   out << email;
   return out;
}

ostream &ItemRange::print(ostream &out) const {
   out << *begin << " - " << *end;
   return out;
}

ostream &ItemFREETEXT::print(ostream &out) const {
   for (int i = 0; i < length; ++i)
      out << *(text + i);
   return out;
}

ostream &ItemList::print(ostream &out, char *delim) const {
   Item *item = head();
   if (item) {
      item->print(out);
      for (item = next(item); item; item = next(item)) {
	 out << delim;
	 item->print(out);
      }
   }

   return out;
}

ostream &ItemSequence::print(ostream &out) const {
   Item *item = head();
   if (item) {
      item->print(out);
      for (item = next(item); item; item = next(item)) {
	 out << " ";
	 item->print(out);
      }
   }

   return out;
}

ItemFilter::~ItemFilter() {
   if (filter)
      delete filter;
}
