//  $Id: aggchk.cc 1.8 Mon, 05 Apr 1999 14:36:40 -0700 mehringe $
//
//  Copyright (c) 1994 by the University of Southern California
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and its
//  documentation in source and binary forms for lawful non-commercial
//  purposes and without fee is hereby granted, provided that the above
//  copyright notice appear in all copies and that both the copyright
//  notice and this permission notice appear in supporting documentation,
//  and that any documentation, advertising materials, and other materials
//  related to such distribution and use acknowledge that the software was
//  developed by the University of Southern California, Information
//  Sciences Institute. The name of the USC may not be used to endorse or
//  promote products derived from this software without specific prior
//  written permission.
//
//  THE UNIVERSITY OF SOUTHERN CALIFORNIA DOES NOT MAKE ANY
//  REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY
//  PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
//  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE,
//  TITLE, AND NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT, TORT,
//  OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE
//  OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  ratoolset@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@ISI.EDU>
//             John Mehringer <mehringe@isi.edu> updated for RAToolSet 4.x

#include <stdio.h>
#include <stdlib.h>
#include "config.h"
#include <cstdlib>
#include <iostream.h>
#include <iomanip.h>

#include "irr/irr.hh"
#include "irr/autnum.hh"
//#include "Error.hh"
//#include "aut-num.hh"
//#include "Route.hh"
#include "radix.hh"

extern radix_node *test_root; // defined in cidr.cc used for the expts

//*Pix aggregator_as = NULL;
ASt aggregator_as = INVALID_AS;

//* Route r; // aspath used to check for looping is an attribute of r
addr* aggs_final = NULL;

// do not use rt.define() 'cos it checks for the exact match in the database
// and if nothing found sets origin to NULL.


void            unlink(addr **,addr **);
addr*           copy_list(addr *);
//addr* component_match(addr **,Filter_Action **);
void import_match(ASt peeras, ASt as, addr **aggregates, int radius);
void            append_aggregates(addr**,addr**);
addr*           refine_aggs(addr *);
void export_match(ASt as,addr **aggregates,int radius);
void examine_policy(ASt source_as, int proxies, addr *aggregates, int radius);
void print_aggregates(addr *,int);
void            append(addr **,addr *);
void delete_list(addr **);
//extern addr*    allowed_proxy_aggregates(Pix,Pix,addr *);
addr* chk_policy(ASt as1, ASt as2, addr *aggs);





void unlink(addr **list,addr **element) {
  addr *tmp;

  if(*list == *element) {
	  *list = (*list)->next;
    delete_list(&((*element)->components));
    delete *element;
    return;
  }
    
  tmp = *list;
  while(tmp->next != *element) 
  tmp = tmp->next;
    
  tmp->next = (*element)->next;
  delete_list(&((*element)->components));
  delete *element;
}
	



//--------------------------------------------------------------
// void 
// append(addr ** list, addr * element) {
//  
//  Makes a Copy of element and Appends it to the to the addr list
//--------------------------------------------------------------
void append(addr ** list, addr * element) {
  addr *new_elmt,*tmp;
  addr *new_elmt_comps,*comps,*tmp_comps;

  //- Copy element to new_elmt
  new_elmt = new addr(*element);
  //* replaced by above
  /*new_elmt = new addr;
  *new_elmt = *element;
  new_elmt->next = NULL;
  new_elmt->rt.nlri.pix = element->rt.nlri.pix;

  for(ListNodePix *p = (element->rt).origin.head();
                   p;
                   p =  (element->rt).origin.next(p->l)) {
    ListNodePix *origin_list = new ListNodePix(p->pix);
    (new_elmt->rt).origin.append(origin_list->l);
  }*/
  
  
  
  //- Copy over Components to new element 
  comps = element->components;
  if(!comps)
    new_elmt->components = NULL;
  else {
    //*new_elmt->components = new addr;
    new_elmt->components = new addr(*comps);
    tmp_comps = new_elmt->components;
  }

  for(; comps ; comps = comps->next , tmp_comps = tmp_comps->next) {
    //*tmp_comps->prefix = comps->prefix;
    //*tmp_comps->length = comps->length;
    //*tmp_comps->rt.nlri.pix = comps->rt.nlri.pix;
	
    //* Copy over origin information
   /* for(ListNodePix *p = (comps->rt).origin.head() ; p ;
        p = (comps->rt).origin.next(p->l)) {
      ListNodePix *list =  new ListNodePix(p->pix);
      (tmp_comps->rt).origin.append(list->l);
    }*/
	
    tmp_comps->components =  NULL;
    if(comps->next) {
      //*tmp_comps->next = new addr;
      tmp_comps->next = new addr(*comps);
    } else
      tmp_comps->next = NULL;
  }


  //- Add new_element to list
  
  
  if(!*list) {   //- If no list create one
    *list = new_elmt; 
  } else {       //- Add to end of list
    tmp = *list;
    while(tmp->next != NULL)
      tmp = tmp->next;
    tmp->next = new_elmt;
  }
//    cerr << "aggcheck::append is empty" << endl;
}
    
	



void delete_list(addr **list) {
  addr *tmp;

  if(!(*list)) return;
  while(*list) {
    tmp = *list;
    *list = (*list)->next;
    delete_list(&(tmp->components));
    delete tmp;
  }
}





addr* copy_list(addr *aggregates) {
/*    addr *tmp,*root_new_list,*orig_comp,*copy_comp;
    

    if(aggregates) {
	tmp = new addr;
	root_new_list = tmp;
    }
    else
	return(NULL);
    
    for(; aggregates ; aggregates = aggregates->next) {
	tmp->prefix       =  aggregates->prefix;
	tmp->length       =  aggregates->length;
	tmp->rt.nlri.pix  =  aggregates->rt.nlri.pix;

	for(ListNodePix *p = (aggregates->rt).origin.head() ; p ; p = (aggregates->rt).origin.next(p->l)) {
	    ListNodePix *list =  new ListNodePix(p->pix);
	    (tmp->rt).origin.append(list->l);
	}

	orig_comp = aggregates->components;
	if(orig_comp) {
	    tmp->components = new addr;
	    copy_comp = tmp->components;
	}
	else
	    tmp->components = NULL;

	for(; orig_comp ; orig_comp = orig_comp->next , copy_comp = copy_comp->next) {
	    copy_comp->prefix          =  orig_comp->prefix;
	    copy_comp->length          =  orig_comp->length;
	    copy_comp->rt.nlri.pix     =  orig_comp->rt.nlri.pix;

	    for(ListNodePix *p = (orig_comp->rt).origin.head() ; p ; p = (orig_comp->rt).origin.next(p->l)) {
		ListNodePix *list =  new ListNodePix(p->pix);
		(copy_comp->rt).origin.append(list->l);
	    }

	    copy_comp->components      =  NULL;
	    if(orig_comp->next) 
		copy_comp->next = new addr;
	    else
		copy_comp->next = NULL;
	}
	
	if(aggregates->next) 
	    tmp->next = new addr;
	else
	    tmp->next = NULL;
	tmp = tmp->next;
    }
    return(root_new_list);
    */
    cerr << "aggcheck.cc copy_list is Empty" << endl;
}
	
    
    


/*addr* component_match(addr **components,Filter_Action **fap) {
    addr *tmp,*old_tmp,*component_list = NULL;
    radix_node *root = NULL;


    tmp = *components;
    
    while(tmp) {
	old_tmp = tmp;
	tmp = tmp->next;
	if((*fap)->filter->match(old_tmp->rt)) {
	    append(&component_list,old_tmp);
	    unlink(components,&old_tmp);
	}
    }
    
    if(component_list)
	root = radix_create_node(NULL,0,0,NULL,EMPTY);
    else
	return(NULL);

    for(; component_list ; component_list = component_list->next) {
	ListNodePix *p = (component_list->rt).origin.head();
	radix_insert(component_list->prefix,component_list->length,p->pix,root);
    }
	
    radix_aggregate(root);
    component_list = NULL;
    component_list = radix_get_aggs(root);
    tmp = radix_get_nonaggs(root);
    for(; tmp; tmp = tmp->next)
	append(&component_list,tmp);
    radix_delete_tree(root);
    return(component_list);
}
*/




void examine_policy(ASt source_as,int proxies,addr *aggregates,int radius) {
/*  ASPolicy *p;
   Filter_Action *fap;
   addr *tmp, *old_tmp, *agg_list = NULL, *tmp_aggs = NULL;
   addr *components = NULL,*comps_head = NULL, *aggs = NULL;
   Pix originator_as = NULL;

   aggregator_as = source_as;
 
   AutNum *as = AS_map.define(aggregator_as);
   r.aspath.append((new ListNodePix(aggregator_as))->l);

   for(p = as->peers.head();p;p = as->peers.next(p->peers)) {

       if(proxies)
	   tmp_aggs = allowed_proxy_aggregates(aggregator_as,p->peeras,aggregates);
       else
	   tmp_aggs = copy_list(aggregates);

       cout << AS_map.key(aggregator_as) << "->"<< AS_map.key(p->peeras)<<"\n";

       if(radius == -1.5) {
	 print_aggregates(tmp_aggs,NO_COMPONENTS);
	 cout << "done" << endl;
	 continue;
       }

       tmp = tmp_aggs;

       r.aspath.append((new ListNodePix(p->peeras))->l);

       for (fap = p->out.head(); fap; fap = p->out.next(fap->falist)) {
	   while(tmp) {
	     if(((tmp->rt).origin.size() == 1) && fap->filter->match(tmp->rt)) {
	       append(&agg_list,tmp);
	       old_tmp = tmp;
	       tmp = tmp->next;
	       unlink(&tmp_aggs,&old_tmp);
	     }
	     else {
	       if(tmp->components) {
		 components = component_match(&(tmp->components),&fap);
		 comps_head = components;
		 for(; components ; components = components->next)
		   append(&agg_list,components);
		 delete_list(&comps_head);
	       }
	       tmp = tmp->next;
	     }
	   }
	   tmp = tmp_aggs;
       }
       delete_list(&tmp_aggs);
       tmp_aggs = NULL;

       if(radius == -1) 
	   print_aggregates(agg_list,NO_COMPONENTS);
       else {
           import_match(aggregator_as,p->peeras,&agg_list,radius);
	   aggs = refine_aggs(agg_list);
	   print_aggregates(aggs,NO_COMPONENTS);
	   delete_list(&aggs);
	   aggs = NULL;
       }
       delete_list(&agg_list);       

       ListNodePix *lnp = r.aspath.tail();
       r.aspath.unlink(lnp->l);
       delete lnp;
   }
   delete as;
   */
}
       


void import_match(ASt peeras, ASt as, addr **aggregates, int radius) {
/*    ASPolicy *p;
    Filter_Action *fap;
    addr *tmp,*old_tmp,*import_aggs = NULL,*components = NULL;
    addr *comps_head = NULL, *tmp_aggs = NULL;

    if(!*aggregates)
	return;

    if(!AS_map.define(as)) 
	return;

    AutNum *autnum = (AutNum *) AS_map.contents(as).definition;
   
    for(p = autnum->peers.head(); p; p = autnum->peers.next(p->peers))
	if(p->peeras == peeras)
	    break;

    if(!p) // peer does not exist
	return;

    tmp_aggs = copy_list(*aggregates);
    tmp = tmp_aggs;
    for(fap = p->in.head(); fap; fap=p->in.next(fap->falist)) {
	while(tmp) {

	     (tmp->rt).aspath.clear();
	     for(ListNodePix *q = r.aspath.head() ; q && q->pix != as; q = r.aspath.next(q->l)) {
	       ListNodePix *list =  new ListNodePix(q->pix);
	       (tmp->rt).aspath.append(list->l);
	     }

	    if(((tmp->rt).origin.size() == 1) && fap->filter->match(tmp->rt)) {
		append(&import_aggs,tmp);
		old_tmp = tmp;
		tmp = tmp->next;
		unlink(&tmp_aggs,&old_tmp);
	    }
	    else {
		if(tmp->components) {
		    components = component_match(&(tmp->components),&fap);
		    comps_head = components;
		    for(; components; components = components->next) 
			append(&import_aggs,components);
		    if(comps_head)
		      if(comps_head->next)
			cout << "import policy" << AS_map.key(as) << endl; 
		    delete_list(&comps_head);
		}
		tmp = tmp->next;
	    }
	}
	tmp = tmp_aggs;
    }

    delete_list(&tmp_aggs);
    tmp_aggs = NULL;
    
    ListNodePix *q = r.aspath.head();
    if(q->pix != peeras) {
      append_aggregates(aggregates,&import_aggs);
      delete_list(&import_aggs);
      //      tmp_aggs = refine_aggs(*aggregates);
      //      delete_list(aggregates);
      //      aggregates = &tmp_aggs;
    }
    else {

      // this is the case when peeras = aggregator AS in which case we have to
      // do level 2 computation
      delete_list(aggregates);
      *aggregates = import_aggs;
    }

    if(radius != -0.5) 
	export_match(as,aggregates,radius);
   */
   cerr << "aggchk.cc import_match is empty!" << endl;
}
		    

	       


void append_aggregates(addr **list,addr **append_list) {
/*    addr *old_elmt,*elmt,*tmp;
    int flag = FALSE;
	
    if(!(*append_list)) return;
    elmt = *append_list;

    while(elmt) {
	tmp = *list;
	flag = FALSE;
	for(; tmp; tmp = tmp->next) 
	    if(elmt->rt.nlri.pix == tmp->rt.nlri.pix) {
		flag = TRUE;
		elmt = elmt->next;
		break;
	    }
	    
	if(!flag) {
	    old_elmt = elmt;
	    elmt = elmt->next;
	    append(list,old_elmt);
	}
    }*/
   cerr << "aggchk.cc append_aggregates is empty!" << endl;
}





addr* refine_aggs(addr *aggs) {
/*    addr *tmp1, *tmp_list = NULL;
    addr *aggregates_list = NULL, *component_list = NULL;
    addr *components = NULL,*final_list = NULL;
    radix_node *root1 = NULL, *root2 = NULL;
    int recurse = FALSE; // need to recurse if there are more specifics which
                         // contain even more specifics
       
    if(aggs) {
	root1 = radix_create_node(NULL,0,0,NULL,EMPTY);
	root2 = radix_create_node(NULL,0,0,NULL,EMPTY);
    }
    else
	return(NULL);

    for(tmp1 = aggs; tmp1; tmp1 = tmp1->next)  {
	radix_insert(tmp1->prefix,tmp1->length,NULL,root1);
        if(!(tmp1->components)) {
	  ListNodePix *p = (tmp1->rt).origin.head();
	  radix_insert(tmp1->prefix,tmp1->length,p->pix,root2);
	}
	else
	  for(components = tmp1->components; components; components = components->next) {
	    ListNodePix *p = (tmp1->rt).origin.head();
	    radix_insert(components->prefix,components->length,p->pix,root2);
	  }
    }


    for(tmp1 = aggs; tmp1; tmp1 = tmp1->next) 
	if(radix_search(tmp1->prefix, tmp1->length, root1) == MORE_SPECIFIC) {
	    append(&tmp_list,tmp1);
	    if(!(tmp1->components)) 
		radix_delete(tmp1->prefix,tmp1->length,root2);
	    else {
		recurse = TRUE;
		for(components = tmp1->components; components; components = components->next) 
		    radix_delete(components->prefix,components->length,root2);
	    }
	}

    if(recurse) {
	final_list = refine_aggs(tmp_list);
	delete_list(&tmp_list);
    }
    else
	final_list = tmp_list;

    radix_aggregate(root2);
    aggregates_list = radix_get_aggs(root2);
    for(; aggregates_list; aggregates_list = aggregates_list->next)
	append(&final_list,aggregates_list);
    component_list = radix_get_nonaggs(root2);
    for(; component_list; component_list = component_list->next)
	append(&final_list,component_list);  
    radix_delete_tree(root1);
    radix_delete_tree(root2);
    return(final_list);
  */
}





inline int aspath_loop_check(Route &r, Pix as) {
/*   for (ListNodePix *p = r.aspath.head(); p; p = r.aspath.next(p->l))
      if (p->pix == as)
         return TRUE;

   return FALSE;
*/ 
cerr << "aggchk.cc aspath_loop_check is empty!" << endl;
}





void export_match(ASt as,addr **aggregates,int radius) {
 /*   ASPolicy *p;
    Filter_Action *fap;
    AutNum *autnum = AS_map.define(as);
    addr *tmp,*old_tmp,*agg_list = NULL,*tmp_aggs = NULL;
    addr *final_aggs,*components = NULL,*comps_head = NULL,*aggs = NULL;

    if(!*aggregates) 
	return;

    for(p = autnum->peers.head(); p; p = autnum->peers.next(p->peers)) {

      if(aspath_loop_check(r,p->peeras)) {
	tmp_aggs = NULL;
	ListNodePix *q1 = r.aspath.head(); // aggregator AS
	ListNodePix *q2 = r.aspath.next(q1->l); // neighbour of agg for which
	// level > 0 is being computed

	// Checking the aggregator's export policy to the current as
	if(p->peeras == q1->pix && as != q2->pix)
	  tmp_aggs = chk_policy(p->peeras,as,*aggregates);

	// Checking the policies towards the aggregator's neighbour that is
	// being considered . Since the neigbour is always marked some of its 
	// policies will not be checked otherwise.
	else {
	  if(p->peeras == q2->pix)
	    tmp_aggs = chk_policy(as,p->peeras,*aggregates);
	}
	if(tmp_aggs) {
	  append_aggregates(aggregates,&tmp_aggs);
	  delete_list(&tmp_aggs);
	  //	  tmp_aggs = refine_aggs(*aggregates);
	  //	  delete_list(aggregates);
	  //	  aggregates = &tmp_aggs;
	}
	continue;
      }

      r.aspath.append((new ListNodePix(p->peeras))->l);      

      //	cout << "export_match: "<< AS_map.key(as) << "->"<< AS_map.key(p->peeras)<<"\n";
	    
      tmp_aggs = copy_list(*aggregates);
      tmp = tmp_aggs;
	
      for (fap = p->out.head(); fap; fap = p->out.next(fap->falist)) {
	while(tmp) {

	     (tmp->rt).aspath.clear();
	     for(ListNodePix *q = r.aspath.head() ; q && q->pix != as; q = r.aspath.next(q->l)) {
	       ListNodePix *list =  new ListNodePix(q->pix);
	       (tmp->rt).aspath.append(list->l);
	     }

	  if (((tmp->rt).origin.size() == 1) && fap->filter->match(tmp->rt)) {

	    // first check if the aggregate matches the filter
	    append(&agg_list,tmp);
	    old_tmp = tmp;
	    tmp = tmp->next;
	    unlink(&tmp_aggs,&old_tmp);
	  }
	  else {

	    // if the aggregate does not match the filter then check the
	    // components
	    if(tmp->components) {
	      components = component_match(&(tmp->components),&fap);
	      comps_head = components;
	      for(; components ; components = components->next)
		append(&agg_list,components);
	      if(comps_head)
		if(comps_head->next)
		  cout << "Export policy " << AS_map.key(as) << endl;
	      delete_list(&comps_head);
	    }
	    tmp = tmp->next;
	  }
	}
	tmp = tmp_aggs;
      }
      
      delete_list(&tmp_aggs);
      tmp_aggs = NULL;

      // If nothing can be exported to this peer then consider the next peer
      if(!agg_list) {
	ListNodePix *lnp = r.aspath.tail();
	r.aspath.unlink(lnp->l);
	delete lnp;
	continue;
      }

      // Appending the possibly new aggregates we got to the old aggregates
      append_aggregates(aggregates,&agg_list);
      delete_list(&agg_list);       

      // refining the list of aggregates
      //      tmp_aggs = refine_aggs(*aggregates);
      //      delete_list(aggregates);
      //      aggregates = &tmp_aggs;

      int aspath_length = r.aspath.size();

      // subtract 2 from aspath length because agg and neighbour already 
      // included. This is because radius is distance from neighbour
      if(radius > (aspath_length - 2) || radius == -3)
	import_match(as,p->peeras,aggregates,radius);
      
      ListNodePix *lnp = r.aspath.tail();
      r.aspath.unlink(lnp->l);
      delete lnp;
    }
    */
}

    



void print_aggregates(addr *aggregates,int print_components) {
  addr *tmp1,*tmp2;
  char prefix_quad[16];
  int num_aggregates = 0;
  int num_components = 0;

  tmp1 = aggregates;
  while(tmp1) {
    int2dd(prefix_quad,tmp1->prefix);
    printf("%s/%d ",prefix_quad,tmp1->length);
      
    if(print_components) {
      printf("\nComponents:\n");
      tmp2 = tmp1->components;
	
      while(tmp2) {
        ++num_components;
        int2dd(prefix_quad,tmp2->prefix);
        printf("%s/%d ( ",prefix_quad,tmp2->length);
        /*
        for(ListNodePix *p = (tmp2->rt).origin.head() ; p ; p = (tmp2->rt).origin.next(p->l)) {
          cout << AS_map.key(p->pix) << " ";
        }*/
        
        cout << "Print out Origins here!";
	  
        cout << ")\n";
        tmp2 = tmp2->next;
      }
      cout << endl;
    }
    tmp1 = tmp1->next;
  }
  cout << endl;
}

       



// Export policy of as1 and import policy of as2 are examined
addr* chk_policy(ASt as1, ASt as2, addr *aggs) {
/*  ASPolicy *p;
  Filter_Action *fap;
  AutNum &autnum1 = *(AutNum *)(AS_map.define(as1));
  AutNum &autnum2 = *(AutNum *)(AS_map.define(as2));
  addr *tmp,*old_tmp,*agg_list = NULL,*tmp_aggs = NULL;
  addr *components = NULL,*comps_head = NULL;

  for(p = autnum1.peers.head(); p; p = autnum1.peers.next(p->peers))
    if(p->peeras == as2)
      break;

  if(!p)
    return(NULL);

  tmp_aggs = copy_list(aggs);
  if(!tmp_aggs) 
    return(NULL);

  tmp = tmp_aggs;
  for (fap = p->out.head(); fap; fap = p->out.next(fap->falist)) {
    while(tmp) {
      if (((tmp->rt).origin.size() == 1) && fap->filter->match(tmp->rt)) {
            append(&agg_list,tmp);
            old_tmp = tmp;
            tmp = tmp->next;
            unlink(&tmp_aggs,&old_tmp);
      }
      else {
	if(tmp->components) {
              components = component_match(&(tmp->components),&fap);
	      comps_head = components;
              for(; components ; components = components->next)
                append(&agg_list,components);
	      delete_list(&comps_head);
	}
	tmp = tmp->next;
      }
    }
    tmp = tmp_aggs;
  }

  delete_list(&tmp_aggs);      
  if(!agg_list)
    return(NULL);
  tmp_aggs = agg_list;
  agg_list = NULL;

  for(p = autnum2.peers.head(); p; p = autnum2.peers.next(p->peers))
    if(p->peeras == as1)
      break;

  if(!p)
    return(NULL);

  tmp = tmp_aggs;
  for (fap = p->in.head(); fap; fap = p->in.next(fap->falist)) {
    while(tmp) {
      if (((tmp->rt).origin.size() == 1) && fap->filter->match(tmp->rt)) {
            append(&agg_list,tmp);
            old_tmp = tmp;
            tmp = tmp->next;
            unlink(&tmp_aggs,&old_tmp);
      }
      else {
        if(tmp->components) {
              components = component_match(&(tmp->components),&fap);
	      comps_head = components;
              for(; components ; components = components->next)
                append(&agg_list,components);
	      delete_list(&comps_head);
        }
        tmp = tmp->next;
      }
    }
    tmp = tmp_aggs;
  }

  delete_list(&tmp_aggs);
  return(agg_list);
  */
}
