%{
//  $Id: xx_parser.y 1.1 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#include "config.hh"

#include <cstring>
#include <cstdlib>
#include <cctype>
#include <cstdarg>
#include "prpath.hh"
#include "dbase.hh"
#include "net.hh"

extern "C" {
#if HAVE_MEMORY_H && 0
#   include <memory.h>
#endif
#ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#endif
}

extern int yyerror(char *);
extern int yylex();
extern Route rt;

%}

%union {
   char *val;
   Pix pi;
}

%token <pi>  TKN_PRFMSK      501
%token <pi>  TKN_ASNUM       503
%token <val> TKN_IP_ADR      504
%token <val> TKN_DNS_NAME    505
%token <val> TKN_ERROR       506

%%
input_stream: {
   if (opt_prompt)
      cout << opt_prompt;
}
| input_stream input
;

input: token
| error '\n' {
   yyerrok;
   if (opt_prompt)
      cout << opt_prompt;
}
| '\n' {
   if (opt_prompt)
      cout << opt_prompt;
}
;

token: TKN_PRFMSK {
   rt.clear();
   rt.nlri.pix = $1;
   rt.define();
   rt.aspath.dontcare();
   rt.print();
   start_prpath(rt);
}
| TKN_IP_ADR {
   char buffer[strlen($1)+4];

   strcpy(buffer, $1);
   strcat(buffer, "/32");

   rt.clear();
   rt.nlri.pix = Prefask_map.add_entry(buffer);
   rt.define_less_or_equal_specific();
   rt.aspath.dontcare();
   rt.print();
   start_prpath(rt);
}
| TKN_DNS_NAME {
   ipAddr ip($1);

   char *ip_ptr = ip.getIpaddr();
   char buffer[strlen(ip_ptr)+4];

   strcpy(buffer, ip_ptr);
   strcat(buffer, "/32");

   rt.clear();
   rt.nlri.pix = Prefask_map.add_entry(buffer);
   rt.define_less_or_equal_specific();
   rt.aspath.dontcare();
   rt.print();
   start_prpath(rt);
}
| TKN_ASNUM {
   rt.clear();

   ListNodePix *p = new ListNodePix;
   p->pix = $1;
   rt.origin.append(p->l);

   rt.nlri.dontcare();
   rt.aspath.dontcare();
   rt.ripecommunity.dontcare();
   rt.print();
   start_prpath(rt);
}
;

%%

extern char *yytext;

int yyerror(char *s) {
   cout << "Error\n";
   return(0);
}

