/*  $Id: xx_lexer.y 1.2 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
 
  Copyright (c) 1994 by the University of Southern California
  and/or the International Business Machines Corporation.
  All rights reserved.

  Permission to use, copy, modify, and distribute this software and
  its documentation in source and binary forms for lawful
  non-commercial purposes and without fee is hereby granted, provided
  that the above copyright notice appear in all copies and that both
  the copyright notice and this permission notice appear in supporting
  documentation, and that any documentation, advertising materials,
  and other materials related to such distribution and use acknowledge
  that the software was developed by the University of Southern
  California, Information Sciences Institute and/or the International
  Business Machines Corporation.  The name of the USC or IBM may not
  be used to endorse or promote products derived from this software
  without specific prior written permission.

  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
  NON-INFRINGEMENT.

  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
  THE USE OR PERFORMANCE OF THIS SOFTWARE.

  Questions concerning this software should be directed to 
  info-ra@isi.edu.

  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu) */


/* definitions */
%{

#include "config.hh"
#include <iostream.h>
#include "pmatch.hh"
#include "xx_parser.h"
#include "dbase.hh"

#define yylval xxlval
#define LEXER_RETURN(x)  return(x)

typedef struct _KeyWord {
   char *val;
   int num;
} KeyWord;

static KeyWord keywords[] = {
NULL,          TKN_ERROR
};

static int get_keyword_num(char *string) {
   int i;

   for (i = 0; keywords[i].val; i++)
      if (!strcmp(keywords[i].val, string))
	 break;

   return(keywords[i].num);
}

extern "C" {
int yywrap () {
   return 1;
}
}

#define yy_input_string xx_input_string
char *yy_input_string = NULL;

#ifndef MIN
#define MIN(x,y) ((x) < (y) ? (x) : (y))
#endif
#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) {                       \
   if (yy_input_string) {                                     \
      result = MIN(strlen(yy_input_string), max_size);        \
      strncpy(buf, yy_input_string, result);                  \
      yy_input_string += result;                              \
      if (result < max_size)                                  \
	 buf[result] = 0;                                     \
   } else {                                                   \
      int c = getchar();                                      \
      result = (c == EOF) ? YY_NULL : (buf[0] = c, 1);        \
   }                                                          \
}

%}

%%

%{
/* Rules */
%}

[A-Za-z_-]+ {
   LEXER_RETURN(get_keyword_num(yytext));
}

AS[0-9]+ {
   yylval.pi = AS_map.add_entry(yytext);
   LEXER_RETURN(TKN_ASNUM);
}

[0-9]+(\.[0-9]+){3,3}\/[0-9]+ {
   yylval.pi = Prefask_map.add_entry(yytext);
   LEXER_RETURN(TKN_PRFMSK);
}

[0-9]+(\.[0-9]+){3,3} {
   yylval.val = yytext;
   LEXER_RETURN(TKN_IP_ADR);
}

[a-zA-Z0-9_-]+\.([a-zA-Z0-9_-]+\.)*[a-zA-Z0-9_-]+ {
   yylval.val = yytext;
   LEXER_RETURN(TKN_DNS_NAME);
}

[ \t]+ { 
   /* Skip white space */
}

\n {
   LEXER_RETURN((int) *yytext);
}

. {
   LEXER_RETURN(TKN_ERROR);
}
%%

/* User Code if any */

