// $Id: NT.cc 1.9.2.2 Wed, 26 Nov 1997 14:55:25 -0800 cengiz $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#include "config.hh"
#include <iostream.h>
#include "NT.hh"
#include "debug.hh"

CLASS_DEBUG_MEMORY_CC(NormalTerm);

ostream& operator<<(ostream& stream, NormalTerm& nt) {
   int i, flag = 0;

   // stream << nt.pref << " ";
   for (i = 0; i < NT_SET_COUNT; i++) {
      if (nt[i].universal())
	 continue;
      
      if (flag)
	 stream << " AND ";

      stream << nt[i];

      flag = 1;
   }

   if (!flag)
      stream << "ANY";

   return stream;
}

void NormalTerm::make_universal(int exception) {

   for (int i = 0; i < NT_SET_COUNT; i++)
      if (exception != i) 
	 (*this)[i].make_universal();

}

void NormalTerm::clear() {
   for (int j = 0; j < NT_SET_COUNT; ++j)
      (*this)[j].clear();
}

void NormalTerm::evaluate(int expand) {
   Pix i, j, macro;

   if (expand & EXPAND_AS_MACROS) {
      for (i = as_macros.conjuncts.first(); i; as_macros.conjuncts.next(i)) {
	 _SetOfPix tmp;	 
	 SetOfSymbol result(&AS_map), tmp2(&AS_map);

	 for (j = as_macros.conjuncts(i)->symbols.first(); 
	      j; 
	      as_macros.conjuncts(i)->symbols.next(j)) {
	    macro = (Pix) as_macros.conjuncts(i)->symbols(j);
	    if (ASMacro_map.contents(macro).evaluated == 2) { // a not symbol
	       tmp.clear();
	       ASMacro2AS(ASMacro_map.contents(macro).not, tmp);
	       tmp2 = tmp;
	       ~tmp2;
	       result |= tmp2;
	    } else { // regular symbol
	       tmp.clear();
	       ASMacro2AS(macro, tmp);
	       tmp2 = tmp;
	       result |= tmp2;
	    }
	 }
	 as_sym &= result;
	 if (as_sym.empty()) {
	    clear();
	    return;
	 }
      }
      as_macros.make_universal();
   }
   if (expand & EXPAND_AS) {
      for (i = as_sym.conjuncts.first(); i; as_sym.conjuncts.next(i)) {
	 SetOfPrefix result;
	 _SetOfPix tmp;
	 for (j = as_sym.conjuncts(i)->symbols.first(); 
	      j; 
	      as_sym.conjuncts(i)->symbols.next(j)) {
	    macro = (Pix) as_sym.conjuncts(i)->symbols(j);
	    if (AS_map.contents(macro).evaluated == 2) { // a not symbol
	       tmp.clear();
	       AS2AdrPrfx(AS_map.contents(macro).not, tmp);
	       result.remove(tmp);
	    } else { // regular symbol
	       tmp.clear();
	       AS2AdrPrfx(macro, tmp);
	       result.insert(tmp);
	    }
	 }
	 prfx_set &= result;
	 if (prfx_set.empty()) {
	    clear();
	    return;
	 }
      }
      as_sym.make_universal();
   }
   if (expand & EXPAND_COMMUNITIES) {
      for (i = prfx_macros.conjuncts.first(); i; prfx_macros.conjuncts.next(i)){
	 SetOfPrefix result;
	 _SetOfPix tmp;
	 for (j = prfx_macros.conjuncts(i)->symbols.first(); 
	      j; 
	      prfx_macros.conjuncts(i)->symbols.next(j)) {
	    macro = (Pix) prfx_macros.conjuncts(i)->symbols(j);
	    if (Community_map.contents(macro).evaluated == 2) { // a not symbol
	       tmp.clear();
	       Comm2AdrPrfx(Community_map.contents(macro).not, tmp);
	       result.remove(tmp);
	    } else { // regular symbol
	       tmp.clear();
	       Comm2AdrPrfx(macro, tmp);
	       result.insert(tmp);
	    }
	 }
	 prfx_set &= result;
	 if (prfx_set.empty()) {
	    clear();
	    return;
	 }
      }
      prfx_macros.make_universal();
   }

}

int NormalTerm::find_diff(NormalTerm &other) {
   int diff = NT_SET_COUNT;

   for (int i = 0; i < NT_SET_COUNT; i++)
      if (!((*this)[i] == other[i]))
	 if (diff == NT_SET_COUNT)
	    diff = i;
	 else 
	    return -1;       // there are differences in more than one index

   // *this and other are different only on the set indexed by diff
   // or identical if diff == NT_SET_COUNT
   return diff;
}


char *AS_format(Pix i) {
   return AS_map.key(i);
}

char *itoa(char *buffer, int i) {
   sprintf(buffer, "%d", i);
   return buffer;
}

char *PRFX_format(Pix i) {
   static char buffer[64];
   Prefask& address = Prefask_map(i);

   return address.get_address(buffer);
}

char *AS_MACROS_format(Pix i) {
   return ASMacro_map.key(i);
}

char *PRFX_MACROS_format(Pix i) {
   return Community_map.key(i);
}

char *AS_Path_format(int i) {
   static char format_buffer[64];
   sprintf(format_buffer, "AS%d", i);
   return format_buffer;
}
