// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _PixSplaySet_h
#ifdef __GNUG__
#pragma interface
#endif
#define _PixSplaySet_h 1

#include "config.hh"
#include "Pix.Set.h"
#include "Pix.SplayNode.h"

class PixSplaySet : public PixSet
{
protected:
  PixSplayNode*   root;

  PixSplayNode*   leftmost() const;
  PixSplayNode*   rightmost();
  PixSplayNode*   pred(PixSplayNode* t);
  PixSplayNode*   succ(PixSplayNode* t) const;
  void            _kill(PixSplayNode* t);
  PixSplayNode*   _copy(PixSplayNode* t);

public:
                  PixSplaySet();
                  PixSplaySet(PixSplaySet& a);
                  ~PixSplaySet();

  Pix             add(Pix  item);
  void            del(Pix  item);
  int             contains(Pix  item);

  void            clear();

  Pix             first() const;
  void            next(Pix& i) const;
  Pix&            operator () (Pix i) const;
  Pix             seek(Pix  item);

  Pix             last();
  void            prev(Pix& i);

  PixSplaySet&    operator =  (const PixSplaySet& b);
  void            operator |= (PixSplaySet& b);
  void            operator -= (PixSplaySet& b);
  void            operator &= (PixSplaySet& b);

  int             operator == (PixSplaySet& b);
  int             operator != (PixSplaySet& b);
  int             operator <= (PixSplaySet& b); 

  int             OK();
};


inline PixSplaySet::~PixSplaySet()
{
  _kill(root);
}

inline PixSplaySet::PixSplaySet()
{
  root = 0;
  count = 0;
}

inline PixSplaySet::PixSplaySet(PixSplaySet& b)
{
  count = b.count;
  root = _copy(b.root);
}


inline PixSplaySet& PixSplaySet::operator = (const PixSplaySet& b)
{
  if (this != &b)
    {
      _kill (root);
      count = b.count;
      root = _copy (b.root);
    }
  return *this;
}

inline int PixSplaySet::operator != (PixSplaySet& b)
{
  return ! (*this == b);
}

inline Pix PixSplaySet::first() const
{
  return Pix(leftmost());
}

inline Pix PixSplaySet::last()
{
  return Pix(rightmost());
}

inline void PixSplaySet::next(Pix& i) const
{
  if (i != 0) i = Pix(succ((PixSplayNode*)i));
}

inline void PixSplaySet::prev(Pix& i)
{
  if (i != 0) i = Pix(pred((PixSplayNode*)i));
}

inline Pix& PixSplaySet::operator () (Pix i) const
{
  if (i == 0) error("null Pix");
  return ((PixSplayNode*)i)->item;
}

inline void PixSplaySet::clear()
{
  _kill(root);
  count = 0;
  root = 0;
}

inline int PixSplaySet::contains(Pix  key)
{
  return seek(key) != 0;
}

#endif
