// $Id: ASMap.h 1.7.1.2 Fri, 31 Oct 1997 15:04:19 -0800 cengiz $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

/*
 *[C] The Regents of the University of Michigan and Merit Network, Inc.1993 
 *All Rights Reserved 
 *  
 *  Permission to use, copy, modify, and distribute this software and its 
 *  documentation for any purpose and without fee is hereby granted, provided 
 *  that the above copyright notice and this permission notice appear in all 
 *  copies of the software and derivative works or modified versions thereof, 
 *  and that both the copyright notice and this permission and disclaimer 
 *  notice appear in supporting documentation. 
 *   
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
 *   EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 *   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE 
 *   UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE 
 *   FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR 
 *   THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the 
 *   University of Michigan and Merit Network, Inc. shall not be liable for any 
 *   special, indirect, incidental or consequential damages with respect to any 
 *   claim by Licensee or any third party arising from use of the software. 
 */

#ifndef _ASMAP_H
#define _ASMAP_H

#include "config.hh"
#include "Map.hh"

class ipAddr;
class AutNum;
class whois;

class ASMap : public Map {
  public:
   ASMap(SymTab& dflt) : Map(dflt) {}
   
   // Added by wlee@isi.edu
   ~ASMap(void) { 
     clear();
   }
   void clear(void);

   Pix add_entry(char *asnum) {
      Pix r, s;

      if (r = seek(asnum))
	 return r;

      char *dup_asnum = (char *) STAllocator.allocate(strlen(asnum)+1);
      strcpy(dup_asnum, asnum);
      (void) (*this)[dup_asnum];
      r = seek(dup_asnum);

      dup_asnum = (char *) STAllocator.allocate(strlen(asnum)+5);
      strcpy(dup_asnum, "NOT ");
      strcpy(dup_asnum + 4, asnum);

      (void) (*this)[dup_asnum];
      s = seek(dup_asnum);

      contents(r).not = s;
      contents(s).not = r;
      contents(s).evaluated = 2;

      return r;
   }

   Pix add_entry(ipAddr& ipaddr);

   Pix add_entry_already_allocated(char *asnum) {
      Pix r, s;

      if (r = seek(asnum))
	 return r;

      (void) (*this)[asnum];
      r = seek(asnum);

      char *dup_asnum = (char *) STAllocator.allocate(strlen(asnum)+5);
      strcpy(dup_asnum, "NOT ");
      strcpy(dup_asnum + 4, asnum);

      (void) (*this)[dup_asnum];
      s = seek(dup_asnum);

      contents(r).not = s;
      contents(s).not = r;
      contents(s).evaluated = 2;

      return r;
   }

   void dump();
   _SetOfPix& expand(Pix p);

   AutNum *define(Pix p);
   void handle_extended_and_original_attr(AutNum *as);
};

extern ASMap AS_map;
extern void AS2AdrPrfx( _SetOfPix&, _SetOfPix& );
extern void AS2AdrPrfx(Pix p, _SetOfPix &PRFXset );

#endif
