// $Id: Route.hh 1.3 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#ifndef RouteObj_H
#define RouteObj_H

#include "config.hh"
#include "List.hh"
#include "Node.h"

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

class ListNodePix {
public:
   Pix       pix;
   ListNode  l;

public:
   ListNodePix() : l(this) {
      pix = NULL;
   }
   ListNodePix(Pix p) : l(this) {
      pix = p;
   }   
};

class ListHeadNodePix : public ListHead<ListNodePix> {
  public:
    ListHeadNodePix() { }

    ListHeadNodePix(const ListHeadNodePix& list) {
	set_empty();
	if (list.is_empty())
	    return;

	for (ListNodePix *e = list.head(); e; e = list.next(e->l)) {
	    ListNodePix *n = new ListNodePix(e->pix);
	    append (n->l);
	}
    }
};

class Attribute {
};

class NLRI : public Attribute {
private:
   char _dontcare;

public:
   Pix pix;

public:
   NLRI () {
      clear();
   }

   clear () {
      pix = NULL;
      _dontcare = 0;
   }

   int is_dontcare() {
      return _dontcare;
   }

   void dontcare() {
      _dontcare = TRUE;
   }
};

//class Origin : public Attribute, public ListHead<ListNodePix> {
class Origin : public Attribute, public ListHeadNodePix {
private:
   char _dontcare;

public:
   Origin() {
      clear();
   }

   void clear() {
      ListHead<ListNodePix>::clear();
      _dontcare = 0;
   }

   int match(Pix asn) {
      ListNodePix *p;
      for (p = head(); p; p = next(p->l))
	 if (asn == p->pix)
	    return TRUE;

      return FALSE;
   }

   int is_dontcare() {
      return _dontcare;
   }

   void dontcare() {
      _dontcare = TRUE;
   }
};

//class RipeCommunity : public Attribute, public ListHead<ListNodePix> {
class RipeCommunity : public Attribute, public ListHeadNodePix {
private:
   char _dontcare;

 public:
   RipeCommunity() {
      clear();
   }

   void clear() {
      ListHead<ListNodePix>::clear();
      _dontcare = 0;
   }

   int match(Pix com) {
      ListNodePix *p;
      for (p = head(); p; p = next(p->l))
	 if (com == p->pix)
	    return TRUE;

      return FALSE;
   }

   int is_dontcare() {
      return _dontcare;
   }

   void dontcare() {
      _dontcare = TRUE;
   }
};


//class ASPath : public Attribute, public ListHead<ListNodePix> {
class ASPath : public Attribute, public ListHeadNodePix {
private:
   char _dontcare;

public:
   ASPath() {
      clear();
   }

   void clear() {
      ListHead<ListNodePix>::clear();
      _dontcare = 0;
   }

   int is_dontcare() {
      return _dontcare;
   }

   void dontcare() {
      _dontcare = TRUE;
   }
};

class Pref : public Attribute {
 public:
   int     pref;

 public:
   Pref() {
      clear();
   }

   void clear() {
      pref = 0;
   }

   void set(int p) {
      pref = p;
   }
};

class Med : public Attribute {
 public:
   int     med;

 public:
   Med() {
      clear();
   }

   void clear() {
      med = 0;
   }

   void set(int m) {
      med = m;
   }
};

class Dpa : public Attribute {
 public:
   Pix asno;
   int pref;

 public:
   Dpa () {
      clear();
   }

   void clear() {
      asno = NULL;
      pref = 0;
   }

   set (Pix asn, int p) {
      asno = asn;
      pref = p;
   }
};

class Route {
public:
   NLRI          nlri;
   Origin        origin;
   RipeCommunity ripecommunity;
   ASPath        aspath;
   Pref          pref;
   Med           med;
   Dpa           dpa;

public:
   void print();
   void define();
   void define_less_or_equal_specific();
   void clear() {
      nlri.clear();
      origin.clear();
      ripecommunity.clear();
      aspath.clear();
      pref.clear();
      med.clear();
      dpa.clear();
   }
};

#endif   // RouteObj_H
