/* A Bison parser, made by GNU Bison 3.0.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         base_yyparse
#define yylex           base_yylex
#define yyerror         base_yyerror
#define yydebug         base_yydebug
#define yynerrs         base_yynerrs

#define yylval          base_yylval
#define yychar          base_yychar
#define yylloc          base_yylloc

/* Copy the first part of user declarations.  */
#line 5 "preproc.y" /* yacc.c:339  */

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
		if (N)						\
			(Current) = (Rhs)[1];	\
		else						\
			(Current) = (Rhs)[0];	\
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char	pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
static void __attribute__((format(PG_PRINTF_ATTRIBUTE, 3, 0)))
vmmerror(int error_code, enum errortype type, const char *error, va_list ap)
{
	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, base_yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	vfprintf(stderr, error, ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
	}
}

void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list		ap;

	va_start(ap, error);
	vmmerror(error_code, type, error, ap);
	va_end(ap);
}

void
mmfatal(int error_code, const char *error, ...)
{
	va_list		ap;

	va_start(ap, error);
	vmmerror(error_code, ET_ERROR, error, ap);
	va_end(ap);

	if (base_yyin)
		fclose(base_yyin);
	if (base_yyout)
		fclose(base_yyout);

	if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
		fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
	exit(error_code);
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(base_yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essentially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), mm_strdup(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in another functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn't cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = EMPTY;
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char var_text[20];
			char *original_var;
			bool skip_set_var = false;
			bool var_ptr = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(var_text, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable)
					 && (strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement")) == 0))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar
					  && ptr->variable->type->type != ECPGt_char
					  && ptr->variable->type->type != ECPGt_unsigned_char
					  && ptr->variable->type->type != ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																			   mm_strdup("1"),
																			   ptr->variable->type->u.element->counter),
														  ptr->variable->type->size),
									  0);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar
					  || ptr->variable->type->type == ECPGt_char
					  || ptr->variable->type->type == ECPGt_unsigned_char
					  || ptr->variable->type->type == ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				if (ptr->variable->type->type == ECPGt_varchar)
					var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_struct
					 || ptr->variable->type->type == ECPGt_union)
			{
				newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
									  ECPGmake_struct_type(ptr->variable->type->u.members,
														   ptr->variable->type->type,
														   ptr->variable->type->type_name,
														   ptr->variable->type->struct_sizeof),
									  0);
				var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct
					|| ptr->variable->type->u.element->type == ECPGt_union)
				{
					newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->variable->type->u.element->u.members,
															   ptr->variable->type->u.element->type,
															   ptr->variable->type->u.element->type_name,
															   ptr->variable->type->u.element->struct_sizeof),
										  0);
				}
				else
				{
					newvar = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																				   ptr->variable->type->u.element->size,
																				   ptr->variable->type->u.element->counter),
															  ptr->variable->type->size),
										  0);
					var_ptr = true;
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, mm_strdup("*("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				var_ptr = true;
			}

			/* create call to "ECPGset_var(<counter>, <connection>, <pointer>. <line number>)" */
			if (!skip_set_var)
			{
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(var_text, "%d))", ecpg_internal_var);
				var_ptr = false;

				if (ptr->indicator->type->type == ECPGt_struct
					|| ptr->indicator->type->type == ECPGt_union)
				{
					newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->indicator->type->u.members,
															   ptr->indicator->type->type,
															   ptr->indicator->type->type_name,
															   ptr->indicator->type->struct_sizeof),
										  0);
					var_ptr = true;
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct
						|| ptr->indicator->type->u.element->type == ECPGt_union)
					{
						newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
											  ECPGmake_struct_type(ptr->indicator->type->u.element->u.members,
																   ptr->indicator->type->u.element->type,
																   ptr->indicator->type->u.element->type_name,
																   ptr->indicator->type->u.element->struct_sizeof),
											  0);
					}
					else
					{
						newind = new_variable(cat_str(4, mm_strdup("("),
													  mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)),
													  mm_strdup(" *)(ECPGget_var("), mm_strdup(var_text)),
											  ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type,
																					   ptr->indicator->type->u.element->size,
																					   ptr->indicator->type->u.element->counter),
																  ptr->indicator->type->size),
											  0);
						var_ptr = true;
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
				}
				else
				{
					newind = new_variable(cat_str(4, mm_strdup("*("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
					var_ptr = true;
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && strcmp(cur->function, current_function) == 0))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;
	int (* strcmp_fn)(const char *, const char *) = ((name[0] == ':' || name[0] == '"') ? strcmp : pg_strcasecmp);

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp_fn(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char *dimension, char *length, enum ECPGttype type_enum,
			char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
		 type_enum == ECPGt_union) &&
		initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}

#line 645 "preproc.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "preproc.h".  */
#ifndef YY_BASE_YY_PREPROC_H_INCLUDED
# define YY_BASE_YY_PREPROC_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int base_yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    SQL_ALLOCATE = 258,
    SQL_AUTOCOMMIT = 259,
    SQL_BOOL = 260,
    SQL_BREAK = 261,
    SQL_CALL = 262,
    SQL_CARDINALITY = 263,
    SQL_CONNECT = 264,
    SQL_COUNT = 265,
    SQL_DATETIME_INTERVAL_CODE = 266,
    SQL_DATETIME_INTERVAL_PRECISION = 267,
    SQL_DESCRIBE = 268,
    SQL_DESCRIPTOR = 269,
    SQL_DISCONNECT = 270,
    SQL_FOUND = 271,
    SQL_FREE = 272,
    SQL_GET = 273,
    SQL_GO = 274,
    SQL_GOTO = 275,
    SQL_IDENTIFIED = 276,
    SQL_INDICATOR = 277,
    SQL_KEY_MEMBER = 278,
    SQL_LENGTH = 279,
    SQL_LONG = 280,
    SQL_NULLABLE = 281,
    SQL_OCTET_LENGTH = 282,
    SQL_OPEN = 283,
    SQL_OUTPUT = 284,
    SQL_REFERENCE = 285,
    SQL_RETURNED_LENGTH = 286,
    SQL_RETURNED_OCTET_LENGTH = 287,
    SQL_SCALE = 288,
    SQL_SECTION = 289,
    SQL_SHORT = 290,
    SQL_SIGNED = 291,
    SQL_SQL = 292,
    SQL_SQLERROR = 293,
    SQL_SQLPRINT = 294,
    SQL_SQLWARNING = 295,
    SQL_START = 296,
    SQL_STOP = 297,
    SQL_STRUCT = 298,
    SQL_UNSIGNED = 299,
    SQL_VAR = 300,
    SQL_WHENEVER = 301,
    S_ADD = 302,
    S_AND = 303,
    S_ANYTHING = 304,
    S_AUTO = 305,
    S_CONST = 306,
    S_DEC = 307,
    S_DIV = 308,
    S_DOTPOINT = 309,
    S_EQUAL = 310,
    S_EXTERN = 311,
    S_INC = 312,
    S_LSHIFT = 313,
    S_MEMPOINT = 314,
    S_MEMBER = 315,
    S_MOD = 316,
    S_MUL = 317,
    S_NEQUAL = 318,
    S_OR = 319,
    S_REGISTER = 320,
    S_RSHIFT = 321,
    S_STATIC = 322,
    S_SUB = 323,
    S_VOLATILE = 324,
    S_TYPEDEF = 325,
    CSTRING = 326,
    CVARIABLE = 327,
    CPP_LINE = 328,
    IP = 329,
    DOLCONST = 330,
    ECONST = 331,
    NCONST = 332,
    UCONST = 333,
    UIDENT = 334,
    IDENT = 335,
    FCONST = 336,
    SCONST = 337,
    BCONST = 338,
    XCONST = 339,
    Op = 340,
    ICONST = 341,
    PARAM = 342,
    TYPECAST = 343,
    DOT_DOT = 344,
    COLON_EQUALS = 345,
    ABORT_P = 346,
    ABSOLUTE_P = 347,
    ACCESS = 348,
    ACTION = 349,
    ADD_P = 350,
    ADMIN = 351,
    AFTER = 352,
    AGGREGATE = 353,
    ALL = 354,
    ALSO = 355,
    ALTER = 356,
    ALWAYS = 357,
    ANALYSE = 358,
    ANALYZE = 359,
    AND = 360,
    ANY = 361,
    ARRAY = 362,
    AS = 363,
    ASC = 364,
    ASSERTION = 365,
    ASSIGNMENT = 366,
    ASYMMETRIC = 367,
    AT = 368,
    ATTRIBUTE = 369,
    AUTHORIZATION = 370,
    BACKWARD = 371,
    BEFORE = 372,
    BEGIN_P = 373,
    BETWEEN = 374,
    BIGINT = 375,
    BINARY = 376,
    BIT = 377,
    BOOLEAN_P = 378,
    BOTH = 379,
    BY = 380,
    CACHE = 381,
    CALLED = 382,
    CASCADE = 383,
    CASCADED = 384,
    CASE = 385,
    CAST = 386,
    CATALOG_P = 387,
    CHAIN = 388,
    CHAR_P = 389,
    CHARACTER = 390,
    CHARACTERISTICS = 391,
    CHECK = 392,
    CHECKPOINT = 393,
    CLASS = 394,
    CLOSE = 395,
    CLUSTER = 396,
    COALESCE = 397,
    COLLATE = 398,
    COLLATION = 399,
    COLUMN = 400,
    COMMENT = 401,
    COMMENTS = 402,
    COMMIT = 403,
    COMMITTED = 404,
    CONCURRENTLY = 405,
    CONFIGURATION = 406,
    CONNECTION = 407,
    CONSTRAINT = 408,
    CONSTRAINTS = 409,
    CONTENT_P = 410,
    CONTINUE_P = 411,
    CONVERSION_P = 412,
    COPY = 413,
    COST = 414,
    CREATE = 415,
    CROSS = 416,
    CSV = 417,
    CURRENT_P = 418,
    CURRENT_CATALOG = 419,
    CURRENT_DATE = 420,
    CURRENT_ROLE = 421,
    CURRENT_SCHEMA = 422,
    CURRENT_TIME = 423,
    CURRENT_TIMESTAMP = 424,
    CURRENT_USER = 425,
    CURSOR = 426,
    CYCLE = 427,
    DATA_P = 428,
    DATABASE = 429,
    DAY_P = 430,
    DEALLOCATE = 431,
    DEC = 432,
    DECIMAL_P = 433,
    DECLARE = 434,
    DEFAULT = 435,
    DEFAULTS = 436,
    DEFERRABLE = 437,
    DEFERRED = 438,
    DEFINER = 439,
    DELETE_P = 440,
    DELIMITER = 441,
    DELIMITERS = 442,
    DESC = 443,
    DICTIONARY = 444,
    DISABLE_P = 445,
    DISCARD = 446,
    DISTINCT = 447,
    DO = 448,
    DOCUMENT_P = 449,
    DOMAIN_P = 450,
    DOUBLE_P = 451,
    DROP = 452,
    EACH = 453,
    ELSE = 454,
    ENABLE_P = 455,
    ENCODING = 456,
    ENCRYPTED = 457,
    END_P = 458,
    ENUM_P = 459,
    ESCAPE = 460,
    EVENT = 461,
    EXCEPT = 462,
    EXCLUDE = 463,
    EXCLUDING = 464,
    EXCLUSIVE = 465,
    EXECUTE = 466,
    EXISTS = 467,
    EXPLAIN = 468,
    EXTENSION = 469,
    EXTERNAL = 470,
    EXTRACT = 471,
    FALSE_P = 472,
    FAMILY = 473,
    FETCH = 474,
    FILTER = 475,
    FIRST_P = 476,
    FLOAT_P = 477,
    FOLLOWING = 478,
    FOR = 479,
    FORCE = 480,
    FOREIGN = 481,
    FORWARD = 482,
    FREEZE = 483,
    FROM = 484,
    FULL = 485,
    FUNCTION = 486,
    FUNCTIONS = 487,
    GLOBAL = 488,
    GRANT = 489,
    GRANTED = 490,
    GREATEST = 491,
    GROUP_P = 492,
    HANDLER = 493,
    HAVING = 494,
    HEADER_P = 495,
    HOLD = 496,
    HOUR_P = 497,
    IDENTITY_P = 498,
    IF_P = 499,
    ILIKE = 500,
    IMMEDIATE = 501,
    IMMUTABLE = 502,
    IMPLICIT_P = 503,
    IN_P = 504,
    INCLUDING = 505,
    INCREMENT = 506,
    INDEX = 507,
    INDEXES = 508,
    INHERIT = 509,
    INHERITS = 510,
    INITIALLY = 511,
    INLINE_P = 512,
    INNER_P = 513,
    INOUT = 514,
    INPUT_P = 515,
    INSENSITIVE = 516,
    INSERT = 517,
    INSTEAD = 518,
    INT_P = 519,
    INTEGER = 520,
    INTERSECT = 521,
    INTERVAL = 522,
    INTO = 523,
    INVOKER = 524,
    IS = 525,
    ISNULL = 526,
    ISOLATION = 527,
    JOIN = 528,
    KEY = 529,
    LABEL = 530,
    LANGUAGE = 531,
    LARGE_P = 532,
    LAST_P = 533,
    LATERAL_P = 534,
    LC_COLLATE_P = 535,
    LC_CTYPE_P = 536,
    LEADING = 537,
    LEAKPROOF = 538,
    LEAST = 539,
    LEFT = 540,
    LEVEL = 541,
    LIKE = 542,
    LIMIT = 543,
    LISTEN = 544,
    LOAD = 545,
    LOCAL = 546,
    LOCALTIME = 547,
    LOCALTIMESTAMP = 548,
    LOCATION = 549,
    LOCK_P = 550,
    MAPPING = 551,
    MATCH = 552,
    MATERIALIZED = 553,
    MAXVALUE = 554,
    MINUTE_P = 555,
    MINVALUE = 556,
    MODE = 557,
    MONTH_P = 558,
    MOVE = 559,
    NAME_P = 560,
    NAMES = 561,
    NATIONAL = 562,
    NATURAL = 563,
    NCHAR = 564,
    NEXT = 565,
    NO = 566,
    NONE = 567,
    NOT = 568,
    NOTHING = 569,
    NOTIFY = 570,
    NOTNULL = 571,
    NOWAIT = 572,
    NULL_P = 573,
    NULLIF = 574,
    NULLS_P = 575,
    NUMERIC = 576,
    OBJECT_P = 577,
    OF = 578,
    OFF = 579,
    OFFSET = 580,
    OIDS = 581,
    ON = 582,
    ONLY = 583,
    OPERATOR = 584,
    OPTION = 585,
    OPTIONS = 586,
    OR = 587,
    ORDER = 588,
    ORDINALITY = 589,
    OUT_P = 590,
    OUTER_P = 591,
    OVER = 592,
    OVERLAPS = 593,
    OVERLAY = 594,
    OWNED = 595,
    OWNER = 596,
    PARSER = 597,
    PARTIAL = 598,
    PARTITION = 599,
    PASSING = 600,
    PASSWORD = 601,
    PLACING = 602,
    PLANS = 603,
    POSITION = 604,
    PRECEDING = 605,
    PRECISION = 606,
    PRESERVE = 607,
    PREPARE = 608,
    PREPARED = 609,
    PRIMARY = 610,
    PRIOR = 611,
    PRIVILEGES = 612,
    PROCEDURAL = 613,
    PROCEDURE = 614,
    PROGRAM = 615,
    QUOTE = 616,
    RANGE = 617,
    READ = 618,
    REAL = 619,
    REASSIGN = 620,
    RECHECK = 621,
    RECURSIVE = 622,
    REF = 623,
    REFERENCES = 624,
    REFRESH = 625,
    REINDEX = 626,
    RELATIVE_P = 627,
    RELEASE = 628,
    RENAME = 629,
    REPEATABLE = 630,
    REPLACE = 631,
    REPLICA = 632,
    RESET = 633,
    RESTART = 634,
    RESTRICT = 635,
    RETURNING = 636,
    RETURNS = 637,
    REVOKE = 638,
    RIGHT = 639,
    ROLE = 640,
    ROLLBACK = 641,
    ROW = 642,
    ROWS = 643,
    RULE = 644,
    SAVEPOINT = 645,
    SCHEMA = 646,
    SCROLL = 647,
    SEARCH = 648,
    SECOND_P = 649,
    SECURITY = 650,
    SELECT = 651,
    SEQUENCE = 652,
    SEQUENCES = 653,
    SERIALIZABLE = 654,
    SERVER = 655,
    SESSION = 656,
    SESSION_USER = 657,
    SET = 658,
    SETOF = 659,
    SHARE = 660,
    SHOW = 661,
    SIMILAR = 662,
    SIMPLE = 663,
    SMALLINT = 664,
    SNAPSHOT = 665,
    SOME = 666,
    STABLE = 667,
    STANDALONE_P = 668,
    START = 669,
    STATEMENT = 670,
    STATISTICS = 671,
    STDIN = 672,
    STDOUT = 673,
    STORAGE = 674,
    STRICT_P = 675,
    STRIP_P = 676,
    SUBSTRING = 677,
    SYMMETRIC = 678,
    SYSID = 679,
    SYSTEM_P = 680,
    TABLE = 681,
    TABLES = 682,
    TABLESPACE = 683,
    TEMP = 684,
    TEMPLATE = 685,
    TEMPORARY = 686,
    TEXT_P = 687,
    THEN = 688,
    TIME = 689,
    TIMESTAMP = 690,
    TO = 691,
    TRAILING = 692,
    TRANSACTION = 693,
    TREAT = 694,
    TRIGGER = 695,
    TRIM = 696,
    TRUE_P = 697,
    TRUNCATE = 698,
    TRUSTED = 699,
    TYPE_P = 700,
    TYPES_P = 701,
    UNBOUNDED = 702,
    UNCOMMITTED = 703,
    UNENCRYPTED = 704,
    UNION = 705,
    UNIQUE = 706,
    UNKNOWN = 707,
    UNLISTEN = 708,
    UNLOGGED = 709,
    UNTIL = 710,
    UPDATE = 711,
    USER = 712,
    USING = 713,
    VACUUM = 714,
    VALID = 715,
    VALIDATE = 716,
    VALIDATOR = 717,
    VALUE_P = 718,
    VALUES = 719,
    VARCHAR = 720,
    VARIADIC = 721,
    VARYING = 722,
    VERBOSE = 723,
    VERSION_P = 724,
    VIEW = 725,
    VIEWS = 726,
    VOLATILE = 727,
    WHEN = 728,
    WHERE = 729,
    WHITESPACE_P = 730,
    WINDOW = 731,
    WITH = 732,
    WITHIN = 733,
    WITHOUT = 734,
    WORK = 735,
    WRAPPER = 736,
    WRITE = 737,
    XML_P = 738,
    XMLATTRIBUTES = 739,
    XMLCONCAT = 740,
    XMLELEMENT = 741,
    XMLEXISTS = 742,
    XMLFOREST = 743,
    XMLPARSE = 744,
    XMLPI = 745,
    XMLROOT = 746,
    XMLSERIALIZE = 747,
    YEAR_P = 748,
    YES_P = 749,
    ZONE = 750,
    NULLS_FIRST = 751,
    NULLS_LAST = 752,
    WITH_ORDINALITY = 753,
    WITH_TIME = 754,
    POSTFIXOP = 755,
    UMINUS = 756
  };
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED

union YYSTYPE
{
#line 579 "preproc.y" /* yacc.c:355  */

	double	dval;
	char	*str;
	int		ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;

#line 1202 "preproc.c" /* yacc.c:355  */
};

typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


extern YYSTYPE base_yylval;
extern YYLTYPE base_yylloc;
int base_yyparse (void);

#endif /* !YY_BASE_YY_PREPROC_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 1233 "preproc.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   112031

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  521
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  719
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2844
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  5237

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   756

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   508,     2,     2,
     513,   514,   506,   504,   516,   505,   515,   507,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   518,   517,
     501,   500,   502,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   511,     2,   512,   509,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   519,     2,   520,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   503,   510
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1512,  1512,  1515,  1517,  1519,  1521,  1523,  1525,  1527,
    1529,  1531,  1533,  1535,  1537,  1539,  1541,  1543,  1545,  1547,
    1549,  1551,  1553,  1555,  1557,  1559,  1561,  1563,  1565,  1567,
    1569,  1571,  1573,  1591,  1593,  1595,  1597,  1599,  1601,  1603,
    1605,  1607,  1609,  1611,  1613,  1615,  1617,  1619,  1621,  1623,
    1625,  1627,  1629,  1631,  1633,  1635,  1637,  1639,  1641,  1643,
    1645,  1647,  1649,  1651,  1655,  1657,  1659,  1661,  1663,  1665,
    1667,  1669,  1671,  1673,  1675,  1677,  1679,  1681,  1683,  1685,
    1687,  1689,  1691,  1693,  1695,  1697,  1699,  1701,  1703,  1705,
    1707,  1709,  1711,  1713,  1715,  1717,  1719,  1721,  1723,  1730,
    1732,  1734,  1736,  1738,  1740,  1742,  1744,  1746,  1748,  1750,
    1752,  1758,  1760,  1762,  1764,  1766,  1768,  1770,  1772,  1774,
    1780,  1790,  1794,  1800,  1804,  1814,  1824,  1825,  1839,  1846,
    1852,  1863,  1869,  1878,  1885,  1891,  1900,  1907,  1915,  1920,
    1928,  1933,  1939,  1944,  1950,  1955,  1961,  1965,  1969,  1973,
    1977,  1981,  1985,  1989,  1993,  2001,  2005,  2009,  2013,  2017,
    2021,  2029,  2037,  2046,  2048,  2056,  2060,  2068,  2076,  2080,
    2088,  2092,  2100,  2104,  2112,  2120,  2128,  2132,  2140,  2144,
    2152,  2156,  2160,  2165,  2174,  2179,  2185,  2190,  2196,  2200,
    2204,  2208,  2212,  2216,  2224,  2228,  2232,  2240,  2244,  2248,
    2256,  2260,  2264,  2268,  2269,  2273,  2277,  2281,  2286,  2290,
    2294,  2298,  2302,  2306,  2310,  2318,  2322,  2330,  2334,  2342,
    2346,  2360,  2364,  2368,  2372,  2380,  2384,  2388,  2392,  2400,
    2404,  2408,  2412,  2416,  2420,  2424,  2432,  2436,  2441,  2447,
    2451,  2459,  2467,  2471,  2475,  2479,  2487,  2491,  2499,  2503,
    2511,  2515,  2523,  2527,  2531,  2535,  2539,  2548,  2556,  2560,
    2568,  2572,  2580,  2588,  2592,  2596,  2600,  2604,  2612,  2616,
    2620,  2624,  2628,  2632,  2636,  2640,  2644,  2648,  2652,  2656,
    2660,  2664,  2668,  2672,  2680,  2684,  2692,  2696,  2700,  2704,
    2708,  2712,  2716,  2720,  2724,  2728,  2732,  2736,  2740,  2744,
    2748,  2752,  2756,  2760,  2764,  2768,  2772,  2776,  2780,  2784,
    2788,  2792,  2796,  2800,  2804,  2808,  2812,  2816,  2820,  2824,
    2828,  2832,  2836,  2840,  2844,  2848,  2852,  2856,  2860,  2864,
    2872,  2876,  2884,  2888,  2893,  2899,  2904,  2910,  2915,  2921,
    2925,  2929,  2933,  2941,  2949,  2954,  2960,  2964,  2972,  2976,
    2980,  2984,  2992,  3000,  3004,  3012,  3016,  3020,  3024,  3032,
    3037,  3045,  3053,  3061,  3065,  3073,  3078,  3084,  3088,  3092,
    3100,  3104,  3112,  3117,  3123,  3127,  3131,  3135,  3139,  3143,
    3147,  3151,  3155,  3159,  3163,  3167,  3171,  3175,  3183,  3188,
    3194,  3199,  3205,  3210,  3216,  3221,  3227,  3231,  3239,  3247,
    3251,  3255,  3259,  3264,  3270,  3274,  3282,  3290,  3294,  3298,
    3302,  3310,  3314,  3318,  3322,  3326,  3330,  3334,  3339,  3345,
    3350,  3356,  3361,  3367,  3371,  3379,  3383,  3391,  3395,  3399,
    3407,  3411,  3419,  3427,  3435,  3440,  3446,  3450,  3454,  3458,
    3466,  3470,  3474,  3478,  3482,  3486,  3490,  3498,  3502,  3506,
    3510,  3518,  3526,  3530,  3535,  3541,  3545,  3549,  3553,  3557,
    3561,  3569,  3573,  3581,  3585,  3589,  3593,  3597,  3601,  3605,
    3613,  3618,  3624,  3629,  3635,  3639,  3647,  3655,  3659,  3664,
    3669,  3675,  3679,  3687,  3691,  3699,  3704,  3710,  3714,  3718,
    3722,  3727,  3733,  3741,  3749,  3753,  3757,  3761,  3765,  3773,
    3778,  3784,  3788,  3792,  3797,  3803,  3807,  3811,  3816,  3822,
    3827,  3833,  3838,  3844,  3852,  3860,  3864,  3869,  3875,  3883,
    3891,  3896,  3902,  3910,  3918,  3922,  3930,  3935,  3941,  3945,
    3953,  3957,  3961,  3965,  3969,  3973,  3977,  3981,  3985,  3989,
    3993,  3997,  4005,  4010,  4016,  4020,  4024,  4028,  4036,  4040,
    4048,  4052,  4060,  4065,  4071,  4075,  4083,  4088,  4094,  4098,
    4106,  4111,  4117,  4121,  4129,  4134,  4140,  4148,  4153,  4159,
    4163,  4171,  4175,  4183,  4188,  4194,  4198,  4202,  4210,  4218,
    4223,  4229,  4237,  4241,  4245,  4249,  4253,  4257,  4261,  4265,
    4269,  4273,  4277,  4281,  4285,  4289,  4293,  4297,  4301,  4305,
    4309,  4313,  4317,  4321,  4325,  4329,  4337,  4345,  4349,  4353,
    4357,  4365,  4369,  4377,  4382,  4388,  4392,  4400,  4404,  4412,
    4417,  4423,  4427,  4435,  4443,  4447,  4455,  4459,  4463,  4467,
    4475,  4483,  4491,  4499,  4507,  4512,  4518,  4522,  4530,  4535,
    4541,  4545,  4553,  4557,  4561,  4569,  4573,  4581,  4585,  4593,
    4601,  4605,  4609,  4617,  4621,  4629,  4637,  4641,  4649,  4653,
    4657,  4665,  4669,  4677,  4681,  4685,  4689,  4693,  4701,  4706,
    4712,  4717,  4723,  4727,  4735,  4740,  4746,  4750,  4755,  4761,
    4765,  4769,  4773,  4781,  4786,  4793,  4795,  4803,  4807,  4811,
    4815,  4819,  4823,  4831,  4835,  4843,  4847,  4855,  4859,  4867,
    4875,  4879,  4887,  4895,  4899,  4903,  4907,  4915,  4924,  4933,
    4937,  4941,  4945,  4949,  4953,  4957,  4961,  4965,  4969,  4973,
    4977,  4981,  4985,  4993,  5001,  5005,  5013,  5017,  5025,  5029,
    5033,  5037,  5041,  5049,  5057,  5061,  5069,  5077,  5082,  5088,
    5092,  5100,  5104,  5108,  5116,  5121,  5127,  5135,  5139,  5147,
    5151,  5155,  5159,  5163,  5171,  5176,  5182,  5187,  5193,  5197,
    5202,  5208,  5214,  5220,  5228,  5232,  5240,  5244,  5252,  5256,
    5264,  5268,  5276,  5280,  5288,  5296,  5304,  5308,  5312,  5316,
    5324,  5328,  5332,  5336,  5340,  5344,  5348,  5352,  5356,  5360,
    5364,  5368,  5372,  5376,  5380,  5384,  5388,  5396,  5400,  5408,
    5412,  5420,  5424,  5432,  5440,  5444,  5449,  5455,  5459,  5463,
    5467,  5471,  5475,  5479,  5483,  5487,  5491,  5495,  5499,  5503,
    5511,  5515,  5519,  5523,  5527,  5531,  5535,  5539,  5543,  5547,
    5551,  5555,  5559,  5563,  5567,  5571,  5575,  5579,  5583,  5587,
    5591,  5595,  5599,  5607,  5611,  5619,  5623,  5627,  5631,  5635,
    5643,  5648,  5654,  5658,  5662,  5666,  5670,  5674,  5678,  5682,
    5686,  5690,  5694,  5698,  5702,  5710,  5714,  5722,  5726,  5730,
    5734,  5740,  5746,  5752,  5758,  5764,  5770,  5776,  5786,  5797,
    5808,  5819,  5830,  5841,  5852,  5868,  5884,  5900,  5911,  5927,
    5938,  5954,  5969,  5973,  5981,  5986,  5992,  6000,  6004,  6012,
    6016,  6020,  6024,  6028,  6036,  6040,  6048,  6052,  6056,  6060,
    6068,  6072,  6076,  6080,  6084,  6088,  6092,  6096,  6100,  6104,
    6108,  6112,  6116,  6120,  6124,  6128,  6136,  6140,  6148,  6152,
    6160,  6165,  6171,  6175,  6183,  6191,  6199,  6203,  6211,  6216,
    6222,  6227,  6233,  6241,  6246,  6252,  6256,  6260,  6268,  6272,
    6276,  6284,  6288,  6292,  6296,  6304,  6312,  6317,  6323,  6328,
    6334,  6339,  6345,  6350,  6356,  6360,  6368,  6372,  6376,  6384,
    6389,  6395,  6399,  6404,  6410,  6414,  6419,  6425,  6429,  6434,
    6440,  6444,  6448,  6456,  6461,  6467,  6471,  6479,  6483,  6491,
    6495,  6503,  6507,  6515,  6519,  6523,  6527,  6531,  6539,  6543,
    6547,  6551,  6555,  6563,  6571,  6579,  6583,  6587,  6595,  6599,
    6603,  6611,  6620,  6624,  6628,  6632,  6640,  6644,  6652,  6656,
    6664,  6668,  6672,  6676,  6680,  6684,  6688,  6692,  6696,  6700,
    6704,  6708,  6712,  6716,  6720,  6728,  6732,  6736,  6740,  6748,
    6752,  6760,  6765,  6771,  6779,  6783,  6791,  6799,  6803,  6811,
    6816,  6822,  6826,  6834,  6838,  6846,  6850,  6858,  6862,  6866,
    6870,  6878,  6882,  6890,  6898,  6902,  6910,  6914,  6922,  6926,
    6930,  6938,  6942,  6947,  6953,  6961,  6966,  6972,  6976,  6980,
    6988,  6992,  7000,  7005,  7011,  7015,  7023,  7027,  7031,  7035,
    7039,  7043,  7047,  7051,  7055,  7059,  7063,  7067,  7071,  7075,
    7079,  7083,  7087,  7091,  7095,  7099,  7103,  7107,  7111,  7115,
    7119,  7123,  7127,  7131,  7135,  7139,  7143,  7147,  7151,  7155,
    7159,  7163,  7167,  7171,  7175,  7179,  7183,  7187,  7191,  7195,
    7199,  7207,  7212,  7218,  7223,  7229,  7233,  7237,  7241,  7245,
    7249,  7253,  7257,  7261,  7265,  7269,  7273,  7277,  7281,  7285,
    7289,  7293,  7297,  7301,  7305,  7309,  7313,  7317,  7321,  7329,
    7333,  7337,  7341,  7345,  7349,  7353,  7357,  7361,  7365,  7369,
    7373,  7377,  7381,  7385,  7389,  7393,  7397,  7401,  7409,  7417,
    7421,  7425,  7433,  7437,  7445,  7449,  7453,  7457,  7461,  7469,
    7474,  7480,  7484,  7488,  7492,  7500,  7504,  7509,  7515,  7519,
    7527,  7535,  7540,  7546,  7554,  7558,  7566,  7570,  7574,  7578,
    7582,  7586,  7590,  7594,  7598,  7602,  7606,  7610,  7614,  7618,
    7626,  7630,  7635,  7641,  7645,  7649,  7653,  7657,  7665,  7669,
    7673,  7681,  7686,  7692,  7696,  7700,  7705,  7714,  7718,  7722,
    7727,  7733,  7741,  7749,  7754,  7760,  7764,  7768,  7772,  7776,
    7780,  7784,  7788,  7792,  7796,  7800,  7804,  7808,  7812,  7816,
    7820,  7828,  7833,  7839,  7843,  7851,  7859,  7864,  7870,  7878,
    7882,  7890,  7894,  7902,  7910,  7914,  7918,  7922,  7926,  7930,
    7934,  7942,  7947,  7953,  7961,  7965,  7969,  7973,  7977,  7981,
    7989,  7997,  8001,  8005,  8013,  8018,  8024,  8028,  8032,  8036,
    8040,  8048,  8052,  8060,  8064,  8068,  8072,  8080,  8084,  8092,
    8096,  8104,  8109,  8115,  8120,  8126,  8131,  8137,  8142,  8148,
    8152,  8156,  8160,  8168,  8172,  8176,  8180,  8184,  8188,  8192,
    8196,  8200,  8208,  8212,  8220,  8228,  8232,  8240,  8244,  8249,
    8255,  8261,  8271,  8276,  8282,  8286,  8290,  8294,  8302,  8304,
    8312,  8317,  8323,  8331,  8335,  8339,  8347,  8351,  8359,  8367,
    8372,  8378,  8386,  8391,  8397,  8405,  8410,  8416,  8420,  8424,
    8428,  8432,  8436,  8440,  8444,  8452,  8457,  8463,  8471,  8475,
    8483,  8487,  8495,  8503,  8511,  8519,  8523,  8531,  8584,  8588,
    8601,  8603,  8607,  8611,  8615,  8624,  8630,  8634,  8642,  8646,
    8654,  8658,  8666,  8670,  8674,  8678,  8682,  8686,  8690,  8694,
    8702,  8706,  8714,  8718,  8722,  8726,  8730,  8734,  8742,  8746,
    8754,  8758,  8766,  8774,  8779,  8785,  8790,  8792,  8798,  8802,
    8806,  8810,  8814,  8818,  8822,  8826,  8830,  8838,  8843,  8849,
    8853,  8858,  8864,  8868,  8872,  8877,  8883,  8888,  8894,  8902,
    8906,  8914,  8918,  8926,  8930,  8934,  8938,  8946,  8951,  8957,
    8961,  8966,  8974,  8978,  8986,  8990,  8998,  9006,  9010,  9015,
    9021,  9029,  9033,  9041,  9045,  9053,  9058,  9064,  9069,  9075,
    9079,  9087,  9092,  9098,  9102,  9110,  9118,  9122,  9126,  9130,
    9138,  9143,  9149,  9153,  9161,  9166,  9172,  9176,  9184,  9188,
    9192,  9196,  9203,  9210,  9214,  9222,  9226,  9230,  9234,  9238,
    9242,  9250,  9254,  9258,  9262,  9270,  9275,  9281,  9285,  9289,
    9293,  9298,  9304,  9308,  9312,  9316,  9324,  9329,  9335,  9339,
    9347,  9351,  9355,  9359,  9367,  9371,  9379,  9383,  9387,  9395,
    9399,  9407,  9415,  9419,  9427,  9432,  9438,  9443,  9449,  9454,
    9460,  9464,  9470,  9476,  9481,  9487,  9491,  9499,  9507,  9509,
    9511,  9515,  9519,  9523,  9531,  9541,  9552,  9561,  9565,  9569,
    9573,  9577,  9581,  9585,  9593,  9597,  9601,  9605,  9613,  9617,
    9625,  9630,  9636,  9640,  9644,  9648,  9652,  9656,  9660,  9664,
    9668,  9672,  9676,  9684,  9689,  9695,  9699,  9707,  9711,  9719,
    9727,  9735,  9739,  9747,  9751,  9759,  9767,  9775,  9779,  9783,
    9787,  9791,  9795,  9803,  9808,  9814,  9819,  9825,  9829,  9833,
    9837,  9845,  9853,  9857,  9862,  9868,  9872,  9876,  9880,  9884,
    9888,  9892,  9896,  9900,  9904,  9908,  9912,  9916,  9921,  9927,
    9931,  9939,  9943,  9947,  9951,  9955,  9959,  9963,  9967,  9971,
    9975,  9979,  9983,  9987,  9991,  9995,  9999, 10003, 10007, 10011,
   10015, 10019, 10023, 10027, 10031, 10035, 10039, 10043, 10047, 10051,
   10055, 10059, 10063, 10067, 10071, 10075, 10079, 10083, 10087, 10091,
   10095, 10099, 10103, 10107, 10111, 10115, 10119, 10123, 10127, 10131,
   10135, 10139, 10143, 10147, 10151, 10155, 10159, 10163, 10168, 10172,
   10180, 10184, 10188, 10192, 10196, 10200, 10204, 10208, 10212, 10216,
   10220, 10224, 10228, 10232, 10236, 10240, 10244, 10248, 10252, 10256,
   10260, 10264, 10272, 10276, 10280, 10284, 10288, 10292, 10296, 10300,
   10304, 10308, 10312, 10316, 10324, 10328, 10332, 10336, 10340, 10344,
   10348, 10356, 10360, 10368, 10372, 10380, 10384, 10388, 10392, 10396,
   10400, 10404, 10408, 10412, 10416, 10420, 10424, 10428, 10432, 10436,
   10440, 10444, 10448, 10452, 10456, 10460, 10464, 10468, 10472, 10476,
   10480, 10484, 10488, 10492, 10496, 10500, 10504, 10508, 10512, 10516,
   10520, 10524, 10528, 10532, 10536, 10540, 10544, 10552, 10556, 10564,
   10568, 10572, 10577, 10583, 10591, 10595, 10603, 10607, 10615, 10619,
   10627, 10631, 10636, 10642, 10646, 10650, 10654, 10662, 10667, 10673,
   10678, 10684, 10689, 10695, 10699, 10707, 10715, 10719, 10724, 10730,
   10738, 10742, 10749, 10754, 10760, 10765, 10770, 10776, 10780, 10788,
   10792, 10796, 10800, 10804, 10812, 10816, 10820, 10828, 10832, 10836,
   10844, 10848, 10856, 10860, 10864, 10868, 10872, 10876, 10880, 10884,
   10888, 10896, 10900, 10908, 10912, 10920, 10924, 10928, 10932, 10936,
   10940, 10948, 10952, 10960, 10964, 10972, 10976, 10984, 10988, 10996,
   11000, 11004, 11012, 11016, 11024, 11029, 11035, 11039, 11043, 11047,
   11051, 11055, 11059, 11063, 11071, 11075, 11083, 11091, 11096, 11102,
   11106, 11110, 11114, 11118, 11123, 11129, 11137, 11145, 11149, 11153,
   11161, 11165, 11173, 11181, 11185, 11193, 11201, 11206, 11212, 11217,
   11223, 11227, 11235, 11239, 11243, 11247, 11255, 11259, 11268, 11270,
   11278, 11283, 11289, 11293, 11301, 11305, 11313, 11321, 11326, 11332,
   11336, 11344, 11348, 11352, 11356, 11364, 11368, 11376, 11380, 11388,
   11392, 11400, 11408, 11416, 11424, 11432, 11440, 11448, 11452, 11460,
   11464, 11468, 11472, 11476, 11480, 11484, 11488, 11492, 11496, 11500,
   11504, 11508, 11512, 11513, 11518, 11524, 11532, 11536, 11544, 11548,
   11549, 11553, 11561, 11565, 11569, 11573, 11581, 11585, 11589, 11593,
   11597, 11601, 11605, 11609, 11613, 11617, 11621, 11625, 11629, 11633,
   11637, 11641, 11645, 11649, 11653, 11657, 11661, 11665, 11669, 11673,
   11677, 11681, 11685, 11689, 11693, 11697, 11701, 11705, 11709, 11713,
   11717, 11721, 11725, 11729, 11733, 11737, 11741, 11745, 11749, 11753,
   11757, 11761, 11765, 11769, 11773, 11777, 11781, 11785, 11789, 11793,
   11797, 11801, 11805, 11809, 11813, 11817, 11821, 11825, 11829, 11833,
   11837, 11841, 11845, 11849, 11853, 11857, 11861, 11865, 11869, 11873,
   11877, 11881, 11885, 11889, 11893, 11897, 11901, 11905, 11909, 11913,
   11917, 11921, 11925, 11929, 11933, 11937, 11941, 11945, 11949, 11953,
   11957, 11961, 11965, 11969, 11973, 11977, 11981, 11985, 11989, 11993,
   11997, 12001, 12005, 12009, 12013, 12017, 12021, 12025, 12029, 12033,
   12037, 12041, 12045, 12049, 12053, 12057, 12061, 12065, 12069, 12073,
   12077, 12081, 12085, 12089, 12093, 12097, 12101, 12105, 12109, 12113,
   12117, 12121, 12125, 12129, 12133, 12137, 12141, 12145, 12149, 12153,
   12157, 12161, 12165, 12169, 12173, 12177, 12181, 12185, 12189, 12193,
   12197, 12201, 12205, 12209, 12213, 12217, 12221, 12225, 12229, 12233,
   12237, 12241, 12245, 12249, 12253, 12257, 12261, 12265, 12269, 12273,
   12277, 12281, 12285, 12289, 12293, 12297, 12301, 12305, 12309, 12313,
   12317, 12321, 12325, 12329, 12333, 12337, 12341, 12345, 12349, 12353,
   12357, 12361, 12365, 12369, 12373, 12377, 12381, 12385, 12389, 12393,
   12397, 12401, 12405, 12409, 12413, 12417, 12421, 12425, 12429, 12433,
   12437, 12441, 12445, 12449, 12453, 12457, 12461, 12465, 12469, 12473,
   12477, 12481, 12485, 12489, 12493, 12497, 12501, 12505, 12509, 12513,
   12517, 12521, 12525, 12529, 12533, 12537, 12541, 12545, 12549, 12553,
   12557, 12561, 12565, 12569, 12573, 12577, 12585, 12589, 12593, 12597,
   12601, 12605, 12609, 12613, 12617, 12621, 12625, 12629, 12633, 12637,
   12641, 12645, 12649, 12653, 12657, 12661, 12665, 12669, 12673, 12677,
   12681, 12685, 12689, 12693, 12697, 12701, 12705, 12709, 12713, 12717,
   12721, 12725, 12729, 12733, 12737, 12741, 12745, 12749, 12753, 12757,
   12765, 12769, 12773, 12777, 12781, 12785, 12789, 12793, 12797, 12801,
   12805, 12809, 12813, 12817, 12821, 12825, 12829, 12833, 12837, 12841,
   12845, 12849, 12857, 12861, 12865, 12869, 12873, 12877, 12881, 12885,
   12889, 12893, 12897, 12901, 12905, 12909, 12913, 12917, 12921, 12925,
   12929, 12933, 12937, 12941, 12945, 12949, 12953, 12957, 12961, 12965,
   12969, 12973, 12977, 12981, 12985, 12989, 12993, 12997, 13001, 13005,
   13009, 13013, 13017, 13021, 13025, 13029, 13033, 13037, 13041, 13045,
   13049, 13053, 13057, 13061, 13065, 13069, 13073, 13077, 13081, 13085,
   13089, 13093, 13097, 13101, 13105, 13109, 13113, 13117, 13121, 13125,
   13129, 13133, 13137, 13141, 13145, 13149, 13153, 13163, 13164, 13167,
   13168, 13169, 13175, 13176, 13177, 13178, 13179, 13192, 13192, 13201,
   13216, 13218, 13221, 13223, 13227, 13239, 13255, 13259, 13270, 13271,
   13274, 13286, 13295, 13296, 13299, 13300, 13301, 13304, 13305, 13308,
   13309, 13312, 13313, 13316, 13318, 13320, 13322, 13326, 13333, 13340,
   13356, 13390, 13400, 13403, 13407, 13420, 13421, 13423, 13425, 13429,
   13443, 13450, 13511, 13520, 13522, 13523, 13526, 13528, 13529, 13532,
   13533, 13534, 13535, 13536, 13543, 13542, 13552, 13554, 13556, 13557,
   13560, 13561, 13562, 13563, 13566, 13567, 13571, 13570, 13587, 13585,
   13601, 13600, 13614, 13620, 13621, 13624, 13626, 13627, 13630, 13631,
   13632, 13633, 13636, 13637, 13640, 13648, 13665, 13673, 13696, 13802,
   13836, 13838, 13840, 13844, 13848, 13847, 13898, 13900, 13899, 13914,
   13920, 13927, 13932, 13938, 13939, 13942, 13943, 13944, 13945, 13946,
   13947, 13948, 13956, 13964, 13967, 13968, 13969, 13970, 13971, 13972,
   13980, 13988, 13989, 13990, 13993, 13994, 13997, 13999, 14008, 14096,
   14097, 14104, 14105, 14106, 14112, 14121, 14124, 14125, 14126, 14127,
   14130, 14131, 14132, 14135, 14137, 14145, 14146, 14152, 14160, 14161,
   14164, 14165, 14168, 14173, 14180, 14185, 14192, 14199, 14199, 14201,
   14208, 14209, 14212, 14213, 14214, 14215, 14216, 14217, 14218, 14219,
   14220, 14226, 14233, 14245, 14251, 14258, 14266, 14267, 14279, 14290,
   14301, 14305, 14306, 14309, 14314, 14318, 14319, 14322, 14328, 14336,
   14342, 14349, 14353, 14354, 14357, 14360, 14364, 14365, 14368, 14374,
   14383, 14388, 14398, 14408, 14420, 14421, 14422, 14423, 14424, 14425,
   14426, 14427, 14428, 14429, 14430, 14431, 14432, 14433, 14434, 14441,
   14442, 14445, 14446, 14453, 14454, 14455, 14462, 14461, 14478, 14479,
   14486, 14485, 14555, 14561, 14567, 14575, 14581, 14587, 14593, 14599,
   14605, 14611, 14617, 14623, 14634, 14635, 14638, 14639, 14640, 14641,
   14642, 14643, 14644, 14645, 14646, 14647, 14648, 14649, 14650, 14651,
   14652, 14653, 14654, 14655, 14656, 14657, 14658, 14659, 14660, 14661,
   14664, 14665, 14666, 14667, 14668, 14669, 14673, 14674, 14675, 14676,
   14677, 14678, 14679, 14682, 14685, 14686, 14687, 14688, 14689, 14690,
   14691, 14692, 14705, 14706, 14707, 14708, 14709, 14710, 14711, 14716,
   14717, 14718, 14719, 14720, 14721, 14727, 14728, 14729, 14730, 14731,
   14732, 14733, 14734, 14735, 14736, 14737, 14740, 14741, 14742, 14743,
   14744, 14747, 14748, 14749, 14750, 14753, 14754, 14755, 14756, 14757,
   14758, 14759, 14776, 14777, 14778, 14781, 14782, 14783, 14784, 14785,
   14786, 14790, 14790, 14793, 14799, 14800, 14803, 14805, 14810, 14820,
   14831, 14838, 14839, 14840, 14843, 14876, 14878, 14880, 14883, 14893,
   14903, 14913, 14914, 14917, 14919, 14920, 14921, 14924, 14926, 14934,
   14935, 14936, 14940, 14941, 14945, 14946, 14949, 14950, 14953, 14954,
   14955, 14956, 14957, 14960, 14961, 14962, 14963, 14964, 14965, 14966,
   14967, 14968, 14969, 14970, 14971, 14972, 14973, 14974, 14975, 14976,
   14977, 14978, 14979, 14980, 14981, 14982, 14983, 14984, 14985, 14986,
   14987, 14988, 14989, 14990, 14991, 14992, 14993, 14994, 14995, 14996,
   14997, 14998, 14999, 15000, 15001, 15002, 15003, 15004, 15005, 15006,
   15007, 15008, 15009, 15010, 15011, 15012, 15013, 15014, 15015, 15018,
   15019, 15020, 15021, 15024, 15025, 15026, 15027, 15028, 15029, 15030,
   15031, 15032, 15033, 15040, 15041, 15042, 15043, 15046, 15047, 15050,
   15051, 15054, 15055, 15066, 15067
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT",
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT",
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE",
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR",
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO",
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER",
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN",
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH",
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT",
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT",
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED",
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO",
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN",
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL",
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB",
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP",
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST",
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST",
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION",
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS",
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION",
  "ASSIGNMENT", "ASYMMETRIC", "AT", "ATTRIBUTE", "AUTHORIZATION",
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT",
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASCADED",
  "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER",
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER",
  "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMENT", "COMMENTS",
  "COMMIT", "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION",
  "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P",
  "COPY", "COST", "CREATE", "CROSS", "CSV", "CURRENT_P", "CURRENT_CATALOG",
  "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME",
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA_P",
  "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE",
  "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P",
  "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD",
  "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH",
  "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE",
  "EVENT", "EXCEPT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE",
  "EXISTS", "EXPLAIN", "EXTENSION", "EXTERNAL", "EXTRACT", "FALSE_P",
  "FAMILY", "FETCH", "FILTER", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR",
  "FORCE", "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION",
  "FUNCTIONS", "GLOBAL", "GRANT", "GRANTED", "GREATEST", "GROUP_P",
  "HANDLER", "HAVING", "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P",
  "ILIKE", "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING",
  "INCREMENT", "INDEX", "INDEXES", "INHERIT", "INHERITS", "INITIALLY",
  "INLINE_P", "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT",
  "INSTEAD", "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO",
  "INVOKER", "IS", "ISNULL", "ISOLATION", "JOIN", "KEY", "LABEL",
  "LANGUAGE", "LARGE_P", "LAST_P", "LATERAL_P", "LC_COLLATE_P",
  "LC_CTYPE_P", "LEADING", "LEAKPROOF", "LEAST", "LEFT", "LEVEL", "LIKE",
  "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP",
  "LOCATION", "LOCK_P", "MAPPING", "MATCH", "MATERIALIZED", "MAXVALUE",
  "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAME_P", "NAMES",
  "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NONE", "NOT", "NOTHING",
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC",
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "ON", "ONLY", "OPERATOR",
  "OPTION", "OPTIONS", "OR", "ORDER", "ORDINALITY", "OUT_P", "OUTER_P",
  "OVER", "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL",
  "PARTITION", "PASSING", "PASSWORD", "PLACING", "PLANS", "POSITION",
  "PRECEDING", "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY",
  "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "PROGRAM", "QUOTE",
  "RANGE", "READ", "REAL", "REASSIGN", "RECHECK", "RECURSIVE", "REF",
  "REFERENCES", "REFRESH", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME",
  "REPEATABLE", "REPLACE", "REPLICA", "RESET", "RESTART", "RESTRICT",
  "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW",
  "ROWS", "RULE", "SAVEPOINT", "SCHEMA", "SCROLL", "SEARCH", "SECOND_P",
  "SECURITY", "SELECT", "SEQUENCE", "SEQUENCES", "SERIALIZABLE", "SERVER",
  "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR",
  "SIMPLE", "SMALLINT", "SNAPSHOT", "SOME", "STABLE", "STANDALONE_P",
  "START", "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE",
  "STRICT_P", "STRIP_P", "SUBSTRING", "SYMMETRIC", "SYSID", "SYSTEM_P",
  "TABLE", "TABLES", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY",
  "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TRANSACTION",
  "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P",
  "TYPES_P", "UNBOUNDED", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE",
  "UNKNOWN", "UNLISTEN", "UNLOGGED", "UNTIL", "UPDATE", "USER", "USING",
  "VACUUM", "VALID", "VALIDATE", "VALIDATOR", "VALUE_P", "VALUES",
  "VARCHAR", "VARIADIC", "VARYING", "VERBOSE", "VERSION_P", "VIEW",
  "VIEWS", "VOLATILE", "WHEN", "WHERE", "WHITESPACE_P", "WINDOW", "WITH",
  "WITHIN", "WITHOUT", "WORK", "WRAPPER", "WRITE", "XML_P",
  "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLEXISTS", "XMLFOREST",
  "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P", "YES_P",
  "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_ORDINALITY", "WITH_TIME",
  "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'",
  "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "','", "';'", "':'",
  "'{'", "'}'", "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with",
  "OptRoleList", "AlterOptRoleList", "AlterOptRoleElem",
  "CreateOptRoleElem", "CreateUserStmt", "AlterRoleStmt",
  "opt_in_database", "AlterRoleSetStmt", "AlterUserStmt",
  "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt",
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt",
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt",
  "set_rest", "generic_set", "set_rest_more", "var_name", "var_list",
  "var_value", "iso_level", "opt_boolean_or_string", "zone_value",
  "opt_encoding", "NonReservedWord_or_Sconst", "VariableResetStmt",
  "reset_rest", "generic_reset", "SetResetClause",
  "FunctionSetResetClause", "VariableShowStmt", "ConstraintsSetStmt",
  "constraints_set_list", "constraints_set_mode", "CheckPointStmt",
  "DiscardStmt", "AlterTableStmt", "alter_table_cmds", "alter_table_cmd",
  "alter_column_default", "opt_drop_behavior", "opt_collate_clause",
  "alter_using", "replica_identity", "reloptions", "opt_reloptions",
  "reloption_list", "reloption_elem", "AlterCompositeTypeStmt",
  "alter_type_cmds", "alter_type_cmd", "ClosePortalStmt", "CopyStmt",
  "copy_from", "opt_program", "copy_file_name", "copy_options",
  "copy_opt_list", "copy_opt_item", "opt_binary", "opt_oids",
  "copy_delimiter", "opt_using", "copy_generic_opt_list",
  "copy_generic_opt_elem", "copy_generic_opt_arg",
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item",
  "CreateStmt", "OptTemp", "OptTableElementList",
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList",
  "TableElement", "TypedTableElement", "columnDef", "columnOptions",
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr",
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption",
  "TableConstraint", "ConstraintElem", "opt_no_inherit", "opt_column_list",
  "columnList", "columnElem", "key_match", "ExclusionConstraintList",
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions",
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith",
  "OnCommitOption", "OptTableSpace", "OptConsTableSpace", "ExistingIndex",
  "create_as_target", "opt_with_data", "CreateMatViewStmt",
  "create_mv_target", "OptNoLog", "RefreshMatViewStmt", "CreateSeqStmt",
  "AlterSeqStmt", "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by",
  "NumericOnly", "NumericOnly_list", "CreatePLangStmt", "opt_trusted",
  "handler_name", "opt_inline_handler", "validator_clause",
  "opt_validator", "DropPLangStmt", "opt_procedural",
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt",
  "CreateExtensionStmt", "create_extension_opt_list",
  "create_extension_opt_item", "AlterExtensionStmt",
  "alter_extension_opt_list", "alter_extension_opt_item",
  "AlterExtensionContentsStmt", "CreateFdwStmt", "fdw_option",
  "fdw_options", "opt_fdw_options", "DropFdwStmt", "AlterFdwStmt",
  "create_generic_options", "generic_option_list", "alter_generic_options",
  "alter_generic_option_list", "alter_generic_option_elem",
  "generic_option_elem", "generic_option_name", "generic_option_arg",
  "CreateForeignServerStmt", "opt_type", "foreign_server_version",
  "opt_foreign_server_version", "DropForeignServerStmt",
  "AlterForeignServerStmt", "CreateForeignTableStmt",
  "AlterForeignTableStmt", "CreateUserMappingStmt", "auth_ident",
  "DropUserMappingStmt", "AlterUserMappingStmt", "CreateTrigStmt",
  "TriggerActionTime", "TriggerEvents", "TriggerOneEvent",
  "TriggerForSpec", "TriggerForOptEach", "TriggerForType", "TriggerWhen",
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable",
  "ConstraintAttributeSpec", "ConstraintAttributeElem", "DropTrigStmt",
  "CreateEventTrigStmt", "event_trigger_when_list",
  "event_trigger_when_item", "event_trigger_value_list",
  "AlterEventTrigStmt", "enable_trigger", "CreateAssertStmt",
  "DropAssertStmt", "DefineStmt", "definition", "def_list", "def_elem",
  "def_arg", "old_aggr_definition", "old_aggr_list", "old_aggr_elem",
  "opt_enum_val_list", "enum_val_list", "AlterEnumStmt",
  "opt_if_not_exists", "CreateOpClassStmt", "opclass_item_list",
  "opclass_item", "opt_default", "opt_opfamily", "opclass_purpose",
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt",
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt",
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt",
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt",
  "opt_restart_seqs", "CommentStmt", "comment_type", "comment_text",
  "SecLabelStmt", "opt_provider", "security_label_type", "security_label",
  "FetchStmt", "fetch_args", "from_in", "opt_from_in", "GrantStmt",
  "RevokeStmt", "privileges", "privilege_list", "privilege",
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option",
  "function_with_argtypes_list", "function_with_argtypes", "GrantRoleStmt",
  "RevokeRoleStmt", "opt_grant_admin_option", "opt_granted_by",
  "AlterDefaultPrivilegesStmt", "DefACLOptionList", "DefACLOption",
  "DefACLAction", "defacl_privilege_target", "IndexStmt", "opt_unique",
  "opt_concurrently", "opt_index_name", "access_method_clause",
  "index_params", "index_elem", "opt_collate", "opt_class", "opt_asc_desc",
  "opt_nulls_order", "CreateFunctionStmt", "opt_or_replace", "func_args",
  "func_args_list", "func_args_with_defaults",
  "func_args_with_defaults_list", "func_arg", "arg_class", "param_name",
  "func_return", "func_type", "func_arg_with_default", "aggr_arg",
  "aggr_args", "aggr_args_list", "createfunc_opt_list",
  "common_func_opt_item", "createfunc_opt_item", "func_as",
  "opt_definition", "table_func_column", "table_func_column_list",
  "AlterFunctionStmt", "alterfunc_opt_list", "opt_restrict",
  "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt", "oper_argtypes",
  "any_operator", "DoStmt", "dostmt_opt_list", "dostmt_opt_item",
  "CreateCastStmt", "cast_context", "DropCastStmt", "opt_if_exists",
  "ReindexStmt", "reindex_type", "opt_force", "AlterTblSpcStmt",
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt",
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti",
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead",
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt",
  "UnlistenStmt", "TransactionStmt", "opt_transaction",
  "transaction_mode_item", "transaction_mode_list",
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option",
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item",
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt",
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", "AlterSystemStmt",
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", "AlterTSDictionaryStmt",
  "AlterTSConfigurationStmt", "CreateConversionStmt", "ClusterStmt",
  "cluster_index_specification", "VacuumStmt", "vacuum_option_list",
  "vacuum_option_elem", "AnalyzeStmt", "analyze_keyword", "opt_verbose",
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt",
  "ExplainableStmt", "explain_option_list", "explain_option_elem",
  "explain_option_name", "explain_option_arg", "PrepareStmt",
  "prep_type_clause", "PreparableStmt", "ExecuteStmt",
  "execute_param_clause", "InsertStmt", "insert_rest",
  "insert_column_list", "insert_column_item", "returning_clause",
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type",
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause",
  "single_set_clause", "multiple_set_clause", "set_target",
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options",
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens",
  "select_clause", "simple_select", "with_clause", "cte_list",
  "common_table_expr", "opt_with_clause", "into_clause",
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct",
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby",
  "select_limit", "opt_select_limit", "limit_clause", "offset_clause",
  "select_limit_value", "select_offset_value",
  "opt_select_fetch_first_value", "select_offset_value2", "row_or_rows",
  "first_or_next", "group_clause", "having_clause", "for_locking_clause",
  "opt_for_locking_clause", "for_locking_items", "for_locking_item",
  "for_locking_strength", "locked_rels_list", "values_clause",
  "from_clause", "from_list", "table_ref", "joined_table", "alias_clause",
  "opt_alias_clause", "func_alias_clause", "join_type", "join_outer",
  "join_qual", "relation_expr", "relation_expr_list",
  "relation_expr_opt_alias", "func_table", "rowsfrom_item",
  "rowsfrom_list", "opt_col_def_list", "opt_ordinality", "where_clause",
  "where_or_current_clause", "OptTableFuncElementList",
  "TableFuncElementList", "TableFuncElement", "Typename",
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType",
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit",
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter",
  "CharacterWithLength", "CharacterWithoutLength", "character",
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval",
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr",
  "c_expr", "func_application", "func_expr", "func_expr_windowless",
  "func_expr_common_subexpr", "xml_root_version",
  "opt_xml_root_standalone", "xml_attributes", "xml_attribute_list",
  "xml_attribute_el", "document_or_content", "xml_whitespace_option",
  "xmlexists_argument", "within_group_clause", "filter_clause",
  "window_clause", "window_definition_list", "window_definition",
  "over_clause", "window_specification", "opt_existing_window_name",
  "opt_partition_clause", "opt_frame_clause", "frame_extent",
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op",
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list",
  "func_arg_expr", "type_list", "array_expr", "array_expr_list",
  "extract_list", "extract_arg", "overlay_list", "overlay_placing",
  "position_list", "substr_list", "substr_from", "substr_for", "trim_list",
  "in_expr", "case_expr", "when_clause_list", "when_clause",
  "case_default", "case_arg", "columnref", "indirection_el", "indirection",
  "opt_indirection", "opt_asymmetric", "ctext_expr", "ctext_expr_list",
  "ctext_row", "opt_target_list", "target_list", "target_el",
  "qualified_name_list", "qualified_name", "name_list", "name",
  "database_name", "access_method", "attr_name", "index_name", "file_name",
  "func_name", "AexprConst", "Iconst", "RoleId", "role_list",
  "SignedIconst", "NonReservedWord", "unreserved_keyword",
  "col_name_keyword", "type_func_name_keyword", "reserved_keyword",
  "statements", "statement", "CreateAsStmt", "$@1", "at", "ECPGConnect",
  "connection_target", "opt_database_name", "db_prefix", "server",
  "opt_server", "server_name", "opt_port", "opt_connection_name",
  "opt_user", "ora_user", "user_name", "char_variable", "opt_options",
  "connect_options", "opt_opt_value", "prepared_name", "ECPGCursorStmt",
  "ECPGExecuteImmediateStmt", "ECPGVarDeclaration",
  "single_vt_declaration", "precision", "opt_scale", "ecpg_interval",
  "ECPGDeclaration", "$@2", "sql_startdeclare", "sql_enddeclare",
  "var_type_declarations", "vt_declarations", "variable_declarations",
  "type_declaration", "$@3", "var_declaration", "$@4", "$@5",
  "opt_bit_field", "storage_declaration", "storage_clause",
  "storage_modifier", "var_type", "enum_type", "enum_definition",
  "struct_union_type_with_symbol", "$@6", "struct_union_type", "$@7",
  "s_struct_union_symbol", "s_struct_union", "simple_type",
  "unsigned_type", "signed_type", "opt_signed", "variable_list",
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare",
  "ECPGDisconnect", "dis_name", "connection_object", "execstring",
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using",
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list",
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output",
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader",
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem",
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems",
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item",
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem",
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem",
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off",
  "ECPGSetConnection", "ECPGTypedef", "$@8", "opt_reference", "ECPGVar",
  "$@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames",
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId",
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon",
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval",
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind",
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param",
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident",
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term",
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest",
  "ecpg_into", "opt_ecpg_into", "ecpg_fetch_into", "opt_ecpg_fetch_into", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
      61,    60,    62,   755,    43,    45,    42,    47,    37,    94,
     756,    91,    93,    40,    41,    46,    44,    59,    58,   123,
     125
};
# endif

#define YYPACT_NINF -4558

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-4558)))

#define YYTABLE_NINF -2684

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-2684)))

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const int yypact[] =
{
   -4558,   477, 11814, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, 27020, -4558,
   -4558, -4558, -4558, -4558,100684,   511, -4558, -4558, -4558,105625,
   -4558, -4558, -4558,   287, 67854, -4558, 70794,   950, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, 74714, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, 56571,   831, -4558,
     494, -4558, -4558, -4558, -4558, -4558, -4558, -4558,  1402,  5196,
   -4558, -4558, 71284, -4558,    85, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, 71774,   594, -4558, -4558,   963,  1501, -4558,    92,
   14271, -4558, -4558, 64424, 68834, -4558, -4558, 75204,   371,  2029,
   15401,  1402, 26526, 75694, -4558,  1334, -4558, 53094, -4558, -4558,
   -4558, 68344, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, 83044,  2839,  1009, 53594, -4558, -4558,
   -4558, -4558, 83044, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, 76184, -4558,   998,  1234,   798, 83534, 84024, 65894,
   -4558,  1544, -4558, 83044,  1385,   716, 55589, -4558, 84514, -4558,
   -4558,  1283, -4558, 76674, -4558, -4558, -4558, -4558,  1009, -4558,
   56571, 52110,    41,  1295, -4558, -4558, 85004, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558,  1994,  1353, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558,   594, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558,   582, -4558,   949,   661,  2016,   801,  1406,
   -4558, -4558, -4558, 14952, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558,102145,   847, -4558, -4558, -4558,  1419, -4558,  1452, -4558,
   -4558, -4558,  2120, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
     880, -4558, -4558, -4558, -4558,  1986,101171, 74714, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, 63934, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558,   182, -4558, -4558, -4558,
   -4558, -4558, 74714, 74714, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   74714,  1592, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558,   512,  1820, -4558, -4558, 56571,  2501,  2501,  2178,
  102145, -4558, -4558, -4558, 58044, 83044, 83044, 83044,  1876, 83044,
    1745, 83044,   234, 58044,109848, 77164,  1928,  1818, 47597, -4558,
  108582, 83044, 83044, 85494, 83044,  1829, 72264, 83044,  1952, 83044,
   83044,109004, 85984,  1980, -4558,  2347,  1392, -4558, -4558, -4558,
   83044,  6704,  2839, -4558, -4558, 83044,  1924, 58044, 83044,  1881,
   83044,  1961, 83044, -4558, 83044,  1984, 86474,   315,  1892,109848,
    2141, 48101,  2042,109848, 86964, 83044, 83044, -4558, -4558,  2051,
   83044, 83044, -4558,  2165,110270,   863,  2192,  2298,  2241,   912,
   -4558, -4558,  2382,  1979, -4558, -4558,  2433, 74714, -4558, 72754,
   -4558, -4558, -4558,  2395, -4558, -4558, -4558, -4558, -4558, -4558,
  106894,  2029, -4558, -4558, 58535, 83044,  2278, -4558, -4558, 87454,
   -4558,  2086, -4558,   368, 59026,110692,  2383,  2090, 48605,  2416,
  111114, 87944, -4558, -4558, 88434, -4558, 88924,  2186, 89414, -4558,
  111536, -4558,  2308, 89904, -4558, 18815, -4558,  2083,  1505,  2114,
    1848, 74714, 74714,  1431,103482, -4558, -4558,   594, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558,   242,   766, 54094,   653,
   54594, -4558, -4558,   812,  1217,  1432,   242,  2554,  2554,    87,
   74714, -4558, -4558,   766, -4558,   642,   612,  2117,  2117,  2117,
    2316,  1083, -4558,  2117, -4558, -4558, -4558, -4558, 76674, 54094,
   54594, -4558,  2128,  2839,   218,  2523,  2188, 83044, -4558, 83044,
   -4558, 83044, 83044, -4558, -4558, -4558,  2552,  2180,  2396, -4558,
    2167, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
    2358,  2362,  2369,   108,  2839,  2267, -4558,  2478, -4558,  2380,
   31537,   524, 74714,  2839, 55094, 77654, 97744,   172,106894,  2839,
   90394,  2223,  1418,  2405, -4558, -4558, -4558,   636, -4558,  2607,
    2231,  2464,   447,  1392, 45113, -4558,  2239,  1626, 76674,102632,
   -4558, -4558, -4558, -4558,   262,  2514, 32046, -4558, 83044,  2234,
   -4558,  2238,  2245,  2248,  2016, -4558, 83044,   824,   824,  2640,
     824,  1870,  1874, -4558,  2131, -4558,  2539,  2503, 76674,  1295,
    1402,  2268, -4558, -4558, -4558,  2288, -4558,  2280,  2291, -4558,
     837,  2543, -4558, -4558, -4558, -4558,  2375,  2401,  2407,  2423,
    2306,  2449,   331, -4558, -4558, -4558, -4558,  2635, -4558, -4558,
   -4558, -4558, -4558, -4558,  2720,  2717,106050,106050,   544,   738,
     183,   208, -4558, -4558, -4558,  2587, -4558, -4558,  2578, 83044,
    2459, 83044, -4558, -4558, -4558, 90884, -4558, -4558,  2501,  2288,
    2352, -4558,   296, -4558,  1626, -4558,   347,   364,   405,  1684,
    2354,  1863,  1315, -4558,   383, 83044,  2500,   147,   721,  2428,
   78144,  4179,  2460,   622,  2709,  2713,  4935,   331, 78634, -4558,
   83044, 83044, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558,  2483, -4558, -4558,  2484,  2754,  1373,  2621,  1464,  2808,
    9154,  1366, 91374, 98234,  2777,  2832,  5548,  1547,   575,  2721,
    1081,  2754,  2823,  1507,  2842,  6510, 83044,  2548, -4558,  2783,
    2891,    -8, -4558,   154, -4558,  2627,  2759,   346, 58044,  2582,
   -4558, -4558, 83044, -4558, -4558, -4558,  2659, -4558,   630, 58044,
   -4558,  2780,  2647, 49109, -4558, 83044, -4558, -4558, -4558, -4558,
   -4558,  2710, 83044, -4558, -4558,  2834, 83044, -4558,  2117,  2767,
    2617,  2994, 61481,   304, 83044,  2657,  3027, 83044,  2827,  2657,
    2670, 91864, -4558, -4558,  2657, -4558, -4558, 83044, 83044,  2623,
    1932,  2657,  2848,  3037,  3051,  2740,  2845,   843,  1449,   122,
    2970,  2657,  2726, 83044, 92354, 83044,  2727, 83044,  3048, 58044,
   83044, -4558,  2851, 79124, -4558,  2684,  2382, -4558, -4558, -4558,
   -4558, -4558,  1114, -4558, -4558, -4558, -4558,  2998,  2352,   340,
    2999,  2700,  3000, -4558, -4558,  2733, -4558,  3003,  2460,  3005,
   -4558,  2702, 92844, -4558, 93334, 93824,  3007,  2483,109848,  3009,
    2702,  3010,  2896,  3013,   340,  3014, -4558,   990,  3016,  2902,
    3018,  2036,  2702,107316,  3021,   116, -4558, 20257, 18815, -4558,
   23733,  1631, -4558, -4558, -4558, -4558, -4558, -4558, 35609,   741,
    2810, -4558, -4558, -4558,  1624, -4558,104769, -4558,  1431,   766,
   -4558, 74714,   766, 74714,    87,   766, 74714,   766, 74714,    87,
     766, 74714, 74714, 74714,   766, -4558, -4558,  2317,  1443, -4558,
   -4558, -4558, -4558, -4558, 74714,  2724, 83044, 83044, -4558, -4558,
   -4558, 69324,109848, 69814, -4558, -4558,    32, 74714, -4558, 74714,
   -4558,  2839, -4558, -4558,  1505, 61481,  3130,109848,  3048,  3017,
    3017,  3017, -4558, -4558, -4558,  2953, 83044,  3019,  3023, 69324,
  109848, -4558, 94314,106894,  2914,  2735, -4558, -4558, -4558, -4558,
    2062,  2868,   320,  2888, 35609,  2736,   247,   247,  2738,  3028,
   -4558, -4558, -4558,   426,  2741,  2742, -4558,   444,   444,  2905,
    2745,  2746, -4558,   453,  2747, -4558,  2963,   486,  2748,  2749,
    2750,  2217,   247, 35609, -4558,  2751,   444,  2752,  2753,  2756,
    3030,  2757, -4558,  3081,  2758,   257,   286,  2760,  2765, -4558,
    2745, -4558,   221,  2768,  2769,  2770,  2772,  2773,  2775,  2779,
    2781, 35609, 35609, -4558, 30519,  1626,  2839, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558,    88, -4558,   495,  5270, -4558,  2789,
   -4558, -4558,  2915, 35609, -4558, -4558,  3004,  2774, -4558,   507,
   -4558, -4558,  1626, -4558, -4558,  1582, -4558, -4558, -4558, -4558,
    1940,  1940,   198, -4558, 71284, 71284, -4558, -4558,  1499,  2782,
   -4558,  1931, -4558, -4558, -4558, -4558, -4558, -4558,106472,  3185,
   -4558,  2633,  2839,   154,   199,  3136,103907,104338,  3032,  3032,
    3020, -4558, -4558, 83044, -4558, -4558, 35609, 51126, -4558,  1626,
      84,  3033, -4558, -4558, -4558,  2075, -4558, -4558, -4558,   594,
   -4558, 13055, -4558,  2087,  2234, 83044, 83044,  3194, -4558, -4558,
    2238, -4558, -4558,  2016,  2016, 35609,  2016,   939,  1703, 32555,
   35609,  3084,  2980,  1371,  1824,  3085, -4558,  2987,  1870,  1874,
   76674, 83044, 94804,  2908, -4558, -4558,  2288,  2807,  1851, -4558,
   63444,101658,101658,  3052, -4558, -4558,  1159,  1130,  2921,  3025,
    2554,  1368,  2328,  2328, -4558, -4558,  2813, -4558,  3151, 71284,
    2875,106050, -4558, -4558, 83044, -4558, -4558, 79614, -4558, -4558,
   -4558,  1487,  2820, -4558,  2833, 83044,  3323, -4558,  2328,  2328,
   -4558, -4558,  2822, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558,102145,  2826, 83044, -4558,  2828,  2829, -4558,102632, 51618,
    1895,  1626,  2904,  2907,  2954, 56571,  2831,  2916,  2918,  2960,
    2919,  2920, 98724, -4558, -4558, -4558, -4558,  1694,   965,  1067,
    2924,   299,   903,  3191, -4558,  1141,  2972, -4558, -4558, -4558,
    4522, 83044,  3152,  7782,  3038,   331,  2971, -4558, -4558,  3086,
    2931,  2934,  3054,   331,  1066, 99214, -4558, -4558, -4558, -4558,
   -4558, -4558,  5703, 29018, -4558,  2935,  2917,  2947, 83044, 64914,
    1484,  3049,  1324,  1825,   129, 83044,  3123,  3058, 83044,  2869,
    2948,  2949,  3140,  2873,  1352,  3234,  2872, -4558, -4558,  3050,
    3146,  3177,  8192,  2938,  2939, 60499,  1407, 49613,  3224,  1850,
    2966, -4558,  1850, 83044,  2968,  2969, 83044,   331, -4558,  3274,
     331,   331,  1923,  3281,  2974,   542,  1968,  2657,  2872,  1332,
   -4558,  2975,  2978,  1461, -4558,  3077, -4558, -4558,  1105,  2988,
   76674,   193,  1971,  2872,  2979,  2981,  2873,  2873, 83044, 83044,
   83044, 83044, 83044,   156,  3304,  3306,  2989,   107,  3036,  2913,
   -4558,  1850,107738,  2995, -4558,  1850, 83044,  2996,  2025,  2872,
    1828, -4558,  1978, -4558, -4558, -4558,  1392, -4558, 83044, -4558,
   83044,  2352, 61481,  3103, -4558,  2952, -4558,  2460,   331, -4558,
   83044, 83044,  2483,  1647,  1133,  3107, 83044,  3165,  2959, -4558,
     356, 51618, -4558,  2623,  2926, -4558,  2973, -4558,  2973,  2973,
    2928,  2928,  2930, -4558, -4558,  2217,  2973,  2928, -4558, 62463,
   -4558,  1597,  1655, -4558,  3329,  3337, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558,  1293, -4558,  2095, -4558, -4558,
   -4558, 83044, 56571, -4558,  3350, -4558, -4558, 61481,  3122,  3241,
   -4558, 83044,  3141,  2942, -4558,  3276,  3001, -4558, -4558,    -9,
   -4558,  3246,109848,  1351,  2839,  2992, 83044,  3168, 83044, 83044,
   83044, 83044, -4558, -4558,  3142,   983,    65, -4558,107738, -4558,
   83044,  1332,  3150,  3358,   695,  2117, 83044,  3243, -4558, 83044,
    2955,  3366,  3203, -4558, -4558,  2965,  2554, -4558,  2684, -4558,
    2142, -4558,  3089, -4558, 58044,   340, -4558, -4558, -4558, -4558,
   61481, 83044, 95294, 58044,   340,109848,109848,  3272,   116,  3275,
    3034,  3278,  3035, 49613,   340,   125,109848, 83044, 83044, 83044,
   -4558, 83044, -4558, -4558, -4558, -4558, 83044, 83044,109848,107738,
    3279,  3282,   340, 83044, 83044, -4558, -4558, 22936,  1797, -4558,
   18815, -4558, 13055,  2125,  3032, -4558,  1592, 83044,  1380,  1431,
  108160, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, 74714,
   -4558, 74714,    87, -4558, -4558, 74714, -4558, 74714,    87, -4558,
   74714, -4558, -4558, -4558, 74714, 83044,  3471,  2982, -4558,  1582,
   -4558, 83044,  2145, -4558, -4558,  2150,   660, 83044, 83044,   631,
   58044, 83044,  3175, 83044, 83044, 83044, 83044, 83044,  3063,  2782,
    1092, -4558,   189, 76674,  3183, -4558, -4558, -4558, -4558, -4558,
    2157,  1994,  1262, 83044, -4558, -4558, -4558, -4558, -4558, -4558,
   69814, 68344,  3280,   280, 83044, -4558, -4558,  3540, 35609, 31028,
   -4558, -4558, -4558,  2990, 13055,  3039, 35609, -4558, -4558, 35609,
    2997,  2554,  2554, 35609, -4558, -4558, -4558, -4558,  2044,  2554,
   -4558, 35609, 35609,  2554,  2554,  2973,  2973, -4558,  5869, 35609,
   -4558, 49613, 35609, 37136, 28508, 35609,  3071,  3012,  2554, -4558,
    2554, -4558, 35609, 30010, -4558, 35609,  3206, 38154, 35609,   199,
    3208, 35609,   199,  3420,  3420,  1295,  2103,  6908,  3006,  1626,
   -4558,  3111,  2554, -4558,  2554,   745,   284, 61481, 35609, 56571,
    3083,   165, 83044, 35609,  3002,  1550, -4558, 35609,   885, -4558,
    3008, 35609,  3088, 35609, 35609, 35609, 35609, 35609, 35609, 35609,
   35609, 35609, -4558, 39144,   307, -4558,  3288,  3307,    -6,  1766,
   70304,  3297, -4558, 31537, 27998, -4558,   190, 74714, -4558, -4558,
    1626, -4558, -4558, -4558, -4558, -4558,  1487,  3015, -4558,  3029,
   -4558, -4558, -4558, -4558, -4558, 83044,  3185, -4558, -4558,  3092,
   -4558, -4558, -4558, -4558,   515, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558,  3022, -4558, -4558, -4558, -4558,  3022, -4558,
   -4558,  3032,  3026,  5213, -4558, -4558, -4558, -4558,  3289,  3290,
     340,102145, 83044,   262, 73244, -4558, 32046, -4558,  2158, -4558,
    3041, -4558,  3268, -4558,  3031, -4558,  7339,  3268, -4558, -4558,
     139,  3137,  3267,  3228, -4558, -4558, -4558,  3043, 13055, -4558,
    2228, 13055,  2236, -4558, -4558, -4558, -4558, -4558, -4558,  1179,
   -4558, 83044,  3183,  3084,  1824,  3102,   791, 83044, -4558, 45608,
    2002, -4558,  2288, -4558, -4558, 25968, -4558, 27508, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558,  3047, -4558, -4558,
   -4558, -4558, -4558,   331,  3055,  3528, -4558,106050, -4558, -4558,
   -4558,  3471, -4558,  2433, -4558,  2433,  3553, -4558, 74714, -4558,
   -4558, -4558, -4558,   534, -4558, 18815, -4558, 18815, -4558,  3229,
   -4558,  3441, -4558, 62463, -4558,  3056, -4558, 61972, 59517, -4558,
   -4558,   802, -4558,  1274,  3131,  3132,  3181,109848, 83044, 83044,
   -4558, 56571,109848, 83044, 83044,109848, 83044, 83044, -4558,  3422,
     -42, 68344,  3184, 66384, -4558, -4558,  3064, 83044,  3118,  3318,
    3319,   -83, -4558, -4558, 95784, -4558,  3262,109848, 83044, 83044,
   35609,  3263, 83044, 83044, -4558,   360,  3158,  3161, -4558, 83044,
    3162, 58044,  3087, 83044, 83044, 83044,  3159,   640, 58044,  3134,
   50117, 83044, 83044, 83044, 83044,  3212, 83044, 83044,  3330,   928,
   76674,   131,  2032,  2872,  3291, -4558,  1193, -4558,109848, 83044,
    3283, -4558, -4558, -4558, 66874,  3492,  3201, -4558, -4558, 99704,
   -4558, -4558, -4558,  2169, -4558,109848,109848, 83044,  8996, 83044,
     906, -4558, -4558, 61481, -4558, 83044, 83044, 83044, 83044, 73734,
   96274, 96764,  1557,  1578, 83044, 74224, -4558, 83044, -4558, -4558,
   57062,109848, 83044,   679, 56571, -4558, 83044,  3287,   755, -4558,
   83044,  4546,  3179,  3189, 83044,   150,  2168,  2872, 83044, 83044,
    3105,  2207,  3186,  3232, -4558, 83044, 97744, -4558,109848,  1515,
   -4558,  3245,109848, 83044, 10723, -4558, -4558,   331, -4558, -4558,
   -4558, -4558, -4558, 83044, 83044,   331, 83044,   331,  1598, -4558,
  109848, 83044, -4558, -4558, -4558, 83044,  9717, 83044, 83044, 83044,
   83044,109848, 83044, -4558, -4558,  1247,  1463,  1609,  1786,  3250,
   83044,  3381, 83044, 97254,109848, 83044, 83044, 83044,  1323, -4558,
   -4558, -4558,  3227, -4558,109848,  1515, -4558, 10131, 83044, 83044,
    3192,  3196,   102,  3270, -4558, -4558, -4558, -4558, -4558, -4558,
    3360,  3526, 83044, -4558,  3365,  3367,  3178,  3187,  3373,  1541,
   83044, -4558, -4558, -4558, -4558, 83044,  3377,  1541,  3322,   525,
   -4558, -4558,  2657, -4558,  2213, -4558,  3153, -4558, 35609,  3543,
   61481,  3143,  3144,  3215, -4558,  3216,  2554, -4558,  2218, -4558,
   -4558,  2227, -4558,  3156,   983,  1632, -4558, 56571, 83044,   763,
     893,  3445, 65404,  2205,  3435, 83044,  3190, 83044,  2205, 83044,
   -4558,  2085, 68344, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558,  3436, -4558,  2839,  2623,  2623,  2623,  2623, -4558,
   -4558, -4558, -4558,  3338,  2119, -4558,  3154,  2623, 83044,  3264,
    2205,  3155, -4558,  1332,  3454,  3458, 83044, 65404,  2269,  3193,
    3564,  2117,  2839,  3346, -4558, 29514,  3726,  3348,106894, 79124,
   -4558,  3169,  3437,  3438,  3457, -4558,  2352, -4558,  3574, -4558,
    3476,   340,  2460, -4558,  2702, -4558, 83044, -4558, 83044, 83044,
   83044, 83044,  2483, -4558, -4558,  2702,  3362,   340,   340, -4558,
    3363,   340,  2702,  3292,  3467,106894, -4558,   116, -4558, -4558,
   -4558, -4558, -4558, 35609, -4558, -4558, -4558,  2117,  2142, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   74714,  2433, -4558,  2244, -4558, 83044, -4558,  3446,  3447,  3448,
    3200,  3202,  3221, 83044,  3204, -4558,  3200,   331,  3200,  2782,
    2782,  3200,  3202,109426,  3613,  3475,   788, -4558,   859,  1378,
    3410, -4558, -4558, -4558, -4558, 61481, -4558, -4558, -4558, -4558,
   -4558, 83044,  3238,   111,  3392,  3207,109426,  3597,   340, -4558,
   58044, -4558, -4558, -4558,  3284,  3299, 58044,  3405,  3259, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558,  3455, 83044,  2266, -4558,
    1823, -4558,  1862, 35609, 35609,   219, -4558, 10998,  2281, 35609,
    3218,  3219,  2292, -4558, -4558, -4558, -4558, -4558, -4558,  3222,
    3501, -4558, -4558,  3223,  2304,  2310,  3230,  3231, -4558, -4558,
    5642,  3233, 11866,  3235, 37136, 37136,   705, -4558, -4558, 37136,
    3237, -4558,  2333, 10437,  3225,  3239,  3247, -4558,  3244,  3248,
   11952, 33064, 35609, 33064, 33064, 12329,  3225,  3253,  2338, 56571,
    3398, 12441,  2341, -4558, 35609, 56571,  6389, 35609, -4558, 35609,
   83044,  3254,  3255, -4558, -4558,  5869, -4558,  3257, -4558, 37136,
   37136, -4558,  3803, 30519, -4558, -4558,  3519, -4558, -4558,  1855,
   -4558,  3251, -4558, -4558,  6017,   181, 35609,  3002, 35609,  3324,
   49613,  4428, 35609,  5908,  2817,  2817,   323,   323,   144,   144,
     144,  1468,  1766, -4558, -4558, -4558,  3277,  3285,  3286,  3424,
    2757, 35609, -4558,  2402,  2429, 83044,  4814,  6501, 11795, -4558,
   -4558, 40657,  3296, -4558, 35609, 35609, 35609,  3269, -4558,  3669,
   13055,   485, -4558,  3695, -4558, -4558, -4558,  1977,  3553,  1487,
   -4558,  1392,  2554,   745,104769, -4558, -4558, -4558, 35609, -4558,
   -4558, -4558, -4558,  2238, -4558, -4558, -4558, -4558, -4558, 83044,
    1994, 35609, -4558, -4558,   584,  2098, 35609,  2228, -4558, -4558,
    3331, -4558, 35609, -4558, -4558, -4558,  2782, -4558, -4558, -4558,
   40657,  3312,  3328, 44618,  3407, -4558, -4558, 83044,   141, -4558,
   -4558, -4558,  3293, -4558, -4558, -4558,  1543, -4558, -4558, -4558,
   -4558, -4558, -4558,  3294, -4558,  3298, -4558,  3300, -4558, -4558,
   -4558, -4558,   179,  3295,  3305,  3301,  -117, -4558, 59517,  2095,
   -4558, 61972, -4558, 61972, -4558,  2095,  3672, -4558, 59517,  1970,
  109848, 83044, 83044, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558,  3506, -4558,109848,109848,  3474, 83044,  3472,
    3477, 35609,   243, 83044,  3303,  3309,  1245,  3554, 83044, -4558,
    3593,   340, -4558, -4558,  3371, -4558, 13055, -4558, -4558, -4558,
   -4558, -4558,109848, 83044, -4558,106894, -4558,  2352, 61481, -4558,
   -4558, -4558, 83044,  3327, 83044, -4558, 83044, 83044, 83044,  2483,
   -4558, -4558, -4558, -4558,  1285, -4558, -4558, 83044, 83044,    77,
    3374,  3376, 83044, -4558,   759,  3077, 10868, 83044, 83044, 83044,
    3560, -4558, -4558, -4558, -4558,  3495, -4558, -4558, 59517, -4558,
    2702,  1453,  3388,  2872, -4558,  3494, -4558,  1177, -4558, -4558,
   -4558, -4558, -4558,  3615,   340,  3616,   340, 83044, 83044, 83044,
   83044, -4558, -4558, -4558, -4558, -4558, 56571, 56571, 56571,  2356,
   -4558, -4558,  2839, -4558, -4558, -4558, -4558, -4558, -4558,  3577,
   -4558,  2361, -4558,   688, -4558, -4558, -4558, -4558, -4558, -4558,
  109848, 83044, 11087, 83044, 83044, 83044,  1955, -4558,   922, 61481,
   -4558, 60990,109848, 83044, -4558, -4558,  3542,  3485, -4558,  1856,
    3486,109848,  3378, -4558, -4558,  3399, -4558, -4558,  3403,  2251,
    2872,  1332, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
    1459,   222,  2309,  2872,  3409, -4558,  3413, -4558, -4558, -4558,
    3547,  3558,  3559,  3421,  3423,  3465,  3425,  3426,  3469, -4558,
    3427,  3473,  3429,  3478,  3430,   340, 61481,  3545,  2839,  3464,
    3656,   340, -4558,  3439, -4558, -4558,  3758, -4558, 83044, -4558,
    3443,  2326,  2872, -4558, -4558,109848, 83044, -4558, -4558, -4558,
    1541, 61481,  3607,  1541,  1541, 83044, 83044,  1541, -4558, -4558,
   -4558,  3610,  3611,  1541, -4558, -4558, -4558, -4558,  2767,  3369,
   -4558,  2395, 47093,  7234,  3372,  3144,  3370,  2554, 43133,  1257,
    3583,  3375, -4558, -4558, 56571, 47093,  2155,  3599,  3394,  3394,
    3394,  3394,  3394,  3394,  3394, -4558,  2620,   289,  2657,106894,
   83044,106894, -4558,   893,  3494, 83044, 83044,  3382,  3379, -4558,
   -4558, -4558, -4558,109848,    90,109848,  2554, -4558, -4558,  3452,
   -4558, 83044,  2117,  3777,  3051,  1351,  3523,  1785,  3727,  3193,
   -4558, -4558, -4558, -4558, 83044, 83044,   983,  2839, -4558,  3389,
    3386, -4558, 83044, 83044, 83044, 83044,  1994,  3396,  3391, 61481,
     -24,  3581,  3584,  2873,  3802,  1994,  3193,  3479, 83044, -4558,
    2364,    95, -4558,  2839,106894, 60008, -4558,  4330, -4558, -4558,
    1077,  3674, -4558, 83044, -4558, -4558, 44123,   340, 61481, 83044,
   -4558,   340,   116,  3456,   340,  3459,   340,   340, 83044, -4558,
   -4558, 83044, -4558, 83044,107738,   340, -4558, 13055,  3689, -4558,
   -4558, -4558, -4558,  3527,  3530,  3532, 83044,  3200, 58044, -4558,
    3408,109848,  1475, -4558, -4558,  3589, -4558, -4558, -4558, -4558,
   -4558,  3716,  3718, -4558, -4558, -4558,   988, -4558,109848, 69324,
     133,109848, -4558,  2352, -4558, -4558,  2460,   331, -4558, 83044,
    3660, -4558, -4558, -4558,  3428,  2367, 12482, 35609, -4558,  3729,
   61481, -4558,  7285, -4558, -4558, -4558, -4558, 35609, -4558, -4558,
   -4558, -4558, -4558, 35609, -4558, 35609,  3704, -4558,  3846,  3846,
   61481, 37136,  1767,  2752, 37136, 37136, 37136, 37136, 37136, 37136,
   37136, 37136, 37136, 39653,   608, -4558, -4558, 35609, 35609,  3711,
    3704, -4558, -4558,  1649,  1649, 61481,  3431,  3225,  3433,  3434,
   35609, -4558, -4558,  2368, 38649,  3440, 56571, -4558, 35609, 10638,
    2385,  3481, 12888,  1626,  7916, -4558,  3801,  2839, 35609,  2575,
    2699, 35609,  2392, 35609,  3709, -4558, -4558, -4558,  3442, -4558,
   -4558, 61481, 35609, 37136, 37136,  6241, -4558,  7813, 35609,  3444,
    8574, 30519, -4558,  3609,  3482, 46103, -4558,  1009,  1009,  1009,
    1009, -4558, 83044, 83044, 83044, 41152,  3714, 40162, 80104,  3453,
    2204, -4558, 80104, 80594, -4558,  3461, -4558,  3449,  1626, 35609,
    3715,   589,   589,  3609, -4558, 35609, 33573,  3450, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558,  3460, -4558,  3463, -4558, -4558,   154,
    3466, -4558, -4558, 10145,   179, -4558, -4558,  3468, -4558,  3462,
   -4558,  2098, -4558, -4558, -4558,  8224,  3625, -4558, -4558,  3453,
   34082,  3407, -4558,  2404, -4558, -4558, 31537, -4558, -4558,  2412,
   45608,  3312, 32046,  1626,  2554,  3470, -4558,  2433,  1977, -4558,
   -4558, -4558, -4558, -4558,  2415,  1988, -4558, -4558, 59517, -4558,
    3515, -4558, -4558, -4558,  3394,  2702,  2702,  1322,  3200,  3737,
    1322,  8517, -4558, -4558, 41647, 83044, 83044, -4558, 83044,  2418,
    1450, 83044, -4558, 83044, -4558, -4558, -4558, -4558,  3863, -4558,
   83044, -4558, -4558,  3514,  3516, -4558, 83044, 83044, 83044, 83044,
   -4558, -4558,  2354, -4558, -4558,109848, 83044, -4558, -4558, -4558,
     232,  2348,  2872, -4558,  3541, -4558, -4558,  3719, -4558,  3853,
    3555, 83044,  3480, -4558,  1450,   211,  2873,   856, -4558, -4558,
    3536, 83044, -4558, 83044, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, 57062, -4558, -4558, 83044, -4558, 56571, 47093,
   56571, -4558,  1486,   239,  2353,  2872, -4558,  3548, -4558,  3550,
    3552,  3598,   898,   619,  3556,  3562,  3604,  3487,  3489,  3490,
   -4558, -4558,   242,  2839, -4558, -4558,  2839,  2702,  2839, 83044,
   83044, 83044,  3874,  3572, 83044, 83044, 83044, 83044, 83044,  3781,
      89,  2071,109848, 83044, 83044,109848, 83044, 83044, 83044, 83044,
   83044, 83044, 83044, -4558,  3868,  3794,  2215,  3840,  3573, 83044,
   -4558, 83044,  3077, 83044, 83044, -4558, -4558, -4558,  3503,  1541,
   -4558, -4558,  3749,  3750, -4558,  1541,  1541, -4558,   356, 56571,
   -4558,  2406, -4558,  3153,  3462,  2328,  2328, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558,  2554,  2458,  3509, -4558, 43628, -4558,
    3510, -4558,  2585,   745, -4558, -4558, 83044,  3394, -4558,  2355,
    2714,  2739,  2811, 81084, 81574, 82064,  3511, 83044, 83044, 37136,
   -4558,  1656,   693, -4558,  3748, 83044,  3551, -4558, -4558, -4558,
    3666, 83044, -4558, -4558, -4558, -4558, -4558,  3521, -4558,  3627,
   65404,  2702,109848,109848,  2702, -4558, 61481,  3522,  3193,109848,
    1351,  1209, 92354,  3561, -4558,  3513,  3812, -4558,  3529,  3524,
   -4558, -4558, 83044,  3494,  2435,   848,  2114,  3238, 67364,  2269,
    3782, -4558, -4558, -4558,  3893,  3617, -4558,  1994,  3238,  3617,
    2839,  3118, -4558, 59517, 35609, 35609, -4558,  3531, -4558,  3533,
    4991, -4558,  2623, -4558, -4558, -4558, -4558, -4558, -4558,  3608,
   83044,  3965, -4558, -4558, -4558,  3544,   340, -4558, -4558, 83044,
   -4558, 83044, -4558, -4558,   340,   340, -4558,  3654, -4558,  1994,
   83044, 83044, 83044,  3200, -4558,   331, -4558,  3821,109426, -4558,
   -4558, -4558, -4558, -4558,  3883,   280,  3828, -4558, -4558,  3790,
    3792,  3793,  3795,  1880, -4558, -4558, 35609, 13055, -4558,  3557,
   -4558, 13055,  8535, 13055,  3711, -4558,  3044,  3835, -4558,  1560,
    3565,  3044,  1021,  1021,   174,   174,   153,   153,   153,  3846,
     608, 13055, 13055, -4558, -4558, -4558, -4558,  3563, -4558, -4558,
   -4558,  3225, -4558, 36118,  3698,  3942, -4558, -4558, -4558,  3594,
    3595,  3566, -4558, 35609, 36627,  3568, 62463, -4558, -4558,   745,
    1787, 37136, 37136,  1140, -4558,  1709, 35609, 61481,  2440,  1140,
    3199,  3273, 35609, 35609,  9632,   350, 35609,  8664,  3567, 35609,
  100194, -4558, -4558, 83044, 83044, 83044, 83044, -4558, -4558, -4558,
   80104, 80594,  3575, 42637,  2204,  3571, 83044, -4558, -4558,  3580,
   40657,  3799,  3739, -4558, 40657,  3739,  1812,  3739,  3806, -4558,
   46598, -4558, -4558,  3582, -4558, -4558, 27998,  2072, 13055,  3961,
    3848, 35609,  3585,  3586,  3587, 13055, 35609, -4558,  2839,  1977,
     902,  2839, -4558, -4558, -4558, 49613, -4558, -4558, -4558,  3773,
   13055, -4558,  1994, 83044,  1626,   429,  3602, 83044, -4558,  3407,
   -4558, -4558, 18815, -4558, -4558, -4558, -4558,  3652,  2445, -4558,
     242, -4558, -4558, -4558, -4558,  3662, 68344,  3877, -4558, 35609,
    2466, -4558,  3630,  3966,   187,  2481,  2488,  1450, -4558,  3551,
   -4558,  1701,  3856,   268, -4558,   340, -4558, 61481, -4558, 83044,
   83044, -4558, -4558, -4558, -4558,  2831, -4558, -4558, 83044, 83044,
   83044, 83044, -4558,109848, 83044, -4558, 56571,  2620,  3797, -4558,
   -4558,  3798,   242, 83044, -4558, 61481,   340,   340, -4558, -4558,
   -4558, -4558,  3612,  3986,  3685, 83044, 83044, 83044, 83044,109848,
   83044, 83044,  2554,  2554, 61481,  3601, -4558,  2554,  2554,  3614,
   -4558,109848, 83044, 83044, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558,109848, 83044, -4558,  3682, -4558, -4558,
   -4558, 83044, 83044, 83044, 83044,  3908, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, 83044, -4558, -4558,
    2839,  2839, 61481,   340,   340, -4558, -4558, -4558,  3854, -4558,
    1541,  1541, -4558, -4558,   121,  2492, -4558,103054, -4558, -4558,
    3027,  2839,  3027,  1482, -4558, -4558,  3027, -4558,  3027, -4558,
    1450,  3621,  1904,  3892, -4558,  2529,102145, 43628, 43628, 43628,
   43628, 43628, -4558, -4558,  3897,   242, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, 35609, -4558,  1010,  3044, -4558, -4558, -4558, -4558,  3551,
    2117,  3676, 58044,  1149, -4558,  3878,   763, 65404,  1665, 83044,
   -4558,  2702,  2702,  3677, 83044,  4028, -4558,   957, 83044,  3941,
    3667, -4558,  2839, -4558, -4558,  3193, 83044, 65404,  3238, -4558,
    2496, -4558, -4558, -4558,  3668,  3584,  3634,  2269,  1139, 83044,
   -4558,  3671, -4558, -4558,  3922,  3639, -4558, 13055, 13055,  2839,
   62954,  4330, -4558, 83044,  3896, 83044, -4558,   340, -4558,   340,
     340, -4558, -4558, 83044,  3200,  3200,  3200, -4558,  3826, -4558,
   -4558,   340,109426,  1880,  1880,  1880,  1880, -4558, -4558, -4558,
   13055, -4558, -4558, -4558, 37136,  3928, -4558,  3645, 61481, -4558,
    3646,  2502,  2513, 38154,  3800, -4558, -4558, -4558,  8999,  3699,
   13055,  3752,  3649,  3655, -4558,  1218,  1218,  1709,  2516, -4558,
   37136, 37136,  1140,  1140, 35609,  1140, -4558, -4558,  9034,  3827,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, 57553, 80104,  3659,
   83044,  2204, 40657, -4558, -4558,  1013, -4558, 40657,  3900, -4558,
   40657, 83044,  3661, 83044,   485, 35609, 35609,  3701, -4558, -4558,
   -4558,  3609, -4558, -4558,  2328, -4558, -4558, -4558, -4558,   745,
    3664, 74714, -4558, -4558, -4558,  1295, -4558, -4558, -4558, -4558,
   -4558, -4558,109426,  3852,109426,  1450,  9069,  3551, 41647, 50621,
   83044, 82554, 82554,  3813,  3551,  3676, -4558, -4558, -4558, -4558,
   -4558, -4558,  3670, -4558, -4558, -4558,  3747, -4558, -4558,   398,
    3183,  2537, -4558, -4558, -4558, -4558, -4558,  3868, -4558, -4558,
   47093,109848, 83044, -4558,  3751, -4558, -4558, -4558, -4558, -4558,
   42142, 49613, -4558,   898,  3673,  3678,   619, -4558, -4558, -4558,
     781,  3183, 83044,  1575,   -19,  3712,  3200,  3951, -4558, -4558,
   -4558,  3868, -4558, -4558,  1541, -4558, -4558, -4558,  2657,  4003,
   -4558, 56571, -4558,105200, -4558, -4558, -4558,  2839, -4558,  2839,
    3875, 83044, 52602,  2839,  2839, -4558, 58044,  4086,  4086, -4558,
    3681,  2048,  2048, -4558, -4558, -4558, 83044, -4558, -4558,  9652,
    3879, -4558,  3676,  3903,  3949, -4558,  3693, 83044,  3849,  3694,
    3702,  1008,  1008,  3494, 83044,  2541,  1994,  1351, 65404,  3494,
   -4558,  1757,  3700,  4004, -4558,  4109,  3396,  3707, -4558, -4558,
   67364,  3887,  3617, 83044,  3584,  3834, -4558,  3839, -4558,  1312,
   -4558, 83044, 41647, -4558, 61972, -4558,  2544, -4558, -4558,  3296,
   83044,    76, -4558,  3723, -4558, -4558, -4558, -4558, -4558, -4558,
     133, -4558, -4558, -4558, -4558,   803, 37136, 61481,  2547, 35609,
   -4558, 35609, -4558,  4103, -4558, -4558, -4558,   638, -4558, -4558,
   -4558,  1218,  1218,  1140, -4558,  4104,  3609, -4558,  2558,  4122,
   -4558, 83044,  2580, -4558, 35609,  3720, -4558, -4558, 40657,  1013,
    2584, 83044,  2595, 61481,  3721,  3225, 13055, 83044, -4558,  3722,
   -4558, -4558, -4558, -4558, -4558, -4558,  1475,  1322,   133,  3966,
    3676, -4558,  3725, -4558, -4558, 83044, -4558,   240,   240, 83044,
    3676, -4558, -4558, 83044,  3811, -4558, -4558, 56571,  3774, -4558,
     927,  3183, 83044, 61481,  2460,   164, -4558, 61481, 61481, -4558,
    3815, -4558, -4558, 83044, 83044, 83044, 83044, 83044,   340, -4558,
    3369,  2839, -4558, -4558,  2604, -4558, -4558, -4558, 83044,  3513,
   -4558,  3513, -4558, -4558,  4086,   773, -4558, -4558, -4558, -4558,
    1742,  3923, -4558,  1136,  3918,  3818,  3734, -4558, 58044,  4168,
    3855, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
    4034,  3193,  3671, -4558, -4558, -4558, -4558, 35609,  3894,  1994,
    2269,  3782, -4558, -4558, -4558,  2608,  3617, -4558, -4558,  4117,
    3929,  4121, -4558,  2609, -4558, -4558,  4991, 62954,  4068, -4558,
    3805, 83044, -4558, -4558,  2254,  4177, -4558,   803,  2625, -4558,
    2631,  2634,  3898,  3808, -4558, 35609,  1741,  3461, 57553,  3755,
   -4558,  2646, -4558, 13055, 83044, -4558, -4558, -4558,  2651, -4558,
   -4558,  3753, -4558,  4156, -4558, -4558,  4036, -4558, 82554,  3807,
   49613, -4558,  2098,  2098,  2117, -4558,  1450, -4558, 83044, -4558,
   35609, -4558,  3844, -4558, -4558,  2655, -4558,   994,  3907,  4050,
    2658,  2663, 83044,  3202,  3809,  3202, -4558,  3200, -4558, -4558,
   -4558, -4558,105200,  3513, -4558, -4558, -4558,  4078,  4023, -4558,
   -4558, -4558, -4558,   355, -4558,  3952,  3953, 83044, -4558,  3765,
   -4558,  2664, 83044, 83044,  4174,  4175, -4558,  9709, 58044,  3671,
    3584,  2269,  2620, -4558, -4558,  3954, -4558,  3955,  3193, 41647,
    4330, -4558,   251, -4558, -4558, -4558, -4558, -4558, 83044, -4558,
   -4558, -4558, -4558, -4558,  3225, 34591, 34591,  3775, -4558, -4558,
   83044, -4558,  2667, -4558, 83044,  3779,109426,   240,  3780, -4558,
    3776, -4558, -4558,  3903,  1450,  3183, 13055, 83044, 58044,  4162,
   -4558, -4558, -4558,  3907, -4558, -4558,  3183, 83044, -4558,  3901,
   -4558,   815,   815,  4110, -4558,  3841, -4558, -4558,  3784, -4558,
    4214,  3494, -4558,   898,  1994, -4558,  3786, -4558,  3617,  3584,
   -4558, -4558,  3617, -4558, -4558, -4558, -4558,  1381, -4558, 37645,
    3913,   617, 10887, -4558, -4558, -4558, -4558,  2668, -4558, -4558,
   -4558,   133,  2098, 35609,  1450, -4558,  3918, -4558,  3183,  2460,
   83044, -4558, -4558, -4558,  3667, -4558,  4207, -4558,   987, -4558,
   -4558, -4558, -4558, -4558,  3601,  3671, 56080, -4558,  3617,  3296,
   -4558,  2173, -4558, -4558, -4558, -4558, -4558, -4558, -4558,  4197,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, 10134, -4558,
   -4558, -4558, -4558,  4093, -4558, -4558, -4558, -4558,  2676, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558,  1871, -4558, -4558,  1959,
    2248, 35100, -4558,  1450,  3946, -4558, 56080, -4558,  2173, -4558,
   58044, -4558, -4558,  3810, 56080,  2677, -4558
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
    2367,     0,     2,     1,  2797,  2801,  2805,  2806,  2723,  2807,
    2808,  2773,  2774,  2775,  2776,  2777,  2778,  2779,  2780,  2781,
    2782,  2783,  2784,  2786,  2785,  2787,  2788,  2789,  2790,  2791,
    2792,  2793,  2794,  2796,  2795,  2745,  2374,  2742,  2739,  2740,
    2741,  2746,  2744,  2737,  2738,  1964,  2810,  2798,  2811,  2799,
    2800,  2802,  2803,  2772,  2804,  2812,  2813,  2814,  2809,  2817,
    2768,  2769,  2767,  2770,  2771,  2815,  2816,  2759,  2760,  2761,
    2762,  2818,  2375,  2376,  2764,  2368,  2372,  2434,  2505,  2765,
    2766,  2763,  2373,  2758,  2505,     0,  2626,  2627,  2628,     0,
    2629,  2630,  2631,  2557,  2519,  2632,     0,     0,  2633,  2634,
    2635,  2636,  2637,  2638,  2639,  2640,     0,  2641,  2642,  2643,
    2644,  2504,  2645,  2646,  2647,  2648,  2649,  2481,  2487,  2610,
       0,  2461,  2462,  2458,  2460,  2459,  2463,  2446,  1222,   565,
    1310,  1309,     0,  2270,  1222,  2226,  2227,  2271,  2228,  2229,
    2230,   262,     0,  1312,  2231,  2272,     0,  1222,  2273,   389,
     984,  2274,  2275,  2389,     0,  2232,  2233,     0,     0,     0,
     565,  1222,     0,     0,  2234,  1424,  2235,     0,  2236,  2276,
    2277,     0,  2237,  2278,  2279,  2238,  2239,  2240,  2280,  2281,
    2282,  2241,  2283,  2284,     0,     0,  1438,     0,  2242,  2285,
    2243,  2244,     0,  2286,  2245,  2246,  2247,  2287,  2288,  2248,
    2249,  2250,     0,  2251,     0,     0,     0,     0,     0,     0,
    2289,  1222,  2252,     0,     0,  1445,     0,  2253,     0,  2290,
    2254,     0,  2255,     0,  2256,  2257,  2258,  2259,  1438,  2606,
    2482,     0,  1314,     0,  2260,  2291,     0,  2261,  2262,  2263,
    2264,  2265,  2266,  2267,  2268,  2269,     0,     0,    59,    60,
      24,    23,    29,    28,    82,    83,    47,    15,    73,    53,
     116,   115,   117,    35,    31,    67,    20,    22,    32,    36,
      55,    48,    94,    54,    18,    52,    77,    56,    80,    42,
       9,    10,    43,    71,    11,    44,    72,    12,    45,    13,
      61,    84,    27,    57,    81,    58,     3,    38,    69,    65,
       8,    49,    50,    51,    74,    75,    76,    99,    79,   111,
      34,   108,    88,    89,   105,    90,   106,     6,    91,    46,
      14,   102,   101,   103,    68,    39,    70,   100,    21,   104,
      16,    17,   107,    78,    97,    93,   112,   110,   118,    95,
      62,     4,     5,    85,    19,    41,     7,    26,    25,    40,
      33,   114,    30,  1312,    87,    98,    86,    92,    66,    96,
     113,    64,   109,  1411,  1398,  1447,  1410,  1423,     0,  1413,
    2702,  2703,    37,  1424,   120,   121,   126,  2371,  2423,  2424,
    2425,  2505,  2456,  2457,  2450,  2466,  2476,  2465,  2469,  2477,
    2464,  2483,     0,   123,   125,   127,   130,   124,   119,   122,
     129,   134,   128,   133,   131,   132,   135,   136,   137,  2704,
    1638,  2701,    63,  2441,  2440,     0,  2505,     0,  2734,  1976,
    1977,  1978,  1979,  1980,  1981,  1982,  1983,  1984,  1985,  1986,
    1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,  1995,  1996,
    1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,  2005,  2006,
    2007,  2008,  2009,  2010,  2011,  2012,  2013,  2014,  2015,  2016,
    2017,  2018,  2019,  2020,  2021,  2022,  2023,  2024,  2025,  2026,
    2027,  2028,  2029,  2030,  2031,  2032,  2033,  2034,  2035,  2036,
    2037,  2038,  2039,  2040,  2041,  2042,  2043,  2044,  2045,  2046,
    2047,  2048,  2049,  2050,  2051,  2052,  2053,  2054,  2055,  2056,
    2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,  2065,  2066,
    2067,  2068,  2069,  2070,  2071,  2072,  2073,  2074,  2075,  2076,
    2077,  2078,  2079,  2080,  2081,  2082,  2083,  2084,  2085,  2086,
    2087,  2088,  2089,  2090,  2091,  2092,  2093,  2094,  2095,  2096,
    2097,  2098,  2099,  2100,  2101,  2102,  2103,  2104,  2105,  2106,
    2107,  2108,  2109,  2110,  2111,  2112,  2113,  2114,  2115,  2116,
    2117,  2118,  2119,  2120,  2121,  2122,  2123,  2124,  2125,  2126,
    2127,  2130,  2128,  2129,  2131,  2132,  2133,  2134,  2135,  2136,
    2137,  2138,  2139,  2140,  2141,  2142,  2143,  2144,  2145,  2146,
    2147,  2148,  2149,  2150,  2151,  2152,  2153,  2154,  2155,  2156,
    2157,  2158,  2159,  2160,  2161,  2162,  2163,  2164,  2165,  2166,
    2167,  2168,  2169,  2170,  2171,  2172,  2173,  2174,  2175,  2176,
    2177,  2178,  2179,  2180,  2181,  2182,  2183,  2184,  2185,  2186,
    2187,  2188,  2189,  2190,  2191,  2192,  2389,  2193,  2194,  2195,
    2196,  2197,  2198,  2199,  2200,  2201,  2202,  2203,  2204,  2205,
    2206,  2207,  2208,  2209,  2210,  2211,  2212,  2213,  2214,  2215,
    2216,  2217,  2218,  2219,  2220,  2221,  2222,  2223,  2224,  2225,
    2407,  1965,  1973,  1974,  1975,  2382,  2403,  2409,  2730,  2408,
    1972,  2556,     0,     0,  2650,  2651,  2652,  2653,  2654,  2655,
    2705,  2706,  2707,  2708,  2709,  2711,  2710,  2518,  2677,  2714,
    2517,  2715,  2521,  2716,  2717,  2718,  2719,  2678,  2720,  2520,
    2712,  2674,  2522,  2515,  2516,  2675,  2624,  2625,  1942,  2676,
    2673,  2713,  2410,  2672,  2526,  2525,  1388,  2729,  1941,  1389,
       0,  2528,  2656,  2657,  2658,  2659,  2661,  2660,  2662,  2292,
    2293,  2294,  2295,  2296,  2297,  2298,  2299,  2300,  2301,  2302,
    2303,  2687,  2304,  2305,  2306,  2700,  2307,  2308,  2688,  2309,
    2310,  2311,  2312,  2313,  2314,  2315,  2316,  2317,  2318,  2319,
    2320,  2321,  2322,  2323,  2324,  2325,  2326,  2327,  2328,  2329,
    2330,  2331,  2332,  2689,  2690,  2333,  2334,  2335,  2336,  2337,
    2338,  2339,  2340,  2341,  2342,  2343,  2344,  2345,  2346,  2347,
    2348,  2349,  2350,  2351,  2352,  2353,  2354,  2355,  2356,  2691,
    2357,  2358,  2692,  2359,  2360,  2361,  2693,  2362,  2363,  2364,
    2365,  2366,  2697,  2698,  2699,  2686,  2479,  2663,  2685,  2696,
    2694,  2695,  2489,  2485,  2493,  2488,     0,     0,     0,     0,
    2505,  1221,  1220,  1206,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   564,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2379,     0,  1232,   360,   359,  1311,
    1292,   565,     0,  1209,   388,     0,     0,     0,     0,     0,
       0,     0,     0,   754,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   185,     0,     0,   412,   411,     0,
       0,     0,   956,   417,     0,     0,     0,     0,     0,   553,
    2388,  2383,  2393,     0,  2386,  2387,  2672,     0,  2821,  2128,
    2419,  2420,  2819,  2178,  1390,   263,   266,   267,   264,   265,
       0,  1063,  1064,  1066,     0,     0,  1076,   789,   790,     0,
     788,     0,   792,     0,     0,     0,   784,     0,     0,     0,
       0,     0,   791,   781,     0,   780,     0,     0,     0,   787,
       0,   782,     0,     0,  1210,     0,  2471,  2472,  2066,  1351,
     418,     0,     0,  1424,     0,  1329,  1330,  1312,  1319,  1331,
    1324,  1326,  1325,  1327,  1323,  1328,  1977,   895,  1991,   895,
    2056,   892,   893,   895,   895,   895,  2145,     0,     0,   867,
       0,   878,  1968,   895,  1969,  2730,   900,   473,   473,   473,
       0,   899,   904,   473,  1203,  1241,  1946,  1437,     0,  1991,
    2056,   868,  1202,  2193,  1343,     0,     0,     0,  1080,     0,
    1081,     0,  2160,  1214,   247,  2670,  2169,  2256,  2193,  2671,
     246,   241,   242,  2665,  2666,  2668,   215,  2669,  2667,  2664,
    1981,     0,     0,   899,     0,  1211,  1212,   851,  1444,  1442,
    1928,     0,     0,  1999,     0,  2011,  2092,   238,  2156,  2161,
    2169,  2256,  2193,  2223,   194,   204,   199,     0,   256,  2169,
    2256,  2193,     0,  1232,     0,  1414,  1530,  1937,     0,     0,
    2480,  1205,  1204,  1313,     0,  1316,     0,  1492,  2141,  1418,
    1420,  1318,  1411,     0,     0,  2370,  1307,  1441,  1441,     0,
    1441,     0,  1403,  1411,  1406,  1410,     0,     0,     0,     0,
    1222,     0,  2448,  2476,  2455,  2511,  2452,     0,     0,  2501,
    2497,  2494,  2502,  2503,  2496,  2484,  1627,  1628,  1629,  1626,
    1639,  1625,     0,  2429,  1630,  2468,  2435,     0,  2443,  2442,
    2747,  2748,  2558,  2381,  2400,     0,     0,     0,     0,     0,
       0,     0,  2527,  2529,  2531,  2491,  2490,  2486,     0,     0,
       0,     0,  2616,  2617,  2615,     0,  2612,  2614,     0,  2511,
       0,  2681,  2675,  2684,     0,  1947,  2676,  2673,  2672,     0,
     799,     0,   141,   944,     0,     0,     0,     0,  1941,     0,
       0,     0,     0,     0,     0,  2065,     0,     0,     0,  1840,
    2003,  2051,  1850,  1848,  1849,  1842,  1843,  1844,  1845,  1846,
    1847,     0,  1061,  1841,     0,   163,   141,     0,     0,  2065,
       0,     0,     0,     0,     0,  2065,     0,     0,     0,     0,
       0,   163,  2095,   141,  2065,     0,     0,     0,  1226,     0,
       0,     0,  1228,  1231,  1207,  1295,     0,  1937,     0,     0,
     830,   820,     0,   831,   821,   826,     0,   833,     0,     0,
     823,     0,     0,     0,   834,     0,   822,   824,   836,   825,
     832,     0,     0,   827,   828,     0,     0,  1218,   473,   366,
       0,     0,     0,     0,     0,   141,  1282,     0,  2065,   141,
       0,     0,   416,   415,   141,   414,   413,  2003,  2051,     0,
     983,   141,  2065,     0,   187,   635,   568,     0,     0,   713,
    2095,   141,     0,     0,     0,     0,     0,     0,   959,     0,
       0,   552,   565,     0,  2392,  2398,     0,  2390,  2559,  2822,
    2820,  2514,     0,  1067,   239,   240,  1065,  2065,     0,   334,
       0,     0,  2065,  1269,   786,     0,   785,  2065,     0,  2065,
    1966,   178,     0,   783,  2003,  2051,  2065,     0,     0,  2065,
     170,  2065,     0,  2065,   334,  2065,   569,     0,  2065,     0,
    2065,  2095,   172,     0,  2065,   334,   797,     0,     0,  2752,
    2756,     0,  2754,  2749,  2470,  2524,  2523,  2422,     0,  2833,
       0,  1390,  1321,  1336,     0,  1332,  1339,  1335,  1424,   895,
     894,     0,   895,     0,  2843,   895,     0,   895,     0,  2843,
     895,     0,     0,     0,   895,  1970,  1971,     0,     0,  2842,
    2838,  2841,   869,   879,     0,   901,     0,     0,   908,   907,
     906,     0,     0,     0,   909,  1534,  1366,     0,   876,     0,
     874,     0,  1200,  1217,     0,     0,     0,     0,   959,  1083,
    1083,  1083,  1213,   245,   243,     0,     0,     0,     0,     0,
       0,  1219,     0,     0,     0,     0,  2736,  1953,  1851,  2735,
       0,  2227,  2228,  2229,  1909,     0,  2677,  2230,  2231,  2272,
    1759,  1746,  1755,  1760,  1747,  1749,  1756,  2232,  2233,  2035,
    2234,  2235,  1960,  2236,  2237,  1582,  2239,  2240,  2241,  1751,
    1753,  2242,  2243,     0,  1961,  2245,  2246,  2114,  2248,  2249,
    2251,  2252,  1757,  2254,  2255,  2256,  2257,  2258,  2259,  1959,
       0,  1758,  2260,  2262,  2263,  2264,  2265,  2266,  2267,  2268,
    2269,     0,     0,  1934,     0,  1728,     0,  1574,  1575,  1597,
    1598,  1576,  1603,  1604,  1616,  1577,     0,  1933,  1641,  1808,
    1727,  1742,  1733,     0,  1726,  1722,  1427,  1927,  1929,     0,
    1723,  1949,  1910,  1963,  1962,  2730,  1918,  1952,  1950,  1951,
       0,     0,     0,   207,     0,     0,  2605,   258,     0,   259,
    1935,  2169,   195,   237,   209,   236,   210,   208,     0,  2001,
     196,     0,     0,   197,     0,     0,     0,     0,     0,     0,
       0,   252,  1208,     0,  1532,  1531,     0,     0,  1916,  1938,
     806,     0,  1305,  1306,  1304,     0,  1301,  1303,  1315,  1312,
    1923,  1922,  1924,     0,  1419,     0,     0,     0,  1401,  1400,
    1318,  1439,  1440,     0,     0,     0,     0,     0,     0,     0,
       0,  1482,  1455,  1456,  1458,  1479,  1483,  1491,     0,  1407,
       0,     0,  1536,     0,  1493,  2369,  2511,  2512,     0,  2506,
       0,  2505,  2505,  2499,  2498,  2495,     0,     0,     0,     0,
       0,     0,     0,     0,  2426,   547,  2428,   544,     0,     0,
    2402,     0,  2406,  2404,     0,  2551,  2554,     0,  2552,  2553,
    2555,     0,  2560,  2561,     0,     0,     0,  2743,     0,     0,
    2542,  2530,  2537,  2539,  2541,  2540,  2549,  2545,  2548,  2550,
    2492,  2505,  2623,     0,  2618,  2621,     0,  2613,     0,     0,
       0,  1948,     0,     0,     0,     0,   800,     0,     0,     0,
       0,     0,     0,   140,  1267,   249,  1265,     0,     0,     0,
       0,     0,     0,     0,  1274,     0,     0,   176,   177,   580,
     565,     0,  2065,     0,     0,     0,     0,  1023,  1030,     0,
       0,     0,     0,     0,     0,     0,  1024,  1022,  1025,   251,
    1034,  1047,  1050,     0,   934,     0,     0,     0,     0,     0,
    1132,     0,     0,  1132,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   272,   284,   329,     0,
       0,  2065,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   145,     0,     0,     0,     0,     0,     0,   531,   543,
       0,     0,     0,     0,     0,   540,     0,   141,   276,   524,
     528,     0,     0,     0,   644,   643,  1272,  1271,     0,     0,
       0,  1132,     0,   268,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   352,
     353,     0,     0,     0,   145,     0,     0,     0,     0,   278,
       0,  2436,     0,  1227,  1224,  1225,     0,  1230,     0,  1291,
       0,     0,     0,     0,   838,     0,   835,     0,     0,   829,
    2003,  2051,     0,     0,     0,     0,     0,     0,   391,   365,
       0,     0,   710,     0,     0,  1585,  1614,  1592,  1614,  1614,
    1581,  1581,  1594,  1583,  1621,     0,  1614,  1581,  1586,     0,
    1584,  1624,  1624,  1609,     0,  1566,  1567,  1568,  1569,  1595,
    1596,  1570,  1601,  1602,  1571,  1638,  2682,  1581,  2683,  2680,
    2679,     0,     0,   721,     0,  1244,  1281,     0,     0,     0,
     574,     0,  2065,     0,   143,   755,     0,   711,   417,     0,
     143,     0,     0,   181,     0,   639,     0,     0,     0,     0,
       0,     0,   659,   658,     0,     0,     0,   712,     0,   143,
       0,   527,  2065,     0,   473,   473,     0,     0,   958,   961,
       0,     0,     0,  2396,  2391,  2394,     0,  2384,  2398,  1393,
    1395,  1394,     0,  1392,     0,   334,   332,   333,   708,  1075,
       0,     0,     0,     0,   334,     0,     0,  2065,   334,  2065,
       0,  2065,     0,     0,   334,   334,     0,     0,     0,     0,
     640,     0,   796,   794,   793,   795,     0,     0,     0,     0,
       0,  2065,   334,     0,     0,   777,  2750,     0,     0,  2753,
       0,  2473,  1861,     0,  2839,  1348,  2836,     0,     0,  1424,
       0,   226,   227,   225,  1337,   228,  1338,  1334,  1320,     0,
     887,     0,  2843,  2844,   872,     0,   882,     0,  2843,   870,
       0,   883,   880,   881,     0,     0,     0,  2837,  2721,  2727,
     886,     0,     0,   474,   476,     0,     0,  2021,  2034,     0,
    2057,  2083,  2084,  2161,  2165,     0,  2188,  2197,     0,   910,
     939,   905,     0,     0,  1376,   877,   875,  1201,  1341,  1867,
       0,  1424,     0,     0,  1082,  1079,  1078,  1077,   244,   216,
       0,     0,     0,   941,  2160,  1216,   850,   565,     0,     0,
    1731,  1732,  1613,  1600,  1908,     0,     0,  1608,  1607,     0,
       0,     0,     0,     0,  1590,  1589,  1588,  1730,  1875,     0,
    1587,     0,     0,     0,     0,  1614,  1614,  1612,  1661,     0,
    1591,     0,     0,  1888,     0,  1894,     0,     0,     0,  1620,
       0,  1618,     0,     0,  1697,     0,     0,     0,     0,     0,
       0,     0,     0,  1645,  1646,  2678,  1728,  1861,     0,  1729,
    1956,     0,     0,  1606,     0,  1638,  1851,     0,     0,     0,
       0,  1921,     0,  1859,     0,     0,  1675,  1857,     0,  1677,
       0,     0,     0,  1850,  1848,  1849,  1842,  1843,  1844,  1845,
    1846,  1847,  1855,  1658,     0,  1932,     0,  1810,     0,  1657,
       0,  1495,  1426,     0,     0,  1954,  1911,     0,  2728,  2731,
    1724,  2602,  2601,  2600,  2599,  2570,     0,  2564,  2565,     0,
    2603,  2604,   260,   261,   257,     0,     0,   212,   211,     0,
     234,   235,   206,   233,     0,   229,   230,   214,  1799,  1798,
     213,   205,   202,   200,   217,   219,   220,   203,   201,   255,
     253,     0,     0,     0,  1913,  1912,  1944,  1917,     0,     0,
     334,  2505,  1299,     0,  1296,  1926,     0,  1421,     0,  1939,
       0,  1308,  1417,  1416,  1448,  1449,   976,  1415,  1473,  1474,
    1469,     0,     0,     0,  1488,  1486,  1465,  1459,  1464,  1462,
       0,  1466,  1641,  1481,  1405,  1453,  1454,  1457,  1404,     0,
    1484,     0,  1376,  1482,  1458,  1363,     0,     0,  1537,     0,
       0,  2513,  2511,  2451,  1566,  2505,  2444,  2505,  2500,  2432,
    1632,  1633,  1634,  1635,  1636,  1637,  2433,     0,  2430,  1631,
    2431,   545,   546,     0,     0,     0,  2399,     0,  2380,  2405,
    2536,  2645,  2568,     0,  2569,     0,     0,  2533,     0,  2543,
    2546,  2544,  2547,     0,  1566,  2724,  2619,  2724,  1566,   998,
    1000,     0,   999,     0,  1002,     0,  1011,     0,     0,   997,
    1016,     0,  1005,  1003,     0,     0,     0,     0,     0,     0,
     801,     0,     0,     0,     0,     0,     0,  2188,   248,  1263,
       0,     0,     0,     0,   943,   942,     0,     0,   963,     0,
       0,     0,  1277,   462,     0,   331,     0,     0,     0,     0,
       0,     0,     0,     0,   706,   703,     0,     0,   702,     0,
     578,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   614,
       0,  1132,     0,   647,     0,  1032,     0,  1031,     0,     0,
       0,  1033,  1028,  1029,  2161,  2169,  2193,   250,  1049,     0,
    1048,  1046,   986,     0,   987,     0,     0,     0,     0,     0,
    2044,   286,   299,     0,  1131,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   320,     0,   323,   322,
       0,     0,     0,     0,     0,   327,     0,     0,     0,   326,
       0,     0,     0,     0,     0,  1132,     0,   280,     0,     0,
       0,     0,     0,     0,  1062,     0,     0,   166,     0,   162,
     165,     0,     0,     0,     0,   530,   542,     0,   534,   535,
     532,   536,   537,     0,     0,     0,     0,     0,     0,   529,
       0,     0,   637,   636,   642,     0,     0,     0,     0,     0,
       0,     0,     0,  1085,  1084,     0,     0,     0,     0,     0,
       0,   745,     0,     0,     0,     0,     0,     0,     0,   169,
     650,   651,     0,   652,     0,   167,   168,     0,     0,     0,
       0,     0,     0,     0,   224,  1223,  1229,  1294,  1945,  1293,
       0,     0,     0,   837,     0,     0,     0,     0,     0,     0,
       0,   839,   840,   841,   842,     0,     0,     0,     0,     0,
     368,   369,   141,   367,     0,   734,  2679,   709,     0,  1566,
       0,  1562,  1558,  1627,  1626,  1625,     0,  1572,  1581,  1578,
     722,     0,   724,   727,     0,  1242,   435,     0,     0,   571,
     614,     0,   420,   174,     0,     0,     0,     0,   139,   185,
     187,   418,     0,   186,   188,   190,   191,   192,   189,   193,
     634,   638,     0,   567,     0,     0,     0,     0,     0,   660,
     664,   663,   667,   665,     0,   661,     0,     0,  1554,     0,
     161,     0,   523,   526,     0,  2377,     0,   420,   504,   345,
       0,   473,     0,     0,   960,     0,     0,     0,     0,     0,
    2397,     0,     0,     0,     0,  1391,     0,  1053,     0,  1270,
    2065,   334,     0,  1051,   179,  1967,     0,   778,     0,     0,
       0,     0,     0,  1055,   774,   171,     0,   334,   334,   570,
       0,   334,   173,     0,     0,     0,   562,   334,   798,  2751,
    2757,  2755,  1350,     0,  2840,  2834,  2835,   473,  1395,  1322,
    1333,   884,   891,   873,   890,   889,   871,   888,   885,  2535,
       0,     0,  2726,     0,   902,     0,   472,     0,     0,     0,
     916,   917,     0,     0,   915,   932,   918,     0,   920,   912,
     911,   921,   922,     0,     0,   941,     0,  1373,     0,  1371,
       0,  1535,  1375,  1364,  1342,     0,  1340,  1345,  1347,  1346,
    1344,     0,   517,     0,     0,   899,     0,     0,   334,  1215,
       0,   852,   853,   859,     0,     0,     0,     0,     0,   860,
     856,   857,   858,   861,   862,   863,     0,     0,     0,  1871,
       0,  1872,     0,     0,     0,  1907,  1903,     0,     0,     0,
       0,     0,     0,  1879,  1880,  1881,  1878,  1882,  1877,     0,
       0,  1883,  1876,     0,     0,     0,     0,     0,  1611,  1610,
       0,     0,     0,     0,     0,     0,     0,  1700,  1733,     0,
       0,  1835,     0,  1861,  1893,     0,     0,  1622,     0,     0,
       0,     0,     0,     0,     0,  1861,  1899,     0,     0,     0,
       0,  1797,     0,  1794,     0,     0,     0,     0,  1918,     0,
       0,     0,     0,  1957,  1642,  1659,  1931,     0,  1920,     0,
       0,  1643,  1666,     0,  1900,  1693,     0,  1698,  1681,     0,
    1674,     0,  1679,  1683,  1662,  1921,  1860,     0,  1858,     0,
       0,  1660,     0,  1655,  1653,  1654,  1647,  1648,  1649,  1650,
    1651,  1652,  1656,  1839,  1837,  1838,     0,     0,     0,  1818,
       0,     0,  1678,  2059,  2092,     0,  1438,  1438,  1438,  1425,
    1436,     0,  1549,  1930,     0,     0,     0,     0,  1734,     0,
    1865,  1447,  1863,  1947,  2733,  2732,  1919,     0,     0,     0,
    1936,     0,     0,  1638,     0,   254,  1533,  1914,     0,   804,
     805,   803,  1566,  1318,  1302,  1298,  1297,  1925,  1317,     0,
    1424,     0,   974,   975,     0,   979,     0,     0,  1467,  1489,
       0,  1480,     0,  1471,  1472,  1463,  1490,  1485,  1409,  1408,
       0,  1552,     0,     0,  1360,  1353,  1538,     0,  1495,  1378,
    1380,  1381,     0,  1918,  2449,  2507,  2454,  2475,  2445,  2478,
    1640,  2427,  2467,     0,  2401,  2571,  2572,     0,  2562,  2563,
    2532,  2538,  2609,     0,  2725,     0,     0,  1001,     0,  1581,
    1012,     0,   996,     0,   995,  1581,     0,  1013,     0,  1581,
       0,     0,     0,  1160,  1087,  1136,   802,  1161,  1088,  1137,
    1162,  1089,  1264,     0,  1266,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   685,
    2065,   334,  1275,  1163,     0,  1090,   330,  1276,  1138,  1280,
     705,   704,     0,     0,  1139,     0,   579,     0,     0,   584,
     585,   586,     0,     0,     0,   587,     0,  2003,  2051,     0,
     592,   599,   604,   594,     0,   605,   600,     0,     0,     0,
       0,     0,     0,   611,   613,     0,     0,     0,     0,     0,
       0,  1026,  1027,  1164,  1093,     0,  1140,   985,     0,  1094,
     175,     0,     0,   273,   287,   620,   685,  1134,   306,   319,
     314,   315,   313,  2065,   334,  2065,   334,     0,     0,     0,
       0,   316,   311,   312,   308,   321,  1980,  2036,  2170,     0,
     624,   626,     0,   631,   324,  1108,   341,   340,   339,     0,
     328,     0,   346,   349,   325,   304,   307,   305,   301,   285,
       0,     0,     0,     0,     0,     0,     0,  1943,     0,     0,
    1057,     0,     0,     0,   164,  1122,     0,     0,   150,     0,
       0,     0,     0,   144,   154,     0,  1170,  1098,     0,     0,
     277,   525,   533,   538,  1102,   541,  1150,   539,  1176,  1099,
       0,  1132,     0,   269,     0,  1100,     0,  1144,  1172,  1124,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1283,
       0,     0,     0,     0,     0,   334,     0,     0,     0,  1134,
    2065,   334,  1171,     0,  1129,  1158,     0,   354,     0,  1123,
       0,     0,   279,  1104,  1152,     0,     0,   222,   221,   223,
       0,     0,     0,     0,     0,     0,     0,     0,   844,   813,
     843,     0,     0,     0,   807,   390,   363,   364,   366,   373,
     733,     0,     0,     0,  1563,  1559,     0,     0,     0,     0,
       0,     0,  1579,   723,     0,     0,     0,     0,  1262,  1262,
    1262,  1262,  1262,  1262,  1262,  1243,  1273,     0,   141,     0,
       0,     0,   573,   613,   620,     0,     0,     0,   419,   423,
     427,   428,   429,     0,     0,     0,     0,   155,   142,     0,
     763,     0,   473,     0,   187,   180,     0,     0,     0,   345,
     720,   718,   717,   719,     0,     0,     0,   738,   716,     0,
    1553,  1555,     0,     0,     0,     0,     0,   422,     0,   476,
       0,     0,   508,     0,     0,     0,   345,     0,     0,   990,
       0,  1008,   991,     0,     0,     0,  1037,  1042,  1038,  1018,
       0,   550,  2395,  2389,  1396,  1397,     0,   334,     0,     0,
     615,   334,   334,     0,   334,     0,   334,   334,     0,  1198,
     641,     0,   693,     0,     0,   334,   776,  1862,     0,  2534,
    2722,   903,   475,     0,     0,     0,     0,   914,     0,   548,
     919,     0,   931,   926,   928,     0,   935,  1374,  1367,  1369,
    1368,     0,     0,  1365,  1868,   775,     0,   522,     0,     0,
     334,     0,   936,     0,   854,   855,     0,     0,   864,     0,
       0,  1443,  1869,  1870,     0,     0,     0,     0,  1904,     0,
       0,  1772,     0,  1748,  1750,  1580,  1762,     0,  1593,  1773,
    1774,  1752,  1754,     0,  1852,     0,     0,  1763,  1702,  1703,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1715,  1714,  1764,  1834,     0,     0,  1891,
    1892,  1765,  1623,  1624,  1624,     0,     0,  1898,     0,     0,
       0,  1770,  1775,     0,     0,     0,     0,  1781,     0,  1802,
       0,     0,     0,  1725,  1862,  1615,  1616,     0,     0,     0,
       0,     0,     0,     0,     0,  1699,  1682,  1676,     0,  1680,
    1684,     0,     0,     0,     0,  1668,  1694,  1664,     0,     0,
    1670,     0,  1695,     0,     0,     0,  1741,  1438,  1438,  1438,
    1438,  1435,     0,     0,     0,     0,  2158,     0,  1516,  1494,
    1496,  1503,  1516,  1521,  1743,  1547,  1744,     0,  1937,     0,
    1476,  1447,  1447,  1447,  1740,     0,     0,     0,  1446,  2584,
    2586,  2587,  2588,  2589,  2590,  2592,  2593,  2595,  2596,  2597,
    2585,  2591,  2594,  2598,  2575,  2576,     0,  2566,  2567,   198,
       0,   231,   218,     0,  2609,  1300,  1940,     0,  1450,     0,
    1853,   979,   977,   978,  1452,     0,     0,  1487,  1460,  1362,
       0,  1360,  1355,     0,  1356,  1918,     0,  1352,  1385,     0,
       0,  1552,     0,  1384,     0,  2509,  2437,     0,     0,  2608,
    2611,  2622,  2620,  2447,     0,  1581,   993,   994,     0,  1017,
       0,  1159,  1086,  1135,  1262,   946,   947,     0,   945,     0,
       0,     0,   461,   962,     0,     0,     0,   685,     0,     0,
     465,     0,  1278,     0,  1177,  1121,   581,   582,     0,   593,
       0,   602,   601,     0,     0,   589,     0,     0,     0,     0,
     588,   607,   554,   608,   610,     0,     0,   609,   612,   617,
    1132,     0,   648,  1110,     0,  1156,  1020,     0,   988,     0,
       0,     0,     0,   435,   300,     0,     0,     0,   288,   298,
       0,     0,   303,     0,   296,   317,   309,   318,   310,   628,
     629,   627,   623,     0,   630,   632,     0,   343,     0,     0,
       0,  1166,     0,  1132,     0,   281,  1106,     0,  1154,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1167,  1141,     0,     0,   147,   146,     0,   153,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   355,   336,     0,   741,     0,     0,     0,
     357,     0,     0,     0,     0,  1165,  1095,   808,     0,     0,
     809,   817,     0,     0,   810,     0,     0,   819,     0,     0,
     362,   370,   735,     0,  2114,  1842,  1843,   731,   736,   728,
     730,   729,   732,   685,     0,     0,     0,  1564,     0,  2823,
    2831,  2830,     0,  1638,   725,   726,     0,  1262,  1261,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     447,     0,     0,   441,     0,     0,  1042,   434,   437,   438,
       0,     0,   574,   577,   575,   576,   606,     0,   454,     0,
       0,   157,     0,     0,   158,   156,     0,     0,   345,     0,
     183,   418,     0,     0,   566,   666,   669,   662,     0,   737,
     739,   714,     0,   620,     0,     0,  1351,   517,     0,   504,
     500,   502,   501,   503,     0,   510,   344,     0,   517,   510,
       0,   963,   989,     0,     0,     0,  1035,  1039,  1036,     0,
       0,  1004,     0,  1019,   982,  1193,  1194,  1191,  1192,     0,
       0,  2412,  1387,  2421,  1054,     0,   334,  1052,   779,     0,
     770,     0,   772,  1056,   334,   334,   653,     0,   563,     0,
       0,     0,     0,   913,   933,     0,   929,     0,     0,   896,
     938,  1372,  1370,   515,     0,   941,     0,   897,   940,     0,
       0,     0,     0,     0,  1873,  1599,     0,  1906,  1902,     0,
    1745,  1874,     0,  1886,  1885,  1701,  1887,     0,  1720,     0,
       0,  1712,  1710,  1711,  1704,  1705,  1706,  1707,  1708,  1709,
    1713,  1896,  1895,  1889,  1890,  1619,  1617,     0,  1767,  1768,
    1769,  1897,  1776,     0,  1994,  1803,  1780,  1796,  1795,     0,
       0,     0,  1783,     0,     0,  1792,     0,  1836,  1605,  1638,
    1644,     0,     0,  1667,  1901,  1685,     0,     0,     0,  1663,
       0,     0,     0,     0,  1672,  1852,     0,     0,     0,     0,
    1821,  1816,  1817,     0,     0,     0,     0,  1429,  1428,  1434,
    1516,  1521,     0,  1411,     0,  1503,     0,  1515,  1501,  1514,
       0,     0,  1527,  1525,     0,  1527,     0,  1527,     0,  1498,
       0,  1517,  1499,  1514,  1546,  1539,     0,  1938,  1548,     0,
    1478,     0,     0,     0,     0,  1866,     0,  1864,  1735,     0,
       0,     0,  1915,  2607,  1422,     0,  1451,  1468,  1461,     0,
    1550,  1361,     0,     0,  1358,  2839,     0,     0,  1379,  1360,
    1382,  2453,     0,  2508,  2573,  2574,  1014,     0,     0,  1006,
       0,   952,   953,   951,   954,     0,     0,     0,   685,     0,
       0,   481,     0,   970,   970,     0,     0,   467,   513,  1042,
     688,     0,     0,     0,   686,   334,  1091,     0,   603,     0,
       0,   598,   596,   595,   597,   555,  1175,  1092,     0,     0,
       0,     0,  1021,     0,     0,  1109,     0,   432,     0,   293,
    1133,     0,     0,     0,   292,     0,   334,   334,   625,   342,
     347,   348,   351,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   764,   747,     0,     0,   765,
     766,     0,     0,     0,  1059,  1060,  1058,   151,   148,   149,
     152,  1119,  1103,  1151,     0,     0,  1101,     0,  1145,  1116,
    1112,     0,     0,     0,     0,     0,  1174,  1128,  1149,  1173,
    1126,  1147,  1125,  1146,  1127,  1148,  1120,     0,  1557,   744,
       0,     0,     0,   334,   334,   655,  1105,  1153,     0,   811,
       0,     0,   812,   814,   393,     0,   396,   403,   374,   379,
    1282,     0,  1282,     0,   376,   380,  1282,   375,  1282,   372,
     707,     0,     0,     0,  1560,     0,  2505,     0,     0,     0,
       0,     0,  1565,  1573,   684,     0,  1253,  1252,  1251,  1255,
    1254,  1257,  1256,  1248,  1247,  1260,  1259,  1246,  1245,  1250,
    1249,     0,   439,     0,   445,   449,   450,   448,   440,  1042,
     473,   512,     0,     0,   697,     0,   572,   420,   451,     0,
     424,   160,   159,     0,     0,     0,   187,     0,     0,   671,
     675,   715,     0,  1556,   649,   345,     0,   420,   517,  2378,
       0,   425,   430,   431,     0,   508,     0,   504,     0,     0,
     514,  1240,   518,   519,     0,     0,   992,  1009,  1010,     0,
       0,  1042,  1041,     0,   557,     0,  2385,   334,   616,   334,
     334,  1199,   694,     0,   925,   924,   923,   549,     0,   927,
     516,   334,     0,     0,     0,     0,     0,   866,   845,   865,
    1905,  1761,  1771,  1884,     0,     0,  1721,     0,     0,  1766,
    2261,     0,     0,     0,     0,  1800,  1801,  1782,     0,  2105,
    1787,     0,     0,     0,  1958,  1691,  1689,  1686,     0,  1687,
       0,     0,  1669,  1665,     0,  1671,  1696,  1807,     0,  1823,
    1820,  1433,  1432,  1431,  1430,  1502,  1500,     0,  1505,  1512,
       0,  1497,     0,  1526,  1522,     0,  1523,     0,     0,  1524,
       0,     0,  1512,     0,  1447,     0,     0,  1812,  1738,  1739,
    1736,  1447,  1955,  2577,     0,  2580,  2578,  2579,  2583,  1638,
       0,     0,  1354,  1357,  1359,     0,  1386,  1377,  2510,  1007,
    1015,  1268,     0,     0,     0,   463,     0,  1042,     0,     0,
       0,   973,   973,     0,  1042,   512,   690,   689,   692,   687,
     691,  1279,     0,   590,   591,  1111,     0,  1157,  1117,     0,
    1376,     0,   621,   289,   290,   291,   294,   336,   302,   295,
       0,     0,     0,  1107,     0,  1155,  1114,  1168,  1096,  1142,
       0,     0,   753,     0,     0,     0,     0,  1169,  1097,  1143,
       0,  1376,     0,     0,     0,     0,  1288,     0,   335,   743,
     742,   336,   356,  1130,     0,   815,   816,   394,   141,     0,
     371,     0,   401,     0,   399,   398,   400,     0,   387,     0,
       0,     0,     0,     0,     0,  1561,     0,  1073,  1073,  2824,
       0,  2825,  2826,  2827,  2828,  2829,     0,   685,  1258,     0,
       0,   436,   512,   480,     0,   442,     0,     0,     0,     0,
       0,     0,     0,   620,     0,     0,     0,   182,   420,   620,
     670,     0,     0,     0,   740,     0,   422,     0,  1349,   421,
       0,     0,   510,     0,   508,     0,   505,     0,   509,     0,
    1233,     0,     0,  1040,     0,  1044,     0,  1003,   980,  1549,
       0,   561,  2411,  2415,  1074,   771,   773,   654,   930,   937,
     334,   846,   847,   848,   849,  1716,     0,     0,     0,     0,
    1777,     0,  1778,  1805,  1804,  1784,  1788,     0,  1785,  1786,
    1688,  1692,  1690,  1673,  1809,     0,  1447,  1542,     0,  1545,
    1504,     0,     0,  1506,     0,     0,  1508,  1510,     0,     0,
       0,     0,     0,  1941,     0,  1475,  1477,     0,  1412,     0,
    2582,  2581,   232,  1854,  1551,  1383,   931,     0,   334,   970,
     512,   482,  2114,   483,   969,     0,   971,   976,   976,     0,
     512,   685,   583,     0,     0,   274,   619,     0,   338,   350,
       0,  1376,     0,     0,     0,   760,   748,     0,     0,   767,
       0,   270,  1113,     0,     0,     0,     0,     0,   334,   818,
     373,     0,   397,   406,     0,   404,   377,   382,     0,   386,
     384,   383,   378,   381,  1073,     0,  1070,  1069,  2832,   683,
       0,   471,   443,     0,   491,     0,     0,   698,     0,     0,
       0,   460,   459,   456,   455,   457,   458,   453,   452,   645,
     757,   345,  1240,   633,   672,   673,   668,     0,     0,     0,
     504,   500,   426,   435,   409,     0,   510,   506,   507,     0,
       0,     0,  1290,     0,   964,  1043,     0,     0,     0,   556,
       0,     0,   560,   551,     0,  2413,   898,  1717,     0,  1718,
       0,     0,     0,  1790,  1789,     0,  1826,  1547,     0,     0,
    1541,     0,  1513,  1529,     0,  1509,  1507,  1518,     0,  1520,
    1735,  1811,  1813,     0,  1737,   948,     0,   949,   973,   486,
       0,   972,   979,   979,   473,   685,   464,  1118,     0,   622,
       0,   297,     0,   282,  1115,     0,   751,     0,   762,   760,
       0,     0,     0,  1284,     0,  1285,  1286,  1289,   358,   361,
     392,   402,     0,   385,  1068,  1072,  1071,     0,     0,   444,
     477,   478,   479,     0,   446,   487,   488,     0,   695,     0,
     700,     0,     0,     0,     0,     0,  1234,     0,     0,  1240,
     508,   504,   433,   499,   407,     0,  1237,     0,   345,     0,
    1042,  1045,  1197,   559,   558,  2416,  2418,  2417,     0,  1719,
    1793,  1779,  1806,  1791,  1822,     0,     0,     0,  1540,  1543,
       0,  1511,     0,  1519,     0,     0,     0,   976,     0,   685,
       0,   967,   966,   480,   466,  1376,   337,     0,     0,     0,
     758,   761,   749,   762,   769,   768,  1376,     0,   405,     0,
     470,     0,     0,     0,   489,     0,   490,   511,     0,   699,
       0,   620,   756,     0,     0,   674,     0,  1235,   510,   508,
    1238,  1239,   510,   965,   981,  1196,  1195,  1424,  2414,  2226,
       0,  2199,     0,  1824,  1827,  1825,  1819,     0,  1528,  1814,
    1815,   334,   979,     0,   468,   484,   491,   275,  1376,     0,
       0,   750,   271,  1287,   675,   496,     0,   495,     0,   493,
     492,   696,   701,   646,   746,  1240,   678,   410,   510,  1549,
    1179,  1424,  1178,  1180,  1188,  1185,  1187,  1186,  1184,     0,
    1831,  1830,  1829,  1833,  1832,  1544,   950,   968,     0,   685,
     283,   752,   759,     0,   494,   498,   497,  1236,     0,   676,
     679,   682,   680,   681,   408,   955,     0,  1189,  1183,  1411,
    1398,     0,   485,   469,     0,   656,     0,  1181,  1424,  1828,
       0,   677,  1182,     0,   678,     0,   657
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4558, -4558,  3940, -4558, -1200,  -266,  2430, -1187, -4558, -4558,
   -4558,  1157, -4558, -4558, -4558, -4558, -4558, -4558, -4558,  3106,
   -4558, -4558,  1606, -2624, -4558, -4558,   -54,  3073, -1613,   -41,
    2701,  1276, -4558, -1402, -4558, -4558,  -881,    35, -4558,  3079,
     768, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -1097,
    1764,  1099,  3804, -3455, -4558, -4558, -1725, -3319, -4558,   479,
   -4558, -4558,  1700, -4558, -4558, -4558,   952,   403,  -548, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558,  -358, -4558, -4558,  -688,
     201,  -106, -2623,  -411, -4558, -4558,   349,  -414, -1626, -4558,
   -3675, -4558,   -92, -4558, -4558, -4558,  -392, -1729,  1191, -4558,
    -980, -1405,  1519,  -748, -4558,  -272, -4558,  -809,  -687,  -683,
    -749,  -566, -3851, -4275, -3899, -3338,  1211, -4558, -3802,   248,
   -4558, -4558,   263,   275, -4558, -4558, -1817, -1753, -4558,  -961,
   -4558, -4558, -4558, -3100, -4558, -4558, -4558, -4558,   -86, -4558,
   -4558, -4558, -4558,   387, -4558, -4558, -4558, -4558, -4558, -4558,
   -2706,  1668,  1671, -4558, -4558, -3339, -4558, -1192, -4558,   529,
   -3156,  1126, -4558, -4558, -4558,  2389, -4558, -4558, -4558, -4558,
   -4558, -4558, -1926, -4558, -4558,   281, -4558,  1681,   930, -4558,
   -4558, -4558,  -786,  -855,  -846, -4558, -3135, -4558, -4558, -4558,
   -4558,  -345, -4558, -4558, -4558, -4558, -4558, -4558, -1230, -4558,
     992, -3268, -4558, -4558,  1000, -4558, -4558, -4558, -4558, -4558,
    -736,  -275,  2414, -4558,  -619,  -712, -4558, -4558, -4558,  -274,
   -4558, -4558, -4558, -4558, -4558, -4558, -1355, 11447, -1873, -4558,
   -4558, -4558, -4558, -2474, -4558, -4558, -4558, -1949, -4558,  4206,
      14,   145,   291, -4558,  -188,  -105,  2943, -1425, -2818,   317,
    -438, -4558, -2078, -4558, -4558, -4558, -2717, -4558, -4558, -4558,
   -4558, -3615,   338, -4558,  2932, -4558,   370, -4558, -4510, -4081,
   -4363, -4020, -3621, -4558, -4558, -1363, -4558, -4558, -4558, -1742,
    1974, -2200, -4558, -2372,   366,  1275, -1250, -2938, -3875, -1037,
   -3383, -4558, -3826,  -542, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -1359,  -898, -4558, -4558,  3483, -4558, -4348, -4558, -4558,
   -4558, -4558,  1165, -4558, -4558, -1722,  1068, -4558, -4558, -4558,
   -4558, -4558,  -731,  -820, -4558, -4558, -4558,   367, -4558, -4558,
   -4558, -4558,  2153, -1237, -1009,  3316,   386, -3989, -4558, -4558,
   -4558, -4558, -3165, -4558, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -1992, -4558, -4558, -4558, -4558, -4558, -4558, -4558,  2088,
    2091,   -40,  -235, -4558, -4558, -1543, -4558,  -831, -4558,  2330,
   -4558, -4558, -4558, -4558,  1354,   395,   400,   -68, -4558, -4558,
     184, -3535,   -67, -4558, -4558, -4558, -4558, -2329,   -66, -4558,
     678, -4558, -4558, -2970, -4558,   415,   -74,  3011,  1611,   -62,
    1116,  -239,  -251,  -241,   -72,  3315,  2785, -4558, -4558, -4558,
    -182,  1854, -4558, -1120,  -346, -4558,  1359,  -936,  2061,  2764,
    2766, -4558,  1360, -4558, -4558,  1364, -4558, -4558, -4558,  -929,
    2070, -4558,  2771, -4558, -4558, -4558,  1347,  1357, -3523,   772,
   -3503, -3470,   260,   246, -1180,  -376,  -128,  3347,  2778,   779,
    -521, -4558, -4558,  -518, -4557,   709, -4558, -4364, -2509,  1085,
   -2185, -1887, -4558, -4558, -1446, 10837, -4558, -4558, -4558, 10926,
   13441, -4558, -4558, 17750, 18054, -4558, -1298,   825, 21455,  6469,
   -1471, -1915, -1564, 20563,  1256,   769, -2676, -4558, -3642, -2632,
   -4558, -4558, -4558,  -337,   835,   301, -4558, -4558, -4558, -4558,
   -4558, -4558,  -630, -4558,  -629, -4558, -4558, -4558,  -618, -3908,
   -1772, -4558,  -824, -4558, 21414,  1395, -4558, -1254, -2861, -2897,
   -3434, -2049, -4558, -4558, -4558, -4558, -4558, -4558, -4558, -1388,
   -3395,  -397,  1476, -4558, -4558,  1569, -4558, -4558, -4558, -1582,
   -1163, -2789,  1480, -2225, -4558, -1109, -4558,   730,  2208, -1073,
    4799, -1373, 17647,  -126, -2431, -1569, -1827, -4558,  1896, -4558,
    2844,  4633,  -925,  -159,  -917,  6609,  4583,  5589, -3242, -4558,
   -4558,   433, -4558, -4558, -4558,  3831,   985, -4558,  3124, -4558,
    1713,  2455, -4558, -4558,  2077,  -972,     3, -4558,  -593, -4558,
    -124, -4558, -4558, -4558,   159, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558, -4558, -4558,  2794, -4558, -4558, -1494, -4558, -4558,
   -4558, -4558, -4558,  4095,  -380, -4558,  3502,  -368, -4558, -4558,
   -4558, -4558, -4558, -4558, -4558, -4558, -4558,  2802,  2108, -4558,
    3302, -4558, -4558, -4558,   -34,  3040, -4558, -4558, -4558, -1231,
    -612,  3313,  3314,  2068, -4558, -4558, -4558, -4558, -4558, -4558,
   -4558, -4558,  2079, -4558, -4558,  1447, -2191,  2080, -4558, -4558,
     740, -4558, -4558,   271, -4558,   746, -4558,  2906, -4558, -4558,
   -4558,   784, -4558, -4558, -4558,  -592, 15073,    28,   -93,   -59,
     797, -4558,  9453,  6588,    58,  2815,   -69, 12597, 20359,   101,
   -4558,  4084,  2089,  1679, -1035, -4558,  3053,  2393, 18984, -4558,
   -1025,   276,  1834, -4558,    -2,  -667, -1221,  3108,  -765, -2013,
   -4558,  4501, -4558, -3627, -4558, -1067,   272,  3499, -1243
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,   247,   248,  1754,  2703,  2579,  3427,  3428,   249,
     250,  1829,   251,   252,   253,   254,   255,   256,   257,  1770,
     258,   259,  1323,  1983,  2713,   260,  2448,  1085,  1086,  1087,
    2303,  2304,  2645,  2305,  2292,  1604,  2085,  1789,  1051,  1052,
    1756,  1790,   262,   263,  1598,  2284,   264,   265,   266,  1816,
    1817,  1764,  2028,  4368,  5001,  3260,  2559,  3464,  3261,  3262,
     267,  1879,  1880,   268,   269,  3378,  1920,  2672,  3930,  3931,
    4399,   885,  2669,  4688,  4689,  4385,  4386,  4695,  4884,  4885,
    2714,  1979,  3458,  4019,  3418,  4470,  3419,  4471,  3420,  4472,
    3406,  3977,  3978,  3979,  3421,  4448,  4917,  3422,  2463,  5029,
    2748,  2115,  2113,  4904,  4260,  4261,  5089,  5034,  5035,  5036,
    5169,  4477,  3462,  4025,  4480,  4725,  3159,  2003,  3537,   985,
    2750,   916,   986,  2715,   274,  2742,  1849,  1850,  2587,  3937,
    3520,   275,  1342,  3801,  4771,  4952,  4953,   276,   873,   277,
    1987,   278,   279,  2699,  3412,   280,  2480,  3176,   281,   282,
    3203,  3204,  3205,   283,   284,  3823,  4641,  1818,  3249,  3250,
    3251,  3252,  3844,   285,  1985,  1855,  2722,   286,   287,   288,
     289,   290,  2632,   291,   292,  2716,  1995,  2734,  2735,  4460,
    4741,  4926,  4743,  5208,  5209,  4717,  3780,  4274,   294,   295,
    4443,  4444,  5041,   296,  2478,   297,   298,   299,  1963,  2691,
    2692,  3938,  1922,  2674,  2675,  4008,  4009,   300,  3338,   301,
    4325,  4326,   917,  5044,  5008,  5102,   302,   303,  4329,  4330,
     304,   305,   306,   307,   308,   973,  1395,  1396,  1746,   309,
    2320,   310,  1296,  3369,   311,  1484,  2887,  4518,   312,  1009,
    1420,  1421,  2717,   314,  1020,  2865,  1022,  2128,  3522,  3523,
    4079,  2834,  1211,   315,   316,  2845,  2868,   317,  1757,  2454,
    2455,  4255,  2718,   918,  2009,  2753,  3154,  4943,  4262,  4621,
    4847,  3065,  3724,   319,   919,  1794,  2523,  2756,  3470,  2426,
    2427,  2428,  4040,  2429,  3472,  2430,  1740,  2431,  3477,  3478,
    3479,  4036,  4044,  4765,  4766,   320,  1792,  2521,   321,   322,
     323,  1826,  1231,   324,   941,   942,   325,  4896,   326,  1361,
     327,  1041,  2145,   328,   329,  2536,  3830,   330,   331,   332,
    5182,  5216,  5217,  5218,  4049,  5137,   333,  5184,  1462,   335,
     336,   337,   876,  1262,  1263,  1264,  2719,  4760,   339,   340,
    2695,  3405,  3959,   341,   342,  2449,  3144,   343,   344,   345,
     346,  1967,   347,   348,   349,   350,  1899,   351,  1635,  1636,
     352,   353,   880,  1105,  1639,  1647,   354,   988,  1414,  1415,
    1416,  2087,   355,  1466,  2856,   989,  1409,   990,  3084,  3733,
    3734,  3737,   991,  3081,   359,  2134,  2850,  2853,   992,  3088,
    3089,  3090,  3091,  3092,  3739,   993,  1011,  1352,  2764,   994,
    1555,   364,   365,   366,  1114,  1109,  1110,   368,  2261,  3019,
    1028,  1653,  1070,  1121,  3688,  2334,  2335,  2357,  2358,  1662,
    1663,  2347,  2349,  3067,  2350,  3075,  2340,  4210,  4587,  2353,
    2354,  1665,  1666,  1667,  2362,   369,  3022,  3669,  3670,  3671,
    4187,  4188,  4202,  4198,  4574,  4816,  3672,  1456,  1673,  3673,
    4807,  4808,  4970,  4205,  3680,  3731,  3449,  3450,  3451,  2432,
    2682,  1945,  1556,  1946,  2689,  1557,  2180,  1948,  1558,  1559,
    1560,  1951,  1561,  1562,  1563,  1564,  2163,  2223,  1565,  1566,
    2199,  1153,  1154,  2072,  2926,  1568,  1569,  1570,  3675,  1571,
    4145,  4542,  4531,  2952,  2953,  2300,  4141,  3615,  2257,  3009,
    4828,  4981,  4982,  3656,  4171,  4559,  4806,  5077,  5143,  5144,
    1572,  3006,  2252,  1233,  1573,  3940,  2254,  2946,  3031,  3032,
    2140,  2161,  2892,  2909,  2910,  2923,  3576,  2930,  2935,  3599,
    3600,  2947,  2975,  1574,  2895,  2896,  3559,  2165,  1575,  1628,
    1629,  2270,  2970,  1642,  1643,  1107,  1576,  1577,  1578,  2129,
    1096,  4812,   726,   709,  3276,  2315,  1266,  1025,  1579,  1580,
    1581,  1370,  1371,  1695,   671,   710,   711,  1191,   823,     2,
      75,   995,  3456,   373,   374,   921,   922,   923,  1344,  1345,
    2014,  2017,  1700,  2398,   675,   676,   727,  4496,  4772,  4955,
     979,   375,   376,   377,   378,  1696,  2394,  1155,    76,    84,
      77,  1156,   415,   416,  2375,   379,   840,   380,  1676,  1135,
    3745,   381,   382,   383,   384,   385,   976,   386,  1137,   387,
    1138,   388,   389,   390,   391,  1145,   392,  1678,  1679,  4243,
    1680,   393,   394,   713,   714,  1407,   395,   396,  1172,  1173,
    1439,  1440,  1706,  1721,  1722,  1723,   397,   683,   398,   399,
     400,  1712,  1713,   401,  2277,  2278,  2403,  2279,   402,  3105,
    3106,   403,  3704,  3705,  4596,  3706,   404,  2273,   405,   406,
    1099,  3750,   407,   836,   408,  1186,   715,   716,   717,  1193,
     826,  1056,   728,  1195,  3253,   828,   829,   719,   720,   721,
    2107,    78,  3113,  2108,  1583,   729,  1584,  2268,  1585,  1586,
    1587,  1588,  1589,  1729,   723,  1162,  1399,  1400,  3114,  1402,
      82,  1403,   412,  3952,  2075,  1441,  2805,  2093,  2094
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      81,  1132,  1599,  1319,  1668,  2034,   367,  1113,  1013,   410,
     357,   358,   360,  1133,  2084,   410,   362,  2038,  2044,  1122,
    1674,  1062,   725,  1354,   824,  1621,  1897,   920,  1013,  2462,
     932,  1741,   731,  3077,  1232,  1380,  1831,  1448,  1449,  1450,
    2687,  2112,  2835,  1454,   915,  1392,  1098,  2317,  3540,  1854,
    1923,  2524,  2679,  1884,  2152,  3122,  3124,  2801,   825,  1353,
    1377,  2174,  2175,  1170,  3029,  2201,  1021,  1417,   878,   824,
    2532,  2647,  2739,  1613,   972,  3986,   411,  1232,  1034,  3417,
    2190,  2541,   411,   934,  2688,  3037,  3435,   680,  2555,  1977,
    3839,  3824,  3841,   367,  4043,  1095,  2599,   712,   874,  1997,
    4226,  3057,  3807,   825,  1063,  1965,   409,  2331,  2025,  1970,
    2891,  3335,   409,   261,  1974,   411,  1124,  3738,  1116,  1174,
    4004,  1980,  2382,  2384,  2385,   987,  1125,  3955,  3526,  3683,
    4483,  1999,  4263,  2793,  1232,   712,  1724,   824,  3278,  2609,
    3941,  2613,  2614,  1848,  4184,   409,  1726,  4029,  4297,  1863,
    4441,   926,  1412,  3941,  2073,  4257,   924,   931,  1889,  2317,
     411,  1354,  1084,  3681,  3682,  4491,   931,  1050,  4475,  3623,
    4201,   825,  2517,  2531,  1791,   827,  2440,  1092,  2074,  2069,
    3754,  1010,  2754,  4622,  2743,  1661,  2099,  2376,  2376,  3096,
     409,  1694,  1664,  3374,  1702,  1703,  4231,  1606,  2167,  2168,
    4752,  1010,  4199,  1165,  4123,   931,  1059,  4158,  2275,  3749,
    1401,   418,  4948,   884,  1059,  4469,  1059,  4820,   831,  4822,
     827,  2625,  1715,  2221,  2187,    45,  4482,  3121,   411,  3112,
    1996,  2542,  2227,  3116,  3960,  3961,  3962,  3963,  3964,  3965,
    2318,  3580,  1767,   414,  2026,  1716,  1187,    37,    38,    39,
      40,  3357,  4944,  2026,    44,   418,  1819,  2230,   409,  4848,
    1348,  2026,  3580,   831,   875, -1948, -1948, -1948, -1948,  2736,
    2620,  1103, -1948,  2328,  3430,  4034,  2534,  2968,    79,   270,
     418,  2132,  2846,    37,    38,    39,    40,  2232,   827,    43,
      44,  1486,  1717,  2968,    45,  2534, -1609, -1609, -1609, -1609,
    2218,   367,  4021, -1609,  3743,   357,   358,   360,  -395,  1058,
    2963,   362,   410,  4352,   418,  3803,   681,  1058,  1918,  1058,
    1894,  4405, -1614, -1614, -1614, -1614,   271,  3992,    45, -1614,
    4620,   831, -1624, -1624, -1624, -1624,  1258,  1480,  2534, -1624,
    3538,   272,  2076,  3145,  1768,  3674,  2607,   410,  3494,  3062,
    3496,  5135,  1603,   273,  2298,  1437, -1609,  4874,  2706,   293,
    4897, -1624, -1624, -1624, -1624,   130,   131,  2534, -1624,   313,
    3021, -2682, -2682, -2682, -2682,  3157,  1897,  2534, -2682,   411,
    2456,  3010, -1614, -1840,  2534,  1912, -2682,  4950,  5007,  3676,
   -1840,  2465,  2219,  2299,  3388, -1614, -1614, -1614, -1614,  2847,
    3753, -2103, -1614,   418,  3674,  1592,  3003,  1209,   261,   409,
    3185,  2227,    43,  3004,   411,  3146,   318,    45,  3557,  2266,
    1161,  2928, -2683, -2683, -2683, -2683,  1259,  2737,  3063, -2683,
    3158,    37,    38,    39,    40,  2928,  2230, -2683,    44, -2680,
   -2680, -2680, -2680,  4625,   409,   334, -2680,  1464,  3676, -1856,
    4629,  2458,  2468,  2045, -2680,  2086, -1856,  4978,  4875,  1232,
    1189,  2707,  3170,  2319,   338,  4353,  2232,  1260,  2026,  2459,
     935,  2201,  1133,   356,  1895,  3993,  1354,     3,  1758,  4936,
   -2679, -2679, -2679, -2679,  2174,  2175,  3012, -2679,  1310,  2554,
    1632,  2190,  1633,   361,  3385, -2679,  2027,  3059,  3808,  1354,
    3980, -2275, -2275, -2275, -2275,  2027,  2543,  3011, -2275,  2262,
     920,   372,  2062,  2027,  5136,  2867, -2275,  1261,  2544, -1581,
   -1581, -1581, -1581,   841,  4298,   417, -1581,  2130, -1594, -1594,
   -1594, -1594,   837,  1961,   838, -1594,  2679,  1175,  4951,  3804,
    5111,  1365,  2142,  2626,  2654,  1438,  5024,   682,  2133,  5133,
    3358,  2309,  2310,  2658,  1104,  2153,  1705,  1708,  1168,  1169,
    3129, -1621, -1621, -1621, -1621,   842,  1354,  3207, -1621,  2545,
      37,    38,    39,    40,   270,  1159,  2848,    44,  2738,  4687,
    1759,  4311,    37,    38,    39,    40,  3273,  2088,  2969,    44,
      37,    38,    39,    40,  2849,  4035,  1737,    44,  2460,  4250,
    2133,  2222,  2156,  1769,  3643,   246,   418,  3941, -2103,    37,
      38,    39,    40,  4722,  -141,    43,    44,  1486,  1717,  2621,
      45,   271,  5215,  -141,  1453,  5087,  4754,  1453,  -141,  2608,
    2167,  2168,  2064,  2068,   926,  1962,   272,  2317,  2187,   924,
    1166,  2036,  4267,  1007,  1008,  2595,  1711,  2597,   273,  4078,
    2293,  2650,  3066,  2251,   293,  2306,  2306,  3740,  3884,  2646,
    1210,  2276,  3592,  2604,   313,  4768,  4748,  4571,  4288,  1219,
    1896,  4575, -2103, -1945,  4464,  4315,  2503,  1825,  4201,  4455,
    3589,  3590,  3591,  3592,  2317,   931,   931, -2103,  3036,  1167,
    3388,  1354,  2894,  2677,  2461, -1840,  3580,  1437,  1626,  1354,
    1354,  1626,  1627, -1948,  4607,  1627,  2823,  3808,  2797,  4523,
    4565,   318,  1718,  1719,  2162,  1437,  5147,  1767,  3005,   936,
    2027,  1202,  3773,  4548,  1760,  2567,  1868,  2288,  4630,  2399,
    1634,  1465,  2363,  1161, -1609,  2469,  2196,  3171,  1246,  2364,
     334,  1311, -1399,   824,  2830,  1113,  1007,  1008,  2836,  3756,
    2838,  3757,  1418,  2841,  3376,  2520,  2197,  1761,  4988,   338,
   -1614, -1856,  3981,  2831,  1869,  2196,  1305,  3301,   356,   937,
    2198,   410,  2842,  2670,  2671,  5128,  1176,   825,  1669,  3208,
    4711,  4712,  4713,  4714,  4715,  2197,  1762,  2162,   361,  4217,
    1488,  4840,  4415,  3580,  1366,  1295,  2036,  1174,  4850,  2200,
     938,  4854,   939,  1905,  2832,  1350,   372,   839,  4400, -2682,
    4000,  5112,  1704,  3183,  2505,  1068, -1399,  1962,  1119,  1768,
    4248, -1402,  2511,  1363,  3029,  3029,  3029,  4992,  4993,  2248,
    2249,  2250,  2251, -1614,   411,  1692,  1693,  1419,   411,  1425,
    5191,  1430,  1198,  3274,  1763,  2806,  2069,  1434,  3708,  2813,
    4327,  1198,   680,  4934,  5178,  2816,   832,  1626,   680,  3256,
   -2683,  1627,  1683,  1124,   409,  1615,   833,  3714,   409,   680,
    1425,  1430,  3136,  1125,  1410,  4437,  2585, -2680,  3582,  2588,
    2589,  3098,  1001,  3098,  5025,  1198,  3917,  2918,  2919,  3920,
    3921,  3580,  2827,  3924,  1178, -1402,  3266,   680,   122,  3927,
    1455,   680,  1002,  3224,  2888,  2890,  2517,  1411,  1069,  3257,
   -2410,   367,   680,  3719,  2036,  2898,   126,  1870, -2679,  2902,
    2683, -2053,  1119,  1651,  1424,  4809,  1429,  2914,  2915,  2574,
    1161,  1351,   931,  5046,  3922,  3923,  1443,   831,   680, -2275,
    2932,  2934,  1198,  5165,  1413,  2263,  4234,  2655,  4328,  4963,
    4494,  2948,  1198,   680,  3581,  1458,  1460,  2173,   680,   977,
    1590,  3377,  1476, -1399,   730,   834,  2179,  5192,   680,  1445,
    1455,  3082,  1037,    81,   418,  3582,  4263,    37,    38,    39,
      40,  1406,   680,    43,    44,   931,  1126,  1147,    45,  3674,
    2599,  3674,  3409,  3258,  1988,  1001,  1795,  3198,  3527, -1621,
    1672,  3686,  1438,  1232,  2985,  1871,  1707,  2804,  2224,  1437,
    3939,  4438,  1423,  3471,  1428,  1002,  1652,  3862,  2746,  1753,
    2264,  5026,  1602,  3939,  1591,  2749,  1610,  1100,  3042,  4300,
    1631,  2833,  1989,  3676,  3583,  3676,  2470,  5054,  1718,  1719,
    1596,  1001, -1402,  1457,  1459,  1148,  -141,  -141,  2684,  4813,
    1038,  2839,  2840,  2219,  4817,  1146,  1906,  4819,  2828, -1399,
    5127,  1002,   879,  1127,  1637,  4810,  3184,  5152,  1198,  3529,
    3199,  5060,  1616, -2684,  1059,  1161,   680,   712,  1059,  5050,
   -2085,  3267,  1773,  2470,  1222,  1223,  1224,  2829,  1225,  1226,
    1227,  1228,  1229,  1230,  4788,   835, -1399,   411,  3674, -1399,
   -2410,  1684,  2456,  4041,  1198,  4211,  1488,  4911,  4043,  3580,
    2774, -2053,  3587,  3588,  3589,  3590,  3591,  3592,  2457,  3863,
    4263,  2785,  1147,  4615,  -799,  1446,  5166,   409,  3711,  4322,
    2986,  3198,  4964,  2792,  2987,  3126,  1617,  3259, -1402,  1150,
    4642,  2052,  3676,  1339,  1426,  2782,  4745,  3966,  1431,  1432,
    1433,  1476,  2928,  2928,  3410,  4912,  1117,  2928,  1444, -2410,
    2338,  4083,  4913,  1417,   680,   680,  3198,  5205,  2730,  4301,
   -2053,  4466,  2988,  2458,  4191, -1402,  1873,  1058, -1402,  2053,
    1148,  1058,  1874,  1149,  4870,  1990,  5207,   215,  3849,  4914,
    3969,  2459,  4858,  3528,   363,  5167,  1438,  2928,  2928,  1171,
    5129,  1050,  1858,  3850,  3199,  3584,  3585,  3586,  2747,  3587,
    3588,  3589,  3590,  3591,  3592,  1118,  2471,   223,  5168,  1232,
    2464,  3202,  4986,  1039,  1040,  2226,  4878,  4323,  2227,  5177,
    1332,  5189,  3411,  5179,  5134,  2019,  1745,  1755,  2685,  3199,
    1059,  1059,  3392,  4192,  3045,  2731,  3755,  2465,  2809,  2339,
    2512,    79,  3129,  2230,  4727,   233,  2012,  1128,  5052,  2231,
    1333,  4915,  4045,  3864,  3530,   886,  1198,  4606,   236,  3200,
   -2085,  4193,  4302,  1991,  1150,  4303,  -618,  1198,  1875,  5214,
    2746,   363,  1119,  2232,  2661,  2020,  4194,  4851,  3076,  1334,
     881,  3582,  2989,  2921,  2472,  4975,  3865,  2036,  4195,  4084,
    1960,  1340,  3201,  1488,  3083,  5206,  3580,  3587,  3588,  3589,
    3590,  3591,  3592,  5229,  4217,  1113,  3127,  4324,  3128,  4591,
    2460,  4196,  2662,  4720,  4755,  3866,  4809,  5099,  3973, -2085,
    5002,  2474,  2054,  1335,  2379,  2513,  4756,  1198,  1035,  4046,
    4814,  2475,  3320,  1058,  1058,  4584,   367,  2090,  3321,  2092,
    3583,  2414,  2096,  4958,  2098,  3202,  1341,  2101,  2102,  2103,
    4728,  4467,  1112,  1133,  3153,  3974,  5030,  1232,  4511,  2554,
    2110,  5091,  5092,  1151,  3825,  2021,   680,  3211,  1724,  3975,
    2466, -1581,  4859,  2135,  4902,  2136,  3329,  5100,  1726,  2234,
    3202,   680,  3293,  1152,  4919,    81,    81,  4197,    81,  1120,
    4923,  2380,  2332,  2333,  2324,  2337,  1198,  4594,  3941,  3491,
    2235,  2236,  1125,  1125,   680,  1125,  2461,  4263,  3346,  -963,
    2055,  3492,  1876,  3497,  1874,  2022,  2732,  4916,  1697,  5005,
    2383,  3223,  3101,  5010,  5011,  1027,  3796,   130,   131,  2733,
    4074,  4939,   898,  2036,  3322,  4379,  1001,  1727,  3293,  4940,
     680,  4382,  4383,  2341, -1581,  1877,  2239,  1715,  1837,  2381,
    3517,  3976,  3212,  1960,  1174,   680,  1002,  1406,  2683,  2240,
    4738,  4815,  3379,  4047,  3797,  2663,  3818,  3939,   680,  5031,
    1716,   680,  2476,  1123,  1878, -2104,  3029,  3300,  3582,   363,
    2342,  4757,  1198,  1697,   980,  3440,  3441,  3442,  3443,  2380,
     900,  2019,  4989,  4463,  1838,  4094,  2023,  3448,  1809,  3313,
    3715,  2711,  4995,   981,  3674,  2477,  3487,  4240,  3674,  1452,
    1875,  1198, -2684, -2684,  1150,  3587,  3588,  3589,  3590,  3591,
    3592,  5197,  1036,  4048,   824,  1147,    37,    38,    39,    40,
    3352,  1616,  1672,    44,  5032,   982,  1992,  3583,  2599,  1198,
    1198,  2808,  1198,  1150,  4251,  3826,  2227,  2381,  3676,   418,
    2280,  2281,  3676,  2664,  2089,  2255,  1993,  2091,   825,  2844,
    2095,  1198,  2097,    45,  1258,  2100,  1405,   418,  4067,  2104,
    3827,  2230,  4900,  1839,  2344,  2712,    35,   824,  3323,  3885,
    1657,   980,  3189,  1148,    41,    42,  2684,   712,   712,  1453,
    1258,  3220,  5045,  4941,  2267,  1617,   680, -1581,  2036,  2296,
     981,  2232,   410,   410,   680,   680,    37,    38,    39,    40,
    1476,  3324,  1828,    44,  1198,   411,  3302,  3798,  4499,  2534,
    4500,  1840,  4270,  1841,  3305,  2345,  3307,  2535,   907,  3555,
     908,  2021,   982,  2598,  2246,  2247,  2248,  2249,  2250,  2251,
    3325,  1150,   824,  1198,   418,   409,  1750,  1198,  1198,  1659,
    1067,  1001,   410,  1978,  1259,  2396,  1232,  3286,  2388,  2418,
    4949,  2389,  1843,    79,    79, -2104,    79,  4043,   411,   411,
     411,  1002,  2282,  3392,  2498,  2316,   825,  1150,  3607,  1751,
    1259,  2022,  1697,   208,  4780,  5180,   192,  1809,  2861,   680,
   -2131,  4999,   712,  3157,   205,  1260,  4271,  1851,   409,   409,
     409,  1845,  1994,  2538,  2708,  3799,  4996,  3287,  1752,  3632,
    4252,  1093,  3587,  3588,  3589,  3590,  3591,  3592,   831,   411,
     215,  1260,  2606,  2740, -2104,  4022,   411,  1960,  4026,  5132,
    1852,  3110,  2976,   411,  2977,  2283,  1847,  1830,  2572,  4253,
    1059,  -163,  4525,  3779,  4526,  1261,  1828,  2218,  3776,   409,
     223,  4272,  2390,  4273,  2539,  3531,   409,  2978,  4254,  3288,
    2590,  3466,  2023,   409, -1581,  3768,  -163,   215,  2036,  2602,
    2556,  1261,  5173,  1059,  3397, -1581,  2685,  2173, -1581,  1745,
   -1581,  1960,  1753,  3819,  4836,  4700,  4838,  2227,   233,  3882,
    4701,   205,   983,  2316,  3326,  1834,  2686,   223,  1106,  2928,
    2573,   236,  2928,  2928,  2928,  2928,  2928,  2928,  2928,  2928,
    2928,  2928,  2230,  1960,  4730,  2382,  4313,   215,  1612,  2557,
    3795,  2558,  4737,  3398,  3532,  1853,    80,  3327,  1835,  4435,
     841,  1354,  2928,  4702,  4747,   233,   831,   984,  4633,  4634,
    1753,  5064,  2232,  1058,  2227,   882,  3820,   223,   236,  3368,
    5094,  3289,  3883,  2979,  1755,  2554,  3328,  1755,  2980,   824,
    1115,  2928,  2928,  2981,  4731,  2227,  3519,  3481,  1354,  2230,
     680,  1883,   842,  4527,  4626,  -163,  1058,  1697,  1864,  4314,
   -2131,  3674,  1697,  1697,  5181,   233,  3674,  2591,  1064,  2592,
    1960,  3674,  4436,   825,  3674,  2769,  4685,  4686,   236,  2232,
    -163,  3687,  3399,  3400,  3505,  4732,  1755,  2659,  2450,  2676,
    1755,  1865,  1129,   679,  4270,  1866,  3401,  3787,  2451,  4285,
    2232,    37,    38,    39,    40,  3676,  1136,  1960,    44,   841,
    3676,  3052,  3674,  2452,   246,  3676,  3237,  4627,  3676, -2131,
    1867,  4268,  4077,  1133,  5154,    37,    38,    39,    40,  4107,
     411,  4108,    44,  2864,  3290,  1960,  5027,  3239,  2391,  2392,
    2534, -2474,  3291,  3402,  2660,  3292,  1962,  2341,  2540, -2684,
     680,   842,   841,  3330,  1753,  3689,  3676,   925,  3690,  3691,
     409,  4078,  2982,   943,  2410,  2412,   680,  3238,  4271,  3692,
    3693,  3694,  2983,  3695,  3696,  2851,  3029,   367,  3697,  3698,
    3699,  3029,  3331,  3809,  2342,  2811,  3029,  2812,  3240,  1026,
    2693,  2814,  1198,  2815,   842,  1742,  2817,     8,  1960,  4595,
    2818,  1198,  3709,   680,   680,  3829,  2235,  2236,  4413,  4005,
    1413,  3036,  4192,  1657,   680,  2863,  1608,  3634,  4014,  3635,
    1171,  1697,  4873,  4272,  3388,  4273,   680,   680,  1743,  1697,
    3403,  3744,  3404,   831,  5223,    81,  2343,  2286,    81,   367,
    4193,  2886,  3636,  2857,  2858,  2859,  2196,  2453,   680,  2860,
    4109,   898,  2239,  2306,  1177,  4577,  3674,  1744,  4289,  1657,
    4110,  3059,  3649, -1446,  1658,  2590,  2197,  4195, -1446,   363,
    1112,  4299,  4304,  5075,    37,    38,    39,    40,  2344,  3812,
    2198,    44,  1659,  1697,  4086,    35,  1697,  1697,  1198,    37,
      38,    39,    40,    41,    42,  1139,    44,  1354,  2196,  5076,
    3676,  4316,  4125,  4126,  2196,  4706,   824,  1626,  2079,   900,
    2080,  1627,  3674,  4073,  4924,  1140,  -521,  2070,  2197,  1660,
    3700,  2071,  1332,  3509,  2197,  1141,  1198,  1198,  1659,  2345,
    3332,  3036, -1446,  4707,  1198,   898,  1232,  1198,  2200,  2640,
     825,  1198,  4925,  3637,  3874,  3855,  2912,  2547,  3638,  1198,
    1198,  3068,  1333,  4090,  1697,  1205,  3676,  1198,  4104,  3333,
    1198,  1198,  1198,  1198,  1188,  1660,  4197,  2928,  4517, -1446,
    1198,  1198,  2641,  1198,  1747,  1198,  1198,  1242,  3982,  1198,
    4879,  4002,  4124,  2246,  2247,  2248,  2249,  2250,  2251,  2903,
    3765,  3766,  2591,   900,  2592,  1960,  1198,   411,   208,  4608,
    1123,  1198,  1243,  1203,  4544,  1198,  2434,  1748,   891,  1198,
    3720,  1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,
    1217,  1198,   410,  2576,  1142,  1335,  1256,   409,  1354,  4543,
    2059,  1198,  1198,  3147,  2271,  3150,  1749,  2272,  5151,  2435,
    2246,  2247,  2248,  2249,  2250,  2251,    35,   907,  3939,   908,
    2060,   843,  3701,  1637,    41,    42,  2904,  2966,  1218,  4473,
    4764,  3471,  3674,  4089,  3786,  4354,  3859,  3639,  2436,  -418,
     883,  3423,   913,  4920,  3085,   940,   410,  3640,   410,  3392,
   -1411,  4855,  4370,  2070,   974,  4355,  1143,  2800,   898,   411,
    3141,  1312, -1411,  1313,  1198,    35,   418, -1411,  3702,  3860,
     831,  2105,  4371,    41,    42,  3552,  3676,  -957,  1117,  2803,
      45,  2642,  4871,    79,  2905,  1248,    79,  2906,   824,   409,
   -1447,  2185,  2186,  2643,  2106, -1447,  4131,  3286,  3861,  2596,
    1299,   907,  2610,   908,  1065,  4191,  3877,  2372,  2373, -1411,
    4265,  4266,  3206,   411,  3553,   411,   900,  2644,  3554,  2928,
    2928,  1257,   825,  3674,  1144,  5227,  1978,  1944,  5228,   418,
     215, -1411,  4945,  1832,  1302,   680,  2556,  1118,  4697,  2556,
    4699,  1304,  -418,   409,  4703,   409,  4704,  3287,  1881,    43,
    1885,  1161,   215,    81,    45,    81,  2639,  3436,  1320, -1447,
     223,  1960,  3703,  3209,  1307,  1960,  1960,  3676, -1411,  2352,
      37,    38,    39,    40,  4192,   680, -1411,    44,  2907,   411,
     680,    45,   223,   680,  1327,  2557,  3445,  2558,  2557,  3284,
    2558,  3446,  3998,  2556,  3424,  1337, -1447,   824,   233,  3288,
    2556,   824,  4193,  -520,  1119,   680,    35,  1343,  1198,   409,
     925,   236,  1897,  1648,    41,    42, -1399,  4194,  3760,  1198,
     233,  2554,  3956,  2173,  2554,  2441,  1198,  3446,   192,  4195,
    1336,   825,  1354,  1338,  1354,   825,  4247,  1346,  3991,  2316,
    3994,  2173,  2557,  2441,  2558,   418,   680,   246,  1179,  2557,
    2954,  2558,  4196,  2957,   907,  4207,   908,  1059,  2372,  3094,
    1180,  1181,  1360,   680,   680,   910,  1364,  4388,  3983,   246,
    3985,  1960,  5003,  1372,   363,  4416,   912,  2908,  2554,  1978,
    1182,  1378,   831,  1183,  3606,  2554,  3608,  3609,   411,   680,
    2139,  3289,   411, -1411,  4409,  4410,  4411,  1354,  3720,  3275,
    1373,  4212,  4213,  4214,  4781,  4782,  4783,  4784,  4389,   215,
    1315,  3720,  1316,  2159,  1059,   246,   680,  3294,   409,  1387,
     680,  1120,   409,  1626,  1393, -1948,  4091,  1627,  4197,  2322,
    3425,  2323,  4390,  4038,  3722,  3723,  2556,  2577,   680,   223,
    2580,  2325,   975,  2326,   824,  3437,  2160,  4391,  2173,   680,
    1745,  4392,  3263,  4085,  1626,  3073,  3074,  1648,  1627,  2762,
    1058,  2763,   680, -1470, -1470,  2317,  2177,  1408,  4894,  3426,
    1447,  4393,   680,  3294,  4394,  2146,  2147,   233,   825,  2802,
      45,  2803,  3881,  1451,  1461,  2557,  4395,  2558,  1467,  2629,
     236,   831,  3036,  2636,  3290,   831,  2204,  1184,  1468,  2824,
    1488,  2825,  3291,  3580,  2826,  3292,  2825,  1473,  1475,  1697,
    2216,  2854,  3058,  2855,  3059,  1474,  1198,  1058,  1960,  2556,
    4151,  2554,  1476,  3217,  4832,  3218,   246, -1190,  1477,  1727,
   -1190,    79,  1478,    79,  1185,   411,  1479,  4504,  4505,  4506,
    3886,  3294,  1483,  1482,    35,   418,  3294,  1485,    37,    38,
      39,    40,    41,    42,    43,    44,  1297,  3914,  1611,    45,
    4375,  3280,  1618,  3281,  4396,   409,  1619,  3380,  2557,  3381,
    2558,  2173,  4397,  2441,  1113,  1614,  1620,  2556,  3294,  4290,
    1190,  3393,  1638,  3394,  4317,  1625,  3460,  4764,  3461,  1212,
    1645,  1646,  2928,  1960,  2556,  3407,   680,  3966,  3511,  1648,
    2825,  2928,  1649,  3967,  2554,  1655,  5157,  4398,  1670,  1123,
    1123,  1671,  1123,  3968,  1355,   943,  2556,  5162,  2928,  2928,
    3551,  2556,  2803,  1300,  1488,  1675,  2557,  3580,  2558,    37,
      38,    39,    40,   680,  1677,  3561,    44,  2803,   831,  1681,
    3969,  1198,  3970,  2557,  4152,  2558,  3565,  1685,  2803,    80,
    1682,  1686,  4492,  2290,    37,    38,    39,    40,  3569,  1690,
    2803,    44,  2554,  1161,  3570,  2557,  2803,  2558,  1699,  5200,
    2557,  3657,  2558,  3658,  3662,  3663,  3664,  1687,  1698,  2554,
    1358,   680,  1701,  1688,  1113,  3582,    74,  3596,  1731,  2803,
    1368,  1730,  3612,  1960,  2803,  3617,   824,  3618,  3659,  1689,
    3660,  2554,   824,  1697,   680,  1739,  2554,  1463,  1198,  1745,
    3842,  1697,  3843,  1697,  1198,  3847,  3971,  3848,  4032,  4532,
    4033,  4095,  4132,  2803,  4133,  1691,    37,    38,    39,    40,
     825,  1198,  1198,    44,  4419,  1733,   825,  1198,  1481,  4142,
    1934,  4143,  2226,  1766,  3583,  2227,  4154,  1593,  2803,  1771,
    2571,  1605,  1355,  1607,    37,    38,    39,    40,  4232,  4421,
    4233,    44,  1198,  1198,  2291,  1798,  4236,  1198,  4237,  4246,
    2230,  3128,  4269,  3972,  2825,  4402,  2231,  4403,  3973,  1198,
    1198,  1198,  1198, -1585, -1585, -1585, -1585,   411,  1833,  4465,
   -1585,  2825,  1198,   411,  4549,  1198,  2855,  1198,  1797,  4610,
    2232,  3128,  2927, -1592, -1592, -1592, -1592,  1198,  1198,  3582,
   -1592,  1198,  1654,  1793,  1656,  3974,  2950,   409,  4673,  4674,
    4617,  4676,  4618,   409,  1198,  4694,  1198,  2651,   367,  3975,
    1198,  4423,  2857,  2858,  2859,  4623,  1825,  2825,  2860,  1827,
     679,   679,  4624,  1828,  2825,  1728,  4690,  3613,  4691,  1198,
    4749,  1012,  4750,  3620,  2928,  4576,  4790,  4579,  4791,  1198,
    1836,  4473,  1198,  1198,  1198,  3720,  1859,  4792,  3583,  2803,
    4800,  1012,  2855,  4407,  4408,  4409,  4410,  4411, -1583, -1583,
   -1583, -1583,   680,  4709,  1860, -1583,  1198,  1882,  1872,  4735,
     831,  4856,  2696,  4857,  1886,  4921,   831,  2825,  4946,  1198,
    4947,  4959,  2233,  2855,  1198,  1891,  2234,  4451,  4452,  1892,
    1198,  3976,  4967,  1893,  4968,  3584,  3585,  3586,  1198,  3587,
    3588,  3589,  3590,  3591,  3592,  1898,  1900,  2235,  2236,  4407,
    4408,  4409,  4410,  4411,  4972,  1902,  3059,  4412,  4977,  1904,
    4012,  1741,  1908,  1914,  2237, -1586, -1586, -1586, -1586,  4979,
    1916,  4012, -1586,  1697,  4507,  2768,  1960,  1909,  5021,  1960,
    5022,  1960,  5053,  5058,  2285,  5059,  1960,  1919,   680,  1488,
    1921,  1924,  3580,  2239,  1753,  1966,  1962,  1692,  1693,  5069,
    1969,  2855,   677,   680,   680,  5070,  2240,  3618,  5071,  1198,
    2803,  1971,  1982,   824,   824,   824, -1584, -1584, -1584, -1584,
    5081,  1981,  3059, -1584,  1901,  5083,  -184,  4012,  2804,  5098,
     680,  2855,  5104,   680,  2855,  1907,  1960,  5105,  5119,  2855,
    5120,  5148,  5195,  3059,  4012,  1984,  1986,   825,   825,   825,
    5225,  5236,  5226,  5226,  1998,   363,  2000,  2006,  2008,  3584,
    3585,  3586,  2016,  3587,  3588,  3589,  3590,  3591,  3592,   859,
    2024,  2029,  2031,  2030,  2032,  2033,  1960,  2035,  2036,  2043,
    1014,  2046,  2047,  2048,  2242,  2049,  2051,  1355,  2056,  2057,
    2058,    80,    80,  2063,    80,  2010,  2077,  2111,  2141,  2148,
    1014,  2157,  2144,  2150,   411,   411,   411,  2151,  2158,  2166,
    1355,  2169,  2170,  2258,  2171,  2172,  2176,   363,   246,  2178,
    2181,  2182,  2183,  2184,  2189,  2191,  2192,  2256,   680,  2193,
    2194,  2195,  2260,  2202,   409,   409,   409,  1960,  2203,  1960,
     680,  2205,  2206,  2207,  1488,  2208,  2209,  3580,  2210,   680,
    2263,  4883,  2211,  2289,  2212,  2137,  4889,  4891,  2285,  2301,
    1437,   824,  2330,  2321,  4550,  1660,  2311,  4168,  1658,  2359,
    2361,  2369,  2964,  2371,  3582,  1150,  2378,  1355, -2684, -2684,
    1697,  2246,  2247,  2248,  2249,  2250,  2251,  4600,  2386,  2393,
    2395,  4825,  2397,  2406,  1960,   825,  2405,  2408,  2413,  2415,
    2437, -2626,  2417,  2438,  2473,  2439,  2441,   831,   831,   831,
    2974,  2444,  2442,   680,  2443,  2445,  2446,   920,  1488,  1960,
    2467,  3580,  4053,  2479,  2500,  2504,  2506,  2508,  4639,  2507,
    2509,  2525,  2510,  3583,  2526,  2527,  2537,  2547,  4551,  3933,
    1960,  2548,  2550,  2553,  2551,  2552,  2554,  2560,  2561,  2564,
    2220,  2562,   411,  1960,  4017,  2563,  2568,  2569,  2575,  2586,
    2225,  1232,  2578,  4028,  2582,  2583,  2593,   680,  1809,   680,
    2594,  2600,  1113,  2265,  2601,  2611,  2605,  2612,  2622,  4670,
    2623,   680,   409,   680,  4052,  2624,  4696,  2627,  1113,  2628,
    2652,  2634,  2638,  2653,  2665,  2667,  2668,  2680,  4971,  2678,
    2162,  2173,  1355,  2179,  2681,  2295,  2297,  2694,  4971,  2697,
    1355,  1355,  2693,  2698,  2701,  2702,   893,  1960,  2709,  2705,
    4723,  1853,  2724,  2744,  4824,  2729,  2745,  2752,  2755,  3582,
    1354,  4829,   680,  1960,  2757,  4173,  4174,  4175,  4176,  2758,
    2759,  2765,   363,  5023,  2776,  2820,  1960,  2778,  4880,   931,
    2780,  2794,  2779,  2781,  2795,   831,  4835,  2837,  2821,  2843,
    2852,  5006,   680,  2893,  5017,  2936,  5009,  2937,  2227,  2866,
    2899,  2949,  2894,  2955,  2960,  2973,  1198,  2967,  5013,   680,
    5015,  2990,  2959,   824,  2992,  3007,  3021,  3008,  3583,  3039,
    3041,  3038,  3049,  3050,  1118,   679,   680,  4961,  3044,   680,
    3046,  3070,  3069,  3582,  3584,  3585,  3586,  3061,  3587,  3588,
    3589,  3590,  3591,  3592,  3060,  1198,  3071,   825,  1960,  3072,
    3080,  3100,  3103,  2275,  3117,  1198,  3118,  3130,  3131,  3102,
    3120,  1198,  3132,  1198,  3143,  3148,  3153,  3151,  1960,  1198,
    3162,  3167,  1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,
    1198,  1198,  3155,  3156,  3172,  1198,  1198,  3173,  3175,  3182,
    3178,  5082,  3583,  1960,  3186,  3194,  3197,  1608,  1198,  3210,
    3215,  1612,  1198,  3265,   411,  3270,  1198,  3271,  3225,  3295,
    4883,  3279,  3282,  3283,  3334,  3337,  1198,  3348,  3355,  1198,
    3360,  1198,  3356,  3359,  3361,  3363,  3365,  3364,  2870,  1960,
    1198,  1198,  1198,  3367,   409,  3366,  1198,  3373,  3375,  1198,
    3384,  3389,  3390,  3382,  3387,  3388,  3395,  3415,  1697,  3429,
    3431,  3444,  3438,  1198,  3452,  1198,  3454,  3447,  3453,  3455,
    3463,  1697,  3465,  3468,  4137,  3480,  3483,  1198,  3484,  3485,
    4935,  3486,  3488,  1198,  1198,  2871,  4966,  2603,  3489,  3498,
    3501,  3504,  3503,  2927,  2927,  3513,  3514,  3515,  2927,  3584,
    3585,  3586,  3516,  3587,  3588,  3589,  3590,  3591,  3592,  3525,
    2867,  5074,  3533,  4337,  2872,  3536,  3059,   831,  2064,  3539,
    3518,  4843,  3541,  1453,  3544,  3545,  4860,  3547,  1198,  3548,
    3567,  3549,  3563,  3564,  1198,  2873,  3566,  3568,  2927,  2927,
    1198,  2803,  3602,  3614,  3571,  3572,  2874,  3574,  3633,  3577,
     824,  3595,  3628,  3601,  2673,   824,  1960,   824,  3603,  3685,
    3648,  3655,  3604,  4865,  3641,  3386,  2875,  3611,  3626,  3627,
    3679,  2876,  1198,  3584,  3585,  3586,  1354,  3587,  3588,  3589,
    3590,  3591,  3592,  3684,   825, -1003,  3730,  3727,  3736,   825,
    3651,   825,  3732,  3742,  3764,  1232,  5201,  3758,  3653,  3654,
    3748,  3767,  3769,   680,  3770,  3781,  3778,  3783,  3790,  3751,
    3805,  3746,  3806,  3817,  3747,  3752,  3774,  2877,  2720,    74,
    3816,  2070,  3775,  1697,  3821,  3822,  3720,  3831,  3833,  3846,
    3872,  3873,  3876,  3878,  3473,  3879,   824,  1232,  2878,  3880,
    1012,   411,  1012,  3889,  1012,  3887,   411,  1960,   411,  3888,
    1012,  1435,  1436,  1774,  3890,  3891,  3894,  3892,  3905,  3893,
    3897,  3895,  3896,  3898,  3899,  3900,  3902,  3907,  3909,  3901,
     825,   409,  2620,  1012,  1012,  3911,   409,  3919,   409,  3913,
    3925,  3926,  3929,  3944,  3945,  1775,  2389,  3957,  2226,  3953,
     680,  2227,  3999,   680,  3958,  3990,  3989,  3996,   859,  4001,
    4003,    80,  4012,  4011,    80,  4020,  3263,  4023,  4312,  4018,
    4027,  4024,  4050,  4069,  4059,  4030,  2230,  4061,  4070,  4080,
    2766,  4071,  2231,  4072,  4075,  2879,  4081,   411,  4082,  2772,
    4093,  2880,  4098,  3598,  3580,  3597,  2221,  2881,  4156,  2159,
    3534,  1776,  1119,  4182,   831,  4128,  2232,  4129,  4130,   831,
    4144,   831,  4209,  4228,  4136,  4157,  4169,   409,  4165,  4204,
    4249,  4256,  4206,  4220,  4218,  4481,  2882,  1198,  2883,  4190,
    4242,  4277,  4279,  1777,  4280,  4225,  4219,  4291,  4293,  4292,
    4221,  4305,  4224,  4294,  4318,  2884,  4319,  4387,  4320,  4321,
     680,   680,  4331,  4296,  1960,  4333,  1012,   680,  4332,  4344,
    4345,  4334,  3474,  4335,  4336,  4351,  4369,  4052,  3631,  1778,
    2885,  4367,  2911,  4300,  5093,  1720,  1212,  4378,  4372,  4380,
    4381,  4404,  4439,  4406,  4431,  4442,  4710,  4449,  4042,  2825,
     831,  1960,  1198,  1198,  4447,  4454,  4459,  4476,  1133,  1779,
    4462,  4478,  4458,  4461,  4493,  4479,  4490,  4489, -2684,  1014,
    4495,  1014,  2234,  1014,  4503,  4508,  4510,  4512,  4497,  1014,
    4513,  1012,  4514,  4515,  4524,  4516,  4533,  4534,  4613,  4535,
    4536,  4521,  4572,  2235,  2236,  4573,   680,  4529,  4528,  4580,
    4537,  4557,  1014,  1014,  4541,  4568,  4585,  4586,  4567,  2216,
   -2684,  4611,  5090,  4570,  1198,  4583,  4601,  4609,  4612,  4588,
    4589,  4590,  4605,  2974,   208,  1354,  4614,  4619,  3475,  4620,
    4628,  4651,  4650,  4652,  1783,  4643,  4644,  4663,  4672,  2239,
    4677,  1784,  3652,  4708,  4684,  1697,  4716,  4729,  3043,  2519,
    4666,  1198,  2240,  4705,  4724,  4734,  4736,  3668,  1786,  4740,
    4742,  1198,  1198,  4645,  1960,  4751,  1787,  4753,  4759,  1198,
    1198,  4761,  4762,  4770,  1198,  1960,  4778,  4786,  4787,  4789,
    1198,  1198,  4796,  4798,  1198,  4797,  1232,  1198,  4794,  4799,
    4602,  4805,  4811,  4818,  4821,  4877,   363,  4827,  4833,  4837,
    3578,  3579,  4849,  4853,  4852,  3594,  4867,  4862,  1198,  4876,
    4881,  4868,  1198,  4888,  4895,  4898,  3668,  4438,  1788,  1112,
    4903,  4905,  3476,   824,  1198,  1014,  4906,  4909,  4908,  1198,
   -2684,  2391,  2392,  4927,  1198,  4928,  4910,  4929,  4933,   677,
     677,  4931,  4937,  4954,  1725,  3629,  3630,  4938,  4962,  4965,
    4969,   679,  5000,  4974,  5028,  4980,  4984,   825,  4990,  4998,
      81,    74,    74,  5012,    74,  5033,  5037,  1728,  5038,    80,
    5040,    80,  5043,  5048,  5055,  5042,  4718,  1198,  5057,  5056,
    1012,  5062,  5068,  3788,  5085,  5086,  5072,  5063,  5080,  5084,
    1014,  5073,  5097,  5101,  5007,  1960,  5109,  5110,  5118,  5113,
    5115,  5088,  5123,  5124,  5130,  5131,  5107,  5160,  5164,  5146,
    5155,   680,  4170,  5153,   411,  5111,  5172,  5112,  5171,  5176,
    5190,  5204,  5221,  1960,  5224,  5230,  1774,  2246,  2247,  2248,
    2249,  2250,  2251,  1131,  2635,  3433,  1857,   680,  2308,  1796,
    3712,  1856,  1960,  5234,   409,  3269,  3828,  4310,  3347,   680,
    3928,  4384,  5019,  4882,  5108,  4930,  4932,   410,  1775,  4450,
    4918,  4721,   680,  3772,  3512,  5156,  4841,  5199,  1607,  5116,
    2927,  1697,  5114,  2927,  2927,  2927,  2927,  2927,  2927,  2927,
    2927,  2927,  2927,  5170,  3867,  5051,  3869,  3777,  3413,  4446,
    1960,  3414,  4308,  3840,  2721,  3396,  4007,  3177,  5203,  5235,
    5231,  3932,  4907,  4135,  1212,   680,  3954,  5174,  4866,  2704,
    5103,  5161,  4869,  1031,  1776,  4509,  2131,   831,  4985,  4486,
    2143,  4485,  3123,  3759,   411,  5061,  5183,  3908,  5232,  1622,
    2810,  3054,  2927,  2927,  3717,  3055,  4468,  4603,  4238,  3508,
    3718,  3904,  2078,  1644,  1356,  3079,  1777,  2356,  2355,  1198,
    2327,  3726,  3728,  3078,   409,  3741,  2360,  3729,  3473,  4185,
    1198,  4566,  4578,  4976,  4181,  1630,  3918,  5079,  2365,  5078,
    4239,  4148,  4960,  4138,  5149,  1012,  5150,  1774,  5145,  3721,
    1012,  1012,  1778,  3646,  3558,  3644,  4235,  1164,  4051,  1014,
    2018,  3023,  3482,  2761,  3104,  5138,  2377,  1134,  2370,  1404,
    3095,  3111,  1709,  1710,  3108,  3707,  3109,  4244,  1960,  1775,
    4593,  1738,  1779,  3370,  4245,  2374,  4597,  2274,  4223,  1157,
    3510,  3370,  2822,    83,  2138,  2067,  3115,  4604,  1442,     0,
     680,     0,     0,  2226,     0,     0,  2227,     0,    79,     0,
    1780,     0,  1198,     0,     0,     0,  1960,  4834,     0,     0,
       0,  1198,     0,  2228,  2387,     0,  1435,  1436,     0,     0,
       0,  2230,     0,     0,  3225,  1776,     0,  2231,  1198,  1198,
       0,     0,  1198,  1781,     0,  2402,     0,   208,  3439,     0,
       0,  1782,  2409,  2411,     0,  1198,     0,  1783,     0,     0,
    1198,  2232,   363,  4055,  1784,  1198,     0,  1777,  1198,     0,
       0,   363,  1785,  1198,  1198,     0,  3467,     0,     0,     0,
       0,  1786,  1355,     0,     0,     0,     0,     0,   824,  1787,
       0,     0,   363,     0,     0,     0,  3474,     0,     0,     0,
     680,     0,   680,  1778,     0,     0,  1198,     0,     0,  1012,
    2481,     0,     0,     0,     0,     0,     0,  1012,     0,  1355,
       0,     0,   825,     0,     0,     0,     0,     0,     0,     0,
       0,  1799,     0,  1779,     0,  4099,     0,  1800,  1960,   680,
       0,  1788,     0,  2482,     0,     0,     0,     0,  1198,     0,
       0,   370,     0,  1697,  1014,  4105,  2483,   370,     0,  1014,
    1014,     0,   673,  2233,  4922,     0,     0,  2234,     0,  2484,
       0,  1012,     0,     0,  1012,  1012,     0,  1801,     0,   411,
    4127,   680,     0,     0,     0,     0,     0,     0,  2235,  2236,
     370,     0,     0,     0,  1198,     0,     0,     0,   208,     0,
       0,     0,  1782,     0,     0,  2237,     0,  2485,  1783,   409,
       0,     0,   670,     0,     0,  1784,  2139,     0,  2486,     0,
       0,     0,     0,  2519,     0,     0,  1802,     0,  2927,     0,
       0,  2238,  1786,  1803,  2239,   370,  1804,     0,  2487,  4387,
    1787,     0,  1012,  2488,   677,     0,     0,  2240,     0,     0,
    1198,     0,  1960,     0,   824,     0,  3543,  2216,     0,     0,
       0,     0,  3546,     0,     0,     0,     0,     0,     0,     0,
       0,  4180,     0,  4183,  1198,  1960,     0,  1198,     0,  1198,
       0,  1054,   831,     0,     0,     0,     0,     0,   825,  1054,
    1805,  1054,  1788,     0,     0,     0,  3476,  4042,     0,     0,
       0,     0,  1198,   370,     0,     0,  1198,     0,     0,     0,
    2489,  1960,     0,     0,     0,     0,     0,     0,  1014,     0,
       0,     0,     0,     0,     0,  2242,  1014,  4106,     0,     0,
    4111,  4112,  4113,  4114,  4115,  4116,  4117,  4118,  4119,  4120,
       0,  2490,     0,     0,     0,   411,     0,  1806,     0,  1807,
    2760,  1960,     0,     0,     0,  1960,  1960,  5049,     0,  1808,
    4831,     0,     0,     0,     0,     0,     0,  1809,  1355,     0,
     859,     0,     0,     0,     0,   409,     0,  1810,     0,     0,
    1014,     0,     0,  1014,  1014,     0,     0,     0,     0,  4160,
    4161,     0,     0,     0,     0,     0,  1198,     0,     0,     0,
       0,    74,     0,  2491,    74,     0,     0,  3677,     0,  2492,
    2927,  2927,  2493,  1812,  1813,  1198,  1697,     0,  2243,  2244,
    2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,     0,
       0,     0,  5220,     0,     0,  1960,     0,     0,  2494,  1814,
       0,     0,  5067,     0,  2495,     0,     0,     0,   831,     0,
       0,  1014,     0,  1198,   370,     0,  1198,  2496,     0,     0,
       0,     0,     0,     0, -2189,     0,  3677,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2497,     0,     0,     0,     0,     0,  1198,   370,
       0,     0,     0,     0,     0,     0,     0,  1815,     0,  1355,
       0,     0,     0,     0,     0,  2900,  2901,     0,     0,     0,
     680, -2189,     0,  2913,     0,     0,     0,  2916,  2917,     0,
    1799,     0,     0, -2189,     0,     0,  1800,     0, -2189,     0,
       0,     0,  2938, -2189,  2939,     0,  1198,     0, -2189,     0,
       0, -2189,     0, -2189,     0,     0,     0,  1198,     0,     0,
       0,     0,  5175,     0,     0,   367,  2961,     0,  2962,  5185,
    5186,  5187,     0,  1198,  1198,  5188,  1801,     0,     0,     0,
   -2189,  4453,     0,   824,   680,     0,  3845,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1198,     0,     0,  3473,
       0,     0, -2189,     0,     0,     0,     0,     0,     0,   367,
       0,     0,     0,  5185,  5186,  5187,     0,   825,  1774,  5188,
    2402,     0,     0,  3875,     0,  1802,     0,     0,     0,     0,
       0,     0,  1803,   824,     0,  1804,     0,  1198,     0, -2189,
       0,   824,     0,   363,     0,     0,     0, -2189,     0,     0,
    1775,  1198,     0,     0,     0,     0,   367,     0,     0,     0,
    5185,  5186,  5187,     0,     0,     0,  5188,   825,     0,     0,
       0,     0,  3906,     0,   411,   825,     0,     0,     0,     0,
       0,     0,     0,     0,  1012,   363,     0,     0,  2050,  1805,
       0,     0,     0,     0,  3370, -2189,     0,  3370,  3370,  2065,
       0,  3370,     0,     0,   409,     0,  1776,  3370,     0,     0,
       0,     0,     0,     0,     0,     0,  3942,     0,     0,  1198,
       0,     0,  3951,     0,   411,  4434,     0,     0,  1198,  3942,
       0,     0,   411,     0,  5211,     0,     0,  1012,  1777,     0,
    1027,     0,  2139,  1355,     0,  1355,  1806,     0,  1807,     0,
       0,     0,     0,     0,   409,     0,     0,  1720,  1808,    74,
       0,    74,   409,     0, -2189,     0,  1809,  3474,     0,     0,
       0,     0,     0,     0,  1778,     0,  1810,   831,     0,     0,
       0,  4010,     0,     0,  5211,     0,     0,     0, -2189,     0,
   -2189, -2189,  5211,  2927,   844,     0,     0,     0,  2226,     0,
       0,  2227,  4793,     0,  1779,     0,  3668,  4037,  1355,  1811,
    3668,     0,  1812,  1813,     0,     0,     0,     0,  2228,  2927,
    2927,     0,     0,     0,     0, -2189,  2230,   831, -2189, -2189,
       0, -2189,  2231,     0,     0,   831,     0,     0,  1814,     0,
     845,    35,     0,     0,     0,     0,     0,     0,   363,    41,
      42,     0,     0,   846,     0,  2226,  2232,     0,  2227,     0,
       0,     0,  4632,     0,     0,     0,     0,     0,     0,   208,
     847,     0,     0,  1782,     0,  2228,   848,     0,  2229,  1783,
       0,     0,     0,  2230,     0,     0,  1784,     0,     0,  2231,
    4647,   849,     0,  1014,  2519,     0,  1815,     0,     0,     0,
       0,     0,   850,  1786,     0,     0,     0,  4545,  4546,  4662,
     851,  1787,     0,  2232,  1212,     0,     0,     0,     0,   370,
       0,     0,   852,   370,     0,     0,     0,   853,     0,     0,
       0,  1012,     0,   854,     0,     0,     0,   673,     0,  1012,
       0,  1012,     0,   673,     0,     0,  1014,     0,   855,     0,
     677,     0,  5212,     0,   673,     0,     0,  4681,  2233,     0,
       0,  4149,  2234,  1788,     0,     0,  1725,  3476,     0,     0,
       0,     0,     0,   856,     0,     0,     0,     0,     0,     0,
       0,     0,   673,  2235,  2236,     0,   673,  1213,     0,     0,
       0,     0,     0,  1236,   857,     0,     0,   673,     0,     0,
    2237,     0,  5212,     0,  1253,     0,     0,     0,     0,     0,
    5212,     0,     0,     0,     0,  2233,     0,     0,     0,  2234,
       0,     0,     0,   673,     0,   858,  2238,     0,     0,  2239,
    3391,     0,  1314,     0,     0,     0,  1321,     0,   673,     0,
    2235,  2236,  2240,   673,     0,  2241,     0,  1331,     0,     0,
       0,     0,     0,   673,   859,  2927,     0,  2237,     0,     0,
       0,  3677,     0,  3677,     0,     0,     0,   673,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   860,     0,  2238,     0,   861,  2239,   862,     0,     0,
       0,     0,     0,   863,     0,     0,   864,     0,     0,  2240,
       0,     0,  2241,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2139,     0,     0,     0,     0,     0,     0,
    2242,   865,   866,     0,   867,     0,     0,     0,   868,     0,
       0,     0,     0,     0,     0,     0,   869,     0,     0,     0,
    1014,   870,     0,  1799,     0,     0,     0,     0,  1014,  1800,
    1014,     0,     0,   871,  1216,     0,     0,     0,     0,  1054,
       0,   673,  1240,  1054,     0,     0,   872,   371,     0,     0,
    3677,  1255,     0,   371,     0,     0,     0,  2242,   674,  1265,
       0,  1012,   370,  3942,  1298,     0,     0,     0,  3668,  1801,
       0,     0,     0,  3668,     0,     0,  3668,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   371,  4338,     0,     0,
    4339,     0,  4340,  2243,  2244,  2245,     0,  2246,  2247,  2248,
    2249,  2250,  2251,     0,     0,  3047,     0,  2226,     0,     0,
    2227,  3048,     0,     0,     0,     0,     0,     0,  1802,     0,
       0,     0,     0,     0,     0,  1803,     0,  2228,  1804,   673,
     673,   371,     0,  3370,     0,  2230,     0,     0,     0,  3370,
    3370,  2231,  2673,     0,     0,     0,     0,     0,     0,     0,
    2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,
    4785,     0,  3951,     0,     0,  2232,     0,     0,     0,     0,
       0,     0,     0,  4418,  4420,  4422,  4424,     0,     0,   670,
     670,     0,  1805,     0,     0,     0,  4801,  4802,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   371,
       0,     0,     0,     0,     0,  1054,  1054,     0,     0,  2767,
    1774,     0,     0,     0,     0,     0,     0,     0,  2773,     0,
    1471,     0,  2777,     0,     0,     0,     0,     0,  2783,  2784,
       0,     0,   363,     0,     0,     0,     0,     0,     0,  1806,
       0,  1807,  1775,     0,  4484,     0,  2796,     0,     0,     0,
       0,  1808,  2139,     0,  1600,     0,     0,     0,     0,  1809,
       0,     0,     0,  2402,     0,     0,  3710,  2233,  1012,  1810,
    1014,  2234,     0,  1624,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3904,     0,
       0,     0,  2235,  2236,     0,  1650,     0,     0,  1776,     0,
       0,     0,  1861,     0,     0,  1812,  1813,  4519,     0,  2237,
       0,     0,     0,     0,  3668,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2139,     0,
    1777,  1862,  2139,  2139,  2226,  2238,     0,  2227,  2239,     0,
       0,   673,     0,     0,     0,     0,     0,     0,     0,     0,
     371,  2240,     0,     0,  2241,     0,   673,     0,     0,     0,
       0,     0,  2230,     0,     0,     0,  1778,     0,  2231,     0,
       0,     0,     0,  2226,     0,     0,  2227,     0,     0,   673,
       0,     0,     0,     0,     0,   371,     0,     0,     0,  1815,
       0,     0,  2232,     0,     0,     0,  1779,  1822,     0,     0,
       0,  2230,     0,     0,     0,     0,     0,  2231,     0,     0,
       0,     0,     0,     0,     0,   673,     0,     0,     0,     0,
       0,     0,  4957,     0,     0,   363,     0,     0,     0,  2242,
     673,  2232,  4592,     0,  4598,  4599,     0,     0,     0,     0,
       0,     0,     0,   673,     0,     0,   673,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    80,     0,     0,     0,
       0,   208,     0,  2518,     0,  1782,  3677,     0,     0,     0,
    3677,  1783,     0,     0,     0,     0,     0,  1014,  1784,     0,
       0,     0,  2226,     0,     0,  2227,  2519,     0,     0,     0,
    1973,     0,     0,     0,  2233,  1786,     0,     0,  2234,     0,
       0,     0,     0,  1787,  3051,     0,     0,     0,     0,     0,
    2230,     0,  2001,  2004,  2005,     0,  2231,     0,     0,  2235,
    2236,     0,  2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,
    2250,  2251,     0,  2233,     0,     0,  2237,  2234,  3573,     0,
    2232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1788,     0,     0,  2235,  2236,
       0,     0,  2238,     0,     0,  2239,     0,     0,     0,     0,
       0,   673,     0,     0,     0,  2237,     0,     0,  2240,   673,
     673,     0,     0,     0,  4679,  4680,     0,     0,     0,     0,
     370,     0,     0,     0,  3370,  3370,     0,     0,     0,     0,
       0,  1355,  3642,     0,  2239,  4698,  1012,     0,     0,     0,
       0,  3946,  3949,     0,     0,     0,     0,  2240,     0,  1012,
     363,  3951,  3951,  3951,  3951,  3951,     0,     0,     0,     0,
    1600,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0, -2684,   370,   370,   370,  2234,     0,     0,     0,
    3995,     0,     0,     0,     0,     0,  2242,     0,  1600,     0,
       0,     0,     0,     0,   673,     0,     0,  2235,  2236,     0,
       0,     0,     0,     0,     0,     0,  4744,  5219,     0,     0,
       0,     0,     0,     0, -2684,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   370,  2242,     0,     0,     0,     0,
       0,   370,     0,  4763,     0,     0,  2226,     0,   370,  2227,
       0,     0,     0,  2239,   670,  1054,     0,     0,  4726,     0,
       0,     0,     0,     0,   363,     0,  2240,  4519,  4519,  4519,
    4519,     0,     0,     0,  2230,     0,     0,     0,     0,     0,
    2231,     0,     0,     0,     0,     0,     0,     0,  1054,  2243,
    2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,
       0,     0,     0,     0,  2232,     0,     0,     0,     0,     0,
       0,  1012,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2243,  2244,
    2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,     0,
       0,     0,  2312,     0, -2684,   371,     0,     0,     0,   371,
       0,     0,     0,     0,     0,  1014,     0,     0,     0,     0,
       0,     0,     0,   674,     0,     0,  4162,     0,  1014,   674,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     674,     0,     0,  3677,     0,   673,     0,     0,  3677,     0,
    2366,     0,     0,  3677,  2226,     0,  3677,  2227,     0,     0,
       0,     0,     0,     0,  3942,     0, -2684,     0,   674,     0,
    2234,     0,   674,     0,  2228,     0,     0,     0,     0,     0,
       0,     0,  2230,   674,     0,     0,     0,     0,  2231,     0,
       0,  2235,  2236,     0,  3677,  2633,     0,     0,  3370,     0,
       0,  2246,  2247,  2248,  2249,  2250,  2251,  1355, -2684,   674,
       0,  4886,  2232,  4887,     0,     0,     0,  4892,  4893,     0,
       0,     0,     0,     0,   674,   370,     0,     0,     0,   674,
       0,     0,     0,     0,     0,     0,  4864,  2239,     0,   674,
       0,     0,     0,     0,     0,   673,     0,     0,     0,     0,
    2240,     0,     0,   674,     0,  3490,     0,     0,     0,     0,
       0,   673,     0,     0,     0,     0,     0,     0,  4241,     0,
       0,  3499,  3500,     0,     0,  3502,     0,  2528,     0,     0,
    1014,  3506,  1212,     0,  2546,  1799,     0,     0,     0,     0,
       0,  1800,     0,     0,     0,  2710,     0,     0,   673,   673,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   673,
       0,  2633,  2581,     0,  2233,  2584,     0,     0,  2234,     0,
       0,   673,   673,     0,     0,     0,     0,     0, -2684,     0,
       0,  1801,     0,     0,     0,     0,     0,     0,  3677,  2235,
    2236, -2191,     0,   673,     0,     0,     0,   674,     0,  2775,
       0,  2619,  3542,     0,     0,     0,  2237,     0,     0,     0,
       0,     0,     0,     0,     0,  2637,     0,     0,   371,     0,
       0,     0,  2633,  1012,     0,     0,     0,     0,   672,  2649,
    1802,     0,  2238,     0,     0,  2239,     0,  1803, -2191,     0,
    1804,     0,     0,     0,  3677,  5020,  1012,     0,  2240,     0,
   -2191,  2241,     0,     0,     0, -2191,   822,     0,     0,     0,
   -2191,     0,     0,     0,     0, -2191,     0,     0, -2191,     0,
   -2191,     0,     0,     0,     0,  2246,  2247,  2248,  2249,  2250,
    2251,     0,     0,     0,     0,   674,   674,     0,     0,     0,
       0,     0,     0,     0,  1805,     0,     0, -2191,     0,     0,
       0,   822,     0,     0,     0,     0,     0,     0,     0,  1435,
    1436,     0,     0,     0,     0,     0,     0,     0,  4401, -2191,
       0,     0,  3949,     0,     0,     0,  2242,     0,     0,  2741,
       0,     0,  1268,  4417,  5039,  2751,     0,     0,     0,     0,
       0,     0,   370,     0,     0,     0,     0,  1053,     0,     0,
       0,  1806,     0,  1807,     0,  1053, -2191,  1053,     0,     0,
       0,     0,     0,  1808, -2191,  1269,     0,     0,     0,   822,
       0,  1809,     0,     0,     0,     0,     0,     0,  1270,  1271,
       0,  1810,     0,     0,     0,     0,  1355,  1272,     0,     0,
       0,  1273,     0,     0,  3677,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2807,     0,  1274,     0,
       0,     0, -2191,     0,  1887,     0,     0,  1812,  1813,  2243,
    2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,  1275,
       0,     0,  1014,     0,   370,  3621,     0,     0,     0,     0,
    1276,     0,     0,  1888,     0,     0,     0,     0,  1277,  1012,
       0,     0,     0,  1600,  1600,  1014,     0,  1027,     0,     0,
    1278,     0,     0,     0,     0,  1279,     0,     0,     0,     0,
       0,     0,  2862,     0,  5126,     0,     0,     0,     0,     0,
       0, -2191,     0,     0,     0,  3677,  1280,     0,   370,     0,
     370,     0,     0,     0,     0,  3782,     0,   674,     0,     0,
       0,  1815,     0,     0,     0, -2191,     0, -2191, -2191,     0,
     673,  1281,   674,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2226,  5159,     0,  2227,     0,     0,     0,
       0,     0,  1282,     0,     0,   674,     0,     0,     0,     0,
    5213,     0, -2191,  2228,     0, -2191, -2191,     0, -2191,     0,
     673,  2230,     0,     0,   370,   673,     0,  2231,   673,     0,
     670,     0,     0,  1283,     0,     0,     0,     0,  3832,     0,
    3834,   674,     0,     0,     0,     0,     0,     0,     0,     0,
     673,  2232,     0,     0,     0,     0,   674,     0,     0,  3020,
    5213,     0,   859,     0,  2402,     0,     0,     0,  5213,   674,
    3133,     0,   674,     0,     0,  3137,     0,     0,  3140,     0,
       0,     0,     0,     0,  3040,     0,    74,     0,     0,  1284,
       0,   673,     0,  1285,  1012,  1286,     0,     0,     0,     0,
    3163,  1287,  1054,     0,  1288,     0,     0,     0,   673,   673,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3053,     0,  3056,     0,     0,  5233,     0,  1014,     0,
    1289,     0,  1290,   370,   673,     0,  1291,   370,     0,  3903,
       0,  3213,     0,     0,  1292,  3910,  1012,     0,     0,  1293,
       0,     0,     0,  2233,     0,     0,     0,  2234,  3219,  1054,
    1600,   673,     0,     0,     0,   673,  4660,  4661,     0,     0,
       0,  4664,  4665,     0,  1294,     0,     0,     0,  2235,  2236,
       0,     0,     0,   673,  3254,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   673,  2237,     0,   674,     0,     0,
       0,     0,     0,     0,     0,   674,   674,   673,     0,     0,
       0,  3285,     0,     0,     0,  3296,   371,   673,     0,     0,
       0,  2238,     0,     0,  2239,     0,     0,     0,     0,     0,
       0,  1012,     0,  3308,     0,     0,     0,  2240,     0,     0,
    2241,     0,     0,     0,  3318,     0,     0,     0,     0,     0,
       0,  3949,  3949,  3949,  3949,  3949,     0,  3342,     0,  1012,
       0,     0,     0,     0,     0,     0,     0,  3349,     0,   371,
     371,   371,     0,     0,     0,     0,     0,     0,     0,     0,
     370,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     674,  4054,     0,     0,     0,  4057,  4058,     0,  4060,     0,
    4062,  4063,     0,  1014,     0,     0,     0,     0,     0,  4068,
       0,     0,     0,     0,     0,  2242,     0,     0,     0,  2226,
     371,     0,  2227,     0,     0,     0,     0,   371,     0,     0,
       0,     0,     0,     0,   371,     0,     0,     0,     0,  2228,
       0,   673,     0,     0,  4087,     0,  3245,  2230,     0,     0,
       0,     0,     0,  2231,     0,  1014,     0,     0,     0,     0,
       0,     0,     0,  3272,     0,     0,     0,     0,     0,     0,
    2226,     0,     0,  2227,     0,     0,     0,  2232,   673,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2228,     0,     0,     0,     0,     0,     0,     0,  2230,     0,
       0,     0,     0,     0,  2231,     0,     0,     0,  2243,  2244,
    2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,     0,
       0,     0,  2958,     0,  2226,     0,   673,  2227,  2232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4830,     0,
    1014,     0,     0,     0,  2228,   822,     0,     0,  3062,   673,
       0,     0,  2230,     0,     0,     0,     0,     0,  2231,     0,
       0,     0,     0,   672,     0,     0,     0,     0,  1014,   672,
       0,   674,     0,     0,     0,     0,  3524,     0,     0,  2233,
     672,     0,  2232,  2234,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1012,     0,     0,     0,     0,  3524,
       0,     0,     0,     0,  2235,  2236,  3432,     0,   672,     0,
       0,     0,   672,     0,     0,     0,     0,     0,     0,     0,
       0,  2237,     0,   672,     0,     0,     0,  3063,     0,     0,
    2233,     0,   370,     0,  2234,     0,     0,     0,   370,     0,
       0,     0,     0,     0,     0,     0,     0,  2238,     0,   672,
    2239,   371,     0,     0,     0,  2235,  2236,     0,     0,     0,
       0,     0,     0,  2240,   672,     0,  2241,     0,     0,   672,
       0,   674,  2237,     0,     0,     0,     0,     0,     0,   672,
       0,     0,     0,     0,  2233,     0,     0,   674,  2234,     0,
       0,     0,     0,   672,     0,     0,     0,     0,  2238,     0,
       0,  2239,     0,     0,     0,     0,     0,     0,     0,  2235,
    2236,     0,     0,     0,  2240,     0,     0,  2241,     0,     0,
       0,     0,     0,     0,   674,   674,  2237,   673,     0,     0,
       0,     0,     0,     0,     0,   674,     0,     0,     0,     0,
       0,  2242,     0,     0,     0,     0,     0,   674,   674,     0,
       0,     0,  2238,     0,     0,  2239,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2240,   674,
       0,  2241,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1053,     0,   672,     0,  1053,
       0,     0,  2242,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1014,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   673,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   673,   673,
       0,     0,     0,     0,  2243,  2244,  2245,     0,  2246,  2247,
    2248,  2249,  2250,  2251,     0,     0,  2242,     0,  3943,     0,
       0,     0,     0,     0,     0,   673,     0,     0,   673,     0,
       0,     0,     0,  3761,     0,     0,     0,     0,     0,     0,
       0,  1955,     0,     0,     0,   672,   672,     0,     0,     0,
       0,     0,     0,     0,     0,  2243,  2244,  2245,     0,  2246,
    2247,  2248,  2249,  2250,  2251,     0,     0,  3064,  5065,  4100,
       0,     0,     0,     0,     0,  3784,     0,     0,     0,     0,
       0,     0,     0,     0,  3661,     0,     0,     0,   371,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   370,
     370,   370,     0,     0,     0,     0,     0,     0,     0,  2243,
    2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,
       0,  1053,  1053,   673,     0,     0,     0,     0,     0,     0,
    4498,     0,     0,     0,     0,   673,     0,     0,  4501,  4502,
       0,     0,     0,     0,   673,     0,     0,  1799,     0,     0,
       0,     0,     0,  1800,     0,     0,     0,     0,     0,     0,
    1957,     0,     0,     0,     0,     0,     0,     0,  2226,     0,
       0,  2227,     0,  3851,     0,     0,     0,     0,     0,     0,
     371,     0,     0,     0,     0,  3870,     0,     0,     0,     0,
       0,     0,     0,  1801,     0,     0,  2230,     0,     0,     0,
       0,     0,  2231,     0,  1955,     0,     0,     0,   673,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2232,     0,     0,     0,
       0,     0,     0,     0,   371,     0,   371,     0,     0,     0,
       0,     0,  1802,     0,     0,     0,     0,   370,     0,  1803,
       0,     0,  1804,     0,     0,     0,   674,   672,  3915,     0,
       0,     0,   673,     0,   673,     0,     0,     0,     0,     0,
       0,  2226,   672,     0,  2227,     0,   673,  5066,   673,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4163,     0,
    5210,  2228,     0,     0,     0,   672,   674,     0,     0,  2230,
     371,   674,     0,     0,   674,  2231,  1805,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1957,     0,     0,   674,   673, -2684,  2232,
       0,   672,  2234,     0,     0,     0,     0,     0,     0,     0,
    5210,     0,     0,     0,     0,     0,   672,     0,  5210,  4631,
    2294,     0,     0,  2235,  2236,     0,     0,   673,     0,   672,
       0,     0,   672,  1806,     0,  1807,     0,   674,     0,     0,
   -2684,     0,     0,     0,   673,  1808,     0,     0,     0,     0,
    4648,  4649,     0,  1809,   674,   674,     0,     0,     0,     0,
       0,   673,     0,  1810,   673,     0,     0,     0,     0,  2239,
       0,     0,     0,     0,     0,     0,     0,  2633,     0,   371,
     674,     0,  2240,   371,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4076,     0,  2501,     0,     0,  1812,
    1813,  2233,     0,     0,     0,  2234,     0,   674,     0,     0,
       0,   674,     0,     0,  4088,     0,     0,  4682,  4683,     0,
       0,     0,     0,     0,     0,  2502,  2235,  2236,     0,   674,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   370,
     674,     0,     0,  2237,     0,     0,     0,     0,  1955,     0,
       0,     0,     0,   674,  3987,  3988,     0,   672,     0,     0,
   -2684,     0,     0,   674,     0,   672,   672,     0,     0,  2238,
    3997,     0,  2239,     0,     0,     0,   822,     0,     0,     0,
       0,     0,     0,  1815,  4006,  2240,     0,     0,  2241,     0,
       0,     0,     0,  4015,     0,     0,     0,     0,     0,     0,
       0,     0,  1955,     0,     0,     0,     0,  4031,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   371,  1799,     0,   822,
       0,     0,     0,  1800,  1955,     0,     0,     0,     0,     0,
       0,  4774,     0,  4775,  4776,     0,     0,     0,     0,  2226,
     672,     0,  2227,     0,     0,  4779,     0,  2246,  2247,  2248,
    2249,  2250,  2251,  2242,     0,     0,     0,  2433,     0,  2228,
       0,     0,     0,  1801,     0,     0,     0,  2230,  1600,     0,
       0,     0,     0,  2231,     0,     0,     0,   674,     0,     0,
       0,     0,     0,     0,   822,     0,     0,     0,     0,     0,
       0,  1053,     0,     0,     0,     0,     0,  2232,     0,     0,
       0,  1955,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2433,  1802,     0,   674,     0,     0,     0,   673,  1803,
    1955,     0,  1804,     0,  1053,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1955,     0,
       0,     0,     0,  1957,     0,     0,  2243,  2244,  2245,     0,
    2246,  2247,  2248,  2249,  2250,  2251,   370,     0,     0,     0,
    4147,   370,   674,   370,     0,     0,  1955,     0,  4286,     0,
       0,     0,     0,     0,     0,     0,  1805,     0,     0,     0,
       0,     0,     0,     0,     0,   674,     0,     0,     0,     0,
       0,  4177,  4178,  4179,     0,     0,     0,     0,     0,  2233,
       0,     0,     0,  2234,     0,   673,     0,     0,   673,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1957,   672,     0,     0,  2235,  2236,     0,     0,     0,  1955,
       0,     0,     0,  1806,     0,  1807,     0,     0,     0,  2433,
       0,  2237,   370,     0,     0,  1808,     0,     0,     0,     0,
       0,     0,     0,  1809,     0,  4356,     0,  1957,  4359,     0,
       0,     0,     0,  1810,     0,     0,     0,  2238,   371,     0,
    2239,     0,     0,     0,   371,     0,     0,     0,     0,     0,
       0,     0,     0,  2240,     0,  1957,  2241,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2565,     0,     0,  1812,
    1813,   822,     0,     0,     0,   673,   673,     0,     0,     0,
       0,     0,   673,     0,  4956,     0,     0,     0,     0,     0,
       0,   672,     0,     0,     0,  2566,     0,     0,     0,     0,
       0,     0,  2226,     0,     0,  2227,     0,   672,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1957,     0,
    2226,     0,  2228,  2227,     0,     0,     0,     0,     0,     0,
    2230,  2242,  4456,   674,     0,     0,  2231,     0,     0,     0,
    2228,     0,  4987,     0,   672,   672,     0,     0,  2230,     0,
       0,     0,     0,  1815,  2231,   672,     0,     0,     0,  2226,
    2232,   673,  2227,     0,     0,     0,     0,   672,   672,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2232,     0,
       0,     0,  5018,     0,     0,     0,     0,  2230,     0,   672,
       0,     0,     0,  2231,     0,     0,  1955,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3524,     0,     0,     0,     0,     0,  2232,     0,   674,
       0,     0,     0,     0,  2243,  2244,  2245,     0,  2246,  2247,
    2248,  2249,  2250,  2251,   674,   674,     0,     0,  4227,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2226,
       0,     0,  2227,     0,     0,  4414,     0,     0,     0,     0,
       0,   674,  2233,     0,   674,     0,  2234,     0,     0,  2228,
       0,     0,     0,     0,  4440,     0,     0,  2230,     0,  4166,
    2233,     0,     0,  2231,  2234,     0,     0,  2235,  2236,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4457,     0,     0,  2237,  2235,  2236,  2232,     0,     0,
       0,     0,     0,     0,     0,  1957,     0,     0,     0, -2684,
       0,     0,  2237,  2234,     0,     0,     0,     0,     0,     0,
    2238,     0,     0,  2239,     0,   371,   371,   371,   822,     0,
       0,     0,     0,     0,  2235,  2236,  2240,     0,  2238,  2241,
       0,  2239,  3033,     0,     0,     0,     0,     0,     0,   674,
       0, -2684,     0,     0,  2240,     0,     0,  2241,     0,     0,
       0,   674,     0,     0,     0,     0,   673,     0,     0,   370,
     674,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2239,     0,  1955,     0,     0,     0,  1955,  1955,     0,     0,
       0,     0,   673,  2240,     0,     0,     0,     0,     0,  2233,
       0,     0,     0,  2234,   673,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2242,     0,     0,   673,     0,     0,
       0,     0,     0,     0,  2235,  2236,     0,     0,     0,     0,
       0,     0,  2242,     0,   674,     0,     0,     0,     0,     0,
       0,  2237,  4657,     0,     0,  5196,     0,     0,     0,     0,
       0,     0,     0,     0,  4667,     0,     0,     0,     0,     0,
     673,     0,  4561,  4562,  4563,  4564,     0,  2238,     0,     0,
    2239, -2684,     0,   371,     0,     0,     0,     0,     0,   370,
       0,     0,     0,  2240,     0,     0,  2241,     0,   674,     0,
     674,     0,  1955,     0,     0,     0,   672,     0,     0,     0,
       0,  3119,   674,     0,   674,  2433,  3125,  2243,  2244,  2245,
       0,  2246,  2247,  2248,  2249,  2250,  2251,     0,     0,     0,
       0,  4258,     0,     0,     0,  2243,  2244,  2245,     0,  2246,
    2247,  2248,  2249,  2250,  2251,     0,   672,     0,     0,  4522,
     822,   672,     0,     0,   672,     0,     0,     0,     0,     0,
       0,     0,     0,   674,     0,     0,     0,     0,     0,     0,
       0,  2242,     0,     0,     0,     0,   672,     0,  2246,  2247,
    2248,  2249,  2250,  2251,  2226,     0,     0,  2227,     0,     0,
       0,  1799,     0,   674,     0,   673,     0,  1800,     0,     0,
       0,     0,     0,     0,  2228,     0,     0,     0,     0,     0,
     674,     0,  2230,     0,     0,     0,     0,   672,  2231,  2226,
       0,  1957,  2227,     0,     0,     0,     0,   674,  1053,     0,
     674,     0,     0,     0,   672,   672,     0,  1801,     0,  2228,
       0,     0,  2232,     0,     0,  3524,     0,  2230,     0,  1955,
       0,     0,     0,  2231,  2226,     0,     0,  2227,     0,   822,
     672,     0,     0,   822,  2243,  2244,  2245,     0,  2246,  2247,
    2248,  2249,  2250,  2251,  2228,     0,     0,  2232,  4556,     0,
       0,     0,  2230,     0,     0,  1053,  1802,   672,  2231,     0,
       0,   672,     0,  1803,     0,   673,  1804,   673,     0,     0,
       0,     0,     0,     0,     0,   371,     0,     0,     0,   672,
       0,     0,  2232,     0,     0,     0,     0,     0,     0,     0,
     672,     0,     0,     0,  1955,     0,     0,     0,     0,     0,
       0,     0,     0,   672,   673,     0,     0,     0,     0,     0,
       0,     0,     0,   672,  2233,  3524,     0,  3524,  2234,  1799,
    1805,     0,     0,     0,     0,  1800,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1957,  2235,
    2236,     0,     0,     0,   370,     0,   673,     0,     0,  2233,
    1837,     0,     0,  2234,     0,     0,  2237,     0,     0,     0,
       0,     0,  4769,     0,     0,  1801,     0,     0,     0,     0,
       0,     0,     0,     0,  2235,  2236,   822,  1806,     0,  1807,
       0,     0,  2238,     0,  2233,  2239,     0,     0,  2234,  1808,
       0,  2237,     0,     0,  1955,     0,  1838,  1809,  2240,     0,
       0,  2241,     0,     0,     0,     0,     0,  1810,     0,  2235,
    2236,     0,     0,  2433,  1802,     0,     0,  2238,     0,     0,
    2239,  1803,     0,     0,  1804,     0,  2237,     0,     0,     0,
       0,     0,     0,  2240,     0,     0,  2241,   672,     0,     0,
    3222,     0,     0,  1812,  1813,     0,     0,     0,     0,     0,
       0,     0,  2238,     0,     0,  2239,     0,     0,     0,     0,
       0,     0,     0,     0,   674,     0,     0,     0,  2240,  1814,
       0,  2241,     0,     0,   672,  1839,  2242,     0,  1805,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   371,     0,     0,     0,     0,   371,     0,   371,
     370,  2242,     0,  1957,     0,     0,     0,     0,     0,     0,
       0,     0,   672,  1840,     0,  1841,     0,  1815,     0,     0,
       0,     0,     0,     0,     0,  1842,     0,  1807,     0,     0,
       0,     0,     0,     0,     0,   672,  2242,  1808,     0,     0,
       0,   674,     0,     0,   674,  1809,     0,     0,     0,     0,
       0,     0,     0,     0,  1843,  1810,     0,     0,     0,  2243,
    2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,
       0,     0,     0,  4795,     0,  4899,     0,     0,   371,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1844,     0,
       0,  1812,  1813,  1845,  2243,  2244,  2245,     0,  2246,  2247,
    2248,  2249,  2250,  2251,     0,     0,     0,   718,  4804,     0,
       0,     0,  1600,     0,     0,     0,     0,  1846,   822,     0,
       0,     0,     0,     0,   822,     0,     0,     0,  1847,  2243,
    2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,
       0,   674,   674,  4839,     0,   718,     0,  1955,   674,     0,
    1955,     0,  1955,     0,     0,     0,     0,  1955,     0,     0,
       0,     0,     0,     0,     0,   673,   718,     0,     0,     0,
       0,     0,  3033,  3033,  3033,  1815,     0,     0,     0,     0,
       0,     0,     0,     0,  1023,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1024,     0,     0,
       0,     0,     0,     0,     0,  1032,     0,  1955,  4994,     0,
       0,     0,     0,   672,     0,     0,     0,     0,     0,     0,
    1043,     0,  1023,     0,     0,     0,  1066,   674,     0,   673,
       0,     0,     0,     0,     0,     0,  1097,     0,     0,     0,
       0,     0,     0,     0,  1102,     0,     0,  1955,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2433,     0,     0,  3125,
       0,  3125,     0,     0,     0,     0,  2433,  2226,     0,  3524,
    2227,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2226,     0,   672,
    2227,     0,     0,     0,     0,  2230,     0,     0,  1955,     0,
    1955,  2231,     0,     0,   672,   672,     0,  2228,     0,   370,
       0,     0,     0,     0,     0,  2230,  1957,     0,     0,     0,
       0,  2231,     0,     0,     0,  2232,     0,     0,     0,     0,
       0,   672,     0,     0,   672,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2226,  2232,     0,  2227,     0,     0,
       0,     0,     0,     0,     0,  1955,  2433,     0,     0,   370,
       0,     0,  1799,     0,  2228,     0,     0,   370,  1800,     0,
       0,     0,  2230,     0,     0,     0,     0,     0,  2231,     0,
    1955,     0,     0,     0,     0,     0,     0,  4554,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1955,  2232,     0,     0,   822,   822,   822,  1801,     0,
       0,     0,     0,     0,  1955,     0,     0,  1957,     0,  1957,
       0,     0,     0,     0,     0,     0,     0, -2684,     0,   672,
       0,  2234,   674,     0,     0,   371,     0,     0,     0,     0,
       0,   672,     0,     0,     0,     0,     0,  2233,     0,     0,
     672,  2234,  2235,  2236,     0,     0,     0,  1802,   674,     0,
       0,     0,     0,     0,  1803,     0,     0,  1804,     0, -2684,
     674,     0,  2235,  2236,  1957,     0,     0,     0,  1955,     0,
       0,     0,     0,   674,     0,     0,     0,     0,     0,  2237,
       0,     0,     0,     0,  1955,     0,     0,     0,  2239,  1957,
       0,     0,     0,     0,  2233,     0,     0,  1955,  2234,     0,
       0,  2240,     0,     0,   672,  2238,     0,     0,  2239,     0,
    3125,  1805,     0,     0,     0,     0,   674,     0,     0,  2235,
    2236,  2240,     0,  3125,  2241,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   371,  2237,     0,     0,     0,
       0,     0,     0,   822,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   672,     0,
     672,     0,  2238,     0,     0,  2239,     0,     0,  1806,  1955,
    1807,     0,   672,     0,   672,     0,     0,     0,  2240, -2684,
    1808,  2241,     0,     0,     0,     0,     0,  1957,  1809,  1955,
       0,     0,     0,     0,     0,     0,     0,     0,  1810,  2242,
       0,     0,     0,  3125,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1955,     0,  1957,     0,     0,     0,
       0,     0,     0,   672,     0,     0,     0,     0,     0,   718,
       0,  3311,     0,     0,  1812,  1813,     0,     0,     0,     0,
       0,   674,     0,     0,     0,     0,     0,     0,     0,     0,
    1955,     0,     0,   672,     0,     0,  2242,     0,     0,     0,
    3312,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     672,     0,     0,     0,     0,     0,  2246,  2247,  2248,  2249,
    2250,  2251,     0,     0,     0,     0,     0,   672,  1957,     0,
     672,     0,  2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,
    2250,  2251,     0,     0,     0,     0,  4901,     0,  1957,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1815,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1957,     0,     0,     0,     0,     0,     0,
       0,   674,     0,   674,     0,     0,     0,     0,     0,  2243,
    2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,  2226,
       0,     0,  2227,  5125,     0,   822,  1799,  1955,     0,  1957,
    2226,     0,  1800,  2227,     0,     0,     0,     0,     0,  2228,
     674,     0,     0,     0,     0,     0,     0,  2230,     0,     0,
    2228,     0,     0,  2231,     0,     0,     0,     0,  2230,     0,
       0,     0,     0,     0,  2231,     0,     0,     0,     0,     0,
       0,     0,  1801,     0,  3033,     0,     0,  2232,     0,     0,
     371,     0,   674,     0,     0,     0,     0,     0,  2232,     0,
       0,     0,     0,     0,     0,     0,     0,  1194,  1200,  1200,
     718,     0,  1200,     0,  1208,     0,  1194,     0,  1097,     0,
       0,  1234,     0,     0,     0,     0,  1097,     0,  1955,  1097,
       0,  1802,     0,  1200,     0,  1097,     0,     0,  1803,     0,
       0,  1804,     0,  1267,     0,     0,     0,     0,  1097,     0,
    1194,     0,     0,  1200,     0,   718,  2433,  1200,     0,     0,
       0,     0,     0,     0,  1234,     0,     0,  1324,     0,     0,
       0,     0,     0,     0,  1200,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2233,
       0,     0,     0,  2234,     0,  1805,     0,     0,     0,     0,
    2233,     0,     0,     0,  2234,     0,     0,  1194,     0,     0,
       0,     0,   718,     0,  2235,  2236,     0,  1194,     0,     0,
       0,  1234,     0,     0,   672,  2235,  2236,     0,     0,     0,
       0,  2237,     0,     0,     0,     0,  1200,     0,     0,     0,
       0,     0,  2237,     0,     0,     0,     0,  3125,     0,     0,
       0,     0,  1806,     0,  1807,     0,   371,  2238,     0,     0,
    2239,     0,   822,     0,  1808,     0,     0,   822,  2238,   822,
       0,  2239,  1809,  2240,     0,  1955,  2241,     0,     0,     0,
       0,     0,  1810,     0,  2240,     0,     0,  2241,     0,     0,
       0,  1097,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1097,  1472,     0,     0,     0,     0,
       0,   672,  1955,     0,   672,  3350,     0,     0,  1812,  1813,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2226,  1582,     0,  2227,     0,   718,  1097,     0,
       0,     0,     0,     0,  3351,     0,     0,     0,   822,     0,
       0,  2242,  2228,     0,     0,     0,     0,  1097,     0,     0,
    2230,  1097,  2242,     0,     0,     0,  2231,     0,     0,  1582,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1097,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2232,  1097,     0,     0,  1957,     0,     0,     0,     0,     0,
       0,     0,  1815,     0,     0,     0,     0,     0,     0,     0,
       0,   672,   672,     0,     0,     0,     0,     0,   672,     0,
       0,   674,     0,     0,     0,  1955,     0,     0,     0,     0,
       0,  2433,     0,     0,     0,     0,  1955,     0,     0,     0,
       0,     0,     0,     0,  2243,  2244,  2245,     0,  2246,  2247,
    2248,  2249,  2250,  2251,     0,  2243,  2244,  2245,  5222,  2246,
    2247,  2248,  2249,  2250,  2251,     0,     0,  4222,     0,     0,
       0,  3597,     0,  1097,     0,     0,  3598,     0,     0,     0,
       0,  1097,     0,  1200,  1200,   674,     0,     0,     0,     0,
       0,     0,  2233,     0,     0,     0,  2234,   672,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2235,  2236,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1194,     0,  2226,  2237,     0,  2227,     0,     0,     0,
       0,     0,  1194,     0,  1957,     0,  1234,     0,     0,     0,
       0,     0,     0,  2228,     0,  1957,  1955,     0,     0,  1200,
    2238,  2230,     0,  2239,     0,     0,     0,  2231,     0,     0,
       0,     0,     0,     0,  1097,   371,  2240,     0,     0,  2241,
    1200,  1200,     0,     0,  1955,     0,     0,     0,     0,     0,
       0,  2232,     0,     0,     0,     0,  1097,  1097,  1097,     0,
    1200,     0,  1194,  1955,  3033,     0,  2015,     0,     0,  3033,
       0,     0,     0,     0,  3033,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   371,     0,     0,  1799,     0,
       0,     0,     0,   371,  1800,  1200,     0,  1200,  1200,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1955,     0,     0,  2242,     0,     0,     0,     0,  1837,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1582,     0,     0,  1801,  1957,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2233,     0,     0,     0,  2234,     0,     0,
       0,     0,     0,  1957,     0,  1838,     0,     0,     0,  2114,
    2114,     0,   672,     0,  1097,   822,  1023,     0,  2235,  2236,
       0,     0,  1957,  1802,     0,     0,     0,     0,     0,     0,
    1803,     0,     0,  1804,     0,  2237,     0,     0,   672,  2149,
       0,     0,  1097,     0,     0,  2155,     0,  2243,  2244,  2245,
     672,  2246,  2247,  2248,  2249,  2250,  2251,  1582,     0,     0,
       0,  2238,     0,   672,  2239,     0,     0,     0,     0,     0,
    1957,     0,     0,  1799,     0,     0,     0,  2240,     0,  1800,
    2241,     0,  2226,     0,  1839,  2227,  1582,  1805,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4139,     0,  2228,     0,     0,     0,   672,  1955,     0,     0,
    2230,     0,     0,     0,  1582,  1582,  2231,  1582,     0,  1801,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1840,     0,  1841,     0,  1582,     0,     0,     0,
    2232,     0,     0,     0,  1842,     0,  1807,     0,     0,     0,
       0,     0,     0,     0,     0,  2242,  1808,   718,   718,     0,
       0,     0,     0,     0,  1809,     0,     0,     0,  1802,  4140,
       0,     0,     0,  1843,  1810,  1803,     0,     0,  1804,     0,
       0,     0,     0,     0,     0,     0,  1097,     0,  4767,  1582,
       0,     0,     0,  2226,     0,     0,  2227,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3298,     0,     0,
    1812,  1813,  1845,  2228,     0,     0,  3560,     0,  1582,     0,
    5193,  2230,  1582,  1582,     0,     0,  1957,  2231,     0,  1955,
       0,   672,  1805,  1097,  1097,  2368,  3299,     0,     0,     0,
       0,     0,  2233,     0,     0,     0,  2234,  1847,  2243,  2244,
    2245,  2232,  2246,  2247,  2248,  2249,  2250,  2251,     0,     0,
       0,     0,   718,     0,     0,     0,     0,  2235,  2236,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2237,     0,     0,     0,     0,  1806,
       0,  1807,  1799,     0,  1815,     0,     0,     0,  1800,     0,
       0,  1808,     0,     0,     0,     0,     0,     0,     0,  1809,
    2238,     0,     0,  2239,     0,     0,     0,     0,     0,  1810,
       0,     0,     0,     0,     0,     0,  2240,     0,     0,  2241,
       0,   672,     0,   672,     0,     0,     0,     0,  1801,     0,
       0,     0,     0,  1955,     0,     0,     0,  5194,  3125,     0,
       0,     0,  3810,  2233,     0,  1812,  1813,  2234,     0,     0,
       0,  1097,  2533,     0,     0,     0,  1955,     0,  1097,     0,
     672,  1200,     0,     0,     0,     0,     0,     0,  2235,  2236,
       0,  3811,     0,     0,     0,     0,     0,  1802,     0,     0,
    1234,     0,     0,     0,  1803,  2237,  1097,  1804,     0,  1097,
       0,     0,  1955,     0,  2242,     0,     0,     0,     0,     0,
     822,     0,   672,     0,     0,     0,     0,     0,     0,     0,
       0,  2238,     0,  1097,  2239,     0,     0,     0,     0,     0,
       0,  1200,  1200,  1200,  1200,  1097,     0,  2240,     0,  1815,
    2241,     0,  1955,     0,     0,     0,  1955,  1955,     0,  1097,
       0,  1805,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2648,  3125,  1097,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1200,  1200,     0,     0,     0,     0,  1200,
       0,     0,     0,     0,     0,  1957,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2243,  2244,  2245,
       0,  2246,  2247,  2248,  2249,  2250,  2251,     0,  1806,     0,
    1807,     0,     0,     0,     0,  2242,     0,     0,     0,     0,
    1808,  1957,     0,     0,  1200,     0,     0,     0,  1809,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1810,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1200,  1200,  1200,  1200,     0,     0,     0,     0,     0,
       0,  1957,     0,  1097,     0,  1957,  1957,     0,     0,  1097,
       0,  3853,  2648,     0,  1812,  1813,   822,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1194,     0,     0,
       0,     0,     0,     0,   718,     0,  1194,     0,     0,     0,
    3854,     0,     0,     0,     0,     0,  1234,     0,  2243,  2244,
    2245,  1200,  2246,  2247,  2248,  2249,  2250,  2251,     0,     0,
    1200,     0,     0,     0,     0,     0,  1200,  1200,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1097,     0,     0,     0,     0,  4767,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1815,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2114,     0,     0,     0,     0,     0,
       0,  1200,     0,  1194,     0,     0,     0,  1097,  1097,     0,
    1200,     0,     0,     0,     0,     0,  1097,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1097,     0,     0,     0,
       0,     0,     0,  1023,  1023,     0,     0,  2869,     0,     0,
       0,  1582,  1582,     0,     0,     0,     0,     0,     0,  1582,
       0,     0,  1582,     0,     0,     0,  1582,     0,     0,     0,
       0,   672,     0,     0,  1582,  1582,     0,     0,     0,     0,
       0,     0,  1582,     0,  1234,  1582,  1582,  1582,  1582,     0,
       0,     0,     0,     0,     0,  1582,  1582,     0,  1582,     0,
    1582,  1582,     0,     0,  1582,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1582,     0,     0,     0,  1200,  1582,     0,     0,     0,
    1582,     0,     0,     0,  1582,   672,  1582,  1582,  1582,  1582,
    1582,  1582,  1582,  1582,  1582,     0,  1582,     0,     0,     0,
       0,     0,     0,  1097,     0,     0,  1582,  1582,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1097,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1097,     0,  1097,     0,  1582,
       0,     0,     0,     0,     0,   822,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1097,     0,     0,     0,     0,     4,
    3086,     0,  3093,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   822,     0,     0,     0,     5,
       0,     0,     0,   822,     0,     0,     0,     0,     0,     6,
       7,     0,     0,     0,     0,     8,     0,     9,    10,     0,
       0,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,     0,    36,     0,    37,
      38,    39,    40,    41,    42,    43,    44,     0,     0,   718,
      45,     0,     0,     0,  1023,     0,  1023,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1582,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1194,     0,  1200,  1200,  1200,     0,
       0,  1194,     0,  1234,     0,  1200,     0,  1200,    46,  1200,
    1200,  2226,     0,  1097,  2227, -2204,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2228,     0,     0,     0,     0,     0,     0,     0,  2230,
       0,     0,  2533,     0,     0,  2231,     0,     0,     0,  3227,
       0,     0,     0,     0,  3236,     0,     0,     0,     0,     0,
    1097,     0, -2204,     0,     0,     0,     0,     0,     0,  2232,
       0,     0,     0,     0, -2204,     0,     0,  1097,    47, -2204,
       0,  3277,  3277,     0, -2204,     0,     0,     0,   718, -2204,
       0,     0, -2204,     0, -2204,     0,    48,  2226,     0,     0,
    2227,     0,     0,     0,     0,     0,  1200,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    49,  2228,     0,     0,
    3605, -2204,     0,     0,     0,  2230,     0,     0,     0,     0,
       0,  2231,     0,  3336,     0,  3339,  3341,     0,    50,     0,
       0,     0,     0, -2204,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1200,     0,     0,     0,     0,
       0,  2233,     0,  1200,    51,  2234,     0,    52,  1200,     0,
   -2204,     0,     0,     0,     0,     0,     0,     0, -2204,     0,
       0,  1582,    53,     0,     0,     0,  2235,  2236,     0,  1947,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2237,     0,  2533,     0,     0,  3277,     0,
    1097,     0,  3434,     0,     0,  1023,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2204,     0,     0,  2238,
       0,     0,  2239,     0,     0,     0,     0,     0,     0,     0,
       0,  3336,     0,     0,     0,  2240,     0,  2233,  2241,  1200,
    3459,  2234,     0,     0,     0,     0,     0,     0,    54,     0,
       0,     0,  2015,  3575,     0,     0,     0,     0,     0,     0,
       0,  1027,  2235,  2236,     0,     0,     0,     0,  1949,  1200,
       0,  1200,  3277,  1200,  3277,     0,     0,     0,     0,  2237,
       0,     0,     0,     0,     0, -2204,     0,     0,     0,     0,
      55,     0,     0,     0,     0,     0,  1582,     0,     0,     0,
       0,     0,     0,     0,    56,  2238,     0,     0,  2239, -2204,
       0, -2204, -2204,  2242,     0,     0,     0,     0,  2114,    57,
       0,  2240,     0,     0,  2241,     0,     0,     0,     0,     0,
       0,     0,  1199,  1201,     0,     0,  1204,     0,  1206,     0,
       0,     0,  1947,     0,     0,     0, -2204,    58,     0, -2204,
   -2204,     0, -2204,     0,    59,     0,     0,  1250,    60,    61,
      62,    63,    64,  1194,     0,    65,    66,    67,    68,  1194,
      69,    70,    71,    72,    73,     0,     0,  1303,     0,     0,
    1200,  1306,     0,     0,     0,     0,  1582,  1582,     0,     0,
       0,     0,  1582,     0,     0,     0,     0,     0,  1329,  2242,
       0,     0,     0,     0,     0,     0,  2243,  2244,  2245,     0,
    2246,  2247,  2248,  2249,  2250,  2251,     0,  1582,  1582,     0,
       0,     0,  1582,     0,     0,     0,     0,     0,     0,     0,
       0,  1949,     0,     0,  1582,  1582,  1582,  1582,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1582,     0,     0,
    1582,     0,  1582,  3625,  2226,     0,     0,  2227,     0,     0,
       0,     0,  1582,  1582,     0,     0,  1582,     0,     0,     0,
       0,     0,     0,     0,  2228,     0,     0,     0,     0,  1582,
       0,  1582,  2230,  1234,     0,  1582,     0,     0,  2231,     0,
       0,     0,  2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,
    2250,  2251,     0,     0,  1582,     0,     0,     0,  1097,     0,
       0,     0,  2232,     0,  3678,     0,     0,  1582,  1582,  1582,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1582,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1582,     0,     0,     0,     0,  1582,
       0,     0,     0,     0,     0,  1582,  2226,     0,     0,  2227,
       0,     0,     0,  3678,     0,     0,  3735,     0,     0,     0,
    3093,     0,     0,     0,     0,     0,  2228,     0,     0,  3616,
       0,     0,     0,     0,  2230,     0,     0,     0,  3610,     0,
    2231,     0,     0,     0,     0,     0,     0,  2226,     0,     0,
    2227,     0,     0,     0,  2233,     0,  1947,     0,  2234,     0,
       0,     0,     0,     0,  2232,     0,     0,  2228,     0,     0,
       0,     0,     0,     0,     0,  2230,     0,     0,     0,  2235,
    2236,  2231,     0,     0,  1582,     0,  3277,     0,     0,     0,
       0,  2114,     0,     0,     0,     0,  2237,     0,     0,     0,
       0,     0,     0,     0,     0,  2232,     0,     0,     0,     0,
    1947,     0,     0,     0,     0,     0,     0,  1200,     0,  1200,
    1200,  1200,  2238,     0,     0,  2239,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2240,     0,
       0,  2241,  1947,     0,     0,  1949,     0,  1823,  1824,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2233,     0,     0,     0,
    2234,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2235,  2236,     0,   830,     0,     0,     0,     0,  1949,
       0,     0,     0,     0,     0,     0,     0,  2233,  2237,     0,
       0,  2234,     0,     0,     0,     0,  2242,     0,     0,  1947,
       0,     0,     0,  1917,     0,     0,     0,     0,     0,     0,
       0,  1949,  2235,  2236,  2238,     0,     0,  2239,  1947,   830,
       0,     0,     0,     0,  1975,  1976,     0,     0,     0,  2237,
    2240,     0,     0,  2241,     0,     0,  1947,     0,     0,     0,
       0,     0,     0,     0,  2007,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2238,     0,     0,  2239,     0,
       0,     0,     0,     0,  1947,  1057,     0,     0,     0,     0,
       0,  2240,     0,  1057,  2241,  1057,     0,     0,  3277,  3277,
       0,  2040,  2042,     0,     0,     0,     0,   830,  1949,  2243,
    2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,
       0,  3950,     0,     0,     0,     0,     0,  1949,  2242,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1949,     0,  1947,  1097,  1097,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1097,     0,     0,     0,     0,  2242,
       0,     0,     0,  1949,     0,     0,     0,  2114,  1097,     0,
       0,     0,     0,     0,     0,     0,  2114,  1097,     0,     0,
       0,     0,     0,     0,     0,  4096,     0,     0,     0,     0,
       0,  1097,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   718,     0,     0,     0,
       0,  2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,  2250,
    2251,  1200,     0,     0,  1200,     0,  1949,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1194,     0,  2226,     0,     0,  2227,     0,     0,     0,
       0,     0,  2243,  2244,  2245,     0,  2246,  2247,  2248,  2249,
    2250,  2251,  1097,  2228,     0,     0,  4146,     0,     0,     0,
       0,  2230,  1200,     0,     0,     0,     0,  2231,     0,     0,
    1582,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1582,     0,     0,     0,     0,     0,  1582,     0,  1582,     0,
       0,  2232,     0,     0,  1582,     0,     0,  1582,  1582,  1582,
    1582,  1582,  1582,  1582,  1582,  1582,  1582,     0,     0,     0,
    1582,  1582,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1582,  1947,     0,     0,  1582,     0,     0,
       0,  1582,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1582,     0,     0,  1582,     0,  1582,     0,     0,     0,
       0,     0,     0,     0,     0,  1582,  1582,  1582,     0,     0,
       0,  1582,     0,     0,  1582,     0,     0,     0,  4172,     0,
       0,     0,     0,     0,     0,  1097,  1097,  1097,  1194,     0,
    3678,  4189,     0,     0,     0,  4189,  4203,     0,     0,     0,
       0,     0,  1582,  2233,     0,     0,     0,  2234,  1582,  1582,
    2226,     0,     0,  2227,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1949,     0,     0,     0,     0,  2235,  2236,
    2228,     0,     0,     0,     0,     0,     0,     0,  2230,     0,
       0,     0,     0,     0,  2231,  2237,     0,     0,     0,     0,
       0,     0,     0,  1582,     0,     0,     0,     0,     0,  1582,
       0,     0,     0,  3093,     0,  1582,     0,     0,  2232,     0,
       0,  2238,     0,     0,  2239,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2240,     0,     0,
    2241,     0,     0,     0,     0,     0,     0,  4264,  2114,  2114,
       0,  2648,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1200,
    1200,  1200,  1200,     0,     0,  2549,     0,     0,     0,     0,
    1947,     0,     0,     0,  1947,  1947,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4307,     0,     0,     0,
       0,     0,     0,     0,     0,  2242,     0,     0,     0,     0,
    2233,     0,     0,     0,  2234,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2615,  2616,  2617,  2618,     0,
       0,     0,     0,     0,     0,  2235,  2236,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2237,     0,     0,     0,     0,     0,     0,  1949,
       0,     0,     0,  1949,  1949,     0,     0,  2656,  2657,     0,
       0,     0,  4373,  2666,     0,     0,     0,     0,  2238,     0,
    1947,  2239,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2240,     0,     0,  2241,  2243,  2244,
    2245,     0,  2246,  2247,  2248,  2249,  2250,  2251,     0,     0,
       0,  3950,     0,     0,     0,     0,     0,     0,  2690,  1097,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1200,     0,  1582,     0,     0,     0,     0,     0,  1097,     0,
       0,     0,     0,   830,  4445,  2725,  2726,  2727,  2728,     0,
       0,  1196,     0,  2533,     0,     0,     0,     0,     0,     0,
    1196,     0,     0,     0,     0,  1097,     0,     0,     0,  1949,
       0,     0,  2242,     0,     0,  3336,     0,     0,     0,     0,
       0,  4474,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1196,     0,     0,  1582,  1582,     0,
       0,     0,     0,     0,     0,  2787,     0,     0,     0,     0,
       0,     0,     0,     0,  2791,     0,     0,     0,     0,     0,
       0,  2798,  3277,     0,  3277,     0,     0,  1947,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1196,     0,     0,     0,     0,     0,     0,     0,  1582,
       0,  1196,     0,     0,     0,  2243,  2244,  2245,     0,  2246,
    2247,  2248,  2249,  2250,  2251,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1582,     0,     0,     0,
       0,     0,  1947,     0,     0,     0,  1582,  1582,     0,     0,
       0,     0,     0,     0,  1582,  1582,  1949,     0,     0,  1582,
       0,     0,     0,     0,     0,  1582,  1582,     0,     0,  1582,
       0,     0,  1582,  4560,     0,     0,  1097,  1097,  1097,  1097,
       0,     0,     0,  4189,  4203,     0,  4189,     0,     0,  4569,
       0,     0,     0,  3678,     0,     0,     0,  3678,     0,     0,
       0,     0,     0,  4582,     0,     0,     0,     0,     0,  1582,
       0,     0,     0,     0,  1582,     0,     0,  1196,     0,  1582,
       0,     0,     0,  1057,     0,     0,     0,  1057,  1234,  2971,
       0,  1949,     0,     0,     0,     0,  3735,     0,     0,     0,
    3093,     0,  1947,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1196,     0,     0,     0,     0,     0,  1023,
       0,     0,  1582,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3277,  3277,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4646,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1949,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1200,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1200,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1057,
    1057,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3950,  3950,  3950,  3950,  3950,  1196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1196,     0,     0,     0,
       0,     0,     0,     0,  1582,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1194,     0,     0,     0,  1958,
    2533,     0,     0,     0,     0,     0,     0,  2114,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1200,
    2533,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3179,  3180,  3181,     0,     0,     0,  1196,     0,     0,  3191,
       0,  3193,     0,  3195,  3196,     0,  1097,     0,  4773,     0,
       0,     0,     0,     0,     0,  1947,     0,     0,  1947,     0,
    1947,     0,     0,     0,     0,  1947,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1582,     0,     0,
       0,     0,     0,     0,     0,     0,  1582,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1582,  1582,  1196,     0,  1582,     0,     0,
       0,     0,     0,     0,     0,  1947,     0,     0,     0,     0,
    1194,  4189,     0,     0,     0,  3678,     0,     0,     0,     0,
    3678,     0,     0,  3678,  3336,     0,  4823,     0,  1582,  1582,
    3303,     0,     0,     0,  1949,     0,     0,  1949,     0,  1949,
       0,     0,     0,     0,  1949,  1947,     0,     0,     0,     0,
       0,     0,  1958,     0,     0,     0,     0,     0,     0,     0,
       0,  4264,  1234,  1200,  1200,  1200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1196,     0,     0,     0,     0,     0,     0,     0,  3362,
       0,     0,     0,     0,  1949,     0,     0,  3371,     0,     0,
       0,     0,  3372,  1194,  1234,     0,  1947,     0,  1947,     0,
    1196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1949,     0,     0,     0,  1196,  1196,
       0,  1196,     0,     0,  2114,  2114,     0,     0,     0,  1194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1097,
    1196,     0,     0,  1947,     0,     0,     0,     0,     0,     0,
    4445,     0,     0,     0,     0,     0,     0,  3277,     0,     0,
       0,  2533,     0,  3457,     0,     0,     0,     0,  1947,     0,
       0,     0,     0,  4474,     0,  1949,  1097,  1949,     0,     0,
       0,     0,     0,     0,  1200,  4264,     0,     0,     0,  1947,
       0,     0,     0,  1196,   830,  3493,     0,  3495,     0,     0,
       0,     0,  1947,     0,     0,     0,     0,     0,     0,  1582,
       0,     0,  1582,     0,  1582,     0,     0,     0,     0,     0,
       0,     0,  1196,     0,     0,     0,  1196,  1196,     0,     0,
       0,     0,  1949,     0,     0,     0,     0,  1582,     0,     0,
       0,  3678,     0,     0,  4823,     0,     0,     0,     0,     0,
    4983,     0,     0,     0,     0,     0,     0,  1949,     0,     0,
       0,     0,     0,     0,     0,     0,  1947,     0,  1200,     0,
       0,     0,  1097,     0,     0,     0,     0,     0,  1949,     0,
       0,     0,  1947,     0,     0,     0,     0,     0,     0,     0,
       0,  1949,     0,     0,     0,  1947,  1200,  1200,  1200,  1200,
       0,     0,     0,     0,  3550,     0,  1958,     0,     0,     0,
       0,  2114,   830,     0,     0,     0,     0,     0,     0,  1057,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1194,     0,     0,     0,     0,     0,     0,     0,   887,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1582,   888,  1057,     0,     0,  1949,     0,     0,     0,     0,
    1958,     0,     0,     0,     0,     0,     0,  1947,     0,     0,
       0,  1949,   889,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1949,   890,     0,  1947,  1582,     0,
       0,  1194,  1958,     0,   891,     0,     0,     0,  -755,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1200,  1947,  1234,     0,   892,     0,     0,     0,     0,
       0,   893,     0,  1582,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   894,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   895,  1947,     0,
       0,     0,     0,     0,     0,   896,  1949,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1200,   897,     0,  1958,
       0,  1194,     0,     0,   898,     0,  1949,     0,   899,     0,
       0,     0,  4264,     0,     0,     0,     0,     0,  1958,     0,
       0,  4773,     0,  -957,     0,     0,     0,     0,  1582,  1582,
       0,  1949,     0,  3336,     0,     0,  1958,  4983,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1194,     0,     0,     0,     0,     0,     0,     0,   830,
    1200,     0,   900,     0,  1958,     0,     0,  1949,     0,  -521,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1582,     0,     0,  1947,     0,     0,     0,     0,
     901,     0,     0,   902,     0,     0,  1582,     0,     0,     0,
       0,     0,     0,  1200,     0,     0,     0,     0,     0,     0,
       0,  1196,     0,     0,     0,     0,     0,  1958,     0,     0,
    1196,  3791,     0,  3792,  3793,  3794,     0,     0,  -418,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   903,     0,     0,     0,
       0,     0,   904,     0,     0,     0,     0,     0,  -418,     0,
       0,   905,     0,     0,  1582,     0,     0,     0,     0,     0,
       0,     0,     0,  1194,  1949,     0,  1947,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -418,     0,   906,
     907,     0,   908,   909,     0,     0,     0,     0,     0,     0,
       0,   910,     0,     0,     0,     0,   911,  1196,     0,     0,
       0,     0,   912,     0,     0,   913,     0,     0,   914,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -418,     0,  1950,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1196,  1196,     0,     0,     0,
       0,     0,     0,  1196,     0,     0,  1196,     0,     0,     0,
    1196,     0,     0,     0,     0,  1949,     0,     0,  1196,  1196,
       0,     0,     0,     0,     0,     0,  1196,     0,     0,  1196,
    1196,  1196,  1196,     0,     0,     0,     0,     0,     0,  1196,
    1196,     0,  1196,     0,  1196,  1196,     0,     0,  1196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1958,  1196,   830,     0,     0,     0,
    1196,     0,     0,  1947,  1196,     0,     0,     0,  1196,     0,
    1196,  1196,  1196,  1196,  1196,  1196,  1196,  1196,  1196,     0,
    1196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1196,  1196,     0,     0,     0,     0,     0,     0,     0,     0,
    1947,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1950,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1949,  1196,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4064,     0,     0,  4065,     0,
       0,     0,     0,     0,     0,    85,     0,     0,     0,  1949,
       0,    89,     0,     0,     0,    93,     0,    94,     0,    96,
      97,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     106,     0,     0,  1947,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1947,     0,  4092,   119,   120,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1958,     0,     0,     0,  1958,  1958,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   830,     0,
       0,     0,     0,   128,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   129,     0,   130,   131,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1196,     0,     0,
    1130,     0,  1949,     0,     0,     0,     0,     0,  1196,     0,
       0,     0,     0,  1949,     0,  1196,     0,     0,     0,     0,
     141,     0,   142,   143,     0,     0,     0,     0,   146,     0,
     147,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     149,     0,   150,     0,  1947,     0,  1057,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   153,     0,   154,     0,
    1958,   157,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1947,   158,     0,   159,     0,   830,     0,   160,
       0,   830,     0,     0,     0,   161,     0,     0,     0,     0,
       0,  1947,     0,   163,     0,   165,     0,     0,     0,     0,
       0,   167,     0,  1057,     0,     0,     0,     0,     0,     0,
    1950,     0,     0,     0,     0,     0,   171,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1949,     0,     0,     0,     0,     0,  1947,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1949,     0,     0,  1950,     0,     0,     0,     0,     0,
       0,   184,   185,  4281,  4282,  4283,  4284,   186,     0,     0,
    1949,     0,     0,     0,     0,     0,   187,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1950,   192,     0,     0,
       0,     0,     0,     0,     0,  1196,     0,  1958,     0,     0,
       0,  1055,     0,     0,     0,     0,     0,     0,     0,  1055,
       0,  1055,     0,     0,   830,     0,     0,     0,  1949,     0,
       0,     0,     0,     0,     0,   202,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   204,     0,     0,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
     208,     0,     0,     0,     0,   209,     0,     0,   211,     0,
       0,     0,   213,  1950,     0,     0,     0,   214,   215,     0,
       0,     0,  1958,     0,     0,   216,     0,     0,   218,     0,
       0,     0,  1950,     0,     0,  1947,   221,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   223,     0,
    1950,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   228,     0,   229,     0,     0,
    1196,     0,     0,     0,     0,   231,     0,     0,  1950,     0,
       0,   232,     0,     0,  4432,     0,   233,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   236,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1958,     0,  1949,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   246,     0,  1196,     0,  -138,
       0,  1950,     0,  1196,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1947,     0,     0,
    1196,  1196,     0,     0,     0,     0,  1196,     0,     0,   944,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   945,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1196,  1196,     0,     0,     0,  1196,     0,     0,     0,
       0,     0,   946,     0,     0,     0,     0,     0,  1196,  1196,
    1196,  1196,     0,     0,     0,   947,   830,     0,     0,     0,
       0,  1196,   830,     0,  1196,     0,  1196,     0,   948,     0,
       0,     0,     0,     0,     0,     0,  1196,  1196,     0,     0,
    1196,     0,     0,     0,     0,   949,  1949,     0,     0,     0,
       0,     0,     0,  1196,     0,  1196,     0,     0,     0,  1196,
       0,     0,     0,     0,     0,     0,   950,     0,     0,     0,
       0,  1947,     0,     0,     0,     0,     0,   951,  1196,     0,
       0,     0,     0,     0,     0,   952,     0,     0,  1196,     0,
       0,  1196,  1196,  1196,  1947,     0,     0,   953,     0,     0,
       0,     0,   954,     0,     0,     0,     0,     0,   955,     0,
       0,     0,     0,     0,     0,  1196,     0,     0,     0,     0,
       0,     0,     0,   956,     0,     0,     0,     0,  1196,     0,
    1947,     0,     0,  1196,     0,     0,     0,     0,  1950,  1196,
       0,     0,     0,     0,     0,     0,     0,  1196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1949,     0,     0,     0,     0,     0,     0,     0,     0,   957,
    1947,     0,     0,     0,  1947,  1947,     0,     0,     0,     0,
       0,     0,     0,  1949,     0,  1958,     0,     0,  1958,     0,
    1958,     0,     0,     0,     0,  1958,     0,     0,     0,     0,
     958,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   959,     0,     0,     0,     0,     0,     0,  1196,  1949,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   859,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1958,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   960,     0,     0,  1949,
     961,     0,   962,  1949,  1949,     0,     0,     0,   963,     0,
    4675,   964,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4678,  1958,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   965,     0,   966,
       0,     0,     0,   967,     0,     0,     0,     0,     0,     0,
       0,   968,     0,   830,   830,   830,   969,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   970,     0,
       0,     0,     0,     0,  1950,     0,     0,     0,  1950,  1950,
       0,   971,     0,     0,     0,     0,  1958,     0,  1958,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4746,     0,     0,     0,  1192,     0,     0,
       0,     0,     0,     0,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,  1958,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1958,     0,
    1192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1950,     0,     0,     0,     0,  1958,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   830,  1958,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1958,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4844,  4846,  4846,
       0,     0,  1958,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1958,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1196,     0,     0,     0,     0,
       0,  1950,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,  1055,
       0,     0,     0,  1055,  1196,     0,     0,  1958,     0,     0,
       0,     0,     0,     0,  1196,     0,     0,     0,     0,     0,
    1196,     0,  1196,     0,     0,     0,     0,  1958,  1196,  1192,
       0,  1196,  1196,  1196,  1196,  1196,  1196,  1196,  1196,  1196,
    1196,     0,     0,     0,  1196,  1196,  1950,     0,     0,     0,
       0,     0,  1958,     0,     0,     0,     0,  1196,  4942,     0,
       0,  1196,     0,   830,     0,  1196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1196,     0,     0,  1196,     0,
    1196,     0,     0,     0,     0,     0,     0,     0,  1958,  1196,
    1196,  1196,     0,     0,     0,  1196,     0,     0,  1196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1196,     0,  1196,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1196,     0,     0,     0,
       0,     0,  1196,  1196,     0,     0,     0,     0,     0,     0,
       0,     0,  4991,     0,     0,     0,  1950,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1055,  1055,     0,     0,     0,
       0,  5014,     0,  5016,     0,     0,     0,  1196,     0,     0,
       0,     0,     0,  1196,     0,     0,     0,     0,     0,  1196,
       0,  1192,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,     0,     0,  1958,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1196,     0,     0,     0,  1956,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4846,     0,     0,     0,     0,
     830,     0,     0,     0,     0,   830,  1958,   830,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1192,     0,     0,     0,     0,     0,     0,     0,     0,
    5122,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   830,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1956,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  5163,     0,     0,     0,     0,  1950,
       0,     0,  1950,     0,  1950,     0,  1196,  1192,     0,  1950,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1958,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  5202,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1950,
       0,     0,     0,     0,  1192,  1192,     0,  1192,     0,     0,
    1958,  1196,  1196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1950,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1196,     0,     0,     0,     0,     0,  1192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1950,     0,  1950,     0,     0,     0,     0,     0,  1192,     0,
    1196,     0,  1192,  1192,     0,     0,     0,     0,     0,     0,
    1196,  1196,     0,  1958,     0,     0,     0,     0,  1196,  1196,
       0,     0,     0,  1196,  1958,     0,     0,     0,     0,  1196,
    1196,     0,     0,  1196,     0,     0,  1196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1950,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1196,     0,     0,
       0,  1196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1950,  1196,     0,     0,     0,     0,  1196,     0,
       0,     0,  1956,  1196,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1950,     0,  1055,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1950,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1196,     0,  1055,     0,
       0,     0,     0,     0,     0,     0,  1956,     0,     0,     0,
       0,     0,     0,     0,  1958,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   830,     0,     0,     0,     0,  1956,     0,
    1950,     0,  1958,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1950,     0,     0,     0,
       0,  1958,     0,     0,     0,     0,     0,     0,     0,  1950,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1958,
       0,     0,     0,     0,     0,  1956,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1956,     0,     0,     0,     0,     0,
       0,  1950,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1956,     0,     0,     0,     0,     0,     0,     0,
       0,  1950,     0,     0,     0,     0,     0,     0,  1196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1196,
    1956,     0,     0,     0,     0,     0,  1950,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1950,     0,     0,     0,     0,  1958,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1192,     0,     0,
       0,     0,     0,  1956,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1196,     0,     0,     0,  1958,     0,     0,     0,     0,
    1196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1196,  1196,     0,
       0,  1196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1196,     0,     0,     0,     0,  1196,
       0,     0,     0,     0,  1196,     0,     0,  1196,     0,     0,
       0,     0,  1196,  1196,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,  1950,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1192,  1192,     0,     0,     0,     0,     0,     0,  1192,
       0,     0,  1192,     0,     0,     0,  1192,  1958,     0,     0,
       0,     0,     0,     0,  1192,  1192,     0,  1196,     0,     0,
       0,     0,  1192,     0,     0,  1192,  1192,  1192,  1192,     0,
       0,     0,     0,     0,     0,  1192,  1192,     0,  1192,     0,
    1192,  1192,     0,     0,  1192,     0,     0,     0,   830,     0,
    1950,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1956,  1192,     0,  1196,     0,     0,  1192,     0,     0,     0,
    1192,     0,     0,     0,  1192,     0,  1192,  1192,  1192,  1192,
    1192,  1192,  1192,  1192,  1192,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1192,  1192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1196,
       0,  1958,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1196,  1958,     0,  1196,     0,  1196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1196,     0,     0,     0,  1196,     0,     0,     0,     0,
    1958,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1950,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   830,     0,     0,     0,     0,     0,
    1958,     0,     0,     0,  1958,  1958,     0,     0,     0,     0,
       0,     0,     0,     0,  1950,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1956,     0,     0,     0,
    1956,  1956,     0,     0,     0,  1196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1196,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,  1958,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1192,     0,     0,     0,     0,     0,
       0,  1192,  1196,     0,     0,  1196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1950,     0,     0,
       0,     0,  1055,     0,     0,     0,     0,  1196,  1950,     0,
       0,     0,     0,     0,     0,     0,  1956,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1196,     0,     0,     0,  1055,
       0,     0,     0,     0,     0,     0,  1196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1196,  1196,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1950,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1950,     0,     0,     0,
    1196,  1192,     0,  1956,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1950,     0,     0,     0,     0,
       0,     0,     0,   830,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   930,     0,     0,     0,     0,     0,     0,     0,     0,
     930,     0,     0,  1950,     0,     0,     0,     0,  1196,     0,
       0,     0,     0,   830,     0,     0,     0,  1196,  1956,     0,
       0,   830,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   930,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,  1111,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1956,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,  1192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1192,  1192,     0,  1950,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1192,  1192,     0,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1192,  1192,  1192,  1192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1192,     0,     0,
    1192,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,  1192,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
       0,  1192,     0,     0,  1160,  1192,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1192,     0,     0,     0,     0,     0,
       0,  1950,     0,     0,  1192,     0,     0,  1192,  1192,  1192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1192,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1192,     0,     0,     0,     0,  1192,
       0,     0,     0,     0,     0,  1192,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1956,     0,     0,  1956,     0,  1956,     0,     0,     0,
       0,  1956,     0,     0,     0,  1950,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1192,     0,     0,     0,  1950,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1956,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1950,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1956,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1950,     0,     0,     0,  1950,  1950,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   930,
     930,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1956,     0,  1956,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1160,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1956,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1956,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1956,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1956,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1207,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1237,  1238,
       0,  1241,     0,     0,  1247,     0,  1249,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1956,     0,     0,  1301,     0,     0,     0,     0,
       0,     0,     0,  1309,     0,     0,     0,     0,  1956,     0,
       0,     0,  1325,  1326,     0,     0,     0,  1328,     0,     0,
       0,  1956,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1160,     0,   930,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1192,  1359,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1382,     0,
       0,  1384,     0,  1386,     0,  1389,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   930,
    1192,     0,     0,  1956,     0,     0,     0,     0,     0,     0,
    1192,     0,     0,     0,     0,     0,  1192,     0,  1192,     0,
       0,     0,     0,  1956,  1192,     0,     0,  1192,  1192,  1192,
    1192,  1192,  1192,  1192,  1192,  1192,  1192,     0,     0,     0,
    1192,  1192,     0,     0,     0,     0,     0,     0,  1956,     0,
       0,     0,     0,  1192,  1469,     0,  1470,  1192,     0,     0,
       0,  1192,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1192,     0,     0,  1192,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,  1956,  1192,  1192,  1192,     0,  1160,
       0,  1192,     0,     0,  1192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
    1192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,     0,     0,  1111,     0,     0,  1192,  1192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,  1192,
       0,     0,     0,     0,     0,  1192,     0,     0,     0,     0,
       4,     0,     0,     0,     0,     0,  1732,     0,  1734,     0,
       0,  1956,  1736,     0,     0,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,  1192,     0,     0,
       6,     7,  1765,     0,     0,     0,     0,     0,     9,    10,
       0,     0,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,  1890,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1903,
       0,     0,  1956,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1913,     0,     0,     0,     0,     0,     0,  1915,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,  1964,     0,     0,  1968,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2011,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    48,     0,     0,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1952,     0,     0,     0,     0,    49,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1956,
       0,     0,     0,   678,     0,     0,     0,     0,   722,    50,
     722,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     722,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1956,  1192,  1192,     0,
       0,     0,     0,     0,     0,    51,   722,     0,    52,     0,
       0,     0,     0,     0,     0,     0,   722,     0,     0,     0,
       0,     0,     0,    53,     0,     0,     0,   722,   722,     0,
       0,   722,     0,     0,     0,     0,     0,   722,     0,     0,
       0,  1015,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
       0,  1015,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   722,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1192,     0,     0,    54,
       0,     0,     0,     0,     0,  1952,  1192,  1192,     0,  1956,
       0,     0,     0,     0,  1192,  1192,     0,     0,     0,  1192,
    1956,     0,     0,     0,     0,  1192,  1192,     0,     0,  1192,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,    55,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,    56,     0,  1192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
      57,     0,     0,     0,  1192,     0,     0,     0,     0,  1192,
       0,     0,  1111,  2329,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    58,     0,
       0,     0,     0,     0,     0,    59,     0,     0,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,  1397,     0,
       0,     0,  1192,    71,  1398,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1956,  2400,     0,     0,  2400,     0,  1953,     0,     0,     0,
       0,     0,  2407,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1956,     0,
    2416,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1956,     0,     0,
       0,   722,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2499,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1956,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1952,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1192,     0,     0,     0,  1953,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1952,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1956,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1952,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1192,     0,     0,
       0,  1956,     0,     0,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2700,     0,
     722,     0,     0,  1192,  1192,     0,     0,  1192,     0,     0,
       0,     0,     0,  2723,     0,     0,     0,     0,     0,     0,
    1192,     0,     0,     0,     0,  1192,     0,     0,     0,     0,
    1192,     0,  1952,  1192,     0,     0,     0,     0,  1192,  1192,
       0,     0,     0,     0,     0,     0,   722,   722,     0,     0,
       0,  1952,     0,     0,     0,     0,     0,     0,     0,  2771,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1952,
       0,  1192,     0,     0,  2786,     0,  2788,     0,  2789,     0,
       0,     0,     0,  2790,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   722,     0,     0,  1952,     0,     0,
       0,     0,     0,  1956,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2819,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2329,     0,     0,     0,  2329,     0,
    2329,     0,     0,  2329,     0,     0,     0,     0,     0,  1192,
    1952,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1953,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1192,     0,  1956,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1953,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
    1956,     0,  1192,     0,  1192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1953,
       0,     0,     0,     0,     0,     0,     0,  1192,     0,     0,
       0,  1192,     0,     0,     0,     0,  1956,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1347,   722,     0,   722,  3034,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1956,     0,     0,     0,
    1956,  1956,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1953,     0,     0,     0,
       0,     0,   722,     0,     0,   722,   722,     0,     0,     0,
       0,     0,     0,     0,     0,  1953,     0,  1952,     0,     0,
     678,  1192,  1015,     0,  1015,     0,     0,     0,     0,     0,
     678,     0,     0,  1953,   722,     0,     0,     0,     0,     0,
    1192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1015,  1015,     0,     0,     0,     0,     0,
    1956,  1953,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,  1192,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1160,   722,     0,   722,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1953,  3134,  3135,     0,     0,     0,
    3138,  3139,     0,     0,  3142,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3152,     0,     0,     0,     0,     0,
       0,  3161,     0,     0,     0,  3164,  3165,     0,     0,  3168,
    3169,  1192,     0,     0,     0,     0,  3174,     0,     0,     0,
       0,     0,  1192,     0,     0,     0,   678,     0,  3190,     0,
    3192,     0,     0,     0,     0,     0,     0,     0,  1192,  1192,
     678,   678,     0,     0,  1714,     0,  3214,     0,     0,     0,
       0,  3216,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1192,     0,  1952,  3221,     0,     0,  1952,  1952,     0,
       0,     0,  3226,     0,  3228,  3229,  3232,  3234,     0,     0,
       0,  3241,  3244,     0,     0,     0,     0,     0,     0,  3255,
       0,   678,     0,  3264,     0,     0,     0,  3268,     0,     0,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1192,     0,     0,     0,
    3297,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3304,     0,  3306,     0,     0,     0,     0,  3309,     0,
       0,     0,  3310,     0,  3314,  3315,  3316,  3317,     0,  3319,
       0,     0,     4,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3343,  3344,  3345,     0,     0,     0,     0,     0,
       0,  1953,     5,  1952,     0,  3353,  3354,     0,     0,     0,
       0,     0,     6,     7,  1192,     0,     0,     0,     0,     0,
       9,    10,     0,  1192,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,     0,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
       0,     0,     0,    45,     0,  3408,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    46,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,     0,     0,     0,   722,     0,   722,     0,     0,
     722,     0,   722,     0,     0,   722,   722,   722,     0,     0,
       0,  2109,     0,     0,     0,     0,     0,     0,   722,     0,
    1952,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   722,     0,   722,     0,     0,     0,     0,   722,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,     0,     0,  1160,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1953,     0,    48,
    2329,  1953,  1953,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    49,
       0,     0,     0,     0,     0,  1952,     0,     0,  3535,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    50,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    51,     0,     0,
      52,     0,     0,     0,     0,     0,     0,     0,     0,  2269,
       0,     0,     0,     0,     0,    53,     0,     0,   722,   722,
       0,     0,     0,     0,     0,     0,     0,  1953,     0,     0,
       0,     0,     0,     0,     0,   678,     0,     0,     0,     0,
     678,   678,     0,     0,     0,  1952,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    54,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   722,     0,   678,     0,     0,     0,     0,
       0,     0,     0,    55,     0,  2404,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3716,    56,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    57,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1953,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      58,     0,     0,     0,     0,     0,     0,    59,     0,   678,
       0,    60,    61,    62,    63,    64,     0,   678,    65,    66,
    1397,  2066,     0,     0,     0,    71,     0,     0,  3762,  3763,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2329,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1953,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3785,   678,     0,     0,   678,   678,     0,     0,     0,  3789,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3800,  3802,     0,     0,     0,  3802,
       0,     0,     0,     0,  3813,  3814,  3815,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1952,     0,
       0,  1952,     0,  1952,     0,     0,     0,     0,  1952,     0,
       0,     0,     0,     0,  3835,  3836,  3837,  3838,     0,     0,
       0,     0,   678,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1953,
       0,     0,     0,     0,     0,     0,     0,     0,  3852,     0,
    3856,  3857,  3858,     0,     0,     0,     0,     0,  1952,     0,
    3871,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1952,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3912,     0,     0,     0,     0,
       0,     0,     0,  3916,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1952,
       0,  1952,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3984,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   722,     0,   722,     0,     0,     0,   722,
       0,   722,     0,     0,   722,     0,  1952,     0,   722,     0,
       0,     0,     0,  2269,     0,     0,     0,     0,     0,  4013,
       0,     0,  4016,     0,     0,     0,     0,     0,     0,     0,
       0,  1952,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1952,   930,     0,     0,  4056,     0,     0,     0,
       0,     0,     0,     0,     0,  1952,     0,     0,     0,     0,
    4066,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2329,     0,     0,     0,     0,     0,     0,
       0,     0,  1953,     0,     0,  1953,     0,  1953,     0,     0,
       0,     0,  1953,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,     0,     0,     0,  1952,
       0,     0,  1197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1952,     0,     0,     0,     0,
       0,     0,  1953,     0,     0,     0,     0,     0,  1952,     0,
       0,     0,     0,     0,  2109,     0,  1197,     0,     0,     0,
       0,  3035,     0,     0,     0,     0,     0,     0,     0,     0,
    2404,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1953,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,     0,     0,     0,     0,
    1952,     0,     0,  1197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,     0,     0,     0,     0,
    1952,     0,     0,  1953,     0,  1953,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1952,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,     0,
       0,   678,     0,     0,     0,     0,     0,  3107,     0,  1714,
    1953,  1952,   722,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1953,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4275,  1197,
    4276,     0,     0,     0,     0,     0,  1953,  4278,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1953,
       0,     0,     0,  4287,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1197,     0,     0,  4295,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4306,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4309,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1952,     0,
       0,     0,     0,  1953,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4341,  4342,  4343,  1953,
       0,  4346,  4347,  4348,  4349,  4350,     0,     0,     0,     0,
    4357,  4358,  1953,  4360,  4361,  4362,  4363,  4364,  4365,  4366,
       0,     0,     0,     0,     0,     0,     0,     0,  4374,     0,
    4376,  4377,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   678,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1952,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4426,  4428,  4430,     0,  1953,  4433,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,  1567,  1953,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1953,
       0,  1959,     0,     0,     0,     0,     0,     0,     0,  1641,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1953,     0,  3802,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2329,  2329,  2329,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1952,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1952,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   722,  2109,     0,     0,     0,     0,
       0,     0,  1953,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,     0,  1959,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1952,     0,     0,     0,
       0,     0,     0,  1953,     0,     0,     0,  1952,     0,     0,
    1197,  1197,     0,  1197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1197,     0,     0,  4635,  4636,  4637,  4638,     0,
       0,  4640,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4653,  4654,  4655,  4656,     0,  4658,  4659,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4668,
    4669,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,     0,  4671,     0,     0,     0,     0,     0,  2329,  2329,
       0,  2329,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1197,     0,     0,     0,  1197,  1197,
       0,     0,     0,  2404,     0,     0,     0,  1952,   678,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1953,     0,     0,     0,     0,  1952,     0,  2164,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1952,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2188,  1953,     0,     0,
       0,     0,     0,     0,     0,     0,  4733,     0,  1959,     0,
       0,     0,     0,     0,     0,  4739,     0,     0,     0,     0,
       0,     0,     0,     0,  2213,  2214,     0,  2217,     0,     0,
       0,     0,  1952,     0,     0,     0,  4758,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2259,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4777,     0,  1959,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1959,     0,     0,     0,     0,  2313,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1953,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1953,     0,     0,     0,     0,     0,  2329,  2336,     0,
       0,     0,  2348,  2351,     0,     0,     0,     0,     0,     0,
    2329,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1959,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1952,     0,
    1959,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1959,  4861,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4872,
       0,     0,     0,     0,     0,     0,  1959,     0,     0,     0,
       0,  1953,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1953,
       0,     0,     0,     0,     0,     0,   678,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1953,   678,
       0,     0,     0,  1197,     0,     0,     0,     0,     0,  1959,
       0,     0,  1197,     0,     0,     0,     0,     0,     0,     0,
    1952,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3802,     0,     0,
       0,     0,     0,     0,     0,     0,  1953,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2329,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2329,     0,
     722,     0,     0,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4997,     0,     0,     0,     0,     0,     0,     0,     0,  5004,
       0,     0,     0,     0,  1952,     0,     0,  1197,  1197,     0,
       0,     0,     0,     0,  2329,  1197,     0,     0,  1197,     0,
       0,   678,  1197,     0,     0,     0,     0,  1952,     0,     0,
    1197,  1197,     0,     0,     0,     0,     0,     0,  1197,     0,
       0,  1197,  1197,  1197,  1197,     0,     0,     0,     0,     0,
       0,  1197,  1197,     0,  1197,     0,  1197,  1197,     0,     0,
    1197,     0,     0,  1952,     0,     0,     0,     0,     0,     0,
       0,     0,  1953,     0,     0,     0,  1959,  1197,     0,     0,
       0,     0,  1197,     0,     0,     0,  1197,     0,  3802,     0,
    1197,     0,  1197,  1197,  1197,  1197,  1197,  1197,  1197,  1197,
    1197,     0,  1197,  1952,     0,     0,     0,  1952,  1952,     0,
       0,  2329,  1197,  1197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  5095,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  5106,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  5117,  1197,     0,     0,     0,  5121,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1953,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2897,
       0,  3107,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  5158,     0,     0,     0,     0,     0,
       0,     0,  2920,     0,     0,  2922,     0,  1954,  2933,     0,
       0,     0,     0,     0,     0,  2940,  2945,     0,     0,     0,
       0,  2951,     0,     0,  2956,     0,     0,     0,     0,     0,
       0,     0,  1959,     0,     0,     0,  1959,  1959,     0,     0,
       0,  2965,     0,     0,     0,     0,  2972,     0,     0,     0,
    2984,     0,     0,     0,  2991,     0,  2993,  2994,  2995,  2996,
    2997,  2998,  2999,  3000,  3001,     0,  3002,     0,  1953,     0,
       0,     0,     0,     0,     0,     0,  1567,  3030,     0,  1197,
       0,     0,     0,   678,     0,     0,     0,     0,     0,     0,
    1197,  1953,     0,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1953,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1641,
       0,     0,  1959,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1953,     0,     0,
    1954,  1953,  1953,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     4,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     6,     7,     0,     0,     0,     0,     0,     0,     9,
      10,  2253,     0,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3166,     0,     0,     0,  1197,     0,  1959,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2253,     0,     0,     0,   678,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1959,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    48,     0,
       0,     0,  1197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1954,     0,     0,     0,     0,     0,
      50,     0,     0,     0,  2404,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1959,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,     0,   678,  1197,    51,     0,     0,    52,
       0,  3383,     0,     0,     0,     0,     0,     0,  1954,     0,
       0,     0,  1197,  1197,    53,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1954,     0,     0,  1197,  1197,     0,   678,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1197,  1197,  1197,  1197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,  1197,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1197,  1197,
      54,     0,  1197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1197,     0,  1197,     0,     0,
       0,  1197,     0,     0,     0,     0,     0,  1954,     0,     0,
       0,     0,     0,     0,     0,     0,  3507,     0,     0,     0,
    1197,   678,    55,     0,     0,     0,  1954,     0,     0,     0,
    1197,     0,     0,  1197,  1197,  1197,    56,     0,     0,     0,
       0,     0,     0,     0,  1954,     0,     0,     0,     0,   678,
       0,    57,     0,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1197,     0,  1954,     0,     0,  1197,     0,     0,     0,    58,
       0,  1197,     0,     0,     0,     0,    59,     0,     0,  1197,
      60,    61,    62,    63,    64,     0,     0,    65,    66,  1397,
    2799,     0,     0,     0,    71,     0,     0,  3556,     0,     0,
       0,     0,  3562,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1959,     0,     0,
    1959,     0,  1959,     0,     0,  1954,  2253,  1959,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2945,     0,  2945,  2945,     0,     0,
    1197,     0,     0,     0,     0,     0,     0,  3619,     0,     0,
    3622,     0,  3624,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1959,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3645,
       0,  3647,     0,     0,     0,  3650,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1959,  2253,     0,
       0,     0,     0,     0,     0,   722,     0,  3030,  3030,  3030,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2253,     0,     0,     0,     0,  2929,     0,     0,
       0,  3713,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2336,     0,     0,  2253,  2253,  3725,
       0,  2253,     0,     0,   678,  2351,     0,     0,  1959,     0,
    1959,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2253,     0,     0,     0,     0,     0,     0,
       0,     0,  1954,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1959,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3771,     0,     0,     0,     0,     0,
    1959,     0,     0,     0,     0,     0,     0,  2253,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     4,     0,
       0,  1959,     0,     0,     0,     0,     0,     0,     0,     0,
    2253,     0,     0,     0,  1959,     0,     0,     0,     5,     0,
       0,     0,  2253,     0,     0,  2253,     0,     0,     6,     7,
       0,     0,     0,     0,     0,     0,     9,    10,     0,     0,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,     0,     0,  1959,    45,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1959,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1959,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,  1954,     0,
       0,     0,  1954,  1954,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1197,     0,     0,  1959,
       0,     0,     0,     0,     0,     0,  1197,     0,     0,     0,
       0,     0,  1197,     0,  1197,     0,     0,    47,   678,  1959,
    1197,     0,     0,  1197,  1197,  1197,  1197,  1197,  1197,  1197,
    1197,  1197,  1197,     0,     0,    48,  1197,  1197,     0,     0,
       0,     0,     0,     0,  1959,     0,     0,     0,     0,  1197,
       0,     0,     0,  1197,     0,    49,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,  1954,     0,
    1197,     0,  1197,     0,     0,     0,     0,    50,     0,     0,
    1959,  1197,  1197,  1197,     0,     0,     0,  1197,     0,     0,
    1197,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1197,     0,  1197,     0,     0,     0,
       0,     0,     0,    51,     0,     0,    52,     0,  1197,     0,
       0,     0,     0,     0,  1197,  1197,     0,     0,     0,     0,
       0,    53,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,  1197,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1959,     0,     0,
    4097,     0,     0,     0,     0,     0,     0,    54,     0,     0,
    4101,     0,     0,  1197,     0,  1954,  4102,     0,  4103,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4121,  4122,     0,     0,     0,     0,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2951,     0,    56,     0,     0,     0,     0,     0,     0,
       0,  4150,     0,     0,  4153,     0,  4155,     0,    57,     0,
       0,     0,     0,     0,     0,  4159,     0,     0,  1959,     0,
    1954,  4164,     0,     0,  4167,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    58,     0,     0,     0,
       0,     0,     0,    59,     0,     0,     0,    60,    61,    62,
      63,    64,  4208,     0,    65,    66,  1397,     0,  4215,  3030,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4230,     0,     0,     0,     0,     0,  1567,
       0,     0,     0,     0,     0,  1641,     0,     0,     0,     0,
    1954,  2253,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,  2253,     0,  2253,     0,  2929,  2929,
    3593,     0,     0,  2929,     0,     0,     0,  2253,     0,     0,
       0,     0,     0,     0,  2253,  1959,     0,     0,     0,  2253,
       0,     0,     0,     0,     0,  2253,     0,     0,     0,     0,
    2253,     0,     0,     0,     0,     0,     0,     0,     0,  2253,
       0,     0,     0,  2929,  2929,     0,  2253,     0,     0,     0,
       0,     0,  1959,  1197,  1197,     0,     0,     0,  2253,     0,
       0,     0,     0,     0,     0,  2253,     0,  2253,  2253,  2253,
    2253,  2253,  2253,  2253,  2253,  2253,  2253,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2253,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1197,  1197,     0,  1959,     0,     0,     0,     0,
    1197,  1197,     0,     0,     0,  1197,  1959,     0,     0,     0,
       0,  1197,  1197,     0,     0,  1197,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,  1197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
    1197,     0,     0,  1954,     0,  1197,  1954,     0,  1954,     0,
    2253,     0,     0,  1954,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4487,  4488,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1954,     0,     0,  1959,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4520,
       0,     0,     0,     0,  1959,     0,     0,     0,     0,     0,
       0,     0,     0,  1954,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1959,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4538,  4540,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4547,
       0,     0,     0,     0,     0,  4552,  4553,     0,     0,  4555,
       0,  1959,  4558,     0,  1954,     0,  1954,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3030,
       0,     0,     0,     0,  3030,     0,     0,     0,     0,  3030,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1197,  1954,     0,     0,     0,     0,     0,  2253,     0,     0,
       0,  1197,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1954,     0,     0,     0,
       0,     0,  4616,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1954,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1959,
    1954,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,     0,  1959,     0,     0,
       0,     0,  1197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1197,
    1197,     0,     0,  1197,  1954,     0,     0,     0,     0,     0,
       0,  2253,     0,     0,     0,     0,  1197,     0,     0,     0,
    1954,  1197,     0,     0,     0,     0,  1197,     0,     0,  1197,
       0,     0,     0,  1954,  1197,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2253,     0,     0,     0,     0,     0,  2253,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3593,  3593,  4719,  2929,     0,     0,  2929,  2929,
    2929,  2929,  2929,  2929,  2929,  2929,  2929,  2929,  3593,  1959,
       0,     0,     0,     0,     0,  1954,     0,     0,     0,  1197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2253,     0,  1954,  2253,     0,  2253,     0,
       0,     0,     0,  3593,  3593,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2929,  2929,  2253,
    1954,  2253,     0,     0,  2253,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1954,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4803,     0,     0,
       0,  1197,     0,  1959,     0,     0,     0,  2253,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2253,
       0,     0,     0,     0,     0,  1197,  1959,     0,  1197,  4826,
    1197,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,     0,  1197,     0,     0,
       0,     0,  1959,     0,     0,  2253,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1954,     0,     0,     0,     0,     0,     0,
       0,     0,  1959,     0,     0,     0,  1959,  1959,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1197,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1954,     0,  1959,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1197,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2951,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4973,     0,     0,
       0,     0,     0,  2929,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1197,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1954,     0,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1954,     0,
    5047,     0,     0,     0,     0,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2253,  1197,     0,     0,  2253,  2253,  2253,     0,     0,
    3593,     0,     0,     0,     0,  3593,  3593,  3593,  3593,  3593,
    3593,  3593,  3593,  3593,  3593,  2253,  2253,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  5096,  2253,  2929,  2929,  2253,     0,  2253,
       0,     0,     0,  2253,  3593,  3593,     0,     0,  2253,     0,
    1197,  2253,     0,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1954,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1954,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2253,     0,     0,     0,     0,     0,     0,  2253,
       0,     0,     0,     0,     0,     0,     0,     0,  5142,  5142,
       0,     0,     0,     0,  2253,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  5142,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  5198,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1954,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1954,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1954,
       0,     0,     0,     0,  5142,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1954,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3593,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2253,  2253,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2253,     0,     0,     0,  2929,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2253,     0,  2253,     0,     0,     0,     0,  3593,
    3593,  2253,     0,     0,  2929,  2929,  2253,  2253,     0,  2253,
       0,     0,  2253,     0,    86,    87,    88,     0,    90,    91,
      92,     0,     0,  1954,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,     0,     0,     0,   107,
     108,   109,   110,     0,   111,   112,   113,   114,   115,     0,
     116,   117,   118,     0,     0,     0,     0,     0,   121,   122,
       0,     0,     0,     0,   123,     0,     0,     0,     0,     0,
    2253,     0,     0,   124,     0,   125,     0,   126,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,     0,     0,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,  1954,     0,     0,     0,     0,
     144,     0,   145,     0,     0,     0,     0,     0,   148,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   151,
       0,     0,     0,  2253,     0,   152,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   155,   156,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   162,     0,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,   166,     0,     0,     0,     0,     0,
     168,     0,     0,     0,     0,     0,   169,     0,   170,  3593,
    2929,     0,     0,     0,   172,     0,     0,     0,     0,     0,
       0,     0,     0,   173,     0,  3593,  3593,  2253,     0,  1954,
       0,     0,     0,     0,     0,     0,   174,   175,     0,     0,
       0,     0,     0,   176,     0,   177,     0,     0,   178,   179,
    2253,   180,  1954,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   181,   182,     0,   183,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,   190,  1954,     0,
     191,     0,     0,     0,   193,     0,     0,   194,     0,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   196,   197,     0,   198,   199,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   200,  1954,   201,
       0,     0,  1954,  1954,     0,     0,     0,     0,     0,     0,
       0,     0,   203,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   210,     0,     0,   212,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3593,   217,     0,     0,   219,     0,   220,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2253,     0,     0,
     222,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   224,   225,     0,     0,     0,   226,     0,   227,
       0,     0,     0,     0,     0,     0,     0,     0,   230,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   234,     0,     0,   235,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   237,   238,   239,   240,   241,   242,   243,   244,
     245,  2253,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3097,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2253,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,  2253,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,  2253,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,   739,   427,   428,   429,   740,
     741,   742,   743,   744,   745,   746,   430,   431,   747,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
     748,   437,   438,   439,   440,   441,   749,   750,   442,   443,
     751,   140,   444,   752,   445,   446,   447,   448,   144,   753,
     145,   754,   449,   450,   451,   452,   148,   453,   755,   756,
     454,   455,   456,   457,   458,   459,   757,   151,   460,   758,
     759,   760,   761,   152,   762,   763,   764,   461,   462,   463,
     464,   701,   465,   155,   156,   466,   765,   467,   766,   468,
     469,   470,   471,   472,   767,   473,   474,   475,   768,   769,
     476,   477,   478,   479,   480,   770,   481,   482,   483,   771,
     484,   485,   486,   772,   487,   488,   489,   490,   164,   491,
     492,   493,   166,   773,   494,   774,   495,   496,   168,   497,
     775,   498,   776,   499,   169,   777,   170,   500,   501,   502,
     778,   503,   172,   779,   504,   780,   505,   506,   703,   507,
     508,   173,   509,   510,   511,   781,   512,   513,   514,   515,
     516,   517,   782,   518,   174,   175,   783,   519,   520,   521,
     784,   176,   785,   177,   786,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,   787,   529,   530,   788,   531,
     181,   182,   532,   183,   789,   533,   534,   535,   790,   791,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,   189,   190,   547,   548,   191,   792,
     549,   550,   193,   551,   793,   194,   552,   195,   553,   554,
     555,   794,   556,   795,   796,   557,   558,   559,   797,   798,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,   799,   569,   200,   570,   201,   571,   572,
     573,   800,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,   801,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,   802,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,   803,   608,   609,   610,   611,   612,   804,   613,
     217,   614,   615,   219,   616,   220,   617,   805,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,   806,
     628,   629,   807,   630,   631,   632,   633,   634,   635,   808,
     224,   225,   809,   810,   637,   226,   638,   227,   811,   639,
     640,   641,   642,   643,   644,   645,   812,   813,   646,   647,
     648,   649,   650,   814,   815,   651,   652,   653,   654,   655,
     816,   234,   817,   656,   235,   657,   658,   659,   660,   818,
     819,   661,   820,   821,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,     0,    85,     0,     0,    86,    87,    88,    89,
      90,    91,    92,    93,     0,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   975,   104,   105,   106,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115,     0,   116,   117,   118,   119,   120,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
     127,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   129,     0,   130,   131,     0,     0,     0,     0,     0,
       0,     0,     0,   132,     0,   133,     0,     0,   134,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,   141,     0,
     142,   143,   144,     0,   145,     0,   146,     0,   147,     0,
     148,     0,     0,     0,     0,     0,     0,     0,   149,     0,
     150,   151,     0,     0,     0,     0,     0,   152,     0,     0,
       0,     0,     0,     0,   153,     0,   154,   155,   156,   157,
       0,     0,     0,     0,     0, -1424,     0,     0,     0,     0,
       0,   158,     0,   159,     0,     0,     0,   160,     0,     0,
       0,     0,     0,   161,   162,     0,     0,     0,     0,     0,
       0,   163,   164,   165,     0,     0,   166,     0,     0,   167,
       0,     0,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,   171,     0,   172,     0,     0,     0,
       0,     0,     0,     0,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   174,   175,
       0,     0, -1424,     0,     0,   176,     0,   177,     0,     0,
     178,   179,     0,   180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   181,   182,     0,   183,     0,   184,
     185,     0,     0,     0,     0,   186,     0,     0,     0,     0,
       0,     0,     0,     0,   187,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,   192,   193,     0,     0,   194,
       0,   195,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   196,   197,     0,   198,   199,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   200,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,   208,     0,
       0,     0,     0,   209,   210,     0,   211,   212,     0,     0,
     213,     0,     0,     0,     0,   214,   215,     0,     0,     0,
       0,     0,     0,   216,   217,     0,   218,   219,     0,   220,
       0,     0,     0,     0,   221,     0,     0,     0,     0,     0,
       0,     0,   222,     0,     0,     0,   223,     0,     0,     0,
       0,     0,     0,     0,   224,   225,     0,     0,     0,   226,
       0,   227,     0,   228,     0,   229,     0,     0,     0,     0,
     230,     0,     0,   231,     0,     0, -1424,     0,     0,   232,
       0,     0,     0,     0,   233,   234,     0,     0,   235,     0,
       0,     0,     0,     0,     0,     0,     0,   236,     0,     0,
       0,     0,     0,     0,   237,   238,   239,   240,   241,   242,
     243,   244,   245,     0,    86,    87,    88,     0,    90,    91,
      92,     0,     0,     0,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   246,   104,   105,     0,  -138,     0,   107,
     108,   109,   110,     0,   111,   112,   113,   114,   115,     0,
     116,   117,   118,     0,     0,     0,     0,     0,   121,   122,
       0,     0,     0,     0,   123,     0,     0,     0,     0,     0,
       0,     0,     0,   124,     0,   125,     0,   126,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,     0,     0,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
     144,     0,   145,     0,     0,     0,     0,     0,   148,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   151,
       0,     0,     0,     0,     0,   152,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   155,   156,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   162,     0,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,   166,     0,     0,     0,     0,     0,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   172,     0,     0,     0,     0,     0,
       0,     0,     0,   173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   175,     0,     0,
       0,     0,     0,   176,     0,   177,     0,     0,   178,   179,
       0,   180,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   181,   182,     0,   183,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,   193,     0,     0,   194,     0,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   196,   197,     0,   198,   199,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   200,     0,   201,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   203,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   210,     0,     0,   212,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   217,     0,     0,   219,     0,   220,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   224,   225,     0,     0,     0,   226,     0,   227,
       0,     0,     0,     0,     0,     0,     0,     0,   230,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   234,     0,     0,   235,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   237,   238,   239,   240,   241,   242,   243,   244,
     245,     0,     0,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,  3099,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
     418,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1486,  1487,  1488,    45,  1489,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,  3024,   427,   428,
     429,     0,     0,     0,     0,  1490,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,  1491,   137,
    1492,  1493,     0,   437,   438,   439,   440,   441,  1494,  1495,
     442,   443,  1496,  1497,   444,     0,   445,   446,   447,   448,
    1498,     0,  1499,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,
     462,   463,   464,   701,   465,  1507,  1508,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
    3025,     0,   476,   477,  1509,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
    1510,   491,   492,   493,  1511,  1512,   494,     0,   495,   496,
    1513,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1514,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,  1515,  1516,     0,  1517,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,  1518,   182,   532,   183,     0,   533,   534,   535,
    1519,  1520,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,  1521,   189,  1522,   547,   548,
     191,  1523,   549,   550,   193,   551,  1524,  1525,   552,  1526,
     553,   554,   555,     0,   556,     0,     0,  1527,   558,   559,
       0,     0,   560,   196,   197,   561,   198,  1528,   562,   563,
     564,   565,   566,   567,   568,     0,   569,  1529,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,  1530,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,  1531,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
    1532,   613,   217,   614,   615,   219,   616,  1533,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
    1534,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,  1535,  1536,     0,     0,   637,  1537,   638,  1538,
    1539,   639,   640,   641,   642,   643,   644,   645,     0,  1540,
     646,   647,   648,   649,   650,  1541,     0,   651,   652,   653,
     654,   655,   707,  1542,  3026,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,  1543,  1544,  1545,  1546,  1547,  1548,  1549,
    1550,   708,   668,   669,     0,     0,     0,     0,     0,     0,
       0,     0,  1551,  1552,  3027,     0,     0,     0,     0,     0,
       0,  1554,  3028,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
     418,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1486,  1487,  1488,    45,  1489,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,  1490,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,  1491,   137,
    1492,  1493,     0,   437,   438,   439,   440,   441,  1494,  1495,
     442,   443,  1496,  1497,   444,     0,   445,   446,   447,   448,
    1498,     0,  1499,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,
     462,   463,   464,   701,   465,  1507,  1508,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1509,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
    1510,   491,   492,   493,  1511,  1512,   494,     0,   495,   496,
    1513,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1514,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,  1515,  1516,     0,  1517,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,  1518,   182,   532,   183,     0,   533,   534,   535,
    1519,  1520,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,  1521,   189,  1522,   547,   548,
     191,  1523,   549,   550,   193,   551,  1524,  1525,   552,  1526,
     553,   554,   555,     0,   556,     0,     0,  1527,   558,   559,
       0,     0,   560,   196,   197,   561,   198,  1528,   562,   563,
     564,   565,   566,   567,   568,     0,   569,  1529,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,  1530,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,  1531,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
    1532,   613,   217,   614,   615,   219,   616,  1533,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
    1534,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,  1535,  1536,     0,     0,   637,  1537,   638,  1538,
    1539,   639,   640,   641,   642,   643,   644,   645,     0,  1540,
     646,   647,   648,   649,   650,  1541,     0,   651,   652,   653,
     654,   655,   707,  1542,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,  1543,  1544,  1545,  1546,  1547,  1548,  1549,
    1550,   708,   668,   669,     0,     0,     0,     0,     0,     0,
       0,     0,  1551,  1552,     0,     0,     0,     0,     0,     0,
       0,  1554,  2931,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,     0,  1925,   137,
    1926,  1927,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,  1928,  1929,   444,     0,   445,   446,   447,   448,
       0,     0,   145,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,   701,   465,  1930,  1931,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1509,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
       0,   491,   492,   493,     0,     0,   494,     0,   495,   496,
    1932,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,     0,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,  2419,   512,   513,
     514,   515,   516,   517,     0,   518,   174,  2420,     0,   519,
     520,   521,  1515,  1933,     0,  1934,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,     0,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,  1935,   189,  1936,   547,   548,
       0,     0,   549,   550,   193,   551,     0,     0,   552,  1937,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,  2422,   197,   561,   198,     0,   562,   563,
     564,   565,   566,   567,   568,     0,   569,     0,   570,     0,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,  1938,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,     0,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
       0,   613,  2423,   614,   615,   219,   616,  1940,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
       0,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,  1941,  1942,     0,     0,   637,     0,   638,     0,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,     0,  1943,  2424,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   708,   668,   669,     0,     0,     0,     0,     0,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,  2522,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,     0,  1925,   137,  1926,  1927,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,  1928,  1929,
     444,     0,   445,   446,   447,   448,     0,     0,   145,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,   701,
     465,  1930,  1931,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1509,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,     0,   491,   492,   493,
       0,     0,   494,     0,   495,   496,  1932,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
       0,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,  2419,   512,   513,   514,   515,   516,   517,
       0,   518,   174,  2420,     0,   519,   520,   521,  1515,  1933,
       0,  1934,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,     0,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1935,   189,  1936,   547,   548,     0,     0,   549,   550,
     193,   551,     0,     0,   552,  1937,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,  2422,
     197,   561,   198,     0,   562,   563,   564,   565,   566,   567,
     568,     0,   569,     0,   570,     0,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1938,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,     0,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,  2423,   614,
     615,   219,   616,  1940,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,     0,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1941,  1942,
       0,     0,   637,     0,   638,     0,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,  1943,
    2424,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   708,   668,   669,
       0,     0,     0,     0,     0,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,  3469,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1486,  1487,  1488,    45,  1489,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,  1490,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
    1491,   137,  1492,  1493,  2941,   437,   438,   439,   440,   441,
    1494,  1495,   442,   443,  1496,  1497,   444,     0,   445,   446,
     447,   448,  1498,     0,  1499,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,  1500,  1501,  1502,  1503,  1504,  1505,
    1506,   461,   462,   463,   464,   701,   465,  1507,  1508,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1509,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,  1510,   491,   492,   493,  1511,  1512,   494,     0,
     495,   496,  1513,   497,     0,   498,     0,   499,   169,  2942,
     170,   500,   501,   502,     0,   503,  1514,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,  1515,  1516,     0,  1517,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,  2943,   531,  1518,   182,   532,   183,     0,   533,
     534,   535,  1519,  1520,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1521,   189,  1522,
     547,   548,   191,  1523,   549,   550,   193,   551,  1524,  1525,
     552,  1526,   553,   554,   555,     0,   556,     0,     0,  1527,
     558,   559,     0,     0,   560,   196,   197,   561,   198,  1528,
     562,   563,   564,   565,   566,   567,   568,     0,   569,  1529,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1530,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,  1531,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,  1532,   613,   217,   614,   615,   219,   616,  1533,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,  1534,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1535,  1536,     0,  2944,   637,  1537,
     638,  1538,  1539,   639,   640,   641,   642,   643,   644,   645,
       0,  1540,   646,   647,   648,   649,   650,  1541,     0,   651,
     652,   653,   654,   655,   707,  1542,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,  1543,  1544,  1545,  1546,  1547,
    1548,  1549,  1550,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1551,  1552,     0,     0,     0,     0,
       0,     0,     0,  1554,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,   418,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1486,  1487,  1488,    45,  1489,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,  1490,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,   135,  1491,
     137,  1492,  1493,     0,   437,   438,   439,   440,   441,  1494,
    1495,   442,   443,  1496,  1497,   444,     0,   445,   446,   447,
     448,  1498,     0,  1499,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,
     461,   462,   463,   464,   701,   465,  1507,  1508,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1509,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,  1510,   491,   492,   493,  1511,  1512,   494,     0,   495,
     496,  1513,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,  1514,     0,   504,     0,   505,
     506,   703,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,   175,     0,
     519,   520,   521,  1515,  1516,     0,  1517,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,  1518,   182,   532,   183,     0,   533,   534,
     535,  1519,  1520,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,  1521,   189,  1522,   547,
     548,   191,  1523,   549,   550,   193,   551,  1524,  1525,   552,
    1526,   553,   554,   555,     0,   556,     0,     0,  1527,   558,
     559,     0,     0,   560,   196,   197,   561,   198,  1528,   562,
     563,   564,   565,   566,   567,   568,     0,   569,  1529,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,  1530,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,  1531,   601,   602,   603,
     604,   605,   606,   706,   607,   215,   608,   609,   610,   611,
     612,  1532,   613,   217,   614,   615,   219,   616,  1533,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1534,     0,   628,   629,   223,   630,   631,   632,   633,
     634,   635,     0,  1535,  1536,     0,     0,   637,  1537,   638,
    1538,  1539,   639,   640,   641,   642,   643,   644,   645,     0,
    1540,   646,   647,   648,   649,   650,  1541,     0,   651,   652,
     653,   654,   655,  2215,  1542,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,   236,   662,   663,   664,
     665,   666,   667,   237,  1543,  1544,  1545,  1546,  1547,  1548,
    1549,  1550,   708,   668,   669,     0,     0,     0,     0,     0,
       0,     0,     0,  1551,  1552,     0,     0,     0,     0,     0,
       0,     0,  1554,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
     418,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1486,  1487,  1488,    45,  1489,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,  1490,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,  1491,   137,
    1492,  1493,     0,   437,   438,   439,   440,   441,  1494,  1495,
     442,   443,  1496,  1497,   444,     0,   445,   446,   447,   448,
    1498,     0,  1499,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,
     462,   463,   464,   701,   465,  1507,  1508,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1509,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
    1510,   491,   492,   493,  1511,  1512,   494,     0,   495,   496,
    1513,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1514,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,  1515,  1516,     0,  1517,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,  1518,   182,   532,   183,     0,   533,   534,   535,
    1519,  1520,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,  1521,   189,  1522,   547,   548,
     191,  1523,   549,   550,   193,   551,  1524,  1525,   552,  1526,
     553,   554,   555,     0,   556,     0,     0,  1527,   558,   559,
       0,     0,   560,   196,   197,   561,   198,  1528,   562,   563,
     564,   565,   566,   567,   568,     0,   569,  1529,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,  1530,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,  1531,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
    1532,   613,   217,   614,   615,   219,   616,  1533,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
    1534,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,  1535,  1536,     0,     0,   637,  1537,   638,  1538,
    1539,   639,   640,   641,   642,   643,   644,   645,     0,  1540,
     646,   647,   648,   649,   650,  1541,     0,   651,   652,   653,
     654,   655,   707,  1542,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,  1543,  1544,  1545,  1546,  1547,  1548,  1549,
    1550,   708,   668,   669,     0,     0,     0,     0,     0,     0,
       0,     0,  1551,  1552,     0,     0,     0,     0,     0,  2159,
    2889,  1554,   732,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   733,   104,   105,   687,   734,     0,   107,   108,
     109,   110,   735,   736,   112,   113,   114,   115,     0,   116,
     737,   738,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,   418,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1486,  1487,  1488,    45,  1489,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,  1490,     0,     0,   430,   431,     0,
     432,   433,   133,   434,   435,   436,   135,  1491,   137,  1492,
    1493,     0,   437,   438,   439,   440,   441,  1494,  1495,   442,
     443,  1496,  1497,   444,     0,   445,   446,   447,   448,  1498,
       0,  1499,     0,   449,   450,   451,   452,   148,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,   151,   460,
       0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,   462,
     463,   464,   701,   465,  1507,  1508,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1509,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,  1510,
     491,   492,   493,  1511,  1512,   494,     0,   495,   496,  1513,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,  1514,     0,   504,     0,   505,   506,   703,
     507,   508,   173,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,   174,   175,     0,   519,   520,
     521,  1515,  1516,     0,  1517,     0,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,  1518,   182,   532,   183,     0,   533,   534,   535,  1519,
    1520,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,  1521,   189,  1522,   547,   548,   191,
    1523,   549,   550,   193,   551,  1524,  1525,   552,  1526,   553,
     554,   555,     0,   556,     0,     0,  1527,   558,   559,     0,
       0,   560,   196,   197,   561,   198,  1528,   562,   563,   564,
     565,   566,   567,   568,     0,   569,  1529,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,  1530,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   210,   599,   600,  1531,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,  1532,
     613,   217,   614,   615,   219,   616,  1533,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1534,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,  1535,  1536,     0,     0,   637,  1537,   638,  1538,  1539,
     639,   640,   641,   642,   643,   644,   645,     0,  1540,   646,
     647,   648,   649,   650,  1541,     0,   651,   652,   653,   654,
     655,   707,  1542,     0,   656,   235,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,  1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,
     708,   668,   669,     0,     0,     0,     0,     0,     0,     0,
       0,  1551,  1552,  1553,     0,     0,     0,     0,     0,     0,
    1554,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1486,
    1487,  1488,    45,  1489,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,  1490,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,  1491,   137,  1492,  1493,
       0,   437,   438,   439,   440,   441,  1494,  1495,   442,   443,
    1496,  1497,   444,     0,   445,   446,   447,   448,  1498,     0,
    1499,     0,   449,   450,   451,   452,   148,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
    1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,   462,   463,
     464,   701,   465,  1507,  1508,   466,  1640,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1509,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,  1510,   491,
     492,   493,  1511,  1512,   494,     0,   495,   496,  1513,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1514,     0,   504,     0,   505,   506,   703,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
    1515,  1516,     0,  1517,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
    1518,   182,   532,   183,     0,   533,   534,   535,  1519,  1520,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,  1521,   189,  1522,   547,   548,   191,  1523,
     549,   550,   193,   551,  1524,  1525,   552,  1526,   553,   554,
     555,     0,   556,     0,     0,  1527,   558,   559,     0,     0,
     560,   196,   197,   561,   198,  1528,   562,   563,   564,   565,
     566,   567,   568,     0,   569,  1529,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
    1530,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,  1531,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,  1532,   613,
     217,   614,   615,   219,   616,  1533,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,  1534,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1535,  1536,     0,     0,   637,  1537,   638,  1538,  1539,   639,
     640,   641,   642,   643,   644,   645,     0,  1540,   646,   647,
     648,   649,   650,  1541,     0,   651,   652,   653,   654,   655,
     707,  1542,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,  1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,
     668,   669,     0,     0,     0,     0,     0,     0,     0,     0,
    1551,  1552,     0,     0,     0,     0,     0,     0,     0,  1554,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,   418,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1486,  1487,
    1488,    45,  1489,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,  2346,   427,   428,   429,     0,     0,
       0,     0,  1490,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,   135,  1491,   137,  1492,  1493,     0,
     437,   438,   439,   440,   441,  1494,  1495,   442,   443,  1496,
    1497,   444,     0,   445,   446,   447,   448,  1498,     0,  1499,
       0,   449,   450,   451,   452,   148,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,  1500,
    1501,  1502,  1503,  1504,  1505,  1506,   461,   462,   463,   464,
     701,   465,  1507,  1508,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1509,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,  1510,   491,   492,
     493,  1511,  1512,   494,     0,   495,   496,  1513,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,  1514,     0,   504,     0,   505,   506,   703,   507,   508,
     173,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,   175,     0,   519,   520,   521,  1515,
    1516,     0,  1517,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,  1518,
     182,   532,   183,     0,   533,   534,   535,  1519,  1520,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,  1521,   189,  1522,   547,   548,   191,  1523,   549,
     550,   193,   551,  1524,  1525,   552,  1526,   553,   554,   555,
       0,   556,     0,     0,  1527,   558,   559,     0,     0,   560,
     196,   197,   561,   198,  1528,   562,   563,   564,   565,   566,
     567,   568,     0,   569,  1529,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,  1530,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,  1531,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,  1532,   613,   217,
     614,   615,   219,   616,  1533,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1534,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,  1535,
    1536,     0,     0,   637,  1537,   638,  1538,  1539,   639,   640,
     641,   642,   643,   644,   645,     0,  1540,   646,   647,   648,
     649,   650,  1541,     0,   651,   652,   653,   654,   655,   707,
    1542,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
    1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,   668,
     669,     0,     0,     0,     0,     0,     0,     0,     0,  1551,
    1552,     0,     0,     0,     0,     0,     0,     0,  1554,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1486,  1487,  1488,
      45,  1489,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,  1490,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,  1491,   137,  1492,  1493,     0,   437,
     438,   439,   440,   441,  1494,  1495,   442,   443,  1496,  1497,
     444,     0,   445,   446,   447,   448,  1498,     0,  1499,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,  1500,  1501,
    1502,  1503,  1504,  1505,  1506,   461,   462,   463,   464,   701,
     465,  1507,  1508,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1509,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,  1510,   491,   492,   493,
    1511,  1512,   494,     0,   495,   496,  1513,   497,     0,   498,
       0,   499,   169,  2942,   170,   500,   501,   502,     0,   503,
    1514,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,  1515,  1516,
       0,  1517,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,  1518,   182,
     532,   183,     0,   533,   534,   535,  1519,  1520,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1521,   189,  1522,   547,   548,   191,  1523,   549,   550,
     193,   551,  1524,  1525,   552,  1526,   553,   554,   555,     0,
     556,     0,     0,  1527,   558,   559,     0,     0,   560,   196,
     197,   561,   198,  1528,   562,   563,   564,   565,   566,   567,
     568,     0,   569,  1529,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1530,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,  1531,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,  1532,   613,   217,   614,
     615,   219,   616,  1533,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,  1534,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1535,  1536,
       0,     0,   637,  1537,   638,  1538,  1539,   639,   640,   641,
     642,   643,   644,   645,     0,  1540,   646,   647,   648,   649,
     650,  1541,     0,   651,   652,   653,   654,   655,   707,  1542,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,  1543,
    1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,   668,   669,
       0,     0,     0,     0,     0,     0,     0,     0,  1551,  1552,
       0,     0,     0,     0,     0,     0,     0,  1554,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,   418,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1486,  1487,  1488,    45,
    1489,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
    1490,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,   135,  1491,   137,  1492,  1493,     0,   437,   438,
     439,   440,   441,  1494,  1495,   442,   443,  1496,  1497,   444,
       0,   445,   446,   447,   448,  1498,     0,  1499,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,  1500,  1501,  1502,
    1503,  1504,  1505,  1506,   461,   462,   463,   464,   701,   465,
    1507,  1508,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,  1509,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,  1510,   491,   492,   493,  1511,
    1512,   494,     0,   495,   496,  1513,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,  1514,
       0,   504,     0,   505,   506,   703,   507,   508,   173,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,   174,   175,     0,   519,   520,   521,  1515,  1516,     0,
    1517,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,  1518,   182,   532,
     183,     0,   533,   534,   535,  1519,  1520,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
    1521,   189,  1522,   547,   548,   191,  1523,   549,   550,   193,
     551,  1524,  1525,   552,  1526,   553,   554,   555,     0,   556,
       0,     0,  1527,   558,   559,     0,     0,   560,   196,   197,
     561,   198,  1528,   562,   563,   564,   565,   566,   567,   568,
       0,   569,  1529,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,  1530,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
    1531,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,  1532,   613,   217,   614,   615,
     219,   616,  1533,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1534,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,  1535,  1536,     0,
       0,   637,  1537,   638,  1538,  1539,   639,   640,   641,   642,
     643,   644,   645,     0,  1540,   646,   647,   648,   649,   650,
    1541,     0,   651,   652,   653,   654,   655,   707,  1542,  4216,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,  1543,  1544,
    1545,  1546,  1547,  1548,  1549,  1550,   708,   668,   669,     0,
       0,     0,     0,     0,     0,     0,     0,  1551,  1552,     0,
       0,     0,     0,     0,     0,     0,  1554,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,   418,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1486,  1487,  1488,    45,  1489,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,  1490,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,  1491,   137,  1492,  1493,     0,   437,   438,   439,
     440,   441,  1494,  1495,   442,   443,  1496,  1497,   444,     0,
     445,   446,   447,   448,  1498,     0,  1499,     0,   449,   450,
     451,   452,   148,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,  4229,  1500,  1501,  1502,  1503,
    1504,  1505,  1506,   461,   462,   463,   464,   701,   465,  1507,
    1508,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,  1509,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,  1510,   491,   492,   493,  1511,  1512,
     494,     0,   495,   496,  1513,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1514,     0,
     504,     0,   505,   506,   703,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,  1515,  1516,     0,  1517,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,  1518,   182,   532,   183,
       0,   533,   534,   535,  1519,  1520,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,  1521,
     189,  1522,   547,   548,   191,  1523,   549,   550,   193,   551,
    1524,  1525,   552,  1526,   553,   554,   555,     0,   556,     0,
       0,  1527,   558,   559,     0,     0,   560,   196,   197,   561,
     198,  1528,   562,   563,   564,   565,   566,   567,   568,     0,
     569,  1529,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,  1530,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,  1531,
     601,   602,   603,   604,   605,   606,   706,   607,     0,   608,
     609,   610,   611,   612,  1532,   613,   217,   614,   615,   219,
     616,  1533,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,  1534,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,  1535,  1536,     0,     0,
     637,  1537,   638,  1538,  1539,   639,   640,   641,   642,   643,
     644,   645,     0,  1540,   646,   647,   648,   649,   650,  1541,
       0,   651,   652,   653,   654,   655,   707,  1542,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,  1543,  1544,  1545,
    1546,  1547,  1548,  1549,  1550,   708,   668,   669,     0,     0,
       0,     0,     0,     0,     0,     0,  1551,  1552,     0,     0,
       0,     0,     0,     0,     0,  1554,   732,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   733,   104,   105,   687,
     734,     0,   107,   108,   109,   110,   735,   736,   112,   113,
     114,   115,     0,   116,   737,   738,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,   418,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1486,  1487,  1488,    45,  1489,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,  1490,     0,
       0,   430,   431,     0,   432,   433,   133,   434,   435,   436,
    5139,  1491,   137,  1492,  1493,     0,   437,   438,   439,   440,
     441,  1494,  1495,   442,   443,  1496,  1497,   444,     0,   445,
     446,   447,   448,  1498,     0,  1499,     0,   449,   450,   451,
     452,   148,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,   151,   460,  5140,  1500,  1501,  1502,  1503,  1504,
    1505,  1506,   461,   462,   463,   464,   701,   465,  1507,  1508,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1509,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,  1510,   491,   492,   493,  1511,  1512,   494,
       0,   495,   496,  1513,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,  1514,     0,   504,
       0,   505,   506,   703,   507,   508,   173,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,   174,
     175,     0,   519,   520,   521,  1515,  1516,     0,  1517,     0,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,  1518,   182,   532,   183,     0,
     533,   534,   535,  1519,  1520,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,  1521,   189,
    1522,   547,   548,   191,  1523,   549,   550,   193,   551,  1524,
    1525,   552,  1526,   553,   554,   555,     0,   556,     0,     0,
    1527,   558,   559,     0,     0,   560,   196,   197,   561,   198,
    1528,   562,   563,   564,   565,   566,   567,   568,     0,   569,
    1529,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,  1530,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   210,   599,   600,  1531,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,  1532,   613,   217,   614,   615,   219,   616,
    1533,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1534,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,  1535,  1536,     0,     0,   637,
    1537,   638,  1538,  1539,   639,   640,   641,   642,  5141,   644,
     645,     0,  1540,   646,   647,   648,   649,   650,  1541,     0,
     651,   652,   653,   654,   655,   707,  1542,     0,   656,   235,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,  1543,  1544,  1545,  1546,
    1547,  1548,  1549,  1550,   708,   668,   669,     0,     0,     0,
       0,     0,     0,     0,     0,  1551,  1552,     0,     0,     0,
       0,     0,     0,     0,  1554,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1486,  1487,  1488,    45,  1489,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,  1490,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
    1491,   137,  1492,  1493,     0,   437,   438,   439,   440,   441,
    1494,  1495,   442,   443,  1496,  1497,   444,     0,   445,   446,
     447,   448,  1498,     0,  1499,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,  5140,  1500,  1501,  1502,  1503,  1504,  1505,
    1506,   461,   462,   463,   464,   701,   465,  1507,  1508,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1509,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,  1510,   491,   492,   493,  1511,  1512,   494,     0,
     495,   496,  1513,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1514,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,  1515,  1516,     0,  1517,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,  1518,   182,   532,   183,     0,   533,
     534,   535,  1519,  1520,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1521,   189,  1522,
     547,   548,   191,  1523,   549,   550,   193,   551,  1524,  1525,
     552,  1526,   553,   554,   555,     0,   556,     0,     0,  1527,
     558,   559,     0,     0,   560,   196,   197,   561,   198,  1528,
     562,   563,   564,   565,   566,   567,   568,     0,   569,  1529,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1530,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,  1531,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,  1532,   613,   217,   614,   615,   219,   616,  1533,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,  1534,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1535,  1536,     0,     0,   637,  1537,
     638,  1538,  1539,   639,   640,   641,   642,  5141,   644,   645,
       0,  1540,   646,   647,   648,   649,   650,  1541,     0,   651,
     652,   653,   654,   655,   707,  1542,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,  1543,  1544,  1545,  1546,  1547,
    1548,  1549,  1550,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1551,  1552,     0,     0,     0,     0,
       0,     0,     0,  1554,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,   418,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1486,  1487,  1488,    45,  1489,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,  1490,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,   135,  1491,
     137,  1492,  1493,     0,   437,   438,   439,   440,   441,  1494,
    1495,   442,   443,  1496,  1497,   444,     0,   445,   446,   447,
     448,  1498,     0,  1499,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,
     461,   462,   463,   464,   701,   465,  1507,  1508,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1509,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,  1510,   491,   492,   493,  1511,  1512,   494,     0,   495,
     496,  1513,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,  1514,     0,   504,     0,   505,
     506,   703,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,   175,     0,
     519,   520,   521,  1515,  1516,     0,  1517,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,  1518,   182,   532,   183,     0,   533,   534,
     535,  1519,  1520,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,  1521,   189,  1522,   547,
     548,   191,  1523,   549,   550,   193,   551,  1524,  1525,   552,
    1526,   553,   554,   555,     0,   556,     0,     0,  1527,   558,
     559,     0,     0,   560,   196,   197,   561,   198,  1528,   562,
     563,   564,   565,   566,   567,   568,     0,   569,  1529,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,  1530,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,  1531,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,  1532,   613,   217,   614,   615,   219,   616,  1533,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1534,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,  1535,  1536,     0,     0,   637,  1537,   638,
    1538,  1539,   639,   640,   641,   642,   643,   644,   645,     0,
    1540,   646,   647,   648,   649,   650,  1541,     0,   651,   652,
     653,   654,   655,   707,  1542,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,  1543,  1544,  1545,  1546,  1547,  1548,
    1549,  1550,   708,   668,   669,     0,     0,     0,     0,     0,
       0,     0,     0,  1551,  1552,     0,     0,     0,     0,     0,
       0,     0,  1554,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
     418,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1486,  1487,  1488,    45,  1489,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,  1490,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,  1491,   137,
    1492,  1493,     0,   437,   438,   439,   440,   441,  1494,  1495,
     442,   443,  1496,  1497,   444,     0,   445,   446,   447,   448,
    1498,     0,  1499,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,
     462,   463,   464,   701,   465,  1507,  1508,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1509,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
    1510,   491,   492,   493,  1511,  1512,   494,     0,   495,   496,
    1513,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1514,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,  1515,  1516,     0,  1517,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,  1518,   182,   532,   183,     0,   533,   534,   535,
    1519,  1520,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,  1521,   189,  1522,   547,   548,
     191,  1523,   549,   550,   193,   551,  1524,  1525,   552,  1526,
     553,   554,   555,     0,   556,     0,     0,  1527,   558,   559,
       0,     0,   560,   196,   197,   561,   198,  1528,   562,   563,
     564,   565,   566,   567,   568,     0,   569,  1529,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,  1530,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,  1531,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
    1532,   613,   217,   614,   615,   219,   616,  1533,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
    1534,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,  1535,  1536,     0,     0,   637,  1537,   638,  1538,
    1539,   639,   640,   641,   642,   643,   644,   645,     0,  1540,
     646,   647,   648,   649,   650,  1541,     0,   651,   652,   653,
     654,   655,   707,  1542,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,  4530,  1543,  1544,  1545,  1546,  1547,  1548,  1549,
    1550,   708,   668,   669,     0,     0,     0,     0,     0,     0,
       0,     0,  1551,  1552,     0,     0,     0,     0,     0,     0,
       0,  1554,   732,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   733,   104,   105,   687,   734,     0,   107,   108,
     109,   110,   735,   736,   112,   113,   114,   115,     0,   116,
     737,   738,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,   418,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1486,  1487,  1488,    45,  1489,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,  1490,     0,     0,   430,   431,     0,
     432,   433,   133,   434,   435,   436,   135,  1491,   137,  1492,
    1493,     0,   437,   438,   439,   440,   441,  1494,  1495,   442,
     443,  1496,  1497,   444,     0,   445,   446,   447,   448,  1498,
       0,  1499,     0,   449,   450,   451,   452,   148,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,   151,   460,
       0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,   462,
     463,   464,   701,   465,  1507,  1508,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1509,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,  1510,
     491,   492,   493,  1511,  1512,   494,     0,   495,   496,  1513,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,  1514,     0,   504,     0,   505,   506,   703,
     507,   508,   173,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,   174,   175,     0,   519,   520,
     521,  1515,  1516,     0,  1517,     0,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,  1518,   182,   532,   183,     0,   533,   534,   535,  1519,
    1520,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,  1521,   189,  1522,   547,  4539,   191,
    1523,   549,   550,   193,   551,  1524,  1525,   552,  1526,   553,
     554,   555,     0,   556,     0,     0,  1527,   558,   559,     0,
       0,   560,   196,   197,   561,   198,  1528,   562,   563,   564,
     565,   566,   567,   568,     0,   569,  1529,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,  1530,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   210,   599,   600,  1531,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,  1532,
     613,   217,   614,   615,   219,   616,  1533,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1534,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,  1535,  1536,     0,     0,   637,  1537,   638,  1538,  1539,
     639,   640,   641,   642,   643,   644,   645,     0,  1540,   646,
     647,   648,   649,   650,  1541,     0,   651,   652,   653,   654,
     655,   707,  1542,     0,   656,   235,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,  1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,
     708,   668,   669,     0,     0,     0,     0,     0,     0,     0,
       0,  1551,  1552,     0,     0,     0,     0,     0,     0,     0,
    1554,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1486,
    1487,  1488,    45,  1489,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,  1490,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,  1491,   137,  1492,  1493,
       0,   437,   438,   439,   440,   441,  1494,  1495,   442,   443,
    1496,  1497,   444,     0,   445,   446,   447,   448,  1498,     0,
    1499,     0,   449,   450,   451,   452,   148,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
    1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,   462,   463,
     464,   701,   465,  1507,  1508,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1509,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,  1510,   491,
     492,   493,  1511,  1512,   494,     0,   495,   496,  1513,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1514,     0,   504,     0,   505,   506,   703,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
    1515,  1516,     0,  1517,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
    1518,   182,   532,   183,     0,   533,   534,   535,  1519,  1520,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,  1521,   189,  1522,   547,   548,   191,     0,
     549,   550,   193,   551,  1524,  1525,   552,  1526,   553,   554,
     555,     0,   556,     0,     0,  1527,   558,   559,     0,     0,
     560,   196,   197,   561,   198,  1528,   562,   563,   564,   565,
     566,   567,   568,     0,   569,  1529,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
    1530,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,  1531,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,  1532,   613,
     217,   614,   615,   219,   616,  1533,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,  1534,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1535,  1536,     0,     0,   637,  1537,   638,  1538,  1539,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,  1541,     0,   651,   652,   653,   654,   655,
     707,  1542,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,  1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,
     668,   669,     0,     0,     0,     0,     0,     0,     0,     0,
    2924,  2925,     0,     0,     0,     0,     0,     0,     0,  1554,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,   418,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1486,  1487,
    1488,    45,  1489,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,  1490,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436, -2684,  1491,   137,  1492,  1493,     0,
     437,   438,   439,   440,   441,  1494,  1495,   442,   443,  1496,
    1497,   444,     0,   445,   446,   447,   448,  1498,     0,  1499,
       0,   449,   450,   451,   452,   148,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,  5140,  1500,
    1501,  1502,  1503,  1504,  1505,  1506,   461,   462,   463,   464,
     701,   465,  1507,  1508,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1509,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,  1510,   491,   492,
     493,  1511,  1512,   494,     0,   495,   496,  1513,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,  1514,     0,   504,     0,   505,   506,   703,   507,   508,
       0,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,   175,     0,   519,   520,   521,  1515,
    1516,     0,  1517,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,  1518,
     182,   532,     0,     0,   533,   534,   535,  1519,  1520,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,  1521,   189,  1522,   547,   548,   191,     0,   549,
     550,   193,   551,  1524,  1525,   552,  1526,   553,   554,   555,
       0,   556,     0,     0,  1527,   558,   559,     0,     0,   560,
     196,   197,   561,   198,  1528,   562,   563,   564,   565,   566,
     567,   568,     0,   569,  1529,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,  1530,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,  1531,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,  1532,   613,   217,
     614,   615,     0,   616,  1533,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1534,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,  1535,
    1536,     0,     0,   637,  1537,   638,  1538,  1539,   639,   640,
     641,   642,  5141,   644,   645,     0,  1540,   646,   647,   648,
     649,   650,  1541,     0,   651,   652,   653,   654,   655,   707,
    1542,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
    1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,   668,
     669,     0,     0,     0,     0,     0,     0,     0,     0,  1551,
    1552,     0,     0,     0,     0,     0,     0,     0,  1554,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1486,  1487,     0,
      45,  1489,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,  1490,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,  1491,   137,  1492,  1493,     0,   437,
     438,   439,   440,   441,  1494,  1495,   442,   443,  1496,  1497,
     444,     0,   445,   446,   447,   448,  1498,     0,  1499,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,  1500,  1501,
    1502,  1503,  1504,  1505,  1506,   461,   462,   463,   464,   701,
     465,  1507,  1508,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1509,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,  1510,   491,   492,   493,
    1511,  1512,   494,     0,   495,   496,  1513,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1514,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,  1515,  1516,
       0,  1517,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,  1518,   182,
     532,   183,     0,   533,   534,   535,  1519,  1520,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1521,   189,  1522,   547,   548,   191,     0,   549,   550,
     193,   551,  1524,  1525,   552,  1526,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,  1528,   562,   563,   564,   565,   566,   567,
     568,     0,   569,  1529,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1530,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,  1531,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,  1532,   613,   217,   614,
     615,   219,   616,  1533,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,  1534,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1535,  1536,
       0,     0,   637,  1537,   638,  1538,  1539,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,  1541,     0,   651,   652,   653,   654,   655,   707,  1542,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,  1543,
    1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,   668,   669,
       0,     0,     0,     0,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,  1554,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,   418,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1486,  1487,     0,    45,  1489,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,  1490,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,   135,  1491,
     137,  1492,  1493,     0,  4134,   438,   439,   440,   441,  1494,
    1495,   442,   443,  1496,  1497,   444,     0,   445,   446,   447,
     448,  1498,     0,  1499,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,
     461,   462,   463,   464,   701,   465,  1507,  1508,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1509,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,  1510,   491,   492,   493,  1511,  1512,   494,     0,   495,
     496,  1513,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,  1514,     0,   504,     0,   505,
     506,   703,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,   175,     0,
     519,   520,   521,  1515,  1516,     0,  1517,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,  1518,   182,   532,   183,     0,   533,   534,
     535,  1519,  1520,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,  1521,   189,  1522,   547,
     548,   191,     0,   549,   550,   193,   551,  1524,  1525,   552,
    1526,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,   197,   561,   198,  1528,   562,
     563,   564,   565,   566,   567,   568,     0,   569,  1529,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,  1530,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,  1531,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,  1532,   613,   217,   614,   615,   219,   616,  1533,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1534,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,  1535,  1536,     0,     0,   637,  1537,   638,
    1538,  1539,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,  1541,     0,   651,   652,
     653,   654,   655,   707,  1542,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,  1543,  1544,  1545,  1546,  1547,  1548,
    1549,  1550,   708,   668,   669,     0,     0,     0,     0,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,  1554,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1486,  1487,  1488,
      45,  1489,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,  1490,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,     0,  1491,   137,  1492,  1493,     0,   437,
     438,   439,   440,   441,  1494,  1495,   442,   443,  1496,  1497,
     444,     0,   445,   446,   447,   448,  1498,     0,  1499,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,  1500,  1501,
    1502,  1503,  1504,  1505,  1506,   461,   462,   463,   464,   701,
     465,  1507,  1508,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1509,   479,   480,     0,   481,   482,   483,     0,   484,     0,
     486,     0,   487,   488,   489,   490,  1510,   491,   492,   493,
    1511,  1512,   494,     0,   495,   496,  1513,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1514,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,  1515,  1516,
       0,  1517,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,  1518,   182,
     532,     0,     0,   533,   534,   535,  1519,  1520,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1521,   189,  1522,   547,   548,   191,     0,   549,   550,
     193,   551,  1524,  1525,   552,  1526,   553,   554,   555,     0,
     556,     0,     0,  1527,   558,   559,     0,     0,   560,   196,
     197,   561,   198,  1528,   562,   563,   564,   565,   566,   567,
     568,     0,   569,  1529,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1530,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,  1531,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,  1532,   613,   217,   614,
     615,     0,   616,  1533,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,  1534,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1535,  1536,
       0,     0,   637,  1537,   638,  1538,  1539,   639,   640,   641,
     642,   643,   644,   645,     0,  1540,   646,   647,   648,   649,
     650,  1541,     0,   651,   652,   653,   654,   655,   707,  1542,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,  1543,
    1544,  1545,  1546,  1547,  1548,  1549,  1550,   708,   668,   669,
       0,     0,     0,     0,     0,     0,     0,     0,  1551,  1552,
       0,     0,     0,     0,     0,     0,     0,  1554,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,   418,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1486,  1487,  1488,    45,
    1489,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
    1490,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,     0,  1491,   137,  1492,  1493,     0,   437,   438,
     439,   440,   441,  1494,  1495,   442,   443,  1496,  1497,   444,
       0,   445,   446,   447,   448,  1498,     0,  1499,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,  1500,  1501,  1502,
    1503,  1504,  1505,  1506,   461,   462,   463,   464,   701,   465,
    1507,  1508,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,  1509,
     479,   480,     0,   481,   482,   483,     0,   484,     0,   486,
       0,   487,   488,   489,   490,  1510,   491,   492,   493,  1511,
    1512,   494,     0,   495,   496,  1513,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,  1514,
       0,   504,     0,   505,   506,   703,   507,   508,     0,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,   174,   175,     0,   519,   520,   521,  1515,  1516,     0,
    1517,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,  1518,   182,   532,
       0,     0,   533,   534,   535,  1519,  1520,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
    1521,   189,  1522,   547,   548,   191,     0,   549,   550,   193,
     551,  1524,  1525,   552,  1526,   553,   554,   555,     0,   556,
       0,     0,  1527,   558,   559,     0,     0,   560,   196,   197,
     561,   198,  1528,   562,   563,   564,   565,   566,   567,   568,
       0,   569,  1529,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,  1530,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
    1531,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,  1532,   613,   217,   614,   615,
       0,   616,  1533,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1534,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,  1535,  1536,     0,
       0,   637,  1537,   638,  1538,  1539,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
    1541,     0,   651,   652,   653,   654,   655,   707,  1542,     0,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,  1543,  1544,
    1545,  1546,  1547,  1548,  1549,  1550,   708,   668,   669,     0,
       0,     0,     0,     0,     0,     0,     0,  2924,  2925,     0,
       0,     0,     0,     0,     0,     0,  1554,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,  1495,   442,   443,   698,   140,   444,     0,
     445,   446,   447,   448,  1498,     0,  1499,     0,   449,   450,
     451,   452,   148,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,  1500,  1501,  1502,  1503,
    1504,  1505,  1506,   461,   462,   463,   464,   701,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,  1511,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1514,     0,
     504,     0,   505,   506,   703,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,  3665,   529,   530,     0,   531,  1518,   182,   532,   183,
       0,   533,   534,   535,  1519,  1520,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,  1525,   552,   195,   553,   554,   555,     0,   556,     0,
    1094,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,  1528,   562,   563,   564,   565,   566,   567,   568,     0,
     569,  1529,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
    3666,   602,   603,   604,   605,   606,   706,   607,   215,   608,
     609,   610,   611,   612,  1532,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,  1534,     0,   628,   629,   223,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,  1537,   638,  1538,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,  1541,
       0,   651,   652,   653,   654,   655,  2215,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,   236,
     662,   663,   664,   665,   666,   667,   237,  1543,  1544,  1545,
    1546,  1547,  1548,  1549,  1550,   708,   668,   669,     0,     0,
       0,     0,   732,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,  3667,    98,    99,   100,   101,
     102,   103,   733,   104,   105,   687,   734,     0,   107,   108,
     109,   110,   735,   736,   112,   113,   114,   115,     0,   116,
     737,   738,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,     0,     0,   430,   431,     0,
     432,   433,   133,   434,   435,   436,   135,   136,   137,   138,
     139,     0,   437,   438,   439,   440,   441,     0,  1495,   442,
     443,   698,   140,   444,     0,   445,   446,   447,   448,  1498,
       0,  1499,     0,   449,   450,   451,   452,   148,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,   151,   460,
       0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,   462,
     463,   464,   701,   465,   155,   156,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,   164,
     491,   492,   493,  1511,     0,   494,     0,   495,   496,   168,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,  1514,     0,   504,     0,   505,   506,   703,
     507,   508,   173,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,   174,   175,     0,   519,   520,
     521,     0,   176,     0,   177,     0,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,  3665,   529,   530,     0,
     531,  1518,   182,   532,   183,     0,   533,   534,   535,  1519,
    1520,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,   188,   189,   190,   547,   548,   191,
       0,   549,   550,   193,   551,     0,  1525,   552,   195,   553,
     554,   555,     0,   556,     0,  1094,   557,   558,   559,     0,
       0,   560,   196,   197,   561,   198,  1528,   562,   563,   564,
     565,   566,   567,   568,     0,   569,  1529,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   203,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   210,   599,   600,   212,  3666,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,  1532,
     613,   217,   614,   615,   219,   616,   220,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1534,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,   224,   225,     0,     0,   637,  1537,   638,  1538,     0,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,  1541,     0,   651,   652,   653,   654,
     655,   707,   234,     0,   656,   235,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,  1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,
     708,   668,   669,     0,     0,     0,     0,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
    3667,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,  1495,   442,   443,   698,   140,   444,     0,
     445,   446,   447,   448,  1498,     0,  1499,     0,   449,   450,
     451,   452,   148,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,  1500,  1501,  1502,  1503,
    1504,  1505,  1506,   461,   462,   463,   464,   701,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,  1511,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1514,     0,
     504,     0,   505,   506,   703,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,  1518,   182,   532,   183,
       0,   533,   534,   535,  1519,  1520,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,  1525,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,  1528,   562,   563,   564,   565,   566,   567,   568,     0,
     569,  1529,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
    3666,   602,   603,   604,   605,   606,   706,   607,     0,   608,
     609,   610,   611,   612,  1532,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,  1534,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,  1537,   638,  1538,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,  1541,
       0,   651,   652,   653,   654,   655,   707,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,  1543,  1544,  1545,
    1546,  1547,  1548,  1549,  1550,   708,   668,   669,     0,     0,
       0,     0,   732,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,   246,    98,    99,   100,   101,
     102,   103,   733,   104,   105,   687,   734,     0,   107,   108,
     109,   110,   735,   736,   112,   113,   114,   115,     0,   116,
     737,   738,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,     0,     0,   430,   431,     0,
     432,   433,   133,   434,   435,   436,   135,   136,   137,   138,
     139,     0,   437,   438,   439,   440,   441,     0,  1495,   442,
     443,   698,   140,   444,     0,   445,   446,   447,   448,  1498,
       0,  1499,     0,   449,   450,   451,   452,   148,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,   151,   460,
       0,  1500,  1501,  1502,  1503,  1504,  1505,  1506,   461,   462,
     463,   464,   701,   465,   155,   156,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,   164,
     491,   492,   493,  1511,     0,   494,     0,   495,   496,   168,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,  1514,     0,   504,     0,   505,   506,   703,
     507,   508,   173,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,   174,   175,     0,   519,   520,
     521,     0,   176,     0,   177,     0,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,  1518,   182,   532,   183,     0,   533,   534,   535,  1519,
    1520,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,   188,   189,   190,   547,   548,   191,
       0,   549,   550,   193,   551,     0,  1525,   552,   195,   553,
     554,   555,     0,   556,     0,     0,   557,   558,   559,     0,
       0,   560,   196,   197,   561,   198,  1528,   562,   563,   564,
     565,   566,   567,   568,     0,   569,  1529,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   203,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   210,   599,   600,   212,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,  1532,
     613,   217,   614,   615,   219,   616,   220,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1534,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,   224,   225,     0,     0,   637,  1537,   638,  1538,     0,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,  1541,     0,   651,   652,   653,   654,
     655,   707,   234,     0,   656,   235,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,  1543,  1544,  1545,  1546,  1547,  1548,  1549,  1550,
     708,   668,   669,     0,     0,     0,     0,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
    4259,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,   698,   140,   444,     0,
     445,   446,   447,   448,   144,     0,   145,     0,   449,   450,
     451,   452,   148,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,   701,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   703,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,   706,   607,     0,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,   707,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   708,   668,   669,     0,     0,
       0,     0,     0,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,  4863,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   687,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,  4186,     0,   430,   431,     0,
     432,   433,     0,   434,   435,   436,   135,   136,     0,   138,
     139,     0,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   698,   140,   444,     0,   445,   446,   447,   448,   144,
       0,     0,     0,   449,   450,   451,   452,     0,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0, -1516,   460,
       0,     0,     0,     0,     0,     0,     0,     0,   461,   462,
     463,   464,   701,   465,   155,   156,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,   164,
     491,   492,   493,   166,     0,   494,     0,   495,   496,   168,
     497,     0,   498,     0,   499,     0,     0, -1516,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   703,
     507,   508,     0,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518, -1516,   175,     0,   519,   520,
     521,     0,   176,     0,   177,     0,   522,     0,     0,   523,
   -1516,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,   181, -1516,   532,     0,     0,   533,   534,   535,     0,
       0,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,   188, -1516,   190,   547,   548,   191,
       0,   549,   550,     0,   551,     0,   194,   552,   195,   553,
     554,   555,     0,   556,     0,     0,   557,   558,   559,     0,
       0,   560,   196,     0,   561,     0,   199,   562,   563,   564,
     565,   566,   567,   568,     0,   569,   200,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   203,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598, -1516,   599,   600,   212,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,     0,
     613,   217,   614,   615,     0,   616,   220,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,   224,   225,     0,     0,   637,   226,   638,   227,     0,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,   707,   234,     0,   656,     0,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     708,   668,   669,     0,     0,     0,     0,     0,     0,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,  1648,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   687,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,    44,     0,     0,     0,    45,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,     0,   434,
     435,   436,   135,   136,     0,   138,   139,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   698,   140,   444,
       0,   445,   446,   447,   448,   144,     0,     0,     0,   449,
     450,   451,   452,     0,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,     0,     0,     0,     0,
       0,     0,     0,     0,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,   166,
       0,   494,     0,   495,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   703,   507,   508,     0,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,     0,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,     0,     0,   523,     0,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,   181,     0,   532,
       0,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,     0,   190,   547,   548,   191,     0,   549,   550,     0,
     551,     0,   194,   552,   195,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,   196,     0,
     561,     0,   199,   562,   563,   564,   565,   566,   567,   568,
       0,   569,   200,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,   217,   614,   615,
       0,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,   226,   638,   227,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,     0,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   708,   668,   669,     0,
       0,     0,     0,     0,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,  3947,  3948,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   687,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,    45,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,     0,   434,   435,   436,   135,   136,     0,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,   698,   140,   444,     0,   445,   446,   447,   448,
     144,     0,     0,     0,   449,   450,   451,   452,     0,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,     0,
     460,     0,     0,     0,     0,     0,     0,     0,     0,   461,
     462,   463,   464,   701,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     703,   507,   508,     0,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,     0,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,     0,     0,
     523,     0,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,     0,   532,     0,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,     0,   190,   547,   548,
     191,     0,   549,   550,     0,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,     0,   561,     0,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   212,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,     0,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,   707,   234,     0,   656,     0,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   708,   668,   669,     0,     0,     0,     0,     0,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,  3948,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   687,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,   418,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,     0,   434,
     435,   436,   135,   136,     0,   138,   139,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   698,   140,   444,
       0,   445,   446,   447,   448,   144,     0,     0,     0,   449,
     450,   451,   452,     0,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,     0,     0,     0,     0,
       0,     0,     0,     0,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,   166,
       0,   494,     0,   495,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   703,   507,   508,     0,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,     0,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,     0,     0,   523,     0,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,   181,     0,   532,
       0,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,     0,   190,   547,   548,   191,     0,   549,   550,     0,
     551,     0,   194,   552,   195,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,   196,     0,
     561,     0,   199,   562,   563,   564,   565,   566,   567,   568,
       0,   569,   200,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,   215,
     608,   609,   610,   611,   612,     0,   613,   217,   614,   615,
       0,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,     0,   628,   629,   223,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,   226,   638,   227,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,  2215,   234,     0,
     656,     0,   657,   658,   659,   660,     0,     0,   661,     0,
     236,   662,   663,   664,   665,   666,   667,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   708,   668,   669,     0,
       0,     0,     0,     0,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,   246,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   687,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,     0,   434,   435,   436,   135,   136,     0,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,   698,   140,   444,     0,   445,   446,   447,   448,
     144,     0,     0,     0,   449,   450,   451,   452,     0,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,     0,
     460,     0,     0,     0,     0,     0,     0,     0,     0,   461,
     462,   463,   464,   701,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     703,   507,   508,     0,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,     0,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,     0,     0,
     523,     0,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,     0,   532,     0,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,     0,   190,   547,   548,
     191,     0,   549,   550,     0,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,     0,   561,     0,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   212,   601,   602,   603,   604,
     605,   606,   706,   607,   215,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,     0,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,   223,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,  2215,   234,     0,   656,     0,   657,   658,   659,
     660,     0,     0,   661,     0,   236,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   708,   668,   669,     0,     0,     0,     0,     0,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,   246,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   687,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,     0,   434,
     435,   436,   135,   136,     0,   138,   139,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   698,   140,   444,
       0,   445,   446,   447,   448,   144,     0,     0,     0,   449,
     450,   451,   452,     0,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,     0,     0,     0,     0,
       0,     0,     0,     0,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,   166,
       0,   494,     0,   495,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   703,   507,   508,     0,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,     0,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,     0,     0,   523,     0,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,   181,     0,   532,
       0,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,     0,   190,   547,   548,   191,     0,   549,   550,     0,
     551,     0,   194,   552,   195,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,   196,     0,
     561,     0,   199,   562,   563,   564,   565,   566,   567,   568,
       0,   569,   200,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,   217,   614,   615,
       0,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,   226,   638,   227,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,     0,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   708,   668,   669,     0,
       0,     0,     0,     0,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,  1623,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   687,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,     0,   434,   435,   436,   135,   136,     0,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,   698,   140,   444,     0,   445,   446,   447,   448,
     144,     0,     0,     0,   449,   450,   451,   452,     0,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,     0,
     460,     0,     0,     0,     0,     0,     0,     0,     0,   461,
     462,   463,   464,   701,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     703,   507,   508,     0,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,     0,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,     0,     0,
     523,     0,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,     0,   532,     0,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,     0,   190,   547,   548,
     191,     0,   549,   550,     0,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,     0,   561,     0,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   212,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,     0,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,   707,   234,     0,   656,     0,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   708,   668,   669,     0,     0,     0,     0,     0,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,  3087,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   687,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,     0,   434,
     435,   436,   135,   136,     0,   138,   139,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   698,   140,   444,
       0,   445,   446,   447,   448,   144,     0,     0,     0,   449,
     450,   451,   452,     0,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,     0,     0,     0,     0,
       0,     0,     0,     0,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,   166,
       0,   494,     0,   495,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   703,   507,   508,     0,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,     0,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,     0,     0,   523,     0,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,   181,     0,   532,
       0,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,     0,   190,   547,   548,   191,     0,   549,   550,     0,
     551,     0,   194,   552,   195,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,   196,     0,
     561,     0,   199,   562,   563,   564,   565,   566,   567,   568,
       0,   569,   200,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,   217,   614,   615,
       0,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,   226,   638,   227,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,     0,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   708,   668,   669,     0,
       0,     0,     0,     0,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,  4170,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   687,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,     0,   434,   435,   436,   135,   136,     0,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,   698,   140,   444,     0,   445,   446,   447,   448,
     144,     0,     0,     0,   449,   450,   451,   452,     0,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,     0,
     460,     0,     0,     0,     0,     0,     0,     0,     0,   461,
     462,   463,   464,   701,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     703,   507,   508,     0,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,     0,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,     0,     0,
     523,     0,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,     0,   532,     0,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,     0,   190,   547,   548,
     191,     0,   549,   550,     0,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,     0,   561,     0,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   212,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,     0,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,   707,   234,     0,   656,     0,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   708,   668,   669,     0,     0,     0,     0,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,  4581,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,   418,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,     0,     0,  1219,    45,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,   739,   427,   428,   429,   740,   741,   742,   743,
     744,   745,   746,   430,   431,   747,   432,   433,   133,   434,
     435,   436,     0,  1925,   137,  1926,  1927,   748,   437,   438,
     439,   440,   441,   749,   750,   442,   443,  1928,  1929,   444,
     752,   445,   446,   447,   448,     0,   753,   145,   754,   449,
     450,   451,   452,   148,   453,   699,   756,   454,   455,   456,
     457,   458,   459,   757,   151,   460,     0,   759,   760,   761,
     152,   762,   763,   764,   461,   462,   463,   464,   701,   465,
    1930,  1931,   466,   765,   467,   766,   468,   469,   470,   471,
     472,   767,   473,   474,   475,   768,   769,   476,   477,  1509,
     479,   480,   770,   481,   482,   483,   771,   484,   485,   486,
     772,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     773,   494,   774,   495,   496,  1932,   497,   775,   498,   776,
     499,   169,   777,   170,   500,   501,   502,   778,   503,     0,
     779,   504,   780,   505,   506,   703,   507,   508,   173,   509,
     510,   511,   781,   512,   513,   514,   515,   516,   517,   782,
     518,   174,     0,     0,   519,   520,   521,  1515,  1933,   785,
    1934,   786,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,   787,   529,   530,   788,   531,     0,   182,   532,
     183,   789,   533,   534,   535,   790,   791,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
    1935,   189,  1936,   547,   548,     0,   792,   549,   550,   193,
     551,   793,     0,   552,  1937,   553,   554,   555,   794,   556,
     795,   796,  3934,   558,   559,   797,   798,   560,     0,   197,
     561,   198,     0,   562,   563,   564,   565,   566,   567,   568,
     799,   569,     0,   570,     0,   571,   572,   573,   800,   574,
     575,   576,   577,   578,   579,   580,   581,  1938,   582,   583,
     584,   585,   801,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,   802,   597,   598,   210,   599,   600,
       0,   601,   602,   603,   604,   605,   606,   706,   607,   803,
     608,   609,   610,   611,   612,   804,   613,  2423,   614,   615,
     219,   616,  1940,   617,   805,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,     0,   806,   628,   629,   807,
     630,   631,   632,   633,   634,   635,   808,  1941,  1942,     0,
     810,   637,     0,   638,     0,   811,   639,   640,   641,   642,
     643,   644,   645,     0,   813,   646,   647,   648,   649,   650,
     814,   815,   651,   652,   653,   654,   655,     0,  1943,   817,
     656,   235,   657,   658,   659,   660,   818,   819,   661,   820,
     821,   662,   663,   664,   665,   666,   667,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   708,   668,   669,     0,
       0,     0,     0,  1222,  1223,  1224,     0,  3935,  3936,  1227,
    1228,  1229,  1230,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   687,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1219,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,     0,     0,   430,   431,     0,
     432,   433,     0,   434,   435,   436,   135,   136,     0,   138,
     139,     0,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   698,   140,   444,     0,   445,  1220,   447,   448,   144,
       0,     0,     0,   449,   450,   451,   452,     0,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
       0,     0,     0,     0,     0,     0,     0,     0,   461,   462,
     463,   464,   701,   465,   155,   156,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,   164,
     491,   492,   493,   166,     0,  1221,     0,   495,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   703,
     507,   508,     0,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,     0,   175,     0,   519,   520,
     521,     0,   176,     0,   177,     0,   522,     0,     0,   523,
       0,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,   181,     0,   532,     0,     0,   533,   534,   535,     0,
       0,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,   188,     0,   190,   547,   548,   191,
       0,   549,   550,     0,   551,     0,   194,   552,   195,   553,
     554,   555,     0,   556,     0,     0,   557,   558,   559,     0,
       0,   560,   196,     0,   561,     0,   199,   562,   563,   564,
     565,   566,   567,   568,     0,   569,   200,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   203,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,     0,   599,   600,   212,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,     0,
     613,   217,   614,   615,     0,   616,   220,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,   224,   225,     0,     0,   637,   226,   638,   227,     0,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,   707,   234,     0,   656,     0,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     708,   668,   669,     0,     0,     0,     0,  1222,  1223,  1224,
       0,  1225,  1226,  1227,  1228,  1229,  1230,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   687,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,  1219,     0,     0,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,     0,     0,
       0,   430,   431,     0,   432,   433,     0,   434,   435,   436,
     135,   136,     0,   138,   139,     0,   437,   438,   439,   440,
     441,     0,     0,   442,   443,   698,   140,   444,     0,   445,
    1317,   447,   448,   144,     0,     0,     0,   449,   450,   451,
     452,     0,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,     0,   460,     0,     0,     0,     0,     0,     0,
       0,     0,   461,   462,   463,   464,   701,   465,   155,   156,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,   164,   491,   492,   493,   166,     0,  1318,
       0,   495,   496,   168,   497,     0,   498,     0,   499,     0,
       0,     0,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   703,   507,   508,     0,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,     0,
     175,     0,   519,   520,   521,     0,   176,     0,   177,     0,
     522,     0,     0,   523,     0,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,   181,     0,   532,     0,     0,
     533,   534,   535,     0,     0,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,   188,     0,
     190,   547,   548,   191,     0,   549,   550,     0,   551,     0,
     194,   552,   195,   553,   554,   555,     0,   556,     0,     0,
     557,   558,   559,     0,     0,   560,   196,     0,   561,     0,
     199,   562,   563,   564,   565,   566,   567,   568,     0,   569,
     200,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   203,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,     0,   599,   600,   212,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,     0,   613,   217,   614,   615,     0,   616,
     220,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,   224,   225,     0,     0,   637,
     226,   638,   227,     0,   639,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,   650,     0,     0,
     651,   652,   653,   654,   655,   707,   234,     0,   656,     0,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   708,   668,   669,     0,     0,     0,
       0,  1222,  1223,  1224,     0,  1225,  1226,  1227,  1228,  1229,
    1230,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   687,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
    1219,     0,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
       0,   434,   435,   436,   135,   136,     0,   138,   139,     0,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   698,
     140,   444,     0,   445,  1374,   447,   448,   144,     0,     0,
       0,   449,   450,   451,   452,     0,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,     0,     0,
       0,     0,     0,     0,     0,     0,   461,   462,   463,   464,
     701,   465,   155,   156,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,   164,   491,   492,
     493,   166,     0,  1375,     0,   495,   496,   168,   497,     0,
     498,     0,   499,     0,     0,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   703,   507,  1376,
       0,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,     0,   175,     0,   519,   520,   521,     0,
     176,     0,   177,     0,   522,     0,     0,   523,     0,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,   181,
       0,   532,     0,     0,   533,   534,   535,     0,     0,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,   188,     0,   190,   547,   548,   191,     0,   549,
     550,     0,   551,     0,   194,   552,   195,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
     196,     0,   561,     0,   199,   562,   563,   564,   565,   566,
     567,   568,     0,   569,   200,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   203,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   212,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,     0,   613,   217,
     614,   615,     0,   616,   220,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,   224,
     225,     0,     0,   637,   226,   638,   227,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,   707,
     234,     0,   656,     0,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   708,   668,
     669,     0,     0,     0,     0,  1222,  1223,  1224,     0,  1225,
    1226,  1227,  1228,  1229,  1230,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   687,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1219,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,     0,   434,   435,   436,   135,   136,
       0,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   698,   140,   444,     0,   445,  1910,   447,
     448,   144,     0,     0,     0,   449,   450,   451,   452,     0,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,     0,     0,     0,     0,     0,     0,     0,     0,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,     0,  1911,     0,   495,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,     0,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,     0,
       0,   523,     0,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,     0,   532,     0,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,     0,   190,   547,
     548,   191,     0,   549,   550,     0,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,     0,   561,     0,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,     0,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,     0,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   708,   668,   669,     0,     0,     0,     0,  1222,
    1223,  1224,     0,  1225,  1226,  1227,  1228,  1229,  1230,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   687,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1219,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,     0,   434,
     435,   436,   135,   136,     0,   138,   139,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   698,   140,   444,
       0,   445,   446,   447,   448,   144,     0,     0,     0,   449,
     450,   451,   452,     0,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,     0,     0,     0,     0,
       0,     0,     0,     0,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,   166,
       0,   494,     0,   495,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   703,   507,   508,     0,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,     0,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,     0,     0,   523,     0,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,   181,     0,   532,
       0,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,     0,   190,   547,   548,   191,     0,   549,   550,     0,
     551,     0,   194,   552,   195,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,   196,     0,
     561,     0,   199,   562,   563,   564,   565,   566,   567,   568,
       0,   569,   200,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,   217,   614,   615,
       0,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,   226,   638,   227,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,     0,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   708,   668,   669,     0,
       0,     0,     0,  1222,  1223,  1224,     0,  1225,  1226,  1227,
    1228,  1229,  1230,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   687,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1219,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,     0,     0,   430,   431,     0,
     432,   433,     0,   434,   435,   436,   135,   136,     0,   138,
     139,     0,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   698,   140,   444,     0,   445,  3187,   447,   448,   144,
       0,     0,     0,   449,   450,   451,   452,     0,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
       0,     0,     0,     0,     0,     0,     0,     0,   461,   462,
     463,   464,   701,   465,   155,   156,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,   164,
     491,   492,   493,   166,     0,  3188,     0,   495,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   703,
     507,   508,     0,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,     0,   175,     0,   519,   520,
     521,     0,   176,     0,   177,     0,   522,     0,     0,   523,
       0,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,   181,     0,   532,     0,     0,   533,   534,   535,     0,
       0,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,   188,     0,   190,   547,   548,   191,
       0,   549,   550,     0,   551,     0,   194,   552,   195,   553,
     554,   555,     0,   556,     0,     0,   557,   558,   559,     0,
       0,   560,   196,     0,   561,     0,   199,   562,   563,   564,
     565,   566,   567,   568,     0,   569,   200,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   203,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,     0,   599,   600,   212,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,     0,
     613,   217,   614,   615,     0,   616,   220,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,   224,   225,     0,     0,   637,   226,   638,   227,     0,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,   707,   234,     0,   656,     0,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     708,   668,   669,     0,     0,     0,     0,  1222,  1223,  1224,
       0,  1225,  1226,  1227,  1228,  1229,  1230,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   687,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,  1219,     0,     0,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,     0,     0,
       0,   430,   431,     0,   432,   433,     0,   434,   435,   436,
     135,   136,     0,   138,   139,     0,   437,   438,   439,   440,
     441,     0,     0,   442,   443,   698,   140,   444,     0,   445,
     446,   447,   448,   144,     0,     0,     0,   449,   450,   451,
     452,     0,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,     0,   460,     0,     0,     0,     0,     0,     0,
       0,     0,   461,   462,   463,   464,   701,   465,   155,   156,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,   164,   491,   492,   493,   166,     0,   494,
       0,   495,   496,   168,   497,     0,   498,     0,   499,     0,
       0,     0,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   703,   507,   508,     0,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,     0,
     175,     0,   519,   520,   521,     0,   176,     0,   177,     0,
     522,     0,     0,   523,     0,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,   181,     0,   532,     0,     0,
     533,   534,   535,     0,     0,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,   188,     0,
     190,   547,   548,   191,     0,   549,   550,     0,   551,     0,
     194,   552,   195,   553,   554,   555,     0,   556,     0,     0,
    4842,   558,   559,     0,     0,   560,   196,     0,   561,     0,
     199,   562,   563,   564,   565,   566,   567,   568,     0,   569,
     200,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   203,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,     0,   599,   600,   212,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,     0,   613,   217,   614,   615,     0,   616,
     220,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,   224,   225,     0,     0,   637,
     226,   638,   227,     0,   639,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,   650,     0,     0,
     651,   652,   653,   654,   655,   707,   234,     0,   656,     0,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   708,   668,   669,     0,     0,     0,
       0,  1222,  1223,  1224,     0,  1225,  1226,  1227,  1228,  1229,
    1230,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,   739,   427,   428,   429,   740,
     741,   742,   743,   744,   745,   746,   430,   431,   747,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
     748,   437,   438,   439,   440,   441,   749,   750,   442,   443,
     751,   140,   444,   752,   445,   446,   447,   448,   144,   753,
     145,   754,   449,   450,   451,   452,   148,   453,   755,   756,
     454,   455,   456,   457,   458,   459,   757,   151,   460,   758,
     759,   760,   761,   152,   762,   763,   764,   461,   462,   463,
     464,   701,   465,   155,   156,   466,   765,   467,   766,   468,
     469,   470,   471,   472,   767,   473,   474,   475,   768,   769,
     476,   477,   478,   479,   480,   770,   481,   482,   483,   771,
     484,   485,   486,   772,   487,   488,   489,   490,   164,   491,
     492,   493,   166,   773,   494,   774,   495,   496,   168,   497,
     775,   498,   776,   499,   169,   777,   170,   500,   501,   502,
     778,   503,   172,   779,   504,   780,   505,   506,   703,   507,
     508,   173,   509,   510,   511,   781,   512,   513,   514,   515,
     516,   517,   782,   518,   174,   175,   783,   519,   520,   521,
     784,   176,   785,   177,   786,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,   787,   529,   530,   788,   531,
     181,   182,   532,   183,   789,   533,   534,   535,   790,   791,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,   189,   190,   547,   548,   191,   792,
     549,   550,   193,   551,   793,   194,   552,   195,   553,   554,
     555,   794,   556,   795,   796,   557,   558,   559,   797,   798,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,   799,   569,   200,   570,   201,   571,   572,
     573,   800,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,   801,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,   802,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,   803,   608,   609,   610,   611,   612,   804,   613,
     217,   614,   615,   219,   616,   220,   617,   805,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,   806,
     628,   629,   807,   630,   631,   632,   633,   634,   635,   808,
     224,   225,   809,   810,   637,   226,   638,   227,   811,   639,
     640,   641,   642,   643,   644,   645,   812,   813,   646,   647,
     648,   649,   650,   814,   815,   651,   652,   653,   654,   655,
     816,   234,   817,   656,   235,   657,   658,   659,   660,   818,
     819,   661,   820,   821,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,     0,   732,    86,    87,    88,   684,    90,    91,
      92,   685,  2314,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,     0,  1925,   137,
    1926,  1927,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,  1928,  1929,   444,     0,   445,   446,   447,   448,
       0,     0,   145,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,   701,   465,  1930,  1931,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1509,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
       0,   491,   492,   493,     0,     0,   494,     0,   495,   496,
    1932,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,     0,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,  2419,   512,   513,
     514,   515,   516,   517,     0,   518,   174,  2420,     0,   519,
     520,   521,  1515,  1933,     0,  1934,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,     0,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,  1935,   189,  1936,   547,   548,
       0,     0,   549,   550,   193,   551,     0,     0,   552,  1937,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,  2421,   560,  2422,   197,   561,   198,     0,   562,   563,
     564,   565,   566,   567,   568,     0,   569,     0,   570,     0,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,  1938,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,     0,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
       0,   613,  2423,   614,   615,   219,   616,  1940,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
       0,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,  1941,  1942,     0,     0,   637,     0,   638,     0,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,     0,  1943,  2424,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   708,   668,   669,     0,     0,    86,    87,    88,   684,
      90,    91,    92,   685,  2425,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,     0,     0,    86,    87,
      88,   684,    90,    91,    92,   685,  1101,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     687,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,     0,   434,   435,
     436,   135,   136,     0,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,   698,   140,   444,     0,
     445,   446,   447,   448,   144,     0,     0,     0,   449,   450,
     451,   452,     0,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,     0,   460,     0,     0,     0,     0,     0,
       0,     0,     0,   461,   462,   463,   464,   701,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
       0,     0,     0,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   703,   507,   508,     0,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
       0,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,     0,     0,   523,     0,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,     0,   532,     0,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,   188,
       0,   190,   547,   548,   191,     0,   549,   550,     0,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,     0,   561,
       0,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,     0,   599,   600,   212,
     601,   602,   603,   604,   605,   606,   706,   607,     0,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,     0,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,   707,   234,     0,   656,
       0,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   708,   668,   669,     0,     0,
      86,    87,    88,   684,    90,    91,    92,   685,  4890,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,   419,   996,   421,   422,   423,
     424,   425,   426,   997,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     998,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   999,   168,   497,     0,   498,
       0,  1000,     0,  1001,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,  1002,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,  1003,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,  1004,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
    1005,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,  1006,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
       0,     0,     0,     0,     0,     0,     0,     0,  1007,  1008,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,   419,   996,   421,   422,   423,
     424,   425,   426,   997,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
    1029,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   999,   168,   497,     0,   498,
       0,  1030,     0,  1001,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,  1002,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,  1003,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,  1004,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
    1005,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,  1006,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
       0,     0,     0,     0,     0,     0,     0,     0,  1007,  1008,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  1422,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,  1001,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,  1002,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
       0,     0,     0,     0,     0,     0,     0,     0,  1007,  1008,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  1427,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,  1001,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,  1002,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
       0,     0,     0,     0,     0,     0,     0,     0,  1007,  1008,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,   702,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
    1594,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
       0,     0,     0,  1071,  1595,    86,    87,    88,   684,    90,
      91,    92,   685,  1072,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   687,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,     0,   434,   435,   436,   135,   136,
       0,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,  1073,   443,  1045,   140,   444,     0,   445,   446,   447,
     448,   144,     0,     0,     0,   449,   450,   451,   452,     0,
     453,  1074,     0,  1075,   455,   456,   457,   458,   459,     0,
       0,   460,     0,     0,     0,     0,     0,     0,     0,     0,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,     0,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,     0,
       0,   523,     0,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,     0,   532,     0,     0,   533,   534,
    1076,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,  1077,   188,     0,   190,   547,
     548,   191,     0,   549,   550,     0,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,     0,   561,     0,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,  1078,   600,   212,   601,   602,   603,
    1079,   605,   606,   706,   607,     0,   608,   609,   610,   611,
    1080,     0,   613,   217,   614,   615,     0,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,  1081,   225,     0,     0,  1082,   226,   638,
     227,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,  1049,   234,     0,   656,     0,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,  1083,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   708,   668,   669,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,   739,
     427,   428,   429,   740,   741,   742,   743,   744,   745,   746,
     430,   431,   747,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,   748,   437,   438,   439,   440,   441,
     749,   750,   442,   443,   751,   140,   444,   752,   445,   446,
     447,   448,   144,   753,   145,   754,   449,   450,   451,   452,
     148,   453,   755,   756,   454,   455,   456,   457,   458,   459,
     757,   151,   460,   758,   759,   760,   761,   152,   762,   763,
     764,   461,   462,   463,   464,   701,   465,   155,   156,   466,
     765,   467,   766,   468,   469,   470,   471,   472,   767,   473,
     474,   475,   768,   769,   476,   477,   478,   479,   480,   770,
     481,   482,   483,   771,   484,   485,   486,   772,   487,   488,
     489,   490,   164,   491,   492,   493,   166,   773,   494,   774,
     495,   496,   168,   497,   775,   498,   776,   499,   169,   777,
     170,   500,   501,   502,   778,   503,   172,   779,   504,   780,
     505,   506,   703,   507,   508,   173,   509,   510,   511,   781,
     512,   513,   514,   515,   516,   517,   782,   518,   174,   175,
     783,   519,   520,   521,   784,   176,   785,   177,   786,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,   787,
     529,   530,   788,   531,   181,   182,   532,   183,   789,   533,
     534,   535,   790,   791,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,   189,   190,
     547,   548,   191,   792,   549,   550,   193,   551,   793,   194,
     552,   195,   553,   554,   555,   794,   556,   795,   796,   557,
     558,   559,   797,   798,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,   799,   569,   200,
     570,   201,   571,   572,   573,   800,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,   801,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,   802,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,   803,   608,   609,   610,
     611,   612,   804,   613,   217,   614,   615,   219,   616,   220,
     617,   805,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,   806,   628,   629,   807,   630,   631,   632,
     633,   634,   635,   808,   224,   225,   809,   810,   637,   226,
     638,   227,   811,   639,   640,   641,   642,   643,   644,   645,
     812,   813,   646,   647,   648,   649,   650,   814,   815,   651,
     652,   653,   654,   655,   816,   234,   817,   656,   235,   657,
     658,   659,   660,   818,   819,   661,   820,   821,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,   732,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   733,   104,   105,   687,
     734,     0,   107,   108,   109,   110,   735,   736,   112,   113,
     114,   115,     0,   116,   737,   738,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
     739,   427,   428,   429,   740,   741,   742,   743,   744,   745,
     746,   430,   431,   747,   432,   433,   133,   434,   435,   436,
     135,   136,   137,   138,   139,   748,   437,   438,   439,   440,
     441,   749,   750,   442,   443,   751,   140,   444,   752,   445,
     446,   447,   448,   144,   753,   145,   754,   449,   450,   451,
     452,   148,   453,   755,   756,   454,   455,   456,   457,   458,
     459,   757,   151,   460,   758,   759,   760,   761,   152,   762,
     763,   764,   461,   462,   463,   464,   701,   465,   155,   156,
     466,   765,   467,   766,   468,   469,   470,   471,   472,   767,
     473,   474,   475,   768,   769,   476,   477,   478,   479,   480,
     770,   481,   482,   483,   771,   484,   485,   486,   772,   487,
     488,   489,   490,   164,   491,   492,   493,   166,   773,   494,
     774,   495,   496,   168,   497,   775,   498,   776,   499,   169,
     777,   170,   500,   501,   502,   778,   503,   172,   779,   504,
     780,   505,   506,   703,   507,   508,   173,   509,   510,   511,
     781,   512,   513,   514,   515,   516,   517,   782,   518,   174,
     175,   783,   519,   520,   521,   784,   176,   785,   177,   786,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
     787,   529,   530,   788,   531,   181,   182,   532,   183,   789,
     533,   534,   535,   790,   791,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,   188,   189,
     190,   547,   548,   191,   792,   549,   550,   193,   551,   793,
     194,   552,   195,   553,   554,   555,   794,   556,   795,   796,
     557,   558,   559,   797,   798,   560,   196,   197,   561,   198,
     199,   562,   563,   564,   565,   566,   567,   568,   799,   569,
     200,   570,   201,   571,   572,   573,   800,   574,   575,   576,
     577,   578,   579,   580,   581,   203,   582,   583,   584,   585,
     801,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   802,   597,   598,   210,   599,   600,   212,   601,
     602,   603,   604,   605,   606,   706,   607,   803,   608,   609,
     610,   611,   612,   804,   613,   217,   614,   615,   219,   616,
     220,   617,   805,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   806,   628,   629,   807,   630,   631,
     632,   633,   634,   635,   808,   224,   225,   809,   810,   637,
     226,   638,   227,   811,   639,   640,   641,   642,   643,   644,
     645,   812,   813,   646,   647,   648,   649,   650,   814,   815,
     651,   652,   653,   654,   655,   816,   234,   817,   656,   235,
     657,   658,   659,   660,   818,   819,   661,   820,   821,   662,
     663,   664,   665,   666,   667,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   708,   668,   669,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,  3246,   424,   425,
     426,   739,   427,   428,   429,   740,   741,   742,   743,   744,
     745,   746,   430,   431,   747,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,   748,   437,   438,   439,
     440,   441,   749,   750,   442,   443,   751,   140,   444,   752,
     445,   446,   447,   448,   144,   753,   145,   754,   449,   450,
     451,   452,   148,   453,   755,   756,   454,   455,   456,   457,
     458,   459,   757,   151,   460,   758,   759,   760,   761,   152,
     762,   763,   764,   461,   462,   463,   464,   701,   465,   155,
     156,   466,   765,   467,   766,   468,   469,   470,   471,   472,
     767,   473,   474,   475,   768,   769,   476,   477,   478,  3247,
     480,   770,   481,   482,   483,   771,   484,   485,   486,   772,
     487,   488,   489,   490,   164,   491,   492,   493,   166,   773,
     494,   774,   495,   496,   168,   497,   775,   498,   776,   499,
     169,   777,   170,   500,   501,   502,   778,   503,   172,   779,
     504,   780,   505,   506,   703,   507,   508,   173,   509,   510,
     511,   781,   512,   513,   514,   515,   516,   517,   782,   518,
     174,   175,   783,   519,   520,   521,   784,   176,   785,   177,
     786,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,   787,   529,   530,   788,   531,   181,   182,   532,   183,
     789,   533,   534,   535,   790,   791,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,   188,
     189,   190,   547,   548,   191,   792,   549,   550,   193,   551,
     793,   194,   552,   195,   553,   554,   555,   794,   556,   795,
     796,   557,   558,   559,   797,   798,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,   799,
     569,   200,   570,   201,   571,   572,   573,   800,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,   801,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,   802,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,   706,   607,   803,   608,
     609,   610,   611,   612,   804,  3248,   217,   614,   615,   219,
     616,   220,   617,   805,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,   806,   628,   629,   807,   630,
     631,   632,   633,   634,   635,   808,   224,   225,   809,   810,
     637,   226,   638,   227,   811,   639,   640,   641,   642,   643,
     644,   645,   812,   813,   646,   647,   648,   649,   650,   814,
     815,   651,   652,   653,   654,   655,   816,   234,   817,   656,
     235,   657,   658,   659,   660,   818,   819,   661,   820,   821,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   708,   668,   669,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,   135,   136,   137,   138,   139,     0,   437,   438,
     439,   440,   441,     0,  1495,   442,   443,   698,   140,   444,
       0,   445,   446,   447,   448,  1498,     0,  1499,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,  1500,  1501,  1502,
    1503,  1504,  1505,  1506,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,  1511,
       0,   494,     0,   495,   496,   168,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,  1514,
       0,   504,     0,   505,   506,   703,   507,   508,   173,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,   174,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,  1518,   182,   532,
     183,     0,   533,   534,   535,  1519,  1520,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,   189,   190,   547,   548,   191,     0,   549,   550,   193,
     551,     0,  1525,   552,   195,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,   196,   197,
     561,   198,  1528,   562,   563,   564,   565,   566,   567,   568,
       0,   569,  1529,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,  1532,   613,   217,   614,   615,
     219,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1534,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,  1537,   638,  1538,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
    1541,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,  1543,  1544,
    1545,  1546,  1547,  1548,  1549,  1550,   708,   668,   669,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,   145,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,   189,   190,   547,   548,   191,     0,   549,   550,
     193,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,   219,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,   135,   136,   137,   138,   139,     0,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   698,
     140,   444,     0,   445,   446,   447,   448,   144,     0,   145,
       0,   449,   450,   451,   452,   148,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,     0,
       0,     0,   152,     0,     0,     0,   461,   462,   463,   464,
     701,   465,   155,   156,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,   164,   491,   492,
     493,   166,     0,   494,     0,   495,   496,   168,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   703,   507,  1357,
     173,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,   175,     0,   519,   520,   521,     0,
     176,     0,   177,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,   181,
     182,   532,   183,     0,   533,   534,   535,     0,     0,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,   188,   189,   190,   547,   548,   191,     0,   549,
     550,   193,   551,     0,   194,   552,   195,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
     196,   197,   561,   198,   199,   562,   563,   564,   565,   566,
     567,   568,     0,   569,   200,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   203,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,   212,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,     0,   613,   217,
     614,   615,   219,   616,   220,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,   224,
     225,     0,     0,   637,   226,   638,   227,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,   707,
     234,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   708,   668,
     669,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
     145,     0,   449,   450,   451,   452,   148,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1367,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,   189,   190,   547,   548,   191,     0,
     549,   550,   193,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,   219,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,   732,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   733,   104,   105,   687,   734,     0,   107,   108,
     109,   110,   735,   736,   112,   113,   114,   115,     0,   116,
     737,   738,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,     0,     0,   430,   431,     0,
     432,   433,   133,   434,   435,   436,     0,  1925,   137,  1926,
    1927,     0,   437,   438,   439,   440,   441,     0,     0,   442,
     443,  1928,  1929,   444,     0,   445,   446,   447,   448,     0,
       0,   145,     0,   449,   450,   451,   452,   148,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,   151,   460,
       0,     0,     0,     0,   152,     0,     0,     0,   461,   462,
     463,   464,   701,   465,  1930,  1931,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1509,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,     0,
     491,   492,   493,     0,     0,   494,     0,   495,   496,  1932,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,     0,     0,   504,     0,   505,   506,   703,
     507,   508,   173,   509,   510,   511,  2419,   512,   513,   514,
     515,   516,   517,     0,   518,   174,  2420,     0,   519,   520,
     521,  1515,  1933,     0,  1934,     0,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,     0,   182,   532,   183,     0,   533,   534,   535,     0,
       0,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,  1935,   189,  1936,   547,   548,     0,
       0,   549,   550,   193,   551,     0,     0,   552,  1937,   553,
     554,   555,     0,   556,     0,     0,   557,   558,   559,     0,
       0,   560,  2422,   197,   561,   198,     0,   562,   563,   564,
     565,   566,   567,   568,     0,   569,     0,   570,     0,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,  1938,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   210,   599,   600,     0,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,     0,
     613,  2423,   614,   615,   219,   616,  1940,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,     0,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,  1941,  1942,     0,     0,   637,     0,   638,     0,     0,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,     0,  1943,  2424,   656,   235,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     708,   668,   669,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,     0,  1925,   137,
    1926,  1927,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,  1928,  1929,   444,     0,   445,   446,   447,   448,
       0,     0,   145,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,   701,   465,  1930,  1931,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1509,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
       0,   491,   492,   493,     0,     0,   494,     0,   495,   496,
    1932,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,     0,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,     0,     0,   519,
     520,   521,  1515,  1933,     0,  1934,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,     0,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,  1935,   189,  1936,   547,   548,
       0,     0,   549,   550,   193,   551,  2510,     0,   552,  1937,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,     0,   197,   561,   198,     0,   562,   563,
     564,   565,   566,   567,   568,     0,   569,     0,   570,     0,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,  1938,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,     0,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
       0,   613,  2423,   614,   615,   219,   616,  1940,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
       0,     0,   628,   629,  4039,   630,   631,   632,   633,   634,
     635,     0,  1941,  1942,     0,     0,   637,     0,   638,     0,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,     0,  1943,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   708,   668,   669,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,     0,  1925,
     137,  1926,  1927,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,  1928,  1929,   444,     0,   445,   446,   447,
     448,     0,     0,   145,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,     0,     0,     0,   152,     0,     0,     0,
     461,   462,   463,   464,   701,   465,  1930,  1931,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1509,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,     0,   491,   492,   493,     0,     0,   494,     0,   495,
     496,  1932,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,     0,     0,   504,     0,   505,
     506,   703,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,     0,     0,
     519,   520,   521,  1515,  1933,     0,  1934,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,     0,   182,   532,   183,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,  1935,   189,  1936,   547,
     548,  2570,     0,   549,   550,   193,   551,     0,     0,   552,
    1937,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,     0,   197,   561,   198,     0,   562,
     563,   564,   565,   566,   567,   568,     0,   569,     0,   570,
       0,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,  1938,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,     0,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,  1939,   614,   615,   219,   616,  1940,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,     0,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,  1941,  1942,     0,     0,   637,     0,   638,
       0,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,     0,  1943,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   708,   668,   669,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,     0,
    1925,   137,  1926,  1927,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,  1928,  1929,   444,     0,   445,   446,
     447,   448,     0,     0,   145,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,   701,   465,  1930,  1931,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1509,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,     0,   491,   492,   493,     0,     0,   494,     0,
     495,   496,  1932,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,     0,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,     0,
       0,   519,   520,   521,  1515,  1933,     0,  1934,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,     0,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1935,   189,  1936,
     547,   548,  3868,     0,   549,   550,   193,   551,     0,     0,
     552,  1937,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,     0,   197,   561,   198,     0,
     562,   563,   564,   565,   566,   567,   568,     0,   569,     0,
     570,     0,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1938,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,     0,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,  1939,   614,   615,   219,   616,  1940,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,     0,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1941,  1942,     0,     0,   637,     0,
     638,     0,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,  1943,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   708,   668,   669,   732,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   733,   104,   105,   687,
     734,     0,   107,   108,   109,   110,   735,   736,   112,   113,
     114,   115,     0,   116,   737,   738,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,     0,     0,
       0,   430,   431,     0,   432,   433,   133,   434,   435,   436,
       0,  1925,   137,  1926,  1927,     0,   437,   438,   439,   440,
     441,     0,     0,   442,   443,  1928,  1929,   444,     0,   445,
     446,   447,   448,     0,     0,   145,     0,   449,   450,   451,
     452,   148,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,   151,   460,     0,     0,     0,     0,   152,     0,
       0,     0,   461,   462,   463,   464,   701,   465,  1930,  1931,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1509,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,     0,   491,   492,   493,     0,     0,   494,
       0,   495,   496,  1932,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,     0,     0,   504,
       0,   505,   506,   703,   507,   508,   173,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,   174,
       0,     0,   519,   520,   521,  1515,  1933,     0,  1934,     0,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,     0,   182,   532,   183,     0,
     533,   534,   535,     0,     0,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,  1935,   189,
    1936,   547,   548,     0,     0,   549,   550,   193,   551,     0,
       0,   552,  1937,   553,   554,   555,     0,   556,     0,     0,
     557,   558,   559,     0,     0,   560,     0,   197,   561,   198,
       0,   562,   563,   564,   565,   566,   567,   568,     0,   569,
       0,   570,     0,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,  1938,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   210,   599,   600,     0,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,     0,   613,  1939,   614,   615,   219,   616,
    1940,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,     0,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,  1941,  1942,     0,     0,   637,
       0,   638,     0,     0,   639,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,   650,     0,     0,
     651,   652,   653,   654,   655,     0,  1943,     0,   656,   235,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   708,   668,   669,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,     0,  1925,   137,  1926,  1927,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,  1928,  1929,   444,     0,
     445,   446,   447,   448,     0,     0,   145,     0,   449,   450,
     451,   452,   148,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,   701,   465,  1930,
    1931,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,  1509,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,     0,   491,   492,   493,     0,     0,
     494,     0,   495,   496,  1932,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,     0,     0,
     504,     0,   505,   506,   703,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,     0,     0,   519,   520,   521,  1515,  1933,     0,  1934,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,     0,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,  1935,
     189,  1936,   547,   548,     0,     0,   549,   550,   193,   551,
       0,     0,   552,  1937,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,     0,   197,   561,
     198,     0,   562,   563,   564,   565,   566,   567,   568,     0,
     569,     0,   570,     0,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,  1938,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,     0,
     601,   602,   603,   604,   605,   606,   706,   607,     0,   608,
     609,   610,   611,   612,     0,   613,  2423,   614,   615,   219,
     616,  1940,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,     0,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,  1941,  1942,     0,     0,
     637,     0,   638,     0,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,     0,  1943,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   708,   668,   669,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,     0,  1925,   137,  1926,  1927,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,  1928,  1929,   444,
       0,   445,   446,   447,   448,     0,     0,   145,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,     0,     0,     0,
     152,     0,     0,     0,   461,   462,   463,   464,   701,   465,
    1930,  1931,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,  1509,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,     0,   491,   492,   493,     0,
       0,   494,     0,   495,   496,  1932,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,     0,
       0,   504,     0,   505,   506,   703,   507,   508,   173,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,   174,     0,     0,   519,   520,   521,  1515,  1933,     0,
    1934,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,     0,   182,   532,
     183,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
    1935,   189,  1936,   547,   548,     0,     0,   549,   550,   193,
     551,     0,     0,   552,  1937,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,     0,   197,
     561,   198,     0,   562,   563,   564,   565,   566,   567,   568,
       0,   569,     0,   570,     0,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,  1938,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
       0,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,     0,   614,   615,
     219,   616,  1940,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,     0,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,  1941,  1942,     0,
       0,   637,     0,   638,     0,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,     0,  1943,     0,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   708,   668,   669,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,     0,     0,   137,     0,     0,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,     0,     0,
     444,     0,   445,   446,   447,   448,     0,     0,   145,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,   701,
     465,     0,     0,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,     0,   491,   492,   493,
       0,     0,   494,     0,   495,   496,     0,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
       0,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,     0,     0,   519,   520,   521,     0,     0,
       0,     0,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,     0,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,     0,   189,     0,   547,   548,     0,     0,   549,   550,
     193,   551,     0,     0,   552,     0,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,     0,
     197,   561,   198,     0,   562,   563,   564,   565,   566,   567,
     568,     0,   569,     0,   570,     0,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,     0,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,     0,   614,
     615,   219,   616,     0,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,     0,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,     0,     0,
       0,     0,   637,     0,   638,     0,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,     0,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,   739,   427,   428,   429,   740,   741,   742,
     743,   744,   745,   746,   430,   431,   747,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,   748,   437,
     438,   439,   440,   441,   749,   750,   442,   443,     0,   140,
     444,   752,   445,   446,   447,   448,   144,   753,   145,   754,
     449,   450,   451,   452,   148,   453,   755,   756,   454,   455,
     456,   457,   458,   459,   757,   151,   460,     0,   759,   760,
     761,   152,   762,   763,   764,   461,   462,   463,   464,     0,
     465,   155,   156,   466,   765,   467,   766,   468,   469,   470,
     471,   472,   767,   473,   474,   475,   768,   769,   476,   477,
     478,   479,   480,   770,   481,   482,   483,   771,   484,   485,
     486,   772,   487,   488,   489,   490,   164,   491,   492,   493,
     166,   773,   494,   774,   495,   496,   168,   497,   775,   498,
     776,   499,   169,   777,   170,   500,   501,   502,   778,   503,
     172,   779,   504,   780,   505,   506,     0,   507,   508,   173,
     509,   510,   511,   781,   512,   513,   514,   515,   516,   517,
     782,   518,   174,   175,     0,   519,   520,   521,     0,   176,
     785,   177,   786,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,   787,   529,   530,   788,   531,   181,   182,
     532,   183,   789,   533,   534,   535,   790,   791,   536,   537,
     538,   539,   540,   541,     0,   542,   543,     0,   544,   545,
     546,   188,   189,   190,   547,   548,   191,   792,   549,   550,
     193,   551,   793,   194,   552,   195,   553,   554,   555,   794,
     556,   795,   796,   557,   558,   559,   797,   798,   560,   196,
     197,   561,   198,   199,   562,   563,   564,   565,   566,   567,
     568,   799,   569,   200,   570,   201,   571,   572,   573,   800,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,   801,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,   802,   597,   598,   210,   599,
     600,   212,   601,   602,   603,   604,   605,   606,     0,   607,
     803,   608,   609,   610,   611,   612,   804,   613,   217,   614,
     615,   219,   616,   220,   617,   805,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,   806,   628,   629,
     807,   630,   631,   632,   633,   634,   635,   808,   224,   225,
       0,   810,   637,   226,   638,   227,   811,   639,   640,   641,
     642,   643,   644,   645,     0,   813,   646,   647,   648,   649,
     650,   814,   815,   651,   652,   653,   654,   655,     0,   234,
     817,   656,   235,   657,   658,   659,   660,   818,   819,   661,
     820,   821,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,     0,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,    37,
      38,    39,    40,    41,    42,     0,    44,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,  1163,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,    37,
      38,    39,    40,    41,    42,     0,    44,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,  2456,   445,   446,   447,   448,   144,     0,     0,  2529,
     449,   450,   451,   452,     0,   453,   699,  2457,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,  2530,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
    2459,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,  2460,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,  2461,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,  2456,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,  2457,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,  2530,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
    2459,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,  3416,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,  2460,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,  2461,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
    1060,   425,   426,  1016,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,  1017,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,  1061,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,  1018,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
    1019,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  1016,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,  1017,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,  3149,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,  1018,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
    1019,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,    44,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,  2456,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,  2457,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,  2530,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
    2459,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,  2460,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,  2461,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,   697,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,   700,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,   702,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  1016,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,  1017,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,  1018,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
    1019,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,   927,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,   928,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   929,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  2116,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,  2117,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,  2118,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
    2119,   499,     0,     0,     0,  2120,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
    2121,  2122,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,  2123,   605,   606,   706,   607,
       0,  2124,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
    2125,   630,  2126,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,  2127,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,  1017,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,  1018,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
    1019,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,  2105,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,  2401,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,  3013,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,  3014,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
    3015,   630,   631,  3016,   633,  3017,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,  3018,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,   724,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,   702,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,   877,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  1244,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  1245,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,  1094,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  1349,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,   130,   131,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  3230,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,  3231,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  3242,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,  3243,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   933,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     978,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,  1033,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,  1094,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  1214,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  1215,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  1597,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  1772,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,  1094,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  1820,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  1821,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,  2013,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,  2105,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,  2401,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,  4186,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,  4200,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,  4425,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,  4427,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,  4429,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,  4845,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,  1042,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  1044,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,  1045,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,  1046,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1047,   225,
       0,     0,  1048,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,  1049,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  1088,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,  1045,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,  1089,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1090,   225,
       0,     0,  1091,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,  1049,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,  1108,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  1239,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  1254,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  1308,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  1322,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  1362,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  1381,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  1383,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  1385,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  1388,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  1394,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,  1608,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,  1073,   443,  1045,   140,
    1609,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
    1077,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,  1078,
     600,   212,   601,   602,   603,  1079,   605,   606,   706,   607,
       0,   608,   609,   610,   611,  1601,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1081,   225,
       0,     0,  1082,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,  1049,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,  1083,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
    1735,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  1044,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,  1045,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,  1049,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  1972,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  2002,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  2037,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  2039,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  2041,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,  2154,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,  2367,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,     0,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  2770,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  3160,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  3233,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  3235,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,  3340,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,  1073,   443,  1045,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
    1077,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,  1078,
     600,   212,   601,   602,   603,  1079,   605,   606,   706,   607,
       0,   608,   609,   610,   611,  1601,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1081,   225,
       0,     0,  1082,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,  1049,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,  1083,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,  1045,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,  1049,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,  1073,   443,  1045,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
    1077,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,  1078,
     600,   212,   601,   602,   603,  1079,   605,   606,   706,   607,
       0,   608,   609,   610,   611,  1601,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,  2447,   632,   633,   634,   635,     0,  1081,   225,
       0,     0,  1082,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,  1049,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,  1083,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,  1073,   443,  1045,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
    1077,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,  1078,
     600,   212,   601,   602,   603,  2514,   605,   606,   706,   607,
       0,   608,   609,   610,   611,  2515,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1081,   225,
       0,     0,  2516,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,  1049,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,  1083,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,  1073,   443,  1045,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
    1077,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,  1078,
     600,   212,   601,   602,   603,  1079,   605,   606,   706,   607,
       0,   608,   609,   610,   611,  2515,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1081,   225,
       0,     0,  2516,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,  1049,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,  1083,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,     0,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,     0,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,     0,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
      86,    87,    88,     0,    90,    91,    92,     0,     0,     0,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,     0,     0,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115, -2438,   116,   117,   118,     0,
       0,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,   127,    35,     0,   413,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   133,
       0,     0,     0,   135,   136,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   140,
       0,     0,     0,     0,     0,     0,   144,     0,   145,     0,
       0,     0,     0,     0,   148,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
       0,   152,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   155,   156,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   162,     0,
       0,     0,     0,     0,     0,     0,   164,     0,     0,     0,
     166,     0,     0,     0,     0,     0,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     172,     0,     0,     0,     0,     0,     0,     0,     0,   173,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   174,   175,     0,     0,     0,     0,     0,   176,
       0,   177,     0,     0,   178,   179,     0,   180,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   181,   182,
       0,   183,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
     193,     0,     0,   194,     0,   195,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   196,
     197,     0,   198,   199,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   200,     0,   201,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   210,     0,
       0,   212,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   217,     0,
       0,   219,     0,   220,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   224,   225,
       0,     0,     0,   226,     0,   227,     0,     0,     0,     0,
       0,     0,     0,     0,   230,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   234,
       0,     0,   235,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    86,    87,    88,
       0,    90,    91,    92,     0,     0,     0,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,     0,
       0,     0,   107,   108,   109,   110,     0,   111,   112,   113,
     114,   115, -2439,   116,   117,   118,     0,     0,     0,     0,
       0,   121,   122,     0,     0,     0,     0,   123,     0,     0,
       0,     0,     0,     0,     0,     0,   124,     0,   125,     0,
     126,   127,    35,     0,  1158,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   133,     0,     0,     0,
     135,   136,   137,   138,   139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   140,     0,     0,     0,
       0,     0,     0,   144,     0,   145,     0,     0,     0,     0,
       0,   148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,     0,   152,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   155,   156,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,     0,     0,     0,
       0,     0,     0,   164,     0,     0,     0,   166,     0,     0,
       0,     0,     0,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   172,     0,     0,
       0,     0,     0,     0,     0,     0,   173,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   174,
     175,     0,     0,     0,     0,     0,   176,     0,   177,     0,
       0,   178,   179,     0,   180,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   181,   182,     0,   183,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   188,   189,
     190,     0,     0,   191,     0,     0,     0,   193,     0,     0,
     194,     0,   195,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   196,   197,     0,   198,
     199,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   203,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   210,     0,     0,   212,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   217,     0,     0,   219,     0,
     220,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   222,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   224,   225,     0,     0,     0,
     226,     0,   227,     0,     0,     0,     0,     0,     0,     0,
       0,   230,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   234,     0,     0,   235,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   237,   238,   239,   240,   241,
     242,   243,   244,   245,    86,    87,    88,     0,    90,    91,
      92,     0,     0,     0,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,     0,     0,     0,   107,
     108,   109,   110,     0,   111,   112,   113,   114,   115,     0,
     116,   117,   118,     0,     0,     0,     0,     0,   121,   122,
       0,     0,     0,     0,   123,     0,     0,     0,     0,     0,
       0,     0,     0,   124,     0,   125,     0,   126,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,     0,     0,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
     144,     0,   145,     0,     0,     0,     0,     0,   148,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   151,
       0,     0,     0,     0,     0,   152,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   155,   156,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   162,     0,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,   166,     0,     0,     0,     0,     0,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   172,     0,     0,     0,     0,     0,
       0,     0,     0,   173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   175,     0,     0,
       0,     0,     0,   176,     0,   177,     0,     0,   178,   179,
       0,   180,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   181,   182,     0,   183,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,   193,     0,     0,   194,     0,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   196,   197,     0,   198,   199,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   200,     0,   201,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   203,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   210,     0,     0,   212,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   217,     0,     0,   219,     0,   220,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   224,   225,     0,     0,     0,   226,     0,   227,
       0,     0,     0,     0,     0,     0,     0,     0,   230,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   234,     0,     0,   235,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    86,    87,    88,     0,    90,    91,    92,     0,     0,
       0,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,     0,     0,     0,   107,   108,   109,   110,
       0,   111,   112,   113,   114,   115,     0,   116,   117,   118,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     133,     0,     0,     0,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,   144,     0,   145,
       0,     0,     0,     0,     0,   148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   151,     0,     0,     0,
       0,     0,   152,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   155,   156,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,     0,   164,     0,     0,
       0,   166,     0,     0,     0,     0,     0,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   172,     0,     0,     0,     0,     0,     0,     0,     0,
     173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   174,   175,     0,     0,     0,     0,     0,
     176,     0,   177,     0,     0,   178,   179,     0,   180,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   181,
     182,     0,   183,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   188,   189,   190,     0,     0,   191,     0,     0,
       0,   193,     0,     0,   194,     0,   195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     196,   197,     0,   198,   199,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   200,     0,   201,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   203,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   210,
       0,     0,   212,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   217,
       0,     0,   219,     0,   220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   224,
     225,     0,     0,     0,   226,     0,   227,     0,     0,     0,
       0,     0,     0,     0,     0,   230,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     234,     0,     0,   235,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   237,
     238,   239,   240,   241,   242,   243,   244,   245,    86,    87,
      88,     0,    90,    91,    92,     0,     0,     0,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
       0,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,   144,     0,   145,     0,     0,     0,
       0,     0,   148,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   151,     0,     0,     0,     0,     0,   152,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   155,
     156,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   164,     0,     0,     0,   166,     0,
       0,     0,     0,     0,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   172,     0,
       0,     0,     0,     0,     0,     0,     0,   173,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     174,   175,     0,     0,     0,     0,     0,   176,     0,   177,
       0,     0,   178,   179,     0,   180,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   181,   182,     0,   183,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   188,
     189,   190,     0,     0,   191,     0,     0,     0,   193,     0,
       0,   194,     0,   195,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   196,   197,     0,
     198,   199,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   200,     0,   201,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   203,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   210,     0,     0,   212,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   217,     0,     0,   219,
       0,   220,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   222,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   224,   225,     0,     0,
       0,   226,     0,   227,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   234,     0,     0,
     235,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   237,   238,   239,   240,
     241,   242,   243,   244,   245,    35,   418,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,     0,     0,     0,
      45,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,     0,   140,
     444,     0,   445,   446,   447,   448,   144,     0,   145,     0,
     449,   450,   451,   452,   148,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,  2081,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,     0,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,     0,   542,   543,     0,   544,   545,
     546,   188,   189,   190,   547,   548,   191,     0,   549,   550,
     193,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,  2082,     0,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,   212,   601,   602,   603,   604,   605,   606,     0,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,   219,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,  2083,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,   234,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,     0,   668,   669,
       0,     0,     0,    35,     0,     0,     0,     0,  1692,  1693,
    4692,    41,    42,     0,     0,     0,     0,  4693,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,   130,   131,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,     0,   140,   444,     0,
     445,   446,   447,   448,   144,     0,   145,     0,   449,   450,
     451,   452,   148,   453,     0,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,     0,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,     0,   542,   543,     0,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,     0,   607,   215,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,   223,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,   233,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,   236,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,     0,   668,   669,    35,   418,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
       0,     0,     0,    45,     0,   246,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,     0,     0,   430,   431,     0,
     432,   433,   133,   434,   435,   436,   135,   136,   137,   138,
     139,     0,   437,   438,   439,   440,   441,     0,     0,   442,
     443,     0,   140,   444,     0,   445,   446,   447,   448,   144,
       0,   145,     0,   449,   450,   451,   452,   148,   453,     0,
       0,   454,   455,   456,   457,   458,   459,     0,   151,   460,
       0,     0,     0,     0,   152,     0,     0,     0,   461,   462,
     463,   464,     0,   465,   155,   156,   466,  2302,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,   164,
     491,   492,   493,   166,  2081,   494,     0,   495,   496,   168,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,     0,
     507,   508,   173,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,   174,   175,     0,   519,   520,
     521,     0,   176,     0,   177,     0,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,   181,   182,   532,   183,     0,   533,   534,   535,     0,
       0,   536,   537,   538,   539,   540,   541,     0,   542,   543,
       0,   544,   545,   546,   188,   189,   190,   547,   548,   191,
       0,   549,   550,   193,   551,     0,   194,   552,   195,   553,
     554,   555,     0,   556,  2082,     0,   557,   558,   559,     0,
       0,   560,   196,   197,   561,   198,   199,   562,   563,   564,
     565,   566,   567,   568,     0,   569,   200,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   203,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   210,   599,   600,   212,   601,   602,   603,   604,   605,
     606,     0,   607,     0,   608,   609,   610,   611,   612,     0,
     613,   217,   614,   615,   219,   616,   220,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,   224,   225,     0,     0,   637,   226,   638,   227,  2083,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,     0,   234,     0,   656,   235,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,   238,   239,   240,   241,   242,   243,   244,   245,
       0,   668,   669,     0,     0,     0,     0,     0,     0,    35,
     418,  1692,  1693,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,     0,    45,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,     0,   140,   444,     0,   445,   446,   447,   448,
     144,     0,   145,     0,   449,   450,   451,   452,   148,   453,
       0,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   155,   156,   466,  2307,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,  2081,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
       0,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,     0,   542,
     543,     0,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,  2082,     0,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,     0,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
    2083,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,     0,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,     0,   668,   669,     0,     0,     0,     0,     0,     0,
      35,   418,  1692,  1693,    37,    38,    39,    40,    41,    42,
      43,    44,     0,     0,     0,    45,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,   135,   136,
     137,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,     0,   140,   444,     0,   445,   446,   447,
     448,   144,     0,   145,     0,   449,   450,   451,   452,   148,
     453,     0,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,     0,     0,     0,   152,     0,     0,     0,
     461,   462,   463,   464,     0,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,  2081,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,     0,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,   182,   532,   183,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   543,     0,   544,   545,   546,   188,   189,   190,   547,
     548,   191,     0,   549,   550,   193,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,  2082,     0,   557,   558,
     559,     0,     0,   560,   196,   197,   561,   198,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,   212,   601,   602,   603,
     604,   605,   606,     0,   607,     0,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,   219,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,  2083,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,     0,   234,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,     0,   668,   669,     0,     0,     0,     0,     0,
       0,    35,     0,  1692,  1693,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,     0,   140,   444,     0,   445,   446,
     447,   448,   144,     0,   145,     0,   449,   450,   451,   452,
     148,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,  2081,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,     0,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
       0,   542,   543,     0,   544,   545,   546,   188,   189,   190,
     547,   548,   191,     0,   549,   550,   193,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,  2082,     0,   557,
     558,   559,     0,     0,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,     0,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,   219,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,  2083,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,   234,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,     0,   668,   669,    35,   418,     0,     0,
      37,    38,    39,    40,    41,    42,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,   135,   136,   137,   138,   139,     0,
     437,   438,   439,   440,   441,     0,     0,   442,   443,     0,
     140,   444,     0,   445,   446,   447,   448,   144,     0,   145,
       0,   449,   450,   451,   452,   148,   453,     0,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,     0,
       0,     0,   152,     0,     0,     0,   461,   462,   463,   464,
       0,   465,   155,   156,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,   164,   491,   492,
     493,   166,     0,   494,     0,   495,   496,   168,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,     0,   507,   508,
     173,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,   175,     0,   519,   520,   521,     0,
     176,     0,   177,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,   181,
     182,   532,   183,     0,   533,   534,   535,     0,     0,   536,
     537,   538,   539,   540,   541,     0,   542,   543,     0,   544,
     545,   546,   188,   189,   190,   547,   548,   191,     0,   549,
     550,   193,   551,     0,   194,   552,   195,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
     196,   197,   561,   198,   199,   562,   563,   564,   565,   566,
     567,   568,     0,   569,   200,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   203,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,   212,   601,   602,   603,   604,   605,   606,     0,
     607,     0,   608,   609,   610,   611,   612,     0,   613,   217,
     614,   615,   219,   616,   220,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,   224,
     225,   636,     0,   637,   226,   638,   227,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,     0,
     234,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
     238,   239,   240,   241,   242,   243,   244,   245,     0,   668,
     669,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,     0,   140,   444,     0,   445,   446,
     447,   448,   144,     0,   145,     0,   449,   450,   451,   452,
     148,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,     0,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
       0,   542,   543,     0,   544,   545,   546,   188,   189,   190,
     547,   548,   191,     0,   549,   550,   193,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,     0,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,   219,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,   234,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    35,   668,   669,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,     0,   140,   444,     0,
     445,   446,   447,   448,   144,     0,   145,     0,   449,   450,
     451,   452,   148,   453,     0,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   155,
     156,   466,  2287,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,     0,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,     0,   542,   543,     0,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,     0,   607,     0,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,     0,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,    35,   668,   669,     0,    37,
      38,    39,    40,    41,    42,     0,    44,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,     0,   140,
     444,     0,   445,   446,   447,   448,   144,     0,   145,     0,
     449,   450,   451,   452,   148,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,     0,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,     0,   542,   543,     0,   544,   545,
     546,   188,   189,   190,   547,   548,   191,     0,   549,   550,
     193,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,   212,   601,   602,   603,   604,   605,   606,     0,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,   219,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,   234,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    35,   668,   669,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
       0,   140,   444,     0,   445,   446,   447,   448,   144,     0,
     145,     0,   449,   450,   451,   452,   148,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,     0,   507,
    2061,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,     0,   542,   543,     0,
     544,   545,   546,   188,   189,   190,   547,   548,   191,     0,
     549,   550,   193,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
       0,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,   219,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
       0,   234,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,    35,
     668,   669,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,     0,   140,   444,     0,   445,   446,   447,   448,
     144,     0,   145,     0,   449,   450,   451,   452,   148,   453,
       0,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,  2630,   461,
     462,   463,   464,     0,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
       0,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,     0,   542,
     543,     0,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,     0,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,  2631,     0,   651,   652,   653,
     654,   655,     0,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    35,   668,   669,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,   130,   131,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,     0,   140,   444,     0,   445,   446,
     447,   448,   144,     0,   145,     0,   449,   450,   451,   452,
     148,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,     0,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
       0,   542,   543,     0,   544,   545,   546,   188,   189,   190,
     547,   548,   191,     0,   549,   550,   193,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,     0,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,   219,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,   234,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    35,   668,   669,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,  1235,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,     0,   140,   444,     0,
     445,   446,   447,   448,   144,     0,   145,     0,   449,   450,
     451,   452,   148,   453,     0,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,     0,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,     0,   542,   543,     0,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,     0,   607,     0,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,     0,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,    35,   668,   669,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  1251,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,     0,   140,
     444,     0,   445,   446,   447,   448,   144,     0,   145,     0,
     449,   450,   451,   452,   148,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,     0,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
    1252,   539,   540,   541,     0,   542,   543,     0,   544,   545,
     546,   188,   189,   190,   547,   548,   191,     0,   549,   550,
     193,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,   212,   601,   602,   603,   604,   605,   606,     0,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,   219,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,   234,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    35,   668,   669,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
       0,   140,   444,     0,   445,   446,   447,   448,   144,     0,
     145,     0,   449,   450,   451,   452,   148,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,   172,  3521,   504,     0,   505,   506,     0,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,     0,   542,   543,     0,
     544,   545,   546,   188,   189,   190,   547,   548,   191,     0,
     549,   550,   193,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
       0,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,   219,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
       0,   234,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,    35,
     668,   669,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,     0,   140,   444,     0,   445,   446,   447,   448,
     144,     0,   145,     0,   449,   450,   451,   452,   148,   453,
       0,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
       0,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,     0,   542,
     543,     0,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,     0,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,     0,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    35,   668,   669,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,     0,   140,   444,     0,   445,   446,
     447,   448,   144,     0,   145,     0,   449,   450,   451,   452,
     148,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,     0,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,  1330,   539,   540,   541,
       0,   542,   543,     0,   544,   545,   546,   188,   189,   190,
     547,   548,   191,     0,   549,   550,   193,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,     0,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,   219,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,   234,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    35,   668,   669,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,     0,   140,   444,     0,
     445,   446,   447,   448,   144,     0,   145,     0,   449,   450,
     451,   452,   148,   453,     0,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,     0,   507,  1369,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,     0,   542,   543,     0,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,     0,   607,     0,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,     0,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,    35,   668,   669,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,     0,   140,
     444,     0,   445,   446,   447,   448,   144,     0,   145,     0,
     449,   450,   451,   452,   148,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,     0,   507,  1379,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,     0,   542,   543,     0,   544,   545,
     546,   188,   189,   190,   547,   548,   191,     0,   549,   550,
     193,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,   212,   601,   602,   603,   604,   605,   606,     0,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,   219,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,   234,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    35,   668,   669,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
       0,   140,   444,     0,   445,   446,   447,   448,   144,     0,
     145,     0,   449,   450,   451,   452,   148,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,     0,   507,
    1390,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,  1391,   539,   540,   541,     0,   542,   543,     0,
     544,   545,   546,   188,   189,   190,   547,   548,   191,     0,
     549,   550,   193,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
       0,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,   219,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
       0,   234,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,     0,
     668,   669
};

static const yytype_int16 yycheck[] =
{
       2,   381,  1075,   901,  1124,  1368,    78,   246,   167,    78,
      78,    78,    78,   381,  1416,    84,    78,  1372,  1377,   365,
    1129,   209,    96,   940,   117,  1092,  1263,   153,   187,  1758,
     154,  1194,   106,  2362,   858,   960,  1236,  1017,  1018,  1019,
    1955,  1446,  2120,  1023,   150,   970,   228,  1629,  2866,  1241,
    1300,  1793,  1939,  1253,  1479,  2427,  2428,  2070,   117,   940,
     958,  1507,  1508,   730,  2264,  1536,   171,   984,   142,   162,
    1799,  1898,  1998,  1082,   160,  3414,    78,   901,   202,  2702,
    1526,  1803,    84,   157,  1957,  2276,  2710,    89,  1813,  1319,
    3246,  3226,  3248,   165,  3477,   223,  1849,    94,   132,  1329,
    3721,  2326,  3202,   162,   209,  1305,    78,  1650,  1358,  1309,
    2159,  2620,    84,    78,  1314,   117,   367,  3087,   353,   731,
    3439,  1321,  1686,  1687,  1688,   165,   367,  3395,  2845,  3026,
    4029,  1331,  3774,  2059,   958,   132,  1171,   230,  2569,  1861,
    3382,  1866,  1867,  1240,  3667,   117,  1171,  3466,  3823,  1246,
    3976,   153,   983,  3395,  1408,  3770,   153,   154,  1255,  1741,
     162,  1078,   216,  3024,  3025,  4040,   163,   208,  4019,  2958,
    3673,   230,  1785,  1799,  1211,   117,  1745,   218,  1409,  1400,
    3118,   167,  2009,  4264,  2001,  1121,  1429,  1681,  1682,  2374,
     162,  1152,  1121,  2667,  1166,  1167,  3731,  1078,  1496,  1497,
    4475,   187,  3672,    21,  3599,   202,   208,  3641,    10,    30,
     975,    72,  4769,   121,   216,  4017,   218,  4581,   117,  4583,
     162,   114,    14,   135,  1522,    86,  4028,  2427,   230,  2414,
     108,   102,    88,  2418,  3399,  3400,  3401,  3402,  3403,  3404,
     156,    88,    95,    84,   128,    37,   838,    75,    76,    77,
      78,   149,  4762,   128,    82,    72,  1217,   113,   230,  4622,
     927,   128,    88,   162,   179,    75,    76,    77,    78,   204,
     114,   230,    82,  1646,  2705,   180,   145,   112,     2,    78,
      72,   249,    93,    75,    76,    77,    78,   143,   230,    81,
      82,    83,    84,   112,    86,   145,    75,    76,    77,    78,
    1554,   373,   326,    82,  3093,   373,   373,   373,   187,   208,
    2225,   373,   381,   224,    72,   238,    29,   216,  1298,   218,
     328,  3948,    75,    76,    77,    78,    78,   237,    86,    82,
     143,   230,    75,    76,    77,    78,   182,   229,   145,    82,
     229,    78,  1409,   385,   197,  3021,   153,   416,  2779,   109,
    2781,   100,   180,    78,   155,   268,   135,   376,   367,    78,
    4708,    75,    76,    77,    78,   103,   104,   145,    82,    78,
     229,    75,    76,    77,    78,   458,  1613,   145,    82,   381,
     137,   387,   135,    99,   145,  1283,    90,   311,   224,  3021,
     106,   180,  1555,   194,   511,    75,    76,    77,    78,   210,
     517,   229,    82,    72,  3080,  1072,    99,   173,   373,   381,
    2488,    88,    81,   106,   416,   457,    78,    86,   199,  1582,
     417,  2193,    75,    76,    77,    78,   272,   362,   188,    82,
     513,    75,    76,    77,    78,  2207,   113,    90,    82,    75,
      76,    77,    78,  4269,   416,    78,    82,   229,  3080,    99,
     182,   208,   153,  1378,    90,  1416,   106,  4821,   477,  1283,
     840,   470,   102,   379,    78,   376,   143,   313,   128,   226,
      99,  1942,   840,    78,   482,   385,  1393,     0,    95,  4754,
      75,    76,    77,    78,  1930,  1931,  2258,    82,   173,   513,
     228,  1937,   230,    78,  2679,    90,   380,   516,  3204,  1416,
     211,    75,    76,    77,    78,   380,   377,   513,    82,  1576,
     636,    78,  1393,   380,   263,   235,    90,   363,   389,    75,
      76,    77,    78,   438,   313,    14,    82,  1452,    75,    76,
      77,    78,    38,   229,    40,    82,  2423,    25,   462,   462,
     185,   173,  1467,   436,  1907,   458,  4894,   260,   516,  5059,
     448,  1618,  1619,  1912,   513,  1480,  1168,  1169,   682,   683,
    2433,    75,    76,    77,    78,   480,  1483,   436,    82,   440,
      75,    76,    77,    78,   373,   416,   387,    82,   513,   458,
     197,  3849,    75,    76,    77,    78,   436,  1418,   423,    82,
      75,    76,    77,    78,   405,   500,  1188,    82,   355,  3764,
     516,   513,  1483,   456,   423,   513,    72,  3849,   436,    75,
      76,    77,    78,  4439,    72,    81,    82,    83,    84,   463,
      86,   373,  5179,    81,   516,  4988,  4477,   516,    86,   436,
    1928,  1929,   516,  1398,   636,   513,   373,  2219,  1936,   636,
     