/* A Bison parser, made by GNU Bison 2.5.  */

/* Bison implementation for Yacc-like parsers in C
   
      Copyright (C) 1984, 1989-1990, 2000-2011 Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 1

/* Substitute the variable and function names.  */
#define yyparse         base_yyparse
#define yylex           base_yylex
#define yyerror         base_yyerror
#define yylval          base_yylval
#define yychar          base_yychar
#define yydebug         base_yydebug
#define yynerrs         base_yynerrs
#define yylloc          base_yylloc

/* Copy the first part of user declarations.  */

/* Line 268 of yacc.c  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
		if (N)						\
			(Current) = (Rhs)[1];	\
		else						\
			(Current) = (Rhs)[0];	\
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char	pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);

			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
				fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), mm_strdup(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in another functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn't cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = EMPTY;
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char var_text[20];
			char *original_var;
			bool skip_set_var = false;
			bool var_ptr = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(var_text, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable)
					 && (strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement")) == 0))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar
					  && ptr->variable->type->type != ECPGt_char
					  && ptr->variable->type->type != ECPGt_unsigned_char
					  && ptr->variable->type->type != ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																			   mm_strdup("1"),
																			   ptr->variable->type->u.element->counter),
														  ptr->variable->type->size),
									  0);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar
					  || ptr->variable->type->type == ECPGt_char
					  || ptr->variable->type->type == ECPGt_unsigned_char
					  || ptr->variable->type->type == ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				if (ptr->variable->type->type == ECPGt_varchar)
					var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_struct
					 || ptr->variable->type->type == ECPGt_union)
			{
				newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
									  ECPGmake_struct_type(ptr->variable->type->u.members,
														   ptr->variable->type->type,
														   ptr->variable->type->type_name,
														   ptr->variable->type->struct_sizeof),
									  0);
				var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct
					|| ptr->variable->type->u.element->type == ECPGt_union)
				{
					newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->variable->type->u.element->u.members,
															   ptr->variable->type->u.element->type,
															   ptr->variable->type->u.element->type_name,
															   ptr->variable->type->u.element->struct_sizeof),
										  0);
				}
				else
				{
					newvar = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																				   ptr->variable->type->u.element->size,
																				   ptr->variable->type->u.element->counter),
															  ptr->variable->type->size),
										  0);
					var_ptr = true;
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, mm_strdup("*("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				var_ptr = true;
			}

			/* create call to "ECPGset_var(<counter>, <connection>, <pointer>. <line number>)" */
			if (!skip_set_var)
			{
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(var_text, "%d))", ecpg_internal_var);
				var_ptr = false;

				if (ptr->indicator->type->type == ECPGt_struct
					|| ptr->indicator->type->type == ECPGt_union)
				{
					newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->indicator->type->u.members,
															   ptr->indicator->type->type,
															   ptr->indicator->type->type_name,
															   ptr->indicator->type->struct_sizeof),
										  0);
					var_ptr = true;
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct
						|| ptr->indicator->type->u.element->type == ECPGt_union)
					{
						newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
											  ECPGmake_struct_type(ptr->indicator->type->u.element->u.members,
																   ptr->indicator->type->u.element->type,
																   ptr->indicator->type->u.element->type_name,
																   ptr->indicator->type->u.element->struct_sizeof),
											  0);
					}
					else
					{
						newind = new_variable(cat_str(4, mm_strdup("("),
													  mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)),
													  mm_strdup(" *)(ECPGget_var("), mm_strdup(var_text)),
											  ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type,
																					   ptr->indicator->type->u.element->size,
																					   ptr->indicator->type->u.element->counter),
																  ptr->indicator->type->size),
											  0);
						var_ptr = true;
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
				}
				else
				{
					newind = new_variable(cat_str(4, mm_strdup("*("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
					var_ptr = true;
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && strcmp(cur->function, current_function) == 0))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;
	int (* strcmp_fn)(const char *, const char *) = ((name[0] == ':' || name[0] == '"') ? strcmp : pg_strcasecmp);

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp_fn(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char *dimension, char *length, enum ECPGttype type_enum,
			char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
		 type_enum == ECPGt_union) &&
		initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Line 268 of yacc.c  */
#line 635 "preproc.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     CSTRING = 326,
     CVARIABLE = 327,
     CPP_LINE = 328,
     IP = 329,
     DOLCONST = 330,
     ECONST = 331,
     NCONST = 332,
     UCONST = 333,
     UIDENT = 334,
     IDENT = 335,
     FCONST = 336,
     SCONST = 337,
     BCONST = 338,
     XCONST = 339,
     Op = 340,
     ICONST = 341,
     PARAM = 342,
     TYPECAST = 343,
     DOT_DOT = 344,
     COLON_EQUALS = 345,
     ABORT_P = 346,
     ABSOLUTE_P = 347,
     ACCESS = 348,
     ACTION = 349,
     ADD_P = 350,
     ADMIN = 351,
     AFTER = 352,
     AGGREGATE = 353,
     ALL = 354,
     ALSO = 355,
     ALTER = 356,
     ALWAYS = 357,
     ANALYSE = 358,
     ANALYZE = 359,
     AND = 360,
     ANY = 361,
     ARRAY = 362,
     AS = 363,
     ASC = 364,
     ASSERTION = 365,
     ASSIGNMENT = 366,
     ASYMMETRIC = 367,
     AT = 368,
     ATTRIBUTE = 369,
     AUTHORIZATION = 370,
     BACKWARD = 371,
     BEFORE = 372,
     BEGIN_P = 373,
     BETWEEN = 374,
     BIGINT = 375,
     BINARY = 376,
     BIT = 377,
     BOOLEAN_P = 378,
     BOTH = 379,
     BY = 380,
     CACHE = 381,
     CALLED = 382,
     CASCADE = 383,
     CASCADED = 384,
     CASE = 385,
     CAST = 386,
     CATALOG_P = 387,
     CHAIN = 388,
     CHAR_P = 389,
     CHARACTER = 390,
     CHARACTERISTICS = 391,
     CHECK = 392,
     CHECKPOINT = 393,
     CLASS = 394,
     CLOSE = 395,
     CLUSTER = 396,
     COALESCE = 397,
     COLLATE = 398,
     COLLATION = 399,
     COLUMN = 400,
     COMMENT = 401,
     COMMENTS = 402,
     COMMIT = 403,
     COMMITTED = 404,
     CONCURRENTLY = 405,
     CONFIGURATION = 406,
     CONNECTION = 407,
     CONSTRAINT = 408,
     CONSTRAINTS = 409,
     CONTENT_P = 410,
     CONTINUE_P = 411,
     CONVERSION_P = 412,
     COPY = 413,
     COST = 414,
     CREATE = 415,
     CROSS = 416,
     CSV = 417,
     CURRENT_P = 418,
     CURRENT_CATALOG = 419,
     CURRENT_DATE = 420,
     CURRENT_ROLE = 421,
     CURRENT_SCHEMA = 422,
     CURRENT_TIME = 423,
     CURRENT_TIMESTAMP = 424,
     CURRENT_USER = 425,
     CURSOR = 426,
     CYCLE = 427,
     DATA_P = 428,
     DATABASE = 429,
     DAY_P = 430,
     DEALLOCATE = 431,
     DEC = 432,
     DECIMAL_P = 433,
     DECLARE = 434,
     DEFAULT = 435,
     DEFAULTS = 436,
     DEFERRABLE = 437,
     DEFERRED = 438,
     DEFINER = 439,
     DELETE_P = 440,
     DELIMITER = 441,
     DELIMITERS = 442,
     DESC = 443,
     DICTIONARY = 444,
     DISABLE_P = 445,
     DISCARD = 446,
     DISTINCT = 447,
     DO = 448,
     DOCUMENT_P = 449,
     DOMAIN_P = 450,
     DOUBLE_P = 451,
     DROP = 452,
     EACH = 453,
     ELSE = 454,
     ENABLE_P = 455,
     ENCODING = 456,
     ENCRYPTED = 457,
     END_P = 458,
     ENUM_P = 459,
     ESCAPE = 460,
     EVENT = 461,
     EXCEPT = 462,
     EXCLUDE = 463,
     EXCLUDING = 464,
     EXCLUSIVE = 465,
     EXECUTE = 466,
     EXISTS = 467,
     EXPLAIN = 468,
     EXTENSION = 469,
     EXTERNAL = 470,
     EXTRACT = 471,
     FALSE_P = 472,
     FAMILY = 473,
     FETCH = 474,
     FIRST_P = 475,
     FLOAT_P = 476,
     FOLLOWING = 477,
     FOR = 478,
     FORCE = 479,
     FOREIGN = 480,
     FORWARD = 481,
     FREEZE = 482,
     FROM = 483,
     FULL = 484,
     FUNCTION = 485,
     FUNCTIONS = 486,
     GLOBAL = 487,
     GRANT = 488,
     GRANTED = 489,
     GREATEST = 490,
     GROUP_P = 491,
     HANDLER = 492,
     HAVING = 493,
     HEADER_P = 494,
     HOLD = 495,
     HOUR_P = 496,
     IDENTITY_P = 497,
     IF_P = 498,
     ILIKE = 499,
     IMMEDIATE = 500,
     IMMUTABLE = 501,
     IMPLICIT_P = 502,
     IN_P = 503,
     INCLUDING = 504,
     INCREMENT = 505,
     INDEX = 506,
     INDEXES = 507,
     INHERIT = 508,
     INHERITS = 509,
     INITIALLY = 510,
     INLINE_P = 511,
     INNER_P = 512,
     INOUT = 513,
     INPUT_P = 514,
     INSENSITIVE = 515,
     INSERT = 516,
     INSTEAD = 517,
     INT_P = 518,
     INTEGER = 519,
     INTERSECT = 520,
     INTERVAL = 521,
     INTO = 522,
     INVOKER = 523,
     IS = 524,
     ISNULL = 525,
     ISOLATION = 526,
     JOIN = 527,
     KEY = 528,
     LABEL = 529,
     LANGUAGE = 530,
     LARGE_P = 531,
     LAST_P = 532,
     LATERAL_P = 533,
     LC_COLLATE_P = 534,
     LC_CTYPE_P = 535,
     LEADING = 536,
     LEAKPROOF = 537,
     LEAST = 538,
     LEFT = 539,
     LEVEL = 540,
     LIKE = 541,
     LIMIT = 542,
     LISTEN = 543,
     LOAD = 544,
     LOCAL = 545,
     LOCALTIME = 546,
     LOCALTIMESTAMP = 547,
     LOCATION = 548,
     LOCK_P = 549,
     MAPPING = 550,
     MATCH = 551,
     MATERIALIZED = 552,
     MAXVALUE = 553,
     MINUTE_P = 554,
     MINVALUE = 555,
     MODE = 556,
     MONTH_P = 557,
     MOVE = 558,
     NAME_P = 559,
     NAMES = 560,
     NATIONAL = 561,
     NATURAL = 562,
     NCHAR = 563,
     NEXT = 564,
     NO = 565,
     NONE = 566,
     NOT = 567,
     NOTHING = 568,
     NOTIFY = 569,
     NOTNULL = 570,
     NOWAIT = 571,
     NULL_P = 572,
     NULLIF = 573,
     NULLS_P = 574,
     NUMERIC = 575,
     OBJECT_P = 576,
     OF = 577,
     OFF = 578,
     OFFSET = 579,
     OIDS = 580,
     ON = 581,
     ONLY = 582,
     OPERATOR = 583,
     OPTION = 584,
     OPTIONS = 585,
     OR = 586,
     ORDER = 587,
     OUT_P = 588,
     OUTER_P = 589,
     OVER = 590,
     OVERLAPS = 591,
     OVERLAY = 592,
     OWNED = 593,
     OWNER = 594,
     PARSER = 595,
     PARTIAL = 596,
     PARTITION = 597,
     PASSING = 598,
     PASSWORD = 599,
     PLACING = 600,
     PLANS = 601,
     POSITION = 602,
     PRECEDING = 603,
     PRECISION = 604,
     PRESERVE = 605,
     PREPARE = 606,
     PREPARED = 607,
     PRIMARY = 608,
     PRIOR = 609,
     PRIVILEGES = 610,
     PROCEDURAL = 611,
     PROCEDURE = 612,
     PROGRAM = 613,
     QUOTE = 614,
     RANGE = 615,
     READ = 616,
     REAL = 617,
     REASSIGN = 618,
     RECHECK = 619,
     RECURSIVE = 620,
     REF = 621,
     REFERENCES = 622,
     REFRESH = 623,
     REINDEX = 624,
     RELATIVE_P = 625,
     RELEASE = 626,
     RENAME = 627,
     REPEATABLE = 628,
     REPLACE = 629,
     REPLICA = 630,
     RESET = 631,
     RESTART = 632,
     RESTRICT = 633,
     RETURNING = 634,
     RETURNS = 635,
     REVOKE = 636,
     RIGHT = 637,
     ROLE = 638,
     ROLLBACK = 639,
     ROW = 640,
     ROWS = 641,
     RULE = 642,
     SAVEPOINT = 643,
     SCHEMA = 644,
     SCROLL = 645,
     SEARCH = 646,
     SECOND_P = 647,
     SECURITY = 648,
     SELECT = 649,
     SEQUENCE = 650,
     SEQUENCES = 651,
     SERIALIZABLE = 652,
     SERVER = 653,
     SESSION = 654,
     SESSION_USER = 655,
     SET = 656,
     SETOF = 657,
     SHARE = 658,
     SHOW = 659,
     SIMILAR = 660,
     SIMPLE = 661,
     SMALLINT = 662,
     SNAPSHOT = 663,
     SOME = 664,
     STABLE = 665,
     STANDALONE_P = 666,
     START = 667,
     STATEMENT = 668,
     STATISTICS = 669,
     STDIN = 670,
     STDOUT = 671,
     STORAGE = 672,
     STRICT_P = 673,
     STRIP_P = 674,
     SUBSTRING = 675,
     SYMMETRIC = 676,
     SYSID = 677,
     SYSTEM_P = 678,
     TABLE = 679,
     TABLES = 680,
     TABLESPACE = 681,
     TEMP = 682,
     TEMPLATE = 683,
     TEMPORARY = 684,
     TEXT_P = 685,
     THEN = 686,
     TIME = 687,
     TIMESTAMP = 688,
     TO = 689,
     TRAILING = 690,
     TRANSACTION = 691,
     TREAT = 692,
     TRIGGER = 693,
     TRIM = 694,
     TRUE_P = 695,
     TRUNCATE = 696,
     TRUSTED = 697,
     TYPE_P = 698,
     TYPES_P = 699,
     UNBOUNDED = 700,
     UNCOMMITTED = 701,
     UNENCRYPTED = 702,
     UNION = 703,
     UNIQUE = 704,
     UNKNOWN = 705,
     UNLISTEN = 706,
     UNLOGGED = 707,
     UNTIL = 708,
     UPDATE = 709,
     USER = 710,
     USING = 711,
     VACUUM = 712,
     VALID = 713,
     VALIDATE = 714,
     VALIDATOR = 715,
     VALUE_P = 716,
     VALUES = 717,
     VARCHAR = 718,
     VARIADIC = 719,
     VARYING = 720,
     VERBOSE = 721,
     VERSION_P = 722,
     VIEW = 723,
     VOLATILE = 724,
     WHEN = 725,
     WHERE = 726,
     WHITESPACE_P = 727,
     WINDOW = 728,
     WITH = 729,
     WITHOUT = 730,
     WORK = 731,
     WRAPPER = 732,
     WRITE = 733,
     XML_P = 734,
     XMLATTRIBUTES = 735,
     XMLCONCAT = 736,
     XMLELEMENT = 737,
     XMLEXISTS = 738,
     XMLFOREST = 739,
     XMLPARSE = 740,
     XMLPI = 741,
     XMLROOT = 742,
     XMLSERIALIZE = 743,
     YEAR_P = 744,
     YES_P = 745,
     ZONE = 746,
     NULLS_FIRST = 747,
     NULLS_LAST = 748,
     WITH_TIME = 749,
     POSTFIXOP = 750,
     UMINUS = 751
   };
#endif



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 293 of yacc.c  */
#line 564 "preproc.y"

	double	dval;
	char	*str;
	int		ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;



/* Line 293 of yacc.c  */
#line 1184 "preproc.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif

#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 343 of yacc.c  */
#line 1209 "preproc.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
	     && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   107979

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  516
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  700
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2793
/* YYNRULES -- Number of states.  */
#define YYNSTATES  5107

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   751

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   503,     2,     2,
     508,   509,   501,   499,   511,   500,   510,   502,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   513,   512,
     496,   495,   497,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   506,     2,   507,   504,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   514,     2,   515,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     498,   505
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   245,   247,   249,   251,   253,   255,   257,
     259,   261,   263,   265,   267,   269,   271,   272,   278,   280,
     281,   284,   285,   288,   289,   292,   295,   299,   303,   305,
     309,   313,   316,   318,   320,   323,   326,   329,   333,   337,
     343,   349,   350,   354,   360,   366,   372,   377,   381,   387,
     391,   397,   403,   410,   412,   414,   418,   424,   431,   436,
     446,   454,   456,   457,   460,   461,   463,   465,   467,   469,
     471,   473,   476,   480,   484,   487,   493,   495,   499,   503,
     507,   511,   515,   519,   522,   525,   528,   531,   535,   539,
     543,   547,   549,   553,   555,   559,   561,   563,   566,   569,
     572,   574,   576,   578,   580,   582,   584,   586,   590,   597,
     599,   601,   603,   605,   607,   608,   610,   612,   615,   619,
     624,   628,   631,   634,   636,   639,   641,   645,   650,   656,
     661,   664,   669,   671,   673,   675,   677,   679,   682,   685,
     688,   691,   696,   703,   708,   715,   720,   727,   732,   739,
     745,   753,   755,   759,   762,   766,   771,   778,   785,   792,
     798,   804,   811,   818,   823,   832,   837,   840,   844,   851,
     856,   860,   864,   868,   872,   876,   881,   886,   890,   894,
     898,   902,   906,   910,   915,   920,   924,   927,   931,   934,
     937,   941,   945,   948,   951,   953,   957,   960,   962,   964,
     965,   968,   969,   972,   973,   977,   980,   981,   983,   987,
     991,   993,   999,  1003,  1008,  1010,  1014,  1019,  1026,  1031,
    1040,  1043,  1046,  1058,  1066,  1068,  1070,  1072,  1073,  1075,
    1077,  1079,  1081,  1085,  1088,  1089,  1091,  1093,  1095,  1099,
    1103,  1105,  1107,  1111,  1115,  1119,  1123,  1128,  1131,  1133,
    1134,  1137,  1138,  1142,  1143,  1145,  1146,  1148,  1152,  1155,
    1157,  1159,  1161,  1165,  1166,  1168,  1172,  1174,  1186,  1201,
    1212,  1226,  1228,  1230,  1233,  1236,  1239,  1242,  1244,  1245,
    1247,  1248,  1252,  1253,  1255,  1259,  1261,  1265,  1267,  1269,
    1271,  1273,  1275,  1280,  1285,  1288,  1289,  1293,  1295,  1297,
    1300,  1303,  1305,  1309,  1314,  1320,  1323,  1329,  1331,  1334,
    1337,  1340,  1344,  1348,  1352,  1353,  1355,  1357,  1359,  1361,
    1363,  1365,  1369,  1371,  1377,  1385,  1389,  1398,  1403,  1413,
    1425,  1428,  1429,  1433,  1434,  1436,  1440,  1442,  1445,  1448,
    1451,  1452,  1454,  1458,  1462,  1469,  1474,  1475,  1477,  1479,
    1482,  1485,  1486,  1490,  1494,  1497,  1499,  1501,  1504,  1507,
    1512,  1513,  1516,  1519,  1522,  1523,  1527,  1532,  1537,  1538,
    1541,  1542,  1547,  1548,  1552,  1558,  1561,  1565,  1566,  1575,
    1580,  1582,  1583,  1589,  1595,  1600,  1607,  1609,  1610,  1612,
    1615,  1618,  1620,  1623,  1627,  1630,  1633,  1636,  1639,  1643,
    1647,  1649,  1653,  1655,  1656,  1658,  1661,  1663,  1665,  1669,
    1676,  1687,  1689,  1690,  1692,  1695,  1698,  1699,  1702,  1705,
    1707,  1708,  1714,  1722,  1724,  1725,  1732,  1735,  1736,  1740,
    1746,  1752,  1761,  1764,  1765,  1768,  1771,  1774,  1780,  1783,
    1784,  1787,  1795,  1806,  1813,  1820,  1827,  1834,  1842,  1850,
    1860,  1870,  1877,  1885,  1892,  1901,  1910,  1919,  1928,  1935,
    1942,  1950,  1958,  1967,  1974,  1981,  1989,  1992,  1995,  1998,
    2001,  2003,  2006,  2008,  2009,  2016,  2025,  2033,  2040,  2045,
    2046,  2048,  2052,  2057,  2059,  2063,  2065,  2068,  2071,  2074,
    2077,  2079,  2081,  2092,  2095,  2096,  2099,  2102,  2104,  2105,
    2110,  2117,  2123,  2128,  2133,  2144,  2158,  2164,  2172,  2181,
    2183,  2185,  2187,  2195,  2205,  2214,  2230,  2251,  2253,  2255,
    2258,  2260,  2264,  2266,  2268,  2270,  2274,  2276,  2280,  2281,
    2283,  2284,  2286,  2288,  2293,  2294,  2296,  2300,  2301,  2303,
    2305,  2307,  2309,  2312,  2313,  2314,  2317,  2320,  2322,  2325,
    2328,  2331,  2334,  2341,  2350,  2362,  2376,  2378,  2382,  2388,
    2390,  2394,  2400,  2402,  2405,  2408,  2410,  2419,  2424,  2430,
    2435,  2440,  2445,  2449,  2457,  2466,  2473,  2480,  2487,  2494,
    2501,  2506,  2512,  2516,  2518,  2522,  2526,  2528,  2530,  2532,
    2534,  2536,  2538,  2542,  2546,  2550,  2552,  2556,  2560,  2562,
    2563,  2565,  2569,  2577,  2587,  2597,  2601,  2602,  2616,  2618,
    2622,  2628,  2635,  2640,  2648,  2651,  2653,  2654,  2657,  2658,
    2661,  2666,  2667,  2669,  2670,  2677,  2686,  2695,  2697,  2701,
    2707,  2713,  2721,  2731,  2739,  2749,  2755,  2762,  2769,  2774,
    2780,  2788,  2790,  2792,  2794,  2797,  2799,  2802,  2805,  2807,
    2809,  2811,  2813,  2815,  2817,  2821,  2825,  2829,  2833,  2835,
    2839,  2841,  2844,  2847,  2851,  2857,  2860,  2863,  2864,  2871,
    2879,  2887,  2895,  2904,  2913,  2920,  2929,  2939,  2949,  2957,
    2968,  2976,  2978,  2980,  2982,  2984,  2986,  2988,  2990,  2992,
    2994,  2997,  2999,  3001,  3003,  3005,  3007,  3010,  3012,  3016,
    3019,  3023,  3027,  3031,  3035,  3037,  3039,  3048,  3058,  3068,
    3078,  3088,  3091,  3092,  3094,  3096,  3099,  3102,  3104,  3106,
    3108,  3110,  3112,  3114,  3116,  3118,  3121,  3123,  3125,  3128,
    3131,  3135,  3140,  3146,  3151,  3157,  3161,  3166,  3170,  3175,
    3177,  3180,  3184,  3188,  3192,  3196,  3201,  3206,  3210,  3214,
    3219,  3224,  3229,  3234,  3236,  3238,  3240,  3241,  3249,  3257,
    3268,  3270,  3272,  3275,  3280,  3286,  3288,  3292,  3295,  3298,
    3301,  3304,  3306,  3309,  3312,  3317,  3321,  3324,  3327,  3330,
    3333,  3337,  3340,  3343,  3346,  3352,  3358,  3364,  3366,  3370,
    3372,  3375,  3379,  3380,  3382,  3386,  3389,  3396,  3403,  3413,
    3417,  3418,  3422,  3423,  3429,  3432,  3433,  3437,  3441,  3445,
    3453,  3461,  3472,  3474,  3476,  3478,  3480,  3495,  3497,  3498,
    3500,  3501,  3503,  3504,  3507,  3508,  3510,  3514,  3520,  3526,
    3534,  3537,  3538,  3540,  3543,  3544,  3546,  3548,  3549,  3551,
    3553,  3554,  3564,  3577,  3585,  3588,  3589,  3593,  3596,  3598,
    3602,  3606,  3609,  3611,  3615,  3619,  3623,  3626,  3629,  3631,
    3633,  3635,  3637,  3640,  3642,  3644,  3646,  3648,  3653,  3659,
    3661,  3665,  3669,  3671,  3674,  3679,  3685,  3687,  3689,  3691,
    3693,  3697,  3701,  3704,  3707,  3709,  3712,  3715,  3718,  3720,
    3723,  3726,  3728,  3730,  3732,  3736,  3739,  3740,  3743,  3745,
    3749,  3755,  3757,  3760,  3762,  3763,  3769,  3777,  3783,  3791,
    3797,  3805,  3809,  3815,  3821,  3827,  3829,  3833,  3836,  3838,
    3841,  3843,  3846,  3858,  3869,  3880,  3883,  3886,  3887,  3897,
    3900,  3901,  3906,  3911,  3916,  3918,  3920,  3922,  3923,  3931,
    3938,  3945,  3952,  3959,  3968,  3977,  3984,  3991,  3999,  4009,
    4019,  4026,  4033,  4040,  4049,  4056,  4065,  4072,  4081,  4089,
    4099,  4106,  4115,  4123,  4133,  4142,  4153,  4163,  4175,  4184,
    4194,  4206,  4215,  4224,  4232,  4239,  4246,  4253,  4259,  4265,
    4274,  4283,  4292,  4301,  4308,  4318,  4320,  4321,  4324,  4325,
    4333,  4340,  4347,  4354,  4361,  4368,  4376,  4386,  4396,  4403,
    4412,  4421,  4430,  4439,  4448,  4455,  4464,  4471,  4480,  4488,
    4498,  4506,  4516,  4523,  4531,  4538,  4545,  4552,  4559,  4566,
    4574,  4582,  4590,  4600,  4610,  4617,  4624,  4631,  4640,  4649,
    4658,  4665,  4673,  4687,  4689,  4691,  4695,  4699,  4701,  4703,
    4705,  4707,  4709,  4711,  4713,  4714,  4716,  4718,  4720,  4722,
    4724,  4726,  4727,  4734,  4743,  4747,  4750,  4751,  4754,  4757,
    4760,  4763,  4767,  4771,  4774,  4777,  4780,  4783,  4787,  4790,
    4796,  4801,  4805,  4809,  4813,  4815,  4817,  4818,  4822,  4825,
    4828,  4830,  4833,  4835,  4839,  4842,  4844,  4845,  4855,  4867,
    4879,  4893,  4897,  4902,  4907,  4908,  4911,  4917,  4920,  4921,
    4925,  4929,  4933,  4937,  4941,  4945,  4949,  4953,  4957,  4961,
    4965,  4969,  4973,  4978,  4982,  4986,  4988,  4989,  4995,  5002,
    5007,  5010,  5011,  5016,  5020,  5026,  5033,  5038,  5045,  5052,
    5058,  5066,  5076,  5083,  5085,  5086,  5093,  5105,  5117,  5129,
    5143,  5153,  5165,  5176,  5181,  5184,  5190,  5193,  5194,  5199,
    5205,  5211,  5216,  5223,  5225,  5229,  5231,  5233,  5235,  5237,
    5240,  5245,  5247,  5249,  5251,  5252,  5254,  5255,  5257,  5258,
    5262,  5263,  5266,  5271,  5275,  5281,  5283,  5285,  5287,  5289,
    5291,  5293,  5295,  5297,  5299,  5301,  5305,  5308,  5310,  5312,
    5314,  5316,  5317,  5323,  5328,  5332,  5333,  5335,  5337,  5339,
    5341,  5346,  5356,  5360,  5361,  5368,  5370,  5375,  5378,  5380,
    5384,  5387,  5391,  5392,  5400,  5403,  5404,  5410,  5414,  5415,
    5418,  5421,  5424,  5428,  5430,  5434,  5436,  5439,  5441,  5442,
    5451,  5453,  5457,  5459,  5461,  5465,  5471,  5474,  5476,  5480,
    5488,  5490,  5492,  5493,  5497,  5500,  5503,  5506,  5507,  5510,
    5513,  5515,  5517,  5521,  5525,  5527,  5530,  5535,  5540,  5543,
    5547,  5553,  5559,  5561,  5563,  5573,  5575,  5578,  5583,  5588,
    5593,  5596,  5600,  5602,  5606,  5613,  5615,  5616,  5619,  5621,
    5622,  5626,  5630,  5635,  5640,  5645,  5650,  5654,  5657,  5659,
    5661,  5662,  5664,  5666,  5667,  5669,  5675,  5677,  5678,  5680,
    5681,  5685,  5687,  5691,  5696,  5700,  5703,  5706,  5708,  5710,
    5712,  5713,  5716,  5721,  5727,  5730,  5734,  5736,  5738,  5740,
    5742,  5746,  5747,  5749,  5751,  5753,  5755,  5757,  5761,  5762,
    5765,  5766,  5768,  5772,  5774,  5775,  5777,  5780,  5784,  5787,
    5792,  5795,  5799,  5802,  5803,  5806,  5810,  5813,  5814,  5816,
    5820,  5823,  5826,  5830,  5833,  5837,  5839,  5844,  5848,  5853,
    5859,  5864,  5870,  5875,  5881,  5884,  5889,  5891,  5893,  5894,
    5896,  5901,  5907,  5912,  5913,  5916,  5919,  5922,  5924,  5926,
    5927,  5932,  5935,  5937,  5940,  5943,  5948,  5950,  5954,  5956,
    5959,  5963,  5965,  5968,  5969,  5972,  5977,  5978,  5980,  5981,
    5983,  5987,  5991,  5994,  5998,  6004,  6011,  6014,  6018,  6022,
    6027,  6028,  6030,  6032,  6034,  6036,  6038,  6041,  6047,  6049,
    6051,  6053,  6055,  6058,  6062,  6066,  6067,  6069,  6071,  6073,
    6075,  6077,  6080,  6083,  6086,  6089,  6092,  6094,  6098,  6099,
    6101,  6103,  6105,  6107,  6113,  6116,  6118,  6120,  6122,  6124,
    6130,  6133,  6136,  6139,  6141,  6145,  6149,  6152,  6154,  6155,
    6159,  6160,  6166,  6169,  6175,  6178,  6180,  6183,  6187,  6188,
    6190,  6192,  6194,  6196,  6198,  6200,  6204,  6208,  6212,  6216,
    6220,  6224,  6228,  6229,  6231,  6236,  6238,  6242,  6246,  6252,
    6255,  6258,  6262,  6266,  6270,  6274,  6278,  6282,  6286,  6290,
    6294,  6298,  6301,  6304,  6308,  6312,  6315,  6319,  6325,  6330,
    6337,  6341,  6347,  6352,  6359,  6364,  6371,  6377,  6385,  6389,
    6392,  6397,  6400,  6404,  6408,  6413,  6417,  6422,  6426,  6431,
    6437,  6444,  6451,  6459,  6466,  6474,  6481,  6489,  6493,  6498,
    6503,  6510,  6513,  6517,  6522,  6524,  6528,  6531,  6534,  6538,
    6542,  6546,  6550,  6554,  6558,  6562,  6566,  6570,  6574,  6577,
    6580,  6586,  6593,  6600,  6608,  6612,  6617,  6619,  6621,  6624,
    6629,  6631,  6633,  6635,  6638,  6641,  6644,  6647,  6649,  6654,
    6660,  6667,  6676,  6683,  6691,  6699,  6705,  6711,  6713,  6715,
    6720,  6722,  6727,  6729,  6734,  6736,  6741,  6743,  6745,  6747,
    6749,  6751,  6753,  6760,  6765,  6770,  6775,  6780,  6787,  6793,
    6799,  6805,  6810,  6817,  6822,  6827,  6832,  6837,  6843,  6851,
    6859,  6869,  6875,  6880,  6887,  6893,  6901,  6909,  6917,  6920,
    6924,  6928,  6932,  6937,  6938,  6943,  6945,  6949,  6953,  6955,
    6957,  6959,  6962,  6965,  6966,  6969,  6974,  6979,  6986,  6989,
    6990,  6992,  6996,  7000,  7003,  7006,  7007,  7014,  7016,  7017,
    7021,  7022,  7025,  7028,  7029,  7031,  7036,  7039,  7042,  7045,
    7048,  7051,  7056,  7060,  7066,  7068,  7070,  7072,  7074,  7076,
    7078,  7080,  7082,  7084,  7086,  7088,  7090,  7092,  7094,  7096,
    7101,  7103,  7108,  7110,  7115,  7117,  7120,  7122,  7125,  7127,
    7131,  7133,  7137,  7139,  7143,  7145,  7149,  7153,  7157,  7160,
    7162,  7166,  7170,  7171,  7173,  7175,  7177,  7179,  7181,  7183,
    7185,  7187,  7192,  7196,  7199,  7203,  7204,  7208,  7212,  7215,
    7218,  7220,  7221,  7224,  7227,  7231,  7234,  7236,  7238,  7242,
    7248,  7250,  7253,  7258,  7261,  7262,  7264,  7265,  7267,  7270,
    7273,  7276,  7280,  7286,  7288,  7291,  7292,  7295,  7297,  7298,
    7300,  7302,  7304,  7308,  7312,  7314,  7318,  7322,  7325,  7327,
    7329,  7331,  7335,  7337,  7340,  7342,  7346,  7348,  7350,  7352,
    7354,  7356,  7358,  7360,  7363,  7365,  7367,  7369,  7371,  7373,
    7376,  7382,  7385,  7389,  7396,  7398,  7400,  7402,  7404,  7406,
    7408,  7410,  7412,  7416,  7418,  7420,  7423,  7426,  7428,  7430,
    7432,  7434,  7436,  7438,  7440,  7442,  7444,  7446,  7448,  7450,
    7452,  7454,  7456,  7458,  7460,  7462,  7464,  7466,  7468,  7470,
    7472,  7474,  7476,  7478,  7480,  7482,  7484,  7486,  7488,  7490,
    7492,  7494,  7496,  7498,  7500,  7502,  7504,  7506,  7508,  7510,
    7512,  7514,  7516,  7518,  7520,  7522,  7524,  7526,  7528,  7530,
    7532,  7534,  7536,  7538,  7540,  7542,  7544,  7546,  7548,  7550,
    7552,  7554,  7556,  7558,  7560,  7562,  7564,  7566,  7568,  7570,
    7572,  7574,  7576,  7578,  7580,  7582,  7584,  7586,  7588,  7590,
    7592,  7594,  7596,  7598,  7600,  7602,  7604,  7606,  7608,  7610,
    7612,  7614,  7616,  7618,  7620,  7622,  7624,  7626,  7628,  7630,
    7632,  7634,  7636,  7638,  7640,  7642,  7644,  7646,  7648,  7650,
    7652,  7654,  7656,  7658,  7660,  7662,  7664,  7666,  7668,  7670,
    7672,  7674,  7676,  7678,  7680,  7682,  7684,  7686,  7688,  7690,
    7692,  7694,  7696,  7698,  7700,  7702,  7704,  7706,  7708,  7710,
    7712,  7714,  7716,  7718,  7720,  7722,  7724,  7726,  7728,  7730,
    7732,  7734,  7736,  7738,  7740,  7742,  7744,  7746,  7748,  7750,
    7752,  7754,  7756,  7758,  7760,  7762,  7764,  7766,  7768,  7770,
    7772,  7774,  7776,  7778,  7780,  7782,  7784,  7786,  7788,  7790,
    7792,  7794,  7796,  7798,  7800,  7802,  7804,  7806,  7808,  7810,
    7812,  7814,  7816,  7818,  7820,  7822,  7824,  7826,  7828,  7830,
    7832,  7834,  7836,  7838,  7840,  7842,  7844,  7846,  7848,  7850,
    7852,  7854,  7856,  7858,  7860,  7862,  7864,  7866,  7868,  7870,
    7872,  7874,  7876,  7878,  7880,  7882,  7884,  7886,  7888,  7890,
    7892,  7894,  7896,  7898,  7900,  7902,  7904,  7906,  7908,  7910,
    7912,  7914,  7916,  7918,  7920,  7922,  7924,  7926,  7928,  7930,
    7932,  7934,  7936,  7938,  7940,  7942,  7944,  7946,  7948,  7950,
    7952,  7954,  7956,  7958,  7960,  7962,  7964,  7966,  7968,  7970,
    7972,  7974,  7976,  7978,  7980,  7982,  7984,  7986,  7988,  7990,
    7992,  7994,  7996,  7998,  8000,  8002,  8004,  8006,  8008,  8010,
    8012,  8014,  8016,  8018,  8020,  8022,  8024,  8026,  8028,  8030,
    8032,  8034,  8036,  8038,  8040,  8042,  8044,  8046,  8048,  8050,
    8052,  8054,  8056,  8058,  8060,  8062,  8064,  8066,  8068,  8070,
    8072,  8074,  8076,  8078,  8080,  8082,  8084,  8086,  8088,  8090,
    8092,  8094,  8096,  8098,  8100,  8102,  8104,  8106,  8108,  8110,
    8112,  8114,  8116,  8118,  8120,  8122,  8124,  8126,  8128,  8130,
    8132,  8134,  8136,  8138,  8140,  8142,  8144,  8146,  8148,  8150,
    8152,  8154,  8156,  8158,  8160,  8162,  8164,  8166,  8168,  8170,
    8172,  8174,  8176,  8178,  8180,  8182,  8184,  8186,  8188,  8190,
    8192,  8194,  8196,  8198,  8200,  8202,  8204,  8206,  8208,  8209,
    8212,  8217,  8221,  8224,  8226,  8228,  8230,  8232,  8234,  8235,
    8244,  8247,  8253,  8257,  8260,  8263,  8267,  8275,  8277,  8279,
    8281,  8282,  8285,  8288,  8290,  8291,  8293,  8297,  8299,  8302,
    8303,  8306,  8307,  8310,  8311,  8313,  8317,  8322,  8326,  8328,
    8330,  8332,  8334,  8337,  8338,  8341,  8346,  8347,  8350,  8353,
    8356,  8358,  8360,  8368,  8372,  8374,  8376,  8378,  8380,  8383,
    8384,  8386,  8390,  8394,  8398,  8402,  8403,  8408,  8414,  8420,
    8421,  8423,  8425,  8427,  8430,  8433,  8435,  8438,  8439,  8447,
    8448,  8454,  8455,  8460,  8463,  8466,  8467,  8470,  8472,  8474,
    8476,  8478,  8480,  8482,  8484,  8486,  8488,  8490,  8492,  8498,
    8501,  8503,  8507,  8510,  8513,  8517,  8518,  8524,  8526,  8527,
    8533,  8536,  8539,  8541,  8543,  8545,  8548,  8551,  8555,  8557,
    8560,  8563,  8567,  8571,  8576,  8579,  8581,  8584,  8586,  8588,
    8591,  8594,  8598,  8600,  8602,  8604,  8606,  8607,  8609,  8613,
    8619,  8620,  8623,  8624,  8626,  8629,  8633,  8636,  8638,  8640,
    8642,  8643,  8645,  8647,  8649,  8651,  8653,  8656,  8659,  8663,
    8664,  8666,  8669,  8671,  8676,  8680,  8685,  8689,  8692,  8694,
    8698,  8700,  8702,  8704,  8706,  8709,  8712,  8714,  8717,  8720,
    8722,  8724,  8726,  8731,  8736,  8741,  8746,  8751,  8753,  8754,
    8758,  8762,  8767,  8769,  8773,  8777,  8782,  8784,  8788,  8792,
    8794,  8796,  8798,  8805,  8807,  8811,  8815,  8822,  8824,  8828,
    8832,  8834,  8836,  8839,  8842,  8844,  8846,  8848,  8850,  8852,
    8854,  8856,  8858,  8860,  8862,  8864,  8866,  8868,  8870,  8872,
    8874,  8879,  8884,  8886,  8888,  8893,  8898,  8902,  8903,  8911,
    8913,  8914,  8915,  8923,  8927,  8932,  8936,  8938,  8940,  8942,
    8945,  8949,  8955,  8958,  8964,  8967,  8969,  8971,  8973,  8975,
    8977,  8979,  8981,  8983,  8985,  8987,  8989,  8991,  8993,  8995,
    8997,  8999,  9001,  9003,  9005,  9007,  9009,  9011,  9013,  9015,
    9017,  9019,  9021,  9023,  9025,  9027,  9029,  9031,  9033,  9035,
    9037,  9039,  9041,  9043,  9045,  9047,  9049,  9051,  9053,  9055,
    9057,  9059,  9061,  9063,  9065,  9067,  9069,  9071,  9073,  9075,
    9077,  9079,  9081,  9083,  9085,  9087,  9089,  9091,  9093,  9095,
    9097,  9099,  9101,  9103,  9105,  9107,  9109,  9111,  9113,  9115,
    9117,  9119,  9121,  9123,  9125,  9127,  9129,  9131,  9133,  9135,
    9137,  9139,  9141,  9143,  9145,  9147,  9149,  9151,  9153,  9155,
    9157,  9159,  9161,  9163,  9167,  9169,  9170,  9172,  9175,  9177,
    9180,  9182,  9184,  9186,  9189,  9192,  9194,  9196,  9198,  9200,
    9202,  9204,  9206,  9208,  9210,  9212,  9214,  9216,  9218,  9220,
    9222,  9224,  9227,  9231,  9233,  9236,  9238,  9242,  9244,  9248,
    9250,  9252,  9254,  9256,  9258,  9260,  9262,  9264,  9266,  9268,
    9270,  9272,  9274,  9276,  9278,  9280,  9282,  9284,  9286,  9288,
    9290,  9292,  9294,  9296,  9298,  9300,  9302,  9304,  9306,  9308,
    9310,  9312,  9314,  9316,  9318,  9320,  9322,  9324,  9326,  9328,
    9330,  9332,  9334,  9336,  9338,  9340,  9342,  9344,  9346,  9348,
    9350,  9352,  9354,  9356,  9358,  9360,  9362,  9364,  9366,  9368,
    9370,  9373,  9377,  9380,  9384,  9386,  9390,  9394,  9398,  9402,
    9406,  9410,  9412,  9414,  9415,  9418,  9421,  9423,  9425,  9428,
    9430,  9432,  9434,  9435
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     517,     0,    -1,  1067,    -1,   705,    -1,   852,    -1,   853,
      -1,   770,    -1,   858,    -1,   720,    -1,   657,    -1,   660,
      -1,   666,    -1,   680,    -1,   682,    -1,   805,    -1,   534,
      -1,   826,    -1,   827,    -1,   636,    -1,   561,    -1,   572,
      -1,   528,    -1,   526,    -1,   861,    -1,   860,    -1,   686,
      -1,   530,    -1,   529,    -1,   868,    -1,   559,    -1,   575,
      -1,   863,    -1,   744,    -1,   556,    -1,   576,    -1,  1069,
      -1,   707,    -1,   816,    -1,   862,    -1,   857,    -1,   654,
      -1,   661,    -1,   675,    -1,   681,    -1,   786,    -1,   533,
      -1,   631,    -1,   722,    -1,   729,    -1,   730,    -1,   643,
      -1,   537,    -1,   635,    -1,   592,    -1,   651,    -1,   687,
      -1,   701,    -1,   519,    -1,   525,    -1,   683,    -1,   848,
      -1,  1210,    -1,   903,    -1,   709,    -1,   890,    -1,   560,
      -1,   813,    -1,   708,    -1,   818,    -1,   665,    -1,   679,
      -1,   536,    -1,   733,    -1,   734,    -1,   735,    -1,   649,
      -1,   835,    -1,   737,    -1,   653,    -1,   700,    -1,   531,
      -1,   532,    -1,   685,    -1,   856,    -1,   883,    -1,   874,
      -1,   751,    -1,   755,    -1,   766,    -1,   775,    -1,   885,
      -1,   838,    -1,   634,    -1,   847,    -1,   892,    -1,   836,
      -1,   880,    -1,   736,    -1,   820,    -1,   809,    -1,   808,
      -1,   810,    -1,   823,    -1,   756,    -1,   767,    -1,   828,
      -1,   747,    -1,   907,    -1,   840,    -1,   742,    -1,   839,
      -1,   896,    -1,   865,    -1,   552,    -1,   541,    -1,   555,
      -1,   845,    -1,  1146,    -1,  1072,    -1,  1089,    -1,  1147,
      -1,  1129,    -1,  1144,    -1,  1130,    -1,  1090,    -1,  1134,
      -1,  1156,    -1,  1148,    -1,  1135,    -1,  1164,    -1,  1166,
      -1,  1159,    -1,  1151,    -1,  1167,    -1,  1170,    -1,  1172,
      -1,    -1,   160,   383,  1059,   520,   521,    -1,   474,    -1,
      -1,   521,   524,    -1,    -1,   522,   523,    -1,    -1,   344,
    1200,    -1,   344,   317,    -1,   202,   344,  1200,    -1,   447,
     344,  1200,    -1,   253,    -1,   152,   287,  1061,    -1,   458,
     453,  1200,    -1,   455,  1060,    -1,  1202,    -1,   523,    -1,
     422,  1058,    -1,    96,  1060,    -1,   383,  1060,    -1,   248,
     383,  1060,    -1,   248,   236,  1060,    -1,   160,   455,  1059,
     520,   521,    -1,   101,   383,  1059,   520,   522,    -1,    -1,
     248,   174,  1051,    -1,   101,   383,  1059,   527,   553,    -1,
     101,   383,    99,   527,   553,    -1,   101,   455,  1059,   520,
     522,    -1,   101,   455,  1059,   553,    -1,   197,   383,  1060,
      -1,   197,   383,   243,   212,  1060,    -1,   197,   455,  1060,
      -1,   197,   455,   243,   212,  1060,    -1,   160,   236,  1059,
     520,   521,    -1,   101,   236,  1059,   535,   455,  1060,    -1,
      95,    -1,   197,    -1,   197,   236,  1060,    -1,   197,   236,
     243,   212,  1060,    -1,   160,   389,   538,   115,  1059,   539,
      -1,   160,   389,  1180,   539,    -1,   160,   389,   243,   312,
     212,   538,   115,  1059,   539,    -1,   160,   389,   243,   312,
     212,  1180,   539,    -1,  1180,    -1,    -1,   539,   540,    -1,
      -1,   592,    -1,   775,    -1,   635,    -1,   687,    -1,   755,
      -1,   845,    -1,   401,   542,    -1,   401,   290,   542,    -1,
     401,   399,   542,    -1,   436,   843,    -1,   399,   136,   108,
     436,   843,    -1,   543,    -1,   544,   434,   545,    -1,   544,
     495,   545,    -1,   544,   434,   180,    -1,   544,   495,   180,
      -1,   544,   228,   163,    -1,   432,   491,   549,    -1,   132,
    1200,    -1,   389,  1200,    -1,   305,   550,    -1,   383,   551,
      -1,   399,   115,   551,    -1,   399,   115,   180,    -1,   479,
     329,   996,    -1,   436,   408,  1200,    -1,  1179,    -1,   544,
     510,  1180,    -1,   546,    -1,   545,   511,   546,    -1,   548,
      -1,   641,    -1,   361,   446,    -1,   361,   149,    -1,   373,
     361,    -1,   397,    -1,   440,    -1,   217,    -1,   326,    -1,
     551,    -1,  1200,    -1,  1202,    -1,   983,  1200,   985,    -1,
     983,   508,  1058,   509,  1200,   985,    -1,   641,    -1,   180,
      -1,   290,    -1,  1200,    -1,   180,    -1,    -1,  1062,    -1,
    1200,    -1,   376,   544,    -1,   376,   432,   491,    -1,   376,
     436,   271,   285,    -1,   376,   399,   115,    -1,   376,    99,
      -1,   401,   542,    -1,   552,    -1,   401,   543,    -1,   552,
      -1,   404,   544,  1213,    -1,   404,   432,   491,  1213,    -1,
     404,   436,   271,   285,  1213,    -1,   404,   399,   115,  1213,
      -1,   404,    99,    -1,   401,   154,   557,   558,    -1,    99,
      -1,  1047,    -1,   183,    -1,   245,    -1,   138,    -1,   191,
      99,    -1,   191,   427,    -1,   191,   429,    -1,   191,   346,
      -1,   101,   424,   954,   562,    -1,   101,   424,   243,   212,
     954,   562,    -1,   101,   251,  1048,   562,    -1,   101,   251,
     243,   212,  1048,   562,    -1,   101,   395,  1048,   562,    -1,
     101,   395,   243,   212,  1048,   562,    -1,   101,   468,  1048,
     562,    -1,   101,   468,   243,   212,  1048,   562,    -1,   101,
     297,   468,  1048,   562,    -1,   101,   297,   468,   243,   212,
    1048,   562,    -1,   563,    -1,   562,   511,   563,    -1,    95,
     600,    -1,    95,   145,   600,    -1,   101,   824,  1180,   564,
      -1,   101,   824,  1180,   197,   312,   317,    -1,   101,   824,
    1180,   401,   312,   317,    -1,   101,   824,  1180,   401,   414,
    1061,    -1,   101,   824,  1180,   401,   568,    -1,   101,   824,
    1180,   376,   568,    -1,   101,   824,  1180,   401,   417,  1180,
      -1,   197,   824,   243,   212,  1180,   565,    -1,   197,   824,
    1180,   565,    -1,   101,   824,  1180,   825,   443,   963,   566,
     567,    -1,   101,   824,  1180,   669,    -1,    95,   609,    -1,
     459,   153,  1050,    -1,   197,   153,   243,   212,  1050,   565,
      -1,   197,   153,  1050,   565,    -1,   401,   474,   325,    -1,
     401,   475,   325,    -1,   141,   326,  1050,    -1,   401,   475,
     141,    -1,   200,   438,  1050,    -1,   200,   102,   438,  1050,
      -1,   200,   375,   438,  1050,    -1,   200,   438,    99,    -1,
     200,   438,   455,    -1,   190,   438,  1050,    -1,   190,   438,
      99,    -1,   190,   438,   455,    -1,   200,   387,  1050,    -1,
     200,   102,   387,  1050,    -1,   200,   375,   387,  1050,    -1,
     190,   387,  1050,    -1,   253,  1048,    -1,   310,   253,  1048,
      -1,   322,   740,    -1,   312,   322,    -1,   339,   434,  1059,
      -1,   401,   426,  1050,    -1,   401,   568,    -1,   376,   568,
      -1,   669,    -1,   401,   180,   987,    -1,   197,   180,    -1,
     128,    -1,   378,    -1,    -1,   143,   740,    -1,    -1,   456,
     987,    -1,    -1,   508,   570,   509,    -1,   474,   568,    -1,
      -1,   571,    -1,   570,   511,   571,    -1,  1182,   495,   713,
      -1,  1182,    -1,  1182,   510,  1182,   495,   713,    -1,  1182,
     510,  1182,    -1,   101,   443,   740,   573,    -1,   574,    -1,
     573,   511,   574,    -1,    95,   114,   962,   565,    -1,   197,
     114,   243,   212,  1180,   565,    -1,   197,   114,  1180,   565,
      -1,   101,   114,  1180,   825,   443,   963,   566,   565,    -1,
     140,   904,    -1,   140,    99,    -1,   158,   583,  1048,   612,
     584,   577,   578,   579,   585,   520,   580,    -1,   158,   908,
     434,   578,   579,   520,   580,    -1,   228,    -1,   434,    -1,
     358,    -1,    -1,  1200,    -1,   415,    -1,   416,    -1,   581,
      -1,   508,   587,   509,    -1,   581,   582,    -1,    -1,   121,
      -1,   325,    -1,   227,    -1,   186,   859,  1200,    -1,   317,
     859,  1200,    -1,   162,    -1,   239,    -1,   359,   859,  1200,
      -1,   205,   859,  1200,    -1,   224,   359,   613,    -1,   224,
     359,   501,    -1,   224,   312,   317,   613,    -1,   201,  1200,
      -1,   121,    -1,    -1,   474,   325,    -1,    -1,   586,   187,
    1200,    -1,    -1,   456,    -1,    -1,   588,    -1,   587,   511,
     588,    -1,  1182,   589,    -1,   548,    -1,   641,    -1,   501,
      -1,   508,   590,   509,    -1,    -1,   591,    -1,   590,   511,
     591,    -1,   548,    -1,   160,   593,   424,  1048,   508,   594,
     509,   623,   624,   625,   626,    -1,   160,   593,   424,   243,
     312,   212,  1048,   508,   594,   509,   623,   624,   625,   626,
      -1,   160,   593,   424,  1048,   322,   740,   595,   624,   625,
     626,    -1,   160,   593,   424,   243,   312,   212,  1048,   322,
     740,   595,   624,   625,   626,    -1,   429,    -1,   427,    -1,
     290,   429,    -1,   290,   427,    -1,   232,   429,    -1,   232,
     427,    -1,   452,    -1,    -1,   596,    -1,    -1,   508,   597,
     509,    -1,    -1,   598,    -1,   596,   511,   598,    -1,   599,
      -1,   597,   511,   599,    -1,   600,    -1,   606,    -1,   609,
      -1,   601,    -1,   609,    -1,  1180,   963,   667,   602,    -1,
    1180,   474,   330,   602,    -1,   602,   603,    -1,    -1,   153,
    1050,   604,    -1,   604,    -1,   605,    -1,   143,   740,    -1,
     312,   317,    -1,   317,    -1,   449,   802,   627,    -1,   353,
     273,   802,   627,    -1,   137,   508,   987,   509,   611,    -1,
     180,   988,    -1,   367,  1048,   612,   615,   619,    -1,   182,
      -1,   312,   182,    -1,   255,   183,    -1,   255,   245,    -1,
     286,  1048,   607,    -1,   607,   249,   608,    -1,   607,   209,
     608,    -1,    -1,   181,    -1,   154,    -1,   252,    -1,   417,
      -1,   147,    -1,    99,    -1,   153,  1050,   610,    -1,   610,
      -1,   137,   508,   987,   509,   698,    -1,   449,   508,   613,
     509,   802,   627,   698,    -1,   449,   628,   698,    -1,   353,
     273,   508,   613,   509,   802,   627,   698,    -1,   353,   273,
     628,   698,    -1,   208,   779,   508,   616,   509,   802,   627,
     618,   698,    -1,   225,   273,   508,   613,   509,   367,  1048,
     612,   615,   619,   698,    -1,   310,   253,    -1,    -1,   508,
     613,   509,    -1,    -1,   614,    -1,   613,   511,   614,    -1,
    1180,    -1,   296,   229,    -1,   296,   341,    -1,   296,   406,
      -1,    -1,   617,    -1,   616,   511,   617,    -1,   781,   474,
     812,    -1,   781,   474,   328,   508,   812,   509,    -1,   471,
     508,   987,   509,    -1,    -1,   620,    -1,   621,    -1,   620,
     621,    -1,   621,   620,    -1,    -1,   326,   454,   622,    -1,
     326,   185,   622,    -1,   310,    94,    -1,   378,    -1,   128,
      -1,   401,   317,    -1,   401,   180,    -1,   254,   508,  1047,
     509,    -1,    -1,   474,   568,    -1,   474,   325,    -1,   475,
     325,    -1,    -1,   326,   148,   197,    -1,   326,   148,   185,
     386,    -1,   326,   148,   350,   386,    -1,    -1,   426,  1050,
      -1,    -1,   456,   251,   426,  1050,    -1,    -1,   456,   251,
    1054,    -1,  1048,   612,   624,   625,   626,    -1,   474,   173,
      -1,   474,   310,   173,    -1,    -1,   160,   633,   297,   468,
     632,   108,   907,   630,    -1,  1048,   612,   569,   626,    -1,
     452,    -1,    -1,   368,   297,   468,  1048,   630,    -1,   160,
     593,   395,  1048,   637,    -1,   101,   395,  1048,   638,    -1,
     101,   395,   243,   212,  1048,   638,    -1,   638,    -1,    -1,
     639,    -1,   638,   639,    -1,   126,   641,    -1,   172,    -1,
     310,   172,    -1,   250,   640,   641,    -1,   298,   641,    -1,
     300,   641,    -1,   310,   298,    -1,   310,   300,    -1,   338,
     125,   740,    -1,   412,   520,   641,    -1,   377,    -1,   377,
     520,   641,    -1,   125,    -1,    -1,  1199,    -1,   500,  1199,
      -1,  1061,    -1,   641,    -1,   642,   511,   641,    -1,   160,
     787,   644,   650,   275,   551,    -1,   160,   787,   644,   650,
     275,   551,   237,   645,   646,   648,    -1,   442,    -1,    -1,
    1050,    -1,  1050,   741,    -1,   256,   645,    -1,    -1,   460,
     645,    -1,   310,   460,    -1,   647,    -1,    -1,   197,   650,
     275,   551,   565,    -1,   197,   650,   275,   243,   212,   551,
     565,    -1,   356,    -1,    -1,   160,   426,  1050,   652,   293,
    1200,    -1,   339,  1050,    -1,    -1,   197,   426,  1050,    -1,
     197,   426,   243,   212,  1050,    -1,   160,   214,  1050,   520,
     655,    -1,   160,   214,   243,   312,   212,  1050,   520,   655,
      -1,   655,   656,    -1,    -1,   389,  1050,    -1,   467,   551,
      -1,   228,   551,    -1,   101,   214,  1050,   454,   658,    -1,
     658,   659,    -1,    -1,   434,   551,    -1,   101,   214,  1050,
     535,    98,  1056,   714,    -1,   101,   214,  1050,   535,   131,
     508,   963,   108,   963,   509,    -1,   101,   214,  1050,   535,
     144,   740,    -1,   101,   214,  1050,   535,   157,   740,    -1,
     101,   214,  1050,   535,   195,   740,    -1,   101,   214,  1050,
     535,   230,   765,    -1,   101,   214,  1050,   535,   650,   275,
    1050,    -1,   101,   214,  1050,   535,   328,   812,   811,    -1,
     101,   214,  1050,   535,   328,   139,   740,   456,  1052,    -1,
     101,   214,  1050,   535,   328,   218,   740,   456,  1052,    -1,
     101,   214,  1050,   535,   389,  1050,    -1,   101,   214,  1050,
     535,   206,   438,  1050,    -1,   101,   214,  1050,   535,   424,
     740,    -1,   101,   214,  1050,   535,   430,   391,   340,   740,
      -1,   101,   214,  1050,   535,   430,   391,   189,   740,    -1,
     101,   214,  1050,   535,   430,   391,   428,   740,    -1,   101,
     214,  1050,   535,   430,   391,   151,   740,    -1,   101,   214,
    1050,   535,   395,   740,    -1,   101,   214,  1050,   535,   468,
     740,    -1,   101,   214,  1050,   535,   297,   468,   740,    -1,
     101,   214,  1050,   535,   225,   424,   740,    -1,   101,   214,
    1050,   535,   225,   173,   477,  1050,    -1,   101,   214,  1050,
     535,   398,  1050,    -1,   101,   214,  1050,   535,   443,   740,
      -1,   160,   225,   173,   477,  1050,   664,   667,    -1,   237,
     645,    -1,   310,   237,    -1,   460,   645,    -1,   310,   460,
      -1,   662,    -1,   663,   662,    -1,   663,    -1,    -1,   197,
     225,   173,   477,  1050,   565,    -1,   197,   225,   173,   477,
     243,   212,  1050,   565,    -1,   101,   225,   173,   477,  1050,
     664,   669,    -1,   101,   225,   173,   477,  1050,   663,    -1,
     330,   508,   668,   509,    -1,    -1,   672,    -1,   668,   511,
     672,    -1,   330,   508,   670,   509,    -1,   671,    -1,   670,
     511,   671,    -1,   672,    -1,   401,   672,    -1,    95,   672,
      -1,   197,   673,    -1,   673,   674,    -1,  1182,    -1,  1200,
      -1,   160,   398,  1050,   676,   678,   225,   173,   477,  1050,
     667,    -1,   443,  1200,    -1,    -1,   467,  1200,    -1,   467,
     317,    -1,   677,    -1,    -1,   197,   398,  1050,   565,    -1,
     197,   398,   243,   212,  1050,   565,    -1,   101,   398,  1050,
     677,   669,    -1,   101,   398,  1050,   677,    -1,   101,   398,
    1050,   669,    -1,   160,   225,   424,  1048,   508,   594,   509,
     398,  1050,   667,    -1,   160,   225,   424,   243,   312,   212,
    1048,   508,   594,   509,   398,  1050,   667,    -1,   101,   225,
     424,   954,   562,    -1,   101,   225,   424,   243,   212,   954,
     562,    -1,   160,   455,   295,   223,   684,   398,  1050,   667,
      -1,   170,    -1,   455,    -1,  1059,    -1,   197,   455,   295,
     223,   684,   398,  1050,    -1,   197,   455,   295,   243,   212,
     223,   684,   398,  1050,    -1,   101,   455,   295,   223,   684,
     398,  1050,   669,    -1,   160,   438,  1050,   688,   689,   326,
    1048,   691,   694,   211,   357,  1056,   508,   695,   509,    -1,
     160,   153,   438,  1050,    97,   689,   326,  1048,   697,   698,
     223,   198,   385,   694,   211,   357,  1056,   508,   695,   509,
      -1,   117,    -1,    97,    -1,   262,   322,    -1,   690,    -1,
     689,   331,   690,    -1,   261,    -1,   185,    -1,   454,    -1,
     454,   322,   613,    -1,   441,    -1,   223,   692,   693,    -1,
      -1,   198,    -1,    -1,   385,    -1,   413,    -1,   470,   508,
     987,   509,    -1,    -1,   696,    -1,   695,   511,   696,    -1,
      -1,  1058,    -1,  1199,    -1,  1200,    -1,  1182,    -1,   228,
    1048,    -1,    -1,    -1,   698,   699,    -1,   312,   182,    -1,
     182,    -1,   255,   245,    -1,   255,   183,    -1,   312,   458,
      -1,   310,   253,    -1,   197,   438,  1050,   326,   740,   565,
      -1,   197,   438,   243,   212,  1050,   326,   740,   565,    -1,
     160,   206,   438,  1050,   326,  1182,   211,   357,  1056,   508,
     509,    -1,   160,   206,   438,  1050,   326,  1182,   470,   702,
     211,   357,  1056,   508,   509,    -1,   703,    -1,   702,   105,
     703,    -1,  1180,   248,   508,   704,   509,    -1,    82,    -1,
     704,   511,    82,    -1,   101,   206,   438,  1050,   706,    -1,
     200,    -1,   200,   375,    -1,   200,   102,    -1,   190,    -1,
     160,   110,  1050,   137,   508,   987,   509,   698,    -1,   197,
     110,  1050,   565,    -1,   160,    98,  1056,   714,   710,    -1,
     160,    98,  1056,   715,    -1,   160,   328,   812,   710,    -1,
     160,   443,   740,   710,    -1,   160,   443,   740,    -1,   160,
     443,   740,   108,   508,   960,   509,    -1,   160,   443,   740,
     108,   204,   508,   718,   509,    -1,   160,   443,   740,   108,
     360,   710,    -1,   160,   430,   391,   340,   740,   710,    -1,
     160,   430,   391,   189,   740,   710,    -1,   160,   430,   391,
     428,   740,   710,    -1,   160,   430,   391,   151,   740,   710,
      -1,   160,   144,   740,   710,    -1,   160,   144,   740,   228,
     740,    -1,   508,   711,   509,    -1,   712,    -1,   711,   511,
     712,    -1,  1182,   495,   713,    -1,  1182,    -1,   796,    -1,
    1066,    -1,  1014,    -1,   641,    -1,  1200,    -1,   508,  1019,
     509,    -1,   508,   501,   509,    -1,   508,   716,   509,    -1,
     717,    -1,   716,   511,   717,    -1,  1202,   495,   713,    -1,
     719,    -1,    -1,  1200,    -1,   719,   511,  1200,    -1,   101,
     443,   740,    95,   461,   721,  1200,    -1,   101,   443,   740,
      95,   461,   721,  1200,   117,  1200,    -1,   101,   443,   740,
      95,   461,   721,  1200,    97,  1200,    -1,   243,   312,   212,
      -1,    -1,   160,   328,   139,   740,   725,   223,   443,   963,
     456,  1052,   726,   108,   723,    -1,   724,    -1,   723,   511,
     724,    -1,   328,  1058,   812,   727,   728,    -1,   328,  1058,
     812,   811,   727,   728,    -1,   230,  1058,  1056,   788,    -1,
     230,  1058,   508,  1019,   509,  1056,   788,    -1,   417,   963,
      -1,   180,    -1,    -1,   218,   740,    -1,    -1,   223,   391,
      -1,   223,   332,   125,   740,    -1,    -1,   364,    -1,    -1,
     160,   328,   218,   740,   456,  1052,    -1,   101,   328,   218,
     740,   456,  1052,    95,   723,    -1,   101,   328,   218,   740,
     456,  1052,   197,   731,    -1,   732,    -1,   731,   511,   732,
      -1,   328,  1058,   508,  1019,   509,    -1,   230,  1058,   508,
    1019,   509,    -1,   197,   328,   139,   740,   456,  1052,   565,
      -1,   197,   328,   139,   243,   212,   740,   456,  1052,   565,
      -1,   197,   328,   218,   740,   456,  1052,   565,    -1,   197,
     328,   218,   243,   212,   740,   456,  1052,   565,    -1,   197,
     338,   125,  1060,   565,    -1,   363,   338,   125,  1060,   434,
    1050,    -1,   197,   738,   243,   212,   739,   565,    -1,   197,
     738,   739,   565,    -1,   197,   251,   150,   739,   565,    -1,
     197,   251,   150,   243,   212,   739,   565,    -1,   424,    -1,
     395,    -1,   468,    -1,   297,   468,    -1,   251,    -1,   225,
     424,    -1,   206,   438,    -1,   443,    -1,   195,    -1,   144,
      -1,   157,    -1,   389,    -1,   214,    -1,   430,   391,   340,
      -1,   430,   391,   189,    -1,   430,   391,   428,    -1,   430,
     391,   151,    -1,   740,    -1,   739,   511,   740,    -1,  1180,
      -1,  1180,   741,    -1,   510,  1053,    -1,   741,   510,  1053,
      -1,   441,   918,   955,   743,   565,    -1,   156,   242,    -1,
     377,   242,    -1,    -1,   146,   326,   745,   740,   269,   746,
      -1,   146,   326,    98,  1056,   714,   269,   746,    -1,   146,
     326,   230,  1056,   788,   269,   746,    -1,   146,   326,   328,
     812,   811,   269,   746,    -1,   146,   326,   153,  1050,   326,
     740,   269,   746,    -1,   146,   326,   387,  1050,   326,   740,
     269,   746,    -1,   146,   326,   387,  1050,   269,   746,    -1,
     146,   326,   438,  1050,   326,   740,   269,   746,    -1,   146,
     326,   328,   139,   740,   456,  1052,   269,   746,    -1,   146,
     326,   328,   218,   740,   456,  1052,   269,   746,    -1,   146,
     326,   276,   321,   641,   269,   746,    -1,   146,   326,   131,
     508,   963,   108,   963,   509,   269,   746,    -1,   146,   326,
     650,   275,   740,   269,   746,    -1,   145,    -1,   174,    -1,
     389,    -1,   251,    -1,   395,    -1,   424,    -1,   195,    -1,
     443,    -1,   468,    -1,   297,   468,    -1,   144,    -1,   157,
      -1,   426,    -1,   214,    -1,   383,    -1,   225,   424,    -1,
     398,    -1,   225,   173,   477,    -1,   206,   438,    -1,   430,
     391,   151,    -1,   430,   391,   189,    -1,   430,   391,   340,
      -1,   430,   391,   428,    -1,  1200,    -1,   317,    -1,   393,
     274,   748,   326,   749,   740,   269,   750,    -1,   393,   274,
     748,   326,    98,  1056,   714,   269,   750,    -1,   393,   274,
     748,   326,   230,  1056,   788,   269,   750,    -1,   393,   274,
     748,   326,   276,   321,   641,   269,   750,    -1,   393,   274,
     748,   326,   650,   275,   740,   269,   750,    -1,   223,   551,
      -1,    -1,   145,    -1,   174,    -1,   206,   438,    -1,   225,
     424,    -1,   389,    -1,   395,    -1,   424,    -1,   195,    -1,
     383,    -1,   426,    -1,   443,    -1,   468,    -1,   297,   468,
      -1,  1200,    -1,   317,    -1,   219,   752,    -1,   303,   752,
      -1,   219,   752,  1214,    -1,   219,   226,   904,  1215,    -1,
     219,   226,   753,   904,  1215,    -1,   219,   116,   904,  1215,
      -1,   219,   116,   753,   904,  1215,    -1,   303,   226,   904,
      -1,   303,   226,   753,   904,    -1,   303,   116,   904,    -1,
     303,   116,   753,   904,    -1,   904,    -1,   753,   904,    -1,
     309,   754,   904,    -1,   354,   754,   904,    -1,   220,   754,
     904,    -1,   277,   754,   904,    -1,    92,  1061,   754,   904,
      -1,   370,  1061,   754,   904,    -1,  1061,   754,   904,    -1,
      99,   754,   904,    -1,   226,  1061,   754,   904,    -1,   226,
      99,   754,   904,    -1,   116,  1061,   754,   904,    -1,   116,
      99,   754,   904,    -1,   228,    -1,   248,    -1,   753,    -1,
      -1,   233,   757,   326,   760,   434,   761,   763,    -1,   381,
     757,   326,   760,   228,   761,   565,    -1,   381,   233,   329,
     223,   757,   326,   760,   228,   761,   565,    -1,   758,    -1,
      99,    -1,    99,   355,    -1,    99,   508,   613,   509,    -1,
      99,   355,   508,   613,   509,    -1,   759,    -1,   758,   511,
     759,    -1,   394,   612,    -1,   367,   612,    -1,   160,   612,
      -1,  1180,   612,    -1,  1047,    -1,   424,  1047,    -1,   395,
    1047,    -1,   225,   173,   477,  1049,    -1,   225,   398,  1049,
      -1,   230,   764,    -1,   174,  1049,    -1,   195,   739,    -1,
     275,  1049,    -1,   276,   321,   642,    -1,   389,  1049,    -1,
     426,  1049,    -1,   443,   739,    -1,    99,   425,   248,   389,
    1049,    -1,    99,   396,   248,   389,  1049,    -1,    99,   231,
     248,   389,  1049,    -1,   762,    -1,   761,   511,   762,    -1,
    1059,    -1,   236,  1059,    -1,   474,   233,   329,    -1,    -1,
     765,    -1,   764,   511,   765,    -1,  1056,   788,    -1,   233,
     758,   434,  1060,   768,   769,    -1,   381,   758,   228,  1060,
     769,   565,    -1,   381,    96,   329,   223,   758,   228,  1060,
     769,   565,    -1,   474,    96,   329,    -1,    -1,   234,   125,
    1059,    -1,    -1,   101,   180,   355,   771,   773,    -1,   771,
     772,    -1,    -1,   248,   389,  1049,    -1,   223,   383,  1060,
      -1,   223,   455,  1060,    -1,   233,   757,   326,   774,   434,
     761,   763,    -1,   381,   757,   326,   774,   228,   761,   565,
      -1,   381,   233,   329,   223,   757,   326,   774,   228,   761,
     565,    -1,   425,    -1,   231,    -1,   396,    -1,   444,    -1,
     160,   776,   251,   777,   778,   326,  1048,   779,   508,   780,
     509,   569,   626,   958,    -1,   449,    -1,    -1,   150,    -1,
      -1,  1054,    -1,    -1,   456,  1052,    -1,    -1,   781,    -1,
     780,   511,   781,    -1,  1180,   782,   783,   784,   785,    -1,
     990,   782,   783,   784,   785,    -1,   508,   987,   509,   782,
     783,   784,   785,    -1,   143,   740,    -1,    -1,   740,    -1,
     456,   740,    -1,    -1,   109,    -1,   188,    -1,    -1,   492,
      -1,   493,    -1,    -1,   160,   787,   230,  1056,   790,   380,
     795,   798,   802,    -1,   160,   787,   230,  1056,   790,   380,
     424,   508,   804,   509,   798,   802,    -1,   160,   787,   230,
    1056,   790,   798,   802,    -1,   331,   374,    -1,    -1,   508,
     789,   509,    -1,   508,   509,    -1,   792,    -1,   789,   511,
     792,    -1,   508,   791,   509,    -1,   508,   509,    -1,   797,
      -1,   791,   511,   797,    -1,   793,   794,   796,    -1,   794,
     793,   796,    -1,   794,   796,    -1,   793,   796,    -1,   796,
      -1,   248,    -1,   333,    -1,   258,    -1,   248,   333,    -1,
     464,    -1,  1181,    -1,   796,    -1,   963,    -1,  1181,   741,
     503,   443,    -1,   402,  1181,   741,   503,   443,    -1,   792,
      -1,   792,   180,   987,    -1,   792,   495,   987,    -1,   800,
      -1,   798,   800,    -1,   127,   326,   317,   259,    -1,   380,
     317,   326,   317,   259,    -1,   418,    -1,   246,    -1,   410,
      -1,   469,    -1,   215,   393,   184,    -1,   215,   393,   268,
      -1,   393,   184,    -1,   393,   268,    -1,   282,    -1,   312,
     282,    -1,   159,   641,    -1,   386,   641,    -1,   554,    -1,
     108,   801,    -1,   275,   551,    -1,   473,    -1,   799,    -1,
    1200,    -1,  1200,   511,  1200,    -1,   474,   710,    -1,    -1,
     794,   796,    -1,   803,    -1,   804,   511,   803,    -1,   101,
     230,   765,   806,   807,    -1,   799,    -1,   806,   799,    -1,
     378,    -1,    -1,   197,   230,  1056,   788,   565,    -1,   197,
     230,   243,   212,  1056,   788,   565,    -1,   197,    98,  1056,
     714,   565,    -1,   197,    98,   243,   212,  1056,   714,   565,
      -1,   197,   328,   812,   811,   565,    -1,   197,   328,   243,
     212,   812,   811,   565,    -1,   508,   963,   509,    -1,   508,
     963,   511,   963,   509,    -1,   508,   311,   511,   963,   509,
      -1,   508,   963,   511,   311,   509,    -1,  1011,    -1,  1180,
     510,   812,    -1,   193,   814,    -1,   815,    -1,   814,   815,
      -1,  1200,    -1,   275,   551,    -1,   160,   131,   508,   963,
     108,   963,   509,   474,   230,   765,   817,    -1,   160,   131,
     508,   963,   108,   963,   509,   475,   230,   817,    -1,   160,
     131,   508,   963,   108,   963,   509,   474,   258,   817,    -1,
     108,   247,    -1,   108,   111,    -1,    -1,   197,   131,   819,
     508,   963,   108,   963,   509,   565,    -1,   243,   212,    -1,
      -1,   369,   821,  1048,   822,    -1,   369,   423,  1050,   822,
      -1,   369,   174,  1050,   822,    -1,   251,    -1,   424,    -1,
     224,    -1,    -1,   101,    98,  1056,   714,   372,   434,  1050,
      -1,   101,   144,   740,   372,   434,  1050,    -1,   101,   157,
     740,   372,   434,  1050,    -1,   101,   174,  1051,   372,   434,
    1051,    -1,   101,   195,   740,   372,   434,  1050,    -1,   101,
     195,   740,   372,   153,  1050,   434,  1050,    -1,   101,   225,
     173,   477,  1050,   372,   434,  1050,    -1,   101,   230,   765,
     372,   434,  1050,    -1,   101,   236,  1059,   372,   434,  1059,
      -1,   101,   650,   275,  1050,   372,   434,  1050,    -1,   101,
     328,   139,   740,   456,  1052,   372,   434,  1050,    -1,   101,
     328,   218,   740,   456,  1052,   372,   434,  1050,    -1,   101,
     389,  1050,   372,   434,  1050,    -1,   101,   398,  1050,   372,
     434,  1050,    -1,   101,   424,   954,   372,   434,  1050,    -1,
     101,   424,   243,   212,   954,   372,   434,  1050,    -1,   101,
     395,  1048,   372,   434,  1050,    -1,   101,   395,   243,   212,
    1048,   372,   434,  1050,    -1,   101,   468,  1048,   372,   434,
    1050,    -1,   101,   468,   243,   212,  1048,   372,   434,  1050,
      -1,   101,   297,   468,  1048,   372,   434,  1050,    -1,   101,
     297,   468,   243,   212,  1048,   372,   434,  1050,    -1,   101,
     251,  1048,   372,   434,  1050,    -1,   101,   251,   243,   212,
    1048,   372,   434,  1050,    -1,   101,   225,   424,   954,   372,
     434,  1050,    -1,   101,   225,   424,   243,   212,   954,   372,
     434,  1050,    -1,   101,   424,   954,   372,   824,  1050,   434,
    1050,    -1,   101,   424,   243,   212,   954,   372,   824,  1050,
     434,  1050,    -1,   101,   297,   468,  1048,   372,   824,  1050,
     434,  1050,    -1,   101,   297,   468,   243,   212,  1048,   372,
     824,  1050,   434,  1050,    -1,   101,   424,   954,   372,   153,
    1050,   434,  1050,    -1,   101,   225,   424,   954,   372,   824,
    1050,   434,  1050,    -1,   101,   225,   424,   243,   212,   954,
     372,   824,  1050,   434,  1050,    -1,   101,   387,  1050,   326,
    1048,   372,   434,  1050,    -1,   101,   438,  1050,   326,  1048,
     372,   434,  1050,    -1,   101,   206,   438,  1050,   372,   434,
    1050,    -1,   101,   383,  1059,   372,   434,  1059,    -1,   101,
     455,  1059,   372,   434,  1059,    -1,   101,   426,  1050,   372,
     434,  1050,    -1,   101,   426,  1050,   401,   568,    -1,   101,
     426,  1050,   376,   568,    -1,   101,   430,   391,   340,   740,
     372,   434,  1050,    -1,   101,   430,   391,   189,   740,   372,
     434,  1050,    -1,   101,   430,   391,   428,   740,   372,   434,
    1050,    -1,   101,   430,   391,   151,   740,   372,   434,  1050,
      -1,   101,   443,   740,   372,   434,  1050,    -1,   101,   443,
     740,   372,   114,  1050,   434,  1050,   565,    -1,   145,    -1,
      -1,   401,   173,    -1,    -1,   101,    98,  1056,   714,   401,
     389,  1050,    -1,   101,   144,   740,   401,   389,  1050,    -1,
     101,   157,   740,   401,   389,  1050,    -1,   101,   195,   740,
     401,   389,  1050,    -1,   101,   214,   740,   401,   389,  1050,
      -1,   101,   230,   765,   401,   389,  1050,    -1,   101,   328,
     812,   811,   401,   389,  1050,    -1,   101,   328,   139,   740,
     456,  1052,   401,   389,  1050,    -1,   101,   328,   218,   740,
     456,  1052,   401,   389,  1050,    -1,   101,   424,   954,   401,
     389,  1050,    -1,   101,   424,   243,   212,   954,   401,   389,
    1050,    -1,   101,   430,   391,   340,   740,   401,   389,  1050,
      -1,   101,   430,   391,   189,   740,   401,   389,  1050,    -1,
     101,   430,   391,   428,   740,   401,   389,  1050,    -1,   101,
     430,   391,   151,   740,   401,   389,  1050,    -1,   101,   395,
    1048,   401,   389,  1050,    -1,   101,   395,   243,   212,  1048,
     401,   389,  1050,    -1,   101,   468,  1048,   401,   389,  1050,
      -1,   101,   468,   243,   212,  1048,   401,   389,  1050,    -1,
     101,   297,   468,  1048,   401,   389,  1050,    -1,   101,   297,
     468,   243,   212,  1048,   401,   389,  1050,    -1,   101,   225,
     424,   954,   401,   389,  1050,    -1,   101,   225,   424,   243,
     212,   954,   401,   389,  1050,    -1,   101,   443,   740,   401,
     389,  1050,    -1,   101,    98,  1056,   714,   339,   434,  1059,
      -1,   101,   144,   740,   339,   434,  1059,    -1,   101,   157,
     740,   339,   434,  1059,    -1,   101,   174,  1051,   339,   434,
    1059,    -1,   101,   195,   740,   339,   434,  1059,    -1,   101,
     230,   765,   339,   434,  1059,    -1,   101,   650,   275,  1050,
     339,   434,  1059,    -1,   101,   276,   321,   641,   339,   434,
    1059,    -1,   101,   328,   812,   811,   339,   434,  1059,    -1,
     101,   328,   139,   740,   456,  1052,   339,   434,  1059,    -1,
     101,   328,   218,   740,   456,  1052,   339,   434,  1059,    -1,
     101,   389,  1050,   339,   434,  1059,    -1,   101,   443,   740,
     339,   434,  1059,    -1,   101,   426,  1050,   339,   434,  1059,
      -1,   101,   430,   391,   189,   740,   339,   434,  1059,    -1,
     101,   430,   391,   151,   740,   339,   434,  1059,    -1,   101,
     225,   173,   477,  1050,   339,   434,  1059,    -1,   101,   398,
    1050,   339,   434,  1059,    -1,   101,   206,   438,  1050,   339,
     434,  1059,    -1,   160,   787,   387,  1050,   108,   326,   833,
     434,  1048,   958,   193,   834,   829,    -1,   313,    -1,   831,
      -1,   508,   830,   509,    -1,   830,   512,   832,    -1,   832,
      -1,   907,    -1,   885,    -1,   896,    -1,   890,    -1,   836,
      -1,   831,    -1,    -1,   394,    -1,   454,    -1,   185,    -1,
     261,    -1,   262,    -1,   100,    -1,    -1,   197,   387,  1050,
     326,   740,   565,    -1,   197,   387,   243,   212,  1050,   326,
     740,   565,    -1,   314,  1180,   837,    -1,   511,  1200,    -1,
      -1,   288,  1180,    -1,   451,  1180,    -1,   451,   501,    -1,
      91,   841,    -1,   118,   841,   844,    -1,   412,   436,   844,
      -1,   148,   841,    -1,   203,   841,    -1,   384,   841,    -1,
     388,  1180,    -1,   371,   388,  1180,    -1,   371,  1180,    -1,
     384,   841,   434,   388,  1180,    -1,   384,   841,   434,  1180,
      -1,   351,   436,  1200,    -1,   148,   352,  1200,    -1,   384,
     352,  1200,    -1,   476,    -1,   436,    -1,    -1,   271,   285,
     547,    -1,   361,   327,    -1,   361,   478,    -1,   182,    -1,
     312,   182,    -1,   842,    -1,   843,   511,   842,    -1,   843,
     842,    -1,   843,    -1,    -1,   160,   593,   468,  1048,   612,
     569,   108,   907,   846,    -1,   160,   331,   374,   593,   468,
    1048,   612,   569,   108,   907,   846,    -1,   160,   593,   365,
     468,  1048,   508,   613,   509,   569,   108,   907,    -1,   160,
     331,   374,   593,   365,   468,  1048,   508,   613,   509,   569,
     108,   907,    -1,   474,   137,   329,    -1,   474,   129,   137,
     329,    -1,   474,   290,   137,   329,    -1,    -1,   289,  1055,
      -1,   160,   174,  1051,   520,   849,    -1,   849,   850,    -1,
      -1,   426,   851,  1050,    -1,   426,   851,   180,    -1,   293,
     851,  1200,    -1,   293,   851,   180,    -1,   428,   851,  1050,
      -1,   428,   851,   180,    -1,   201,   851,  1200,    -1,   201,
     851,  1058,    -1,   201,   851,   180,    -1,   279,   851,  1200,
      -1,   279,   851,   180,    -1,   280,   851,  1200,    -1,   280,
     851,   180,    -1,   152,   287,   851,  1061,    -1,   339,   851,
    1050,    -1,   339,   851,   180,    -1,   495,    -1,    -1,   101,
     174,  1051,   520,   854,    -1,   101,   174,  1051,   401,   426,
    1050,    -1,   101,   174,  1051,   553,    -1,   854,   855,    -1,
      -1,   152,   287,   851,  1061,    -1,   197,   174,  1051,    -1,
     197,   174,   243,   212,  1051,    -1,   160,   195,   740,   859,
     963,   602,    -1,   101,   195,   740,   564,    -1,   101,   195,
     740,   197,   312,   317,    -1,   101,   195,   740,   401,   312,
     317,    -1,   101,   195,   740,    95,   609,    -1,   101,   195,
     740,   197,   153,  1050,   565,    -1,   101,   195,   740,   197,
     153,   243,   212,  1050,   565,    -1,   101,   195,   740,   459,
     153,  1050,    -1,   108,    -1,    -1,   101,   430,   391,   189,
     740,   710,    -1,   101,   430,   391,   151,   740,    95,   295,
     223,  1049,   474,   739,    -1,   101,   430,   391,   151,   740,
     101,   295,   223,  1049,   474,   739,    -1,   101,   430,   391,
     151,   740,   101,   295,   374,   740,   474,   740,    -1,   101,
     430,   391,   151,   740,   101,   295,   223,  1049,   374,   740,
     474,   740,    -1,   101,   430,   391,   151,   740,   197,   295,
     223,  1049,    -1,   101,   430,   391,   151,   740,   197,   295,
     243,   212,   223,  1049,    -1,   160,   725,   157,   740,   223,
    1200,   434,  1200,   228,   740,    -1,   141,   870,  1048,   864,
      -1,   141,   870,    -1,   141,   870,  1054,   326,  1048,    -1,
     456,  1054,    -1,    -1,   457,   871,   872,   870,    -1,   457,
     871,   872,   870,  1048,    -1,   457,   871,   872,   870,   868,
      -1,   457,   508,   866,   509,    -1,   457,   508,   866,   509,
    1048,   873,    -1,   867,    -1,   866,   511,   867,    -1,   869,
      -1,   466,    -1,   227,    -1,   229,    -1,   869,   870,    -1,
     869,   870,  1048,   873,    -1,   104,    -1,   103,    -1,   466,
      -1,    -1,   229,    -1,    -1,   227,    -1,    -1,   508,  1049,
     509,    -1,    -1,   213,   875,    -1,   213,   869,   870,   875,
      -1,   213,   466,   875,    -1,   213,   508,   876,   509,   875,
      -1,   907,    -1,   885,    -1,   896,    -1,   890,    -1,   903,
      -1,  1069,    -1,   631,    -1,   634,    -1,   883,    -1,   877,
      -1,   876,   511,   877,    -1,   878,   879,    -1,  1062,    -1,
     869,    -1,   548,    -1,   641,    -1,    -1,   351,  1088,   881,
     108,   882,    -1,   351,  1088,   228,  1133,    -1,   508,  1019,
     509,    -1,    -1,   907,    -1,   885,    -1,   896,    -1,   890,
      -1,   211,  1088,   884,  1212,    -1,   160,   593,   424,   629,
     108,   211,  1050,   884,   630,    -1,   508,  1016,   509,    -1,
      -1,   915,   261,   267,  1048,   886,   889,    -1,   907,    -1,
     508,   887,   509,   907,    -1,   180,   462,    -1,   888,    -1,
     887,   511,   888,    -1,  1180,  1040,    -1,   379,  1045,  1213,
      -1,    -1,   915,   185,   228,   956,   891,   959,   889,    -1,
     456,   945,    -1,    -1,   294,   918,   955,   893,   895,    -1,
     248,   894,   301,    -1,    -1,    93,   403,    -1,   385,   403,
      -1,   385,   210,    -1,   403,   454,   210,    -1,   403,    -1,
     403,   385,   210,    -1,   210,    -1,    93,   210,    -1,   316,
      -1,    -1,   915,   454,   956,   401,   897,   944,   959,   889,
      -1,   898,    -1,   897,   511,   898,    -1,   899,    -1,   900,
      -1,   901,   495,  1042,    -1,   508,   902,   509,   495,  1044,
      -1,  1180,  1040,    -1,   901,    -1,   902,   511,   901,    -1,
     179,   904,   905,   171,   906,   223,   907,    -1,  1050,    -1,
    1193,    -1,    -1,   905,   310,   390,    -1,   905,   390,    -1,
     905,   121,    -1,   905,   260,    -1,    -1,   474,   240,    -1,
     475,   240,    -1,   909,    -1,   908,    -1,   508,   909,   509,
      -1,   508,   908,   509,    -1,   911,    -1,   910,   922,    -1,
     910,   921,   937,   926,    -1,   910,   921,   925,   938,    -1,
     912,   910,    -1,   912,   910,   922,    -1,   912,   910,   921,
     937,   926,    -1,   912,   910,   921,   925,   938,    -1,   911,
      -1,   908,    -1,   394,   920,  1045,   916,   944,   958,   935,
     936,   999,    -1,   943,    -1,   424,   954,    -1,   910,   448,
     919,   910,    -1,   910,   265,   919,   910,    -1,   910,   207,
     919,   910,    -1,   474,   913,    -1,   474,   365,   913,    -1,
     914,    -1,   913,   511,   914,    -1,  1050,   873,   108,   508,
     882,   509,    -1,   912,    -1,    -1,   267,   917,    -1,  1213,
      -1,    -1,   429,   918,  1048,    -1,   427,   918,  1048,    -1,
     290,   429,   918,  1048,    -1,   290,   427,   918,  1048,    -1,
     232,   429,   918,  1048,    -1,   232,   427,   918,  1048,    -1,
     452,   918,  1048,    -1,   424,  1048,    -1,  1048,    -1,   424,
      -1,    -1,    99,    -1,   192,    -1,    -1,   192,    -1,   192,
     326,   508,  1016,   509,    -1,    99,    -1,    -1,   922,    -1,
      -1,   332,   125,   923,    -1,   924,    -1,   923,   511,   924,
      -1,   987,   456,  1014,   785,    -1,   987,   784,   785,    -1,
     927,   928,    -1,   928,   927,    -1,   927,    -1,   928,    -1,
     925,    -1,    -1,   287,   929,    -1,   287,   929,   511,   930,
      -1,   219,   934,   931,   933,   327,    -1,   324,   930,    -1,
     324,   932,   933,    -1,   987,    -1,    99,    -1,   987,    -1,
    1061,    -1,   508,   987,   509,    -1,    -1,   989,    -1,   385,
      -1,   386,    -1,   220,    -1,   309,    -1,   236,   125,  1016,
      -1,    -1,   238,   987,    -1,    -1,   939,    -1,   223,   361,
     327,    -1,   937,    -1,    -1,   940,    -1,   939,   940,    -1,
     941,   942,   895,    -1,   223,   454,    -1,   223,   310,   273,
     454,    -1,   223,   403,    -1,   223,   273,   403,    -1,   322,
    1047,    -1,    -1,   462,  1044,    -1,   943,   511,  1044,    -1,
     228,   945,    -1,    -1,   946,    -1,   945,   511,   946,    -1,
     954,   949,    -1,   957,   950,    -1,   278,   957,   950,    -1,
     908,   949,    -1,   278,   908,   949,    -1,   947,    -1,   508,
     947,   509,   948,    -1,   508,   947,   509,    -1,   946,   161,
     272,   946,    -1,   946,   951,   272,   946,   953,    -1,   946,
     272,   946,   953,    -1,   946,   307,   951,   272,   946,    -1,
     946,   307,   272,   946,    -1,   108,  1180,   508,  1049,   509,
      -1,   108,  1180,    -1,  1180,   508,  1049,   509,    -1,  1180,
      -1,   948,    -1,    -1,   948,    -1,   108,   508,   961,   509,
      -1,   108,  1180,   508,   961,   509,    -1,  1180,   508,   961,
     509,    -1,    -1,   229,   952,    -1,   284,   952,    -1,   382,
     952,    -1,   257,    -1,   334,    -1,    -1,   456,   508,  1049,
     509,    -1,   326,   987,    -1,  1048,    -1,  1048,   501,    -1,
     327,  1048,    -1,   327,   508,  1048,   509,    -1,   954,    -1,
     955,   511,   954,    -1,   954,    -1,   954,  1180,    -1,   954,
     108,  1180,    -1,   990,    -1,   471,   987,    -1,    -1,   471,
     987,    -1,   471,   163,   322,   904,    -1,    -1,   961,    -1,
      -1,   962,    -1,   961,   511,   962,    -1,  1180,   963,   566,
      -1,   965,   964,    -1,   402,   965,   964,    -1,   965,   107,
     506,  1058,   507,    -1,   402,   965,   107,   506,  1058,   507,
      -1,   965,   107,    -1,   402,   965,   107,    -1,   964,   506,
     507,    -1,   964,   506,  1211,   507,    -1,    -1,   967,    -1,
     969,    -1,   971,    -1,   975,    -1,   982,    -1,   983,   985,
      -1,   983,   508,  1058,   509,   985,    -1,   969,    -1,   972,
      -1,   976,    -1,   982,    -1,  1181,   968,    -1,  1181,   741,
     968,    -1,   508,  1016,   509,    -1,    -1,   263,    -1,   264,
      -1,   407,    -1,   120,    -1,   362,    -1,   221,   970,    -1,
     196,   349,    -1,   178,   968,    -1,   177,   968,    -1,   320,
     968,    -1,   123,    -1,   508,  1058,   509,    -1,    -1,   973,
      -1,   974,    -1,   973,    -1,   974,    -1,   122,   980,   508,
    1016,   509,    -1,   122,   980,    -1,   977,    -1,   978,    -1,
     977,    -1,   978,    -1,   979,   508,  1058,   509,   981,    -1,
     979,   981,    -1,   135,   980,    -1,   134,   980,    -1,   463,
      -1,   306,   135,   980,    -1,   306,   134,   980,    -1,   308,
     980,    -1,   465,    -1,    -1,   135,   401,  1180,    -1,    -1,
     433,   508,  1058,   509,   984,    -1,   433,   984,    -1,   432,
     508,  1058,   509,   984,    -1,   432,   984,    -1,   266,    -1,
     494,   491,    -1,   475,   432,   491,    -1,    -1,   489,    -1,
     302,    -1,   175,    -1,   241,    -1,   299,    -1,   986,    -1,
     489,   434,   302,    -1,   175,   434,   241,    -1,   175,   434,
     299,    -1,   175,   434,   986,    -1,   241,   434,   299,    -1,
     241,   434,   986,    -1,   299,   434,   986,    -1,    -1,   392,
      -1,   392,   508,  1058,   509,    -1,   989,    -1,   987,    88,
     963,    -1,   987,   143,   740,    -1,   987,   113,   432,   491,
     987,    -1,   499,   987,    -1,   500,   987,    -1,   987,   499,
     987,    -1,   987,   500,   987,    -1,   987,   501,   987,    -1,
     987,   502,   987,    -1,   987,   503,   987,    -1,   987,   504,
     987,    -1,   987,   496,   987,    -1,   987,   497,   987,    -1,
     987,   495,   987,    -1,   987,  1013,   987,    -1,  1013,   987,
      -1,   987,  1013,    -1,   987,   105,   987,    -1,   987,   331,
     987,    -1,   312,   987,    -1,   987,   286,   987,    -1,   987,
     286,   987,   205,   987,    -1,   987,   312,   286,   987,    -1,
     987,   312,   286,   987,   205,   987,    -1,   987,   244,   987,
      -1,   987,   244,   987,   205,   987,    -1,   987,   312,   244,
     987,    -1,   987,   312,   244,   987,   205,   987,    -1,   987,
     405,   434,   987,    -1,   987,   405,   434,   987,   205,   987,
      -1,   987,   312,   405,   434,   987,    -1,   987,   312,   405,
     434,   987,   205,   987,    -1,   987,   269,   317,    -1,   987,
     270,    -1,   987,   269,   312,   317,    -1,   987,   315,    -1,
    1009,   336,  1009,    -1,   987,   269,   440,    -1,   987,   269,
     312,   440,    -1,   987,   269,   217,    -1,   987,   269,   312,
     217,    -1,   987,   269,   450,    -1,   987,   269,   312,   450,
      -1,   987,   269,   192,   228,   987,    -1,   987,   269,   312,
     192,   228,   987,    -1,   987,   269,   322,   508,  1019,   509,
      -1,   987,   269,   312,   322,   508,  1019,   509,    -1,   987,
     119,  1041,   988,   105,   988,    -1,   987,   312,   119,  1041,
     988,   105,   988,    -1,   987,   119,   421,   988,   105,   988,
      -1,   987,   312,   119,   421,   988,   105,   988,    -1,   987,
     248,  1031,    -1,   987,   312,   248,  1031,    -1,   987,  1015,
    1010,   908,    -1,   987,  1015,  1010,   508,   987,   509,    -1,
     449,   908,    -1,   987,   269,   194,    -1,   987,   269,   312,
     194,    -1,   989,    -1,   988,    88,   963,    -1,   499,   988,
      -1,   500,   988,    -1,   988,   499,   988,    -1,   988,   500,
     988,    -1,   988,   501,   988,    -1,   988,   502,   988,    -1,
     988,   503,   988,    -1,   988,   504,   988,    -1,   988,   496,
     988,    -1,   988,   497,   988,    -1,   988,   495,   988,    -1,
     988,  1013,   988,    -1,  1013,   988,    -1,   988,  1013,    -1,
     988,   269,   192,   228,   988,    -1,   988,   269,   312,   192,
     228,   988,    -1,   988,   269,   322,   508,  1019,   509,    -1,
     988,   269,   312,   322,   508,  1019,   509,    -1,   988,   269,
     194,    -1,   988,   269,   312,   194,    -1,  1037,    -1,  1057,
      -1,  1197,  1040,    -1,   508,   987,   509,  1040,    -1,  1032,
      -1,   990,    -1,   908,    -1,   908,  1039,    -1,   212,   908,
      -1,   107,   908,    -1,   107,  1020,    -1,  1009,    -1,  1056,
     508,   509,  1002,    -1,  1056,   508,  1017,   509,  1002,    -1,
    1056,   508,   464,  1018,   509,  1002,    -1,  1056,   508,  1017,
     511,   464,  1018,   509,  1002,    -1,  1056,   508,  1017,   922,
     509,  1002,    -1,  1056,   508,    99,  1017,   921,   509,  1002,
      -1,  1056,   508,   192,  1017,   921,   509,  1002,    -1,  1056,
     508,   501,   509,  1002,    -1,   144,   223,   508,   987,   509,
      -1,   165,    -1,   168,    -1,   168,   508,  1058,   509,    -1,
     169,    -1,   169,   508,  1058,   509,    -1,   291,    -1,   291,
     508,  1058,   509,    -1,   292,    -1,   292,   508,  1058,   509,
      -1,   166,    -1,   170,    -1,   400,    -1,   455,    -1,   164,
      -1,   167,    -1,   131,   508,   987,   108,   963,   509,    -1,
     216,   508,  1022,   509,    -1,   337,   508,  1024,   509,    -1,
     347,   508,  1026,   509,    -1,   420,   508,  1027,   509,    -1,
     437,   508,   987,   108,   963,   509,    -1,   439,   508,   124,
    1030,   509,    -1,   439,   508,   281,  1030,   509,    -1,   439,
     508,   435,  1030,   509,    -1,   439,   508,  1030,   509,    -1,
     318,   508,   987,   511,   987,   509,    -1,   142,   508,  1016,
     509,    -1,   235,   508,  1016,   509,    -1,   283,   508,  1016,
     509,    -1,   481,   508,  1016,   509,    -1,   482,   508,   304,
    1182,   509,    -1,   482,   508,   304,  1182,   511,   993,   509,
      -1,   482,   508,   304,  1182,   511,  1016,   509,    -1,   482,
     508,   304,  1182,   511,   993,   511,  1016,   509,    -1,   483,
     508,   989,   998,   509,    -1,   484,   508,   994,   509,    -1,
     485,   508,   996,   987,   997,   509,    -1,   486,   508,   304,
    1182,   509,    -1,   486,   508,   304,  1182,   511,   987,   509,
      -1,   487,   508,   987,   511,   991,   992,   509,    -1,   488,
     508,   996,   987,   108,   965,   509,    -1,   467,   987,    -1,
     467,   310,   461,    -1,   511,   411,   490,    -1,   511,   411,
     310,    -1,   511,   411,   310,   461,    -1,    -1,   480,   508,
     994,   509,    -1,   995,    -1,   994,   511,   995,    -1,   987,
     108,  1182,    -1,   987,    -1,   194,    -1,   155,    -1,   350,
     472,    -1,   419,   472,    -1,    -1,   343,   989,    -1,   343,
     989,   125,   366,    -1,   343,   125,   366,   989,    -1,   343,
     125,   366,   989,   125,   366,    -1,   473,  1000,    -1,    -1,
    1001,    -1,  1000,   511,  1001,    -1,  1180,   108,  1003,    -1,
     335,  1003,    -1,   335,  1180,    -1,    -1,   508,  1004,  1005,
     921,  1006,   509,    -1,  1180,    -1,    -1,   342,   125,  1016,
      -1,    -1,   360,  1007,    -1,   386,  1007,    -1,    -1,  1008,
      -1,   119,  1008,   105,  1008,    -1,   445,   348,    -1,   445,
     222,    -1,   163,   385,    -1,   987,   348,    -1,   987,   222,
      -1,   385,   508,  1016,   509,    -1,   385,   508,   509,    -1,
     508,  1016,   511,   987,   509,    -1,   106,    -1,   409,    -1,
      99,    -1,    85,    -1,  1012,    -1,   499,    -1,   500,    -1,
     501,    -1,   502,    -1,   503,    -1,   504,    -1,   496,    -1,
     497,    -1,   495,    -1,    85,    -1,   328,   508,   812,   509,
      -1,  1011,    -1,   328,   508,   812,   509,    -1,  1011,    -1,
     328,   508,   812,   509,    -1,   286,    -1,   312,   286,    -1,
     244,    -1,   312,   244,    -1,   987,    -1,  1016,   511,   987,
      -1,  1018,    -1,  1017,   511,  1018,    -1,   987,    -1,   794,
      90,   987,    -1,   963,    -1,  1019,   511,   963,    -1,   506,
    1016,   507,    -1,   506,  1021,   507,    -1,   506,   507,    -1,
    1020,    -1,  1021,   511,  1020,    -1,  1023,   228,   987,    -1,
      -1,  1202,    -1,   489,    -1,   302,    -1,   175,    -1,   241,
      -1,   299,    -1,   392,    -1,  1200,    -1,   987,  1025,  1028,
    1029,    -1,   987,  1025,  1028,    -1,   345,   987,    -1,   988,
     248,   988,    -1,    -1,   987,  1028,  1029,    -1,   987,  1029,
    1028,    -1,   987,  1028,    -1,   987,  1029,    -1,  1016,    -1,
      -1,   228,   987,    -1,   223,   987,    -1,   987,   228,  1016,
      -1,   228,  1016,    -1,  1016,    -1,   908,    -1,   508,  1016,
     509,    -1,   130,  1036,  1033,  1035,   203,    -1,  1034,    -1,
    1033,  1034,    -1,   470,   987,   431,   987,    -1,   199,   987,
      -1,    -1,   987,    -1,    -1,  1180,    -1,  1180,  1039,    -1,
     510,  1053,    -1,   510,   501,    -1,   506,   987,   507,    -1,
     506,   987,   513,   987,   507,    -1,  1038,    -1,  1039,  1038,
      -1,    -1,  1040,  1038,    -1,   112,    -1,    -1,   987,    -1,
     180,    -1,  1042,    -1,  1043,   511,  1042,    -1,   508,  1043,
     509,    -1,  1046,    -1,  1045,   511,  1046,    -1,   987,   108,
    1182,    -1,   987,  1202,    -1,   987,    -1,   501,    -1,  1048,
      -1,  1047,   511,  1048,    -1,  1180,    -1,  1180,  1039,    -1,
    1050,    -1,  1049,   511,  1050,    -1,  1180,    -1,  1180,    -1,
    1180,    -1,  1182,    -1,  1180,    -1,  1200,    -1,  1181,    -1,
    1180,  1039,    -1,  1058,    -1,  1199,    -1,  1200,    -1,  1198,
      -1,    84,    -1,  1056,  1200,    -1,  1056,   508,  1017,   509,
    1200,    -1,   966,  1200,    -1,   983,  1200,   985,    -1,   983,
     508,  1058,   509,  1200,   985,    -1,   440,    -1,   217,    -1,
     317,    -1,  1194,    -1,  1192,    -1,    86,    -1,  1062,    -1,
    1059,    -1,  1060,   511,  1059,    -1,  1058,    -1,  1194,    -1,
     499,  1058,    -1,   500,  1058,    -1,  1202,    -1,  1063,    -1,
    1064,    -1,  1065,    -1,    91,    -1,    92,    -1,    93,    -1,
      94,    -1,    95,    -1,    96,    -1,    97,    -1,    98,    -1,
     100,    -1,   101,    -1,   102,    -1,   110,    -1,   111,    -1,
     113,    -1,   114,    -1,   116,    -1,   117,    -1,   118,    -1,
     125,    -1,   126,    -1,   127,    -1,   128,    -1,   129,    -1,
     132,    -1,   133,    -1,   136,    -1,   138,    -1,   139,    -1,
     140,    -1,   141,    -1,   146,    -1,   147,    -1,   148,    -1,
     149,    -1,   151,    -1,   154,    -1,   155,    -1,   156,    -1,
     157,    -1,   158,    -1,   159,    -1,   162,    -1,   171,    -1,
     172,    -1,   173,    -1,   174,    -1,   176,    -1,   179,    -1,
     181,    -1,   183,    -1,   184,    -1,   185,    -1,   186,    -1,
     187,    -1,   189,    -1,   190,    -1,   191,    -1,   194,    -1,
     195,    -1,   196,    -1,   197,    -1,   198,    -1,   200,    -1,
     201,    -1,   202,    -1,   204,    -1,   205,    -1,   206,    -1,
     208,    -1,   209,    -1,   210,    -1,   211,    -1,   213,    -1,
     214,    -1,   215,    -1,   218,    -1,   220,    -1,   222,    -1,
     224,    -1,   226,    -1,   230,    -1,   231,    -1,   232,    -1,
     234,    -1,   237,    -1,   239,    -1,   240,    -1,   242,    -1,
     243,    -1,   245,    -1,   246,    -1,   247,    -1,   249,    -1,
     250,    -1,   251,    -1,   252,    -1,   253,    -1,   254,    -1,
     256,    -1,   260,    -1,   261,    -1,   262,    -1,   268,    -1,
     271,    -1,   273,    -1,   274,    -1,   275,    -1,   276,    -1,
     277,    -1,   279,    -1,   280,    -1,   282,    -1,   285,    -1,
     288,    -1,   289,    -1,   290,    -1,   293,    -1,   294,    -1,
     295,    -1,   296,    -1,   297,    -1,   298,    -1,   300,    -1,
     301,    -1,   303,    -1,   304,    -1,   305,    -1,   309,    -1,
     310,    -1,   313,    -1,   314,    -1,   316,    -1,   319,    -1,
     321,    -1,   322,    -1,   323,    -1,   325,    -1,   328,    -1,
     329,    -1,   330,    -1,   338,    -1,   339,    -1,   340,    -1,
     341,    -1,   342,    -1,   343,    -1,   344,    -1,   346,    -1,
     348,    -1,   351,    -1,   352,    -1,   350,    -1,   354,    -1,
     355,    -1,   356,    -1,   357,    -1,   358,    -1,   359,    -1,
     360,    -1,   361,    -1,   363,    -1,   364,    -1,   365,    -1,
     366,    -1,   368,    -1,   369,    -1,   370,    -1,   371,    -1,
     372,    -1,   373,    -1,   374,    -1,   375,    -1,   376,    -1,
     377,    -1,   378,    -1,   380,    -1,   381,    -1,   383,    -1,
     384,    -1,   386,    -1,   387,    -1,   388,    -1,   389,    -1,
     390,    -1,   391,    -1,   393,    -1,   395,    -1,   396,    -1,
     397,    -1,   398,    -1,   399,    -1,   401,    -1,   403,    -1,
     404,    -1,   406,    -1,   408,    -1,   410,    -1,   411,    -1,
     412,    -1,   413,    -1,   414,    -1,   415,    -1,   416,    -1,
     417,    -1,   418,    -1,   419,    -1,   422,    -1,   423,    -1,
     425,    -1,   426,    -1,   427,    -1,   428,    -1,   429,    -1,
     430,    -1,   436,    -1,   438,    -1,   441,    -1,   442,    -1,
     443,    -1,   444,    -1,   445,    -1,   446,    -1,   447,    -1,
     450,    -1,   451,    -1,   452,    -1,   453,    -1,   454,    -1,
     457,    -1,   458,    -1,   459,    -1,   460,    -1,   461,    -1,
     465,    -1,   467,    -1,   468,    -1,   469,    -1,   472,    -1,
     475,    -1,   476,    -1,   477,    -1,   478,    -1,   479,    -1,
     490,    -1,   491,    -1,   119,    -1,   120,    -1,   122,    -1,
     123,    -1,   135,    -1,   142,    -1,   177,    -1,   178,    -1,
     212,    -1,   216,    -1,   221,    -1,   235,    -1,   258,    -1,
     264,    -1,   266,    -1,   283,    -1,   306,    -1,   308,    -1,
     311,    -1,   318,    -1,   320,    -1,   333,    -1,   337,    -1,
     347,    -1,   349,    -1,   362,    -1,   385,    -1,   402,    -1,
     407,    -1,   420,    -1,   432,    -1,   433,    -1,   437,    -1,
     439,    -1,   463,    -1,   480,    -1,   481,    -1,   482,    -1,
     483,    -1,   484,    -1,   485,    -1,   486,    -1,   487,    -1,
     488,    -1,   115,    -1,   121,    -1,   144,    -1,   150,    -1,
     161,    -1,   167,    -1,   227,    -1,   229,    -1,   244,    -1,
     257,    -1,   269,    -1,   270,    -1,   272,    -1,   284,    -1,
     286,    -1,   307,    -1,   315,    -1,   334,    -1,   335,    -1,
     336,    -1,   382,    -1,   405,    -1,   466,    -1,    99,    -1,
     103,    -1,   104,    -1,   105,    -1,   106,    -1,   107,    -1,
     108,    -1,   109,    -1,   112,    -1,   124,    -1,   130,    -1,
     131,    -1,   137,    -1,   143,    -1,   145,    -1,   153,    -1,
     160,    -1,   164,    -1,   165,    -1,   166,    -1,   168,    -1,
     169,    -1,   170,    -1,   180,    -1,   182,    -1,   188,    -1,
     192,    -1,   193,    -1,   199,    -1,   203,    -1,   207,    -1,
     217,    -1,   219,    -1,   223,    -1,   225,    -1,   228,    -1,
     233,    -1,   236,    -1,   238,    -1,   248,    -1,   255,    -1,
     265,    -1,   267,    -1,   278,    -1,   281,    -1,   287,    -1,
     291,    -1,   292,    -1,   312,    -1,   317,    -1,   324,    -1,
     326,    -1,   327,    -1,   331,    -1,   332,    -1,   345,    -1,
     353,    -1,   367,    -1,   379,    -1,   394,    -1,   400,    -1,
     409,    -1,   421,    -1,   424,    -1,   431,    -1,   435,    -1,
     440,    -1,   449,    -1,   455,    -1,   456,    -1,   464,    -1,
     470,    -1,   471,    -1,   473,    -1,   474,    -1,    -1,  1067,
    1068,    -1,  1189,  1071,   518,   512,    -1,  1189,   518,   512,
      -1,  1189,  1091,    -1,  1096,    -1,  1208,    -1,    73,    -1,
     514,    -1,   515,    -1,    -1,   160,   593,   424,   629,   108,
    1070,   907,   630,    -1,   113,  1132,    -1,     9,   434,  1073,
    1080,  1081,    -1,     9,   434,   180,    -1,     9,  1082,    -1,
     174,  1073,    -1,  1074,  1077,  1079,    -1,  1075,   513,  1076,
    1079,   502,  1074,  1085,    -1,  1084,    -1,  1200,    -1,  1051,
      -1,    -1,  1202,  1196,    -1,    85,  1078,    -1,  1076,    -1,
      -1,  1180,    -1,  1180,   510,  1078,    -1,    74,    -1,   513,
    1058,    -1,    -1,   108,  1132,    -1,    -1,   455,  1082,    -1,
      -1,  1083,    -1,  1083,   502,  1083,    -1,  1083,    21,   125,
    1083,    -1,  1083,   456,  1083,    -1,  1059,    -1,  1200,    -1,
    1194,    -1,  1196,    -1,    85,  1086,    -1,    -1,  1180,  1087,
      -1,  1180,  1087,    85,  1086,    -1,    -1,   495,  1058,    -1,
     495,  1202,    -1,   495,  1194,    -1,  1050,    -1,  1084,    -1,
     179,   904,   905,   171,   906,   223,  1088,    -1,   211,   245,
    1133,    -1,  1092,    -1,  1103,    -1,  1105,    -1,   641,    -1,
     511,   641,    -1,    -1,   985,    -1,   489,   434,   299,    -1,
     489,   434,   392,    -1,   175,   434,   175,    -1,   302,   434,
     302,    -1,    -1,  1098,  1097,  1100,  1099,    -1,  1189,   118,
     179,    34,   512,    -1,  1189,   203,   179,    34,   512,    -1,
      -1,  1101,    -1,  1092,    -1,    73,    -1,  1101,  1092,    -1,
    1101,    73,    -1,  1105,    -1,  1102,  1105,    -1,    -1,    70,
    1104,  1112,  1128,  1184,   964,   512,    -1,    -1,  1109,  1112,
    1106,  1125,   512,    -1,    -1,  1112,  1107,  1125,   512,    -1,
    1115,   512,    -1,   513,  1058,    -1,    -1,  1110,  1111,    -1,
    1110,    -1,  1111,    -1,    56,    -1,    67,    -1,    65,    -1,
      50,    -1,    51,    -1,    69,    -1,  1121,    -1,  1117,    -1,
    1113,    -1,  1184,   508,  1093,  1094,   509,    -1,  1184,  1095,
      -1,  1119,    -1,   204,  1178,  1114,    -1,   204,  1114,    -1,
     204,  1178,    -1,   514,  1206,   515,    -1,    -1,  1119,  1116,
     514,  1102,   515,    -1,  1115,    -1,    -1,  1120,  1118,   514,
    1102,   515,    -1,    43,  1178,    -1,   448,  1178,    -1,    43,
      -1,   448,    -1,  1122,    -1,  1124,  1123,    -1,    44,    35,
      -1,    44,    35,   263,    -1,    44,    -1,    44,   263,    -1,
      44,    25,    -1,    44,    25,   263,    -1,    44,    25,    25,
      -1,    44,    25,    25,   263,    -1,    44,   134,    -1,    35,
      -1,    35,   263,    -1,   263,    -1,    25,    -1,    25,   263,
      -1,    25,    25,    -1,    25,    25,   263,    -1,     5,    -1,
     134,    -1,   196,    -1,    36,    -1,    -1,  1126,    -1,  1125,
     511,  1126,    -1,  1128,  1183,   964,  1108,  1127,    -1,    -1,
     495,  1207,    -1,    -1,   501,    -1,   501,   501,    -1,   179,
     413,  1202,    -1,    15,  1131,    -1,  1132,    -1,   163,    -1,
      99,    -1,    -1,  1051,    -1,   180,    -1,  1084,    -1,  1084,
      -1,    71,    -1,    17,   904,    -1,    17,    99,    -1,    28,
     904,  1136,    -1,    -1,  1137,    -1,   456,  1141,    -1,  1138,
      -1,   456,    37,    14,  1203,    -1,   456,    14,  1050,    -1,
     267,    37,    14,  1203,    -1,   267,    14,  1050,    -1,   267,
    1050,    -1,  1142,    -1,  1142,   511,  1141,    -1,  1143,    -1,
    1194,    -1,  1192,    -1,  1058,    -1,   499,  1058,    -1,   500,
    1058,    -1,  1199,    -1,   499,  1199,    -1,   500,  1199,    -1,
    1200,    -1,  1198,    -1,  1201,    -1,    13,   259,  1088,  1138,
      -1,    13,  1145,  1088,  1138,    -1,    13,  1145,  1088,  1139,
      -1,    13,   259,  1088,  1140,    -1,    13,  1145,  1088,  1140,
      -1,    29,    -1,    -1,     3,    14,  1203,    -1,   176,    14,
    1203,    -1,    18,    14,  1203,  1149,    -1,  1150,    -1,  1149,
     511,  1150,    -1,  1196,   495,  1155,    -1,   401,    14,  1203,
    1152,    -1,  1153,    -1,  1152,   511,  1153,    -1,  1155,   495,
    1154,    -1,  1058,    -1,  1196,    -1,    10,    -1,    18,    14,
    1203,   461,  1154,  1157,    -1,  1158,    -1,  1157,   511,  1158,
      -1,  1196,   495,  1163,    -1,   401,    14,  1203,   461,  1154,
    1160,    -1,  1161,    -1,  1160,   511,  1161,    -1,  1163,   495,
    1162,    -1,  1199,    -1,  1154,    -1,   500,  1199,    -1,   500,
    1058,    -1,  1200,    -1,     8,    -1,   173,    -1,    11,    -1,
      12,    -1,    22,    -1,    23,    -1,    24,    -1,   304,    -1,
      26,    -1,    27,    -1,   349,    -1,    31,    -1,    32,    -1,
      33,    -1,   443,    -1,   401,     4,   495,  1165,    -1,   401,
       4,   434,  1165,    -1,   326,    -1,   323,    -1,   401,   152,
     434,  1132,    -1,   401,   152,   495,  1132,    -1,   401,   152,
    1132,    -1,    -1,   443,  1168,  1184,   269,  1112,   964,  1169,
      -1,    30,    -1,    -1,    -1,    45,  1171,  1182,   269,  1112,
     964,  1169,    -1,    46,    38,  1173,    -1,    46,   312,    16,
    1173,    -1,    46,    40,  1173,    -1,   156,    -1,    39,    -1,
      42,    -1,    20,  1050,    -1,    19,   434,  1050,    -1,   193,
    1050,   508,  1190,   509,    -1,   193,     6,    -1,     7,  1050,
     508,  1190,   509,    -1,     7,  1050,    -1,  1175,    -1,  1176,
      -1,     6,    -1,     7,    -1,     8,    -1,    10,    -1,    11,
      -1,    12,    -1,    16,    -1,    19,    -1,    20,    -1,    21,
      -1,    22,    -1,    23,    -1,    24,    -1,    26,    -1,    27,
      -1,    31,    -1,    32,    -1,    33,    -1,    34,    -1,    37,
      -1,    38,    -1,    39,    -1,    40,    -1,    42,    -1,     9,
      -1,    13,    -1,    15,    -1,    28,    -1,    45,    -1,    46,
      -1,     5,    -1,    25,    -1,    29,    -1,    35,    -1,    43,
      -1,    36,    -1,    44,    -1,  1182,    -1,  1202,    -1,  1063,
      -1,  1064,    -1,  1187,    -1,  1174,    -1,  1185,    -1,   134,
      -1,   462,    -1,  1202,    -1,  1186,    -1,  1064,    -1,  1174,
      -1,  1185,    -1,   134,    -1,   462,    -1,  1202,    -1,  1186,
      -1,  1065,    -1,  1174,    -1,  1185,    -1,  1177,    -1,  1183,
      -1,  1177,    -1,   134,    -1,   163,    -1,   259,    -1,   263,
      -1,   434,    -1,   448,    -1,   462,    -1,  1185,    -1,  1187,
      -1,  1184,    -1,  1063,    -1,  1066,    -1,  1176,    -1,   152,
      -1,  1202,    -1,  1064,    -1,  1065,    -1,  1175,    -1,    50,
      -1,    51,    -1,    56,    -1,    65,    -1,    67,    -1,    70,
      -1,    69,    -1,  1063,    -1,  1187,    -1,   152,    -1,   175,
      -1,   241,    -1,   299,    -1,   302,    -1,   392,    -1,   489,
      -1,  1191,    -1,  1188,   511,  1191,    -1,    41,    -1,    -1,
    1206,    -1,  1196,  1195,    -1,  1196,    -1,  1196,  1195,    -1,
    1084,    -1,  1196,    -1,  1196,    -1,    22,  1196,    -1,    22,
    1050,    -1,    72,    -1,    87,    -1,    83,    -1,    81,    -1,
      82,    -1,    76,    -1,    77,    -1,    78,    -1,    75,    -1,
      84,    -1,    80,    -1,    71,    -1,    79,    -1,  1050,    -1,
    1084,    -1,  1209,    -1,   508,   509,    -1,   508,  1205,   509,
      -1,  1204,    -1,  1205,  1204,    -1,  1207,    -1,  1206,   511,
    1207,    -1,  1205,    -1,   514,  1206,   515,    -1,  1209,    -1,
     508,    -1,   509,    -1,   511,    -1,   512,    -1,  1202,    -1,
    1058,    -1,  1199,    -1,  1200,    -1,   501,    -1,   499,    -1,
     500,    -1,   502,    -1,   503,    -1,   317,    -1,    47,    -1,
      48,    -1,    49,    -1,    50,    -1,    51,    -1,    52,    -1,
      53,    -1,    54,    -1,    55,    -1,    56,    -1,    57,    -1,
      58,    -1,    60,    -1,    59,    -1,    61,    -1,    62,    -1,
      63,    -1,    64,    -1,    65,    -1,    66,    -1,    67,    -1,
      68,    -1,    70,    -1,    69,    -1,     5,    -1,   204,    -1,
     241,    -1,   263,    -1,    25,    -1,   299,    -1,   302,    -1,
     392,    -1,    35,    -1,    36,    -1,    43,    -1,    44,    -1,
     489,    -1,   134,    -1,   221,    -1,   434,    -1,   448,    -1,
     463,    -1,   506,    -1,   507,    -1,   495,    -1,   513,    -1,
     176,  1088,    -1,   176,   351,  1088,    -1,   176,    99,    -1,
     176,   351,    99,    -1,  1058,    -1,   508,  1211,   509,    -1,
    1211,   499,  1211,    -1,  1211,   500,  1211,    -1,  1211,   501,
    1211,    -1,  1211,   502,  1211,    -1,  1211,   503,  1211,    -1,
    1200,    -1,  1180,    -1,    -1,  1137,  1213,    -1,  1213,  1137,
      -1,  1137,    -1,  1213,    -1,   267,  1188,    -1,  1139,    -1,
    1213,    -1,  1138,    -1,    -1,  1214,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1478,  1478,  1481,  1483,  1485,  1487,  1489,  1491,  1493,
    1495,  1497,  1499,  1501,  1503,  1505,  1507,  1509,  1511,  1513,
    1515,  1517,  1519,  1521,  1523,  1525,  1527,  1529,  1531,  1533,
    1535,  1553,  1555,  1557,  1559,  1561,  1563,  1565,  1567,  1569,
    1571,  1573,  1575,  1577,  1579,  1581,  1583,  1585,  1587,  1589,
    1591,  1593,  1595,  1597,  1599,  1601,  1603,  1605,  1607,  1609,
    1611,  1613,  1617,  1619,  1621,  1623,  1625,  1627,  1629,  1631,
    1633,  1635,  1637,  1639,  1641,  1643,  1645,  1647,  1649,  1651,
    1653,  1655,  1657,  1659,  1661,  1663,  1665,  1667,  1669,  1671,
    1673,  1675,  1677,  1679,  1681,  1683,  1685,  1692,  1694,  1696,
    1698,  1700,  1702,  1704,  1706,  1708,  1710,  1712,  1714,  1720,
    1722,  1724,  1726,  1728,  1730,  1732,  1734,  1736,  1742,  1752,
    1756,  1762,  1766,  1776,  1786,  1787,  1801,  1808,  1814,  1825,
    1831,  1840,  1847,  1853,  1862,  1869,  1877,  1882,  1890,  1895,
    1901,  1906,  1912,  1917,  1923,  1927,  1931,  1935,  1939,  1943,
    1947,  1951,  1955,  1963,  1967,  1971,  1975,  1979,  1983,  1991,
    1999,  2008,  2010,  2018,  2022,  2030,  2038,  2046,  2050,  2058,
    2062,  2070,  2078,  2086,  2090,  2098,  2102,  2110,  2114,  2118,
    2123,  2132,  2137,  2143,  2148,  2154,  2158,  2162,  2166,  2170,
    2174,  2182,  2186,  2190,  2198,  2202,  2206,  2214,  2218,  2222,
    2226,  2230,  2234,  2238,  2243,  2247,  2251,  2255,  2259,  2263,
    2267,  2275,  2279,  2287,  2291,  2299,  2303,  2317,  2321,  2325,
    2329,  2337,  2341,  2345,  2349,  2357,  2361,  2365,  2369,  2373,
    2377,  2381,  2389,  2393,  2398,  2404,  2408,  2416,  2420,  2424,
    2428,  2432,  2440,  2444,  2452,  2456,  2464,  2468,  2472,  2476,
    2480,  2489,  2497,  2501,  2509,  2513,  2521,  2529,  2533,  2537,
    2541,  2549,  2553,  2557,  2561,  2565,  2569,  2573,  2577,  2581,
    2585,  2593,  2597,  2605,  2609,  2613,  2617,  2621,  2625,  2629,
    2633,  2637,  2641,  2645,  2649,  2653,  2657,  2661,  2665,  2669,
    2673,  2677,  2681,  2685,  2689,  2693,  2697,  2701,  2705,  2709,
    2713,  2717,  2721,  2725,  2729,  2733,  2737,  2741,  2745,  2749,
    2753,  2757,  2761,  2765,  2769,  2777,  2781,  2789,  2793,  2798,
    2804,  2809,  2815,  2820,  2826,  2834,  2839,  2845,  2849,  2857,
    2861,  2865,  2869,  2877,  2885,  2889,  2897,  2901,  2905,  2909,
    2917,  2922,  2930,  2938,  2946,  2950,  2958,  2963,  2969,  2973,
    2977,  2985,  2989,  2997,  3002,  3008,  3012,  3016,  3020,  3024,
    3028,  3032,  3036,  3040,  3044,  3048,  3052,  3056,  3064,  3069,
    3075,  3080,  3086,  3091,  3097,  3102,  3108,  3112,  3120,  3128,
    3132,  3136,  3140,  3145,  3151,  3155,  3163,  3171,  3175,  3179,
    3183,  3191,  3195,  3199,  3203,  3207,  3211,  3215,  3220,  3226,
    3231,  3237,  3242,  3248,  3252,  3260,  3264,  3272,  3276,  3280,
    3288,  3292,  3300,  3308,  3316,  3321,  3327,  3331,  3335,  3339,
    3347,  3351,  3355,  3359,  3363,  3367,  3371,  3379,  3383,  3387,
    3391,  3399,  3407,  3411,  3416,  3422,  3426,  3430,  3434,  3438,
    3442,  3450,  3454,  3462,  3466,  3470,  3474,  3478,  3482,  3486,
    3494,  3499,  3505,  3510,  3516,  3520,  3528,  3536,  3540,  3545,
    3550,  3556,  3560,  3568,  3572,  3580,  3585,  3591,  3595,  3599,
    3603,  3608,  3614,  3622,  3630,  3634,  3638,  3642,  3646,  3654,
    3659,  3665,  3669,  3673,  3678,  3684,  3688,  3692,  3697,  3703,
    3708,  3714,  3719,  3725,  3733,  3741,  3745,  3750,  3756,  3764,
    3772,  3777,  3783,  3791,  3799,  3803,  3811,  3816,  3822,  3826,
    3834,  3838,  3842,  3846,  3850,  3854,  3858,  3862,  3866,  3870,
    3874,  3878,  3886,  3891,  3897,  3901,  3905,  3913,  3917,  3925,
    3929,  3937,  3942,  3948,  3952,  3960,  3965,  3971,  3975,  3983,
    3988,  3994,  3998,  4006,  4011,  4017,  4025,  4030,  4036,  4040,
    4048,  4052,  4060,  4065,  4071,  4075,  4079,  4087,  4095,  4100,
    4106,  4114,  4118,  4122,  4126,  4130,  4134,  4138,  4142,  4146,
    4150,  4154,  4158,  4162,  4166,  4170,  4174,  4178,  4182,  4186,
    4190,  4194,  4198,  4202,  4206,  4214,  4222,  4226,  4230,  4234,
    4242,  4246,  4254,  4259,  4265,  4269,  4277,  4281,  4289,  4294,
    4300,  4304,  4312,  4320,  4324,  4332,  4336,  4340,  4344,  4352,
    4360,  4368,  4376,  4384,  4389,  4395,  4399,  4407,  4412,  4418,
    4422,  4430,  4434,  4438,  4446,  4450,  4458,  4462,  4470,  4478,
    4482,  4486,  4494,  4498,  4506,  4514,  4518,  4526,  4530,  4534,
    4542,  4546,  4554,  4558,  4562,  4566,  4570,  4578,  4583,  4589,
    4594,  4600,  4604,  4612,  4617,  4623,  4627,  4632,  4638,  4642,
    4646,  4650,  4658,  4663,  4670,  4672,  4680,  4684,  4688,  4692,
    4696,  4700,  4708,  4712,  4720,  4724,  4732,  4736,  4744,  4752,
    4756,  4764,  4772,  4776,  4780,  4784,  4792,  4801,  4810,  4814,
    4818,  4822,  4826,  4830,  4834,  4838,  4842,  4846,  4850,  4854,
    4858,  4862,  4870,  4878,  4882,  4890,  4894,  4902,  4906,  4910,
    4914,  4918,  4926,  4930,  4938,  4946,  4950,  4958,  4966,  4971,
    4977,  4981,  4989,  4993,  4997,  5005,  5010,  5016,  5024,  5028,
    5036,  5040,  5044,  5048,  5052,  5060,  5065,  5071,  5076,  5082,
    5086,  5091,  5097,  5103,  5109,  5117,  5121,  5129,  5133,  5141,
    5145,  5153,  5157,  5165,  5169,  5177,  5185,  5193,  5197,  5201,
    5205,  5213,  5217,  5221,  5225,  5229,  5233,  5237,  5241,  5245,
    5249,  5253,  5257,  5261,  5265,  5269,  5273,  5277,  5285,  5289,
    5297,  5301,  5309,  5313,  5321,  5329,  5333,  5338,  5344,  5348,
    5352,  5356,  5360,  5364,  5368,  5372,  5376,  5380,  5384,  5388,
    5392,  5400,  5404,  5408,  5412,  5416,  5420,  5424,  5428,  5432,
    5436,  5440,  5444,  5448,  5452,  5456,  5460,  5464,  5468,  5472,
    5476,  5480,  5484,  5488,  5496,  5500,  5508,  5512,  5516,  5520,
    5524,  5532,  5537,  5543,  5547,  5551,  5555,  5559,  5563,  5567,
    5571,  5575,  5579,  5583,  5587,  5591,  5599,  5603,  5611,  5615,
    5619,  5623,  5629,  5635,  5641,  5647,  5653,  5659,  5665,  5675,
    5686,  5697,  5708,  5719,  5730,  5741,  5757,  5773,  5789,  5800,
    5816,  5827,  5843,  5858,  5862,  5870,  5875,  5881,  5889,  5893,
    5901,  5905,  5909,  5913,  5917,  5925,  5929,  5937,  5941,  5945,
    5949,  5957,  5961,  5965,  5969,  5973,  5977,  5981,  5985,  5989,
    5993,  5997,  6001,  6005,  6009,  6013,  6017,  6025,  6029,  6037,
    6041,  6049,  6054,  6060,  6064,  6072,  6080,  6088,  6092,  6100,
    6105,  6111,  6116,  6122,  6130,  6135,  6141,  6145,  6149,  6157,
    6161,  6165,  6173,  6177,  6181,  6185,  6193,  6201,  6206,  6212,
    6217,  6223,  6228,  6234,  6239,  6245,  6249,  6257,  6261,  6265,
    6273,  6278,  6284,  6288,  6293,  6299,  6303,  6308,  6314,  6318,
    6323,  6329,  6333,  6337,  6345,  6350,  6356,  6360,  6368,  6372,
    6380,  6384,  6392,  6396,  6404,  6408,  6412,  6416,  6420,  6428,
    6432,  6436,  6440,  6444,  6452,  6460,  6468,  6472,  6476,  6484,
    6488,  6492,  6500,  6504,  6512,  6516,  6520,  6524,  6528,  6532,
    6536,  6540,  6544,  6548,  6552,  6556,  6560,  6564,  6568,  6576,
    6580,  6584,  6588,  6596,  6600,  6608,  6613,  6619,  6627,  6631,
    6639,  6647,  6651,  6659,  6664,  6670,  6674,  6682,  6686,  6694,
    6698,  6706,  6710,  6714,  6718,  6726,  6730,  6738,  6746,  6750,
    6758,  6762,  6770,  6774,  6778,  6786,  6790,  6795,  6801,  6809,
    6814,  6820,  6824,  6828,  6836,  6840,  6848,  6853,  6859,  6863,
    6867,  6871,  6875,  6879,  6883,  6887,  6891,  6895,  6899,  6903,
    6907,  6911,  6915,  6919,  6923,  6927,  6931,  6935,  6939,  6943,
    6947,  6951,  6955,  6959,  6963,  6967,  6971,  6975,  6979,  6983,
    6987,  6991,  6995,  6999,  7003,  7007,  7011,  7015,  7019,  7023,
    7027,  7031,  7035,  7039,  7043,  7051,  7056,  7062,  7067,  7073,
    7077,  7081,  7085,  7089,  7093,  7097,  7101,  7105,  7109,  7113,
    7117,  7121,  7125,  7129,  7133,  7137,  7141,  7145,  7149,  7153,
    7157,  7161,  7165,  7173,  7177,  7181,  7185,  7189,  7193,  7197,
    7201,  7205,  7209,  7213,  7217,  7221,  7225,  7229,  7233,  7237,
    7241,  7245,  7253,  7261,  7265,  7269,  7277,  7281,  7289,  7293,
    7297,  7301,  7305,  7313,  7318,  7324,  7328,  7332,  7336,  7344,
    7348,  7353,  7359,  7363,  7371,  7379,  7384,  7390,  7398,  7402,
    7410,  7414,  7418,  7422,  7426,  7430,  7434,  7438,  7442,  7446,
    7450,  7454,  7458,  7462,  7470,  7474,  7479,  7485,  7489,  7493,
    7497,  7501,  7509,  7513,  7517,  7525,  7530,  7536,  7540,  7544,
    7548,  7556,  7561,  7566,  7572,  7578,  7586,  7594,  7599,  7605,
    7609,  7613,  7617,  7621,  7625,  7629,  7633,  7637,  7641,  7645,
    7649,  7653,  7657,  7661,  7665,  7673,  7678,  7684,  7688,  7696,
    7704,  7709,  7715,  7723,  7727,  7735,  7743,  7747,  7751,  7755,
    7759,  7763,  7767,  7775,  7780,  7786,  7794,  7798,  7802,  7806,
    7810,  7814,  7822,  7830,  7834,  7838,  7846,  7851,  7857,  7861,
    7865,  7869,  7873,  7881,  7885,  7893,  7897,  7901,  7905,  7913,
    7917,  7925,  7929,  7937,  7942,  7948,  7953,  7959,  7964,  7970,
    7975,  7981,  7985,  7989,  7993,  8001,  8005,  8009,  8013,  8017,
    8021,  8025,  8029,  8033,  8041,  8045,  8053,  8061,  8065,  8073,
    8077,  8082,  8088,  8094,  8104,  8109,  8115,  8119,  8123,  8127,
    8135,  8137,  8145,  8150,  8156,  8164,  8168,  8172,  8180,  8184,
    8192,  8200,  8205,  8211,  8219,  8224,  8230,  8238,  8243,  8249,
    8253,  8257,  8261,  8265,  8269,  8273,  8277,  8285,  8290,  8296,
    8304,  8308,  8316,  8320,  8328,  8336,  8344,  8352,  8356,  8364,
    8417,  8421,  8434,  8436,  8440,  8444,  8448,  8457,  8463,  8467,
    8475,  8479,  8487,  8491,  8499,  8503,  8507,  8511,  8515,  8519,
    8523,  8527,  8535,  8539,  8547,  8551,  8555,  8559,  8563,  8567,
    8575,  8579,  8587,  8591,  8599,  8607,  8612,  8618,  8623,  8625,
    8631,  8635,  8639,  8643,  8647,  8651,  8655,  8659,  8663,  8671,
    8676,  8682,  8686,  8691,  8697,  8701,  8705,  8710,  8716,  8721,
    8727,  8735,  8739,  8747,  8751,  8759,  8763,  8767,  8771,  8779,
    8784,  8790,  8794,  8799,  8807,  8811,  8819,  8823,  8831,  8839,
    8843,  8848,  8854,  8862,  8866,  8874,  8878,  8886,  8891,  8897,
    8902,  8908,  8912,  8920,  8925,  8931,  8935,  8943,  8951,  8955,
    8959,  8963,  8971,  8976,  8982,  8986,  8994,  8999,  9005,  9009,
    9017,  9021,  9025,  9029,  9036,  9043,  9047,  9055,  9059,  9063,
    9067,  9071,  9075,  9083,  9087,  9091,  9095,  9103,  9108,  9114,
    9118,  9122,  9126,  9131,  9137,  9141,  9145,  9149,  9157,  9162,
    9168,  9172,  9180,  9184,  9188,  9192,  9200,  9204,  9212,  9216,
    9220,  9228,  9236,  9241,  9247,  9251,  9257,  9263,  9268,  9274,
    9278,  9286,  9294,  9296,  9298,  9302,  9306,  9310,  9318,  9328,
    9339,  9348,  9352,  9356,  9360,  9364,  9368,  9372,  9380,  9384,
    9388,  9392,  9400,  9404,  9412,  9417,  9423,  9427,  9431,  9435,
    9439,  9443,  9447,  9451,  9455,  9459,  9463,  9471,  9476,  9482,
    9486,  9494,  9498,  9506,  9514,  9522,  9526,  9534,  9538,  9546,
    9554,  9562,  9566,  9570,  9574,  9578,  9582,  9590,  9595,  9601,
    9606,  9612,  9616,  9620,  9624,  9632,  9640,  9644,  9649,  9655,
    9659,  9663,  9667,  9671,  9675,  9679,  9683,  9687,  9691,  9695,
    9699,  9703,  9708,  9714,  9718,  9726,  9730,  9734,  9738,  9742,
    9746,  9750,  9754,  9758,  9762,  9766,  9770,  9774,  9778,  9782,
    9786,  9790,  9794,  9798,  9802,  9806,  9810,  9814,  9818,  9822,
    9826,  9830,  9834,  9838,  9842,  9846,  9850,  9854,  9858,  9862,
    9866,  9870,  9874,  9878,  9882,  9886,  9890,  9894,  9898,  9902,
    9906,  9910,  9914,  9918,  9922,  9926,  9930,  9934,  9938,  9942,
    9946,  9950,  9955,  9959,  9967,  9971,  9975,  9979,  9983,  9987,
    9991,  9995,  9999, 10003, 10007, 10011, 10015, 10019, 10023, 10027,
   10031, 10035, 10039, 10043, 10047, 10051, 10059, 10063, 10067, 10071,
   10075, 10079, 10083, 10087, 10091, 10095, 10099, 10103, 10111, 10115,
   10119, 10123, 10127, 10131, 10135, 10139, 10143, 10147, 10151, 10155,
   10159, 10163, 10167, 10171, 10175, 10179, 10183, 10187, 10191, 10195,
   10199, 10203, 10207, 10211, 10215, 10219, 10223, 10227, 10231, 10235,
   10239, 10243, 10247, 10251, 10255, 10259, 10263, 10267, 10271, 10275,
   10279, 10283, 10287, 10291, 10295, 10299, 10303, 10307, 10315, 10319,
   10327, 10331, 10335, 10340, 10346, 10354, 10358, 10366, 10370, 10378,
   10382, 10390, 10394, 10399, 10405, 10409, 10413, 10417, 10425, 10430,
   10436, 10440, 10448, 10456, 10460, 10465, 10471, 10479, 10483, 10490,
   10495, 10501, 10506, 10511, 10517, 10521, 10529, 10533, 10537, 10541,
   10545, 10553, 10557, 10561, 10569, 10573, 10577, 10585, 10589, 10597,
   10601, 10605, 10609, 10613, 10617, 10621, 10625, 10629, 10637, 10641,
   10649, 10653, 10661, 10665, 10669, 10673, 10677, 10681, 10689, 10693,
   10701, 10705, 10713, 10717, 10725, 10729, 10737, 10741, 10745, 10753,
   10757, 10765, 10770, 10776, 10780, 10784, 10788, 10792, 10796, 10800,
   10804, 10812, 10816, 10824, 10832, 10837, 10843, 10847, 10851, 10855,
   10859, 10864, 10870, 10878, 10886, 10890, 10894, 10902, 10906, 10914,
   10922, 10926, 10934, 10942, 10947, 10953, 10958, 10964, 10968, 10976,
   10980, 10984, 10988, 10996, 11000, 11009, 11011, 11019, 11024, 11030,
   11034, 11042, 11046, 11054, 11062, 11066, 11074, 11078, 11082, 11086,
   11094, 11098, 11106, 11110, 11118, 11122, 11130, 11138, 11146, 11154,
   11162, 11170, 11178, 11182, 11190, 11194, 11198, 11202, 11206, 11210,
   11214, 11218, 11222, 11226, 11230, 11234, 11238, 11242, 11243, 11248,
   11254, 11262, 11266, 11274, 11278, 11279, 11283, 11291, 11295, 11299,
   11303, 11311, 11315, 11319, 11323, 11327, 11331, 11335, 11339, 11343,
   11347, 11351, 11355, 11359, 11363, 11367, 11371, 11375, 11379, 11383,
   11387, 11391, 11395, 11399, 11403, 11407, 11411, 11415, 11419, 11423,
   11427, 11431, 11435, 11439, 11443, 11447, 11451, 11455, 11459, 11463,
   11467, 11471, 11475, 11479, 11483, 11487, 11491, 11495, 11499, 11503,
   11507, 11511, 11515, 11519, 11523, 11527, 11531, 11535, 11539, 11543,
   11547, 11551, 11555, 11559, 11563, 11567, 11571, 11575, 11579, 11583,
   11587, 11591, 11595, 11599, 11603, 11607, 11611, 11615, 11619, 11623,
   11627, 11631, 11635, 11639, 11643, 11647, 11651, 11655, 11659, 11663,
   11667, 11671, 11675, 11679, 11683, 11687, 11691, 11695, 11699, 11703,
   11707, 11711, 11715, 11719, 11723, 11727, 11731, 11735, 11739, 11743,
   11747, 11751, 11755, 11759, 11763, 11767, 11771, 11775, 11779, 11783,
   11787, 11791, 11795, 11799, 11803, 11807, 11811, 11815, 11819, 11823,
   11827, 11831, 11835, 11839, 11843, 11847, 11851, 11855, 11859, 11863,
   11867, 11871, 11875, 11879, 11883, 11887, 11891, 11895, 11899, 11903,
   11907, 11911, 11915, 11919, 11923, 11927, 11931, 11935, 11939, 11943,
   11947, 11951, 11955, 11959, 11963, 11967, 11971, 11975, 11979, 11983,
   11987, 11991, 11995, 11999, 12003, 12007, 12011, 12015, 12019, 12023,
   12027, 12031, 12035, 12039, 12043, 12047, 12051, 12055, 12059, 12063,
   12067, 12071, 12075, 12079, 12083, 12087, 12091, 12095, 12099, 12103,
   12107, 12111, 12115, 12119, 12123, 12127, 12131, 12135, 12139, 12143,
   12147, 12151, 12155, 12159, 12163, 12167, 12171, 12175, 12179, 12183,
   12187, 12191, 12195, 12199, 12203, 12207, 12211, 12215, 12219, 12223,
   12227, 12231, 12235, 12239, 12243, 12247, 12251, 12255, 12259, 12263,
   12267, 12271, 12275, 12279, 12283, 12287, 12295, 12299, 12303, 12307,
   12311, 12315, 12319, 12323, 12327, 12331, 12335, 12339, 12343, 12347,
   12351, 12355, 12359, 12363, 12367, 12371, 12375, 12379, 12383, 12387,
   12391, 12395, 12399, 12403, 12407, 12411, 12415, 12419, 12423, 12427,
   12431, 12435, 12439, 12443, 12447, 12451, 12455, 12459, 12463, 12467,
   12475, 12479, 12483, 12487, 12491, 12495, 12499, 12503, 12507, 12511,
   12515, 12519, 12523, 12527, 12531, 12535, 12539, 12543, 12547, 12551,
   12555, 12559, 12563, 12571, 12575, 12579, 12583, 12587, 12591, 12595,
   12599, 12603, 12607, 12611, 12615, 12619, 12623, 12627, 12631, 12635,
   12639, 12643, 12647, 12651, 12655, 12659, 12663, 12667, 12671, 12675,
   12679, 12683, 12687, 12691, 12695, 12699, 12703, 12707, 12711, 12715,
   12719, 12723, 12727, 12731, 12735, 12739, 12743, 12747, 12751, 12755,
   12759, 12763, 12767, 12771, 12775, 12779, 12783, 12787, 12791, 12795,
   12799, 12803, 12807, 12811, 12815, 12819, 12823, 12827, 12831, 12835,
   12839, 12843, 12847, 12851, 12855, 12859, 12863, 12867, 12877, 12878,
   12881, 12882, 12883, 12889, 12890, 12891, 12892, 12893, 12906, 12906,
   12915, 12930, 12932, 12935, 12937, 12941, 12953, 12969, 12973, 12984,
   12985, 12988, 13000, 13009, 13010, 13013, 13014, 13015, 13018, 13019,
   13022, 13023, 13026, 13027, 13030, 13032, 13034, 13036, 13040, 13047,
   13054, 13070, 13104, 13114, 13117, 13121, 13134, 13135, 13137, 13139,
   13143, 13157, 13164, 13225, 13234, 13236, 13237, 13240, 13242, 13243,
   13246, 13247, 13248, 13249, 13250, 13257, 13256, 13266, 13268, 13270,
   13271, 13274, 13275, 13276, 13277, 13280, 13281, 13285, 13284, 13301,
   13299, 13315, 13314, 13328, 13334, 13335, 13338, 13340, 13341, 13344,
   13345, 13346, 13347, 13350, 13351, 13354, 13362, 13379, 13387, 13410,
   13516, 13550, 13552, 13554, 13558, 13562, 13561, 13612, 13614, 13613,
   13628, 13634, 13641, 13646, 13652, 13653, 13656, 13657, 13658, 13659,
   13660, 13661, 13662, 13670, 13678, 13681, 13682, 13683, 13684, 13685,
   13686, 13694, 13702, 13703, 13704, 13707, 13708, 13711, 13713, 13722,
   13810, 13811, 13818, 13819, 13820, 13826, 13835, 13838, 13839, 13840,
   13841, 13844, 13845, 13846, 13849, 13851, 13859, 13860, 13866, 13874,
   13875, 13878, 13879, 13882, 13887, 13894, 13899, 13906, 13913, 13913,
   13915, 13922, 13923, 13926, 13927, 13928, 13929, 13930, 13931, 13932,
   13933, 13934, 13940, 13947, 13959, 13965, 13972, 13980, 13981, 13993,
   14004, 14015, 14019, 14020, 14023, 14028, 14032, 14033, 14036, 14042,
   14050, 14056, 14063, 14067, 14068, 14071, 14074, 14078, 14079, 14082,
   14088, 14097, 14102, 14112, 14122, 14134, 14135, 14136, 14137, 14138,
   14139, 14140, 14141, 14142, 14143, 14144, 14145, 14146, 14147, 14148,
   14155, 14156, 14159, 14160, 14167, 14168, 14169, 14176, 14175, 14192,
   14193, 14200, 14199, 14269, 14275, 14281, 14289, 14295, 14301, 14307,
   14313, 14319, 14325, 14331, 14337, 14348, 14349, 14352, 14353, 14354,
   14355, 14356, 14357, 14358, 14359, 14360, 14361, 14362, 14363, 14364,
   14365, 14366, 14367, 14368, 14369, 14370, 14371, 14372, 14373, 14374,
   14375, 14378, 14379, 14380, 14381, 14382, 14383, 14387, 14388, 14389,
   14390, 14391, 14392, 14393, 14396, 14399, 14400, 14401, 14402, 14403,
   14404, 14405, 14406, 14419, 14420, 14421, 14422, 14423, 14424, 14425,
   14430, 14431, 14432, 14433, 14434, 14435, 14441, 14442, 14443, 14444,
   14445, 14446, 14447, 14448, 14449, 14450, 14451, 14454, 14455, 14456,
   14457, 14458, 14461, 14462, 14463, 14464, 14467, 14468, 14469, 14470,
   14471, 14472, 14473, 14490, 14491, 14492, 14495, 14496, 14497, 14498,
   14499, 14500, 14504, 14504, 14507, 14513, 14514, 14517, 14519, 14524,
   14534, 14545, 14552, 14553, 14554, 14557, 14590, 14592, 14594, 14597,
   14607, 14617, 14627, 14628, 14631, 14633, 14634, 14635, 14638, 14640,
   14648, 14649, 14650, 14654, 14655, 14659, 14660, 14663, 14664, 14667,
   14668, 14669, 14670, 14671, 14674, 14675, 14676, 14677, 14678, 14679,
   14680, 14681, 14682, 14683, 14684, 14685, 14686, 14687, 14688, 14689,
   14690, 14691, 14692, 14693, 14694, 14695, 14696, 14697, 14698, 14699,
   14700, 14701, 14702, 14703, 14704, 14705, 14706, 14707, 14708, 14709,
   14710, 14711, 14712, 14713, 14714, 14715, 14716, 14717, 14718, 14719,
   14720, 14721, 14722, 14723, 14724, 14725, 14726, 14727, 14728, 14729,
   14732, 14733, 14734, 14735, 14738, 14739, 14740, 14741, 14742, 14743,
   14744, 14745, 14746, 14749, 14750, 14751, 14752, 14753, 14756, 14757,
   14760, 14761, 14772, 14773
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT",
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT",
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE",
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR",
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO",
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER",
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN",
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH",
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT",
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT",
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED",
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO",
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN",
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL",
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB",
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP",
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST",
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST",
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION",
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS",
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION",
  "ASSIGNMENT", "ASYMMETRIC", "AT", "ATTRIBUTE", "AUTHORIZATION",
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT",
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASCADED",
  "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER",
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER",
  "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMENT", "COMMENTS",
  "COMMIT", "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION",
  "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P",
  "COPY", "COST", "CREATE", "CROSS", "CSV", "CURRENT_P", "CURRENT_CATALOG",
  "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME",
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA_P",
  "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE",
  "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P",
  "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD",
  "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH",
  "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE",
  "EVENT", "EXCEPT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE",
  "EXISTS", "EXPLAIN", "EXTENSION", "EXTERNAL", "EXTRACT", "FALSE_P",
  "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE",
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "FUNCTIONS",
  "GLOBAL", "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING",
  "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE",
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX",
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INLINE_P", "INNER_P",
  "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P",
  "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL",
  "ISOLATION", "JOIN", "KEY", "LABEL", "LANGUAGE", "LARGE_P", "LAST_P",
  "LATERAL_P", "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAKPROOF",
  "LEAST", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL",
  "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "MAPPING", "MATCH",
  "MATERIALIZED", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", "MONTH_P",
  "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO",
  "NONE", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P",
  "NULLIF", "NULLS_P", "NUMERIC", "OBJECT_P", "OF", "OFF", "OFFSET",
  "OIDS", "ON", "ONLY", "OPERATOR", "OPTION", "OPTIONS", "OR", "ORDER",
  "OUT_P", "OUTER_P", "OVER", "OVERLAPS", "OVERLAY", "OWNED", "OWNER",
  "PARSER", "PARTIAL", "PARTITION", "PASSING", "PASSWORD", "PLACING",
  "PLANS", "POSITION", "PRECEDING", "PRECISION", "PRESERVE", "PREPARE",
  "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE",
  "PROGRAM", "QUOTE", "RANGE", "READ", "REAL", "REASSIGN", "RECHECK",
  "RECURSIVE", "REF", "REFERENCES", "REFRESH", "REINDEX", "RELATIVE_P",
  "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", "RESET",
  "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROLE",
  "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", "SCHEMA", "SCROLL",
  "SEARCH", "SECOND_P", "SECURITY", "SELECT", "SEQUENCE", "SEQUENCES",
  "SERIALIZABLE", "SERVER", "SESSION", "SESSION_USER", "SET", "SETOF",
  "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SNAPSHOT", "SOME",
  "STABLE", "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN",
  "STDOUT", "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SYMMETRIC",
  "SYSID", "SYSTEM_P", "TABLE", "TABLES", "TABLESPACE", "TEMP", "TEMPLATE",
  "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING",
  "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE",
  "TRUSTED", "TYPE_P", "TYPES_P", "UNBOUNDED", "UNCOMMITTED",
  "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", "UNLOGGED",
  "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATE",
  "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR", "VARIADIC", "VARYING",
  "VERBOSE", "VERSION_P", "VIEW", "VOLATILE", "WHEN", "WHERE",
  "WHITESPACE_P", "WINDOW", "WITH", "WITHOUT", "WORK", "WRAPPER", "WRITE",
  "XML_P", "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLEXISTS",
  "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P",
  "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_TIME", "'='", "'<'",
  "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'", "'^'", "UMINUS",
  "'['", "']'", "'('", "')'", "'.'", "','", "';'", "':'", "'{'", "'}'",
  "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with", "OptRoleList",
  "AlterOptRoleList", "AlterOptRoleElem", "CreateOptRoleElem",
  "CreateUserStmt", "AlterRoleStmt", "opt_in_database", "AlterRoleSetStmt",
  "AlterUserStmt", "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt",
  "CreateGroupStmt", "AlterGroupStmt", "add_drop", "DropGroupStmt",
  "CreateSchemaStmt", "OptSchemaName", "OptSchemaEltList", "schema_stmt",
  "VariableSetStmt", "set_rest", "set_rest_more", "var_name", "var_list",
  "var_value", "iso_level", "opt_boolean_or_string", "zone_value",
  "opt_encoding", "NonReservedWord_or_Sconst", "VariableResetStmt",
  "SetResetClause", "FunctionSetResetClause", "VariableShowStmt",
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode",
  "CheckPointStmt", "DiscardStmt", "AlterTableStmt", "alter_table_cmds",
  "alter_table_cmd", "alter_column_default", "opt_drop_behavior",
  "opt_collate_clause", "alter_using", "reloptions", "opt_reloptions",
  "reloption_list", "reloption_elem", "AlterCompositeTypeStmt",
  "alter_type_cmds", "alter_type_cmd", "ClosePortalStmt", "CopyStmt",
  "copy_from", "opt_program", "copy_file_name", "copy_options",
  "copy_opt_list", "copy_opt_item", "opt_binary", "opt_oids",
  "copy_delimiter", "opt_using", "copy_generic_opt_list",
  "copy_generic_opt_elem", "copy_generic_opt_arg",
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item",
  "CreateStmt", "OptTemp", "OptTableElementList",
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList",
  "TableElement", "TypedTableElement", "columnDef", "columnOptions",
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr",
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption",
  "TableConstraint", "ConstraintElem", "opt_no_inherit", "opt_column_list",
  "columnList", "columnElem", "key_match", "ExclusionConstraintList",
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions",
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith",
  "OnCommitOption", "OptTableSpace", "OptConsTableSpace", "ExistingIndex",
  "create_as_target", "opt_with_data", "CreateMatViewStmt",
  "create_mv_target", "OptNoLog", "RefreshMatViewStmt", "CreateSeqStmt",
  "AlterSeqStmt", "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by",
  "NumericOnly", "NumericOnly_list", "CreatePLangStmt", "opt_trusted",
  "handler_name", "opt_inline_handler", "validator_clause",
  "opt_validator", "DropPLangStmt", "opt_procedural",
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt",
  "CreateExtensionStmt", "create_extension_opt_list",
  "create_extension_opt_item", "AlterExtensionStmt",
  "alter_extension_opt_list", "alter_extension_opt_item",
  "AlterExtensionContentsStmt", "CreateFdwStmt", "fdw_option",
  "fdw_options", "opt_fdw_options", "DropFdwStmt", "AlterFdwStmt",
  "create_generic_options", "generic_option_list", "alter_generic_options",
  "alter_generic_option_list", "alter_generic_option_elem",
  "generic_option_elem", "generic_option_name", "generic_option_arg",
  "CreateForeignServerStmt", "opt_type", "foreign_server_version",
  "opt_foreign_server_version", "DropForeignServerStmt",
  "AlterForeignServerStmt", "CreateForeignTableStmt",
  "AlterForeignTableStmt", "CreateUserMappingStmt", "auth_ident",
  "DropUserMappingStmt", "AlterUserMappingStmt", "CreateTrigStmt",
  "TriggerActionTime", "TriggerEvents", "TriggerOneEvent",
  "TriggerForSpec", "TriggerForOptEach", "TriggerForType", "TriggerWhen",
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable",
  "ConstraintAttributeSpec", "ConstraintAttributeElem", "DropTrigStmt",
  "CreateEventTrigStmt", "event_trigger_when_list",
  "event_trigger_when_item", "event_trigger_value_list",
  "AlterEventTrigStmt", "enable_trigger", "CreateAssertStmt",
  "DropAssertStmt", "DefineStmt", "definition", "def_list", "def_elem",
  "def_arg", "aggr_args", "old_aggr_definition", "old_aggr_list",
  "old_aggr_elem", "opt_enum_val_list", "enum_val_list", "AlterEnumStmt",
  "opt_if_not_exists", "CreateOpClassStmt", "opclass_item_list",
  "opclass_item", "opt_default", "opt_opfamily", "opclass_purpose",
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt",
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt",
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt",
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt",
  "opt_restart_seqs", "CommentStmt", "comment_type", "comment_text",
  "SecLabelStmt", "opt_provider", "security_label_type", "security_label",
  "FetchStmt", "fetch_args", "from_in", "opt_from_in", "GrantStmt",
  "RevokeStmt", "privileges", "privilege_list", "privilege",
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option",
  "function_with_argtypes_list", "function_with_argtypes", "GrantRoleStmt",
  "RevokeRoleStmt", "opt_grant_admin_option", "opt_granted_by",
  "AlterDefaultPrivilegesStmt", "DefACLOptionList", "DefACLOption",
  "DefACLAction", "defacl_privilege_target", "IndexStmt", "opt_unique",
  "opt_concurrently", "opt_index_name", "access_method_clause",
  "index_params", "index_elem", "opt_collate", "opt_class", "opt_asc_desc",
  "opt_nulls_order", "CreateFunctionStmt", "opt_or_replace", "func_args",
  "func_args_list", "func_args_with_defaults",
  "func_args_with_defaults_list", "func_arg", "arg_class", "param_name",
  "func_return", "func_type", "func_arg_with_default",
  "createfunc_opt_list", "common_func_opt_item", "createfunc_opt_item",
  "func_as", "opt_definition", "table_func_column",
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list",
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt",
  "oper_argtypes", "any_operator", "DoStmt", "dostmt_opt_list",
  "dostmt_opt_item", "CreateCastStmt", "cast_context", "DropCastStmt",
  "opt_if_exists", "ReindexStmt", "reindex_type", "opt_force",
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt",
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti",
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead",
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt",
  "UnlistenStmt", "TransactionStmt", "opt_transaction",
  "transaction_mode_item", "transaction_mode_list",
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option",
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item",
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt",
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", "CreateDomainStmt",
  "AlterDomainStmt", "opt_as", "AlterTSDictionaryStmt",
  "AlterTSConfigurationStmt", "CreateConversionStmt", "ClusterStmt",
  "cluster_index_specification", "VacuumStmt", "vacuum_option_list",
  "vacuum_option_elem", "AnalyzeStmt", "analyze_keyword", "opt_verbose",
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt",
  "ExplainableStmt", "explain_option_list", "explain_option_elem",
  "explain_option_name", "explain_option_arg", "PrepareStmt",
  "prep_type_clause", "PreparableStmt", "ExecuteStmt",
  "execute_param_clause", "InsertStmt", "insert_rest",
  "insert_column_list", "insert_column_item", "returning_clause",
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type",
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause",
  "single_set_clause", "multiple_set_clause", "set_target",
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options",
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens",
  "select_clause", "simple_select", "with_clause", "cte_list",
  "common_table_expr", "opt_with_clause", "into_clause",
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct",
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby",
  "select_limit", "opt_select_limit", "limit_clause", "offset_clause",
  "select_limit_value", "select_offset_value",
  "opt_select_fetch_first_value", "select_offset_value2", "row_or_rows",
  "first_or_next", "group_clause", "having_clause", "for_locking_clause",
  "opt_for_locking_clause", "for_locking_items", "for_locking_item",
  "for_locking_strength", "locked_rels_list", "values_clause",
  "from_clause", "from_list", "table_ref", "joined_table", "alias_clause",
  "opt_alias_clause", "func_alias_clause", "join_type", "join_outer",
  "join_qual", "relation_expr", "relation_expr_list",
  "relation_expr_opt_alias", "func_table", "where_clause",
  "where_or_current_clause", "OptTableFuncElementList",
  "TableFuncElementList", "TableFuncElement", "Typename",
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType",
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit",
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter",
  "CharacterWithLength", "CharacterWithoutLength", "character",
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval",
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr",
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone",
  "xml_attributes", "xml_attribute_list", "xml_attribute_el",
  "document_or_content", "xml_whitespace_option", "xmlexists_argument",
  "window_clause", "window_definition_list", "window_definition",
  "over_clause", "window_specification", "opt_existing_window_name",
  "opt_partition_clause", "opt_frame_clause", "frame_extent",
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op",
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list",
  "func_arg_expr", "type_list", "array_expr", "array_expr_list",
  "extract_list", "extract_arg", "overlay_list", "overlay_placing",
  "position_list", "substr_list", "substr_from", "substr_for", "trim_list",
  "in_expr", "case_expr", "when_clause_list", "when_clause",
  "case_default", "case_arg", "columnref", "indirection_el", "indirection",
  "opt_indirection", "opt_asymmetric", "ctext_expr", "ctext_expr_list",
  "ctext_row", "target_list", "target_el", "qualified_name_list",
  "qualified_name", "name_list", "name", "database_name", "access_method",
  "attr_name", "index_name", "file_name", "func_name", "AexprConst",
  "Iconst", "RoleId", "role_list", "SignedIconst", "NonReservedWord",
  "unreserved_keyword", "col_name_keyword", "type_func_name_keyword",
  "reserved_keyword", "statements", "statement", "CreateAsStmt", "$@1",
  "at", "ECPGConnect", "connection_target", "opt_database_name",
  "db_prefix", "server", "opt_server", "server_name", "opt_port",
  "opt_connection_name", "opt_user", "ora_user", "user_name",
  "char_variable", "opt_options", "connect_options", "opt_opt_value",
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt",
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale",
  "ecpg_interval", "ECPGDeclaration", "$@2", "sql_startdeclare",
  "sql_enddeclare", "var_type_declarations", "vt_declarations",
  "variable_declarations", "type_declaration", "$@3", "var_declaration",
  "$@4", "$@5", "opt_bit_field", "storage_declaration", "storage_clause",
  "storage_modifier", "var_type", "enum_type", "enum_definition",
  "struct_union_type_with_symbol", "$@6", "struct_union_type", "$@7",
  "s_struct_union_symbol", "s_struct_union", "simple_type",
  "unsigned_type", "signed_type", "opt_signed", "variable_list",
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare",
  "ECPGDisconnect", "dis_name", "connection_object", "execstring",
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using",
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list",
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output",
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader",
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem",
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems",
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item",
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem",
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem",
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off",
  "ECPGSetConnection", "ECPGTypedef", "$@8", "opt_reference", "ECPGVar",
  "$@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames",
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId",
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon",
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval",
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind",
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param",
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident",
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term",
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest",
  "ecpg_into", "ecpg_fetch_into", "opt_ecpg_fetch_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,    61,    60,    62,   750,    43,
      45,    42,    47,    37,    94,   751,    91,    93,    40,    41,
      46,    44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   516,   517,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   519,   520,   520,
     521,   521,   522,   522,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   524,   524,   524,   524,   524,   524,   525,
     526,   527,   527,   528,   528,   529,   530,   531,   531,   532,
     532,   533,   534,   535,   535,   536,   536,   537,   537,   537,
     537,   538,   538,   539,   539,   540,   540,   540,   540,   540,
     540,   541,   541,   541,   542,   542,   542,   543,   543,   543,
     543,   543,   543,   543,   543,   543,   543,   543,   543,   543,
     543,   544,   544,   545,   545,   546,   546,   547,   547,   547,
     547,   548,   548,   548,   548,   549,   549,   549,   549,   549,
     549,   549,   550,   550,   550,   551,   551,   552,   552,   552,
     552,   552,   553,   553,   554,   554,   555,   555,   555,   555,
     555,   556,   557,   557,   558,   558,   559,   560,   560,   560,
     560,   561,   561,   561,   561,   561,   561,   561,   561,   561,
     561,   562,   562,   563,   563,   563,   563,   563,   563,   563,
     563,   563,   563,   563,   563,   563,   563,   563,   563,   563,
     563,   563,   563,   563,   563,   563,   563,   563,   563,   563,
     563,   563,   563,   563,   563,   563,   563,   563,   563,   563,
     563,   563,   563,   563,   563,   564,   564,   565,   565,   565,
     566,   566,   567,   567,   568,   569,   569,   570,   570,   571,
     571,   571,   571,   572,   573,   573,   574,   574,   574,   574,
     575,   575,   576,   576,   577,   577,   578,   578,   579,   579,
     579,   580,   580,   581,   581,   582,   582,   582,   582,   582,
     582,   582,   582,   582,   582,   582,   582,   582,   583,   583,
     584,   584,   585,   585,   586,   586,   587,   587,   588,   589,
     589,   589,   589,   589,   590,   590,   591,   592,   592,   592,
     592,   593,   593,   593,   593,   593,   593,   593,   593,   594,
     594,   595,   595,   596,   596,   597,   597,   598,   598,   598,
     599,   599,   600,   601,   602,   602,   603,   603,   603,   603,
     604,   604,   604,   604,   604,   604,   604,   605,   605,   605,
     605,   606,   607,   607,   607,   608,   608,   608,   608,   608,
     608,   609,   609,   610,   610,   610,   610,   610,   610,   610,
     611,   611,   612,   612,   613,   613,   614,   615,   615,   615,
     615,   616,   616,   617,   617,   618,   618,   619,   619,   619,
     619,   619,   620,   621,   622,   622,   622,   622,   622,   623,
     623,   624,   624,   624,   624,   625,   625,   625,   625,   626,
     626,   627,   627,   628,   629,   630,   630,   630,   631,   632,
     633,   633,   634,   635,   636,   636,   637,   637,   638,   638,
     639,   639,   639,   639,   639,   639,   639,   639,   639,   639,
     639,   639,   640,   640,   641,   641,   641,   642,   642,   643,
     643,   644,   644,   645,   645,   646,   646,   647,   647,   648,
     648,   649,   649,   650,   650,   651,   652,   652,   653,   653,
     654,   654,   655,   655,   656,   656,   656,   657,   658,   658,
     659,   660,   660,   660,   660,   660,   660,   660,   660,   660,
     660,   660,   660,   660,   660,   660,   660,   660,   660,   660,
     660,   660,   660,   660,   660,   661,   662,   662,   662,   662,
     663,   663,   664,   664,   665,   665,   666,   666,   667,   667,
     668,   668,   669,   670,   670,   671,   671,   671,   671,   672,
     673,   674,   675,   676,   676,   677,   677,   678,   678,   679,
     679,   680,   680,   680,   681,   681,   682,   682,   683,   684,
     684,   684,   685,   685,   686,   687,   687,   688,   688,   688,
     689,   689,   690,   690,   690,   690,   690,   691,   691,   692,
     692,   693,   693,   694,   694,   695,   695,   695,   696,   696,
     696,   696,   697,   697,   698,   698,   699,   699,   699,   699,
     699,   699,   700,   700,   701,   701,   702,   702,   703,   704,
     704,   705,   706,   706,   706,   706,   707,   708,   709,   709,
     709,   709,   709,   709,   709,   709,   709,   709,   709,   709,
     709,   709,   710,   711,   711,   712,   712,   713,   713,   713,
     713,   713,   714,   714,   715,   716,   716,   717,   718,   718,
     719,   719,   720,   720,   720,   721,   721,   722,   723,   723,
     724,   724,   724,   724,   724,   725,   725,   726,   726,   727,
     727,   727,   728,   728,   729,   730,   730,   731,   731,   732,
     732,   733,   733,   734,   734,   735,   736,   737,   737,   737,
     737,   738,   738,   738,   738,   738,   738,   738,   738,   738,
     738,   738,   738,   738,   738,   738,   738,   738,   739,   739,
     740,   740,   741,   741,   742,   743,   743,   743,   744,   744,
     744,   744,   744,   744,   744,   744,   744,   744,   744,   744,
     744,   745,   745,   745,   745,   745,   745,   745,   745,   745,
     745,   745,   745,   745,   745,   745,   745,   745,   745,   745,
     745,   745,   745,   745,   746,   746,   747,   747,   747,   747,
     747,   748,   748,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   750,   750,   751,   751,
     751,   751,   751,   751,   751,   751,   751,   751,   751,   752,
     752,   752,   752,   752,   752,   752,   752,   752,   752,   752,
     752,   752,   752,   753,   753,   754,   754,   755,   756,   756,
     757,   757,   757,   757,   757,   758,   758,   759,   759,   759,
     759,   760,   760,   760,   760,   760,   760,   760,   760,   760,
     760,   760,   760,   760,   760,   760,   760,   761,   761,   762,
     762,   763,   763,   764,   764,   765,   766,   767,   767,   768,
     768,   769,   769,   770,   771,   771,   772,   772,   772,   773,
     773,   773,   774,   774,   774,   774,   775,   776,   776,   777,
     777,   778,   778,   779,   779,   780,   780,   781,   781,   781,
     782,   782,   783,   783,   783,   784,   784,   784,   785,   785,
     785,   786,   786,   786,   787,   787,   788,   788,   789,   789,
     790,   790,   791,   791,   792,   792,   792,   792,   792,   793,
     793,   793,   793,   793,   794,   795,   796,   796,   796,   797,
     797,   797,   798,   798,   799,   799,   799,   799,   799,   799,
     799,   799,   799,   799,   799,   799,   799,   799,   799,   800,
     800,   800,   800,   801,   801,   802,   802,   803,   804,   804,
     805,   806,   806,   807,   807,   808,   808,   809,   809,   810,
     810,   811,   811,   811,   811,   812,   812,   813,   814,   814,
     815,   815,   816,   816,   816,   817,   817,   817,   818,   819,
     819,   820,   820,   820,   821,   821,   822,   822,   823,   823,
     823,   823,   823,   823,   823,   823,   823,   823,   823,   823,
     823,   823,   823,   823,   823,   823,   823,   823,   823,   823,
     823,   823,   823,   823,   823,   823,   823,   823,   823,   823,
     823,   823,   823,   823,   823,   823,   823,   823,   823,   823,
     823,   823,   823,   823,   823,   824,   824,   825,   825,   826,
     826,   826,   826,   826,   826,   826,   826,   826,   826,   826,
     826,   826,   826,   826,   826,   826,   826,   826,   826,   826,
     826,   826,   826,   827,   827,   827,   827,   827,   827,   827,
     827,   827,   827,   827,   827,   827,   827,   827,   827,   827,
     827,   827,   828,   829,   829,   829,   830,   830,   831,   831,
     831,   831,   831,   832,   832,   833,   833,   833,   833,   834,
     834,   834,   835,   835,   836,   837,   837,   838,   839,   839,
     840,   840,   840,   840,   840,   840,   840,   840,   840,   840,
     840,   840,   840,   840,   841,   841,   841,   842,   842,   842,
     842,   842,   843,   843,   843,   844,   844,   845,   845,   845,
     845,   846,   846,   846,   846,   847,   848,   849,   849,   850,
     850,   850,   850,   850,   850,   850,   850,   850,   850,   850,
     850,   850,   850,   850,   850,   851,   851,   852,   852,   853,
     854,   854,   855,   856,   856,   857,   858,   858,   858,   858,
     858,   858,   858,   859,   859,   860,   861,   861,   861,   861,
     861,   861,   862,   863,   863,   863,   864,   864,   865,   865,
     865,   865,   865,   866,   866,   867,   867,   867,   867,   868,
     868,   869,   869,   870,   870,   871,   871,   872,   872,   873,
     873,   874,   874,   874,   874,   875,   875,   875,   875,   875,
     875,   875,   875,   875,   876,   876,   877,   878,   878,   879,
     879,   879,   880,   880,   881,   881,   882,   882,   882,   882,
     883,   883,   884,   884,   885,   886,   886,   886,   887,   887,
     888,   889,   889,   890,   891,   891,   892,   893,   893,   894,
     894,   894,   894,   894,   894,   894,   894,   895,   895,   896,
     897,   897,   898,   898,   899,   900,   901,   902,   902,   903,
     904,   904,   905,   905,   905,   905,   905,   906,   906,   906,
     907,   907,   908,   908,   909,   909,   909,   909,   909,   909,
     909,   909,   910,   910,   911,   911,   911,   911,   911,   911,
     912,   912,   913,   913,   914,   915,   915,   916,   916,   916,
     917,   917,   917,   917,   917,   917,   917,   917,   917,   918,
     918,   919,   919,   919,   920,   920,   920,   920,   921,   921,
     922,   923,   923,   924,   924,   925,   925,   925,   925,   926,
     926,   927,   927,   927,   928,   928,   929,   929,   930,   931,
     931,   931,   932,   933,   933,   934,   934,   935,   935,   936,
     936,   937,   937,   938,   938,   939,   939,   940,   941,   941,
     941,   941,   942,   942,   943,   943,   944,   944,   945,   945,
     946,   946,   946,   946,   946,   946,   946,   947,   947,   947,
     947,   947,   947,   948,   948,   948,   948,   949,   949,   950,
     950,   950,   950,   950,   951,   951,   951,   951,   952,   952,
     953,   953,   954,   954,   954,   954,   955,   955,   956,   956,
     956,   957,   958,   958,   959,   959,   959,   960,   960,   961,
     961,   962,   963,   963,   963,   963,   963,   963,   964,   964,
     964,   965,   965,   965,   965,   965,   965,   965,   966,   966,
     966,   966,   967,   967,   968,   968,   969,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   970,   970,   971,
     971,   972,   972,   973,   974,   975,   975,   976,   976,   977,
     978,   979,   979,   979,   979,   979,   979,   980,   980,   981,
     981,   982,   982,   982,   982,   983,   984,   984,   984,   985,
     985,   985,   985,   985,   985,   985,   985,   985,   985,   985,
     985,   985,   985,   986,   986,   987,   987,   987,   987,   987,
     987,   987,   987,   987,   987,   987,   987,   987,   987,   987,
     987,   987,   987,   987,   987,   987,   987,   987,   987,   987,
     987,   987,   987,   987,   987,   987,   987,   987,   987,   987,
     987,   987,   987,   987,   987,   987,   987,   987,   987,   987,
     987,   987,   987,   987,   987,   987,   987,   987,   987,   987,
     987,   987,   987,   987,   988,   988,   988,   988,   988,   988,
     988,   988,   988,   988,   988,   988,   988,   988,   988,   988,
     988,   988,   988,   988,   988,   988,   989,   989,   989,   989,
     989,   989,   989,   989,   989,   989,   989,   989,   990,   990,
     990,   990,   990,   990,   990,   990,   990,   990,   990,   990,
     990,   990,   990,   990,   990,   990,   990,   990,   990,   990,
     990,   990,   990,   990,   990,   990,   990,   990,   990,   990,
     990,   990,   990,   990,   990,   990,   990,   990,   990,   990,
     990,   990,   990,   990,   990,   990,   990,   990,   991,   991,
     992,   992,   992,   992,   993,   994,   994,   995,   995,   996,
     996,   997,   997,   997,   998,   998,   998,   998,   999,   999,
    1000,  1000,  1001,  1002,  1002,  1002,  1003,  1004,  1004,  1005,
    1005,  1006,  1006,  1006,  1007,  1007,  1008,  1008,  1008,  1008,
    1008,  1009,  1009,  1009,  1010,  1010,  1010,  1011,  1011,  1012,
    1012,  1012,  1012,  1012,  1012,  1012,  1012,  1012,  1013,  1013,
    1014,  1014,  1015,  1015,  1015,  1015,  1015,  1015,  1016,  1016,
    1017,  1017,  1018,  1018,  1019,  1019,  1020,  1020,  1020,  1021,
    1021,  1022,  1022,  1023,  1023,  1023,  1023,  1023,  1023,  1023,
    1023,  1024,  1024,  1025,  1026,  1026,  1027,  1027,  1027,  1027,
    1027,  1027,  1028,  1029,  1030,  1030,  1030,  1031,  1031,  1032,
    1033,  1033,  1034,  1035,  1035,  1036,  1036,  1037,  1037,  1038,
    1038,  1038,  1038,  1039,  1039,  1040,  1040,  1041,  1041,  1042,
    1042,  1043,  1043,  1044,  1045,  1045,  1046,  1046,  1046,  1046,
    1047,  1047,  1048,  1048,  1049,  1049,  1050,  1051,  1052,  1053,
    1054,  1055,  1056,  1056,  1057,  1057,  1057,  1057,  1057,  1057,
    1057,  1057,  1057,  1057,  1057,  1057,  1057,  1057,  1057,  1058,
    1059,  1060,  1060,  1061,  1061,  1061,  1061,  1062,  1062,  1062,
    1062,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1064,  1064,  1064,  1064,
    1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,
    1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,
    1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,
    1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,
    1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,
    1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,
    1065,  1065,  1065,  1066,  1066,  1066,  1066,  1066,  1066,  1066,
    1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,
    1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,
    1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,
    1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,
    1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,
    1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,
    1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,  1067,  1067,
    1068,  1068,  1068,  1068,  1068,  1068,  1068,  1068,  1070,  1069,
    1071,  1072,  1072,  1072,  1072,  1073,  1073,  1073,  1073,  1074,
    1074,  1075,  1076,  1077,  1077,  1078,  1078,  1078,  1079,  1079,
    1080,  1080,  1081,  1081,  1082,  1082,  1082,  1082,  1083,  1083,
    1083,  1084,  1085,  1085,  1086,  1086,  1087,  1087,  1087,  1087,
    1088,  1088,  1089,  1090,  1091,  1092,  1092,  1093,  1094,  1094,
    1095,  1095,  1095,  1095,  1095,  1097,  1096,  1098,  1099,  1100,
    1100,  1101,  1101,  1101,  1101,  1102,  1102,  1104,  1103,  1106,
    1105,  1107,  1105,  1105,  1108,  1108,  1109,  1109,  1109,  1110,
    1110,  1110,  1110,  1111,  1111,  1112,  1112,  1112,  1112,  1112,
    1112,  1113,  1113,  1113,  1114,  1116,  1115,  1117,  1118,  1117,
    1119,  1119,  1120,  1120,  1121,  1121,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1123,  1123,  1123,  1123,  1123,
    1123,  1123,  1123,  1123,  1123,  1124,  1124,  1125,  1125,  1126,
    1127,  1127,  1128,  1128,  1128,  1129,  1130,  1131,  1131,  1131,
    1131,  1132,  1132,  1132,  1133,  1133,  1134,  1134,  1135,  1136,
    1136,  1137,  1137,  1138,  1138,  1139,  1139,  1140,  1141,  1141,
    1142,  1142,  1142,  1143,  1143,  1143,  1143,  1143,  1143,  1143,
    1143,  1143,  1144,  1144,  1144,  1144,  1144,  1145,  1145,  1146,
    1147,  1148,  1149,  1149,  1150,  1151,  1152,  1152,  1153,  1154,
    1154,  1155,  1156,  1157,  1157,  1158,  1159,  1160,  1160,  1161,
    1162,  1162,  1162,  1162,  1162,  1163,  1163,  1163,  1163,  1163,
    1163,  1163,  1163,  1163,  1163,  1163,  1163,  1163,  1163,  1163,
    1164,  1164,  1165,  1165,  1166,  1166,  1166,  1168,  1167,  1169,
    1169,  1171,  1170,  1172,  1172,  1172,  1173,  1173,  1173,  1173,
    1173,  1173,  1173,  1173,  1173,  1174,  1174,  1175,  1175,  1175,
    1175,  1175,  1175,  1175,  1175,  1175,  1175,  1175,  1175,  1175,
    1175,  1175,  1175,  1175,  1175,  1175,  1175,  1175,  1175,  1175,
    1175,  1176,  1176,  1176,  1176,  1176,  1176,  1177,  1177,  1177,
    1177,  1177,  1177,  1177,  1178,  1179,  1179,  1179,  1179,  1179,
    1179,  1179,  1179,  1180,  1180,  1180,  1180,  1180,  1180,  1180,
    1181,  1181,  1181,  1181,  1181,  1181,  1182,  1182,  1182,  1182,
    1182,  1182,  1182,  1182,  1182,  1182,  1182,  1183,  1183,  1183,
    1183,  1183,  1184,  1184,  1184,  1184,  1185,  1185,  1185,  1185,
    1185,  1185,  1185,  1186,  1186,  1186,  1187,  1187,  1187,  1187,
    1187,  1187,  1188,  1188,  1189,  1190,  1190,  1191,  1191,  1192,
    1193,  1194,  1195,  1195,  1195,  1196,  1197,  1198,  1199,  1200,
    1200,  1200,  1200,  1200,  1201,  1202,  1202,  1202,  1203,  1203,
    1204,  1204,  1204,  1205,  1205,  1206,  1206,  1207,  1207,  1208,
    1208,  1208,  1208,  1208,  1209,  1209,  1209,  1209,  1209,  1209,
    1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,
    1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,
    1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,
    1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,
    1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,
    1210,  1210,  1210,  1210,  1211,  1211,  1211,  1211,  1211,  1211,
    1211,  1211,  1211,  1212,  1212,  1212,  1212,  1212,  1213,  1213,
    1214,  1214,  1215,  1215
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     5,     1,     0,
       2,     0,     2,     0,     2,     2,     3,     3,     1,     3,
       3,     2,     1,     1,     2,     2,     2,     3,     3,     5,
       5,     0,     3,     5,     5,     5,     4,     3,     5,     3,
       5,     5,     6,     1,     1,     3,     5,     6,     4,     9,
       7,     1,     0,     2,     0,     1,     1,     1,     1,     1,
       1,     2,     3,     3,     2,     5,     1,     3,     3,     3,
       3,     3,     3,     2,     2,     2,     2,     3,     3,     3,
       3,     1,     3,     1,     3,     1,     1,     2,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     3,     6,     1,
       1,     1,     1,     1,     0,     1,     1,     2,     3,     4,
       3,     2,     2,     1,     2,     1,     3,     4,     5,     4,
       2,     4,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     4,     6,     4,     6,     4,     6,     4,     6,     5,
       7,     1,     3,     2,     3,     4,     6,     6,     6,     5,
       5,     6,     6,     4,     8,     4,     2,     3,     6,     4,
       3,     3,     3,     3,     3,     4,     4,     3,     3,     3,
       3,     3,     3,     4,     4,     3,     2,     3,     2,     2,
       3,     3,     2,     2,     1,     3,     2,     1,     1,     0,
       2,     0,     2,     0,     3,     2,     0,     1,     3,     3,
       1,     5,     3,     4,     1,     3,     4,     6,     4,     8,
       2,     2,    11,     7,     1,     1,     1,     0,     1,     1,
       1,     1,     3,     2,     0,     1,     1,     1,     3,     3,
       1,     1,     3,     3,     3,     3,     4,     2,     1,     0,
       2,     0,     3,     0,     1,     0,     1,     3,     2,     1,
       1,     1,     3,     0,     1,     3,     1,    11,    14,    10,
      13,     1,     1,     2,     2,     2,     2,     1,     0,     1,
       0,     3,     0,     1,     3,     1,     3,     1,     1,     1,
       1,     1,     4,     4,     2,     0,     3,     1,     1,     2,
       2,     1,     3,     4,     5,     2,     5,     1,     2,     2,
       2,     3,     3,     3,     0,     1,     1,     1,     1,     1,
       1,     3,     1,     5,     7,     3,     8,     4,     9,    11,
       2,     0,     3,     0,     1,     3,     1,     2,     2,     2,
       0,     1,     3,     3,     6,     4,     0,     1,     1,     2,
       2,     0,     3,     3,     2,     1,     1,     2,     2,     4,
       0,     2,     2,     2,     0,     3,     4,     4,     0,     2,
       0,     4,     0,     3,     5,     2,     3,     0,     8,     4,
       1,     0,     5,     5,     4,     6,     1,     0,     1,     2,
       2,     1,     2,     3,     2,     2,     2,     2,     3,     3,
       1,     3,     1,     0,     1,     2,     1,     1,     3,     6,
      10,     1,     0,     1,     2,     2,     0,     2,     2,     1,
       0,     5,     7,     1,     0,     6,     2,     0,     3,     5,
       5,     8,     2,     0,     2,     2,     2,     5,     2,     0,
       2,     7,    10,     6,     6,     6,     6,     7,     7,     9,
       9,     6,     7,     6,     8,     8,     8,     8,     6,     6,
       7,     7,     8,     6,     6,     7,     2,     2,     2,     2,
       1,     2,     1,     0,     6,     8,     7,     6,     4,     0,
       1,     3,     4,     1,     3,     1,     2,     2,     2,     2,
       1,     1,    10,     2,     0,     2,     2,     1,     0,     4,
       6,     5,     4,     4,    10,    13,     5,     7,     8,     1,
       1,     1,     7,     9,     8,    15,    20,     1,     1,     2,
       1,     3,     1,     1,     1,     3,     1,     3,     0,     1,
       0,     1,     1,     4,     0,     1,     3,     0,     1,     1,
       1,     1,     2,     0,     0,     2,     2,     1,     2,     2,
       2,     2,     6,     8,    11,    13,     1,     3,     5,     1,
       3,     5,     1,     2,     2,     1,     8,     4,     5,     4,
       4,     4,     3,     7,     8,     6,     6,     6,     6,     6,
       4,     5,     3,     1,     3,     3,     1,     1,     1,     1,
       1,     1,     3,     3,     3,     1,     3,     3,     1,     0,
       1,     3,     7,     9,     9,     3,     0,    13,     1,     3,
       5,     6,     4,     7,     2,     1,     0,     2,     0,     2,
       4,     0,     1,     0,     6,     8,     8,     1,     3,     5,
       5,     7,     9,     7,     9,     5,     6,     6,     4,     5,
       7,     1,     1,     1,     2,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     3,     3,     3,     3,     1,     3,
       1,     2,     2,     3,     5,     2,     2,     0,     6,     7,
       7,     7,     8,     8,     6,     8,     9,     9,     7,    10,
       7,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     1,     2,     1,     3,     2,
       3,     3,     3,     3,     1,     1,     8,     9,     9,     9,
       9,     2,     0,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     2,     2,
       3,     4,     5,     4,     5,     3,     4,     3,     4,     1,
       2,     3,     3,     3,     3,     4,     4,     3,     3,     4,
       4,     4,     4,     1,     1,     1,     0,     7,     7,    10,
       1,     1,     2,     4,     5,     1,     3,     2,     2,     2,
       2,     1,     2,     2,     4,     3,     2,     2,     2,     2,
       3,     2,     2,     2,     5,     5,     5,     1,     3,     1,
       2,     3,     0,     1,     3,     2,     6,     6,     9,     3,
       0,     3,     0,     5,     2,     0,     3,     3,     3,     7,
       7,    10,     1,     1,     1,     1,    14,     1,     0,     1,
       0,     1,     0,     2,     0,     1,     3,     5,     5,     7,
       2,     0,     1,     2,     0,     1,     1,     0,     1,     1,
       0,     9,    12,     7,     2,     0,     3,     2,     1,     3,
       3,     2,     1,     3,     3,     3,     2,     2,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     4,     5,     1,
       3,     3,     1,     2,     4,     5,     1,     1,     1,     1,
       3,     3,     2,     2,     1,     2,     2,     2,     1,     2,
       2,     1,     1,     1,     3,     2,     0,     2,     1,     3,
       5,     1,     2,     1,     0,     5,     7,     5,     7,     5,
       7,     3,     5,     5,     5,     1,     3,     2,     1,     2,
       1,     2,    11,    10,    10,     2,     2,     0,     9,     2,
       0,     4,     4,     4,     1,     1,     1,     0,     7,     6,
       6,     6,     6,     8,     8,     6,     6,     7,     9,     9,
       6,     6,     6,     8,     6,     8,     6,     8,     7,     9,
       6,     8,     7,     9,     8,    10,     9,    11,     8,     9,
      11,     8,     8,     7,     6,     6,     6,     5,     5,     8,
       8,     8,     8,     6,     9,     1,     0,     2,     0,     7,
       6,     6,     6,     6,     6,     7,     9,     9,     6,     8,
       8,     8,     8,     8,     6,     8,     6,     8,     7,     9,
       7,     9,     6,     7,     6,     6,     6,     6,     6,     7,
       7,     7,     9,     9,     6,     6,     6,     8,     8,     8,
       6,     7,    13,     1,     1,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     0,     6,     8,     3,     2,     0,     2,     2,     2,
       2,     3,     3,     2,     2,     2,     2,     3,     2,     5,
       4,     3,     3,     3,     1,     1,     0,     3,     2,     2,
       1,     2,     1,     3,     2,     1,     0,     9,    11,    11,
      13,     3,     4,     4,     0,     2,     5,     2,     0,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     4,     3,     3,     1,     0,     5,     6,     4,
       2,     0,     4,     3,     5,     6,     4,     6,     6,     5,
       7,     9,     6,     1,     0,     6,    11,    11,    11,    13,
       9,    11,    10,     4,     2,     5,     2,     0,     4,     5,
       5,     4,     6,     1,     3,     1,     1,     1,     1,     2,
       4,     1,     1,     1,     0,     1,     0,     1,     0,     3,
       0,     2,     4,     3,     5,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     2,     1,     1,     1,
       1,     0,     5,     4,     3,     0,     1,     1,     1,     1,
       4,     9,     3,     0,     6,     1,     4,     2,     1,     3,
       2,     3,     0,     7,     2,     0,     5,     3,     0,     2,
       2,     2,     3,     1,     3,     1,     2,     1,     0,     8,
       1,     3,     1,     1,     3,     5,     2,     1,     3,     7,
       1,     1,     0,     3,     2,     2,     2,     0,     2,     2,
       1,     1,     3,     3,     1,     2,     4,     4,     2,     3,
       5,     5,     1,     1,     9,     1,     2,     4,     4,     4,
       2,     3,     1,     3,     6,     1,     0,     2,     1,     0,
       3,     3,     4,     4,     4,     4,     3,     2,     1,     1,
       0,     1,     1,     0,     1,     5,     1,     0,     1,     0,
       3,     1,     3,     4,     3,     2,     2,     1,     1,     1,
       0,     2,     4,     5,     2,     3,     1,     1,     1,     1,
       3,     0,     1,     1,     1,     1,     1,     3,     0,     2,
       0,     1,     3,     1,     0,     1,     2,     3,     2,     4,
       2,     3,     2,     0,     2,     3,     2,     0,     1,     3,
       2,     2,     3,     2,     3,     1,     4,     3,     4,     5,
       4,     5,     4,     5,     2,     4,     1,     1,     0,     1,
       4,     5,     4,     0,     2,     2,     2,     1,     1,     0,
       4,     2,     1,     2,     2,     4,     1,     3,     1,     2,
       3,     1,     2,     0,     2,     4,     0,     1,     0,     1,
       3,     3,     2,     3,     5,     6,     2,     3,     3,     4,
       0,     1,     1,     1,     1,     1,     2,     5,     1,     1,
       1,     1,     2,     3,     3,     0,     1,     1,     1,     1,
       1,     2,     2,     2,     2,     2,     1,     3,     0,     1,
       1,     1,     1,     5,     2,     1,     1,     1,     1,     5,
       2,     2,     2,     1,     3,     3,     2,     1,     0,     3,
       0,     5,     2,     5,     2,     1,     2,     3,     0,     1,
       1,     1,     1,     1,     1,     3,     3,     3,     3,     3,
       3,     3,     0,     1,     4,     1,     3,     3,     5,     2,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     2,     2,     3,     3,     2,     3,     5,     4,     6,
       3,     5,     4,     6,     4,     6,     5,     7,     3,     2,
       4,     2,     3,     3,     4,     3,     4,     3,     4,     5,
       6,     6,     7,     6,     7,     6,     7,     3,     4,     4,
       6,     2,     3,     4,     1,     3,     2,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     2,
       5,     6,     6,     7,     3,     4,     1,     1,     2,     4,
       1,     1,     1,     2,     2,     2,     2,     1,     4,     5,
       6,     8,     6,     7,     7,     5,     5,     1,     1,     4,
       1,     4,     1,     4,     1,     4,     1,     1,     1,     1,
       1,     1,     6,     4,     4,     4,     4,     6,     5,     5,
       5,     4,     6,     4,     4,     4,     4,     5,     7,     7,
       9,     5,     4,     6,     5,     7,     7,     7,     2,     3,
       3,     3,     4,     0,     4,     1,     3,     3,     1,     1,
       1,     2,     2,     0,     2,     4,     4,     6,     2,     0,
       1,     3,     3,     2,     2,     0,     6,     1,     0,     3,
       0,     2,     2,     0,     1,     4,     2,     2,     2,     2,
       2,     4,     3,     5,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       1,     4,     1,     4,     1,     2,     1,     2,     1,     3,
       1,     3,     1,     3,     1,     3,     3,     3,     2,     1,
       3,     3,     0,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     3,     2,     3,     0,     3,     3,     2,     2,
       1,     0,     2,     2,     3,     2,     1,     1,     3,     5,
       1,     2,     4,     2,     0,     1,     0,     1,     2,     2,
       2,     3,     5,     1,     2,     0,     2,     1,     0,     1,
       1,     1,     3,     3,     1,     3,     3,     2,     1,     1,
       1,     3,     1,     2,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     2,
       5,     2,     3,     6,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     2,
       4,     3,     2,     1,     1,     1,     1,     1,     0,     8,
       2,     5,     3,     2,     2,     3,     7,     1,     1,     1,
       0,     2,     2,     1,     0,     1,     3,     1,     2,     0,
       2,     0,     2,     0,     1,     3,     4,     3,     1,     1,
       1,     1,     2,     0,     2,     4,     0,     2,     2,     2,
       1,     1,     7,     3,     1,     1,     1,     1,     2,     0,
       1,     3,     3,     3,     3,     0,     4,     5,     5,     0,
       1,     1,     1,     2,     2,     1,     2,     0,     7,     0,
       5,     0,     4,     2,     2,     0,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     5,     2,
       1,     3,     2,     2,     3,     0,     5,     1,     0,     5,
       2,     2,     1,     1,     1,     2,     2,     3,     1,     2,
       2,     3,     3,     4,     2,     1,     2,     1,     1,     2,
       2,     3,     1,     1,     1,     1,     0,     1,     3,     5,
       0,     2,     0,     1,     2,     3,     2,     1,     1,     1,
       0,     1,     1,     1,     1,     1,     2,     2,     3,     0,
       1,     2,     1,     4,     3,     4,     3,     2,     1,     3,
       1,     1,     1,     1,     2,     2,     1,     2,     2,     1,
       1,     1,     4,     4,     4,     4,     4,     1,     0,     3,
       3,     4,     1,     3,     3,     4,     1,     3,     3,     1,
       1,     1,     6,     1,     3,     3,     6,     1,     3,     3,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       4,     4,     1,     1,     4,     4,     3,     0,     7,     1,
       0,     0,     7,     3,     4,     3,     1,     1,     1,     2,
       3,     5,     2,     5,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     0,     1,     2,     1,     2,
       1,     1,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     3,     1,     2,     1,     3,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     2,     3,     1,     3,     3,     3,     3,     3,
       3,     1,     1,     0,     2,     2,     1,     1,     2,     1,
       1,     1,     0,     1
};

/* YYDEFACT[STATE-NAME] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
    2318,     0,     2,     1,  2748,  2752,  2756,  2757,  2674,  2758,
    2759,  2724,  2725,  2726,  2727,  2728,  2729,  2730,  2731,  2732,
    2733,  2734,  2735,  2737,  2736,  2738,  2739,  2740,  2741,  2742,
    2743,  2744,  2745,  2747,  2746,  2696,  2325,  2693,  2690,  2691,
    2692,  2697,  2695,  2688,  2689,  1919,  2761,  2749,  2762,  2750,
    2751,  2753,  2754,  2723,  2755,  2763,  2764,  2765,  2760,  2768,
    2719,  2720,  2718,  2721,  2722,  2766,  2767,  2710,  2711,  2712,
    2713,  2769,  2326,  2327,  2715,  2319,  2323,  2385,  2456,  2716,
    2717,  2714,  2324,  2709,  2456,     0,  2577,  2578,  2579,     0,
    2580,  2581,  2582,  2508,  2470,  2583,     0,     0,  2584,  2585,
    2586,  2587,  2588,  2589,  2590,  2591,     0,  2592,  2593,  2594,
    2595,  2455,  2596,  2597,  2598,  2599,  2600,  2432,  2438,  2561,
       0,  2412,  2413,  2409,  2411,  2410,  2414,  2397,  1196,   544,
    1282,  1281,     0,  2220,  1196,  2176,  2177,  2221,  2178,  2179,
    2180,   256,     0,  1284,  2181,  2222,     0,  1196,  2223,   369,
     965,  2224,  2225,  2340,     0,  2182,  2183,     0,     0,     0,
     544,  1196,     0,     0,  2184,  1396,  2185,     0,  2186,  2226,
    2227,     0,  2187,  2228,  2229,  2188,  2189,  2190,  2230,  2231,
    2232,  2191,  2233,  2234,     0,     0,  1410,     0,  2192,  2235,
    2193,  2194,     0,  2236,  2195,  2196,  2197,  2237,  2238,  2239,
    2198,  2199,  2200,     0,  2201,     0,     0,     0,     0,     0,
       0,  2240,  1196,  2202,     0,     0,  1417,     0,  2203,     0,
    2241,  2204,     0,  2205,     0,  2206,  2207,  2208,  2209,  1410,
    2557,  2433,     0,  1286,     0,  2210,  2242,     0,  2211,  2212,
    2213,  2214,  2215,  2216,  2217,  2218,  2219,     0,     0,    57,
      58,    22,    21,    27,    26,    80,    81,    45,    15,    71,
      51,   114,   113,   115,    33,    29,    65,    19,    20,    30,
      34,    53,    46,    92,    52,    18,    50,    75,    54,    78,
      40,     9,    10,    41,    69,    11,    42,    70,    12,    43,
      13,    59,    82,    25,    55,    79,    56,     3,    36,    67,
      63,     8,    47,    48,    49,    72,    73,    74,    97,    77,
     109,    32,   106,    86,    87,   103,    88,   104,     6,    89,
      44,    14,   100,    99,   101,    66,    37,    68,    98,   102,
      16,    17,   105,    76,    95,    91,   110,   108,   116,    93,
      60,     4,     5,    83,    39,     7,    24,    23,    38,    31,
     112,    28,  1284,    85,    96,    84,    90,    64,    94,   111,
      62,   107,  1383,  1370,  1419,  1382,  1395,     0,  1385,  2653,
    2654,    35,  1396,   118,   119,   124,  2322,  2374,  2375,  2376,
    2456,  2407,  2408,  2401,  2417,  2427,  2416,  2420,  2428,  2415,
    2434,     0,   121,   123,   125,   128,   122,   117,   120,   127,
     132,   126,   131,   129,   130,   133,   134,   135,  2655,  1602,
    2652,    61,  2392,  2391,     0,  2456,     0,  2685,  1931,  1932,
    1933,  1934,  1935,  1936,  1937,  1938,  1939,  1940,  1941,  1942,
    1943,  1944,  1945,  1946,  1947,  1948,  1949,  1950,  1951,  1952,
    1953,  1954,  1955,  1956,  1957,  1958,  1959,  1960,  1961,  1962,
    1963,  1964,  1965,  1966,  1967,  1968,  1969,  1970,  1971,  1972,
    1973,  1974,  1975,  1976,  1977,  1978,  1979,  1980,  1981,  1982,
    1983,  1984,  1985,  1986,  1987,  1988,  1989,  1990,  1991,  1992,
    1993,  1994,  1995,  1996,  1997,  1998,  1999,  2000,  2001,  2002,
    2003,  2004,  2005,  2006,  2007,  2008,  2009,  2010,  2011,  2012,
    2013,  2014,  2015,  2016,  2017,  2018,  2019,  2020,  2021,  2022,
    2023,  2024,  2025,  2026,  2027,  2028,  2029,  2030,  2031,  2032,
    2033,  2034,  2035,  2036,  2037,  2038,  2039,  2040,  2041,  2042,
    2043,  2044,  2045,  2046,  2047,  2048,  2049,  2050,  2051,  2052,
    2053,  2054,  2055,  2056,  2057,  2058,  2059,  2060,  2061,  2062,
    2063,  2064,  2065,  2066,  2067,  2068,  2069,  2070,  2071,  2072,
    2073,  2074,  2075,  2076,  2077,  2078,  2079,  2082,  2080,  2081,
    2083,  2084,  2085,  2086,  2087,  2088,  2089,  2090,  2091,  2092,
    2093,  2094,  2095,  2096,  2097,  2098,  2099,  2100,  2101,  2102,
    2103,  2104,  2105,  2106,  2107,  2108,  2109,  2110,  2111,  2112,
    2113,  2114,  2115,  2116,  2117,  2118,  2119,  2120,  2121,  2122,
    2123,  2124,  2125,  2126,  2127,  2128,  2129,  2130,  2131,  2132,
    2133,  2134,  2135,  2136,  2137,  2138,  2139,  2140,  2141,  2142,
    2143,  2144,  2340,  2145,  2146,  2147,  2148,  2149,  2150,  2151,
    2152,  2153,  2154,  2155,  2156,  2157,  2158,  2159,  2160,  2161,
    2162,  2163,  2164,  2165,  2166,  2167,  2168,  2169,  2170,  2171,
    2172,  2173,  2174,  2175,  2358,  1920,  1928,  1929,  1930,  2333,
    2354,  2360,  2681,  2359,  1927,  2507,     0,     0,  2601,  2602,
    2603,  2604,  2605,  2606,  2656,  2657,  2658,  2659,  2660,  2662,
    2661,  2469,  2628,  2665,  2468,  2666,  2472,  2667,  2668,  2669,
    2670,  2629,  2671,  2471,  2663,  2625,  2473,  2466,  2467,  2626,
    2575,  2576,  1897,  2627,  2624,  2664,  2361,  2623,  2477,  2476,
    1360,  2680,  1896,  1361,     0,  2479,  2607,  2608,  2609,  2610,
    2612,  2611,  2613,  2243,  2244,  2245,  2246,  2247,  2248,  2249,
    2250,  2251,  2252,  2253,  2254,  2638,  2255,  2256,  2257,  2651,
    2258,  2259,  2639,  2260,  2261,  2262,  2263,  2264,  2265,  2266,
    2267,  2268,  2269,  2270,  2271,  2272,  2273,  2274,  2275,  2276,
    2277,  2278,  2279,  2280,  2281,  2282,  2283,  2640,  2641,  2284,
    2285,  2286,  2287,  2288,  2289,  2290,  2291,  2292,  2293,  2294,
    2295,  2296,  2297,  2298,  2299,  2300,  2301,  2302,  2303,  2304,
    2305,  2306,  2307,  2642,  2308,  2309,  2643,  2310,  2311,  2312,
    2644,  2313,  2314,  2315,  2316,  2317,  2648,  2649,  2650,  2637,
    2430,  2614,  2636,  2647,  2645,  2646,  2440,  2436,  2444,  2439,
       0,     0,     0,     0,  2456,  1195,  1194,  1180,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   543,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2330,     0,  1206,
     341,   340,  1283,  1264,   544,     0,  1183,   368,     0,     0,
       0,     0,     0,     0,     0,     0,   735,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   182,     0,     0,
     392,   391,     0,     0,     0,   937,   397,     0,     0,     0,
       0,     0,   532,  2339,  2334,  2344,     0,  2337,  2338,  2623,
       0,  2772,  2080,  2370,  2371,  2770,  2130,  1362,   257,   260,
     258,   259,     0,  1037,  1038,  1040,     0,     0,  1050,   770,
     771,     0,   769,     0,   773,     0,     0,     0,   765,     0,
       0,     0,     0,     0,   772,   762,     0,   761,     0,     0,
       0,   768,     0,   763,     0,     0,  1184,     0,  2422,  2423,
    2020,  1323,   398,     0,     0,  1396,     0,  1301,  1302,  1284,
    1291,  1303,  1296,  1298,  1297,  1299,  1295,  1300,  1932,   876,
    1946,   876,  2010,   873,   874,   876,   876,   876,  2097,     0,
       0,   848,     0,   859,  1923,   876,  1924,  2681,   881,   453,
     453,   453,     0,   880,   885,   453,  1177,  1215,  1901,  1409,
       0,  1946,  2010,   849,  1176,  2145,  1315,     0,     0,     0,
    1054,     0,  1055,     0,  2112,  1188,   241,  2621,  2121,  2206,
    2145,  2622,   237,  2616,  2617,  2619,   211,  2620,  2618,  2615,
    1936,     0,     0,   880,     0,  1185,  1186,   832,  1416,  1414,
       0,     0,     0,  1954,     0,  1966,  2046,   234,  2108,  2113,
    2121,  2206,  2145,  2173,   191,   196,     0,   250,  2121,  2206,
    2145,     0,  1206,     0,  1386,  1502,  1892,     0,     0,  2431,
    1179,  1178,  1285,     0,  1288,     0,  1464,  2093,  1390,  1392,
    1290,  1383,     0,     0,  2321,  1279,  1413,  1413,     0,  1413,
       0,  1375,  1383,  1378,  1382,     0,     0,     0,     0,  1196,
       0,  2399,  2427,  2406,  2462,  2403,     0,     0,  2452,  2448,
    2445,  2453,  2454,  2447,  2435,  1591,  1592,  1593,  1590,  1603,
    1589,     0,  2380,  1594,  2419,  2386,     0,  2394,  2393,  2698,
    2699,  2509,  2332,  2351,     0,     0,     0,     0,     0,     0,
       0,  2478,  2480,  2482,  2442,  2441,  2437,     0,     0,     0,
       0,  2567,  2568,  2566,     0,  2563,  2565,     0,  2462,     0,
    2632,  2626,  2635,     0,  1902,  2627,  2624,  2623,     0,   780,
       0,   139,   925,     0,     0,     0,     0,  1896,     0,     0,
       0,     0,     0,  2019,     0,     0,     0,  1797,  1958,  2006,
    1807,  1805,  1806,  1799,  1800,  1801,  1802,  1803,  1804,     0,
    1035,  1798,     0,   161,   139,     0,     0,  2019,     0,     0,
    2019,     0,     0,     0,     0,     0,  2049,   139,  2019,     0,
       0,     0,  1200,     0,     0,     0,  1202,  1205,  1181,  1267,
       0,  1892,     0,     0,   811,   801,     0,   812,   802,   807,
       0,   814,     0,     0,   804,     0,     0,     0,   815,     0,
     803,   805,   817,   806,   813,     0,     0,   808,   809,     0,
       0,  1192,   453,   347,     0,     0,     0,     0,     0,   139,
    1254,     0,  2019,   139,     0,     0,   396,   395,   139,   394,
     393,  1958,  2006,     0,   964,   139,  2019,     0,   184,   614,
     547,     0,     0,   692,  2049,   139,     0,     0,     0,     0,
       0,     0,   940,     0,     0,   531,   544,     0,  2343,  2349,
       0,  2341,  2510,  2773,  2771,  2465,     0,  1041,   235,   236,
    1039,  2019,     0,   319,     0,     0,  2019,  1243,   767,     0,
     766,  2019,     0,  2019,  1921,   175,     0,   764,  1958,  2006,
    2019,     0,     0,  2019,   167,  2019,     0,  2019,   319,  2019,
     548,     0,  2019,     0,  2019,  2049,   169,     0,  2019,   319,
     778,     0,     0,  2703,  2707,     0,  2705,  2700,  2421,  2475,
    2474,  2373,     0,  2783,     0,  1362,  1293,  1308,     0,  1304,
    1311,  1307,  1396,   876,   875,     0,   876,     0,  2792,   876,
       0,   876,     0,  2792,   876,     0,     0,     0,   876,  1925,
    1926,     0,     0,  2791,  2789,  2790,   850,   860,     0,   882,
       0,     0,   889,   888,   887,     0,     0,     0,   890,  1506,
    1338,     0,   857,     0,   855,     0,  1174,  1191,     0,     0,
       0,     0,     0,  1057,  1057,  1057,  1187,   240,   238,     0,
       0,     0,     0,     0,     0,  1193,     0,     0,     0,     0,
    2687,  1908,  1808,  2686,     0,  2177,  2178,  2179,  1866,     0,
    2628,  2180,  2181,  2222,  1720,  1707,  1716,  1721,  1708,  1710,
    1717,  2182,  2183,  1990,  2184,  2185,  1915,  2186,  2187,  1546,
    2189,  2190,  2191,  1712,  1714,  2192,  2193,     0,  1916,  2195,
    2196,  2068,  2198,  2199,  2201,  2202,  1718,  2204,  2205,  2206,
    2207,  2208,  2209,  1914,     0,  1719,  2210,  2212,  2213,  2214,
    2215,  2216,  2217,  2218,  2219,     0,     0,  1889,     0,  1692,
       0,  1538,  1539,  1561,  1562,  1540,  1567,  1568,  1580,  1541,
       0,  1888,  1605,  1691,  1697,     0,  1690,  1686,  1399,  1884,
       0,  1687,  1904,  1867,  1918,  1917,  2681,  1875,  1907,  1905,
    1906,     0,     0,     0,   203,     0,     0,  2556,   252,     0,
     253,  1890,  2121,   192,   233,   205,   232,   206,   204,     0,
    1956,   193,     0,     0,   194,     0,     0,     0,     0,     0,
       0,     0,   246,  1182,     0,  1504,  1503,     0,     0,  1873,
    1893,   787,     0,  1277,  1278,  1276,     0,  1273,  1275,  1287,
    1284,  1880,  1879,  1881,     0,  1391,     0,     0,     0,  1373,
    1372,  1290,  1411,  1412,     0,     0,     0,     0,     0,     0,
       0,     0,  1454,  1427,  1428,  1430,  1451,  1455,  1463,     0,
    1379,     0,     0,  1508,     0,  1465,  2320,  2462,  2463,     0,
    2457,     0,  2456,  2456,  2450,  2449,  2446,     0,     0,     0,
       0,     0,     0,     0,  2377,   526,  2379,   524,     0,     0,
    2353,     0,  2357,  2355,     0,  2502,  2505,     0,  2503,  2504,
    2506,     0,  2511,  2512,     0,     0,     0,  2694,     0,     0,
    2493,  2481,  2488,  2490,  2492,  2491,  2500,  2496,  2499,  2501,
    2443,  2456,  2574,     0,  2569,  2572,     0,  2564,     0,     0,
       0,  1903,     0,     0,     0,     0,   781,     0,     0,     0,
       0,     0,     0,   138,  1241,   243,  1239,     0,     0,     0,
       0,     0,     0,     0,  1246,     0,     0,   173,   174,   559,
     544,     0,  2019,     0,     0,     0,     0,   997,  1004,     0,
       0,     0,     0,     0,     0,     0,   998,   996,   999,   245,
    1008,  1021,  1024,     0,   915,     0,     0,     0,     0,  1106,
       0,     0,  1106,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   263,   271,   314,     0,  2019,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   143,     0,
       0,     0,     0,     0,     0,   511,   523,     0,     0,     0,
       0,     0,   520,     0,   139,   265,   504,   508,     0,     0,
       0,   623,   622,     0,  1106,     0,   261,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   333,   334,     0,     0,     0,   143,   166,     0,
       0,     0,   267,     0,  2387,     0,  1201,  1198,  1199,     0,
    1204,     0,  1263,     0,     0,     0,     0,   819,     0,   816,
       0,     0,   810,  1958,  2006,     0,     0,     0,     0,     0,
       0,   371,   346,     0,     0,     0,   689,     0,  1549,  1578,
    1556,  1578,  1578,  1545,  1545,  1558,  1547,  1585,     0,  1578,
    1545,  1550,     0,  1548,  1588,  1588,  1573,     0,  1530,  1531,
    1532,  1533,  1559,  1560,  1534,  1565,  1566,  1535,  1602,  2633,
    1545,  2634,  2631,  2630,     0,     0,   700,     0,  1218,  1253,
       0,     0,     0,   553,     0,  2019,     0,   141,   736,     0,
     690,   397,     0,   141,     0,     0,   178,     0,   618,     0,
       0,     0,     0,     0,     0,   638,   637,     0,     0,     0,
     691,     0,   141,     0,   507,  2019,     0,   453,   453,     0,
       0,   939,   942,     0,     0,     0,  2347,  2342,  2345,     0,
    2335,  2349,  1365,  1367,  1366,     0,  1364,     0,   319,   317,
     318,   687,  1049,     0,     0,     0,     0,   319,     0,     0,
    2019,   319,  2019,     0,  2019,     0,     0,   319,   319,     0,
       0,     0,     0,   619,     0,   777,   775,   774,   776,     0,
       0,     0,     0,     0,  2019,   319,     0,     0,   758,  2701,
       0,     0,  2704,     0,  2424,  1818,     0,  2786,  1320,  2787,
       0,     0,  1396,     0,   222,   223,   221,  1309,   224,  1310,
    1306,  1292,     0,   868,     0,  2792,  2793,   853,     0,   863,
       0,  2792,   851,     0,   864,   861,   862,     0,     0,     0,
    2788,  2672,  2678,   867,     0,     0,   454,   456,     0,     0,
    1976,  1989,     0,  2011,  2037,  2038,  2113,  2117,     0,  2140,
    2149,     0,   891,   920,   886,     0,     0,  1348,   858,   856,
    1175,  1313,  1824,     0,  1396,     0,   497,  1056,  1053,  1052,
    1051,   239,   212,     0,     0,     0,   922,  2112,  1190,   831,
     544,     0,     0,  1695,  1696,  1577,  1564,  1865,     0,     0,
    1572,  1571,     0,     0,     0,     0,     0,  1554,  1553,  1552,
    1694,  1832,     0,  1551,     0,     0,     0,     0,  1578,  1578,
    1576,  1625,     0,  1555,     0,     0,  1845,     0,  1851,     0,
       0,     0,  1584,     0,  1582,     0,     0,  1661,     0,     0,
       0,     0,     0,     0,     0,     0,  1609,  1610,  2629,  1692,
    1818,     0,  1693,  1911,     0,     0,  1570,     0,  1602,  1808,
       0,     0,     0,     0,  1878,     0,  1816,     0,     0,  1639,
    1814,     0,  1641,     0,     0,     0,  1807,  1805,  1806,  1799,
    1800,  1801,  1802,  1803,  1804,  1812,  1622,     0,  1887,     0,
    1621,     0,     0,  1467,  1398,     0,  1909,  1868,     0,  2679,
    2682,  1688,  2553,  2552,  2551,  2550,  2521,     0,  2515,  2516,
       0,  2554,  2555,   254,   255,   251,     0,     0,   208,   207,
       0,   230,   231,   202,   229,     0,   225,   226,   210,  1760,
    1759,   209,   201,   199,   197,   213,   215,   216,   200,   198,
     249,   247,     0,     0,     0,  1870,  1869,  1899,  1874,     0,
       0,   319,  2456,  1271,     0,  1268,  1883,     0,  1393,     0,
    1894,     0,  1280,  1389,  1388,  1420,  1421,   957,  1387,  1445,
    1446,  1441,     0,     0,     0,  1460,  1458,  1437,  1431,  1436,
    1434,     0,  1438,  1605,  1453,  1377,  1425,  1426,  1429,  1376,
       0,  1456,     0,  1348,  1454,  1430,  1335,     0,     0,  1509,
       0,     0,  2464,  2462,  2402,  1530,  2456,  2395,  2456,  2451,
    2383,  1596,  1597,  1598,  1599,  1600,  1601,  2384,     0,  2381,
    1595,  2382,   525,     0,     0,     0,  2350,     0,  2331,  2356,
    2487,  2596,  2519,     0,  2520,     0,     0,  2484,     0,  2494,
    2497,  2495,  2498,     0,  1530,  2675,  2570,  2675,  1530,     0,
       0,     0,     0,     0,     0,     0,     0,   782,     0,     0,
       0,     0,     0,     0,  2140,   242,  1237,     0,     0,     0,
       0,   924,   923,     0,     0,   944,     0,     0,     0,  1249,
     442,     0,   316,     0,     0,     0,     0,     0,     0,     0,
       0,   685,   682,     0,     0,   681,     0,   557,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   593,     0,  1106,     0,
     626,     0,  1006,     0,  1005,     0,     0,     0,  1007,  1002,
    1003,  2113,  2121,  2145,   244,  1023,     0,  1022,  1020,   979,
     981,   980,     0,   983,   967,     0,   968,     0,     0,   978,
     986,   984,     0,     0,     0,     0,  1999,   273,   286,     0,
    1105,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   306,     0,   309,   308,     0,     0,     0,     0,   313,
       0,     0,     0,   312,     0,     0,     0,     0,  1106,     0,
     269,     0,     0,     0,     0,     0,     0,  1036,     0,   164,
       0,   160,   163,     0,     0,     0,     0,   510,   522,     0,
     514,   515,   512,   516,   517,     0,     0,     0,     0,     0,
       0,   509,     0,     0,   616,   615,   621,     0,     0,     0,
       0,     0,     0,     0,  1098,  1097,     0,     0,     0,     0,
       0,     0,   726,     0,     0,     0,     0,     0,     0,     0,
     629,   630,     0,   631,     0,   165,     0,     0,     0,     0,
       0,     0,     0,   220,  1197,  1203,  1266,  1900,  1265,     0,
       0,     0,   818,     0,     0,     0,     0,     0,     0,     0,
     820,   821,   822,   823,     0,     0,     0,     0,     0,   349,
     350,   139,   348,     0,   715,  2630,   688,     0,  1530,     0,
    1526,  1522,  1591,  1590,  1589,     0,  1536,  1545,  1542,   701,
       0,   703,   706,     0,  1216,   415,     0,     0,   550,   593,
       0,   400,   171,     0,     0,     0,     0,   137,   182,   184,
     398,     0,   183,   185,   187,   188,   189,   186,   190,   613,
     617,     0,   546,     0,     0,     0,     0,     0,   639,   643,
     642,   646,   644,     0,   640,     0,     0,  1518,     0,   159,
       0,   503,   506,     0,  2328,     0,   400,   484,   326,     0,
     453,     0,     0,   941,     0,     0,     0,     0,     0,  2348,
       0,     0,     0,     0,  1363,     0,  1027,     0,  1244,  2019,
     319,     0,  1025,   176,  1922,     0,   759,     0,     0,     0,
       0,     0,  1029,   755,   168,     0,   319,   319,   549,     0,
     319,   170,     0,     0,     0,   541,   319,   779,  2702,  2708,
    2706,  1322,     0,  2784,  2785,   453,  1367,  1294,  1305,   865,
     872,   854,   871,   870,   852,   869,   866,  2486,     0,     0,
    2677,     0,   883,     0,   452,     0,     0,     0,   897,   898,
       0,     0,   896,   913,   899,     0,   901,   893,   892,   902,
     903,     0,     0,   922,     0,  1345,     0,  1343,     0,  1507,
    1347,  1336,  1314,     0,  1312,  1317,  1319,  1318,  1316,     0,
       0,   502,     0,     0,   880,     0,     0,   319,  1189,     0,
     833,   834,   840,     0,     0,     0,     0,     0,   841,   837,
     838,   839,   842,   843,   844,     0,     0,     0,  1828,     0,
    1829,     0,     0,     0,  1864,  1860,     0,     0,     0,     0,
       0,     0,  1836,  1837,  1838,  1835,  1839,  1834,     0,     0,
    1840,  1833,     0,     0,     0,     0,     0,  1575,  1574,     0,
       0,     0,     0,     0,     0,     0,  1664,  1697,     0,     0,
    1792,     0,  1818,  1850,     0,     0,  1586,     0,     0,     0,
       0,     0,     0,     0,  1818,  1856,     0,     0,     0,     0,
    1758,     0,  1755,     0,     0,     0,     0,  1875,     0,     0,
       0,     0,  1912,  1606,  1623,  1886,     0,  1877,     0,     0,
    1607,  1630,     0,  1857,  1657,     0,  1662,  1645,     0,  1638,
       0,  1643,  1647,  1626,  1878,  1817,     0,  1815,     0,     0,
    1624,     0,  1619,  1617,  1618,  1611,  1612,  1613,  1614,  1615,
    1616,  1620,  1796,  1794,  1795,     0,     0,     0,  1642,  2013,
    2046,     0,  1410,  1410,  1410,  1397,  1408,  1885,     0,  1513,
       0,     0,     0,     0,  1775,     0,  1822,     0,  1820,  1902,
    2684,  2683,  1876,     0,     0,     0,  1891,     0,     0,  1602,
       0,   248,  1505,  1871,     0,   785,   786,   784,  1530,  1290,
    1274,  1270,  1269,  1882,  1289,     0,  1396,     0,   955,   956,
       0,   960,     0,     0,  1439,  1461,     0,  1452,     0,  1443,
    1444,  1435,  1462,  1457,  1381,  1380,     0,  1516,     0,     0,
    1332,  1325,  1510,     0,  1467,  1350,  1352,  1353,     0,  1875,
    2400,  2458,  2405,  2426,  2396,  2429,  1604,  2378,  2418,     0,
    2352,  2522,  2523,     0,  2513,  2514,  2483,  2489,  2560,     0,
    2676,     0,     0,   713,   712,     0,     0,     0,  1134,  1059,
    1110,   783,  1135,  1060,  1111,  1136,  1061,  1238,     0,  1240,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   664,  2019,   319,  1247,  1137,     0,
    1062,   315,  1248,  1112,  1252,   684,   683,     0,     0,  1113,
       0,   558,     0,     0,   563,   564,   565,     0,     0,     0,
     566,     0,  1958,  2006,     0,   571,   578,   583,   573,     0,
     584,   579,     0,     0,     0,     0,     0,     0,   590,   592,
       0,     0,     0,     0,     0,     0,  1000,  1001,  1138,  1065,
       0,  1114,   982,  1545,   966,     0,     0,   977,     0,   976,
    1545,  1545,  1066,   172,     0,   264,   274,   599,  1108,   292,
     305,   300,   301,   299,  2019,   319,  2019,   319,     0,     0,
       0,     0,   302,   297,   298,   294,   307,  1935,  1991,  2122,
       0,   603,   605,     0,   610,   310,  1080,     0,   327,   330,
     311,   290,   293,   291,   287,   272,     0,     0,     0,     0,
       0,     0,  1898,     0,     0,  1031,     0,     0,     0,   162,
    1094,     0,     0,   148,     0,     0,     0,     0,   142,   152,
       0,  1144,  1070,     0,     0,   266,   505,   513,   518,  1074,
     521,  1124,   519,  1150,  1071,  1106,     0,   262,     0,  1072,
       0,  1118,  1146,  1096,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1255,     0,     0,     0,     0,     0,   319,
       0,     0,     0,  1108,  2019,   319,  1145,     0,  1103,  1132,
       0,   335,     0,  1095,     0,     0,   268,  1076,  1126,     0,
       0,   218,   217,   219,     0,     0,     0,     0,     0,     0,
       0,     0,   825,   794,   824,     0,     0,     0,   788,   370,
     344,   345,   347,   354,   714,     0,     0,     0,  1527,  1523,
       0,     0,     0,     0,     0,     0,  1543,   702,     0,     0,
       0,     0,  1236,  1236,  1236,  1236,  1236,  1236,  1236,  1217,
    1245,     0,   139,     0,     0,     0,   552,   592,   599,     0,
       0,     0,   399,   403,   407,   408,   409,     0,     0,     0,
       0,   153,   140,     0,   744,     0,   453,     0,   184,   177,
       0,     0,     0,   545,   699,   697,   696,   698,     0,     0,
       0,   719,   695,     0,  1517,  1519,     0,     0,     0,     0,
       0,   402,     0,   456,     0,     0,   488,     0,     0,     0,
     326,     0,     0,   971,     0,   989,   972,     0,     0,     0,
    1011,  1016,  1012,   992,     0,   529,  2346,  2340,  1368,  1369,
       0,   319,     0,     0,   594,   319,   319,     0,   319,     0,
     319,   319,     0,  1172,   620,     0,   672,     0,     0,   319,
     757,  1819,     0,  2485,  2673,   884,   455,     0,     0,     0,
       0,   895,     0,   527,   900,     0,   912,   907,   909,     0,
     916,  1346,  1339,  1341,  1340,     0,     0,  1337,  1825,   756,
     495,     0,     0,     0,   319,     0,   917,     0,   835,   836,
       0,     0,   845,     0,     0,  1415,  1826,  1827,     0,     0,
       0,     0,  1861,     0,     0,  1733,     0,  1709,  1711,  1544,
    1723,     0,  1557,  1734,  1735,  1713,  1715,     0,  1809,     0,
       0,  1724,  1666,  1667,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1679,  1678,  1725,
    1791,     0,     0,  1848,  1849,  1726,  1587,  1588,  1588,     0,
       0,  1855,     0,     0,     0,  1731,  1736,     0,     0,     0,
       0,  1742,     0,  1763,     0,     0,     0,  1689,  1819,  1579,
    1580,     0,     0,     0,     0,     0,     0,     0,     0,  1663,
    1646,  1640,     0,  1644,  1648,     0,     0,     0,     0,  1632,
    1658,  1628,     0,     0,  1634,     0,  1659,  1410,  1410,  1410,
    1410,  1407,     0,     0,     0,     0,     0,  1488,  1466,  1468,
    1475,  1488,  1493,  1511,     0,  1892,     0,  1448,  1419,  1419,
       0,  1775,     0,  1698,     0,  1775,     0,     0,  2535,  2537,
    2538,  2539,  2540,  2541,  2543,  2544,  2546,  2547,  2548,  2536,
    2542,  2545,  2549,  2526,  2527,     0,  2517,  2518,   195,     0,
     227,   214,     0,  2560,  1272,  1895,     0,  1422,     0,  1810,
     960,   958,   959,  1424,     0,     0,  1459,  1432,  1334,     0,
    1332,  1327,     0,  1328,  1875,     0,  1324,  1357,     0,     0,
    1516,     0,  1356,     0,  2460,  2388,     0,     0,  2559,  2562,
    2573,  2571,  2398,  1133,  1058,  1109,  1236,   927,   928,     0,
     926,     0,     0,     0,   441,   943,     0,     0,     0,   664,
       0,     0,   445,     0,  1250,     0,  1151,  1093,   560,   561,
       0,   572,     0,   581,   580,     0,     0,   568,     0,     0,
       0,     0,   567,   586,   533,   587,   589,     0,     0,   588,
     591,   596,  1106,     0,   627,  1082,     0,  1130,   994,     0,
    1545,   969,   974,   975,     0,     0,     0,   415,     0,     0,
       0,   275,   285,     0,     0,   289,     0,   283,   303,   295,
     304,   296,   607,   608,   606,   602,     0,   609,   611,   324,
       0,     0,     0,  1140,  1106,     0,   270,  1078,     0,  1128,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1141,  1115,     0,     0,   145,   144,     0,   151,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   336,   321,     0,   722,     0,     0,     0,   338,
       0,     0,     0,     0,  1139,  1067,   789,     0,     0,   790,
     798,     0,     0,   791,     0,     0,   800,     0,     0,   343,
     351,   716,     0,  2068,  1799,  1800,   710,   717,   707,   709,
     708,   711,   664,     0,     0,     0,  1528,     0,  2774,  2782,
    2781,     0,  1602,   704,   705,     0,  1236,  1235,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   427,
       0,     0,   421,     0,     0,  1016,   414,   417,   418,     0,
       0,   553,   556,   554,   555,   585,     0,   434,     0,     0,
     155,     0,     0,   156,   154,     0,     0,   326,     0,   180,
     398,     0,     0,   645,   648,   641,     0,   718,   720,   693,
       0,   599,     0,     0,  1323,   497,     0,   484,   480,   482,
     481,   483,     0,   490,   325,     0,   497,   490,     0,   944,
     970,     0,     0,     0,  1009,  1013,  1010,     0,     0,   985,
       0,   993,   963,  1167,  1168,  1165,  1166,     0,     0,  2363,
    1359,  2372,  1028,     0,   319,  1026,   760,     0,   751,     0,
     753,  1030,   319,   319,   632,     0,   542,     0,     0,     0,
       0,   894,   914,     0,   910,     0,     0,   877,   919,  1344,
    1342,   496,   922,     0,   878,   921,     0,     0,     0,     0,
       0,  1830,  1563,     0,  1863,  1859,     0,  1706,  1831,     0,
    1843,  1842,  1665,  1844,     0,  1684,     0,     0,  1676,  1674,
    1675,  1668,  1669,  1670,  1671,  1672,  1673,  1677,  1853,  1852,
    1846,  1847,  1583,  1581,     0,  1728,  1729,  1730,  1854,  1737,
       0,  1949,  1764,  1741,  1757,  1756,     0,     0,     0,  1744,
       0,     0,  1753,     0,  1793,  1569,  1602,  1608,     0,     0,
    1631,  1858,  1649,     0,     0,     0,  1627,     0,     0,     0,
       0,  1636,  1809,     0,     0,     0,     0,     0,     0,  1401,
    1400,  1406,  1488,  1493,  1383,     0,  1475,     0,  1487,  1473,
    1486,     0,     0,  1499,  1497,     0,  1499,     0,  1499,     0,
    1470,     0,  1489,  1471,  1486,     0,  1893,  1512,     0,  1450,
       0,     0,  1418,     0,  1775,  1705,  1778,  1773,  1774,  1823,
    1699,  1910,     0,  1821,  1775,     0,     0,     0,  1872,  2558,
    1394,     0,  1423,  1440,  1433,     0,  1514,  1333,     0,     0,
    1330,     0,     0,     0,  1351,  1332,  1354,  2404,     0,  2459,
    2524,  2525,     0,   933,   934,   932,   935,     0,     0,     0,
     664,     0,     0,   461,     0,   951,   951,     0,     0,   447,
     493,  1016,   667,     0,     0,     0,   665,   319,  1063,     0,
     582,     0,     0,   577,   575,   574,   576,   534,  1149,  1064,
       0,     0,     0,     0,   995,     0,   987,  1081,     0,   412,
       0,   280,  1107,     0,     0,     0,   279,     0,   319,   319,
     604,   328,   329,   332,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   745,   728,     0,     0,   746,   747,
       0,     0,     0,  1033,  1034,  1032,   149,   146,   147,   150,
    1091,  1075,  1125,  1073,     0,  1119,  1088,  1084,     0,     0,
       0,     0,     0,  1148,  1102,  1123,  1147,  1100,  1121,  1099,
    1120,  1101,  1122,  1092,     0,  1521,   725,     0,     0,     0,
     319,   319,   634,  1077,  1127,     0,   792,     0,     0,   793,
     795,   373,     0,   376,   383,   355,   360,  1254,     0,  1254,
       0,   357,   361,  1254,   356,  1254,   353,   686,     0,     0,
       0,  1524,     0,     0,     0,     0,     0,     0,  1529,  1537,
     663,     0,  1227,  1226,  1225,  1229,  1228,  1231,  1230,  1222,
    1221,  1234,  1233,  1220,  1219,  1224,  1223,     0,   419,     0,
     425,   429,   430,   428,   420,  1016,   453,   492,     0,     0,
     676,     0,   551,   400,   431,     0,   404,   158,   157,     0,
       0,     0,   184,     0,     0,   650,   654,   694,     0,  1520,
     628,   326,     0,   400,   497,  2329,     0,   405,   410,   411,
       0,   488,     0,   484,     0,     0,   494,  1214,   498,   499,
       0,     0,   973,   990,   991,     0,     0,  1016,  1015,     0,
     536,     0,  2336,   319,   595,   319,   319,  1173,   673,     0,
     906,   905,   904,   528,     0,   908,   319,     0,     0,     0,
       0,     0,   847,   826,   846,  1862,  1722,  1732,  1841,     0,
       0,  1685,     0,     0,  1727,  2211,     0,     0,     0,     0,
    1761,  1762,  1743,     0,  2059,  1748,     0,     0,     0,  1913,
    1655,  1653,  1650,     0,  1651,     0,     0,  1633,  1629,     0,
    1635,  1660,  1405,  1404,  1403,  1402,  1474,  1472,  1477,  1484,
       0,  1469,     0,  1498,  1494,     0,  1495,     0,     0,  1496,
       0,     0,  1484,     0,     0,     0,     0,  1769,  1775,  1775,
    1700,  1780,  1777,     0,  1702,  2528,     0,  2531,  2529,  2530,
    2534,  1602,     0,     0,  1326,  1329,  1331,     0,  1358,  1349,
    2461,  1242,     0,     0,     0,   443,     0,  1016,     0,     0,
       0,   954,   954,     0,  1016,   492,   669,   668,   671,   666,
     670,  1251,     0,   569,   570,  1083,     0,  1131,  1089,   988,
       0,   600,   276,   277,   278,   281,   321,   288,   282,     0,
    1079,     0,  1129,  1086,  1142,  1068,  1116,     0,     0,   734,
       0,     0,     0,     0,  1143,  1069,  1117,     0,     0,     0,
       0,  1260,     0,   320,   724,   723,   321,   337,  1104,     0,
     796,   797,   374,   139,     0,   352,     0,   381,     0,   379,
     378,   380,     0,   367,     0,     0,     0,     0,     0,  1525,
       0,  1047,  1047,  2775,  2776,  2777,  2778,  2779,  2780,     0,
     664,  1232,     0,     0,   416,   492,   460,     0,   422,     0,
       0,     0,     0,     0,     0,     0,   599,     0,     0,     0,
     179,   400,   599,   649,     0,     0,     0,   721,     0,   402,
       0,  1321,   401,     0,     0,   490,     0,   488,     0,   485,
       0,   489,     0,  1207,     0,     0,  1014,     0,  1018,     0,
     984,   961,  1513,     0,   540,  2362,  2366,  1048,   752,   754,
     633,   911,   918,   319,   827,   828,   829,   830,  1680,     0,
       0,     0,     0,  1738,     0,  1739,  1766,  1765,  1745,  1749,
       0,  1746,  1747,  1652,  1656,  1654,  1637,  1476,     0,     0,
    1478,     0,     0,  1480,  1482,     0,     0,     0,     0,     0,
    1896,  1775,  1447,  1449,     0,  1384,  1703,  1704,     0,  1419,
    1775,  2533,  2532,   228,  1811,  1515,  1355,   912,     0,   319,
     951,   492,   462,  2068,   463,   950,     0,   952,   957,   957,
       0,   492,   664,   562,     0,   598,     0,   323,   331,     0,
       0,     0,   741,   729,     0,     0,   748,  1085,     0,     0,
       0,     0,     0,   319,   799,   354,     0,   377,   386,     0,
     384,   358,   363,     0,   365,   364,   359,   362,  1047,     0,
    1044,  1043,   662,     0,   451,   423,     0,   471,     0,     0,
     677,     0,     0,     0,   440,   439,   436,   435,   437,   438,
     433,   432,   624,   738,   326,  1214,   612,   651,   652,   647,
       0,     0,     0,   484,   480,   406,   415,   389,     0,   490,
     486,   487,     0,     0,     0,  1262,     0,   945,  1017,     0,
       0,     0,   535,     0,     0,   539,   530,     0,  2364,   879,
    1681,     0,  1682,     0,     0,     0,  1751,  1750,     0,  1485,
    1501,     0,  1481,  1479,  1490,     0,  1492,  1768,  1770,     0,
       0,  1783,  1701,   929,     0,   930,   954,   466,     0,   953,
     960,   960,   453,   664,   444,  1090,   601,     0,   284,  1087,
       0,   732,     0,   743,   741,     0,     0,  1256,     0,  1257,
    1258,  1261,   339,   342,   372,   382,     0,   366,  1042,  1046,
    1045,     0,     0,   424,   457,   458,   459,     0,   426,   467,
     468,     0,   674,     0,   679,     0,     0,     0,     0,     0,
    1208,     0,     0,  1209,   488,   484,   413,   479,   387,     0,
    1211,     0,   326,     0,  1016,  1019,  1171,   538,   537,  2367,
    2369,  2368,     0,  1683,  1754,  1740,  1767,  1752,  1483,     0,
    1491,     0,     0,  1779,     0,     0,     0,     0,   957,     0,
     664,     0,   948,   947,   460,   446,   322,     0,     0,   739,
     742,   730,   743,   750,   749,     0,   385,     0,   450,     0,
       0,     0,   469,     0,   470,   491,     0,   678,     0,   599,
     737,     0,     0,   653,     0,   490,   488,  1212,  1213,   490,
     946,   962,  1170,  1169,  1396,  2365,  1500,  1771,  1772,  2176,
       0,  2151,     0,  1781,  1784,  1782,  1776,   319,   960,     0,
     448,   464,   471,     0,     0,   731,  1259,   654,   476,     0,
     475,     0,   473,   472,   675,   680,   625,   727,  1210,   657,
     390,   490,  1513,  1153,  1396,  1152,  1154,  1162,  1159,  1161,
    1160,  1158,     0,  1788,  1787,  1786,  1790,  1789,   931,   949,
       0,   664,   733,   740,     0,   474,   478,   477,     0,   655,
     658,   661,   659,   660,   388,   936,     0,  1163,  1157,  1383,
    1370,     0,   465,   449,     0,   635,     0,  1155,  1396,  1785,
       0,   656,  1156,     0,   657,     0,   636
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,   248,   249,  1734,  2662,  2541,  3371,  3372,   250,
     251,  1806,   252,   253,   254,   255,   256,   257,   258,  1750,
     259,   260,  1307,  1956,  2672,   261,  2405,  1075,  1076,  2274,
    2275,  2604,  2276,  2263,  1585,  2058,  1769,  1736,  1770,   263,
     264,  1579,  2255,   265,   266,   267,  1794,  1795,  1744,  2001,
    4285,  4888,  2523,  3408,  3207,  3208,   268,  1852,  1853,   269,
     270,  3322,  1893,  2631,  3859,  3860,  4316,   878,  2628,  4593,
    4594,  4302,  4303,  4600,  4779,  4780,  2673,  1952,  3402,  3947,
    3362,  4386,  3363,  4387,  3364,  4388,  3350,  3906,  3907,  3908,
    3365,  4364,  4810,  3366,  2420,  4913,  2707,  2088,  2086,  4797,
    4182,  4183,  4970,  4918,  4919,  4920,  5042,  4393,  3406,  3953,
    4396,  4628,  3104,  1976,  2821,   977,  2709,   909,   978,  2674,
     275,  2701,  1826,  1827,  2549,  3866,  3464,   276,  1326,  3733,
    4674,  4845,  4846,   277,   866,   278,  1960,   279,   280,  2658,
    3356,   281,  2437,  3121,   282,   283,  3148,  3149,  3150,   284,
     285,  3757,  4550,  1796,  3200,  3201,  3202,  3203,  3777,   286,
    1958,  1832,  2681,   287,   288,   289,   290,   291,  2592,   292,
     293,  2675,  1968,  2693,  2694,  4376,  4644,  4819,  4646,  5078,
    5079,  4620,  3712,  4196,   295,   296,  4359,  4360,  4925,   297,
    2435,   298,   299,   300,  1936,  2650,  2651,  3867,  1720,  1896,
    2633,  2634,  3936,  3937,   301,  3282,   302,  4244,  4245,   910,
    4928,  4893,  4981,   303,   304,  4248,  4249,   305,   306,   307,
     308,   309,   965,  1379,  1380,  1726,   310,  2291,   311,  1280,
    3313,   312,  1468,  2846,  4433,   313,  1001,  1404,  1405,  2676,
     315,  1012,  2824,  1014,  2101,  3466,  3467,  4007,  2792,  1200,
     316,   317,  2803,  2827,   318,  1737,  2411,  2412,  4177,  2677,
     911,  1982,  2712,  3099,  4836,  4184,  4531,  4748,  3021,  3663,
     320,   912,  1774,  2485,  2715,  3414,  3415,  2487,  2985,  3968,
    2489,  3416,  3421,  3422,  3423,  3964,  3972,  4668,  4669,   321,
    1772,  2478,   322,   323,   324,  1803,  1219,   325,   933,   934,
     326,  4790,   327,  1345,   328,  1033,  2118,   329,  2501,  3763,
     330,   331,   332,  5055,  5086,  5087,  5088,  3977,  5014,   333,
    5057,  1446,   335,   336,   337,   869,  1246,  1247,  1248,  2678,
    4663,   339,   340,  2654,  3349,  3888,   341,   342,  2406,  3089,
     343,   344,   345,  1940,   346,   347,   348,   349,  1872,   350,
    1616,  1617,   351,   352,   873,  1094,  1620,  1628,   353,   980,
    1398,  1399,  1400,  2060,   354,  1450,  2814,   981,  1393,   982,
    3040,  3672,  3673,  3676,   983,  3037,   358,  2107,  2808,  2811,
     984,  3044,  3045,  3046,  3047,  3048,  3678,   985,  1003,  1336,
    2723,   986,  1539,   363,   364,   365,  1103,  1098,  1099,   367,
    2233,  2975,  1020,  1634,  1060,  1110,  4132,  2305,  2306,  2328,
    2329,  1643,  1644,  2318,  2320,  3023,  2321,  3031,  2311,  4129,
    4497,  2324,  2325,  1646,  1647,  1648,  2333,   368,  2979,  3608,
    3609,  3610,  4108,  4109,  4123,  4119,  4484,  4713,  3611,  1440,
    1654,  3612,  3617,  3670,  3393,  3394,  3395,  2490,  2641,  1918,
    1540,  1919,  2648,  1541,  2153,  1921,  1542,  1543,  1544,  1924,
    1545,  1546,  1547,  1548,  2136,  2196,  1549,  1550,  2172,  1142,
    1143,  2045,  2885,  1552,  1553,  4072,  4457,  4446,  2911,  2912,
    2271,  4068,  3559,  4725,  4867,  4868,  4140,  4137,  4501,  4729,
    4966,  5023,  5024,  1554,  2965,  2225,  1221,  1555,  3869,  2227,
    2905,  2987,  2988,  2390,  2134,  2851,  2868,  2869,  2882,  3520,
    2889,  2894,  3543,  3544,  2906,  2934,  1556,  2854,  2855,  3503,
    2138,  1557,  1609,  1610,  2241,  2929,  1623,  1624,  1096,  1558,
    1559,  2102,  1085,  4709,   720,   703,  3221,  2286,  1250,  1017,
    1560,  1561,  1562,  1354,  1355,  1675,   665,   704,   705,  1180,
     817,     2,    75,   987,  3400,   372,   373,   914,   915,   916,
    1328,  1329,  1987,  1990,  1680,  2368,   669,   670,   721,  4412,
    4675,  4848,   971,   374,   375,   376,   377,  1676,  2364,  1144,
      76,    84,    77,  1145,   414,   415,  2346,   378,   834,   379,
    1657,  1124,  3684,   380,   381,   382,   383,   384,   968,   385,
    1126,   386,  1127,   387,   388,   389,   390,  1134,   391,  1659,
    1660,  4169,  1661,   392,   393,   707,   708,  1391,   394,   395,
    1161,  1162,  1423,  1424,  1686,  1701,  1702,  1703,   396,   677,
     397,   398,   399,  1692,  1693,   400,  2248,  2249,  2373,  2250,
     401,  3061,  3062,   402,  3643,  3644,  4508,  3645,   403,  2244,
     404,   405,  1088,  3689,   406,   830,   407,  1175,   709,   710,
     711,  1182,   820,  1046,   722,  1184,  3204,   822,   823,   713,
     714,   715,  2080,    78,  3069,  2081,  1564,   723,  1565,  2239,
    1566,  1567,  1568,  1569,  1570,  1709,   717,  1151,  1383,  1384,
    3070,  1386,    82,  1387,   411,  3881,  2048,  1425,  2066,  2067
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -4473
static const int yypact[] =
{
   -4473,   351, 11926, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, 26150, -4473,
   -4473, -4473, -4473, -4473, 25154,   466, -4473, -4473, -4473,101633,
   -4473, -4473, -4473,   504, 65638, -4473, 68554,   817, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, 71956, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, 54934,  1443, -4473,
     739, -4473, -4473, -4473, -4473, -4473, -4473, -4473,  1538,  9315,
   -4473, -4473, 69040, -4473,    91, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, 69526,   616, -4473, -4473,   406,    39, -4473,   100,
   14906, -4473, -4473, 62236, 66610, -4473, -4473, 72442,   625,  2019,
    4049,  1538, 25661, 72928, -4473,  1777, -4473, 51490, -4473, -4473,
   -4473, 66124, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, 79732,  2628,   960, 51985, -4473, -4473,
   -4473, -4473, 79732, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, 73414, -4473,   963,  1245,  1271, 80218, 80704,
   63694, -4473,  1263, -4473, 79732,  1276,   966, 53960, -4473, 81190,
   -4473, -4473,  1196, -4473, 73900, -4473, -4473, -4473, -4473,   960,
   -4473, 54934, 50516,   192,  1149, -4473, -4473, 81676, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473,  1847,  1275, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473,   616, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473,   423, -4473,   735,   535,  1473,   184,  1307, -4473,
   -4473, -4473,  9775, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   98194,  2181, -4473, -4473, -4473,  1313, -4473,  1404, -4473, -4473,
   -4473,  1759, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,   580,
   -4473, -4473, -4473, -4473,  1958, 97228, 71956, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, 61750, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
     175, -4473, -4473, -4473, -4473, -4473, 71956, 71956, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, 71956,  1483, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473,   522,  1768, -4473, -4473,
   54934,  2439,  2439,  2023, 98194, -4473, -4473, -4473, 55908, 79732,
   79732, 79732,  1804, 79732,  1802, 79732,   289, 55908,105398, 82162,
    1889,  1808, 46048, -4473,104562, 79732, 79732, 82648, 79732, 74386,
   79732,  1879, 79732, 79732,105816, 83134,  2026, -4473,  2276,  1246,
   -4473, -4473, -4473, 79732, 14472,  2628, -4473, -4473, 79732,  1890,
   55908, 79732,  1810, 79732,  1896, 79732, -4473, 79732,  1905, 83620,
     341,  1796,105398,  1978, 46547,  1996,105398, 84106, 79732, 79732,
   -4473, -4473,  2003, 79732, 79732, -4473,  2079,106234,  1217,  2123,
    2296,  2180,   718, -4473, -4473,  2375,  1953, -4473, -4473,  2417,
   71956, -4473, 70012, -4473, -4473, -4473,  2165, -4473, -4473, -4473,
   -4473, -4473,102890,  2019, -4473, -4473, 56395, 79732,  2269, -4473,
   -4473, 84592, -4473,  2082, -4473,   356, 56882,106652,  2379,  2064,
   47046,  2410,107070, 85078, -4473, -4473, 85564, -4473, 86050,  2149,
   86536, -4473,107488, -4473,  2273, 87022, -4473, 15370, -4473,  2037,
    2063,  2074,  1878, 71956, 71956,   995, 99513, -4473, -4473,   616,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,   216,  1744,
   52480,  1114, 52975, -4473, -4473,  1278,  1343,  1353,   216,  2470,
    2470,    86, 71956, -4473, -4473,  1744, -4473,   550,  1139,  2105,
    2105,  2105,  2300,   911, -4473,  2105, -4473, -4473, -4473, -4473,
   73900, 52480, 52975, -4473,  2111,  2628,   135,  2530,  2191, 79732,
   -4473, 79732, -4473, 79732, 79732, -4473, -4473, -4473,  2549,  2183,
    2408, -4473,  2178, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
    2360,  2365,  2391,     9,  2628,  2302, -4473,  2521, -4473,  2424,
   30148,  1203, 71956,  2628, 53470, 74872, 94798,   134,102890,  2628,
   87508,  2268,   948,  2436, -4473, -4473,   647, -4473,  2654,  2279,
    2487,   261,  1246, 43589, -4473,  2281,  1821, 73900, 98677, -4473,
   -4473, -4473, -4473,   137,  2548, 30652, -4473, 79732,  2275, -4473,
    2290,  2278,  2293,  1473, -4473, 79732,  1494,  1494,  2676,  1494,
    2042,  2058, -4473,  2346, -4473,  2581,  2551, 73900,  1149,  1538,
    2303, -4473, -4473, -4473,  2324, -4473,  2331,  2339, -4473,   663,
    2599, -4473, -4473, -4473, -4473,  2440,  2462,  2463,  2468,  2370,
    2469,   419, -4473, -4473, -4473, -4473,  2705, -4473, -4473, -4473,
   -4473, -4473, -4473,  2809,  2797,102054,102054,   574,   648,   129,
     191, -4473, -4473, -4473,  2665, -4473, -4473,  2672, 79732,  2527,
   79732, -4473, -4473, -4473, 87994, -4473, -4473,  2439,  2324,  2438,
   -4473,   233, -4473,  1821, -4473,   330,   359,   392,  1697,  2446,
    1855,  1924, -4473,   619, 79732,  2567,   127,  1069,  2500, 75358,
    7416,  2461,   607,  2772,  4950,   419, 88480, -4473, 79732, 79732,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,  2480,
   -4473, -4473,  2486,  2744,  1082,  2674,  1647,  2794,  6192,  1459,
    2800,  5440,  2054,   750,  2692,   851,  2798,  2014,  2815,  5822,
   79732,  2518, -4473,  2756,  2868,    41, -4473,   782, -4473,  2603,
    2729,   630, 55908,  2563, -4473, -4473, 79732, -4473, -4473, -4473,
    2636, -4473,   375, 55908, -4473,  2758,  2612, 47545, -4473, 79732,
   -4473, -4473, -4473, -4473, -4473,  2693, 79732, -4473, -4473,  2812,
   79732, -4473,  2105,  2732,  2593,  2971, 59317,   195, 79732,  2639,
    3008, 79732,  2807,  2639,  2656, 88966, -4473, -4473,  2639, -4473,
   -4473, 79732, 79732,  2632,  1899,  2639,  2808,  3031,  3044,  2722,
    2833,   839,  1374,   111,  2950,  2639,  2706, 79732, 89452, 79732,
    2707, 79732,  3026, 55908, 79732, -4473,  2821, 75844, -4473,  2666,
    2375, -4473, -4473, -4473, -4473, -4473,  1237, -4473, -4473, -4473,
   -4473,  2966,  2438,   432,  2968,  2677,  2970, -4473, -4473,  2711,
   -4473,  2972,  2461,  2977, -4473,  2680, 89938, -4473, 90424, 90910,
    2980,  2480,105398,  2981,  2680,  2982,  2872,  2987,   432,  2990,
   -4473,   844,  2991,  2878,  2993,  1898,  2680,103308,  2996,   143,
   -4473, 20368, 15370, -4473, 22532,  1824, -4473, -4473, -4473, -4473,
   -4473, -4473, 34180,   793,  2785, -4473, -4473, -4473,  1775, -4473,
  100786, -4473,   995,  1744, -4473, 71956,  1744, 71956,    86,  1744,
   71956,  1744, 71956,    86,  1744, 71956, 71956, 71956,  1744, -4473,
   -4473,  1837,  1458, -4473, -4473, -4473, -4473, -4473, 71956,  2702,
   79732, 79732, -4473, -4473, -4473, 67096,105398, 67582, -4473, -4473,
     259, 71956, -4473, 71956, -4473,  2628, -4473, -4473,  2063, 59317,
    3103,105398, 79732,  2988,  2988,  2988, -4473, -4473, -4473,  2930,
   79732,  2994,  2997, 67096,105398, -4473, 91396,102890,  2890,  2715,
   -4473, -4473, -4473, -4473,  1906,  2753,   350,  2765, 34180,  2718,
     295,   295,  2720,  3006, -4473, -4473, -4473,   412,  2725,  2727,
   -4473,   215,   215,  2881,  2730,  2733, -4473,   283,  2737, -4473,
    2791,   480,  2739,  2740,  2741,  2254,   295, 34180, -4473,  2742,
     215,  2743,  2745,  2746,  3000,  2750, -4473,  3067,  2751,   378,
     435,  2752,  2754, -4473,  2730, -4473,   266,  2755,  2757,  2761,
    2763,  2766,  2767,  2768,  2769, 34180, 34180, -4473, 29140,  1821,
    2628, -4473, -4473, -4473, -4473, -4473, -4473, -4473,    83, -4473,
     510,  6358, -4473, -4473,  2901, 34180, -4473, -4473,    32, -4473,
     529, -4473, -4473,  1821, -4473, -4473,   801, -4473, -4473, -4473,
   -4473,  1936,  1936,   194, -4473, 69040, 69040, -4473, -4473,  1462,
    2762, -4473,  1567, -4473, -4473, -4473, -4473, -4473, -4473,102472,
    3132, -4473,  1020,  2628,   782,  1259,  3089, 99934,100360,  2999,
    2999,  2995, -4473, -4473, 79732, -4473, -4473, 34180, 49542, -4473,
    1821,    67,  3010, -4473, -4473, -4473,  1966, -4473, -4473, -4473,
     616, -4473, 14306, -4473,  1985,  2275, 79732, 79732,  3173, -4473,
   -4473,  2290, -4473, -4473,  1473,  1473, 34180,  1473,   907,  1537,
   31156, 34180,  3059,  2959,   600,  1600,  3061, -4473,  2964,  2042,
    2058, 73900, 79732, 91882,  2886, -4473, -4473,  2324,  2788,  1933,
   -4473, 61264, 97711, 97711,  3028, -4473, -4473,  1174,  1366,  2908,
    3002,  2470,  1162,  2156, -4473, -4473,  2790, -4473,  3123, 69040,
    2850,102054, -4473, -4473, 79732, -4473, -4473, 76330, -4473, -4473,
   -4473,  2100,  2795, -4473,  2813, 79732,  3293, -4473,  2156,  2156,
   -4473, -4473,  2799, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, 98194,  2801, 79732, -4473,  2803,  2804, -4473, 98677, 50029,
    2009,  1821,  2879,  2880,  2926, 54934,  2806,  2883,  2891,  2937,
    2893,  2894, 95284, -4473, -4473, -4473, -4473,  1376,   903,  1500,
    2895,   214,   805,  3177, -4473,  1429,  2943, -4473, -4473, -4473,
    4227, 79732,  3121,  5890,  3009,   419,  2948, -4473, -4473,  3062,
    2911,  2915,  3035,   419,   213, 95770, -4473, -4473, -4473, -4473,
   -4473, -4473,  4707, 27654, -4473,  2920,  2900, 79732, 62722,  3212,
    3033,  1017,   778,   131, 79732,  3110,  3047, 79732,  2862,  2938,
    2940,  2863,  1598,  3224,  2869, -4473, -4473,  3042,  3170,  6383,
    2934,  2935, 58343,  1396, 48044,  3218,   836,  2960, -4473,   836,
   79732,  2963,  2969, 79732,   419, -4473,  3275,   419,   419,  1666,
    3277,  2975,   361,  1780,  2639,  2869,  1584, -4473,  2989,  2992,
    1214, -4473,  3074, 73900,   141,  1863,  2869,  2998,  3003,  2863,
    2863, 79732, 79732, 79732, 79732, 79732,   118,  3291,  3297,  3004,
     125,  3025,  2904, -4473,103726,  3005, 94798, -4473, -4473, 79732,
    3007,  2177,  2869,  1718, -4473,  1686, -4473, -4473, -4473,  1246,
   -4473, 79732, -4473, 79732,  2438, 59317,  3099, -4473,  2956, -4473,
    2461,   419, -4473, 79732, 79732,  2480,  1260,  1084,  3101, 79732,
    3165,  2962, -4473,   244, 50029,  2632, -4473,  2936, -4473,  2978,
   -4473,  2978,  2978,  2953,  2953,  2954, -4473, -4473,  2254,  2978,
    2953, -4473, 60291, -4473,  1628,  1630, -4473,  3332,  3351, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,   732, -4473,
    2033, -4473, -4473, -4473, 79732, 54934, -4473,  3345, -4473, -4473,
   59317,  3138,  3255, -4473, 79732,  3156,  2961, -4473,  3290,  3015,
   -4473, -4473,   712, -4473,  3260,105398,  1498,  2628,  3012, 79732,
    3183, 79732, 79732, 79732, 79732, -4473, -4473,  3155,   812,   181,
   -4473,103726, -4473, 79732,  1584,  3169,  3374,    15,  2105, 79732,
    3261, -4473, 79732,  2979,  3377,  3211, -4473, -4473,  2983,  2470,
   -4473,  2666, -4473,  1997, -4473,  3100, -4473, 55908,   432, -4473,
   -4473, -4473, -4473, 59317, 79732, 92368, 55908,   432,105398,105398,
    3279,   143,  3282,  3036,  3283,  3040, 48044,   432,   152,105398,
   79732, 79732, 79732, -4473, 79732, -4473, -4473, -4473, -4473, 79732,
   79732,105398,103726,  3286,  3288,   432, 79732, 79732, -4473, -4473,
   21222,  1825, -4473, 15370, -4473, 14306,  2070,  2999, -4473,  1483,
   79732,  1403,   995,104144, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, 71956, -4473, 71956,    86, -4473, -4473, 71956, -4473,
   71956,    86, -4473, 71956, -4473, -4473, -4473, 71956, 79732,  3489,
    3001, -4473,   801, -4473, 79732,  2087, -4473, -4473,  2091,   792,
   79732, 79732,   591, 55908, 79732,  3185, 79732, 79732, 79732, 79732,
   79732,  3070,  2762,   727, -4473,   656, 73900,  3194, -4473, -4473,
   -4473, -4473, -4473,  2098,  1847,  1256,  3037, -4473, -4473, -4473,
   -4473, -4473, -4473, 67582, 66124,  3285,   227, 79732, -4473, -4473,
    4476, 34180, 29644, -4473, -4473, -4473,  3011, 14306,  3048, 34180,
   -4473, -4473, 34180,  3016,  2470,  2470, 34180, -4473, -4473, -4473,
   -4473,  2986,  2470, -4473, 34180, 34180,  2470,  2470,  2978,  2978,
   -4473,  4561, 34180, -4473, 48044, 34180, 35692, 27149, 34180,  3082,
    3029,  2470, -4473,  2470, -4473, 34180, 28636, -4473, 34180,  3221,
   36700, 34180,  1259,  3232, 34180,  1259,  3428,  3428,  1149,  3141,
    8156,  3027,  1821, -4473,  3136,  2470, -4473,  2470,   896,   155,
   59317, 34180, 54934,  3109,   172, 79732, 34180,  3038,  2170, -4473,
   34180,   877, -4473,  3041, 34180,  3108, 34180, 34180, 34180, 34180,
   34180, 34180, 34180, 34180, 34180, -4473, 37680,   296, -4473,  1007,
    2229, 68068, 30148,  3315, -4473, 26644, -4473,   312, 71956, -4473,
   -4473,  1821, -4473, -4473, -4473, -4473, -4473,  2100,  3039, -4473,
    3049, -4473, -4473, -4473, -4473, -4473, 79732,  3132, -4473, -4473,
    3112, -4473, -4473, -4473, -4473,   731, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473,  3050, -4473, -4473, -4473, -4473,  3050,
   -4473, -4473,  2999,  3055,  4012, -4473, -4473, -4473, -4473,  3303,
    3309,   432, 98194, 79732,   137, 70498, -4473, 30652, -4473,  2107,
   -4473,  3045, -4473,  3294, -4473,  3054, -4473,  8277,  3294, -4473,
   -4473,   193,  3152,  3295,  3240, -4473, -4473, -4473,  3058, 14306,
   -4473,  2138, 14306,  2189, -4473, -4473, -4473, -4473, -4473, -4473,
     985, -4473, 79732,  3194,  3059,  1600,  3115,   904, 79732, -4473,
   44079,  2118, -4473,  2324, -4473, -4473, 23043, -4473, 24619, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,  3063, -4473,
   -4473, -4473, -4473,   419,  3068,  3542, -4473,102054, -4473, -4473,
   -4473,  3489, -4473,  2417, -4473,  2417,  3568, -4473, 71956, -4473,
   -4473, -4473, -4473,  1089, -4473, 15370, -4473, 15370, -4473,  3072,
    2112,  3145,  3153,  3203,105398, 79732, 79732, -4473, 54934,105398,
   79732, 79732,105398, 79732, 79732, -4473,  3443,  1049, 66124,  3207,
   64180, -4473, -4473,  3090, 79732,  3143,  3324,  3327,   726, -4473,
   -4473, 92854, -4473,  3284,105398, 79732, 79732, 34180,  3289, 79732,
   79732, -4473,   290,  3168,  3171, -4473, 79732,  3174, 55908,  3102,
   79732, 79732, 79732,  3175,   460, 55908,  3147, 48543, 79732, 79732,
   79732, 79732,  3225, 79732, 79732,  3342,   837, 73900,   313,  2188,
    2869,  3302, -4473,  1262, -4473,105398, 79732,  3299, -4473, -4473,
   -4473, 64666,  3505,  3215, -4473, -4473, 96256, -4473, -4473,  3296,
   -4473, -4473, 60291, -4473, -4473,  2129, -4473, 59804, 57369, -4473,
   -4473,   736,105398,105398,  6415, 79732,  1184, -4473, -4473, 59317,
   -4473, 79732, 79732, 79732, 70984, 93340, 93826,  1061,  1289, 79732,
   71470, -4473, 79732, -4473, -4473, 55421,105398, 79732, 54934, -4473,
   79732,  3301,  1028, -4473, 79732,  3046,  3193, 79732,   333,  2260,
    2869, 79732, 79732,  3117,  2147,  3196,  3242, -4473, 79732, -4473,
  105398,  1421, -4473,  3262,105398, 79732,  6831, -4473, -4473,   419,
   -4473, -4473, -4473, -4473, -4473, 79732, 79732,   419, 79732,   419,
    1335, -4473,105398, 79732, -4473, -4473, -4473,  6426, 79732, 79732,
   79732, 79732,105398, 79732, -4473, -4473,  1213,  1413,  1588,  1753,
    3264, 79732,  3390, 79732, 94312,105398, 79732, 79732, 79732,  1910,
   -4473, -4473,  3239, -4473,105398,  1421,  6737, 79732, 79732,  3204,
    3205,   104,  3281, -4473, -4473, -4473, -4473, -4473, -4473,  3371,
    3535, 79732, -4473,  3375,  3376,  3192,  3199,  3380,  1767, 79732,
   -4473, -4473, -4473, -4473, 79732,  3383,  1767,  3331,   547, -4473,
   -4473,  2639, -4473,  2162, -4473,  3163, -4473, 34180,  3552, 59317,
    3158,  3159,  3227, -4473,  3234,  2470, -4473,  2167, -4473, -4473,
    2171, -4473,  3176,   812,  1523, -4473, 54934, 79732,   502,   842,
    3457, 63208,  2784,  3447, 79732,  3206, 79732,  2784, 79732, -4473,
    2643, 66124, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473,  3450, -4473,  2628,  2632,  2632,  2632,  2632, -4473, -4473,
   -4473, -4473,  3350,  1971, -4473,  3172,  2632, 79732,  3278,  2784,
    3179, -4473,  1584,  3465,  3467, 79732, 63208,  2193,  3209,  3581,
    2105,  2628,  3365, -4473, 28145,  5835,  3366,102890, 75844, -4473,
    3195,  3454,  3456,  3475, -4473,  2438, -4473,  3591, -4473,  3488,
     432,  2461, -4473,  2680, -4473, 79732, -4473, 79732, 79732, 79732,
   79732,  2480, -4473, -4473,  2680,  3379,   432,   432, -4473,  3382,
     432,  2680,  3304,  3478,102890, -4473,   143, -4473, -4473, -4473,
   -4473, -4473, 34180, -4473, -4473,  2105,  1997, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, 71956,  2417,
   -4473,  2184, -4473, 79732, -4473,  3455,  3458,  3461,  3200,  3208,
    3233, 79732,  3210, -4473,  3200,   419,  3200,  2762,  2762,  3200,
    3208,104980,  3618,  3481,   426, -4473,   707,   749,  3415, -4473,
   -4473, -4473, -4473, 59317, -4473, -4473, -4473, -4473, -4473, 79732,
     910, -4473,    54,  3392,  3213,104980,  3595,   432, -4473, 55908,
   -4473, -4473, -4473,  3287,  3298, 55908,  3405,  3259, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473,  3453, 79732,  2198, -4473,  1862,
   -4473,  1884, 34180, 34180,   267, -4473, 12524,  2213, 34180,  3220,
    3222,  2216, -4473, -4473, -4473, -4473, -4473, -4473,  3223,  3502,
   -4473, -4473,  3228,  2234,  2262,  3231,  3235, -4473, -4473,  7343,
    3236, 13087,  3237, 35692, 35692,  1616, -4473, -4473, 35692,  3238,
   -4473,  2267,  8936,  3230,  3241,  3243, -4473,  3244,  3245, 13329,
   31660, 34180, 31660, 31660, 13830,  3230,  3247,  2270, 54934,  3393,
   13938,  2274, -4473, 34180, 54934,  7537, 34180, -4473, 34180, 79732,
    3248,  3249, -4473, -4473,  4561, -4473,  3252, -4473, 35692, 35692,
   -4473,  3547, 29140, -4473, -4473,  3520, -4473, -4473,  1010, -4473,
    3251, -4473, -4473,  5157,   245, 34180,  3038, 34180,  3326, 48044,
    3793, 34180,  3469,  4954,  4954,   834,   834,   138,   138,   138,
    1937,  2229, -4473, -4473, -4473,  3253,  2750, 34180, -4473,  2368,
    2378, 79732,  7180,  9486, 10029, -4473, -4473, -4473, 39178,  3292,
   34180, 34180, 34180,  3256,  3398,  3659, 14306,  1067, -4473,  3672,
   -4473, -4473, -4473,   323,  3568,  2100, -4473,  1246,  2470,   896,
  100786, -4473, -4473, -4473, 34180, -4473, -4473, -4473, -4473,  2290,
   -4473, -4473, -4473, -4473, -4473, 79732,  1847, 34180, -4473, -4473,
    1857,  1991, 34180,  2138, -4473, -4473,  3312, -4473, 34180, -4473,
   -4473, -4473,  2762, -4473, -4473, -4473, 39178,  3300,  3305, 43099,
    3389, -4473, -4473, 79732,   183, -4473, -4473, -4473,  3274, -4473,
   -4473, -4473,  1266, -4473, -4473, -4473, -4473, -4473, -4473,  3258,
   -4473,  3265, -4473,  3306, -4473, -4473, -4473, -4473,   169,  3263,
    3266,  3273,  1627, -4473, -4473,105398, 79732, 79732, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,  3486, -4473,
  105398,105398,  3449, 79732,  3459,  3460, 34180,   862, 79732,  3307,
    3313,  1349,  3532, 79732, -4473,  3573,   432, -4473, -4473,  3353,
   -4473, 14306, -4473, -4473, -4473, -4473, -4473,105398, 79732, -4473,
  102890, -4473,  2438, 59317, -4473, -4473, -4473, 79732,  3316, 79732,
   -4473, 79732, 79732, 79732,  2480, -4473, -4473, -4473, -4473,  1123,
   -4473, -4473, 79732, 79732,    76,  3355,  3356, 79732, -4473,   729,
    3074,  7004, 79732, 79732, 79732,  3533, -4473, -4473, -4473, -4473,
    3477, -4473, -4473,  2033, -4473, 57369, 59804, -4473, 59804, -4473,
    2033,  1571, -4473,  2680,  3362,  2869, -4473,  3468,  1179, -4473,
   -4473, -4473, -4473, -4473,  3587,   432,  3588,   432, 79732, 79732,
   79732, 79732, -4473, -4473, -4473, -4473, -4473, 54934, 54934, 54934,
    2315, -4473, -4473,  2628, -4473, -4473, -4473,  2323, -4473,  1318,
   -4473, -4473, -4473, -4473, -4473, -4473,105398,  7120, 79732, 79732,
   79732,  2130, -4473,   298, 59317, -4473, 58830,105398, 79732, -4473,
   -4473,  3515,  3462, -4473,  1838,  3463,105398,  3352, -4473, -4473,
    3369, -4473, -4473,  3370,  2264,  2869,  1584, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473,   352,  2272,  2869,  3378, -4473,
    3386, -4473, -4473, -4473,  3513,  3514,  3516,  3391,  3394,  3421,
    3395,  3396,  3425, -4473,  3397,  3434,  3401,  3435,  3402,   432,
   59317,  3525,  2628,  3426,  3614,   432, -4473,  3407, -4473, -4473,
    3718, -4473, 79732, -4473,  3410,  2292,  2869, -4473, -4473,105398,
   79732, -4473, -4473, -4473,  1767, 59317,  3570,  1767,  1767, 79732,
   79732,  1767, -4473, -4473, -4473,  3576,  3577,  1767, -4473, -4473,
   -4473, -4473,  2732,  3339, -4473,  2165, 45549,  8192,  3346,  3159,
    3344,  2470, 41629,  1467,  3546,  3348, -4473, -4473, 54934, 45549,
    1972,  3564,  3359,  3359,  3359,  3359,  3359,  3359,  3359, -4473,
    1830,   274,  2639,102890, 79732,102890, -4473,   842,  3468, 79732,
   79732,  3349,  3354, -4473, -4473, -4473, -4473,105398,    89,105398,
    2470, -4473, -4473,  3412, -4473, 79732,  2105,  3749,  3044,  1498,
    3492,  1620,  3694, -4473, -4473, -4473, -4473, -4473, 79732, 79732,
     812,  2628, -4473,  3360,  3357, -4473, 79732, 79732, 79732, 79732,
    1847,  3363,  3361, 59317,   624,  3551,  3554,  2863,  3764,  1847,
    3209,  3448, 79732, -4473,  2343,    78, -4473,  2628,102890, 57856,
   -4473,  4525, -4473, -4473,   714,  3647, -4473, 79732, -4473, -4473,
   42609,   432, 59317, 79732, -4473,   432,   143,  3429,   432,  3433,
     432,   432, 79732, -4473, -4473, 79732, -4473, 79732,103726,   432,
   -4473, 14306,  3667, -4473, -4473, -4473, -4473,  3503,  3504,  3506,
   79732,  3200, 55908, -4473,  3388,105398,  1491, -4473, -4473,  3562,
   -4473, -4473, -4473, -4473, -4473,  3684,  3690, -4473, -4473, -4473,
   -4473,  3729,105398, 67096,   157,105398, -4473,  2438, -4473, -4473,
    2461,   419, -4473, 79732,  3635, -4473, -4473, -4473,  3403,  2361,
   13975, 34180, -4473,  3705, 59317, -4473,  8790, -4473, -4473, -4473,
   -4473, 34180, -4473, -4473, -4473, -4473, -4473, 34180, -4473, 34180,
    3682, -4473,  3823,  3823, 59317, 35692,  1656,  2743, 35692, 35692,
   35692, 35692, 35692, 35692, 35692, 35692, 35692, 38184,   776, -4473,
   -4473, 34180, 34180,  3691,  3682, -4473, -4473,  1346,  1346, 59317,
    3404,  3230,  3406,  3408, 34180, -4473, -4473,  2384, 37190,  3409,
   54934, -4473, 34180, 11004,  2398,  3464, 14259,  1821,  9058, -4473,
    3786,  2628, 34180,  1241,  2388, 34180,  2404, 34180,  3696, -4473,
   -4473, -4473,  3414, -4473, -4473, 59317, 34180, 35692, 35692,  5244,
   -4473,  5469, 34180,  3416,  5680, 29140, -4473,   960,   960,   960,
     960, -4473, 79732, 79732, 79732, 39668, 38688, 76816,  3418,  1489,
   -4473, 76816, 77302, -4473,  3419,  1821, 34180,  3697,   882,   882,
    3423,  3398, 44569, -4473, 34180,  1595, 32164,  3431, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473,  3427, -4473,  3439, -4473, -4473,   782,  3436,
   -4473, -4473,  6561,   169, -4473, -4473,  3437, -4473,  3422, -4473,
    1991, -4473, -4473, -4473,  9986,  3610, -4473, -4473,  3418, 32668,
    3389, -4473,  2409, -4473, -4473, 30148, -4473, -4473,  2412, 44079,
    3300, 30652,  1821,  2470,  3452, -4473,  2417,   323, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473,  3359,  2680,  2680,   752,
    3200,  3719,   752, 10361, -4473, -4473, 40158, 79732, 79732, -4473,
   79732,  2420,  1622, 79732, -4473, 79732, -4473, -4473, -4473, -4473,
    3836, -4473, 79732, -4473, -4473,  3493,  3494, -4473, 79732, 79732,
   79732, 79732, -4473, -4473,  2446, -4473, -4473,105398, 79732, -4473,
   -4473, -4473,   363,  2450,  2869, -4473,  3517, -4473, -4473,  3689,
    1772, -4473, -4473, -4473,  3510, 79732,  3446, -4473,  1124,  2863,
      62, -4473, -4473,  3519, 79732, -4473, 79732, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, 55421, -4473, -4473, -4473,
   54934, 45549, 54934, -4473,   380,  2578,  2869, -4473,  3522, -4473,
    3523,  3524,  3574,  1131,   188,  3540,  3541,  3578,  3473,  3484,
    3485, -4473, -4473,   216,  2628, -4473, -4473,  2628,  2680,  2628,
   79732, 79732, 79732, 79732, 79732, 79732, 79732, 79732,  3753,   158,
    1900,105398, 79732, 79732,105398, 79732, 79732, 79732, 79732, 79732,
   79732, 79732, -4473,  3834,  3784,  2031,  3824,  3557, 79732, -4473,
   79732,  3074, 79732, 79732, -4473, -4473, -4473,  3496,  1767, -4473,
   -4473,  3733,  3734, -4473,  1767,  1767, -4473,   244, 54934, -4473,
    2789, -4473,  3163,  3422,  2470,  2156, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473,  2470,  2209,  3499, -4473, 42119, -4473, -4473,
   -4473,  2358,   896, -4473, -4473, 79732,  3359, -4473,  2341,  2512,
    2568,  2932, 77788, 78274, 78760,  3500, 79732, 79732, 35692, -4473,
    1625,   875, -4473,  3736, 79732,  3536, -4473, -4473, -4473,  3650,
   79732, -4473, -4473, -4473, -4473, -4473,  3508, -4473,  3613, 63208,
    2680,105398,105398,  2680, -4473, 59317,  3509,  3209,105398,  1498,
    1235, 89452,  3537,  3501,  3790, -4473,  3511,  3507, -4473, -4473,
   79732,  3468,  2423,   614,  2074,  3037, 65152,  2193,  3765, -4473,
   -4473, -4473,  3875,  3599, -4473,  1847,  3037,  3599,  2628,  3143,
   -4473, 57369, 34180, 34180, -4473,  3518, -4473,  3527,  5874, -4473,
    2632, -4473, -4473, -4473, -4473, -4473, -4473,  3594, 79732,  3945,
   -4473, -4473, -4473,  3529,   432, -4473, -4473, 79732, -4473, 79732,
   -4473, -4473,   432,   432, -4473,  3638, -4473,  1847, 79732, 79732,
   79732,  3200, -4473,   419, -4473,  3806,104980, -4473, -4473, -4473,
   -4473, -4473,   227,  3812, -4473, -4473,  3775,  3776,  3783,  3785,
    1870, -4473, -4473, 34180, 14306, -4473,  3544, -4473, 14306, 10642,
   14306,  3691, -4473,  1938,  3829, -4473,  1324,  3556,  1938,  2004,
    2004,   501,   501,   120,   120,   120,  3823,   776, 14306, 14306,
   -4473, -4473, -4473, -4473,  3550, -4473, -4473, -4473,  3230, -4473,
   34684,  3699,  3935, -4473, -4473, -4473,  3598,  3600,  3558, -4473,
   34180, 35188,  3555, 60291, -4473, -4473,   896,   334, 35692, 35692,
    2289, -4473,   114, 34180, 59317,  2426,  2289,  2543,  2635, 34180,
   34180,  5813,   325, 34180, 11045, 79732, 79732, 79732, 79732, -4473,
   -4473, -4473, 76816, 77302, 41138,  1489,  3565, 79732, -4473, -4473,
    3567, 39178,  3801,  3744, -4473, 39178,  3744,  1798,  3744,  3808,
   -4473, 45059, -4473, -4473,  3582, 26644,  2044, 14306,  3959,  3847,
   34180,  3583, -4473,  3584,  3398, -4473, 96742, -4473, -4473, 14306,
   -4473, -4473, 34180, -4473,  3398,   323,  1037,  2628, -4473, -4473,
   -4473, 48044, -4473, -4473, -4473,  3772, 14306, -4473,  1847, 79732,
    1821,    60,  3601, 79732, -4473,  3389, -4473, -4473, 15370, -4473,
   -4473, -4473,   216, -4473, -4473, -4473, -4473,  3652, 66124,  3867,
   -4473, 34180,  2429, -4473,  3624,  3956,    88,  2441,  2444,  1622,
   -4473,  3536, -4473,  1683,  3848,   151, -4473,   432, -4473, 59317,
   -4473, 79732, 79732, -4473, -4473, -4473, -4473,  2806, -4473, -4473,
   79732, 79732, 79732, 79732, -4473,  3660, -4473, -4473, 54934,  1830,
    3787, -4473, -4473,  3789,   216, 79732, -4473, 59317,   432,   432,
   -4473, -4473, -4473,  3607, 79732, 79732, 79732, 79732,105398, 79732,
   79732,  2470,  2470, 59317,  3596, -4473,  2470,  2470,  3603, -4473,
  105398, 79732, 79732, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473,  3676, -4473, -4473, -4473, 79732, 79732,
   79732, 79732,  3899, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, 79732, -4473, -4473,  2628,  2628, 59317,
     432,   432, -4473, -4473, -4473,  3843, -4473,  1767,  1767, -4473,
   -4473,   223,  2451, -4473, 99095, -4473, -4473,  3008,  2628,  3008,
      92, -4473, -4473,  3008, -4473,  3008, -4473,  1622,  3608,  1803,
    3886, -4473,  1813, 42119, 42119, 42119, 42119, 42119, -4473, -4473,
    3890,   216, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, 34180, -4473,  1301,
    1938, -4473, -4473, -4473, -4473,  3536,  2105,  3663, 55908,   311,
   -4473,  3872,   502, 63208,  1785, 79732, -4473,  2680,  2680,  3666,
   79732,  4018, -4473,   633, 79732,  3929,  3664, -4473,  2628, -4473,
   -4473,  3209, 79732, 63208,  3037, -4473,  2472, -4473, -4473, -4473,
    3655,  3554,  3622,  2193,   711, 79732, -4473,  3661, -4473, -4473,
    3905,  3628, -4473, 14306, 14306,  2628, 60778,  4525, -4473, 79732,
    3881, 79732, -4473,   432, -4473,   432,   432, -4473, -4473, 79732,
    3200,  3200,  3200, -4473,  3809, -4473,   432,104980,  1870,  1870,
    1870,  1870, -4473, -4473, -4473, 14306, -4473, -4473, -4473, 35692,
    3911, -4473,  3633, 59317, -4473,  3634,  2476,  2482, 36700,  3777,
   -4473, -4473, -4473, 11145,  3683, 14306,  3735,  3636,  3639, -4473,
     869,   869,   114,  2488, -4473, 35692, 35692,  2289,  2289, 34180,
    2289, -4473, -4473, -4473, -4473, -4473, -4473, -4473, 76816,  3641,
   79732,  1489, 39178, -4473, -4473,  1371, -4473, 39178,  3878, -4473,
   39178, 79732,  3643, 79732,  1191, 34180, 34180,  3679,  3398,  3398,
   -4473,  3811, -4473,  3645, -4473, -4473,  2156, -4473, -4473, -4473,
   -4473,   896,  3648, 71956, -4473, -4473, -4473,  1149, -4473, -4473,
   -4473, -4473,104980,  3830,104980,  1622, 11287,  3536, 40158, 49042,
   79732, 79246, 79246,  3791,  3536,  3663, -4473, -4473, -4473, -4473,
   -4473, -4473,  3651, -4473, -4473, -4473,  3727, -4473, -4473, -4473,
    2508, -4473, -4473, -4473, -4473, -4473,  3834, -4473, -4473, 45549,
   -4473,  3728, -4473, -4473, -4473, -4473, -4473, 40648, 48044, -4473,
    1131,  3656,  3662,   188, -4473, -4473, -4473, 79732,  1524,  1277,
    3693,  3200,  3940, -4473, -4473, -4473,  3834, -4473, -4473,  1767,
   -4473, -4473, -4473,  2639,  3981, -4473, 54934, -4473,101212, -4473,
   -4473, -4473,  2628, -4473,  2628,  3852, 51003,  2628,  2628, -4473,
   55908,  4063,  4063, -4473,  2083,  2083, -4473, -4473, -4473, 79732,
   -4473, -4473, 11624,  3855, -4473,  3663,  3877,  3923, -4473,  3668,
   79732,  3820,  3670,  3673,   868,   868,  3468, 79732,  2513,  1847,
    1498, 63208,  3468, -4473,  1680,  3677,  3970, -4473,  4076,  3363,
    3678, -4473, -4473, 65152,  3856,  3599, 79732,  3554,  3802, -4473,
    3805, -4473,  1398, -4473, 79732, 40158, -4473, 59804, -4473,  2522,
   -4473, -4473,  3292, 79732,   883, -4473,  3700, -4473, -4473, -4473,
   -4473, -4473, -4473,   157, -4473, -4473, -4473, -4473,   816, 35692,
   59317,  2540, 34180, -4473, 34180, -4473,  4067, -4473, -4473, -4473,
       8, -4473, -4473, -4473,   869,   869,  2289, -4473, 79732,  2547,
   -4473, 34180,  3688, -4473, -4473, 39178,  1371,  2558, 79732,  2574,
   59317,  3398,  3230, 14306, 79732, -4473, -4473, -4473,  4075,  3869,
    3398, -4473, -4473, -4473, -4473, -4473, -4473,  1491,   752,   157,
    3956,  3663, -4473,  3695, -4473, -4473, 79732, -4473,  1198,  1198,
   79732,  3663, -4473, -4473, 79732, -4473, 54934,  3746, -4473, 79732,
   59317,  2461,    55, -4473, 59317, 59317, -4473, -4473, 79732, 79732,
   79732, 79732, 79732,   432, -4473,  3339,  2628, -4473, -4473,  2582,
   -4473, -4473, -4473, 79732, -4473,  3501, -4473, -4473,  4063,   715,
   -4473, -4473, -4473,  1708,  3894, -4473,  1261,  3879,  3782,  3701,
   -4473, 55908,  4129,  3814, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473,  3995,  3209,  3661, -4473, -4473, -4473, -4473,
   34180,  3857,  1847,  2193,  3765, -4473, -4473, -4473,  2587,  3599,
   -4473, -4473,  4078,  3888,  4081, -4473,  2588, -4473, -4473,  5874,
   60778,  4026, -4473,  3760, 79732, -4473, -4473,  2492,  4136, -4473,
     816,  2591, -4473,  2600,  2614,  3860,  3761, -4473,  2615, -4473,
   14306, 79732, -4473, -4473, -4473,  2618, -4473,  3717, -4473,  4121,
   34180,  1065, -4473, -4473,  4002, -4473, 79246,  3762, 48044, -4473,
    1991,  1991,  2105, -4473,  1622, -4473, -4473, 34180, -4473, -4473,
    2641, -4473,  1442,  3868,  4011,  2642,  2645,  3208,  3763,  3208,
   -4473,  3200, -4473, -4473, -4473, -4473,101212,  3501, -4473, -4473,
   -4473,  4037,  3985, -4473, -4473, -4473, -4473,   308, -4473,  3914,
    3917, 79732, -4473,  3737, -4473,  2646, 79732, 79732,  4138,  4139,
   -4473, 11778, 55908, -4473,  3554,  2193,  1830, -4473, -4473,  3920,
   -4473,  3921,  3209, 40158,  4525, -4473,  1003, -4473, -4473, -4473,
   -4473, -4473, 79732, -4473, -4473, -4473, -4473, -4473, -4473,  2649,
   -4473, 79732,  3745,  3230, 33172, 33172,  3743,104980,  1198,  3750,
   -4473,  3748, -4473, -4473,  3877,  1622, 14306, 55908,  4134, -4473,
   -4473, -4473,  3868, -4473, -4473, 79732, -4473,  3876, -4473,  1120,
    1120,  4069, -4473,  3813, -4473, -4473,  3756, -4473,  4180,  3468,
   -4473,  1131,  1847, -4473,  3758,  3599,  3554, -4473, -4473,  3599,
   -4473, -4473, -4473, -4473,  1764, -4473, -4473, -4473, -4473, 36196,
    3883,   622, 12867, -4473, -4473, -4473, -4473,   157,  1991, 34180,
    1622, -4473,  3879,  2461, 79732, -4473, -4473,  3664, -4473,  4176,
   -4473,  1077, -4473, -4473, -4473, -4473, -4473,  3596, -4473, 54447,
   -4473,  3599,  3292, -4473,  1939, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473,  4164, -4473, -4473, -4473, -4473, -4473, -4473, -4473,
   12287, -4473, -4473, -4473,  4060, -4473, -4473, -4473,  2659, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473,  1684, -4473, -4473,  1866,
    2293, 33676, -4473,  1622,  3915, -4473, 54447, -4473,  1939, -4473,
   55908, -4473, -4473,  3767, 54447,  2660, -4473
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4473, -4473,  3901, -4473, -1175,   256,  2421,  -717, -4473, -4473,
   -4473,  3053, -4473, -4473, -4473, -4473, -4473, -4473, -4473,  3078,
   -4473, -4473,  1615, -2595, -4473, -4473,   -56, -1602,  2048,  2686,
    1286, -4473, -1385, -4473, -4473,  -885,    14, -1061, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473, -1130,  1766,  1121,  3280,
   -2645, -4473, -1711, -3326, -4473,   521, -4473, -4473,  1714, -4473,
   -4473, -4473,   982,   448,  -469, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473,  -289, -4473, -4473,  -597,   177,  -113, -2572,  -339,
   -4473, -4473,   393,  -342, -1619, -4473, -3613, -4473,   -36, -4473,
   -4473, -4473,  -321, -1699,  1219, -4473,  -977, -1388,  1534,  -656,
   -4473,  -209, -4473,  -712,  -599,  -596,  -668,  -498, -3791, -4217,
   -3787, -3400,  1227, -4473, -3750,   182, -4473, -4473,   238,   302,
   -4473, -4473, -1796, -1762, -4473,  -742, -4473, -4473, -4473, -3069,
   -4473, -4473, -4473, -4473,  -102, -4473, -4473, -4473, -4473,   418,
   -4473, -4473, -4473, -4473, -4473, -4473, -2813,  1672,  1673, -4473,
   -4473, -3277, -4473, -1207, -4473,   557, -3087,  1136, -4473, -4473,
   -4473,  2377, -4473, -4473, -4473, -4473, -4473, -4473, -1864, -4473,
   -4473,   304, -4473,  1685,   946, -4473, -4473, -4473,  -700,  -763,
    -749, -4473, -3596, -4473, -4473, -4473, -4473,  -282, -4473, -4473,
   -4473, -4473, -4473, -4473, -1244, -4473,  1011, -3215, -1239, -4473,
   -4473,  1027, -4473, -4473, -4473, -4473, -4473,  -647,  -215,  2413,
   -4473,  -537,  -622, -4473, -4473, -4473,  -210, -4473, -4473, -4473,
   -4473, -4473, -4473, -1339,  7308, -1839, -4473, -4473, -4473, -4473,
   -2586, -4473, -4473, -4473, -1674, -4473,  4177,   -14,   154,   336,
   -4473,  -197,  -110,  2929, -1412, -2775,   364,  -370, -4473, -2049,
   -4473, -4473, -4473, -2678, -4473, -4473, -4473, -4473, -3557,   337,
   -4473, -4473, -4473,   413, -4473, -4369, -4001, -4280, -3879, -3541,
   -4473, -4473, -1340, -4473, -4473, -4473, -1683,  1885, -1730, -4473,
   -2433,   414, -3820, -1018, -3327, -4473, -3734,  -466, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -1354,  -883, -4473, -4473,  3445,
   -4473, -4305, -4473, -4473, -4473, -4473,  1187, -4473, -1680,  1093,
   -4473, -4473, -4473, -4473, -4473,  -635,  -718, -4473, -4473, -4473,
     339, -4473, -4473, -4473, -4473,  1711, -1219, -1047,  3308,   368,
    -434, -4473, -4473, -4473, -4473, -3099, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -1779, -4473, -4473, -4473, -4473, -4473, -4473,
   -4473,  2088,  2093,   -99,  -203, -4473, -4473, -1520, -4473,  -841,
   -4473,  2330, -4473, -4473, -4473, -4473,  1373,   370,   447,   -74,
   -4473, -4473,   234, -3484,   -72, -4473, -4473, -4473, -4473,  2059,
     -68, -4473,   716, -4473, -4473, -2900, -4473,   374,   -10,  3013,
    1631,   -69,   254,  -233,  -214,  -208,   -77,  3310,  2770, -4473,
   -4473, -4473,  -211,  1770, -4473, -1108,  -362, -4473,  1377,  -921,
    2065,  2759,  2771, -4473,  1370, -4473, -4473,  1378, -4473, -4473,
   -4473,  -920,  2068, -4473,  2760, -4473, -4473, -4473,  1355,  1375,
   -3444,   803, -3462, -3424,   307,   303, -1115,  -303,  -149,  3334,
    2773,   814, -4472,   743, -4473, -3532, -2460,  -877, -2154, -1883,
   -4473, -4473, -1439,  9325, -4473, -4473, -4473, 14027, 14115, -4473,
   -4473, 15410, 17403, -4473, -1256,   856, 17579,  5830, -1472, -1892,
   -1563, 11971,   455,   -80, -2879, -4473, -4473, -4473,  -264,   867,
     272, -4473, -4473, -4473, -4473,  -531, -2901,  -527, -4473, -4473,
   -4473,  -534, -3336, -1629, -4473,  -817, -4473, 20680,  1419, -4473,
   -1373, -2842, -2836, -1418, -2024, -4473, -4473, -4473, -4473, -4473,
   -4473, -4473, -1393, -3351,  -385,  1496, -4473, -4473,  1586, -4473,
   -4473, -4473, -1580, -1163, -2762,  1499, -2204, -4473, -1110,   770,
    2217, -1062,  5035, -1298, 16829,  -129, -2476, -1558, -1798, -4473,
     745, -4473,  3034,  3335,  -523,  -141,  -891,  5587,  4577,  5529,
   -3204, -4473, -4473,   381, -4473, -4473, -4473,  3816,  1023, -4473,
    3124, -4473,  1735,  2464, -4473, -4473,  2089,  -962,   -37, -4473,
    -493, -4473,  -138, -4473, -4473, -4473,   217, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473, -4473, -4473,  2802, -4473, -4473, -1483,
   -4473, -4473, -4473, -4473, -4473,  4079,  -310, -4473,  3512,  -308,
   -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473, -4473,  2805,
    2125, -4473,  3311, -4473, -4473, -4473,   -35,  3021, -4473, -4473,
   -4473, -1224,  -605,  3314,  3318,  2078, -4473, -4473, -4473, -4473,
   -4473, -4473, -4473, -4473,  2095, -4473, -4473,  1477, -2184,  2101,
   -4473, -4473,   788, -4473, -4473,   338, -4473,   791, -4473,  2910,
   -4473, -4473, -4473,   831, -4473, -4473, -4473,  -515, 14066,    58,
     -94,    97,   954, -4473,  8775,  4738,    81,  2825,   119, 11681,
   19213,   121, -4473,  4082,  2108,  1719, -1033, -4473,  4175,  2415,
   18131, -4473, -1029,   162,  1224, -4473,    -2,  -664, -1203,  3118,
    -754, -2022, -4473,  4498, -4473, -3641, -4473, -1054,  3526, -1241
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2635
static const yytype_int16 yytable[] =
{
      81,   366,  1111,  1580,   356,  1649,   357,  2017,  1655,   361,
     359,  1303,  2007,  1052,  1102,  2057,   925,  2011,  1087,  2046,
    1721,  2760,  1831,   818,   913,  1594,  1005,  1602,  1870,  2638,
    2288,  2113,  1432,  1433,  1434,  1220,  2646,   908,  1438,  2419,
    3318,  1338,  2085,  2488,  2793,  1895,  1005,  1337,  2174,  1808,
    3484,  2125,  2147,  2148,  3167,  3169,  3223,   706,   964,  1950,
    1159,  1013,  1857,  2993,  2561,  1026,   979,  1361,   818,  1970,
    1121,  2163,  1122,  2606,  3379,  1084,   410,  1220,  3739,  2498,
    2519,  3915,   410,  3623,  3957,  1401,   719,   674,   366,  3361,
    2486,  2647,   262,  3013,  3971,   706,   725,   867,  1825,  3613,
    1053,  1836,  2506,  1998,  2353,  2355,  2356,  2698,  2850,  1862,
    3772,  2302,  3774,  4189,  1938,   410,   917,   924,  1943,  4152,
    1163,  3279,  3870,  1947,  3884,  3470,   924,  1704,  2574,  2575,
    1953,  1706,   871,  1220,  1396,  3870,   408,   818,  3618,  3619,
    1972,  2288,   408,  3677,  4219,  4179,  3620,   927,  4407,  1105,
    4122,   919,  1113,  1002,  2570,  3567,  4391,  3613,  1114,  2497,
     410,  1074,  4105,  2474,    79,  2191,   924,  2397,  2752,  2047,
    4399,  4357,  2072,  1002,  4655,   408,  1858,  1338,  2702,  2347,
    2347,  2042,  1771,  1587,  2713,  4532,  4157,  4120,  3374,  1642,
    1645,  3052,  4050,  1682,  1683,  4385,  1154,   409,   821,  3688,
    4841,   417,  2200,   409,  2246,  1695,  4398,  1049,  3524,    37,
      38,    39,    40,  1385,   819,  1049,    44,  1049,  2194,  1969,
     408,   877,  1747,  2289,  2140,  2141,  2200,  2203,  1696,   410,
    3068,  4530,  2581,  2507,  3072,  4222,  4322,  1464,   825,  2586,
     130,   131,  2427,   821,  3889,  3890,  3891,  3892,  3893,  3894,
    2160,  2203,  4749,  3301, -1797,   271,  1332,  2205,  3962,   819,
     272, -1797,  3438,   417,  3440,   417,    37,    38,    39,    40,
     868,  1999,    43,    44,  1470,  1697,  4317,    45,  4892,    45,
    1999,  2205,  3482,   825,  2927,  1999,  2500,  3682,   417,   408,
   -1545, -1545, -1545, -1545,  2568,   366,  4837, -1545,   356,  2231,
     357,   413,    45,   361,   359,  1891,  2922,  4791, -2633, -2633,
   -2633, -2633,   821,  3735,  1584, -2633,   273,  1176,  4856,    37,
      38,    39,    40, -2633,  1748,  3921,    44,  1421,   819,  2299,
    1048,  3628,   362,  4539,  3629,  3630,  3740,  2705,  1048,  2049,
    1048, -1573, -1573, -1573, -1573,  3631,  3632,  3633, -1573,  3634,
    3635,     3,   825,  1421,  3636,  3637,  3638,  2927, -1558, -1558,
   -1558, -1558, -2057,  1448,  1613, -1558,  1614,  2425,  1867,  1115,
   -1578, -1578, -1578, -1578,  4223,  1870,  2192, -1578,   410,  1150,
     274,  4269,   294, -2635,  1885,  2695,   262, -1903, -1903, -1903,
   -1903,   875,  3115,  3793, -1903,  2962,  3130,  2469,  1573,  1674,
    2237, -1573,  2963,   879,  4605, -2634, -2634, -2634, -2634,  1917,
    -375,  2978, -2634,   410,   314,   319,  4630,   334,  4246,   362,
   -2634,  1092,  2200,  1934, -1813, -1578, -1578, -1578, -1578,  1364,
   -1578, -1813, -1578,  -139, -2631, -2631, -2631, -2631,   408,  1376,
    4829, -2631,  -139,  2174,  2290,  1116,   338,  -139,   355, -2631,
    1220,  4606,   360, -1588, -1588, -1588, -1588,  4535,  2500,   371,
   -1588,  2826,  1198,  1797,  2147,  2148,  3501, -2630, -2630, -2630,
   -2630,  2163,  3922,   408, -2630,   835,  4224,  2205,  2500,  4225,
     416,  2470, -2630,  4908,  3329,  3909,  1338, -2225, -2225, -2225,
   -2225,   417,  2035,  4989, -2225,  3794,  3639,  2500,  4857,   409,
      43,  1101, -2225,   913,  2234,    45,  2508,  2105,  2500,  1338,
   -1588, -1588, -1588, -1588,  1294,   836,  4247, -1588,  2509,  1868,
    1437,  2000,  4631,  2706,  1178,  2500,  1122,   835,  1421,  1349,
    2000,  2617,  4270,   675,   409,  2000,  3736,  2887,  1157,  1158,
    2613,  2696,  1422,  2232,  3740,  2280,  2281,  1164,  1878,   271,
    3302,  2887,  1685,  1688,   272, -1585, -1585, -1585, -1585,  2587,
    1999,  2061, -1585,  1802, -1797,  1437,  4232,   836, -2057,  2510,
    2518,  2232,  2112,  3963,  5010,  2569,  1338,  3870,  2106,  2582,
    5085,  1749,  2129, -1371,  4525,    37,    38,    39,    40,  3524,
    1691,  2195,    44,  2928,  1607,   917,  4968,  4172,  1608,  2638,
    2968,  4371,  4657,  1615,    37,    38,    39,    40,   247,  4540,
     273,    44,  2288,  2219,  2220,  2221,  2222,  2223,  2224,  1935,
    1112,  4625,  3705,  2460,  3536,  2566,   362,  3640,  2041, -2057,
     919,  1155,  1148,  3128,  4651,  2609,  3471,  3795,  1117,   924,
     924,  4122,  2224,  1449, -2057,  2140,  2141,  2557,  2426,  2559,
    2605,  2636,  3171,  2160,  2037,  2247, -1371,  2288,  2059,  2629,
    2630,  2992,  1717,  2009,  4380,  3116,  3587,  4481,  4006,  2530,
    3796,  4485,  3641,  4671,   274,  3332,   294,  1156,  4476,  4592,
    4438,  4519,  4614,  4615,  4616,  4617,  4618,  1150,  1664,  2697,
    1698,  1699,   999,  1000,  3679, -1374,  2781,  2756,  1338,  3797,
    1093,  3022,  1747,  1935,  2259,  2964,  1338,  1338,   314,   319,
    1231,   334,  1191,  1199,  1738,   999,  1000,  5005,  3846,  2369,
    4135,  3849,  3850,  2146,   928,  3853,  3613,  3613,  2334,  2335,
    3353,  3856,   874,  3752, -1813,  3753,   818,  2853,  2009,  4876,
     338, -2633,   355,  1102,  3910,  2539,   360,  3152,  2542,  2804,
    3246,  1650,  2789,   371,  2477,  1135,  1289,  3166,  2847,  2849,
    2135,  2800,  4990,   676,  2790,  1295,  3642,  3218, -1374,  2857,
    2106,  1460,  1279,  2861, -1573,  3320,  1402,   831,  3153,   832,
    1350,  2873,  2874,  3929,  1334,  1165,  3813,  4331,  1163,  5051,
    4143,  2152,  2788,  4741,  2891,  2893,  2794,  4210,  2796,  1879,
    4751,  2799, -1371, -1578,  1748,  2907,    37,    38,    39,    40,
    2000,  3647,  1347,    44,  4234,  2135,  1739, -2361,  1607,  1638,
   -1903,  1136,  1608,  2238,  2771,  2764,  4909,  4185,   410,  3472,
    2774,   724,   410,  3851,  3852,  1733,  1187,  2042, -2634,  2018,
    3081,  1684,  2112, -1545,  5064,  1187,   674,  1403,  3219,  1409,
    2264,  1414,   674,  2169,  3653,  2277,  2277,  1418, -1578,  1394,
    -139,  -139,   674,  3054,  3524,  3054,  2805, -2631,  4827,  4880,
    4881,  1439,  2170,   417,  2474,  1596,  3176,  1397,  1187,  1137,
    1409,  1414,  1138,  1150,  3129,   924,  2171,  1640,   408,  1113,
     674,  3354,   408,  3868,   674,  1114,  4658, -1371,   366,  3973,
   -2630,  1841,  2877,  2878,  3524,   674,  3868,  2642,  4659,  4410,
    2169,  1167,  4160,  2103, -1374,  1687, -1545,  3473,   999,  1673,
   -2225,  2537,  2200,  2500,  1335,  2534,  1665,   819,  2115,  2170,
     674,  2505, -1371,  1390,  1187, -1371,  4382,   924,  1439,  1842,
    2561,  2126,  1106,  2173,  1187,   674,  1846,  2203,  1323,  3949,
     674,   825,  1847,   409,  1472,  2705, -1900,  3524,  1740,  4717,
     674,  4719,  4910,  1395,  1242,    81,  3143,  4804,  1653,  3355,
    5065,   929,  1139,  1136,   674,  3974,  1407,  2205,  1412,  1775,
    1408,  3321,  1413,  4173,  2488,  2427,  3969,  1220, -1585,  2791,
    1961,  1741,  1427,  2763,  1618,  2025,  2944,  2689,  2610,  2413,
    1107,  2708,  3533,  3534,  3535,  3536, -2361,  1441,  1443, -1374,
    1583,  1442,  1444,  2462,  1591,  4805,  4707,  2112,  2197,  4944,
    1742,  2468,  4806,  2785,  4793,  1150,  2192,   706,  1962,  1577,
    1422,  1137,  4934,  2026,  2643,  2797,  2798,  2235,  4710,  3144,
    2413,  2806,  4938,  4714, -1374,  3526,  4716, -1374,  1848,  4807,
    1753,   833,   930,  1243,   931,  4648,  2414,  4353,  1187,  2807,
    1421,  4660, -2361,  2655,  1049,  1058,   674,  1108,  1049,  1140,
    2415,  2642,  2547,  2690,  3143,  2550,  2551,  2665,  1743,  3143,
    3971,  1597,   872,  3480,  3038, -2635,   410,  2416,  1141,  5028,
    1843,    35,   417,  1187,  1244,    37,    38,    39,    40,    41,
      42,    43,    44,  5012,  1422,  1324,    45,  3650,  3975,   417,
    3474,  2415,    37,    38,    39,    40,   969,  2428,    43,    44,
    4808,  2945,  4383,    45,  1139,  2946,  2727,  2309,  2416,    79,
    1242,  4551,  2518,  2741,  3475,  4752,  1607,  1136,  3526,  2614,
    1608,  4641,  1598,  1245,  5006,  1410,   408,  3144,  4174,  1415,
    1416,  1417,  3144,   674,   674,   972,  4884,  1460,  1059,  1428,
    1325,   417,  1401,  2947,    37,    38,    39,    40,  3976,  3212,
      43,    44,  1470,  1697,   973,    45,  3145,  4175,  1844,  1963,
    2666,  4874,  3102,  1109,  2027,  1089,  4865,  1048,  2786,  3147,
    1849,  1048,  4354,  4843,  2429,  1137,  4176,  3527,  2643,  1220,
    2261,  2802,  3578,  3476,  3579,  1735,   974,  1612,  3336,  3146,
    5011,  2767,   209,  4936,  1108,  2417,  2310,  2787,  5050,  1243,
    3481,  2644,  5052,  1850,  1985,  4795,    80,  3580,  3001,   362,
    1101, -1545,  3613,  4500,  3103,  2620,  3613,  1856,  2009,  2998,
    2645,  -597, -1545,  4504,  2146, -1545,  1725, -1545,  5038,  1160,
    1187,  1735,  1851,  2691,  2887,  2887,  2417,  5076,  2312,  2887,
    1244,  1187,  4296,  4518,  5084,  5013,  2692,  1964,  4299,  4300,
    3032,  4862,  2028,  2621,  3728,  3531,  3532,  3533,  3534,  3535,
    3536,  2880,  2948,  4494,  1933,  4809,  1907,  4975,  1139,    37,
      38,    39,    40,  1869,  4143,  2313,    44,  3147,   216,  2887,
    2887,  1027,  3147,  1677,  2422,  1102,  4503,  3018,  3264,  1245,
    2262,  2418,  3729,   673,  3265,  3531,  3532,  3533,  3534,  3535,
    3536,  1187,  1707,  2923,  3750,   366,  1472,  3581,   224,  3524,
    1805,  3171,  3582,  3273,  4426,  2221,  2222,  2223,  2224,  4972,
    4973,  4877,   993,  4844,  4758,  1436,  4078,  1220,  3868,  2350,
    1704,  4883,  2418,  3213,  1706,  3870,  1593,  1112,  1992,  4812,
     674,  4241,   994,   206,  3175,  4816,   234,  1677,  3531,  3532,
    3533,  3534,  3535,  3536,  5030,   674,  3758,   918,   237,    81,
      81, -2007,    81,   935,  1019,  2644,  3019,  3441,  2315,   216,
    1187,  3435,  2966,  4130,  5077,  2063,  3436,  2065,   674,  1108,
    2069,  2384,  2071,  1122,  2503,  2074,  2075,  2076,  1993,  1018,
    3266,  1390,  3039,  4002,  2269,  2351,  3245,  2295,  2083,   224,
    2303,  2304,  1437,  2308,  2622,  4964,  1114,  1114,  1242,  1114,
    5039,  2108,  3090,  2109,   674,  2488,  4220,  3257,  3895,  2316,
    3384,  3385,  3386,  3387,  1163,  1029,  3156,  1933,  3188,   674,
    3583,  4965,  3392,  2270,  1807,  2504,  3323,   234,  -161,  4242,
    3584,  2359,   674,  3730,  2360,   674,  3296,   891,   826,   237,
    -780,  1965,  1695,  2352,  4021,  5093,  1187,  4166,   827,  3499,
    4379,  3898,  3751,  -161,  2561,  2733,  3431,  5069,  4929,  3654,
    4914,  1966,    35,  3461,  1429,  1696,  2744,  1994,  5040,  3189,
      41,    42,  1653,   247,  3091,  1187,   993,  2552,  2751,  1788,
    3526,  4415,  2623,  4416,   818,  2967,  4440,  1243,  4441,   999,
    1673,  5041,  1030,  1108,  1992,   893,   994,  4832,  3551,  2618,
    3157,  2564,  4112,  1187,  1187,  4833,  1187,  4506,   706,   706,
    2251,  2252,  1028,    79,    79, -2039,    79,  1995,  4243,  2228,
    1057,  3731,  3267,  1187,  2361,  3759,  1733,  2062,  1244,  3576,
    2064,  2323,  1677,  2068,  3134,  2070,  1139,   818,  2073,  3527,
   -2007,   993,  2077,  3231,  2766,  3814,  3625,   828,  3626,  1725,
    3760,   993,  1316,  1179,  3995,  3268,  2619,   674,  1698,  1699,
    2267,   994,  1201,  1632,  2191,   674,   674,  4726,  4727,  2407,
    4113,   994,  4915,  3613,  4842,  1187,   410,  1245,  3613,  2408,
   -2058,  3613,  1317,  4623,  3269,  1054,  5009,  3971,  3902,  2431,
   -2083,  3057,  3177,  3232,  2409,  1284, -2007,  1996,  4114,  2432,
    1220,   818,  1082,  2553,  1187,  2554,  1967,  1571,  1187,  1187,
    3098,  1318,   706,  4115,  2366,  2253,  4442,  1430,  2455,  4185,
    4112,  4769,  4683,  2421,  3903,  4116,   362,  1095,  2670,   410,
     410,   410,   900,  1994,   901,  2354,   408,  4916,  3904,  4886,
      37,    38,    39,    40,  3233,  3341,  3190,    44,  4117,   674,
    2422,  1342,  1589,  5062,  2567,  1319,  1633,  1951,  4834,  2287,
    2819,  1352,  -944,  3950,  1031,  1032,  3954,  4711,  1572,   835,
    4721,  1472,  3626,  2257,  3524,   819,   829,  2254,  2351,   410,
    1814,  4590,  4591,  1995,  3066,  3711,   410,  1933,  4113,   408,
     408,   408,  5046,   410,  3342,  4543,  4544,  3191,  2133,   825,
    1049,  2671,  3336,  3410, -2039,  2535,  3528,  3529,  3530,   836,
    3531,  3532,  3533,  3534,  3535,  3536,  4114,  4737,  2150,  4739,
    3905,  4770,  3270,  4118,  1677,  5099,  1815,  2410,  1139,  1677,
    1677,  4115,  3330,  1049,  1128,  3234,  2352,  2009,  2433,   408,
    2353,  1933,  3332,  4116,  4978,  4948,   408,  4640,  2177,  3683,
    3727,   409,   409,   408,  1129,  3271,  4185,  1104,  3015,  1788,
   -2039,  4633,  2189,  1996,  1130,  3700,  4117,  2536,  1828, -2058,
    1933,  2434,  3343,  3344,  4192,  3102,  2287,  3247,  4351, -2083,
    2312,  4650,  2423,  3781,  3272,  3250,  3345,  3252,  1118,  1638,
    1735,  2169,   819,  1735,  3238,  1125,  1338,  4712,  3782,  4872,
     409,  1829,  3425,  4979,  1816,  2362,  3613,  2388,  2552,   837,
    2170,   818,    37,    38,    39,    40,   825,  2313,  4034,    44,
    4035,  2078,   674,  1048,  1049, -2058,   918,  3708,   876,  1139,
    2380,  2382,  3346,  1338,  3525, -2083,  4536,   216,  3235,  3449,
    4352,  4118,   966,  1933,  2079,  2728,  3236,  4193,  3238,  3237,
     130,   131,  1817,  3719,  1818,  3526,  1048,  1640,  1112,  1112,
    4192,  1112,  2635,  1131,  2560,  4207,  2887,   224,  2314,  2887,
    2887,  2887,  2887,  2887,  2887,  2887,  2887,  2887,  2887,   417,
    1933,  4757,  4190,    37,    38,    39,    40,  1677, -2425,  2512,
      44,  1935,  1820,  1055,  1641,  1677,  1830,  2823,  4537,  2887,
    3622,  4911,  4194,   410,  4195,   234,  3478,   972,  1933,  1160,
    2315,  4773,  1207,  3741,  3527,    37,    38,    39,    40,  3347,
    3648,  3348,    44,   674,  1397,  1132,   973,  2809,  2887,  2887,
    3274,  1822,  4507,  4193,  2553,  4005,  2554,  3895,  4036,   674,
    3173,  3762,   993,  3896,   835,   366,  1677,  1048,  4037,  1677,
    1677,   247,  3008,  3897,  1122,  1316,  1811,  2992,   974,  3275,
    4329,  2316,   994,   408,  4634,  1187,  1824,  1874,  4768,     8,
    3933,  1933,  4006,  4774,  1187,  3290,   674,   674,  1880,  3942,
    3898,  1847,  3899,  2822,   836,  1317,  2652,   674,  4194,  1812,
    4195,  3744,  1133,  1472,  2520,  2200,  3524,  4113,  2845,   674,
     674,  1166,   819,  4610,  4635,  3015,  1722,   366,    81,  1177,
    2815,    81,  2816,  1677,  3931,  2818,  2817,  2601,  4221,  4226,
    2203,   674,  2769,  3463,  2770,  4114,   825,  2599,  2772,  2602,
    2773,  4611,  4211,  2775,  4185,  4817,  3593,  2776,  1983,  1723,
    4487,  4013,  2521,  2522,  3754,  4052,  4053,  5053,   192,  2146,
    2205,  2398,  4116,  2603,  3312,  3900,  2886,  3786,  1319,  1472,
    2600,  1187,  3524,  4818,    37,    38,    39,    40,  1724,  1281,
    2909,    44,  2992,  2169,  4235,  2169,  2518,  1848,   818,  1338,
     891,  3528,  3529,  3530,  3453,  3531,  3532,  3533,  3534,  3535,
    3536,  2032,  2170,  4271,  2170,  3276,  3868,  4031,  4287,  1187,
    1187,   891,  1220,  3332,  1389,   417,  2171,  1187,  2173,  3692,
    1187,  2033,  3901,  4272,  1187,   206,  4520,  3902,  4288,  2871,
    4017,  4051,  1187,  1187,  3277,  3805,  1339,   935,   216,  1192,
    1187,  4813,  4001,  1187,  1187,  1187,  1187,  4085,   893,  2558,
    3024,   216,   417,  1187,  1187,  -501,  1187,  3911,  1187,  1187,
    4118,  4058,  1187,  3903,  4459,  3658,    45,  4432,   224,   893,
    4458,    80,  5027,  5097,  1727,  1618,  5098,  3904,  1933,  1187,
     410,   224,    79,  3659,  1187,    79,  2520,  3526,  1187,  2667,
    1205,  3092,  1187,  3095,  1187,  1187,  1187,  1187,  1187,  1187,
    1187,  1187,  1187,  1296,  1187,  1297,   234,  1728,  2699,  1338,
    1187,  2488,   122,  1187,  4838,  3718,    35,    43,   237,   234,
    1194,   216,    45,   975,    41,    42,  3720,  4389,  4016,  1447,
     126,   237,  2571,   192,  2521,  2522,  1729,  1042,  2277,  2242,
     408,  1638,  2243,  1730,  -398,  1639,  3527,  1081,  3041,  2887,
    1233,   224,  5054,  3526,  3086,  4215,  1206, -1418,  1465,  3905,
    2146, -1418,  2398,  2925,  2052,   976,  2053,  1574,  2518,  2520,
     410,  1586,  1339,  1588,   932,  1187,  1731,  3389,  3885,   819,
     209,  1240,  3390,  3390,   818,   900,   362,   901,  3151,   234,
    1241,  3336,  4323,  4324,  4325,  4326,  4327,  2200,  1286,  4187,
    4188,   237,  4613,   825,  1283,  1732,   900,  1607,   901,  1640,
     906,  1608,  3527,   216,  1288,  2043,  2043,  2521,  2522,  2044,
    2759,  1150,  2203,  1291,   410, -1418,   410,  3798,  2391,  3800,
     408,  1951,  1210,  1211,  1212,   247,  1213,  1214,  1215,  1216,
    1217,  1218,  2935,   224,  2936,   674,  1641,  -398,   362,  3496,
    1304,  2518,  2205,  2762,  2199,  1629,  -500,  2200, -1371,   673,
     673,  2392, -1418,    81,  1708,    81,  1855,  2937,  2158,  2159,
     209,  3497,   674,  1837,  1311,  3498,   410,   674,  1733,  3927,
     674,   234,  2203,  3833,   408,  1299,   408,  1300,  2204,  3229,
    2393,   409,  2132,   237,   247,  1856,    37,    38,    39,    40,
    1320,   818,   674,    44,   818,  1187,  1838,    45,  3847,  1870,
    1839,  1322,  2205,  3528,  3529,  3530,  1187,  3531,  3532,  3533,
    3534,  3535,  3536,  1187,  2343,  2344,  1168,   247, -1164,  2887,
    2887, -1164,  4126,  1321,  2913,  1840,   408,  2916,  1169,  1170,
    1327,  2933,  1338,   674,  1338,   409,  1330,   409,  3912,  3790,
    3914,  2721,  2722,  1472,  1049,  2293,  3524,  2294,  1171,  2287,
    1933,  1172,  2938,  3661,  3662,  1933,  1933,  2939,  1733,   417,
     674,   674,  2940,  4079,  2296,   819,  2297,  1933,  2208,  2209,
   -2635, -2635,  3791,  3531,  3532,  3533,  3534,  3535,  3536,  3659,
    4131,  4133,  1344,   410,   674,  3550,   410,  3552,  3553,   825,
    1348,  4332,  3659,  3029,  3030,  1677,  3177,  1338,  4602,  1356,
    4604,  3792,  1357,  3966,  4607,  1362,  4608,  2207,   674,  3239,
    1371,  2146,   674,  1725,  2212,  1707,  2288,    79,  1377,    79,
    1607,   967, -1903,  1106,  1608,  3983,    45,  3381,  2208,  2209,
     674,  4788,   818,    35,   417, -1419,  2598,  3697,  3698, -1419,
     674,    41,    42,   408, -1442, -1442,   408,  3154,    45,  2761,
    2992,  2762,  1392,   674,  4325,  4326,  4327,    37,    38,    39,
      40,   362,   674,  3239,    44,  1173,  2782,  1048,  2783,  3209,
    2784,  1339,  2783,  2520,  2212,    80,    80,  2812,    80,  2813,
    2941,  1107,   819,  1431,  2520,   819,  3014,  2213,  3015,  4733,
    2942,  3074,  1445,  2813,  1339,  3627,  1435,  4026,  1472,  2343,
    3050,  3524,  1174, -1419,  4292,  1187,   825,  1933,  3164,   825,
    3165,  2119,  2120,    37,    38,    39,    40,  4032,  4465,  3220,
      44,  2521,  2522,  3812,   410,  1451,  3225,  3526,  3226,  1452,
    3239,  3815,  2521,  2522,  1457,  3239,  4463,  3404,  3405,  2110,
   -1419,  3324,  4054,  3325,  1458,  2146,  4667,  2398,  1108,  1459,
    3337,  3843,  3338,  4319,  4320,  2518,  2520,  4447,  1460,  1461,
    2520,  1339,  4335,  3455,  1462,  2783,  2518,  3239,  2520,  1102,
    4420,  4421,  4422,    37,    38,    39,    40,  3495,  2112,  2762,
      44,  1677,  1933,  3808,   408,   674,  3527,  1463,  2520,  1677,
    1472,  1677,  3505,  3524,  2762,  3509,  4408,  2762,  2219,  2220,
    2221,  2222,  2223,  2224,  2521,  2522,  1466,  3351,  2521,  2522,
    4466,  1150,  2725,  3513,  1467,  2762,  2521,  2522,  4337,  4018,
    1469,  2731,   674,   819,  4684,  4685,  4686,  4687,  1601,  1592,
    1187,  3602,  3603,  3604,  2193,  1595,  2521,  2522,  2518,  1599,
    1600,  3514,  2518,  2762,  2198,  1619,  3540,   825,  2762,  3556,
    2518,  2762,  1606,  3561,  2236,  3562,  1626,  1629,  2219,  2220,
    2221,  2222,  2223,  2224,  1109,  3597,   884,  3598,  1627,   674,
    2518,  1636,  1630,  2886,  2886,  3599,  1102,  3600,  2886,  1651,
    2887,  1933,  3526,  1339,   818,  1656,  2266,  2268,  1652,  2887,
     818,  1339,  1339,   674,  3775,  1658,  3776,  1187, -1549, -1549,
   -1549, -1549,  3779,  1187,  3780, -1549,  2887,  2887,  1201,  4212,
   -1556, -1556, -1556, -1556,  3920,  1662,  3923, -1556,  2886,  2886,
    1187,  1187,  3960,  1663,  3961,    35,  1187,  4323,  4324,  4325,
    4326,  4327,  1666,    41,    42,  4328, -1547, -1547, -1547, -1547,
    4022,  3527,  2762, -1547,  1667,   891,  2520,  1635,  1671,  1637,
    3367,  1187,  1187,  3528,  3529,  3530,  1187,  3531,  3532,  3533,
    3534,  3535,  3536,  4059,  -938,  4060,  1668,  1669,  1187,  1187,
    1187,  1187,  1670,  1672,  3526,   673,   410,  4069,  1678,  4070,
    4305,  1187,   410,  4081,  1187,  2762,  1187,  1679,  4158,  4599,
    4159,  4162,  1681,  4163,  2521,  2522,  1187,  1187,  1710,  4191,
    1187,  2783,  4381,   893,  2783,  4464,  3231,  2813,  4527,   366,
    4528,  1711,  2815,  1187,  2816,  1187,  1719,  2818,  2817,  1187,
    4533,  4306,  2783,  4534,  4389,  2783,  1725,  1677,  2518,  4012,
    4595,  1713,  4596,  3527,  3659,  1187,   408,  4236,  1746,  1773,
    4578,  4579,   408,  4581,  3380,  4307,  1187,  1751,  1187,  1187,
    1187,  4652,  4638,  4653,  1777,  4693,  3232,  4694,  1802,  3557,
    4308,  4695,  1805,  2762,  4309,  3564,  1804,  4703,   674,  2813,
    1810,  4486,  1187,  4489,  2520,   819,  1813,    37,    38,    39,
      40,   819,  1833,  4310,    44,  1187,  4311,  4755,  1845,  4756,
    1187,  1854,  4814,  1721,  2783,  4691,  1187,  1859,  4312,   825,
    1864,  4839,  3368,  4840,  1187,   825,    74,  3233,  3528,  3529,
    3530,  1865,  3531,  3532,  3533,  3534,  3535,  3536,  4369,  4852,
    1866,  2813,  2521,  2522,  2565,  1873,  4859,    35,  3015,  1871,
    2887,    37,    38,    39,    40,    41,    42,  4864,    44,  3940,
     900,  1875,   901,   674,  1877, -1550, -1550, -1550, -1550,  1881,
    1882,   903, -1550,  4866,  1887,  3940,  2518,  1889,   674,   674,
    1892,  4905,   905,  4906,  1187,  1951,  4937,  4942,  2256,  4943,
    4953,  1894,  2813,   818,   818,   818,  4313,  4516,  1897,  4954,
    4667,  3562,  4339,  1733,  4314,   674,  1939,  2632,   674,  1942,
    1954,  1933,  4722,  4955,  4958,  2762,  3015,  4960,  3234,  3940,
    3528,  3529,  3530,  1944,  3531,  3532,  3533,  3534,  3535,  3536,
    1935,  1778, -1548, -1548, -1548, -1548,  1955,  1779,  4315, -1548,
    4977,  4983,  2813,  2813,  4984,  4997,  2813,  4998,  5016,  -181,
    3015,  2862,  1677,  1933,  1933,  1957,  1933,  3369,  5095,  5106,
    5096,  5096,  1959,  1971,  1973,  1979,  1981,   853,  1997,  1989,
    2002,  2679,  2004,  3122,  2006,  2003,  2189,  1780,  2005,  2008,
    1201,  2009,  2016,  2019,  2020,   410,   410,   410,  2021,  2022,
    2933,  1004,  2024,  2029,  2030,  2031,  3370,  2112,  2036,  2050,
    2084,  2114,  2117,  4778,   674,  2121,  2130,  2123,  4785,  3596,
    2124,  1004,  1933,  2131,  1933,   674,  2139,  2863,  2142,  2143,
    2149,  3235,  3607,  2144,   674,  2145,  1781,  2229,   247,  3236,
    2260,  2151,  3237,  1782,   818,  2154,  1783,  2155,  2156,  2157,
    2162,  2164,  2272,  2165,  2166,   408,   408,   408,  2167,  2168,
    2175,  4423,  2176,  2178,    80,  2179,  1421,    80,  4512,  2180,
     362,  2181,  4851,  2256,  2182,  2183,  2184,  2185,  1933,  2292,
    2282,  2301,  1639,  1641,  2330,  2864,  2332,  2340,  2865,  2342,
    3607,  2349,  3981,  1101,   819,   819,   819,   674,   913,  1784,
    1139,  2363,  2365,  1933,  2357,  2367,  2375,  2378,  2376,  2385,
    2383, -2577,  2387,  2394,  2395,  2396,  2398,  2399,   825,   825,
     825,  4854,  4542,  3862,  1933,  2400,  2401,  2402,  2403,  2424,
    2430,  3945,  2436,  2457,  1220,  2461,   410,  1933,  3522,  3523,
    3956,  2463,  4890,  3538,  2464,  2465,  4895,  4896, -1383,  2466,
    4556,   674,  2467,   674,  2492,  2493,  1785,  2500,  1786,  2502,
   -1383,  3980,  1102,  2512, -1383,   674,  4569,   674,  1787,  2513,
    2515,  2518,  2516,  1102,  2517,  2870,  1788,  2524,  2866,  4626,
    2525,  2526,  2527,  3573,  3574,  1789,  4095,  4096,  4097,  4098,
    2531,  2532,  2538,   924,  2540,  4907,   408,  2544,  4367,  4368,
    2548,  1933,  2555,  2545,  1788,  2583, -1383,  4736,  4894,  2556,
    4858,  2584,  4586,  1338,  2588,  2589,   674,  1933,  4775,  2652,
    4858,  4891,  1791,  2562,   664,  2611,  2563,  2624, -1383,  4897,
    1933,  4899,  2572,  2612,  2626,   819,  2627,  2573,  2585,  2594,
    2639,  2597,  2653,  2135,  2637,  2886,   674,  1792,  2886,  2886,
    2886,  2886,  2886,  2886,  2886,  2886,  2886,  2886,  2640,   825,
    1187,  2146,  2152,   674,  2656, -1383,   818,  2657,  2660,  2661,
     886,  2664,  2668, -1383,  4901,  2867,  2683,  2688,  4062,  1830,
     674,  2703,  2704,   674,  2711,  2716,  2717,  2714,  1677,  2999,
    2724,  2735,  2738,  2718,  2737,  2739,  2740,  4963,  2753,  1187,
    2754,  1677,  1933,  2778,  2801,  1793,  2795,  2886,  2886,  1187,
    2810,  2820,  2779,  2825,  2895,  1187,  2200,  1187,  2853,  2852,
    2896,  4778,  1933,  1187,  2858,  2908,  1187,  1187,  1187,  1187,
    1187,  1187,  1187,  1187,  1187,  1187,  2914,  2919,  2918,  1187,
    1187,  2926,  2951,  2978,  2995,  3005,  2932,  1933,  2997,  2949,
    2994,  3006,  1187,  3016,  2199,  3025,  1187,  2200,   410,  1107,
    1187,  3000,  4601,  4959,  3002,  3017,  2112,  3027,  3026,  3028,
    1187,  3036,  3056,  1187,  3487,  1187,  3059,  3058,  2246,  3075,
    3490,  3073,  2203,  1933,  1187,  1187,  1187,  3076,  2204, -1383,
    1187,   673,  3077,  1187,  4828,  3088,  3093,  3100,  3096,  3098,
    3101,  3107,  3117,  1187,  1187,  3118,  3112,  1708,  3120,    80,
    3123,    80,  2205,  3127,  1187,  3131,  3139,  3142,   408,  3155,
    1589,  4871,  1187,  1593,  1187,  3160,  3211,  3216,  3224,  3162,
    3227,  3228,  2199,  3281,  3240,  2200,  3278,  3292,  3299,  3300,
    3304,  4064,  3303,  3305,  3307,  3308,  4744,  1607,  3309,  3311,
    1629,  1608,  3317,  1677,   362,  3310,  3319,   819,  3326,  3328,
    2203,  3333,  4256,   362,  3331,  3332,  2204,  1187,  3334,  3359,
    3373,  3339,  3388,  1187,  3375,  3382,  3396,  3398,  3399,  1187,
    3391,   825,   818,  3407,   362,  4762,   818,  3397,   818,  3409,
    2205,  3412,  3424,  5072,  3428,  1588,  3429,  3427,  3430,  3432,
    3433,  3448,  3447,  3457,  1187,  3442,  3458,  1338,  3445,  3459,
    3460,  3015,  1220,  2206,  3469,  2826,  3477,  2207,  3483,  2037,
    3485,  3462,  3489,  3614,  1437,  3488,  3491,  3492,  3493,  3507,
    3511,  3508,  3510,  3622,  3546,   674,  3558,  3512,  2208,  2209,
    3515,  2762,  3659,  3572,  3516,  3518,  3521,  3539,  3577,  3624,
    3545,  1220,  3575,  3547,  3548,  2210,  3555,  3570,  3571,  3585,
    3592,  3595,  -984,  3616,   818,  3621,  3666,  3671,  3675,  3681,
    3685,  3669,  3690,  3696,   410,  3699,  3686,  2043,   410,  1933,
     410,  3614,  3691,  3710,  2212,  3713,  3702,  3715,  3701,  3737,
    3738, -2635,  3748,  3722,  3749,  2207,  3755,  2213,  3756,  3764,
    3766,  3687,  3803,  3810,  3811,  3809,  3804,  3807,  3818,  3819,
    3823,  3820,  3816,  2112,  3826,  3706,  2208,  2209,  2886,   674,
    3817,  3707,   674,  3828,  3830,  3821,  3838,  3836,  3822,  3824,
    3825,  3827,  2581, -2635,   408,  3829,  3831,  3834,   408,  3848,
     408,  3840,  3314,  3833,  3842,  3854,  3855,  3858,  2360,  2189,
    3314,  3886,  3873,  3874,  3887,  3925,   410,  3882,  3918,  4102,
    4104,  3209,  2212,  4233,  3928,  3919,  3930,  3932,  3940,  3939,
    3948,  3946,  3955,   819,  2215,  2213,  3951,   819,  2199,   819,
    3952,  2200,  3958,  2112,  3978,  3987,  4397,  2112,  2112,  3989,
    3997,  4008,  3998,  3999,  4009,  4000,  1187,   825,  2201,  4003,
    4010,   825,  4011,   825,  4020,  4974,  2203,  3383,  4025,  2132,
    3542,  3524,  2204,  4055,  3541,  4056,   408,  4057,  4063,   674,
     674,  2194,  4084,  1933,  4083,  4092,   674,  4125,  3980,  4111,
    4151,  4071,  4134,  4128,  4146,  3411,  2205,  4154,  4145,  4304,
    4144,  1339,  4178,  1677,  4199,  4147,  4150,  4168,  4214,  4201,
    4202,  4213, -2635,  4216,  4218,   819,  4237,  4238,  4239,  1933,
    1187,  1187,  4227,  4240,  2216,  2217,  2218,  4252,  2219,  2220,
    2221,  2222,  2223,  2224,  4250,  4251,  4268,  4284,  1339,   825,
    4033,  4523,  4253,  4038,  4039,  4040,  4041,  4042,  4043,  4044,
    4045,  4046,  4047,  4254,  4255,  4971,  4286,  4222,  2886,  2886,
    4289,    74,  4297,  4298,   674,  4295,  4321,  4358,  4347,  4355,
    3970,  4365,  2783,  4375,  4374,  1338,  4363,  4370,  4378,  4392,
    4377,  1187,  1004,  4394,  1004,  4395,  1004,  2362,  4409,  4405,
    4411,  4521,  1004,  1419,  1420,  4406,  4419,  2206,  4413,  4424,
    4427,  2207,  4087,  4088,  4428,  4429,  2219,  2220,  2221,  2222,
    2223,  2224,  4430,  4436,  4431,  1004,  1004,  4439,  1187,  4444,
    4449,  1220,  2208,  2209,  4443,  4448,  4456,  4452,  1187,  1187,
    4450,  1933,  4451,  4482,  4478,  4480,  1187,  1187,  4483,  2210,
    4490,  1187,  1933,  4554,  4495,  4496,  4522,  1187,  1187,  4514,
    4493,  1187,  4498,  4499,  4513,  4524,  4517,  2199,  4529,  4530,
    2200,  4538,  4559,  4549,  4552,  2211,  4553,  4570,  2212,  1187,
    4577,  4582,  4589,  1187,  4573,  4609,  4612,  2201,  4619,  4627,
    4632,  2213,  4637,  1187,   818,  2203,  4639,  4643,  1187,  4654,
    4656,  2204,  3627,  4664,  4645,  4662,  4665,  4673,  4681,  4689,
    1187,  4690,  4692,  4697,  4699,  4701,  4700,   936,  4702,  4708,
    4715,  4718,  4724,  4728,  4730,  2205,  4738,  4734,  4750,   937,
    4753,  4754,  4759,  4772,  4764,  1677,    81,  4771,  4776,  4783,
    4765,  4789,  4354,  4796,  4798,  1004,  4799,  4801,  4802,  1187,
     938,  4821,  4803,  1202,  4822,  4820,  4826,  4824,  4830,  1224,
    4621,  4831,  4855,   939,  1700,  4847,  4861,  1933,  2215,  1237,
    4870,  1108,  4887,  4878,  4912,  4917,   940,  1201,  4921,   362,
    4922,  4924,  4926,  4927,  4932,  4939,   410,  4940,  4941,  4946,
    4947,  4952,  4957,   941,  1339,  1933,  4956,  1298,  4961,  4962,
    4967,  1305,  4980,  4969,  4892,  4987,   674,  4985,  4988,  1004,
    4991,  1933,  1315,  4993,   942,  4996,  5001,  5002,   674,  5007,
    5008,   362,  5026,  4136,  4989,   943,  2206,  5031,  5029,  5034,
    2207,  5037,  5045,   944,   671,  5044,  5049,  4990,  5063,  5091,
    5075,  5094,  5100,  1120,   945,  5104,   408,  1809,  2595,   946,
    1776,  2208,  2209,  3377,  2279,   947,  3651,  1933,  2216,  2217,
    2218,  3215,  2219,  2220,  2221,  2222,  2223,  2224,  2210,  3761,
     948,  4231,   674,  3291,  3857,  4301,  4903,  4777,  4509,  4986,
    4823,  4825,  4366,  4624,  4811,   819,  3704,  3456,  5032,  4742,
    5071,  4994,  5043,  4992,  2211,  2438,  4935,  2212,  3709,  4362,
      79,  3357,  3358,  4230,  3773,  2680,  3935,  5074,  3340,   825,
    2213,  5105,  1006,  2214,  1339,  1187,   949,  5101,  4800,  3883,
    3614,  3614,  3861,  4350,  5047,  4763,  1187,  4982,  2439,  2886,
    5035,  2663,  1006,  4766,  1023,  3607,  2104,  4873,  4696,  3607,
    4425,  2440,  4401,  3168,  4945,  4402,  3837,   950,  1340,  5056,
    5102,  4930,  3010,  2768,  2441,  2886,  2886,   951,  3011,  3656,
    1603,  4384,  3033,  4515,  3657,  4164,  2298,  3452,  3667,  3680,
    3035,  3665,  3034,  2327,  1933,   853,  2331,  1625,  2051,  4106,
    4477,  3668,   362,  4863,  2326,    74,    74,  2215,    74,  4103,
    4488,  1611,  2442,  4165,  2336,   674,  4075,  3778,  4853,  4065,
    5017,  5025,   952,  2443,  1004,  5018,   953,  1187,   954,  3660,
    3502,  1933,  3590,  3588,   955,  4161,  1187,   956,  1153,  2977,
    3979,  3614,  2444,  3426,  1991,  2720,  3060,  2445,  3806,  5015,
    1123,  3067,  2341,  1187,  1187,  2348,  1677,  1187,  3051,  2111,
    3064,  3646,  1689,   957,  4170,   958,  1690,  3065,  4171,   959,
    1187,  1388,  2245,  4505,  4149,  1187,  2345,   960,  1187,  1718,
     664,   664,   961,  1187,  1187,  3071,  1146,  2780,  3454,  2040,
      83,     0,   818,  4735,   962,     0,  3835,  2216,  2217,  2218,
       0,  2219,  2220,  2221,  2222,  2223,  2224,   963,     0,  3003,
     674,     0,   674,     0,  2446,  3004,  1187,  1426,  3314,     0,
       0,  3314,  3314,  4460,  4461,  3314,     0,     0,     0,     0,
       0,  3314,     0,     0,     0,     0,     0,     0,     0,     0,
    3871,     0,     0,     0,     0,  2447,  3880,  1933,     0,     0,
       0,     0,     0,  3871,     0,  1187,     0,     0,     0,     0,
    4815,     0,     0,     0,  2829,     0,     0,  1339,     0,  1339,
       0,     0,     0,   853,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   410,     0,   674,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1187,  2886,
       0,     0,     0,     0,     0,  3938,  2448,     0,     0,     0,
       0,  2830,  2449,     0,     0,  2450,  1004,     0,     0,     0,
       0,  1004,  1004,  3417,     0,     0,     0,     0,     0,     0,
       0,  3965,  1339,     0,     0,     0,  2199,     0,  2023,  2200,
    2831,  2451,  1754,     0,   408,   369,     0,  2452,     0,  2038,
       0,   369,   818,  1187,     0,  1933,   667,     0,  4732,     0,
    2453,  2832,     0,     0,  2203,     0,     0,  4304,     0,     0,
    2204,     0,  2833,     0,  1755,     0,     0,  1187,  1933,     0,
    1187,     0,  1187,   819,   369,  2454,     0,     0,     0,     0,
       0,  2834,     0,     0,  2205,  2358,  2835,  1420,     0,  1187,
       0,     0,     0,  1187,     0,     0,     0,   825,  1933,     0,
       0,  1677,     0,     0,     0,  2372,     0,     0,     0,     0,
       0,     0,  2379,  2381,     0,     0,  3607,     0,     0,   369,
    1756,  3607,     0,     0,  3607,     0,     0,     0,     0,     0,
       0,     0,  2836,  4933,   410,     0,     0,     0,  1933,     0,
       0,     0,  1933,  1933,     0,     0,     0,     0,     0,     0,
       0,  1757,     0,  2837,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1044,     0,     0,  1004,
       0,     0,     0,     0,  1044,  4076,  1044,  1004,     0,  1187,
    3418,     0,     0,     0,     0,  2206,     0,  1758,   369,  2207,
       0,     0,     0,     0,   408,     0,     0,     0,  1187,     0,
       0,  5090,     0,     0,     0,     0,     0,     0,     0,     0,
    2208,  2209,   853,     0,  1754,     0,     0,  1759,  1933,     0,
       0,     0,     0,     0,     0,  4951,     0,  2210,  1004,  4141,
       0,  1004,  1004,   819,     0,     0,  3614,     0,     0,  2838,
    3614,     0,     0,     0,     0,  2839,  1755,     0,  1187,     0,
       0,  2840,     0,  2211,     0,     0,  2212,   825,     0,     0,
       0,     0,     0,     0,     0,  1187,     0,     0,     0,  2213,
       0,     0,     0,   362,  4688,     0,     0,     0,     0,     0,
    2841,   209,  2842,     0,   674,  1762,     0,     0,     0,     0,
       0,  1763,     0,     0,     0,  1004,     0,     0,  1764,  2843,
    4704,  4705,  1756,     0,     0,     0,  2476,     0,     0,     0,
    1187,     0,     0,  5048,     0,  1766,     0,   366,     0,     0,
    5058,  1187,  5059,  1767,  2844,  5061,  5060,     0,     0,     0,
       0,     0,     0,  1757,     0,   818,     0,   369,     0,     0,
       0,     0,  1187,  1187,     0,   674,  2215,     0,     0,  3607,
       0,     0,     0,     0,     0,  1187,     0,   366,     0,     0,
    5058,     0,  5059,     0,     0,  5061,  5060,     0,     0,  1758,
       0,     0,   369,     0,  1768,     0,     0,     0,  3420,  3970,
       0,     0,   818,     0,     0,  3871,     0,     0,     0,     0,
     818,     0,     0,     0,     0,     0,   664,  1187,     0,  1759,
       0,   366,     0,  2719,  5058,     0,  5059,  1187,  4257,  5061,
    5060,  4258,     0,  4259,     0,     0,     0,     0,     0,  2199,
       0,     0,  2200,     0,     0,  1778,     0,   410,     0,     0,
       0,  1779,     0,     0,     0,     0,  2216,  2217,  2218,     0,
    2219,  2220,  2221,  2222,  2223,  2224,     0,  2203,     0,     0,
       0,     0,  3314,  2204,    74,     0,   362,    74,  3314,  3314,
       0,  2632,     0,   209,     0,  2475,     0,  1762,     0,  1187,
       0,  1780,     0,  1763,   410,     0,     0,  2205,  1187,     0,
    1764,  3880,   410,  4629,     0,     0,     0,   408,  2476,     0,
       0,     0,  4334,  4336,  4338,  4340,     0,  1766,     0,     0,
       0,     0,     0,     0,     0,  1767,     0,     0,     0,     0,
    5081,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1781,     0,     0,     0,  4850,     0,   819,  1782,     0,     0,
    1783,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,   408,  1006,     0,  1006,     0,  1006,     0,     0,
     825,     0,     0,  1006,     0,     0,  1768,  5081,  2859,  2860,
       0,     0,  4400,     0,     0,  5081,  2872,     0,     0,  2593,
    2875,  2876,     0,   819,     0,     0,  1006,  1006,  2206,     0,
       0,   819,  2207,  1784,     0,  2897,     0,  2898,     0,     0,
       0,  5082,     0,     0,     0,     0,     0,   825,     0,     0,
       0,     0,     0,  2208,  2209,   825,     0,  3614,     0,  2920,
       0,  2921,  3614,     0,     0,  3614,     0,     0,     0,     0,
    2210,     0,  2199,     0,  4434,  2200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   362,     0,  5082,     0,
    1785,     0,  1786,     0,     0,     0,  5082,     0,   362,  2212,
    2203,     0,  1787,  3614,     0,     0,  2204,     0,  2726,     0,
    1788,  2372,  2213,     0,     0,     0,     0,  2732,     0,  1789,
    2669,  2736,     0,     0,     0,     0,     0,  2742,  2743,     0,
    2205,     0,     0,     0,     0,     0,  2593,     0,  5089,     0,
       0,     0,  4761,     0,     0,  2755,  1006,     0,     0,     0,
       0,     0,  1790,     0,     0,     0,  1791,     0,     0,  2199,
     671,   671,  2200,     0,     0,  1705,     0,     0,     0,     0,
       0,     0,     0,     0,  2734,  1004,     0,     0,     0,     0,
       0,  1792,   362,     0,     0,  1201,     0,  2203,     0,  2215,
       0,     0,  3586,  2204,     0,     0,     0,  2593,     0,     0,
    4510,  4511,     0,     0,     0,     0,     0,     0,     0,     0,
    1006,     0,     0,     0,     0,     0,     0,  2205,     0,     0,
       0,     0,    80,     0,     0,     0,     0,  1004,     0,     0,
       0, -2635,     0,     0,     0,  2207,     0,   369,     0,  1793,
    3614,   369,     0,     0,     0,     0,     0,  1700,     0,    74,
       0,    74,     0,     0,     0,   667,  2208,  2209,     0,     0,
       0,   667,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   667,     0, -2635,     0,     0,     0,     0,     0,  4089,
   -2635, -2635,     0,  2219,  2220,  2221,  2222,  2223,  2224,     0,
    3614,     0,     0,     0,     0,     0,     0,     0,     0,   667,
       0,     0,  2212,   667,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   667,  2213,     0,     0, -2635,     0,
       0,     0,  2207,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   667,
       0,  4584,  4585,  2208,  2209,     0,     0,     0,     0,     0,
       0,  3314,  3314,     0,   667,     0,     0,     0,  1339,   667,
   -2635,     0,  4603,     0,     0,  1778,     0,     0,     0,   667,
       0,  1779,     0,     0,     0,     0,  4923,  3880,  3880,  3880,
    3880,  3880,     0,   667,  2199,     0,     0,  2200,     0,  2212,
       0,     0, -2635,     0,     0,     0,     0,     0,     0,     0,
       0,  3007,  2213,     0,     0,  1006,     0,     0,     0,     0,
       0,  1780,  2203,  1004,     0,     0,     0,     0,  2204,     0,
       0,  1004,     0,  1004,     0,     0,     0,     0,     0,     0,
       0,     0,  4647,     0,     0,     0,     0,   370,     0,     0,
       0,     0,  2205,   370,     0,     0,     0,     0,   668,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4666,
    1781,     0,     0,     0,     0,     0,     0,  1782,     0,     0,
    1783,     0,     0,  1044,     0,   667,   370,  1044,     0, -2635,
       0,     0,  4434,  4434,  4434,  4434,  2219,  2220,  2221,  2222,
    2223,  2224,     0,     0,     0,   369,     0,     0,     0,     0,
       0,     0,     0,     0,  4090,     0,   666,  5004,     0,  3335,
       0,     0,     0,     0,     0,     0,     0,     0,  3614,     0,
       0,   370,     0,  1784,     0,     0,     0,     0,     0,     0,
       0,     0,   664,     0,   816,     0,     0,     0,     0,     0,
       0,     0,     0, -2635,     0,     0,     0,  2207,     0,     0,
       0,     0,  5033,     0,     0,     0,     0,     0,     0,  3078,
       0,     0,   667,   667,  3082,     0,     0,  3085,  2208,  2209,
       0,     0,     0,  2219,  2220,  2221,  2222,  2223,  2224,   816,
    1785,     0,  1786,     0,     0, -2635,     0,     0,     0,  3108,
     370,     0,  1787,     0,     0,  2199,     0,  1006,  2200,     0,
    1788,     0,  1006,  1006,     0,     0,     0,     0,     0,  1789,
       0,     0,     0,  3871,  2212,     0,     0,     0,     0,     0,
       0,     0,     0,  2203,     0,     0,  1043,  2213,     0,  2204,
    3158,     0,     0,     0,  1043,     0,  1043,     0,     0,     0,
       0,     0,  1834,  3314,     0,     0,  1791,     0,   816,     0,
       0,     0,  1339,  2205,     0,     0,  4781,  3172,  4782,  1004,
       0,  4786,  4787,     0,     0,     0,     0,     0,     0,     0,
       0,  1835,     0,     0,     0,  5103,     0,     0,     0,     0,
       0,  3205,     0,     0,     0,     0,   671,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2635,  3230,     0,     0,     0,  3241,
       0,     0,     0,     0,  1204,  4093,     0,     0,     0,     0,
       0,     0,  1228,     0,     0,     0,     0,  3253,  2199,  1793,
    1239,  2200,     0,     0,     0,     0,     0,  3262,  1249,   370,
       0,     0,     0,  1282,     0,     0,     0,  1778,     0,     0,
    3286,     0,     0,  1779, -2635,     0,  2203,     0,  2207,  3293,
    1006,     0,  2204,     0,     0,     0,     0,     0,  1006,   667,
       0,     0,     0,  3417,   370,     0,     0,     0,     0,  2208,
    2209,     0,     0,     0,   667,     0,  2205,     0,     0,     0,
       0,     0,  1754,  1780,     0,     0, -2635,     0,  2219,  2220,
    2221,  2222,  2223,  2224,     0,     0,     0,   667,     0,     0,
       0,     0,  3417,     0,     0,  1778,     0,     0,     0,  1006,
       0,  1779,  1006,  1006,  1755,  2212,     0,     0,     0,     0,
    4904,  1754,     0,     0,     0,     0,     0,     0,  2213,     0,
    3434,     0,  1781,   667,     0,     0,     0,     0,  4469,  1782,
       0,     0,  1783,     0,  1930,     0,  3443,  3444,   667,  2372,
    3446,  1780,  3649,  1755,  1004,     0,  3450,     0,     0,     0,
       0,   667,     0,     0,   667,     0,     0,     0,     0,     0,
    1756,     0,     0,     0,     0,     0,  1006, -2635,     0,     0,
       0,  2207,     0,     0,     0,     0,     0,     0,  1455,     0,
       0,     0,     0,     0,     0,  1784,     0,     0,     0,     0,
    1781,  1757,  2208,  2209,     0, -2635,     0,  1782,     0,  1756,
    1783,     0,     0,     0,     0,     0,     0,     0,     0, -2635,
    1581,     0,     0,     0,     0,     0,     0,  3486,     0,     0,
    3418,     0,     0,     0,     0,     0,     0,  1758,  1605,     0,
    1757,     0,     0,     0,     0,     0,     0,     0,  2212,     0,
    1339,     0,  1785,     0,  1786,     0,  3468,     0,     0,     0,
    1631,  2213,     0,  1784,  1787,     0,     0,  1759,     0,  3418,
       0,     0,  1788,     0,     0,     0,  1758,     0,     0,     0,
    3468,  1789,     0,     0,     0,     0,   667,     0,     0,     0,
       0,     0,     0,     0,   667,   667,     0,     0,     0,  2219,
    2220,  2221,  2222,  2223,  2224,   369,  1759,  1930,     0,     0,
       0,     0,     0,     0,  1860,     0,     0,     0,  1791,     0,
    1785,     0,  1786,     0,     0,     0,     0,     0,     0,     0,
       0,   209,  1787,     0,     0,  3419,     0,     0, -2635,     0,
    1788,  1763,     0,  1861,     0,     0,     0,     0,  1764,  1789,
       0,     0,     0,     0,     0,     0,  2476,     0,   369,   369,
     369,  1799,     0,     0,     0,  1766,     0,     0,     0,     0,
     209,     0,     0,  1767,  1762,     0,     0,     0,   667,     0,
    1763,     0,  2458,     0,     0,     0,  1791,  1764,     0,     0,
       0,     0,     0,  5083,     0,  2476,     0,     0,     0,     0,
       0,  1793,     0,     0,  1766,     0,     0,  1778,   369,     0,
       0,  2459,  1767,  1779,     0,   369,     0,     0,     0,     0,
       0,     0,   369,     0,  1768,     0,     0,     0,  3420,  1044,
       0,     0,  2219,  2220,  2221,  2222,  2223,  2224,  1814,     0,
    5083,     0,     0,     0,     0,     0,     0,     0,  5083,     0,
    1946,     0,     0,  1780,     0,     0,     0,     0,     0,     0,
       0,     0,  1044,  1768,     0,     0,     0,  3420,     0,  1793,
       0,     0,  1974,  1977,  1978,     0,     0,     0,     0,   370,
    1004,     0,     0,   370,  1815,  3875,  3878,     0,     0,     0,
       0,     0,     0,  1004,     0,     0,     0,   668,     0,     0,
       0,     0,  1781,   668,     0,     0,  3714,     0,     0,  1782,
       0,     0,  1783,   668,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3924,     0,     0,     0,     0,     0,
    3693,     0,     0,     0,     0,     0,     0,   816,     0,     0,
       0,   668,     0,     0,     0,   668,     0,     0,     0,    35,
       0,   667,     0,  1044,     0,   666,   668,    41,    42,     0,
       0,   666,  1816,  2199,     0,  1784,  2200,     0,     0,     0,
       0,   666,  3716,     0,     0,     0,     0,  1930,     0,     0,
       0,   668,     0,  2201,     0,  3765,  2202,  3767,     0,     0,
    1581,  2203,     0,     0,     0,     0,   668,  2204,  1778,   666,
       0,   668,     0,   666,  1779,     0,  1006,  2116,     0,     0,
    1817,   668,  1818,     0,   666,     0,     0,     0,  1581,     0,
       0,  2205,  1819,     0,  1786,   668,     0,     0,     0,     0,
    1778,  2491,   369,     0,  1787,     0,  1779,     0,     0,   666,
       0,  1778,  1788,     0,  1780,  1004,     0,  1779,     0,     0,
    1820,  1789,   667,     0,   666,     0,     0,     0,  1006,   666,
    1930,     0,   671,     0,     0,     0,     0,     0,   667,   666,
       0,  3783,     0,     0,     0,     0,  1780,     0,  1705,  3832,
       0,     0,  3801,   666,  1821,  3839,     0,  1780,  1791,  1822,
       0,     0,     0,  1781,     0,     0,     0,     0,     0,     0,
    1782,     0,     0,  1783,     0,   667,   667,     0,     0,     0,
       0,     0,     0,  1823,     0,     0,   667,   668,     0,     0,
       0,     0,  2206,     0,  1824,  1781,  2207,     0,   667,   667,
       0,     0,  1782,  1930,     0,  1783,  1781,   370,     0,     0,
       0,     0,     0,  1782,     0,     0,  1783,  2208,  2209,     0,
     667,     0,  1930,     0,  3844,     0,  1784,     0,     0,  2283,
       0,     0,     0,     0,  2210,     0,  2199,     0,     0,  2200,
    1930,  1793,     0,  1043,     0,   666,     0,  1043,     0,     0,
       0,     0,     0,     0,     0,     0,  2201,     0,  1784,     0,
    2211,     0,     0,  2212,  2203,     0,     0,     0,  1930,  1784,
    2204,     0,     0,     0,   668,   668,  2213,  2337,     0,  2214,
       0,     0,     0,  1785,     0,  1786,     0,     0,     0,     0,
       0,     0,     0,     0,  2205,  1787,     0,     0,     0,     0,
       0,  3982,     0,  1788,     0,  3985,  3986,  4167,  3988,     0,
    3990,  3991,  1789,     0,  1006,  1785,     0,  1786,     0,  3996,
       0,     0,  1006,     0,  1006,     0,  1785,  1787,  1786,     0,
       0,  1930,   666,   666,     0,  1788,     0,     0,  1787,     0,
       0,     0,     0,     0,  1789,  2528,  1788,     0,     0,  1791,
       0,     0,     0,  2215,  4014,  1789,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   369,
       0,     0,     0,  2593,  2529,     0,     0,  3174,     0,     0,
       0,  1791,     0,     0,     0,     0,     0,     0,  3255,     0,
    4004,     0,  1791,     0,     0,  2206,     0,     0,     0,  2207,
       0,     0,  2494,     0,     0,  1004,  1792,     0,     0,  2511,
    4015,     0,     0,     0,     0,     0,     0,  3256,     0,     0,
    2208,  2209,  1778,     0,     0,     0,     0,  1004,  1779,     0,
       0,     0,  1793,     0,     0,  2543,     0,  2210,  2546,     0,
       0,     0,     0,  2216,  2217,  2218,     0,  2219,  2220,  2221,
    2222,  2223,  2224,     0,     0,     0,     0,     0,     0,   369,
       0,     0,     0,  2211,  1793,     0,  2212,     0,  1780,     0,
    2580,     0,     0,     0,     0,  1793,     0,     0,     0,  2213,
       0,   668,  2214,     0,  2596,     0,     0,     0,  1419,  1420,
       0,     0,     0,     0,     0,     0,   668,  4318,  2608,     0,
       0,  3878,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4333,   369,     0,   369,  1778,  1781,     0,   668,
       0,     0,  1779,     0,  1782,     0,     0,  1783,  1930,     0,
       0,     0,     0,     0,   667,     0,     0,     0,     0,   666,
       0,     0,     0,     0,     0,     0,     0,  1814,     0,     0,
       0,     0,     0,     0,   666,   668,  2215,     0,     0,     0,
    1006,   667,  1780,  2989,     0,   369,   667,     0,     0,   667,
     668,     0,     0,     0,     0,     0,     0,   666,     0,     0,
    1784,     0,     0,   668,     0,     0,   668,     0,     0,     0,
       0,   667,     0,  1815,     0,     0,     0,     0,  2700,     0,
       0,     0,     0,     0,  2710,     0,     0,     0,     0,     0,
       0,  1781,     0,   666,     0,     0,     0,     0,  1782,     0,
       0,  1783,     0,     0,     0,     0,     0,  1004,   666,     0,
       0,     0,   667,     0,     0,     0,     0,  1785,     0,  1786,
       0,   666,     0,  1044,   666,     0,  2216,  2217,  2218,  1787,
    2219,  2220,  2221,  2222,  2223,  2224,     0,  1788,  4148,   667,
     667,     0,  4208,     0,     0,     0,  1789,     0,     0,     0,
       0,  1816,     0,     0,  1784,  2765,     0,     0,     0,     0,
       0,     0,   369,   667,     0,   369,     0,     0,     0,  1778,
       0,     0,     0,     0,     0,  1779,     0,     0,     0,  3294,
       0,     0,     0,  1791,     0,     0,  1928,   667,   668,     0,
       0,   667,     0,     0,     0,     0,   668,   668,     0,  1817,
       0,  1818,  1581,  1581,     0,     0,     0,   370,  3295,   667,
       0,  1819,     0,  1786,     0,  1780,     0,     0,     0,   667,
       0,     0,     0,  1787,     0,     0,  4273,     0,     0,  4276,
       0,  1788,   667,     0,     0,     0,     0,     0,     0,  1820,
    1789,   667,     0,     0,     0,  1006,   666,     0,     0,     0,
    2372,     0,     0,     0,   666,   666,     0,     0,     0,     0,
     370,   370,   370,     0,  1781,   816,  1793,     0,     0,     0,
       0,  1782,    74,  3243,  1783,     0,  1004,  1791,  1822,     0,
     668,     0,     0,     0,     0,  1778,     0,     0,     0,     0,
    3163,  1779,     0,     0,     0,  2491,  3170,     0,     0,     0,
       0,     0,  3244,   369,     0,     0,     0,  1930,     0,     0,
     370,     0,     0,  1824,     0,     0,     0,   370,   816,     0,
       0,     0,     0,     0,   370,     0,     0,  1784,  1004,     0,
       0,  1780,     0,  4372,  4414,     0,  2976,     0,   666,     0,
       0,     0,  4417,  4418,     0,  4567,  4568,     0,     0,  1928,
    4571,  4572,     0,     0,     0,     0,     0,     0,     0,     0,
    1793,  2996,     0,     0,   667,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1781,     0,   816,     0,  1785,     0,  1786,  1782,     0,  1043,
    1783,     0,     0,     0,     0,     0,  1787,     0,  3009,     0,
    3012,   667,     0,     0,  1788,     0,     0,     0,  1004,     0,
   -2141,  3468,     0,  1789,     0,     0,     0,     0,     0,     0,
       0,     0,  1043,     0,     0,     0,     0,  3878,  3878,  3878,
    3878,  3878,     0,     0,     0,  1004,     0,  1581,     0,     0,
       0,     0,     0,  1784,     0,     0,  3742,  1930,   667,     0,
    1791,     0,     0,   668,     0,     0,     0, -2141,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2141,
       0,     0,   667, -2141,     0,  3743,     0,     0, -2141,     0,
       0,     0,     0, -2141,     0,     0, -2141,     0, -2141,     0,
       0,     0,  2265,     0,     0,     0,     0,     0,  2199,     0,
    1785,  2200,  1786,     0,     0,     0,     0,     0,     0,     0,
       0,   666,  1787,  1043,     0, -2141,     0,     0,  2201,     0,
    1788,     0,  2491,     0,     0,     0,  2203,     0,     0,  1789,
       0,     0,  2204,  1793,   370,     0,     0, -2141,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4541,     0,     0,
       0,     0,     0,     0,   668,   369,  2205,     0,     0,     0,
       0,   369,  3784,     0,     0,     0,  1791,     0,     0,     0,
     668,  1006,     0,     0, -2141,     0,     0,     0,  4557,  4558,
       0,     0, -2141,     0,  1006,     0,     0,     0,     0,     0,
       0,  3785,   816,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   668,   668,     0,
    4731,     0,   666,  1754,     0,     0,     0,  3196,   668,  1928,
       0,  1930,     0,     0,     0,     0,     0,     0,   666, -2141,
     668,   668,  3217,     0,     0,     0,     0,     0,     0,     0,
    4587,  4588,     0,  4564,     0,  1755,     0,   667,     0,  1793,
       0,     0,   668,     0,     0,  4574,     0,  2206,     0,     0,
       0,  2207,     0,  1004,     0,   666,   666,     0,     0,     0,
       0,     0,     0,  1928,  1019,     0,   666,     0,     0,     0,
       0,     0,  2208,  2209,     0,     0,     0,     0,   666,   666,
       0,     0,  2199,     0,     0,  2200,     0,     0, -2141,  2210,
       0,  1756,  1928,     0,     0,     0,     0,     0,     0,     0,
     666,     0,  2201,     0,     0,     0,     0,     0,     0,     0,
    2203, -2141,   667, -2141, -2141,  2211,  2204,     0,  2212,     0,
       0,     0,  1757,     0,     0,     0,  1006,   667,   667,     0,
       0,  2213,     0,     0,  2214,     0,     0,     0,     0,     0,
    2205,     0,     0,     0,     0,     0, -2141,     0,     0, -2141,
   -2141,     0, -2141,  4677,   667,  4678,  4679,   667,  1758,     0,
       0,  3376,     0,     0,     0,  1928,  4682,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2989,  2989,
    2989,     0,     0,     0,  1928,     0,     0,     0,  1759,     0,
       0,   370,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1928,     0,     0,     0,     0,     0,  2215,     0,
       0,     0,     0,     0,     0,  1760,     0,     0,     0,     0,
       0,     0,  3468,     0,     0,     0,     0,     0,     0,     0,
    1928,     0,     0,     0,   369,   369,   369,     0,     0,     0,
       0,  2206,     0,     0,     0,  2207,     0,     0,  1761,   816,
       0,     0,   209,   667,     0,     0,  1762,     0,     0,     0,
       0,     0,  1763,     0,   667,     0,  2208,  2209,     0,  1764,
       0,     0,     0,   667,     0,     0,     0,  1765,     0,     0,
       0,   370,     0,  2210,     0,     0,  1766,     0,     0,     0,
       0,     0,     0,  1928,  1767,     0,     0,     0,  2216,  2217,
    2218,     0,  2219,  2220,  2221,  2222,  2223,  2224,     0,  2211,
       0,     0,  2212,     0,  3517,     0,     0,  3468,     0,  3468,
       0,  1930,     0,     0,     0,  2213,     0,     0,  2214,     0,
       0,     0,     0,     0,     0,   370,   667,   370,     0,     0,
       0,  4949,     0,     0,     0,  1768,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   668,     0,     0,     0,
       0,     0,     0,  2491,  3170,     0,  3170,     0,     0,     0,
       0,     0,     0,     0,     0,   369,     0,     0,     0,     0,
       0,     0,     0,   668,     0,     0,     0,   370,   668,     0,
     667,   668,   667,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2215,     0,   667,     0,   667,     0,     0,     0,
       0,     0,     0,   668,   666,     0,  1006,     0,     0,     0,
       0,     0,  1930,  4849,  1930,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1006,     0,
       0,   666,     0,     0,     0,   816,   666,     0,     0,   666,
       0,     0,     0,     0,   668,   667,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3601,     0,     0,     0,
       0,   666,     0,     0,     0,     0,     0,     0,  1930,  4875,
       0,   668,   668,     0,     0,   667,     0,     0,     0,     0,
    1928,     0,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,
    2223,  2224,   667,  1930,   370,   668,     0,   370,  3565,     0,
       0,     0,   666,  4902,     0,     0,     0,     0,     0,   667,
       0,     0,   667,  1043,  3170,     0,     0,     0,     0,   668,
       0,     0,     0,   668,     0,     0,     0,  3170,     0,   666,
     666,     0,     0,  5080,     0,     0,     0,     0,     0,     0,
       0,   668,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   668,   816,   666,     0,   816,     0,     0,     0,     0,
       0,     0,     0,     0,   668,     0,     0,     0,     0,     0,
       0,     0,     0,   668,     0,     0,     0,   666,     0,     0,
    5080,   666,     0,     0,     0,     0,     0,   369,  5080,     0,
       0,  1930,     0,     0,     0,     0,     0,  1188,  1190,   666,
       0,  1193,     0,  1195,     0,     0,     0,  3170,     0,   666,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1930,  1235,   666,     0,     0,     0,     0,     0,  1006,     0,
       0,   666,     0,     0,     0,   370,     0,     0,     0,     0,
       0,  1287,     0,     0,     0,  1290,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1313,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2199,  1930,   816,  2200,     0,   668,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2201,  1930,     0,     0,     0,     0,     0,     0,  2203,
       0,     0,     0,     0,     0,  2204,     0,  2199,     0,     0,
    2200,     0,     0,   668,     0,     0,     0,  1930,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2201,     0,  2205,
       0,     0,  3468,     0,   666,  2203,     0,  5068,     0,     0,
       0,  2204,  1928,     0,   667,     0,     0,  1928,  1928,     0,
       0,     0,     0,  1930,     0,     0,     0,     0,     0,  1928,
     668,     0,     0,     0,     0,  2205,     0,     0,     0,     0,
       0,   666,     0,     0,     0,     0,     0,  1006,     0,     0,
       0,     0,     0,   369,   668,     0,     0,   369,     0,   369,
       0,     0,  2199,     0,  2989,  2200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2201,     0,     0,     0,  3018,     0,   666,     0,
    2203,     0,     0,     0,  3916,  3917,  2204,     0,   667,  1006,
    2206,   667,     0,     0,  2207,     0,     0,     0,     0,     0,
    3926,     0,   666,     0,     0,     0,     0,     0,     0,     0,
    2205,     0,     0,     0,  3934,  2208,  2209,     0,     0,     0,
       0,     0,     0,  3943,     0,   369,  2206,   370,     0,     0,
    2207,     0,  2210,   370,     0,     0,     0,  3959,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2208,  2209,     0,     0,  3019,     0,     0,  2211,  1928,
       0,  2212,     0,     0,     0,     0,     0,     0,  2210,  1006,
       0,     0,     0,     0,  2213,     0,     0,  2214,     0,     0,
       0,     0,     0,     0,     0,   816,     0,     0,   667,   667,
       0,   816,     0,     0,  2211,   667,  1006,  2212,     0,     0,
       0,     0,     0,     0,     0,     0,  1800,  1801,  1581,  3170,
    2213,  2206,     0,  2214,     0,  2207,     0,     0,     0,   668,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1928,     0,  2208,  2209,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2215,     0,  2210,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   667,     0,     0,     0,   666,  1890,  2211,
       0,     0,  2212,     0,     0,     0,     0,  2215,     0,     0,
       0,     0,     0,     0,   668,  2213,     0,     0,  2214,  1948,
    1949,     0,     0,     0,     0,     0,     0,     0,     0,   668,
     668,     0,     0,     0,     0,     0,     0,     0,     0,  1980,
       0,     0,     0,     0,     0,     0,     0,  4099,  4100,  4101,
       0,     0,     0,  1928,     0,     0,   668,     0,     0,   668,
       0,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,
    2224,     0,   666,  1930,     0,  2917,  2013,  2015,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   666,   666,     0,
       0,     0,  2215,     0,     0,     0,     0,  2216,  2217,  2218,
       0,  2219,  2220,  2221,  2222,  2223,  2224,     0,     0,  2491,
       0,  3872,     0,     0,   666,     0,     0,   666,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   370,   370,   370,     0,
       0,     0,     0,  3020,  1006,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   668,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   668,     0,     0,     0,
       0,     0,     0,     0,     0,   668,     0,     0,     0,     0,
       0,     0,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,
    2223,  2224,     0,     0,   816,   816,   816,     0,     0,     0,
       0,     0,     0,     0,     0,   369,     0,     0,     0,     0,
       0,     0,     0,   666,     0,     0,     0,     0,     0,     0,
       0,  1930,     0,     0,   666,   667,     0,     0,     0,     0,
       0,     0,  1930,   666,     0,     0,     0,   667,   668,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2989,     0,     0,     0,   370,  2989,   712,
       0,     0,     0,     0,     0,  2199,     0,     0,  2200,     0,
    2989,   667,   668,     0,   668,     0,   666,     0,     0,     0,
       0,     0,     0,     0,     0,  2201,   668,     0,   668,     0,
       0,     0,     0,  2203,     0,     0,     0,   712,     0,  2204,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4330,     0,     0,     0,     0,   816,     0,     0,   712,     0,
       0,     0,     0,  2205,     0,     0,     0,  1930,     0,  4356,
     666,     0,   666,     0,     0,     0,  1015,   668,     0,     0,
       0,     0,     0,  1928,   666,     0,   666,     0,     0,  1016,
       0,     0,     0,     0,     0,  1930,  4373,  1024,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   668,     0,     0,
       0,  1930,     0,  1035,     0,  1015,     0,     0,     0,  1056,
       0,     0,     0,     0,   668,  1928,  1928,     0,  1928,  1086,
       0,     0,     0,     0,   667,   666,     0,  1091,     0,     0,
       0,   668,     0,     0,   668,     0,     0,     0,     0,     0,
       0,  2199,  4950,     0,  2200,     0,     0,  1930,     0,     0,
       0,     0,     0,     0,  2206,   666,     0,     0,  2207,     0,
       0,  2201,     0,     0,     0,     0,     0,     0,     0,  2203,
       0,     0,   666,     0,  1928,  2204,  1928,     0,     0,  2208,
    2209,     0,     0,     0,     0,     0,     0,     0,     0,   666,
       0,     0,   666,     0,     0,     0,  2210,     0,     0,  2205,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   370,
       0,     0,     0,     0,     0,  2514,     0,     0,     0,   667,
       0,   667,  2211,     0,     0,  2212,     0,     0,     0,     0,
    1928,     0,     0,     0,     0,     0,     0,     0,  2213,     0,
       0,  2214,     0,     0,     0,     0,     0,     0,     0,     0,
    4472,  4473,  4474,  4475,     0,  1928,     0,     0,     0,     0,
       0,     0,     0,  2199,  4670,     0,  2200,   816,     0,  2576,
    2577,  2578,  2579,     0,     0,     0,  1928,     0,     0,  3541,
       0,     0,     0,  2201,  3542,     0,     0,     0,     0,  1928,
       0,  2203,     0,   369,     0,   667,     0,  2204,     0,     0,
    2206,  1930,     0,     0,  2207,     0,     0,     0,     0,     0,
       0,  2615,  2616,     0,     0,  2215,     0,  2625,     0,     0,
       0,  2205,     0,     0,     0,  2208,  2209,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2210,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1928,     0,     0,     0,     0,     0,     0,
       0,     0,  2649,     0,     0,     0,     0,     0,  2211,  1928,
       0,  2212,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1928,     0,  2213,     0,   668,  2214,     0,  2684,
    2685,  2686,  2687,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2216,  2217,  2218,     0,  2219,
    2220,  2221,  2222,  2223,  2224,     0,     0,  3170,     0,  4027,
       0,     0,  2206,     0,     0,   370,  2207,     0,     0,   370,
       0,   370,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   666,     0,     0,  2208,  2209,  2746,
       0,     0,     0,   369,  1928,     0,     0,     0,  2750,     0,
       0,  2215,     0,     0,  2210,  2757,     0,     0,     0,     0,
     668,     0,     0,   668,  1928,     0,     0,     0,     0,     0,
       0,     0,     0,   816,     0,     0,     0,   816,     0,   816,
    2211,     0,     0,  2212,     0,     0,     0,     0,     0,  1928,
       0,     0,     0,     0,     0,     0,  2213,   370,     0,  2214,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3170,     0,   712,   666,     0,
       0,   666,     0,   838,     0,  1928,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1930,     0,
       0,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,
    2224,     0,     0,     0,  4672,   816,     0,     0,     0,     0,
     668,   668,     0,     0,     0,     0,     0,   668,  1930,   839,
       0,     0,     0,  2215,     0,     0,     0,     0,     0,     0,
       0,     0,   840,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   667,     0,     0,     0,     0,     0,   841,
       0,     0,     0,     0,     0,   842,     0,     0,  1930,     0,
       0,     0,  1930,  1930,     0,     0,     0,     0,   666,   666,
     843,     0,     0,  2930,     0,   666,     0,     0,     0,     0,
       0,   844,     0,     0,     0,     0,     0,     0,     0,   845,
       0,     0,     0,     0,     0,   668,     0,     0,     0,     0,
     846,     0,     0,     0,   667,   847,     0,     0,     0,     0,
       0,   848,     0,  2216,  2217,  2218,     0,  2219,  2220,  2221,
    2222,  2223,  2224,     0,     0,     0,   849,  4074,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4670,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   850,     0,   666,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1928,   851,  1183,  1189,  1189,   712,     0,  1189,     0,
    1197,     0,  1183,     0,  1086,     0,   369,  1222,     0,     0,
       0,     0,  1086,     0,  1086,     0,     0,     0,  1189,     0,
    1086,     0,     0,   852,     0,     0, -2143,     0,  1251,     0,
       0,     0,     0,  1086,  4792,  1183,     0,     0,  1189,     0,
     712,     0,  1189,     0,     0,     0,     0,     0,     0,  1222,
       0,   853,  1308,   369,     0,     0,     0,     0,     0,  1189,
       0,   369,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1581,     0, -2143,     0,     0,     0,     0,   854,     0,
       0,     0,   855,     0,   856, -2143,     0,     0,     0, -2143,
     857,  1183,     0,   858, -2143,     0,   712,     0,     0, -2143,
       0,  1183, -2143,     0, -2143,  1222,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   859,
    1189,   860,     0,     0,     0,   861,     0,   370,  3124,  3125,
    3126, -2143,     0,   862,     0,  1928,     0,  3136,   863,  3138,
       0,  3140,  3141,     0,     0,     0,     0,   668,     0,     0,
     864,     0,     0, -2143,     0,     0,     0,     0,    85,   668,
       0,     0,     0,   865,    89,  4882,     0,     0,    93,     0,
      94,  1928,    96,    97,     0,  1086,     0,     0,     0,     0,
       0,     0,     0,   106,     0,   816,     0,     0,  1086,  1456,
   -2143,     0,     0,     0,     0,     0,     0,     0, -2143,     0,
     119,   120,     0,     0,     0,   666,     0,     0,     0,     0,
       0,     0,     0,   668,     0,  1563,     0,   666,     0,   712,
    1086,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1086,     0,
       0,     0,  1086,  3248,     0, -2143,   128,     0,     0,     0,
    1563,     0,     0,     0,     0,     0,   129,     0,   130,   131,
    1086,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   666,  1086,  1119,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1928,     0,     0,     0,     0,     0,     0,
    1019,     0,     0,   141,  1928,   142,   143,     0,     0,  3306,
       0,   146,     0,   147,     0,     0,     0,  3315,     0,     0,
       0,     0,  3316,   149, -2143,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   153,
       0,   154,     0,     0,   157,     0,   668, -2143,     0, -2143,
   -2143,     0,     0,     0,     0,     0,   158,     0,   159,     0,
       0,     0,   160,     0,  1086,     0,     0,     0,   161,     0,
       0,  1086,     0,  1189,  1189,     0,   163,     0,   165,     0,
       0,     0, -2143,     0,   167, -2143, -2143,     0, -2143,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   171,     0,
       0,     0,     0,  3401,   666,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1183,     0,  1928,
       0,     0,     0,     0,     0,     0,     0,     0,  1183,     0,
       0,     0,  1222,     0,     0,  3437,     0,  3439,     0,     0,
       0,   668,     0,   668,     0,  1189,     0,  1928,     0,     0,
       0,     0,     0,   184,   185,     0,     0,     0,     0,   186,
    1086,  2199,     0,  1928,  2200,     0,  1189,  1189,   187,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   192,
       0,  2201,  1086,  1086,  1086,     0,  1189,     0,  1183,  2203,
       0,     0,  1988,     0,     0,  2204,     0,     0,     0,   666,
       0,   666,     0,     0,     0,     0,     0,     0,     0,  1928,
       0,     0,     0,     0,     0,   370,   203,   668,     0,  2205,
       0,  1189,     0,  1189,  1189,     0,     0,     0,   205,     0,
       0,     0,     0,   206,   207,     0,   208,     0,     0,     0,
       0,   209,     0,     0,  3494,     0,   210,     0,     0,   212,
       0,     0,     0,   214,     0,     0,     0,  1563,   215,   216,
       0,     0,     0,     0,     0,     0,   217,     0,     0,   219,
       0,     0,     0,   816,     0,   666,     0,   222,     0, -2156,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   224,
       0,     0,     0,     0,     0,  2087,  2087,     0,     0,     0,
    1086,     0,  1015,     0,     0,     0,   229,     0,   230,     0,
       0,     0,     0,     0,     0,     0,   232,  1086,     0,     0,
    2206,     0,   233,     0,  2207,  2122, -2156,   234,  1086,     0,
       0,  2128,     0,     0,     0,     0,     0,     0, -2156,   237,
       0,     0, -2156,  1563,     0,  2208,  2209, -2156,     0,     0,
       0,     0, -2156,     0,     0, -2156,     0, -2156,     0,     0,
       0,     0,  2210,  1928,     0,     0,     0,     0,     0,     0,
       0,     0,  1563,   247,     0,   370,     0,  -136,     0,     0,
       0,     0,     0,     0, -2156,     0,     0,     0,  2211,     0,
       0,  2212,     0,     0,     0,     0,     0,     0,     0,     0,
    1563,  1563,     0,  1563,  2213,     0, -2156,  2214,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1563,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   816,     0,     0,     0,     0,     0,     0,
     712,   712,     0, -2156,     0,     0,     0,     0,     0,     0,
       0, -2156,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1086,
       0,     0,  1563,     0,     0,     0,     0,     0,     0,  1928,
       0,  2215,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2156,     0,
       0,  1563,     0,     0,     0,  1563,  1563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1086,  1086,  2339,     0,
       0,     0,     0,     0,     0,   668,     0,  3723,     0,  3724,
    3725,  3726,     0,     0,     0,     0,  2199,     0,     0,  2200,
       0,     0,     0,  1019,   712,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2201,     0,     0,     0,
       0,     0,     0,     0,  2203,     0,     0, -2156,     0,     0,
    2204,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,
    2224,     0,     0,   666,     0,  4153,   668,  1928,     0,     0,
   -2156,     0, -2156, -2156,  2205,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1928,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2156,     0,     0, -2156, -2156,
       0, -2156,     0,     0,     0,     0,     0,     0,     0,     0,
    1928,     0,  1086,  2499,   666,     0,     0,     0,     0,  1086,
       0,     0,  1189,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   370,  1222,
       0,     0,     0,     0,     0,  1086,     0,     0,  1086,     0,
    1928,     0,     0,     0,  1928,  1928,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2206,     0,     0,  1086,  2207,
       0,  1920,     0,     0,     0,     0,  1189,  1189,  1189,  1189,
    1086,     0,     0,     0,     0,   370,     0,     0,     0,     0,
    2208,  2209,     0,   370,  1086,     0,   816,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2607,  2210,  1086,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1189,  1189,
       0,     0,     0,     0,  1189,     0,     0,     0,     0,     0,
       0,     0,     0,  2211,     0,     0,  2212,     0,     0,     0,
       0,     0,     0,   816,     0,     0,     0,     0,     0,  2213,
       0,   816,  2214,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1189,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2199,     0,     0,
    2200,     0,     0,     0,     0,     0,  1189,  1189,  1189,  1189,
       0,     0,     0,     0,     0,     0,     0,  2201,  1086,     0,
    3992,     0,     0,  3993,  1086,  2203,     0,  2607,     0,     0,
       0,  2204,     0,     0,     0,     0,  2215,     0,     0,     0,
       0,     0,  1183,     0,  1920,     0,     0,     0,     0,   712,
       0,  1183,     0,     0,     0,  2205,     0,     0,     0,     0,
       0,  1222,     0,     0,     0,     0,  1189,     0,     0,     0,
       0,  4019,     0,     0,     0,  1189,     0,     0,     0,     0,
       0,  1189,  1189,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1086,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2216,  2217,  2218,  2087,
    2219,  2220,  2221,  2222,  2223,  2224,  1189,     0,  1183,     0,
    4180,     0,  1086,  1086,     0,  1189,     0,     0,     0,     0,
       0,  1086,     0,     0,     0,     0,  2206,     0,     0,     0,
    2207,     0,     0,     0,     0,     0,     0,     0,  1015,  1015,
       0,     0,  2828,     0,     0,     0,  1563,  1563,     0,     0,
       0,  2208,  2209,     0,  1563,     0,     0,  1563,     0,     0,
       0,  1563,     0,     0,     0,     0,     0,     0,  2210,  1563,
    1563,     0,     0,     0,     0,     0,     0,  1563,     0,  1222,
    1563,  1563,  1563,  1563,     0,     0,     0,     0,     0,     0,
    1563,  1563,     0,  1563,  2211,  1563,  1563,  2212,     0,  1563,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2213,     0,     0,  2214,     0,     0,  1563,     0,     0,     0,
    1189,  1563,     0,     0,     0,  1563,     0,     0,     0,  1563,
       0,  1563,  1563,  1563,  1563,  1563,  1563,  1563,  1563,  1563,
       0,  1563,     0,     0,     0,     0,  1086,  1563,     0,     0,
    1563,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1086,     0,     0,     0,     0,  4203,  4204,  4205,  4206,
       0,     0,     0,     0,  1920,     0,     0,  2215,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1086,     0,
    1086,     0,  1563,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2199,
       0,     0,  2200,     0,     0,     0,     0,     0,  1920,     0,
       0,     0,     0,     0,     0,     0,     0,  1086,     0,  2201,
       0,     0,     0,  3042,     0,  3049,     0,  2203,     0,     0,
       0,     0,     0,  2204,     0,     0,     0,  1920,     0,     0,
    2199,     0,     0,  2200,     0,     0,     0,  2216,  2217,  2218,
       0,  2219,  2220,  2221,  2222,  2223,  2224,  2205,     0,     0,
    2201,  4437,     0,     0,     0,     0,     0,     0,  2203,     0,
       0,     0,     0,     0,  2204,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   712,     0,
       0,     0,     0,  1015,     0,  1015,     0,     0,  2205,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1920,     0,  1563,     0,  4348,     0,     0,     0,     0,     0,
       0,     0,     0,  1183,     0,  1189,  1189,  1189,     0,  1920,
    1183,     0,  1222,     0,  1189,     0,  1189,     0,  1189,  1189,
    2199,     0,  1086,  2200,     0,     0,     0,  1920,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2206,     0,
    2201,     0,  2207,     0,     0,     0,     0,     0,  2203,     0,
       0,     0,     0,     0,  2204,  1920,     0,     0,     0,     0,
    2499,     0,     0,  2208,  2209,     0,  3178,     0,     0,     0,
       0,  3187,     0,     0,     0,     0,     0,  1086,  2205,  2206,
    2210,     0,     0,  2207,     0,     0,     0,     0,     0,     0,
       0,     0,  1086,     0,     0,     0,  3222,  3222,     0,     0,
       0,     0,     0,   712,  2208,  2209,  2211,     0,     0,  2212,
       0,     0,     0,     0,     0,     0,     0,     0,  1920,     0,
    1189,  2210,  2213,     0,     0,  2214,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4066,     0,  3280,  2211,  3283,  3285,
    2212,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2199,  2213,     0,  2200,  2214,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1189,     0,     0,  2206,
       0,     0,  2201,  2207,  1189,     0,     0,     0,     0,  1189,
    2203,     0,     0,     0,     0,     0,  2204,     0,     0,  2215,
       0,     0,  1563,     0,  2208,  2209,     0,     0,     0,     0,
       0,     0,     0,  4067,     0,     0,     0,     0,     0,     0,
    2205,  2210,     0,     0,     0,     0,  2499,     0,     0,  3222,
       0,  1086,     0,  3378,     0,     0,  1015,     0,     0,     0,
    2215,     0,     0,     0,     0,     0,     0,  2211,     0,     0,
    2212,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3280,  2213,     0,     0,  2214,     0,     0,     0,
    1189,  3403,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1988,     0,     0,     0,     0,     0,  2216,
    2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,  2224,     0,
    1189,     0,  1189,  3222,  1189,  3222,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1920,     0,     0,     0,     0,
       0,  2206,     0,     0,     0,  2207,     0,  1563,     0,     0,
    2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,  2224,
    2215,     0,     0,     0,  4471,     0,  2208,  2209,  2087,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2210,     0,     0,     0,     0,  4580,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4583,     0,     0,     0,     0,     0,     0,  2211,
       0,     0,  2212,     0,  1183,     0,     0,     0,     0,     0,
    1183,     0,     0,     0,     0,  2213,     0,     0,  2214,     0,
       0,  1189,     0,     0,     0,     0,     0,  1563,  1563,     0,
       0,     0,     0,  1563,     0,     0,     0,     0,     0,     0,
    2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,  2224,
       0,     0,     0,     0,  4698,     0,     0,     0,  1563,  1563,
       0,     0,     0,  1563,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1563,  1563,  1563,  1563,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1563,     0,
    4649,  1563,  2215,  1563,  3569,     0,     0,     0,     0,     0,
       0,     0,     0,  1563,  1563,     0,     0,  1563,     0,  2199,
       0,     0,  2200,     0,     0,     0,     0,     0,     0,     0,
    1563,     0,  1563,     0,  1222,     0,  1563,     0,     0,  2201,
       0,     0,     0,     0,     0,     0,     0,  2203,     0,     0,
       0,     0,  1563,  2204,     0,     0,  1086,     0,     0,     0,
       0,     0,     0,  3615,     0,  1563,  1563,  1563,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2205,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1563,
       0,     0,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,
    2223,  2224,  1563,     0,     0,     0,  4740,  1563,   824,     0,
       0,     0,     0,  1563,     0,     0,     0,  1920,     0,     0,
       0,  3615,  1920,  1920,  3674,     0,     0,     0,  3049,     0,
       0,     0,     0,     0,  1920,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4745,  4747,
    4747,     0,     0,   824,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2199,     0,     0,  2200,     0,  2206,     0,
       0,  1563,  2207,  3222,     0,     0,     0,     0,  2087,     0,
       0,     0,     0,  2201,     0,     0,     0,     0,     0,     0,
    1047,  2203,     0,  2208,  2209,     0,     0,  2204,  1047,     0,
    1047,     0,     0,     0,  1189,     0,  1189,  1189,  1189,     0,
    2210,     0,   824,     0,     0,     0,     0,     0,     0,     0,
       0,  2205,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     4,     0,     0,     0,     0,  2211,     0,     0,  2212,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,  2213,     0,     0,  2214,     0,     0,     0,     0,
       0,     6,     7,     0,  1920,     0,     0,     8,     0,     9,
      10,     0,  4835,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,     0,    36,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2206,     0,     0,     0,  2207,     0,     0,  2215,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1920,
       0,     0,     0,     0,     0,     0,     0,  2208,  2209,     0,
       0,     0,     0,     0,  4879,     0,     0,     0,     0,     0,
      46,     0,     0,     0,  2210,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4898,     0,  4900,
       0,     0,     0,     0,  3222,  3222,     0,     0,     0,     0,
    2211,     0,     0,  2212,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2213,  3879,     0,  2214,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2216,
    2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,  2224,     0,
      47,     0,     0,  4794,  1086,  1086,     0,     0,  1920,     0,
       0,     0,     0,     0,     0,     0,     0,    48,     0,     0,
    1086,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2087,  1086,     0,     0,    49,     0,     0,
       0,     0,  2087,  1086,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2215,  4747,     0,     0,  1086,     0,    50,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   712,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1189,     0,     0,
    1189,     0,     0,     0,     0,    51,     0,     0,    52,     0,
       0,     0,     0,     0,     0,  5000,     0,  1183,     0,     0,
       0,     0,     0,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1086,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1189,     0,
       0,     0,     0,  2216,  2217,  2218,  1563,  2219,  2220,  2221,
    2222,  2223,  2224,     0,     0,     0,  1563,  5003,     0,     0,
       0,     0,  1563,  5036,  1563,     0,     0,     0,     0,     0,
    1563,     0,     0,  1563,  1563,  1563,  1563,  1563,  1563,  1563,
    1563,  1563,  1563,     0,     0,     0,  1563,  1563,    54,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1563,
       0,     0,     0,  1563,     0,     0,     0,  1563,     0,     0,
       0,     0,  5073,     0,     0,     0,     0,  1563,     0,     0,
    1563,     0,  1563,     0,     0,     0,     0,     0,     0,     0,
      55,  1563,  1563,  1563,     0,     0,     0,  1563,     0,     0,
    1563,     0,  2199,     0,    56,  2200,     0,  1086,  1086,  1086,
    1183,  3615,  4110,     0,     0,     0,  4110,  4124,     0,    57,
       0,  1563,  2201,     0,     0,     0,     0,  4138,     0,  1563,
    2203,  1563,     0,     0,     0,     0,  2204,     0,     0,     0,
       0,     0,     0,     0,     0,    58,     0,     0,     0,     0,
       0,    59,     0,     0,     0,    60,    61,    62,    63,    64,
    2205,     0,    65,    66,    67,    68,     0,    69,    70,    71,
      72,    73,     0,     0,  1563,     0,     0,     0,  1920,     0,
    1563,     0,     0,     0,  3049,     0,  1563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4186,  2087,  2087,     0,  2607,     0,     0,     0,     0,
    1920,  1920,     0,  1920,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1189,  1189,  1189,  1189,     0,     0,     0,
       0,   824,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
       0,  2206,     0,     0,     0,  2207,     0,     0,     0,     0,
       0,  4229,     0,     0,     0,     0,     0,     0,     0,  1920,
       0,  1920,     0,     0,     0,     0,  2208,  2209,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2210,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2211,
       0,     0,  2212,     0,     0,  1920,     0,     0,     0,  2199,
       0,     0,  2200,  4290,     0,  2213,     0,  1185,  2214,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,  2201,
    1920,     0,  3504,     0,     0,     0,     0,  2203,     0,     0,
       0,     0,     0,  2204,     0,     0,     0,     0,     0,     0,
       0,  1920,  3879,     0,     0,     0,     0,     0,     0,     0,
    1086,     0,     0,     0,  1920,     0,     0,  2205,     0,     0,
       0,  1189,     0,  1563,     0,     0,     0,     0,     0,  1086,
       0,     0,     0,     0,     0,  4361,     0,     0,     0,     0,
       0,     0,  2215,     0,  2499,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1086,     0,     0,     0,
       0,     0,     0,     0,     0,  3280,     0,     0,     0,     0,
       0,  4390,     0,     0,     0,     0,     0,     0,  1920,     0,
       0,     0,     0,     0,     0,     0,     0,  1563,  1563,     0,
       0,  1185,     0,     0,  1920,     0,     0,  1047,     0,     0,
       0,  1047,     0,     0,     0,     0,     0,  1920,     0,     0,
       0,     0,  3222,     0,  3222,     0,     0,     0,  2206,     0,
       0,     0,  2207,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,
    2223,  2224,     0,  2208,  2209,     0,  5092,     0,  1563,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2210,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1920,
       0,     0,     0,     0,     0,  1563,  2211,     0,     0,  2212,
       0,     0,     0,     0,     0,  1563,  1563,     0,     0,  1920,
       0,     0,  2213,  1563,  1563,  2214,     0,     0,  1563,     0,
       0,     0,     0,     0,  1563,  1563,     0,     0,  1563,     0,
    1086,  1086,  1086,  1086,  1920,     0,     0,  4110,  4124,  4110,
       0,     0,  4479,     0,     0,     0,  3615,     0,     0,     0,
    3615,     0,     0,     0,     0,     0,  4492,     0,     0,     0,
    1563,     0,     0,     0,     0,  1563,     0,     0,     0,     0,
    1920,  4502,     0,     0,     0,     0,     0,  1563,     0,     0,
       0,     0,     0,     0,     0,     0,  1222,     0,     0,  2215,
       0,     0,     0,  1185,  3674,     0,     0,     0,  3049,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,  2199,  1015,     0,  2200,  1563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1931,     0,     0,
       0,     0,  2201,     0,     0,     0,  3222,  3222,     0,     0,
    2203,     0,     0,     0,     0,     0,  2204,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4555,     0,     0,     0,  1185,     0,     0,     0,     0,     0,
    2205,     0,     0,     0,     0,     0,     0,     0,     0,  2216,
    2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,  2224,     0,
       0,  1551,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1189,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1189,
       0,     0,     0,     0,     0,     0,  1622,     0,     0,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  5066,
       0,     0,     0,     0,     0,     0,     0,     0,  3879,  3879,
    3879,  3879,  3879,     0,     0,     0,  1920,     0,     0,     0,
       0,  2206,     0,     0,     0,  2207,     0,     0,     0,     0,
       0,     0,  1563,     0,     0,     0,     0,     0,     0,     0,
    1931,     0,     0,  1183,     0,     0,  2208,  2209,  2499,     0,
       0,     0,     0,     0,     0,  2087,     0,     0,     0,     0,
       0,     0,     0,  2210,     0,     0,     0,  1189,  2499,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2199,     0,     0,  2200,     0,     0,     0,  2211,
       0,     0,  2212,     0,  1086,     0,  4676,     0,  1185,     0,
       0,     0,  2201,     0,     0,  2213,     0,     0,  2214,     0,
    2203,     0,     0,     0,     0,     0,  2204,     0,     0,     0,
       0,     0,     0,     0,  1563,  5067,  1185,  1185,     0,  1185,
       0,     0,     0,  1563,     0,     0,     0,     0,     0,     0,
    2205,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
    1563,  1563,     0,     0,  1563,     0,     0,     0,     0,     0,
    1920,     0,     0,  4110,     0,     0,     0,  3615,     0,     0,
       0,     0,  3615,     0,     0,  3615,  3280,     0,  4720,     0,
    1563,  1563,  2215,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1920,     0,  1185,   824,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4186,  1222,  1189,  1189,  1189,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,  1185,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,  2206,     0,     0,     0,  2207,     0,     0,     0,     0,
       0,     0,  1183,  1222,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2208,  2209,     0,     0,
       0,     0,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,
    2223,  2224,     0,  2210,     0,     0,     0,     0,     0,     0,
       0,  2087,     0,     0,     0,  1183,     0,     0,     0,     0,
       0,     0,     0,     0,  1086,     0,     0,     0,  1920,  2211,
    1931,     0,  2212,     0,     0,  4361,   824,     0,     0,  1920,
       0,     0,  3222,  1047,  2199,  2213,  2499,  2200,  2214,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4390,     0,
       0,  1086,  3519,     0,  2201,     0,     0,  3549,     0,  1189,
    4186,     0,  2203,     0,     0,     0,  1047,     0,  2204,  2137,
       0,     0,     0,     0,  1931,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1563,     0,     0,  1563,     0,  1563,
       0,     0,  2205,     0,     0,     0,     0,     0,  2161,     0,
       0,     0,     0,  1931,     0,     0,  1563,     0,     0,     0,
    3615,     0,  2215,  4720,     0,     0,     0,     0,     0,  4869,
       0,     0,     0,     0,     0,     0,  2186,  2187,     0,  2190,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1189,     0,     0,  1920,  1086,  2230,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1047,     0,     0,
       0,     0,     0,  1189,  1189,  1189,  1189,     0,     0,     0,
       0,     0,  1920,     0,     0,     0,  1931,     0,  2087,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1920,     0,
       0,     0,     0,  2206,     0,  1931,  1183,  2207,  2284,     0,
       0,     0,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,
    2223,  2224,     0,  1931,     0,  1563,     0,     0,  2208,  2209,
       0,     0,     0,     0,     0,     0,     0,  2307,     0,     0,
       0,  2319,  2322,     0,  1920,  2210,   824,     0,     0,     0,
       0,  1931,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2211,     0,     0,  2212,  1563,     0,     0,     0,     0,
       0,  1189,     0,  1222,     0,     0,     0,  2213,     0,     0,
    2214,     0,  1563,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
       0,     0,     0,     0,  1931,     0,     0,  1185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1189,     0,     0,     0,     0,  1183,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4186,     0,
       0,     0,     0,     0,     0,     0,     0,  4676,     0,     0,
       0,     0,     0,     0,  2215,     0,  4869,     0,     0,  1563,
    1563,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1183,     0,     0,     0,     0,     0,     0,     0,
    1189,     0,     0,     0,     0,     0,     0,     0,  1920,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1563,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1563,     0,     0,     0,     0,  1189,
       0,     0,  1185,  1185,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,  1185,  2216,  2217,  2218,  1185,  2219,  2220,
    2221,  2222,  2223,  2224,     0,  1185,  1185,     0,     0,     0,
       0,     0,     0,  1185,     0,     0,  1185,  1185,  1185,  1185,
       0,     0,     0,     0,     0,     0,  1185,  1185,     0,  1185,
       0,  1185,  1185,     0,     0,  1185,  1563,     0,     0,     0,
       0,     0,     0,     0,     0,  1183,     0,     0,     0,     0,
       0,  1931,  1185,   824,  1920,     0,     0,  1185,     0,     0,
       0,  1185,     0,     0,     0,  1185,     0,  1185,  1185,  1185,
    1185,  1185,  1185,  1185,  1185,  1185,     0,  1185,     0,     0,
       0,     0,     0,  1185,     0,  2199,  1185,     0,  2200,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2201,     0,     0,     0,     0,
       0,     0,     0,  2203,     0,     0,     0,     0,     0,  2204,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2205,     0,     0,     0,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1920,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1920,     0,     0,     0,     0,
       0,     0,     0,  2199,     0,     0,  2200,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2201,     0,  1920,  3560,     0,     0,     0,
       0,  2203,     0,     0,     0,     0,     0,  2204,  3554,     0,
    2199,     0,     0,  2200,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2206,     0,     0,     0,  2207,   824,
    2201,  2205,     0,     0,     0,  1920,     0,     0,  2203,  1920,
    1920,     0,     0,     0,  2204,     0,     0,     0,     0,  2208,
    2209,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
    2856,     0,     0,     0,     0,     0,  2210,     0,  2205,  1185,
       0,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,  2879,     0,     0,  2881,     0,     0,  2892,
       0,     0,  2211,     0,     0,  2212,  2899,  2904,     0,     0,
       0,     0,  2910,     0,     0,  2915,     0,  1047,  2213,     0,
       0,  2214,     0,  1931,     0,     0,     0,     0,  1931,  1931,
       0,     0,  2924,     0,     0,     0,     0,  2931,     0,     0,
    1931,  2943,  2206,     0,     0,  2950,  2207,  2952,  2953,  2954,
    2955,  2956,  2957,  2958,  2959,  2960,   824,  2961,     0,   824,
       0,     0,     0,  1551,     0,     0,  2986,  2208,  2209,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2206,
       0,     0,     0,  2207,  2210,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2215,     0,     0,     0,     0,
       0,     0,     0,     0,  2208,  2209,     0,     0,     0,     0,
    2211,     0,     0,  2212,     0,     0,     0,     0,     0,     0,
       0,  2210,     0,     0,     0,     0,  2213,     0,  1622,  2214,
       0,     0,     0,     0,     0,  1045,     0,     0,     0,     0,
       0,     0,     0,  1045,     0,  1045,     0,  2211,     0,     0,
    2212,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2213,     0,     0,  2214,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
    1931,     0,     0,     0,     0,  2216,  2217,  2218,     0,  2219,
    2220,  2221,  2222,  2223,  2224,     0,     0,   824,     0,     0,
       0,     0,     0,  2215,  2199,     0,     0,  2200,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2201,     0,     0,  4073,     0,     0,
       0,     0,  2203,     0,     0,     0,     0,     0,  2204,     0,
    2215,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2199,     0,     0,  2200,  1931,     0,     0,  3111,     0,
       0,     0,  2205,     0,     0,     0,  4023,     0,     0,     0,
       0,  2201,     0,     0,     0,     0,     0,     0,     0,  2203,
       0,     0,     0,     0,     0,  2204,     0,     0,     0,     0,
       0,     0,     0,  2216,  2217,  2218,     0,  2219,  2220,  2221,
    2222,  2223,  2224,  1185,     0,     0,     0,     0,     0,  2205,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,  2224,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1931,     0,     0,     0,     0,     0,
       0,     0,     0,  2206,     0,     0,     0,  2207,     0,     0,
    1185,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2208,  2209,
       0,     0,     0,  1185,  1185,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,  2210,     0,     0,     0,     0,
    2206,     0,     0,     0,  2207,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1185,  1185,     0,     0,     0,  1185,
    1252,  2211,     0,     0,  2212,  2208,  2209,     0,     0,     0,
       0,  1185,  1185,  1185,  1185,     0,     0,  2213,     0,   824,
    2214,     0,  2210,     0,  1185,   824,     0,  1185,     0,  1185,
       0,     0,     0,  1253,     0,     0,     0,     0,  3327,  1185,
    1185,     0,     0,  1185,     0,     0,  1254,  1255,  2211,     0,
       0,  2212,     0,     0,     0,  1256,  1185,     0,  1185,  1257,
       0,     0,  1185,     0,  2213,     0,     0,  2214,     0,     0,
       0,     0,     0,     0,     0,     0,  1258,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,  1185,  1185,  1185,  2215,     0,     0,  1259,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1260,     0,
       0,     0,     0,     0,     0,  1185,  1261,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1262,  1185,     0,
       0,     0,  1263,  1185,     0,     0,     0,     0,     0,  1185,
       0,  2215,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,  1264,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3451,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1265,     0,
       0,     0,     0,     0,  2216,  2217,  2218,     0,  2219,  2220,
    2221,  2222,  2223,  2224,     0,     0,     0,     0,     0,  1266,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1267,  2216,  2217,  2218,  1931,  2219,  2220,  2221,  2222,  2223,
    2224,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3500,     0,     0,     0,   853,  3506,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1931,  1931,     0,  1931,
       0,     0,     0,     0,     0,  1268,     0,     0,     0,  1269,
       0,  1270,     0,     0,     0,     0,     0,  1271,     0,     0,
    1272,  2904,     0,  2904,  2904,     0,     0,     0,   824,   824,
     824,     0,     0,     0,  3563,     0,     0,  3566,     0,  3568,
       0,     0,     0,     0,     0,     0,  1273,     0,  1274,     0,
       0,     0,  1275,     0,  1181,  1931,     0,  1931,     0,     0,
    1276,     0,     0,  1181,     0,  1277,  3589,     0,  3591,     0,
       0,     0,  3594,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1278,     0,     0,     0,     0,     0,  1181,     0,     0,     0,
       0,  2986,  2986,  2986,     0,     0,     0,     0,     0,     0,
       0,  1931,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3652,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1931,     0,  2307,     0,
       0,     0,     0,  3664,     0,     0,     0,     0,     0,  2322,
       0,     0,  1181,     0,   880,     0,     0,  1931,     0,     0,
       0,     0,  1181,     0,     0,     0,   881,     0,     0,   824,
    1931,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   882,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     883,     0,     0,     0,     0,     0,     0,     0,     0,   884,
       0,     0,     0,  -736,     0,     0,     0,  3703,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     885,     0,     0,     0,  1931,     0,   886,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1931,   887,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   888,  1931,     0,     0,     0,     0,     0,     0,
     889,     0,     0,     0,     0,     0,  1181,     0,     0,     0,
       0,   890,  1045,     0,     0,     0,  1045,     0,   891,     0,
       0,     0,   892,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -938,     0,     0,
       0,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,  1931,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,   893,     0,  1185,     0,
    1185,     0,     0,  -501,     0,  1931,  1185,     0,     0,  1185,
    1185,  1185,  1185,  1185,  1185,  1185,  1185,  1185,  1185,     0,
       0,     0,  1185,  1185,     0,     0,     0,     0,     0,     0,
    1931,     0,     0,     0,   894,  1185,     0,   895,     0,  1185,
       0,   824,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,     0,     0,  1185,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,  1931,  1185,  1185,  1185,
       0,  -398,     0,  1185,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,  1185,     0,   896,
       0,     0,     0,     0,     0,   897,     0,  1185,     0,     0,
       0,  -398,     0,     0,   898,  1185,     0,  1185,     0,     0,
       0,     0,     0,  1922,     0,     0,     0,     0,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1181,
    -398,     0,   899,   900,     0,   901,   902,     0,     0,     0,
       0,     0,     0,     0,   903,     0,     0,     0,     0,   904,
    1185,     0,  1929,     0,     0,   905,  1185,     0,   906,     0,
       0,   907,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -398,     4,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,  1181,
       0,     0,     0,     0,     0,     5,     0,     0,     0,     0,
       0,  1923,     0,     0,     0,     6,     7,     0,     0,     0,
       0,     0,     0,     9,    10,     0,     0,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,   824,  1181,     0,
       0,   824,  1931,   824,     0,     0,     0,     0,     0,     0,
       0,     0,  4024,     0,     0,     0,  1922,     0,     0,     0,
       0,     0,  4028,     0,     0,     0,     0,     0,  4029,     0,
    4030,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,  4048,  4049,     0,  1929,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2910,     0,     0,     0,     0,     0,   824,
       0,     0,     0,  4077,  1181,     0,  4080,     0,  4082,     0,
       0,     0,     0,     0,     0,     0,     0,  4086,     0,     0,
       0,     0,     0,  4091,  1923,     0,  4094,     0,     0,     0,
       0,     0,     0,  1181,    47,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,  4127,     0,     0,
       0,    48,     0,     0,     0,  4139,     0,  2986,     0,     0,
       0,  1181,  1181,     0,  1181,     0,  1931,     0,     0,     0,
       0,    49,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,     0,     0,     0,     0,     0,     0,
    4156,     0,  1931,  1185,  1185,     0,  1551,     0,     0,     0,
       0,     0,  1622,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    51,
       0,     0,    52,  1181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    53,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,  1185,     0,  1181,  1181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,  1922,     0,     0,     0,
       0,  1185,  1185,     0,  1931,     0,     0,     0,     0,  1185,
    1185,     0,    54,     0,  1185,  1931,     0,     0,     0,     0,
    1185,  1185,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1929,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,  1185,     0,  1045,     0,
    1922,     0,     0,     0,    55,     0,  1185,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,     0,    56,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,  1922,
       0,  1045,     0,    57,  1923,     0,     0,     0,     0,  1929,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    58,
       0,     0,  1185,     0,     0,    59,     0,     0,  1929,    60,
      61,    62,    63,    64,     0,     0,    65,    66,  1381,     0,
    1931,     0,     0,    71,  1382,     0,     0,     0,  1923,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   824,
       0,     0,  1922,     0,     0,     0,     0,     0,  1931,     0,
       0,     0,     0,     0,     0,     0,     0,  1923,     0,     0,
       0,  1922,  1045,     0,  1931,     0,     0,     0,     0,     0,
       0,     0,     0,  4403,  4404,     0,     0,     0,     0,  1922,
       0,  1929,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1929,     0,     0,     0,     0,     0,     0,  1922,     0,     0,
    1931,     0,     0,     0,     0,     0,     0,     0,  1929,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1923,     0,     0,     0,  4435,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1929,     0,     0,  1923,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1923,  1185,     0,
    1922,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,  4453,  4455,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4462,  1923,     0,     0,     0,     0,
    4467,  4468,     0,  1181,  4470,     0,     0,     0,     0,  1929,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1931,     0,     0,
       0,     0,     0,     0,     0,     0,  2986,     0,     0,     0,
       0,  2986,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2986,     0,     0,     0,     0,  1923,     0,
    1185,     0,     0,     0,  1931,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,  1185,     0,     0,
    1185,     0,  4526,     0,     0,     0,     0,     0,     0,  1181,
       0,     0,     0,  1185,     0,     0,     0,     0,  1185,     0,
       0,  1185,     0,     0,     0,     0,  1185,  1185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1181,  1181,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,  1181,  1185,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
    1181,  1181,     0,     0,     0,     0,     0,  1922,  1181,     0,
       0,  1181,  1181,  1181,  1181,     0,     0,     0,     0,     0,
    1931,  1181,  1181,     0,  1181,     0,  1181,  1181,  1185,     0,
    1181,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1929,  1181,     0,     0,
       0,     0,  1181,     0,     0,     0,  1181,   824,     0,     0,
    1181,     0,  1181,  1181,  1181,  1181,  1181,  1181,  1181,  1181,
    1181,  1185,  1181,     0,     0,     0,     0,     0,  1181,     0,
       0,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1923,     0,     0,  4622,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,     0,  1931,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,     0,
    1185,  1931,     0,  1185,     0,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,  1185,     0,     0,     0,
       0,  1931,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   824,     0,     0,
    4706,  1931,     0,     0,     0,  1931,  1931,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4723,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,  1181,     0,     0,     0,     0,  1922,
       0,  1181,     0,     0,  1922,  1922,     0,     0,     0,     0,
       0,  1931,     0,     0,     0,     0,  1922,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1045,     0,     0,     0,     0,     0,  1929,     0,
       0,  1185,     0,  1929,  1929,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1929,     0,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1923,     0,     0,
       0,     0,  1923,  1923,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,  1923,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1185,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
       0,     0,     0,  2910,     0,     0,  1922,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4860,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1925,     0,     0,     0,
    1185,     0,     0,  1181,     0,  1929,     0,     0,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     824,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1922,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1923,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,   824,     0,     0,
    1929,  1185,     0,     0,     0,   824,     0,     0,     0,     0,
       0,  4931,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1181,  1923,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1922,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4976,  1925,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1929,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1181,  1181,
       0,     0,     0,     0,  1181,     0,     0,     0,  1923,     0,
       0,     0,     0,     0,     0,  5022,  5022,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1181,
    1181,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1181,  1181,  1181,  1181,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1181,
       0,     0,  1181,   923,  1181,     0,     0,     0,     0,     0,
    5022,     0,   923,     0,  1181,  1181,     0,     0,  1181,     0,
    5070,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1181,     0,  1181,     0,     0,     0,  1181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   923,  1181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,  1181,  1181,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  5022,     0,     0,     0,  1100,     0,     0,     0,
    1181,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,  1181,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1925,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1922,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1925,     0,     0,     0,     0,     0,  1929,
       0,     0,  1922,  1922,     0,  1922,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1925,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1929,  1929,     0,  1929,     0,     0,     0,  1923,     0,
       0,     0,     0,     0,     0,  1149,     0,     0,     0,     0,
       0,  1922,     0,  1922,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1923,  1923,     0,  1923,     0,  1925,     0,     0,     0,     0,
    1929,     0,  1929,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1925,     0,     0,  1922,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1925,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1922,     0,     0,     0,     0,     0,     0,  1923,
       0,  1923,     0,     0,     0,     0,  1929,     0,     0,     0,
    1925,     0,     0,  1922,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1922,     0,     0,     0,
       0,  1929,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1929,     0,     0,  1923,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1929,     0,     0,     0,     0,
       0,     0,     0,  1925,     0,     0,     0,     0,     0,     0,
    1923,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1922,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1923,     0,     0,     0,     0,  1922,     0,     0,     0,
       0,     0,     0,     0,  1923,     0,     0,     0,     0,  1922,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1929,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1929,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1929,     0,
       0,     0,     0,     0,     0,   923,   923,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1923,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1181,     0,
       0,  1922,     0,     0,  1923,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1923,     0,     0,
       0,  1922,     0,  1149,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1181,     0,     0,
    1929,     0,     0,     0,     0,     0,  1922,  1181,     0,     0,
       0,     0,     0,  1181,     0,  1181,     0,     0,     0,     0,
    1929,  1181,     0,     0,  1181,  1181,  1181,  1181,  1181,  1181,
    1181,  1181,  1181,  1181,     0,     0,     0,  1181,  1181,     0,
    1925,     0,  1922,     0,     0,  1929,     0,     0,     0,  1923,
    1181,     0,     0,     0,  1181,     0,     0,     0,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1181,  1923,
       0,  1181,     0,  1181,     0,     0,     0,     0,     0,     0,
       0,  1929,  1181,  1181,  1181,     0,     0,     0,  1181,     0,
       0,  1181,     0,     0,  1923,     0,     0,     0,     0,     0,
       0,  1181,  1181,     0,  1196,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,  1225,  1226,     0,  1229,     0,  1232,
    1181,  1234,  1181,     0,     0,     0,     0,     0,     0,     0,
    1923,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1285,     0,     0,     0,     0,     0,     0,     0,  1293,     0,
       0,     0,     0,     0,     0,     0,     0,  1309,  1310,     0,
       0,     0,  1312,     0,     0,  1181,     0,     0,     0,     0,
       0,  1181,     0,     0,     0,     0,     0,  1181,     0,  1149,
       0,   923,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1343,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1366,     0,     0,  1368,     0,  1370,     0,  1373,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   923,     0,     0,     0,     0,  1922,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1929,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1453,     0,
    1454,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1149,  1925,     0,     0,     0,  1923,  1925,  1925,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1925,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1100,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1922,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1922,     0,
       0,  1929,     0,     0,     0,     0,     0,  1712,     0,  1714,
       0,     0,     0,  1716,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1745,     0,     0,     0,  1929,  1181,  1181,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1923,     0,     0,     0,     0,     0,     0,     0,     0,  1925,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1863,
       0,     0,     0,     0,     0,     0,  1923,     0,     0,     0,
       0,     0,     0,     0,     0,  1876,     0,     0,     0,  1181,
       0,     0,     0,     0,     0,     0,     0,     0,  1886,     0,
    1922,     0,     0,     0,     0,  1888,     0,     0,     0,     0,
       0,  1922,     0,     0,     0,     0,     0,  1937,     0,     0,
    1941,     0,     0,     0,  1925,     0,  1181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1181,  1181,     0,  1929,
       0,     0,     0,     0,  1181,  1181,     0,     0,     0,  1181,
    1929,     0,     0,  1984,     0,  1181,  1181,     0,     0,  1181,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1181,     0,     0,
       0,  1181,     0,     0,     0,     0,     0,     0,  1923,     0,
       0,  1181,     0,     0,     0,     0,  1181,     0,     0,  1923,
       0,     0,     0,     0,     0,     0,     0,     0,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     672,     0,     0,  1925,     0,   716,  1922,   716,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   716,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1181,     0,     0,
       0,     0,     0,     0,  1922,     0,     0,     0,     0,     0,
       0,     0,     0,   716,     0,  1929,     0,     0,     0,     0,
    1922,     0,     0,   716,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   716,   716,     0,     0,   716,     0,
       0,     0,     0,  1929,   716,     0,     0,     0,  1007,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1929,
       0,     0,     0,     0,  1923,     0,  1922,     0,  1007,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   716,     0,     0,     0,     0,     0,
       0,     0,  1923,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1929,     0,     0,  1923,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1923,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1100,  2300,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1922,     0,  1929,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,     0,  1929,
       0,     0,     0,  2370,  1181,     0,  2370,     0,     0,     0,
       0,     0,     0,     0,  2377,     0,     0,     0,     0,     0,
       0,  1181,  1181,  1925,     0,  1181,     0,     0,     0,     0,
       0,     0,  2386,     0,     0,     0,     0,   716,  1181,     0,
       0,     0,     0,  1181,     0,     0,  1181,     0,  1923,     0,
       0,  1181,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1925,  1925,     0,  1925,     0,
    2456,     0,     0,     0,     0,     0,  1922,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1929,     0,     0,     0,     0,
       0,     0,     0,  1181,  1925,     0,  1925,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1923,     0,  1181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1926,
    1925,     0,     0,     0,  1922,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1925,     0,  1922,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1181,     0,  1929,     0,     0,  1925,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1922,     0,  1925,
       0,     0,     0,     0,     0,  1181,  1929,     0,  1181,     0,
    1181,     0,     0,   716,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2659,     0,     0,     0,  1181,     0,     0,
       0,  1181,  1923,     0,     0,     0,  1929,  1922,  2682,     0,
       0,  1922,  1922,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1923,     0,   716,   716,     0,
       0,     0,     0,  1925,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1929,     0,     0,  1925,
    1929,  1929,     0,     0,  2730,  1923,     0,     0,     0,     0,
       0,     0,  1925,     0,     0,     0,     0,     0,     0,  2745,
       0,  2747,  1926,  2748,     0,   716,     0,     0,  2749,     0,
       0,     0,     0,     0,     0,  1927,     0,  1181,     0,     0,
       0,     0,     0,     0,     0,  1923,     0,     0,     0,  1923,
    1923,     0,     0,     0,     0,     0,  1181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1929,  2777,     0,     0,
       0,     0,     0,     0,  1925,     0,     0,     0,     0,  2300,
       0,     0,     0,  2300,     0,  2300,     0,     0,  2300,     0,
       0,     0,     0,     0,  1925,     0,  1181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,  1925,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1925,     0,     0,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1181,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1927,     0,
    1181,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,     0,
    1331,   716,     0,   716,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2990,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,   716,     0,     0,   716,   716,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   672,
       0,  1007,  1926,  1007,     0,     0,     0,     0,     0,   672,
       0,     0,     0,   716,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1007,  1007,     0,     0,     0,  1181,     0,     0,
       0,     0,     0,     0,     0,     0,  1181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1926,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1925,     0,   716,     0,   716,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1926,     0,  1149,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3079,  3080,     0,     0,     0,  3083,
    3084,     0,     0,  3087,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3097,     0,     0,     0,     0,     0,     0,
    3106,     0,     0,     0,  3109,  3110,     0,     0,  3113,  3114,
       0,     0,     0,     0,     0,  3119,     0,     0,     0,     0,
       0,     0,   672,     0,     0,     0,     0,  3135,  1926,  3137,
       0,     0,     0,     0,     0,     0,   672,   672,     0,     0,
    1694,     0,     0,     0,     0,  3159,     0,  1926,  1927,     0,
    3161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1926,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3179,  3180,  3183,  3185,  1925,   672,     0,  3192,  3195,
       0,     0,     0,  1926,     0,     0,  3206,     0,     0,  3210,
       0,     0,  1927,  3214,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1925,     0,     0,  3242,     0,     0,     0,     0,     0,
       0,  1927,     0,     0,     0,  3249,     0,  3251,     0,     0,
       0,     0,  3254,     0,     0,     0,     0,  3258,  3259,  3260,
    3261,     0,  3263,     0,     0,     0,  1926,     0,     0,     0,
       0,     0,     0,     0,     0,  3287,  3288,  3289,     0,     0,
       0,     0,     0,     0,     0,     0,  3297,  3298,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1927,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1927,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1925,     0,     0,  3352,     0,     0,     0,
       0,  1927,     0,     0,  1925,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1927,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   672,     0,     0,     0,     0,   716,     0,   716,     0,
       0,   716,     0,   716,     0,     0,   716,   716,   716,     0,
       0,     0,  2082,     0,     0,     0,     0,     0,     0,   716,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   716,     0,   716,     0,     0,     0,     0,   716,
       0,     0,  1927,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1926,     0,     0,     0,  1149,     0,  1925,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2300,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1925,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3479,     0,
       0,     0,     0,  1925,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2240,     0,  1925,
       0,     0,     0,     0,     0,     0,   716,   716,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   672,     0,     0,     0,     0,   672,   672,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1927,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     716,     0,   672,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2374,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3655,     0,     0,     0,     0,     0,
       0,     0,     0,  1925,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1926,   672,     0,     0,     0,
    1926,  1926,     0,     0,   672,     0,     0,     0,     0,     0,
       0,     0,  1926,     0,     0,  3694,  3695,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2300,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   672,     0,  3717,   672,   672,
       0,     0,     0,     0,     0,     0,  3721,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1925,
       0,  3732,  3734,     0,     0,     0,  3734,     0,     0,     0,
       0,  3745,  3746,  3747,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   672,     0,     0,     0,     0,  3768,  3769,  3770,
    3771,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1926,     0,     0,     0,     0,  3787,  3788,  3789,
       0,  1186,     0,     0,     0,     0,     0,  3802,     0,     0,
    1186,  1927,     0,     0,     0,     0,  1927,  1927,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1925,  1927,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,     0,
    1925,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1926,     0,     0,
       0,  3841,     0,     0,     0,     0,     0,     0,     0,  3845,
    1925,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1925,     0,     0,     0,  1925,  1925,     0,     0,     0,     0,
       0,     0,     0,  3913,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   716,     0,   716,     0,     0,     0,   716,
       0,   716,     0,     0,   716,     0,     0,     0,   716,     0,
       0,     0,     0,  2240,     0,     0,  1926,     0,  1927,     0,
       0,     0,     0,     0,     0,  3941,     0,     0,  3944,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   923,
       0,     0,  3984,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,  3994,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2300,
       0,     0,     0,  1927,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2082,     0,     0,     0,     0,     0,     0,  2991,
       0,     0,     0,     4,     0,     0,     0,     0,  2374,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1927,     5,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     6,     7,     0,     0,     0,     0,     0,
       0,     9,    10,     0,     0,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
       0,     0,   672,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,     0,    45,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   672,     0,     0,     0,   672,  1932,
       0,     0,    46,     0,  3063,     0,  1694,     0,     0,   716,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1926,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,  4197,     0,  4198,     0,     0,     0,     0,     0,
       0,  4200,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4209,  1926,  1926,
       0,  1926,    47,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4217,     0,     0,     0,     0,    48,
       0,     0,     0,  4228,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,     0,    49,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1926,     0,  1926,
       0,    50,     0,     0,     0,     0,     0,     0,     0,  4260,
    4261,  4262,  4263,  4264,  4265,  4266,  4267,     0,     0,     0,
       0,  4274,  4275,     0,  4277,  4278,  4279,  4280,  4281,  4282,
    4283,     0,  1932,     0,     0,     0,     0,    51,     0,  4291,
      52,  4293,  4294,     0,     0,     0,     0,     0,     0,     0,
     672,     0,     0,  1926,     0,    53,     0,     0,   672,     0,
     672,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1927,     0,     0,     0,     0,     0,  1926,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1186,  4342,  4344,  4346,     0,     0,  4349,     0,     0,  1926,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1926,     0,  1927,  1927,     0,  1927,  1186,  1186,
       0,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
      54,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    55,  1927,     0,  1927,  1926,  3734,     0,     0,
       0,     0,     0,     0,     0,     0,    56,     0,     0,     0,
    1186,     0,  1926,     0,     0,     0,     0,  2300,  2300,  2300,
       0,    57,     0,     0,     0,  1926,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
       0,     0,     0,  1186,  1186,     0,     0,    58,     0,  1927,
       0,     0,     0,    59,     0,     0,     0,    60,    61,    62,
      63,    64,     0,     0,    65,    66,  1381,  2039,     0,     0,
       0,    71,     0,     0,  1927,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1927,     0,  1926,     0,   716,
    2082,     0,     0,     0,     0,     0,     0,     0,  1927,     0,
       0,     0,     0,     0,     0,     0,   672,  1926,     0,     0,
       0,     0,  1932,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1926,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1927,     0,     0,     0,  1932,     0,  1926,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1927,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1927,     0,     0,     0,  1932,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4545,
    4546,  4547,  4548,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4560,  4561,  4562,  4563,     0,  4565,  4566,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4575,  4576,     0,  1927,     0,     0,     0,     0,  1932,     0,
       0,     0,     0,     0,     0,     0,     0,  2300,  2300,     0,
    2300,     0,     0,  1927,     0,     0,     0,  1932,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1932,  2374,     0,  1927,     0,
       0,   672,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1932,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1927,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1926,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4636,     0,     0,     0,     0,     0,
       0,     0,     0,  4642,     0,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,  1932,     0,     0,  1186,
       0,     0,     0,     0,  4661,     0,     0,     4,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,  4680,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     7,     0,
       0,     0,     0,     0,     0,     9,    10,     0,     0,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,  1186,     0,    45,  2300,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2300,     0,     0,     0,     0,     0,  1926,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1186,  1186,     0,     0,     0,     0,
       0,     0,  1186,     0,     0,  1186,    46,     0,     0,  1186,
    1927,     0,     0,     0,  1926,     0,     0,  1186,  1186,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,  1186,  1186,
    1186,  1186,     0,     0,     0,     0,     0,     0,  1186,  1186,
       0,  1186,     0,  1186,  1186,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,  4767,     0,     0,     0,
       0,     0,     0,  1932,  1186,     0,     0,     0,     0,  1186,
       0,     0,     0,  1186,     0,     0,    47,  1186,     0,  1186,
    1186,  1186,  1186,  1186,  1186,  1186,  1186,  1186,     0,  1186,
       0,     0,     0,    48,     0,  1186,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,   672,     0,     0,
       0,     0,     0,    49,     0,     0,     0,     0,     0,     0,
     672,     0,     0,     0,     0,     0,  1926,     0,     0,     0,
       0,     0,     0,     0,     0,    50,     0,  1926,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3734,     0,  1927,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    51,     0,     0,    52,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2300,     0,    53,
    1927,     0,     0,     0,     0,     0,     0,  2300,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   716,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4885,     0,     0,     0,     0,  4889,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2300,  1926,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    54,     0,     0,     0,     0,     0,
       0,     0,   672,     0,     0,     0,     0,     0,     0,     0,
    1926,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,  1926,     0,     0,     0,
       0,  1186,  1927,     0,     0,     0,    55,     0,  1186,     0,
       0,     0,     0,  1927,     0,     0,     0,     0,     0,     0,
      56,     0,     0,  3734,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    57,     0,     0,     0,     0,
    2300,     0,  1926,     0,     0,  1932,     0,     0,     0,     0,
    1932,  1932,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    58,  1932,     0,     0,     0,     0,    59,     0,     0,
       0,    60,    61,    62,    63,    64,     0,     0,    65,    66,
    1381,  2758,     0,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4995,     0,     0,     0,     0,  4999,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1927,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1927,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3063,     0,     0,
       0,     0,  1927,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1926,     0,     0,     0,
    1186,     0,  1932,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1927,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   672,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1932,     0,     0,
       0,     0,     0,     0,   672,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1926,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1927,     0,     0,     0,  1932,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,  1186,     0,     0,     0,
    1926,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1926,     0,     0,  1186,  1186,     0,     0,
       0,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,  1186,  1186,  1186,     0,     0,     0,
       0,     0,     0,  1926,     0,     0,  1186,     0,     0,  1186,
       0,  1186,     0,     0,   672,     0,     0,     0,  1927,     0,
       0,  1186,  1186,     0,     0,  1186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
    1186,     0,     0,  1926,  1186,     0,     0,  1926,  1926,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1186,     0,  1186,  1186,  1186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1186,  2226,     0,     0,     0,  1186,     0,     0,     0,     0,
       0,  1186,     0,     0,     0,     0,  1927,     0,     0,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1927,
       0,     0,     0,     0,     0,     0,     0,  2374,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1927,
       0,     0,  2226,   672,     0,     0,     0,     0,     0,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1932,     0,     0,  1927,
       0,     0,     0,  1927,  1927,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   672,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1932,  1932,
       0,  1932,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   672,     0,  1932,     0,  1932,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   672,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1932,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1932,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     4,     0,  1932,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1932,     0,     0,     0,     0,     5,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     7,     0,
       0,     0,     0,     0,     0,     9,    10,     0,     0,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,  1932,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1932,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   716,  1932,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    46,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     672,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1186,     0,     0,  1932,     0,     0,
       0,     0,     0,     0,  1186,  2226,     0,     0,     0,     0,
    1186,     0,  1186,     0,     0,     0,    47,  1932,  1186,     0,
       0,  1186,  1186,  1186,  1186,  1186,  1186,  1186,  1186,  1186,
    1186,     0,     0,    48,  1186,  1186,     0,     0,     0,     0,
       0,     0,  1932,     0,     0,     0,     0,  1186,     0,     0,
       0,  1186,     0,    49,     0,  1186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,  1186,     0,
    1186,     0,     0,     0,     0,    50,     0,     0,  1932,  1186,
    1186,  1186,     0,     0,     0,  1186,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,  2226,  1186,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
       0,    51,     0,     0,    52,     0,     0,  1186,     0,  1186,
       0,  2226,     0,     0,     0,     0,  2888,     0,     0,    53,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2226,  2226,     0,     0,
    2226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2226,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
       0,     0,     0,     0,    54,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2226,     0,    55,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   672,     0,
      56,     0,     0,     0,     0,     0,     0,  2226,     0,     0,
       0,     0,     0,     0,  1932,    57,     0,     0,     0,  2226,
       0,     0,  2226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    58,     0,     0,     0,     0,     0,    59,     0,     0,
       0,    60,    61,    62,    63,    64,     0,     0,    65,    66,
    1381,     0,     0,     0,     0,    71,     0,     0,     0,    86,
      87,    88,     0,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,     0,     0,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115,     0,   116,   117,   118,     0,     0,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,  1186,   126,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1932,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,  1932,  1186,  1186,     0,   140,     0,
       0,     0,     0,     0,     0,   144,     0,   145,     0,     0,
       0,     0,     0,   148,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   151,     0,     0,     0,     0,     0,
     152,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     155,   156,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   162,     0,     0,
       0,     0,     0,     0,     0,   164,     0,     0,     0,   166,
       0,     0,     0,     0,   168,     0,     0,     0,     0,     0,
     169,     0,   170,  1186,     0,     0,     0,     0,   172,     0,
       0,     0,     0,  1186,  1186,     0,  1932,   173,     0,     0,
       0,  1186,  1186,     0,     0,     0,  1186,  1932,     0,     0,
     174,   175,  1186,  1186,     0,     0,  1186,   176,     0,   177,
       0,     0,   178,   179,     0,   180,     0,     0,     0,     0,
       0,     0,     0,     0,  1186,     0,   181,   182,  1186,   183,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,   188,
     189,   190,     0,     0,   191,  1186,     0,     0,   193,     0,
       0,   194,     0,   195,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   196,   197,   198,   199,
     200,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     201,     0,   202,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   204,     0,     0,     0,     0,
       0,     0,  1932,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   211,     0,     0,   213,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1932,     0,     0,     0,     0,   218,     0,     0,   220,     0,
     221,     0,     0,     0,     0,     0,  1932,     0,     0,     0,
       0,     0,     0,   223,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   225,   226,     0,     0,     0,
     227,     0,   228,     0,     0,     0,     0,     0,     0,     0,
       0,   231,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1932,     0,     0,     0,   235,     0,     0,   236,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,     0,     0,     0,  2226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3053,  2226,
    1186,  2226,     0,  2888,  2888,  3537,     0,     0,  2888,     0,
       0,  1186,  2226,     0,     0,     0,     0,     0,     0,  2226,
       0,     0,     0,     0,  2226,     0,     0,     0,     0,     0,
    2226,     0,     0,     0,     0,  2226,     0,     0,     0,     0,
       0,     0,     0,     0,  2226,     0,     0,     0,  2888,  2888,
       0,  2226,     0,     0,     0,     0,     0,     0,     0,  1932,
       0,     0,     0,  2226,     0,     0,     0,     0,     0,     0,
    2226,     0,  2226,  2226,  2226,  2226,  2226,  2226,  2226,  2226,
    2226,  2226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,     0,     0,     0,  1932,     0,     0,     0,
       0,  1186,     0,     0,     0,     0,  2226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,  1186,
       0,     0,  1186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,     0,     0,
    1186,     0,     0,  1186,     0,     0,     0,     0,  1186,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1932,     0,     0,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
    1932,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,  1932,     0,  1186,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1186,     0,     0,     0,  1186,     0,
       0,     0,     0,  1932,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1932,     0,     0,     0,  1932,  1932,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2226,     0,     0,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1932,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1186,  1186,     0,
    2226,     0,     0,     0,     0,     0,  2226,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3537,  3537,     0,  2888,     0,     0,  2888,  2888,
    2888,  2888,  2888,  2888,  2888,  2888,  2888,  2888,  3537,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,  2226,     0,     0,  2226,     0,  2226,     0,
       0,     0,     0,  3537,  3537,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2888,  2888,  2226,
       0,  2226,     0,     0,  2226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2888,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    86,    87,    88,     0,    90,
      91,    92,     0,     0,     0,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,     0,     0,     0,
     107,   108,   109,   110,     0,   111,   112,   113,   114,   115,
       0,   116,   117,   118,     0,     0,     0,     0,     0,   121,
     122,     0,     0,     0,     0,   123,     0,     0,     0,     0,
       0,     0,     0,     0,   124,     0,   125,     0,   126,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  2226,     0,     0,     0,  2226,  2226,
    2226,     0,     0,  3537,     0,     0,     0,     0,  3537,  3537,
    3537,  3537,  3537,  3537,  3537,  3537,  3537,  3537,  2226,  2226,
       0,     0,     0,     0,   133,     0,     0,     0,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,  2226,  2888,  2888,
    2226,   144,  2226,   145,     0,     0,  2226,  3537,  3537,   148,
       0,  2226,     0,     0,  2226,     0,     0,     0,     0,     0,
     151,     0,     0,     0,     0,     0,   152,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   155,   156,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2226,
       0,     0,     0,   162,     0,     0,     0,     0,     0,     0,
       0,   164,     0,     0,     0,   166,  2226,     0,     0,     0,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   172,     0,     0,     0,     0,     0,
       0,     0,     0,   173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   175,     0,     0,
       0,     0,     0,   176,     0,   177,     0,     0,   178,   179,
       0,   180,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   181,   182,     0,   183,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,   193,     0,     0,   194,     0,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,   197,   198,   199,   200,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   204,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   211,     0,     0,   213,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   218,     0,     0,   220,     0,   221,     0,     0,     0,
    3537,     0,     0,     0,     0,     0,     0,     0,     0,   223,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   225,   226,     0,     0,     0,   227,     0,   228,     0,
       0,     0,     0,     0,     0,     0,     0,   231,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   235,  2226,  2226,   236,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   238,
     239,   240,   241,   242,   243,   244,   245,   246,     0,     0,
       0,     0,     0,     0,     0,  2226,     0,     0,     0,  2888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2226,  3055,  2226,     0,     0,     0,     0,
    3537,  3537,  2226,     0,     0,  2888,  2888,  2226,  2226,     0,
    2226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      86,    87,    88,     0,    90,    91,    92,     0,     0,     0,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,     0,     0,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115, -2389,   116,   117,   118,     0,
       0,     0,     0,     0,   121,   122,  2226,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,   127,    35,     0,   412,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   133,
       0,     0,     0,   135,   136,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   140,
       0,     0,     0,     0,     0,     0,   144,     0,   145,     0,
       0,     0,  2226,     0,   148,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
       0,   152,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   155,   156,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   162,     0,
       0,     0,     0,     0,     0,     0,   164,     0,  3537,  2888,
     166,     0,     0,     0,     0,   168,     0,     0,     0,     0,
       0,   169,     0,   170,  3537,  3537,  2226,     0,     0,   172,
       0,     0,     0,     0,     0,     0,     0,     0,   173,     0,
       0,     0,     0,  2226,     0,     0,     0,     0,     0,     0,
       0,   174,   175,     0,     0,     0,     0,     0,   176,     0,
     177,     0,     0,   178,   179,     0,   180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   181,   182,     0,
     183,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,   190,     0,     0,   191,     0,     0,     0,   193,
       0,     0,   194,     0,   195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   196,   197,   198,
     199,   200,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   204,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3537,     0,     0,     0,     0,     0,   211,     0,     0,   213,
    2226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   218,     0,     0,   220,
       0,   221,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   223,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   225,   226,     0,     0,
       0,   227,     0,   228,     0,     0,     0,     0,     0,     0,
       0,     0,   231,     0,     0,     0,     0,     0,     0,     0,
       0,  2226,     0,     0,     0,     0,     0,   235,     0,     0,
     236,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   238,   239,   240,   241,   242,   243,
     244,   245,   246,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,  2226,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
    2226,     0,   418,   419,   420,   421,   422,   423,   424,   425,
     733,   426,   427,   428,   734,   735,   736,   737,   738,   739,
     740,   429,   430,   741,   431,   432,   133,   433,   434,   435,
     135,   136,   137,   138,   139,   742,   436,   437,   438,   439,
     440,   743,   744,   441,   442,   745,   140,   443,   746,   444,
     445,   446,   447,   144,   747,   145,   748,   448,   449,   450,
     451,   148,   452,   749,   750,   453,   454,   455,   456,   457,
     458,   751,   151,   459,   752,   753,   754,   755,   152,   756,
     757,   758,   460,   461,   462,   463,   695,   464,   155,   156,
     465,   759,   466,   760,   467,   468,   469,   470,   471,   761,
     472,   473,   474,   762,   763,   475,   476,   477,   478,   479,
     764,   480,   481,   482,   765,   483,   484,   485,   766,   486,
     487,   488,   489,   164,   490,   491,   492,   166,   767,   493,
     768,   494,   168,   495,   769,   496,   770,   497,   169,   771,
     170,   498,   499,   500,   772,   501,   172,   773,   502,   774,
     503,   504,   697,   505,   506,   173,   507,   508,   509,   775,
     510,   511,   512,   513,   514,   515,   776,   516,   174,   175,
     777,   517,   518,   519,   778,   176,   779,   177,   780,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,   781,
     527,   528,   782,   529,   181,   182,   530,   183,   783,   531,
     532,   533,   784,   785,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,   189,   190,
     545,   546,   191,   786,   547,   548,   193,   549,   787,   194,
     550,   195,   551,   552,   553,   788,   554,   789,   790,   555,
     556,   557,   791,   792,   196,   197,   198,   199,   200,   558,
     559,   560,   561,   562,   563,   564,   793,   565,   201,   566,
     202,   567,   568,   569,   794,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,   795,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
     796,   593,   594,   211,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,   797,   604,   605,   606,   607,
     608,   798,   609,   218,   610,   611,   220,   612,   221,   613,
     799,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,   800,   624,   625,   801,   626,   627,   628,   629,
     630,   631,   802,   225,   226,   803,   804,   633,   227,   634,
     228,   805,   635,   636,   637,   638,   639,   640,   641,   806,
     807,   642,   643,   644,   645,   646,   808,   809,   647,   648,
     649,   650,   651,   810,   235,   811,   652,   236,   653,   654,
     655,   812,   813,   656,   814,   815,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    85,     0,     0,    86,    87,    88,    89,
      90,    91,    92,    93,     0,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   967,   104,   105,   106,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115,     0,   116,   117,   118,   119,   120,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
     127,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   129,     0,   130,   131,     0,     0,     0,     0,     0,
       0,     0,     0,   132,     0,   133,     0,     0,   134,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,   141,     0,
     142,   143,   144,     0,   145,     0,   146,     0,   147,     0,
     148,     0,     0,     0,     0,     0,     0,     0,   149,     0,
     150,   151,     0,     0,     0,     0,     0,   152,     0,     0,
       0,     0,     0,     0,   153,     0,   154,   155,   156,   157,
       0,     0,     0,     0,     0, -1396,     0,     0,     0,     0,
       0,   158,     0,   159,     0,     0,     0,   160,     0,     0,
       0,     0,     0,   161,   162,     0,     0,     0,     0,     0,
       0,   163,   164,   165,     0,     0,   166,     0,     0,   167,
       0,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,   171,     0,   172,     0,     0,     0,     0,
       0,     0,     0,     0,   173,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   174,   175,     0,
       0, -1396,     0,     0,   176,     0,   177,     0,     0,   178,
     179,     0,   180,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   181,   182,     0,   183,     0,   184,   185,
       0,     0,     0,     0,   186,     0,     0,     0,     0,     0,
       0,     0,     0,   187,     0,     0,   188,   189,   190,     0,
       0,   191,     0,     0,   192,   193,     0,     0,   194,     0,
     195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   196,   197,   198,   199,   200,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   201,     0,   202,
       0,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   204,   205,     0,     0,     0,     0,   206,   207,
       0,   208,     0,     0,     0,     0,   209,     0,     0,     0,
       0,   210,   211,     0,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,     0,
       0,   217,   218,     0,   219,   220,     0,   221,     0,     0,
       0,     0,   222,     0,     0,     0,     0,     0,     0,     0,
     223,     0,     0,     0,   224,     0,     0,     0,     0,     0,
       0,     0,   225,   226,     0,     0,     0,   227,     0,   228,
       0,   229,     0,   230,     0,     0,     0,     0,   231,     0,
       0,   232,     0,     0, -1396,     0,     0,   233,     0,     0,
       0,     0,   234,   235,     0,     0,   236,     0,     0,     0,
       0,     0,     0,     0,   237,     0,     0,     0,     0,     0,
     238,   239,   240,   241,   242,   243,   244,   245,   246,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   726,
      86,    87,    88,   678,    90,    91,    92,   679,   247,   680,
      95,     0,  -136,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,   417,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1470,  1471,  1472,
      45,  1473,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,  2980,   426,   427,   428,     0,     0,     0,
       0,  1474,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,   135,  1475,   137,  1476,  1477,     0,   436,
     437,   438,   439,   440,  1478,  1479,   441,   442,  1480,  1481,
     443,     0,   444,   445,   446,   447,  1482,     0,  1483,     0,
     448,   449,   450,   451,   148,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,  1484,  1485,
    1486,  1487,  1488,  1489,  1490,   460,   461,   462,   463,   695,
     464,  1491,  1492,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,  2981,     0,   475,   476,
    1493,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,  1494,   490,   491,   492,
    1495,  1496,   493,     0,   494,  1497,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,  1498,
       0,   502,     0,   503,   504,   697,   505,   506,   173,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,   175,     0,   517,   518,   519,  1499,  1500,     0,
    1501,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,  1502,   182,   530,
     183,     0,   531,   532,   533,  1503,  1504,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
    1505,   189,  1506,   545,   546,   191,  1507,   547,   548,   193,
     549,  1508,  1509,   550,  1510,   551,   552,   553,     0,   554,
       0,     0,  1511,   556,   557,     0,     0,   196,   197,   198,
     199,  1512,   558,   559,   560,   561,   562,   563,   564,     0,
     565,  1513,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,  1514,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,  1515,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,  1516,   609,   218,   610,   611,   220,
     612,  1517,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,  1518,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,  1519,  1520,     0,     0,
     633,  1521,   634,  1522,  1523,   635,   636,   637,   638,   639,
     640,   641,     0,  1524,   642,   643,   644,   645,   646,  1525,
       0,   647,   648,   649,   650,   651,   701,  1526,  2982,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,  1527,  1528,  1529,  1530,  1531,
    1532,  1533,  1534,   702,   662,   663,     0,     0,     0,     0,
       0,     0,     0,  1535,  1536,  2983,     0,     0,     0,     0,
       0,     0,  1538,  2984,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,   417,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1470,  1471,  1472,    45,  1473,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,  1474,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,  1475,
     137,  1476,  1477,     0,   436,   437,   438,   439,   440,  1478,
    1479,   441,   442,  1480,  1481,   443,     0,   444,   445,   446,
     447,  1482,     0,  1483,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,
     460,   461,   462,   463,   695,   464,  1491,  1492,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,  1493,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,  1494,   490,   491,   492,  1495,  1496,   493,     0,   494,
    1497,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,  1498,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,  1499,  1500,     0,  1501,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,  1502,   182,   530,   183,     0,   531,   532,   533,
    1503,  1504,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,  1505,   189,  1506,   545,   546,
     191,  1507,   547,   548,   193,   549,  1508,  1509,   550,  1510,
     551,   552,   553,     0,   554,     0,     0,  1511,   556,   557,
       0,     0,   196,   197,   198,   199,  1512,   558,   559,   560,
     561,   562,   563,   564,     0,   565,  1513,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,  1514,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,  1515,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,  1516,
     609,   218,   610,   611,   220,   612,  1517,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,  1518,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,  1519,  1520,     0,     0,   633,  1521,   634,  1522,  1523,
     635,   636,   637,   638,   639,   640,   641,     0,  1524,   642,
     643,   644,   645,   646,  1525,     0,   647,   648,   649,   650,
     651,   701,  1526,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
    1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,   662,
     663,     0,     0,     0,     0,     0,     0,     0,  1535,  1536,
       0,     0,     0,     0,     0,     0,     0,  1538,  2890,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,     0,  1898,   137,  1899,  1900,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,  1901,  1902,
     443,     0,   444,   445,   446,   447,     0,     0,   145,     0,
     448,   449,   450,   451,   148,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,     0,     0,
       0,   152,     0,     0,     0,   460,   461,   462,   463,   695,
     464,  1903,  1904,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
    1493,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,     0,   490,   491,   492,
       0,     0,   493,     0,   494,  1905,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,     0,
       0,   502,     0,   503,   504,   697,   505,   506,   173,   507,
     508,   509,  2479,   510,   511,   512,   513,   514,   515,     0,
     516,   174,  2480,     0,   517,   518,   519,  1499,  1906,     0,
    1907,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,     0,   182,   530,
     183,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
    1908,   189,  1909,   545,   546,     0,     0,   547,   548,   193,
     549,     0,     0,   550,  1910,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,  2481,   197,   198,
     199,     0,   558,   559,   560,   561,   562,   563,   564,     0,
     565,     0,   566,     0,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,  1911,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,     0,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,  2482,   610,   611,   220,
     612,  1913,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,     0,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,  1914,  1915,     0,     0,
     633,     0,   634,     0,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,     0,  1916,  2483,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   702,   662,   663,     0,     0,     0,     0,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,  2484,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,     0,  1898,   137,  1899,  1900,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,  1901,
    1902,   443,     0,   444,   445,   446,   447,     0,     0,   145,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,     0,
       0,     0,   152,     0,     0,     0,   460,   461,   462,   463,
     695,   464,  1903,  1904,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,  1493,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,     0,   490,   491,
     492,     0,     0,   493,     0,   494,  1905,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
       0,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,  2479,   510,   511,   512,   513,   514,   515,
       0,   516,   174,  2480,     0,   517,   518,   519,  1499,  1906,
       0,  1907,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,     0,   182,
     530,   183,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,  1908,   189,  1909,   545,   546,     0,     0,   547,   548,
     193,   549,     0,     0,   550,  1910,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,  2481,   197,
     198,   199,     0,   558,   559,   560,   561,   562,   563,   564,
       0,   565,     0,   566,     0,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,  1911,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
       0,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,  2482,   610,   611,
     220,   612,  1913,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,     0,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1914,  1915,     0,
       0,   633,     0,   634,     0,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,     0,  1916,  2483,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   702,   662,   663,     0,     0,     0,
       0,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,  3413,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1470,
    1471,  1472,    45,  1473,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,  1474,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,   135,  1475,   137,  1476,  1477,
    2900,   436,   437,   438,   439,   440,  1478,  1479,   441,   442,
    1480,  1481,   443,     0,   444,   445,   446,   447,  1482,     0,
    1483,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
    1484,  1485,  1486,  1487,  1488,  1489,  1490,   460,   461,   462,
     463,   695,   464,  1491,  1492,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,  1493,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,  1494,   490,
     491,   492,  1495,  1496,   493,     0,   494,  1497,   495,     0,
     496,     0,   497,   169,  2901,   170,   498,   499,   500,     0,
     501,  1498,     0,   502,     0,   503,   504,   697,   505,   506,
     173,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,   175,     0,   517,   518,   519,  1499,
    1500,     0,  1501,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,  2902,   529,  1502,
     182,   530,   183,     0,   531,   532,   533,  1503,  1504,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1505,   189,  1506,   545,   546,   191,  1507,   547,
     548,   193,   549,  1508,  1509,   550,  1510,   551,   552,   553,
       0,   554,     0,     0,  1511,   556,   557,     0,     0,   196,
     197,   198,   199,  1512,   558,   559,   560,   561,   562,   563,
     564,     0,   565,  1513,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,  1514,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,  1515,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,  1516,   609,   218,   610,
     611,   220,   612,  1517,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,  1518,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,  1519,  1520,
       0,  2903,   633,  1521,   634,  1522,  1523,   635,   636,   637,
     638,   639,   640,   641,     0,  1524,   642,   643,   644,   645,
     646,  1525,     0,   647,   648,   649,   650,   651,   701,  1526,
       0,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,  1527,  1528,  1529,
    1530,  1531,  1532,  1533,  1534,   702,   662,   663,     0,     0,
       0,     0,     0,     0,     0,  1535,  1536,     0,     0,     0,
       0,     0,     0,     0,  1538,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1470,  1471,  1472,    45,  1473,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,  1474,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
    1475,   137,  1476,  1477,     0,   436,   437,   438,   439,   440,
    1478,  1479,   441,   442,  1480,  1481,   443,     0,   444,   445,
     446,   447,  1482,     0,  1483,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,  1484,  1485,  1486,  1487,  1488,  1489,
    1490,   460,   461,   462,   463,   695,   464,  1491,  1492,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,  1493,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,  1494,   490,   491,   492,  1495,  1496,   493,     0,
     494,  1497,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,  1498,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,  1499,  1500,     0,  1501,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,  1502,   182,   530,   183,     0,   531,   532,
     533,  1503,  1504,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,  1505,   189,  1506,   545,
     546,   191,  1507,   547,   548,   193,   549,  1508,  1509,   550,
    1510,   551,   552,   553,     0,   554,     0,     0,  1511,   556,
     557,     0,     0,   196,   197,   198,   199,  1512,   558,   559,
     560,   561,   562,   563,   564,     0,   565,  1513,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,  1514,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,  1515,   597,   598,   599,   600,
     601,   602,   700,   603,   216,   604,   605,   606,   607,   608,
    1516,   609,   218,   610,   611,   220,   612,  1517,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
    1518,     0,   624,   625,   224,   626,   627,   628,   629,   630,
     631,     0,  1519,  1520,     0,     0,   633,  1521,   634,  1522,
    1523,   635,   636,   637,   638,   639,   640,   641,     0,  1524,
     642,   643,   644,   645,   646,  1525,     0,   647,   648,   649,
     650,   651,  2188,  1526,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,   237,   657,   658,   659,   660,   661,
     238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,
     662,   663,     0,     0,     0,     0,     0,     0,     0,  1535,
    1536,     0,     0,     0,     0,     0,     0,     0,  1538,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,   417,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1470,  1471,  1472,
      45,  1473,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,  1474,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,   135,  1475,   137,  1476,  1477,     0,   436,
     437,   438,   439,   440,  1478,  1479,   441,   442,  1480,  1481,
     443,     0,   444,   445,   446,   447,  1482,     0,  1483,     0,
     448,   449,   450,   451,   148,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,  1484,  1485,
    1486,  1487,  1488,  1489,  1490,   460,   461,   462,   463,   695,
     464,  1491,  1492,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
    1493,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,  1494,   490,   491,   492,
    1495,  1496,   493,     0,   494,  1497,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,  1498,
       0,   502,     0,   503,   504,   697,   505,   506,   173,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,   175,     0,   517,   518,   519,  1499,  1500,     0,
    1501,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,  1502,   182,   530,
     183,     0,   531,   532,   533,  1503,  1504,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
    1505,   189,  1506,   545,   546,   191,  1507,   547,   548,   193,
     549,  1508,  1509,   550,  1510,   551,   552,   553,     0,   554,
       0,     0,  1511,   556,   557,     0,     0,   196,   197,   198,
     199,  1512,   558,   559,   560,   561,   562,   563,   564,     0,
     565,  1513,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,  1514,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,  1515,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,  1516,   609,   218,   610,   611,   220,
     612,  1517,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,  1518,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,  1519,  1520,     0,     0,
     633,  1521,   634,  1522,  1523,   635,   636,   637,   638,   639,
     640,   641,     0,  1524,   642,   643,   644,   645,   646,  1525,
       0,   647,   648,   649,   650,   651,   701,  1526,     0,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,  1527,  1528,  1529,  1530,  1531,
    1532,  1533,  1534,   702,   662,   663,     0,     0,     0,     0,
       0,     0,     0,  1535,  1536,     0,     0,     0,     0,     0,
    2132,  2848,  1538,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
     417,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1470,  1471,  1472,    45,  1473,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,  1474,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,  1475,   137,
    1476,  1477,     0,   436,   437,   438,   439,   440,  1478,  1479,
     441,   442,  1480,  1481,   443,     0,   444,   445,   446,   447,
    1482,     0,  1483,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,   460,
     461,   462,   463,   695,   464,  1491,  1492,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,  1493,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
    1494,   490,   491,   492,  1495,  1496,   493,     0,   494,  1497,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,  1498,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,  1499,  1500,     0,  1501,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,  1502,   182,   530,   183,     0,   531,   532,   533,  1503,
    1504,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,  1505,   189,  1506,   545,   546,   191,
    1507,   547,   548,   193,   549,  1508,  1509,   550,  1510,   551,
     552,   553,     0,   554,     0,     0,  1511,   556,   557,     0,
       0,   196,   197,   198,   199,  1512,   558,   559,   560,   561,
     562,   563,   564,     0,   565,  1513,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
    1514,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,  1515,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,  1516,   609,
     218,   610,   611,   220,   612,  1517,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,  1518,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
    1519,  1520,     0,     0,   633,  1521,   634,  1522,  1523,   635,
     636,   637,   638,   639,   640,   641,     0,  1524,   642,   643,
     644,   645,   646,  1525,     0,   647,   648,   649,   650,   651,
     701,  1526,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,  1527,
    1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,   662,   663,
       0,     0,     0,     0,     0,     0,     0,  1535,  1536,  1537,
       0,     0,     0,     0,     0,     0,  1538,   726,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   727,   104,   105,
     681,   728,     0,   107,   108,   109,   110,   729,   730,   112,
     113,   114,   115,     0,   116,   731,   732,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1470,  1471,  1472,    45,  1473,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,  1474,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,   135,  1475,   137,  1476,  1477,     0,   436,   437,   438,
     439,   440,  1478,  1479,   441,   442,  1480,  1481,   443,     0,
     444,   445,   446,   447,  1482,     0,  1483,     0,   448,   449,
     450,   451,   148,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,  1484,  1485,  1486,  1487,
    1488,  1489,  1490,   460,   461,   462,   463,   695,   464,  1491,
    1492,   465,  1621,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,  1493,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,  1494,   490,   491,   492,  1495,  1496,
     493,     0,   494,  1497,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,  1498,     0,   502,
       0,   503,   504,   697,   505,   506,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
     175,     0,   517,   518,   519,  1499,  1500,     0,  1501,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,  1502,   182,   530,   183,     0,
     531,   532,   533,  1503,  1504,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,  1505,   189,
    1506,   545,   546,   191,  1507,   547,   548,   193,   549,  1508,
    1509,   550,  1510,   551,   552,   553,     0,   554,     0,     0,
    1511,   556,   557,     0,     0,   196,   197,   198,   199,  1512,
     558,   559,   560,   561,   562,   563,   564,     0,   565,  1513,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,  1514,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,  1515,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,  1516,   609,   218,   610,   611,   220,   612,  1517,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,  1518,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,  1519,  1520,     0,     0,   633,  1521,
     634,  1522,  1523,   635,   636,   637,   638,   639,   640,   641,
       0,  1524,   642,   643,   644,   645,   646,  1525,     0,   647,
     648,   649,   650,   651,   701,  1526,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,
    1534,   702,   662,   663,     0,     0,     0,     0,     0,     0,
       0,  1535,  1536,     0,     0,     0,     0,     0,     0,     0,
    1538,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1470,
    1471,  1472,    45,  1473,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,  2317,   426,   427,   428,     0,
       0,     0,     0,  1474,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,   135,  1475,   137,  1476,  1477,
       0,   436,   437,   438,   439,   440,  1478,  1479,   441,   442,
    1480,  1481,   443,     0,   444,   445,   446,   447,  1482,     0,
    1483,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
    1484,  1485,  1486,  1487,  1488,  1489,  1490,   460,   461,   462,
     463,   695,   464,  1491,  1492,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,  1493,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,  1494,   490,
     491,   492,  1495,  1496,   493,     0,   494,  1497,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,  1498,     0,   502,     0,   503,   504,   697,   505,   506,
     173,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,   175,     0,   517,   518,   519,  1499,
    1500,     0,  1501,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,  1502,
     182,   530,   183,     0,   531,   532,   533,  1503,  1504,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1505,   189,  1506,   545,   546,   191,  1507,   547,
     548,   193,   549,  1508,  1509,   550,  1510,   551,   552,   553,
       0,   554,     0,     0,  1511,   556,   557,     0,     0,   196,
     197,   198,   199,  1512,   558,   559,   560,   561,   562,   563,
     564,     0,   565,  1513,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,  1514,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,  1515,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,  1516,   609,   218,   610,
     611,   220,   612,  1517,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,  1518,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,  1519,  1520,
       0,     0,   633,  1521,   634,  1522,  1523,   635,   636,   637,
     638,   639,   640,   641,     0,  1524,   642,   643,   644,   645,
     646,  1525,     0,   647,   648,   649,   650,   651,   701,  1526,
       0,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,  1527,  1528,  1529,
    1530,  1531,  1532,  1533,  1534,   702,   662,   663,     0,     0,
       0,     0,     0,     0,     0,  1535,  1536,     0,     0,     0,
       0,     0,     0,     0,  1538,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1470,  1471,  1472,    45,  1473,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,  1474,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
    1475,   137,  1476,  1477,     0,   436,   437,   438,   439,   440,
    1478,  1479,   441,   442,  1480,  1481,   443,     0,   444,   445,
     446,   447,  1482,     0,  1483,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,  1484,  1485,  1486,  1487,  1488,  1489,
    1490,   460,   461,   462,   463,   695,   464,  1491,  1492,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,  1493,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,  1494,   490,   491,   492,  1495,  1496,   493,     0,
     494,  1497,   495,     0,   496,     0,   497,   169,  2901,   170,
     498,   499,   500,     0,   501,  1498,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,  1499,  1500,     0,  1501,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,  1502,   182,   530,   183,     0,   531,   532,
     533,  1503,  1504,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,  1505,   189,  1506,   545,
     546,   191,  1507,   547,   548,   193,   549,  1508,  1509,   550,
    1510,   551,   552,   553,     0,   554,     0,     0,  1511,   556,
     557,     0,     0,   196,   197,   198,   199,  1512,   558,   559,
     560,   561,   562,   563,   564,     0,   565,  1513,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,  1514,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,  1515,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
    1516,   609,   218,   610,   611,   220,   612,  1517,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
    1518,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1519,  1520,     0,     0,   633,  1521,   634,  1522,
    1523,   635,   636,   637,   638,   639,   640,   641,     0,  1524,
     642,   643,   644,   645,   646,  1525,     0,   647,   648,   649,
     650,   651,   701,  1526,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,
     662,   663,     0,     0,     0,     0,     0,     0,     0,  1535,
    1536,     0,     0,     0,     0,     0,     0,     0,  1538,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,   417,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1470,  1471,  1472,
      45,  1473,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,  1474,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,   135,  1475,   137,  1476,  1477,     0,   436,
     437,   438,   439,   440,  1478,  1479,   441,   442,  1480,  1481,
     443,     0,   444,   445,   446,   447,  1482,     0,  1483,     0,
     448,   449,   450,   451,   148,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,  1484,  1485,
    1486,  1487,  1488,  1489,  1490,   460,   461,   462,   463,   695,
     464,  1491,  1492,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
    1493,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,  1494,   490,   491,   492,
    1495,  1496,   493,     0,   494,  1497,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,  1498,
       0,   502,     0,   503,   504,   697,   505,   506,   173,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,   175,     0,   517,   518,   519,  1499,  1500,     0,
    1501,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,  1502,   182,   530,
     183,     0,   531,   532,   533,  1503,  1504,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
    1505,   189,  1506,   545,   546,   191,  1507,   547,   548,   193,
     549,  1508,  1509,   550,  1510,   551,   552,   553,     0,   554,
       0,     0,  1511,   556,   557,     0,     0,   196,   197,   198,
     199,  1512,   558,   559,   560,   561,   562,   563,   564,     0,
     565,  1513,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,  1514,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,  1515,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,  1516,   609,   218,   610,   611,   220,
     612,  1517,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,  1518,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,  1519,  1520,     0,     0,
     633,  1521,   634,  1522,  1523,   635,   636,   637,   638,   639,
     640,   641,     0,  1524,   642,   643,   644,   645,   646,  1525,
       0,   647,   648,   649,   650,   651,   701,  1526,  4142,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,  1527,  1528,  1529,  1530,  1531,
    1532,  1533,  1534,   702,   662,   663,     0,     0,     0,     0,
       0,     0,     0,  1535,  1536,     0,     0,     0,     0,     0,
       0,     0,  1538,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
     417,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1470,  1471,  1472,    45,  1473,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,  1474,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,  1475,   137,
    1476,  1477,     0,   436,   437,   438,   439,   440,  1478,  1479,
     441,   442,  1480,  1481,   443,     0,   444,   445,   446,   447,
    1482,     0,  1483,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,  4155,  1484,  1485,  1486,  1487,  1488,  1489,  1490,   460,
     461,   462,   463,   695,   464,  1491,  1492,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,  1493,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
    1494,   490,   491,   492,  1495,  1496,   493,     0,   494,  1497,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,  1498,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,  1499,  1500,     0,  1501,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,  1502,   182,   530,   183,     0,   531,   532,   533,  1503,
    1504,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,  1505,   189,  1506,   545,   546,   191,
    1507,   547,   548,   193,   549,  1508,  1509,   550,  1510,   551,
     552,   553,     0,   554,     0,     0,  1511,   556,   557,     0,
       0,   196,   197,   198,   199,  1512,   558,   559,   560,   561,
     562,   563,   564,     0,   565,  1513,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
    1514,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,  1515,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,  1516,   609,
     218,   610,   611,   220,   612,  1517,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,  1518,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
    1519,  1520,     0,     0,   633,  1521,   634,  1522,  1523,   635,
     636,   637,   638,   639,   640,   641,     0,  1524,   642,   643,
     644,   645,   646,  1525,     0,   647,   648,   649,   650,   651,
     701,  1526,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,  1527,
    1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,   662,   663,
       0,     0,     0,     0,     0,     0,     0,  1535,  1536,     0,
       0,     0,     0,     0,     0,     0,  1538,   726,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   727,   104,   105,
     681,   728,     0,   107,   108,   109,   110,   729,   730,   112,
     113,   114,   115,     0,   116,   731,   732,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1470,  1471,  1472,    45,  1473,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,  1474,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,  5019,  1475,   137,  1476,  1477,     0,   436,   437,   438,
     439,   440,  1478,  1479,   441,   442,  1480,  1481,   443,     0,
     444,   445,   446,   447,  1482,     0,  1483,     0,   448,   449,
     450,   451,   148,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,  5020,  1484,  1485,  1486,  1487,
    1488,  1489,  1490,   460,   461,   462,   463,   695,   464,  1491,
    1492,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,  1493,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,  1494,   490,   491,   492,  1495,  1496,
     493,     0,   494,  1497,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,  1498,     0,   502,
       0,   503,   504,   697,   505,   506,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
     175,     0,   517,   518,   519,  1499,  1500,     0,  1501,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,  1502,   182,   530,   183,     0,
     531,   532,   533,  1503,  1504,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,  1505,   189,
    1506,   545,   546,   191,  1507,   547,   548,   193,   549,  1508,
    1509,   550,  1510,   551,   552,   553,     0,   554,     0,     0,
    1511,   556,   557,     0,     0,   196,   197,   198,   199,  1512,
     558,   559,   560,   561,   562,   563,   564,     0,   565,  1513,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,  1514,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,  1515,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,  1516,   609,   218,   610,   611,   220,   612,  1517,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,  1518,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,  1519,  1520,     0,     0,   633,  1521,
     634,  1522,  1523,   635,   636,   637,   638,  5021,   640,   641,
       0,  1524,   642,   643,   644,   645,   646,  1525,     0,   647,
     648,   649,   650,   651,   701,  1526,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,
    1534,   702,   662,   663,     0,     0,     0,     0,     0,     0,
       0,  1535,  1536,     0,     0,     0,     0,     0,     0,     0,
    1538,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1470,
    1471,  1472,    45,  1473,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,  1474,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,   135,  1475,   137,  1476,  1477,
       0,   436,   437,   438,   439,   440,  1478,  1479,   441,   442,
    1480,  1481,   443,     0,   444,   445,   446,   447,  1482,     0,
    1483,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,  5020,
    1484,  1485,  1486,  1487,  1488,  1489,  1490,   460,   461,   462,
     463,   695,   464,  1491,  1492,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,  1493,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,  1494,   490,
     491,   492,  1495,  1496,   493,     0,   494,  1497,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,  1498,     0,   502,     0,   503,   504,   697,   505,   506,
     173,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,   175,     0,   517,   518,   519,  1499,
    1500,     0,  1501,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,  1502,
     182,   530,   183,     0,   531,   532,   533,  1503,  1504,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1505,   189,  1506,   545,   546,   191,  1507,   547,
     548,   193,   549,  1508,  1509,   550,  1510,   551,   552,   553,
       0,   554,     0,     0,  1511,   556,   557,     0,     0,   196,
     197,   198,   199,  1512,   558,   559,   560,   561,   562,   563,
     564,     0,   565,  1513,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,  1514,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,  1515,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,  1516,   609,   218,   610,
     611,   220,   612,  1517,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,  1518,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,  1519,  1520,
       0,     0,   633,  1521,   634,  1522,  1523,   635,   636,   637,
     638,  5021,   640,   641,     0,  1524,   642,   643,   644,   645,
     646,  1525,     0,   647,   648,   649,   650,   651,   701,  1526,
       0,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,  1527,  1528,  1529,
    1530,  1531,  1532,  1533,  1534,   702,   662,   663,     0,     0,
       0,     0,     0,     0,     0,  1535,  1536,     0,     0,     0,
       0,     0,     0,     0,  1538,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1470,  1471,  1472,    45,  1473,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,  1474,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
    1475,   137,  1476,  1477,     0,   436,   437,   438,   439,   440,
    1478,  1479,   441,   442,  1480,  1481,   443,     0,   444,   445,
     446,   447,  1482,     0,  1483,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,  1484,  1485,  1486,  1487,  1488,  1489,
    1490,   460,   461,   462,   463,   695,   464,  1491,  1492,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,  1493,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,  1494,   490,   491,   492,  1495,  1496,   493,     0,
     494,  1497,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,  1498,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,  1499,  1500,     0,  1501,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,  1502,   182,   530,   183,     0,   531,   532,
     533,  1503,  1504,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,  1505,   189,  1506,   545,
     546,   191,  1507,   547,   548,   193,   549,  1508,  1509,   550,
    1510,   551,   552,   553,     0,   554,     0,     0,  1511,   556,
     557,     0,     0,   196,   197,   198,   199,  1512,   558,   559,
     560,   561,   562,   563,   564,     0,   565,  1513,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,  1514,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,  1515,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
    1516,   609,   218,   610,   611,   220,   612,  1517,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
    1518,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1519,  1520,     0,     0,   633,  1521,   634,  1522,
    1523,   635,   636,   637,   638,   639,   640,   641,     0,  1524,
     642,   643,   644,   645,   646,  1525,     0,   647,   648,   649,
     650,   651,   701,  1526,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,
     662,   663,     0,     0,     0,     0,     0,     0,     0,  1535,
    1536,     0,     0,     0,     0,     0,     0,     0,  1538,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,   417,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1470,  1471,  1472,
      45,  1473,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,  1474,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,   135,  1475,   137,  1476,  1477,     0,   436,
     437,   438,   439,   440,  1478,  1479,   441,   442,  1480,  1481,
     443,     0,   444,   445,   446,   447,  1482,     0,  1483,     0,
     448,   449,   450,   451,   148,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,  1484,  1485,
    1486,  1487,  1488,  1489,  1490,   460,   461,   462,   463,   695,
     464,  1491,  1492,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
    1493,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,  1494,   490,   491,   492,
    1495,  1496,   493,     0,   494,  1497,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,  1498,
       0,   502,     0,   503,   504,   697,   505,   506,   173,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,   175,     0,   517,   518,   519,  1499,  1500,     0,
    1501,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,  1502,   182,   530,
     183,     0,   531,   532,   533,  1503,  1504,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
    1505,   189,  1506,   545,   546,   191,  1507,   547,   548,   193,
     549,  1508,  1509,   550,  1510,   551,   552,   553,     0,   554,
       0,     0,  1511,   556,   557,     0,     0,   196,   197,   198,
     199,  1512,   558,   559,   560,   561,   562,   563,   564,     0,
     565,  1513,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,  1514,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,  1515,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,  1516,   609,   218,   610,   611,   220,
     612,  1517,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,  1518,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,  1519,  1520,     0,     0,
     633,  1521,   634,  1522,  1523,   635,   636,   637,   638,   639,
     640,   641,     0,  1524,   642,   643,   644,   645,   646,  1525,
       0,   647,   648,   649,   650,   651,   701,  1526,     0,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,  4445,  1527,  1528,  1529,  1530,  1531,
    1532,  1533,  1534,   702,   662,   663,     0,     0,     0,     0,
       0,     0,     0,  1535,  1536,     0,     0,     0,     0,     0,
       0,     0,  1538,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
     417,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1470,  1471,  1472,    45,  1473,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,  1474,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,  1475,   137,
    1476,  1477,     0,   436,   437,   438,   439,   440,  1478,  1479,
     441,   442,  1480,  1481,   443,     0,   444,   445,   446,   447,
    1482,     0,  1483,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,   460,
     461,   462,   463,   695,   464,  1491,  1492,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,  1493,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
    1494,   490,   491,   492,  1495,  1496,   493,     0,   494,  1497,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,  1498,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,  1499,  1500,     0,  1501,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,  1502,   182,   530,   183,     0,   531,   532,   533,  1503,
    1504,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,  1505,   189,  1506,   545,  4454,   191,
    1507,   547,   548,   193,   549,  1508,  1509,   550,  1510,   551,
     552,   553,     0,   554,     0,     0,  1511,   556,   557,     0,
       0,   196,   197,   198,   199,  1512,   558,   559,   560,   561,
     562,   563,   564,     0,   565,  1513,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
    1514,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,  1515,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,  1516,   609,
     218,   610,   611,   220,   612,  1517,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,  1518,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
    1519,  1520,     0,     0,   633,  1521,   634,  1522,  1523,   635,
     636,   637,   638,   639,   640,   641,     0,  1524,   642,   643,
     644,   645,   646,  1525,     0,   647,   648,   649,   650,   651,
     701,  1526,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,  1527,
    1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,   662,   663,
       0,     0,     0,     0,     0,     0,     0,  1535,  1536,     0,
       0,     0,     0,     0,     0,     0,  1538,   726,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   727,   104,   105,
     681,   728,     0,   107,   108,   109,   110,   729,   730,   112,
     113,   114,   115,     0,   116,   731,   732,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1470,  1471,  1472,    45,  1473,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,  1474,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,   135,  1475,   137,  1476,  1477,     0,   436,   437,   438,
     439,   440,  1478,  1479,   441,   442,  1480,  1481,   443,     0,
     444,   445,   446,   447,  1482,     0,  1483,     0,   448,   449,
     450,   451,   148,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,  1484,  1485,  1486,  1487,
    1488,  1489,  1490,   460,   461,   462,   463,   695,   464,  1491,
    1492,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,  1493,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,  1494,   490,   491,   492,  1495,  1496,
     493,     0,   494,  1497,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,  1498,     0,   502,
       0,   503,   504,   697,   505,   506,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
     175,     0,   517,   518,   519,  1499,  1500,     0,  1501,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,  1502,   182,   530,   183,     0,
     531,   532,   533,  1503,  1504,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,  1505,   189,
    1506,   545,   546,   191,     0,   547,   548,   193,   549,  1508,
    1509,   550,  1510,   551,   552,   553,     0,   554,     0,     0,
    1511,   556,   557,     0,     0,   196,   197,   198,   199,  1512,
     558,   559,   560,   561,   562,   563,   564,     0,   565,  1513,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,  1514,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,  1515,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,  1516,   609,   218,   610,   611,   220,   612,  1517,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,  1518,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,  1519,  1520,     0,     0,   633,  1521,
     634,  1522,  1523,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,  1525,     0,   647,
     648,   649,   650,   651,   701,  1526,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,
    1534,   702,   662,   663,     0,     0,     0,     0,     0,     0,
       0,  2883,  2884,     0,     0,     0,     0,     0,     0,     0,
    1538,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1470,
    1471,  1472,    45,  1473,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,  1474,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435, -2635,  1475,   137,  1476,  1477,
       0,   436,   437,   438,   439,   440,  1478,  1479,   441,   442,
    1480,  1481,   443,     0,   444,   445,   446,   447,  1482,     0,
    1483,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,  5020,
    1484,  1485,  1486,  1487,  1488,  1489,  1490,   460,   461,   462,
     463,   695,   464,  1491,  1492,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,  1493,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,  1494,   490,
     491,   492,  1495,  1496,   493,     0,   494,  1497,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,  1498,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,   175,     0,   517,   518,   519,  1499,
    1500,     0,  1501,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,  1502,
     182,   530,     0,     0,   531,   532,   533,  1503,  1504,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1505,   189,  1506,   545,   546,   191,     0,   547,
     548,   193,   549,  1508,  1509,   550,  1510,   551,   552,   553,
       0,   554,     0,     0,  1511,   556,   557,     0,     0,   196,
     197,   198,   199,  1512,   558,   559,   560,   561,   562,   563,
     564,     0,   565,  1513,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,  1514,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,  1515,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,  1516,   609,   218,   610,
     611,     0,   612,  1517,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,  1518,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,  1519,  1520,
       0,     0,   633,  1521,   634,  1522,  1523,   635,   636,   637,
     638,  5021,   640,   641,     0,  1524,   642,   643,   644,   645,
     646,  1525,     0,   647,   648,   649,   650,   651,   701,  1526,
       0,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,  1527,  1528,  1529,
    1530,  1531,  1532,  1533,  1534,   702,   662,   663,     0,     0,
       0,     0,     0,     0,     0,  1535,  1536,     0,     0,     0,
       0,     0,     0,     0,  1538,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1470,  1471,     0,    45,  1473,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,  1474,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
    1475,   137,  1476,  1477,     0,   436,   437,   438,   439,   440,
    1478,  1479,   441,   442,  1480,  1481,   443,     0,   444,   445,
     446,   447,  1482,     0,  1483,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,  1484,  1485,  1486,  1487,  1488,  1489,
    1490,   460,   461,   462,   463,   695,   464,  1491,  1492,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,  1493,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,  1494,   490,   491,   492,  1495,  1496,   493,     0,
     494,  1497,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,  1498,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,  1499,  1500,     0,  1501,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,  1502,   182,   530,   183,     0,   531,   532,
     533,  1503,  1504,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,  1505,   189,  1506,   545,
     546,   191,     0,   547,   548,   193,   549,  1508,  1509,   550,
    1510,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,   197,   198,   199,  1512,   558,   559,
     560,   561,   562,   563,   564,     0,   565,  1513,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,  1514,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,  1515,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
    1516,   609,   218,   610,   611,   220,   612,  1517,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
    1518,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1519,  1520,     0,     0,   633,  1521,   634,  1522,
    1523,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,  1525,     0,   647,   648,   649,
     650,   651,   701,  1526,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,
     662,   663,     0,     0,     0,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,  1538,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1470,  1471,     0,    45,  1473,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,  1474,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
    1475,   137,  1476,  1477,     0,  4061,   437,   438,   439,   440,
    1478,  1479,   441,   442,  1480,  1481,   443,     0,   444,   445,
     446,   447,  1482,     0,  1483,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,  1484,  1485,  1486,  1487,  1488,  1489,
    1490,   460,   461,   462,   463,   695,   464,  1491,  1492,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,  1493,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,  1494,   490,   491,   492,  1495,  1496,   493,     0,
     494,  1497,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,  1498,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,  1499,  1500,     0,  1501,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,  1502,   182,   530,   183,     0,   531,   532,
     533,  1503,  1504,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,  1505,   189,  1506,   545,
     546,   191,     0,   547,   548,   193,   549,  1508,  1509,   550,
    1510,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,   197,   198,   199,  1512,   558,   559,
     560,   561,   562,   563,   564,     0,   565,  1513,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,  1514,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,  1515,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
    1516,   609,   218,   610,   611,   220,   612,  1517,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
    1518,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1519,  1520,     0,     0,   633,  1521,   634,  1522,
    1523,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,  1525,     0,   647,   648,   649,
     650,   651,   701,  1526,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,
     662,   663,     0,     0,     0,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,  1538,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1470,  1471,  1472,    45,  1473,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,  1474,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,     0,
    1475,   137,  1476,  1477,     0,   436,   437,   438,   439,   440,
    1478,  1479,   441,   442,  1480,  1481,   443,     0,   444,   445,
     446,   447,  1482,     0,  1483,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,  1484,  1485,  1486,  1487,  1488,  1489,
    1490,   460,   461,   462,   463,   695,   464,  1491,  1492,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,  1493,   478,   479,     0,
     480,   481,   482,     0,   483,     0,   485,     0,   486,   487,
     488,   489,  1494,   490,   491,   492,  1495,  1496,   493,     0,
     494,  1497,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,  1498,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,  1499,  1500,     0,  1501,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,  1502,   182,   530,     0,     0,   531,   532,
     533,  1503,  1504,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,  1505,   189,  1506,   545,
     546,   191,     0,   547,   548,   193,   549,  1508,  1509,   550,
    1510,   551,   552,   553,     0,   554,     0,     0,  1511,   556,
     557,     0,     0,   196,   197,   198,   199,  1512,   558,   559,
     560,   561,   562,   563,   564,     0,   565,  1513,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,  1514,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,  1515,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
    1516,   609,   218,   610,   611,     0,   612,  1517,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
    1518,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1519,  1520,     0,     0,   633,  1521,   634,  1522,
    1523,   635,   636,   637,   638,   639,   640,   641,     0,  1524,
     642,   643,   644,   645,   646,  1525,     0,   647,   648,   649,
     650,   651,   701,  1526,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,
     662,   663,     0,     0,     0,     0,     0,     0,     0,  1535,
    1536,     0,     0,     0,     0,     0,     0,     0,  1538,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,   417,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1470,  1471,  1472,
      45,  1473,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,  1474,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,     0,  1475,   137,  1476,  1477,     0,   436,
     437,   438,   439,   440,  1478,  1479,   441,   442,  1480,  1481,
     443,     0,   444,   445,   446,   447,  1482,     0,  1483,     0,
     448,   449,   450,   451,   148,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,  1484,  1485,
    1486,  1487,  1488,  1489,  1490,   460,   461,   462,   463,   695,
     464,  1491,  1492,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
    1493,   478,   479,     0,   480,   481,   482,     0,   483,     0,
     485,     0,   486,   487,   488,   489,  1494,   490,   491,   492,
    1495,  1496,   493,     0,   494,  1497,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,  1498,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,   175,     0,   517,   518,   519,  1499,  1500,     0,
    1501,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,  1502,   182,   530,
       0,     0,   531,   532,   533,  1503,  1504,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
    1505,   189,  1506,   545,   546,   191,     0,   547,   548,   193,
     549,  1508,  1509,   550,  1510,   551,   552,   553,     0,   554,
       0,     0,  1511,   556,   557,     0,     0,   196,   197,   198,
     199,  1512,   558,   559,   560,   561,   562,   563,   564,     0,
     565,  1513,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,  1514,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,  1515,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,  1516,   609,   218,   610,   611,     0,
     612,  1517,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,  1518,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,  1519,  1520,     0,     0,
     633,  1521,   634,  1522,  1523,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,  1525,
       0,   647,   648,   649,   650,   651,   701,  1526,     0,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,  1527,  1528,  1529,  1530,  1531,
    1532,  1533,  1534,   702,   662,   663,     0,     0,     0,     0,
       0,     0,     0,  2883,  2884,     0,     0,     0,     0,     0,
       0,     0,  1538,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,   136,   137,
     138,   139,     0,   436,   437,   438,   439,   440,     0,  1479,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
    1482,     0,  1483,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,  1495,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,  1498,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,  3605,   527,   528,     0,
     529,  1502,   182,   530,   183,     0,   531,   532,   533,  1503,
    1504,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,   189,   190,   545,   546,   191,
       0,   547,   548,   193,   549,     0,  1509,   550,   195,   551,
     552,   553,     0,   554,     0,  1083,   555,   556,   557,     0,
       0,   196,   197,   198,   199,  1512,   558,   559,   560,   561,
     562,   563,   564,     0,   565,  1513,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,   216,   604,   605,   606,   607,   608,  1516,   609,
     218,   610,   611,   220,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,  1518,     0,
     624,   625,   224,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,  1521,   634,  1522,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,  1525,     0,   647,   648,   649,   650,   651,
    2188,   235,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,   237,   657,   658,   659,   660,   661,   238,  1527,
    1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,   662,   663,
       0,     0,     0,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,  3606,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,   136,   137,
     138,   139,     0,   436,   437,   438,   439,   440,     0,  1479,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
    1482,     0,  1483,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,  1495,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,  1498,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,  3605,   527,   528,     0,
     529,  1502,   182,   530,   183,     0,   531,   532,   533,  1503,
    1504,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,   189,   190,   545,   546,   191,
       0,   547,   548,   193,   549,     0,  1509,   550,   195,   551,
     552,   553,     0,   554,     0,  1083,   555,   556,   557,     0,
       0,   196,   197,   198,   199,  1512,   558,   559,   560,   561,
     562,   563,   564,     0,   565,  1513,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,  1516,   609,
     218,   610,   611,   220,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,  1518,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,  1521,   634,  1522,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,  1525,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,  1527,
    1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,   662,   663,
       0,     0,     0,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,  3606,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,   136,   137,
     138,   139,     0,   436,   437,   438,   439,   440,     0,  1479,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
    1482,     0,  1483,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,  1495,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,  1498,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,  1502,   182,   530,   183,     0,   531,   532,   533,  1503,
    1504,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,   189,   190,   545,   546,   191,
       0,   547,   548,   193,   549,     0,  1509,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,   197,   198,   199,  1512,   558,   559,   560,   561,
     562,   563,   564,     0,   565,  1513,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,  1516,   609,
     218,   610,   611,   220,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,  1518,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,  1521,   634,  1522,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,  1525,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,  1527,
    1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,   662,   663,
       0,     0,     0,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,   247,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,   136,   137,
     138,   139,     0,   436,   437,   438,   439,   440,     0,  1479,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
    1482,     0,  1483,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,  1495,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,  1498,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,  1502,   182,   530,   183,     0,   531,   532,   533,  1503,
    1504,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,   189,   190,   545,   546,   191,
       0,   547,   548,   193,   549,     0,  1509,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,   197,   198,   199,  1512,   558,   559,   560,   561,
     562,   563,   564,     0,   565,  1513,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,  1516,   609,
     218,   610,   611,   220,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,  1518,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,  1521,   634,  1522,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,  1525,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,  1527,
    1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,   662,   663,
       0,     0,     0,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,  4181,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,   136,   137,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,   145,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,     0,     0,     0,   152,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,   182,   530,   183,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,   189,   190,   545,   546,   191,
       0,   547,   548,   193,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,   197,   198,   199,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,   220,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
       0,     0,     0,     0,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,  4760,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,  4107,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0, -1488,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0, -1488,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516, -1488,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
   -1488,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181, -1488,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188, -1488,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
   -1488,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
       0,     0,     0,     0,     0,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,  1629,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,    37,    38,    39,    40,    41,    42,
       0,    44,     0,     0,     0,    45,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,     0,     0,     0,     0,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,  3876,  3877,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,    37,    38,    39,    40,    41,    42,
       0,    44,     0,     0,     0,    45,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,     0,     0,     0,     0,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,  3877,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,   417,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,   216,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,   224,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,  2188,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,   237,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,     0,     0,     0,     0,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,   247,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,   216,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,   224,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,  2188,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,   237,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,     0,     0,     0,     0,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,   247,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,     0,     0,     0,     0,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,  1604,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,     0,     0,     0,     0,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,  3043,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,     0,     0,     0,     0,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,  4136,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,     0,     0,     0,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,  4491,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,   417,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,     0,     0,  1207,    45,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,   733,   426,
     427,   428,   734,   735,   736,   737,   738,   739,   740,   429,
     430,   741,   431,   432,   133,   433,   434,   435,     0,  1898,
     137,  1899,  1900,   742,   436,   437,   438,   439,   440,   743,
     744,   441,   442,  1901,  1902,   443,   746,   444,   445,   446,
     447,     0,   747,   145,   748,   448,   449,   450,   451,   148,
     452,   693,   750,   453,   454,   455,   456,   457,   458,   751,
     151,   459,     0,   753,   754,   755,   152,   756,   757,   758,
     460,   461,   462,   463,   695,   464,  1903,  1904,   465,   759,
     466,   760,   467,   468,   469,   470,   471,   761,   472,   473,
     474,   762,   763,   475,   476,  1493,   478,   479,   764,   480,
     481,   482,   765,   483,   484,   485,   766,   486,   487,   488,
     489,     0,   490,   491,   492,     0,   767,   493,   768,   494,
    1905,   495,   769,   496,   770,   497,   169,   771,   170,   498,
     499,   500,   772,   501,     0,   773,   502,   774,   503,   504,
     697,   505,   506,   173,   507,   508,   509,   775,   510,   511,
     512,   513,   514,   515,   776,   516,   174,     0,     0,   517,
     518,   519,  1499,  1906,   779,  1907,   780,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,   781,   527,   528,
     782,   529,     0,   182,   530,   183,   783,   531,   532,   533,
     784,   785,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,  1908,   189,  1909,   545,   546,
       0,   786,   547,   548,   193,   549,   787,     0,   550,  1910,
     551,   552,   553,   788,   554,   789,   790,  3863,   556,   557,
     791,   792,     0,   197,   198,   199,     0,   558,   559,   560,
     561,   562,   563,   564,   793,   565,     0,   566,     0,   567,
     568,   569,   794,   570,   571,   572,   573,   574,   575,   576,
     577,  1911,   578,   579,   580,   581,   795,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   796,   593,
     594,   211,   595,   596,     0,   597,   598,   599,   600,   601,
     602,   700,   603,   797,   604,   605,   606,   607,   608,   798,
     609,  2482,   610,   611,   220,   612,  1913,   613,   799,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,     0,
     800,   624,   625,   801,   626,   627,   628,   629,   630,   631,
     802,  1914,  1915,     0,   804,   633,     0,   634,     0,   805,
     635,   636,   637,   638,   639,   640,   641,     0,   807,   642,
     643,   644,   645,   646,   808,   809,   647,   648,   649,   650,
     651,     0,  1916,   811,   652,   236,   653,   654,   655,   812,
     813,   656,   814,   815,   657,   658,   659,   660,   661,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   702,   662,
     663,     0,     0,     0,  1210,  1211,  1212,     0,  3864,  3865,
    1215,  1216,  1217,  1218,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,  1207,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,  1208,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,  1209,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
       0,     0,     0,  1210,  1211,  1212,     0,  1213,  1214,  1215,
    1216,  1217,  1218,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1207,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,  1301,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,  1302,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,     0,
       0,     0,  1210,  1211,  1212,     0,  1213,  1214,  1215,  1216,
    1217,  1218,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,  1207,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,  1358,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,  1359,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,  1360,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,     0,     0,
       0,  1210,  1211,  1212,     0,  1213,  1214,  1215,  1216,  1217,
    1218,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
    1207,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,  1883,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,  1884,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,     0,     0,     0,
    1210,  1211,  1212,     0,  1213,  1214,  1215,  1216,  1217,  1218,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,  1207,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,     0,     0,     0,  1210,
    1211,  1212,     0,  1213,  1214,  1215,  1216,  1217,  1218,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1207,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,  3132,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,  3133,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,     0,     0,     0,  1210,  1211,
    1212,     0,  1213,  1214,  1215,  1216,  1217,  1218,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,  1207,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
    4743,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,     0,     0,     0,  1210,  1211,  1212,
       0,  1213,  1214,  1215,  1216,  1217,  1218,   726,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   727,   104,   105,
     681,   728,     0,   107,   108,   109,   110,   729,   730,   112,
     113,   114,   115,     0,   116,   731,   732,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,   733,   426,   427,   428,   734,   735,   736,   737,   738,
     739,   740,   429,   430,   741,   431,   432,   133,   433,   434,
     435,   135,   136,   137,   138,   139,   742,   436,   437,   438,
     439,   440,   743,   744,   441,   442,   745,   140,   443,   746,
     444,   445,   446,   447,   144,   747,   145,   748,   448,   449,
     450,   451,   148,   452,   749,   750,   453,   454,   455,   456,
     457,   458,   751,   151,   459,   752,   753,   754,   755,   152,
     756,   757,   758,   460,   461,   462,   463,   695,   464,   155,
     156,   465,   759,   466,   760,   467,   468,   469,   470,   471,
     761,   472,   473,   474,   762,   763,   475,   476,   477,   478,
     479,   764,   480,   481,   482,   765,   483,   484,   485,   766,
     486,   487,   488,   489,   164,   490,   491,   492,   166,   767,
     493,   768,   494,   168,   495,   769,   496,   770,   497,   169,
     771,   170,   498,   499,   500,   772,   501,   172,   773,   502,
     774,   503,   504,   697,   505,   506,   173,   507,   508,   509,
     775,   510,   511,   512,   513,   514,   515,   776,   516,   174,
     175,   777,   517,   518,   519,   778,   176,   779,   177,   780,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
     781,   527,   528,   782,   529,   181,   182,   530,   183,   783,
     531,   532,   533,   784,   785,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,   189,
     190,   545,   546,   191,   786,   547,   548,   193,   549,   787,
     194,   550,   195,   551,   552,   553,   788,   554,   789,   790,
     555,   556,   557,   791,   792,   196,   197,   198,   199,   200,
     558,   559,   560,   561,   562,   563,   564,   793,   565,   201,
     566,   202,   567,   568,   569,   794,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,   795,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,   796,   593,   594,   211,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,   797,   604,   605,   606,
     607,   608,   798,   609,   218,   610,   611,   220,   612,   221,
     613,   799,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,   800,   624,   625,   801,   626,   627,   628,
     629,   630,   631,   802,   225,   226,   803,   804,   633,   227,
     634,   228,   805,   635,   636,   637,   638,   639,   640,   641,
     806,   807,   642,   643,   644,   645,   646,   808,   809,   647,
     648,   649,   650,   651,   810,   235,   811,   652,   236,   653,
     654,   655,   812,   813,   656,   814,   815,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,   726,    86,    87,    88,   678,    90,
      91,    92,   679,  2285,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,     0,  1898,
     137,  1899,  1900,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,  1901,  1902,   443,     0,   444,   445,   446,
     447,     0,     0,   145,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,     0,     0,     0,   152,     0,     0,     0,
     460,   461,   462,   463,   695,   464,  1903,  1904,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,  1493,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,     0,   490,   491,   492,     0,     0,   493,     0,   494,
    1905,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,     0,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,     0,     0,   517,
     518,   519,  1499,  1906,     0,  1907,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,     0,   182,   530,   183,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,  1908,   189,  1909,   545,   546,
       0,     0,   547,   548,   193,   549,     0,     0,   550,  1910,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,     0,   197,   198,   199,     0,   558,   559,   560,
     561,   562,   563,   564,     0,   565,     0,   566,     0,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,  1911,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,     0,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,  1912,   610,   611,   220,   612,  1913,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,     0,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,  1914,  1915,     0,     0,   633,     0,   634,     0,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,     0,  1916,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   702,   662,
     663,     0,    86,    87,    88,   678,    90,    91,    92,   679,
    2389,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,     0,    86,
      87,    88,   678,    90,    91,    92,   679,  1090,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,     0,    86,    87,    88,   678,
      90,    91,    92,   679,  4784,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,   418,   988,   420,   421,   422,   423,   424,   425,   989,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   990,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     991,   168,   495,     0,   496,     0,   992,     0,   993,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,   994,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   995,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   996,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   997,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     998,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,     0,     0,     0,     0,     0,     0,   999,
    1000,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,   418,   988,   420,   421,
     422,   423,   424,   425,   989,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,  1021,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   991,   168,   495,     0,   496,
       0,  1022,     0,   993,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,   994,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   995,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   996,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   997,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   998,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,     0,     0,     0,
       0,     0,     0,     0,   999,  1000,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,  1406,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,   993,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,   994,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,     0,     0,     0,     0,     0,     0,   999,
    1000,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,  1411,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,   993,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,   994,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,     0,     0,     0,
       0,     0,     0,     0,   999,  1000,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
     696,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,  1575,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,     0,  1061,  1576,    86,    87,    88,   678,
      90,    91,    92,   679,  1062,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,  1063,   442,  1037,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,  1064,     0,  1065,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
    1066,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,  1067,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,  1068,   596,   213,   597,   598,   599,  1069,
     601,   602,   700,   603,     0,   604,   605,   606,   607,  1070,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1071,   226,     0,     0,  1072,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,  1041,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,  1073,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
       0,     0,     0,    45,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,   733,   426,   427,   428,
     734,   735,   736,   737,   738,   739,   740,   429,   430,   741,
     431,   432,   133,   433,   434,   435,   135,   136,   137,   138,
     139,   742,   436,   437,   438,   439,   440,   743,   744,   441,
     442,   745,   140,   443,   746,   444,   445,   446,   447,   144,
     747,   145,   748,   448,   449,   450,   451,   148,   452,   749,
     750,   453,   454,   455,   456,   457,   458,   751,   151,   459,
     752,   753,   754,   755,   152,   756,   757,   758,   460,   461,
     462,   463,   695,   464,   155,   156,   465,   759,   466,   760,
     467,   468,   469,   470,   471,   761,   472,   473,   474,   762,
     763,   475,   476,   477,   478,   479,   764,   480,   481,   482,
     765,   483,   484,   485,   766,   486,   487,   488,   489,   164,
     490,   491,   492,   166,   767,   493,   768,   494,   168,   495,
     769,   496,   770,   497,   169,   771,   170,   498,   499,   500,
     772,   501,   172,   773,   502,   774,   503,   504,   697,   505,
     506,   173,   507,   508,   509,   775,   510,   511,   512,   513,
     514,   515,   776,   516,   174,   175,   777,   517,   518,   519,
     778,   176,   779,   177,   780,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,   781,   527,   528,   782,   529,
     181,   182,   530,   183,   783,   531,   532,   533,   784,   785,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,   189,   190,   545,   546,   191,   786,
     547,   548,   193,   549,   787,   194,   550,   195,   551,   552,
     553,   788,   554,   789,   790,   555,   556,   557,   791,   792,
     196,   197,   198,   199,   200,   558,   559,   560,   561,   562,
     563,   564,   793,   565,   201,   566,   202,   567,   568,   569,
     794,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,   795,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,   796,   593,   594,   211,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,   797,   604,   605,   606,   607,   608,   798,   609,   218,
     610,   611,   220,   612,   221,   613,   799,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,   800,   624,
     625,   801,   626,   627,   628,   629,   630,   631,   802,   225,
     226,   803,   804,   633,   227,   634,   228,   805,   635,   636,
     637,   638,   639,   640,   641,   806,   807,   642,   643,   644,
     645,   646,   808,   809,   647,   648,   649,   650,   651,   810,
     235,   811,   652,   236,   653,   654,   655,   812,   813,   656,
     814,   815,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,   733,   426,   427,   428,   734,   735,   736,
     737,   738,   739,   740,   429,   430,   741,   431,   432,   133,
     433,   434,   435,   135,   136,   137,   138,   139,   742,   436,
     437,   438,   439,   440,   743,   744,   441,   442,   745,   140,
     443,   746,   444,   445,   446,   447,   144,   747,   145,   748,
     448,   449,   450,   451,   148,   452,   749,   750,   453,   454,
     455,   456,   457,   458,   751,   151,   459,   752,   753,   754,
     755,   152,   756,   757,   758,   460,   461,   462,   463,   695,
     464,   155,   156,   465,   759,   466,   760,   467,   468,   469,
     470,   471,   761,   472,   473,   474,   762,   763,   475,   476,
     477,   478,   479,   764,   480,   481,   482,   765,   483,   484,
     485,   766,   486,   487,   488,   489,   164,   490,   491,   492,
     166,   767,   493,   768,   494,   168,   495,   769,   496,   770,
     497,   169,   771,   170,   498,   499,   500,   772,   501,   172,
     773,   502,   774,   503,   504,   697,   505,   506,   173,   507,
     508,   509,   775,   510,   511,   512,   513,   514,   515,   776,
     516,   174,   175,   777,   517,   518,   519,   778,   176,   779,
     177,   780,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,   781,   527,   528,   782,   529,   181,   182,   530,
     183,   783,   531,   532,   533,   784,   785,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,   189,   190,   545,   546,   191,   786,   547,   548,   193,
     549,   787,   194,   550,   195,   551,   552,   553,   788,   554,
     789,   790,   555,   556,   557,   791,   792,   196,   197,   198,
     199,   200,   558,   559,   560,   561,   562,   563,   564,   793,
     565,   201,   566,   202,   567,   568,   569,   794,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,   795,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,   796,   593,   594,   211,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,   797,   604,
     605,   606,   607,   608,   798,   609,   218,   610,   611,   220,
     612,   221,   613,   799,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,   800,   624,   625,   801,   626,
     627,   628,   629,   630,   631,   802,   225,   226,   803,   804,
     633,   227,   634,   228,   805,   635,   636,   637,   638,   639,
     640,   641,   806,   807,   642,   643,   644,   645,   646,   808,
     809,   647,   648,   649,   650,   651,   810,   235,   811,   652,
     236,   653,   654,   655,   812,   813,   656,   814,   815,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,  3197,   423,   424,   425,
     733,   426,   427,   428,   734,   735,   736,   737,   738,   739,
     740,   429,   430,   741,   431,   432,   133,   433,   434,   435,
     135,   136,   137,   138,   139,   742,   436,   437,   438,   439,
     440,   743,   744,   441,   442,   745,   140,   443,   746,   444,
     445,   446,   447,   144,   747,   145,   748,   448,   449,   450,
     451,   148,   452,   749,   750,   453,   454,   455,   456,   457,
     458,   751,   151,   459,   752,   753,   754,   755,   152,   756,
     757,   758,   460,   461,   462,   463,   695,   464,   155,   156,
     465,   759,   466,   760,   467,   468,   469,   470,   471,   761,
     472,   473,   474,   762,   763,   475,   476,   477,  3198,   479,
     764,   480,   481,   482,   765,   483,   484,   485,   766,   486,
     487,   488,   489,   164,   490,   491,   492,   166,   767,   493,
     768,   494,   168,   495,   769,   496,   770,   497,   169,   771,
     170,   498,   499,   500,   772,   501,   172,   773,   502,   774,
     503,   504,   697,   505,   506,   173,   507,   508,   509,   775,
     510,   511,   512,   513,   514,   515,   776,   516,   174,   175,
     777,   517,   518,   519,   778,   176,   779,   177,   780,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,   781,
     527,   528,   782,   529,   181,   182,   530,   183,   783,   531,
     532,   533,   784,   785,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,   189,   190,
     545,   546,   191,   786,   547,   548,   193,   549,   787,   194,
     550,   195,   551,   552,   553,   788,   554,   789,   790,   555,
     556,   557,   791,   792,   196,   197,   198,   199,   200,   558,
     559,   560,   561,   562,   563,   564,   793,   565,   201,   566,
     202,   567,   568,   569,   794,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,   795,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
     796,   593,   594,   211,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,   797,   604,   605,   606,   607,
     608,   798,  3199,   218,   610,   611,   220,   612,   221,   613,
     799,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,   800,   624,   625,   801,   626,   627,   628,   629,
     630,   631,   802,   225,   226,   803,   804,   633,   227,   634,
     228,   805,   635,   636,   637,   638,   639,   640,   641,   806,
     807,   642,   643,   644,   645,   646,   808,   809,   647,   648,
     649,   650,   651,   810,   235,   811,   652,   236,   653,   654,
     655,   812,   813,   656,   814,   815,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,   136,   137,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,   145,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,     0,     0,     0,   152,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,   182,   530,   183,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,   189,   190,   545,   546,   191,
       0,   547,   548,   193,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,   197,   198,   199,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,   220,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,   136,   137,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,   145,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,     0,
       0,     0,   152,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,  1341,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,   182,
     530,   183,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,   189,   190,   545,   546,   191,     0,   547,   548,
     193,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,   197,
     198,   199,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
     220,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,   726,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   727,   104,   105,
     681,   728,     0,   107,   108,   109,   110,   729,   730,   112,
     113,   114,   115,     0,   116,   731,   732,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,   135,   136,   137,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,   145,     0,   448,   449,
     450,   451,   148,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,     0,     0,     0,   152,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,  1351,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,   182,   530,   183,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,   189,
     190,   545,   546,   191,     0,   547,   548,   193,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,   197,   198,   199,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,   220,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,     0,  1898,
     137,  1899,  1900,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,  1901,  1902,   443,     0,   444,   445,   446,
     447,     0,     0,   145,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,     0,     0,     0,   152,     0,     0,     0,
     460,   461,   462,   463,   695,   464,  1903,  1904,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,  1493,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,     0,   490,   491,   492,     0,     0,   493,     0,   494,
    1905,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,     0,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,  2479,   510,   511,
     512,   513,   514,   515,     0,   516,   174,  2480,     0,   517,
     518,   519,  1499,  1906,     0,  1907,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,     0,   182,   530,   183,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,  1908,   189,  1909,   545,   546,
       0,     0,   547,   548,   193,   549,     0,     0,   550,  1910,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,  2481,   197,   198,   199,     0,   558,   559,   560,
     561,   562,   563,   564,     0,   565,     0,   566,     0,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,  1911,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,     0,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,  2482,   610,   611,   220,   612,  1913,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,     0,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,  1914,  1915,     0,     0,   633,     0,   634,     0,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,     0,  1916,  2483,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   702,   662,
     663,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,     0,  1898,   137,  1899,  1900,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
    1901,  1902,   443,     0,   444,   445,   446,   447,     0,     0,
     145,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
       0,     0,     0,   152,     0,     0,     0,   460,   461,   462,
     463,   695,   464,  1903,  1904,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,  1493,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,     0,   490,
     491,   492,     0,     0,   493,     0,   494,  1905,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,     0,     0,   502,     0,   503,   504,   697,   505,   506,
     173,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,     0,     0,   517,   518,   519,  1499,
    1906,     0,  1907,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,     0,
     182,   530,   183,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1908,   189,  1909,   545,   546,     0,     0,   547,
     548,   193,   549,  2467,     0,   550,  1910,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,     0,
     197,   198,   199,     0,   558,   559,   560,   561,   562,   563,
     564,     0,   565,     0,   566,     0,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,  1911,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,     0,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,  2482,   610,
     611,   220,   612,  1913,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,     0,     0,   624,   625,
    3967,   626,   627,   628,   629,   630,   631,     0,  1914,  1915,
       0,     0,   633,     0,   634,     0,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,     0,  1916,
       0,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   702,   662,   663,   726,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   727,   104,
     105,   681,   728,     0,   107,   108,   109,   110,   729,   730,
     112,   113,   114,   115,     0,   116,   731,   732,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,     0,  1898,   137,  1899,  1900,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,  1901,  1902,   443,
       0,   444,   445,   446,   447,     0,     0,   145,     0,   448,
     449,   450,   451,   148,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,     0,     0,     0,
     152,     0,     0,     0,   460,   461,   462,   463,   695,   464,
    1903,  1904,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,  1493,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,     0,   490,   491,   492,     0,
       0,   493,     0,   494,  1905,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,     0,     0,
     502,     0,   503,   504,   697,   505,   506,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,     0,     0,   517,   518,   519,  1499,  1906,     0,  1907,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,     0,   182,   530,   183,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,  1908,
     189,  1909,   545,   546,  2533,     0,   547,   548,   193,   549,
       0,     0,   550,  1910,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,     0,   197,   198,   199,
       0,   558,   559,   560,   561,   562,   563,   564,     0,   565,
       0,   566,     0,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,  1911,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,     0,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,  1912,   610,   611,   220,   612,
    1913,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,     0,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,  1914,  1915,     0,     0,   633,
       0,   634,     0,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,     0,  1916,     0,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   702,   662,   663,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,     0,
    1898,   137,  1899,  1900,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,  1901,  1902,   443,     0,   444,   445,
     446,   447,     0,     0,   145,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,     0,     0,     0,   152,     0,     0,
       0,   460,   461,   462,   463,   695,   464,  1903,  1904,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,  1493,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,     0,   490,   491,   492,     0,     0,   493,     0,
     494,  1905,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,     0,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,     0,     0,
     517,   518,   519,  1499,  1906,     0,  1907,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,     0,   182,   530,   183,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,  1908,   189,  1909,   545,
     546,  3799,     0,   547,   548,   193,   549,     0,     0,   550,
    1910,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,     0,   197,   198,   199,     0,   558,   559,
     560,   561,   562,   563,   564,     0,   565,     0,   566,     0,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,  1911,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,     0,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,  1912,   610,   611,   220,   612,  1913,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
       0,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1914,  1915,     0,     0,   633,     0,   634,     0,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,     0,  1916,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   702,
     662,   663,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,     0,  1898,   137,  1899,
    1900,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,  1901,  1902,   443,     0,   444,   445,   446,   447,     0,
       0,   145,     0,   448,   449,   450,   451,   148,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,     0,     0,     0,   152,     0,     0,     0,   460,   461,
     462,   463,   695,   464,  1903,  1904,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,  1493,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,     0,
     490,   491,   492,     0,     0,   493,     0,   494,  1905,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,     0,     0,   502,     0,   503,   504,   697,   505,
     506,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,     0,     0,   517,   518,   519,
    1499,  1906,     0,  1907,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
       0,   182,   530,   183,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,  1908,   189,  1909,   545,   546,     0,     0,
     547,   548,   193,   549,     0,     0,   550,  1910,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
       0,   197,   198,   199,     0,   558,   559,   560,   561,   562,
     563,   564,     0,   565,     0,   566,     0,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,  1911,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,     0,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,  1912,
     610,   611,   220,   612,  1913,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,     0,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1914,
    1915,     0,     0,   633,     0,   634,     0,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,     0,
    1916,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   702,   662,   663,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,     0,  1898,   137,  1899,  1900,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,  1901,  1902,
     443,     0,   444,   445,   446,   447,     0,     0,   145,     0,
     448,   449,   450,   451,   148,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,     0,     0,
       0,   152,     0,     0,     0,   460,   461,   462,   463,   695,
     464,  1903,  1904,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
    1493,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,     0,   490,   491,   492,
       0,     0,   493,     0,   494,  1905,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,     0,
       0,   502,     0,   503,   504,   697,   505,   506,   173,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,     0,     0,   517,   518,   519,  1499,  1906,     0,
    1907,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,     0,   182,   530,
     183,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
    1908,   189,  1909,   545,   546,     0,     0,   547,   548,   193,
     549,     0,     0,   550,  1910,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,     0,   197,   198,
     199,     0,   558,   559,   560,   561,   562,   563,   564,     0,
     565,     0,   566,     0,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,  1911,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,     0,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,  2482,   610,   611,   220,
     612,  1913,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,     0,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,  1914,  1915,     0,     0,
     633,     0,   634,     0,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,     0,  1916,     0,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   702,   662,   663,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
       0,  1898,   137,  1899,  1900,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,  1901,  1902,   443,     0,   444,
     445,   446,   447,     0,     0,   145,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,     0,     0,     0,   152,     0,
       0,     0,   460,   461,   462,   463,   695,   464,  1903,  1904,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1493,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,     0,   490,   491,   492,     0,     0,   493,
       0,   494,  1905,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,     0,     0,   502,     0,
     503,   504,   697,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,     0,
       0,   517,   518,   519,  1499,  1906,     0,  1907,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,     0,   182,   530,   183,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1908,   189,  1909,
     545,   546,     0,     0,   547,   548,   193,   549,     0,     0,
     550,  1910,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,     0,   197,   198,   199,     0,   558,
     559,   560,   561,   562,   563,   564,     0,   565,     0,   566,
       0,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1911,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,     0,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,     0,   610,   611,   220,   612,  1913,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,     0,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1914,  1915,     0,     0,   633,     0,   634,
       0,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,     0,  1916,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     702,   662,   663,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,     0,     0,   137,
       0,     0,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,     0,     0,   443,     0,   444,   445,   446,   447,
       0,     0,   145,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,     0,     0,     0,   152,     0,     0,     0,   460,
     461,   462,   463,   695,   464,     0,     0,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
       0,   490,   491,   492,     0,     0,   493,     0,   494,     0,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,     0,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,     0,     0,   517,   518,
     519,     0,     0,     0,     0,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,     0,   182,   530,   183,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,     0,   189,     0,   545,   546,     0,
       0,   547,   548,   193,   549,     0,     0,   550,     0,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,     0,   197,   198,   199,     0,   558,   559,   560,   561,
     562,   563,   564,     0,   565,     0,   566,     0,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
       0,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,     0,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
       0,   610,   611,   220,   612,     0,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,     0,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
       0,     0,     0,     0,   633,     0,   634,     0,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
       0,     0,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,   733,   426,   427,   428,   734,   735,   736,
     737,   738,   739,   740,   429,   430,   741,   431,   432,   133,
     433,   434,   435,   135,   136,   137,   138,   139,   742,   436,
     437,   438,   439,   440,   743,   744,   441,   442,     0,   140,
     443,   746,   444,   445,   446,   447,   144,   747,   145,   748,
     448,   449,   450,   451,   148,   452,   749,   750,   453,   454,
     455,   456,   457,   458,   751,   151,   459,     0,   753,   754,
     755,   152,   756,   757,   758,   460,   461,   462,   463,     0,
     464,   155,   156,   465,   759,   466,   760,   467,   468,   469,
     470,   471,   761,   472,   473,   474,   762,   763,   475,   476,
     477,   478,   479,   764,   480,   481,   482,   765,   483,   484,
     485,   766,   486,   487,   488,   489,   164,   490,   491,   492,
     166,   767,   493,   768,   494,   168,   495,   769,   496,   770,
     497,   169,   771,   170,   498,   499,   500,   772,   501,   172,
     773,   502,   774,   503,   504,     0,   505,   506,   173,   507,
     508,   509,   775,   510,   511,   512,   513,   514,   515,   776,
     516,   174,   175,     0,   517,   518,   519,     0,   176,   779,
     177,   780,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,   781,   527,   528,   782,   529,   181,   182,   530,
     183,   783,   531,   532,   533,   784,   785,   534,   535,   536,
     537,   538,   539,     0,   540,   541,     0,   542,   543,   544,
     188,   189,   190,   545,   546,   191,   786,   547,   548,   193,
     549,   787,   194,   550,   195,   551,   552,   553,   788,   554,
     789,   790,   555,   556,   557,   791,   792,   196,   197,   198,
     199,   200,   558,   559,   560,   561,   562,   563,   564,   793,
     565,   201,   566,   202,   567,   568,   569,   794,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,   795,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,   796,   593,   594,   211,   595,   596,   213,
     597,   598,   599,   600,   601,   602,     0,   603,   797,   604,
     605,   606,   607,   608,   798,   609,   218,   610,   611,   220,
     612,   221,   613,   799,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,   800,   624,   625,   801,   626,
     627,   628,   629,   630,   631,   802,   225,   226,     0,   804,
     633,   227,   634,   228,   805,   635,   636,   637,   638,   639,
     640,   641,     0,   807,   642,   643,   644,   645,   646,   808,
     809,   647,   648,   649,   650,   651,     0,   235,   811,   652,
     236,   653,   654,   655,   812,   813,   656,   814,   815,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,     0,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
    1152,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,  2413,
     444,   445,   446,   447,   144,     0,     0,  2495,   448,   449,
     450,   451,     0,   452,   693,  2414,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
    2496,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,  2416,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,  2417,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,  2418,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,  2413,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,  2414,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,  2496,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,  2416,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,  3360,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,  2417,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,  2418,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
    1050,   424,   425,  1008,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,  1009,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,  1051,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,  1010,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,  1011,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,  1008,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
    1009,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,  3094,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,  1010,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,  1011,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,  2413,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,  2414,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
    2496,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,  2416,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,  2417,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,  2418,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
     417,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,   691,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,   694,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,   696,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,  1008,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,  1009,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,  1010,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,  1011,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,   920,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,   921,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   922,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,  2089,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
    2090,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,  2091,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,  2092,   497,     0,     0,     0,  2093,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,  2094,  2095,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,  2096,   601,   602,   700,   603,
       0,  2097,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
    2098,   626,  2099,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,  2100,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,  1009,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,  1010,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,  1011,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,  2078,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,  2371,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
     417,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
    2969,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,  2970,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,  2971,   626,   627,  2972,   629,  2973,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
    2974,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,   417,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,   718,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
     696,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,   870,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,  1333,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,   130,   131,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,  3181,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,  3182,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,  3193,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,  3194,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   926,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
     417,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   970,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,   417,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
    1025,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,  1083,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,  1230,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,  1083,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,  1578,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,  1752,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,  1083,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,  1986,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,  2078,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,  2371,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,  4107,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
    4121,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,  4341,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,  4343,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
    4345,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,  4746,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,  1034,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,  1036,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,  1037,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,     0,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,  1038,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,  1039,   226,     0,     0,
    1040,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,  1041,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,  1077,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,  1037,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,     0,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,  1078,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1079,   226,     0,     0,  1080,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,  1041,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,  1097,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,  1203,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,  1227,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,  1238,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,  1292,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,  1306,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,  1346,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,  1365,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,  1367,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,  1369,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,  1372,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,  1378,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,  1589,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
    1063,   442,  1037,   140,  1590,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
       0,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,  1067,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,  1068,   596,   213,   597,   598,   599,  1069,   601,   602,
     700,   603,     0,   604,   605,   606,   607,  1582,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
    1071,   226,     0,     0,  1072,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
    1041,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,  1073,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
    1715,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,  1798,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,  1945,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,  1975,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,  2010,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,  2012,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,  2014,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,  2127,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
    2338,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,     0,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,  2729,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,  3105,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,  3184,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,  3186,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,  3284,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
    1063,   442,  1037,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
       0,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,  1067,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,  1068,   596,   213,   597,   598,   599,  1069,   601,   602,
     700,   603,     0,   604,   605,   606,   607,  1582,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
    1071,   226,     0,     0,  1072,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
    1041,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,  1073,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,  1063,   442,  1037,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,     0,     0,   453,   454,
     455,  