/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     CSTRING = 326,
     CVARIABLE = 327,
     CPP_LINE = 328,
     IP = 329,
     DOLCONST = 330,
     ECONST = 331,
     NCONST = 332,
     UCONST = 333,
     UIDENT = 334,
     IDENT = 335,
     FCONST = 336,
     SCONST = 337,
     BCONST = 338,
     XCONST = 339,
     Op = 340,
     ICONST = 341,
     PARAM = 342,
     TYPECAST = 343,
     DOT_DOT = 344,
     COLON_EQUALS = 345,
     ABORT_P = 346,
     ABSOLUTE_P = 347,
     ACCESS = 348,
     ACTION = 349,
     ADD_P = 350,
     ADMIN = 351,
     AFTER = 352,
     AGGREGATE = 353,
     ALL = 354,
     ALSO = 355,
     ALTER = 356,
     ALWAYS = 357,
     ANALYSE = 358,
     ANALYZE = 359,
     AND = 360,
     ANY = 361,
     ARRAY = 362,
     AS = 363,
     ASC = 364,
     ASSERTION = 365,
     ASSIGNMENT = 366,
     ASYMMETRIC = 367,
     AT = 368,
     ATTRIBUTE = 369,
     AUTHORIZATION = 370,
     BACKWARD = 371,
     BEFORE = 372,
     BEGIN_P = 373,
     BETWEEN = 374,
     BIGINT = 375,
     BINARY = 376,
     BIT = 377,
     BOOLEAN_P = 378,
     BOTH = 379,
     BY = 380,
     CACHE = 381,
     CALLED = 382,
     CASCADE = 383,
     CASCADED = 384,
     CASE = 385,
     CAST = 386,
     CATALOG_P = 387,
     CHAIN = 388,
     CHAR_P = 389,
     CHARACTER = 390,
     CHARACTERISTICS = 391,
     CHECK = 392,
     CHECKPOINT = 393,
     CLASS = 394,
     CLOSE = 395,
     CLUSTER = 396,
     COALESCE = 397,
     COLLATE = 398,
     COLLATION = 399,
     COLUMN = 400,
     COMMENT = 401,
     COMMENTS = 402,
     COMMIT = 403,
     COMMITTED = 404,
     CONCURRENTLY = 405,
     CONFIGURATION = 406,
     CONNECTION = 407,
     CONSTRAINT = 408,
     CONSTRAINTS = 409,
     CONTENT_P = 410,
     CONTINUE_P = 411,
     CONVERSION_P = 412,
     COPY = 413,
     COST = 414,
     CREATE = 415,
     CROSS = 416,
     CSV = 417,
     CURRENT_P = 418,
     CURRENT_CATALOG = 419,
     CURRENT_DATE = 420,
     CURRENT_ROLE = 421,
     CURRENT_SCHEMA = 422,
     CURRENT_TIME = 423,
     CURRENT_TIMESTAMP = 424,
     CURRENT_USER = 425,
     CURSOR = 426,
     CYCLE = 427,
     DATA_P = 428,
     DATABASE = 429,
     DAY_P = 430,
     DEALLOCATE = 431,
     DEC = 432,
     DECIMAL_P = 433,
     DECLARE = 434,
     DEFAULT = 435,
     DEFAULTS = 436,
     DEFERRABLE = 437,
     DEFERRED = 438,
     DEFINER = 439,
     DELETE_P = 440,
     DELIMITER = 441,
     DELIMITERS = 442,
     DESC = 443,
     DICTIONARY = 444,
     DISABLE_P = 445,
     DISCARD = 446,
     DISTINCT = 447,
     DO = 448,
     DOCUMENT_P = 449,
     DOMAIN_P = 450,
     DOUBLE_P = 451,
     DROP = 452,
     EACH = 453,
     ELSE = 454,
     ENABLE_P = 455,
     ENCODING = 456,
     ENCRYPTED = 457,
     END_P = 458,
     ENUM_P = 459,
     ESCAPE = 460,
     EXCEPT = 461,
     EXCLUDE = 462,
     EXCLUDING = 463,
     EXCLUSIVE = 464,
     EXECUTE = 465,
     EXISTS = 466,
     EXPLAIN = 467,
     EXTENSION = 468,
     EXTERNAL = 469,
     EXTRACT = 470,
     FALSE_P = 471,
     FAMILY = 472,
     FETCH = 473,
     FIRST_P = 474,
     FLOAT_P = 475,
     FOLLOWING = 476,
     FOR = 477,
     FORCE = 478,
     FOREIGN = 479,
     FORWARD = 480,
     FREEZE = 481,
     FROM = 482,
     FULL = 483,
     FUNCTION = 484,
     FUNCTIONS = 485,
     GLOBAL = 486,
     GRANT = 487,
     GRANTED = 488,
     GREATEST = 489,
     GROUP_P = 490,
     HANDLER = 491,
     HAVING = 492,
     HEADER_P = 493,
     HOLD = 494,
     HOUR_P = 495,
     IDENTITY_P = 496,
     IF_P = 497,
     ILIKE = 498,
     IMMEDIATE = 499,
     IMMUTABLE = 500,
     IMPLICIT_P = 501,
     IN_P = 502,
     INCLUDING = 503,
     INCREMENT = 504,
     INDEX = 505,
     INDEXES = 506,
     INHERIT = 507,
     INHERITS = 508,
     INITIALLY = 509,
     INLINE_P = 510,
     INNER_P = 511,
     INOUT = 512,
     INPUT_P = 513,
     INSENSITIVE = 514,
     INSERT = 515,
     INSTEAD = 516,
     INT_P = 517,
     INTEGER = 518,
     INTERSECT = 519,
     INTERVAL = 520,
     INTO = 521,
     INVOKER = 522,
     IS = 523,
     ISNULL = 524,
     ISOLATION = 525,
     JOIN = 526,
     KEY = 527,
     LABEL = 528,
     LANGUAGE = 529,
     LARGE_P = 530,
     LAST_P = 531,
     LC_COLLATE_P = 532,
     LC_CTYPE_P = 533,
     LEADING = 534,
     LEAST = 535,
     LEFT = 536,
     LEVEL = 537,
     LIKE = 538,
     LIMIT = 539,
     LISTEN = 540,
     LOAD = 541,
     LOCAL = 542,
     LOCALTIME = 543,
     LOCALTIMESTAMP = 544,
     LOCATION = 545,
     LOCK_P = 546,
     MAPPING = 547,
     MATCH = 548,
     MAXVALUE = 549,
     MINUTE_P = 550,
     MINVALUE = 551,
     MODE = 552,
     MONTH_P = 553,
     MOVE = 554,
     NAME_P = 555,
     NAMES = 556,
     NATIONAL = 557,
     NATURAL = 558,
     NCHAR = 559,
     NEXT = 560,
     NO = 561,
     NONE = 562,
     NOT = 563,
     NOTHING = 564,
     NOTIFY = 565,
     NOTNULL = 566,
     NOWAIT = 567,
     NULL_P = 568,
     NULLIF = 569,
     NULLS_P = 570,
     NUMERIC = 571,
     OBJECT_P = 572,
     OF = 573,
     OFF = 574,
     OFFSET = 575,
     OIDS = 576,
     ON = 577,
     ONLY = 578,
     OPERATOR = 579,
     OPTION = 580,
     OPTIONS = 581,
     OR = 582,
     ORDER = 583,
     OUT_P = 584,
     OUTER_P = 585,
     OVER = 586,
     OVERLAPS = 587,
     OVERLAY = 588,
     OWNED = 589,
     OWNER = 590,
     PARSER = 591,
     PARTIAL = 592,
     PARTITION = 593,
     PASSING = 594,
     PASSWORD = 595,
     PLACING = 596,
     PLANS = 597,
     POSITION = 598,
     PRECEDING = 599,
     PRECISION = 600,
     PRESERVE = 601,
     PREPARE = 602,
     PREPARED = 603,
     PRIMARY = 604,
     PRIOR = 605,
     PRIVILEGES = 606,
     PROCEDURAL = 607,
     PROCEDURE = 608,
     QUOTE = 609,
     RANGE = 610,
     READ = 611,
     REAL = 612,
     REASSIGN = 613,
     RECHECK = 614,
     RECURSIVE = 615,
     REF = 616,
     REFERENCES = 617,
     REINDEX = 618,
     RELATIVE_P = 619,
     RELEASE = 620,
     RENAME = 621,
     REPEATABLE = 622,
     REPLACE = 623,
     REPLICA = 624,
     RESET = 625,
     RESTART = 626,
     RESTRICT = 627,
     RETURNING = 628,
     RETURNS = 629,
     REVOKE = 630,
     RIGHT = 631,
     ROLE = 632,
     ROLLBACK = 633,
     ROW = 634,
     ROWS = 635,
     RULE = 636,
     SAVEPOINT = 637,
     SCHEMA = 638,
     SCROLL = 639,
     SEARCH = 640,
     SECOND_P = 641,
     SECURITY = 642,
     SELECT = 643,
     SEQUENCE = 644,
     SEQUENCES = 645,
     SERIALIZABLE = 646,
     SERVER = 647,
     SESSION = 648,
     SESSION_USER = 649,
     SET = 650,
     SETOF = 651,
     SHARE = 652,
     SHOW = 653,
     SIMILAR = 654,
     SIMPLE = 655,
     SMALLINT = 656,
     SOME = 657,
     STABLE = 658,
     STANDALONE_P = 659,
     START = 660,
     STATEMENT = 661,
     STATISTICS = 662,
     STDIN = 663,
     STDOUT = 664,
     STORAGE = 665,
     STRICT_P = 666,
     STRIP_P = 667,
     SUBSTRING = 668,
     SYMMETRIC = 669,
     SYSID = 670,
     SYSTEM_P = 671,
     TABLE = 672,
     TABLES = 673,
     TABLESPACE = 674,
     TEMP = 675,
     TEMPLATE = 676,
     TEMPORARY = 677,
     TEXT_P = 678,
     THEN = 679,
     TIME = 680,
     TIMESTAMP = 681,
     TO = 682,
     TRAILING = 683,
     TRANSACTION = 684,
     TREAT = 685,
     TRIGGER = 686,
     TRIM = 687,
     TRUE_P = 688,
     TRUNCATE = 689,
     TRUSTED = 690,
     TYPE_P = 691,
     UNBOUNDED = 692,
     UNCOMMITTED = 693,
     UNENCRYPTED = 694,
     UNION = 695,
     UNIQUE = 696,
     UNKNOWN = 697,
     UNLISTEN = 698,
     UNLOGGED = 699,
     UNTIL = 700,
     UPDATE = 701,
     USER = 702,
     USING = 703,
     VACUUM = 704,
     VALID = 705,
     VALIDATE = 706,
     VALIDATOR = 707,
     VALUE_P = 708,
     VALUES = 709,
     VARCHAR = 710,
     VARIADIC = 711,
     VARYING = 712,
     VERBOSE = 713,
     VERSION_P = 714,
     VIEW = 715,
     VOLATILE = 716,
     WHEN = 717,
     WHERE = 718,
     WHITESPACE_P = 719,
     WINDOW = 720,
     WITH = 721,
     WITHOUT = 722,
     WORK = 723,
     WRAPPER = 724,
     WRITE = 725,
     XML_P = 726,
     XMLATTRIBUTES = 727,
     XMLCONCAT = 728,
     XMLELEMENT = 729,
     XMLEXISTS = 730,
     XMLFOREST = 731,
     XMLPARSE = 732,
     XMLPI = 733,
     XMLROOT = 734,
     XMLSERIALIZE = 735,
     YEAR_P = 736,
     YES_P = 737,
     ZONE = 738,
     NULLS_FIRST = 739,
     NULLS_LAST = 740,
     WITH_TIME = 741,
     POSTFIXOP = 742,
     UMINUS = 743
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_COUNT 265
#define SQL_DATETIME_INTERVAL_CODE 266
#define SQL_DATETIME_INTERVAL_PRECISION 267
#define SQL_DESCRIBE 268
#define SQL_DESCRIPTOR 269
#define SQL_DISCONNECT 270
#define SQL_FOUND 271
#define SQL_FREE 272
#define SQL_GET 273
#define SQL_GO 274
#define SQL_GOTO 275
#define SQL_IDENTIFIED 276
#define SQL_INDICATOR 277
#define SQL_KEY_MEMBER 278
#define SQL_LENGTH 279
#define SQL_LONG 280
#define SQL_NULLABLE 281
#define SQL_OCTET_LENGTH 282
#define SQL_OPEN 283
#define SQL_OUTPUT 284
#define SQL_REFERENCE 285
#define SQL_RETURNED_LENGTH 286
#define SQL_RETURNED_OCTET_LENGTH 287
#define SQL_SCALE 288
#define SQL_SECTION 289
#define SQL_SHORT 290
#define SQL_SIGNED 291
#define SQL_SQL 292
#define SQL_SQLERROR 293
#define SQL_SQLPRINT 294
#define SQL_SQLWARNING 295
#define SQL_START 296
#define SQL_STOP 297
#define SQL_STRUCT 298
#define SQL_UNSIGNED 299
#define SQL_VAR 300
#define SQL_WHENEVER 301
#define S_ADD 302
#define S_AND 303
#define S_ANYTHING 304
#define S_AUTO 305
#define S_CONST 306
#define S_DEC 307
#define S_DIV 308
#define S_DOTPOINT 309
#define S_EQUAL 310
#define S_EXTERN 311
#define S_INC 312
#define S_LSHIFT 313
#define S_MEMPOINT 314
#define S_MEMBER 315
#define S_MOD 316
#define S_MUL 317
#define S_NEQUAL 318
#define S_OR 319
#define S_REGISTER 320
#define S_RSHIFT 321
#define S_STATIC 322
#define S_SUB 323
#define S_VOLATILE 324
#define S_TYPEDEF 325
#define CSTRING 326
#define CVARIABLE 327
#define CPP_LINE 328
#define IP 329
#define DOLCONST 330
#define ECONST 331
#define NCONST 332
#define UCONST 333
#define UIDENT 334
#define IDENT 335
#define FCONST 336
#define SCONST 337
#define BCONST 338
#define XCONST 339
#define Op 340
#define ICONST 341
#define PARAM 342
#define TYPECAST 343
#define DOT_DOT 344
#define COLON_EQUALS 345
#define ABORT_P 346
#define ABSOLUTE_P 347
#define ACCESS 348
#define ACTION 349
#define ADD_P 350
#define ADMIN 351
#define AFTER 352
#define AGGREGATE 353
#define ALL 354
#define ALSO 355
#define ALTER 356
#define ALWAYS 357
#define ANALYSE 358
#define ANALYZE 359
#define AND 360
#define ANY 361
#define ARRAY 362
#define AS 363
#define ASC 364
#define ASSERTION 365
#define ASSIGNMENT 366
#define ASYMMETRIC 367
#define AT 368
#define ATTRIBUTE 369
#define AUTHORIZATION 370
#define BACKWARD 371
#define BEFORE 372
#define BEGIN_P 373
#define BETWEEN 374
#define BIGINT 375
#define BINARY 376
#define BIT 377
#define BOOLEAN_P 378
#define BOTH 379
#define BY 380
#define CACHE 381
#define CALLED 382
#define CASCADE 383
#define CASCADED 384
#define CASE 385
#define CAST 386
#define CATALOG_P 387
#define CHAIN 388
#define CHAR_P 389
#define CHARACTER 390
#define CHARACTERISTICS 391
#define CHECK 392
#define CHECKPOINT 393
#define CLASS 394
#define CLOSE 395
#define CLUSTER 396
#define COALESCE 397
#define COLLATE 398
#define COLLATION 399
#define COLUMN 400
#define COMMENT 401
#define COMMENTS 402
#define COMMIT 403
#define COMMITTED 404
#define CONCURRENTLY 405
#define CONFIGURATION 406
#define CONNECTION 407
#define CONSTRAINT 408
#define CONSTRAINTS 409
#define CONTENT_P 410
#define CONTINUE_P 411
#define CONVERSION_P 412
#define COPY 413
#define COST 414
#define CREATE 415
#define CROSS 416
#define CSV 417
#define CURRENT_P 418
#define CURRENT_CATALOG 419
#define CURRENT_DATE 420
#define CURRENT_ROLE 421
#define CURRENT_SCHEMA 422
#define CURRENT_TIME 423
#define CURRENT_TIMESTAMP 424
#define CURRENT_USER 425
#define CURSOR 426
#define CYCLE 427
#define DATA_P 428
#define DATABASE 429
#define DAY_P 430
#define DEALLOCATE 431
#define DEC 432
#define DECIMAL_P 433
#define DECLARE 434
#define DEFAULT 435
#define DEFAULTS 436
#define DEFERRABLE 437
#define DEFERRED 438
#define DEFINER 439
#define DELETE_P 440
#define DELIMITER 441
#define DELIMITERS 442
#define DESC 443
#define DICTIONARY 444
#define DISABLE_P 445
#define DISCARD 446
#define DISTINCT 447
#define DO 448
#define DOCUMENT_P 449
#define DOMAIN_P 450
#define DOUBLE_P 451
#define DROP 452
#define EACH 453
#define ELSE 454
#define ENABLE_P 455
#define ENCODING 456
#define ENCRYPTED 457
#define END_P 458
#define ENUM_P 459
#define ESCAPE 460
#define EXCEPT 461
#define EXCLUDE 462
#define EXCLUDING 463
#define EXCLUSIVE 464
#define EXECUTE 465
#define EXISTS 466
#define EXPLAIN 467
#define EXTENSION 468
#define EXTERNAL 469
#define EXTRACT 470
#define FALSE_P 471
#define FAMILY 472
#define FETCH 473
#define FIRST_P 474
#define FLOAT_P 475
#define FOLLOWING 476
#define FOR 477
#define FORCE 478
#define FOREIGN 479
#define FORWARD 480
#define FREEZE 481
#define FROM 482
#define FULL 483
#define FUNCTION 484
#define FUNCTIONS 485
#define GLOBAL 486
#define GRANT 487
#define GRANTED 488
#define GREATEST 489
#define GROUP_P 490
#define HANDLER 491
#define HAVING 492
#define HEADER_P 493
#define HOLD 494
#define HOUR_P 495
#define IDENTITY_P 496
#define IF_P 497
#define ILIKE 498
#define IMMEDIATE 499
#define IMMUTABLE 500
#define IMPLICIT_P 501
#define IN_P 502
#define INCLUDING 503
#define INCREMENT 504
#define INDEX 505
#define INDEXES 506
#define INHERIT 507
#define INHERITS 508
#define INITIALLY 509
#define INLINE_P 510
#define INNER_P 511
#define INOUT 512
#define INPUT_P 513
#define INSENSITIVE 514
#define INSERT 515
#define INSTEAD 516
#define INT_P 517
#define INTEGER 518
#define INTERSECT 519
#define INTERVAL 520
#define INTO 521
#define INVOKER 522
#define IS 523
#define ISNULL 524
#define ISOLATION 525
#define JOIN 526
#define KEY 527
#define LABEL 528
#define LANGUAGE 529
#define LARGE_P 530
#define LAST_P 531
#define LC_COLLATE_P 532
#define LC_CTYPE_P 533
#define LEADING 534
#define LEAST 535
#define LEFT 536
#define LEVEL 537
#define LIKE 538
#define LIMIT 539
#define LISTEN 540
#define LOAD 541
#define LOCAL 542
#define LOCALTIME 543
#define LOCALTIMESTAMP 544
#define LOCATION 545
#define LOCK_P 546
#define MAPPING 547
#define MATCH 548
#define MAXVALUE 549
#define MINUTE_P 550
#define MINVALUE 551
#define MODE 552
#define MONTH_P 553
#define MOVE 554
#define NAME_P 555
#define NAMES 556
#define NATIONAL 557
#define NATURAL 558
#define NCHAR 559
#define NEXT 560
#define NO 561
#define NONE 562
#define NOT 563
#define NOTHING 564
#define NOTIFY 565
#define NOTNULL 566
#define NOWAIT 567
#define NULL_P 568
#define NULLIF 569
#define NULLS_P 570
#define NUMERIC 571
#define OBJECT_P 572
#define OF 573
#define OFF 574
#define OFFSET 575
#define OIDS 576
#define ON 577
#define ONLY 578
#define OPERATOR 579
#define OPTION 580
#define OPTIONS 581
#define OR 582
#define ORDER 583
#define OUT_P 584
#define OUTER_P 585
#define OVER 586
#define OVERLAPS 587
#define OVERLAY 588
#define OWNED 589
#define OWNER 590
#define PARSER 591
#define PARTIAL 592
#define PARTITION 593
#define PASSING 594
#define PASSWORD 595
#define PLACING 596
#define PLANS 597
#define POSITION 598
#define PRECEDING 599
#define PRECISION 600
#define PRESERVE 601
#define PREPARE 602
#define PREPARED 603
#define PRIMARY 604
#define PRIOR 605
#define PRIVILEGES 606
#define PROCEDURAL 607
#define PROCEDURE 608
#define QUOTE 609
#define RANGE 610
#define READ 611
#define REAL 612
#define REASSIGN 613
#define RECHECK 614
#define RECURSIVE 615
#define REF 616
#define REFERENCES 617
#define REINDEX 618
#define RELATIVE_P 619
#define RELEASE 620
#define RENAME 621
#define REPEATABLE 622
#define REPLACE 623
#define REPLICA 624
#define RESET 625
#define RESTART 626
#define RESTRICT 627
#define RETURNING 628
#define RETURNS 629
#define REVOKE 630
#define RIGHT 631
#define ROLE 632
#define ROLLBACK 633
#define ROW 634
#define ROWS 635
#define RULE 636
#define SAVEPOINT 637
#define SCHEMA 638
#define SCROLL 639
#define SEARCH 640
#define SECOND_P 641
#define SECURITY 642
#define SELECT 643
#define SEQUENCE 644
#define SEQUENCES 645
#define SERIALIZABLE 646
#define SERVER 647
#define SESSION 648
#define SESSION_USER 649
#define SET 650
#define SETOF 651
#define SHARE 652
#define SHOW 653
#define SIMILAR 654
#define SIMPLE 655
#define SMALLINT 656
#define SOME 657
#define STABLE 658
#define STANDALONE_P 659
#define START 660
#define STATEMENT 661
#define STATISTICS 662
#define STDIN 663
#define STDOUT 664
#define STORAGE 665
#define STRICT_P 666
#define STRIP_P 667
#define SUBSTRING 668
#define SYMMETRIC 669
#define SYSID 670
#define SYSTEM_P 671
#define TABLE 672
#define TABLES 673
#define TABLESPACE 674
#define TEMP 675
#define TEMPLATE 676
#define TEMPORARY 677
#define TEXT_P 678
#define THEN 679
#define TIME 680
#define TIMESTAMP 681
#define TO 682
#define TRAILING 683
#define TRANSACTION 684
#define TREAT 685
#define TRIGGER 686
#define TRIM 687
#define TRUE_P 688
#define TRUNCATE 689
#define TRUSTED 690
#define TYPE_P 691
#define UNBOUNDED 692
#define UNCOMMITTED 693
#define UNENCRYPTED 694
#define UNION 695
#define UNIQUE 696
#define UNKNOWN 697
#define UNLISTEN 698
#define UNLOGGED 699
#define UNTIL 700
#define UPDATE 701
#define USER 702
#define USING 703
#define VACUUM 704
#define VALID 705
#define VALIDATE 706
#define VALIDATOR 707
#define VALUE_P 708
#define VALUES 709
#define VARCHAR 710
#define VARIADIC 711
#define VARYING 712
#define VERBOSE 713
#define VERSION_P 714
#define VIEW 715
#define VOLATILE 716
#define WHEN 717
#define WHERE 718
#define WHITESPACE_P 719
#define WINDOW 720
#define WITH 721
#define WITHOUT 722
#define WORK 723
#define WRAPPER 724
#define WRITE 725
#define XML_P 726
#define XMLATTRIBUTES 727
#define XMLCONCAT 728
#define XMLELEMENT 729
#define XMLEXISTS 730
#define XMLFOREST 731
#define XMLPARSE 732
#define XMLPI 733
#define XMLROOT 734
#define XMLSERIALIZE 735
#define YEAR_P 736
#define YES_P 737
#define ZONE 738
#define NULLS_FIRST 739
#define NULLS_LAST 740
#define WITH_TIME 741
#define POSTFIXOP 742
#define UMINUS 743




/* Copy the first part of user declarations.  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int 	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);

			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
			        fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), mm_strdup(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in other functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn's cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = mm_strdup("");
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char temp[20];
			char *original_var;
			bool skip_set_var = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(temp, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable) && (!strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement"))))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char && ptr->variable->type->type != ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, mm_strdup("1"), ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
				sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char || ptr->variable->type->type == ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				if (ptr->variable->type->type == ECPGt_varchar)
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				else
					sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_struct || ptr->variable->type->type == ECPGt_union)
			{
				sprintf(temp, "%d)))", ecpg_internal_var);
				newvar = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->variable->type->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.members, ptr->variable->type->type, ptr->variable->type->type_name, ptr->variable->type->struct_sizeof), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct || ptr->variable->type->u.element->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newvar = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->variable->type->u.element->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.element->u.members, ptr->variable->type->u.element->type, ptr->variable->type->u.element->type_name, ptr->variable->type->u.element->struct_sizeof), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newvar = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, ptr->variable->type->u.element->size, ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, mm_strdup("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}

			/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
			if (!skip_set_var)
				result = cat_str(5, result, mm_strdup("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), mm_strdup("), __LINE__);\n"));

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(temp, "%d))", ecpg_internal_var);

				if (ptr->indicator->type->type == ECPGt_struct || ptr->indicator->type->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newind = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->indicator->type->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.members, ptr->indicator->type->type, ptr->indicator->type->type_name, ptr->indicator->type->struct_sizeof), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct || ptr->indicator->type->u.element->type == ECPGt_union)
					{
						sprintf(temp, "%d)))", ecpg_internal_var);
						newind = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->indicator->type->u.element->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.element->u.members, ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->type_name, ptr->indicator->type->u.element->struct_sizeof), 0);
						sprintf(temp, "%d, (", ecpg_internal_var++);
					}
					else
					{
						newind = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->size, ptr->indicator->type->u.element->counter), ptr->indicator->type->size), 0);
						sprintf(temp, "%d, &(", ecpg_internal_var++);
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newind = new_variable(cat_str(4, mm_strdup("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				result = cat_str(5, result, mm_strdup("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), mm_strdup("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && !strcmp(cur->function, current_function)))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;
	int (* strcmp_fn)(const char *, const char *) = (name[0] == ':' ? strcmp : pg_strcasecmp);

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp_fn(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 463 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1529 "preproc.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1553 "preproc.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   98618

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  508
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  686
/* YYNRULES -- Number of rules. */
#define YYNRULES  2687
/* YYNRULES -- Number of states. */
#define YYNSTATES  4825

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   743

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   495,     2,     2,
     500,   501,   493,   491,   503,   492,   502,   494,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   505,   504,
     488,   487,   489,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   498,     2,   499,   496,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   506,     2,   507,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   490,   497
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   245,   247,   249,   251,   253,   255,   257,
     259,   261,   263,   264,   270,   272,   273,   276,   277,   280,
     281,   284,   287,   291,   295,   297,   301,   305,   308,   310,
     312,   315,   318,   321,   325,   329,   335,   341,   342,   346,
     352,   358,   363,   367,   373,   377,   383,   389,   396,   398,
     400,   404,   410,   417,   422,   424,   425,   428,   429,   431,
     433,   435,   437,   439,   441,   444,   448,   452,   456,   460,
     464,   468,   472,   476,   479,   485,   488,   491,   494,   497,
     501,   505,   509,   511,   515,   517,   521,   523,   525,   528,
     531,   534,   536,   538,   540,   542,   544,   546,   548,   552,
     559,   561,   563,   565,   567,   569,   570,   572,   574,   577,
     581,   586,   590,   593,   596,   598,   602,   607,   613,   618,
     621,   626,   628,   630,   632,   634,   636,   639,   642,   645,
     648,   653,   658,   663,   668,   670,   674,   677,   681,   686,
     693,   700,   707,   713,   719,   726,   733,   738,   747,   750,
     754,   761,   766,   770,   774,   778,   782,   786,   791,   796,
     800,   804,   808,   812,   816,   820,   825,   830,   834,   837,
     841,   844,   847,   851,   855,   858,   861,   863,   867,   870,
     872,   874,   875,   878,   879,   882,   883,   887,   890,   891,
     893,   897,   901,   903,   909,   913,   918,   920,   924,   929,
     936,   941,   950,   953,   956,   967,   974,   976,   978,   980,
     982,   984,   986,   990,   993,   994,   996,   998,  1002,  1006,
    1008,  1010,  1014,  1018,  1022,  1026,  1031,  1034,  1036,  1037,
    1040,  1041,  1045,  1046,  1048,  1049,  1051,  1055,  1058,  1060,
    1062,  1064,  1068,  1069,  1071,  1075,  1077,  1089,  1104,  1115,
    1129,  1131,  1133,  1136,  1139,  1142,  1145,  1147,  1148,  1150,
    1151,  1155,  1156,  1158,  1162,  1164,  1168,  1170,  1172,  1174,
    1176,  1178,  1182,  1187,  1190,  1191,  1195,  1197,  1199,  1202,
    1205,  1207,  1211,  1216,  1221,  1224,  1230,  1232,  1235,  1238,
    1241,  1245,  1249,  1253,  1254,  1256,  1258,  1260,  1262,  1264,
    1266,  1270,  1272,  1278,  1286,  1290,  1299,  1304,  1314,  1326,
    1330,  1331,  1333,  1337,  1339,  1342,  1345,  1348,  1349,  1351,
    1355,  1359,  1366,  1371,  1372,  1374,  1376,  1379,  1382,  1383,
    1387,  1391,  1394,  1396,  1398,  1401,  1404,  1409,  1410,  1413,
    1416,  1419,  1420,  1424,  1429,  1434,  1435,  1438,  1439,  1444,
    1445,  1449,  1455,  1459,  1460,  1462,  1466,  1468,  1471,  1475,
    1476,  1482,  1487,  1489,  1490,  1492,  1495,  1498,  1500,  1503,
    1507,  1510,  1513,  1516,  1519,  1523,  1527,  1529,  1533,  1535,
    1536,  1538,  1541,  1543,  1545,  1549,  1556,  1567,  1569,  1570,
    1572,  1575,  1578,  1579,  1582,  1585,  1587,  1588,  1594,  1602,
    1604,  1605,  1612,  1615,  1616,  1620,  1626,  1632,  1641,  1644,
    1645,  1648,  1651,  1654,  1660,  1663,  1664,  1667,  1675,  1686,
    1693,  1700,  1707,  1714,  1722,  1730,  1740,  1750,  1757,  1764,
    1773,  1782,  1791,  1800,  1807,  1814,  1822,  1831,  1838,  1845,
    1853,  1856,  1859,  1862,  1865,  1867,  1870,  1872,  1873,  1880,
    1889,  1897,  1904,  1909,  1910,  1912,  1916,  1921,  1923,  1927,
    1929,  1932,  1935,  1938,  1941,  1943,  1945,  1956,  1959,  1960,
    1963,  1966,  1968,  1969,  1974,  1981,  1987,  1992,  1997,  2006,
    2018,  2022,  2025,  2027,  2031,  2033,  2039,  2048,  2050,  2052,
    2054,  2062,  2072,  2081,  2097,  2118,  2120,  2122,  2125,  2127,
    2131,  2133,  2135,  2137,  2141,  2143,  2147,  2148,  2150,  2151,
    2153,  2155,  2160,  2161,  2163,  2167,  2168,  2170,  2172,  2174,
    2176,  2179,  2180,  2181,  2184,  2187,  2189,  2192,  2195,  2198,
    2205,  2214,  2223,  2228,  2234,  2239,  2244,  2249,  2253,  2261,
    2270,  2277,  2284,  2291,  2298,  2303,  2309,  2313,  2315,  2319,
    2323,  2325,  2327,  2329,  2331,  2333,  2335,  2339,  2343,  2347,
    2349,  2353,  2357,  2359,  2360,  2362,  2366,  2373,  2382,  2391,
    2405,  2407,  2411,  2417,  2424,  2429,  2437,  2440,  2442,  2443,
    2446,  2447,  2450,  2455,  2456,  2458,  2459,  2466,  2475,  2484,
    2486,  2490,  2496,  2502,  2510,  2520,  2528,  2538,  2544,  2551,
    2558,  2563,  2565,  2567,  2569,  2571,  2574,  2576,  2578,  2580,
    2582,  2584,  2586,  2590,  2594,  2598,  2602,  2604,  2608,  2610,
    2613,  2616,  2620,  2626,  2629,  2632,  2633,  2640,  2648,  2656,
    2664,  2673,  2682,  2689,  2698,  2708,  2718,  2726,  2737,  2745,
    2754,  2763,  2772,  2781,  2783,  2785,  2787,  2789,  2791,  2793,
    2795,  2797,  2799,  2801,  2803,  2805,  2807,  2809,  2812,  2814,
    2818,  2820,  2822,  2831,  2841,  2851,  2861,  2871,  2874,  2875,
    2877,  2880,  2882,  2884,  2886,  2888,  2890,  2892,  2894,  2896,
    2899,  2902,  2906,  2911,  2917,  2922,  2928,  2932,  2937,  2941,
    2946,  2948,  2951,  2955,  2959,  2963,  2967,  2972,  2977,  2981,
    2985,  2990,  2995,  3000,  3005,  3007,  3009,  3011,  3012,  3020,
    3028,  3039,  3041,  3043,  3046,  3051,  3057,  3059,  3063,  3066,
    3069,  3072,  3075,  3077,  3080,  3083,  3088,  3092,  3095,  3098,
    3101,  3105,  3108,  3111,  3117,  3123,  3129,  3131,  3135,  3137,
    3140,  3144,  3145,  3147,  3151,  3154,  3161,  3168,  3178,  3182,
    3183,  3187,  3188,  3194,  3197,  3198,  3202,  3206,  3210,  3218,
    3226,  3237,  3239,  3241,  3243,  3258,  3260,  3261,  3263,  3264,
    3266,  3267,  3270,  3271,  3273,  3277,  3283,  3289,  3297,  3300,
    3301,  3303,  3306,  3307,  3309,  3311,  3312,  3314,  3316,  3317,
    3327,  3340,  3348,  3351,  3352,  3356,  3359,  3361,  3365,  3369,
    3372,  3374,  3378,  3382,  3386,  3389,  3392,  3394,  3396,  3398,
    3400,  3403,  3405,  3407,  3409,  3411,  3416,  3422,  3424,  3428,
    3432,  3434,  3437,  3442,  3448,  3450,  3452,  3454,  3456,  3460,
    3464,  3467,  3470,  3473,  3476,  3478,  3481,  3484,  3486,  3488,
    3490,  3494,  3497,  3498,  3501,  3503,  3507,  3513,  3515,  3518,
    3520,  3521,  3527,  3535,  3541,  3549,  3555,  3563,  3567,  3573,
    3579,  3585,  3587,  3591,  3594,  3596,  3599,  3601,  3604,  3616,
    3627,  3638,  3641,  3644,  3645,  3655,  3658,  3659,  3664,  3669,
    3674,  3676,  3678,  3680,  3681,  3689,  3696,  3703,  3710,  3717,
    3724,  3732,  3742,  3752,  3759,  3766,  3773,  3780,  3787,  3795,
    3804,  3814,  3823,  3830,  3837,  3844,  3850,  3856,  3865,  3874,
    3883,  3892,  3899,  3909,  3911,  3912,  3915,  3916,  3924,  3931,
    3938,  3945,  3952,  3959,  3967,  3977,  3987,  3994,  4003,  4012,
    4021,  4030,  4037,  4044,  4052,  4059,  4067,  4074,  4081,  4088,
    4095,  4102,  4110,  4118,  4126,  4136,  4146,  4153,  4160,  4167,
    4176,  4185,  4194,  4201,  4215,  4217,  4219,  4223,  4227,  4229,
    4231,  4233,  4235,  4237,  4239,  4241,  4242,  4244,  4246,  4248,
    4250,  4252,  4254,  4255,  4262,  4271,  4275,  4278,  4279,  4282,
    4285,  4288,  4291,  4295,  4299,  4302,  4305,  4308,  4311,  4315,
    4318,  4324,  4329,  4333,  4337,  4341,  4343,  4345,  4346,  4350,
    4353,  4356,  4358,  4361,  4363,  4367,  4370,  4372,  4373,  4382,
    4393,  4397,  4402,  4407,  4408,  4411,  4417,  4420,  4421,  4425,
    4429,  4433,  4437,  4441,  4445,  4449,  4453,  4457,  4461,  4465,
    4469,  4473,  4478,  4482,  4486,  4488,  4489,  4495,  4502,  4507,
    4510,  4511,  4516,  4520,  4526,  4533,  4538,  4545,  4552,  4558,
    4566,  4568,  4569,  4576,  4588,  4600,  4612,  4626,  4636,  4648,
    4659,  4664,  4667,  4673,  4676,  4677,  4682,  4688,  4694,  4699,
    4706,  4708,  4712,  4714,  4716,  4718,  4720,  4723,  4728,  4730,
    4732,  4734,  4735,  4737,  4738,  4740,  4741,  4745,  4746,  4749,
    4754,  4758,  4764,  4766,  4768,  4770,  4772,  4774,  4776,  4778,
    4780,  4784,  4787,  4789,  4791,  4793,  4795,  4797,  4798,  4804,
    4809,  4813,  4814,  4816,  4818,  4820,  4822,  4827,  4836,  4840,
    4841,  4848,  4850,  4855,  4858,  4860,  4864,  4867,  4871,  4872,
    4880,  4883,  4884,  4890,  4894,  4895,  4898,  4901,  4904,  4908,
    4910,  4914,  4916,  4919,  4921,  4922,  4931,  4933,  4937,  4939,
    4941,  4945,  4951,  4954,  4956,  4960,  4968,  4970,  4972,  4973,
    4977,  4980,  4983,  4986,  4987,  4990,  4993,  4995,  4997,  5001,
    5005,  5007,  5010,  5015,  5020,  5023,  5027,  5033,  5039,  5041,
    5043,  5053,  5055,  5058,  5063,  5068,  5073,  5076,  5080,  5082,
    5086,  5093,  5095,  5096,  5099,  5101,  5102,  5106,  5110,  5115,
    5120,  5125,  5130,  5134,  5137,  5139,  5141,  5142,  5144,  5146,
    5147,  5149,  5155,  5157,  5158,  5160,  5161,  5165,  5167,  5171,
    5176,  5180,  5183,  5186,  5188,  5190,  5192,  5193,  5196,  5201,
    5207,  5210,  5214,  5216,  5218,  5220,  5222,  5226,  5227,  5229,
    5231,  5233,  5235,  5237,  5241,  5242,  5245,  5246,  5248,  5252,
    5254,  5255,  5257,  5260,  5265,  5270,  5273,  5274,  5277,  5281,
    5284,  5285,  5287,  5291,  5293,  5296,  5298,  5301,  5307,  5314,
    5320,  5322,  5325,  5327,  5332,  5336,  5341,  5347,  5352,  5358,
    5363,  5369,  5372,  5377,  5379,  5382,  5385,  5388,  5390,  5392,
    5393,  5398,  5401,  5403,  5406,  5409,  5414,  5416,  5420,  5422,
    5425,  5429,  5431,  5434,  5435,  5438,  5443,  5444,  5446,  5447,
    5449,  5453,  5457,  5460,  5464,  5470,  5477,  5480,  5484,  5488,
    5493,  5494,  5496,  5498,  5500,  5502,  5504,  5507,  5513,  5515,
    5517,  5519,  5521,  5524,  5528,  5532,  5533,  5535,  5537,  5539,
    5541,  5543,  5546,  5549,  5552,  5555,  5558,  5560,  5564,  5565,
    5567,  5569,  5571,  5573,  5579,  5582,  5584,  5586,  5588,  5590,
    5596,  5599,  5602,  5605,  5607,  5611,  5615,  5618,  5620,  5621,
    5625,  5626,  5632,  5635,  5641,  5644,  5646,  5649,  5653,  5654,
    5656,  5658,  5660,  5662,  5664,  5666,  5670,  5674,  5678,  5682,
    5686,  5690,  5694,  5695,  5697,  5702,  5704,  5708,  5712,  5718,
    5721,  5724,  5728,  5732,  5736,  5740,  5744,  5748,  5752,  5756,
    5760,  5764,  5767,  5770,  5774,  5778,  5781,  5785,  5791,  5796,
    5803,  5807,  5813,  5818,  5825,  5830,  5837,  5843,  5851,  5855,
    5858,  5863,  5866,  5870,  5874,  5879,  5883,  5888,  5892,  5897,
    5903,  5910,  5917,  5925,  5932,  5940,  5947,  5955,  5959,  5964,
    5969,  5976,  5979,  5983,  5988,  5990,  5994,  5997,  6000,  6004,
    6008,  6012,  6016,  6020,  6024,  6028,  6032,  6036,  6040,  6043,
    6046,  6052,  6059,  6066,  6074,  6078,  6083,  6085,  6087,  6090,
    6095,  6097,  6099,  6101,  6104,  6107,  6110,  6112,  6117,  6123,
    6130,  6139,  6146,  6154,  6162,  6168,  6170,  6172,  6177,  6179,
    6184,  6186,  6191,  6193,  6198,  6200,  6202,  6204,  6206,  6208,
    6210,  6217,  6222,  6227,  6232,  6237,  6244,  6250,  6256,  6262,
    6267,  6274,  6279,  6284,  6289,  6294,  6300,  6308,  6316,  6326,
    6332,  6337,  6344,  6350,  6358,  6366,  6374,  6377,  6381,  6385,
    6389,  6394,  6395,  6400,  6402,  6406,  6410,  6412,  6414,  6416,
    6419,  6422,  6423,  6426,  6431,  6436,  6443,  6446,  6447,  6449,
    6453,  6457,  6460,  6463,  6464,  6471,  6473,  6474,  6478,  6479,
    6482,  6485,  6486,  6488,  6493,  6496,  6499,  6502,  6505,  6508,
    6513,  6517,  6523,  6525,  6527,  6529,  6531,  6533,  6535,  6537,
    6539,  6541,  6543,  6545,  6547,  6549,  6551,  6553,  6558,  6560,
    6565,  6567,  6572,  6574,  6577,  6579,  6582,  6584,  6588,  6590,
    6594,  6596,  6600,  6602,  6606,  6610,  6614,  6617,  6619,  6623,
    6627,  6628,  6630,  6632,  6634,  6636,  6638,  6640,  6642,  6644,
    6649,  6653,  6656,  6660,  6661,  6665,  6669,  6672,  6675,  6677,
    6678,  6681,  6684,  6688,  6691,  6693,  6695,  6699,  6705,  6707,
    6710,  6715,  6718,  6719,  6721,  6722,  6724,  6727,  6730,  6733,
    6737,  6743,  6745,  6748,  6749,  6752,  6754,  6755,  6757,  6759,
    6761,  6765,  6769,  6771,  6775,  6779,  6782,  6784,  6786,  6788,
    6792,  6794,  6797,  6799,  6803,  6805,  6807,  6809,  6811,  6813,
    6815,  6817,  6820,  6822,  6824,  6826,  6828,  6830,  6833,  6839,
    6842,  6846,  6853,  6855,  6857,  6859,  6861,  6863,  6865,  6867,
    6869,  6871,  6874,  6877,  6879,  6881,  6883,  6885,  6887,  6889,
    6891,  6893,  6895,  6897,  6899,  6901,  6903,  6905,  6907,  6909,
    6911,  6913,  6915,  6917,  6919,  6921,  6923,  6925,  6927,  6929,
    6931,  6933,  6935,  6937,  6939,  6941,  6943,  6945,  6947,  6949,
    6951,  6953,  6955,  6957,  6959,  6961,  6963,  6965,  6967,  6969,
    6971,  6973,  6975,  6977,  6979,  6981,  6983,  6985,  6987,  6989,
    6991,  6993,  6995,  6997,  6999,  7001,  7003,  7005,  7007,  7009,
    7011,  7013,  7015,  7017,  7019,  7021,  7023,  7025,  7027,  7029,
    7031,  7033,  7035,  7037,  7039,  7041,  7043,  7045,  7047,  7049,
    7051,  7053,  7055,  7057,  7059,  7061,  7063,  7065,  7067,  7069,
    7071,  7073,  7075,  7077,  7079,  7081,  7083,  7085,  7087,  7089,
    7091,  7093,  7095,  7097,  7099,  7101,  7103,  7105,  7107,  7109,
    7111,  7113,  7115,  7117,  7119,  7121,  7123,  7125,  7127,  7129,
    7131,  7133,  7135,  7137,  7139,  7141,  7143,  7145,  7147,  7149,
    7151,  7153,  7155,  7157,  7159,  7161,  7163,  7165,  7167,  7169,
    7171,  7173,  7175,  7177,  7179,  7181,  7183,  7185,  7187,  7189,
    7191,  7193,  7195,  7197,  7199,  7201,  7203,  7205,  7207,  7209,
    7211,  7213,  7215,  7217,  7219,  7221,  7223,  7225,  7227,  7229,
    7231,  7233,  7235,  7237,  7239,  7241,  7243,  7245,  7247,  7249,
    7251,  7253,  7255,  7257,  7259,  7261,  7263,  7265,  7267,  7269,
    7271,  7273,  7275,  7277,  7279,  7281,  7283,  7285,  7287,  7289,
    7291,  7293,  7295,  7297,  7299,  7301,  7303,  7305,  7307,  7309,
    7311,  7313,  7315,  7317,  7319,  7321,  7323,  7325,  7327,  7329,
    7331,  7333,  7335,  7337,  7339,  7341,  7343,  7345,  7347,  7349,
    7351,  7353,  7355,  7357,  7359,  7361,  7363,  7365,  7367,  7369,
    7371,  7373,  7375,  7377,  7379,  7381,  7383,  7385,  7387,  7389,
    7391,  7393,  7395,  7397,  7399,  7401,  7403,  7405,  7407,  7409,
    7411,  7413,  7415,  7417,  7419,  7421,  7423,  7425,  7427,  7429,
    7431,  7433,  7435,  7437,  7439,  7441,  7443,  7445,  7447,  7449,
    7451,  7453,  7455,  7457,  7459,  7461,  7463,  7465,  7467,  7469,
    7471,  7473,  7475,  7477,  7479,  7481,  7483,  7485,  7487,  7489,
    7491,  7493,  7495,  7497,  7499,  7501,  7503,  7505,  7507,  7509,
    7511,  7513,  7515,  7517,  7519,  7521,  7523,  7525,  7527,  7529,
    7531,  7533,  7535,  7537,  7539,  7541,  7543,  7545,  7547,  7549,
    7551,  7553,  7555,  7557,  7559,  7561,  7563,  7565,  7567,  7569,
    7571,  7573,  7575,  7577,  7579,  7581,  7583,  7585,  7587,  7589,
    7591,  7593,  7595,  7597,  7599,  7601,  7603,  7605,  7607,  7609,
    7611,  7613,  7615,  7617,  7619,  7621,  7623,  7625,  7627,  7629,
    7631,  7633,  7635,  7636,  7639,  7644,  7648,  7651,  7653,  7655,
    7657,  7659,  7661,  7662,  7671,  7674,  7680,  7684,  7687,  7690,
    7694,  7702,  7704,  7706,  7708,  7709,  7712,  7715,  7717,  7718,
    7720,  7724,  7726,  7729,  7730,  7733,  7734,  7737,  7738,  7740,
    7744,  7749,  7753,  7755,  7757,  7759,  7761,  7764,  7765,  7768,
    7773,  7774,  7777,  7780,  7783,  7785,  7787,  7795,  7799,  7801,
    7803,  7805,  7807,  7810,  7811,  7813,  7817,  7821,  7825,  7829,
    7830,  7835,  7841,  7847,  7848,  7850,  7852,  7854,  7857,  7860,
    7862,  7865,  7866,  7874,  7875,  7881,  7882,  7887,  7890,  7893,
    7894,  7897,  7899,  7901,  7903,  7905,  7907,  7909,  7911,  7913,
    7915,  7917,  7919,  7925,  7928,  7930,  7934,  7937,  7940,  7944,
    7945,  7951,  7953,  7954,  7960,  7963,  7966,  7968,  7970,  7972,
    7975,  7978,  7982,  7984,  7987,  7990,  7994,  7998,  8003,  8006,
    8008,  8011,  8013,  8015,  8018,  8021,  8025,  8027,  8029,  8031,
    8033,  8034,  8036,  8040,  8046,  8047,  8050,  8051,  8053,  8056,
    8060,  8063,  8065,  8067,  8069,  8070,  8072,  8074,  8076,  8078,
    8080,  8083,  8086,  8090,  8091,  8093,  8096,  8098,  8103,  8107,
    8112,  8116,  8119,  8121,  8125,  8127,  8129,  8131,  8133,  8136,
    8139,  8141,  8144,  8147,  8149,  8151,  8153,  8158,  8163,  8168,
    8173,  8178,  8180,  8181,  8185,  8189,  8194,  8196,  8200,  8204,
    8209,  8211,  8215,  8219,  8221,  8223,  8225,  8232,  8234,  8238,
    8242,  8249,  8251,  8255,  8259,  8261,  8263,  8266,  8269,  8271,
    8273,  8275,  8277,  8279,  8281,  8283,  8285,  8287,  8289,  8291,
    8293,  8295,  8297,  8299,  8301,  8306,  8311,  8313,  8315,  8320,
    8325,  8329,  8330,  8338,  8340,  8341,  8342,  8350,  8354,  8359,
    8363,  8365,  8367,  8369,  8372,  8376,  8382,  8385,  8391,  8394,
    8396,  8398,  8400,  8402,  8404,  8406,  8408,  8410,  8412,  8414,
    8416,  8418,  8420,  8422,  8424,  8426,  8428,  8430,  8432,  8434,
    8436,  8438,  8440,  8442,  8444,  8446,  8448,  8450,  8452,  8454,
    8456,  8458,  8460,  8462,  8464,  8466,  8468,  8470,  8472,  8474,
    8476,  8478,  8480,  8482,  8484,  8486,  8488,  8490,  8492,  8494,
    8496,  8498,  8500,  8502,  8504,  8506,  8508,  8510,  8512,  8514,
    8516,  8518,  8520,  8522,  8524,  8526,  8528,  8530,  8532,  8534,
    8536,  8538,  8540,  8542,  8544,  8546,  8548,  8550,  8552,  8554,
    8556,  8558,  8560,  8562,  8564,  8566,  8568,  8570,  8572,  8574,
    8576,  8578,  8580,  8582,  8584,  8586,  8588,  8590,  8594,  8596,
    8597,  8599,  8602,  8604,  8607,  8609,  8611,  8613,  8616,  8619,
    8621,  8623,  8625,  8627,  8629,  8631,  8633,  8635,  8637,  8639,
    8641,  8643,  8645,  8647,  8649,  8651,  8654,  8658,  8660,  8663,
    8665,  8669,  8671,  8675,  8677,  8679,  8681,  8683,  8685,  8687,
    8689,  8691,  8693,  8695,  8697,  8699,  8701,  8703,  8705,  8707,
    8709,  8711,  8713,  8715,  8717,  8719,  8721,  8723,  8725,  8727,
    8729,  8731,  8733,  8735,  8737,  8739,  8741,  8743,  8745,  8747,
    8749,  8751,  8753,  8755,  8757,  8759,  8761,  8763,  8765,  8767,
    8769,  8771,  8773,  8775,  8777,  8779,  8781,  8783,  8785,  8787,
    8789,  8791,  8793,  8795,  8797,  8800,  8804,  8807,  8811,  8813,
    8817,  8821,  8825,  8829,  8833,  8837,  8839,  8841,  8842,  8845,
    8848,  8850,  8852,  8855,  8857,  8859,  8861,  8862
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     509,     0,    -1,  1045,    -1,   835,    -1,   836,    -1,   753,
      -1,   841,    -1,   704,    -1,   644,    -1,   647,    -1,   653,
      -1,   667,    -1,   672,    -1,   788,    -1,   526,    -1,   809,
      -1,   810,    -1,   623,    -1,   551,    -1,   562,    -1,   520,
      -1,   518,    -1,   844,    -1,   843,    -1,   676,    -1,   522,
      -1,   521,    -1,   851,    -1,   549,    -1,   565,    -1,   846,
      -1,   727,    -1,   546,    -1,   566,    -1,  1047,    -1,   691,
      -1,   799,    -1,   845,    -1,   840,    -1,   641,    -1,   648,
      -1,   662,    -1,   668,    -1,   769,    -1,   525,    -1,   705,
      -1,   712,    -1,   713,    -1,   630,    -1,   529,    -1,   622,
      -1,   581,    -1,   638,    -1,   677,    -1,   511,    -1,   517,
      -1,   673,    -1,   831,    -1,  1188,    -1,   886,    -1,   693,
      -1,   873,    -1,   550,    -1,   796,    -1,   692,    -1,   801,
      -1,   652,    -1,   666,    -1,   528,    -1,   716,    -1,   717,
      -1,   718,    -1,   636,    -1,   818,    -1,   720,    -1,   640,
      -1,   690,    -1,   523,    -1,   524,    -1,   675,    -1,   839,
      -1,   866,    -1,   857,    -1,   734,    -1,   738,    -1,   749,
      -1,   758,    -1,   868,    -1,   821,    -1,   830,    -1,   875,
      -1,   819,    -1,   863,    -1,   719,    -1,   803,    -1,   792,
      -1,   791,    -1,   793,    -1,   806,    -1,   739,    -1,   750,
      -1,   811,    -1,   730,    -1,   890,    -1,   823,    -1,   725,
      -1,   822,    -1,   879,    -1,   848,    -1,   543,    -1,   533,
      -1,   545,    -1,   828,    -1,  1124,    -1,  1050,    -1,  1067,
      -1,  1125,    -1,  1107,    -1,  1122,    -1,  1108,    -1,  1068,
      -1,  1112,    -1,  1134,    -1,  1126,    -1,  1113,    -1,  1142,
      -1,  1144,    -1,  1137,    -1,  1129,    -1,  1145,    -1,  1148,
      -1,  1150,    -1,    -1,   160,   377,  1039,   512,   513,    -1,
     466,    -1,    -1,   513,   516,    -1,    -1,   514,   515,    -1,
      -1,   340,  1178,    -1,   340,   313,    -1,   202,   340,  1178,
      -1,   439,   340,  1178,    -1,   252,    -1,   152,   284,  1040,
      -1,   450,   445,  1178,    -1,   447,  1029,    -1,  1180,    -1,
     515,    -1,   415,  1038,    -1,    96,  1029,    -1,   377,  1029,
      -1,   247,   377,  1029,    -1,   247,   235,  1029,    -1,   160,
     447,  1039,   512,   513,    -1,   101,   377,  1039,   512,   514,
      -1,    -1,   247,   174,  1031,    -1,   101,   377,  1039,   519,
     544,    -1,   101,   447,  1039,   512,   514,    -1,   101,   447,
    1039,   544,    -1,   197,   377,  1029,    -1,   197,   377,   242,
     211,  1029,    -1,   197,   447,  1029,    -1,   197,   447,   242,
     211,  1029,    -1,   160,   235,  1039,   512,   513,    -1,   101,
     235,  1039,   527,   447,  1029,    -1,    95,    -1,   197,    -1,
     197,   235,  1029,    -1,   197,   235,   242,   211,  1029,    -1,
     160,   383,   530,   115,  1039,   531,    -1,   160,   383,  1158,
     531,    -1,  1158,    -1,    -1,   531,   532,    -1,    -1,   581,
      -1,   758,    -1,   622,    -1,   677,    -1,   738,    -1,   828,
      -1,   395,   534,    -1,   395,   287,   534,    -1,   395,   393,
     534,    -1,   535,   427,   536,    -1,   535,   487,   536,    -1,
     535,   427,   180,    -1,   535,   487,   180,    -1,   535,   227,
     163,    -1,   425,   483,   540,    -1,   429,   826,    -1,   393,
     136,   108,   429,   826,    -1,   132,  1178,    -1,   383,  1178,
      -1,   301,   541,    -1,   377,   542,    -1,   393,   115,   542,
      -1,   393,   115,   180,    -1,   471,   325,   976,    -1,  1157,
      -1,   535,   502,  1158,    -1,   537,    -1,   536,   503,   537,
      -1,   539,    -1,   628,    -1,   356,   438,    -1,   356,   149,
      -1,   367,   356,    -1,   391,    -1,   433,    -1,   216,    -1,
     322,    -1,   542,    -1,  1178,    -1,  1180,    -1,   963,  1178,
     965,    -1,   963,   500,  1038,   501,  1178,   965,    -1,   628,
      -1,   180,    -1,   287,    -1,  1178,    -1,   180,    -1,    -1,
    1158,    -1,  1178,    -1,   370,   535,    -1,   370,   425,   483,
      -1,   370,   429,   270,   282,    -1,   370,   393,   115,    -1,
     370,    99,    -1,   395,   534,    -1,   543,    -1,   398,   535,
    1191,    -1,   398,   425,   483,  1191,    -1,   398,   429,   270,
     282,  1191,    -1,   398,   393,   115,  1191,    -1,   398,    99,
      -1,   395,   154,   547,   548,    -1,    99,    -1,  1027,    -1,
     183,    -1,   244,    -1,   138,    -1,   191,    99,    -1,   191,
     420,    -1,   191,   422,    -1,   191,   342,    -1,   101,   417,
     934,   552,    -1,   101,   250,  1028,   552,    -1,   101,   389,
    1028,   552,    -1,   101,   460,  1028,   552,    -1,   553,    -1,
     552,   503,   553,    -1,    95,   589,    -1,    95,   145,   589,
      -1,   101,   807,  1158,   554,    -1,   101,   807,  1158,   197,
     308,   313,    -1,   101,   807,  1158,   395,   308,   313,    -1,
     101,   807,  1158,   395,   407,  1040,    -1,   101,   807,  1158,
     395,   558,    -1,   101,   807,  1158,   370,   558,    -1,   101,
     807,  1158,   395,   410,  1158,    -1,   197,   807,   242,   211,
    1158,   555,    -1,   197,   807,  1158,   555,    -1,   101,   807,
    1158,   808,   436,   943,   556,   557,    -1,    95,   598,    -1,
     451,   153,  1030,    -1,   197,   153,   242,   211,  1030,   555,
      -1,   197,   153,  1030,   555,    -1,   395,   466,   321,    -1,
     395,   467,   321,    -1,   141,   322,  1030,    -1,   395,   467,
     141,    -1,   200,   431,  1030,    -1,   200,   102,   431,  1030,
      -1,   200,   369,   431,  1030,    -1,   200,   431,    99,    -1,
     200,   431,   447,    -1,   190,   431,  1030,    -1,   190,   431,
      99,    -1,   190,   431,   447,    -1,   200,   381,  1030,    -1,
     200,   102,   381,  1030,    -1,   200,   369,   381,  1030,    -1,
     190,   381,  1030,    -1,   252,  1028,    -1,   306,   252,  1028,
      -1,   318,   723,    -1,   308,   318,    -1,   335,   427,  1039,
      -1,   395,   419,  1030,    -1,   395,   558,    -1,   370,   558,
      -1,   656,    -1,   395,   180,   967,    -1,   197,   180,    -1,
     128,    -1,   372,    -1,    -1,   143,   723,    -1,    -1,   448,
     967,    -1,    -1,   500,   560,   501,    -1,   466,   558,    -1,
      -1,   561,    -1,   560,   503,   561,    -1,  1160,   487,   697,
      -1,  1160,    -1,  1160,   502,  1160,   487,   697,    -1,  1160,
     502,  1160,    -1,   101,   436,   723,   563,    -1,   564,    -1,
     563,   503,   564,    -1,    95,   114,   942,   555,    -1,   197,
     114,   242,   211,  1158,   555,    -1,   197,   114,  1158,   555,
      -1,   101,   114,  1158,   808,   436,   943,   556,   555,    -1,
     140,   887,    -1,   140,    99,    -1,   158,   572,  1028,   600,
     573,   567,   568,   574,   512,   569,    -1,   158,   891,   427,
     568,   512,   569,    -1,   227,    -1,   427,    -1,  1178,    -1,
     408,    -1,   409,    -1,   570,    -1,   500,   576,   501,    -1,
     570,   571,    -1,    -1,   121,    -1,   321,    -1,   186,   842,
    1178,    -1,   313,   842,  1178,    -1,   162,    -1,   238,    -1,
     354,   842,  1178,    -1,   205,   842,  1178,    -1,   223,   354,
     601,    -1,   223,   354,   493,    -1,   223,   308,   313,   601,
      -1,   201,  1178,    -1,   121,    -1,    -1,   466,   321,    -1,
      -1,   575,   187,  1178,    -1,    -1,   448,    -1,    -1,   577,
      -1,   576,   503,   577,    -1,  1160,   578,    -1,   539,    -1,
     628,    -1,   493,    -1,   500,   579,   501,    -1,    -1,   580,
      -1,   579,   503,   580,    -1,   539,    -1,   160,   582,   417,
    1028,   500,   583,   501,   611,   612,   613,   614,    -1,   160,
     582,   417,   242,   308,   211,  1028,   500,   583,   501,   611,
     612,   613,   614,    -1,   160,   582,   417,  1028,   318,   723,
     584,   612,   613,   614,    -1,   160,   582,   417,   242,   308,
     211,  1028,   318,   723,   584,   612,   613,   614,    -1,   422,
      -1,   420,    -1,   287,   422,    -1,   287,   420,    -1,   231,
     422,    -1,   231,   420,    -1,   444,    -1,    -1,   585,    -1,
      -1,   500,   586,   501,    -1,    -1,   587,    -1,   585,   503,
     587,    -1,   588,    -1,   586,   503,   588,    -1,   589,    -1,
     595,    -1,   598,    -1,   590,    -1,   598,    -1,  1158,   943,
     591,    -1,  1158,   466,   326,   591,    -1,   591,   592,    -1,
      -1,   153,  1030,   593,    -1,   593,    -1,   594,    -1,   143,
     723,    -1,   308,   313,    -1,   313,    -1,   441,   785,   615,
      -1,   349,   272,   785,   615,    -1,   137,   500,   967,   501,
      -1,   180,   968,    -1,   362,  1028,   600,   603,   607,    -1,
     182,    -1,   308,   182,    -1,   254,   183,    -1,   254,   244,
      -1,   283,  1028,   596,    -1,   596,   248,   597,    -1,   596,
     208,   597,    -1,    -1,   181,    -1,   154,    -1,   251,    -1,
     410,    -1,   147,    -1,    99,    -1,   153,  1030,   599,    -1,
     599,    -1,   137,   500,   967,   501,   688,    -1,   441,   500,
     601,   501,   785,   615,   688,    -1,   441,   616,   688,    -1,
     349,   272,   500,   601,   501,   785,   615,   688,    -1,   349,
     272,   616,   688,    -1,   207,   762,   500,   604,   501,   785,
     615,   606,   688,    -1,   224,   272,   500,   601,   501,   362,
    1028,   600,   603,   607,   688,    -1,   500,   601,   501,    -1,
      -1,   602,    -1,   601,   503,   602,    -1,  1158,    -1,   293,
     228,    -1,   293,   337,    -1,   293,   400,    -1,    -1,   605,
      -1,   604,   503,   605,    -1,   764,   466,   795,    -1,   764,
     466,   324,   500,   795,   501,    -1,   463,   500,   967,   501,
      -1,    -1,   608,    -1,   609,    -1,   608,   609,    -1,   609,
     608,    -1,    -1,   322,   446,   610,    -1,   322,   185,   610,
      -1,   306,    94,    -1,   372,    -1,   128,    -1,   395,   313,
      -1,   395,   180,    -1,   253,   500,  1027,   501,    -1,    -1,
     466,   558,    -1,   466,   321,    -1,   467,   321,    -1,    -1,
     322,   148,   197,    -1,   322,   148,   185,   380,    -1,   322,
     148,   346,   380,    -1,    -1,   419,  1030,    -1,    -1,   448,
     250,   419,  1030,    -1,    -1,   448,   250,  1034,    -1,  1028,
     618,   612,   613,   614,    -1,   500,   619,   501,    -1,    -1,
     620,    -1,   619,   503,   620,    -1,  1158,    -1,   466,   173,
      -1,   466,   306,   173,    -1,    -1,   160,   582,   389,  1028,
     624,    -1,   101,   389,  1028,   625,    -1,   625,    -1,    -1,
     626,    -1,   625,   626,    -1,   126,   628,    -1,   172,    -1,
     306,   172,    -1,   249,   627,   628,    -1,   294,   628,    -1,
     296,   628,    -1,   306,   294,    -1,   306,   296,    -1,   334,
     125,   723,    -1,   405,   512,   628,    -1,   371,    -1,   371,
     512,   628,    -1,   125,    -1,    -1,  1177,    -1,   492,  1177,
      -1,  1040,    -1,   628,    -1,   629,   503,   628,    -1,   160,
     770,   631,   637,   274,   542,    -1,   160,   770,   631,   637,
     274,   542,   236,   632,   633,   635,    -1,   435,    -1,    -1,
    1030,    -1,  1030,   724,    -1,   255,   632,    -1,    -1,   452,
     632,    -1,   306,   452,    -1,   634,    -1,    -1,   197,   637,
     274,   542,   555,    -1,   197,   637,   274,   242,   211,   542,
     555,    -1,   352,    -1,    -1,   160,   419,  1030,   639,   290,
    1178,    -1,   335,  1030,    -1,    -1,   197,   419,  1030,    -1,
     197,   419,   242,   211,  1030,    -1,   160,   213,  1030,   512,
     642,    -1,   160,   213,   242,   308,   211,  1030,   512,   642,
      -1,   642,   643,    -1,    -1,   383,  1030,    -1,   459,   542,
      -1,   227,   542,    -1,   101,   213,  1030,   446,   645,    -1,
     645,   646,    -1,    -1,   427,   542,    -1,   101,   213,  1030,
     527,    98,  1036,   698,    -1,   101,   213,  1030,   527,   131,
     500,   943,   108,   943,   501,    -1,   101,   213,  1030,   527,
     144,   723,    -1,   101,   213,  1030,   527,   157,   723,    -1,
     101,   213,  1030,   527,   195,   723,    -1,   101,   213,  1030,
     527,   229,   748,    -1,   101,   213,  1030,   527,   637,   274,
    1030,    -1,   101,   213,  1030,   527,   324,   795,   794,    -1,
     101,   213,  1030,   527,   324,   139,   723,   448,  1032,    -1,
     101,   213,  1030,   527,   324,   217,   723,   448,  1032,    -1,
     101,   213,  1030,   527,   383,  1030,    -1,   101,   213,  1030,
     527,   417,   723,    -1,   101,   213,  1030,   527,   423,   385,
     336,   723,    -1,   101,   213,  1030,   527,   423,   385,   189,
     723,    -1,   101,   213,  1030,   527,   423,   385,   421,   723,
      -1,   101,   213,  1030,   527,   423,   385,   151,   723,    -1,
     101,   213,  1030,   527,   389,   723,    -1,   101,   213,  1030,
     527,   460,   723,    -1,   101,   213,  1030,   527,   224,   417,
     723,    -1,   101,   213,  1030,   527,   224,   173,   469,  1030,
      -1,   101,   213,  1030,   527,   392,  1030,    -1,   101,   213,
    1030,   527,   436,   723,    -1,   160,   224,   173,   469,  1030,
     651,   654,    -1,   236,   632,    -1,   306,   236,    -1,   452,
     632,    -1,   306,   452,    -1,   649,    -1,   650,   649,    -1,
     650,    -1,    -1,   197,   224,   173,   469,  1030,   555,    -1,
     197,   224,   173,   469,   242,   211,  1030,   555,    -1,   101,
     224,   173,   469,  1030,   651,   656,    -1,   101,   224,   173,
     469,  1030,   650,    -1,   326,   500,   655,   501,    -1,    -1,
     659,    -1,   655,   503,   659,    -1,   326,   500,   657,   501,
      -1,   658,    -1,   657,   503,   658,    -1,   659,    -1,   395,
     659,    -1,    95,   659,    -1,   197,   660,    -1,   660,   661,
      -1,  1160,    -1,  1178,    -1,   160,   392,  1030,   663,   665,
     224,   173,   469,  1030,   654,    -1,   436,  1178,    -1,    -1,
     459,  1178,    -1,   459,   313,    -1,   664,    -1,    -1,   197,
     392,  1030,   555,    -1,   197,   392,   242,   211,  1030,   555,
      -1,   101,   392,  1030,   664,   656,    -1,   101,   392,  1030,
     664,    -1,   101,   392,  1030,   656,    -1,   160,   224,   417,
    1028,   669,   392,  1030,   654,    -1,   160,   224,   417,   242,
     308,   211,  1028,   669,   392,  1030,   654,    -1,   500,   670,
     501,    -1,   500,   501,    -1,   671,    -1,   670,   503,   671,
      -1,   589,    -1,   101,   224,   417,   934,   552,    -1,   160,
     447,   292,   222,   674,   392,  1030,   654,    -1,   170,    -1,
     447,    -1,  1039,    -1,   197,   447,   292,   222,   674,   392,
    1030,    -1,   197,   447,   292,   242,   211,   222,   674,   392,
    1030,    -1,   101,   447,   292,   222,   674,   392,  1030,   656,
      -1,   160,   431,  1030,   678,   679,   322,  1028,   681,   684,
     210,   353,  1036,   500,   685,   501,    -1,   160,   153,   431,
    1030,    97,   679,   322,  1028,   687,   688,   222,   198,   379,
     684,   210,   353,  1036,   500,   685,   501,    -1,   117,    -1,
      97,    -1,   261,   318,    -1,   680,    -1,   679,   327,   680,
      -1,   260,    -1,   185,    -1,   446,    -1,   446,   318,   601,
      -1,   434,    -1,   222,   682,   683,    -1,    -1,   198,    -1,
      -1,   379,    -1,   406,    -1,   462,   500,   967,   501,    -1,
      -1,   686,    -1,   685,   503,   686,    -1,    -1,  1038,    -1,
    1177,    -1,  1178,    -1,  1160,    -1,   227,  1028,    -1,    -1,
      -1,   688,   689,    -1,   308,   182,    -1,   182,    -1,   254,
     244,    -1,   254,   183,    -1,   308,   450,    -1,   197,   431,
    1030,   322,  1028,   555,    -1,   197,   431,   242,   211,  1030,
     322,  1028,   555,    -1,   160,   110,  1030,   137,   500,   967,
     501,   688,    -1,   197,   110,  1030,   555,    -1,   160,    98,
    1036,   698,   694,    -1,   160,    98,  1036,   699,    -1,   160,
     324,   795,   694,    -1,   160,   436,   723,   694,    -1,   160,
     436,   723,    -1,   160,   436,   723,   108,   500,   940,   501,
      -1,   160,   436,   723,   108,   204,   500,   702,   501,    -1,
     160,   423,   385,   336,   723,   694,    -1,   160,   423,   385,
     189,   723,   694,    -1,   160,   423,   385,   421,   723,   694,
      -1,   160,   423,   385,   151,   723,   694,    -1,   160,   144,
     723,   694,    -1,   160,   144,   723,   227,   723,    -1,   500,
     695,   501,    -1,   696,    -1,   695,   503,   696,    -1,  1160,
     487,   697,    -1,  1160,    -1,   779,    -1,  1044,    -1,   994,
      -1,   628,    -1,  1178,    -1,   500,   999,   501,    -1,   500,
     493,   501,    -1,   500,   700,   501,    -1,   701,    -1,   700,
     503,   701,    -1,  1180,   487,   697,    -1,   703,    -1,    -1,
    1178,    -1,   703,   503,  1178,    -1,   101,   436,   723,    95,
     453,  1178,    -1,   101,   436,   723,    95,   453,  1178,   117,
    1178,    -1,   101,   436,   723,    95,   453,  1178,    97,  1178,
      -1,   160,   324,   139,   723,   708,   222,   436,   943,   448,
    1032,   709,   108,   706,    -1,   707,    -1,   706,   503,   707,
      -1,   324,  1038,   795,   710,   711,    -1,   324,  1038,   795,
     794,   710,   711,    -1,   229,  1038,  1036,   771,    -1,   229,
    1038,   500,   999,   501,  1036,   771,    -1,   410,   943,    -1,
     180,    -1,    -1,   217,   723,    -1,    -1,   222,   385,    -1,
     222,   328,   125,   723,    -1,    -1,   359,    -1,    -1,   160,
     324,   217,   723,   448,  1032,    -1,   101,   324,   217,   723,
     448,  1032,    95,   706,    -1,   101,   324,   217,   723,   448,
    1032,   197,   714,    -1,   715,    -1,   714,   503,   715,    -1,
     324,  1038,   500,   999,   501,    -1,   229,  1038,   500,   999,
     501,    -1,   197,   324,   139,   723,   448,  1032,   555,    -1,
     197,   324,   139,   242,   211,   723,   448,  1032,   555,    -1,
     197,   324,   217,   723,   448,  1032,   555,    -1,   197,   324,
     217,   242,   211,   723,   448,  1032,   555,    -1,   197,   334,
     125,  1029,   555,    -1,   358,   334,   125,  1029,   427,  1030,
      -1,   197,   721,   242,   211,   722,   555,    -1,   197,   721,
     722,   555,    -1,   417,    -1,   389,    -1,   460,    -1,   250,
      -1,   224,   417,    -1,   436,    -1,   195,    -1,   144,    -1,
     157,    -1,   383,    -1,   213,    -1,   423,   385,   336,    -1,
     423,   385,   189,    -1,   423,   385,   421,    -1,   423,   385,
     151,    -1,   723,    -1,   722,   503,   723,    -1,  1158,    -1,
    1158,   724,    -1,   502,  1033,    -1,   724,   502,  1033,    -1,
     434,   901,   935,   726,   555,    -1,   156,   241,    -1,   371,
     241,    -1,    -1,   146,   322,   728,   723,   268,   729,    -1,
     146,   322,    98,  1036,   698,   268,   729,    -1,   146,   322,
     229,  1036,   771,   268,   729,    -1,   146,   322,   324,   795,
     794,   268,   729,    -1,   146,   322,   153,  1030,   322,   723,
     268,   729,    -1,   146,   322,   381,  1030,   322,   723,   268,
     729,    -1,   146,   322,   381,  1030,   268,   729,    -1,   146,
     322,   431,  1030,   322,   723,   268,   729,    -1,   146,   322,
     324,   139,   723,   448,  1032,   268,   729,    -1,   146,   322,
     324,   217,   723,   448,  1032,   268,   729,    -1,   146,   322,
     275,   317,   628,   268,   729,    -1,   146,   322,   131,   500,
     943,   108,   943,   501,   268,   729,    -1,   146,   322,   637,
     274,   723,   268,   729,    -1,   146,   322,   423,   385,   336,
     723,   268,   729,    -1,   146,   322,   423,   385,   189,   723,
     268,   729,    -1,   146,   322,   423,   385,   421,   723,   268,
     729,    -1,   146,   322,   423,   385,   151,   723,   268,   729,
      -1,   145,    -1,   174,    -1,   383,    -1,   250,    -1,   389,
      -1,   417,    -1,   195,    -1,   436,    -1,   460,    -1,   144,
      -1,   157,    -1,   419,    -1,   213,    -1,   377,    -1,   224,
     417,    -1,   392,    -1,   224,   173,   469,    -1,  1178,    -1,
     313,    -1,   387,   273,   731,   322,   732,   723,   268,   733,
      -1,   387,   273,   731,   322,    98,  1036,   698,   268,   733,
      -1,   387,   273,   731,   322,   229,  1036,   771,   268,   733,
      -1,   387,   273,   731,   322,   275,   317,   628,   268,   733,
      -1,   387,   273,   731,   322,   637,   274,   723,   268,   733,
      -1,   222,   542,    -1,    -1,   145,    -1,   224,   417,    -1,
     383,    -1,   389,    -1,   417,    -1,   195,    -1,   436,    -1,
     460,    -1,  1178,    -1,   313,    -1,   218,   735,    -1,   299,
     735,    -1,   218,   735,  1192,    -1,   218,   225,   887,  1193,
      -1,   218,   225,   736,   887,  1193,    -1,   218,   116,   887,
    1193,    -1,   218,   116,   736,   887,  1193,    -1,   299,   225,
     887,    -1,   299,   225,   736,   887,    -1,   299,   116,   887,
      -1,   299,   116,   736,   887,    -1,   887,    -1,   736,   887,
      -1,   305,   737,   887,    -1,   350,   737,   887,    -1,   219,
     737,   887,    -1,   276,   737,   887,    -1,    92,  1040,   737,
     887,    -1,   364,  1040,   737,   887,    -1,  1040,   737,   887,
      -1,    99,   737,   887,    -1,   225,  1040,   737,   887,    -1,
     225,    99,   737,   887,    -1,   116,  1040,   737,   887,    -1,
     116,    99,   737,   887,    -1,   227,    -1,   247,    -1,   736,
      -1,    -1,   232,   740,   322,   743,   427,   744,   746,    -1,
     375,   740,   322,   743,   227,   744,   555,    -1,   375,   232,
     325,   222,   740,   322,   743,   227,   744,   555,    -1,   741,
      -1,    99,    -1,    99,   351,    -1,    99,   500,   601,   501,
      -1,    99,   351,   500,   601,   501,    -1,   742,    -1,   741,
     503,   742,    -1,   388,   600,    -1,   362,   600,    -1,   160,
     600,    -1,  1158,   600,    -1,  1027,    -1,   417,  1027,    -1,
     389,  1027,    -1,   224,   173,   469,  1029,    -1,   224,   392,
    1029,    -1,   229,   747,    -1,   174,  1029,    -1,   274,  1029,
      -1,   275,   317,   629,    -1,   383,  1029,    -1,   419,  1029,
      -1,    99,   418,   247,   383,  1029,    -1,    99,   390,   247,
     383,  1029,    -1,    99,   230,   247,   383,  1029,    -1,   745,
      -1,   744,   503,   745,    -1,  1039,    -1,   235,  1039,    -1,
     466,   232,   325,    -1,    -1,   748,    -1,   747,   503,   748,
      -1,  1036,   771,    -1,   232,   741,   427,  1029,   751,   752,
      -1,   375,   741,   227,  1029,   752,   555,    -1,   375,    96,
     325,   222,   741,   227,  1029,   752,   555,    -1,   466,    96,
     325,    -1,    -1,   233,   125,  1039,    -1,    -1,   101,   180,
     351,   754,   756,    -1,   754,   755,    -1,    -1,   247,   383,
    1029,    -1,   222,   377,  1029,    -1,   222,   447,  1029,    -1,
     232,   740,   322,   757,   427,   744,   746,    -1,   375,   740,
     322,   757,   227,   744,   555,    -1,   375,   232,   325,   222,
     740,   322,   757,   227,   744,   555,    -1,   418,    -1,   230,
      -1,   390,    -1,   160,   759,   250,   760,   761,   322,  1028,
     762,   500,   763,   501,   559,   614,   938,    -1,   441,    -1,
      -1,   150,    -1,    -1,  1034,    -1,    -1,   448,  1032,    -1,
      -1,   764,    -1,   763,   503,   764,    -1,  1158,   765,   766,
     767,   768,    -1,   970,   765,   766,   767,   768,    -1,   500,
     967,   501,   765,   766,   767,   768,    -1,   143,   723,    -1,
      -1,   723,    -1,   448,   723,    -1,    -1,   109,    -1,   188,
      -1,    -1,   484,    -1,   485,    -1,    -1,   160,   770,   229,
    1036,   773,   374,   778,   781,   785,    -1,   160,   770,   229,
    1036,   773,   374,   417,   500,   787,   501,   781,   785,    -1,
     160,   770,   229,  1036,   773,   781,   785,    -1,   327,   368,
      -1,    -1,   500,   772,   501,    -1,   500,   501,    -1,   775,
      -1,   772,   503,   775,    -1,   500,   774,   501,    -1,   500,
     501,    -1,   780,    -1,   774,   503,   780,    -1,   776,   777,
     779,    -1,   777,   776,   779,    -1,   777,   779,    -1,   776,
     779,    -1,   779,    -1,   247,    -1,   329,    -1,   257,    -1,
     247,   329,    -1,   456,    -1,  1159,    -1,   779,    -1,   943,
      -1,  1159,   724,   495,   436,    -1,   396,  1159,   724,   495,
     436,    -1,   775,    -1,   775,   180,   967,    -1,   775,   487,
     967,    -1,   783,    -1,   781,   783,    -1,   127,   322,   313,
     258,    -1,   374,   313,   322,   313,   258,    -1,   411,    -1,
     245,    -1,   403,    -1,   461,    -1,   214,   387,   184,    -1,
     214,   387,   267,    -1,   387,   184,    -1,   387,   267,    -1,
     159,   628,    -1,   380,   628,    -1,   544,    -1,   108,   784,
      -1,   274,   542,    -1,   465,    -1,   782,    -1,  1178,    -1,
    1178,   503,  1178,    -1,   466,   694,    -1,    -1,   777,   779,
      -1,   786,    -1,   787,   503,   786,    -1,   101,   229,   748,
     789,   790,    -1,   782,    -1,   789,   782,    -1,   372,    -1,
      -1,   197,   229,  1036,   771,   555,    -1,   197,   229,   242,
     211,  1036,   771,   555,    -1,   197,    98,  1036,   698,   555,
      -1,   197,    98,   242,   211,  1036,   698,   555,    -1,   197,
     324,   795,   794,   555,    -1,   197,   324,   242,   211,   795,
     794,   555,    -1,   500,   943,   501,    -1,   500,   943,   503,
     943,   501,    -1,   500,   307,   503,   943,   501,    -1,   500,
     943,   503,   307,   501,    -1,   991,    -1,  1158,   502,   795,
      -1,   193,   797,    -1,   798,    -1,   797,   798,    -1,  1178,
      -1,   274,   542,    -1,   160,   131,   500,   943,   108,   943,
     501,   466,   229,   748,   800,    -1,   160,   131,   500,   943,
     108,   943,   501,   467,   229,   800,    -1,   160,   131,   500,
     943,   108,   943,   501,   466,   257,   800,    -1,   108,   246,
      -1,   108,   111,    -1,    -1,   197,   131,   802,   500,   943,
     108,   943,   501,   555,    -1,   242,   211,    -1,    -1,   363,
     804,  1028,   805,    -1,   363,   416,  1030,   805,    -1,   363,
     174,  1030,   805,    -1,   250,    -1,   417,    -1,   223,    -1,
      -1,   101,    98,  1036,   698,   366,   427,  1030,    -1,   101,
     144,   723,   366,   427,  1030,    -1,   101,   157,   723,   366,
     427,  1030,    -1,   101,   174,  1031,   366,   427,  1031,    -1,
     101,   229,   748,   366,   427,  1030,    -1,   101,   235,  1039,
     366,   427,  1039,    -1,   101,   637,   274,  1030,   366,   427,
    1030,    -1,   101,   324,   139,   723,   448,  1032,   366,   427,
    1030,    -1,   101,   324,   217,   723,   448,  1032,   366,   427,
    1030,    -1,   101,   383,  1030,   366,   427,  1030,    -1,   101,
     417,   934,   366,   427,  1030,    -1,   101,   389,  1028,   366,
     427,  1030,    -1,   101,   460,  1028,   366,   427,  1030,    -1,
     101,   250,  1028,   366,   427,  1030,    -1,   101,   224,   417,
     934,   366,   427,  1030,    -1,   101,   417,   934,   366,   807,
    1030,   427,  1030,    -1,   101,   224,   417,   934,   366,   807,
    1030,   427,  1030,    -1,   101,   431,  1030,   322,  1028,   366,
     427,  1030,    -1,   101,   377,  1039,   366,   427,  1039,    -1,
     101,   447,  1039,   366,   427,  1039,    -1,   101,   419,  1030,
     366,   427,  1030,    -1,   101,   419,  1030,   395,   558,    -1,
     101,   419,  1030,   370,   558,    -1,   101,   423,   385,   336,
     723,   366,   427,  1030,    -1,   101,   423,   385,   189,   723,
     366,   427,  1030,    -1,   101,   423,   385,   421,   723,   366,
     427,  1030,    -1,   101,   423,   385,   151,   723,   366,   427,
    1030,    -1,   101,   436,   723,   366,   427,  1030,    -1,   101,
     436,   723,   366,   114,  1030,   427,  1030,   555,    -1,   145,
      -1,    -1,   395,   173,    -1,    -1,   101,    98,  1036,   698,
     395,   383,  1030,    -1,   101,   144,   723,   395,   383,  1030,
      -1,   101,   157,   723,   395,   383,  1030,    -1,   101,   195,
     723,   395,   383,  1030,    -1,   101,   213,   723,   395,   383,
    1030,    -1,   101,   229,   748,   395,   383,  1030,    -1,   101,
     324,   795,   794,   395,   383,  1030,    -1,   101,   324,   139,
     723,   448,  1032,   395,   383,  1030,    -1,   101,   324,   217,
     723,   448,  1032,   395,   383,  1030,    -1,   101,   417,   934,
     395,   383,  1030,    -1,   101,   423,   385,   336,   723,   395,
     383,  1030,    -1,   101,   423,   385,   189,   723,   395,   383,
    1030,    -1,   101,   423,   385,   421,   723,   395,   383,  1030,
      -1,   101,   423,   385,   151,   723,   395,   383,  1030,    -1,
     101,   389,  1028,   395,   383,  1030,    -1,   101,   460,  1028,
     395,   383,  1030,    -1,   101,   224,   417,   934,   395,   383,
    1030,    -1,   101,   436,   723,   395,   383,  1030,    -1,   101,
      98,  1036,   698,   335,   427,  1039,    -1,   101,   144,   723,
     335,   427,  1039,    -1,   101,   157,   723,   335,   427,  1039,
      -1,   101,   174,  1031,   335,   427,  1039,    -1,   101,   195,
     723,   335,   427,  1039,    -1,   101,   229,   748,   335,   427,
    1039,    -1,   101,   637,   274,  1030,   335,   427,  1039,    -1,
     101,   275,   317,   628,   335,   427,  1039,    -1,   101,   324,
     795,   794,   335,   427,  1039,    -1,   101,   324,   139,   723,
     448,  1032,   335,   427,  1039,    -1,   101,   324,   217,   723,
     448,  1032,   335,   427,  1039,    -1,   101,   383,  1030,   335,
     427,  1039,    -1,   101,   436,   723,   335,   427,  1039,    -1,
     101,   419,  1030,   335,   427,  1039,    -1,   101,   423,   385,
     189,   723,   335,   427,  1039,    -1,   101,   423,   385,   151,
     723,   335,   427,  1039,    -1,   101,   224,   173,   469,  1030,
     335,   427,  1039,    -1,   101,   392,  1030,   335,   427,  1039,
      -1,   160,   770,   381,  1030,   108,   322,   816,   427,  1028,
     938,   193,   817,   812,    -1,   309,    -1,   814,    -1,   500,
     813,   501,    -1,   813,   504,   815,    -1,   815,    -1,   890,
      -1,   868,    -1,   879,    -1,   873,    -1,   819,    -1,   814,
      -1,    -1,   388,    -1,   446,    -1,   185,    -1,   260,    -1,
     261,    -1,   100,    -1,    -1,   197,   381,  1030,   322,  1028,
     555,    -1,   197,   381,   242,   211,  1030,   322,  1028,   555,
      -1,   310,  1158,   820,    -1,   503,  1178,    -1,    -1,   285,
    1158,    -1,   443,  1158,    -1,   443,   493,    -1,    91,   824,
      -1,   118,   824,   827,    -1,   405,   429,   827,    -1,   148,
     824,    -1,   203,   824,    -1,   378,   824,    -1,   382,  1158,
      -1,   365,   382,  1158,    -1,   365,  1158,    -1,   378,   824,
     427,   382,  1158,    -1,   378,   824,   427,  1158,    -1,   347,
     429,  1178,    -1,   148,   348,  1178,    -1,   378,   348,  1178,
      -1,   468,    -1,   429,    -1,    -1,   270,   282,   538,    -1,
     356,   323,    -1,   356,   470,    -1,   182,    -1,   308,   182,
      -1,   825,    -1,   826,   503,   825,    -1,   826,   825,    -1,
     826,    -1,    -1,   160,   582,   460,  1028,   600,   108,   890,
     829,    -1,   160,   327,   368,   582,   460,  1028,   600,   108,
     890,   829,    -1,   466,   137,   325,    -1,   466,   129,   137,
     325,    -1,   466,   287,   137,   325,    -1,    -1,   286,  1035,
      -1,   160,   174,  1031,   512,   832,    -1,   832,   833,    -1,
      -1,   419,   834,  1030,    -1,   419,   834,   180,    -1,   290,
     834,  1178,    -1,   290,   834,   180,    -1,   421,   834,  1030,
      -1,   421,   834,   180,    -1,   201,   834,  1178,    -1,   201,
     834,  1038,    -1,   201,   834,   180,    -1,   277,   834,  1178,
      -1,   277,   834,   180,    -1,   278,   834,  1178,    -1,   278,
     834,   180,    -1,   152,   284,   834,  1040,    -1,   335,   834,
    1030,    -1,   335,   834,   180,    -1,   487,    -1,    -1,   101,
     174,  1031,   512,   837,    -1,   101,   174,  1031,   395,   419,
    1030,    -1,   101,   174,  1031,   544,    -1,   837,   838,    -1,
      -1,   152,   284,   834,  1040,    -1,   197,   174,  1031,    -1,
     197,   174,   242,   211,  1031,    -1,   160,   195,   723,   842,
     943,   591,    -1,   101,   195,   723,   554,    -1,   101,   195,
     723,   197,   308,   313,    -1,   101,   195,   723,   395,   308,
     313,    -1,   101,   195,   723,    95,   598,    -1,   101,   195,
     723,   197,   153,  1030,   555,    -1,   108,    -1,    -1,   101,
     423,   385,   189,   723,   694,    -1,   101,   423,   385,   151,
     723,    95,   292,   222,  1029,   466,   722,    -1,   101,   423,
     385,   151,   723,   101,   292,   222,  1029,   466,   722,    -1,
     101,   423,   385,   151,   723,   101,   292,   368,   723,   466,
     723,    -1,   101,   423,   385,   151,   723,   101,   292,   222,
    1029,   368,   723,   466,   723,    -1,   101,   423,   385,   151,
     723,   197,   292,   222,  1029,    -1,   101,   423,   385,   151,
     723,   197,   292,   242,   211,   222,  1029,    -1,   160,   708,
     157,   723,   222,  1178,   427,  1178,   227,   723,    -1,   141,
     853,  1028,   847,    -1,   141,   853,    -1,   141,   853,  1034,
     322,  1028,    -1,   448,  1034,    -1,    -1,   449,   854,   855,
     853,    -1,   449,   854,   855,   853,  1028,    -1,   449,   854,
     855,   853,   851,    -1,   449,   500,   849,   501,    -1,   449,
     500,   849,   501,  1028,   856,    -1,   850,    -1,   849,   503,
     850,    -1,   852,    -1,   458,    -1,   226,    -1,   228,    -1,
     852,   853,    -1,   852,   853,  1028,   856,    -1,   104,    -1,
     103,    -1,   458,    -1,    -1,   228,    -1,    -1,   226,    -1,
      -1,   500,  1029,   501,    -1,    -1,   212,   858,    -1,   212,
     852,   853,   858,    -1,   212,   458,   858,    -1,   212,   500,
     859,   501,   858,    -1,   890,    -1,   868,    -1,   879,    -1,
     873,    -1,   886,    -1,  1047,    -1,   866,    -1,   860,    -1,
     859,   503,   860,    -1,   861,   862,    -1,  1158,    -1,   852,
      -1,   458,    -1,   539,    -1,   628,    -1,    -1,   347,  1066,
     864,   108,   865,    -1,   347,  1066,   227,  1111,    -1,   500,
     999,   501,    -1,    -1,   890,    -1,   868,    -1,   879,    -1,
     873,    -1,   210,  1066,   867,  1190,    -1,   160,   582,   417,
     617,   108,   210,  1066,   867,    -1,   500,   996,   501,    -1,
      -1,   898,   260,   266,  1028,   869,   872,    -1,   890,    -1,
     500,   870,   501,   890,    -1,   180,   454,    -1,   871,    -1,
     870,   503,   871,    -1,  1158,  1020,    -1,   373,  1025,  1191,
      -1,    -1,   898,   185,   227,   936,   874,   939,   872,    -1,
     448,   927,    -1,    -1,   291,   901,   935,   876,   878,    -1,
     247,   877,   297,    -1,    -1,    93,   397,    -1,   379,   397,
      -1,   379,   209,    -1,   397,   446,   209,    -1,   397,    -1,
     397,   379,   209,    -1,   209,    -1,    93,   209,    -1,   312,
      -1,    -1,   898,   446,   936,   395,   880,   926,   939,   872,
      -1,   881,    -1,   880,   503,   881,    -1,   882,    -1,   883,
      -1,   884,   487,  1022,    -1,   500,   885,   501,   487,  1024,
      -1,  1158,  1020,    -1,   884,    -1,   885,   503,   884,    -1,
     179,   887,   888,   171,   889,   222,   890,    -1,  1030,    -1,
    1171,    -1,    -1,   888,   306,   384,    -1,   888,   384,    -1,
     888,   121,    -1,   888,   259,    -1,    -1,   466,   239,    -1,
     467,   239,    -1,   892,    -1,   891,    -1,   500,   892,   501,
      -1,   500,   891,   501,    -1,   894,    -1,   893,   905,    -1,
     893,   904,   920,   909,    -1,   893,   904,   908,   921,    -1,
     895,   893,    -1,   895,   893,   905,    -1,   895,   893,   904,
     920,   909,    -1,   895,   893,   904,   908,   921,    -1,   894,
      -1,   891,    -1,   388,   903,  1025,   899,   926,   938,   918,
     919,   979,    -1,   925,    -1,   417,   934,    -1,   893,   440,
     902,   893,    -1,   893,   264,   902,   893,    -1,   893,   206,
     902,   893,    -1,   466,   896,    -1,   466,   360,   896,    -1,
     897,    -1,   896,   503,   897,    -1,  1030,   856,   108,   500,
     865,   501,    -1,   895,    -1,    -1,   266,   900,    -1,  1191,
      -1,    -1,   422,   901,  1028,    -1,   420,   901,  1028,    -1,
     287,   422,   901,  1028,    -1,   287,   420,   901,  1028,    -1,
     231,   422,   901,  1028,    -1,   231,   420,   901,  1028,    -1,
     444,   901,  1028,    -1,   417,  1028,    -1,  1028,    -1,   417,
      -1,    -1,    99,    -1,   192,    -1,    -1,   192,    -1,   192,
     322,   500,   996,   501,    -1,    99,    -1,    -1,   905,    -1,
      -1,   328,   125,   906,    -1,   907,    -1,   906,   503,   907,
      -1,   967,   448,   994,   768,    -1,   967,   767,   768,    -1,
     910,   911,    -1,   911,   910,    -1,   910,    -1,   911,    -1,
     908,    -1,    -1,   284,   912,    -1,   284,   912,   503,   913,
      -1,   218,   917,   914,   916,   323,    -1,   320,   913,    -1,
     320,   915,   916,    -1,   967,    -1,    99,    -1,   967,    -1,
    1040,    -1,   500,   967,   501,    -1,    -1,   969,    -1,   379,
      -1,   380,    -1,   219,    -1,   305,    -1,   235,   125,   996,
      -1,    -1,   237,   967,    -1,    -1,   922,    -1,   222,   356,
     323,    -1,   920,    -1,    -1,   923,    -1,   922,   923,    -1,
     222,   446,   924,   878,    -1,   222,   397,   924,   878,    -1,
     318,  1027,    -1,    -1,   454,  1024,    -1,   925,   503,  1024,
      -1,   227,   927,    -1,    -1,   928,    -1,   927,   503,   928,
      -1,   934,    -1,   934,   930,    -1,   937,    -1,   937,   930,
      -1,   937,   108,   500,   941,   501,    -1,   937,   108,  1158,
     500,   941,   501,    -1,   937,  1158,   500,   941,   501,    -1,
     891,    -1,   891,   930,    -1,   929,    -1,   500,   929,   501,
     930,    -1,   500,   929,   501,    -1,   928,   161,   271,   928,
      -1,   928,   931,   271,   928,   933,    -1,   928,   271,   928,
     933,    -1,   928,   303,   931,   271,   928,    -1,   928,   303,
     271,   928,    -1,   108,  1158,   500,  1029,   501,    -1,   108,
    1158,    -1,  1158,   500,  1029,   501,    -1,  1158,    -1,   228,
     932,    -1,   281,   932,    -1,   376,   932,    -1,   256,    -1,
     330,    -1,    -1,   448,   500,  1029,   501,    -1,   322,   967,
      -1,  1028,    -1,  1028,   493,    -1,   323,  1028,    -1,   323,
     500,  1028,   501,    -1,   934,    -1,   935,   503,   934,    -1,
     934,    -1,   934,  1158,    -1,   934,   108,  1158,    -1,   970,
      -1,   463,   967,    -1,    -1,   463,   967,    -1,   463,   163,
     318,   887,    -1,    -1,   941,    -1,    -1,   942,    -1,   941,
     503,   942,    -1,  1158,   943,   556,    -1,   945,   944,    -1,
     396,   945,   944,    -1,   945,   107,   498,  1038,   499,    -1,
     396,   945,   107,   498,  1038,   499,    -1,   945,   107,    -1,
     396,   945,   107,    -1,   944,   498,   499,    -1,   944,   498,
    1189,   499,    -1,    -1,   947,    -1,   949,    -1,   951,    -1,
     955,    -1,   962,    -1,   963,   965,    -1,   963,   500,  1038,
     501,   965,    -1,   949,    -1,   952,    -1,   956,    -1,   962,
      -1,  1159,   948,    -1,  1159,   724,   948,    -1,   500,   996,
     501,    -1,    -1,   262,    -1,   263,    -1,   401,    -1,   120,
      -1,   357,    -1,   220,   950,    -1,   196,   345,    -1,   178,
     948,    -1,   177,   948,    -1,   316,   948,    -1,   123,    -1,
     500,  1038,   501,    -1,    -1,   953,    -1,   954,    -1,   953,
      -1,   954,    -1,   122,   960,   500,   996,   501,    -1,   122,
     960,    -1,   957,    -1,   958,    -1,   957,    -1,   958,    -1,
     959,   500,  1038,   501,   961,    -1,   959,   961,    -1,   135,
     960,    -1,   134,   960,    -1,   455,    -1,   302,   135,   960,
      -1,   302,   134,   960,    -1,   304,   960,    -1,   457,    -1,
      -1,   135,   395,  1158,    -1,    -1,   426,   500,  1038,   501,
     964,    -1,   426,   964,    -1,   425,   500,  1038,   501,   964,
      -1,   425,   964,    -1,   265,    -1,   486,   483,    -1,   467,
     425,   483,    -1,    -1,   481,    -1,   298,    -1,   175,    -1,
     240,    -1,   295,    -1,   966,    -1,   481,   427,   298,    -1,
     175,   427,   240,    -1,   175,   427,   295,    -1,   175,   427,
     966,    -1,   240,   427,   295,    -1,   240,   427,   966,    -1,
     295,   427,   966,    -1,    -1,   386,    -1,   386,   500,  1038,
     501,    -1,   969,    -1,   967,    88,   943,    -1,   967,   143,
     723,    -1,   967,   113,   425,   483,   967,    -1,   491,   967,
      -1,   492,   967,    -1,   967,   491,   967,    -1,   967,   492,
     967,    -1,   967,   493,   967,    -1,   967,   494,   967,    -1,
     967,   495,   967,    -1,   967,   496,   967,    -1,   967,   488,
     967,    -1,   967,   489,   967,    -1,   967,   487,   967,    -1,
     967,   993,   967,    -1,   993,   967,    -1,   967,   993,    -1,
     967,   105,   967,    -1,   967,   327,   967,    -1,   308,   967,
      -1,   967,   283,   967,    -1,   967,   283,   967,   205,   967,
      -1,   967,   308,   283,   967,    -1,   967,   308,   283,   967,
     205,   967,    -1,   967,   243,   967,    -1,   967,   243,   967,
     205,   967,    -1,   967,   308,   243,   967,    -1,   967,   308,
     243,   967,   205,   967,    -1,   967,   399,   427,   967,    -1,
     967,   399,   427,   967,   205,   967,    -1,   967,   308,   399,
     427,   967,    -1,   967,   308,   399,   427,   967,   205,   967,
      -1,   967,   268,   313,    -1,   967,   269,    -1,   967,   268,
     308,   313,    -1,   967,   311,    -1,   989,   332,   989,    -1,
     967,   268,   433,    -1,   967,   268,   308,   433,    -1,   967,
     268,   216,    -1,   967,   268,   308,   216,    -1,   967,   268,
     442,    -1,   967,   268,   308,   442,    -1,   967,   268,   192,
     227,   967,    -1,   967,   268,   308,   192,   227,   967,    -1,
     967,   268,   318,   500,   999,   501,    -1,   967,   268,   308,
     318,   500,   999,   501,    -1,   967,   119,  1021,   968,   105,
     968,    -1,   967,   308,   119,  1021,   968,   105,   968,    -1,
     967,   119,   414,   968,   105,   968,    -1,   967,   308,   119,
     414,   968,   105,   968,    -1,   967,   247,  1011,    -1,   967,
     308,   247,  1011,    -1,   967,   995,   990,   891,    -1,   967,
     995,   990,   500,   967,   501,    -1,   441,   891,    -1,   967,
     268,   194,    -1,   967,   268,   308,   194,    -1,   969,    -1,
     968,    88,   943,    -1,   491,   968,    -1,   492,   968,    -1,
     968,   491,   968,    -1,   968,   492,   968,    -1,   968,   493,
     968,    -1,   968,   494,   968,    -1,   968,   495,   968,    -1,
     968,   496,   968,    -1,   968,   488,   968,    -1,   968,   489,
     968,    -1,   968,   487,   968,    -1,   968,   993,   968,    -1,
     993,   968,    -1,   968,   993,    -1,   968,   268,   192,   227,
     968,    -1,   968,   268,   308,   192,   227,   968,    -1,   968,
     268,   318,   500,   999,   501,    -1,   968,   268,   308,   318,
     500,   999,   501,    -1,   968,   268,   194,    -1,   968,   268,
     308,   194,    -1,  1017,    -1,  1037,    -1,  1175,  1020,    -1,
     500,   967,   501,  1020,    -1,  1012,    -1,   970,    -1,   891,
      -1,   211,   891,    -1,   107,   891,    -1,   107,  1000,    -1,
     989,    -1,  1036,   500,   501,   982,    -1,  1036,   500,   997,
     501,   982,    -1,  1036,   500,   456,   998,   501,   982,    -1,
    1036,   500,   997,   503,   456,   998,   501,   982,    -1,  1036,
     500,   997,   905,   501,   982,    -1,  1036,   500,    99,   997,
     904,   501,   982,    -1,  1036,   500,   192,   997,   904,   501,
     982,    -1,  1036,   500,   493,   501,   982,    -1,   165,    -1,
     168,    -1,   168,   500,  1038,   501,    -1,   169,    -1,   169,
     500,  1038,   501,    -1,   288,    -1,   288,   500,  1038,   501,
      -1,   289,    -1,   289,   500,  1038,   501,    -1,   166,    -1,
     170,    -1,   394,    -1,   447,    -1,   164,    -1,   167,    -1,
     131,   500,   967,   108,   943,   501,    -1,   215,   500,  1002,
     501,    -1,   333,   500,  1004,   501,    -1,   343,   500,  1006,
     501,    -1,   413,   500,  1007,   501,    -1,   430,   500,   967,
     108,   943,   501,    -1,   432,   500,   124,  1010,   501,    -1,
     432,   500,   279,  1010,   501,    -1,   432,   500,   428,  1010,
     501,    -1,   432,   500,  1010,   501,    -1,   314,   500,   967,
     503,   967,   501,    -1,   142,   500,   996,   501,    -1,   234,
     500,   996,   501,    -1,   280,   500,   996,   501,    -1,   473,
     500,   996,   501,    -1,   474,   500,   300,  1160,   501,    -1,
     474,   500,   300,  1160,   503,   973,   501,    -1,   474,   500,
     300,  1160,   503,   996,   501,    -1,   474,   500,   300,  1160,
     503,   973,   503,   996,   501,    -1,   475,   500,   969,   978,
     501,    -1,   476,   500,   974,   501,    -1,   477,   500,   976,
     967,   977,   501,    -1,   478,   500,   300,  1160,   501,    -1,
     478,   500,   300,  1160,   503,   967,   501,    -1,   479,   500,
     967,   503,   971,   972,   501,    -1,   480,   500,   976,   967,
     108,   945,   501,    -1,   459,   967,    -1,   459,   306,   453,
      -1,   503,   404,   482,    -1,   503,   404,   306,    -1,   503,
     404,   306,   453,    -1,    -1,   472,   500,   974,   501,    -1,
     975,    -1,   974,   503,   975,    -1,   967,   108,  1160,    -1,
     967,    -1,   194,    -1,   155,    -1,   346,   464,    -1,   412,
     464,    -1,    -1,   339,   969,    -1,   339,   969,   125,   361,
      -1,   339,   125,   361,   969,    -1,   339,   125,   361,   969,
     125,   361,    -1,   465,   980,    -1,    -1,   981,    -1,   980,
     503,   981,    -1,  1158,   108,   983,    -1,   331,   983,    -1,
     331,  1158,    -1,    -1,   500,   984,   985,   904,   986,   501,
      -1,  1158,    -1,    -1,   338,   125,   996,    -1,    -1,   355,
     987,    -1,   380,   987,    -1,    -1,   988,    -1,   119,   988,
     105,   988,    -1,   437,   344,    -1,   437,   221,    -1,   163,
     379,    -1,   967,   344,    -1,   967,   221,    -1,   379,   500,
     996,   501,    -1,   379,   500,   501,    -1,   500,   996,   503,
     967,   501,    -1,   106,    -1,   402,    -1,    99,    -1,    85,
      -1,   992,    -1,   491,    -1,   492,    -1,   493,    -1,   494,
      -1,   495,    -1,   496,    -1,   488,    -1,   489,    -1,   487,
      -1,    85,    -1,   324,   500,   795,   501,    -1,   991,    -1,
     324,   500,   795,   501,    -1,   991,    -1,   324,   500,   795,
     501,    -1,   283,    -1,   308,   283,    -1,   243,    -1,   308,
     243,    -1,   967,    -1,   996,   503,   967,    -1,   998,    -1,
     997,   503,   998,    -1,   967,    -1,   777,    90,   967,    -1,
     943,    -1,   999,   503,   943,    -1,   498,   996,   499,    -1,
     498,  1001,   499,    -1,   498,   499,    -1,  1000,    -1,  1001,
     503,  1000,    -1,  1003,   227,   967,    -1,    -1,  1180,    -1,
     481,    -1,   298,    -1,   175,    -1,   240,    -1,   295,    -1,
     386,    -1,  1178,    -1,   967,  1005,  1008,  1009,    -1,   967,
    1005,  1008,    -1,   341,   967,    -1,   968,   247,   968,    -1,
      -1,   967,  1008,  1009,    -1,   967,  1009,  1008,    -1,   967,
    1008,    -1,   967,  1009,    -1,   996,    -1,    -1,   227,   967,
      -1,   222,   967,    -1,   967,   227,   996,    -1,   227,   996,
      -1,   996,    -1,   891,    -1,   500,   996,   501,    -1,   130,
    1016,  1013,  1015,   203,    -1,  1014,    -1,  1013,  1014,    -1,
     462,   967,   424,   967,    -1,   199,   967,    -1,    -1,   967,
      -1,    -1,  1158,    -1,  1158,  1019,    -1,   502,  1033,    -1,
     502,   493,    -1,   498,   967,   499,    -1,   498,   967,   505,
     967,   499,    -1,  1018,    -1,  1019,  1018,    -1,    -1,  1020,
    1018,    -1,   112,    -1,    -1,   967,    -1,   180,    -1,  1022,
      -1,  1023,   503,  1022,    -1,   500,  1023,   501,    -1,  1026,
      -1,  1025,   503,  1026,    -1,   967,   108,  1160,    -1,   967,
    1180,    -1,   967,    -1,   493,    -1,  1028,    -1,  1027,   503,
    1028,    -1,  1158,    -1,  1158,  1019,    -1,  1030,    -1,  1029,
     503,  1030,    -1,  1158,    -1,  1158,    -1,  1158,    -1,  1160,
      -1,  1158,    -1,  1178,    -1,  1159,    -1,  1158,  1019,    -1,
    1038,    -1,  1177,    -1,  1178,    -1,  1176,    -1,    84,    -1,
    1036,  1178,    -1,  1036,   500,   997,   501,  1178,    -1,   946,
    1178,    -1,   963,  1178,   965,    -1,   963,   500,  1038,   501,
    1178,   965,    -1,   433,    -1,   216,    -1,   313,    -1,  1172,
      -1,  1170,    -1,    86,    -1,  1158,    -1,  1038,    -1,  1172,
      -1,   491,  1038,    -1,   492,  1038,    -1,    91,    -1,    92,
      -1,    93,    -1,    94,    -1,    95,    -1,    96,    -1,    97,
      -1,    98,    -1,   100,    -1,   101,    -1,   102,    -1,   110,
      -1,   111,    -1,   113,    -1,   114,    -1,   116,    -1,   117,
      -1,   118,    -1,   125,    -1,   126,    -1,   127,    -1,   128,
      -1,   129,    -1,   132,    -1,   133,    -1,   136,    -1,   138,
      -1,   139,    -1,   140,    -1,   141,    -1,   144,    -1,   146,
      -1,   147,    -1,   148,    -1,   149,    -1,   151,    -1,   154,
      -1,   155,    -1,   156,    -1,   157,    -1,   158,    -1,   159,
      -1,   162,    -1,   171,    -1,   172,    -1,   173,    -1,   174,
      -1,   176,    -1,   179,    -1,   181,    -1,   183,    -1,   184,
      -1,   185,    -1,   186,    -1,   187,    -1,   189,    -1,   190,
      -1,   191,    -1,   194,    -1,   195,    -1,   196,    -1,   197,
      -1,   198,    -1,   200,    -1,   201,    -1,   202,    -1,   204,
      -1,   205,    -1,   207,    -1,   208,    -1,   209,    -1,   210,
      -1,   212,    -1,   213,    -1,   214,    -1,   217,    -1,   219,
      -1,   221,    -1,   223,    -1,   225,    -1,   229,    -1,   230,
      -1,   231,    -1,   233,    -1,   236,    -1,   238,    -1,   239,
      -1,   241,    -1,   242,    -1,   244,    -1,   245,    -1,   246,
      -1,   248,    -1,   249,    -1,   250,    -1,   251,    -1,   252,
      -1,   253,    -1,   255,    -1,   259,    -1,   260,    -1,   261,
      -1,   267,    -1,   270,    -1,   272,    -1,   273,    -1,   274,
      -1,   275,    -1,   276,    -1,   277,    -1,   278,    -1,   282,
      -1,   285,    -1,   286,    -1,   287,    -1,   290,    -1,   291,
      -1,   292,    -1,   293,    -1,   294,    -1,   296,    -1,   297,
      -1,   299,    -1,   300,    -1,   301,    -1,   305,    -1,   306,
      -1,   309,    -1,   310,    -1,   312,    -1,   315,    -1,   317,
      -1,   318,    -1,   319,    -1,   321,    -1,   324,    -1,   325,
      -1,   326,    -1,   334,    -1,   335,    -1,   336,    -1,   337,
      -1,   338,    -1,   339,    -1,   340,    -1,   342,    -1,   344,
      -1,   347,    -1,   348,    -1,   346,    -1,   350,    -1,   351,
      -1,   352,    -1,   353,    -1,   354,    -1,   355,    -1,   356,
      -1,   358,    -1,   359,    -1,   360,    -1,   361,    -1,   363,
      -1,   364,    -1,   365,    -1,   366,    -1,   367,    -1,   368,
      -1,   369,    -1,   370,    -1,   371,    -1,   372,    -1,   374,
      -1,   375,    -1,   377,    -1,   378,    -1,   380,    -1,   381,
      -1,   382,    -1,   383,    -1,   384,    -1,   385,    -1,   387,
      -1,   389,    -1,   390,    -1,   391,    -1,   392,    -1,   393,
      -1,   395,    -1,   397,    -1,   398,    -1,   400,    -1,   403,
      -1,   404,    -1,   405,    -1,   406,    -1,   407,    -1,   408,
      -1,   409,    -1,   410,    -1,   411,    -1,   412,    -1,   415,
      -1,   416,    -1,   418,    -1,   419,    -1,   420,    -1,   421,
      -1,   422,    -1,   423,    -1,   429,    -1,   431,    -1,   434,
      -1,   435,    -1,   436,    -1,   437,    -1,   438,    -1,   439,
      -1,   442,    -1,   443,    -1,   444,    -1,   445,    -1,   446,
      -1,   449,    -1,   450,    -1,   451,    -1,   452,    -1,   453,
      -1,   457,    -1,   459,    -1,   460,    -1,   461,    -1,   464,
      -1,   467,    -1,   468,    -1,   469,    -1,   470,    -1,   471,
      -1,   482,    -1,   483,    -1,   119,    -1,   120,    -1,   122,
      -1,   123,    -1,   135,    -1,   142,    -1,   177,    -1,   178,
      -1,   211,    -1,   215,    -1,   220,    -1,   234,    -1,   257,
      -1,   263,    -1,   265,    -1,   280,    -1,   302,    -1,   304,
      -1,   307,    -1,   314,    -1,   316,    -1,   329,    -1,   333,
      -1,   343,    -1,   345,    -1,   357,    -1,   379,    -1,   396,
      -1,   401,    -1,   413,    -1,   425,    -1,   426,    -1,   430,
      -1,   432,    -1,   455,    -1,   472,    -1,   473,    -1,   474,
      -1,   475,    -1,   476,    -1,   477,    -1,   478,    -1,   479,
      -1,   480,    -1,   115,    -1,   121,    -1,   150,    -1,   161,
      -1,   167,    -1,   226,    -1,   228,    -1,   243,    -1,   256,
      -1,   268,    -1,   269,    -1,   271,    -1,   281,    -1,   283,
      -1,   303,    -1,   311,    -1,   330,    -1,   331,    -1,   332,
      -1,   376,    -1,   399,    -1,   458,    -1,    99,    -1,   103,
      -1,   104,    -1,   105,    -1,   106,    -1,   107,    -1,   108,
      -1,   109,    -1,   112,    -1,   124,    -1,   130,    -1,   131,
      -1,   137,    -1,   143,    -1,   145,    -1,   153,    -1,   160,
      -1,   164,    -1,   165,    -1,   166,    -1,   168,    -1,   169,
      -1,   170,    -1,   180,    -1,   182,    -1,   188,    -1,   192,
      -1,   193,    -1,   199,    -1,   203,    -1,   206,    -1,   216,
      -1,   218,    -1,   222,    -1,   224,    -1,   227,    -1,   232,
      -1,   235,    -1,   237,    -1,   247,    -1,   254,    -1,   264,
      -1,   266,    -1,   279,    -1,   284,    -1,   288,    -1,   289,
      -1,   308,    -1,   313,    -1,   320,    -1,   322,    -1,   323,
      -1,   327,    -1,   328,    -1,   341,    -1,   349,    -1,   362,
      -1,   373,    -1,   388,    -1,   394,    -1,   402,    -1,   414,
      -1,   417,    -1,   424,    -1,   428,    -1,   433,    -1,   441,
      -1,   447,    -1,   448,    -1,   456,    -1,   462,    -1,   463,
      -1,   465,    -1,   466,    -1,    -1,  1045,  1046,    -1,  1167,
    1049,   510,   504,    -1,  1167,   510,   504,    -1,  1167,  1069,
      -1,  1074,    -1,  1186,    -1,    73,    -1,   506,    -1,   507,
      -1,    -1,   160,   582,   417,   617,   108,  1048,   890,   621,
      -1,   113,  1110,    -1,     9,   427,  1051,  1058,  1059,    -1,
       9,   427,   180,    -1,     9,  1060,    -1,   174,  1051,    -1,
    1052,  1055,  1057,    -1,  1053,   505,  1054,  1057,   494,  1052,
    1063,    -1,  1062,    -1,  1178,    -1,  1031,    -1,    -1,  1180,
    1174,    -1,    85,  1056,    -1,  1054,    -1,    -1,  1158,    -1,
    1158,   502,  1056,    -1,    74,    -1,   505,  1038,    -1,    -1,
     108,  1110,    -1,    -1,   447,  1060,    -1,    -1,  1061,    -1,
    1061,   494,  1061,    -1,  1061,    21,   125,  1061,    -1,  1061,
     448,  1061,    -1,  1039,    -1,  1178,    -1,  1172,    -1,  1174,
      -1,    85,  1064,    -1,    -1,  1158,  1065,    -1,  1158,  1065,
      85,  1064,    -1,    -1,   487,  1038,    -1,   487,  1180,    -1,
     487,  1172,    -1,  1030,    -1,  1062,    -1,   179,   887,   888,
     171,   889,   222,  1066,    -1,   210,   244,  1111,    -1,  1070,
      -1,  1081,    -1,  1083,    -1,   628,    -1,   503,   628,    -1,
      -1,   965,    -1,   481,   427,   295,    -1,   481,   427,   386,
      -1,   175,   427,   175,    -1,   298,   427,   298,    -1,    -1,
    1076,  1075,  1078,  1077,    -1,  1167,   118,   179,    34,   504,
      -1,  1167,   203,   179,    34,   504,    -1,    -1,  1079,    -1,
    1070,    -1,    73,    -1,  1079,  1070,    -1,  1079,    73,    -1,
    1083,    -1,  1080,  1083,    -1,    -1,    70,  1082,  1090,  1106,
    1162,   944,   504,    -1,    -1,  1087,  1090,  1084,  1103,   504,
      -1,    -1,  1090,  1085,  1103,   504,    -1,  1093,   504,    -1,
     505,  1038,    -1,    -1,  1088,  1089,    -1,  1088,    -1,  1089,
      -1,    56,    -1,    67,    -1,    65,    -1,    50,    -1,    51,
      -1,    69,    -1,  1099,    -1,  1095,    -1,  1091,    -1,  1162,
     500,  1071,  1072,   501,    -1,  1162,  1073,    -1,  1097,    -1,
     204,  1156,  1092,    -1,   204,  1092,    -1,   204,  1156,    -1,
     506,  1184,   507,    -1,    -1,  1097,  1094,   506,  1080,   507,
      -1,  1093,    -1,    -1,  1098,  1096,   506,  1080,   507,    -1,
      43,  1156,    -1,   440,  1156,    -1,    43,    -1,   440,    -1,
    1100,    -1,  1102,  1101,    -1,    44,    35,    -1,    44,    35,
     262,    -1,    44,    -1,    44,   262,    -1,    44,    25,    -1,
      44,    25,   262,    -1,    44,    25,    25,    -1,    44,    25,
      25,   262,    -1,    44,   134,    -1,    35,    -1,    35,   262,
      -1,   262,    -1,    25,    -1,    25,   262,    -1,    25,    25,
      -1,    25,    25,   262,    -1,     5,    -1,   134,    -1,   196,
      -1,    36,    -1,    -1,  1104,    -1,  1103,   503,  1104,    -1,
    1106,  1161,   944,  1086,  1105,    -1,    -1,   487,  1185,    -1,
      -1,   493,    -1,   493,   493,    -1,   179,   406,  1180,    -1,
      15,  1109,    -1,  1110,    -1,   163,    -1,    99,    -1,    -1,
    1031,    -1,   180,    -1,  1062,    -1,  1062,    -1,    71,    -1,
      17,   887,    -1,    17,    99,    -1,    28,   887,  1114,    -1,
      -1,  1115,    -1,   448,  1119,    -1,  1116,    -1,   448,    37,
      14,  1181,    -1,   448,    14,  1030,    -1,   266,    37,    14,
    1181,    -1,   266,    14,  1030,    -1,   266,  1030,    -1,  1120,
      -1,  1120,   503,  1119,    -1,  1121,    -1,  1172,    -1,  1170,
      -1,  1038,    -1,   491,  1038,    -1,   492,  1038,    -1,  1177,
      -1,   491,  1177,    -1,   492,  1177,    -1,  1178,    -1,  1176,
      -1,  1179,    -1,    13,   258,  1066,  1116,    -1,    13,  1123,
    1066,  1116,    -1,    13,  1123,  1066,  1117,    -1,    13,   258,
    1066,  1118,    -1,    13,  1123,  1066,  1118,    -1,    29,    -1,
      -1,     3,    14,  1181,    -1,   176,    14,  1181,    -1,    18,
      14,  1181,  1127,    -1,  1128,    -1,  1127,   503,  1128,    -1,
    1174,   487,  1133,    -1,   395,    14,  1181,  1130,    -1,  1131,
      -1,  1130,   503,  1131,    -1,  1133,   487,  1132,    -1,  1038,
      -1,  1174,    -1,    10,    -1,    18,    14,  1181,   453,  1132,
    1135,    -1,  1136,    -1,  1135,   503,  1136,    -1,  1174,   487,
    1141,    -1,   395,    14,  1181,   453,  1132,  1138,    -1,  1139,
      -1,  1138,   503,  1139,    -1,  1141,   487,  1140,    -1,  1177,
      -1,  1132,    -1,   492,  1177,    -1,   492,  1038,    -1,  1178,
      -1,     8,    -1,   173,    -1,    11,    -1,    12,    -1,    22,
      -1,    23,    -1,    24,    -1,   300,    -1,    26,    -1,    27,
      -1,   345,    -1,    31,    -1,    32,    -1,    33,    -1,   436,
      -1,   395,     4,   487,  1143,    -1,   395,     4,   427,  1143,
      -1,   322,    -1,   319,    -1,   395,   152,   427,  1110,    -1,
     395,   152,   487,  1110,    -1,   395,   152,  1110,    -1,    -1,
     436,  1146,  1162,   268,  1090,   944,  1147,    -1,    30,    -1,
      -1,    -1,    45,  1149,  1160,   268,  1090,   944,  1147,    -1,
      46,    38,  1151,    -1,    46,   308,    16,  1151,    -1,    46,
      40,  1151,    -1,   156,    -1,    39,    -1,    42,    -1,    20,
    1030,    -1,    19,   427,  1030,    -1,   193,  1030,   500,  1168,
     501,    -1,   193,     6,    -1,     7,  1030,   500,  1168,   501,
      -1,     7,  1030,    -1,  1153,    -1,  1154,    -1,     6,    -1,
       7,    -1,     8,    -1,    10,    -1,    11,    -1,    12,    -1,
      16,    -1,    19,    -1,    20,    -1,    21,    -1,    22,    -1,
      23,    -1,    24,    -1,    26,    -1,    27,    -1,    31,    -1,
      32,    -1,    33,    -1,    34,    -1,    37,    -1,    38,    -1,
      39,    -1,    40,    -1,    42,    -1,     9,    -1,    13,    -1,
      15,    -1,    28,    -1,    45,    -1,    46,    -1,     5,    -1,
      25,    -1,    29,    -1,    35,    -1,    43,    -1,    36,    -1,
      44,    -1,  1160,    -1,  1180,    -1,  1041,    -1,  1042,    -1,
    1165,    -1,  1152,    -1,  1163,    -1,   134,    -1,   454,    -1,
    1180,    -1,  1164,    -1,  1042,    -1,  1152,    -1,  1163,    -1,
     134,    -1,   454,    -1,  1180,    -1,  1164,    -1,  1043,    -1,
    1152,    -1,  1163,    -1,  1155,    -1,  1161,    -1,  1155,    -1,
     134,    -1,   163,    -1,   258,    -1,   262,    -1,   427,    -1,
     440,    -1,   454,    -1,  1163,    -1,  1165,    -1,  1162,    -1,
    1041,    -1,  1044,    -1,  1154,    -1,   152,    -1,  1180,    -1,
    1042,    -1,  1043,    -1,  1153,    -1,    50,    -1,    51,    -1,
      56,    -1,    65,    -1,    67,    -1,    70,    -1,    69,    -1,
    1041,    -1,  1165,    -1,   152,    -1,   175,    -1,   240,    -1,
     295,    -1,   298,    -1,   386,    -1,   481,    -1,  1169,    -1,
    1166,   503,  1169,    -1,    41,    -1,    -1,  1184,    -1,  1174,
    1173,    -1,  1174,    -1,  1174,  1173,    -1,  1062,    -1,  1174,
      -1,  1174,    -1,    22,  1174,    -1,    22,  1030,    -1,    72,
      -1,    87,    -1,    83,    -1,    81,    -1,    82,    -1,    76,
      -1,    77,    -1,    78,    -1,    75,    -1,    84,    -1,    80,
      -1,    71,    -1,    79,    -1,  1030,    -1,  1062,    -1,  1187,
      -1,   500,   501,    -1,   500,  1183,   501,    -1,  1182,    -1,
    1183,  1182,    -1,  1185,    -1,  1184,   503,  1185,    -1,  1183,
      -1,   506,  1184,   507,    -1,  1187,    -1,   500,    -1,   501,
      -1,   503,    -1,   504,    -1,  1180,    -1,  1038,    -1,  1177,
      -1,  1178,    -1,   493,    -1,   491,    -1,   492,    -1,   494,
      -1,   495,    -1,   313,    -1,    47,    -1,    48,    -1,    49,
      -1,    50,    -1,    51,    -1,    52,    -1,    53,    -1,    54,
      -1,    55,    -1,    56,    -1,    57,    -1,    58,    -1,    60,
      -1,    59,    -1,    61,    -1,    62,    -1,    63,    -1,    64,
      -1,    65,    -1,    66,    -1,    67,    -1,    68,    -1,    70,
      -1,    69,    -1,     5,    -1,   204,    -1,   240,    -1,   262,
      -1,    25,    -1,   295,    -1,   298,    -1,   386,    -1,    35,
      -1,    36,    -1,    43,    -1,    44,    -1,   481,    -1,   134,
      -1,   220,    -1,   427,    -1,   440,    -1,   455,    -1,   498,
      -1,   499,    -1,   487,    -1,   505,    -1,   176,  1066,    -1,
     176,   347,  1066,    -1,   176,    99,    -1,   176,   347,    99,
      -1,  1038,    -1,   500,  1189,   501,    -1,  1189,   491,  1189,
      -1,  1189,   492,  1189,    -1,  1189,   493,  1189,    -1,  1189,
     494,  1189,    -1,  1189,   495,  1189,    -1,  1178,    -1,  1158,
      -1,    -1,  1115,  1191,    -1,  1191,  1115,    -1,  1115,    -1,
    1191,    -1,   266,  1166,    -1,  1117,    -1,  1191,    -1,  1116,
      -1,    -1,  1192,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1363,  1363,  1366,  1368,  1370,  1372,  1374,  1376,  1378,
    1380,  1382,  1384,  1386,  1388,  1390,  1392,  1394,  1396,  1398,
    1400,  1402,  1404,  1406,  1408,  1410,  1412,  1414,  1416,  1418,
    1436,  1438,  1440,  1442,  1444,  1446,  1448,  1450,  1452,  1454,
    1456,  1458,  1460,  1462,  1464,  1466,  1468,  1470,  1472,  1474,
    1476,  1478,  1480,  1482,  1484,  1486,  1488,  1490,  1492,  1499,
    1501,  1503,  1505,  1507,  1509,  1511,  1513,  1515,  1517,  1519,
    1521,  1523,  1525,  1527,  1529,  1531,  1533,  1535,  1537,  1539,
    1541,  1543,  1545,  1547,  1549,  1551,  1553,  1555,  1557,  1559,
    1561,  1563,  1565,  1572,  1574,  1576,  1578,  1580,  1582,  1584,
    1586,  1588,  1590,  1592,  1594,  1600,  1602,  1604,  1606,  1608,
    1610,  1612,  1614,  1616,  1622,  1632,  1636,  1644,  1648,  1658,
    1668,  1669,  1683,  1690,  1696,  1707,  1713,  1722,  1729,  1735,
    1744,  1751,  1759,  1764,  1772,  1777,  1783,  1788,  1794,  1799,
    1805,  1809,  1813,  1817,  1821,  1825,  1829,  1833,  1837,  1845,
    1849,  1853,  1857,  1861,  1865,  1873,  1881,  1890,  1892,  1900,
    1908,  1916,  1924,  1928,  1936,  1940,  1948,  1956,  1964,  1968,
    1976,  1980,  1988,  1992,  2000,  2005,  2011,  2016,  2022,  2026,
    2030,  2034,  2038,  2042,  2050,  2054,  2058,  2066,  2070,  2074,
    2078,  2082,  2086,  2090,  2094,  2098,  2103,  2107,  2111,  2115,
    2119,  2123,  2131,  2135,  2143,  2147,  2155,  2159,  2173,  2177,
    2181,  2185,  2193,  2197,  2201,  2205,  2213,  2217,  2221,  2225,
    2229,  2233,  2237,  2245,  2249,  2254,  2260,  2264,  2272,  2276,
    2280,  2284,  2288,  2296,  2300,  2308,  2312,  2316,  2320,  2324,
    2333,  2341,  2345,  2353,  2357,  2365,  2373,  2377,  2381,  2385,
    2393,  2397,  2401,  2405,  2413,  2417,  2425,  2429,  2433,  2437,
    2441,  2445,  2449,  2453,  2457,  2461,  2465,  2469,  2473,  2477,
    2481,  2485,  2489,  2493,  2497,  2501,  2505,  2509,  2513,  2517,
    2521,  2525,  2529,  2533,  2537,  2541,  2545,  2549,  2553,  2557,
    2561,  2565,  2569,  2573,  2577,  2581,  2585,  2593,  2597,  2605,
    2609,  2614,  2620,  2625,  2631,  2636,  2642,  2650,  2655,  2661,
    2665,  2673,  2677,  2681,  2685,  2693,  2701,  2705,  2713,  2717,
    2721,  2725,  2733,  2738,  2746,  2757,  2768,  2772,  2780,  2784,
    2788,  2796,  2800,  2808,  2813,  2819,  2823,  2827,  2831,  2835,
    2839,  2843,  2847,  2851,  2855,  2859,  2863,  2871,  2876,  2882,
    2887,  2893,  2898,  2904,  2909,  2915,  2919,  2927,  2935,  2939,
    2943,  2947,  2952,  2958,  2962,  2970,  2978,  2982,  2986,  2990,
    2998,  3002,  3006,  3010,  3014,  3018,  3022,  3027,  3033,  3038,
    3044,  3049,  3055,  3059,  3067,  3071,  3079,  3083,  3087,  3095,
    3099,  3107,  3115,  3123,  3128,  3134,  3138,  3142,  3146,  3154,
    3158,  3162,  3166,  3170,  3174,  3178,  3186,  3190,  3194,  3198,
    3206,  3214,  3218,  3223,  3229,  3233,  3237,  3241,  3245,  3249,
    3257,  3261,  3269,  3273,  3277,  3281,  3285,  3289,  3293,  3301,
    3306,  3312,  3316,  3324,  3332,  3336,  3341,  3346,  3352,  3356,
    3364,  3368,  3376,  3381,  3387,  3391,  3395,  3399,  3404,  3410,
    3418,  3426,  3430,  3434,  3438,  3442,  3450,  3455,  3461,  3465,
    3469,  3474,  3480,  3484,  3488,  3493,  3499,  3504,  3510,  3515,
    3521,  3529,  3537,  3542,  3548,  3552,  3560,  3568,  3572,  3577,
    3583,  3591,  3599,  3604,  3610,  3614,  3622,  3626,  3630,  3634,
    3638,  3642,  3646,  3650,  3654,  3658,  3662,  3666,  3674,  3679,
    3685,  3689,  3693,  3701,  3705,  3713,  3717,  3725,  3730,  3736,
    3740,  3748,  3753,  3759,  3763,  3771,  3776,  3782,  3786,  3794,
    3799,  3805,  3813,  3818,  3824,  3828,  3836,  3840,  3848,  3853,
    3859,  3863,  3867,  3875,  3883,  3888,  3894,  3902,  3906,  3910,
    3914,  3918,  3922,  3926,  3930,  3934,  3938,  3942,  3946,  3950,
    3954,  3958,  3962,  3966,  3970,  3974,  3978,  3982,  3986,  3994,
    4002,  4006,  4010,  4014,  4022,  4026,  4034,  4039,  4045,  4049,
    4057,  4061,  4069,  4074,  4080,  4084,  4092,  4100,  4104,  4112,
    4116,  4120,  4124,  4132,  4140,  4148,  4156,  4164,  4169,  4175,
    4179,  4187,  4192,  4198,  4202,  4210,  4214,  4218,  4226,  4230,
    4238,  4242,  4250,  4254,  4262,  4270,  4278,  4286,  4290,  4294,
    4302,  4306,  4314,  4322,  4326,  4334,  4338,  4342,  4350,  4354,
    4362,  4366,  4370,  4374,  4378,  4386,  4391,  4397,  4402,  4408,
    4412,  4420,  4425,  4431,  4435,  4440,  4446,  4450,  4454,  4458,
    4466,  4471,  4478,  4480,  4488,  4492,  4496,  4500,  4504,  4512,
    4516,  4524,  4533,  4542,  4546,  4550,  4554,  4558,  4562,  4566,
    4570,  4574,  4578,  4582,  4586,  4590,  4598,  4606,  4610,  4618,
    4622,  4630,  4634,  4638,  4642,  4646,  4654,  4658,  4666,  4674,
    4678,  4686,  4694,  4699,  4705,  4709,  4717,  4721,  4725,  4733,
    4741,  4745,  4753,  4757,  4761,  4765,  4769,  4777,  4782,  4788,
    4793,  4799,  4803,  4808,  4814,  4820,  4826,  4834,  4838,  4846,
    4850,  4858,  4862,  4870,  4874,  4882,  4886,  4894,  4902,  4910,
    4914,  4922,  4926,  4930,  4934,  4938,  4942,  4946,  4950,  4954,
    4958,  4962,  4966,  4970,  4974,  4978,  4986,  4990,  4998,  5002,
    5010,  5014,  5022,  5030,  5034,  5039,  5045,  5049,  5053,  5057,
    5061,  5065,  5069,  5073,  5077,  5081,  5085,  5089,  5093,  5097,
    5101,  5105,  5109,  5117,  5121,  5125,  5129,  5133,  5137,  5141,
    5145,  5149,  5153,  5157,  5161,  5165,  5169,  5173,  5177,  5181,
    5189,  5193,  5201,  5205,  5209,  5213,  5217,  5225,  5230,  5236,
    5240,  5244,  5248,  5252,  5256,  5260,  5264,  5272,  5276,  5284,
    5288,  5292,  5296,  5302,  5308,  5314,  5320,  5326,  5332,  5338,
    5348,  5359,  5370,  5381,  5392,  5403,  5414,  5430,  5446,  5462,
    5473,  5489,  5500,  5516,  5531,  5535,  5543,  5548,  5554,  5562,
    5566,  5574,  5578,  5582,  5586,  5590,  5598,  5602,  5610,  5614,
    5618,  5622,  5630,  5634,  5638,  5642,  5646,  5650,  5654,  5658,
    5662,  5666,  5670,  5674,  5678,  5682,  5690,  5694,  5702,  5706,
    5714,  5719,  5725,  5729,  5737,  5745,  5753,  5757,  5765,  5770,
    5776,  5781,  5787,  5795,  5800,  5806,  5810,  5814,  5822,  5826,
    5830,  5838,  5842,  5846,  5854,  5862,  5867,  5873,  5878,  5884,
    5889,  5895,  5900,  5906,  5910,  5918,  5922,  5926,  5934,  5939,
    5945,  5949,  5954,  5960,  5964,  5969,  5975,  5979,  5984,  5990,
    5994,  5998,  6006,  6011,  6017,  6021,  6029,  6033,  6041,  6045,
    6053,  6057,  6065,  6069,  6073,  6077,  6081,  6089,  6093,  6097,
    6101,  6105,  6113,  6121,  6129,  6133,  6137,  6145,  6149,  6153,
    6161,  6165,  6173,  6177,  6181,  6185,  6189,  6193,  6197,  6201,
    6205,  6209,  6213,  6217,  6221,  6229,  6233,  6237,  6241,  6249,
    6253,  6261,  6266,  6272,  6280,  6284,  6292,  6300,  6304,  6312,
    6317,  6323,  6327,  6335,  6339,  6347,  6351,  6359,  6363,  6367,
    6371,  6379,  6383,  6391,  6399,  6403,  6411,  6415,  6423,  6427,
    6431,  6439,  6443,  6448,  6454,  6462,  6467,  6473,  6477,  6481,
    6489,  6493,  6501,  6506,  6512,  6516,  6520,  6524,  6528,  6532,
    6536,  6540,  6544,  6548,  6552,  6556,  6560,  6564,  6568,  6572,
    6576,  6580,  6584,  6588,  6592,  6596,  6600,  6604,  6608,  6612,
    6616,  6620,  6624,  6632,  6637,  6643,  6648,  6654,  6658,  6662,
    6666,  6670,  6674,  6678,  6682,  6686,  6690,  6694,  6698,  6702,
    6706,  6710,  6714,  6718,  6722,  6730,  6734,  6738,  6742,  6746,
    6750,  6754,  6758,  6762,  6766,  6770,  6774,  6778,  6782,  6786,
    6790,  6794,  6798,  6806,  6814,  6818,  6822,  6830,  6834,  6842,
    6846,  6850,  6854,  6858,  6866,  6871,  6877,  6881,  6885,  6889,
    6897,  6901,  6906,  6912,  6916,  6924,  6932,  6937,  6943,  6951,
    6955,  6963,  6967,  6971,  6975,  6979,  6983,  6987,  6991,  6995,
    6999,  7003,  7007,  7011,  7015,  7023,  7027,  7032,  7038,  7042,
    7046,  7050,  7054,  7062,  7066,  7070,  7078,  7083,  7089,  7093,
    7101,  7106,  7111,  7117,  7123,  7131,  7139,  7144,  7150,  7154,
    7158,  7162,  7166,  7170,  7174,  7178,  7182,  7186,  7190,  7194,
    7198,  7202,  7206,  7210,  7218,  7223,  7229,  7233,  7241,  7249,
    7254,  7260,  7268,  7272,  7280,  7288,  7292,  7296,  7300,  7304,
    7312,  7317,  7323,  7331,  7335,  7339,  7343,  7347,  7351,  7359,
    7367,  7371,  7375,  7383,  7388,  7394,  7398,  7402,  7406,  7410,
    7418,  7422,  7430,  7434,  7438,  7442,  7450,  7454,  7462,  7466,
    7474,  7479,  7485,  7490,  7496,  7501,  7507,  7512,  7518,  7522,
    7526,  7530,  7538,  7542,  7546,  7550,  7554,  7558,  7562,  7570,
    7574,  7582,  7590,  7594,  7598,  7606,  7610,  7615,  7621,  7627,
    7637,  7642,  7648,  7652,  7656,  7660,  7668,  7670,  7678,  7683,
    7689,  7697,  7701,  7705,  7713,  7717,  7725,  7733,  7738,  7744,
    7752,  7757,  7763,  7771,  7776,  7782,  7786,  7790,  7794,  7798,
    7802,  7806,  7810,  7818,  7823,  7829,  7837,  7841,  7849,  7853,
    7861,  7869,  7877,  7885,  7889,  7897,  7950,  7954,  7967,  7969,
    7973,  7977,  7981,  7990,  7996,  8000,  8008,  8012,  8020,  8024,
    8032,  8036,  8040,  8044,  8048,  8052,  8056,  8060,  8068,  8072,
    8080,  8084,  8088,  8092,  8096,  8100,  8108,  8112,  8120,  8124,
    8132,  8140,  8145,  8151,  8156,  8158,  8164,  8168,  8172,  8176,
    8180,  8184,  8188,  8192,  8196,  8204,  8209,  8215,  8219,  8224,
    8230,  8234,  8238,  8243,  8249,  8254,  8260,  8268,  8272,  8280,
    8284,  8292,  8296,  8300,  8304,  8312,  8317,  8323,  8327,  8332,
    8340,  8344,  8352,  8356,  8364,  8372,  8376,  8381,  8387,  8395,
    8399,  8407,  8411,  8419,  8424,  8430,  8435,  8441,  8445,  8453,
    8458,  8464,  8468,  8476,  8480,  8488,  8493,  8499,  8503,  8511,
    8516,  8522,  8526,  8534,  8538,  8542,  8546,  8550,  8554,  8558,
    8562,  8568,  8572,  8576,  8584,  8588,  8592,  8596,  8600,  8604,
    8612,  8616,  8620,  8624,  8632,  8636,  8640,  8644,  8652,  8657,
    8663,  8667,  8675,  8679,  8683,  8687,  8695,  8699,  8707,  8711,
    8715,  8723,  8731,  8736,  8742,  8746,  8752,  8758,  8763,  8769,
    8773,  8781,  8789,  8791,  8793,  8797,  8801,  8805,  8813,  8823,
    8834,  8843,  8847,  8851,  8855,  8859,  8863,  8867,  8875,  8879,
    8883,  8887,  8895,  8899,  8907,  8912,  8918,  8922,  8926,  8930,
    8934,  8938,  8942,  8946,  8950,  8954,  8958,  8966,  8971,  8977,
    8981,  8989,  8993,  9001,  9009,  9017,  9021,  9029,  9033,  9041,
    9049,  9057,  9061,  9065,  9069,  9073,  9077,  9085,  9090,  9096,
    9101,  9107,  9111,  9115,  9119,  9127,  9135,  9139,  9144,  9150,
    9154,  9158,  9162,  9166,  9170,  9174,  9178,  9182,  9186,  9190,
    9194,  9198,  9203,  9209,  9213,  9221,  9225,  9229,  9233,  9237,
    9241,  9245,  9249,  9253,  9257,  9261,  9265,  9269,  9273,  9277,
    9281,  9285,  9289,  9293,  9297,  9301,  9305,  9309,  9313,  9317,
    9321,  9325,  9329,  9333,  9337,  9341,  9345,  9349,  9353,  9357,
    9361,  9365,  9369,  9373,  9377,  9381,  9385,  9389,  9393,  9397,
    9401,  9405,  9409,  9413,  9417,  9421,  9425,  9429,  9433,  9437,
    9441,  9445,  9450,  9454,  9462,  9466,  9470,  9474,  9478,  9482,
    9486,  9490,  9494,  9498,  9502,  9506,  9510,  9514,  9518,  9522,
    9526,  9530,  9534,  9538,  9542,  9546,  9554,  9558,  9562,  9566,
    9570,  9574,  9578,  9582,  9586,  9590,  9594,  9602,  9606,  9610,
    9614,  9618,  9622,  9626,  9630,  9634,  9638,  9642,  9646,  9650,
    9654,  9658,  9662,  9666,  9670,  9674,  9678,  9682,  9686,  9690,
    9694,  9698,  9702,  9706,  9710,  9714,  9718,  9722,  9726,  9730,
    9734,  9738,  9742,  9746,  9750,  9754,  9758,  9762,  9766,  9770,
    9774,  9778,  9782,  9786,  9790,  9794,  9802,  9806,  9814,  9818,
    9822,  9827,  9833,  9841,  9845,  9853,  9857,  9865,  9869,  9877,
    9881,  9886,  9892,  9896,  9900,  9904,  9912,  9917,  9923,  9927,
    9935,  9943,  9947,  9952,  9958,  9966,  9970,  9977,  9982,  9988,
    9993,  9998, 10004, 10008, 10016, 10020, 10024, 10028, 10032, 10040,
   10044, 10048, 10056, 10060, 10064, 10072, 10076, 10084, 10088, 10092,
   10096, 10100, 10104, 10108, 10112, 10116, 10124, 10128, 10136, 10140,
   10148, 10152, 10156, 10160, 10164, 10168, 10176, 10180, 10188, 10192,
   10200, 10204, 10212, 10216, 10224, 10228, 10232, 10240, 10244, 10252,
   10257, 10263, 10267, 10271, 10275, 10279, 10283, 10287, 10291, 10299,
   10303, 10311, 10319, 10324, 10330, 10334, 10338, 10342, 10346, 10351,
   10357, 10365, 10373, 10377, 10381, 10389, 10393, 10401, 10409, 10413,
   10421, 10429, 10434, 10440, 10445, 10451, 10455, 10463, 10467, 10471,
   10475, 10483, 10487, 10496, 10498, 10506, 10511, 10517, 10521, 10529,
   10533, 10541, 10549, 10553, 10561, 10565, 10569, 10573, 10581, 10585,
   10593, 10597, 10605, 10609, 10617, 10625, 10633, 10641, 10649, 10657,
   10665, 10669, 10677, 10681, 10685, 10689, 10693, 10697, 10701, 10705,
   10709, 10713, 10717, 10721, 10725, 10729, 10730, 10735, 10741, 10749,
   10753, 10754, 10758, 10766, 10770, 10774, 10778, 10782, 10786, 10790,
   10794, 10798, 10802, 10806, 10810, 10814, 10818, 10822, 10826, 10830,
   10834, 10838, 10842, 10846, 10850, 10854, 10858, 10862, 10866, 10870,
   10874, 10878, 10882, 10886, 10890, 10894, 10898, 10902, 10906, 10910,
   10914, 10918, 10922, 10926, 10930, 10934, 10938, 10942, 10946, 10950,
   10954, 10958, 10962, 10966, 10970, 10974, 10978, 10982, 10986, 10990,
   10994, 10998, 11002, 11006, 11010, 11014, 11018, 11022, 11026, 11030,
   11034, 11038, 11042, 11046, 11050, 11054, 11058, 11062, 11066, 11070,
   11074, 11078, 11082, 11086, 11090, 11094, 11098, 11102, 11106, 11110,
   11114, 11118, 11122, 11126, 11130, 11134, 11138, 11142, 11146, 11150,
   11154, 11158, 11162, 11166, 11170, 11174, 11178, 11182, 11186, 11190,
   11194, 11198, 11202, 11206, 11210, 11214, 11218, 11222, 11226, 11230,
   11234, 11238, 11242, 11246, 11250, 11254, 11258, 11262, 11266, 11270,
   11274, 11278, 11282, 11286, 11290, 11294, 11298, 11302, 11306, 11310,
   11314, 11318, 11322, 11326, 11330, 11334, 11338, 11342, 11346, 11350,
   11354, 11358, 11362, 11366, 11370, 11374, 11378, 11382, 11386, 11390,
   11394, 11398, 11402, 11406, 11410, 11414, 11418, 11422, 11426, 11430,
   11434, 11438, 11442, 11446, 11450, 11454, 11458, 11462, 11466, 11470,
   11474, 11478, 11482, 11486, 11490, 11494, 11498, 11502, 11506, 11510,
   11514, 11518, 11522, 11526, 11530, 11534, 11538, 11542, 11546, 11550,
   11554, 11558, 11562, 11566, 11570, 11574, 11578, 11582, 11586, 11590,
   11594, 11598, 11602, 11606, 11610, 11614, 11618, 11622, 11626, 11630,
   11634, 11638, 11642, 11646, 11650, 11654, 11658, 11662, 11666, 11670,
   11674, 11678, 11682, 11686, 11690, 11694, 11698, 11702, 11706, 11710,
   11714, 11718, 11726, 11730, 11734, 11738, 11742, 11746, 11750, 11754,
   11758, 11762, 11766, 11770, 11774, 11778, 11782, 11786, 11790, 11794,
   11798, 11802, 11806, 11810, 11814, 11818, 11822, 11826, 11830, 11834,
   11838, 11842, 11846, 11850, 11854, 11858, 11862, 11866, 11870, 11874,
   11878, 11882, 11886, 11890, 11894, 11898, 11906, 11910, 11914, 11918,
   11922, 11926, 11930, 11934, 11938, 11942, 11946, 11950, 11954, 11958,
   11962, 11966, 11970, 11974, 11978, 11982, 11986, 11990, 11998, 12002,
   12006, 12010, 12014, 12018, 12022, 12026, 12030, 12034, 12038, 12042,
   12046, 12050, 12054, 12058, 12062, 12066, 12070, 12074, 12078, 12082,
   12086, 12090, 12094, 12098, 12102, 12106, 12110, 12114, 12118, 12122,
   12126, 12130, 12134, 12138, 12142, 12146, 12150, 12154, 12158, 12162,
   12166, 12170, 12174, 12178, 12182, 12186, 12190, 12194, 12198, 12202,
   12206, 12210, 12214, 12218, 12222, 12226, 12230, 12234, 12238, 12242,
   12246, 12250, 12254, 12258, 12262, 12266, 12270, 12274, 12278, 12282,
   12286, 12290, 12300, 12301, 12304, 12305, 12306, 12312, 12313, 12314,
   12315, 12316, 12329, 12329, 12338, 12354, 12356, 12359, 12361, 12365,
   12377, 12393, 12397, 12408, 12409, 12412, 12424, 12433, 12434, 12437,
   12438, 12439, 12442, 12443, 12446, 12447, 12450, 12451, 12454, 12456,
   12458, 12460, 12464, 12471, 12478, 12494, 12528, 12538, 12541, 12543,
   12556, 12557, 12559, 12561, 12565, 12578, 12585, 12646, 12655, 12657,
   12658, 12661, 12663, 12664, 12667, 12668, 12669, 12670, 12671, 12678,
   12677, 12687, 12689, 12691, 12692, 12695, 12696, 12697, 12698, 12701,
   12702, 12706, 12705, 12722, 12720, 12736, 12735, 12749, 12755, 12756,
   12759, 12761, 12762, 12765, 12766, 12767, 12768, 12771, 12772, 12775,
   12783, 12800, 12808, 12831, 12937, 12971, 12973, 12975, 12979, 12983,
   12982, 13033, 13035, 13034, 13049, 13055, 13062, 13067, 13070, 13071,
   13074, 13075, 13076, 13077, 13078, 13079, 13080, 13088, 13096, 13099,
   13100, 13101, 13102, 13103, 13104, 13112, 13120, 13121, 13122, 13125,
   13126, 13129, 13131, 13135, 13223, 13224, 13231, 13232, 13233, 13239,
   13248, 13251, 13252, 13253, 13254, 13257, 13258, 13259, 13262, 13264,
   13272, 13273, 13279, 13287, 13288, 13291, 13292, 13295, 13300, 13307,
   13312, 13319, 13326, 13326, 13328, 13335, 13336, 13339, 13340, 13341,
   13342, 13343, 13344, 13345, 13346, 13347, 13353, 13360, 13372, 13378,
   13385, 13393, 13394, 13406, 13417, 13428, 13432, 13433, 13436, 13441,
   13445, 13446, 13449, 13455, 13463, 13466, 13473, 13477, 13478, 13481,
   13484, 13488, 13489, 13492, 13498, 13506, 13507, 13516, 13525, 13537,
   13538, 13539, 13540, 13541, 13542, 13543, 13544, 13545, 13546, 13547,
   13548, 13549, 13550, 13551, 13558, 13559, 13562, 13563, 13570, 13571,
   13572, 13579, 13578, 13595, 13596, 13603, 13602, 13672, 13678, 13684,
   13692, 13698, 13704, 13710, 13716, 13722, 13728, 13734, 13740, 13751,
   13752, 13755, 13756, 13757, 13758, 13759, 13760, 13761, 13762, 13763,
   13764, 13765, 13766, 13767, 13768, 13769, 13770, 13771, 13772, 13773,
   13774, 13775, 13776, 13777, 13778, 13781, 13782, 13783, 13784, 13785,
   13786, 13790, 13791, 13792, 13793, 13794, 13795, 13796, 13799, 13802,
   13803, 13804, 13805, 13806, 13807, 13808, 13809, 13822, 13823, 13824,
   13825, 13826, 13827, 13828, 13833, 13834, 13835, 13836, 13837, 13838,
   13844, 13845, 13846, 13847, 13848, 13849, 13850, 13851, 13852, 13853,
   13854, 13857, 13858, 13859, 13860, 13861, 13864, 13865, 13866, 13867,
   13870, 13871, 13872, 13873, 13874, 13875, 13876, 13893, 13894, 13895,
   13898, 13899, 13900, 13901, 13902, 13903, 13907, 13907, 13910, 13916,
   13917, 13920, 13922, 13927, 13937, 13948, 13955, 13956, 13957, 13960,
   13993, 13995, 13997, 14000, 14010, 14020, 14030, 14031, 14034, 14036,
   14037, 14038, 14041, 14043, 14051, 14052, 14053, 14057, 14058, 14062,
   14063, 14066, 14067, 14070, 14071, 14072, 14073, 14074, 14077, 14078,
   14079, 14080, 14081, 14082, 14083, 14084, 14085, 14086, 14087, 14088,
   14089, 14090, 14091, 14092, 14093, 14094, 14095, 14096, 14097, 14098,
   14099, 14100, 14101, 14102, 14103, 14104, 14105, 14106, 14107, 14108,
   14109, 14110, 14111, 14112, 14113, 14114, 14115, 14116, 14117, 14118,
   14119, 14120, 14121, 14122, 14123, 14124, 14125, 14126, 14127, 14128,
   14129, 14130, 14131, 14132, 14135, 14136, 14137, 14138, 14141, 14142,
   14143, 14144, 14145, 14146, 14147, 14148, 14149, 14152, 14153, 14154,
   14155, 14156, 14159, 14160, 14163, 14164, 14175, 14176
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", 
  "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP", 
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST", 
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST", 
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", 
  "ALWAYS", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", 
  "ASSERTION", "ASSIGNMENT", "ASYMMETRIC", "AT", "ATTRIBUTE", 
  "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", 
  "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", 
  "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", 
  "CHARACTER", "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", 
  "CLUSTER", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMENT", 
  "COMMENTS", "COMMIT", "COMMITTED", "CONCURRENTLY", "CONFIGURATION", 
  "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", 
  "CONVERSION_P", "COPY", "COST", "CREATE", "CROSS", "CSV", "CURRENT_P", 
  "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", 
  "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", 
  "DATA_P", "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", 
  "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", 
  "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", 
  "DISABLE_P", "DISCARD", "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", 
  "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", 
  "END_P", "ENUM_P", "ESCAPE", "EXCEPT", "EXCLUDE", "EXCLUDING", 
  "EXCLUSIVE", "EXECUTE", "EXISTS", "EXPLAIN", "EXTENSION", "EXTERNAL", 
  "EXTRACT", "FALSE_P", "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", 
  "FOLLOWING", "FOR", "FORCE", "FOREIGN", "FORWARD", "FREEZE", "FROM", 
  "FULL", "FUNCTION", "FUNCTIONS", "GLOBAL", "GRANT", "GRANTED", 
  "GREATEST", "GROUP_P", "HANDLER", "HAVING", "HEADER_P", "HOLD", 
  "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE", "IMMUTABLE", 
  "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", "INDEXES", 
  "INHERIT", "INHERITS", "INITIALLY", "INLINE_P", "INNER_P", "INOUT", 
  "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", "INTEGER", 
  "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", 
  "JOIN", "KEY", "LABEL", "LANGUAGE", "LARGE_P", "LAST_P", "LC_COLLATE_P", 
  "LC_CTYPE_P", "LEADING", "LEAST", "LEFT", "LEVEL", "LIKE", "LIMIT", 
  "LISTEN", "LOAD", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", 
  "LOCK_P", "MAPPING", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", 
  "MODE", "MONTH_P", "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", 
  "NCHAR", "NEXT", "NO", "NONE", "NOT", "NOTHING", "NOTIFY", "NOTNULL", 
  "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", "OBJECT_P", "OF", 
  "OFF", "OFFSET", "OIDS", "ON", "ONLY", "OPERATOR", "OPTION", "OPTIONS", 
  "OR", "ORDER", "OUT_P", "OUTER_P", "OVER", "OVERLAPS", "OVERLAY", 
  "OWNED", "OWNER", "PARSER", "PARTIAL", "PARTITION", "PASSING", 
  "PASSWORD", "PLACING", "PLANS", "POSITION", "PRECEDING", "PRECISION", 
  "PRESERVE", "PREPARE", "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", 
  "PROCEDURAL", "PROCEDURE", "QUOTE", "RANGE", "READ", "REAL", "REASSIGN", 
  "RECHECK", "RECURSIVE", "REF", "REFERENCES", "REINDEX", "RELATIVE_P", 
  "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", "RESET", 
  "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", "RIGHT", 
  "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", "SCHEMA", 
  "SCROLL", "SEARCH", "SECOND_P", "SECURITY", "SELECT", "SEQUENCE", 
  "SEQUENCES", "SERIALIZABLE", "SERVER", "SESSION", "SESSION_USER", "SET", 
  "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", 
  "STABLE", "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN", 
  "STDOUT", "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SYMMETRIC", 
  "SYSID", "SYSTEM_P", "TABLE", "TABLES", "TABLESPACE", "TEMP", 
  "TEMPLATE", "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", 
  "TRUNCATE", "TRUSTED", "TYPE_P", "UNBOUNDED", "UNCOMMITTED", 
  "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", "UNLOGGED", 
  "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATE", 
  "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR", "VARIADIC", "VARYING", 
  "VERBOSE", "VERSION_P", "VIEW", "VOLATILE", "WHEN", "WHERE", 
  "WHITESPACE_P", "WINDOW", "WITH", "WITHOUT", "WORK", "WRAPPER", "WRITE", 
  "XML_P", "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLEXISTS", 
  "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P", 
  "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_TIME", "'='", "'<'", 
  "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'", "'^'", "UMINUS", 
  "'['", "']'", "'('", "')'", "'.'", "','", "';'", "':'", "'{'", "'}'", 
  "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with", "OptRoleList", 
  "AlterOptRoleList", "AlterOptRoleElem", "CreateOptRoleElem", 
  "CreateUserStmt", "AlterRoleStmt", "opt_in_database", 
  "AlterRoleSetStmt", "AlterUserStmt", "AlterUserSetStmt", "DropRoleStmt", 
  "DropUserStmt", "CreateGroupStmt", "AlterGroupStmt", "add_drop", 
  "DropGroupStmt", "CreateSchemaStmt", "OptSchemaName", 
  "OptSchemaEltList", "schema_stmt", "VariableSetStmt", "set_rest", 
  "var_name", "var_list", "var_value", "iso_level", 
  "opt_boolean_or_string", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableResetStmt", "SetResetClause", 
  "VariableShowStmt", "ConstraintsSetStmt", "constraints_set_list", 
  "constraints_set_mode", "CheckPointStmt", "DiscardStmt", 
  "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_column_default", "opt_drop_behavior", "opt_collate_clause", 
  "alter_using", "reloptions", "opt_reloptions", "reloption_list", 
  "reloption_elem", "AlterCompositeTypeStmt", "alter_type_cmds", 
  "alter_type_cmd", "ClosePortalStmt", "CopyStmt", "copy_from", 
  "copy_file_name", "copy_options", "copy_opt_list", "copy_opt_item", 
  "opt_binary", "opt_oids", "copy_delimiter", "opt_using", 
  "copy_generic_opt_list", "copy_generic_opt_elem", 
  "copy_generic_opt_arg", "copy_generic_opt_arg_list", 
  "copy_generic_opt_arg_list_item", "CreateStmt", "OptTemp", 
  "OptTableElementList", "OptTypedTableElementList", "TableElementList", 
  "TypedTableElementList", "TableElement", "TypedTableElement", 
  "columnDef", "columnOptions", "ColQualList", "ColConstraint", 
  "ColConstraintElem", "ConstraintAttr", "TableLikeClause", 
  "TableLikeOptionList", "TableLikeOption", "TableConstraint", 
  "ConstraintElem", "opt_column_list", "columnList", "columnElem", 
  "key_match", "ExclusionConstraintList", "ExclusionConstraintElem", 
  "ExclusionWhereClause", "key_actions", "key_update", "key_delete", 
  "key_action", "OptInherit", "OptWith", "OnCommitOption", 
  "OptTableSpace", "OptConsTableSpace", "ExistingIndex", 
  "create_as_target", "OptCreateAs", "CreateAsList", "CreateAsElement", 
  "opt_with_data", "CreateSeqStmt", "AlterSeqStmt", "OptSeqOptList", 
  "SeqOptList", "SeqOptElem", "opt_by", "NumericOnly", "NumericOnly_list", 
  "CreatePLangStmt", "opt_trusted", "handler_name", "opt_inline_handler", 
  "validator_clause", "opt_validator", "DropPLangStmt", "opt_procedural", 
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt", 
  "CreateExtensionStmt", "create_extension_opt_list", 
  "create_extension_opt_item", "AlterExtensionStmt", 
  "alter_extension_opt_list", "alter_extension_opt_item", 
  "AlterExtensionContentsStmt", "CreateFdwStmt", "fdw_option", 
  "fdw_options", "opt_fdw_options", "DropFdwStmt", "AlterFdwStmt", 
  "create_generic_options", "generic_option_list", 
  "alter_generic_options", "alter_generic_option_list", 
  "alter_generic_option_elem", "generic_option_elem", 
  "generic_option_name", "generic_option_arg", "CreateForeignServerStmt", 
  "opt_type", "foreign_server_version", "opt_foreign_server_version", 
  "DropForeignServerStmt", "AlterForeignServerStmt", 
  "CreateForeignTableStmt", "OptForeignTableElementList", 
  "ForeignTableElementList", "ForeignTableElement", 
  "AlterForeignTableStmt", "CreateUserMappingStmt", "auth_ident", 
  "DropUserMappingStmt", "AlterUserMappingStmt", "CreateTrigStmt", 
  "TriggerActionTime", "TriggerEvents", "TriggerOneEvent", 
  "TriggerForSpec", "TriggerForOptEach", "TriggerForType", "TriggerWhen", 
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable", 
  "ConstraintAttributeSpec", "ConstraintAttributeElem", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition", 
  "old_aggr_list", "old_aggr_elem", "opt_enum_val_list", "enum_val_list", 
  "AlterEnumStmt", "CreateOpClassStmt", "opclass_item_list", 
  "opclass_item", "opt_default", "opt_opfamily", "opclass_purpose", 
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt", 
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt", 
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt", 
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt", 
  "opt_restart_seqs", "CommentStmt", "comment_type", "comment_text", 
  "SecLabelStmt", "opt_provider", "security_label_type", "security_label", 
  "FetchStmt", "fetch_args", "from_in", "opt_from_in", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "function_with_argtypes_list", "function_with_argtypes", 
  "GrantRoleStmt", "RevokeRoleStmt", "opt_grant_admin_option", 
  "opt_granted_by", "AlterDefaultPrivilegesStmt", "DefACLOptionList", 
  "DefACLOption", "DefACLAction", "defacl_privilege_target", "IndexStmt", 
  "opt_unique", "opt_concurrently", "opt_index_name", 
  "access_method_clause", "index_params", "index_elem", "opt_collate", 
  "opt_class", "opt_asc_desc", "opt_nulls_order", "CreateFunctionStmt", 
  "opt_or_replace", "func_args", "func_args_list", 
  "func_args_with_defaults", "func_args_with_defaults_list", "func_arg", 
  "arg_class", "param_name", "func_return", "func_type", 
  "func_arg_with_default", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "func_as", "opt_definition", "table_func_column", 
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list", 
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt", 
  "oper_argtypes", "any_operator", "DoStmt", "dostmt_opt_list", 
  "dostmt_opt_item", "CreateCastStmt", "cast_context", "DropCastStmt", 
  "opt_if_exists", "ReindexStmt", "reindex_type", "opt_force", 
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt", 
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti", 
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead", 
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt", 
  "UnlistenStmt", "TransactionStmt", "opt_transaction", 
  "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "vacuum_option_list", "vacuum_option_elem", "AnalyzeStmt", 
  "analyze_keyword", "opt_verbose", "opt_full", "opt_freeze", 
  "opt_name_list", "ExplainStmt", "ExplainableStmt", 
  "explain_option_list", "explain_option_elem", "explain_option_name", 
  "explain_option_arg", "PrepareStmt", "prep_type_clause", 
  "PreparableStmt", "ExecuteStmt", "execute_param_clause", "InsertStmt", 
  "insert_rest", "insert_column_list", "insert_column_item", 
  "returning_clause", "DeleteStmt", "using_clause", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", "set_clause_list", 
  "set_clause", "single_set_clause", "multiple_set_clause", "set_target", 
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options", 
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens", 
  "select_clause", "simple_select", "with_clause", "cte_list", 
  "common_table_expr", "opt_with_clause", "into_clause", 
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct", 
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby", 
  "select_limit", "opt_select_limit", "limit_clause", "offset_clause", 
  "select_limit_value", "select_offset_value", 
  "opt_select_fetch_first_value", "select_offset_value2", "row_or_rows", 
  "first_or_next", "group_clause", "having_clause", "for_locking_clause", 
  "opt_for_locking_clause", "for_locking_items", "for_locking_item", 
  "locked_rels_list", "values_clause", "from_clause", "from_list", 
  "table_ref", "joined_table", "alias_clause", "join_type", "join_outer", 
  "join_qual", "relation_expr", "relation_expr_list", 
  "relation_expr_opt_alias", "func_table", "where_clause", 
  "where_or_current_clause", "OptTableFuncElementList", 
  "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType", 
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr", 
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "xmlexists_argument", 
  "window_clause", "window_definition_list", "window_definition", 
  "over_clause", "window_specification", "opt_existing_window_name", 
  "opt_partition_clause", "opt_frame_clause", "frame_extent", 
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list", 
  "func_arg_expr", "type_list", "array_expr", "array_expr_list", 
  "extract_list", "extract_arg", "overlay_list", "overlay_placing", 
  "position_list", "substr_list", "substr_from", "substr_for", 
  "trim_list", "in_expr", "case_expr", "when_clause_list", "when_clause", 
  "case_default", "case_arg", "columnref", "indirection_el", 
  "indirection", "opt_indirection", "opt_asymmetric", "ctext_expr", 
  "ctext_expr_list", "ctext_row", "target_list", "target_el", 
  "qualified_name_list", "qualified_name", "name_list", "name", 
  "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "RoleId", 
  "SignedIconst", "unreserved_keyword", "col_name_keyword", 
  "type_func_name_keyword", "reserved_keyword", "statements", "statement", 
  "CreateAsStmt", "@1", "at", "ECPGConnect", "connection_target", 
  "opt_database_name", "db_prefix", "server", "opt_server", "server_name", 
  "opt_port", "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "connect_options", "opt_opt_value", 
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt", 
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale", 
  "ecpg_interval", "ECPGDeclaration", "@2", "sql_startdeclare", 
  "sql_enddeclare", "var_type_declarations", "vt_declarations", 
  "variable_declarations", "type_declaration", "@3", "var_declaration", 
  "@4", "@5", "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@6", "struct_union_type", "@7", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execstring", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list", 
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item", 
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem", 
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem", 
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off", 
  "ECPGSetConnection", "ECPGTypedef", "@8", "opt_reference", "ECPGVar", 
  "@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames", 
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId", 
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon", 
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval", 
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind", 
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param", 
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", 
  "ecpg_ident", "quoted_ident_stringvar", "c_stuff_item", "c_stuff", 
  "c_list", "c_term", "c_thing", "c_anything", "DeallocateStmt", 
  "Iresult", "execute_rest", "ecpg_into", "ecpg_fetch_into", 
  "opt_ecpg_fetch_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,    61,    60,    62,
     742,    43,    45,    42,    47,    37,    94,   743,    91,    93,
      40,    41,    46,    44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   508,   509,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   510,   510,   510,   510,   510,   510,   510,
     510,   510,   510,   511,   512,   512,   513,   513,   514,   514,
     515,   515,   515,   515,   515,   515,   515,   515,   515,   516,
     516,   516,   516,   516,   516,   517,   518,   519,   519,   520,
     521,   522,   523,   523,   524,   524,   525,   526,   527,   527,
     528,   528,   529,   529,   530,   530,   531,   531,   532,   532,
     532,   532,   532,   532,   533,   533,   533,   534,   534,   534,
     534,   534,   534,   534,   534,   534,   534,   534,   534,   534,
     534,   534,   535,   535,   536,   536,   537,   537,   538,   538,
     538,   538,   539,   539,   539,   539,   540,   540,   540,   540,
     540,   540,   540,   541,   541,   541,   542,   542,   543,   543,
     543,   543,   543,   544,   544,   545,   545,   545,   545,   545,
     546,   547,   547,   548,   548,   549,   550,   550,   550,   550,
     551,   551,   551,   551,   552,   552,   553,   553,   553,   553,
     553,   553,   553,   553,   553,   553,   553,   553,   553,   553,
     553,   553,   553,   553,   553,   553,   553,   553,   553,   553,
     553,   553,   553,   553,   553,   553,   553,   553,   553,   553,
     553,   553,   553,   553,   553,   553,   553,   554,   554,   555,
     555,   555,   556,   556,   557,   557,   558,   559,   559,   560,
     560,   561,   561,   561,   561,   562,   563,   563,   564,   564,
     564,   564,   565,   565,   566,   566,   567,   567,   568,   568,
     568,   569,   569,   570,   570,   571,   571,   571,   571,   571,
     571,   571,   571,   571,   571,   571,   571,   572,   572,   573,
     573,   574,   574,   575,   575,   576,   576,   577,   578,   578,
     578,   578,   578,   579,   579,   580,   581,   581,   581,   581,
     582,   582,   582,   582,   582,   582,   582,   582,   583,   583,
     584,   584,   585,   585,   586,   586,   587,   587,   587,   588,
     588,   589,   590,   591,   591,   592,   592,   592,   592,   593,
     593,   593,   593,   593,   593,   593,   594,   594,   594,   594,
     595,   596,   596,   596,   597,   597,   597,   597,   597,   597,
     598,   598,   599,   599,   599,   599,   599,   599,   599,   600,
     600,   601,   601,   602,   603,   603,   603,   603,   604,   604,
     605,   605,   606,   606,   607,   607,   607,   607,   607,   608,
     609,   610,   610,   610,   610,   610,   611,   611,   612,   612,
     612,   612,   613,   613,   613,   613,   614,   614,   615,   615,
     616,   617,   618,   618,   619,   619,   620,   621,   621,   621,
     622,   623,   624,   624,   625,   625,   626,   626,   626,   626,
     626,   626,   626,   626,   626,   626,   626,   626,   627,   627,
     628,   628,   628,   629,   629,   630,   630,   631,   631,   632,
     632,   633,   633,   634,   634,   635,   635,   636,   636,   637,
     637,   638,   639,   639,   640,   640,   641,   641,   642,   642,
     643,   643,   643,   644,   645,   645,   646,   647,   647,   647,
     647,   647,   647,   647,   647,   647,   647,   647,   647,   647,
     647,   647,   647,   647,   647,   647,   647,   647,   647,   648,
     649,   649,   649,   649,   650,   650,   651,   651,   652,   652,
     653,   653,   654,   654,   655,   655,   656,   657,   657,   658,
     658,   658,   658,   659,   660,   661,   662,   663,   663,   664,
     664,   665,   665,   666,   666,   667,   667,   667,   668,   668,
     669,   669,   670,   670,   671,   672,   673,   674,   674,   674,
     675,   675,   676,   677,   677,   678,   678,   678,   679,   679,
     680,   680,   680,   680,   680,   681,   681,   682,   682,   683,
     683,   684,   684,   685,   685,   685,   686,   686,   686,   686,
     687,   687,   688,   688,   689,   689,   689,   689,   689,   690,
     690,   691,   692,   693,   693,   693,   693,   693,   693,   693,
     693,   693,   693,   693,   693,   693,   694,   695,   695,   696,
     696,   697,   697,   697,   697,   697,   698,   698,   699,   700,
     700,   701,   702,   702,   703,   703,   704,   704,   704,   705,
     706,   706,   707,   707,   707,   707,   707,   708,   708,   709,
     709,   710,   710,   710,   711,   711,   712,   713,   713,   714,
     714,   715,   715,   716,   716,   717,   717,   718,   719,   720,
     720,   721,   721,   721,   721,   721,   721,   721,   721,   721,
     721,   721,   721,   721,   721,   721,   722,   722,   723,   723,
     724,   724,   725,   726,   726,   726,   727,   727,   727,   727,
     727,   727,   727,   727,   727,   727,   727,   727,   727,   727,
     727,   727,   727,   728,   728,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   728,   728,   728,   728,
     729,   729,   730,   730,   730,   730,   730,   731,   731,   732,
     732,   732,   732,   732,   732,   732,   732,   733,   733,   734,
     734,   734,   734,   734,   734,   734,   734,   734,   734,   734,
     735,   735,   735,   735,   735,   735,   735,   735,   735,   735,
     735,   735,   735,   735,   736,   736,   737,   737,   738,   739,
     739,   740,   740,   740,   740,   740,   741,   741,   742,   742,
     742,   742,   743,   743,   743,   743,   743,   743,   743,   743,
     743,   743,   743,   743,   743,   743,   744,   744,   745,   745,
     746,   746,   747,   747,   748,   749,   750,   750,   751,   751,
     752,   752,   753,   754,   754,   755,   755,   755,   756,   756,
     756,   757,   757,   757,   758,   759,   759,   760,   760,   761,
     761,   762,   762,   763,   763,   764,   764,   764,   765,   765,
     766,   766,   766,   767,   767,   767,   768,   768,   768,   769,
     769,   769,   770,   770,   771,   771,   772,   772,   773,   773,
     774,   774,   775,   775,   775,   775,   775,   776,   776,   776,
     776,   776,   777,   778,   779,   779,   779,   780,   780,   780,
     781,   781,   782,   782,   782,   782,   782,   782,   782,   782,
     782,   782,   782,   782,   782,   783,   783,   783,   783,   784,
     784,   785,   785,   786,   787,   787,   788,   789,   789,   790,
     790,   791,   791,   792,   792,   793,   793,   794,   794,   794,
     794,   795,   795,   796,   797,   797,   798,   798,   799,   799,
     799,   800,   800,   800,   801,   802,   802,   803,   803,   803,
     804,   804,   805,   805,   806,   806,   806,   806,   806,   806,
     806,   806,   806,   806,   806,   806,   806,   806,   806,   806,
     806,   806,   806,   806,   806,   806,   806,   806,   806,   806,
     806,   806,   806,   807,   807,   808,   808,   809,   809,   809,
     809,   809,   809,   809,   809,   809,   809,   809,   809,   809,
     809,   809,   809,   809,   809,   810,   810,   810,   810,   810,
     810,   810,   810,   810,   810,   810,   810,   810,   810,   810,
     810,   810,   810,   811,   812,   812,   812,   813,   813,   814,
     814,   814,   814,   814,   815,   815,   816,   816,   816,   816,
     817,   817,   817,   818,   818,   819,   820,   820,   821,   822,
     822,   823,   823,   823,   823,   823,   823,   823,   823,   823,
     823,   823,   823,   823,   823,   824,   824,   824,   825,   825,
     825,   825,   825,   826,   826,   826,   827,   827,   828,   828,
     829,   829,   829,   829,   830,   831,   832,   832,   833,   833,
     833,   833,   833,   833,   833,   833,   833,   833,   833,   833,
     833,   833,   833,   833,   834,   834,   835,   835,   836,   837,
     837,   838,   839,   839,   840,   841,   841,   841,   841,   841,
     842,   842,   843,   844,   844,   844,   844,   844,   844,   845,
     846,   846,   846,   847,   847,   848,   848,   848,   848,   848,
     849,   849,   850,   850,   850,   850,   851,   851,   852,   852,
     853,   853,   854,   854,   855,   855,   856,   856,   857,   857,
     857,   857,   858,   858,   858,   858,   858,   858,   858,   859,
     859,   860,   861,   861,   861,   862,   862,   862,   863,   863,
     864,   864,   865,   865,   865,   865,   866,   866,   867,   867,
     868,   869,   869,   869,   870,   870,   871,   872,   872,   873,
     874,   874,   875,   876,   876,   877,   877,   877,   877,   877,
     877,   877,   877,   878,   878,   879,   880,   880,   881,   881,
     882,   883,   884,   885,   885,   886,   887,   887,   888,   888,
     888,   888,   888,   889,   889,   889,   890,   890,   891,   891,
     892,   892,   892,   892,   892,   892,   892,   892,   893,   893,
     894,   894,   894,   894,   894,   894,   895,   895,   896,   896,
     897,   898,   898,   899,   899,   899,   900,   900,   900,   900,
     900,   900,   900,   900,   900,   901,   901,   902,   902,   902,
     903,   903,   903,   903,   904,   904,   905,   906,   906,   907,
     907,   908,   908,   908,   908,   909,   909,   910,   910,   910,
     911,   911,   912,   912,   913,   914,   914,   914,   915,   916,
     916,   917,   917,   918,   918,   919,   919,   920,   920,   921,
     921,   922,   922,   923,   923,   924,   924,   925,   925,   926,
     926,   927,   927,   928,   928,   928,   928,   928,   928,   928,
     928,   928,   928,   928,   929,   929,   929,   929,   929,   929,
     930,   930,   930,   930,   931,   931,   931,   931,   932,   932,
     933,   933,   934,   934,   934,   934,   935,   935,   936,   936,
     936,   937,   938,   938,   939,   939,   939,   940,   940,   941,
     941,   942,   943,   943,   943,   943,   943,   943,   944,   944,
     944,   945,   945,   945,   945,   945,   945,   945,   946,   946,
     946,   946,   947,   947,   948,   948,   949,   949,   949,   949,
     949,   949,   949,   949,   949,   949,   949,   950,   950,   951,
     951,   952,   952,   953,   954,   955,   955,   956,   956,   957,
     958,   959,   959,   959,   959,   959,   959,   960,   960,   961,
     961,   962,   962,   962,   962,   963,   964,   964,   964,   965,
     965,   965,   965,   965,   965,   965,   965,   965,   965,   965,
     965,   965,   965,   966,   966,   967,   967,   967,   967,   967,
     967,   967,   967,   967,   967,   967,   967,   967,   967,   967,
     967,   967,   967,   967,   967,   967,   967,   967,   967,   967,
     967,   967,   967,   967,   967,   967,   967,   967,   967,   967,
     967,   967,   967,   967,   967,   967,   967,   967,   967,   967,
     967,   967,   967,   967,   967,   967,   967,   967,   967,   967,
     967,   967,   967,   967,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   969,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   971,   971,   972,   972,
     972,   972,   973,   974,   974,   975,   975,   976,   976,   977,
     977,   977,   978,   978,   978,   978,   979,   979,   980,   980,
     981,   982,   982,   982,   983,   984,   984,   985,   985,   986,
     986,   986,   987,   987,   988,   988,   988,   988,   988,   989,
     989,   989,   990,   990,   990,   991,   991,   992,   992,   992,
     992,   992,   992,   992,   992,   992,   993,   993,   994,   994,
     995,   995,   995,   995,   995,   995,   996,   996,   997,   997,
     998,   998,   999,   999,  1000,  1000,  1000,  1001,  1001,  1002,
    1002,  1003,  1003,  1003,  1003,  1003,  1003,  1003,  1003,  1004,
    1004,  1005,  1006,  1006,  1007,  1007,  1007,  1007,  1007,  1007,
    1008,  1009,  1010,  1010,  1010,  1011,  1011,  1012,  1013,  1013,
    1014,  1015,  1015,  1016,  1016,  1017,  1017,  1018,  1018,  1018,
    1018,  1019,  1019,  1020,  1020,  1021,  1021,  1022,  1022,  1023,
    1023,  1024,  1025,  1025,  1026,  1026,  1026,  1026,  1027,  1027,
    1028,  1028,  1029,  1029,  1030,  1031,  1032,  1033,  1034,  1035,
    1036,  1036,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1038,  1039,  1040,
    1040,  1040,  1040,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,  1041,
    1041,  1041,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1043,  1043,  1043,  1043,
    1043,  1043,  1043,  1043,  1043,  1043,  1043,  1043,  1043,  1043,
    1043,  1043,  1043,  1043,  1043,  1043,  1043,  1043,  1044,  1044,
    1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,
    1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,
    1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,
    1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,
    1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,
    1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,
    1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,  1044,
    1044,  1044,  1045,  1045,  1046,  1046,  1046,  1046,  1046,  1046,
    1046,  1046,  1048,  1047,  1049,  1050,  1050,  1050,  1050,  1051,
    1051,  1051,  1051,  1052,  1052,  1053,  1054,  1055,  1055,  1056,
    1056,  1056,  1057,  1057,  1058,  1058,  1059,  1059,  1060,  1060,
    1060,  1060,  1061,  1061,  1061,  1062,  1063,  1063,  1064,  1064,
    1065,  1065,  1065,  1065,  1066,  1066,  1067,  1068,  1069,  1070,
    1070,  1071,  1072,  1072,  1073,  1073,  1073,  1073,  1073,  1075,
    1074,  1076,  1077,  1078,  1078,  1079,  1079,  1079,  1079,  1080,
    1080,  1082,  1081,  1084,  1083,  1085,  1083,  1083,  1086,  1086,
    1087,  1087,  1087,  1088,  1088,  1088,  1088,  1089,  1089,  1090,
    1090,  1090,  1090,  1090,  1090,  1091,  1091,  1091,  1092,  1094,
    1093,  1095,  1096,  1095,  1097,  1097,  1098,  1098,  1099,  1099,
    1100,  1100,  1100,  1100,  1100,  1100,  1100,  1100,  1100,  1101,
    1101,  1101,  1101,  1101,  1101,  1101,  1101,  1101,  1101,  1102,
    1102,  1103,  1103,  1104,  1105,  1105,  1106,  1106,  1106,  1107,
    1108,  1109,  1109,  1109,  1109,  1110,  1110,  1110,  1111,  1111,
    1112,  1112,  1113,  1114,  1114,  1115,  1115,  1116,  1116,  1117,
    1117,  1118,  1119,  1119,  1120,  1120,  1120,  1121,  1121,  1121,
    1121,  1121,  1121,  1121,  1121,  1121,  1122,  1122,  1122,  1122,
    1122,  1123,  1123,  1124,  1125,  1126,  1127,  1127,  1128,  1129,
    1130,  1130,  1131,  1132,  1132,  1133,  1134,  1135,  1135,  1136,
    1137,  1138,  1138,  1139,  1140,  1140,  1140,  1140,  1140,  1141,
    1141,  1141,  1141,  1141,  1141,  1141,  1141,  1141,  1141,  1141,
    1141,  1141,  1141,  1141,  1142,  1142,  1143,  1143,  1144,  1144,
    1144,  1146,  1145,  1147,  1147,  1149,  1148,  1150,  1150,  1150,
    1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,  1152,
    1152,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1153,  1153,  1153,  1153,  1154,  1154,  1154,  1154,  1154,
    1154,  1155,  1155,  1155,  1155,  1155,  1155,  1155,  1156,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1158,  1158,  1158,
    1158,  1158,  1158,  1158,  1159,  1159,  1159,  1159,  1159,  1159,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1161,  1161,  1161,  1161,  1161,  1162,  1162,  1162,  1162,
    1163,  1163,  1163,  1163,  1163,  1163,  1163,  1164,  1164,  1164,
    1165,  1165,  1165,  1165,  1165,  1165,  1166,  1166,  1167,  1168,
    1168,  1169,  1169,  1170,  1171,  1172,  1173,  1173,  1173,  1174,
    1175,  1176,  1177,  1178,  1178,  1178,  1178,  1178,  1179,  1180,
    1180,  1180,  1181,  1181,  1182,  1182,  1182,  1183,  1183,  1184,
    1184,  1185,  1185,  1186,  1186,  1186,  1186,  1186,  1187,  1187,
    1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,
    1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,
    1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,
    1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,
    1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,
    1187,  1187,  1187,  1187,  1188,  1188,  1188,  1188,  1189,  1189,
    1189,  1189,  1189,  1189,  1189,  1189,  1189,  1190,  1190,  1190,
    1190,  1190,  1191,  1191,  1192,  1192,  1193,  1193
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     5,     1,     0,     2,     0,     2,     0,
       2,     2,     3,     3,     1,     3,     3,     2,     1,     1,
       2,     2,     2,     3,     3,     5,     5,     0,     3,     5,
       5,     4,     3,     5,     3,     5,     5,     6,     1,     1,
       3,     5,     6,     4,     1,     0,     2,     0,     1,     1,
       1,     1,     1,     1,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     2,     5,     2,     2,     2,     2,     3,
       3,     3,     1,     3,     1,     3,     1,     1,     2,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     3,     6,
       1,     1,     1,     1,     1,     0,     1,     1,     2,     3,
       4,     3,     2,     2,     1,     3,     4,     5,     4,     2,
       4,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       4,     4,     4,     4,     1,     3,     2,     3,     4,     6,
       6,     6,     5,     5,     6,     6,     4,     8,     2,     3,
       6,     4,     3,     3,     3,     3,     3,     4,     4,     3,
       3,     3,     3,     3,     3,     4,     4,     3,     2,     3,
       2,     2,     3,     3,     2,     2,     1,     3,     2,     1,
       1,     0,     2,     0,     2,     0,     3,     2,     0,     1,
       3,     3,     1,     5,     3,     4,     1,     3,     4,     6,
       4,     8,     2,     2,    10,     6,     1,     1,     1,     1,
       1,     1,     3,     2,     0,     1,     1,     3,     3,     1,
       1,     3,     3,     3,     3,     4,     2,     1,     0,     2,
       0,     3,     0,     1,     0,     1,     3,     2,     1,     1,
       1,     3,     0,     1,     3,     1,    11,    14,    10,    13,
       1,     1,     2,     2,     2,     2,     1,     0,     1,     0,
       3,     0,     1,     3,     1,     3,     1,     1,     1,     1,
       1,     3,     4,     2,     0,     3,     1,     1,     2,     2,
       1,     3,     4,     4,     2,     5,     1,     2,     2,     2,
       3,     3,     3,     0,     1,     1,     1,     1,     1,     1,
       3,     1,     5,     7,     3,     8,     4,     9,    11,     3,
       0,     1,     3,     1,     2,     2,     2,     0,     1,     3,
       3,     6,     4,     0,     1,     1,     2,     2,     0,     3,
       3,     2,     1,     1,     2,     2,     4,     0,     2,     2,
       2,     0,     3,     4,     4,     0,     2,     0,     4,     0,
       3,     5,     3,     0,     1,     3,     1,     2,     3,     0,
       5,     4,     1,     0,     1,     2,     2,     1,     2,     3,
       2,     2,     2,     2,     3,     3,     1,     3,     1,     0,
       1,     2,     1,     1,     3,     6,    10,     1,     0,     1,
       2,     2,     0,     2,     2,     1,     0,     5,     7,     1,
       0,     6,     2,     0,     3,     5,     5,     8,     2,     0,
       2,     2,     2,     5,     2,     0,     2,     7,    10,     6,
       6,     6,     6,     7,     7,     9,     9,     6,     6,     8,
       8,     8,     8,     6,     6,     7,     8,     6,     6,     7,
       2,     2,     2,     2,     1,     2,     1,     0,     6,     8,
       7,     6,     4,     0,     1,     3,     4,     1,     3,     1,
       2,     2,     2,     2,     1,     1,    10,     2,     0,     2,
       2,     1,     0,     4,     6,     5,     4,     4,     8,    11,
       3,     2,     1,     3,     1,     5,     8,     1,     1,     1,
       7,     9,     8,    15,    20,     1,     1,     2,     1,     3,
       1,     1,     1,     3,     1,     3,     0,     1,     0,     1,
       1,     4,     0,     1,     3,     0,     1,     1,     1,     1,
       2,     0,     0,     2,     2,     1,     2,     2,     2,     6,
       8,     8,     4,     5,     4,     4,     4,     3,     7,     8,
       6,     6,     6,     6,     4,     5,     3,     1,     3,     3,
       1,     1,     1,     1,     1,     1,     3,     3,     3,     1,
       3,     3,     1,     0,     1,     3,     6,     8,     8,    13,
       1,     3,     5,     6,     4,     7,     2,     1,     0,     2,
       0,     2,     4,     0,     1,     0,     6,     8,     8,     1,
       3,     5,     5,     7,     9,     7,     9,     5,     6,     6,
       4,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     3,     3,     3,     3,     1,     3,     1,     2,
       2,     3,     5,     2,     2,     0,     6,     7,     7,     7,
       8,     8,     6,     8,     9,     9,     7,    10,     7,     8,
       8,     8,     8,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     1,     3,
       1,     1,     8,     9,     9,     9,     9,     2,     0,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     3,     4,     5,     4,     5,     3,     4,     3,     4,
       1,     2,     3,     3,     3,     3,     4,     4,     3,     3,
       4,     4,     4,     4,     1,     1,     1,     0,     7,     7,
      10,     1,     1,     2,     4,     5,     1,     3,     2,     2,
       2,     2,     1,     2,     2,     4,     3,     2,     2,     2,
       3,     2,     2,     5,     5,     5,     1,     3,     1,     2,
       3,     0,     1,     3,     2,     6,     6,     9,     3,     0,
       3,     0,     5,     2,     0,     3,     3,     3,     7,     7,
      10,     1,     1,     1,    14,     1,     0,     1,     0,     1,
       0,     2,     0,     1,     3,     5,     5,     7,     2,     0,
       1,     2,     0,     1,     1,     0,     1,     1,     0,     9,
      12,     7,     2,     0,     3,     2,     1,     3,     3,     2,
       1,     3,     3,     3,     2,     2,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     4,     5,     1,     3,     3,
       1,     2,     4,     5,     1,     1,     1,     1,     3,     3,
       2,     2,     2,     2,     1,     2,     2,     1,     1,     1,
       3,     2,     0,     2,     1,     3,     5,     1,     2,     1,
       0,     5,     7,     5,     7,     5,     7,     3,     5,     5,
       5,     1,     3,     2,     1,     2,     1,     2,    11,    10,
      10,     2,     2,     0,     9,     2,     0,     4,     4,     4,
       1,     1,     1,     0,     7,     6,     6,     6,     6,     6,
       7,     9,     9,     6,     6,     6,     6,     6,     7,     8,
       9,     8,     6,     6,     6,     5,     5,     8,     8,     8,
       8,     6,     9,     1,     0,     2,     0,     7,     6,     6,
       6,     6,     6,     7,     9,     9,     6,     8,     8,     8,
       8,     6,     6,     7,     6,     7,     6,     6,     6,     6,
       6,     7,     7,     7,     9,     9,     6,     6,     6,     8,
       8,     8,     6,    13,     1,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     1,     0,     6,     8,     3,     2,     0,     2,     2,
       2,     2,     3,     3,     2,     2,     2,     2,     3,     2,
       5,     4,     3,     3,     3,     1,     1,     0,     3,     2,
       2,     1,     2,     1,     3,     2,     1,     0,     8,    10,
       3,     4,     4,     0,     2,     5,     2,     0,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     4,     3,     3,     1,     0,     5,     6,     4,     2,
       0,     4,     3,     5,     6,     4,     6,     6,     5,     7,
       1,     0,     6,    11,    11,    11,    13,     9,    11,    10,
       4,     2,     5,     2,     0,     4,     5,     5,     4,     6,
       1,     3,     1,     1,     1,     1,     2,     4,     1,     1,
       1,     0,     1,     0,     1,     0,     3,     0,     2,     4,
       3,     5,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     2,     1,     1,     1,     1,     1,     0,     5,     4,
       3,     0,     1,     1,     1,     1,     4,     8,     3,     0,
       6,     1,     4,     2,     1,     3,     2,     3,     0,     7,
       2,     0,     5,     3,     0,     2,     2,     2,     3,     1,
       3,     1,     2,     1,     0,     8,     1,     3,     1,     1,
       3,     5,     2,     1,     3,     7,     1,     1,     0,     3,
       2,     2,     2,     0,     2,     2,     1,     1,     3,     3,
       1,     2,     4,     4,     2,     3,     5,     5,     1,     1,
       9,     1,     2,     4,     4,     4,     2,     3,     1,     3,
       6,     1,     0,     2,     1,     0,     3,     3,     4,     4,
       4,     4,     3,     2,     1,     1,     0,     1,     1,     0,
       1,     5,     1,     0,     1,     0,     3,     1,     3,     4,
       3,     2,     2,     1,     1,     1,     0,     2,     4,     5,
       2,     3,     1,     1,     1,     1,     3,     0,     1,     1,
       1,     1,     1,     3,     0,     2,     0,     1,     3,     1,
       0,     1,     2,     4,     4,     2,     0,     2,     3,     2,
       0,     1,     3,     1,     2,     1,     2,     5,     6,     5,
       1,     2,     1,     4,     3,     4,     5,     4,     5,     4,
       5,     2,     4,     1,     2,     2,     2,     1,     1,     0,
       4,     2,     1,     2,     2,     4,     1,     3,     1,     2,
       3,     1,     2,     0,     2,     4,     0,     1,     0,     1,
       3,     3,     2,     3,     5,     6,     2,     3,     3,     4,
       0,     1,     1,     1,     1,     1,     2,     5,     1,     1,
       1,     1,     2,     3,     3,     0,     1,     1,     1,     1,
       1,     2,     2,     2,     2,     2,     1,     3,     0,     1,
       1,     1,     1,     5,     2,     1,     1,     1,     1,     5,
       2,     2,     2,     1,     3,     3,     2,     1,     0,     3,
       0,     5,     2,     5,     2,     1,     2,     3,     0,     1,
       1,     1,     1,     1,     1,     3,     3,     3,     3,     3,
       3,     3,     0,     1,     4,     1,     3,     3,     5,     2,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     2,     2,     3,     3,     2,     3,     5,     4,     6,
       3,     5,     4,     6,     4,     6,     5,     7,     3,     2,
       4,     2,     3,     3,     4,     3,     4,     3,     4,     5,
       6,     6,     7,     6,     7,     6,     7,     3,     4,     4,
       6,     2,     3,     4,     1,     3,     2,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     2,
       5,     6,     6,     7,     3,     4,     1,     1,     2,     4,
       1,     1,     1,     2,     2,     2,     1,     4,     5,     6,
       8,     6,     7,     7,     5,     1,     1,     4,     1,     4,
       1,     4,     1,     4,     1,     1,     1,     1,     1,     1,
       6,     4,     4,     4,     4,     6,     5,     5,     5,     4,
       6,     4,     4,     4,     4,     5,     7,     7,     9,     5,
       4,     6,     5,     7,     7,     7,     2,     3,     3,     3,
       4,     0,     4,     1,     3,     3,     1,     1,     1,     2,
       2,     0,     2,     4,     4,     6,     2,     0,     1,     3,
       3,     2,     2,     0,     6,     1,     0,     3,     0,     2,
       2,     0,     1,     4,     2,     2,     2,     2,     2,     4,
       3,     5,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     1,     4,
       1,     4,     1,     2,     1,     2,     1,     3,     1,     3,
       1,     3,     1,     3,     3,     3,     2,     1,     3,     3,
       0,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       3,     2,     3,     0,     3,     3,     2,     2,     1,     0,
       2,     2,     3,     2,     1,     1,     3,     5,     1,     2,
       4,     2,     0,     1,     0,     1,     2,     2,     2,     3,
       5,     1,     2,     0,     2,     1,     0,     1,     1,     1,
       3,     3,     1,     3,     3,     2,     1,     1,     1,     3,
       1,     2,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     2,     5,     2,
       3,     6,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     2,     4,     3,     2,     1,     1,     1,
       1,     1,     0,     8,     2,     5,     3,     2,     2,     3,
       7,     1,     1,     1,     0,     2,     2,     1,     0,     1,
       3,     1,     2,     0,     2,     0,     2,     0,     1,     3,
       4,     3,     1,     1,     1,     1,     2,     0,     2,     4,
       0,     2,     2,     2,     1,     1,     7,     3,     1,     1,
       1,     1,     2,     0,     1,     3,     3,     3,     3,     0,
       4,     5,     5,     0,     1,     1,     1,     2,     2,     1,
       2,     0,     7,     0,     5,     0,     4,     2,     2,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     5,     2,     1,     3,     2,     2,     3,     0,
       5,     1,     0,     5,     2,     2,     1,     1,     1,     2,
       2,     3,     1,     2,     2,     3,     3,     4,     2,     1,
       2,     1,     1,     2,     2,     3,     1,     1,     1,     1,
       0,     1,     3,     5,     0,     2,     0,     1,     2,     3,
       2,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       2,     2,     3,     0,     1,     2,     1,     4,     3,     4,
       3,     2,     1,     3,     1,     1,     1,     1,     2,     2,
       1,     2,     2,     1,     1,     1,     4,     4,     4,     4,
       4,     1,     0,     3,     3,     4,     1,     3,     3,     4,
       1,     3,     3,     1,     1,     1,     6,     1,     3,     3,
       6,     1,     3,     3,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     4,     4,     1,     1,     4,     4,
       3,     0,     7,     1,     0,     0,     7,     3,     4,     3,
       1,     1,     1,     2,     3,     5,     2,     5,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     1,     0,
       1,     2,     1,     2,     1,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     1,     2,     1,
       3,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     3,     2,     3,     1,     3,
       3,     3,     3,     3,     3,     1,     1,     0,     2,     2,
       1,     1,     2,     1,     1,     1,     0,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
    2212,     0,     2,     1,  2642,  2646,  2650,  2651,  2568,  2652,
    2653,  2618,  2619,  2620,  2621,  2622,  2623,  2624,  2625,  2626,
    2627,  2628,  2629,  2631,  2630,  2632,  2633,  2634,  2635,  2636,
    2637,  2638,  2639,  2641,  2640,  2590,  2219,  2587,  2584,  2585,
    2586,  2591,  2589,  2582,  2583,  1827,  2655,  2643,  2656,  2644,
    2645,  2647,  2648,  2617,  2649,  2657,  2658,  2659,  2654,  2662,
    2613,  2614,  2612,  2615,  2616,  2660,  2661,  2604,  2605,  2606,
    2607,  2663,  2220,  2221,  2609,  2213,  2217,  2279,  2350,  2610,
    2611,  2608,  2218,  2603,  2350,     0,  2471,  2472,  2473,     0,
    2474,  2475,  2476,  2402,  2364,  2477,     0,     0,  2478,  2479,
    2480,  2481,  2482,  2483,  2484,  2485,     0,  2486,  2487,  2488,
    2489,  2349,  2490,  2491,  2492,  2493,  2494,  2326,  2332,  2455,
       0,  2306,  2307,  2303,  2305,  2304,  2308,  2291,  1117,   520,
    1199,  1198,     0,  2116,  1117,  2072,  2073,  2117,  2074,  2075,
    2076,   245,     0,  1201,  2077,     0,  1117,  2118,   348,   913,
    2119,  2120,  2234,     0,  2078,  2079,     0,     0,     0,   520,
    1117,     0,     0,  2080,  1312,  2081,     0,  2082,  2121,  2122,
       0,  2083,  2123,  2124,  2084,  2085,  2086,  2125,  2126,  2127,
    2087,  2128,  2129,     0,     0,  1326,     0,  2088,  2130,  2089,
    2090,     0,  2131,  2091,  2092,  2093,  2132,  2133,  2134,  2094,
    2095,  2096,     0,  2097,     0,     0,     0,     0,     0,  2135,
    1117,  2098,     0,     0,  1333,     0,  2099,     0,  2136,  2100,
       0,  2101,     0,  2102,  2103,  2104,  2105,  1326,  2451,  2327,
       0,  1203,     0,  2106,  2137,     0,  2107,  2108,  2109,  2110,
    2111,  2112,  2113,  2114,  2115,     0,     0,    54,    55,    21,
      20,    26,    25,    77,    78,    44,    14,    68,    49,   110,
     109,   111,    32,    28,    62,    18,    19,    29,    33,    51,
      50,    17,    48,    72,    52,    75,    39,     8,     9,    40,
      66,    10,    41,    67,    11,    42,    12,    56,    79,    24,
      53,    76,    35,    64,    60,     7,    45,    46,    47,    69,
      70,    71,    93,    74,   105,    31,   102,    83,    84,    99,
      85,   100,     5,    86,    43,    13,    96,    95,    97,    63,
      36,    65,    94,    98,    15,    16,   101,    73,    91,    88,
     106,   104,   112,    89,    57,     3,     4,    80,    38,     6,
      23,    22,    37,    30,   108,    27,  1201,    82,    92,    81,
      87,    61,    90,   107,    59,   103,  1299,  1286,  1335,  1298,
    1311,     0,  1301,  2547,  2548,    34,  1312,   114,   115,   120,
    2216,  2268,  2269,  2270,  2350,  2301,  2302,  2295,  2311,  2321,
    2310,  2314,  2322,  2309,  2328,     0,   117,   119,   121,   124,
     118,   113,   116,   123,   128,   122,   127,   125,   126,   129,
     130,   131,  2549,  1512,  2546,    58,  2286,  2285,     0,  2350,
       0,  2495,  2496,  2497,  2498,  2499,  2500,  2550,  2551,  2552,
    2553,  2554,  2556,  2555,  2579,  1833,  1834,  1835,  1836,  1837,
    1838,  1839,  1840,  1841,  1842,  1843,  1844,  1845,  1846,  1847,
    1848,  1849,  1850,  1851,  1852,  1853,  1854,  1855,  1856,  1857,
    2522,  1858,  1859,  1860,  1861,  1862,  1863,  1864,  1865,  1866,
    1867,  1868,  2559,  1869,  1870,  1871,  1872,  1873,  1874,  1875,
    1876,  1877,  1878,  1879,  2560,  1880,  1881,  1882,  1883,  1884,
    1885,  1886,  1887,  1888,  1889,  1890,  1891,  1892,  1893,  1894,
    1895,  1896,  1897,  1898,  1899,  1900,  1901,  1902,  1903,  1904,
    1905,  1906,  1907,  1908,  1909,  1910,  1911,  1912,  1913,  1914,
    1915,  1916,  1917,  1918,  1919,  2561,  1920,  1921,  1922,  1923,
    1924,  1925,  1926,  1927,  1928,  1929,  1930,  1931,  1932,  1933,
    1934,  1935,  1936,  1937,  1938,  1939,  1940,  1941,  1942,  1943,
    1944,  1945,  1946,  1947,  1948,  1949,  1950,  1951,  1952,  2562,
    1953,  1954,  2563,  1955,  1956,  1957,  1958,  1959,  1960,  1961,
    1962,  1963,  1964,  1965,  1966,  1967,  1968,  1969,  1970,  1971,
    1972,  1973,  1974,  1975,  1976,  1977,  1978,  1979,  1982,  1980,
    1981,  1983,  1984,  1985,  1986,  1987,  1988,  1989,  1990,  1991,
    1992,  1993,  1994,  1995,  1996,  1997,  1998,  1999,  2000,  2001,
    2002,  2003,  2004,  2005,  2006,  2007,  2008,  2009,  2010,  2011,
    2012,  2013,  2564,  2014,  2015,  2016,  2017,  2018,  2019,  2020,
    2021,  2022,  2023,  2024,  2025,  2026,  2027,  2028,  2029,  2030,
    2031,  2032,  2033,  2034,  2035,  2036,  2037,  2038,  2039,  2040,
    2041,  2234,  2042,  2043,  2044,  2045,  2046,  2047,  2048,  2049,
    2050,  2051,  2052,  2053,  2054,  2055,  2056,  2057,  2058,  2059,
    2523,  2060,  2061,  2062,  2063,  2064,  2065,  2066,  2067,  2068,
    2069,  2565,  2070,  2071,  2252,  2557,  2519,  2227,  2248,  2520,
    2469,  2470,  1828,  2521,  2518,  2558,  2254,  2575,  2253,  2517,
    2401,     0,     0,  2363,  2362,  2366,  2365,  2367,  2360,  2361,
    1805,  2255,  2371,  2370,  1276,  2574,  1804,  1277,     0,  2373,
    2501,  2502,  2503,  2504,  2506,  2505,  2507,  2138,  2139,  2140,
    2141,  2142,  2143,  2144,  2145,  2146,  2147,  2148,  2149,  2532,
    2150,  2151,  2152,  2545,  2153,  2154,  2533,  2155,  2156,  2157,
    2158,  2159,  2160,  2161,  2162,  2163,  2164,  2165,  2166,  2167,
    2168,  2169,  2170,  2171,  2172,  2173,  2174,  2175,  2176,  2177,
    2178,  2534,  2535,  2179,  2180,  2181,  2182,  2183,  2184,  2185,
    2186,  2187,  2188,  2189,  2190,  2191,  2192,  2193,  2194,  2195,
    2196,  2197,  2198,  2199,  2200,  2201,  2536,  2202,  2203,  2537,
    2204,  2205,  2206,  2538,  2207,  2208,  2209,  2210,  2211,  2542,
    2543,  2544,  2531,  2324,  2508,  2530,  2541,  2539,  2540,  2334,
    2330,  2338,  2333,     0,     0,     0,     0,  2350,  1116,  1115,
    1101,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   519,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2224,     0,  1127,
     323,   322,  1200,  1181,   520,     0,  1104,   347,     0,     0,
       0,     0,     0,     0,     0,     0,   697,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   175,     0,     0,   371,
     370,     0,     0,     0,   885,   376,     0,     0,     0,     0,
     508,  2233,  2228,  2238,     0,  2231,  2232,  2517,     0,  2666,
    1980,  2264,  2265,  2664,  2027,  1278,   246,   249,   247,   248,
       0,   983,   984,   986,     0,     0,   996,   728,   729,     0,
     727,   731,     0,     0,     0,   724,     0,     0,     0,     0,
     730,   722,     0,   721,     0,     0,     0,   726,     0,   723,
       0,     0,  1105,     0,  2316,  2317,  1922,  1239,   377,     0,
       0,  1312,     0,  1201,  1208,  1218,  1213,  1215,  1214,  1216,
    1212,  1217,  1834,   827,  1848,   827,  1912,   824,   825,   827,
     827,   827,  1995,     0,     0,   799,     0,   810,  1829,   827,
    1830,  2575,   832,   430,   430,   430,     0,   831,   836,   430,
    1098,  1134,  1809,  1325,     0,  1848,  1912,   800,  1097,  2042,
    1231,     0,     0,  1000,     0,  1001,     0,  2010,  1109,   232,
    2515,  2019,  2102,  2042,  2516,   228,  2510,  2511,  2513,   202,
    2514,  2512,  2509,  1838,     0,     0,   831,     0,  1106,  1107,
     788,  1332,  1330,     0,     0,     0,  1856,     0,  1869,  1947,
     225,  2006,  2011,  2019,  2102,  2042,  2069,   184,     0,   239,
    2019,  2102,  2042,     0,  1127,     0,  1302,  1412,  1800,     0,
       0,  2325,  1100,  1099,  1202,     0,  1205,     0,  1377,  1992,
    1306,  1308,  1207,  1299,     0,     0,  2215,  1196,  1329,  1329,
       0,  1329,     0,  1291,  1299,  1294,  1298,     0,     0,     0,
       0,  1117,     0,  2293,  2321,  2300,  2356,  2297,     0,     0,
    2346,  2342,  2339,  2347,  2348,  2341,  2329,  1501,  1502,  1503,
    1500,  1513,  1499,     0,  2274,  1504,  2313,  2280,     0,  2288,
    2287,  2592,  2593,  2403,  2226,  2245,     0,     0,     0,     0,
       0,     0,     0,  2372,  2374,  2376,  2336,  2335,  2331,     0,
       0,     0,     0,  2461,  2462,  2460,     0,  2457,  2459,     0,
    2356,     0,  2526,  2520,  2529,     0,  1810,  2521,  2518,  2517,
       0,   738,     0,   135,   874,     0,     0,     0,  1804,     0,
       0,     0,     0,     0,     0,     0,  1705,  1860,  1908,  1715,
    1713,  1714,  1707,  1708,  1709,  1710,  1711,  1712,     0,   981,
    1706,     0,   135,     0,     0,     0,     0,     0,     0,     0,
       0,  1950,   135,     0,     0,     0,  1121,     0,     0,     0,
    1123,  1126,  1102,  1184,     0,  1800,     0,     0,   772,   763,
       0,   773,   764,   769,   775,     0,     0,   766,     0,     0,
     776,     0,   765,   767,   778,   768,   774,     0,     0,   770,
     771,     0,     0,  1113,   430,     0,     0,     0,     0,     0,
       0,   135,  1171,  1921,   135,     0,     0,   375,   374,   135,
     373,   372,  1860,  1908,     0,   912,   135,     0,   177,   588,
     523,     0,     0,   657,  1950,   135,     0,     0,     0,     0,
     888,     0,     0,   507,   520,     0,  2237,  2243,     0,  2235,
    2404,  2667,  2665,  2359,     0,   987,   226,   227,   985,  1921,
       0,   301,     0,     0,  1921,  1162,     0,   725,  1921,     0,
    1921,   170,  1802,  1860,  1908,  1921,     0,     0,  1921,   162,
    1921,     0,  1921,   301,  1921,   524,     0,  1921,     0,  1921,
    1950,   164,     0,  1921,   301,   736,     0,     0,  2597,  2601,
       0,  2599,  2594,  2315,  2369,  2368,  2267,     0,  2677,     0,
    1278,  1210,  2523,  1224,  1223,     0,  1219,  1227,  1222,  1312,
     827,   826,     0,   827,     0,  2686,   827,     0,   827,     0,
    2686,   827,     0,     0,     0,   827,  1831,  1832,     0,     0,
    2685,  2683,  2684,   801,   811,     0,   833,     0,     0,   840,
     839,   838,     0,     0,     0,   841,  1416,  1254,     0,   808,
       0,   806,     0,  1095,  1112,     0,     0,     0,     0,  1003,
    1003,  1003,  1108,   231,   229,     0,     0,     0,     0,     0,
       0,  1114,     0,     0,     0,     0,  2581,  1816,  1716,  2580,
       0,  2073,  2074,  2075,  1774,     0,  2522,  2076,  2077,  1628,
    1615,  1624,  1629,  1616,  1618,  1625,  2078,  2079,  1893,  2080,
    2081,  1823,  2082,  2083,  1456,  2085,  2086,  2087,  1620,  1622,
    2088,  2089,     0,  1824,  2091,  2092,  1968,  2094,  2095,  2097,
    2098,  1626,  2100,  2101,  2102,  2103,  2104,  2105,  1822,     0,
    1627,  2106,  2108,  2109,  2110,  2111,  2112,  2113,  2114,  2115,
       0,     0,  1797,     0,  1602,     0,  1448,  1449,  1471,  1472,
    1450,  1477,  1478,  1490,  1451,     0,  1796,  1515,  1601,  1606,
       0,  1600,  1596,  1315,  1792,     0,  1597,  1812,  1775,  1826,
    1825,  2575,  1783,  1815,  1813,  1814,     0,     0,     0,   195,
       0,     0,  2450,   241,     0,   242,  1798,  2019,   185,   224,
     197,   223,   198,   196,     0,  1858,   186,     0,   193,     0,
       0,     0,     0,     0,     0,     0,   235,  1103,     0,  1414,
    1413,     0,     0,  1781,  1801,   745,     0,  1194,  1195,  1193,
       0,  1190,  1192,  1204,  1201,  1788,  1787,  1789,     0,  1307,
       0,     0,     0,  1289,  1288,  1207,  1327,  1328,     0,     0,
       0,     0,     0,     0,     0,     0,  1370,  1343,  1344,  1346,
    1367,  1371,     0,  1295,     0,     0,  1418,     0,  1378,  2214,
    2356,  2357,     0,  2351,     0,  2350,  2350,  2344,  2343,  2340,
       0,     0,     0,     0,     0,     0,     0,  2271,   502,  2273,
     500,     0,     0,  2247,     0,  2251,  2249,     0,  2396,  2399,
       0,  2397,  2398,  2400,     0,  2405,  2406,     0,     0,     0,
    2588,     0,     0,  2387,  2375,  2382,  2384,  2386,  2385,  2394,
    2390,  2393,  2395,  2337,  2350,  2468,     0,  2463,  2466,     0,
    2458,     0,     0,     0,  1811,     0,     0,     0,     0,   739,
       0,     0,     0,     0,     0,     0,   134,  1160,   234,  1158,
       0,     0,     0,     0,     0,  1165,     0,   168,   169,   535,
     520,     0,     0,     0,     0,     0,   945,     0,     0,     0,
       0,     0,     0,   946,   944,   947,   954,   967,   970,     0,
     864,     0,     0,     0,  1034,     0,     0,  1034,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   251,
     254,   296,     0,     0,     0,     0,     0,     0,     0,     0,
     139,     0,     0,     0,     0,   487,   499,     0,     0,     0,
       0,     0,   496,     0,   135,   252,   481,   484,     0,     0,
     597,   596,  1034,     0,   250,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     315,   316,     0,     0,     0,   139,   161,     0,     0,   253,
       0,  2281,     0,  1122,  1119,  1120,     0,  1125,     0,  1180,
       0,     0,     0,     0,     0,   777,     0,     0,  1860,  1908,
       0,     0,     0,     0,     0,     0,   350,   329,   330,   135,
     328,     0,     0,   654,     0,  1459,  1488,  1466,  1488,  1488,
    1455,  1455,  1468,  1457,  1495,     0,  1488,  1455,  1460,     0,
    1458,  1498,  1498,  1483,     0,  1440,  1441,  1442,  1443,  1469,
    1470,  1444,  1475,  1476,  1445,  1512,  2527,  1455,  2528,  2525,
    2524,     0,     0,   664,     0,  1137,  1170,     0,     0,   529,
       0,  1921,     0,   137,   698,     0,   655,     0,   137,     0,
     173,     0,   592,     0,     0,     0,     0,     0,     0,   616,
     615,     0,     0,     0,   656,     0,   137,   483,  1921,     0,
     473,   430,     0,   887,   890,     0,     0,     0,  2241,  2236,
    2239,     0,  2229,  2243,  1281,  1283,  1282,     0,  1280,     0,
     301,   299,   300,   652,   995,     0,     0,     0,     0,   301,
       0,     0,  1921,     0,  1921,     0,     0,   301,   301,     0,
       0,     0,     0,   593,     0,   735,   733,   732,   734,     0,
       0,     0,     0,     0,  1921,   301,     0,     0,   720,  2595,
       0,     0,  2598,     0,  2318,  1726,     0,  2680,  1236,  2681,
       0,     0,  1312,     0,   213,   214,   212,  1225,   215,  1226,
    1221,  1209,     0,   819,     0,  2686,  2687,   804,     0,   814,
       0,  2686,   802,     0,   815,   812,   813,     0,     0,     0,
    2682,  2566,  2572,   818,     0,     0,   431,   433,     0,     0,
    1879,     0,  1913,  1939,  1940,  2011,  2015,     0,  2037,     0,
     842,   869,   837,     0,     0,  1264,   809,   807,  1096,  1229,
    1732,     0,  1312,     0,  1002,   999,   998,   997,   230,   203,
       0,     0,     0,   871,  2010,  1111,   787,   520,     0,     0,
    1604,  1605,  1487,  1474,  1773,     0,     0,  1482,  1481,     0,
       0,     0,     0,  1464,  1463,  1462,  1603,  1740,     0,  1461,
       0,     0,     0,     0,  1488,  1488,  1486,  1535,     0,  1465,
       0,     0,  1753,     0,  1759,     0,     0,     0,  1494,     0,
    1492,     0,     0,  1571,     0,     0,     0,     0,     0,     0,
       0,     0,  1519,  1520,  1602,  1726,     0,  1819,     0,     0,
    1480,     0,  1512,  1716,     0,     0,     0,     0,  1786,     0,
    1724,     0,     0,  1549,  1722,     0,  1551,     0,     0,     0,
    1715,  1713,  1714,  1707,  1708,  1709,  1710,  1711,  1712,  1720,
    1532,     0,  1795,     0,  1531,     0,     0,  1380,  1314,     0,
    1817,  1776,     0,  2573,  2576,  1598,  2447,  2446,  2445,  2444,
    2415,     0,  2409,  2410,     0,  2448,  2449,   243,   244,   240,
       0,     0,   200,   199,     0,   221,   222,   192,   220,     0,
     216,   217,  1668,  1667,   201,   191,   189,   187,   204,   206,
     207,   190,   188,   238,   236,     0,     0,     0,  1778,  1777,
    1807,  1782,     0,     0,   301,  2350,  1188,     0,  1185,  1791,
       0,  1309,     0,     0,  1197,  1305,  1304,  1336,  1337,   905,
    1303,  1361,  1362,  1357,     0,  1376,  1376,  1353,  1347,  1352,
    1350,     0,  1354,  1515,  1369,  1293,  1341,  1342,  1345,  1292,
       0,  1372,  1370,  1346,  1251,     0,     0,  1419,     0,     0,
    2358,  2356,  2296,  1440,  2350,  2289,  2350,  2345,  2277,  1506,
    1507,  1508,  1509,  1510,  1511,  2278,     0,  2275,  1505,  2276,
     501,     0,     0,     0,  2244,     0,  2225,  2250,  2381,  2490,
    2413,     0,  2414,     0,     0,  2378,     0,  2388,  2391,  2389,
    2392,     0,  1440,  2569,  2464,  2569,  1440,     0,     0,     0,
       0,     0,     0,     0,     0,   740,     0,     0,     0,     0,
       0,     0,  2037,   233,  1156,     0,     0,     0,     0,   873,
     872,     0,     0,   892,     0,     0,     0,  1168,   421,     0,
     298,     0,     0,     0,     0,     0,     0,   533,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   567,  1034,     0,   605,     0,   952,
       0,     0,     0,     0,   953,   950,   951,  2011,   969,   968,
     966,   927,   929,   928,     0,   931,   915,     0,   916,     0,
       0,   926,   934,   932,     0,     0,     0,  1901,   256,   268,
       0,  1033,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   288,     0,   291,   290,     0,     0,     0,     0,
     295,     0,     0,     0,   294,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   982,     0,     0,   156,   159,     0,
       0,   486,   498,     0,   490,   491,   488,   492,   493,     0,
       0,     0,     0,     0,     0,   485,     0,   590,   589,   595,
       0,     0,     0,     0,     0,  1026,  1025,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   607,   608,     0,   609,     0,   160,     0,     0,     0,
       0,     0,     0,   211,  1118,  1124,  1183,  1808,  1182,     0,
       0,     0,   779,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   334,
       0,   679,  2524,   653,     0,  1440,     0,  1436,  1432,  1501,
    1500,  1499,     0,  1446,  1455,  1452,   665,     0,   667,   670,
       0,  1135,   394,     0,   526,   567,     0,     0,     0,   166,
       0,     0,     0,   133,   177,   377,     0,   176,   178,   180,
     181,   182,   179,   183,   587,   591,     0,   522,     0,     0,
       0,     0,     0,   617,   621,   620,   624,   622,     0,   618,
       0,  1428,     0,   155,   480,   482,     0,  2222,     0,   379,
     461,     0,     0,     0,   889,     0,     0,     0,     0,     0,
    2242,     0,     0,     0,     0,  1279,     0,   973,     0,  1163,
    1921,   301,     0,   971,   171,  1803,     0,     0,     0,     0,
       0,   975,   717,   163,     0,   301,   301,   525,     0,   301,
     165,     0,     0,     0,   517,   301,   737,  2596,  2602,  2600,
    1238,     0,  2678,  2679,   473,  1283,  1211,  1220,   816,   823,
     805,   822,   821,   803,   820,   817,  2380,     0,     0,  2571,
       0,   834,     0,   429,     0,     0,     0,   848,     0,     0,
     847,   862,   849,     0,   851,   844,   843,   852,     0,     0,
     871,     0,  1261,     0,  1259,     0,  1417,  1263,  1252,  1230,
       0,  1228,  1233,  1235,  1234,  1232,     0,     0,     0,   831,
       0,     0,   301,  1110,     0,   789,   794,     0,     0,     0,
     791,   792,   793,   795,   796,     0,     0,     0,  1736,     0,
    1737,     0,     0,     0,  1772,  1768,     0,     0,     0,     0,
       0,  1744,  1745,  1746,  1743,  1747,  1742,     0,     0,  1748,
    1741,     0,     0,     0,     0,     0,  1485,  1484,     0,     0,
       0,     0,     0,     0,     0,  1574,  1606,     0,     0,  1700,
       0,  1726,  1758,     0,     0,  1496,     0,     0,     0,     0,
       0,     0,     0,  1726,  1764,     0,     0,     0,     0,  1666,
       0,  1663,     0,     0,     0,     0,  1783,     0,     0,     0,
       0,  1820,  1516,  1533,  1794,     0,  1785,     0,     0,  1517,
    1540,     0,  1765,  1567,     0,  1572,  1555,     0,  1548,     0,
    1553,  1557,  1536,  1786,  1725,     0,  1723,     0,     0,  1534,
       0,  1529,  1527,  1528,  1521,  1522,  1523,  1524,  1525,  1526,
    1530,  1704,  1702,  1703,     0,     0,     0,  1552,  1915,  1947,
       0,  1326,  1326,  1326,  1313,  1324,  1793,     0,  1423,     0,
       0,     0,     0,  1683,     0,  1730,     0,  1728,  1810,  2578,
    2577,  1784,     0,     0,     0,  1799,     0,     0,  1512,     0,
     237,  1415,  1779,     0,   743,   744,   742,  1440,  1207,  1191,
    1187,  1186,  1790,  1206,  1312,     0,   903,   904,     0,   908,
       0,     0,  1355,  1368,     0,  1264,  1264,     0,  1359,  1360,
    1351,  1297,  1296,     0,  1426,     0,     0,  1248,  1241,  1420,
       0,  1380,  1266,  1268,  1269,     0,  1783,  2294,  2352,  2299,
    2320,  2290,  2323,  1514,  2272,  2312,     0,  2246,  2416,  2417,
       0,  2407,  2408,  2377,  2383,  2454,     0,  2570,     0,     0,
     677,   676,     0,     0,     0,  1056,  1005,  1038,   741,  1057,
    1006,  1039,  1058,  1007,  1157,     0,  1159,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   642,   301,  1166,  1059,   297,  1167,  1040,  1041,     0,
     534,     0,     0,   539,   540,   541,     0,     0,   542,  1860,
    1908,     0,   547,   553,   557,   548,     0,   558,   554,     0,
       0,     0,     0,     0,   564,   566,     0,     0,     0,     0,
       0,   948,   949,  1060,  1008,     0,  1042,   930,  1455,   914,
       0,     0,   925,     0,   924,  1455,  1455,  1009,   167,   257,
     394,  1036,   274,   287,   282,   283,   281,  1921,   301,  1921,
     301,     0,     0,     0,     0,   284,   279,   280,   276,   289,
    1837,  1894,  2020,     0,   577,   579,     0,   584,   292,  1017,
       0,   309,   312,   293,   272,   275,   273,   269,   255,     0,
       0,  1806,     0,     0,   977,     0,     0,     0,   158,  1022,
       0,     0,   144,     0,     0,     0,     0,   138,   148,  1066,
    1013,   489,   494,  1015,   497,  1051,   495,  1072,  1014,     0,
    1046,  1068,  1024,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1172,     0,     0,     0,     0,     0,   301,     0,
     686,  1036,  1921,   301,  1067,     0,  1031,  1054,     0,   317,
       0,  1023,  1016,  1052,     0,     0,   209,   208,   210,     0,
       0,     0,     0,     0,     0,     0,     0,   781,   752,   780,
       0,     0,     0,     0,     0,     0,     0,   746,   349,   326,
     327,     0,     0,   325,   331,   678,     0,     0,     0,  1437,
    1433,     0,     0,     0,     0,     0,     0,  1453,   666,     0,
       0,     0,     0,  1155,  1155,  1155,  1155,  1155,  1155,  1155,
    1136,  1164,   135,     0,     0,     0,   528,   566,   573,     0,
     601,   604,     0,   602,     0,     0,     0,     0,     0,   149,
     136,     0,   706,   430,   172,     0,     0,     0,   521,   663,
     661,   660,   662,     0,     0,     0,   683,     0,  1427,  1429,
       0,     0,     0,     0,   381,     0,     0,   378,   382,   386,
     387,   388,     0,   474,   476,     0,     0,   465,     0,     0,
       0,   919,     0,   937,   920,     0,     0,     0,   957,   962,
     958,   940,     0,   505,  2240,  2234,  1284,  1285,     0,   301,
       0,     0,   568,   301,     0,   301,     0,   301,   301,     0,
    1093,   594,     0,   649,     0,     0,   301,   719,  1727,     0,
       0,  2379,  2567,   835,   432,     0,     0,     0,     0,   846,
       0,   503,   850,     0,   861,   856,   858,     0,   865,  1262,
    1255,  1257,  1256,     0,     0,  1253,  1733,   718,     0,     0,
     301,     0,   866,     0,   790,     0,     0,     0,     0,  1331,
    1734,  1735,     0,     0,     0,     0,  1769,     0,     0,  1641,
    1617,  1619,  1454,  1631,     0,  1467,  1642,  1643,  1621,  1623,
       0,  1717,     0,     0,  1632,  1576,  1577,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1589,  1588,  1633,  1699,     0,     0,  1756,  1757,  1634,  1497,
    1498,  1498,     0,     0,  1763,     0,     0,     0,  1639,  1644,
       0,     0,     0,     0,  1650,     0,  1671,     0,     0,     0,
    1599,  1727,  1489,  1490,     0,     0,     0,     0,     0,     0,
       0,     0,  1573,  1556,  1550,     0,  1554,  1558,     0,     0,
       0,     0,  1542,  1568,  1538,     0,     0,  1544,     0,  1569,
    1326,  1326,  1326,  1326,  1323,     0,     0,     0,     0,  1390,
    1379,  1381,  1392,  1383,  1385,  1421,     0,  1800,     0,  1364,
    1335,  1335,     0,  1683,     0,  1607,     0,  1683,     0,     0,
    2429,  2431,  2432,  2433,  2434,  2435,  2437,  2438,  2440,  2441,
    2442,  2430,  2436,  2439,  2443,  2420,  2421,     0,  2411,  2412,
     194,     0,   218,   205,     0,  2454,  1189,     0,  1338,     0,
    1718,   908,   906,   907,  1340,     0,     0,  1375,  1374,  1373,
    1348,  1250,     0,  1248,  1243,     0,  1244,  1783,     0,  1240,
    1273,     0,     0,  1426,     0,  1272,     0,  2354,  2282,     0,
       0,  2453,  2456,  2467,  2465,  2292,  1055,  1004,  1037,  1155,
     876,   877,     0,   875,     0,     0,     0,   420,   891,     0,
       0,     0,   642,     0,     0,   424,  1169,   536,   537,     0,
       0,   555,     0,     0,   544,     0,     0,     0,     0,   543,
     560,   509,   561,   563,     0,   562,   565,   570,  1018,     0,
    1053,   942,     0,  1455,   917,   922,   923,     0,   391,     0,
       0,     0,   258,     0,     0,   271,     0,   266,   285,   277,
     286,   278,   581,   582,   580,   576,     0,   583,   585,   306,
       0,     0,     0,  1062,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1063,  1043,     0,     0,   141,
     140,     0,   147,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   318,
     303,     0,     0,     0,     0,     0,   320,     0,     0,  1061,
    1010,   747,     0,     0,   748,   756,     0,     0,   749,     0,
       0,     0,     0,     0,     0,   758,   352,     0,   355,   362,
     335,   339,  1171,     0,  1171,     0,   340,  1171,   336,  1171,
     333,   680,     0,  1968,  1707,  1708,   674,   681,   671,   673,
     672,   675,   642,     0,     0,     0,  1438,     0,  2668,  2676,
    2675,     0,  1512,   668,   669,     0,  1155,  1154,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   406,
       0,     0,   400,     0,     0,   962,   393,   396,   397,   529,
     532,   530,   531,     0,   559,     0,   600,     0,   573,   151,
       0,     0,   152,   150,     0,     0,   377,     0,     0,   623,
     626,   619,     0,   682,   684,   658,     0,   573,     0,  1239,
     479,     0,   461,   413,   457,     0,   472,     0,   459,   458,
     460,     0,   467,  1133,     0,   892,   918,     0,     0,     0,
     955,   959,   956,     0,     0,   933,     0,   941,   911,  1088,
    1089,  1086,  1087,     0,     0,  2257,  1275,  2266,   974,     0,
     301,   972,     0,   713,     0,   715,   976,   301,   301,   610,
       0,   518,   476,     0,     0,     0,     0,   845,   863,     0,
     859,     0,     0,   828,   868,  1260,  1258,   871,     0,   829,
     870,     0,     0,     0,     0,     0,  1738,  1473,     0,  1771,
    1767,     0,  1739,     0,  1751,  1750,  1575,  1752,     0,  1594,
       0,     0,  1586,  1584,  1585,  1578,  1579,  1580,  1581,  1582,
    1583,  1587,  1761,  1760,  1754,  1755,  1493,  1491,     0,  1636,
    1637,  1638,  1762,  1645,     0,  1851,  1672,  1649,  1665,  1664,
       0,     0,     0,  1652,     0,     0,  1661,     0,  1701,  1479,
    1512,  1518,     0,     0,  1541,  1766,  1559,     0,     0,     0,
    1537,     0,     0,     0,     0,  1546,  1717,     0,     0,     0,
       0,     0,     0,  1317,  1316,  1322,  1299,     0,  1392,     0,
    1391,  1403,     0,     0,  1409,  1407,     0,  1409,     0,  1409,
       0,  1384,     0,  1386,  1403,     0,  1801,  1422,     0,  1366,
       0,     0,  1334,     0,  1683,  1614,  1686,  1681,  1682,  1731,
    1608,  1818,     0,  1729,  1683,     0,     0,     0,  1780,  2452,
    1310,     0,  1339,  1356,  1349,     0,  1424,  1249,     0,     0,
    1246,     0,     0,     0,  1267,  1248,  1270,  2298,     0,  2353,
    2418,  2419,     0,   882,   883,   881,     0,     0,     0,   642,
       0,     0,   438,     0,   899,   899,     0,     0,   426,   470,
     962,   645,     0,     0,   643,     0,   556,     0,     0,   552,
     550,   549,   551,   510,  1071,     0,   943,     0,   935,     0,
     263,  1035,     0,     0,     0,   262,     0,   301,   301,   578,
     310,   311,   314,     0,     0,     0,     0,     0,     0,   707,
     690,     0,     0,   708,   709,     0,     0,     0,   979,   980,
     978,   145,   142,   143,   146,  1019,     0,     0,     0,     0,
       0,  1070,  1030,  1050,  1069,  1028,  1048,  1027,  1047,  1029,
    1049,  1021,     0,  1431,   688,   687,     0,   301,   301,   612,
       0,   750,     0,     0,   751,   762,   760,   759,   761,   753,
     353,   135,     0,   332,     0,   360,     0,   358,   357,   359,
       0,   346,     0,     0,     0,     0,     0,   651,     0,     0,
       0,  1434,     0,     0,     0,     0,     0,     0,  1439,  1447,
     641,     0,  1146,  1145,  1144,  1148,  1147,  1150,  1149,  1141,
    1140,  1153,  1152,  1139,  1138,  1143,  1142,     0,   398,     0,
     404,   408,   409,   407,   399,   962,   430,   469,   527,     0,
       0,   603,   598,   154,   153,     0,     0,     0,     0,   628,
     632,   659,     0,  1430,   606,     0,   379,  1237,     0,  2223,
       0,   384,   389,   390,     0,   465,   410,     0,   461,   383,
     475,     0,     0,   471,     0,  1128,     0,     0,   921,   938,
     939,     0,     0,   962,   961,     0,   512,     0,  2230,   301,
     569,   301,   301,  1094,   650,     0,   855,   854,   853,   504,
       0,   857,   301,     0,     0,     0,     0,     0,   798,   782,
     797,  1770,  1630,  1640,  1749,     0,     0,  1595,     0,     0,
    1635,  2107,     0,     0,     0,     0,  1669,  1670,  1651,     0,
    1959,  1656,     0,     0,     0,  1821,  1565,  1563,  1560,     0,
    1561,     0,     0,  1543,  1539,     0,  1545,  1570,  1321,  1320,
    1319,  1318,  1394,  1401,     0,  1382,     0,  1408,  1404,     0,
    1405,     0,     0,  1406,     0,     0,  1401,     0,     0,     0,
       0,  1677,  1683,  1683,  1609,  1688,  1685,     0,  1611,  2422,
       0,  2425,  2423,  2424,  2428,  1512,     0,     0,  1242,  1245,
    1247,     0,  1274,  1265,  2355,  1161,     0,     0,     0,   422,
       0,   962,     0,     0,     0,   902,   902,     0,   962,   469,
     647,   646,   644,   648,     0,   545,   546,  1020,   936,   259,
     260,   261,   264,   303,   270,   265,     0,  1064,  1011,  1044,
       0,     0,   696,     0,     0,     0,     0,  1065,  1012,  1045,
       0,     0,     0,  1177,     0,   302,   303,   319,  1032,     0,
     754,   755,   334,     0,   356,   365,     0,   363,   337,   342,
       0,   344,   343,   338,   341,  1435,     0,   993,   993,  2669,
    2670,  2671,  2672,  2673,  2674,     0,   642,  1151,     0,     0,
     395,   469,   437,     0,   401,     0,   574,     0,     0,  1133,
     379,   573,   627,     0,     0,     0,   685,   381,     0,   477,
       0,   380,     0,     0,   467,     0,     0,     0,   465,     0,
     462,     0,   466,     0,     0,     0,     0,     0,   960,     0,
     964,     0,   932,   909,  1423,     0,   516,  2256,  2260,   994,
     714,   716,   611,   860,   867,   301,   783,   784,   785,   786,
    1590,     0,     0,     0,     0,  1646,     0,  1647,  1674,  1673,
    1653,  1657,     0,  1654,  1655,  1562,  1566,  1564,  1547,  1393,
       0,     0,  1395,     0,     0,  1397,  1399,     0,     0,     0,
       0,     0,  1804,  1683,  1363,  1365,     0,  1300,  1612,  1613,
       0,  1335,  1683,  2427,  2426,   219,  1719,  1425,  1271,   861,
       0,   301,   899,   469,   439,  1968,   440,   898,     0,   900,
     905,   905,     0,   469,   642,   538,   305,   313,     0,     0,
     703,   691,     0,     0,   710,     0,     0,     0,     0,     0,
     301,   757,   324,   351,   361,     0,   345,   993,     0,   990,
     989,   640,     0,   403,   402,     0,   448,     0,   572,     0,
     573,   700,  1129,   586,   629,   630,   625,     0,     0,   461,
     457,   478,   385,   394,   368,   419,   418,   415,   414,   416,
     417,   412,   411,     0,   467,   463,   464,     0,  1130,     0,
    1179,     0,   893,   963,     0,     0,     0,   511,     0,     0,
     515,   506,     0,  2258,   830,  1591,     0,  1592,     0,     0,
       0,  1659,  1658,     0,  1402,  1411,     0,  1398,  1396,  1387,
       0,  1389,  1676,  1678,     0,     0,  1691,  1610,   878,     0,
     879,   902,   443,     0,   901,   908,   908,   430,   642,   423,
       0,   267,     0,   694,     0,   705,   703,     0,     0,  1173,
       0,  1174,  1175,  1178,   321,   364,   988,   992,   991,     0,
     434,   435,   436,     0,   405,   444,   445,     0,   575,   599,
       0,     0,     0,     0,   465,   461,   392,   456,   366,  1131,
    1132,   308,     0,   962,   965,  1092,   514,   513,  2261,  2263,
    2262,     0,  1593,  1662,  1648,  1675,  1660,  1400,     0,  1388,
       0,     0,  1687,     0,     0,     0,     0,   905,     0,   642,
       0,   896,   895,   437,   425,   304,     0,     0,   701,   704,
     692,   705,   712,   711,     0,     0,     0,     0,     0,   446,
       0,   447,   468,   699,     0,   631,     0,   467,   465,     0,
     467,   894,   910,  1091,  1090,  1312,  2259,  1410,  1679,  1680,
    2072,     0,  2047,     0,  1689,  1692,  1690,  1684,   301,   908,
       0,   427,   441,   448,     0,     0,   693,  1176,   632,   453,
       0,   452,     0,   450,   449,   689,   635,   369,   467,   307,
    1423,  1074,  1312,  1073,  1075,  1083,  1080,  1082,  1081,  1079,
       0,  1696,  1695,  1694,  1698,  1697,   880,   897,     0,   642,
     695,   702,     0,   451,   455,   454,     0,   633,   636,   639,
     637,   638,   367,   884,     0,  1084,  1078,  1299,  1286,     0,
     442,   428,     0,   613,     0,  1076,  1312,  1693,     0,   634,
    1077,     0,   635,     0,   614
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,   246,   247,  1687,  2549,  2437,  3209,  3210,   248,
     249,  1751,   250,   251,   252,   253,   254,   255,   256,  1700,
     257,   258,  1267,  1890,  2557,   259,  2323,  1048,  2197,  2198,
    2494,  2199,  2187,  1540,  1988,  1688,  1716,   261,   262,  1534,
    2179,   263,   264,   265,  1739,  1740,  1695,  1933,  4073,  4631,
    2424,  4730,  3060,  3061,   266,  1790,  1791,   267,   268,  3161,
    1829,  3163,  3164,  3680,   858,  2518,  4091,  4092,  3667,  3668,
    4098,  4366,  4367,   269,  1887,  3236,  3762,  3237,  4170,  3238,
    4171,  3239,  4172,  3191,  3726,  3727,  3728,  3240,  4176,  4571,
    3241,  2338,  1389,  2015,  2016,  4546,  3991,  3992,  4699,  4654,
    4655,  4656,  4763,  4178,  3247,  3772,  4183,  4394,  2971,  1909,
    2590,  3242,  3243,  4169,   270,   271,  2584,  1766,  1767,  2443,
    3686,  3302,   272,  1284,  3560,  4436,  4590,  4591,   273,   846,
     274,  1894,   275,   276,  2544,  3196,   277,  2347,  2980,   278,
     279,  3004,  3005,  3006,   280,   281,  3734,  4395,  1741,  3053,
    3054,  3055,  3056,  3597,   282,  1892,  1771,  2566,   283,   284,
     285,  2548,  3202,  3203,   286,   287,  2483,   288,   289,   290,
    1902,  2578,  2579,  4160,  4403,  4556,  4405,  4796,  4797,  4386,
    3545,  4004,   291,   292,   293,   294,  1873,  2537,  2538,  3687,
    1673,  1833,  2520,  2521,  3752,  3753,   295,   296,  4039,  4040,
     888,  4661,  4635,  4710,   297,   298,  4043,  4044,   299,   300,
     301,   302,   303,   941,  1334,  1335,  1679,   304,  2214,   305,
    1242,  3148,   306,  1424,  2716,  4219,   307,   975,  1361,  1362,
     308,   309,   986,  2699,   988,  2029,  3304,  3305,  3823,  2670,
    1171,   310,   311,  2680,  2702,   312,  1690,  2329,  2330,  3986,
     313,   889,  1914,  2593,  2966,  4581,  3993,  4315,  4510,  2889,
    3494,   314,   890,  1720,  2387,  2596,  3252,  3253,  2389,  2854,
    3784,  2391,  3254,  3259,  3260,  3261,  3780,  3788,  4430,  4431,
     315,  1718,  2380,   316,   317,   318,  1746,  1188,   319,   911,
     912,   320,  4539,   321,  1303,   322,  1006,  2045,   323,  2402,
    3583,   324,   325,   326,  4773,  4804,  4805,  4806,  3793,  4735,
     327,  4775,  1403,   329,   330,   331,   849,  1210,  1211,  1212,
     332,  4185,   333,   334,  2541,  3190,  3708,   335,   336,  2324,
    2956,   337,   338,   339,  1877,   340,   341,   342,   343,  1809,
     344,  1570,  1571,   345,   346,   853,  1066,  1574,  1582,   347,
     954,  1355,  1356,  1357,  1990,   348,  1407,  2691,   955,  1348,
     956,  2907,  3505,  3506,  3509,   957,  2904,   352,  2035,  2685,
    2688,   958,  2911,  2912,  2913,  2914,  2915,  3511,   959,   977,
    1294,  2604,   960,  1494,   357,   358,   359,  1075,  1070,  1071,
     361,  2157,  2844,   994,  1588,  1033,  1082,  3942,  2227,  2228,
    2248,  2249,  1597,  1598,  2238,  2240,  2891,  2241,  2900,  2233,
    3939,  4281,  2244,  2245,  1600,  1601,  2895,   362,  2848,  3440,
    3441,  3442,  3920,  3930,  4268,  4475,  3443,  1397,  1607,  3444,
    3449,  3503,  3227,  3228,  3229,  2392,  2528,  1855,  1495,  1856,
    2535,  1496,  2079,  1858,  1497,  1498,  1499,  1861,  1500,  1501,
    1502,  1503,  2063,  2120,  1504,  1505,  2098,  1114,  1115,  1975,
    2754,  1507,  1508,  3886,  4243,  4232,  2780,  2781,  2194,  3882,
    3392,  4487,  4612,  4613,  3950,  3947,  4285,  4491,  4695,  4744,
    4745,  1509,  2834,  2149,  1190,  1510,  3689,  2151,  2774,  2856,
    2857,  2308,  2061,  2721,  2737,  2738,  2751,  3353,  2758,  2763,
    3376,  3377,  2775,  2803,  1511,  2724,  2725,  3337,  2065,  1512,
    1563,  1564,  2165,  2798,  1577,  1578,  1068,  1513,  1514,  2030,
    1057,  4471,  1312,   696,  3070,  2209,  1214,   991,  1515,  1516,
    1517,  3306,  1628,   675,   676,  1152,   800,     2,    75,   961,
    3233,   366,   367,   892,   893,   894,  1286,  1287,  1919,  1922,
    1633,  2286,   677,   678,   705,  4198,  4437,  4593,   947,   368,
     369,   370,   371,  1629,  2282,  1116,    76,    84,    77,  1117,
     408,   409,  2264,   372,   817,   373,  1610,  1096,  3517,   374,
     375,   376,   377,   378,   944,   379,  1098,   380,  1099,   381,
     382,   383,   384,  1106,   385,  1612,  1613,  3979,  1614,   386,
     387,   698,   699,  1346,   388,   389,  1133,  1134,  1380,  1381,
    1639,  1654,  1655,  1656,   390,   692,   391,   392,   393,  1645,
    1646,   394,  2172,  2173,  2291,  2174,   395,  2928,  2929,   396,
    3475,  3476,  4292,  3477,   397,  2168,   398,   399,  1060,  3522,
     400,   813,   401,  1147,   679,   680,   681,  1154,   803,  1019,
     706,  1156,  3057,   805,   806,   683,   684,   685,  2010,    78,
    2936,  2011,  1519,   707,  1520,  2163,  1521,  1522,  1523,  1524,
    1525,  1662,   689,  1123,  1338,  1339,  2937,  1341,    82,  1342,
     405,  3701,  1978,  1382,  1996,  1997
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -4227
static const int yypact[] =
{
   -4227,   361, 10165, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, 21325, -4227,
   -4227, -4227, -4227, -4227, 96238,   755, -4227, -4227, -4227, 60866,
   -4227, -4227, -4227,   251, 66124, -4227, 69470,   954, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, 73294, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, 53684,  1276, -4227,
     348, -4227, -4227, -4227, -4227, -4227, -4227, -4227,   -93,  8071,
   -4227, -4227, 69948, -4227,    37, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, 70426,   587, -4227,   762,  1037, -4227,    72,  7535,
   -4227, -4227, 61822, 67080, -4227, -4227, 73772,   581,  2217,  8755,
     -93, 20844, 74250, -4227,  2046, -4227, 50296, -4227, -4227, -4227,
   66602, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, 80464,  2590,   811, 50783, -4227, -4227, -4227,
   -4227, 80464, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, 74728, -4227,   905,   737, 80942, 81420, 63734, -4227,
    1577, -4227, 80464,  1289,  1382, 52726, -4227, 81898, -4227, -4227,
    1349, -4227, 75206, -4227, -4227, -4227, -4227,   811, -4227, 53684,
   47877,   134,  1231, -4227, -4227, 82376, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227,  1569,  1359, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227,   587, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227,   230, -4227,  1441,   671,
    1258,   105,  1412, -4227, -4227, -4227, 15799, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, 97663,   304, -4227, -4227, -4227,  1372,
   -4227,  1383, -4227, -4227, -4227,  1502, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227,  1076, -4227, -4227, -4227, -4227,  1934, 96713,
   73294, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, 61344, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,   154, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, 73294, 73294, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, 73294,  1484,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,   406,
    1739, -4227, -4227, 53684,  2337,  2337,  2003, 97663, -4227, -4227,
   -4227, 54642, 80464, 80464, 80464,  1743, 80464, 80464,   567, 54642,
   80464, 80464,  1745, 43481, -4227, 80464, 80464, 80464, 80464, 75206,
   80464,  1741, 80464, 80464, 82854, 80464,  1884, -4227,  2169,  1486,
   -4227, -4227, -4227, 80464,  5100,  2590, -4227, -4227, 80464,  1750,
   54642, 80464,  1686, 80464,  1778, 80464, -4227, 80464, 83332,   576,
    1841, 80464,  1929, 43972,  1853, 80464, 80464, 80464, 80464, -4227,
   -4227,  1852, 80464, 80464, -4227, -4227, 83810,  1409,  2088,  2041,
     539, -4227, -4227,  2197,  1791, -4227, -4227,  2230, 73294, -4227,
   70904, -4227, -4227, -4227,  2032, -4227, -4227, -4227, -4227, -4227,
   64212,  2217, -4227, -4227, 55121, 80464,  2065, -4227, -4227, 84288,
   -4227, -4227,   640, 55600, 84766, -4227, 44463,  2253, 85244, 85722,
   -4227, -4227, 86200, -4227, 86678,  1937, 87156, -4227, 87634, -4227,
    2107, 88112, -4227, 22261, -4227,  1883,   299,  1893,   607, 73294,
   73294,   538, 39134,   587, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227,   191,   130, 51270,   917, 51757, -4227, -4227,  1267,
    1331,  1352,   191,  2324,  2324,    34, 73294, -4227, -4227,   130,
   -4227,   669,   -63,  1925,  1925,  1925,  2093,   -90, -4227,  1925,
   -4227, -4227, -4227, -4227, 75206, 51270, 51757, -4227,  1927,  2590,
      15,  2308, 80464, -4227, 80464, -4227, 80464, 80464, -4227, -4227,
   -4227,  2322,  1972,  2203, -4227,  1984, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227,  2172,  2196,  2180,   125,  2590,  2133, -4227,
    2272, -4227,  2222, 26859,   -94, 73294,  2590, 52244, 75684, 94326,
     323, 64212,  2590, 88590,  2073,  1486,  2241, -4227,   430, -4227,
    2463,  2101,  2326,   560,  1486, 41062, -4227,  2106,  1657, 75206,
   98138, -4227, -4227, -4227, -4227,   243,  2378, 27355, -4227, 80464,
    2104, -4227,  2138,  2159,  2162,  1258, -4227, 80464,  1517,  1517,
    2552,  1517,  1618,  1698, -4227,  1843, -4227,  2462,  2434, 75206,
    1231,   -93,  2189, -4227, -4227, -4227,  2220, -4227,  2198,  2219,
   -4227,   425,  2470, -4227, -4227, -4227, -4227,  2306,  2313,  2317,
    2325,  2266,  2335,   139, -4227, -4227, -4227, -4227,  2579, -4227,
   -4227, -4227, -4227, -4227, -4227,  2683,  2667, 61822, 61822,    66,
     496,   118,   244, -4227, -4227, -4227,  2536, -4227, -4227,  2535,
   80464,  2379, 80464, -4227, -4227, -4227, 89068, -4227, -4227,  2337,
    2220,  2310, -4227,   333, -4227,  1657, -4227,   351,   397,   408,
     849,  2311,  1659,  1508, -4227,   172,  2421,   106,   -96,  2348,
   75206,  4974,  2328,   179,  2556,   139, -4227, 80464, 80464, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,  2333, -4227,
   -4227,  2364,  1495,   859,  3648,   872,  4147,  1915,   557,  2528,
    1232,  2634,  1786,  5677, 80464,  2404, -4227,  2604,  2708,   599,
   -4227,   591, -4227,  2449,  2595,  1033, 54642,  2431, -4227, -4227,
   80464, -4227, -4227, -4227, -4227,   662, 54642, -4227,  2603, 44954,
   -4227, 80464, -4227, -4227, -4227, -4227, -4227,  2542, 80464, -4227,
   -4227,  2658, 80464, -4227,  1925,   804,  2435,  2801, 57995,    85,
   80464,  2479,  2834,  2650,  2479,  2480, 89546, -4227, -4227,  2479,
   -4227, -4227, 80464, 80464,  2465,  1693,  2479,  2851,  2854,  2549,
    2643,   609,  1109,    79,  2764,  2479, 80464, 90024, 80464, 80464,
    2852, 54642, 80464, -4227,  2656, 76162, -4227,  2506,  2197, -4227,
   -4227, -4227, -4227, -4227,  1503, -4227, -4227, -4227, -4227,  2802,
    2310,   297,  2804,  2512,  2806, -4227,  2545, -4227,  2811,  2328,
    2812,  2521, -4227, 90502, 90980,  2815,  2333, 80464,  2817,  2521,
    2818,  2710,  2823,   297,  2825, -4227,   738,  2828,  2718,  2830,
    1458,  2521, 64690,  2831,    93, -4227, 22350, 22261, -4227, 22910,
     943, -4227, -4227, -4227, -4227, -4227, -4227, 30827,   537,  2626,
   -4227, -4227,  1231, -4227, -4227,  1867, -4227, 49809, -4227,   538,
     130, -4227, 73294,   130, 73294,    34,   130, 73294,   130, 73294,
      34,   130, 73294, 73294, 73294,   130, -4227, -4227,  1355,  1563,
   -4227, -4227, -4227, -4227, -4227, 73294,  2544, 80464, 80464, -4227,
   -4227, -4227, 67558, 80464, 68036, -4227, -4227,   155, 73294, -4227,
   73294, -4227,  2590, -4227, -4227,   299, 57995,  2938, 80464,  2824,
    2824,  2824, -4227, -4227, -4227,  2769, 80464,  2832,  2833, 67558,
   80464, -4227, 91458, 64212,  2730,  2553, -4227, -4227, -4227, -4227,
    1871,  2682,   419,  2696, 30827,  2560,   175,   175,  2561, -4227,
   -4227, -4227,   442,  2562,  2563, -4227,   458,   458,  2719,  2565,
    2566, -4227,   500,  2567, -4227,  2711,   517,  2569,  2570,  2572,
    1950,   175, 30827, -4227,  2574,   458,  2575,  2576,  2577,  2783,
    2578, -4227,  2803,  2580,   342,   369,  2581,  2582, -4227,  2565,
   -4227,   377,  2583,  2584,  2585,  2587,  2588,  2591,  2592,  2593,
   30827, 30827, -4227, 25867, -4227,  2590, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227,    59, -4227,   542,  5359, -4227, -4227,  2724,
   30827, -4227, -4227,   194, -4227,   577, -4227, -4227,  1657, -4227,
   -4227,  1213, -4227, -4227, -4227, -4227,  1866,  1866,   169, -4227,
   69948, 69948, -4227, -4227,   148,  2594, -4227,  1744, -4227, -4227,
   -4227, -4227, -4227, -4227, 62300,  2982, -4227,   934,   591,   186,
    2931, 48835, 49322,  2829,  2829,  2814, -4227, -4227, 80464, -4227,
   -4227, 30827, 46919, -4227,  1657,    77,  2836, -4227, -4227, -4227,
    1899, -4227, -4227, -4227,   587, -4227, 14916, -4227,  1918,  2104,
   80464, 80464,  2993, -4227, -4227,  2138, -4227, -4227,  1258,  1258,
   30827,  1258,    98,  1378, 27851, 30827,  2884,  2787,   582,  1483,
    2887, -4227,  1618,  1698, 75206, 80464, 91936,  2715, -4227, -4227,
    2220,  2618,  1766, -4227, 59910, 97188, 97188,  2853, -4227, -4227,
    1311,   818,  2727,  2816,  2324,  1161,  1386, -4227, -4227,  2613,
   -4227,  2939, 69948,  2672, 61822, -4227, -4227, 80464, -4227, -4227,
   76640, -4227, -4227, -4227,  1994,  2617, -4227,  2636, 80464,  3107,
   -4227,  1386,  1386, -4227, -4227,  2621, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, 97663,  2625, 80464, -4227,  2627,  2628,
   -4227, 98138, 47398,  1660,  1657,  2699,  2702,  2747, 53684,  2630,
    2706,  2707,  2753,  2716,  2717, 94804, -4227, -4227, -4227, -4227,
    1348,   340,  1302,  2721,   579, -4227,  2754, -4227, -4227, -4227,
    4715, 80464,  6110,  2819,   139,  2759, -4227,  2722,  2723,  2840,
     139,   987, 95282, -4227, -4227, -4227, -4227, -4227,  2284, 24405,
   -4227,  2728,  2720, 62778,  3016,  2841,  1087,  1857,   330, 80464,
    2910,  2848, 80464,  2668,  2746,  2749,  2674,  1732,  3027,  2678,
   -4227, -4227,  2847,  2736,  2737, 57037,    -1, 45445,  3014,  2763,
   -4227,  1471,  2772,  2775,   139, -4227,  3071,   139,   139,  1291,
    3078,  2777,   145,  1610,  2479,  2678,  1478, -4227,  2778,  1755,
   -4227,  2880,   133,  1809,  2678,  2782,  2784,  2674,  2674, 80464,
   80464, 80464, 80464, 80464,    90,  3096,  3099,  2790,    96,  2835,
    2725, -4227, 71382,  2792, 94326, -4227, -4227,  2794,  1942,  2678,
    1306, -4227,  1726, -4227, -4227, -4227,  1486, -4227, 80464, -4227,
   80464,  2310, 57995,  2892,  2755, -4227,  2328,   139, 80464, 80464,
    2333,  1262,   897,  2900, 80464,  2955,  2760, -4227, -4227,  2479,
   -4227, 47398,  2465, -4227,  2733, -4227,  2770, -4227,  2770,  2770,
    2734,  2734,  2735, -4227, -4227,  1950,  2770,  2734, -4227, 58953,
   -4227,  1634,  1711, -4227,  3129,  3131, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227,  1296, -4227,  1892, -4227, -4227,
   -4227, 80464, 53684, -4227,  3143, -4227, -4227, 57995,  3032, -4227,
   80464,  2936,  2745, -4227,  3066,  2799, -4227,  2788, -4227, 80464,
     203,  2590,  2791, 80464,  2961, 80464, 80464, 80464, 80464, -4227,
   -4227,  2934,   632,   114, -4227, 71382, -4227,  1478,  2945,  3146,
     525,  1925,  3034, -4227, 80464,  2757,  3150,  2985, -4227, -4227,
    2758,  2324, -4227,  2506, -4227,  1865, -4227,  2877, -4227, 54642,
     297, -4227, -4227, -4227, -4227, 57995, 80464, 92414, 54642,   297,
   80464, 80464,  3052,  2821,  3053,  2826, 45445,   297,   109, 80464,
   80464, 80464, 80464, -4227, 80464, -4227, -4227, -4227, -4227, 80464,
   80464, 80464, 71382,  3055,  3056,   297, 80464, 80464, -4227, -4227,
   22821,  1712, -4227, 22261, -4227, 14916,  1921,  2829, -4227,  1484,
   80464,  1522,   538, 68514, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, 73294, -4227, 73294,    34, -4227, -4227, 73294, -4227,
   73294,    34, -4227, 73294, -4227, -4227, -4227, 73294, 80464,  3257,
    2773, -4227,  1213, -4227, 80464,  1944, -4227, -4227,  1947,   670,
   80464,    88, 54642, 80464,  2956, 80464, 80464, 80464, 80464,  2845,
    2594,  1068, -4227,   494, 75206,  2963, -4227, -4227, -4227, -4227,
   -4227,  1979,  1569,   427, -4227, -4227, -4227, -4227, -4227, -4227,
   68036, 66602,  3051,   224, 80464, -4227, -4227,  1112, 30827, 26363,
   -4227, -4227, -4227,  2779, 14916,  2827, 30827, -4227, -4227, 30827,
    2324,  2324, 30827, -4227, -4227, -4227, -4227,  1555,  2324, -4227,
   30827, 30827,  2324,  2324,  2770,  2770, -4227,  3950, 30827, -4227,
   45445, 30827, 32315, 23908, 30827,  2855,  2800,  2324, -4227,  2324,
   -4227, 30827, 25371, -4227, 30827,  2986, 33307, 30827,   186,  2988,
   30827,   186,  3202,  3202,   927,  6247,  2789, -4227,  2896,  2324,
   -4227,  2324,   386,   166, 57995, 30827, 53684,  2868,   117, 80464,
   30827,  2795,  1856, -4227, 30827,   953, -4227,  2796, 30827,  2870,
   30827, 30827, 30827, 30827, 30827, 30827, 30827, 30827, 30827, -4227,
   34271,   196, -4227,   729,  1975, 68992, 26859,  3073, -4227, 23411,
   -4227,   216, 73294, -4227, -4227,  1657, -4227, -4227, -4227, -4227,
   -4227,  1994,  2805, -4227,  2820, -4227, -4227, -4227, -4227, -4227,
   80464,  2982, -4227, -4227,  2873, -4227, -4227, -4227, -4227,   585,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227,  2807, -4227, -4227,
   -4227, -4227,  2807, -4227, -4227,  2829,  2808,  5505, -4227, -4227,
   -4227, -4227,  3062,  3063,   297, 97663, 80464,   243, 71860, -4227,
   27355, -4227,  1986,  2822, -4227,  3041, -4227,  2809, -4227,  9543,
    3041, -4227, -4227,   116,  2983,  2996,  2996, -4227,  2837, 14916,
   -4227,  2027, 14916,  2136, -4227, -4227, -4227, -4227, -4227, -4227,
     856, -4227,  2884,  1483,  2863,  1240, 80464, -4227, 41544,  1851,
   -4227,  2220, -4227, -4227, 19923, -4227, 21800, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227,  2838, -4227, -4227, -4227,
   -4227,   139,  2843,  3281, -4227, 61822, -4227, -4227, -4227,  3257,
   -4227,  2230, -4227,  2230,  3307, -4227, 73294, -4227, -4227, -4227,
   -4227,  1048, -4227, 22261, -4227, 22261, -4227,  2856,  1989,  2897,
    2898,  2940, 80464, 80464, 80464, -4227, 53684, 80464, 80464, 80464,
   80464, 80464, 80464, -4227,  3167,   826, 66602,  2947, 65168, -4227,
   -4227,  2846, 80464,  2883,  3060,  3077,  1167, -4227, -4227, 80464,
   -4227,  3015, 80464, 30827,  3021, 80464, 80464,  2908, 54642,  2858,
   80464, 80464, 80464,   676, 54642, 45936, 80464, 80464, 80464, 80464,
    2953, 80464, 80464,  3079,    50,   138,  2053,  2678,  3039, -4227,
    1038, 80464, 80464,  3047, -4227, -4227, -4227, 64212, -4227, -4227,
   -4227,  3025, -4227, -4227, 58953, -4227, -4227,  2004, -4227, 58474,
   56079, -4227, -4227,   660, 80464, 80464, 80464,  1239, -4227, -4227,
   57995, -4227, 80464, 80464, 80464, 72338, 92892, 93370,  1408,  1464,
   80464, 72816, -4227, 80464, -4227, -4227, 54163, 80464, 80464, 53684,
   -4227, 80464,  3049,   703, -4227, 80464,  3868,  2948, 80464, 80464,
    2871,  2010,  2950,  2995, -4227, 80464, 80464,   830, -4227, 80464,
   80464, -4227, -4227,   139, -4227, -4227, -4227, -4227, -4227, 80464,
   80464,   139, 80464,   139,  1394, -4227, 80464, -4227, -4227, -4227,
   80464, 80464, 80464, 80464, 80464, -4227, -4227,  1451,  1325,  1453,
    1489,  3013, 80464,  2590, 80464, 93848, 80464, 80464, 80464, 80464,
    1322, -4227, -4227,  2990, -4227, 80464,   830, 80464, 80464,  2957,
    2959,    89,  3031, -4227, -4227, -4227, -4227, -4227, -4227,  3115,
    3280, 80464, -4227,  3122,  3124,  2946,  2949,  3127,  1914, 80464,
   80464, 80464, 80464, 80464, 80464,  3128,  1914,  3080,    13,  2902,
    2024, -4227,  2911, -4227, 30827,  3297, 57995,  2909,  2913,  2987,
   -4227,  2998,  2324, -4227,  2026, -4227, -4227,  2030, -4227,  2925,
     632,  1221, -4227, 80464,    29,   790,  3204, 37674,  3028,  3247,
    3200, 80464, 80464,  3247, -4227,  1056, 66602, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227,  3203, -4227,  2590,  2465,
    2465,  2465,  2465, -4227, -4227, -4227, -4227,  3110,  1794, -4227,
    2929, 80464,  3038,  3247, -4227,  1478,  3220,  3224, 80464, 63256,
    2082,  3327,  2590,  3116, -4227, 24888,  4798,  3117, 64212, 76162,
   -4227,  2951,  3205,  3208,  3221, -4227,  2310, -4227,  3334, -4227,
    3237,   297,  2328, -4227,  2521, -4227, 80464, 80464, 80464, 80464,
    2333, -4227, -4227,  2521,  3130,   297,   297, -4227,  3133,   297,
    2521,  3061,  3235, 64212, -4227,    93, -4227, -4227, -4227, -4227,
   -4227, 30827, -4227, -4227,  2960,  1865, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, 73294,  2230, -4227,
    2039, -4227, 80464, -4227,  3214,  3215,  3216,  2521,  2999, 80464,
    2962, -4227,  2521,   139,  2521,  2594,  2594,  2521, 77118,  3368,
    3236,   846, -4227,   931,   -50,  3173, -4227, -4227, -4227, -4227,
   57995, -4227, -4227, -4227, -4227, -4227, 80464,   137,  3154,  2974,
   77118,  3354,   297, -4227, 54642, -4227, -4227,  3064, 54642,  3163,
   -4227, -4227, -4227, -4227, -4227,  3209, 80464,  2051, -4227,  1736,
   -4227,  1756, 30827, 30827,    44, -4227, 12782,  2056,  2984,  2989,
    2084, -4227, -4227, -4227, -4227, -4227, -4227,  2991,  3259, -4227,
   -4227,  2994,  2087,  2091,  3000,  3002, -4227, -4227,  5802,  3003,
   13250,  3004, 32315, 32315,   771, -4227, -4227, 32315,  3006, -4227,
    2094, 12520,  3010,  3017,  3005, -4227,  3018,  3020, 13539, 28347,
   30827, 28347, 28347, 13985,  3010,  3023,  2099, 53684,  3148, 14088,
    2102, -4227, 30827, 53684,  6218, 30827, -4227, 30827, 80464,  3024,
    3026, -4227, -4227,  3950, -4227,  3008, -4227, 32315, 32315, -4227,
    3228, 25867, -4227, -4227,  3262, -4227, -4227,  1605, -4227,  3022,
   -4227, -4227,  3592,   127, 30827,  2795, 30827,  3087, 45445,  5315,
   30827,  4241,  4382,  4382,   502,   502,   142,   142,   142,  1764,
    1975, -4227, -4227, -4227,  3029,  2578, 30827, -4227,  2209,  2210,
   80464,  7218,  9556, 10042, -4227, -4227, -4227, 35745,  3054, 30827,
   30827, 30827,  3030,  3184,  3426, 14916,   890, -4227,  3436, -4227,
   -4227, -4227,   327,  3307,  1994, -4227,  1486,  2324,   386, 49809,
   -4227, -4227, -4227, 30827, -4227, -4227, -4227, -4227,  2138, -4227,
   -4227, -4227, -4227, -4227,  1569, 30827, -4227, -4227,  1259,  1874,
   30827,  2027, -4227, -4227, 80464,  2963,  2963, 30827, -4227, -4227,
   -4227, -4227, -4227, 35745,  3065,  3076, 40580,  3160, -4227, -4227,
   80464,   141, -4227, -4227, -4227,  3048, -4227, -4227, -4227,   688,
   -4227, -4227, -4227, -4227, -4227, -4227,  3036, -4227,  3033, -4227,
    3057, -4227, -4227, -4227, -4227,   153,  3037,  3040,  3044,  1433,
   -4227, -4227, 80464, 80464, 80464, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227,  3258, -4227, 80464, 80464,  3219,
   80464,  3222,  3226, 30827,   891, 80464,  3058,  3059,  1315,  3299,
   80464, -4227,   297, -4227, -4227, 14916, -4227, -4227, -4227, 64212,
   -4227,  2310, 57995, -4227, -4227, -4227,  3084, 80464, -4227, 80464,
   80464,  2333, -4227, -4227, -4227, -4227,   961, -4227, -4227, 80464,
   80464,   487,  3134, 80464, -4227,   716,  2880, 80464, 80464, 80464,
    3296, -4227, -4227, -4227, -4227,  3242, -4227, -4227,  1892, -4227,
   56079, 58474, -4227, 58474, -4227,  1892,  1665, -4227,  2521, -4227,
   -4227,   555, -4227, -4227, -4227, -4227, -4227,  3349,   297,  3352,
     297, 80464, 80464, 80464, 80464, -4227, -4227, -4227, -4227, -4227,
   53684, 53684, 53684,  2143, -4227, -4227,  2590, -4227, -4227, -4227,
    2149, -4227,  1452, -4227, -4227, -4227, -4227, -4227, -4227, 80464,
    1800, -4227,   866, 57995, -4227, 57516, 80464, 80464, -4227, -4227,
    3283,  3225, -4227,  1955,  3229, 80464,  3119, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,  3144,
   -4227, -4227, -4227,  3278,  3282,  3284,  3145,  3152,  3190,  3156,
    3157,  3192, -4227,  3158,  3206,  3159,  3207,  3161,   297, 57995,
     270,  3196,  3381,   297, -4227,  3166, -4227, -4227,  3481, -4227,
   80464, -4227, -4227, -4227, 80464, 80464, -4227, -4227, -4227,  1914,
   57995,  3328,  1914,  1914, 80464, 80464,  1914, -4227, -4227, -4227,
    3329,  3333,  3337,  3338,  3340,  3342,  1914, -4227, -4227, -4227,
   -4227,   804, 53684, -4227,  2714, -4227,  2032, 42990,  6280,  3104,
    2913,  3112,  2324, 38652,    28,  3316,  3120, -4227, -4227, 53684,
   42990,  1885,  3339,  3135,  3135,  3135,  3135,  3135,  3135,  3135,
   -4227,  2067,  2479, 64212, 80464, 64212, -4227,   790,  3291, 80464,
   -4227, -4227,  2152, -4227, 80464, 80464,   742, 80464,  2324, -4227,
   -4227,  3189, -4227,  1925,   203,  3260,  1539,  3456, -4227, -4227,
   -4227, -4227, -4227, 80464, 80464,   632,  2590,  3137,  3132, -4227,
   80464, 80464, 73294,  1569,  3136, 80464,  3138,  3140, -4227, -4227,
   -4227, -4227,  2158, -4227, 57995,   -62,  3309,  3312,  1569,  3217,
   80464, -4227,  2177,    38, -4227,  2590, 64212, 56558, -4227,  1813,
   -4227, -4227,   850,  3405, -4227, 80464, -4227, -4227, 40098,   297,
   57995, 80464, -4227,   297,  3199,   297,  3201,   297,   297, 80464,
   -4227, -4227, 80464, -4227, 80464, 71382,   297, -4227, 14916, 80464,
    3428, -4227, -4227, -4227, -4227,  3265,  3268,  3269, 80464,  2521,
   54642, -4227,  3151, 80464,  1319, -4227, -4227,  3330, -4227, -4227,
   -4227, -4227, -4227,  3444,  3448, -4227, -4227, -4227, 80464, 67558,
     132, 80464, -4227,  2310, -4227,  2328,   139, 80464,  3391, -4227,
   -4227, -4227,  3162,  2195, 14419, 30827, -4227,  3458, 57995, -4227,
   -4227, -4227, -4227, -4227, 30827, -4227, -4227, -4227, -4227, -4227,
   30827, -4227, 30827,  3437, -4227,  3575,  3575, 57995, 32315,  1381,
    2575, 32315, 32315, 32315, 32315, 32315, 32315, 32315, 32315, 32315,
   34767,   920, -4227, -4227, 30827, 30827,  3443,  3437, -4227, -4227,
    1531,  1531, 57995,  3165,  3010,  3168,  3170, 30827, -4227, -4227,
    2200, 33789,  3172, 53684, -4227, 30827, 13016,  2204,  3223, 14716,
    1657,  6354, -4227,  3532,  2590, 30827,  1456,  1520, 30827,  2207,
   30827,  3441, -4227, -4227, -4227,  3174, -4227, -4227, 57995, 30827,
   32315, 32315,  4721, -4227,  4805, 30827,  3175,  6547, 25867, -4227,
     811,   811,   811,   811, -4227, 80464, 80464, 80464, 35263, 77596,
    3176,  2062, -4227, 77596, 78074, -4227,  3178,  1657, 30827,  3446,
     -27,   -27,  3186,  3184, 42026, -4227, 30827,  1729, 28843,  3188,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227,  3182, -4227,  3211, -4227, -4227,
     591,  3191, -4227, -4227,  6746,   153, -4227,  3194, -4227,  3193,
   -4227,  1874, -4227, -4227, -4227,  7078,  3367,  2594, -4227, -4227,
   -4227,  3176, 29339,  3160, -4227,  2211, -4227, -4227, 26859, -4227,
   -4227,  2221, 41544,  3065, 27355,  1657,  2324,  3212, -4227,  2230,
     327, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,  3135,
    2521,  2521,   777,  2521,  3469,   777,  7787, -4227, -4227, 36227,
   80464, 80464, -4227, 80464,  2235,  1295, -4227, -4227, -4227,  3593,
   80464, -4227,  3252,  3254, -4227, 80464, 80464, 80464, 80464, -4227,
   -4227,  2311, -4227, -4227, 80464, -4227, -4227, -4227, -4227,  3276,
   -4227, -4227,  3449,  1673, -4227, -4227, -4227,  3270,  2067,  1095,
    2674,   680, -4227,  3272, 80464, -4227, 80464, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, 54163, -4227, -4227, -4227,
   53684, 42990, 53684, -4227,  3277,  3285,  3326,    58,  1066,  3286,
    3287,  3335,  3227,  3230,  3231, -4227, -4227,   191,  2590, -4227,
   -4227,  2590,  2521,  2590, 80464,  3488,    74,  1496, 80464, 80464,
   80464, 80464, 80464, 80464, 80464, 80464, 80464, 80464, 80464, -4227,
    3582,  2590,  2590,  3554,  3298, 80464, -4227, 80464,  2880, -4227,
   -4227, -4227,  3232,  1914, -4227, -4227,  3468,  3470, -4227,  1914,
    1914,  1914,  1914,  1914,  1914, -4227,   217,  2240, -4227, 38157,
   -4227, -4227,  2834,  2590,  2834,    35, -4227,  2834, -4227,  2834,
   -4227, -4227,  2911,  3193,  2324,  1386, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227,  2324,  2148,  3238, -4227, 39616, -4227, -4227,
   -4227,  2044,   386, -4227, -4227, 80464,  3135, -4227,  2399,  2382,
    2641,  2761, 78552, 79030, 79508,  3244, 80464, 80464, 32315, -4227,
    1538,   877, -4227,  3474, 80464,  3288, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227,  3248, -4227,  2745, -4227, 80464,  3291,  2521,
   80464, 80464,  2521, -4227, 57995,  3642,   607, 90024,  3289,  3250,
    3529, -4227,  3255,  3256, -4227, -4227, 80464,  3291,   589,  1893,
    3295, 65646,  2082, -4227,  3502, 63256, -4227, 80464, -4227, -4227,
   -4227,  3609,  3344,  3302,  2590,  2883, -4227, 56079, 30827, 30827,
   -4227,  3261, -4227,  3273,  5135, -4227,  2465, -4227, -4227, -4227,
   -4227, -4227, -4227,  3343, 80464,  3680, -4227, -4227, -4227,  3271,
     297, -4227, 80464, -4227, 80464, -4227, -4227,   297,   297, -4227,
    3377, -4227, -4227,  1569, 80464, 80464, 80464,  2521, -4227,   139,
   -4227,  3546, 77118, -4227, -4227, -4227, -4227,   224,  3557, -4227,
   -4227,  3513,  3517,  3519,  3524,  1964, -4227, -4227, 30827, 14916,
   -4227,  3292, 14916,  8082, 14916,  3443, -4227,   948,  3567, -4227,
     879,  3300,   948,  1405,  1405,   226,   226,   101,   101,   101,
    3575,   920, 14916, 14916, -4227, -4227, -4227, -4227,  3294, -4227,
   -4227, -4227,  3010, -4227, 31323,  3438,  3676, -4227, -4227, -4227,
    3341,  3345,  3306, -4227, 30827, 31819,  3305, 58953, -4227, -4227,
     386,  1571, 32315, 32315,  2117, -4227,   906, 30827, 57995,  2246,
    2117,  2129,  2418, 30827, 30827,  6694,   198, 30827,  8568, 80464,
   80464, 80464, 80464, -4227, -4227, -4227, 37191,  2062,  3310, 80464,
   -4227,  3303, 35745,  3539,  3482, -4227, 35745,  3482,  1891,  3482,
    3542, -4227, 42508, -4227,  3314, 23411,  1731, 14916,  3690,  3580,
   30827,  3317, -4227,  3318,  3184, -4227, 95760, -4227, -4227, 14916,
   -4227, -4227, 30827, -4227,  3184,   327,  1025,  2590, -4227, -4227,
   -4227, 45445, -4227, -4227, -4227,  3503, 14916, -4227,  1569, 80464,
    1657,   225,  3347, 80464, -4227,  3160, -4227, -4227, 22261, -4227,
   -4227, -4227,   191, -4227, -4227, -4227,  3399, 66602,  3600, -4227,
   30827,  2262, -4227,  3363,  3687,   168,  2276,  2339,  1295, -4227,
    3288, -4227,  1543,   252, -4227, 57995, -4227, 80464, 80464, -4227,
   -4227, -4227, -4227,  2630, -4227, 80464, -4227,  3401, -4227,  3527,
   -4227, -4227,  3528,   191, 80464, -4227, 57995,   297,   297, -4227,
   -4227, -4227,  3355, 80464, 80464, 80464,  2324,  2324, 57995,  3346,
   -4227,  2324,  2324,  3350, -4227, 80464, 80464, 80464, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, 80464, 80464, 80464, 80464,
    3632, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, 80464, -4227, -4227, -4227, 57995,   297,   297, -4227,
    3576, -4227,  1914,  1914, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227,  2479,  3659, -4227, 53684, -4227, 60388, -4227, -4227, -4227,
    2590, -4227,  2590,  3534, 48356,  2590,  2590,  1295,  3351,  1706,
    3623, -4227,  2236, 39616, 39616, 39616, 39616, 39616, -4227, -4227,
    3627,   191, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, 30827, -4227,  1373,
     948, -4227, -4227, -4227, -4227,  3288,  1925,  3407,    29, 53684,
    3464, -4227, -4227,  2521,  2521,  3409,  1569,   648, 80464,  3660,
    3397, -4227,  2590, -4227, -4227, 80464, 63256, -4227,   715, -4227,
    2343, -4227, -4227, -4227,  3396,  3312,  1334,  3364,  2082, -4227,
   -4227,   597, 80464, -4227,  1332, -4227,  3636,  3365, -4227, 14916,
   14916,  2590, 59432,  1813, -4227, 80464,  3611, 80464, -4227,   297,
   -4227,   297,   297, -4227, -4227, 80464,  2521,  2521,  2521, -4227,
    3544, -4227,   297, 77118,  1964,  1964,  1964,  1964, -4227, -4227,
   -4227, 14916, -4227, -4227, -4227, 32315,  3640, -4227,  3370, 57995,
   -4227,  3371,  2354,  2366, 33307,  3515, -4227, -4227, -4227,  9272,
    3421, 14916,  3473,  3378,  3379, -4227,   884,   884,   906,  2372,
   -4227, 32315, 32315,  2117,  2117, 30827,  2117, -4227, -4227, -4227,
   -4227, -4227, 77596,  3384, 80464,  2062, 35745, -4227, -4227,  2548,
   -4227, 35745,  3607, -4227, 35745, 80464,  3386, 80464,  1155, 30827,
   30827,  3416,  3184,  3184, -4227,  3549, -4227,  3387, -4227, -4227,
    1386, -4227, -4227, -4227, -4227,   386,  3388, 73294, -4227, -4227,
   -4227,  1231, -4227, -4227, -4227, -4227, 77118,  3571, 77118,  1295,
    9666,  3288, 36227, 46427, 80464, 79986, 79986,  3536,  3288,  3407,
   -4227, -4227, -4227, -4227,  3393, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227,  3582, -4227, -4227, 42990, -4227, -4227, -4227,
   36709, 45445, -4227,    58,  3404,  3406,  1066, -4227, -4227, -4227,
    1476,   775,  3433,  2521,  3689, -4227,  3582, -4227, -4227,  1914,
   -4227, -4227,  2902,  2590, -4227, -4227,  2386, -4227, -4227, -4227,
   80464, -4227,  3250, -4227, -4227, -4227, 54642,  3801,  3801, -4227,
    1818,  1818, -4227, -4227, -4227, 80464, -4227, -4227, 10810,  3601,
   -4227,  3407,  3620,  3665, -4227,  2393, -4227, 80464, 80464,  3302,
   63256,  3291, -4227,   499,  3417,  3708, -4227,  3136,  3418, -4227,
    3748, -4227, 65646,  3596,  3344,   900,   900, 80464,  3312,  3545,
   -4227,  3547, -4227,  3789,  3605,  3794, 80464, 36227, -4227, 58474,
   -4227,  2401, -4227, -4227,  3054, 80464,     9, -4227,  3445, -4227,
   -4227, -4227, -4227, -4227, -4227,   132, -4227, -4227, -4227, -4227,
    1030, 32315, 57995,  2415, 30827, -4227, 30827, -4227,  3809, -4227,
   -4227, -4227,   -24, -4227, -4227, -4227,   884,   884,  2117, -4227,
   80464,  2420, -4227, 30827,  3439, -4227, -4227, 35745,  2548,  2427,
   80464,  2447, 57995,  3184,  3010, 14916, 80464, -4227, -4227, -4227,
    3812,  3615,  3184, -4227, -4227, -4227, -4227, -4227, -4227,  1319,
     777,   132,  3687,  3407, -4227,  3447, -4227, -4227, 80464, -4227,
     233,   233, 80464,  3407, -4227, -4227,  3497, -4227, 57995,  2328,
      48, -4227, 57995, 57995, -4227, 80464, 80464, 80464, 80464, 80464,
     297, -4227, -4227, -4227, -4227, 60388,  3250,  3801,  1028, -4227,
   -4227, -4227,  1482, -4227, -4227,   852,  3624,  3530, -4227, 53684,
    3291,  3731, -4227, -4227, -4227, -4227, -4227, 30827,  3598,  2082,
    3502, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227,  2452,  3344, -4227, -4227,  3628, -4227,  3633,
   -4227,  2453, -4227, -4227,  5135, 59432,  3767, -4227,  3510, 80464,
   -4227, -4227,  2186,  3879, -4227,  1030,  2456, -4227,  2459,  2469,
    3604,  3514, -4227,  2472, -4227, 14916, 80464, -4227, -4227, -4227,
    2473, -4227,  3465, -4227,  3862, 30827,  1530, -4227, -4227,  3745,
   -4227, 79986,  3512, 45445, -4227,  1874,  1874,  1925, -4227,  1295,
   30827, -4227,  2476, -4227,  1124,  3614,  3756,  2488,  2491,  3477,
    3520,  3477, -4227,  2521, -4227, -4227, -4227, -4227, -4227,  3787,
   -4227, -4227, -4227,   293, -4227,  3667,  3668, 80464, -4227, -4227,
   80464,  3884, 11195, 54642,  3312,  2082,  2067, -4227, -4227, -4227,
   -4227,  3521, 36227,  1813, -4227,   875, -4227, -4227, -4227, -4227,
   -4227, 80464, -4227, -4227, -4227, -4227, -4227, -4227,  2492, -4227,
   80464,  3493,  3010, 29835, 29835,  3494, 77118,   233,  3496, -4227,
    3498, -4227, -4227,  3620,  1295, 14916, 54642,  3869, -4227, -4227,
   -4227,  3614, -4227, -4227, 80464,  3618,   770,   770,  3813, -4227,
    3555, -4227, -4227, -4227,    58, -4227,  3500,  3344,  3312,  2674,
    3344, -4227, -4227, -4227, -4227,  1978, -4227, -4227, -4227, -4227,
   32811,  3625,  1050, 13465, -4227, -4227, -4227, -4227,   132,  1874,
   30827,  1295, -4227,  3624,  2328, 80464, -4227, -4227,  3397, -4227,
    3908, -4227,  1043, -4227, -4227,  3346, 53205, -4227,  3344, -4227,
    3054, -4227,  1995, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
    3900, -4227, -4227, -4227, -4227, -4227, -4227, -4227, 11308, -4227,
   -4227, -4227,  3796, -4227, -4227, -4227,  2496, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227,  1675, -4227, -4227,  1796,  2162, 30331,
   -4227,  1295,  3654, -4227, 53205, -4227,  1995, -4227, 54642, -4227,
   -4227,  3508, 53205,  2497, -4227
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -4227, -4227,  3644, -4227, -1158,    82,  2216,  -635, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,  2842,
   -4227, -4227, -4227,  1459, -4227, -4227,   -72,   645,  2464,  1148,
   -4227, -1335, -4227, -4227,  -865,   150,  -993, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227,  -996,  1594,   990,  2457, -2403, -4227,
   -1713, -4227, -4227,   422, -4227, -4227,  1545, -4227, -4227, -4227,
     862,  -336, -4227, -4227, -4227, -4227, -4227, -4227, -4227,   -67,
   -4227, -4227,  -507, -1796,  -116,  -136,  -376, -4227, -4227,   268,
    -380, -1684, -4227, -2946, -4227,  -105, -4227, -4227, -4227,  -379,
   -1664,  1075,  -971, -1350,  1379,  -663, -4227,  -270, -4227,  -709,
    -611,  -609,  -670,  -512, -3622, -4023, -4017, -3007,  1081, -4227,
   -4227, -4227,   283, -4227, -1795, -4227, -4227,  2144, -1621, -4227,
    -978, -4227, -4227, -4227, -2923, -4227, -4227, -4227, -4227,   -99,
   -4227, -4227, -4227, -4227,   325, -4227, -4227, -4227, -4227, -4227,
   -4227, -2133,  1507,  1514, -4227, -4227, -3594, -4227, -1183, -4227,
     464, -2947,  1010, -4227, -4227, -4227,  2170, -4227, -4227, -4227,
   -4227,   329, -4227,   338, -4227, -4227, -1815, -4227, -4227, -1790,
   -4227,  1526,   842, -4227, -4227, -4227,  -688,  -746,  -737, -4227,
   -3423, -4227, -4227, -4227, -4227, -4227, -1223, -4227,   899, -3052,
   -1198, -4227, -4227,   913, -4227, -4227, -4227, -4227,  -643,  -254,
    2206, -4227,  -542,  -615, -4227, -4227, -4227,  -249, -4227, -4227,
   -4227, -4227, -4227, -4227, -1936,  8668, -1788, -4227, -4227, -4227,
   -4227, -2338, -4227, -4227, -4227, -1878, -4227,  3912,   -15,  1434,
   -1783, -4227,  -197,  -104,  2709, -1357, -2645,   278,  -397, -4227,
   -1980, -4227, -4227, -4227, -2557, -4227, -4227, -4227, -4227, -3396,
   -1781, -4227, -4227, -4227,   331, -4227, -4173, -3826, -4093, -3383,
   -3377, -4227, -4227, -1303, -4227, -4227, -4227, -1613,  1714, -1682,
   -4227, -2333,   328, -3636, -1018, -3170, -4227, -3564,  -478, -4227,
   -4227, -4227, -4227, -4227, -4227, -4227, -1312,  -863, -4227, -4227,
    3197, -4227, -4107, -4227, -4227, -4227, -4227,  1263, -4227, -1581,
     988, -4227, -4227, -4227, -4227, -4227,  -625,  -705, -4227, -4227,
   -4227,   156, -4227, -4227, -4227, -4227,  1556, -1164,  -974,  3067,
   -1780,  -287, -4227, -4227, -4227, -4227, -2940, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -1332, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227,  1896,  1898,  -111,  -220, -4227, -4227, -1469, -4227,
    -813, -4227,  2131, -4227, -4227, -4227, -4227,  1233,   188,   359,
     -59, -4227, -4227,   157, -3329,   -58, -4227, -4227, -4227, -4227,
    -214,   -57, -4227,   610, -4227, -4227, -2781, -4227,   235,   -81,
    2774,  1474,   -61,   378,  -237,  -238,  -227,   -77,  3068,  2547,
   -4227, -4227, -4227,  -201,  1922, -4227, -1078,  -355, -4227,  1243,
    -925,  1876,  2532,  2534, -4227,  1235, -4227, -4227,  1242, -4227,
   -4227, -4227,  -924,  1882, -4227,  2538,  1900, -4227,  1229,  1238,
   -3301,   704, -3302,   215,  -923,  -333,  -130,  3089,  2551, -4227,
   -4226,   633, -4227, -3339, -2360,  -756, -2103, -1814, -4227, -4227,
   -1377,  7958, -4227, -4227, -4227,  9818, 10531, -4227, -4227, 14094,
   14243, -4227, -1255,   746, 16410,  7449, -1403, -1816, -1523, 15602,
    1614,  -793, -2563, -4227, -4227, -4227,  -303,   758,   242, -4227,
   -4227, -4227, -4227,  -528, -2767,  -526, -4227, -4227, -4227,  -525,
   -3944,  1428, -4227,  -790, -4227, 15921,  1283, -4227, -1316, -2718,
   -2721, -1366, -1946, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -1465, -3196,  -445,  1357, -4227, -4227,  1449, -4227, -4227, -4227,
   -1518, -1127, -2637,  1364, -2109, -4227, -1081,   679,  2022, -1036,
    5099,  1617, 13285,  -120, -2355, -1524, -1730, -4227,   232, -4227,
    1858,  1840,  -150,   568,     7,  1021, -3046, -4227, -4227,   267,
   -4227, -4227, -4227,  3538,   923, -4227,  2901, -4227,  1593,  2273,
   -4227, -4227,  1910,  -961,    33, -4227,  -483, -4227,  -129, -4227,
   -4227, -4227,   128, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
   -4227, -4227,  2586, -4227, -4227, -1443, -4227, -4227, -4227, -4227,
   -4227,  3826,  -307, -4227,  3263,  -306, -4227, -4227, -4227, -4227,
   -4227, -4227, -4227, -4227, -4227,  2596,  1943, -4227,  3070, -4227,
   -4227, -4227,   -51,  2810, -4227, -4227, -4227, -1193,  -591,  3082,
    3083,  1906, -4227, -4227, -4227, -4227, -4227, -4227, -4227, -4227,
    1917, -4227, -4227,  1351, -2094,  1923, -4227, -4227,   702, -4227,
   -4227,   269, -4227,   708, -4227,  2695, -4227, -4227, -4227,   744,
   -4227, -4227, -4227,  -596, 10560,  1367,  1005,   773,  1228, -4227,
    5193,  9108,   115,  2616,   -26,  7987, 14632,   689, -4227,  3823,
    1930,  1578, -1012, -4227,  6475,  2225, 13982, -4227, -1007,     3,
    1607, -4227,    -2,  -657, -1175,  2903,  -751, -1919, -4227,  4239,
   -4227, -3422, -4227, -1024,  3279, -1208
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2529
static const short yytable[] =
{
      81,   360,  1535,  1083,  1947,    79,  1939,  1602,  1074,  1608,
    1264,  1025,  1770,  1390,  1391,   703,   979,   355,  1395,   350,
     351,   353,  1987,  2420,   903,   709,  1059,  2337,  1674,  1556,
    2635,  1976,   891,   887,  1750,  2525,   979,  2390,  2018,  2398,
    2041,  1886,  2671,  1189,  1795,  1295,  2211,  1807,  1832,  2533,
    1904,  1131,   403,   953,  2639,  3320,  3022,  3024,   403,  2399,
     940,   851,  2052,  1316,  2465,  2466,   987,  1093,  1094,  2073,
    2074,  1548,  2100,  1000,  3072,   905,   404,  2862,  2496,  2534,
    3565,   847,   404,  1189,  3578,   363,  3455,   360,  2089,  3787,
    2582,   363,  1056,  1875,  2558,  2559,  1879,  2271,  2273,  2274,
    2560,  1883,  1930,  3592,  1026,  3594,  2388,  2561,  1888,  2562,
    2563,  2882,  3118,  2720,  3962,   404,  2224,  1906,  1135,  3998,
    1657,  3690,  1085,  3308,   363,  1659,  1077,   697,  3704,  3510,
    3452,  3450,  3451,  1086,  3690,  1627,  1189,  3917,  1351,  3988,
    4175,  3931,  3933,  1047,  4152,  2455,  2407,  2631,  4193,  3400,
     897,   976,  4414,  1717,  2315,  1977,  2211,  1596,  1599,   404,
    2919,  4147,  2002,  4164,  1972,   697,  1635,  1636,   363,  4316,
    1689,   976,  2265,  2265,  3967,  1126,  1542,  2116,  3157,  2170,
    3864,  2067,  2068,  3521,  2594,   895,   902,  1903,   424,  3357,
     424,  2461,  1340,   857,  2118,   902,  3212,  1742,  1765,  2935,
    1774,  1697,    45,  2939,  2472,  1022,  2086,  1799,  4586,  1796,
    2477,   424,   407,  1022,  1017,  1022,   848,  -135,  3778,  1148,
      43,  1931,  1017,  4511,  1017,    45,  -135,   404,   260,  2796,
    2124,  -135,   804,  2212,   328,   902,   363,  1931,  3136,  2796,
    3159,  1290,  1405,  3335,  3709,  3710,  3711,  3712,  3713,  3714,
   -1488, -1488, -1488, -1488,  4582,  2127,  3193, -1488,  1648,  3768,
    1931,  2668,  3275,   424,  3277, -1705,   349,  1691,  2269,  4107,
    4634,  4540, -1705,  1826,  1697,  4112,   804,    45,  2401,  3515,
     690,  1649,  4601,  2401,  3445,  2129,  3000,  4036,  1386,   360,
    1087, -1811, -1811, -1811, -1811,  2831,  4057, -1721, -1811,  -738,
    1378,  1080,  2832,  1698, -1721,   355,  2791,   350,   351,   353,
   -1488,  4314,  1871,   354,  3357,  4588,   424,  2231,  2580,    37,
      38,    39,    40,  2270,  1979,    43,    44,  1426,  1650,  3313,
      45,  2177,  1637,  1526,  2432,  3460,   818,  1393,  3461,  3462,
    3445,  2192,  2886,  4103,   804,   365,   130,   131,   403,  3463,
    3464,  3465,  1420,  3466,  3467,   122,  3001,   967,  3468,  3469,
    3470,     3,  1064,  2555,  3318,  1088,  1820,  3641,  2847,  1692,
    1344,   424,   404,   126,  2988,   819,  1698,   968,  1528,  1989,
    2193,   363,  4037,   403,  1807,  3002,   814,  3642,   815,  4104,
   -1287,  2161,  2178,  1527,  2433,  4574,  3314,  4564,    37,    38,
      39,    40,  2033,  2232,  -354,    44,  1678,   404, -2527, -2527,
   -2527, -2527,  3194,  1394,  1111, -2527,   363, -1498, -1498, -1498,
   -1498,  2887,  3170, -2527, -1498,  1931, -2528, -2528, -2528, -2528,
    4646,  1136,  2408, -2528,  4322,  2556,  4319,  1387,  2419,  1189,
    3160, -2528,  4058,  1122, -1498, -1498, -1498, -1498,  2213,  2100,
    1617, -1498, -1483, -1483, -1483, -1483,   356,  2701,  4602, -1483,
    2155,  4589, -1287,  2073,  2074,  1932,   818,  1965,  4038,  1567,
    2089,  1568, -2525, -2525, -2525, -2525,  3940,  2331,  4716, -2525,
    2669,  1932,  1379, -2524, -2524, -2524, -2524, -2525,  3195,  2158,
   -2524,  1378,  1854,  2332, -1488, -1488, -1488, -1488, -2524,  4731,
    3471, -1488,  3003,  1539,  1932,   819,  2723,  1693,  2507,   691,
    1150,  1094, -1483,  2503,  1379,  1406,   260, -2120, -2120, -2120,
   -2120,   891,   328,  2478, -2120,  3779,   859,  3137,  4697,  2203,
    2204,  2797, -2120, -1455, -1455, -1455, -1455,  1120,  1638,  1641,
   -1455,  3420,   356,  2473,  4803,  1721,  1991,  2333,  1745,  4031,
   -1957,  1089,  1699,  1670,   349,  3690,  4418,  4668,  2056,  2119,
    2460,  2529,  1129,  1130,  2334,  3007,  4309,  1694, -1705,  2188,
    2525,  1644,   245,  2200,  2200, -1468, -1468, -1468, -1468,  1872,
    2034,  4391, -1468,  2067,  2068,  1872,  1971,  2681,  2459,  3982,
    2124,  2086, -1495, -1495, -1495, -1495,  1967,  3369,  2833, -1495,
   -1721,   354,  1127, -1287,  2451,  3026,  2453,   973,   974,  2523,
    3538,  1686,  1941,  2499,  2581,  2127,  2890,    37,    38,    39,
      40,  4265,  2171,  1073,    44,  4269,  1108,  3472,  1394,  4433,
     973,  1626,  2062,   365,  1065,  3822,  -135,  -135,  2148,   897,
    1394,  4727,  2495,  2211,  3512,  2129,  4303,  2861,  1128,  4224,
    2040,  3173,    37,    38,    39,    40,   816,  1550,  2034,    44,
      37,    38,    39,    40,  2660,  4090,  1561,    44,  1137,  1932,
    1562,  2519,  3473,  2287,   895, -1488,  4621,  2252,  2253,  2183,
     906,  1109,   973,   974,  2530,   799,  3945,  1618,  3575,  2335,
    3576,  4380,  4381,  4382,  4383,  4384, -1287,  2156,   948,  2409,
    2379,  1569,  4323,  2682,  1163,  4768,  2367,  3021,  1779,  1196,
    4767,  2410,  3029,  4770,  1561,  1074, -1811,   949,  1562,  3366,
    3367,  3368,  3369,  3562,   902,   902,  2369,  1941,  2156,   799,
    1603, -1287,  2374,  1359, -1287,  1651,  1652,  3953,  1084,  4717,
    1169,  1122,  2717,  2719,   356,  1251,  1780,  4503,   950,  1255,
   -1957,  4802,  3579,  2727,  4513,  1241,  2730,  1135,  2438,  2343,
    1895,  2411,  1640,  3474,  2742,  2743,  4121, -1455,  1281,   410,
    3479,  1292,  1111,  1206,  3485,  1016,  2441,  2760,  2762,  2444,
    2445,  2336,  4419,  1016,  3008,  1016,  2643,  2650,  2776,  3656,
    3657,   403,  2948,  2653,  4420,  1972,  4780,   799,  1896,  1305,
    1592,  3651,  2243,  1378,  3654,  3655,   808,  4553,  3658,  2095,
   -1957,   404,  1360,  1306,  1366,   404,  1371,  2574,  3665,  1159,
     363,  2921,  1375,  2921,   363, -1957,  1378,  1159,  2096,  2746,
    2747, -1290,  1349, -2527,  3688,  1814,  2095,  1085,   870,  2504,
   -1455,  1354,  2097,  2588,  3065,  1366,  1371,  3688,  1086,  2986,
     808, -2528,  1015,  4021,  2696,  2096,  1428,  1551,  1159,  3357,
    2343,  1207,  1053,  3201,  1396,  4817,  1594,  2531,  1350,  2099,
    3970,  4196,  3566,  2683,   360,  3445,  2062, -1483,  4554,    37,
      38,    39,    40,  1365,  2434,  1370,    44,  2344,  4409,  1955,
     802,  2684,  2575,  1781,   872,  1384,  1021, -2525,  4759,  1208,
    2664,    35,  1293, -1290,  1021,  4555,  1021,  4165, -2524,    41,
      42,  1002,  1159,  2390,  1399,  1401,  2040,  1552,   808, -1488,
    1282,  1159,  1804,   907,  3785,  3580,   214,  1956,  1139,  1396,
    1941,  1122,  1416,   902,   802, -2255,  4479,  4664,  4481,  3563,
    2591,    81, -2120,  4421,  1379,  1897,    79,  1209,  4673,  1364,
    3581,  1369,  3000,  2642,  1572,   222,  4659,  1189,  2072,  1606,
    4469,  3607,  2345,  4542,  2455,  4472,  2588,  1538,   708,  1428,
    4476,  1546,  3357,  4478,  1283,  4733,  3994,  3740,  1782,  1345,
    1398,  1400,  3080,   902,  1170,  1132,  1532,  1003,  4022,  2431,
    2675,  2676,   232,  1256,  2124,  2145,  2146,  2147,  2148,  4565,
    2078,   908,   802,   909,   235,    35,   424,  3983,  3357,    37,
      38,    39,    40,    41,    42,    43,    44, -1495,  3358,  2127,
      45,  4410,  3001,  3787,  3066,  2589,  3000,   879,  2331,   880,
    1898,  1159,  3081,  1428,  1566,  3789,  3357,  1022,   245,  3359,
    1702,  1022,  2121,  4728, -1290,   852,  1017,  4566,  2510,  2129,
    1017,   885,  3482,  1151,  4567,  3309,  2500,  1307,   404,  4143,
    2665,  1172,  1416,  3608,  3566,  1159,  2576,   363,  1122,  1805,
     697,  4226,  2813,  4227,  1957,  2040,  4760,  2159,  2577,  1815,
    4650,  4568,  3082,  2620,   854,  2867,  2511,  4023,  2666,  4166,
    4024,  4629,  1246,  2987,  1806,  3360,  3001,   424,  2333,   364,
      37,    38,    39,    40,  4619,   364,    43,    44,  2835,  4732,
    3790,    45,  3555,  2272,  2185,  2334,  1630, -2255,  3357,  3741,
     424,  2542,   801,    37,    38,    39,    40,  4625,  4626,    43,
      44,  1426,  1650, -1299,    45,  1660,  4734, -1290,   364,  4647,
    3311,  4610,  4761,  4526,   967, -1299,  1300, -1455,  4400, -1299,
    3556,  4569,  3359,  1004,  1005,  1309,  1189,  3177, -1455,  1958,
    2072, -1455,  1678, -1455,   968,  4762,   801,  3984,  3003,  2646,
    3083,  2375, -1290, -2255, -2529, -1290,  4607,  4284,  1630,  2608,
    2419,  2870,   364, -1909,  1675,  1917,  3173,  4288,  3359,  4651,
    4144, -1299,  4302,  3516,  1752,  3985,  2814,  4228,  1733,  1844,
    2815,  3609,  4396,  2957,  1111,  4704,  1899,  1768,  3360,   864,
    2704, -1299,  1827,  1828,  1159,  1676,  3359,  4278,  1080,  3953,
    -571,  2186,  3011,  4794,  1159,  1753,  1900,  2749,   993,  2836,
    3573,  4287,  3610,  2512,   801,  2162,  2816,  3026,  3791,  1001,
    2335,  4527,  3003,  3310,  1677,  3112,  1870, -1299,  4701,  4702,
     364,  1107,  4652,  2235,  2376, -1299,  1074,  2705,  3361,  3362,
    3363,  3611,  3364,  3365,  3366,  3367,  3368,  3369,  3688,  3084,
    4212,  4782,  3360,  2958,  4648,  2340,  4751,  3085,  1941,  1159,
    3086,  1993,   360,  1995,  4517,   424,  1999,   870,  2001,  1657,
    3690,  2004,  2005,  2006,  1659,  4041,  3792,  3557, -2529,  2755,
    1189,   809,  2236,  2924,  2013,  3012,  -886,  2706,  3278,  3273,
    4570,   810,  4514,  2778,  4749,  4081,  1108,  2036,  2513,  2037,
    3818,  4084,  4085,  4086,  4087,  4088,  4089,  1784,  3312,   356,
    1073,  1769,  2336,  1785,    81,    81,  2707,    81,  2390,    79,
      79,  2708,    79,   872,  1176,  1159,  3219,  3220,  3221,  3222,
    2225,  2226,  2817,  2230,  2218, -1808,  4795,  2302,  1094,  3445,
    1630,  1086,  1086,  3445,  1086, -1909,  4811, -1299,  2792,  2008,
    1901,  1109,  4787,  3182,  1110,  3364,  3365,  3366,  3367,  3368,
    3369,   799,  3558,  3215,  4544,   855,  3836,  2709,  1135,   945,
    4042,  3457,  2009,  3458,  4783,   364,  4163,  2143,  2144,  2145,
    2146,  2147,  2148,  4019,  1870,  3976,  3333,  3574,  3269,  3486,
     811,  3364,  3365,  3366,  3367,  3368,  3369,  3128,  2558,  2559,
    2905, -1909,  3183,  1785,  2560,   973,  1626,   424,  1583,  1786,
     364,  2561,  1159,  2562,  2563,  3361,  3362,  3363,  1345,  3364,
    3365,  3366,  3367,  3368,  3369,   402,  1973,  4201,  1811,  4202,
    1974,   402,  4707,  1084,  3384,  2339,  2277,  1061,  1816,  2278,
    1159,  4423,  1111,  2446,   834,  3091,   818,    43,  2404,  4424,
    3810,  2529,    45,  3094,  1606,  3096,   879,  4001,   880,  2175,
    2176,  1031,  2340,  1080,   402,  3409,  2268,   882,  1159,  1159,
    1428,  1159,  2991,  3357,   967,  2710,  4622,   884,  3184,  3185,
     885,  2711,   808,  3787,  2152,   819,  4628,  1100,  1159,  4708,
    3715,  3186,  4587,  1915,   968,  4488,  4489,  4290,  2405,  1786,
    2116,  3364,  3365,  3366,  3367,  3368,  3369,  1101,   402,  2712,
    2508,  1561,  3769, -1941,  2679,  1562,  1108,  1102,   812,  1651,
    1652,  1428,  4415,  2413,  3357,  2191,  3103,  2279,  2713,  4002,
    1630,  2269,  3104,  3718,  1630,  1630,  3187,  1112,   967,  1159,
     404,  3892,  1030,   697,   697,  1189,  2446,  1787,  4445,   363,
    2325,  1941,  2714,  3848,  1032,  3849,  1113,  1648,   968,   967,
    2326,  2284,  4416,  3489,  2509,  2447,   802,  2448,  1159,   403,
     403,  1109,  1159,  1159,  2530,  2327,   402, -1958,  1788,   968,
    1649,  2363,  4658,  4003,  1754,  1428,  2270,  1016,  3357,    80,
    2341,  1016,   404,   404,   404,  2969,  1586,  4666, -1983,  4425,
    3544,   363,   363,   363,  1924,  3893,    35,  1789,   214,  2280,
      37,    38,    39,    40,    41,    42,  1103,    44,   403,  2933,
    3188,  2489,  3189,  1924,  3030,  2306,   214,  1078,  3105,  3177,
    1755,  2271,  4325,  4326,  2298,  2300,  4483,   222,  3458,  2124,
    3109,  4499,   404,  4501,  4001,   697,  4677,  2970,  1206,   404,
    1870,   363,  2490,  3359,  1925,   222,   404,  2210,   363,  3554,
    1962,  4389,  1111,  1022,   820,   363,  3722,  2965,  2447,  3850,
    2448,  3110,  1017,  2645,   232,  3301,   688,  1111,  1104,  3851,
    1963,  1592,   856,  3445,  4649,  1079,   235,  1630,  3445,  1587,
    1022,  3445,   232,  1630,  2129, -1941,   942,  1870,  4059,  1017,
    3111,  4141,  3723,  2328,  3359,  4617,  4320,  1756,  1021,  3360,
    2731,  1067,  1021,  3263,  2234,  3724,  4002,   356,  4060,  -892,
    2906,   402,  1748,  1870,  4360,  4361,  1179,  1180,  1181,  3994,
    1182,  1183,  1184,  1185,  1186,  1187,  1207,  1630,   245,   896,
    1630,  1630,  1926,  2969,  1105,   913,  1028,  1594,  3286,  1080,
    3171, -1941,  1757,  4013,  1758,  2235,   402,  2531,  1054, -1958,
    3360,  1926,  4142,  3548,  2454,  3821,  3106,  4321,  3359,  3041,
    4003,   992,  1022,  2210,  1208,  2732,  2532,  3411,  1276,  3412,
   -1983,  1017,  3087,  1595,    37,    38,    39,    40,  2060,  1927,
    1870,    44,  1760,  3999,  3725,  3541,  2609,  3107,   801,  3113,
    1630,  3413,  3822,  3567,  2236,  1872,  1277,  2076,  1927,  2522,
      37,    38,    39,    40,   364, -1958,  1592,    44,   364,  3042,
    1593,   207,  1209,  1683,  3360,  3043,  3108,  1870,  3114,  1762,
    2733,  3087,  2124,  2734,  2698,  3115, -1983,  2103,  3497,  1544,
      74,  1749,  4291,  1076,  3994,  -157,  1794,  4020,  4025,  1278,
     404,  2114,  1354,  3749,  1684,  1870,  1097,  2127,   207,   363,
    2181,  1081,  2861,  1764,  3116,  4693,  4119,  1928,  3845, -2319,
    -157,  2200,  3480, -2529, -2529,  3044,  3364,  3365,  3366,  3367,
    3368,  3369,  1594,  1685,  2686,   360,  1928,  2129,  2877,  1094,
    4694,  2648,  3865,  2649,  3445,  1090, -1334,  2651,  3414,  2652,
   -1334,  3255,  2654,  3415,   870,  1027,  2655,  1159,  1276,   674,
    4516,  3173,  1132,  1870,  3316,  4376,  1159,  3525,  1595,  3601,
    1703,  2735,  4525,  3361,  3362,  3363,  2697,  3364,  3365,  3366,
    3367,  3368,  3369,  4530,  3602,  3426,  3747,   214,  2715,  2755,
    2755,  1686,  3828,  4377,  2755,   360,  1084,  1084,    81,  1084,
    2553,    81,  1704,    79,  1686,     8,    79,  3866,  3867,  1941,
     872,  2695, -1334,  2692,  2693,  2694,   222,  2539,  2583,    37,
      38,    39,    40,  2452,  1680,  2309,    44,  2861,  2095,  1278,
    3291,  1138,  2401,  3688,  2755,  2755,   818,  3361,  3362,  3363,
    2406,  3364,  3365,  3366,  3367,  3368,  3369,  2096, -1334,  1149,
    1159,  4531,  3832,   232,   978,  1681,  2310,  1705,  1189,  2421,
      37,    38,    39,    40,  3729,   235,  2736,    44,  3416,    37,
      38,    39,    40,  4551,   978,   819,    44,  3417,  2804,  1078,
    2805,  4748,  3899,  3201,  1682,  2311,  1159,  1159,  1706,  4304,
    3454, -1335,  1175,  2124,  1159, -1335,   424,  1159,  2457,   245,
    1159,  3872,  2806,  4244,  4245,  2740,  2422,  2423,  1159,  1159,
      45,   364,  2491,  2892,  2084,  2085,  1159,  3256,  2127,  1159,
    1159,  1159,  1159,  2492,  1164,  2390,  4583,  4173,  3490,  1159,
    1159,  2095,  1159,    35,  1159,  1159,  1572,  1079,  1159,  3994,
    2419,    41,    42,   879,  3547,   880,  3224,  2493,  2129,  3924,
    2096,  3225,  1870,  1159,   404,  3831,  1198, -1335,  1159,  2959,
     799,  2962,  1159,   363,  2097,  3604,  1159,   885,  1159,  1159,
    1159,  1159,  1159,  1159,  1159,  1159,  1159,  3925,  1159,   130,
     131,  2421,  1793,  -377,  1159,  1561,   207,  1159,  1204,  1562,
    3577,  2606,  4271, -1335,  2807,  2072,  3605,  2316,  4017,  2808,
    2612,  1080,  3927,  2072,  2809,  2316,  4815,  1245,  2095,  4816,
     402,  1794,   799,   207,   402,  2166,  1248,  1709,  2167,   403,
    3996,  3997,  2462,  1710,  2908,  3606,  3177,  2096,  2422,  2423,
    1711,  2953,  2123,  1205,  3715,  2124,   948,  3705,  1794,  1250,
    3716,  2099,  3225,   404,  1428,  1973,  1713,  3357,  1159,  2638,
    3717,  1265,   363,  3923,  1714,   949,  3549,  3147,  2421,  1561,
    2127, -1811,  2419,  1562,  4251,  3330,  2128,  1271,   403,  2641,
     403,  2794,  3745,  2132,  2133,  1279,   799,  3718,   896,  3719,
    1775,   808,  1686,  1016,  1172,  3331,   950,    35,   424,  3332,
    2129,  1257,   404,  1258,   404,    41,    42,  3929,  3619,  2261,
    2262,   363,    45,   363,  1715,  2422,  2423,  4218,  3258,  3786,
    1016,  1776,  1285,  1081,  1630,  1777,  2136,  4771,   191,  2810,
    3924,  1280,    37,    38,    39,    40,  1288,  1583,  2811,    44,
   -1287,    81,   424,    81,  1660,   191,    79,  1302,    79,  2419,
    1778,  4115,  4116,  4117,   404,  3078,  1807,  3612,  3925,  3614,
    3936,  3720,  1326,   363,  3383,  2488,  3385,  3386,  3730,  1122,
    3732,  2602,  2603,  3926,  4097,   802,  4446,  4447,  4448,  4449,
    4100,  1159,  4102,  3927,  1140,  4105,  1159,  4106,  3833,  1260,
    2782,  1261,  1159,  2785,  2261,  2917,  1141,  1142,  3492,  3493,
     356,  2421,  1016,  3640,  2131,  3928,   214,   808,  1982,  2059,
    1983,   245,  3941,  3943,  1021,  3721,  1143,  3490,  1317,  1144,
    3722,  1332,  1870,   214,  3652,  2132,  2133,  1870,  1870,   943,
    3490,  3782,  2072,  1347,  1678,   222,  4537,  3359,  1870,  1367,
    2216,  1021,  2217,  1372,  1373,  1374,  2898,  2899,  2422,  2423,
      45,  1703,   222,  1385,   404,  1392,  3723,   404,  2211,  2219,
     356,  2220,  2640,   363,  2641,  1388,   363,   402,  2136,  3724,
    1402,  2210,   232,  1408,   214,  3088,  3009,  1413,  3929,  3216,
     799,  2137,  2419,  1704,   235,  2661,  1630,  2662,  2663,   232,
    2662,   802,  2861,  3360,  1630,  1414,  1630,    37,    38,    39,
      40,   235,  1243,   222,    44,  4079,  2143,  2144,  2145,  2146,
    2147,  2148,  2421,  1415,    37,    38,    39,    40,  4772,  4495,
    2689,    44,  2690,  1021,  3088,    45,  1416,  2883,  3030,  1941,
    2941,   910,  2690,  1145,  1423,   245, -1085,  1417,  1705, -1085,
     232,  3459,  1419,  1428,   951,  3019,  3357,  3020,  3725,  2802,
    4429,  3074,   235,  3075,  3799, -1358, -1358,  1297,   913,  2422,
    2423,  1418,  1159,  4252,  1870,  3165,  2072,  3166,  2316,  1706,
    1146,  3178,  4249,  3179,  3062,  4113,  4114,  4115,  4116,  4117,
    3293,  1311,  2662,  4118,  1425,  1319,   952,  3088,  3245,  3246,
      80,  3088,  3329,  2419,  2641,  1331,  1547,  3339,  4233,  2641,
    1422,   808,  4125,  4194,  1074,  2755,  1549,   801,  2755,  2755,
    2755,  2755,  2755,  2755,  2755,  2755,  2755,  2755,  1553,  4122,
    2981,  3088,  3841,   364,  1554,  3342,  1172,  2641,  3346,  4639,
    2641,  4641,  3347,  1870,  2641,  3373,  1555,  2641,  3876,  1560,
    3389,  3846,  2641,  3394,  1573,  3395,  1404,  1580,  2143,  2144,
    2145,  2146,  2147,  2148,  4109,  4110,  3361,  3362,  3363,   801,
    3364,  3365,  3366,  3367,  3368,  3369,  3868,  2755,  2755,  3430,
    3432,  3431,  3433,   356,  1421,   364,   364,   364,  1581,  1159,
    3435,  3436,  3437,  1529,  3595,   802,  3596,  1541,  1297,  1543,
    3599,  1723,  3600,  3736,   207,  3737,  2378,  1724,  1709,  3766,
    1583,  3767,  2040,  1584,  1710,    37,    38,    39,    40,  1074,
    1173,  1711,    44,  2046,  2047,  1192,  1630,  1590,  3776,  1794,
    3777,  3498,  3499,   801,  1202,   364,  3359,  1713,  1870,  1604,
    1122,  4099,   364,  1609,   799,  1714,  3837,  1725,  2641,   364,
    1605,  3873,  1159,  3874,  1615,  3883,  1159,  3884,  3895,  3923,
    2641,  1259,  3968,  1611,  3969,  1266,    37,    38,    39,    40,
    1159,  1159,  3972,    44,  3973,  1616,  1275,  4113,  4114,  4115,
    4116,  4117,  1619,  1620,   688,   688,  4000,  4379,  2662,  1661,
    1621,  4093,  3360,  4094,  1622,  1715,  1726,  4250,  4173,  2690,
    1159,  1159,  1623,  1727,  4372,  1159,  1728, -1459, -1459, -1459,
   -1459,  4365,  1625,  4311, -1459,  4312,  1624,  1159,  1159,  1159,
    1159, -1466, -1466, -1466, -1466,   404,  3924,  4317, -1466,  2662,
    1159,   404,  1631,  1159,   363,  1159, -1457, -1457, -1457, -1457,
     363,  1632,  1634, -1457,  1992,  1159,  1159,  1994,  1663,  1159,
    1998,    74,  2000,  1664,  3925,  2003,  1666,   360,  1729,  2007,
    1672,  3490,  1159,  1678,  1159,   808,  1696,  1701,  1159,  3926,
     978,  4127,   978,  2695,   978,  2692,  2693,  2694,  1719,  3927,
     978,  1376,  1377,  1745,  1159,  3670,    37,    38,    39,    40,
    4318,  4209,  2662,    44,  4411,  1159,  4412,  1159,  1159,  1159,
    1783,  3928,  1830,   978,   978,  4455,  1792,  4456, -1460, -1460,
   -1460, -1460,  1730,  4453,  1731, -1460,  1747,  4457,  1674,  2641,
    4473,  1159,  1630,  4465,  1732,  2690,  3671,   801, -1458, -1458,
   -1458, -1458,  1733,  1159,   799, -1458,  1802,  4534,  1159,  4535,
    1803,  1734,  3390,   364,  4548,  1159,  4549,  1808,  3397,   802,
    3672,  1159,  4584,  4429,  4585,  3361,  3362,  3363,  1801,  3364,
    3365,  3366,  3367,  3368,  3369,  3673,  4597,  1810,  2690,  3674,
    1817,  4604,  1735,  1941,  3929,  2755,  1736,  1822,  4609,   402,
    3756,  1812,  1824,  4362,  1948,  1831,  3323,  3675,  1834,  1297,
    3325,  4129,  1876,    80,    80,  1686,    80,  4300,  4611,  1880,
    3756,  1737,  3676,  4667,  4671,  2180,  4672,  4682,  1878,  2690,
    4683,  1159,  3395,  4484,  1297,  1872,  1889,   674,   674,  -174,
    4684,   978,  2641,  4687,  4689,  1941,  3756,  4706,  1893,  2690,
    1870,   402,   402,   402,   799,  1891,  1905,   799,  4155,  4712,
    1653,  2690,  4713,  4737,  2690,  1941,  4474,  4813,  4824,  4814,
    4814,  1589,  1913,  1591,  4270,   808,  4273,  1738,   834,  2038,
    2031,  1921,  1935,  1929,  1937,  1934,  4769,  1936,  1870,  1870,
    4536,  1870,  1938,  1940,  1941,  2043,  1946,  3677,  1949,  1950,
    1297,   402,  1951,   978,  1952,  3678,  1954,  2053,   402,  1959,
    1960,  1961,  1966,  1980,  2014,   402,  2042,  2044,   404,   404,
     404,  2048,  2057,  2058,  2050,  2051,  2153,   363,   363,   363,
    2066,  2069,  2070,  2071,  2075,   245,  2077,  2080,  3679,  2081,
    2082,  1870,  2083,  1870,  2088,  2090,  2091,  2092,  2093,  3446,
    2094,  2101,  2102,  2104,  2105,  2106,  4596,  2107,  2108,   802,
    2184,  2109,  2110,  2111,  2195,  1378,  2205,  2180,  4296,  2755,
    2755,  2223,  2117,  3759,  2215,   808,  1593,  1595,   808,  2250,
    2258,  2260,  2122,  1111,  2275,  2267,  2281,  1870,  2283,  2285,
    2293,  2296,  2160,  2294,  2301,  2303,  2312, -2471,  2305,  2313,
    2314,   801,  2316,  2317,  2318,  3446,  2319,  2346,  1870,  3797,
    4599,  2368,  2040,  2320,  2321,   891,  2370,   364,  2342,  2371,
    2372,  1297,  4632,  2373,  2190,  2394,  4637,  4638,  1297,  1297,
     404,  2401,  2413,  2403,  3682,  1870,  2414,  2395,  2416,   363,
    1630,  1189,  3760,  2417,  2419,  4392,  2418,   404,  1870,  2114,
    2425,  2426,  2427,  1630,  2428,  2429,   363,  3773,  2435,   802,
    2436,  1074,   802,  2802,    74,    74,  2442,    74,  2222,  2439,
    4365,  1074,  2440,  2449,  2450,  2456,  1733,  3796,  4636,  2463,
    2474,  2464,  3429,  2475,  2501,   978,  4633,  2476,  2479,  2485,
    4498,  2487,  2514,  2516,  2502,  3439,  2517,  2062,  2480,  3909,
    3910,  3911,  3912,  2524,  2072,  2078,   364,  2526,  2527,   402,
    2540,   688,  1870,  2543,  2546,  2547,   866,  2551,  2552,  4324,
    1769,  2568,  2573,  2586,  2587,  1870,  2592,  2595,  2597,  2598,
    2599,  2605,   356,  2616,  2618,   902,  2632,  2633,  1870,  2617,
    4333,  2657,  2678,  2673,  2619,  2687,  2658,  3669,  2700,  2722,
    2764,  3439,  4342,  2765,  1073,   364,  2777,   364,  2783,  2723,
    2124,  2788,  2787,  2795,  2539,  2801,  2818,  2820,  1159,  4692,
    2847,   902,  2866,  2874,  2875,  1079,  2893,  2864,  2863,  2871,
    2869,  2903,  2885,  2123,  2894,  2926,  2124,  2170,    35,  2955,
    4356,   801,  2884,  2944,  2942,  2943,    41,    42,  2973,  1630,
    2960,  2965,  2967,  1159,  2976,  2979,  1870,   364,  2996,  2923,
    2897,  2127,  1159,  3205,  2925,   799,  2963,  2128,  1159,  2968,
    1159,   799,  3010,  2999,  3017,  1870,  1159,  2940,  2982,  1159,
    1159,  1159,  1159,  1159,  1159,  1159,  1159,  1159,  1159,  3015,
    3064,  2129,  1159,  1159,  3073,  3069,  2458,  3076,  3077,  3117,
    1870,  4573,  3130,  3139,  3134,  1159,  3135,  3138,  3140,  1159,
    3142,   404,  3143,  1159,  3144,  3146,  3156,  3145,  3167,  3080,
     363,  3158,  3162,  1159,  3169,   978,  1159,  3172,  1159,   978,
     978,  3173,  3180,  4616,  3174,  3199,  1870,  1159,  1159,  1159,
    3204,   801,  3211,  1159,   801,  3175,  1159,  3217,  3223,  3226,
    3230,  3231,  2755,  3408,  3232,  3248,  1159,   364,  3250,  3262,
     364,  4458,  3270,  3268,  3266,  3265,  1159,  3267,  3271,  3081,
    4506,  4790,  3279,  3284,  1159,  3282,  1159,  3285,  2755,  2755,
    3289,  3295,  3296,  3297,  3307,  3300,   808,  4051,  3298,  2701,
    3315, -2529,   808,  2040,   674,  2131,  3319,  1394,  4520,  3321,
    3326,  3324,  2276,  3327,  1377,  3340,  3344,  3391,  3379,  3410,
    3341,  3405,  3343,   402,  3206,  3345,  2132,  2133,  2564,  3082,
    1159,  3348,  2290,  3349,  3351,  3354,  1159,  3372,  3878,  2297,
    2299, -2529,  1159,  2641,  3425,  3454,  3456,  3448,  3378,  3380,
    2756,  3381,  3418,  1189,  3388,  3403,  -932,  3404,  3502,  3428,
    3504,  3453,  1172,  3508,  2756,  3514,  3519,  1159,  3523,  2136,
    3518,  3532,  3529,  1973,  3520,  3524,  3490,  3534,  3535,  3543,
     802,  1189,  2137,  3550,  3571,  3572,   802,  2614,  3539,  3540,
    3584,  3564,   978,  3586,  3623,  3618,  2623,  3617,   978,  3621,
    3625,  3624,  3628,  3630,  3626,  3633,  3627,    80,  2630,  3629,
      80,  2837,   402,  3631,  3632,  3634,  3636,  3083,  3638,  3635,
    3637,  3643,  3645,  3647,   404,  2472,  3653,  3659,   404,  1870,
     404,  3660,  3693,   363,  1630,  3661,  3662,   363,  3663,   363,
    3664,   356,   978,  3694,  2278,   978,   978,  3733,   799,   799,
     799,  3702,  3707,  3706,  3207,  3744,   356, -2529,  3746,  3748,
    3770,   402,  2484,   402,  3771,  3756,  3761,  2667,  3755,  3764,
    2672,  3794,  2674,  3765,  3774,  2677,   356,  3802,  3814,  3804,
    3813,  3815,  3816,  3825,  3819,  3824,  4703,  3826,  2755,  3835,
    2059,  3840,  3208,  3357,  3375,  3374,  3869,  2118,  3897,  3870,
    3446,  3871,  1630,  3877,  3898,   978,  3906,  2123,  3935,  3922,
    2124,  3938,  3885,   402,  2739,  3955,  3084,  3944,  2280,  3954,
    3964,  3987,  3957,  3961,  3085,  3960,  2040,  3086,  3956,  3978,
    4007,  4005,  4008,  4015,  4033,  2127,  4018,  4016,  4026,  4035,
    4056,  2128,  4034,  4045,  4046,  3062,  1159,  4032,  4047,  2143,
    2144,  2145,  2146,  2147,  2148,  4072,  3640,  4021,  4048,  2554,
     799,  4049,  4050,  4080,  4076,  2129,  4082,  4111,  4083,   808,
     808,   808,  1870,  1723,  4137,  2484,  4145,   799,  4149,  1724,
    4156,  4159,  3796,  2662,  3786,  4177,  4161,  4181,  4158,  4162,
    4700,  4168,  2040,  4182,  4191,  4197,  2040,  2040,  4184,  4205,
    4195,  3446,  4199,  4192,  1754,  1870,  1159,  1159,  4210,  2600,
    1953,  4214,   801,   402,  4213,  4215,   402,  4216,   801,  1725,
    4307,  1968,  4217,  4222,  4225,  4230,  2868,  3419,   364,  4234,
    4229,  4235,  2484,  4264,   364,  4236,  2114,  4238,  4242,  4237,
    4266,  4262,  4267,  4274,  4277,  4279,  3916,  4280,  4282,  4283,
    1755,  4297,  1630,   802,   802,   802,  4306,  4308,    74,  4313,
    4314,    74,  4305,  1189,  4301, -2529,  1159,  4328,  1726,  2131,
    4329,  4330,  4336,  4354,  4359,  1727,  4363,  4370,  1728,  4343,
    4375,   808,  4378,  4346,  4385,  4393,  4397,  4398,  4402,  4404,
    2132,  2133,  4413,  4426,  4417,  4427,  4435,  4451,   808,  4443,
    4452,  4454,  1159,  4331,  4461, -2529,  4459,  4462,  4477,  4463,
    4464,  4486,  1159,  1159,  4470,  1870,  4480,  4490,  4492,  4496,
    1159,  1159,   688,  4500,  4515,  1159,  1870,  1756,  4512,  4528,
    1729,  1159,  1159,  2136,  4522,  1159,  4523,  4298,  1661,  4538,
      80,  4529,    80,  4545,  4144,  4547,  2137,  4557,  4558,  4560,
    1159,  4561,  4563,  3459,  1159,  4575,  4577,  4576,  2728,  2729,
    4578,  4579,  4592,  1159,  4600,   802,  2741,  4615,  1159,  4606,
    2744,  2745,  1757,  1080,  1758,  4630,  4653,  4623,  4660,  4657,
    1159,  4663,   802,  4669,  1759,  2766,  1731,  2767,  4670,  4293,
    4675,   799,  4676,  1723,  4681,  4685,  1732,  4686,  4690,  1724,
    4691,  4387,  4696,  4709,  1733,  4698,    81,  2789,  4634,  2790,
    1967,    79,  1760,  1734,  1543,  4715,  4714,  4729,  1159,  4718,
    4720, -2529,  4724,  3946,  4755,  4747,  4750,  4758,  4716,  4752,
    4766,  4717,  4793,  1870,  4781,  4809,  4812,  4818,  4822,  1725,
    1092,  2486,  3028,  3214,  1761,  1722,  2202,  3483,  1736,  1762,
    3068,  3582,  4030,  3666,  1870,  3129,  4532,  4364,  4645,  2290,
    4408,  4559,  4562,  4179,  4390,  2123,  1870,  4572,  2124,  3537,
    4753,  3294,  4504,  1763,  4789,  4721,  4719,  4764,  4665,  3542,
    4180,  2585,  3197,  1764,  4148,   801,   801,   801,  1726,  3198,
    4029,  3593,  2565,  2127,  4150,  1727,  3181,  3751,  1728,  2128,
    4792,   364,   364,   364,  1870,  4151,  4823,  4819,  3703,  3681,
    3120,  4765,   808,  2143,  2144,  2145,  2146,  2147,  2148,  4521,
    2550,   978,   404,  2129,  4711,  4399,  4756,  4524,   997,  1738,
    4211,   363,  4618,  2032,  3023,  4188,  4187,  4674,  1298,  3644,
    4774,  4820,  4552,  2879,  2647,  3149,  2880,  3487,  4167,  3290,
    1729,  1557,  3974,  3149,  1981,   674,  4299,  2221,  3488,  2902,
    2247,  2246,  3500,  3496,  2901,  1159,  2896,  1579,  2251,   978,
    3513,  3501,  3918,  4272,   402,  4608,  3975,   404,  1565,  3889,
     402,  4598,  2945,  3879,  3446,  2254,   363,  2949,  3446,  1653,
    2952,    74,  4738,    74,   799,  4739,   802,   801,   799,  4746,
     799,  3491,  3423,  3336,  1730,  3218,  1731,  3421,  2846,  1125,
    2756,  2756,  2974,   364,   801,  2756,  1732,  3971,  3795,  1923,
    1870,   356,  3264,  2130,  1733,  2927,  2601,  2131,  4736,  3249,
     364,  1095,  2266,  1734,  2918,  1297,  2259,  2934,  1343,  3669,
    2931,  3013,  1642,  1643,  3478,  2039,  4497,  2932,  2132,  2133,
    1671,  3980,  2169,  1159,  4289,  2756,  2756,  1870,  3981,  3959,
    2263,  1118,  1159,  2134,  3027,  2938,  3292,  2659,  1736,  1970,
    1297,    83,  1723,     0,     0,     0,     0,     0,  1724,  1159,
    1159,     0,     0,  1159,  1383,     0,     0,  3058,  2135,     0,
       0,  2136,     0,  1737,  1159,     0,     0,     0,     0,  1159,
       0,     0,  1159,     0,  2137,     0,  3079,  1159,  1159,  3089,
       0,     0,     0,     0,     0,   808,  3299,     0,  1725,   808,
       0,   808,     0,  4494,     0,     0,  3097,     0,     0,     0,
    3439,   978,     0,  3101,  3439,     0,     0,     0,     0,   978,
    1159,   978,     0,     0,     0,     0,  3124,     0,     0,  1738,
       0,     0,     0,     0,     0,  3131,  2123,     0,     0,  2124,
       0,     0,     0,     0,  1870,     0,     0,  1726,  1159,  1630,
       0,     0,     0,     0,  1727,     0,   356,  1728,     0,  2139,
       0,     0,     0,     0,  2127,     0,     0,     0,     0,     0,
    2128,     0,     0,     0,     0,     0,  3355,  3356,     0,   802,
       0,  3371,     0,   802,  1159,   802,     0,     0,     0,     0,
       0,     0,     0,     0,  2129,     0,     0,  2607,     0,     0,
    3176,     0,     0,     0,     0,     0,  2613,     0,   801,  1729,
       0,     0,     0,     0,  2621,  2622,     0,     0,     0,     0,
       0,  3406,  3407,     0,   364,     0,     0,   402,   402,   402,
       0,     0,  2634,     0,     0,  1159,     0,  1870,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2140,  2141,  2142,
       0,  2143,  2144,  2145,  2146,  2147,  2148,     0,     0,  1159,
    1870,     0,  1159,  1730,  1159,  1731,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1732,     0,  2123,     0,     0,
    2124,  1159,     0,  1733,     0,  1159,  1297,     0,     0,     0,
    1870,     0,  1734,     0,  2130,     0,     0,     0,  2131,     0,
       0,     0,     0,     0,     0,  2127,     0,     0,  3446,     0,
       0,  2128,     0,  3446,     0,     0,  3446,     0,     0,  2132,
    2133,     0,     0,  1772,     0,     0,  1870,  1736,     0,     0,
    1870,  1870,     0,     0,  2134,  2129,     0,     0,     0,   402,
       0,   978,     0,     0,   356,  4808,     0,     0,     0,     0,
       0,     0,  1773,     0,  3446,     0,   402,   404,     0,     0,
       0,     0,  2136,     0,     0,  1159,   363,     0,     0,     0,
       0,     0,     0,     0,     0,  2137,     0,     0,     0,     0,
       0,     0,  4519,     0,  3530,  3531,     0,  3533,     0,     0,
       0,     0,     0,  1870,     0,     0,  1297,     0,     0,     0,
    4680,     0,     0,     0,     0,     0,     0,     0,  1738,     0,
       0,   801,     0,     0,     0,   801,     0,   801,  1172,     0,
       0,     0,     0,  1159,     0,     0,     0,   364,     0,     0,
       0,   364,     0,   364,     0,  2130,     0,     0,  1159,  2131,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2139,     0,     0,     0,  3439,     0,     0,     0,     0,  3439,
    2132,  2133,  3439,     0,     0,     0,     0,     0,   360,  3446,
       0,  1159,   799,  3598,     0,  2134,     0,     0,     0,     0,
    1159,  2876,     0,     0,  4779,     0,  4776,  4777,  4778,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3620,  1159,  1159,  2136,     0,   360,     0,     0,     0,     0,
       0,     0,  3622,     0,  1159,     0,  2137,     0,     0,  3446,
       0,  4779,     0,  4776,  4777,  4778,     0,   799,     0,     0,
       0,     0,  2290,     0,     0,  3481,     0,   978,  2140,  2141,
    2142,     0,  2143,  2144,  2145,  2146,  2147,  2148,  1159,   360,
       0,     0,     0,     0,     0,     0,  3149,     0,  1159,  3149,
    3149,     0,     0,  3149,     0,  4779,     0,  4776,  4777,  4778,
     402,     0,     0,  3149,   404,     0,     0,     0,  1830,  4800,
       0,     0,     0,   363,  3691,     0,     0,     0,     0,     0,
    3700,  2139,  3526,   808,     0,     0,  2756,  3691,     0,  2756,
    2756,  2756,  2756,  2756,  2756,  2756,  2756,  2756,  2756,     0,
    1297,     0,  1297,     0,     0,     0,  2123,  1159,     0,  2124,
       0,     0,   404,  2348,     0,     0,  1159,  4800,     0,  2756,
     404,   363,  3739,     0,  3742,  4800,     0,     0,     0,   363,
       0,     0,     0,  3754,  2127,     0,     0,     0,   808,     0,
    2128,     0,     0,     0,     0,     0,  2349,     0,  2756,  2756,
       0,     0,     0,     0,     0,  3439,     0,     0,     0,  2350,
       0,     0,  3781,  1297,  2129,     0,     0,   802,     0,     0,
   -2529, -2529,  2351,  2143,  2144,  2145,  2146,  2147,  2148,     0,
       0,  4799,     0,     0,     0,     0,     0,     0,     0,     0,
    2123,     0,     0,  2124,     0,  4726,     0,     0,     0,     0,
       0,     0,     0,     0,  3446,     0,  3255,     0,     0,  3603,
    2352,     0,     0,     0,     0,  3817,  3615,     0,  2127,     0,
       0,     0,   802,     0,  2128,  1703,  3903,     0,     0,  4799,
       0,     0,     0,     0,     0,  3827,     0,  4799,  4754,  2353,
       0,     0,     0,     0,  2354,     0,     0,     0,  2129,     0,
       0,     0,     0,     0,     0,     0,     0,  1704,     0,     0,
       0,     0,     0,   402, -2529,     0,     0,   402,  2131,   402,
       0,     0,  3847,     0,  3649,  3852,  3853,  3854,  3855,  3856,
    3857,  3858,  3859,  3860,  3861,     0,     0,     0,     0,  2132,
    2133,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2529,     0,     0,     0,     0,     0,
    3904,  3890,  1705,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   978,     0,     0,     0,     0,
    3695,  3698,  2136,     0,  3901,  3902,     0,     0,   978,  2355,
       0,     0,     0,  1706,     0,  2137,     0,     0, -2529,     0,
    4821,     0,  2131,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3951,     0,  3743,   834,  3272,     0,
       0,     0,  3256,  2132,  2133,     0,     0,     0,     0,     0,
       0,     0,  3280,  3281,     0,     0,  3283,     0, -2529,     0,
       0,     0,  3287,     0,     0,     0,     0,     0,  2356,   801,
       0,  1703,     0,     0,  2357,     0,     0,  2358,     0,     0,
       0,     0,     0,   356,     0,   364,  2136,   799,     0,     0,
   -2529,     0,     0,     0,     0,  2484,     0,     0,     0,  2137,
       0,     0,  2359,  1704,     0,     0,     0,     0,  2360,     0,
       0,     0,     0,  3820,     0,     0,  2756,     0,     0,     0,
    4807,  2361,     0,     0,   801,     0,     0,     0,     0,  3322,
       0,  3830,     0,     0,     0,     0,     0,     0,   207,     0,
     364,     0,  3257,     0,     0,  2362,     0,     0,  1710,     0,
       0,     0,     0,     0,   978,  1711,     0,     0,  1705,     0,
       0,     0,     0,  1794,   356,     0,     0,     0,  1216,     0,
       0,  1713,     0,     0, -2529,     0,     0,     0,  3691,  1714,
       0,     0,  2143,  2144,  2145,  2146,  2147,  2148,     0,  1706,
       0,     0,     0,     0,     0,  4052,     0,     0,  4053,     0,
    4054,  1217,     0,     0,     0,     0,     0,     0,   808,     0,
       0,     0,     0,  3255,  1218,  1219,     0,     0,  4074,  4075,
       0,     0,     0,  1220,     0,     0,     0,  1221,     0,  1715,
    3149,     0,  1703,  3258,     0,     0,  3149,  3149,  3149,  3149,
    3149,  3149,     0,     0,  1222,     0,  1297,     0,     0,     0,
    4101,     0,   682,     0,     0,     0,     0,   700,     0,     0,
       0,     0,     0,     0,  1704,  1223,  2143,  2144,  2145,  2146,
    2147,  2148,     0,     0,  3700,     0,     0,     0,     0,  1707,
       0,     0,     0,  1224,     0,  4124,  4126,  4128,  4130,     0,
    2756,  2756,   802,     0,  1225,   700,     0,     0,     0,  1226,
       0,     0,  4140,     0,   799,     0,     0,     0,     0,     0,
    1708,     0,     0,     0,   207,   700,     0,     0,  1709,  1705,
    1227,     0,     0,     0,  1710,     0,     0,  4153,  4154,     0,
       0,  1711,     0,   989,     0,     0,     0,     0,     0,  1712,
       0,     0,     0,     0,  3977,  1228,   990,  1713,     0,     0,
    1706,  4186,   799,     0,   998,  1714,     0,     0,     0,     0,
     799,     0,     0,     0,     0,     0,     0,     0,     0,  1008,
    2123,   989,     0,  2124,  4014,  1029,     0,     0,     0,  3256,
       0,     0,     0,     0,     0,  1058,     0,     0,     0,     0,
    2125,     0,     0,  1063,  1229,     0,     0,     0,  2127,  3546,
      35,  4206,  4207,  4208,  2128,  1715,     0,     0,    41,    42,
       0,     0,  4220,     0,  2123,     0,     0,  2124,     0,     0,
       0,     0,   834,     0,     0,   808,     0,     0,  2129,   978,
       0,   402,     0,     0,  2125,     0,     0,  2126,  4061,     0,
       0,  4064,  2127,     0,     0,   978,     0,  1230,  2128,     0,
       0,  1231,     0,  1232,     0,     0,     0,     0,     0,  1233,
       0,     0,  1234,     0,     0,  3585,     0,  3587,     0,     0,
       0,     0,  2129,   808,     0,   207,  4246,  4247,     0,  1709,
       0,   808,     0,     0,     0,  1710,   402,  1235,     0,  1236,
       0,     0,  1711,  1237,     0,     0,     0,   978,     0,     0,
    1794,  1238,     0,     0,     0,     0,  1239,     0,  1713,   802,
       0,     0,  1376,  1377,     0,     0,  1714,     0,     0,     0,
       0,  4108,     0,     0,   801,  3698,     0,     0,  2130,     0,
    1240,     0,  2131,  4294,  4295,     0,  4123,     0,     0,     0,
     364,     0,     0,     0,     0,  3639,     0,     0,     0,     0,
    3646,     0,     0,  2132,  2133,    80,     0,   802,     0,     0,
    2123,     0,     0,  2124,     0,   802,  1715,     0,  2134,     0,
    3258,     0,  2130,     0,     0,     0,  2131,     0,     0,     0,
    2125,     0,     0,     0,     0,     0,     0,     0,  2127,     0,
       0,     0,     0,  2135,  2128,     0,  2136,  2132,  2133,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2137,
       0,     0,  2134,     0,     0,     0,     0,     0,  2129,     0,
       0,     0,     0,  2756,     0,     0,     0,     0,     0,     0,
       0,     0,  2756,     0,     0,     0,     0,  2135,     0,     0,
    2136,     0,     0,  4350,  4351,     0,  4353,   978,     0,  2756,
    2756,     0,     0,  2137,     0,     0,  2138,     0,     0,  3149,
    3149,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1297,     0,     0,     0,  4368,     0,  4369,
       0,     0,  4373,  4374,  2139,     0,     0,     0,     0,     0,
    3700,  3700,  3700,  3700,  3700,     0,  3798,     0,     0,     0,
    3801,     0,  3803,     0,  3805,  3806,     0,     0,     0,     0,
       0,     0,     0,  3811,     0,     0,     0,     0,  2130,     0,
       0,     0,  2131,     0,     0,     0,     0,     0,  2139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4406,
       0,   801,  1723,  2132,  2133,     0,     0,  3829,  1724,     0,
       0,     0,     0,     0,     0,     0,     0,   364,  2134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4428,     0,
       0,     0,  2140,  2141,  2142,     0,  2143,  2144,  2145,  2146,
    2147,  2148,     0,  2135,  2290,     0,  2136,     0,  1725,   801,
       0,  4220,  4220,  4220,  4220,     0,     0,   801,     0,  2137,
       0,     0,  2138,     0,   700,   364,    74,     0,     0,  4450,
     978,     0,     0,   364,     0,     0,  2140,  2141,  2142,     0,
    2143,  2144,  2145,  2146,  2147,  2148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4466,  4467,  1726,     0,     0,
       0,     0,     0,  4337,  1727,     0,     0,  1728,     0,  2756,
       0,   978,     0,     0,     0,  4347,     0,  2123,     0,     0,
    2124,     0,     0,     0,  4340,  4341,     0,     0,     0,  4344,
    4345,     0,     0,     0,  2139,     0,     0,  2125,     0,     0,
       0,     0,     0,     0,     0,  2127,   402,     0,     0,     0,
       0,  2128,     0,     0,     0,     0,     0,     0,     0,  1729,
    1174,     0,     0,     0,     0,     0,  1194,     0,     0,     0,
       0,     0,     0,  3691,  1203,  2129,     0,     0,     0,     0,
       0,     0,  1213,     0,     0,     0,     0,  1244,     0,     0,
       0,     0,     0,     0,     0,     0,  3149,     0,     0,     0,
    4533,  3698,  3698,  3698,  3698,  3698,     0,     0,     0,   978,
       0,     0,     0,  1730,     0,  1731,     0,     0,     0,     0,
       0,     0,  2140,  2141,  2142,  1732,  2143,  2144,  2145,  2146,
    2147,  2148,     0,  1733,  2872,     0,     0,     0,     0,     0,
    2873,     0,  1734,     0,  1155,  1161,  1161,   700,     0,  1161,
    1168,     0,  1155,   682,  1058,     0,  1191,     0,   682,     0,
    1058,     0,  1058,     0,     0,     0,  1161,   682,  1058,     0,
       0,     0,     0,  1797,     0,  2130,  1215,  1736,     0,  2131,
       0,  1058,     0,  1155,     0,     0,  1161,     0,   700,     0,
    1161,     0,     0,     0,   682,  4595,  1191,     0,   682,  1268,
    2132,  2133,  1798,     0,     0,     0,  1161,     0,     0,   682,
       0,     0,     0,     0,     0,  2134,     0,  4603,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4603,     0,     0,
       0,     0,     0,  1296,     0,  1411,     0,  1155,     0,     0,
    2135,     0,   700,  2136,     0,     0,  1155,     0,     0,  1191,
       0,     0,     0,     0,     0,     0,  2137,     0,  1738,  2138,
       0,     0,     0,   402,  1161,     0,     0,  1536,     0,     0,
       0,     0,  1297,     0,     0,  1358,  4643,     0,  4493,     0,
       0,     0,     0,     0,  1559,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1585,     0,     0,     0,
       0,   402,     0,     0,     0,     0,     0,  1058,     0,   402,
       0,     0,     0,     0,   978,     0,     0,     0,     0,  1058,
    1412,  2139,     0,     0,     0,  1723,     0,     0,     0,     0,
       0,  1724,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4688,     0,     0,  1518,     0,     0,     0,
     700,  1058,     0,     0,  1296,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1058,     0,
       0,  1725,  1058,     0,     0,     0,     0,  4200,     0,     0,
    1518,     0,     0,     0,  4203,  4204,     0,     0,     0,     0,
    1058,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1058,     0,     0,     0,     0,     0,     0,  2140,
    2141,  2142,     0,  2143,  2144,  2145,  2146,  2147,  2148,     0,
    1726,     0,     0,  2123,     0,  3350,  2124,  1727,     0,     0,
    1728,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     682,   682,     0,  2125,     0,     0,     0,     0,     0,     0,
       0,  2127,  2123,     0,     0,  2124,     0,  2128,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2125,     0,     0,  1882,     0,     0,     0,     0,
    2127,  2129,  1729,  1058,     0,  2123,  2128,     0,  2124,     0,
    1161,  1161,     0,  4801,     0,  1907,  1910,  1911,     0,     0,
       0,     0,     0,     0,     0,  2125,     0,     0,     0,     0,
    2129,     0,     0,  2127,     0,     0,     0,     0,     0,  2128,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1155,
       0,     0,     0,     0,     0,     0,  1730,     0,  1731,  1155,
       0,  4801,  1191,  2129,     0,     0,     0,     0,  1732,  4801,
       0,     0,     0,     0,     0,  1161,  1733,     0,     0,  2123,
       0,     0,  2124,     0,     0,  1734,     0,     0,     0,  1058,
    4678,     0,     0,     0,     0,  1161,  1161,     0,     0,  2125,
       0,  2130,     0,     0,     0,  2131,     0,  2127,     0,  1058,
    1058,  1058,  1161,  2128,  1155,     0,  2365,     0,  1920,     0,
    1736,     0,     0,     0,  4334,  4335,  2132,  2133,     0,     0,
    2130,  1536,     0,     0,  2131,     0,     0,  2129,     0,     0,
       0,  2134,     0,     0,     0,  2366,  1161,  1161,     0,     0,
       0,     0,     0,     0,     0,  2132,  2133,     0,  1536,     0,
       0,     0,     0,  2130,     0,  1296,  2135,  2131,     0,  2136,
    2134,     0,     0,     0,  4357,  4358,     0,     0,     0,     0,
    1518,     0,  2137,     0,     0,  2138,     0,     0,  2132,  2133,
    1296,     0,     0,     0,     0,  2135,     0,     0,  2136,     0,
       0,  1738,     0,  2134,   686,     0,     0,     0,     0,     0,
       0,  2137,     0,     0,  2138,     0,     0,     0,     0,     0,
    2017,  2017,     0,     0,     0,  1058,     0,   989,  2135,     0,
       0,  2136,     0,     0,     0,     0,     0,  2130,     0,     0,
       0,  2131,     0,     0,  2137,     0,     0,  2138,     0,  2049,
       0,     0,  1058,     0,     0,  2055,  1296,  2139,     0,     0,
       0,     0,  2132,  2133,  4798,     0,     0,  1518,     0,     0,
       0,     0,  2123,     0,     0,  2124,     0,  2134,     0,     0,
       0,   980,     0,     0,     0,     0,  2139,     0,     0,     0,
       0,     0,     0,     0,     0,  1518,  4439,  2206,  4440,  4441,
    2127,   980,  2135,     0,     0,  2136,  2128,     0,     0,  4444,
       0,     0,  4798,     0,     0,     0,     0,     0,  2137,  2139,
    4798,  2138,     0,  1518,  1518,     0,  1518,     0,     0,     0,
    2129,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1518,  2255,  2140,  2141,  2142,     0,  2143,
    2144,  2145,  2146,  2147,  2148,     0,     0,     0,     0,     0,
       0,  3398,     0,   700,   700,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2140,  2141,  2142,  1296,  2143,  2144,
    2145,  2146,  2147,  2148,  1296,  1296,     0,     0,  2786,     0,
       0,  1058,  3907,  2139,  1518,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2140,  2141,  2142,
       0,  2143,  2144,  2145,  2146,  2147,  2148,     0,     0,  2123,
       0,  3692,  2124,  1518,     0,     0,     0,  1518,  1518,     0,
   -2529,     0,     0,     0,  2131,     0,     0,  1058,  1058,  2257,
       0,     0,     0,     0,     0,     0,     0,  2127,     0,     0,
       0,     0,     0,  2128,     0,  2132,  2133,     0,     0,     0,
       0,     0,     0,     0,     0,   700,     0,   682,  2412,     0,
   -2529,  2123,     0,     0,  2124,     0,     0,  2129,     0,     0,
       0,  2140,  2141,  2142,     0,  2143,  2144,  2145,  2146,  2147,
    2148,  2125,     0,     0,     0,  3888,     0,     0,  2136,  2127,
       0,     0,     0,     0,     0,  2128,     0,     0,     0,     0,
       0,  2137,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2471,     0,     0,     0,     0,     0,     0,  2129,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4255,
       0,     0,  4594,     0,     0,     0,     0,     0,     0,  2498,
       0,     0,     0,     0,     0,     0,  2400,     0,     0,     0,
       0,     0,  1058,     0,     0,  1161,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2529,     0,     0,
    1191,  2131,     0,     0,     0,     0, -2529,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4620,     0,
       0,     0,  2132,  2133,     0,     0,     0,     0,     0,     0,
       0,     0,  1161,  1161,  1161,  1161,  1058, -2529,     0,     0,
       0,     0,     0,     0,     0,   682,     0,  4644,     0,  2130,
       0,     0,     0,  2131,     0,     0,     0,     0,     0,     0,
       0,  2497,     0,  1058,     0,  2136,     0,     0,     0,     0,
       0,  1161,  1161,     0,  2132,  2133,     0,  1161,  2137,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2134,
       0,     0,     0,     0,     0,     0,     0,     0,  2143,  2144,
    2145,  2146,  2147,  2148,     0,     0,     0,     0,     0,     0,
    2625,     0,     0,     0,  2135,     0,     0,  2136,     0,  2629,
       0,     0,     0,     0,  1161,     0,     0,     0,     0,     0,
    2137,     0,     0,  2138,     0,     0,     0,     0,     0,  2644,
       0,     0,   682,     0,     0,     0,     0,     0,  1161,  1161,
    1161,  1161,     0, -2529,     0,     0,     0,     0,   682,     0,
       0,     0,     0,     0,     0,     0,     0,  2497,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1155,     0,     0,  1536,  1536,     0,     0,   700,
       0,  1155,     0,     0,     0,     0,     0,     0,     0,  1191,
       0,     0,     0,     0,  1058,  2139,     0,     0,     0,     0,
       0,     0,     0,  1058,     0,   682,     0,     0,     0,  1161,
    1161,     0,     0,  2123,     0,     0,  2124,     0,     0,     0,
       0,     0,     0,  1058,     0,     0,  1358,     0,     0,     0,
       0,     0,     0,  2125,     0,  2143,  2144,  2145,  2146,  2147,
    2148,  2127,     0,     0,     0,     0,     0,  2128,     0,     0,
       0,     0,     0,     0,     0,  4786,     0,  2017,     0,     0,
       0,     0,     0,     0,     0,  1155,     0,     0,     0,  1058,
    1058,  2129,     0,     0,     0,     0,     0,  1058,     0,     0,
       0,     0,     0,  2140,  2141,  2142,     0,  2143,  2144,  2145,
    2146,  2147,  2148,   989,   989,  3958,     0,  2703,     0,     0,
       0,  1518,  1518,     0,  2845,     0,     0,     0,     0,  1518,
       0,     0,  1518,     0,     0,  1518,     0,     0,     0,     0,
       0,     0,     0,  1518,  1518,     0,     0,     0,     0,  2865,
       0,  1518,     0,  1191,  1518,  1518,  1518,  1518,     0,     0,
       0,     0,     0,     0,  1518,  1518,     0,  1518,     0,  1518,
    1518,     0,     0,  1518,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2878,     0,  2881,  1518,     0,
       0,  2130,  1161,  1518,     0,  2131,     0,  1518,     0,     0,
       0,  1518,     0,  1518,  1518,  1518,  1518,  1518,  1518,  1518,
    1518,  1518,     0,  1518,     0,     0,  2132,  2133,  1058,  1518,
       0,     0,  1518,     0,     0,     0,     0,     0,     0,     0,
       0,  2134,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1058,     0,     0,     0,     0, -2038,     0,
       0,     0,     0,     0,     0,     0,  2135,     0,     0,  2136,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2137,     0,     0,  2138,     0,     0,     0,  1058,
       0,  1058,     0,  1518,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2038,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2038,   980,     0,   980,
   -2038,   980,     0,     0,     0, -2038,     0,   980,     0,  2909,
   -2038,  2916,     0, -2038,     0, -2038,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     980,   980,     0,     0,     0,     0,     0,  2139,   682,     0,
       0,     0, -2038,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2038,     0,     0,   682,     0,     0,     0,     0,
     682,     0,  3049,   682,   700,     0,     0,     0,     0,   989,
       0,   989,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   682,  1518,     0, -2038,     0,
       0,  1155,     0,  1161,  1161,  1161, -2038,  1155,  1191,     0,
    1161,     0,  1161,     0,  1161,  1161,     0,     0,     0,     0,
       0,     0,     0,     0,   682,  2140,  2141,  2142,     0,  2143,
    2144,  2145,  2146,  2147,  2148,     0,     0,     0,     0,  3963,
       0,     0,     0,     0,     0,     0,     0,   682,   980,  2400,
       0, -2038,     0,     0,     0,  3031,     0,     0,     0,     0,
    3040,     0,   686,   686,     0,     0,  1058,  1658,     0,     0,
     682,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3071,  3071,     0,     0,     0,     0,     0,   700,   682,
       0,     0,   682,   860,     0,   993,     0,     0,     0,     0,
       0,     0,  1161,     0,     0,   861,     0,     0,     0,   682,
     980,  3213,     0,     0,     0,     0,   682,     0, -2038,     0,
       0,     0,     0,     0,     0,  3119,   862,  3121,  3123,   682,
       0,     0,     0,     0,     0,     0,     0,     0,   682,   863,
       0, -2038,     0, -2038, -2038,     0,     0,     0,   864,     0,
       0,     0,  -698,     0,  1161,     0,     0,     0,     0,     0,
       0,     0,  1161,  1161,  1161,  1161,  1161,  1161,     0,   865,
       0,     0,     0,     0,     0,   866, -2038,  1518,     0, -2038,
   -2038,     0, -2038,     0,     0,     0,     0,     0,     0,     0,
     867,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2400,     0,     0,     0,  3071,  1058,     0,     0,   868,   989,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   869,
       0,     0,     0,     0,     0,     0,   870,     0,     0,     0,
     871,     0,     0,     0,  3119,     0,     0,     0,     0,     0,
       0,  1161,  3244,     0,     0,  -886,     0,     0,     0,     0,
       0,  1296,  1920,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1161,
    3071,  1161,  3071,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   872,     0,     0,     0,  1296,     0,     0,     0,
       0,     0,   980,     0,  1518,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2017,     0,     0,     0,   873,
       0,     0,   874,     0,     0,     0,     0,     0,     0,     0,
       0,   682,  2123,     0,     0,  2124,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2125,   682,     0,     0,     0,  1155,     0,     0,
    2127,  1155,     0,     0,     0,     0,  2128,     0,     0,  1161,
       0,     0,   875,     0,     0,  1518,  1518,     0,   876,     0,
       0,     0,     0,     0,  -377,     0,     0,   877,     0,     0,
    2129,     0,     0,     0,     0,     0,     0,     0,     0,  3434,
       0,     0,     0,     0,     0,  1518,  1518,     0,     0,     0,
    1518,     0,  -377,     0,   878,   879,     0,   880,   881,     0,
       0,     0,  1518,  1518,  1518,  1518,   882,     0,     0,     0,
       0,   883,     0,     0,     0,  1518,   884,     0,  1518,   885,
    1518,  3402,   886,     0,     0,     0,     0,     0,     0,     0,
    1518,  1518,     0,  1536,  1518,  -377,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1518,     0,  1518,
       0,  1191,     0,  1518,     0,     0,     0,     0,     0,     0,
       0,     0,   980,     0,     0,     0,   980,   980,     0,  1518,
    2130,     0,     0,  1058,  2131,     0,     0,     0,     0,     0,
    3447,     0,  1518,  1518,  1518,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2132,  2133,     0,     0,     0,
       0,     0,  1296,     0,     0,     0,  1518,     0,     0,     0,
    2134,     0,     0,     0,     0,     0,     0,     0,  1518,     0,
       0,     0,     0,  1518,     0,     0,     0,  1058,     0,     0,
    1518,     0,     0,     0,     0,  2135,  3447,     0,  2136,  3507,
       0,     0,     0,  2916,   807,     0,     0,     0,     0,   686,
       0,  2137,     0,     0,  2138,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   682,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   807,     0,
       0,     0,     0,     0,     0,     0,  1518,     0,  3071,     0,
       0,     0,     0,  2017,     0,     0,     0,  2123,     0,   821,
    2124,     0,  1296,     0,     0,     0,     0,     0,     0,   980,
    1161,     0,  1161,  1161,     0,   980,  2139,  2125,     0,     0,
       0,     0,     0,     0,  1020,  2127,     0,     0,     0,     0,
       0,  2128,  1020,     0,  1020,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   822,   807,     0,     0,     0,
       0,     0,     0,     0,     0,  2129,     0,     0,   823,   980,
       0,     0,   980,   980,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   824,     0,     0,     0,     0,
       0,   825,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   682,     0,     0,     0,   826,     0,     0,   682,
       0,     0,     0,     0,  2140,  2141,  2142,     0,  2143,  2144,
    2145,  2146,  2147,  2148,   827,     0,     0,     0,  3989,     0,
       0,     0,   980,     0,     0,   828,     0,     0,  3735,     0,
     829,     0,     0,     0,     0,     0,   830,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   831,     0,  3750,     0,  2130,     0,   682,     0,  2131,
    3758,     0,     0,     0,  3763,     0,     0,  3071,  3071,     0,
       0,     0,     0,     0,     0,     0,   832,     0,     0,  3775,
    2132,  2133,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2134,  3699,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3807,     0,
       0,  3808,     0,     0,     0,     0,  1296,     0,  1296,     0,
    2135,     0,  1058,  2136,     0,   833,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2137,     0,     0,  2138,
       0,     0,     0,     0,     0,     0,  2017,  1058,  1536,     0,
       0,     0,     0,   834,  1058,     0,     0,     0,  1058,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1058,     0,     0,     0,     0,   835,  1296,
       0,     0,     0,     0,   836,     0,     0,     0,   700,     0,
     837,     0,     0,   838,     0,     0,     0,     0,     0,     0,
       0,     0,  1058,     0,     0,  1058,     0,     0,   682,     0,
       0,  2139,  3812,     0,     0,     0,     0,     0,   839,     0,
     840,     0,     0,  1155,   841,     0,   682,     0,     0,     0,
       0,     0,   842,     0,     0,     0,     0,   843,     0,     0,
       0,     0,  1058,     0,   682,     0,     0,     0,   844,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,  1518,     0,
       0,   845,     0,     0,  3913,  3914,  3915,  1518,     0,     0,
       0,     0,     0,  1518,     0,  1518,     0,     0,     0,     0,
       0,  1518,     0,     0,  1518,  1518,  1518,  1518,  1518,  1518,
    1518,  1518,  1518,  1518,     0,     0,     0,  1518,  1518,  2140,
    2141,  2142,     0,  2143,  2144,  2145,  2146,  2147,  2148,     0,
    1518,     0,     0,  4223,  1518,     0,     0,     0,  1518,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1518,     0,
       0,  1518,     0,  1518,     0,     0,     0,     0,     0,     0,
       0,     0,  1518,  1518,  1518,     0,     0,     0,  1518,     0,
       0,  1518,     0,     0,     0,     0,     0,     0,  1058,  1058,
    1058,  3447,  3921,     0,     0,     0,  3921,  3934,     0,     0,
       0,  1518,     0,     0,     0,     0,     0,  3948,     0,  1518,
       0,  1518,     0,  2123,     0,     0,  2124,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2125,     0,     0,     0,     0,     0,     0,
       0,  2127,     0,     0,     0,     0,     0,  2128,     0,     0,
       0,     0,     0,     0,     0,  1518,     0,  1865,     0,     0,
       0,  1518,     0,     0,     0,  2916,     0,  1518,   980,     0,
       0,  2129,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3995,  2017,  2017,     0,  2497,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1161,  1161,
    1161,  1161,     0,     0,     0,     0,   980,   682,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1658,     0,     0,  4028,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     807,     0,     0,     0,  4120,     0,     0,     0,  1157,     0,
       0,  2130,     0,     0,     0,  2131,  1157,     0,     0,     0,
       0,   682,     0,  4146,   682,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2132,  2133,  4077,     0,
       0,     0,     0,     0,     0,     0,  4157,  1157,     0,     0,
       0,  2134,     0,   914,     0,  1865,     0,     0,     0,     0,
       0,     0,  1296,     0,     0,   915,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2135,     0,     0,  2136,
       0,     0,     0,     0,     0,     0,   916,     0,     0,     0,
    3699,     0,  2137,     0,     0,  2138,     0,     0,  1058,   917,
       0,  1157,     0,     0,     0,     0,     0,     0,     0,  1161,
    1157,  1518,   918,     0,     0,     0,     0,  1058,   980,     0,
       0,     0,     0,     0,     0,     0,   980,     0,   980,   919,
    2400,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1058,     0,     0,     0,     0,     0,     0,     0,     0,  3119,
     920,     0,     0,     0,  4174,     0,     0,     0,  2400,     0,
    3812,     0,     0,     0,     0,     0,     0,  2139,   921,     0,
       0,  1518,  1518,     0,     0,     0,     0,     0,     0,   922,
       0,     0,     0,     0,   923,     0,     0,     0,     0,     0,
     924,     0,     0,     0,     0,  3071,  2189,  3071,     0,     0,
       0,     0,     0,     0,     0,   925,     0,     0,  4258,  4259,
    4260,  4261,     0,     0,     0,   682,     0,     0,     0,     0,
    1157,     0,     0,     0,     0,     0,  1020,     0,     0,     0,
    1020,  1518,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1157,  2140,  2141,  2142,     0,  2143,
    2144,  2145,  2146,  2147,  2148,     0,     0,  1518,     0,  4257,
       0,     0,     0,     0,     0,     0,     0,  1518,  1518,   926,
       0,     0,     0,     0,     0,  1518,  1518,     0,     0,   927,
    1518,     0,     0,     0,     0,     0,  1518,  1518,     0,     0,
    1518,     0,  1058,  1058,  1058,  1058,     0,   834,     0,  3921,
       0,     0,  4263,     0,     0,  3447,     0,     0,     0,  3447,
       0,  1865,     0,     0,     0,  4276,     0,     0,  1518,     0,
       0,     0,   928,  1518,     0,     0,   929,     0,   930,  4286,
       0,     0,     0,     0,   931,  1518,     0,   932,   980,     0,
       0,     0,     0,     0,  1191,     0,     0,     0,     0,     0,
       0,     0,  3507,     0,     0,     0,  2916,     0,  1865,     0,
       0,     0,   933,     0,   934,     0,     0,     0,   935,     0,
     989,     0,     0,  1518,     0,     0,   936,     0,     0,     0,
       0,   937,     0,     0,  1865,     0,     0,     0,     0,     0,
    3071,  3071,   938,  1157,     0,     0,  1857,     0,     0,     0,
       0,     0,     0,  1157,     0,   939,     0,  4332,     0,     0,
       0,     0,     0,     0,     0,     0,   682,     0,     0,     0,
       0,     0,     0,     0,     0,  1868,     0,     0,   682,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1161,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1865,     0,     0,     0,  1161,     0,     0,  1157,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1865,     0,     0,     0,     0,     0,     0,     0,     0,  1296,
       0,     0,     0,     0,  4434,     0,     0,  2017,  1865,     0,
       0,     0,     0,     0,     0,     0,  3699,  3699,  3699,  3699,
    3699,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1865,     0,     0,     0,
    1518,     0,     0,     0,  1157,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   980,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2123,  1161,  2400,
    2124,     0,     0,     0,  1857,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2125,     0,     0,
       0,     0,     0,     0,  1865,  2127,     0,     0,  1058,     0,
    4438,  2128,     0,  1868,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   682,     0,     0,     0,
       0,     0,     0,     0,     0,  2129,     0,     0,  1518,     0,
       0,  1157,     0,     0,     0,     0,     0,  1518,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1518,  1518,     0,     0,  1518,  1157,
       0,     0,     0,     0,     0,  3921,     0,     0,     0,  3447,
       0,     0,     0,     0,  3447,     0,     0,  3447,  3119,     0,
    4482,     0,  1518,  1518,     0,     0,     0,  1157,  1157,     0,
    1157,     0,     0,     0,  4541,     0,     0,     0,     0,     0,
    1160,  1162,     0,     0,  1165,  1166,     0,  1157,     0,   682,
       0,   682,     0,     0,     0,  3995,  1191,  1161,  1161,  1161,
       0,  1200,     0,     0,     0,  2130,  1536,     0,     0,  2131,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1249,     0,  1155,  1191,  1252,     0,     0,     0,     0,
    2132,  2133,     0,     0,     0,     0,     0,     0,  1157,   807,
       0,  1273,     0,     0,     0,  2134,     0,     0,     0,     0,
       0,     0,     0,  2017,     0,     0,     0,     0,     0,  1155,
       0,     0,     0,  1865,     0,     0,     0,  1157,  1058,     0,
    2135,  1157,  1157,  2136,     0,     0,     0,     0,     0,     0,
       0,  3071,     0,  2400,     0,     0,  2137,     0,     0,  2138,
       0,     0,     0,     0,     0,  4174,     0,     0,     0,     0,
    1058,  4627,     0,     0,     0,     0,     0,     0,     0,  1161,
    3995,     0,     0,     0,     0,     0,     0,     0,  2123,     0,
    1857,  2124,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   980,     0,  1518,     0,     0,  1518,  2125,  1518,
       0,     0,  2886,     0,     0,   980,  2127,     0,     0,  1868,
       0,     0,  2128,     0,     0,   807,  1518,     0,     0,     0,
    3447,  2139,  1020,  4482,     0,     0,     0,  1857,     0,  4614,
       0,     0,     0,     0,     0,     0,  2129,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1020,
       0,  1161,     0,  1857,     0,  1058,  1868,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2040,     0,  1161,  1161,
    1161,  1161,     0,     0,     0,     0,     0,     0,  1296,     0,
       0,  2887,  1868,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1518,  2123,     0,     0,  2124,     0,     0,     0,     0,  2140,
    2141,  2142, -2040,  2143,  2144,  2145,  2146,  2147,  2148,     0,
    1857,  2125,     0,  4460, -2040,     0,     0,     0, -2040,  2127,
       0,  1020,     0, -2040,     0,  2128,  2130,     0, -2040,  1857,
    2131, -2040,     0, -2040,     0,     0,     0,     0,     0,  1868,
       0,   980,     0,     0,     0,     0,     0,  1857,  1518,  2129,
       0,  2132,  2133,     0,  1161,     0,  1191,     0,  1868,     0,
   -2040,     0,     0,  1518,     0,     0,  2134,     0,     0,     0,
       0,     0,     0,  1865,     0,  1857,  1868,     0,  1865,  1865,
   -2040,     0,     0,     0,     0,  1743,  1744,     0,     0,  1865,
       0,  2135,     0,  1161,  2136,     0,  1155,     0,     0,   807,
       0,     0,     0,     0,  1868,  3995,     0,  2137,     0,     0,
    2138,     0,     0,     0,  4438,     0, -2040,     0,     0,     0,
       0,     0,     0,  4614, -2040,     0,  1518,  1518,     0,   682,
       0,     0,     0,  1857,     0,     0,     0,     0,     0,  1155,
       0,     0,     0,     0,     0,     0,     0,  1161,     0,  2130,
    1825,     0,     0,  2131,     0,     0,  1157,     0,     0,     0,
       0,     0,  1868,     0,     0,  1157,     0,     0,     0, -2040,
    1884,  1885,     0,  1518,  2132,  2133,     0,     0,     0,     0,
       0,     0,  2139,  1518,     0,     0,     0,  1912,  1161,  2134,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   993,  2135,  1865,     0,  2136,     0,     0,
       0,  1943,  1945,     0,     0,     0,     0,     0,     0,     0,
    2137,  2888,     0,  2138,     0,     0, -2040,     0,     0,     0,
       0,     0,  1518,     0,     0,     0,     0,     0,     0,  1157,
       0,  1155,     0,     0,     0,     0,     0,     0,     0, -2040,
       0, -2040, -2040,     0,     0,     0,     0,     0,     0,     0,
    2140,  2141,  2142,     0,  2143,  2144,  2145,  2146,  2147,  2148,
       0,     0,     0,     0,  1865,  1157,  1157,     0,     0,     0,
       0,     0,     0,  1157, -2040,     0,  1157, -2040, -2040,  1157,
   -2040,     0,     0,     0,     0,  2139,     0,  1157,  1157,     0,
       0,     0,     0,     0,     0,  1157,   980,     0,  1157,  1157,
    1157,  1157,  1857,     0,     0,     0,     0,     0,  1157,  1157,
       0,  1157,   980,  1157,  1157,     0,     0,  1157,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1868,  1157,   807,     0,     0,     0,  1157,     0,     0,
       0,  1157,     0,     0,     0,  1157,     0,  1157,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,     0,  1157,     0,  1865,
       0,     0,     0,  1157,   980,     0,  1157,     0,     0,     0,
       0,     0,     0,  2140,  2141,  2142,     0,  2143,  2144,  2145,
    2146,  2147,  2148,     0,     0,     0,     0,  4502,     0,     0,
       4,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       6,     7, -2052,     0,     0,     0,     8,  1157,     9,    10,
       0,     0,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,    36,     0,
      37,    38,    39,    40,    41,    42,    43,    44, -2052,     0,
       0,    45,     0,     0,     0,     0,     0,     0,     0,     0,
   -2052,     0,     0,     0, -2052,     0,     0,     0,     0, -2052,
       0,     0,     0,     0, -2052,     0,     0, -2052,     0, -2052,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   980,     0,     0,     0,     0,    46,
       0,     0,     0,   807,     0,     0, -2052,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2052,     0,     0,     0,
    1157,     0,     0,     0,     0,  1157,     0,     0,     0,     0,
       0,  1157,  1857,     0,     0,     0,     0,  1857,  1857,     0,
       0,     0,     0,     0,     0,     0,  1867,     0,  1857,     0,
       0,     0, -2052,     0,     0,     0,     0,     0,     0,    47,
   -2052,  1868,     0,     0,     0,     0,  1868,  1868,     0,     0,
       0,     0,     0,     0,     0,    48,     0,  1868,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2415,     0,     0,   807,     0,    49,   807,     0,     0,     0,
       0,     0,     0,     0,     0, -2052,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    50,     0,     0,
       0,  1865,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2467,  2468,  2469,
    2470,     0,     0,     0,     0,     0,     0,   980,     0,   993,
      51,     0,     0,    52,     0,     0,     0,     0,     0,  1865,
    1865,     0,  1865,     0,     0,     0,     0,     0,    53,     0,
       0,     0, -2052,     0,  1857,     0,  2505,  2506,     0,     0,
       0,     0,  2515,     0,     0,     0,     0,     0,   980,     0,
       0,     0,     0,     0,     0, -2052,     0, -2052, -2052,     0,
       0,  1157,     0,  1868,  1867,     0,     0,     0,     0,     0,
       0,     0,  1865,     0,  1865,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2536,
   -2052,     0,     0, -2052, -2052,     0, -2052,     0,     0,     0,
       0,    54,     0,  1857,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2569,  2570,  2571,  2572,     0,  1865,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1868,     0,     0,     0,     0,     0,     0,  1865,
       0,     0,    55,     0,     0,     0,   980,     0,     0,     0,
       0,     0,     0,     0,     0,    56,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1865,     0,     0,     0,
      57,     0,     0,     0,     0,     0,     0,     0,  1157,  1865,
       0,     0,     0,     0,     0,  2636,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    58,     0,  1857,     0,
       0,     0,    59,     0,     0,     0,    60,    61,    62,    63,
      64,     0,     0,    65,    66,    67,    68,     0,    69,    70,
      71,    72,    73,     0,     0,     0,     0,  1868,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1157,     0,  1865,     0,  1157,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1865,     0,     0,  1157,
    1157,     0,     0,     0,     0,     0,     0,     0,     0,  1865,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1157,
    1157,     0,     0,     0,  1157,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1157,  1157,  1157,  1157,
       0,     0,     0,     0,   807,     0,     0,  1018,     0,  1157,
     807,     0,  1157,     0,  1157,  1018,     0,  1018,     0,     0,
    1867,     0,     0,     0,  1157,  1157,     0,  1865,  1157,     0,
       0,     0,     0,     0,     0,     0,     0,  2799,     0,     0,
       0,  1157,     0,  1157,     0,     0,  1865,  1157,     0,     0,
       0,   980,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1157,     0,     0,     0,  2393,     0,     0,
       0,  1865,     0,     0,  1157,     0,  1157,  1157,  1157,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1867,     0,     0,     0,     0,     0,     0,
    1157,     0,     0,     0,     0,     0,     0,  1865,     0,     0,
       0,     0,  1157,     0,     0,     0,     0,  1157,     0,     0,
       0,     0,     0,     0,  1157,     0,     0,     0,     0,     0,
    1157,     0,     0,     0,     0,  2123,     0,     0,  2124,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2125,     0,     0,     0,     0,
    1867,     0,     0,  2127,     0,     0,     0,     0,     0,  2128,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1867,
    1857,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1157,     0,     0,  2129,     0,     0,     0,  1867,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1868,
       0,     0,     0,     0,     0,     0,     0,     0,  1857,  1857,
       0,  1857,     0,     0,     0,  1867,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1868,  1868,     0,
    1868,     0,     0,     0,     0,     0,     0,     0,  2983,  2984,
    2985,     0,     0,     0,     0,  2993,     0,  2995,     0,  2997,
    2998,  1857,     0,  1857,     0,     0,     0,   807,   807,   807,
       0,     0,     0,  1867,     0,     0,     0,     0,     0,     0,
    1865,     0,     0,  2130,     0,     0,     0,  2131,     0,     0,
    1868,     0,  1868,     0,     0,     0,  1859,  4679,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1857,  2132,  2133,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2134,     0,     0,     0,     0,  1857,     0,
       0,     0,     0,     0,     0,     0,  1868,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3092,  2135,     0,
       0,  2136,     0,     0,     0,  1857,     0,  1868,     0,     0,
       0,     0,     0,     0,  2137,     0,     0,  2138,  1857,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   807,
       0,     0,     0,     0,  1868,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   807,  1868,     0,  3141,
       0,     0,     0,     0,     0,     0,     0,  3150,  3151,  3152,
    3153,  3154,  3155,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1865,     0,     0,     0,     0,     0,     0,
       0,     0,  1857,     0,     0,     0,     0,     0,     0,  2139,
       0,     0,     0,     0,     0,  1857,     0,     0,     0,     0,
       0,     0,     0,     0,  1859,     0,  1865,     0,  1857,     0,
       0,  1868,  1867,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1868,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3234,  1868,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2858,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2123,     0,     0,  2124,  3274,     0,  3276,  1157,     0,     0,
       0,     0,     0,     0,     0,     0,  1857,  2140,  2141,  2142,
    2125,  2143,  2144,  2145,  2146,  2147,  2148,     0,  2127,     0,
       0,  4543,     0,     0,  2128,  1857,     0,     0,     0,     0,
       0,     0,  1157,     0,     0,  1868,     0,     0,     0,     0,
       0,  1157,     0,     0,     0,     0,  1865,  1157,  2129,  1157,
    1857,     0,     0,     0,  1868,  1157,     0,  1865,  1157,  1157,
    1157,  1157,  1157,  1157,  1157,  1157,  1157,  1157,     0,     0,
       0,  1157,  1157,     0,     0,     0,     0,     0,     0,  1868,
       0,     0,     0,     0,  1157,     0,  1857,     0,  1157,     0,
     807,  1153,  1157,     0,  3328,     0,     0,     0,     0,  1153,
       0,     0,  1157,  2123,     0,  1157,  2124,  1157,     0,     0,
       0,     0,     0,     0,     0,  1868,  1157,  1157,  1157,     0,
       0,     0,  1157,  2125,     0,  1157,     0,     0,     0,     0,
    1153,  2127,     0,     0,     0,  1157,     0,  2128,     0,     0,
       0,     0,     0,     0,     0,  1157,     0,     0,  2130,     0,
       0,     0,  2131,  1157,     0,  1157,     0,     0,     0,     0,
       0,  2129,     0,     0,  1865,     0,     0,     0,     0,     0,
       0,     0,     0,  2132,  2133,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1153,  1865,     0,     0,  2134,     0,
       0,     0,     0,  1153,     0,     0,     0,  1865,     0,  1157,
    1859,     0,  3018,     0,     0,  1157,     0,  2393,  3025,     0,
       0,  1157,     0,  2135,     0,     0,  2136,     0,  1867,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2137,
       0,     0,  2138,     0,     0,  1865,  1157,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1859,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2130,     0,     0,     0,  2131,     0,     0,     0,  1857,
       0,     0,     0,  1859,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2132,  2133,     0,     0,
       0,     0,     0,   807,     0,     0,     0,   807,  1868,   807,
       0,  2134,     0,  1153,  2139,     0,     0,     0,     0,  1018,
       0,     0,     0,  1018,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2135,     0,     0,  2136,
       0,     0,     0,     0,     0,     0,     0,  1153,     0,     0,
    1859,     0,  2137,     0,  1867,  2138,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1859,
       0,     0,     0,     0,     0,  3551,     0,  3552,  3553,     0,
       0,     0,     0,     0,     0,     0,     0,  1859,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1865,     0,
       0,     0,  2140,  2141,  2142,     0,  2143,  2144,  2145,  2146,
    2147,  2148,     0,     0,     0,  1859,  4725,     0,     0,     0,
       0,     0,  1857,  2393,     0,  1157,     0,  2139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1868,     0,     0,     0,  1857,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1859,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1868,  1157,  1157,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1153,     0,     0,  1860,
       0,     0,     0,     0,     0,  1865,  1153,     0,     0,     0,
       0,     0,     0,     0,     0,  2140,  2141,  2142,  1867,  2143,
    2144,  2145,  2146,  2147,  2148,     0,     0,     0,  1866,  4810,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1157,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1153,     0,     0,     0,  1857,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1857,     0,     0,     0,
       0,  1157,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1157,  1157,     0,  1868,     0,     0,     0,  1865,  1157,
    1157,     0,     0,     0,  1157,  1868,     0,     0,     0,     0,
    1157,  1157,     0,     0,  1157,     0,     0,     0,     0,     0,
       0,  1865,     0,     0,     0,     0,     0,  1153,     0,  1157,
       0,     0,     0,  1157,     0,     0,     0,     0,     0,     0,
       0,     0,  1157,     0,     0,     0,     0,  1157,     0,     0,
       0,  1865,     0,     0,     0,     0,     0,  1860,     0,  1157,
       0,     0,  1859,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2858,  2858,  2858,
       0,     0,     0,  1857,     0,     0,  1866,  1865,     0,     0,
       0,  1865,  1865,     0,     0,     0,     0,  1157,     0,     0,
       0,     0,     0,     0,  1857,     0,     0,     0,     0,     0,
       0,     0,  1868,     0,  1153,  3834,  1857,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1868,     0,     0,     0,     0,     0,     0,
       0,     0,  1153,     0,     0,  1868,     0,     0,     0,     0,
       0,     0,     0,     0,  1857,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1153,  1153,     0,  1153,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1868,     0,     0,     0,     0,     0,     0,
    1153,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   807,     0,     0,     0,     0,     0,     0,     0,     0,
    1867,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1153,     0,     0,  1157,     0,     0,     0,  2393,  3025,
       0,  3025,     0,     0,     0,     0,   807,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1153,     0,     0,     0,  1153,  1153,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1868,
       0,  1867,     0,  1867,     0,     0,     0,  1857,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1859,  1860,     0,     0,     0,  1859,  1859,     0,
       0,     0,  1157,     0,     0,     0,  1868,     0,  1859,     0,
       0,  1157,     0,  4009,  4010,  4011,  4012,  1867,     0,     0,
       0,     0,  1866,     0,     0,     0,     0,     0,  1157,  1157,
       0,     0,  1157,     0,     0,  1018,     0,     0,  1867,     0,
    1860,     0,     0,  1157,     0,     0,     0,     0,  1157,     0,
       0,  1157,     0,     0,     0,     0,  1157,  1157,     0,     0,
       0,     0,  1018,     0,     0,  3025,  1860,     0,     0,  1866,
       0,     0,     0,     0,     0,     0,     0,     0,  3025,     0,
       0,     0,     0,     0,  1857,     0,     0,     0,     0,  1157,
       0,     0,     0,     0,     0,  1866,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1868,     0,     0,     0,  1157,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1860,  1859,     0,     0,     0,     0,     0,
       0,     0,  1867,     0,  1018,     0,     0,     0,     0,     0,
       0,     0,  1860,  1157,     0,  3025,     0,     0,     0,     0,
       0,     0,  1866,     0,     0,     0,     0,     0,  1867,     0,
    1860,     0,     0,     0,  4138,     0,     0,  1857,     0,     0,
       0,  1866,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1860,  1866,
    1857,     0,     0,  1859,  1157,     0,  1868,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1866,  1157,  1868,
    1857,  1157,     0,  1157,     0,     0,  1867,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1157,     0,     0,     0,  1157,  1867,  1860,     0,     0,  1868,
       0,     0,     0,     0,     0,     0,  1857,     0,     0,     0,
    1857,  1857,     0,     0,     0,     0,     0,     0,     0,  1153,
    1867,     0,     0,     0,     0,  1866,     0,     0,  1153,     0,
       0,     0,     0,     0,     0,  1868,     0,     0,  1859,  1868,
    1868,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1867,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   807,     0,     0,     0,
       0,     0,     0,     0,  1157,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2858,     0,     0,     0,
       0,     0,  1868,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1153,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1157,     0,     0,  2123,     0,     0,  2124,     0,
       0,     0,     0,     0,     0,     0,     0,  1157,  1153,  1153,
       0,     0,     0,     0,     0,  2125,  1153,     0,     0,  1153,
       0,     0,  1153,  2127,     0,     0,     0,     0,     0,  2128,
    1153,  1153,     0,     0,     0,     0,     0,     0,  1153,     0,
    1157,  1153,  1153,  1153,  1153,  1860,     0,     0,     0,  1157,
       0,  1153,  1153,  2129,  1153,     0,  1153,  1153,     0,     0,
    1153,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1157,  1157,     0,     0,  1866,  1153,     0,     0,     0,     0,
    1153,     0,     0,  1157,  1153,     0,     0,     0,  1153,     0,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  3025,
    1153,     0,     0,     0,     0,     0,  1153,     0,     0,  1153,
       0,     0,     0,     0,     0,     0,  4352,  1157,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1157,     0,     0,
    4355,     0,  3374,     0,     0,     0,     0,  3375,     0,     0,
       0,     0,     0,   807,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2130,     0,     0,     0,  2131,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1153,     0,     0,     0,     0,     0,     0,     0,  2132,  2133,
       0,     0,     0,     0,     0,     0,  1157,     0,     0,     0,
    1859,   807,     0,  2134,     0,  1157,     0,     0,     0,   807,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2135,     0,
       0,  2136,     0,  4407,     0,     0,     0,     0,  1859,  1859,
       0,  1859,     0,     0,  2137,     0,     0,  2138,     0,     0,
       0,     0,  1867,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2123,     0,     0,
    2124,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2393,     0,  2125,     0,     0,
    3338,  1859,     0,  1859,     0,  2127,     0,     0,     0,     0,
       0,  2128,     0,  1153,     0,     0,     0,     0,  1153,     0,
       0,     0,     0,     0,  1153,  1860,     0,     0,     0,  2139,
    1860,  1860,     0,     0,     0,  2129,     0,     0,     0,     0,
       0,  1860,     0,     0,     0,     0,     0,  1859,     0,     0,
       0,     0,     0,     0,  1866,     0,     0,     0,     0,  1866,
    1866,     0,     0,     0,     0,     0,     0,     0,  1859,     0,
    1866,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4507,  4509,  4509,  1859,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1867,     0,     0,  1859,     0,
       0,     0,     0,     0,     0,     0,  1867,  2140,  2141,  2142,
       0,  2143,  2144,  2145,  2146,  2147,  2148,     0,     0,     0,
       0,     0,     0,     0,     0,  2130,     0,     0,     0,  2131,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2858,     0,     0,     0,     0,  2858,     0,
    2132,  2133,     0,     0,     0,     0,     0,  1860,     0,     0,
    2858,     0,  1859,     0,     0,  2134,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1859,     0,     0,     0,     0,
       0,     0,     0,     0,  1153,     0,  1866,     0,  1859,     0,
    2135,     0,     0,  2136,  4580,     0,     0,     0,     0,     0,
       0,  2123,     0,     0,  2124,     0,  2137,     0,     0,  2138,
       0,     0,     0,  1867,     0,     0,     0,     0,     0,     0,
       0,  2125,     0,     0,     0,     0,  1860,     0,     0,  2127,
       0,     0,     0,     0,  1867,  2128,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1867,     0,     0,     0,
       0,     0,     0,     0,     0,  1866,  1859,     0,     0,  2129,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1859,  4624,     0,     0,     0,
       0,  2139,     0,     0,  1867,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4640,     0,  4642,     0,     0,     0,
    1859,  1153,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1860,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1859,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1866,     0,     0,     0,     0,     0,     0,     0,     0,  2130,
       0,     0,     0,  2131,  1153,     0,     0,     0,  1153,  2140,
    2141,  2142,     0,  2143,  2144,  2145,  2146,  2147,  2148,     0,
       0,     0,  1153,  1153,  2132,  2133,     0,     0,     0,  4509,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2134,
    4432,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1153,  1153,     0,     0,     0,  1153,     0,     0,
       0,     0,     0,     0,  2135,     0,     0,  2136,  4723,  1153,
    1153,  1153,  1153,     0,     0,  2123,     0,  1867,  2124,     0,
    2137,     0,  1153,  2138,     0,  1153,     0,  1153,     0,     0,
       0,     0,     0,     0,     0,  2125,     0,  1153,  1153,     0,
       0,  1153,  3880,  2127,     0,     0,     0,     0,     0,  2128,
       0,     0,     0,     0,  1153,     0,  1153,     0,     0,     0,
    1153,   704,  4757,     0,     0,     0,     0,     0,     0,     0,
       0,   704,     0,  2129,     0,     0,  1153,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1153,     0,  1153,
    1153,  1153,     0,     0,     0,  2139,     0,     0,     0,  1859,
       0,     0,     0,  4791,     0,     0,     0,   704,  3881,     0,
       0,     0,     0,  1153,     0,     0,     0,     0,   901,     0,
       0,   704,     0,     0,  3025,  1153,     0,   901,     0,     0,
    1153,   704,     0,     0,     0,     0,     0,  1153,     0,     0,
       0,     0,     0,  1153,     0,     0,     0,     0,     0,     0,
       0,   704,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   901,     0,     0,
       0,     0,     0,  2130,     0,     0,     0,  2131,     0,     0,
       0,     0,     0,  2140,  2141,  2142,     0,  2143,  2144,  2145,
    2146,  2147,  2148,  1860,     0,     0,     0,     0,  2132,  2133,
    1072,     0,     0,  1153,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2134,     0,     0,     0,  3025,     0,     0,
       0,     0,  1866,     0,     0,     0,     0,     0,     0,     0,
    2123,  1860,  1860,  2124,  1860,     0,     0,     0,  2135,     0,
    1867,  2136,  1859,     0,     0,     0,     0,     0,     0,     0,
    2125,     0,     0,     0,  2137,     0,     0,  2138,  2127,     0,
    1866,  1866,     0,  1866,  2128,     0,     0,     0,     0,     0,
    1867,  3352,     0,     0,     0,  1859,     0,     0,     0,     0,
       0,     0,     0,     0,  1860,     0,  1860,     0,  2129,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2123,     0,  1867,  2124,     0,     0,
    1867,  1867,     0,  1866,     0,  1866,     0,     0,     0,     0,
       0,     0,     0,     0,  2125,     0,     0,  3382,     0,  2139,
    1860,     0,  2127,     0,     0,     0,     0,     0,  2128,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1860,     0,     0,     0,     0,     0,     0,     0,  1866,
       0,     0,  2129,     0,     0,     0,  4784,     0,     0,     0,
       0,     0,     0,  4432,     0,  1121,     0,     0,  1860,     0,
    1866,     0,     0,     0,     0,  1859,     0,     0,  2130,     0,
       0,  1860,  2131,     0,     0,     0,  1859,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1866,     0,     0,
       0,     0,     0,  2132,  2133,     0,     0,  2140,  2141,  2142,
    1866,  2143,  2144,  2145,  2146,  2147,  2148,     0,  2134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2135,     0,  1860,  2136,     0,     0,     0,
       0,     0,  2130,     0,     0,     0,  2131,     0,  1860,  2137,
       0,     0,  2138,     0,     0,     0,     0,     0,     0,     0,
       0,  1860,     0,     0,  1866,     0,     0,  2132,  2133,  4785,
       0,     0,     0,     0,     0,     0,     0,  1866,     0,     0,
       0,     0,  2134,  1859,     0,     0,     0,     0,     0,     0,
    1866,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1859,     0,     0,  2135,     0,     0,
    2136,     0,     0,     0,     0,     0,  1859,     0,     0,     0,
    1153,     0,     0,  2137,  2139,     0,  2138,     0,     0,  1860,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1860,     0,
       0,     0,     0,     0,  1859,  1153,     0,     0,  1866,     0,
       0,     0,     0,     0,  1153,     0,     0,     0,     0,     0,
    1153,     0,  1153,  1860,     0,     0,     0,  1866,  1153,     0,
       0,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,     0,     0,     0,  1153,  1153,     0,     0,  2139,     0,
       0,     0,  1866,     0,     0,     0,     0,  1153,     0,  1860,
       0,  1153,  2140,  2141,  2142,  1153,  2143,  2144,  2145,  2146,
    2147,  2148,     0,     0,     0,  1153,     0,     0,  1153,     0,
    1153,     0,     0,     0,     0,     0,   901,   901,  1866,  1153,
    1153,  1153,     0,     0,     0,  1153,     0,     0,  1153,     0,
       0,     0,     0,  1121,     0,     0,     0,     0,  1153,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1153,     0,
       0,     0,     0,     0,     0,     0,  1153,     0,  1153,     0,
       0,     0,     0,     0,     0,     0,  2140,  2141,  2142,     0,
    2143,  2144,  2145,  2146,  2147,  2148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1859,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1153,     0,     0,     0,     0,     0,  1153,     0,
    2123,   687,     0,  2124,  1153,     0,   701,     0,   701,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   701,     0,
    2125,     0,     0,     0,     0,     0,     0,     0,  2127,  1153,
       0,     0,     0,     0,  2128,     0,     0,     0,     0,     0,
       0,     0,  1167,     0,   701,     0,     0,     0,     0,     0,
       0,  1193,     0,  1195,   701,  1197,     0,  1199,  2129,     0,
       0,     0,  1860,     0,   701,   701,     0,     0,   701,     0,
       0,     0,     0,     0,   701,     0,  1247,     0,   981,     0,
       0,     0,     0,  1254,  1859,     0,     0,     0,     0,     0,
       0,  1866,  1269,  1270,     0,     0,     0,  1272,   981,     0,
       0,     0,     0,  2123,     0,     0,  2124,     0,     0,     0,
       0,     0,     0,  1121,   701,   901,     0,     0,     0,     0,
       0,     0,     0,  2125,     0,     0,  3393,     0,     0,     0,
    1301,  2127,     0,     0,     0,     0,     0,  2128,     0,     0,
       0,     0,  3387,     0,  1321,     0,     0,  1323,     0,  1325,
       0,  1328,     0,     0,     0,     0,     0,     0,  2130,     0,
       0,  2129,  2131,     0,   704,   901,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1859,     0,   704,
       0,   704,     0,  2132,  2133,     0,     0,     0,     0,     0,
       0,   704,     0,     0,     0,     0,     0,     0,  2134,     0,
    1859,     0,     0,     0,     0,  1860,     0,     0,  1153,     0,
     704,   704,     0,     0,     0,     0,     0,  1409,     0,  1410,
       0,     0,     0,  2135,     0,     0,  2136,     0,     0,     0,
    1859,     0,     0,     0,  1866,     0,     0,     0,  1860,  2137,
       0,     0,  2138,     0,     0,     0,     0,     0,     0,     0,
    1121,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2130,     0,     0,     0,  2131,  1859,  1866,  1153,  1153,
    1859,  1859,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1072,     0,  2132,  2133,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2134,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2139,     0,     0,     0,     0,     0,
       0,     0,   701,     0,     0,     0,  2135,     0,  1153,  2136,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2137,     0,     0,  2138,     0,     0,  1860,     0,
       0,     0,     0,     0,     0,  1665,     0,  1667,     0,  1860,
       0,  1669,     0,     0,  1153,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1153,  1153,     0,  1866,     0,     0,
       0,     0,  1153,  1153,     0,     0,     0,  1153,  1866,     0,
       0,     0,     0,  1153,  1153,     0,     0,  1153,     0,     0,
       0,     0,  2140,  2141,  2142,     0,  2143,  2144,  2145,  2146,
    2147,  2148,  1153,     0,     0,     0,  1153,  2139,     0,  1800,
       0,     0,     0,     0,     0,  1153,     0,     0,     0,     0,
    1153,     0,     0,     0,  2123,  1813,     0,  2124,     0,     0,
       0,     0,  1153,     0,     0,     0,  1821,     0,     0,     0,
       0,     0,     0,  1823,  2125,     0,     0,     0,     0,     0,
       0,     0,  2127,     0,     0,  1874,  1860,     0,  2128,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1153,     0,     0,     0,     0,     0,     0,  1860,     0,     0,
       0,     0,  2129,     0,     0,  1866,     0,  1916,     0,  1860,
       0,     0,     0,     0,     0,  2140,  2141,  2142,     0,  2143,
    2144,  2145,  2146,  2147,  2148,     0,  1866,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1866,     0,
       0,     0,     0,     0,     0,     0,     0,  1860,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   701,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1866,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   704,     0,   704,
       0,     0,   704,     0,   704,     0,     0,   704,   704,   704,
       0,     0,  2130,     0,     0,     0,  2131,     0,     0,     0,
     704,     0,     0,   701,   701,     0,     0,     0,     0,     0,
       0,     0,     0,   704,     0,   704,     0,  2132,  2133,     0,
     701,     0,     0,     0,     0,     0,     0,  1153,     0,     0,
       0,     0,  2134,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2135,     0,     0,
    2136,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2137,     0,     0,  2138,     0,     0,     0,
       0,     0,  1866,     0,     0,     0,     0,     0,     0,     0,
    1860,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1153,     0,     0,     0,  1866,
       0,     0,     0,     0,  1153,     0,     0,     0,     0,     0,
       0,  2123,     0,     0,  2124,     0,     0,     0,     0,     0,
       0,  1153,  1153,     0,     0,  1153,     0,     0,  2139,     0,
       0,  2125,     0,     0,  3887,     0,  1153,     0,     0,  2127,
       0,  1153,     0,     0,  1153,  2128,     0,     0,     0,  1153,
    1153,     0,     0,  3838,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2129,
       0,     0,     0,     0,     0,  1072,     0,  1860,     0,     0,
       0,     0,  1153,     0,     0,     0,     0,     0,     0,  1289,
     701,     0,   701,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1866,     0,     0,     0,
    1153,     0,     0,     0,     0,     0,  2140,  2141,  2142,     0,
    2143,  2144,  2145,  2146,  2147,  2148,     0,     0,     0,     0,
       0,     0,  2288,     0,     0,  2288,     0,     0,   701,     0,
       0,   701,   701,  2295,     0,     0,  1153,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   981,     0,   981,     0,
       0,  2304,     0,     0,   687,     0,     0,     0,   701,  2130,
    1860,     0,     0,  2131,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   981,   981,     0,
       0,     0,     0,  1860,  2132,  2133,  2364,  1153,     0,  1866,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2134,
       0,  2123,     0,     0,  2124,     0,     0,     0,     0,     0,
       0,  1153,  1866,  1860,  1153,     0,  1153,   701,     0,   701,
       0,  2125,     0,     0,  2135,     0,     0,  2136,     0,  2127,
       0,     0,     0,  1153,     0,  2128,     0,  1153,     0,     0,
    2137,     0,  1866,  2138,     0,     0,     0,     0,     0,  1860,
       0,     0,     0,  1860,  1860,     0,     0,     0,     0,  2129,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1866,     0,
       0,     0,  1866,  1866,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   687,
     687,     0,     0,  1647,     0,  2139,     0,  1153,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1866,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,  2130,
       0,     0,     0,  2131,     0,  2545,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1153,     0,     0,  2567,     0,
       0,     0,     0,     0,  2132,  2133,     0,     0,     0,     0,
    1153,     0,     0,     0,     0,     0,     0,     0,     0,  2134,
       0,     0,     0,  2140,  2141,  2142,     0,  2143,  2144,  2145,
    2146,  2147,  2148,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2611,  1153,  2135,     0,  2615,  2136,     0,     0,
       0,     0,  1153,     0,     0,  2624,     0,  2626,     0,  2627,
    2137,     0,     0,  2138,  2628,     0,     0,     0,     0,     0,
       0,     0,     0,  1153,  1153,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1153,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   704,     0,   704,
       0,     0,     0,   704,     0,   704,     0,     0,   704,     0,
       0,     0,   704,  2656,     0,     0,     0,     0,     0,     0,
    1153,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1153,     0,     0,     0,     0,  2139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,     0,  1862,     0,   701,     0,   701,     0,     0,   701,
       0,   701,     0,     0,   701,   701,   701,     0,     0,     0,
    2012,     0,     0,     0,     0,     0,     0,   701,     0,  1153,
       0,     0,     0,     0,     0,     0,     0,     0,  1153,     0,
     701,     0,   701,     0,     0,     0,     0,   701,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2140,  2141,  2142,     0,  2143,  2144,  2145,
    2146,  2147,  2148,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2859,     0,     0,
       0,     0,     0,  1158,     0,     0,     0,     0,     0,     0,
       0,  1158,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1863,  1158,     0,     0,     0,     0,     0,     0,     0,
    1862,     0,     0,  2164,     0,     0,     0,     0,     0,     0,
       0,     0,   701,   701,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,     0,     0,   687,   687,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1158,     0,     0,     0,
       0,     0,     0,     0,     0,  1158,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1121,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2946,  2947,
       0,     0,     0,  2950,  2951,     0,     0,  2954,     0,     0,
       0,     0,     0,     0,   701,     0,   687,  2964,     0,     0,
       0,     0,     0,     0,  2972,     0,  2292,     0,     0,     0,
    2977,  2978,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2992,     0,  2994,     0,     0,     0,     0,     0,  1863,
       0,     0,     0,     0,     0,     0,     0,  3014,     0,     0,
       0,     0,  3016,     0,     0,  1158,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,  3032,  3033,
    3036,  3038,   687,     0,     0,  3045,  3048,     0,     0,  1158,
       0,     0,     0,  3059,     0,     0,  3063,     0,     0,     0,
    3067,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3090,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3093,   687,  3095,     0,   687,
     687,     0,     0,     0,     0,  3098,  3099,  3100,     0,  3102,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3125,  3126,  3127,     0,  1862,     0,     0,     0,
       0,     0,  3132,  3133,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,     0,    85,     0,     0,     0,     0,     0,    89,     0,
       0,     0,    93,  1862,    94,     0,    96,    97,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   106,  3192,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1862,
       0,     0,     0,     0,   119,   120,     0,     0,  1158,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1158,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1869,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     129,     0,   130,   131,     0,     0,  1862,     0,     0,     0,
       0,     0,     0,  1158,     0,  1863,     0,  1091,     0,     0,
       0,     0,     0,     0,     0,  1862,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   141,     0,   142,
     143,     0,  1121,  1862,     0,   145,     0,   146,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   148,     0,   149,
       0,     0,  1863,     0,     0,     0,     0,     0,     0,     0,
       0,  1862,     0,   152,   701,   153,   701,     0,   156,  1158,
     701,  3317,   701,     0,     0,   701,     0,     0,  1863,   701,
     157,     0,   158,     0,  2164,     0,   159,     0,     0,     0,
       0,     0,   160,     0,     0,     0,     0,     0,     0,   162,
       0,   164,     0,     0,     0,     0,     0,   166,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1862,
       0,   170,     0,     0,     0,     0,     0,     0,  1869,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1863,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1158,     0,     0,     0,
       0,     0,     0,     0,  1863,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   183,   184,     0,     0,     0,     0,
     185,     0,  1863,     0,  1158,     0,     0,     0,   186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   191,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1863,     0,  1158,  1158,     0,  1158,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2012,     0,     0,
       0,     0,  1158,     0,  2860,     0,   202,     0,     0,     0,
       0,     0,     0,  2292,     0,     0,     0,   204,     0,     0,
       0,     0,   205,     0,   206,     0,     0,     0,     0,   207,
       0,     0,     0,     0,   208,     0,     0,   210,  1863,     0,
       0,   212,     0,     0,     0,     0,   213,   214,     0,     0,
       0,     0,     0,  1158,   215,     0,     0,   217,     0,     0,
       0,     0,     0,     0,   220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   687,   222,     0,  1862,     0,
       0,     0,  1158,     0,     0,     0,  1158,  1158,  3527,  3528,
       0,     0,     0,   227,     0,   228,     0,     0,     0,     0,
       0,     0,   230,     0,     0,     0,     0,     0,   231,     0,
       0,     0,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   235,     0,   687,     0,     0,
       0,     0,     0,  2930,     0,  1647,     0,     0,   701,     0,
       0,     0,     0,     0,  3559,  3561,     0,     0,  3561,     0,
       0,     0,  3568,  3569,  3570,     0,     0,     0,     0,   245,
       0,     0,     0,  -132,  1869,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3588,  3589,  3590,  3591,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1869,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3616,     0,     0,     0,     0,  1863,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1869,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3648,     0,     0,     0,     0,
    3650,     0,     0,     0,     0,   687,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   687,     0,     0,     0,     0,
       0,     0,     0,     0,  1869,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1869,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1862,  3731,
       0,  1869,     0,  1862,  1862,     0,     0,     0,     0,  3738,
       0,     0,     0,     0,  1862,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1869,
       0,     0,     0,     0,     0,  3757,     0,   901,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   901,     0,     0,  3800,     0,     0,     0,
       0,  1158,     0,     0,     0,     0,     0,  1869,     0,  3809,
    1158,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1862,     0,     0,     0,     0,     0,     0,  1863,     0,     0,
       0,     0,  1863,  1863,     0,  1506,     0,     0,     0,   701,
    2012,     0,     0,  1863,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1158,   687,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1576,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1862,
    1158,  1158,     0,     0,     0,     0,     0,     0,  1158,     0,
       0,  1158,     0,     0,  1158,     0,     0,     0,     0,     0,
       0,     0,  1158,  1158,     0,     0,     0,     0,     0,     0,
    1158,     0,     0,  1158,  1158,  1158,  1158,     0,     0,     0,
       0,     0,     0,  1158,  1158,     0,  1158,     0,  1158,  1158,
       0,     0,  1158,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1869,  1158,     0,     0,
       0,     0,  1158,     0,     0,     0,  1158,     0,     0,  1863,
    1158,     0,  1158,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,     0,  1158,     0,  1862,     0,     0,     0,  1158,     0,
       0,  1158,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4006,     0,     0,  1863,     0,
       0,     0,     0,     0,     0,     0,  2292,     0,     0,     0,
       0,   687,  1158,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4027,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4055,
       0,     0,     0,     0,  4062,  4063,     0,  4065,  4066,  4067,
    4068,  4069,  4070,  4071,     0,     0,     0,     0,     0,     0,
       0,     0,  4078,  1863,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1158,     0,     0,     0,     0,
    1158,     0,     0,     0,     0,     0,  1158,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4132,  4134,  4136,
       0,     0,  4139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1869,     0,     0,     0,
       0,  1869,  1869,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1869,     0,     0,     0,  2064,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2087,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1862,     0,     0,  3561,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2112,  2113,     0,  2115,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2154,     0,  1862,  1862,     0,  1862,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,     0,     0,     0,     0,     0,  1158,     0,  1869,     0,
       0,     0,   687,  2207,     0,     0,     0,  1862,     0,  1862,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2229,     0,     0,     0,  2239,  2242,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1862,   701,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1863,     0,  1869,     0,     0,
       0,     0,     0,     0,  1862,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     701,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1862,     0,  1863,  1863,     0,  1863,     0,     0,     0,
       0,     0,     0,  1158,  1862,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4327,     0,     0,     0,     0,     0,     0,     0,   687,     0,
       0,     0,     0,     0,     0,     0,  1863,     0,  1863,  4338,
    4339,     0,  1869,     0,     0,     0,     0,     0,     0,     0,
       0,  4348,  4349,     0,     0,     0,  1158,     0,  1862,     0,
    1158,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1862,     0,     0,  1158,  1158,     0,     0,     0,     0,
       0,     0,  1863,     0,  1862,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1863,  1158,  1158,     0,     0,     0,  1158,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1158,  1158,  1158,  1158,     0,     0,     0,     0,     0,
    1863,     0,     0,     0,  1158,     0,     0,  1158,     0,  1158,
       0,     0,     0,  1863,     0,     0,     0,  2150,     0,  1158,
    1158,     0,  1862,  1158,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4401,     0,     0,  1158,     0,  1158,     0,
       0,  1862,  1158,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4422,  1158,     0,
       0,     0,     0,     0,     0,     0,  1862,     0,     0,  1158,
       0,  1158,  1158,  1158,     0,     0,     0,  1863,     0,     0,
    4442,     0,     0,     0,     0,     0,     0,  2150,     0,     0,
    1863,  2930,     0,     0,     0,  1158,     0,     0,     0,     0,
       0,     0,  1862,  1863,     0,     0,     0,  1158,     0,     0,
       0,     0,  1158,     0,     0,     0,     0,     0,     0,  1158,
       0,     0,     0,     0,     0,  1158,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1863,   704,   687,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1158,     0,     0,     0,   687,
    1863,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1869,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1863,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   687,  1869,  1869,     0,  1869,     0,     0,  1864,     0,
       0,  1863,     0,     0,     0,     0,     0,     0,  2726,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4550,     0,     0,     0,     0,     0,     0,     0,
    2748,     0,     0,  2750,     0,  1862,  2761,     0,     0,     0,
       0,     0,     0,  2768,  2773,  1869,     0,  1869,     0,  2779,
       0,     0,  2784,     0,     0,     0,     0,     0,     0,     0,
    3561,     0,     0,     0,     0,     0,     0,  2793,     0,     0,
       0,     0,  2800,     0,     0,     0,  2812,     0,     0,     0,
    2819,     0,  2821,  2822,  2823,  2824,  2825,  2826,  2827,  2828,
    2829,  1869,  2830,     0,     0,     0,     0,     0,  1506,     0,
       0,  2855,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1869,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1869,
       0,   687,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1869,     0,     0,     0,  1864,     0,     0,     0,
       0,     0,  1576,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1862,     0,
       0,     0,     0,     0,  1863,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1862,     0,     0,  3561,     0,  1869,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1869,
       0,     0,     0,     0,     0,     0,  2150,     0,     0,     0,
       0,     0,  1869,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1158,     0,     0,     0,     0,     0,  2292,     0,
       0,     0,  4722,     0,     0,  2975,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,     0,  1158,     0,     0,
    1869,     0,     0,     0,     0,     0,  1158,     0,     0,     0,
       0,  1862,  1158,     0,  1158,  2150,     0,  1863,     0,  1869,
    1158,     0,  1862,  1158,  1158,  1158,  1158,  1158,  1158,  1158,
    1158,  1158,  1158,     0,     0,   687,  1158,  1158,  2150,     0,
       0,     0,     0,  2757,  1869,     0,     0,     0,     0,  1158,
    1863,     0,     0,  1158,     0,     0,     0,  1158,     0,     0,
       0,     0,     0,  2150,  2150,     0,  2150,  1158,     0,     0,
    1158,     0,  1158,     0,     0,     0,     0,     0,     0,     0,
    1869,  1158,  1158,  1158,     0,     0,     0,  1158,     0,     0,
    1158,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1158,     0,     0,     0,     0,  2150,     0,     0,     0,     0,
    1158,     0,  1864,     0,     0,     0,     0,     0,  1158,     0,
    1158,     0,     0,     0,     0,     0,     0,     0,     0,  1862,
       0,     0,     0,   687,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1862,     0,     0,     0,     0,     0,  3168,     0,  2150,  1864,
    1863,     0,  1862,     0,  1158,     0,     0,     0,     0,     0,
    1158,  1863,     0,     0,     0,     0,  1158,     0,     0,     0,
    2150,     0,     0,     0,     0,  1864,     0,     0,     0,     0,
    2150,     0,     0,  2150,     0,     0,     0,     0,     0,     0,
    1862,  1158,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1864,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1869,     0,     0,     0,     0,     0,     0,
       0,  1864,     0,  3288,     0,     0,     0,     0,  1863,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1864,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1863,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   701,
       0,  1863,     0,     0,     0,     0,     0,  1864,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   687,  1863,
       0,     0,     0,  1862,     0,  3334,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1864,     0,     0,     0,     0,
    1158,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2773,     0,  2773,  2773,     0,  1869,     0,     0,     0,
       0,     0,     0,     0,  3396,     0,     0,  3399,     0,  3401,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1869,
    1158,  1158,     0,     0,     0,     0,  3422,     0,  3424,     0,
       0,     0,  3427,     0,     0,     0,     0,     0,     0,     0,
    1862,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2855,  2855,  2855,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1158,     0,  1863,     0,     0,  3484,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2229,     0,     0,
       0,     0,  3495,     0,     0,     0,     0,     0,     0,  2242,
       0,     0,     0,     0,     0,     0,  1158,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1158,  1158,     0,  1869,
       0,     0,     0,  1862,  1158,  1158,     0,     0,     0,  1158,
    1869,     0,     0,     0,  1864,  1158,  1158,     0,     0,  1158,
       0,     0,     0,     0,     0,     0,  1862,     0,     0,     0,
       0,     0,     0,     0,  1158,     0,     0,     0,  1158,     0,
       0,     0,     0,     0,     0,  3536,     0,  1158,     0,     0,
       0,     0,  1158,     0,   687,     0,  1862,     0,     0,  1863,
       0,     0,     0,     0,  1158,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1862,     0,     0,     0,  1862,  1862,     0,     0,
       0,     0,  1158,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1869,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2150,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1869,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2150,
    1869,  2150,  1863,  2757,  2757,  3370,     0,     0,  2757,     0,
       0,     0,  2150,     0,     0,     0,     0,     0,     0,  2150,
       0,     0,     0,     0,  2150,  1863,     0,     0,     0,     0,
    2150,     0,     0,     0,     0,  2150,     0,     0,  1869,     0,
       0,     0,     0,     0,  2150,     0,     0,     0,  2757,  2757,
       0,  2150,     0,     0,     0,  1863,     0,     0,     0,     0,
       0,     0,     0,  2150,     0,     0,     0,     0,     0,     0,
    2150,     0,  2150,  2150,  2150,  2150,  2150,  2150,  2150,  2150,
    2150,  2150,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1863,     0,     0,     0,  1863,  1863,     0,     0,  1158,
       0,     0,     0,     0,     0,     0,  2150,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1864,     0,     0,     0,     0,  1864,
    1864,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1864,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1869,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1158,     0,     0,
       0,  1869,     0,     0,     0,     0,  1158,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1158,  1158,     0,     0,  1158,     0,     0,
       0,     0,     0,     0,     0,     0,  2150,     0,  1158,     0,
       0,     0,     0,  1158,     0,     0,  1158,     0,     0,     0,
       0,  1158,  1158,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1864,  3839,     0,     0,
       0,     0,     0,     0,  1158,     0,  3842,     0,     0,     0,
       0,     0,  3843,     0,  3844,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1869,     0,
       0,     0,  1158,     0,     0,     0,  3862,  3863,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2779,     0,     0,
       0,     0,     0,     0,     0,  1864,     0,  3891,  1158,     0,
    3894,     0,  3896,     0,     0,     0,     0,     0,     0,     0,
       0,  3900,     0,     0,     0,     0,     0,  3905,     0,     0,
    3908,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3937,     0,     0,     0,     0,     0,     0,     0,  3949,  1158,
    2855,  1869,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1158,  1869,     0,  1158,     0,  1158,  2150,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1864,     0,     0,     0,  3966,  1158,     0,     0,     0,  1158,
    1506,     0,     0,     0,  1869,     0,  1576,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1869,     0,     0,     0,  1869,  1869,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1158,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2150,
       0,     0,     0,     0,     0,     0,     0,  1869,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1158,     0,     0,
       0,     0,     0,     0,     0,  2150,     0,     0,     0,     0,
       0,     0,  1158,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3370,  3370,     0,  2757,
       0,     0,  2757,  2757,  2757,  2757,  2757,  2757,  2757,  2757,
    2757,  2757,  3370,     0,     0,  1158,     0,     0,     0,     0,
       0,     0,     0,     0,  1158,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2150,     0,     0,
    2150,     0,  2150,     0,     0,  1158,  1158,  3370,  3370,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1158,     0,
       0,  2757,  2757,  2150,     0,  2150,     0,     0,  2150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1158,     0,     0,     0,     0,     0,     0,     0,
    4189,  4190,  1158,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1864,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2150,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1864,  1864,     0,  1864,     0,     0,     0,     0,     0,     0,
    4221,  1158,     0,     0,     0,     0,     0,     0,     0,     0,
    1158,     0,     0,     0,     0,     0,     0,  2150,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1864,     0,  1864,  4239,  4241,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4248,
       0,     0,     0,     0,     0,  4253,  4254,     0,     0,  4256,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1864,
       0,     0,     0,     0,     0,     0,     0,  2855,     0,     0,
       0,     0,  2855,     0,     0,     0,     0,     0,     0,     0,
    1864,     0,     0,     0,  2855,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1864,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1864,     0,  4310,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2757,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1864,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1864,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1864,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4388,
       0,     0,     0,     0,     0,     0,     0,     0,  1864,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2150,     0,     0,  2150,  2150,  2150,     0,  1864,  3370,     0,
       0,     0,     0,  3370,  3370,  3370,  3370,  3370,  3370,  3370,
    3370,  3370,  3370,  2150,  2150,     0,     0,     0,     0,     0,
       0,     0,  1864,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2150,  2757,  2757,  2150,     0,  2150,     0,     0,
       0,  2150,  3370,  3370,     0,     0,  2150,     0,  1864,  2150,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4468,  2150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4485,     0,     0,     0,     0,  2150,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    86,
      87,    88,     0,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,     0,     0,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115,     0,   116,   117,   118,     0,     0,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,     0,   126,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,  1864,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2779,     0,   140,     0,
       0,  3370,     0,     0,     0,   144,     0,     0,     0,     0,
       0,     0,     0,   147,     0,  4605,     0,     0,     0,     0,
       0,     0,     0,     0,   150,     0,     0,     0,     0,     0,
     151,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     154,   155,     0,     0,     0,     0,     0,     0,     0,     0,
    2150,  2150,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   161,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,   165,     0,
       0,     0,  2150,   167,     0,     0,  2757,     0,     0,   168,
       0,   169,     0,     0,  1864,     0,     0,   171,     0,  4662,
    2150,     0,  2150,     0,     0,     0,   172,  3370,  3370,  2150,
       0,     0,  2757,  2757,  2150,  2150,     0,  2150,     0,   173,
     174,     0,     0,     0,     0,     0,   175,  1864,   176,     0,
       0,   177,   178,     0,   179,     0,     0,     0,     0,     0,
       0,     0,     0,   180,   181,     0,   182,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   187,   188,   189,     0,     0,
     190,  2150,  4705,     0,   192,     0,     0,   193,     0,   194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   195,   196,   197,   198,   199,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   200,     0,   201,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4743,  4743,  1864,     0,   209,
       0,     0,   211,     0,     0,     0,     0,     0,  1864,  2150,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   216,
       0,     0,   218,     0,   219,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   221,     0,     0,     0,
       0,     0,  4743,     0,     0,     0,     0,     0,   223,   224,
       0,     0,  4788,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,   229,     0,     0,     0,     0,     0,     0,
       0,  3370,  2757,     0,     0,     0,     0,     0,   233,     0,
       0,   234,     0,     0,     0,     0,     0,  3370,  3370,  2150,
       0,     0,     0,     0,     0,   236,   237,   238,   239,   240,
     241,   242,   243,   244,     0,     0,  2150,     0,     0,     0,
       0,  4743,     0,     0,     0,  1864,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2920,     0,     0,     0,     0,     0,  1864,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1864,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1864,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3370,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2150,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2150,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2150,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1864,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2150,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2150,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1864,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1864,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   710,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,  1864,    98,    99,   100,   101,   102,   103,   711,
     104,   105,   414,   712,     0,   107,   108,   109,   110,   713,
     714,   112,   113,   114,   115,     0,   116,   715,   716,   415,
     416,     0,  1864,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,  1864,     0,
       0,     0,  1864,  1864,     0,   425,   426,   427,   428,   429,
     430,   431,   432,   717,   433,   434,   435,   718,   719,   720,
     721,   722,   723,   724,   436,   437,   725,   438,   439,   133,
     440,   441,   442,   135,   136,   137,   138,   139,   726,   443,
     444,   445,   446,   447,   727,   728,   448,   449,   729,   140,
     451,   730,   452,   453,   454,   455,   144,   731,   456,   732,
     457,   458,   459,   460,   147,   461,   733,   734,   463,   464,
     465,   466,   467,   468,   735,   150,   469,   736,   737,   738,
     739,   151,   740,   741,   742,   470,   471,   472,   473,   474,
     475,   154,   155,   476,   743,   477,   744,   478,   479,   480,
     481,   482,   745,   483,   484,   485,   746,   747,   486,   487,
     488,   489,   490,   748,   491,   492,   493,   749,   494,   495,
     750,   496,   497,   498,   499,   163,   500,   501,   502,   165,
     751,   503,   752,   504,   167,   505,   753,   506,   754,   507,
     168,   755,   169,   508,   509,   510,   756,   511,   171,   757,
     512,   758,   513,   514,   515,   516,   517,   172,   518,   519,
     520,   759,   521,   522,   523,   524,   525,   526,   760,   527,
     173,   174,   761,   528,   529,   530,   762,   175,   763,   176,
     764,   531,   177,   178,   532,   179,   533,   534,   535,   536,
     537,   538,   539,   765,   180,   181,   540,   182,   766,   541,
     542,   543,   767,   768,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,   188,   189,   556,
     557,   190,   769,   558,   559,   192,   560,   770,   193,   561,
     194,   562,   563,   564,   771,   565,   772,   773,   566,   567,
     568,   774,   775,   195,   196,   197,   198,   199,   569,   570,
     571,   572,   573,   574,   575,   776,   576,   200,   577,   201,
     578,   579,   580,   777,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,   778,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   779,   602,   603,
     209,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,   780,   614,   615,   616,   617,   618,   781,   619,
     216,   620,   621,   218,   622,   219,   782,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,   783,   633,
     634,   784,   635,   636,   637,   638,   639,   640,   785,   223,
     224,   786,   787,   642,   225,   643,   226,   788,   644,   645,
     646,   647,   648,   649,   789,   790,   650,   651,   652,   653,
     654,   791,   792,   655,   656,   657,   658,   659,   793,   233,
     794,   661,   234,   662,   663,   664,   795,   796,   665,   797,
     798,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    85,     0,
       0,    86,    87,    88,    89,    90,    91,    92,    93,     0,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     943,   104,   105,   106,     0,     0,   107,   108,   109,   110,
       0,   111,   112,   113,   114,   115,     0,   116,   117,   118,
     119,   120,     0,     0,     0,   121,   122,     0,     0,     0,
       0,   123,     0,     0,     0,     0,     0,     0,     0,     0,
     124,     0,   125,     0,   126,   127,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   129,     0,   130,   131,
       0,     0,     0,     0,     0,     0,     0,     0,   132,     0,
     133,     0,     0,   134,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,   141,     0,   142,   143,   144,     0,     0,
       0,   145,     0,   146,     0,   147,     0,     0,     0,     0,
       0,     0,     0,   148,     0,   149,   150,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,     0,     0,   152,
       0,   153,   154,   155,   156,     0,     0,     0,     0,     0,
   -1312,     0,     0,     0,     0,     0,   157,     0,   158,     0,
       0,     0,   159,     0,     0,     0,     0,     0,   160,   161,
       0,     0,     0,     0,     0,   162,   163,   164,     0,     0,
     165,     0,     0,   166,     0,   167,     0,     0,     0,     0,
       0,   168,     0,   169,     0,     0,     0,   170,     0,   171,
       0,     0,     0,     0,     0,     0,     0,     0,   172,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   173,   174,     0,     0, -1312,     0,     0,   175,     0,
     176,     0,     0,   177,   178,     0,   179,     0,     0,     0,
       0,     0,     0,     0,     0,   180,   181,     0,   182,     0,
     183,   184,     0,     0,     0,     0,   185,     0,     0,     0,
       0,     0,     0,     0,   186,     0,     0,   187,   188,   189,
       0,     0,   190,     0,     0,   191,   192,     0,     0,   193,
       0,   194,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   195,   196,   197,   198,   199,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   200,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,     0,     0,   205,     0,
     206,     0,     0,     0,     0,   207,     0,     0,     0,     0,
     208,   209,     0,   210,   211,     0,     0,   212,     0,     0,
       0,     0,   213,   214,     0,     0,     0,     0,     0,     0,
     215,   216,     0,   217,   218,     0,   219,     0,     0,     0,
     220,     0,     0,     0,     0,     0,     0,     0,   221,     0,
       0,     0,   222,     0,     0,     0,     0,     0,     0,     0,
     223,   224,     0,     0,     0,   225,     0,   226,     0,   227,
       0,   228,     0,     0,     0,   229,     0,     0,   230,     0,
       0, -1312,     0,     0,   231,     0,     0,     0,     0,   232,
     233,     0,     0,   234,     0,     0,     0,     0,     0,     0,
       0,   235,     0,     0,     0,     0,     0,   236,   237,   238,
     239,   240,   241,   242,   243,   244,    86,    87,    88,     0,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   245,   104,   105,     0,  -132,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115,     0,   116,   117,   118,     0,     0,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,     0,     0,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,   144,     0,     0,     0,     0,     0,     0,     0,
     147,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   150,     0,     0,     0,     0,     0,   151,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   154,   155,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   161,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,   165,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,   168,     0,   169,     0,
       0,     0,     0,     0,   171,     0,     0,     0,     0,     0,
       0,     0,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   173,   174,     0,     0,
       0,     0,     0,   175,     0,   176,     0,     0,   177,   178,
       0,   179,     0,     0,     0,     0,     0,     0,     0,     0,
     180,   181,     0,   182,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   187,   188,   189,     0,     0,   190,     0,     0,
       0,   192,     0,     0,   193,     0,   194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   195,
     196,   197,   198,   199,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   200,     0,   201,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   209,     0,     0,   211,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   216,     0,     0,   218,
       0,   219,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   221,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   223,   224,     0,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
     229,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,     0,     0,   234,     0,
       0,     0,     0,     0,     0,     0,     4,     0,     0,     0,
       0,     0,   236,   237,   238,   239,   240,   241,   242,   243,
     244,     0,     0,     0,     0,     0,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     0,     0,
       0,     0,     0,     0,     9,    10,     0,  2922,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     4,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     6,     7,     0,     0,     0,
       0,     0,     0,     9,    10,    46,     0,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    48,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    49,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,    51,     0,     0,    52,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      48,     0,     0,     0,    53,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    50,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    51,     0,    54,    52,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    55,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    56,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    57,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    54,     0,     0,     0,
       0,     0,    58,     0,     0,     0,     0,     0,    59,     0,
       0,     0,    60,    61,    62,    63,    64,     0,     0,    65,
      66,  1336,     0,     0,     0,     0,    71,  1337,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    55,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      56,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    57,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     4,     0,     0,     0,
       0,    58,     0,     0,     0,     0,     0,    59,     0,     0,
       0,    60,    61,    62,    63,    64,     5,     0,    65,    66,
    1336,  1969,     0,     0,     0,    71,     6,     7,     0,     0,
       0,     0,     0,     0,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     4,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     6,     7,     0,     0,     0,
       0,     0,     0,     9,    10,    46,     0,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    48,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    49,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,    51,     0,     0,    52,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      48,     0,     0,     0,    53,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    50,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    51,     0,    54,    52,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    55,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    56,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    57,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    54,     0,     0,     0,
       0,     0,    58,     0,     0,     0,     0,     0,    59,     0,
       0,     0,    60,    61,    62,    63,    64,     0,     0,    65,
      66,  1336,  2637,     0,     0,     0,    71,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    55,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      56,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    57,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    58,     0,     0,     0,     0,     0,    59,     0,     0,
       0,    60,    61,    62,    63,    64,     0,     0,    65,    66,
    1336,     0,     0,     0,     0,    71,   710,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   711,   104,   105,   414,
     712,     0,   107,   108,   109,   110,   713,   714,   112,   113,
     114,   115,     0,   116,   715,   716,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,   424,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1426,  1427,  1428,    45,  1429,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
    2849,   433,   434,   435,     0,     0,     0,     0,  1430,     0,
       0,   436,   437,     0,   438,   439,   133,   440,   441,   442,
     135,  1431,   137,  1432,  1433,     0,   443,   444,   445,   446,
     447,  1434,  1435,   448,   449,  1436,  1437,   451,     0,   452,
     453,   454,   455,  1438,     0,   456,     0,   457,   458,   459,
     460,   147,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,   150,   469,     0,  1439,  1440,  1441,  1442,  1443,
    1444,  1445,   470,   471,   472,   473,   474,   475,  1446,  1447,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,  2850,     0,   486,   487,  1448,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,  1449,   500,   501,   502,  1450,  1451,   503,     0,
     504,  1452,   505,     0,   506,     0,   507,   168,     0,   169,
     508,   509,   510,     0,   511,  1453,     0,   512,     0,   513,
     514,   515,   516,   517,   172,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,   173,   174,     0,
     528,   529,   530,  1454,  1455,     0,  1456,     0,   531,   177,
     178,   532,   179,   533,   534,   535,   536,   537,   538,   539,
       0,  1457,   181,   540,   182,     0,   541,   542,   543,  1458,
    1459,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,  1460,   188,  1461,   556,   557,   190,  1462,
     558,   559,   192,   560,  1463,  1464,   561,  1465,   562,   563,
     564,     0,   565,     0,     0,  1466,   567,   568,     0,     0,
     195,   196,   197,   198,  1467,   569,   570,   571,   572,   573,
     574,   575,     0,   576,  1468,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,  1469,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,   209,   604,   605,
    1470,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,  1471,   619,   216,   620,   621,
     218,   622,  1472,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,  1473,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,  1474,  1475,     0,     0,
     642,  1476,   643,  1477,  1478,   644,   645,   646,   647,   648,
     649,     0,  1479,   650,   651,   652,   653,   654,  1480,     0,
     655,   656,   657,   658,   659,   660,  1481,  2851,   661,   234,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,  1482,  1483,  1484,  1485,  1486,  1487,
    1488,  1489,   671,   672,   673,     0,     0,     0,     0,     0,
       0,     0,  1490,  1491,  2852,     0,     0,     0,     0,     0,
       0,  1493,  2853,   710,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   711,   104,   105,   414,   712,     0,   107,
     108,   109,   110,   713,   714,   112,   113,   114,   115,     0,
     116,   715,   716,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
     424,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1426,  1427,  1428,    45,  1429,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,  1430,     0,     0,   436,   437,
       0,   438,   439,   133,   440,   441,   442,   135,  1431,   137,
    1432,  1433,     0,   443,   444,   445,   446,   447,  1434,  1435,
     448,   449,  1436,  1437,   451,     0,   452,   453,   454,   455,
    1438,     0,   456,     0,   457,   458,   459,   460,   147,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,   150,
     469,     0,  1439,  1440,  1441,  1442,  1443,  1444,  1445,   470,
     471,   472,   473,   474,   475,  1446,  1447,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,  1448,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,  1449,
     500,   501,   502,  1450,  1451,   503,     0,   504,  1452,   505,
       0,   506,     0,   507,   168,     0,   169,   508,   509,   510,
       0,   511,  1453,     0,   512,     0,   513,   514,   515,   516,
     517,   172,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,   173,   174,     0,   528,   529,   530,
    1454,  1455,     0,  1456,     0,   531,   177,   178,   532,   179,
     533,   534,   535,   536,   537,   538,   539,     0,  1457,   181,
     540,   182,     0,   541,   542,   543,  1458,  1459,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
    1460,   188,  1461,   556,   557,   190,  1462,   558,   559,   192,
     560,  1463,  1464,   561,  1465,   562,   563,   564,     0,   565,
       0,     0,  1466,   567,   568,     0,     0,   195,   196,   197,
     198,  1467,   569,   570,   571,   572,   573,   574,   575,     0,
     576,  1468,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,  1469,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,   209,   604,   605,  1470,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,  1471,   619,   216,   620,   621,   218,   622,  1472,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,  1473,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,  1474,  1475,     0,     0,   642,  1476,   643,
    1477,  1478,   644,   645,   646,   647,   648,   649,     0,  1479,
     650,   651,   652,   653,   654,  1480,     0,   655,   656,   657,
     658,   659,   660,  1481,     0,   661,   234,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,  1482,  1483,  1484,  1485,  1486,  1487,  1488,  1489,   671,
     672,   673,     0,     0,     0,     0,     0,     0,     0,  1490,
    1491,     0,     0,     0,     0,     0,     0,     0,  1493,  2759,
     710,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     711,   104,   105,   414,   712,     0,   107,   108,   109,   110,
     713,   714,   112,   113,   114,   115,     0,   116,   715,   716,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
     133,   440,   441,   442,     0,  1835,   137,  1836,  1837,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,  1838,
    1839,   451,     0,   452,   453,   454,   455,     0,     0,   456,
       0,   457,   458,   459,   460,   147,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,   150,   469,     0,     0,
       0,     0,   151,     0,     0,     0,   470,   471,   472,   473,
     474,   475,  1840,  1841,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,  1448,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,     0,   500,   501,   502,
       0,     0,   503,     0,   504,  1842,   505,     0,   506,     0,
     507,   168,     0,   169,   508,   509,   510,     0,   511,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   172,   518,
     519,   520,  2381,   521,   522,   523,   524,   525,   526,     0,
     527,   173,  2382,     0,   528,   529,   530,  1454,  1843,     0,
    1844,     0,   531,   177,   178,   532,   179,   533,   534,   535,
     536,   537,   538,   539,     0,     0,   181,   540,   182,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,  1845,   188,  1846,
     556,   557,     0,     0,   558,   559,   192,   560,     0,     0,
     561,  1847,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,  2383,   196,   197,   198,     0,   569,
     570,   571,   572,   573,   574,   575,     0,   576,     0,   577,
       0,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,  1848,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,   209,   604,   605,     0,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,  2384,   620,   621,   218,   622,  1850,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
    1851,  1852,     0,     0,   642,     0,   643,     0,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,     0,
    1853,  2385,   661,   234,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   671,   672,   673,     0,
       0,     0,     0,   710,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,  2386,    98,    99,   100,
     101,   102,   103,   711,   104,   105,   414,   712,     0,   107,
     108,   109,   110,   713,   714,   112,   113,   114,   115,     0,
     116,   715,   716,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,   133,   440,   441,   442,     0,  1835,   137,
    1836,  1837,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,  1838,  1839,   451,     0,   452,   453,   454,   455,
       0,     0,   456,     0,   457,   458,   459,   460,   147,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,   150,
     469,     0,     0,     0,     0,   151,     0,     0,     0,   470,
     471,   472,   473,   474,   475,  1840,  1841,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,  1448,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,     0,
     500,   501,   502,     0,     0,   503,     0,   504,  1842,   505,
       0,   506,     0,   507,   168,     0,   169,   508,   509,   510,
       0,   511,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   172,   518,   519,   520,  2381,   521,   522,   523,   524,
     525,   526,     0,   527,   173,  2382,     0,   528,   529,   530,
    1454,  1843,     0,  1844,     0,   531,   177,   178,   532,   179,
     533,   534,   535,   536,   537,   538,   539,     0,     0,   181,
     540,   182,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
    1845,   188,  1846,   556,   557,     0,     0,   558,   559,   192,
     560,     0,     0,   561,  1847,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,  2383,   196,   197,
     198,     0,   569,   570,   571,   572,   573,   574,   575,     0,
     576,     0,   577,     0,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,  1848,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,   209,   604,   605,     0,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,  2384,   620,   621,   218,   622,  1850,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,  1851,  1852,     0,     0,   642,     0,   643,
       0,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,     0,  1853,  2385,   661,   234,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   671,
     672,   673,     0,     0,     0,     0,   710,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,  3251,
      98,    99,   100,   101,   102,   103,   711,   104,   105,   414,
     712,     0,   107,   108,   109,   110,   713,   714,   112,   113,
     114,   115,     0,   116,   715,   716,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,   424,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1426,  1427,  1428,    45,  1429,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,  1430,     0,
       0,   436,   437,     0,   438,   439,   133,   440,   441,   442,
     135,  1431,   137,  1432,  1433,  2769,   443,   444,   445,   446,
     447,  1434,  1435,   448,   449,  1436,  1437,   451,     0,   452,
     453,   454,   455,  1438,     0,   456,     0,   457,   458,   459,
     460,   147,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,   150,   469,     0,  1439,  1440,  1441,  1442,  1443,
    1444,  1445,   470,   471,   472,   473,   474,   475,  1446,  1447,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,  1448,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,  1449,   500,   501,   502,  1450,  1451,   503,     0,
     504,  1452,   505,     0,   506,     0,   507,   168,  2770,   169,
     508,   509,   510,     0,   511,  1453,     0,   512,     0,   513,
     514,   515,   516,   517,   172,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,   173,   174,     0,
     528,   529,   530,  1454,  1455,     0,  1456,     0,   531,   177,
     178,   532,   179,   533,   534,   535,   536,   537,   538,   539,
    2771,  1457,   181,   540,   182,     0,   541,   542,   543,  1458,
    1459,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,  1460,   188,  1461,   556,   557,   190,  1462,
     558,   559,   192,   560,  1463,  1464,   561,  1465,   562,   563,
     564,     0,   565,     0,     0,  1466,   567,   568,     0,     0,
     195,   196,   197,   198,  1467,   569,   570,   571,   572,   573,
     574,   575,     0,   576,  1468,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,  1469,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,   209,   604,   605,
    1470,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,  1471,   619,   216,   620,   621,
     218,   622,  1472,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,  1473,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,  1474,  1475,     0,  2772,
     642,  1476,   643,  1477,  1478,   644,   645,   646,   647,   648,
     649,     0,  1479,   650,   651,   652,   653,   654,  1480,     0,
     655,   656,   657,   658,   659,   660,  1481,     0,   661,   234,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,  1482,  1483,  1484,  1485,  1486,  1487,
    1488,  1489,   671,   672,   673,     0,     0,     0,     0,     0,
       0,     0,  1490,  1491,     0,     0,     0,     0,     0,     0,
       0,  1493,   710,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   711,   104,   105,   414,   712,     0,   107,   108,
     109,   110,   713,   714,   112,   113,   114,   115,     0,   116,
     715,   716,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,   424,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1426,  1427,  1428,    45,  1429,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,  1430,     0,     0,   436,   437,     0,
     438,   439,   133,   440,   441,   442,   135,  1431,   137,  1432,
    1433,     0,   443,   444,   445,   446,   447,  1434,  1435,   448,
     449,  1436,  1437,   451,     0,   452,   453,   454,   455,  1438,
       0,   456,     0,   457,   458,   459,   460,   147,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,   150,   469,
       0,  1439,  1440,  1441,  1442,  1443,  1444,  1445,   470,   471,
     472,   473,   474,   475,  1446,  1447,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,  1448,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,  1449,   500,
     501,   502,  1450,  1451,   503,     0,   504,  1452,   505,     0,
     506,     0,   507,   168,     0,   169,   508,   509,   510,     0,
     511,  1453,     0,   512,     0,   513,   514,   515,   516,   517,
     172,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,   173,   174,     0,   528,   529,   530,  1454,
    1455,     0,  1456,     0,   531,   177,   178,   532,   179,   533,
     534,   535,   536,   537,   538,   539,     0,  1457,   181,   540,
     182,     0,   541,   542,   543,  1458,  1459,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,  1460,
     188,  1461,   556,   557,   190,  1462,   558,   559,   192,   560,
    1463,  1464,   561,  1465,   562,   563,   564,     0,   565,     0,
       0,  1466,   567,   568,     0,     0,   195,   196,   197,   198,
    1467,   569,   570,   571,   572,   573,   574,   575,     0,   576,
    1468,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,  1469,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,   209,   604,   605,  1470,   606,   607,   608,
     609,   610,   611,   612,   613,   214,   614,   615,   616,   617,
     618,  1471,   619,   216,   620,   621,   218,   622,  1472,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
    1473,     0,   633,   634,   222,   635,   636,   637,   638,   639,
     640,     0,  1474,  1475,     0,     0,   642,  1476,   643,  1477,
    1478,   644,   645,   646,   647,   648,   649,     0,  1479,   650,
     651,   652,   653,   654,  1480,     0,   655,   656,   657,   658,
     659,  1352,  1481,     0,   661,   234,   662,   663,   664,     0,
       0,   665,     0,   235,   666,   667,   668,   669,   670,   236,
    1482,  1483,  1484,  1485,  1486,  1487,  1488,  1489,   671,   672,
     673,     0,     0,     0,     0,     0,     0,     0,  1490,  1491,
       0,     0,     0,     0,     0,     0,     0,  1493,   710,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   711,   104,
     105,   414,   712,     0,   107,   108,   109,   110,   713,   714,
     112,   113,   114,   115,     0,   116,   715,   716,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,   424,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1426,  1427,  1428,    45,
    1429,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
    1430,     0,     0,   436,   437,     0,   438,   439,   133,   440,
     441,   442,   135,  1431,   137,  1432,  1433,     0,   443,   444,
     445,   446,   447,  1434,  1435,   448,   449,  1436,  1437,   451,
       0,   452,   453,   454,   455,  1438,     0,   456,     0,   457,
     458,   459,   460,   147,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,   150,   469,     0,  1439,  1440,  1441,
    1442,  1443,  1444,  1445,   470,   471,   472,   473,   474,   475,
    1446,  1447,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,  1448,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,  1449,   500,   501,   502,  1450,  1451,
     503,     0,   504,  1452,   505,     0,   506,     0,   507,   168,
       0,   169,   508,   509,   510,     0,   511,  1453,     0,   512,
       0,   513,   514,   515,   516,   517,   172,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,   173,
     174,     0,   528,   529,   530,  1454,  1455,     0,  1456,     0,
     531,   177,   178,   532,   179,   533,   534,   535,   536,   537,
     538,   539,     0,  1457,   181,   540,   182,     0,   541,   542,
     543,  1458,  1459,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,  1460,   188,  1461,   556,   557,
     190,  1462,   558,   559,   192,   560,  1463,  1464,   561,  1465,
     562,   563,   564,     0,   565,     0,     0,  1466,   567,   568,
       0,     0,   195,   196,   197,   198,  1467,   569,   570,   571,
     572,   573,   574,   575,     0,   576,  1468,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
    1469,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,   209,
     604,   605,  1470,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,  1471,   619,   216,
     620,   621,   218,   622,  1472,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,  1473,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,  1474,  1475,
       0,     0,   642,  1476,   643,  1477,  1478,   644,   645,   646,
     647,   648,   649,     0,  1479,   650,   651,   652,   653,   654,
    1480,     0,   655,   656,   657,   658,   659,   660,  1481,     0,
     661,   234,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,  1482,  1483,  1484,  1485,
    1486,  1487,  1488,  1489,   671,   672,   673,     0,     0,     0,
       0,     0,     0,     0,  1490,  1491,     0,     0,     0,     0,
       0,  2059,  2718,  1493,   710,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   711,   104,   105,   414,   712,     0,
     107,   108,   109,   110,   713,   714,   112,   113,   114,   115,
       0,   116,   715,   716,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,   424,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1426,  1427,  1428,    45,  1429,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,  1430,     0,     0,   436,
     437,     0,   438,   439,   133,   440,   441,   442,   135,  1431,
     137,  1432,  1433,     0,   443,   444,   445,   446,   447,  1434,
    1435,   448,   449,  1436,  1437,   451,     0,   452,   453,   454,
     455,  1438,     0,   456,     0,   457,   458,   459,   460,   147,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
     150,   469,     0,  1439,  1440,  1441,  1442,  1443,  1444,  1445,
     470,   471,   472,   473,   474,   475,  1446,  1447,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,  1448,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
    1449,   500,   501,   502,  1450,  1451,   503,     0,   504,  1452,
     505,     0,   506,     0,   507,   168,     0,   169,   508,   509,
     510,     0,   511,  1453,     0,   512,     0,   513,   514,   515,
     516,   517,   172,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,   173,   174,     0,   528,   529,
     530,  1454,  1455,     0,  1456,     0,   531,   177,   178,   532,
     179,   533,   534,   535,   536,   537,   538,   539,     0,  1457,
     181,   540,   182,     0,   541,   542,   543,  1458,  1459,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,  1460,   188,  1461,   556,   557,   190,  1462,   558,   559,
     192,   560,  1463,  1464,   561,  1465,   562,   563,   564,     0,
     565,     0,     0,  1466,   567,   568,     0,     0,   195,   196,
     197,   198,  1467,   569,   570,   571,   572,   573,   574,   575,
       0,   576,  1468,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,  1469,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,   209,   604,   605,  1470,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,  1471,   619,   216,   620,   621,   218,   622,
    1472,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,  1473,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,  1474,  1475,     0,     0,   642,  1476,
     643,  1477,  1478,   644,   645,   646,   647,   648,   649,     0,
    1479,   650,   651,   652,   653,   654,  1480,     0,   655,   656,
     657,   658,   659,   660,  1481,     0,   661,   234,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,  1482,  1483,  1484,  1485,  1486,  1487,  1488,  1489,
     671,   672,   673,     0,     0,     0,     0,     0,     0,     0,
    1490,  1491,  1492,     0,     0,     0,     0,     0,     0,  1493,
     710,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     711,   104,   105,   414,   712,     0,   107,   108,   109,   110,
     713,   714,   112,   113,   114,   115,     0,   116,   715,   716,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,   424,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1426,  1427,
    1428,    45,  1429,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,  1430,     0,     0,   436,   437,     0,   438,   439,
     133,   440,   441,   442,   135,  1431,   137,  1432,  1433,     0,
     443,   444,   445,   446,   447,  1434,  1435,   448,   449,  1436,
    1437,   451,     0,   452,   453,   454,   455,  1438,     0,   456,
       0,   457,   458,   459,   460,   147,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,   150,   469,     0,  1439,
    1440,  1441,  1442,  1443,  1444,  1445,   470,   471,   472,   473,
     474,   475,  1446,  1447,   476,  1575,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,  1448,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,  1449,   500,   501,   502,
    1450,  1451,   503,     0,   504,  1452,   505,     0,   506,     0,
     507,   168,     0,   169,   508,   509,   510,     0,   511,  1453,
       0,   512,     0,   513,   514,   515,   516,   517,   172,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,   173,   174,     0,   528,   529,   530,  1454,  1455,     0,
    1456,     0,   531,   177,   178,   532,   179,   533,   534,   535,
     536,   537,   538,   539,     0,  1457,   181,   540,   182,     0,
     541,   542,   543,  1458,  1459,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,  1460,   188,  1461,
     556,   557,   190,  1462,   558,   559,   192,   560,  1463,  1464,
     561,  1465,   562,   563,   564,     0,   565,     0,     0,  1466,
     567,   568,     0,     0,   195,   196,   197,   198,  1467,   569,
     570,   571,   572,   573,   574,   575,     0,   576,  1468,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,  1469,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,   209,   604,   605,  1470,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,  1471,
     619,   216,   620,   621,   218,   622,  1472,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,  1473,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
    1474,  1475,     0,     0,   642,  1476,   643,  1477,  1478,   644,
     645,   646,   647,   648,   649,     0,  1479,   650,   651,   652,
     653,   654,  1480,     0,   655,   656,   657,   658,   659,   660,
    1481,     0,   661,   234,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,  1482,  1483,
    1484,  1485,  1486,  1487,  1488,  1489,   671,   672,   673,     0,
       0,     0,     0,     0,     0,     0,  1490,  1491,     0,     0,
       0,     0,     0,     0,     0,  1493,   710,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   711,   104,   105,   414,
     712,     0,   107,   108,   109,   110,   713,   714,   112,   113,
     114,   115,     0,   116,   715,   716,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,   424,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1426,  1427,  1428,    45,  1429,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
    2237,   433,   434,   435,     0,     0,     0,     0,  1430,     0,
       0,   436,   437,     0,   438,   439,   133,   440,   441,   442,
     135,  1431,   137,  1432,  1433,     0,   443,   444,   445,   446,
     447,  1434,  1435,   448,   449,  1436,  1437,   451,     0,   452,
     453,   454,   455,  1438,     0,   456,     0,   457,   458,   459,
     460,   147,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,   150,   469,     0,  1439,  1440,  1441,  1442,  1443,
    1444,  1445,   470,   471,   472,   473,   474,   475,  1446,  1447,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,  1448,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,  1449,   500,   501,   502,  1450,  1451,   503,     0,
     504,  1452,   505,     0,   506,     0,   507,   168,     0,   169,
     508,   509,   510,     0,   511,  1453,     0,   512,     0,   513,
     514,   515,   516,   517,   172,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,   173,   174,     0,
     528,   529,   530,  1454,  1455,     0,  1456,     0,   531,   177,
     178,   532,   179,   533,   534,   535,   536,   537,   538,   539,
       0,  1457,   181,   540,   182,     0,   541,   542,   543,  1458,
    1459,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,  1460,   188,  1461,   556,   557,   190,  1462,
     558,   559,   192,   560,  1463,  1464,   561,  1465,   562,   563,
     564,     0,   565,     0,     0,  1466,   567,   568,     0,     0,
     195,   196,   197,   198,  1467,   569,   570,   571,   572,   573,
     574,   575,     0,   576,  1468,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,  1469,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,   209,   604,   605,
    1470,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,  1471,   619,   216,   620,   621,
     218,   622,  1472,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,  1473,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,  1474,  1475,     0,     0,
     642,  1476,   643,  1477,  1478,   644,   645,   646,   647,   648,
     649,     0,  1479,   650,   651,   652,   653,   654,  1480,     0,
     655,   656,   657,   658,   659,   660,  1481,     0,   661,   234,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,  1482,  1483,  1484,  1485,  1486,  1487,
    1488,  1489,   671,   672,   673,     0,     0,     0,     0,     0,
       0,     0,  1490,  1491,     0,     0,     0,     0,     0,     0,
       0,  1493,   710,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   711,   104,   105,   414,   712,     0,   107,   108,
     109,   110,   713,   714,   112,   113,   114,   115,     0,   116,
     715,   716,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,   424,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1426,  1427,  1428,    45,  1429,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,  1430,     0,     0,   436,   437,     0,
     438,   439,   133,   440,   441,   442,   135,  1431,   137,  1432,
    1433,     0,   443,   444,   445,   446,   447,  1434,  1435,   448,
     449,  1436,  1437,   451,     0,   452,   453,   454,   455,  1438,
       0,   456,     0,   457,   458,   459,   460,   147,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,   150,   469,
       0,  1439,  1440,  1441,  1442,  1443,  1444,  1445,   470,   471,
     472,   473,   474,   475,  1446,  1447,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,  1448,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,  1449,   500,
     501,   502,  1450,  1451,   503,     0,   504,  1452,   505,     0,
     506,     0,   507,   168,  2770,   169,   508,   509,   510,     0,
     511,  1453,     0,   512,     0,   513,   514,   515,   516,   517,
     172,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,   173,   174,     0,   528,   529,   530,  1454,
    1455,     0,  1456,     0,   531,   177,   178,   532,   179,   533,
     534,   535,   536,   537,   538,   539,     0,  1457,   181,   540,
     182,     0,   541,   542,   543,  1458,  1459,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,  1460,
     188,  1461,   556,   557,   190,  1462,   558,   559,   192,   560,
    1463,  1464,   561,  1465,   562,   563,   564,     0,   565,     0,
       0,  1466,   567,   568,     0,     0,   195,   196,   197,   198,
    1467,   569,   570,   571,   572,   573,   574,   575,     0,   576,
    1468,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,  1469,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,   209,   604,   605,  1470,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,  1471,   619,   216,   620,   621,   218,   622,  1472,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
    1473,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,  1474,  1475,     0,     0,   642,  1476,   643,  1477,
    1478,   644,   645,   646,   647,   648,   649,     0,  1479,   650,
     651,   652,   653,   654,  1480,     0,   655,   656,   657,   658,
     659,   660,  1481,     0,   661,   234,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
    1482,  1483,  1484,  1485,  1486,  1487,  1488,  1489,   671,   672,
     673,     0,     0,     0,     0,     0,     0,     0,  1490,  1491,
       0,     0,     0,     0,     0,     0,     0,  1493,   710,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   711,   104,
     105,   414,   712,     0,   107,   108,   109,   110,   713,   714,
     112,   113,   114,   115,     0,   116,   715,   716,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,   424,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1426,  1427,  1428,    45,
    1429,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
    1430,     0,     0,   436,   437,     0,   438,   439,   133,   440,
     441,   442,   135,  1431,   137,  1432,  1433,     0,   443,   444,
     445,   446,   447,  1434,  1435,   448,   449,  1436,  1437,   451,
       0,   452,   453,   454,   455,  1438,     0,   456,     0,   457,
     458,   459,   460,   147,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,   150,   469,     0,  1439,  1440,  1441,
    1442,  1443,  1444,  1445,   470,   471,   472,   473,   474,   475,
    1446,  1447,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,  1448,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,  1449,   500,   501,   502,  1450,  1451,
     503,     0,   504,  1452,   505,     0,   506,     0,   507,   168,
       0,   169,   508,   509,   510,     0,   511,  1453,     0,   512,
       0,   513,   514,   515,   516,   517,   172,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,   173,
     174,     0,   528,   529,   530,  1454,  1455,     0,  1456,     0,
     531,   177,   178,   532,   179,   533,   534,   535,   536,   537,
     538,   539,     0,  1457,   181,   540,   182,     0,   541,   542,
     543,  1458,  1459,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,  1460,   188,  1461,   556,   557,
     190,  1462,   558,   559,   192,   560,  1463,  1464,   561,  1465,
     562,   563,   564,     0,   565,     0,     0,  1466,   567,   568,
       0,     0,   195,   196,   197,   198,  1467,   569,   570,   571,
     572,   573,   574,   575,     0,   576,  1468,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
    1469,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,   209,
     604,   605,  1470,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,  1471,   619,   216,
     620,   621,   218,   622,  1472,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,  1473,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,  1474,  1475,
       0,     0,   642,  1476,   643,  1477,  1478,   644,   645,   646,
     647,   648,   649,     0,  1479,   650,   651,   652,   653,   654,
    1480,     0,   655,   656,   657,   658,   659,   660,  1481,  3952,
     661,   234,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,  1482,  1483,  1484,  1485,
    1486,  1487,  1488,  1489,   671,   672,   673,     0,     0,     0,
       0,     0,     0,     0,  1490,  1491,     0,     0,     0,     0,
       0,     0,     0,  1493,   710,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   711,   104,   105,   414,   712,     0,
     107,   108,   109,   110,   713,   714,   112,   113,   114,   115,
       0,   116,   715,   716,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,   424,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1426,  1427,  1428,    45,  1429,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,  1430,     0,     0,   436,
     437,     0,   438,   439,   133,   440,   441,   442,   135,  1431,
     137,  1432,  1433,     0,   443,   444,   445,   446,   447,  1434,
    1435,   448,   449,  1436,  1437,   451,     0,   452,   453,   454,
     455,  1438,     0,   456,     0,   457,   458,   459,   460,   147,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
     150,   469,  3965,  1439,  1440,  1441,  1442,  1443,  1444,  1445,
     470,   471,   472,   473,   474,   475,  1446,  1447,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,  1448,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
    1449,   500,   501,   502,  1450,  1451,   503,     0,   504,  1452,
     505,     0,   506,     0,   507,   168,     0,   169,   508,   509,
     510,     0,   511,  1453,     0,   512,     0,   513,   514,   515,
     516,   517,   172,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,   173,   174,     0,   528,   529,
     530,  1454,  1455,     0,  1456,     0,   531,   177,   178,   532,
     179,   533,   534,   535,   536,   537,   538,   539,     0,  1457,
     181,   540,   182,     0,   541,   542,   543,  1458,  1459,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,  1460,   188,  1461,   556,   557,   190,  1462,   558,   559,
     192,   560,  1463,  1464,   561,  1465,   562,   563,   564,     0,
     565,     0,     0,  1466,   567,   568,     0,     0,   195,   196,
     197,   198,  1467,   569,   570,   571,   572,   573,   574,   575,
       0,   576,  1468,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,  1469,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,   209,   604,   605,  1470,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,  1471,   619,   216,   620,   621,   218,   622,
    1472,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,  1473,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,  1474,  1475,     0,     0,   642,  1476,
     643,  1477,  1478,   644,   645,   646,   647,   648,   649,     0,
    1479,   650,   651,   652,   653,   654,  1480,     0,   655,   656,
     657,   658,   659,   660,  1481,     0,   661,   234,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,  1482,  1483,  1484,  1485,  1486,  1487,  1488,  1489,
     671,   672,   673,     0,     0,     0,     0,     0,     0,     0,
    1490,  1491,     0,     0,     0,     0,     0,     0,     0,  1493,
     710,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     711,   104,   105,   414,   712,     0,   107,   108,   109,   110,
     713,   714,   112,   113,   114,   115,     0,   116,   715,   716,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,   424,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1426,  1427,
    1428,    45,  1429,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,  1430,     0,     0,   436,   437,     0,   438,   439,
     133,   440,   441,   442,  4740,  1431,   137,  1432,  1433,     0,
     443,   444,   445,   446,   447,  1434,  1435,   448,   449,  1436,
    1437,   451,     0,   452,   453,   454,   455,  1438,     0,   456,
       0,   457,   458,   459,   460,   147,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,   150,   469,  4741,  1439,
    1440,  1441,  1442,  1443,  1444,  1445,   470,   471,   472,   473,
     474,   475,  1446,  1447,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,  1448,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,  1449,   500,   501,   502,
    1450,  1451,   503,     0,   504,  1452,   505,     0,   506,     0,
     507,   168,     0,   169,   508,   509,   510,     0,   511,  1453,
       0,   512,     0,   513,   514,   515,   516,   517,   172,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,   173,   174,     0,   528,   529,   530,  1454,  1455,     0,
    1456,     0,   531,   177,   178,   532,   179,   533,   534,   535,
     536,   537,   538,   539,     0,  1457,   181,   540,   182,     0,
     541,   542,   543,  1458,  1459,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,  1460,   188,  1461,
     556,   557,   190,  1462,   558,   559,   192,   560,  1463,  1464,
     561,  1465,   562,   563,   564,     0,   565,     0,     0,  1466,
     567,   568,     0,     0,   195,   196,   197,   198,  1467,   569,
     570,   571,   572,   573,   574,   575,     0,   576,  1468,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,  1469,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,   209,   604,   605,  1470,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,  1471,
     619,   216,   620,   621,   218,   622,  1472,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,  1473,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
    1474,  1475,     0,     0,   642,  1476,   643,  1477,  1478,   644,
     645,   646,  4742,   648,   649,     0,  1479,   650,   651,   652,
     653,   654,  1480,     0,   655,   656,   657,   658,   659,   660,
    1481,     0,   661,   234,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,  1482,  1483,
    1484,  1485,  1486,  1487,  1488,  1489,   671,   672,   673,     0,
       0,     0,     0,     0,     0,     0,  1490,  1491,     0,     0,
       0,     0,     0,     0,     0,  1493,   710,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   711,   104,   105,   414,
     712,     0,   107,   108,   109,   110,   713,   714,   112,   113,
     114,   115,     0,   116,   715,   716,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,   424,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1426,  1427,  1428,    45,  1429,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,  1430,     0,
       0,   436,   437,     0,   438,   439,   133,   440,   441,   442,
     135,  1431,   137,  1432,  1433,     0,   443,   444,   445,   446,
     447,  1434,  1435,   448,   449,  1436,  1437,   451,     0,   452,
     453,   454,   455,  1438,     0,   456,     0,   457,   458,   459,
     460,   147,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,   150,   469,  4741,  1439,  1440,  1441,  1442,  1443,
    1444,  1445,   470,   471,   472,   473,   474,   475,  1446,  1447,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,  1448,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,  1449,   500,   501,   502,  1450,  1451,   503,     0,
     504,  1452,   505,     0,   506,     0,   507,   168,     0,   169,
     508,   509,   510,     0,   511,  1453,     0,   512,     0,   513,
     514,   515,   516,   517,   172,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,   173,   174,     0,
     528,   529,   530,  1454,  1455,     0,  1456,     0,   531,   177,
     178,   532,   179,   533,   534,   535,   536,   537,   538,   539,
       0,  1457,   181,   540,   182,     0,   541,   542,   543,  1458,
    1459,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,  1460,   188,  1461,   556,   557,   190,  1462,
     558,   559,   192,   560,  1463,  1464,   561,  1465,   562,   563,
     564,     0,   565,     0,     0,  1466,   567,   568,     0,     0,
     195,   196,   197,   198,  1467,   569,   570,   571,   572,   573,
     574,   575,     0,   576,  1468,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,  1469,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,   209,   604,   605,
    1470,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,  1471,   619,   216,   620,   621,
     218,   622,  1472,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,  1473,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,  1474,  1475,     0,     0,
     642,  1476,   643,  1477,  1478,   644,   645,   646,  4742,   648,
     649,     0,  1479,   650,   651,   652,   653,   654,  1480,     0,
     655,   656,   657,   658,   659,   660,  1481,     0,   661,   234,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,  1482,  1483,  1484,  1485,  1486,  1487,
    1488,  1489,   671,   672,   673,     0,     0,     0,     0,     0,
       0,     0,  1490,  1491,     0,     0,     0,     0,     0,     0,
       0,  1493,   710,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   711,   104,   105,   414,   712,     0,   107,   108,
     109,   110,   713,   714,   112,   113,   114,   115,     0,   116,
     715,   716,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,   424,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1426,  1427,  1428,    45,  1429,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,  1430,     0,     0,   436,   437,     0,
     438,   439,   133,   440,   441,   442,   135,  1431,   137,  1432,
    1433,     0,   443,   444,   445,   446,   447,  1434,  1435,   448,
     449,  1436,  1437,   451,     0,   452,   453,   454,   455,  1438,
       0,   456,     0,   457,   458,   459,   460,   147,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,   150,   469,
       0,  1439,  1440,  1441,  1442,  1443,  1444,  1445,   470,   471,
     472,   473,   474,   475,  1446,  1447,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,  1448,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,  1449,   500,
     501,   502,  1450,  1451,   503,     0,   504,  1452,   505,     0,
     506,     0,   507,   168,     0,   169,   508,   509,   510,     0,
     511,  1453,     0,   512,     0,   513,   514,   515,   516,   517,
     172,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,   173,   174,     0,   528,   529,   530,  1454,
    1455,     0,  1456,     0,   531,   177,   178,   532,   179,   533,
     534,   535,   536,   537,   538,   539,     0,  1457,   181,   540,
     182,     0,   541,   542,   543,  1458,  1459,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,  1460,
     188,  1461,   556,   557,   190,  1462,   558,   559,   192,   560,
    1463,  1464,   561,  1465,   562,   563,   564,     0,   565,     0,
       0,  1466,   567,   568,     0,     0,   195,   196,   197,   198,
    1467,   569,   570,   571,   572,   573,   574,   575,     0,   576,
    1468,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,  1469,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,   209,   604,   605,  1470,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,  1471,   619,   216,   620,   621,   218,   622,  1472,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
    1473,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,  1474,  1475,     0,     0,   642,  1476,   643,  1477,
    1478,   644,   645,   646,   647,   648,   649,     0,  1479,   650,
     651,   652,   653,   654,  1480,     0,   655,   656,   657,   658,
     659,   660,  1481,     0,   661,   234,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
    1482,  1483,  1484,  1485,  1486,  1487,  1488,  1489,   671,   672,
     673,     0,     0,     0,     0,     0,     0,     0,  1490,  1491,
       0,     0,     0,     0,     0,     0,     0,  1493,   710,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   711,   104,
     105,   414,   712,     0,   107,   108,   109,   110,   713,   714,
     112,   113,   114,   115,     0,   116,   715,   716,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,   424,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1426,  1427,  1428,    45,
    1429,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
    1430,     0,     0,   436,   437,     0,   438,   439,   133,   440,
     441,   442,   135,  1431,   137,  1432,  1433,     0,   443,   444,
     445,   446,   447,  1434,  1435,   448,   449,  1436,  1437,   451,
       0,   452,   453,   454,   455,  1438,     0,   456,     0,   457,
     458,   459,   460,   147,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,   150,   469,     0,  1439,  1440,  1441,
    1442,  1443,  1444,  1445,   470,   471,   472,   473,   474,   475,
    1446,  1447,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,  1448,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,  1449,   500,   501,   502,  1450,  1451,
     503,     0,   504,  1452,   505,     0,   506,     0,   507,   168,
       0,   169,   508,   509,   510,     0,   511,  1453,     0,   512,
       0,   513,   514,   515,   516,   517,   172,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,   173,
     174,     0,   528,   529,   530,  1454,  1455,     0,  1456,     0,
     531,   177,   178,   532,   179,   533,   534,   535,   536,   537,
     538,   539,     0,  1457,   181,   540,   182,     0,   541,   542,
     543,  1458,  1459,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,  1460,   188,  1461,   556,   557,
     190,  1462,   558,   559,   192,   560,  1463,  1464,   561,  1465,
     562,   563,   564,     0,   565,     0,     0,  1466,   567,   568,
       0,     0,   195,   196,   197,   198,  1467,   569,   570,   571,
     572,   573,   574,   575,     0,   576,  1468,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
    1469,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,   209,
     604,   605,  1470,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,  1471,   619,   216,
     620,   621,   218,   622,  1472,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,  1473,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,  1474,  1475,
       0,     0,   642,  1476,   643,  1477,  1478,   644,   645,   646,
     647,   648,   649,     0,  1479,   650,   651,   652,   653,   654,
    1480,     0,   655,   656,   657,   658,   659,   660,  1481,     0,
     661,   234,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,  4231,  1482,  1483,  1484,  1485,
    1486,  1487,  1488,  1489,   671,   672,   673,     0,     0,     0,
       0,     0,     0,     0,  1490,  1491,     0,     0,     0,     0,
       0,     0,     0,  1493,   710,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   711,   104,   105,   414,   712,     0,
     107,   108,   109,   110,   713,   714,   112,   113,   114,   115,
       0,   116,   715,   716,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,   424,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1426,  1427,  1428,    45,  1429,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,  1430,     0,     0,   436,
     437,     0,   438,   439,   133,   440,   441,   442,   135,  1431,
     137,  1432,  1433,     0,   443,   444,   445,   446,   447,  1434,
    1435,   448,   449,  1436,  1437,   451,     0,   452,   453,   454,
     455,  1438,     0,   456,     0,   457,   458,   459,   460,   147,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
     150,   469,     0,  1439,  1440,  1441,  1442,  1443,  1444,  1445,
     470,   471,   472,   473,   474,   475,  1446,  1447,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,  1448,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
    1449,   500,   501,   502,  1450,  1451,   503,     0,   504,  1452,
     505,     0,   506,     0,   507,   168,     0,   169,   508,   509,
     510,     0,   511,  1453,     0,   512,     0,   513,   514,   515,
     516,   517,   172,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,   173,   174,     0,   528,   529,
     530,  1454,  1455,     0,  1456,     0,   531,   177,   178,   532,
     179,   533,   534,   535,   536,   537,   538,   539,     0,  1457,
     181,   540,   182,     0,   541,   542,   543,  1458,  1459,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,  1460,   188,  1461,   556,  4240,   190,  1462,   558,   559,
     192,   560,  1463,  1464,   561,  1465,   562,   563,   564,     0,
     565,     0,     0,  1466,   567,   568,     0,     0,   195,   196,
     197,   198,  1467,   569,   570,   571,   572,   573,   574,   575,
       0,   576,  1468,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,  1469,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,   209,   604,   605,  1470,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,  1471,   619,   216,   620,   621,   218,   622,
    1472,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,  1473,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,  1474,  1475,     0,     0,   642,  1476,
     643,  1477,  1478,   644,   645,   646,   647,   648,   649,     0,
    1479,   650,   651,   652,   653,   654,  1480,     0,   655,   656,
     657,   658,   659,   660,  1481,     0,   661,   234,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,  1482,  1483,  1484,  1485,  1486,  1487,  1488,  1489,
     671,   672,   673,     0,     0,     0,     0,     0,     0,     0,
    1490,  1491,     0,     0,     0,     0,     0,     0,     0,  1493,
     710,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     711,   104,   105,   414,   712,     0,   107,   108,   109,   110,
     713,   714,   112,   113,   114,   115,     0,   116,   715,   716,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,   424,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1426,  1427,
    1428,    45,  1429,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,  1430,     0,     0,   436,   437,     0,   438,   439,
     133,   440,   441,   442,   135,  1431,   137,  1432,  1433,     0,
     443,   444,   445,   446,   447,  1434,  1435,   448,   449,  1436,
    1437,   451,     0,   452,   453,   454,   455,  1438,     0,   456,
       0,   457,   458,   459,   460,   147,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,   150,   469,     0,  1439,
    1440,  1441,  1442,  1443,  1444,  1445,   470,   471,   472,   473,
     474,   475,  1446,  1447,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,  1448,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,  1449,   500,   501,   502,
    1450,  1451,   503,     0,   504,  1452,   505,     0,   506,     0,
     507,   168,     0,   169,   508,   509,   510,     0,   511,  1453,
       0,   512,     0,   513,   514,   515,   516,   517,   172,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,   173,   174,     0,   528,   529,   530,  1454,  1455,     0,
    1456,     0,   531,   177,   178,   532,   179,   533,   534,   535,
     536,   537,   538,   539,     0,  1457,   181,   540,   182,     0,
     541,   542,   543,  1458,  1459,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,  1460,   188,  1461,
     556,   557,   190,     0,   558,   559,   192,   560,  1463,  1464,
     561,  1465,   562,   563,   564,     0,   565,     0,     0,  1466,
     567,   568,     0,     0,   195,   196,   197,   198,  1467,   569,
     570,   571,   572,   573,   574,   575,     0,   576,  1468,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,  1469,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,   209,   604,   605,  1470,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,  1471,
     619,   216,   620,   621,   218,   622,  1472,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,  1473,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
    1474,  1475,     0,     0,   642,  1476,   643,  1477,  1478,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,  1480,     0,   655,   656,   657,   658,   659,   660,
    1481,     0,   661,   234,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,  1482,  1483,
    1484,  1485,  1486,  1487,  1488,  1489,   671,   672,   673,     0,
       0,     0,     0,     0,     0,     0,  2752,  2753,     0,     0,
       0,     0,     0,     0,     0,  1493,   710,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   711,   104,   105,   414,
     712,     0,   107,   108,   109,   110,   713,   714,   112,   113,
     114,   115,     0,   116,   715,   716,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,   424,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1426,  1427,  1428,    45,  1429,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,  1430,     0,
       0,   436,   437,     0,   438,   439,   133,   440,   441,   442,
   -2529,  1431,   137,  1432,  1433,     0,   443,   444,   445,   446,
     447,  1434,  1435,   448,   449,  1436,  1437,   451,     0,   452,
     453,   454,   455,  1438,     0,   456,     0,   457,   458,   459,
     460,   147,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,   150,   469,  4741,  1439,  1440,  1441,  1442,  1443,
    1444,  1445,   470,   471,   472,   473,   474,   475,  1446,  1447,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,  1448,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,  1449,   500,   501,   502,  1450,  1451,   503,     0,
     504,  1452,   505,     0,   506,     0,   507,   168,     0,   169,
     508,   509,   510,     0,   511,  1453,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,   173,   174,     0,
     528,   529,   530,  1454,  1455,     0,  1456,     0,   531,   177,
     178,   532,   179,   533,   534,   535,   536,   537,   538,   539,
       0,  1457,   181,   540,     0,     0,   541,   542,   543,  1458,
    1459,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,  1460,   188,  1461,   556,   557,   190,     0,
     558,   559,   192,   560,  1463,  1464,   561,  1465,   562,   563,
     564,     0,   565,     0,     0,  1466,   567,   568,     0,     0,
     195,   196,   197,   198,  1467,   569,   570,   571,   572,   573,
     574,   575,     0,   576,  1468,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,  1469,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,   209,   604,   605,
    1470,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,  1471,   619,   216,   620,   621,
       0,   622,  1472,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,  1473,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,  1474,  1475,     0,     0,
     642,  1476,   643,  1477,  1478,   644,   645,   646,  4742,   648,
     649,     0,  1479,   650,   651,   652,   653,   654,  1480,     0,
     655,   656,   657,   658,   659,   660,  1481,     0,   661,   234,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,  1482,  1483,  1484,  1485,  1486,  1487,
    1488,  1489,   671,   672,   673,     0,     0,     0,     0,     0,
       0,     0,  1490,  1491,     0,     0,     0,     0,     0,     0,
       0,  1493,   710,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   711,   104,   105,   414,   712,     0,   107,   108,
     109,   110,   713,   714,   112,   113,   114,   115,     0,   116,
     715,   716,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,   424,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1426,  1427,     0,    45,  1429,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,  1430,     0,     0,   436,   437,     0,
     438,   439,   133,   440,   441,   442,   135,  1431,   137,  1432,
    1433,     0,   443,   444,   445,   446,   447,  1434,  1435,   448,
     449,  1436,  1437,   451,     0,   452,   453,   454,   455,  1438,
       0,   456,     0,   457,   458,   459,   460,   147,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,   150,   469,
       0,  1439,  1440,  1441,  1442,  1443,  1444,  1445,   470,   471,
     472,   473,   474,   475,  1446,  1447,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,  1448,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,  1449,   500,
     501,   502,  1450,  1451,   503,     0,   504,  1452,   505,     0,
     506,     0,   507,   168,     0,   169,   508,   509,   510,     0,
     511,  1453,     0,   512,     0,   513,   514,   515,   516,   517,
     172,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,   173,   174,     0,   528,   529,   530,  1454,
    1455,     0,  1456,     0,   531,   177,   178,   532,   179,   533,
     534,   535,   536,   537,   538,   539,     0,  1457,   181,   540,
     182,     0,   541,   542,   543,  1458,  1459,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,  1460,
     188,  1461,   556,   557,   190,     0,   558,   559,   192,   560,
    1463,  1464,   561,  1465,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,   196,   197,   198,
    1467,   569,   570,   571,   572,   573,   574,   575,     0,   576,
    1468,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,  1469,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,   209,   604,   605,  1470,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,  1471,   619,   216,   620,   621,   218,   622,  1472,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
    1473,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,  1474,  1475,     0,     0,   642,  1476,   643,  1477,
    1478,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,  1480,     0,   655,   656,   657,   658,
     659,   660,  1481,     0,   661,   234,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
    1482,  1483,  1484,  1485,  1486,  1487,  1488,  1489,   671,   672,
     673,     0,     0,     0,   710,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,  1493,    98,    99,
     100,   101,   102,   103,   711,   104,   105,   414,   712,     0,
     107,   108,   109,   110,   713,   714,   112,   113,   114,   115,
       0,   116,   715,   716,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,   424,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1426,  1427,     0,    45,  1429,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,  1430,     0,     0,   436,
     437,     0,   438,   439,   133,   440,   441,   442,   135,  1431,
     137,  1432,  1433,     0,  3875,   444,   445,   446,   447,  1434,
    1435,   448,   449,  1436,  1437,   451,     0,   452,   453,   454,
     455,  1438,     0,   456,     0,   457,   458,   459,   460,   147,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
     150,   469,     0,  1439,  1440,  1441,  1442,  1443,  1444,  1445,
     470,   471,   472,   473,   474,   475,  1446,  1447,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,  1448,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
    1449,   500,   501,   502,  1450,  1451,   503,     0,   504,  1452,
     505,     0,   506,     0,   507,   168,     0,   169,   508,   509,
     510,     0,   511,  1453,     0,   512,     0,   513,   514,   515,
     516,   517,   172,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,   173,   174,     0,   528,   529,
     530,  1454,  1455,     0,  1456,     0,   531,   177,   178,   532,
     179,   533,   534,   535,   536,   537,   538,   539,     0,  1457,
     181,   540,   182,     0,   541,   542,   543,  1458,  1459,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,  1460,   188,  1461,   556,   557,   190,     0,   558,   559,
     192,   560,  1463,  1464,   561,  1465,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,   196,
     197,   198,  1467,   569,   570,   571,   572,   573,   574,   575,
       0,   576,  1468,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,  1469,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,   209,   604,   605,  1470,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,  1471,   619,   216,   620,   621,   218,   622,
    1472,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,  1473,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,  1474,  1475,     0,     0,   642,  1476,
     643,  1477,  1478,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,  1480,     0,   655,   656,
     657,   658,   659,   660,  1481,     0,   661,   234,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,  1482,  1483,  1484,  1485,  1486,  1487,  1488,  1489,
     671,   672,   673,     0,     0,     0,   710,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,  1493,
      98,    99,   100,   101,   102,   103,   711,   104,   105,   414,
     712,     0,   107,   108,   109,   110,   713,   714,   112,   113,
     114,   115,     0,   116,   715,   716,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,   424,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1426,  1427,  1428,    45,  1429,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,  1430,     0,
       0,   436,   437,     0,   438,   439,   133,   440,   441,   442,
       0,  1431,   137,  1432,  1433,     0,   443,   444,   445,   446,
     447,  1434,  1435,   448,   449,  1436,  1437,   451,     0,   452,
     453,   454,   455,  1438,     0,   456,     0,   457,   458,   459,
     460,   147,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,   150,   469,     0,  1439,  1440,  1441,  1442,  1443,
    1444,  1445,   470,   471,   472,   473,   474,   475,  1446,  1447,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,  1448,   489,   490,
       0,   491,   492,   493,     0,   494,     0,     0,   496,   497,
     498,   499,  1449,   500,   501,   502,  1450,  1451,   503,     0,
     504,  1452,   505,     0,   506,     0,   507,   168,     0,   169,
     508,   509,   510,     0,   511,  1453,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,   173,   174,     0,
     528,   529,   530,  1454,  1455,     0,  1456,     0,   531,   177,
     178,   532,   179,   533,   534,   535,   536,   537,   538,   539,
       0,  1457,   181,   540,     0,     0,   541,   542,   543,  1458,
    1459,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,  1460,   188,  1461,   556,   557,   190,     0,
     558,   559,   192,   560,  1463,  1464,   561,  1465,   562,   563,
     564,     0,   565,     0,     0,  1466,   567,   568,     0,     0,
     195,   196,   197,   198,  1467,   569,   570,   571,   572,   573,
     574,   575,     0,   576,  1468,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,  1469,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,   209,   604,   605,
    1470,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,  1471,   619,   216,   620,   621,
       0,   622,  1472,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,  1473,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,  1474,  1475,     0,     0,
     642,  1476,   643,  1477,  1478,   644,   645,   646,   647,   648,
     649,     0,  1479,   650,   651,   652,   653,   654,  1480,     0,
     655,   656,   657,   658,   659,   660,  1481,     0,   661,   234,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,  1482,  1483,  1484,  1485,  1486,  1487,
    1488,  1489,   671,   672,   673,     0,     0,     0,     0,     0,
       0,     0,  1490,  1491,     0,     0,     0,     0,     0,     0,
       0,  1493,   710,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   711,   104,   105,   414,   712,     0,   107,   108,
     109,   110,   713,   714,   112,   113,   114,   115,     0,   116,
     715,   716,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,   424,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1426,  1427,  1428,    45,  1429,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,  1430,     0,     0,   436,   437,     0,
     438,   439,   133,   440,   441,   442,     0,  1431,   137,  1432,
    1433,     0,   443,   444,   445,   446,   447,  1434,  1435,   448,
     449,  1436,  1437,   451,     0,   452,   453,   454,   455,  1438,
       0,   456,     0,   457,   458,   459,   460,   147,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,   150,   469,
       0,  1439,  1440,  1441,  1442,  1443,  1444,  1445,   470,   471,
     472,   473,   474,   475,  1446,  1447,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,  1448,   489,   490,     0,   491,   492,   493,
       0,   494,     0,     0,   496,   497,   498,   499,  1449,   500,
     501,   502,  1450,  1451,   503,     0,   504,  1452,   505,     0,
     506,     0,   507,   168,     0,   169,   508,   509,   510,     0,
     511,  1453,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,   173,   174,     0,   528,   529,   530,  1454,
    1455,     0,  1456,     0,   531,   177,   178,   532,   179,   533,
     534,   535,   536,   537,   538,   539,     0,  1457,   181,   540,
       0,     0,   541,   542,   543,  1458,  1459,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,  1460,
     188,  1461,   556,   557,   190,     0,   558,   559,   192,   560,
    1463,  1464,   561,  1465,   562,   563,   564,     0,   565,     0,
       0,  1466,   567,   568,     0,     0,   195,   196,   197,   198,
    1467,   569,   570,   571,   572,   573,   574,   575,     0,   576,
    1468,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,  1469,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,   209,   604,   605,  1470,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,  1471,   619,   216,   620,   621,     0,   622,  1472,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
    1473,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,  1474,  1475,     0,     0,   642,  1476,   643,  1477,
    1478,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,  1480,     0,   655,   656,   657,   658,
     659,   660,  1481,     0,   661,   234,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
    1482,  1483,  1484,  1485,  1486,  1487,  1488,  1489,   671,   672,
     673,     0,     0,     0,     0,     0,     0,     0,  2752,  2753,
       0,     0,     0,     0,     0,     0,     0,  1493,   710,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   711,   104,
     105,   414,   712,     0,   107,   108,   109,   110,   713,   714,
     112,   113,   114,   115,     0,   116,   715,   716,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,   133,   440,
     441,   442,   135,   136,   137,   138,   139,     0,   443,   444,
     445,   446,   447,     0,  1435,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,  1438,     0,   456,     0,   457,
     458,   459,   460,   147,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,   150,   469,     0,  1439,  1440,  1441,
    1442,  1443,  1444,  1445,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,  1450,     0,
     503,     0,   504,   167,   505,     0,   506,     0,   507,   168,
       0,   169,   508,   509,   510,     0,   511,  1453,     0,   512,
       0,   513,   514,   515,   516,   517,   172,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,   173,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,   177,   178,   532,   179,   533,   534,   535,   536,   537,
     538,   539,     0,  1457,   181,   540,   182,     0,   541,   542,
     543,  1458,  1459,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,   188,   189,   556,   557,
     190,     0,   558,   559,   192,   560,     0,  1464,   561,   194,
     562,   563,   564,     0,   565,     0,  1055,   566,   567,   568,
       0,     0,   195,   196,   197,   198,  1467,   569,   570,   571,
     572,   573,   574,   575,     0,   576,  1468,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,   209,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,   214,   614,   615,   616,   617,   618,  1471,   619,   216,
     620,   621,   218,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,  1473,     0,   633,   634,
     222,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,  1476,   643,  1477,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
    1480,     0,   655,   656,   657,   658,   659,  1352,   233,     0,
     661,   234,   662,   663,   664,     0,     0,   665,     0,   235,
     666,   667,   668,   669,   670,   236,  1482,  1483,  1484,  1485,
    1486,  1487,  1488,  1489,   671,   672,   673,     0,     0,     0,
     710,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,  3438,    98,    99,   100,   101,   102,   103,
     711,   104,   105,   414,   712,     0,   107,   108,   109,   110,
     713,   714,   112,   113,   114,   115,     0,   116,   715,   716,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
     133,   440,   441,   442,   135,   136,   137,   138,   139,     0,
     443,   444,   445,   446,   447,     0,  1435,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,  1438,     0,   456,
       0,   457,   458,   459,   460,   147,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,   150,   469,     0,  1439,
    1440,  1441,  1442,  1443,  1444,  1445,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
    1450,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,   168,     0,   169,   508,   509,   510,     0,   511,  1453,
       0,   512,     0,   513,   514,   515,   516,   517,   172,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,   173,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,   177,   178,   532,   179,   533,   534,   535,
     536,   537,   538,   539,     0,  1457,   181,   540,   182,     0,
     541,   542,   543,  1458,  1459,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,   188,   189,
     556,   557,   190,     0,   558,   559,   192,   560,     0,  1464,
     561,   194,   562,   563,   564,     0,   565,     0,  1055,   566,
     567,   568,     0,     0,   195,   196,   197,   198,  1467,   569,
     570,   571,   572,   573,   574,   575,     0,   576,  1468,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,   209,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,  1471,
     619,   216,   620,   621,   218,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,  1473,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,  1476,   643,  1477,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,  1480,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,   234,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,  1482,  1483,
    1484,  1485,  1486,  1487,  1488,  1489,   671,   672,   673,     0,
       0,     0,   710,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,  3438,    98,    99,   100,   101,
     102,   103,   711,   104,   105,   414,   712,     0,   107,   108,
     109,   110,   713,   714,   112,   113,   114,   115,     0,   116,
     715,   716,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,   133,   440,   441,   442,   135,   136,   137,   138,
     139,     0,   443,   444,   445,   446,   447,     0,  1435,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,  1438,
       0,   456,     0,   457,   458,   459,   460,   147,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,   150,   469,
       0,  1439,  1440,  1441,  1442,  1443,  1444,  1445,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,  1450,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,   168,     0,   169,   508,   509,   510,     0,
     511,  1453,     0,   512,     0,   513,   514,   515,   516,   517,
     172,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,   173,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,   177,   178,   532,   179,   533,
     534,   535,   536,   537,   538,   539,     0,  1457,   181,   540,
     182,     0,   541,   542,   543,  1458,  1459,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
     188,   189,   556,   557,   190,     0,   558,   559,   192,   560,
       0,  1464,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,   196,   197,   198,
    1467,   569,   570,   571,   572,   573,   574,   575,     0,   576,
    1468,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,   209,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,  1471,   619,   216,   620,   621,   218,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
    1473,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,  1476,   643,  1477,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,  1480,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,   234,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
    1482,  1483,  1484,  1485,  1486,  1487,  1488,  1489,   671,   672,
     673,     0,     0,     0,   710,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,  3990,    98,    99,
     100,   101,   102,   103,   711,   104,   105,   414,   712,     0,
     107,   108,   109,   110,   713,   714,   112,   113,   114,   115,
       0,   116,   715,   716,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,   133,   440,   441,   442,   135,   136,
     137,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,   147,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
     150,   469,     0,     0,     0,     0,   151,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,     0,   503,     0,   504,   167,
     505,     0,   506,     0,   507,   168,     0,   169,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,   172,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,   173,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,   177,   178,   532,
     179,   533,   534,   535,   536,   537,   538,   539,     0,   180,
     181,   540,   182,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,   188,   189,   556,   557,   190,     0,   558,   559,
     192,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,   195,   196,
     197,   198,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,   209,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,   218,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,   234,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,     0,     0,     0,     0,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,  4518,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,  3919,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0, -1390,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0, -1390,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527, -1390,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532, -1390,   533,   534,   535,   536,   537,   538,   539,
       0,   180, -1390,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187, -1390,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603, -1390,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,     0,     0,     0,     0,     0,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,  1583,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,     0,     0,
       0,     0,     0,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,  3200,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,   424,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
       0,     0,     0,    45,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,  1984,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,  1985,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
    1986,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,     0,     0,     0,     0,     0,     0,     0,   973,  1626,
    4095,     0,     0,     0,     0,     0,     0,  4096,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,    45,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,     0,     0,     0,     0,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,  3696,  3697,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   130,   131,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,   214,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,   222,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,  1352,   233,
       0,   661,  1353,   662,   663,   664,     0,     0,   665,     0,
     235,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,     0,     0,
       0,     0,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,   245,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,    45,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
       0,     0,     0,     0,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,  3697,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
     424,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,   214,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,   222,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,  1352,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,   235,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,     0,     0,     0,     0,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,   245,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,   214,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,   222,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,  1352,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,   235,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,     0,     0,     0,     0,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
     245,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,     0,     0,     0,     0,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,  1558,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,     0,     0,
       0,     0,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,  2910,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
       0,     0,     0,     0,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,  3946,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,     0,     0,     0,   710,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,  4275,    98,
      99,   100,   101,   102,   103,   711,   104,   105,   414,   712,
       0,   107,   108,   109,   110,   713,   714,   112,   113,   114,
     115,     0,   116,   715,   716,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,   424,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,  1176,    45,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,   717,
     433,   434,   435,   718,   719,   720,   721,   722,   723,   724,
     436,   437,   725,   438,   439,   133,   440,   441,   442,     0,
    1835,   137,  1836,  1837,   726,   443,   444,   445,   446,   447,
     727,   728,   448,   449,  1838,  1839,   451,   730,   452,   453,
     454,   455,     0,   731,   456,   732,   457,   458,   459,   460,
     147,   461,   462,   734,   463,   464,   465,   466,   467,   468,
     735,   150,   469,     0,   737,   738,   739,   151,   740,   741,
     742,   470,   471,   472,   473,   474,   475,  1840,  1841,   476,
     743,   477,   744,   478,   479,   480,   481,   482,   745,   483,
     484,   485,   746,   747,   486,   487,  1448,   489,   490,   748,
     491,   492,   493,   749,   494,   495,   750,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   751,   503,   752,   504,
    1842,   505,   753,   506,   754,   507,   168,   755,   169,   508,
     509,   510,   756,   511,     0,   757,   512,   758,   513,   514,
     515,   516,   517,   172,   518,   519,   520,   759,   521,   522,
     523,   524,   525,   526,   760,   527,   173,     0,     0,   528,
     529,   530,  1454,  1843,   763,  1844,   764,   531,   177,   178,
     532,   179,   533,   534,   535,   536,   537,   538,   539,   765,
       0,   181,   540,   182,   766,   541,   542,   543,   767,   768,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,  1845,   188,  1846,   556,   557,     0,   769,   558,
     559,   192,   560,   770,     0,   561,  1847,   562,   563,   564,
     771,   565,   772,   773,  3683,   567,   568,   774,   775,     0,
     196,   197,   198,     0,   569,   570,   571,   572,   573,   574,
     575,   776,   576,     0,   577,     0,   578,   579,   580,   777,
     581,   582,   583,   584,   585,   586,   587,  1848,   588,   589,
     590,   591,   778,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,   779,   602,   603,   209,   604,   605,     0,
     606,   607,   608,   609,   610,   611,   612,   613,   780,   614,
     615,   616,   617,   618,   781,   619,  2384,   620,   621,   218,
     622,  1850,   782,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,     0,   783,   633,   634,   784,   635,   636,
     637,   638,   639,   640,   785,  1851,  1852,     0,   787,   642,
       0,   643,     0,   788,   644,   645,   646,   647,   648,   649,
       0,   790,   650,   651,   652,   653,   654,   791,   792,   655,
     656,   657,   658,   659,     0,  1853,   794,   661,   234,   662,
     663,   664,   795,   796,   665,   797,   798,   666,   667,   668,
     669,   670,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   671,   672,   673,     0,     0,     0,  1179,  1180,  1181,
       0,  3684,  3685,  1184,  1185,  1186,  1187,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   414,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,  1176,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,     0,   440,   441,   442,
     135,   136,     0,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
    1177,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,     0,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   469,     0,     0,     0,     0,     0,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,  1178,     0,
     504,   167,   505,     0,   506,     0,   507,     0,     0,     0,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,   517,     0,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,     0,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,     0,
       0,   532,     0,   533,   534,   535,   536,   537,   538,   539,
       0,   180,     0,   540,     0,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,     0,   189,   556,   557,   190,     0,
     558,   559,     0,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,     0,     0,     0,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,     0,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
       0,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,     0,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,     0,     0,     0,  1179,  1180,
    1181,     0,  1182,  1183,  1184,  1185,  1186,  1187,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,  1176,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,  1262,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,  1263,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,     0,     0,     0,  1179,
    1180,  1181,     0,  1182,  1183,  1184,  1185,  1186,  1187,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1176,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   440,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,  1313,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
    1314,     0,   504,   167,   505,     0,   506,     0,   507,     0,
       0,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,  1315,     0,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   537,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   556,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,     0,     0,     0,
    1179,  1180,  1181,     0,  1182,  1183,  1184,  1185,  1186,  1187,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,  1176,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,  1818,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,  1819,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,     0,     0,
       0,  1179,  1180,  1181,     0,  1182,  1183,  1184,  1185,  1186,
    1187,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
    1176,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,     0,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,     0,
       0,     0,  1179,  1180,  1181,     0,  1182,  1183,  1184,  1185,
    1186,  1187,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,  1176,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,  2989,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,  2990,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
       0,     0,     0,  1179,  1180,  1181,     0,  1182,  1183,  1184,
    1185,  1186,  1187,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1176,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,  4505,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,     0,     0,     0,  1179,  1180,  1181,     0,  1182,  1183,
    1184,  1185,  1186,  1187,   710,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   711,   104,   105,   414,   712,     0,
     107,   108,   109,   110,   713,   714,   112,   113,   114,   115,
       0,   116,   715,   716,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,   717,   433,
     434,   435,   718,   719,   720,   721,   722,   723,   724,   436,
     437,   725,   438,   439,   133,   440,   441,   442,   135,   136,
     137,   138,   139,   726,   443,   444,   445,   446,   447,   727,
     728,   448,   449,   729,   140,   451,   730,   452,   453,   454,
     455,   144,   731,   456,   732,   457,   458,   459,   460,   147,
     461,   733,   734,   463,   464,   465,   466,   467,   468,   735,
     150,   469,   736,   737,   738,   739,   151,   740,   741,   742,
     470,   471,   472,   473,   474,   475,   154,   155,   476,   743,
     477,   744,   478,   479,   480,   481,   482,   745,   483,   484,
     485,   746,   747,   486,   487,   488,   489,   490,   748,   491,
     492,   493,   749,   494,   495,   750,   496,   497,   498,   499,
     163,   500,   501,   502,   165,   751,   503,   752,   504,   167,
     505,   753,   506,   754,   507,   168,   755,   169,   508,   509,
     510,   756,   511,   171,   757,   512,   758,   513,   514,   515,
     516,   517,   172,   518,   519,   520,   759,   521,   522,   523,
     524,   525,   526,   760,   527,   173,   174,   761,   528,   529,
     530,   762,   175,   763,   176,   764,   531,   177,   178,   532,
     179,   533,   534,   535,   536,   537,   538,   539,   765,   180,
     181,   540,   182,   766,   541,   542,   543,   767,   768,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,   188,   189,   556,   557,   190,   769,   558,   559,
     192,   560,   770,   193,   561,   194,   562,   563,   564,   771,
     565,   772,   773,   566,   567,   568,   774,   775,   195,   196,
     197,   198,   199,   569,   570,   571,   572,   573,   574,   575,
     776,   576,   200,   577,   201,   578,   579,   580,   777,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,   778,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,   779,   602,   603,   209,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,   780,   614,   615,
     616,   617,   618,   781,   619,   216,   620,   621,   218,   622,
     219,   782,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,   783,   633,   634,   784,   635,   636,   637,
     638,   639,   640,   785,   223,   224,   786,   787,   642,   225,
     643,   226,   788,   644,   645,   646,   647,   648,   649,   789,
     790,   650,   651,   652,   653,   654,   791,   792,   655,   656,
     657,   658,   659,   793,   233,   794,   661,   234,   662,   663,
     664,   795,   796,   665,   797,   798,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,   710,    86,    87,    88,   411,    90,    91,
      92,   412,  2208,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   711,   104,   105,   414,   712,     0,   107,
     108,   109,   110,   713,   714,   112,   113,   114,   115,     0,
     116,   715,   716,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,   133,   440,   441,   442,     0,  1835,   137,
    1836,  1837,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,  1838,  1839,   451,     0,   452,   453,   454,   455,
       0,     0,   456,     0,   457,   458,   459,   460,   147,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,   150,
     469,     0,     0,     0,     0,   151,     0,     0,     0,   470,
     471,   472,   473,   474,   475,  1840,  1841,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,  1448,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,     0,
     500,   501,   502,     0,     0,   503,     0,   504,  1842,   505,
       0,   506,     0,   507,   168,     0,   169,   508,   509,   510,
       0,   511,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   172,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,   173,     0,     0,   528,   529,   530,
    1454,  1843,     0,  1844,     0,   531,   177,   178,   532,   179,
     533,   534,   535,   536,   537,   538,   539,     0,     0,   181,
     540,   182,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
    1845,   188,  1846,   556,   557,     0,     0,   558,   559,   192,
     560,     0,     0,   561,  1847,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,     0,   196,   197,
     198,     0,   569,   570,   571,   572,   573,   574,   575,     0,
     576,     0,   577,     0,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,  1848,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,   209,   604,   605,     0,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,  1849,   620,   621,   218,   622,  1850,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,  1851,  1852,     0,     0,   642,     0,   643,
       0,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,     0,  1853,     0,   661,   234,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   671,
     672,   673,     0,    86,    87,    88,   411,    90,    91,    92,
     412,  2307,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,     0,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,     0,    86,    87,    88,   411,    90,    91,    92,   412,
    1062,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
       0,    86,    87,    88,   411,    90,    91,    92,   412,  4371,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   414,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,   424,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
       0,   440,   441,   442,   135,   136,     0,   138,   139,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,   450,
     140,   451,     0,   452,   453,   454,   455,   144,     0,   456,
       0,   457,   458,   459,   460,     0,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   469,     0,     0,
       0,     0,     0,     0,     0,     0,   470,   471,   472,   473,
     474,   475,   154,   155,   476,  2196,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,   488,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,   163,   500,   501,   502,
     165,  1984,   503,     0,   504,   167,   505,     0,   506,     0,
     507,     0,     0,     0,   508,   509,   510,     0,   511,   171,
       0,   512,     0,   513,   514,   515,   516,   517,     0,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,     0,   174,     0,   528,   529,   530,     0,   175,     0,
     176,     0,   531,     0,     0,   532,     0,   533,   534,   535,
     536,   537,   538,   539,     0,   180,     0,   540,     0,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,     0,   189,
     556,   557,   190,     0,   558,   559,     0,   560,     0,   193,
     561,   194,   562,   563,   564,     0,   565,  1985,     0,   566,
     567,   568,     0,     0,   195,     0,     0,     0,   199,   569,
     570,   571,   572,   573,   574,   575,     0,   576,   200,   577,
     201,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,     0,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,   216,   620,   621,     0,   622,   219,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
     223,   224,     0,     0,   642,   225,   643,   226,  1986,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,   660,
     233,     0,   661,     0,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,     0,
       0,     0,     0,     0,     0,     0,   973,  1626,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,   424,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,  2201,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,  1984,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,  1985,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,  1986,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,     0,     0,     0,     0,
       0,     0,     0,   973,  1626,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   414,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,   424,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,     0,     0,     0,    45,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,     0,   440,   441,   442,   135,   136,
       0,   138,   139,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,   450,   140,   451,     0,   452,   453,   454,
     455,   144,     0,   456,     0,   457,   458,   459,   460,     0,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   469,     0,     0,     0,     0,     0,     0,     0,     0,
     470,   471,   472,   473,   474,   475,   154,   155,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,   488,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
     163,   500,   501,   502,   165,  1984,   503,     0,   504,   167,
     505,     0,   506,     0,   507,     0,     0,     0,   508,   509,
     510,     0,   511,   171,     0,   512,     0,   513,   514,   515,
     516,   517,     0,   518,   519,   520,     0,   521,   522,   523,
     524,   525,   526,     0,   527,     0,   174,     0,   528,   529,
     530,     0,   175,     0,   176,     0,   531,     0,     0,   532,
       0,   533,   534,   535,   536,   537,   538,   539,     0,   180,
       0,   540,     0,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   187,     0,   189,   556,   557,   190,     0,   558,   559,
       0,   560,     0,   193,   561,   194,   562,   563,   564,     0,
     565,  1985,     0,   566,   567,   568,     0,     0,   195,     0,
       0,     0,   199,   569,   570,   571,   572,   573,   574,   575,
       0,   576,   200,   577,   201,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,   203,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,     0,   604,   605,   211,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,   216,   620,   621,     0,   622,
     219,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   221,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,   223,   224,     0,     0,   642,   225,
     643,   226,  1986,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,   660,   233,     0,   661,     0,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     671,   672,   673,     0,     0,     0,     0,     0,     0,     0,
     973,  1626,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,   424,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,   425,   962,   427,
     428,   429,   430,   431,   432,   963,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   964,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   965,   167,   505,     0,   506,
       0,   966,     0,   967,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,   968,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   969,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   970,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   971,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     972,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
       0,     0,     0,     0,     0,     0,     0,   973,   974,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   414,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,   424,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,    45,
       0,     0,     0,     0,   425,   962,   427,   428,   429,   430,
     431,   432,   963,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,     0,   995,
     441,   442,   135,   136,     0,   138,   139,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,   450,   140,   451,
       0,   452,   453,   454,   455,   144,     0,   456,     0,   457,
     458,   459,   460,     0,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   469,     0,     0,     0,     0,
       0,     0,     0,     0,   470,   471,   472,   473,   474,   475,
     154,   155,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,   488,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,   163,   500,   501,   502,   165,     0,
     503,     0,   965,   167,   505,     0,   506,     0,   996,     0,
     967,     0,   508,   509,   510,     0,   511,   171,     0,   512,
       0,   513,   514,   515,   516,   517,     0,   518,   519,   520,
     968,   521,   522,   523,   524,   525,   526,     0,   527,     0,
     174,     0,   528,   529,   530,     0,   175,     0,   176,     0,
     531,     0,     0,   532,     0,   533,   534,   535,   536,   969,
     538,   539,     0,   180,     0,   540,     0,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,     0,   189,   970,   557,
     190,     0,   558,   559,     0,   560,     0,   193,   561,   194,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,   195,     0,     0,     0,   199,   569,   570,   571,
     572,   573,   574,   575,     0,   576,   200,   577,   201,   578,
     579,   580,     0,   971,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,     0,   592,   972,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,     0,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,   216,
     620,   621,     0,   622,   219,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,   223,   224,
       0,     0,   642,   225,   643,   226,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,   660,   233,     0,
     661,     0,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,     0,     0,     0,
       0,     0,     0,     0,   973,   974,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,   424,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,  1363,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,   967,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,   968,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,     0,     0,     0,     0,     0,     0,
       0,   973,   974,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   414,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,   424,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,  1368,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,     0,   440,   441,   442,   135,   136,     0,   138,
     139,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,   450,   140,   451,     0,   452,   453,   454,   455,   144,
       0,   456,     0,   457,   458,   459,   460,     0,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   469,
       0,     0,     0,     0,     0,     0,     0,     0,   470,   471,
     472,   473,   474,   475,   154,   155,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,   488,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,   163,   500,
     501,   502,   165,     0,   503,     0,   504,   167,   505,     0,
     506,     0,   507,     0,   967,     0,   508,   509,   510,     0,
     511,   171,     0,   512,     0,   513,   514,   515,   516,   517,
       0,   518,   519,   520,   968,   521,   522,   523,   524,   525,
     526,     0,   527,     0,   174,     0,   528,   529,   530,     0,
     175,     0,   176,     0,   531,     0,     0,   532,     0,   533,
     534,   535,   536,   537,   538,   539,     0,   180,     0,   540,
       0,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,   187,
       0,   189,   556,   557,   190,     0,   558,   559,     0,   560,
       0,   193,   561,   194,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,   195,     0,     0,     0,
     199,   569,   570,   571,   572,   573,   574,   575,     0,   576,
     200,   577,   201,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,   203,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,     0,   604,   605,   211,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,   216,   620,   621,     0,   622,   219,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     221,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,   223,   224,     0,     0,   642,   225,   643,   226,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,   660,   233,     0,   661,     0,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   671,   672,
     673,     0,     0,     0,     0,     0,     0,     0,   973,   974,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,   424,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,   695,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,  1530,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,     0,     0,
    1034,  1531,    86,    87,    88,   411,    90,    91,    92,   412,
    1035,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,  1036,   449,
    1010,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,  1037,     0,
    1038,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,  1039,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,  1040,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,  1041,   605,   211,   606,   607,   608,  1042,
     610,   611,   612,   613,     0,   614,   615,   616,   617,  1043,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,  1044,   224,     0,     0,  1045,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
    1014,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,  1046,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
     710,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     711,   104,   105,   414,   712,     0,   107,   108,   109,   110,
     713,   714,   112,   113,   114,   115,     0,   116,   715,   716,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,   717,   433,   434,   435,   718,   719,
     720,   721,   722,   723,   724,   436,   437,   725,   438,   439,
     133,   440,   441,   442,   135,   136,   137,   138,   139,   726,
     443,   444,   445,   446,   447,   727,   728,   448,   449,   729,
     140,   451,   730,   452,   453,   454,   455,   144,   731,   456,
     732,   457,   458,   459,   460,   147,   461,   733,   734,   463,
     464,   465,   466,   467,   468,   735,   150,   469,   736,   737,
     738,   739,   151,   740,   741,   742,   470,   471,   472,   473,
     474,   475,   154,   155,   476,   743,   477,   744,   478,   479,
     480,   481,   482,   745,   483,   484,   485,   746,   747,   486,
     487,   488,   489,   490,   748,   491,   492,   493,   749,   494,
     495,   750,   496,   497,   498,   499,   163,   500,   501,   502,
     165,   751,   503,   752,   504,   167,   505,   753,   506,   754,
     507,   168,   755,   169,   508,   509,   510,   756,   511,   171,
     757,   512,   758,   513,   514,   515,   516,   517,   172,   518,
     519,   520,   759,   521,   522,   523,   524,   525,   526,   760,
     527,   173,   174,   761,   528,   529,   530,   762,   175,   763,
     176,   764,   531,   177,   178,   532,   179,   533,   534,   535,
     536,   537,   538,   539,   765,   180,   181,   540,   182,   766,
     541,   542,   543,   767,   768,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   187,   188,   189,
     556,   557,   190,   769,   558,   559,   192,   560,   770,   193,
     561,   194,   562,   563,   564,   771,   565,   772,   773,   566,
     567,   568,   774,   775,   195,   196,   197,   198,   199,   569,
     570,   571,   572,   573,   574,   575,   776,   576,   200,   577,
     201,   578,   579,   580,   777,   581,   582,   583,   584,   585,
     586,   587,   203,   588,   589,   590,   591,   778,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,   779,   602,
     603,   209,   604,   605,   211,   606,   607,   608,   609,   610,
     611,   612,   613,   780,   614,   615,   616,   617,   618,   781,
     619,   216,   620,   621,   218,   622,   219,   782,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   221,   783,
     633,   634,   784,   635,   636,   637,   638,   639,   640,   785,
     223,   224,   786,   787,   642,   225,   643,   226,   788,   644,
     645,   646,   647,   648,   649,   789,   790,   650,   651,   652,
     653,   654,   791,   792,   655,   656,   657,   658,   659,   793,
     233,   794,   661,   234,   662,   663,   664,   795,   796,   665,
     797,   798,   666,   667,   668,   669,   670,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   671,   672,   673,   710,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   711,
     104,   105,   414,   712,     0,   107,   108,   109,   110,   713,
     714,   112,   113,   114,   115,     0,   116,   715,   716,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,   717,   433,   434,   435,   718,   719,   720,
     721,   722,   723,   724,   436,   437,   725,   438,   439,   133,
     440,   441,   442,   135,   136,   137,   138,   139,   726,   443,
     444,   445,   446,   447,   727,   728,   448,   449,   729,   140,
     451,   730,   452,   453,   454,   455,   144,   731,   456,   732,
     457,   458,   459,   460,   147,   461,   733,   734,   463,   464,
     465,   466,   467,   468,   735,   150,   469,   736,   737,   738,
     739,   151,   740,   741,   742,   470,   471,   472,   473,   474,
     475,   154,   155,   476,   743,   477,   744,   478,   479,   480,
     481,   482,   745,   483,   484,   485,   746,   747,   486,   487,
     488,   489,   490,   748,   491,   492,   493,   749,   494,   495,
     750,   496,   497,   498,   499,   163,   500,   501,   502,   165,
     751,   503,   752,   504,   167,   505,   753,   506,   754,   507,
     168,   755,   169,   508,   509,   510,   756,   511,   171,   757,
     512,   758,   513,   514,   515,   516,   517,   172,   518,   519,
     520,   759,   521,   522,   523,   524,   525,   526,   760,   527,
     173,   174,   761,   528,   529,   530,   762,   175,   763,   176,
     764,   531,   177,   178,   532,   179,   533,   534,   535,   536,
     537,   538,   539,   765,   180,   181,   540,   182,   766,   541,
     542,   543,   767,   768,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,   188,   189,   556,
     557,   190,   769,   558,   559,   192,   560,   770,   193,   561,
     194,   562,   563,   564,   771,   565,   772,   773,   566,   567,
     568,   774,   775,   195,   196,   197,   198,   199,   569,   570,
     571,   572,   573,   574,   575,   776,   576,   200,   577,   201,
     578,   579,   580,   777,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,   778,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   779,   602,   603,
     209,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,   780,   614,   615,   616,   617,   618,   781,   619,
     216,   620,   621,   218,   622,   219,   782,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,   783,   633,
     634,   784,   635,   636,   637,   638,   639,   640,   785,   223,
     224,   786,   787,   642,   225,   643,   226,   788,   644,   645,
     646,   647,   648,   649,   789,   790,   650,   651,   652,   653,
     654,   791,   792,   655,   656,   657,   658,   659,   793,   233,
     794,   661,   234,   662,   663,   664,   795,   796,   665,   797,
     798,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,   710,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   711,   104,
     105,   414,   712,     0,   107,   108,   109,   110,   713,   714,
     112,   113,   114,   115,     0,   116,   715,   716,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,  3050,   430,
     431,   432,   717,   433,   434,   435,   718,   719,   720,   721,
     722,   723,   724,   436,   437,   725,   438,   439,   133,   440,
     441,   442,   135,   136,   137,   138,   139,   726,   443,   444,
     445,   446,   447,   727,   728,   448,   449,   729,   140,   451,
     730,   452,   453,   454,   455,   144,   731,   456,   732,   457,
     458,   459,   460,   147,   461,   733,   734,   463,   464,   465,
     466,   467,   468,   735,   150,   469,   736,   737,   738,   739,
     151,   740,   741,   742,   470,   471,   472,   473,   474,   475,
     154,   155,   476,   743,   477,   744,   478,   479,   480,   481,
     482,   745,   483,   484,   485,   746,   747,   486,   487,   488,
    3051,   490,   748,   491,   492,   493,   749,   494,   495,   750,
     496,   497,   498,   499,   163,   500,   501,   502,   165,   751,
     503,   752,   504,   167,   505,   753,   506,   754,   507,   168,
     755,   169,   508,   509,   510,   756,   511,   171,   757,   512,
     758,   513,   514,   515,   516,   517,   172,   518,   519,   520,
     759,   521,   522,   523,   524,   525,   526,   760,   527,   173,
     174,   761,   528,   529,   530,   762,   175,   763,   176,   764,
     531,   177,   178,   532,   179,   533,   534,   535,   536,   537,
     538,   539,   765,   180,   181,   540,   182,   766,   541,   542,
     543,   767,   768,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,   187,   188,   189,   556,   557,
     190,   769,   558,   559,   192,   560,   770,   193,   561,   194,
     562,   563,   564,   771,   565,   772,   773,   566,   567,   568,
     774,   775,   195,   196,   197,   198,   199,   569,   570,   571,
     572,   573,   574,   575,   776,   576,   200,   577,   201,   578,
     579,   580,   777,   581,   582,   583,   584,   585,   586,   587,
     203,   588,   589,   590,   591,   778,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,   779,   602,   603,   209,
     604,   605,   211,   606,   607,   608,   609,   610,   611,   612,
     613,   780,   614,   615,   616,   617,   618,   781,  3052,   216,
     620,   621,   218,   622,   219,   782,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   221,   783,   633,   634,
     784,   635,   636,   637,   638,   639,   640,   785,   223,   224,
     786,   787,   642,   225,   643,   226,   788,   644,   645,   646,
     647,   648,   649,   789,   790,   650,   651,   652,   653,   654,
     791,   792,   655,   656,   657,   658,   659,   793,   233,   794,
     661,   234,   662,   663,   664,   795,   796,   665,   797,   798,
     666,   667,   668,   669,   670,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   671,   672,   673,   710,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   711,   104,   105,
     414,   712,     0,   107,   108,   109,   110,   713,   714,   112,
     113,   114,   115,     0,   116,   715,   716,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,   133,   440,   441,
     442,   135,   136,   137,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,   147,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   150,   469,     0,     0,     0,     0,   151,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,   168,     0,
     169,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,   172,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,   173,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
     177,   178,   532,   179,   533,   534,   535,   536,   537,   538,
     539,     0,   180,   181,   540,   182,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,   188,   189,   556,   557,   190,
       0,   558,   559,   192,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,   196,   197,   198,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,   209,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,   218,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
     234,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,   710,    86,    87,    88,
     411,    90,    91,    92,   412,     0,   413,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   711,   104,   105,   414,
     712,     0,   107,   108,   109,   110,   713,   714,   112,   113,
     114,   115,     0,   116,   715,   716,   415,   416,     0,     0,
       0,   417,   418,     0,     0,     0,     0,   419,     0,     0,
       0,     0,     0,     0,     0,     0,   420,     0,   421,     0,
     422,   423,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   425,   426,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,     0,     0,     0,     0,     0,
       0,   436,   437,     0,   438,   439,   133,   440,   441,   442,
     135,   136,   137,   138,   139,     0,   443,   444,   445,   446,
     447,     0,     0,   448,   449,   450,   140,   451,     0,   452,
     453,   454,   455,   144,     0,   456,     0,   457,   458,   459,
     460,   147,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,   150,   469,     0,     0,     0,     0,   151,     0,
       0,     0,   470,   471,   472,   473,   474,   475,   154,   155,
     476,     0,   477,     0,   478,   479,   480,   481,   482,     0,
     483,   484,   485,     0,     0,   486,   487,   488,   489,   490,
       0,   491,   492,   493,     0,   494,   495,     0,   496,   497,
     498,   499,   163,   500,   501,   502,   165,     0,   503,     0,
     504,   167,   505,     0,   506,     0,   507,   168,     0,   169,
     508,   509,   510,     0,   511,   171,     0,   512,     0,   513,
     514,   515,   516,  1299,   172,   518,   519,   520,     0,   521,
     522,   523,   524,   525,   526,     0,   527,   173,   174,     0,
     528,   529,   530,     0,   175,     0,   176,     0,   531,   177,
     178,   532,   179,   533,   534,   535,   536,   537,   538,   539,
       0,   180,   181,   540,   182,     0,   541,   542,   543,     0,
       0,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   187,   188,   189,   556,   557,   190,     0,
     558,   559,   192,   560,     0,   193,   561,   194,   562,   563,
     564,     0,   565,     0,     0,   566,   567,   568,     0,     0,
     195,   196,   197,   198,   199,   569,   570,   571,   572,   573,
     574,   575,     0,   576,   200,   577,   201,   578,   579,   580,
       0,   581,   582,   583,   584,   585,   586,   587,   203,   588,
     589,   590,   591,     0,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,     0,   602,   603,   209,   604,   605,
     211,   606,   607,   608,   609,   610,   611,   612,   613,     0,
     614,   615,   616,   617,   618,     0,   619,   216,   620,   621,
     218,   622,   219,     0,   623,   624,   625,   626,   627,   628,
     629,   630,   631,   632,   221,     0,   633,   634,     0,   635,
     636,   637,   638,   639,   640,     0,   223,   224,     0,     0,
     642,   225,   643,   226,     0,   644,   645,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,     0,     0,
     655,   656,   657,   658,   659,   660,   233,     0,   661,   234,
     662,   663,   664,     0,     0,   665,     0,     0,   666,   667,
     668,   669,   670,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   671,   672,   673,   710,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   711,   104,   105,   414,   712,
       0,   107,   108,   109,   110,   713,   714,   112,   113,   114,
     115,     0,   116,   715,   716,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,   133,   440,   441,   442,   135,
     136,   137,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
     147,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,   150,   469,     0,     0,     0,     0,   151,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,   168,     0,   169,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,  1308,   172,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,   173,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,   177,   178,
     532,   179,   533,   534,   535,   536,   537,   538,   539,     0,
     180,   181,   540,   182,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,   188,   189,   556,   557,   190,     0,   558,
     559,   192,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
     196,   197,   198,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,   209,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,   218,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,   234,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,   710,    86,    87,    88,   411,    90,
      91,    92,   412,     0,   413,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   711,   104,   105,   414,   712,     0,
     107,   108,   109,   110,   713,   714,   112,   113,   114,   115,
       0,   116,   715,   716,   415,   416,     0,     0,     0,   417,
     418,     0,     0,     0,     0,   419,     0,     0,     0,     0,
       0,     0,     0,     0,   420,     0,   421,     0,   422,   423,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,   426,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,     0,     0,     0,     0,     0,     0,     0,   436,
     437,     0,   438,   439,   133,   440,   441,   442,     0,  1835,
     137,  1836,  1837,     0,   443,   444,   445,   446,   447,     0,
       0,   448,   449,  1838,  1839,   451,     0,   452,   453,   454,
     455,     0,     0,   456,     0,   457,   458,   459,   460,   147,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
     150,   469,     0,     0,     0,     0,   151,     0,     0,     0,
     470,   471,   472,   473,   474,   475,  1840,  1841,   476,     0,
     477,     0,   478,   479,   480,   481,   482,     0,   483,   484,
     485,     0,     0,   486,   487,  1448,   489,   490,     0,   491,
     492,   493,     0,   494,   495,     0,   496,   497,   498,   499,
       0,   500,   501,   502,     0,     0,   503,     0,   504,  1842,
     505,     0,   506,     0,   507,   168,     0,   169,   508,   509,
     510,     0,   511,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   172,   518,   519,   520,  2381,   521,   522,   523,
     524,   525,   526,     0,   527,   173,  2382,     0,   528,   529,
     530,  1454,  1843,     0,  1844,     0,   531,   177,   178,   532,
     179,   533,   534,   535,   536,   537,   538,   539,     0,     0,
     181,   540,   182,     0,   541,   542,   543,     0,     0,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,  1845,   188,  1846,   556,   557,     0,     0,   558,   559,
     192,   560,     0,     0,   561,  1847,   562,   563,   564,     0,
     565,     0,     0,   566,   567,   568,     0,     0,  2383,   196,
     197,   198,     0,   569,   570,   571,   572,   573,   574,   575,
       0,   576,     0,   577,     0,   578,   579,   580,     0,   581,
     582,   583,   584,   585,   586,   587,  1848,   588,   589,   590,
     591,     0,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,     0,   602,   603,   209,   604,   605,     0,   606,
     607,   608,   609,   610,   611,   612,   613,     0,   614,   615,
     616,   617,   618,     0,   619,  2384,   620,   621,   218,   622,
    1850,     0,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,     0,   635,   636,   637,
     638,   639,   640,     0,  1851,  1852,     0,     0,   642,     0,
     643,     0,     0,   644,   645,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,     0,     0,   655,   656,
     657,   658,   659,     0,  1853,  2385,   661,   234,   662,   663,
     664,     0,     0,   665,     0,     0,   666,   667,   668,   669,
     670,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     671,   672,   673,   710,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   711,   104,   105,   414,   712,     0,   107,
     108,   109,   110,   713,   714,   112,   113,   114,   115,     0,
     116,   715,   716,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,   133,   440,   441,   442,     0,  1835,   137,
    1836,  1837,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,  1838,  1839,   451,     0,   452,   453,   454,   455,
       0,     0,   456,     0,   457,   458,   459,   460,   147,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,   150,
     469,     0,     0,     0,     0,   151,     0,     0,     0,   470,
     471,   472,   473,   474,   475,  1840,  1841,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,  1448,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,     0,
     500,   501,   502,     0,     0,   503,     0,   504,  1842,   505,
       0,   506,     0,   507,   168,     0,   169,   508,   509,   510,
       0,   511,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   172,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,   173,     0,     0,   528,   529,   530,
    1454,  1843,     0,  1844,     0,   531,   177,   178,   532,   179,
     533,   534,   535,   536,   537,   538,   539,     0,     0,   181,
     540,   182,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
    1845,   188,  1846,   556,   557,     0,     0,   558,   559,   192,
     560,  2373,     0,   561,  1847,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,     0,   196,   197,
     198,     0,   569,   570,   571,   572,   573,   574,   575,     0,
     576,     0,   577,     0,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,  1848,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,   209,   604,   605,     0,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,  2384,   620,   621,   218,   622,  1850,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,  3783,   635,   636,   637,   638,
     639,   640,     0,  1851,  1852,     0,     0,   642,     0,   643,
       0,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,     0,  1853,     0,   661,   234,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   671,
     672,   673,   710,    86,    87,    88,   411,    90,    91,    92,
     412,     0,   413,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   711,   104,   105,   414,   712,     0,   107,   108,
     109,   110,   713,   714,   112,   113,   114,   115,     0,   116,
     715,   716,   415,   416,     0,     0,     0,   417,   418,     0,
       0,     0,     0,   419,     0,     0,     0,     0,     0,     0,
       0,     0,   420,     0,   421,     0,   422,   423,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   425,   426,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,     0,     0,     0,     0,     0,     0,   436,   437,     0,
     438,   439,   133,   440,   441,   442,     0,  1835,   137,  1836,
    1837,     0,   443,   444,   445,   446,   447,     0,     0,   448,
     449,  1838,  1839,   451,     0,   452,   453,   454,   455,     0,
       0,   456,     0,   457,   458,   459,   460,   147,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,   150,   469,
       0,     0,     0,     0,   151,     0,     0,     0,   470,   471,
     472,   473,   474,   475,  1840,  1841,   476,     0,   477,     0,
     478,   479,   480,   481,   482,     0,   483,   484,   485,     0,
       0,   486,   487,  1448,   489,   490,     0,   491,   492,   493,
       0,   494,   495,     0,   496,   497,   498,   499,     0,   500,
     501,   502,     0,     0,   503,     0,   504,  1842,   505,     0,
     506,     0,   507,   168,     0,   169,   508,   509,   510,     0,
     511,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     172,   518,   519,   520,     0,   521,   522,   523,   524,   525,
     526,     0,   527,   173,     0,     0,   528,   529,   530,  1454,
    1843,     0,  1844,     0,   531,   177,   178,   532,   179,   533,
     534,   535,   536,   537,   538,   539,     0,     0,   181,   540,
     182,     0,   541,   542,   543,     0,     0,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,  1845,
     188,  1846,   556,   557,  2430,     0,   558,   559,   192,   560,
       0,     0,   561,  1847,   562,   563,   564,     0,   565,     0,
       0,   566,   567,   568,     0,     0,     0,   196,   197,   198,
       0,   569,   570,   571,   572,   573,   574,   575,     0,   576,
       0,   577,     0,   578,   579,   580,     0,   581,   582,   583,
     584,   585,   586,   587,  1848,   588,   589,   590,   591,     0,
     592,   593,   594,   595,   596,   597,   598,   599,   600,   601,
       0,   602,   603,   209,   604,   605,     0,   606,   607,   608,
     609,   610,   611,   612,   613,     0,   614,   615,   616,   617,
     618,     0,   619,  1849,   620,   621,   218,   622,  1850,     0,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,     0,   635,   636,   637,   638,   639,
     640,     0,  1851,  1852,     0,     0,   642,     0,   643,     0,
       0,   644,   645,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,     0,     0,   655,   656,   657,   658,
     659,     0,  1853,     0,   661,   234,   662,   663,   664,     0,
       0,   665,     0,     0,   666,   667,   668,   669,   670,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   671,   672,
     673,   710,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   711,   104,   105,   414,   712,     0,   107,   108,   109,
     110,   713,   714,   112,   113,   114,   115,     0,   116,   715,
     716,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,   133,   440,   441,   442,     0,  1835,   137,  1836,  1837,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
    1838,  1839,   451,     0,   452,   453,   454,   455,     0,     0,
     456,     0,   457,   458,   459,   460,   147,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,   150,   469,     0,
       0,     0,     0,   151,     0,     0,     0,   470,   471,   472,
     473,   474,   475,  1840,  1841,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,  1448,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,     0,   500,   501,
     502,     0,     0,   503,     0,   504,  1842,   505,     0,   506,
       0,   507,   168,     0,   169,   508,   509,   510,     0,   511,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   172,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,   173,     0,     0,   528,   529,   530,  1454,  1843,
       0,  1844,     0,   531,   177,   178,   532,   179,   533,   534,
     535,   536,   537,   538,   539,     0,     0,   181,   540,   182,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,  1845,   188,
    1846,   556,   557,  3613,     0,   558,   559,   192,   560,     0,
       0,   561,  1847,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,     0,   196,   197,   198,     0,
     569,   570,   571,   572,   573,   574,   575,     0,   576,     0,
     577,     0,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,  1848,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,   209,   604,   605,     0,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,  1849,   620,   621,   218,   622,  1850,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,  1851,  1852,     0,     0,   642,     0,   643,     0,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
       0,  1853,     0,   661,   234,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   671,   672,   673,
     710,    86,    87,    88,   411,    90,    91,    92,   412,     0,
     413,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     711,   104,   105,   414,   712,     0,   107,   108,   109,   110,
     713,   714,   112,   113,   114,   115,     0,   116,   715,   716,
     415,   416,     0,     0,     0,   417,   418,     0,     0,     0,
       0,   419,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   421,     0,   422,   423,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,   426,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,     0,
       0,     0,     0,     0,     0,   436,   437,     0,   438,   439,
     133,   440,   441,   442,     0,  1835,   137,  1836,  1837,     0,
     443,   444,   445,   446,   447,     0,     0,   448,   449,  1838,
    1839,   451,     0,   452,   453,   454,   455,     0,     0,   456,
       0,   457,   458,   459,   460,   147,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,   150,   469,     0,     0,
       0,     0,   151,     0,     0,     0,   470,   471,   472,   473,
     474,   475,  1840,  1841,   476,     0,   477,     0,   478,   479,
     480,   481,   482,     0,   483,   484,   485,     0,     0,   486,
     487,  1448,   489,   490,     0,   491,   492,   493,     0,   494,
     495,     0,   496,   497,   498,   499,     0,   500,   501,   502,
       0,     0,   503,     0,   504,  1842,   505,     0,   506,     0,
     507,   168,     0,   169,   508,   509,   510,     0,   511,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   172,   518,
     519,   520,     0,   521,   522,   523,   524,   525,   526,     0,
     527,   173,     0,     0,   528,   529,   530,  1454,  1843,     0,
    1844,     0,   531,   177,   178,   532,   179,   533,   534,   535,
     536,   537,   538,   539,     0,     0,   181,   540,   182,     0,
     541,   542,   543,     0,     0,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,  1845,   188,  1846,
     556,   557,     0,     0,   558,   559,   192,   560,     0,     0,
     561,  1847,   562,   563,   564,     0,   565,     0,     0,   566,
     567,   568,     0,     0,     0,   196,   197,   198,     0,   569,
     570,   571,   572,   573,   574,   575,     0,   576,     0,   577,
       0,   578,   579,   580,     0,   581,   582,   583,   584,   585,
     586,   587,  1848,   588,   589,   590,   591,     0,   592,   593,
     594,   595,   596,   597,   598,   599,   600,   601,     0,   602,
     603,   209,   604,   605,     0,   606,   607,   608,   609,   610,
     611,   612,   613,     0,   614,   615,   616,   617,   618,     0,
     619,  1849,   620,   621,   218,   622,  1850,     0,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,     0,   635,   636,   637,   638,   639,   640,     0,
    1851,  1852,     0,     0,   642,     0,   643,     0,     0,   644,
     645,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,     0,     0,   655,   656,   657,   658,   659,     0,
    1853,     0,   661,   234,   662,   663,   664,     0,     0,   665,
       0,     0,   666,   667,   668,   669,   670,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   671,   672,   673,   710,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   711,
     104,   105,   414,   712,     0,   107,   108,   109,   110,   713,
     714,   112,   113,   114,   115,     0,   116,   715,   716,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,   133,
     440,   441,   442,     0,  1835,   137,  1836,  1837,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,  1838,  1839,
     451,     0,   452,   453,   454,   455,     0,     0,   456,     0,
     457,   458,   459,   460,   147,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,   150,   469,     0,     0,     0,
       0,   151,     0,     0,     0,   470,   471,   472,   473,   474,
     475,  1840,  1841,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
    1448,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,     0,   500,   501,   502,     0,
       0,   503,     0,   504,  1842,   505,     0,   506,     0,   507,
     168,     0,   169,   508,   509,   510,     0,   511,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   172,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
     173,     0,     0,   528,   529,   530,  1454,  1843,     0,  1844,
       0,   531,   177,   178,   532,   179,   533,   534,   535,   536,
     537,   538,   539,     0,     0,   181,   540,   182,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,  1845,   188,  1846,   556,
     557,     0,     0,   558,   559,   192,   560,     0,     0,   561,
    1847,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,     0,   196,   197,   198,     0,   569,   570,
     571,   572,   573,   574,   575,     0,   576,     0,   577,     0,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,  1848,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
     209,   604,   605,     0,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
    2384,   620,   621,   218,   622,  1850,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,  1851,
    1852,     0,     0,   642,     0,   643,     0,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,     0,  1853,
       0,   661,   234,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   671,   672,   673,   710,    86,
      87,    88,   411,    90,    91,    92,   412,     0,   413,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   711,   104,
     105,   414,   712,     0,   107,   108,   109,   110,   713,   714,
     112,   113,   114,   115,     0,   116,   715,   716,   415,   416,
       0,     0,     0,   417,   418,     0,     0,     0,     0,   419,
       0,     0,     0,     0,     0,     0,     0,     0,   420,     0,
     421,     0,   422,   423,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,   426,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,     0,     0,     0,
       0,     0,     0,   436,   437,     0,   438,   439,   133,   440,
     441,   442,     0,  1835,   137,  1836,  1837,     0,   443,   444,
     445,   446,   447,     0,     0,   448,   449,  1838,  1839,   451,
       0,   452,   453,   454,   455,     0,     0,   456,     0,   457,
     458,   459,   460,   147,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,   150,   469,     0,     0,     0,     0,
     151,     0,     0,     0,   470,   471,   472,   473,   474,   475,
    1840,  1841,   476,     0,   477,     0,   478,   479,   480,   481,
     482,     0,   483,   484,   485,     0,     0,   486,   487,  1448,
     489,   490,     0,   491,   492,   493,     0,   494,   495,     0,
     496,   497,   498,   499,     0,   500,   501,   502,     0,     0,
     503,     0,   504,  1842,   505,     0,   506,     0,   507,   168,
       0,   169,   508,   509,   510,     0,   511,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   172,   518,   519,   520,
       0,   521,   522,   523,   524,   525,   526,     0,   527,   173,
       0,     0,   528,   529,   530,  1454,  1843,     0,  1844,     0,
     531,   177,   178,   532,   179,   533,   534,   535,   536,   537,
     538,   539,     0,     0,   181,   540,   182,     0,   541,   542,
     543,     0,     0,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,  1845,   188,  1846,   556,   557,
       0,     0,   558,   559,   192,   560,     0,     0,   561,  1847,
     562,   563,   564,     0,   565,     0,     0,   566,   567,   568,
       0,     0,     0,   196,   197,   198,     0,   569,   570,   571,
     572,   573,   574,   575,     0,   576,     0,   577,     0,   578,
     579,   580,     0,   581,   582,   583,   584,   585,   586,   587,
    1848,   588,   589,   590,   591,     0,   592,   593,   594,   595,
     596,   597,   598,   599,   600,   601,     0,   602,   603,   209,
     604,   605,     0,   606,   607,   608,   609,   610,   611,   612,
     613,     0,   614,   615,   616,   617,   618,     0,   619,     0,
     620,   621,   218,   622,  1850,     0,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
       0,   635,   636,   637,   638,   639,   640,     0,  1851,  1852,
       0,     0,   642,     0,   643,     0,     0,   644,   645,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
       0,     0,   655,   656,   657,   658,   659,     0,  1853,     0,
     661,   234,   662,   663,   664,     0,     0,   665,     0,     0,
     666,   667,   668,   669,   670,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   671,   672,   673,   710,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   711,   104,   105,
     414,   712,     0,   107,   108,   109,   110,   713,   714,   112,
     113,   114,   115,     0,   116,   715,   716,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,   133,   440,   441,
     442,     0,     0,   137,     0,     0,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,     0,     0,   451,     0,
     452,   453,   454,   455,     0,     0,   456,     0,   457,   458,
     459,   460,   147,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   150,   469,     0,     0,     0,     0,   151,
       0,     0,     0,   470,   471,   472,   473,   474,   475,     0,
       0,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,     0,   500,   501,   502,     0,     0,   503,
       0,   504,     0,   505,     0,   506,     0,   507,   168,     0,
     169,   508,   509,   510,     0,   511,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   172,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,   173,     0,
       0,   528,   529,   530,     0,     0,     0,     0,     0,   531,
     177,   178,   532,   179,   533,   534,   535,   536,   537,   538,
     539,     0,     0,   181,   540,   182,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,     0,   188,     0,   556,   557,     0,
       0,   558,   559,   192,   560,     0,     0,   561,     0,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,     0,   196,   197,   198,     0,   569,   570,   571,   572,
     573,   574,   575,     0,   576,     0,   577,     0,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,     0,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,   209,   604,
     605,     0,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,     0,   620,
     621,   218,   622,     0,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,     0,     0,     0,
       0,   642,     0,   643,     0,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,     0,     0,     0,   661,
     234,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,   717,
     433,   434,   435,   718,   719,   720,   721,   722,   723,   724,
     436,   437,   725,   438,   439,   133,   440,   441,   442,   135,
     136,   137,   138,   139,   726,   443,   444,   445,   446,   447,
     727,   728,   448,   449,     0,   140,   451,   730,   452,   453,
     454,   455,   144,   731,   456,   732,   457,   458,   459,   460,
     147,   461,   733,   734,   463,   464,   465,   466,   467,   468,
     735,   150,   469,     0,   737,   738,   739,   151,   740,   741,
     742,   470,   471,   472,   473,     0,   475,   154,   155,   476,
     743,   477,   744,   478,   479,   480,   481,   482,   745,   483,
     484,   485,   746,   747,   486,   487,   488,   489,   490,   748,
     491,   492,   493,   749,   494,   495,   750,   496,   497,   498,
     499,   163,   500,   501,   502,   165,   751,   503,   752,   504,
     167,   505,   753,   506,   754,   507,   168,   755,   169,   508,
     509,   510,   756,   511,   171,   757,   512,   758,   513,   514,
       0,   516,   517,   172,   518,   519,   520,   759,   521,   522,
     523,   524,   525,   526,   760,   527,   173,   174,     0,   528,
     529,   530,     0,   175,   763,   176,   764,   531,   177,   178,
     532,   179,   533,   534,   535,   536,   537,   538,   539,   765,
     180,   181,   540,   182,   766,   541,   542,   543,   767,   768,
     544,   545,   546,   547,   548,     0,   550,   551,     0,   553,
     554,   555,   187,   188,   189,   556,   557,   190,   769,   558,
     559,   192,   560,   770,   193,   561,   194,   562,   563,   564,
     771,   565,   772,   773,   566,   567,   568,   774,   775,   195,
     196,   197,   198,   199,   569,   570,   571,   572,   573,   574,
     575,   776,   576,   200,   577,   201,   578,   579,   580,   777,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,   778,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,   779,   602,   603,   209,   604,   605,   211,
     606,   607,   608,   609,   610,   611,     0,   613,   780,   614,
     615,   616,   617,   618,   781,   619,   216,   620,   621,   218,
     622,   219,   782,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,   783,   633,   634,   784,   635,   636,
     637,   638,   639,   640,   785,   223,   224,     0,   787,   642,
     225,   643,   226,   788,   644,   645,   646,   647,   648,   649,
       0,   790,   650,   651,   652,   653,   654,   791,   792,   655,
     656,   657,   658,   659,     0,   233,   794,   661,   234,   662,
     663,   664,   795,   796,   665,   797,   798,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,     0,   672,   673,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,  1984,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
    1985,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,  1986,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,   424,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,   641,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,   424,     0,     0,    37,
      38,    39,    40,    41,    42,     0,    44,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,  1124,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,   424,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
    2182,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,  2331,   452,   453,   454,   455,
     144,     0,   456,  2396,   457,   458,   459,   460,     0,   461,
     462,  2332,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,  2397,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,  2334,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,  2335,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,  2336,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,  2331,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,  2332,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,  2397,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
    2334,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,  3235,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,  2335,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,  2336,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
    1023,   431,   432,   982,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,   983,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,  1024,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,   984,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,   985,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,  1964,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,   982,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,   983,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
    2961,   511,   171,     0,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
     984,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,   985,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,  2331,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,  2332,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,  2397,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
    2334,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,  2335,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,  2336,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,   424,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,   693,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,   694,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,   695,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,   982,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,   983,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,   984,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
     985,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,   898,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,   424,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,   899,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   900,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,  2019,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,  2020,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,  2021,   507,     0,     0,     0,  2022,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,  2023,  2024,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,  2025,   610,   611,   612,   613,     0,  2026,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,  2027,   635,  2028,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,   983,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,   984,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,   985,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   130,   131,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,  1353,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    86,    87,
      88,   411,    90,    91,    92,   412,  2008,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,  2289,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,   424,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,  2838,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,  2839,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,  2840,
     635,   636,  2841,   638,  2842,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,  2843,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,   424,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,   702,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
     424,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,   695,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,   424,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,   850,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,   424,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,  1291,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,  2481,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,  2482,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   130,   131,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,  3034,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,  3035,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,  3046,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,  3047,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,   424,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,   424,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   904,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,   424,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   946,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
     424,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   999,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,  1055,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,  1533,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,  1918,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,  2008,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,  2289,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,  3303,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,  3919,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,  3932,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,  4131,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
    4133,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,  4135,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,  4508,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,  1007,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,  1009,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,  1010,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,     0,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,  1011,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,  1012,   224,     0,     0,  1013,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,  1014,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,  1049,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,  1010,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
       0,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,  1050,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,  1051,   224,     0,     0,  1052,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,  1014,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,  1069,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,  1201,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,  1253,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,  1274,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
    1304,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,  1310,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,  1318,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,  1320,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,  1322,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
    1324,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,  1327,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,  1329,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,  1330,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,  1333,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,  1544,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,  1036,   449,  1010,   140,  1545,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,     0,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,  1040,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,  1041,   605,   211,
     606,   607,   608,  1042,   610,   611,   612,   613,     0,   614,
     615,   616,   617,  1537,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,  1044,   224,     0,     0,  1045,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,  1014,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,  1046,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,  1668,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,  1881,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,  1908,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,  1942,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,  1944,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
     517,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
    2054,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,  2256,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,   448,   449,
     450,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,   604,   605,   211,   606,   607,   608,   609,
     610,   611,   612,   613,     0,   614,   615,   616,   617,   618,
       0,     0,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,   223,   224,     0,     0,   642,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
     660,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,   670,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,   448,   449,   450,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,  2610,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,   555,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,   604,   605,   211,   606,   607,   608,   609,   610,   611,
     612,   613,     0,   614,   615,   616,   617,   618,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,   636,   637,   638,   639,   640,     0,   223,
     224,     0,     0,   642,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,   660,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,   670,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,   448,   449,   450,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,  3037,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,   555,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,   604,
     605,   211,   606,   607,   608,   609,   610,   611,   612,   613,
       0,   614,   615,   616,   617,   618,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,   223,   224,     0,
       0,   642,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,   660,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,   670,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,  3039,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,   573,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,   586,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
     606,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,    86,    87,    88,   411,    90,    91,
      92,   412,     0,   413,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   414,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   415,   416,     0,     0,     0,   417,   418,
       0,     0,     0,     0,   419,     0,     0,     0,     0,     0,
       0,     0,     0,   420,     0,   421,     0,   422,   423,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   425,
     426,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,     0,     0,     0,     0,     0,     0,   436,   437,
       0,   438,   439,     0,   440,   441,   442,   135,   136,     0,
     138,   139,     0,   443,   444,   445,   446,   447,     0,     0,
     448,   449,   450,   140,   451,     0,   452,   453,   454,   455,
     144,     0,   456,     0,   457,   458,   459,   460,     0,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,     0,     0,     0,     0,     0,     0,     0,   470,
     471,   472,   473,   474,   475,   154,   155,   476,     0,   477,
       0,   478,   479,   480,   481,   482,     0,   483,   484,   485,
       0,     0,   486,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   494,   495,     0,   496,   497,   498,   499,   163,
     500,   501,   502,   165,     0,   503,     0,   504,   167,   505,
       0,   506,     0,   507,     0,     0,     0,   508,   509,   510,
       0,   511,   171,     0,   512,     0,   513,   514,   515,   516,
    3122,     0,   518,   519,   520,     0,   521,   522,   523,   524,
     525,   526,     0,   527,     0,   174,     0,   528,   529,   530,
       0,   175,     0,   176,     0,   531,     0,     0,   532,     0,
     533,   534,   535,   536,   537,   538,   539,     0,   180,     0,
     540,     0,     0,   541,   542,   543,     0,     0,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     187,     0,   189,   556,   557,   190,     0,   558,   559,     0,
     560,     0,   193,   561,   194,   562,   563,   564,     0,   565,
       0,     0,   566,   567,   568,     0,     0,   195,     0,     0,
       0,   199,   569,   570,   571,   572,   573,   574,   575,     0,
     576,   200,   577,   201,   578,   579,   580,     0,   581,   582,
     583,   584,   585,   586,   587,   203,   588,   589,   590,   591,
       0,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,     0,   602,   603,     0,   604,   605,   211,   606,   607,
     608,   609,   610,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   216,   620,   621,     0,   622,   219,
       0,   623,   624,   625,   626,   627,   628,   629,   630,   631,
     632,   221,     0,   633,   634,     0,   635,   636,   637,   638,
     639,   640,     0,   223,   224,     0,     0,   642,   225,   643,
     226,     0,   644,   645,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,     0,     0,   655,   656,   657,
     658,   659,   660,   233,     0,   661,     0,   662,   663,   664,
       0,     0,   665,     0,     0,   666,   667,   668,   669,   670,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   671,
     672,   673,    86,    87,    88,   411,    90,    91,    92,   412,
       0,   413,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   414,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   415,   416,     0,     0,     0,   417,   418,     0,     0,
       0,     0,   419,     0,     0,     0,     0,     0,     0,     0,
       0,   420,     0,   421,     0,   422,   423,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   425,   426,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
       0,     0,     0,     0,     0,     0,   436,   437,     0,   438,
     439,     0,   440,   441,   442,   135,   136,     0,   138,   139,
       0,   443,   444,   445,   446,   447,     0,     0,  1036,   449,
    1010,   140,   451,     0,   452,   453,   454,   455,   144,     0,
     456,     0,   457,   458,   459,   460,     0,   461,     0,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   469,     0,
       0,     0,     0,     0,     0,     0,     0,   470,   471,   472,
     473,   474,   475,   154,   155,   476,     0,   477,     0,   478,
     479,   480,   481,   482,     0,   483,   484,   485,     0,     0,
     486,   487,   488,   489,   490,     0,   491,   492,   493,     0,
     494,   495,     0,   496,   497,   498,   499,   163,   500,   501,
     502,   165,     0,   503,     0,   504,   167,   505,     0,   506,
       0,   507,     0,     0,     0,   508,   509,   510,     0,   511,
     171,     0,   512,     0,   513,   514,   515,   516,   517,     0,
     518,   519,   520,     0,   521,   522,   523,   524,   525,   526,
       0,   527,     0,   174,     0,   528,   529,   530,     0,   175,
       0,   176,     0,   531,     0,     0,   532,     0,   533,   534,
     535,   536,   537,   538,   539,     0,   180,     0,   540,     0,
       0,   541,   542,   543,     0,     0,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,  1040,   187,     0,
     189,   556,   557,   190,     0,   558,   559,     0,   560,     0,
     193,   561,   194,   562,   563,   564,     0,   565,     0,     0,
     566,   567,   568,     0,     0,   195,     0,     0,     0,   199,
     569,   570,   571,   572,   573,   574,   575,     0,   576,   200,
     577,   201,   578,   579,   580,     0,   581,   582,   583,   584,
     585,   586,   587,   203,   588,   589,   590,   591,     0,   592,
     593,   594,   595,   596,   597,   598,   599,   600,   601,     0,
     602,   603,     0,  1041,   605,   211,   606,   607,   608,  1042,
     610,   611,   612,   613,     0,   614,   615,   616,   617,  1537,
       0,   619,   216,   620,   621,     0,   622,   219,     0,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   221,
       0,   633,   634,     0,   635,   636,   637,   638,   639,   640,
       0,  1044,   224,     0,     0,  1045,   225,   643,   226,     0,
     644,   645,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,     0,     0,   655,   656,   657,   658,   659,
    1014,   233,     0,   661,     0,   662,   663,   664,     0,     0,
     665,     0,     0,   666,   667,   668,   669,  1046,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   671,   672,   673,
      86,    87,    88,   411,    90,    91,    92,   412,     0,   413,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   414,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   415,
     416,     0,     0,     0,   417,   418,     0,     0,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,   420,
       0,   421,     0,   422,   423,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   425,   426,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,     0,     0,
       0,     0,     0,     0,   436,   437,     0,   438,   439,     0,
     440,   441,   442,   135,   136,     0,   138,   139,     0,   443,
     444,   445,   446,   447,     0,     0,  1036,   449,  1010,   140,
     451,     0,   452,   453,   454,   455,   144,     0,   456,     0,
     457,   458,   459,   460,     0,   461,     0,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,     0,     0,
       0,     0,     0,     0,     0,   470,   471,   472,   473,   474,
     475,   154,   155,   476,     0,   477,     0,   478,   479,   480,
     481,   482,     0,   483,   484,   485,     0,     0,   486,   487,
     488,   489,   490,     0,   491,   492,   493,     0,   494,   495,
       0,   496,   497,   498,   499,   163,   500,   501,   502,   165,
       0,   503,     0,   504,   167,   505,     0,   506,     0,   507,
       0,     0,     0,   508,   509,   510,     0,   511,   171,     0,
     512,     0,   513,   514,   515,   516,   517,     0,   518,   519,
     520,     0,   521,   522,   523,   524,   525,   526,     0,   527,
       0,   174,     0,   528,   529,   530,     0,   175,     0,   176,
       0,   531,     0,     0,   532,     0,   533,   534,   535,   536,
     537,   538,   539,     0,   180,     0,   540,     0,     0,   541,
     542,   543,     0,     0,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,  1040,   187,     0,   189,   556,
     557,   190,     0,   558,   559,     0,   560,     0,   193,   561,
     194,   562,   563,   564,     0,   565,     0,     0,   566,   567,
     568,     0,     0,   195,     0,     0,     0,   199,   569,   570,
     571,   572,   573,   574,   575,     0,   576,   200,   577,   201,
     578,   579,   580,     0,   581,   582,   583,   584,   585,   586,
     587,   203,   588,   589,   590,   591,     0,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,     0,   602,   603,
       0,  1041,   605,   211,   606,   607,   608,  1042,   610,   611,
     612,   613,     0,   614,   615,   616,   617,  1537,     0,   619,
     216,   620,   621,     0,   622,   219,     0,   623,   624,   625,
     626,   627,   628,   629,   630,   631,   632,   221,     0,   633,
     634,     0,   635,  2322,   637,   638,   639,   640,     0,  1044,
     224,     0,     0,  1045,   225,   643,   226,     0,   644,   645,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,     0,     0,   655,   656,   657,   658,   659,  1014,   233,
       0,   661,     0,   662,   663,   664,     0,     0,   665,     0,
       0,   666,   667,   668,   669,  1046,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   671,   672,   673,    86,    87,
      88,   411,    90,    91,    92,   412,     0,   413,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     414,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   415,   416,     0,
       0,     0,   417,   418,     0,     0,     0,     0,   419,     0,
       0,     0,     0,     0,     0,     0,     0,   420,     0,   421,
       0,   422,   423,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   425,   426,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,     0,     0,     0,     0,     0,
       0,     0,   436,   437,     0,   438,   439,     0,   440,   441,
     442,   135,   136,     0,   138,   139,     0,   443,   444,   445,
     446,   447,     0,     0,  1036,   449,  1010,   140,   451,     0,
     452,   453,   454,   455,   144,     0,   456,     0,   457,   458,
     459,   460,     0,   461,     0,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   469,     0,     0,     0,     0,     0,
       0,     0,     0,   470,   471,   472,   473,   474,   475,   154,
     155,   476,     0,   477,     0,   478,   479,   480,   481,   482,
       0,   483,   484,   485,     0,     0,   486,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   494,   495,     0,   496,
     497,   498,   499,   163,   500,   501,   502,   165,     0,   503,
       0,   504,   167,   505,     0,   506,     0,   507,     0,     0,
       0,   508,   509,   510,     0,   511,   171,     0,   512,     0,
     513,   514,   515,   516,   517,     0,   518,   519,   520,     0,
     521,   522,   523,   524,   525,   526,     0,   527,     0,   174,
       0,   528,   529,   530,     0,   175,     0,   176,     0,   531,
       0,     0,   532,     0,   533,   534,   535,   536,   537,   538,
     539,     0,   180,     0,   540,     0,     0,   541,   542,   543,
       0,     0,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,  1040,   187,     0,   189,   556,   557,   190,
       0,   558,   559,     0,   560,     0,   193,   561,   194,   562,
     563,   564,     0,   565,     0,     0,   566,   567,   568,     0,
       0,   195,     0,     0,     0,   199,   569,   570,   571,   572,
     573,   574,   575,     0,   576,   200,   577,   201,   578,   579,
     580,     0,   581,   582,   583,   584,   585,   586,   587,   203,
     588,   589,   590,   591,     0,   592,   593,   594,   595,   596,
     597,   598,   599,   600,   601,     0,   602,   603,     0,  1041,
     605,   211,   606,   607,   608,  2377,   610,   611,   612,   613,
       0,   614,   615,   616,   617,  1537,     0,   619,   216,   620,
     621,     0,   622,   219,     0,   623,   624,   625,   626,   627,
     628,   629,   630,   631,   632,   221,     0,   633,   634,     0,
     635,   636,   637,   638,   639,   640,     0,  1044,   224,     0,
       0,  1045,   225,   643,   226,     0,   644,   645,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,     0,
       0,   655,   656,   657,   658,   659,  1014,   233,     0,   661,
       0,   662,   663,   664,     0,     0,   665,     0,     0,   666,
     667,   668,   669,  1046,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   671,   672,   673,    86,    87,    88,   411,
      90,    91,    92,   412,     0,   413,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   414,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   415,   416,     0,     0,     0,
     417,   418,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,   420,     0,   421,     0,   422,
     423,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   425,   426,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,     0,     0,     0,     0,     0,     0,
     436,   437,     0,   438,   439,     0,   440,   441,   442,   135,
     136,     0,   138,   139,     0,   443,   444,   445,   446,   447,
       0,     0,   448,   449,   450,   140,   451,     0,   452,   453,
     454,   455,   144,     0,   456,     0,   457,   458,   459,   460,
       0,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   469,     0,     0,     0,     0,     0,     0,     0,
       0,   470,   471,   472,   473,   474,   475,   154,   155,   476,
       0,   477,     0,   478,   479,   480,   481,   482,     0,   483,
     484,   485,     0,     0,   486,   487,   488,   489,   490,     0,
     491,   492,   493,     0,   494,   495,     0,   496,   497,   498,
     499,   163,   500,   501,   502,   165,     0,   503,     0,   504,
     167,   505,     0,   506,     0,   507,     0,     0,     0,   508,
     509,   510,     0,   511,   171,     0,   512,     0,   513,   514,
     515,   516,   517,     0,   518,   519,   520,     0,   521,   522,
     523,   524,   525,   526,     0,   527,     0,   174,     0,   528,
     529,   530,     0,   175,     0,   176,     0,   531,     0,     0,
     532,     0,   533,   534,   535,   536,   537,   538,   539,     0,
     180,     0,   540,     0,     0,   541,   542,   543,     0,     0,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,   555,   187,     0,   189,   556,   557,   190,     0,   558,
     559,     0,   560,     0,   193,   561,   194,   562,   563,   564,
       0,   565,     0,     0,   566,   567,   568,     0,     0,   195,
       0,     0,     0,   199,   569,   570,   571,   572,     0,   574,
     575,     0,   576,   200,   577,   201,   578,   579,   580,     0,
     581,   582,   583,   584,   585,     0,   587,   203,   588,   589,
     590,   591,     0,   592,   593,   594,   595,   596,   597,   598,
     599,   600,   601,     0,   602,   603,     0,   604,   605,   211,
       0,   607,   608,   609,   610,   611,   612,   613,     0,   614,
     615,   616,   617,   618,     0,   619,   216,   620,   621,     0,
     622,   219,     0,   623,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   221,     0,   633,   634,     0,   635,   636,
     637,   638,   639,   640,     0,   223,   224,     0,     0,   642,
     225,   643,   226,     0,   644,   645,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,     0,     0,   655,
     656,   657,   658,   659,   660,   233,     0,   661,     0,   662,
     663,   664,     0,     0,   665,     0,     0,   666,   667,   668,
     669,   670,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   671,   672,   673,    86,    87,    88,     0,    90,    91,
      92,     0,     0,     0,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,     0,     0,     0,   107,
     108,   109,   110,     0,   111,   112,   113,   114,   115, -2283,
     116,   117,   118,     0,     0,     0,     0,     0,   121,   122,
       0,     0,     0,     0,   123,     0,     0,     0,     0,     0,
       0,     0,     0,   124,     0,   125,     0,   126,   127,    35,
       0,   406,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,     0,     0,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
     144,     0,     0,     0,     0,     0,     0,     0,   147,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   150,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   154,   155,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   161,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,   165,     0,     0,     0,     0,   167,     0,
       0,     0,     0,     0,   168,     0,   169,     0,  