/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONTINUE = 265,
     SQL_COUNT = 266,
     SQL_DATA = 267,
     SQL_DATETIME_INTERVAL_CODE = 268,
     SQL_DATETIME_INTERVAL_PRECISION = 269,
     SQL_DESCRIBE = 270,
     SQL_DESCRIPTOR = 271,
     SQL_DISCONNECT = 272,
     SQL_FOUND = 273,
     SQL_FREE = 274,
     SQL_GO = 275,
     SQL_GOTO = 276,
     SQL_IDENTIFIED = 277,
     SQL_INDICATOR = 278,
     SQL_KEY_MEMBER = 279,
     SQL_LENGTH = 280,
     SQL_LONG = 281,
     SQL_NULLABLE = 282,
     SQL_OCTET_LENGTH = 283,
     SQL_OPEN = 284,
     SQL_OUTPUT = 285,
     SQL_REFERENCE = 286,
     SQL_RETURNED_LENGTH = 287,
     SQL_RETURNED_OCTET_LENGTH = 288,
     SQL_SCALE = 289,
     SQL_SECTION = 290,
     SQL_SHORT = 291,
     SQL_SIGNED = 292,
     SQL_SQL = 293,
     SQL_SQLERROR = 294,
     SQL_SQLPRINT = 295,
     SQL_SQLWARNING = 296,
     SQL_START = 297,
     SQL_STOP = 298,
     SQL_STRUCT = 299,
     SQL_UNSIGNED = 300,
     SQL_VAR = 301,
     SQL_WHENEVER = 302,
     S_ADD = 303,
     S_AND = 304,
     S_ANYTHING = 305,
     S_AUTO = 306,
     S_CONST = 307,
     S_DEC = 308,
     S_DIV = 309,
     S_DOTPOINT = 310,
     S_EQUAL = 311,
     S_EXTERN = 312,
     S_INC = 313,
     S_LSHIFT = 314,
     S_MEMPOINT = 315,
     S_MEMBER = 316,
     S_MOD = 317,
     S_MUL = 318,
     S_NEQUAL = 319,
     S_OR = 320,
     S_REGISTER = 321,
     S_RSHIFT = 322,
     S_STATIC = 323,
     S_SUB = 324,
     S_VOLATILE = 325,
     S_TYPEDEF = 326,
     TYPECAST = 327,
     ABORT_P = 328,
     ABSOLUTE_P = 329,
     ACCESS = 330,
     ACTION = 331,
     ADD_P = 332,
     ADMIN = 333,
     AFTER = 334,
     AGGREGATE = 335,
     ALL = 336,
     ALSO = 337,
     ALTER = 338,
     ALWAYS = 339,
     ANALYSE = 340,
     ANALYZE = 341,
     AND = 342,
     ANY = 343,
     ARRAY = 344,
     AS = 345,
     ASC = 346,
     ASSERTION = 347,
     ASSIGNMENT = 348,
     ASYMMETRIC = 349,
     AT = 350,
     AUTHORIZATION = 351,
     BACKWARD = 352,
     BEFORE = 353,
     BEGIN_P = 354,
     BETWEEN = 355,
     BIGINT = 356,
     BINARY = 357,
     BIT = 358,
     BOOLEAN_P = 359,
     BOTH = 360,
     BY = 361,
     CACHE = 362,
     CALLED = 363,
     CASCADE = 364,
     CASCADED = 365,
     CASE = 366,
     CAST = 367,
     CHAIN = 368,
     CHAR_P = 369,
     CHARACTER = 370,
     CHARACTERISTICS = 371,
     CHECK = 372,
     CHECKPOINT = 373,
     CLASS = 374,
     CLOSE = 375,
     CLUSTER = 376,
     COALESCE = 377,
     COLLATE = 378,
     COLUMN = 379,
     COMMENT = 380,
     COMMIT = 381,
     COMMITTED = 382,
     CONCURRENTLY = 383,
     CONFIGURATION = 384,
     CONNECTION = 385,
     CONSTRAINT = 386,
     CONSTRAINTS = 387,
     CONTENT_P = 388,
     CONVERSION_P = 389,
     COPY = 390,
     COST = 391,
     CREATE = 392,
     CREATEDB = 393,
     CREATEROLE = 394,
     CREATEUSER = 395,
     CROSS = 396,
     CSV = 397,
     CURRENT_P = 398,
     CURRENT_DATE = 399,
     CURRENT_ROLE = 400,
     CURRENT_TIME = 401,
     CURRENT_TIMESTAMP = 402,
     CURRENT_USER = 403,
     CURSOR = 404,
     CYCLE = 405,
     DATABASE = 406,
     DAY_P = 407,
     DEALLOCATE = 408,
     DEC = 409,
     DECIMAL_P = 410,
     DECLARE = 411,
     DEFAULT = 412,
     DEFAULTS = 413,
     DEFERRABLE = 414,
     DEFERRED = 415,
     DEFINER = 416,
     DELETE_P = 417,
     DELIMITER = 418,
     DELIMITERS = 419,
     DESC = 420,
     DICTIONARY = 421,
     DISABLE_P = 422,
     DISCARD = 423,
     DISTINCT = 424,
     DO = 425,
     DOCUMENT_P = 426,
     DOMAIN_P = 427,
     DOUBLE_P = 428,
     DROP = 429,
     EACH = 430,
     ELSE = 431,
     ENABLE_P = 432,
     ENCODING = 433,
     ENCRYPTED = 434,
     END_P = 435,
     ENUM_P = 436,
     ESCAPE = 437,
     EXCEPT = 438,
     EXCLUSIVE = 439,
     EXCLUDING = 440,
     EXECUTE = 441,
     EXISTS = 442,
     EXPLAIN = 443,
     EXTERNAL = 444,
     EXTRACT = 445,
     FALSE_P = 446,
     FAMILY = 447,
     FETCH = 448,
     FIRST_P = 449,
     FLOAT_P = 450,
     FOR = 451,
     FORCE = 452,
     FOREIGN = 453,
     FORWARD = 454,
     FREEZE = 455,
     FROM = 456,
     FULL = 457,
     FUNCTION = 458,
     GET = 459,
     GLOBAL = 460,
     GRANT = 461,
     GRANTED = 462,
     GREATEST = 463,
     GROUP_P = 464,
     HANDLER = 465,
     HAVING = 466,
     HEADER_P = 467,
     HOLD = 468,
     HOUR_P = 469,
     IF_P = 470,
     ILIKE = 471,
     IMMEDIATE = 472,
     IMMUTABLE = 473,
     IMPLICIT_P = 474,
     IN_P = 475,
     INCLUDING = 476,
     INCREMENT = 477,
     INDEX = 478,
     INDEXES = 479,
     INHERIT = 480,
     INHERITS = 481,
     INITIALLY = 482,
     INNER_P = 483,
     INOUT = 484,
     INPUT_P = 485,
     INSENSITIVE = 486,
     INSERT = 487,
     INSTEAD = 488,
     INT_P = 489,
     INTEGER = 490,
     INTERSECT = 491,
     INTERVAL = 492,
     INTO = 493,
     INVOKER = 494,
     IS = 495,
     ISNULL = 496,
     ISOLATION = 497,
     JOIN = 498,
     KEY = 499,
     LANCOMPILER = 500,
     LANGUAGE = 501,
     LARGE_P = 502,
     LAST_P = 503,
     LEADING = 504,
     LEAST = 505,
     LEFT = 506,
     LEVEL = 507,
     LIKE = 508,
     LIMIT = 509,
     LISTEN = 510,
     LOAD = 511,
     LOCAL = 512,
     LOCALTIME = 513,
     LOCALTIMESTAMP = 514,
     LOCATION = 515,
     LOCK_P = 516,
     LOGIN_P = 517,
     MAPPING = 518,
     MATCH = 519,
     MAXVALUE = 520,
     MINUTE_P = 521,
     MINVALUE = 522,
     MODE = 523,
     MONTH_P = 524,
     MOVE = 525,
     NAME_P = 526,
     NAMES = 527,
     NATIONAL = 528,
     NATURAL = 529,
     NCHAR = 530,
     NEW = 531,
     NEXT = 532,
     NO = 533,
     NOCREATEDB = 534,
     NOCREATEROLE = 535,
     NOCREATEUSER = 536,
     NOINHERIT = 537,
     NOLOGIN_P = 538,
     NONE = 539,
     NOSUPERUSER = 540,
     NOT = 541,
     NOTHING = 542,
     NOTIFY = 543,
     NOTNULL = 544,
     NOWAIT = 545,
     NULL_P = 546,
     NULLIF = 547,
     NULLS_P = 548,
     NUMERIC = 549,
     OBJECT_P = 550,
     OF = 551,
     OFF = 552,
     OFFSET = 553,
     OIDS = 554,
     OLD = 555,
     ON = 556,
     ONLY = 557,
     OPERATOR = 558,
     OPTION = 559,
     OR = 560,
     ORDER = 561,
     OUT_P = 562,
     OUTER_P = 563,
     OVERLAPS = 564,
     OVERLAY = 565,
     OWNED = 566,
     OWNER = 567,
     PARSER = 568,
     PARTIAL = 569,
     PASSWORD = 570,
     PLACING = 571,
     PLANS = 572,
     POSITION = 573,
     PRECISION = 574,
     PRESERVE = 575,
     PREPARE = 576,
     PREPARED = 577,
     PRIMARY = 578,
     PRIOR = 579,
     PRIVILEGES = 580,
     PROCEDURAL = 581,
     PROCEDURE = 582,
     QUOTE = 583,
     READ = 584,
     REAL = 585,
     REASSIGN = 586,
     RECHECK = 587,
     REFERENCES = 588,
     REINDEX = 589,
     RELATIVE_P = 590,
     RELEASE = 591,
     RENAME = 592,
     REPEATABLE = 593,
     REPLACE = 594,
     REPLICA = 595,
     RESET = 596,
     RESTART = 597,
     RESTRICT = 598,
     RETURNING = 599,
     RETURNS = 600,
     REVOKE = 601,
     RIGHT = 602,
     ROLE = 603,
     ROLLBACK = 604,
     ROW = 605,
     ROWS = 606,
     RULE = 607,
     SAVEPOINT = 608,
     SCHEMA = 609,
     SCROLL = 610,
     SEARCH = 611,
     SECOND_P = 612,
     SECURITY = 613,
     SELECT = 614,
     SEQUENCE = 615,
     SERIALIZABLE = 616,
     SESSION = 617,
     SESSION_USER = 618,
     SET = 619,
     SETOF = 620,
     SHARE = 621,
     SHOW = 622,
     SIMILAR = 623,
     SIMPLE = 624,
     SMALLINT = 625,
     SOME = 626,
     STABLE = 627,
     STANDALONE_P = 628,
     START = 629,
     STATEMENT = 630,
     STATISTICS = 631,
     STDIN = 632,
     STDOUT = 633,
     STORAGE = 634,
     STRICT_P = 635,
     STRIP_P = 636,
     SUBSTRING = 637,
     SUPERUSER_P = 638,
     SYMMETRIC = 639,
     SYSID = 640,
     SYSTEM_P = 641,
     TABLE = 642,
     TABLESPACE = 643,
     TEMP = 644,
     TEMPLATE = 645,
     TEMPORARY = 646,
     TEXT_P = 647,
     THEN = 648,
     TIME = 649,
     TIMESTAMP = 650,
     TO = 651,
     TRAILING = 652,
     TRANSACTION = 653,
     TREAT = 654,
     TRIGGER = 655,
     TRIM = 656,
     TRUE_P = 657,
     TRUNCATE = 658,
     TRUSTED = 659,
     TYPE_P = 660,
     UNCOMMITTED = 661,
     UNENCRYPTED = 662,
     UNION = 663,
     UNIQUE = 664,
     UNKNOWN = 665,
     UNLISTEN = 666,
     UNTIL = 667,
     UPDATE = 668,
     USER = 669,
     USING = 670,
     VACUUM = 671,
     VALID = 672,
     VALIDATOR = 673,
     VALUE_P = 674,
     VALUES = 675,
     VARCHAR = 676,
     VARYING = 677,
     VERBOSE = 678,
     VERSION_P = 679,
     VIEW = 680,
     VOLATILE = 681,
     WHEN = 682,
     WHERE = 683,
     WHITESPACE_P = 684,
     WITH = 685,
     WITHOUT = 686,
     WORK = 687,
     WRITE = 688,
     XML_P = 689,
     XMLATTRIBUTES = 690,
     XMLCONCAT = 691,
     XMLELEMENT = 692,
     XMLFOREST = 693,
     XMLPARSE = 694,
     XMLPI = 695,
     XMLROOT = 696,
     XMLSERIALIZE = 697,
     YEAR_P = 698,
     YES_P = 699,
     ZONE = 700,
     NULLS_FIRST = 701,
     NULLS_LAST = 702,
     WITH_CASCADED = 703,
     WITH_LOCAL = 704,
     WITH_CHECK = 705,
     IDENT = 706,
     SCONST = 707,
     Op = 708,
     CSTRING = 709,
     CVARIABLE = 710,
     CPP_LINE = 711,
     IP = 712,
     BCONST = 713,
     XCONST = 714,
     DOLCONST = 715,
     ECONST = 716,
     NCONST = 717,
     ICONST = 718,
     PARAM = 719,
     FCONST = 720,
     POSTFIXOP = 721,
     UMINUS = 722
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONTINUE 265
#define SQL_COUNT 266
#define SQL_DATA 267
#define SQL_DATETIME_INTERVAL_CODE 268
#define SQL_DATETIME_INTERVAL_PRECISION 269
#define SQL_DESCRIBE 270
#define SQL_DESCRIPTOR 271
#define SQL_DISCONNECT 272
#define SQL_FOUND 273
#define SQL_FREE 274
#define SQL_GO 275
#define SQL_GOTO 276
#define SQL_IDENTIFIED 277
#define SQL_INDICATOR 278
#define SQL_KEY_MEMBER 279
#define SQL_LENGTH 280
#define SQL_LONG 281
#define SQL_NULLABLE 282
#define SQL_OCTET_LENGTH 283
#define SQL_OPEN 284
#define SQL_OUTPUT 285
#define SQL_REFERENCE 286
#define SQL_RETURNED_LENGTH 287
#define SQL_RETURNED_OCTET_LENGTH 288
#define SQL_SCALE 289
#define SQL_SECTION 290
#define SQL_SHORT 291
#define SQL_SIGNED 292
#define SQL_SQL 293
#define SQL_SQLERROR 294
#define SQL_SQLPRINT 295
#define SQL_SQLWARNING 296
#define SQL_START 297
#define SQL_STOP 298
#define SQL_STRUCT 299
#define SQL_UNSIGNED 300
#define SQL_VAR 301
#define SQL_WHENEVER 302
#define S_ADD 303
#define S_AND 304
#define S_ANYTHING 305
#define S_AUTO 306
#define S_CONST 307
#define S_DEC 308
#define S_DIV 309
#define S_DOTPOINT 310
#define S_EQUAL 311
#define S_EXTERN 312
#define S_INC 313
#define S_LSHIFT 314
#define S_MEMPOINT 315
#define S_MEMBER 316
#define S_MOD 317
#define S_MUL 318
#define S_NEQUAL 319
#define S_OR 320
#define S_REGISTER 321
#define S_RSHIFT 322
#define S_STATIC 323
#define S_SUB 324
#define S_VOLATILE 325
#define S_TYPEDEF 326
#define TYPECAST 327
#define ABORT_P 328
#define ABSOLUTE_P 329
#define ACCESS 330
#define ACTION 331
#define ADD_P 332
#define ADMIN 333
#define AFTER 334
#define AGGREGATE 335
#define ALL 336
#define ALSO 337
#define ALTER 338
#define ALWAYS 339
#define ANALYSE 340
#define ANALYZE 341
#define AND 342
#define ANY 343
#define ARRAY 344
#define AS 345
#define ASC 346
#define ASSERTION 347
#define ASSIGNMENT 348
#define ASYMMETRIC 349
#define AT 350
#define AUTHORIZATION 351
#define BACKWARD 352
#define BEFORE 353
#define BEGIN_P 354
#define BETWEEN 355
#define BIGINT 356
#define BINARY 357
#define BIT 358
#define BOOLEAN_P 359
#define BOTH 360
#define BY 361
#define CACHE 362
#define CALLED 363
#define CASCADE 364
#define CASCADED 365
#define CASE 366
#define CAST 367
#define CHAIN 368
#define CHAR_P 369
#define CHARACTER 370
#define CHARACTERISTICS 371
#define CHECK 372
#define CHECKPOINT 373
#define CLASS 374
#define CLOSE 375
#define CLUSTER 376
#define COALESCE 377
#define COLLATE 378
#define COLUMN 379
#define COMMENT 380
#define COMMIT 381
#define COMMITTED 382
#define CONCURRENTLY 383
#define CONFIGURATION 384
#define CONNECTION 385
#define CONSTRAINT 386
#define CONSTRAINTS 387
#define CONTENT_P 388
#define CONVERSION_P 389
#define COPY 390
#define COST 391
#define CREATE 392
#define CREATEDB 393
#define CREATEROLE 394
#define CREATEUSER 395
#define CROSS 396
#define CSV 397
#define CURRENT_P 398
#define CURRENT_DATE 399
#define CURRENT_ROLE 400
#define CURRENT_TIME 401
#define CURRENT_TIMESTAMP 402
#define CURRENT_USER 403
#define CURSOR 404
#define CYCLE 405
#define DATABASE 406
#define DAY_P 407
#define DEALLOCATE 408
#define DEC 409
#define DECIMAL_P 410
#define DECLARE 411
#define DEFAULT 412
#define DEFAULTS 413
#define DEFERRABLE 414
#define DEFERRED 415
#define DEFINER 416
#define DELETE_P 417
#define DELIMITER 418
#define DELIMITERS 419
#define DESC 420
#define DICTIONARY 421
#define DISABLE_P 422
#define DISCARD 423
#define DISTINCT 424
#define DO 425
#define DOCUMENT_P 426
#define DOMAIN_P 427
#define DOUBLE_P 428
#define DROP 429
#define EACH 430
#define ELSE 431
#define ENABLE_P 432
#define ENCODING 433
#define ENCRYPTED 434
#define END_P 435
#define ENUM_P 436
#define ESCAPE 437
#define EXCEPT 438
#define EXCLUSIVE 439
#define EXCLUDING 440
#define EXECUTE 441
#define EXISTS 442
#define EXPLAIN 443
#define EXTERNAL 444
#define EXTRACT 445
#define FALSE_P 446
#define FAMILY 447
#define FETCH 448
#define FIRST_P 449
#define FLOAT_P 450
#define FOR 451
#define FORCE 452
#define FOREIGN 453
#define FORWARD 454
#define FREEZE 455
#define FROM 456
#define FULL 457
#define FUNCTION 458
#define GET 459
#define GLOBAL 460
#define GRANT 461
#define GRANTED 462
#define GREATEST 463
#define GROUP_P 464
#define HANDLER 465
#define HAVING 466
#define HEADER_P 467
#define HOLD 468
#define HOUR_P 469
#define IF_P 470
#define ILIKE 471
#define IMMEDIATE 472
#define IMMUTABLE 473
#define IMPLICIT_P 474
#define IN_P 475
#define INCLUDING 476
#define INCREMENT 477
#define INDEX 478
#define INDEXES 479
#define INHERIT 480
#define INHERITS 481
#define INITIALLY 482
#define INNER_P 483
#define INOUT 484
#define INPUT_P 485
#define INSENSITIVE 486
#define INSERT 487
#define INSTEAD 488
#define INT_P 489
#define INTEGER 490
#define INTERSECT 491
#define INTERVAL 492
#define INTO 493
#define INVOKER 494
#define IS 495
#define ISNULL 496
#define ISOLATION 497
#define JOIN 498
#define KEY 499
#define LANCOMPILER 500
#define LANGUAGE 501
#define LARGE_P 502
#define LAST_P 503
#define LEADING 504
#define LEAST 505
#define LEFT 506
#define LEVEL 507
#define LIKE 508
#define LIMIT 509
#define LISTEN 510
#define LOAD 511
#define LOCAL 512
#define LOCALTIME 513
#define LOCALTIMESTAMP 514
#define LOCATION 515
#define LOCK_P 516
#define LOGIN_P 517
#define MAPPING 518
#define MATCH 519
#define MAXVALUE 520
#define MINUTE_P 521
#define MINVALUE 522
#define MODE 523
#define MONTH_P 524
#define MOVE 525
#define NAME_P 526
#define NAMES 527
#define NATIONAL 528
#define NATURAL 529
#define NCHAR 530
#define NEW 531
#define NEXT 532
#define NO 533
#define NOCREATEDB 534
#define NOCREATEROLE 535
#define NOCREATEUSER 536
#define NOINHERIT 537
#define NOLOGIN_P 538
#define NONE 539
#define NOSUPERUSER 540
#define NOT 541
#define NOTHING 542
#define NOTIFY 543
#define NOTNULL 544
#define NOWAIT 545
#define NULL_P 546
#define NULLIF 547
#define NULLS_P 548
#define NUMERIC 549
#define OBJECT_P 550
#define OF 551
#define OFF 552
#define OFFSET 553
#define OIDS 554
#define OLD 555
#define ON 556
#define ONLY 557
#define OPERATOR 558
#define OPTION 559
#define OR 560
#define ORDER 561
#define OUT_P 562
#define OUTER_P 563
#define OVERLAPS 564
#define OVERLAY 565
#define OWNED 566
#define OWNER 567
#define PARSER 568
#define PARTIAL 569
#define PASSWORD 570
#define PLACING 571
#define PLANS 572
#define POSITION 573
#define PRECISION 574
#define PRESERVE 575
#define PREPARE 576
#define PREPARED 577
#define PRIMARY 578
#define PRIOR 579
#define PRIVILEGES 580
#define PROCEDURAL 581
#define PROCEDURE 582
#define QUOTE 583
#define READ 584
#define REAL 585
#define REASSIGN 586
#define RECHECK 587
#define REFERENCES 588
#define REINDEX 589
#define RELATIVE_P 590
#define RELEASE 591
#define RENAME 592
#define REPEATABLE 593
#define REPLACE 594
#define REPLICA 595
#define RESET 596
#define RESTART 597
#define RESTRICT 598
#define RETURNING 599
#define RETURNS 600
#define REVOKE 601
#define RIGHT 602
#define ROLE 603
#define ROLLBACK 604
#define ROW 605
#define ROWS 606
#define RULE 607
#define SAVEPOINT 608
#define SCHEMA 609
#define SCROLL 610
#define SEARCH 611
#define SECOND_P 612
#define SECURITY 613
#define SELECT 614
#define SEQUENCE 615
#define SERIALIZABLE 616
#define SESSION 617
#define SESSION_USER 618
#define SET 619
#define SETOF 620
#define SHARE 621
#define SHOW 622
#define SIMILAR 623
#define SIMPLE 624
#define SMALLINT 625
#define SOME 626
#define STABLE 627
#define STANDALONE_P 628
#define START 629
#define STATEMENT 630
#define STATISTICS 631
#define STDIN 632
#define STDOUT 633
#define STORAGE 634
#define STRICT_P 635
#define STRIP_P 636
#define SUBSTRING 637
#define SUPERUSER_P 638
#define SYMMETRIC 639
#define SYSID 640
#define SYSTEM_P 641
#define TABLE 642
#define TABLESPACE 643
#define TEMP 644
#define TEMPLATE 645
#define TEMPORARY 646
#define TEXT_P 647
#define THEN 648
#define TIME 649
#define TIMESTAMP 650
#define TO 651
#define TRAILING 652
#define TRANSACTION 653
#define TREAT 654
#define TRIGGER 655
#define TRIM 656
#define TRUE_P 657
#define TRUNCATE 658
#define TRUSTED 659
#define TYPE_P 660
#define UNCOMMITTED 661
#define UNENCRYPTED 662
#define UNION 663
#define UNIQUE 664
#define UNKNOWN 665
#define UNLISTEN 666
#define UNTIL 667
#define UPDATE 668
#define USER 669
#define USING 670
#define VACUUM 671
#define VALID 672
#define VALIDATOR 673
#define VALUE_P 674
#define VALUES 675
#define VARCHAR 676
#define VARYING 677
#define VERBOSE 678
#define VERSION_P 679
#define VIEW 680
#define VOLATILE 681
#define WHEN 682
#define WHERE 683
#define WHITESPACE_P 684
#define WITH 685
#define WITHOUT 686
#define WORK 687
#define WRITE 688
#define XML_P 689
#define XMLATTRIBUTES 690
#define XMLCONCAT 691
#define XMLELEMENT 692
#define XMLFOREST 693
#define XMLPARSE 694
#define XMLPI 695
#define XMLROOT 696
#define XMLSERIALIZE 697
#define YEAR_P 698
#define YES_P 699
#define ZONE 700
#define NULLS_FIRST 701
#define NULLS_LAST 702
#define WITH_CASCADED 703
#define WITH_LOCAL 704
#define WITH_CHECK 705
#define IDENT 706
#define SCONST 707
#define Op 708
#define CSTRING 709
#define CVARIABLE 710
#define CPP_LINE 711
#define IP 712
#define BCONST 713
#define XCONST 714
#define DOLCONST 715
#define ECONST 716
#define NCONST 717
#define ICONST 718
#define PARAM 719
#define FCONST 720
#define POSTFIXOP 721
#define UMINUS 722




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);
			if (unlink(output_filename) != 0 && *output_filename != '-')
			        fprintf(stderr, "Could not remove output file %s!\n", output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, strdup(pacounter_buffer), make_str(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * {
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming.
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;

	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);

		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1"), ptr->variable->type->u.element->lineno), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}

		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);

			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "Initializer not allowed in typedef command");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "Type %s already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "No multidimensional array support for simple data types");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 374 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1400 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1424 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   72765

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  488
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  566
/* YYNRULES -- Number of rules. */
#define YYNRULES  2242
/* YYNRULES -- Number of states. */
#define YYNSTATES  3865

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   723

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   474,     2,     2,
     479,   480,   472,   470,   486,   471,   481,   473,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   487,   482,
     467,   466,   468,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   477,     2,   478,   475,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   483,     2,   484,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   469,   476,   485
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   220,   222,   224,
     226,   228,   230,   232,   234,   236,   238,   240,   242,   244,
     246,   248,   250,   252,   254,   260,   262,   263,   266,   269,
     273,   277,   279,   281,   283,   285,   287,   289,   291,   293,
     295,   297,   301,   305,   308,   311,   314,   317,   321,   325,
     331,   337,   342,   348,   353,   357,   363,   367,   373,   379,
     386,   388,   390,   394,   400,   407,   412,   414,   415,   418,
     419,   421,   423,   425,   427,   429,   431,   434,   438,   442,
     446,   450,   454,   458,   462,   466,   469,   475,   478,   481,
     485,   489,   493,   495,   499,   501,   505,   508,   511,   514,
     516,   518,   520,   522,   524,   526,   528,   530,   532,   534,
     538,   545,   547,   549,   551,   553,   554,   556,   558,   562,
     567,   573,   578,   581,   584,   588,   593,   597,   600,   603,
     605,   610,   612,   614,   616,   618,   620,   623,   626,   629,
     632,   637,   642,   644,   648,   652,   657,   664,   671,   678,
     685,   690,   697,   700,   705,   709,   713,   717,   721,   726,
     731,   735,   739,   743,   747,   751,   755,   760,   765,   769,
     772,   776,   778,   780,   784,   788,   792,   795,   798,   802,
     805,   807,   809,   810,   813,   814,   817,   820,   830,   837,
     839,   841,   843,   845,   847,   850,   851,   853,   855,   859,
     863,   865,   867,   871,   875,   879,   884,   886,   887,   890,
     891,   895,   896,   898,   899,   911,   924,   926,   928,   931,
     934,   937,   940,   941,   943,   944,   946,   950,   952,   954,
     956,   960,   963,   964,   968,   970,   972,   975,   977,   981,
     986,   991,   994,  1000,  1002,  1005,  1008,  1011,  1015,  1018,
    1019,  1022,  1025,  1028,  1031,  1034,  1037,  1041,  1043,  1048,
    1055,  1063,  1075,  1079,  1080,  1084,  1086,  1088,  1091,  1094,
    1095,  1097,  1099,  1102,  1105,  1106,  1110,  1114,  1117,  1119,
    1121,  1124,  1127,  1132,  1133,  1136,  1139,  1142,  1143,  1147,
    1152,  1157,  1158,  1161,  1162,  1167,  1168,  1169,  1177,  1183,
    1187,  1188,  1192,  1194,  1196,  1202,  1207,  1210,  1211,  1214,
    1216,  1219,  1223,  1226,  1229,  1232,  1235,  1239,  1243,  1247,
    1249,  1250,  1256,  1266,  1268,  1269,  1271,  1274,  1277,  1278,
    1281,  1282,  1288,  1296,  1298,  1299,  1306,  1309,  1310,  1314,
    1320,  1335,  1355,  1357,  1359,  1361,  1365,  1371,  1373,  1375,
    1377,  1381,  1382,  1384,  1385,  1387,  1389,  1391,  1395,  1396,
    1398,  1400,  1401,  1404,  1406,  1409,  1411,  1414,  1415,  1418,
    1420,  1423,  1426,  1433,  1442,  1451,  1455,  1461,  1466,  1471,
    1476,  1480,  1488,  1497,  1504,  1511,  1518,  1525,  1529,  1531,
    1535,  1539,  1541,  1543,  1545,  1547,  1549,  1553,  1557,  1561,
    1563,  1567,  1571,  1573,  1577,  1591,  1593,  1597,  1602,  1610,
    1615,  1623,  1626,  1628,  1629,  1632,  1633,  1635,  1636,  1643,
    1652,  1661,  1663,  1667,  1673,  1679,  1687,  1697,  1705,  1715,
    1721,  1728,  1735,  1740,  1742,  1744,  1746,  1748,  1750,  1752,
    1754,  1756,  1760,  1764,  1768,  1772,  1774,  1778,  1780,  1783,
    1786,  1790,  1795,  1801,  1806,  1811,  1815,  1820,  1824,  1828,
    1831,  1836,  1839,  1841,  1843,  1845,  1847,  1850,  1853,  1855,
    1857,  1859,  1862,  1865,  1867,  1870,  1873,  1875,  1877,  1879,
    1886,  1894,  1902,  1912,  1921,  1930,  1937,  1947,  1957,  1965,
    1976,  1984,  1993,  2002,  2011,  2020,  2022,  2024,  2026,  2028,
    2030,  2032,  2034,  2036,  2038,  2040,  2042,  2044,  2046,  2048,
    2056,  2064,  2075,  2078,  2080,  2082,  2084,  2088,  2090,  2092,
    2094,  2096,  2098,  2101,  2104,  2107,  2110,  2113,  2116,  2119,
    2121,  2125,  2127,  2130,  2134,  2135,  2137,  2141,  2144,  2151,
    2158,  2162,  2163,  2167,  2168,  2182,  2197,  2199,  2200,  2203,
    2204,  2206,  2210,  2215,  2220,  2227,  2229,  2232,  2233,  2235,
    2237,  2238,  2240,  2242,  2243,  2253,  2261,  2264,  2265,  2269,
    2272,  2274,  2278,  2282,  2286,  2289,  2292,  2294,  2296,  2298,
    2300,  2303,  2305,  2309,  2311,  2313,  2315,  2320,  2326,  2328,
    2331,  2336,  2342,  2344,  2346,  2348,  2350,  2354,  2358,  2361,
    2364,  2367,  2370,  2372,  2375,  2378,  2380,  2383,  2384,  2390,
    2392,  2395,  2397,  2398,  2404,  2412,  2418,  2426,  2434,  2444,
    2446,  2450,  2454,  2458,  2460,  2464,  2476,  2487,  2490,  2491,
    2501,  2504,  2505,  2510,  2515,  2520,  2522,  2524,  2526,  2527,
    2535,  2542,  2549,  2556,  2563,  2571,  2581,  2591,  2598,  2605,
    2612,  2619,  2626,  2635,  2644,  2651,  2658,  2667,  2676,  2685,
    2694,  2696,  2697,  2705,  2712,  2719,  2726,  2733,  2740,  2748,
    2755,  2762,  2769,  2776,  2784,  2794,  2804,  2814,  2821,  2828,
    2835,  2844,  2853,  2854,  2869,  2871,  2873,  2877,  2881,  2883,
    2885,  2887,  2889,  2891,  2893,  2895,  2896,  2898,  2900,  2902,
    2904,  2906,  2908,  2909,  2916,  2925,  2928,  2931,  2934,  2937,
    2940,  2944,  2948,  2951,  2954,  2957,  2960,  2964,  2967,  2973,
    2978,  2982,  2986,  2990,  2992,  2994,  2995,  2999,  3002,  3005,
    3007,  3011,  3014,  3016,  3017,  3026,  3037,  3040,  3044,  3048,
    3049,  3052,  3058,  3062,  3064,  3067,  3071,  3075,  3079,  3083,
    3087,  3091,  3095,  3099,  3104,  3108,  3112,  3114,  3115,  3121,
    3126,  3129,  3130,  3135,  3139,  3145,  3152,  3157,  3164,  3171,
    3177,  3185,  3187,  3188,  3195,  3207,  3219,  3231,  3245,  3255,
    3267,  3278,  3282,  3284,  3289,  3292,  3293,  3298,  3304,  3310,
    3313,  3318,  3320,  3322,  3324,  3325,  3327,  3328,  3330,  3331,
    3335,  3336,  3341,  3343,  3345,  3347,  3349,  3351,  3353,  3355,
    3356,  3362,  3367,  3369,  3371,  3373,  3375,  3379,  3380,  3385,
    3394,  3398,  3399,  3402,  3406,  3409,  3413,  3419,  3421,  3426,
    3429,  3433,  3435,  3438,  3441,  3442,  3449,  3452,  3453,  3459,
    3463,  3464,  3467,  3470,  3473,  3477,  3479,  3483,  3485,  3488,
    3490,  3491,  3499,  3501,  3505,  3507,  3509,  3513,  3519,  3522,
    3524,  3528,  3536,  3537,  3540,  3543,  3546,  3550,  3551,  3554,
    3557,  3559,  3561,  3565,  3569,  3571,  3574,  3579,  3584,  3586,
    3588,  3597,  3599,  3604,  3609,  3614,  3617,  3619,  3620,  3624,
    3628,  3633,  3638,  3643,  3648,  3651,  3653,  3655,  3656,  3658,
    3659,  3661,  3667,  3669,  3670,  3672,  3673,  3677,  3679,  3683,
    3688,  3692,  3697,  3702,  3705,  3708,  3713,  3715,  3716,  3718,
    3720,  3722,  3726,  3727,  3730,  3731,  3733,  3737,  3739,  3740,
    3742,  3745,  3750,  3755,  3758,  3759,  3762,  3766,  3769,  3770,
    3774,  3776,  3778,  3781,  3783,  3786,  3792,  3799,  3805,  3807,
    3810,  3812,  3817,  3821,  3826,  3832,  3837,  3843,  3848,  3854,
    3857,  3862,  3864,  3867,  3870,  3873,  3875,  3877,  3878,  3883,
    3886,  3888,  3891,  3894,  3899,  3901,  3904,  3908,  3910,  3913,
    3914,  3917,  3922,  3927,  3928,  3930,  3934,  3937,  3940,  3944,
    3950,  3957,  3961,  3966,  3967,  3969,  3973,  3977,  3981,  3985,
    3989,  3993,  3995,  3997,  3999,  4001,  4003,  4005,  4007,  4010,
    4016,  4018,  4020,  4022,  4024,  4027,  4031,  4035,  4036,  4038,
    4040,  4042,  4044,  4046,  4049,  4052,  4055,  4058,  4061,  4063,
    4067,  4068,  4070,  4072,  4074,  4076,  4082,  4085,  4087,  4089,
    4091,  4093,  4099,  4102,  4105,  4108,  4110,  4114,  4118,  4121,
    4123,  4124,  4128,  4129,  4135,  4138,  4144,  4147,  4149,  4153,
    4157,  4158,  4160,  4162,  4164,  4166,  4168,  4170,  4174,  4178,
    4182,  4186,  4190,  4194,  4198,  4199,  4201,  4205,  4211,  4214,
    4217,  4221,  4225,  4229,  4233,  4237,  4241,  4245,  4249,  4253,
    4257,  4260,  4263,  4267,  4271,  4274,  4278,  4284,  4289,  4296,
    4300,  4306,  4311,  4318,  4323,  4330,  4336,  4344,  4347,  4351,
    4354,  4359,  4363,  4367,  4372,  4376,  4381,  4385,  4390,  4396,
    4403,  4410,  4418,  4425,  4433,  4440,  4448,  4452,  4457,  4462,
    4469,  4472,  4476,  4481,  4483,  4487,  4490,  4494,  4498,  4502,
    4506,  4510,  4514,  4518,  4522,  4526,  4530,  4533,  4536,  4542,
    4549,  4556,  4564,  4568,  4573,  4575,  4577,  4580,  4585,  4587,
    4589,  4591,  4594,  4597,  4600,  4602,  4606,  4611,  4617,  4623,
    4628,  4630,  4632,  4637,  4639,  4644,  4646,  4651,  4653,  4658,
    4660,  4662,  4664,  4666,  4673,  4678,  4683,  4688,  4693,  4700,
    4706,  4712,  4718,  4723,  4730,  4735,  4740,  4745,  4750,  4756,
    4764,  4772,  4782,  4787,  4794,  4800,  4808,  4816,  4819,  4823,
    4827,  4831,  4836,  4837,  4842,  4844,  4848,  4852,  4854,  4856,
    4858,  4861,  4864,  4865,  4870,  4874,  4880,  4882,  4884,  4886,
    4888,  4890,  4892,  4894,  4896,  4898,  4900,  4902,  4904,  4906,
    4908,  4910,  4915,  4917,  4922,  4924,  4929,  4931,  4934,  4936,
    4939,  4941,  4945,  4949,  4950,  4952,  4956,  4958,  4962,  4966,
    4970,  4972,  4974,  4976,  4978,  4980,  4982,  4984,  4986,  4991,
    4995,  4998,  5002,  5003,  5007,  5011,  5014,  5017,  5019,  5020,
    5023,  5026,  5030,  5033,  5035,  5037,  5041,  5047,  5050,  5052,
    5057,  5060,  5061,  5063,  5064,  5066,  5069,  5072,  5075,  5079,
    5085,  5087,  5090,  5091,  5094,  5096,  5097,  5099,  5101,  5103,
    5107,  5111,  5115,  5117,  5121,  5123,  5125,  5127,  5129,  5131,
    5135,  5137,  5140,  5142,  5146,  5148,  5150,  5152,  5154,  5156,
    5158,  5160,  5163,  5165,  5168,  5172,  5179,  5181,  5183,  5185,
    5187,  5189,  5191,  5193,  5195,  5197,  5199,  5201,  5203,  5205,
    5207,  5209,  5212,  5214,  5216,  5218,  5220,  5223,  5226,  5228,
    5230,  5232,  5234,  5236,  5238,  5240,  5242,  5245,  5248,  5250,
    5252,  5254,  5256,  5258,  5260,  5262,  5264,  5267,  5273,  5275,
    5277,  5279,  5281,  5287,  5291,  5294,  5297,  5301,  5309,  5311,
    5313,  5315,  5316,  5319,  5322,  5324,  5325,  5327,  5331,  5333,
    5336,  5337,  5340,  5341,  5344,  5345,  5347,  5351,  5356,  5360,
    5362,  5364,  5366,  5369,  5370,  5378,  5382,  5384,  5386,  5388,
    5390,  5393,  5394,  5396,  5400,  5404,  5408,  5412,  5413,  5418,
    5424,  5430,  5431,  5433,  5435,  5437,  5439,  5442,  5445,  5448,
    5450,  5453,  5454,  5462,  5463,  5469,  5470,  5475,  5478,  5481,
    5482,  5485,  5487,  5489,  5491,  5493,  5495,  5497,  5499,  5501,
    5503,  5505,  5507,  5513,  5516,  5518,  5522,  5525,  5528,  5532,
    5533,  5539,  5541,  5542,  5548,  5551,  5554,  5556,  5558,  5560,
    5563,  5566,  5570,  5572,  5575,  5578,  5582,  5586,  5591,  5594,
    5596,  5599,  5601,  5603,  5606,  5609,  5613,  5615,  5617,  5619,
    5621,  5622,  5624,  5628,  5634,  5635,  5638,  5639,  5641,  5644,
    5648,  5651,  5653,  5655,  5657,  5658,  5660,  5662,  5664,  5667,
    5670,  5672,  5674,  5675,  5677,  5679,  5681,  5683,  5686,  5689,
    5693,  5694,  5696,  5699,  5701,  5706,  5711,  5712,  5714,  5717,
    5719,  5721,  5725,  5727,  5729,  5734,  5739,  5744,  5746,  5747,
    5751,  5755,  5760,  5762,  5766,  5770,  5775,  5777,  5781,  5785,
    5787,  5794,  5796,  5800,  5804,  5811,  5813,  5817,  5821,  5823,
    5825,  5827,  5829,  5831,  5833,  5835,  5837,  5839,  5841,  5843,
    5845,  5847,  5849,  5851,  5856,  5861,  5863,  5865,  5870,  5875,
    5879,  5880,  5888,  5890,  5891,  5892,  5900,  5904,  5909,  5913,
    5915,  5917,  5919,  5922,  5926,  5932,  5935,  5941,  5944,  5946,
    5948,  5950,  5952,  5954,  5956,  5958,  5960,  5962,  5964,  5966,
    5968,  5970,  5972,  5974,  5976,  5978,  5980,  5982,  5984,  5986,
    5988,  5990,  5992,  5994,  5996,  5998,  6000,  6002,  6004,  6006,
    6008,  6010,  6012,  6014,  6016,  6018,  6020,  6022,  6024,  6026,
    6028,  6030,  6032,  6034,  6036,  6038,  6040,  6042,  6044,  6046,
    6048,  6050,  6052,  6054,  6056,  6058,  6060,  6062,  6064,  6066,
    6068,  6070,  6072,  6074,  6076,  6078,  6080,  6082,  6084,  6086,
    6088,  6090,  6092,  6094,  6096,  6098,  6100,  6102,  6104,  6106,
    6108,  6110,  6112,  6114,  6116,  6118,  6120,  6122,  6124,  6126,
    6128,  6130,  6132,  6134,  6136,  6138,  6140,  6142,  6144,  6146,
    6148,  6150,  6152,  6154,  6156,  6158,  6160,  6162,  6164,  6166,
    6168,  6170,  6172,  6174,  6176,  6178,  6180,  6182,  6184,  6186,
    6188,  6190,  6192,  6194,  6196,  6198,  6200,  6202,  6204,  6206,
    6208,  6210,  6212,  6214,  6216,  6218,  6220,  6222,  6224,  6226,
    6228,  6230,  6232,  6234,  6236,  6238,  6240,  6242,  6244,  6246,
    6248,  6250,  6252,  6254,  6256,  6258,  6260,  6262,  6264,  6266,
    6268,  6270,  6272,  6274,  6276,  6278,  6280,  6282,  6284,  6286,
    6288,  6290,  6292,  6294,  6296,  6298,  6300,  6302,  6304,  6306,
    6308,  6310,  6312,  6314,  6316,  6318,  6320,  6322,  6324,  6326,
    6328,  6330,  6332,  6334,  6336,  6338,  6340,  6342,  6344,  6346,
    6348,  6350,  6352,  6354,  6356,  6358,  6360,  6362,  6364,  6366,
    6368,  6370,  6372,  6374,  6376,  6378,  6380,  6382,  6384,  6386,
    6388,  6390,  6392,  6394,  6396,  6398,  6400,  6402,  6404,  6406,
    6408,  6410,  6412,  6414,  6416,  6418,  6420,  6422,  6424,  6426,
    6428,  6430,  6432,  6434,  6436,  6438,  6440,  6442,  6444,  6446,
    6448,  6450,  6452,  6454,  6456,  6458,  6460,  6462,  6464,  6466,
    6468,  6470,  6472,  6474,  6476,  6478,  6480,  6482,  6484,  6486,
    6488,  6490,  6492,  6494,  6496,  6498,  6500,  6502,  6504,  6506,
    6508,  6510,  6512,  6514,  6516,  6518,  6520,  6522,  6524,  6526,
    6528,  6530,  6532,  6534,  6536,  6538,  6540,  6542,  6544,  6546,
    6548,  6550,  6552,  6554,  6556,  6558,  6560,  6562,  6564,  6566,
    6568,  6570,  6572,  6574,  6576,  6578,  6580,  6582,  6584,  6586,
    6588,  6590,  6592,  6594,  6596,  6598,  6600,  6602,  6604,  6606,
    6608,  6610,  6612,  6614,  6616,  6618,  6620,  6622,  6624,  6626,
    6628,  6630,  6632,  6634,  6636,  6638,  6640,  6642,  6644,  6646,
    6648,  6650,  6652,  6654,  6656,  6658,  6660,  6662,  6664,  6666,
    6668,  6670,  6672,  6674,  6676,  6678,  6680,  6682,  6684,  6686,
    6688,  6690,  6692,  6694,  6696,  6698,  6700,  6702,  6704,  6706,
    6708,  6710,  6712,  6714,  6716,  6718,  6720,  6722,  6724,  6726,
    6728,  6730,  6732,  6734,  6736,  6738,  6740,  6742,  6744,  6746,
    6748,  6750,  6752,  6754,  6756,  6758,  6760,  6762,  6764,  6766,
    6768,  6770,  6772,  6774,  6776,  6778,  6780,  6782,  6784,  6786,
    6788,  6790,  6792,  6794,  6796,  6798,  6800,  6802,  6804,  6806,
    6808,  6810,  6812,  6814,  6816,  6818,  6820,  6822,  6824,  6826,
    6828,  6830,  6832,  6834,  6836,  6838,  6840,  6844,  6846,  6847,
    6849,  6852,  6854,  6857,  6859,  6861,  6864,  6867,  6869,  6871,
    6873,  6875,  6877,  6879,  6882,  6886,  6888,  6891,  6893,  6897,
    6899,  6903,  6905,  6907,  6909,  6911,  6913,  6915,  6917,  6919,
    6921,  6923,  6925,  6927,  6929,  6931,  6933,  6935,  6937,  6939,
    6941,  6943,  6945,  6947,  6949,  6951,  6953,  6955,  6957,  6959,
    6961,  6963,  6965,  6967,  6969,  6971,  6973,  6975,  6977,  6979,
    6981,  6983,  6985,  6987,  6989,  6991,  6993,  6995,  6997,  6999,
    7001,  7003,  7005,  7007,  7009,  7011,  7013,  7015,  7017,  7019,
    7021,  7023,  7025
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     489,     0,    -1,   490,    -1,    -1,   490,   491,    -1,  1039,
     492,   493,   482,    -1,  1039,   493,   482,    -1,  1039,   936,
      -1,   941,    -1,  1052,    -1,   456,    -1,   483,    -1,   484,
      -1,    95,   977,    -1,   730,    -1,   731,    -1,   736,    -1,
     687,    -1,   505,    -1,   704,    -1,   705,    -1,   583,    -1,
     530,    -1,   499,    -1,   498,    -1,   739,    -1,   738,    -1,
     500,    -1,   501,    -1,   744,    -1,   528,    -1,   538,    -1,
     741,    -1,   647,    -1,   525,    -1,   539,    -1,   576,    -1,
     611,    -1,   695,    -1,   740,    -1,   735,    -1,   673,    -1,
     504,    -1,   587,    -1,   623,    -1,   629,    -1,   630,    -1,
     494,    -1,   508,    -1,   582,    -1,   548,    -1,   594,    -1,
     597,    -1,   497,    -1,   726,    -1,   758,    -1,   777,    -1,
     613,    -1,   764,    -1,   529,    -1,   612,    -1,   697,    -1,
     507,    -1,   633,    -1,   634,    -1,   635,    -1,   592,    -1,
     502,    -1,   714,    -1,   637,    -1,   596,    -1,   610,    -1,
     503,    -1,   734,    -1,   750,    -1,   756,    -1,   643,    -1,
     650,    -1,   661,    -1,   665,    -1,   759,    -1,   716,    -1,
     725,    -1,   766,    -1,   715,    -1,   753,    -1,   636,    -1,
     699,    -1,   691,    -1,   692,    -1,   690,    -1,   702,    -1,
     651,    -1,   662,    -1,   706,    -1,   780,    -1,   718,    -1,
     642,    -1,   717,    -1,   770,    -1,   743,    -1,   512,    -1,
     522,    -1,   523,    -1,   723,    -1,   993,    -1,   920,    -1,
     934,    -1,   994,    -1,   974,    -1,   991,    -1,   975,    -1,
     935,    -1,   981,    -1,  1002,    -1,   995,    -1,   982,    -1,
    1009,    -1,  1011,    -1,  1005,    -1,   998,    -1,  1012,    -1,
    1015,    -1,  1017,    -1,   137,   348,   918,   495,   496,    -1,
     430,    -1,    -1,   315,   908,    -1,   315,   291,    -1,   179,
     315,   908,    -1,   407,   315,   908,    -1,   383,    -1,   285,
      -1,   225,    -1,   282,    -1,   138,    -1,   279,    -1,   139,
      -1,   280,    -1,   262,    -1,   283,    -1,   130,   254,   910,
      -1,   417,   412,   908,    -1,   414,   895,    -1,   385,   909,
      -1,    78,   895,    -1,   348,   895,    -1,   220,   348,   895,
      -1,   220,   209,   895,    -1,   137,   414,   918,   495,   496,
      -1,    83,   348,   918,   495,   496,    -1,    83,   348,   918,
     524,    -1,    83,   414,   918,   495,   496,    -1,    83,   414,
     918,   524,    -1,   174,   348,   895,    -1,   174,   348,   215,
     187,   895,    -1,   174,   414,   895,    -1,   174,   414,   215,
     187,   895,    -1,   137,   209,   918,   495,   496,    -1,    83,
     209,   918,   506,   414,   895,    -1,    77,    -1,   174,    -1,
     174,   209,   895,    -1,   174,   209,   215,   187,   895,    -1,
     137,   354,   509,    96,   918,   510,    -1,   137,   354,  1025,
     510,    -1,  1025,    -1,    -1,   510,   511,    -1,    -1,   548,
      -1,   665,    -1,   582,    -1,   597,    -1,   650,    -1,   723,
      -1,   364,   513,    -1,   364,   257,   513,    -1,   364,   362,
     513,    -1,   514,   396,   515,    -1,   514,   485,   515,    -1,
     514,   396,   157,    -1,   514,   485,   157,    -1,   514,   201,
     143,    -1,   394,   445,   519,    -1,   398,   721,    -1,   362,
     116,    90,   398,   721,    -1,   272,   520,    -1,   348,   521,
      -1,   362,    96,   521,    -1,   362,    96,   157,    -1,   434,
     304,   854,    -1,  1024,    -1,   514,   481,  1025,    -1,   517,
      -1,   515,   486,   517,    -1,   329,   406,    -1,   329,   127,
      -1,   338,   329,    -1,   361,    -1,   518,    -1,   916,    -1,
    1025,    -1,   402,    -1,   191,    -1,   301,    -1,   297,    -1,
     916,    -1,  1046,    -1,   842,   913,   844,    -1,   842,   479,
     909,   480,   913,   844,    -1,   157,    -1,   257,    -1,   913,
      -1,   157,    -1,    -1,  1025,    -1,   913,    -1,   367,   514,
     988,    -1,   367,   394,   445,   988,    -1,   367,   398,   242,
     252,   988,    -1,   367,   362,    96,   988,    -1,   367,    81,
      -1,   341,   514,    -1,   341,   394,   445,    -1,   341,   398,
     242,   252,    -1,   341,   362,    96,    -1,   341,    81,    -1,
     364,   513,    -1,   523,    -1,   364,   132,   526,   527,    -1,
      81,    -1,   893,    -1,   160,    -1,   217,    -1,   118,    -1,
     168,    81,    -1,   168,   389,    -1,   168,   391,    -1,   168,
     317,    -1,    83,   387,   814,   531,    -1,    83,   223,   814,
     533,    -1,   532,    -1,   531,   486,   532,    -1,    77,   703,
     553,    -1,    83,   703,  1025,   535,    -1,    83,   703,  1025,
     174,   286,   291,    -1,    83,   703,  1025,   364,   286,   291,
      -1,    83,   703,  1025,   364,   376,   909,    -1,    83,   703,
    1025,   364,   379,  1025,    -1,   174,   703,  1025,   536,    -1,
      83,   703,  1025,   405,   821,   537,    -1,    77,   561,    -1,
     174,   131,   896,   536,    -1,   364,   431,   299,    -1,   121,
     301,   896,    -1,   364,   431,   121,    -1,   177,   400,   896,
      -1,   177,    84,   400,   896,    -1,   177,   340,   400,   896,
      -1,   177,   400,    81,    -1,   177,   400,   414,    -1,   167,
     400,   896,    -1,   167,   400,    81,    -1,   167,   400,   414,
      -1,   177,   352,   896,    -1,   177,    84,   352,   896,    -1,
     177,   340,   352,   896,    -1,   167,   352,   896,    -1,   225,
     894,    -1,   278,   225,   894,    -1,   534,    -1,   534,    -1,
     533,   486,   534,    -1,   312,   396,   918,    -1,   364,   388,
     896,    -1,   364,   614,    -1,   341,   614,    -1,   364,   157,
     845,    -1,   174,   157,    -1,   109,    -1,   343,    -1,    -1,
     415,   845,    -1,    -1,   120,   896,    -1,   120,    81,    -1,
     135,   544,   894,   545,   540,   541,   546,   495,   542,    -1,
     135,   781,   396,   541,   495,   542,    -1,   396,    -1,   201,
      -1,   913,    -1,   377,    -1,   378,    -1,   542,   543,    -1,
      -1,   102,    -1,   299,    -1,   163,   737,   913,    -1,   291,
     737,   913,    -1,   142,    -1,   212,    -1,   328,   737,   908,
      -1,   182,   737,   908,    -1,   197,   328,   564,    -1,   197,
     286,   291,   564,    -1,   102,    -1,    -1,   430,   299,    -1,
      -1,   547,   164,   913,    -1,    -1,   415,    -1,    -1,   137,
     549,   387,   894,   479,   550,   480,   571,   572,   573,   574,
      -1,   137,   549,   387,   894,   296,   894,   479,   550,   480,
     572,   573,   574,    -1,   391,    -1,   389,    -1,   257,   391,
      -1,   257,   389,    -1,   205,   391,    -1,   205,   389,    -1,
      -1,   551,    -1,    -1,   552,    -1,   551,   486,   552,    -1,
     553,    -1,   558,    -1,   561,    -1,  1025,   821,   554,    -1,
     554,   555,    -1,    -1,   131,   896,   556,    -1,   556,    -1,
     557,    -1,   286,   291,    -1,   291,    -1,   409,   686,   575,
      -1,   323,   244,   686,   575,    -1,   117,   479,   845,   480,
      -1,   157,   846,    -1,   333,   894,   563,   566,   567,    -1,
     159,    -1,   286,   159,    -1,   227,   160,    -1,   227,   217,
      -1,   253,   894,   559,    -1,   559,   560,    -1,    -1,   221,
     158,    -1,   185,   158,    -1,   221,   132,    -1,   185,   132,
      -1,   221,   224,    -1,   185,   224,    -1,   131,   896,   562,
      -1,   562,    -1,   117,   479,   845,   480,    -1,   409,   479,
     564,   480,   686,   575,    -1,   323,   244,   479,   564,   480,
     686,   575,    -1,   198,   244,   479,   564,   480,   333,   894,
     563,   566,   567,   607,    -1,   479,   564,   480,    -1,    -1,
     564,   486,   565,    -1,   565,    -1,  1025,    -1,   264,   202,
      -1,   264,   314,    -1,    -1,   568,    -1,   569,    -1,   568,
     569,    -1,   569,   568,    -1,    -1,   301,   162,   570,    -1,
     301,   413,   570,    -1,   278,    76,    -1,   343,    -1,   109,
      -1,   364,   157,    -1,   364,   291,    -1,   226,   479,   893,
     480,    -1,    -1,   430,   614,    -1,   430,   299,    -1,   431,
     299,    -1,    -1,   301,   126,   174,    -1,   301,   126,   162,
     351,    -1,   301,   126,   320,   351,    -1,    -1,   388,   896,
      -1,    -1,   415,   223,   388,   896,    -1,    -1,    -1,   137,
     549,   387,   578,    90,   577,   780,    -1,   894,   579,   572,
     573,   574,    -1,   479,   580,   480,    -1,    -1,   580,   486,
     581,    -1,   581,    -1,  1025,    -1,   137,   549,   360,   894,
     584,    -1,    83,   360,   894,   584,    -1,   584,   585,    -1,
      -1,   107,   915,    -1,   150,    -1,   278,   150,    -1,   222,
     586,   915,    -1,   265,   915,    -1,   267,   915,    -1,   278,
     265,    -1,   278,   267,    -1,   311,   106,   640,    -1,   374,
     495,   915,    -1,   342,   495,   915,    -1,   106,    -1,    -1,
     137,   588,   593,   246,   521,    -1,   137,   588,   593,   246,
     521,   210,   589,   590,   591,    -1,   404,    -1,    -1,   896,
      -1,   896,   641,    -1,   418,   589,    -1,    -1,   245,   913,
      -1,    -1,   174,   593,   246,   913,   536,    -1,   174,   593,
     246,   215,   187,   913,   536,    -1,   326,    -1,    -1,   137,
     388,   896,   595,   260,   908,    -1,   312,   896,    -1,    -1,
     174,   388,   896,    -1,   174,   388,   215,   187,   896,    -1,
     137,   400,   896,   598,   599,   301,   894,   601,   186,   327,
     896,   479,   604,   480,    -1,   137,   131,   400,   896,    79,
     599,   301,   894,   606,   607,   196,   175,   350,   186,   327,
     902,   479,   604,   480,    -1,    98,    -1,    79,    -1,   600,
      -1,   600,   305,   600,    -1,   600,   305,   600,   305,   600,
      -1,   232,    -1,   162,    -1,   413,    -1,   196,   602,   603,
      -1,    -1,   175,    -1,    -1,   350,    -1,   375,    -1,   605,
      -1,   604,   486,   605,    -1,    -1,   917,    -1,  1025,    -1,
      -1,   201,   894,    -1,   608,    -1,   608,   609,    -1,   609,
      -1,   609,   608,    -1,    -1,   286,   159,    -1,   159,    -1,
     227,   217,    -1,   227,   160,    -1,   174,   400,   896,   301,
     894,   536,    -1,   174,   400,   215,   187,   896,   301,   894,
     536,    -1,   137,    92,   896,   117,   479,   845,   480,   607,
      -1,   174,    92,   896,    -1,   137,    80,   902,   618,   614,
      -1,   137,    80,   902,   619,    -1,   137,   303,   858,   614,
      -1,   137,   405,   640,   614,    -1,   137,   405,   640,    -1,
     137,   405,   640,    90,   479,   819,   480,    -1,   137,   405,
     640,    90,   181,   479,   622,   480,    -1,   137,   392,   356,
     313,   640,   614,    -1,   137,   392,   356,   166,   640,   614,
      -1,   137,   392,   356,   390,   640,   614,    -1,   137,   392,
     356,   129,   640,   614,    -1,   479,   615,   480,    -1,   616,
      -1,   615,   486,   616,    -1,  1027,   466,   617,    -1,  1027,
      -1,   682,    -1,  1037,    -1,   861,    -1,   916,    -1,   479,
     865,   480,    -1,   479,   472,   480,    -1,   479,   620,   480,
      -1,   621,    -1,   620,   486,   621,    -1,  1046,   466,   617,
      -1,   913,    -1,   622,   486,   913,    -1,   137,   303,   119,
     640,   626,   196,   405,   821,   415,   898,   627,    90,   624,
      -1,   625,    -1,   624,   486,   625,    -1,   303,   909,   694,
     628,    -1,   303,   909,   694,   479,   693,   480,   628,    -1,
     203,   909,   902,   675,    -1,   203,   909,   479,   865,   480,
     902,   675,    -1,   379,   821,    -1,   157,    -1,    -1,   192,
     640,    -1,    -1,   332,    -1,    -1,   137,   303,   192,   640,
     415,   898,    -1,    83,   303,   192,   640,   415,   898,    77,
     624,    -1,    83,   303,   192,   640,   415,   898,   174,   631,
      -1,   632,    -1,   631,   486,   632,    -1,   303,   909,   479,
     865,   480,    -1,   203,   909,   479,   865,   480,    -1,   174,
     303,   119,   640,   415,   898,   536,    -1,   174,   303,   119,
     215,   187,   640,   415,   898,   536,    -1,   174,   303,   192,
     640,   415,   898,   536,    -1,   174,   303,   192,   215,   187,
     640,   415,   898,   536,    -1,   174,   311,   106,   895,   536,
      -1,   331,   311,   106,   895,   396,   896,    -1,   174,   638,
     215,   187,   639,   536,    -1,   174,   638,   639,   536,    -1,
     387,    -1,   360,    -1,   425,    -1,   223,    -1,   405,    -1,
     172,    -1,   134,    -1,   354,    -1,   392,   356,   313,    -1,
     392,   356,   166,    -1,   392,   356,   390,    -1,   392,   356,
     129,    -1,   640,    -1,   639,   486,   640,    -1,  1025,    -1,
    1025,   641,    -1,   481,   899,    -1,   641,   481,   899,    -1,
     403,   787,   893,   536,    -1,   193,   644,   646,   896,   988,
      -1,   193,   644,   896,   988,    -1,   193,   646,   896,   988,
      -1,   193,   896,   988,    -1,   193,   644,   646,   896,    -1,
     193,   644,   896,    -1,   193,   646,   896,    -1,   193,   896,
      -1,   270,   644,   646,   896,    -1,   270,   896,    -1,   277,
      -1,   324,    -1,   194,    -1,   248,    -1,    74,   645,    -1,
     335,   645,    -1,   645,    -1,    81,    -1,   199,    -1,   199,
     645,    -1,   199,    81,    -1,    97,    -1,    97,   645,    -1,
      97,    81,    -1,   910,    -1,   220,    -1,   201,    -1,   125,
     301,   648,   896,   240,   649,    -1,   125,   301,    80,   902,
     618,   240,   649,    -1,   125,   301,   203,   902,   675,   240,
     649,    -1,   125,   301,   303,   858,   479,   693,   480,   240,
     649,    -1,   125,   301,   400,   896,   301,   640,   240,   649,
      -1,   125,   301,   352,   896,   301,   640,   240,   649,    -1,
     125,   301,   352,   896,   240,   649,    -1,   125,   301,   303,
     119,   640,   415,   898,   240,   649,    -1,   125,   301,   303,
     192,   640,   415,   898,   240,   649,    -1,   125,   301,   247,
     295,   915,   240,   649,    -1,   125,   301,   112,   479,   821,
      90,   821,   480,   240,   649,    -1,   125,   301,   593,   246,
     640,   240,   649,    -1,   125,   301,   392,   356,   313,   640,
     240,   649,    -1,   125,   301,   392,   356,   166,   640,   240,
     649,    -1,   125,   301,   392,   356,   390,   640,   240,   649,
      -1,   125,   301,   392,   356,   129,   640,   240,   649,    -1,
     124,    -1,   151,    -1,   354,    -1,   223,    -1,   360,    -1,
     387,    -1,   172,    -1,   405,    -1,   425,    -1,   134,    -1,
     388,    -1,   348,    -1,   913,    -1,   291,    -1,   206,   652,
     301,   655,   396,   656,   658,    -1,   346,   652,   301,   655,
     201,   656,   536,    -1,   346,   206,   304,   196,   652,   301,
     655,   201,   656,   536,    -1,    81,   325,    -1,    81,    -1,
     653,    -1,   654,    -1,   653,   486,   654,    -1,   359,    -1,
     333,    -1,   137,    -1,  1025,    -1,   893,    -1,   387,   893,
      -1,   360,   893,    -1,   203,   659,    -1,   151,   895,    -1,
     246,   895,    -1,   354,   895,    -1,   388,   895,    -1,   657,
      -1,   656,   486,   657,    -1,   918,    -1,   209,   918,    -1,
     430,   206,   304,    -1,    -1,   660,    -1,   659,   486,   660,
      -1,   902,   675,    -1,   206,   653,   396,   895,   663,   664,
      -1,   346,   653,   201,   895,   664,   536,    -1,   430,    78,
     304,    -1,    -1,   207,   106,   918,    -1,    -1,   137,   666,
     223,   900,   301,   894,   667,   479,   668,   480,   686,   574,
     817,    -1,   137,   666,   223,   128,   900,   301,   894,   667,
     479,   668,   480,   686,   574,   817,    -1,   409,    -1,    -1,
     415,   898,    -1,    -1,   669,    -1,   668,   486,   669,    -1,
    1025,   670,   671,   672,    -1,   848,   670,   671,   672,    -1,
     479,   845,   480,   670,   671,   672,    -1,   640,    -1,   415,
     640,    -1,    -1,    91,    -1,   165,    -1,    -1,   446,    -1,
     447,    -1,    -1,   137,   674,   203,   902,   675,   345,   681,
     683,   686,    -1,   137,   674,   203,   902,   675,   683,   686,
      -1,   305,   339,    -1,    -1,   479,   676,   480,    -1,   479,
     480,    -1,   677,    -1,   676,   486,   677,    -1,   678,   680,
     682,    -1,   680,   678,   682,    -1,   680,   682,    -1,   678,
     682,    -1,   682,    -1,   220,    -1,   307,    -1,   229,    -1,
     220,   307,    -1,   913,    -1,   913,   486,   913,    -1,  1026,
      -1,   682,    -1,   821,    -1,  1026,   641,   474,   405,    -1,
     365,  1026,   641,   474,   405,    -1,   685,    -1,   683,   685,
      -1,   108,   301,   291,   230,    -1,   345,   291,   301,   291,
     230,    -1,   380,    -1,   218,    -1,   372,    -1,   426,    -1,
     189,   358,   161,    -1,   189,   358,   239,    -1,   358,   161,
      -1,   358,   239,    -1,   136,   915,    -1,   351,   915,    -1,
     524,    -1,    90,   679,    -1,   246,   521,    -1,   684,    -1,
     430,   614,    -1,    -1,    83,   203,   660,   688,   689,    -1,
     684,    -1,   688,   684,    -1,   343,    -1,    -1,   174,   203,
     902,   675,   536,    -1,   174,   203,   215,   187,   902,   675,
     536,    -1,   174,    80,   902,   618,   536,    -1,   174,    80,
     215,   187,   902,   618,   536,    -1,   174,   303,   858,   479,
     693,   480,   536,    -1,   174,   303,   215,   187,   694,   479,
     693,   480,   536,    -1,   821,    -1,   821,   486,   821,    -1,
     284,   486,   821,    -1,   821,   486,   284,    -1,   858,    -1,
    1025,   481,   694,    -1,   137,   112,   479,   821,    90,   821,
     480,   430,   203,   660,   696,    -1,   137,   112,   479,   821,
      90,   821,   480,   431,   203,   696,    -1,    90,    93,    -1,
      -1,   174,   112,   698,   479,   821,    90,   821,   480,   536,
      -1,   215,   187,    -1,    -1,   334,   700,   894,   701,    -1,
     334,   386,   896,   701,    -1,   334,   151,   896,   701,    -1,
     223,    -1,   387,    -1,   197,    -1,    -1,    83,    80,   902,
     618,   337,   396,   896,    -1,    83,   134,   640,   337,   396,
     896,    -1,    83,   151,   897,   337,   396,   897,    -1,    83,
     203,   660,   337,   396,   896,    -1,    83,   209,   918,   337,
     396,   918,    -1,    83,   593,   246,   896,   337,   396,   896,
      -1,    83,   303,   119,   640,   415,   898,   337,   396,   896,
      -1,    83,   303,   192,   640,   415,   898,   337,   396,   896,
      -1,    83,   354,   896,   337,   396,   896,    -1,    83,   387,
     814,   337,   396,   896,    -1,    83,   360,   814,   337,   396,
     896,    -1,    83,   425,   814,   337,   396,   896,    -1,    83,
     223,   814,   337,   396,   896,    -1,    83,   387,   814,   337,
     703,   896,   396,   896,    -1,    83,   400,   896,   301,   814,
     337,   396,   896,    -1,    83,   414,   918,   337,   396,   918,
      -1,    83,   388,   896,   337,   396,   896,    -1,    83,   392,
     356,   313,   640,   337,   396,   896,    -1,    83,   392,   356,
     166,   640,   337,   396,   896,    -1,    83,   392,   356,   390,
     640,   337,   396,   896,    -1,    83,   392,   356,   129,   640,
     337,   396,   896,    -1,   124,    -1,    -1,    83,    80,   902,
     618,   364,   354,   896,    -1,    83,   172,   640,   364,   354,
     896,    -1,    83,   203,   660,   364,   354,   896,    -1,    83,
     360,   814,   364,   354,   896,    -1,    83,   387,   814,   364,
     354,   896,    -1,    83,   405,   640,   364,   354,   896,    -1,
      83,    80,   902,   618,   312,   396,   918,    -1,    83,   134,
     640,   312,   396,   918,    -1,    83,   151,   897,   312,   396,
     918,    -1,    83,   172,   897,   312,   396,   918,    -1,    83,
     203,   660,   312,   396,   918,    -1,    83,   593,   246,   896,
     312,   396,   918,    -1,    83,   303,   694,   479,   693,   480,
     312,   396,   918,    -1,    83,   303,   119,   640,   415,   898,
     312,   396,   918,    -1,    83,   303,   192,   640,   415,   898,
     312,   396,   918,    -1,    83,   354,   896,   312,   396,   918,
      -1,    83,   405,   640,   312,   396,   918,    -1,    83,   388,
     896,   312,   396,   918,    -1,    83,   392,   356,   166,   640,
     312,   396,   918,    -1,    83,   392,   356,   129,   640,   312,
     396,   918,    -1,    -1,   137,   674,   352,   896,    90,   707,
     301,   712,   396,   894,   817,   170,   713,   708,    -1,   287,
      -1,   710,    -1,   479,   709,   480,    -1,   709,   482,   711,
      -1,   711,    -1,   780,    -1,   759,    -1,   770,    -1,   764,
      -1,   715,    -1,   710,    -1,    -1,   359,    -1,   413,    -1,
     162,    -1,   232,    -1,   233,    -1,    82,    -1,    -1,   174,
     352,   896,   301,   894,   536,    -1,   174,   352,   215,   187,
     896,   301,   894,   536,    -1,   288,  1025,    -1,   255,  1025,
      -1,   411,  1025,    -1,   411,   472,    -1,    73,   719,    -1,
      99,   719,   722,    -1,   374,   398,   722,    -1,   126,   719,
      -1,   180,   719,    -1,   349,   719,    -1,   353,  1025,    -1,
     336,   353,  1025,    -1,   336,  1025,    -1,   349,   719,   396,
     353,  1025,    -1,   349,   719,   396,  1025,    -1,   321,   398,
     913,    -1,   126,   322,   913,    -1,   349,   322,   913,    -1,
     432,    -1,   398,    -1,    -1,   242,   252,   516,    -1,   329,
     302,    -1,   329,   433,    -1,   720,    -1,   721,   486,   720,
      -1,   721,   720,    -1,   721,    -1,    -1,   137,   549,   425,
     894,   563,    90,   780,   724,    -1,   137,   305,   339,   549,
     425,   894,   563,    90,   780,   724,    -1,   450,   304,    -1,
     448,   117,   304,    -1,   449,   117,   304,    -1,    -1,   256,
     901,    -1,   137,   151,   897,   430,   727,    -1,   137,   151,
     897,    -1,   728,    -1,   727,   728,    -1,   388,   729,   896,
      -1,   388,   729,   157,    -1,   260,   729,   913,    -1,   260,
     729,   157,    -1,   390,   729,   896,    -1,   390,   729,   157,
      -1,   178,   729,   914,    -1,   178,   729,   157,    -1,   130,
     254,   729,   909,    -1,   312,   729,   896,    -1,   312,   729,
     157,    -1,   466,    -1,    -1,    83,   151,   897,   495,   732,
      -1,    83,   151,   897,   524,    -1,   732,   733,    -1,    -1,
     130,   254,   729,   909,    -1,   174,   151,   897,    -1,   174,
     151,   215,   187,   897,    -1,   137,   172,   640,   737,   821,
     554,    -1,    83,   172,   640,   535,    -1,    83,   172,   640,
     174,   286,   291,    -1,    83,   172,   640,   364,   286,   291,
      -1,    83,   172,   640,    77,   561,    -1,    83,   172,   640,
     174,   131,   896,   536,    -1,    90,    -1,    -1,    83,   392,
     356,   166,   640,   614,    -1,    83,   392,   356,   129,   640,
      77,   263,   196,   895,   430,   639,    -1,    83,   392,   356,
     129,   640,    83,   263,   196,   895,   430,   639,    -1,    83,
     392,   356,   129,   640,    83,   263,   339,   640,   430,   640,
      -1,    83,   392,   356,   129,   640,    83,   263,   196,   895,
     339,   640,   430,   640,    -1,    83,   392,   356,   129,   640,
     174,   263,   196,   895,    -1,    83,   392,   356,   129,   640,
     174,   263,   215,   187,   196,   895,    -1,   137,   626,   134,
     640,   196,   913,   396,   913,   201,   640,    -1,   121,   894,
     742,    -1,   121,    -1,   121,   894,   301,   894,    -1,   415,
     900,    -1,    -1,   416,   747,   748,   746,    -1,   416,   747,
     748,   746,   894,    -1,   416,   747,   748,   746,   744,    -1,
     745,   746,    -1,   745,   746,   894,   749,    -1,    86,    -1,
      85,    -1,   423,    -1,    -1,   202,    -1,    -1,   200,    -1,
      -1,   479,   895,   480,    -1,    -1,   188,   752,   746,   751,
      -1,   780,    -1,   759,    -1,   770,    -1,   764,    -1,   777,
      -1,   756,    -1,   745,    -1,    -1,   321,   980,   755,    90,
     754,    -1,   321,   980,   201,   979,    -1,   780,    -1,   759,
      -1,   770,    -1,   764,    -1,   479,   865,   480,    -1,    -1,
     186,   980,   757,   978,    -1,   137,   549,   387,   578,    90,
     186,   980,   757,    -1,   479,   863,   480,    -1,    -1,   153,
     980,    -1,   153,   321,   980,    -1,   153,    81,    -1,   153,
     321,    81,    -1,   232,   238,   894,   760,   763,    -1,   780,
      -1,   479,   761,   480,   780,    -1,   157,   420,    -1,   761,
     486,   762,    -1,   762,    -1,  1025,   885,    -1,   344,   890,
      -1,    -1,   162,   201,   815,   765,   818,   763,    -1,   415,
     807,    -1,    -1,   261,   787,   893,   767,   769,    -1,   220,
     768,   268,    -1,    -1,    75,   366,    -1,   350,   366,    -1,
     350,   184,    -1,   366,   413,   184,    -1,   366,    -1,   366,
     350,   184,    -1,   184,    -1,    75,   184,    -1,   290,    -1,
      -1,   413,   815,   364,   771,   806,   818,   763,    -1,   772,
      -1,   771,   486,   772,    -1,   773,    -1,   774,    -1,   775,
     466,   887,    -1,   479,   776,   480,   466,   889,    -1,  1025,
     885,    -1,   775,    -1,   776,   486,   775,    -1,   156,   896,
     778,   149,   779,   196,   780,    -1,    -1,   778,   102,    -1,
     778,   231,    -1,   778,   355,    -1,   778,   278,   355,    -1,
      -1,   430,   213,    -1,   431,   213,    -1,   782,    -1,   781,
      -1,   479,   782,   480,    -1,   479,   781,   480,    -1,   784,
      -1,   783,   791,    -1,   783,   790,   800,   795,    -1,   783,
     790,   794,   801,    -1,   784,    -1,   781,    -1,   359,   789,
     890,   785,   806,   817,   798,   799,    -1,   805,    -1,   783,
     408,   788,   783,    -1,   783,   236,   788,   783,    -1,   783,
     183,   788,   783,    -1,   238,   786,    -1,   988,    -1,    -1,
     391,   787,   894,    -1,   389,   787,   894,    -1,   257,   391,
     787,   894,    -1,   257,   389,   787,   894,    -1,   205,   391,
     787,   894,    -1,   205,   389,   787,   894,    -1,   387,   894,
      -1,   894,    -1,   387,    -1,    -1,    81,    -1,    -1,   169,
      -1,   169,   301,   479,   863,   480,    -1,    81,    -1,    -1,
     791,    -1,    -1,   306,   106,   792,    -1,   793,    -1,   792,
     486,   793,    -1,   845,   415,   861,   672,    -1,   845,   671,
     672,    -1,   254,   796,   298,   797,    -1,   298,   797,   254,
     796,    -1,   254,   796,    -1,   298,   797,    -1,   254,   796,
     486,   797,    -1,   794,    -1,    -1,   845,    -1,    81,    -1,
     845,    -1,   209,   106,   863,    -1,    -1,   211,   845,    -1,
      -1,   802,    -1,   196,   329,   302,    -1,   800,    -1,    -1,
     803,    -1,   802,   803,    -1,   196,   413,   804,   769,    -1,
     196,   366,   804,   769,    -1,   296,   895,    -1,    -1,   420,
     889,    -1,   805,   486,   889,    -1,   201,   807,    -1,    -1,
     807,   486,   808,    -1,   808,    -1,   814,    -1,   814,   810,
      -1,   816,    -1,   816,   810,    -1,   816,    90,   479,   819,
     480,    -1,   816,    90,  1025,   479,   819,   480,    -1,   816,
    1025,   479,   819,   480,    -1,   781,    -1,   781,   810,    -1,
     809,    -1,   479,   809,   480,   810,    -1,   479,   809,   480,
      -1,   808,   141,   243,   808,    -1,   808,   811,   243,   808,
     813,    -1,   808,   243,   808,   813,    -1,   808,   274,   811,
     243,   808,    -1,   808,   274,   243,   808,    -1,    90,  1025,
     479,   895,   480,    -1,    90,  1025,    -1,  1025,   479,   895,
     480,    -1,  1025,    -1,   202,   812,    -1,   251,   812,    -1,
     347,   812,    -1,   228,    -1,   308,    -1,    -1,   415,   479,
     895,   480,    -1,   301,   845,    -1,   894,    -1,   894,   472,
      -1,   302,   894,    -1,   302,   479,   894,   480,    -1,   814,
      -1,   814,  1025,    -1,   814,    90,  1025,    -1,   848,    -1,
     428,   845,    -1,    -1,   428,   845,    -1,   428,   143,   296,
     896,    -1,   428,   143,   296,   464,    -1,    -1,   820,    -1,
     819,   486,   820,    -1,  1025,   821,    -1,   824,   822,    -1,
     365,   824,   822,    -1,   824,    89,   477,   909,   478,    -1,
     365,   824,    89,   477,   909,   478,    -1,   477,   478,   822,
      -1,   477,   823,   478,   822,    -1,    -1,   909,    -1,   479,
     823,   480,    -1,   823,   470,   823,    -1,   823,   471,   823,
      -1,   823,   472,   823,    -1,   823,   473,   823,    -1,   823,
     474,   823,    -1,   908,    -1,  1025,    -1,   826,    -1,   841,
      -1,   828,    -1,   830,    -1,   834,    -1,   842,   844,    -1,
     842,   479,   909,   480,   844,    -1,   828,    -1,   831,    -1,
     835,    -1,   841,    -1,  1026,   827,    -1,  1026,   641,   827,
      -1,   479,   863,   480,    -1,    -1,   234,    -1,   235,    -1,
     370,    -1,   101,    -1,   330,    -1,   195,   829,    -1,   173,
     319,    -1,   155,   827,    -1,   154,   827,    -1,   294,   827,
      -1,   104,    -1,   479,   909,   480,    -1,    -1,   832,    -1,
     833,    -1,   832,    -1,   833,    -1,   103,   839,   479,   863,
     480,    -1,   103,   839,    -1,   836,    -1,   837,    -1,   836,
      -1,   837,    -1,   838,   479,   909,   480,   840,    -1,   838,
     840,    -1,   115,   839,    -1,   114,   839,    -1,   421,    -1,
     273,   115,   839,    -1,   273,   114,   839,    -1,   275,   839,
      -1,   422,    -1,    -1,   115,   364,  1025,    -1,    -1,   395,
     479,   909,   480,   843,    -1,   395,   843,    -1,   394,   479,
     909,   480,   843,    -1,   394,   843,    -1,   237,    -1,   430,
     394,   445,    -1,   431,   394,   445,    -1,    -1,   443,    -1,
     269,    -1,   152,    -1,   214,    -1,   266,    -1,   357,    -1,
     443,   396,   269,    -1,   152,   396,   214,    -1,   152,   396,
     266,    -1,   152,   396,   357,    -1,   214,   396,   266,    -1,
     266,   396,   357,    -1,   214,   396,   357,    -1,    -1,   847,
      -1,   845,    72,   821,    -1,   845,    95,   394,   445,   845,
      -1,   470,   845,    -1,   471,   845,    -1,   845,   470,   845,
      -1,   845,   471,   845,    -1,   845,   472,   845,    -1,   845,
     473,   845,    -1,   845,   474,   845,    -1,   845,   475,   845,
      -1,   845,   467,   845,    -1,   845,   468,   845,    -1,   845,
     466,   845,    -1,   845,   860,   845,    -1,   860,   845,    -1,
     845,   860,    -1,   845,    87,   845,    -1,   845,   305,   845,
      -1,   286,   845,    -1,   845,   253,   845,    -1,   845,   253,
     845,   182,   845,    -1,   845,   286,   253,   845,    -1,   845,
     286,   253,   845,   182,   845,    -1,   845,   216,   845,    -1,
     845,   216,   845,   182,   845,    -1,   845,   286,   216,   845,
      -1,   845,   286,   216,   845,   182,   845,    -1,   845,   368,
     396,   845,    -1,   845,   368,   396,   845,   182,   845,    -1,
     845,   286,   368,   396,   845,    -1,   845,   286,   368,   396,
     845,   182,   845,    -1,   845,   241,    -1,   845,   240,   291,
      -1,   845,   289,    -1,   845,   240,   286,   291,    -1,   856,
     309,   856,    -1,   845,   240,   402,    -1,   845,   240,   286,
     402,    -1,   845,   240,   191,    -1,   845,   240,   286,   191,
      -1,   845,   240,   410,    -1,   845,   240,   286,   410,    -1,
     845,   240,   169,   201,   845,    -1,   845,   240,   286,   169,
     201,   845,    -1,   845,   240,   296,   479,   865,   480,    -1,
     845,   240,   286,   296,   479,   865,   480,    -1,   845,   100,
     886,   846,    87,   846,    -1,   845,   286,   100,   886,   846,
      87,   846,    -1,   845,   100,   384,   846,    87,   846,    -1,
     845,   286,   100,   384,   846,    87,   846,    -1,   845,   220,
     876,    -1,   845,   286,   220,   876,    -1,   845,   862,   857,
     781,    -1,   845,   862,   857,   479,   845,   480,    -1,   409,
     781,    -1,   845,   240,   171,    -1,   845,   240,   286,   171,
      -1,   847,    -1,   846,    72,   821,    -1,   471,   846,    -1,
     846,   470,   846,    -1,   846,   471,   846,    -1,   846,   472,
     846,    -1,   846,   473,   846,    -1,   846,   474,   846,    -1,
     846,   475,   846,    -1,   846,   467,   846,    -1,   846,   468,
     846,    -1,   846,   466,   846,    -1,   846,   453,   846,    -1,
     860,   846,    -1,   846,   860,    -1,   846,   240,   169,   201,
     846,    -1,   846,   240,   286,   169,   201,   846,    -1,   846,
     240,   296,   479,   846,   480,    -1,   846,   240,   286,   296,
     479,   846,   480,    -1,   846,   240,   171,    -1,   846,   240,
     286,   171,    -1,   882,    -1,   903,    -1,   464,   885,    -1,
     479,   845,   480,   885,    -1,   877,    -1,   848,    -1,   781,
      -1,   187,   781,    -1,    89,   781,    -1,    89,   867,    -1,
     856,    -1,   902,   479,   480,    -1,   902,   479,   863,   480,
      -1,   902,   479,    81,   863,   480,    -1,   902,   479,   169,
     863,   480,    -1,   902,   479,   472,   480,    -1,   144,    -1,
     146,    -1,   146,   479,   909,   480,    -1,   147,    -1,   147,
     479,   909,   480,    -1,   258,    -1,   258,   479,   909,   480,
      -1,   259,    -1,   259,   479,   909,   480,    -1,   145,    -1,
     148,    -1,   363,    -1,   414,    -1,   112,   479,   845,    90,
     821,   480,    -1,   190,   479,   864,   480,    -1,   310,   479,
     869,   480,    -1,   318,   479,   871,   480,    -1,   382,   479,
     872,   480,    -1,   399,   479,   845,    90,   821,   480,    -1,
     401,   479,   105,   875,   480,    -1,   401,   479,   249,   875,
     480,    -1,   401,   479,   397,   875,   480,    -1,   401,   479,
     875,   480,    -1,   292,   479,   845,   486,   845,   480,    -1,
     122,   479,   863,   480,    -1,   208,   479,   863,   480,    -1,
     250,   479,   863,   480,    -1,   436,   479,   863,   480,    -1,
     437,   479,   271,  1027,   480,    -1,   437,   479,   271,  1027,
     486,   851,   480,    -1,   437,   479,   271,  1027,   486,   863,
     480,    -1,   437,   479,   271,  1027,   486,   851,   486,   863,
     480,    -1,   438,   479,   852,   480,    -1,   439,   479,   854,
     845,   855,   480,    -1,   440,   479,   271,  1027,   480,    -1,
     440,   479,   271,  1027,   486,   845,   480,    -1,   441,   479,
     845,   486,   849,   850,   480,    -1,   424,   845,    -1,   424,
     278,   419,    -1,   486,   373,   444,    -1,   486,   373,   278,
      -1,   486,   373,   278,   419,    -1,    -1,   435,   479,   852,
     480,    -1,   853,    -1,   852,   486,   853,    -1,   845,    90,
    1027,    -1,   845,    -1,   171,    -1,   133,    -1,   320,   429,
      -1,   381,   429,    -1,    -1,   350,   479,   863,   480,    -1,
     350,   479,   480,    -1,   479,   863,   486,   845,   480,    -1,
      88,    -1,   371,    -1,    81,    -1,   453,    -1,   859,    -1,
     470,    -1,   471,    -1,   472,    -1,   474,    -1,   475,    -1,
     473,    -1,   467,    -1,   468,    -1,   466,    -1,   453,    -1,
     303,   479,   694,   480,    -1,   858,    -1,   303,   479,   694,
     480,    -1,   858,    -1,   303,   479,   694,   480,    -1,   253,
      -1,   286,   253,    -1,   216,    -1,   286,   216,    -1,   845,
      -1,   863,   486,   845,    -1,   868,   201,   845,    -1,    -1,
     821,    -1,   865,   486,   821,    -1,   867,    -1,   866,   486,
     867,    -1,   477,   863,   478,    -1,   477,   866,   478,    -1,
    1046,    -1,   443,    -1,   269,    -1,   152,    -1,   214,    -1,
     266,    -1,   357,    -1,   913,    -1,   845,   870,   873,   874,
      -1,   845,   870,   873,    -1,   316,   845,    -1,   846,   220,
     846,    -1,    -1,   845,   873,   874,    -1,   845,   874,   873,
      -1,   845,   873,    -1,   845,   874,    -1,   863,    -1,    -1,
     201,   845,    -1,   196,   845,    -1,   845,   201,   863,    -1,
     201,   863,    -1,   863,    -1,   781,    -1,   479,   863,   480,
      -1,   111,   881,   878,   880,   180,    -1,   878,   879,    -1,
     879,    -1,   427,   845,   393,   845,    -1,   176,   845,    -1,
      -1,   845,    -1,    -1,   892,    -1,   892,   884,    -1,   481,
     899,    -1,   481,   472,    -1,   477,   845,   478,    -1,   477,
     845,   487,   845,   478,    -1,   883,    -1,   884,   883,    -1,
      -1,   885,   883,    -1,    94,    -1,    -1,   845,    -1,   157,
      -1,   887,    -1,   888,   486,   887,    -1,   479,   888,   480,
      -1,   890,   486,   891,    -1,   891,    -1,   845,    90,  1027,
      -1,   845,    -1,   472,    -1,   919,    -1,  1025,    -1,   894,
      -1,   893,   486,   894,    -1,   892,    -1,   892,   884,    -1,
     896,    -1,   895,   486,   896,    -1,  1025,    -1,  1025,    -1,
    1025,    -1,  1027,    -1,  1025,    -1,   913,    -1,  1026,    -1,
     892,   884,    -1,   917,    -1,   825,   913,    -1,   842,   913,
     844,    -1,   842,   479,   909,   480,   913,   844,    -1,   402,
      -1,   191,    -1,   291,    -1,  1042,    -1,   463,    -1,   465,
      -1,   458,    -1,   459,    -1,   452,    -1,   461,    -1,   462,
      -1,   460,    -1,   904,    -1,  1043,    -1,   909,    -1,   471,
     909,    -1,   904,    -1,  1045,    -1,   905,    -1,   911,    -1,
     471,   905,    -1,   471,   904,    -1,   908,    -1,   908,    -1,
    1043,    -1,   904,    -1,   908,    -1,  1043,    -1,   905,    -1,
     904,    -1,   471,   905,    -1,   471,   904,    -1,  1043,    -1,
     908,    -1,   915,    -1,   908,    -1,   905,    -1,   904,    -1,
     906,    -1,   907,    -1,   902,   908,    -1,   902,   479,   863,
     480,   908,    -1,  1043,    -1,  1025,    -1,   300,    -1,   276,
      -1,     9,   396,   921,   928,   929,    -1,     9,   396,   157,
      -1,     9,   930,    -1,   151,   921,    -1,   922,   925,   927,
      -1,   923,   487,   924,   927,   473,   922,   933,    -1,   932,
      -1,   908,    -1,   897,    -1,    -1,  1046,  1045,    -1,   453,
     926,    -1,   924,    -1,    -1,  1025,    -1,  1025,   481,   926,
      -1,   457,    -1,   487,   909,    -1,    -1,    90,   977,    -1,
      -1,   414,   930,    -1,    -1,   931,    -1,   931,   473,   931,
      -1,   931,    22,   106,   931,    -1,   931,   415,   931,    -1,
     918,    -1,   913,    -1,  1045,    -1,   453,  1025,    -1,    -1,
     156,   896,   778,   149,   779,   196,   980,    -1,   186,   217,
     979,    -1,   937,    -1,   948,    -1,   950,    -1,   915,    -1,
     486,   915,    -1,    -1,   844,    -1,   443,   396,   266,    -1,
     443,   396,   357,    -1,   152,   396,   152,    -1,   269,   396,
     269,    -1,    -1,   943,   942,   945,   944,    -1,  1039,    99,
     156,    35,   482,    -1,  1039,   180,   156,    35,   482,    -1,
      -1,   946,    -1,   456,    -1,   950,    -1,   948,    -1,   946,
     950,    -1,   946,   948,    -1,   946,   456,    -1,   950,    -1,
     947,   950,    -1,    -1,    71,   949,   957,   973,  1028,   822,
     482,    -1,    -1,   954,   957,   951,   970,   482,    -1,    -1,
     957,   952,   970,   482,    -1,   960,   482,    -1,   487,   904,
      -1,    -1,   955,   956,    -1,   955,    -1,   956,    -1,    57,
      -1,    68,    -1,    66,    -1,    51,    -1,    52,    -1,    70,
      -1,   966,    -1,   962,    -1,   958,    -1,  1028,   479,   938,
     939,   480,    -1,  1028,   940,    -1,   964,    -1,   181,  1023,
     959,    -1,   181,   959,    -1,   181,  1023,    -1,   483,  1050,
     484,    -1,    -1,   964,   961,   483,   947,   484,    -1,   960,
      -1,    -1,   965,   963,   483,   947,   484,    -1,    44,  1023,
      -1,   408,  1023,    -1,    44,    -1,   408,    -1,   967,    -1,
     969,   968,    -1,    45,    36,    -1,    45,    36,   234,    -1,
      45,    -1,    45,   234,    -1,    45,    26,    -1,    45,    26,
     234,    -1,    45,    26,    26,    -1,    45,    26,    26,   234,
      -1,    45,   114,    -1,    36,    -1,    36,   234,    -1,   234,
      -1,    26,    -1,    26,   234,    -1,    26,    26,    -1,    26,
      26,   234,    -1,     5,    -1,   114,    -1,   173,    -1,    37,
      -1,    -1,   971,    -1,   970,   486,   971,    -1,   973,  1029,
     822,   953,   972,    -1,    -1,   466,  1051,    -1,    -1,   472,
      -1,   472,   472,    -1,   156,   375,  1046,    -1,    17,   976,
      -1,   977,    -1,   143,    -1,    81,    -1,    -1,   897,    -1,
     157,    -1,   932,    -1,   984,   988,    -1,   988,   984,    -1,
     984,    -1,   988,    -1,    -1,   932,    -1,   454,    -1,   896,
      -1,   932,    -1,    19,   896,    -1,    19,    81,    -1,    29,
     896,   983,    -1,    -1,   984,    -1,   415,   989,    -1,   985,
      -1,   415,   987,    16,  1047,    -1,   238,   987,    16,  1047,
      -1,    -1,    38,    -1,   238,  1038,    -1,   986,    -1,   990,
      -1,   990,   486,   989,    -1,   916,    -1,  1042,    -1,    15,
     230,   896,   985,    -1,    15,   992,   896,   985,    -1,    15,
     992,   896,   986,    -1,    30,    -1,    -1,     3,    16,  1047,
      -1,   153,    16,  1047,    -1,   204,    16,  1047,   996,    -1,
     997,    -1,   996,   486,   997,    -1,  1045,   466,  1001,    -1,
     364,    16,  1047,   999,    -1,  1000,    -1,   999,   486,  1000,
      -1,  1001,   466,   911,    -1,    11,    -1,   204,    16,  1047,
     419,   911,  1003,    -1,  1004,    -1,  1003,   486,  1004,    -1,
    1045,   466,  1008,    -1,   364,    16,  1047,   419,   911,  1006,
      -1,  1007,    -1,  1006,   486,  1007,    -1,  1008,   466,   912,
      -1,     8,    -1,    12,    -1,    13,    -1,    14,    -1,    23,
      -1,    24,    -1,    25,    -1,   271,    -1,    27,    -1,    28,
      -1,   319,    -1,    32,    -1,    33,    -1,    34,    -1,   405,
      -1,   364,     4,   466,  1010,    -1,   364,     4,   396,  1010,
      -1,   301,    -1,   297,    -1,   364,   130,   396,   977,    -1,
     364,   130,   466,   977,    -1,   364,   130,   977,    -1,    -1,
     405,  1013,  1028,   240,   957,   822,  1014,    -1,    31,    -1,
      -1,    -1,    46,  1016,  1027,   240,   957,   822,  1014,    -1,
      47,    39,  1018,    -1,    47,   286,    18,  1018,    -1,    47,
      41,  1018,    -1,    10,    -1,    40,    -1,    43,    -1,    21,
     896,    -1,    20,   396,   896,    -1,   170,   896,   479,  1040,
     480,    -1,   170,     6,    -1,     7,   896,   479,  1040,   480,
      -1,     7,   896,    -1,  1020,    -1,  1021,    -1,     6,    -1,
       7,    -1,     8,    -1,    10,    -1,    11,    -1,    12,    -1,
      13,    -1,    14,    -1,    18,    -1,    20,    -1,    21,    -1,
      22,    -1,    23,    -1,    24,    -1,    25,    -1,    27,    -1,
      28,    -1,    32,    -1,    33,    -1,    34,    -1,    35,    -1,
      38,    -1,    39,    -1,    40,    -1,    41,    -1,    43,    -1,
       9,    -1,    15,    -1,    17,    -1,    29,    -1,    46,    -1,
      47,    -1,     5,    -1,    26,    -1,    30,    -1,    36,    -1,
      44,    -1,    37,    -1,    45,    -1,  1027,    -1,  1046,    -1,
    1032,    -1,  1034,    -1,  1035,    -1,  1019,    -1,  1030,    -1,
     114,    -1,   420,    -1,  1046,    -1,  1031,    -1,  1035,    -1,
    1019,    -1,  1030,    -1,   114,    -1,   420,    -1,  1046,    -1,
    1031,    -1,  1036,    -1,  1019,    -1,  1022,    -1,  1030,    -1,
    1029,    -1,  1022,    -1,   114,    -1,   230,    -1,   234,    -1,
     408,    -1,   396,    -1,  1030,    -1,  1032,    -1,  1046,    -1,
    1035,    -1,  1036,    -1,  1020,    -1,  1028,    -1,  1037,    -1,
    1033,    -1,  1021,    -1,    51,    -1,    52,    -1,    57,    -1,
      66,    -1,    68,    -1,    71,    -1,    70,    -1,  1032,    -1,
    1033,    -1,   152,    -1,   214,    -1,   266,    -1,   269,    -1,
     357,    -1,   443,    -1,  1034,    -1,   130,    -1,    73,    -1,
      74,    -1,    75,    -1,    76,    -1,    77,    -1,    78,    -1,
      79,    -1,    80,    -1,    82,    -1,    83,    -1,    84,    -1,
      92,    -1,    93,    -1,    95,    -1,    97,    -1,    98,    -1,
      99,    -1,   106,    -1,   107,    -1,   109,    -1,   110,    -1,
     113,    -1,   116,    -1,   118,    -1,   119,    -1,   120,    -1,
     121,    -1,   125,    -1,   126,    -1,   127,    -1,   128,    -1,
     129,    -1,   132,    -1,   133,    -1,   134,    -1,   135,    -1,
     136,    -1,   138,    -1,   139,    -1,   140,    -1,   142,    -1,
     149,    -1,   150,    -1,   151,    -1,   153,    -1,   156,    -1,
     158,    -1,   160,    -1,   162,    -1,   163,    -1,   164,    -1,
     166,    -1,   167,    -1,   168,    -1,   171,    -1,   172,    -1,
     173,    -1,   174,    -1,   175,    -1,   177,    -1,   178,    -1,
     179,    -1,   182,    -1,   185,    -1,   184,    -1,   186,    -1,
     188,    -1,   189,    -1,   192,    -1,   193,    -1,   194,    -1,
     197,    -1,   199,    -1,   203,    -1,   205,    -1,   207,    -1,
     210,    -1,   212,    -1,   213,    -1,   215,    -1,   217,    -1,
     218,    -1,   219,    -1,   221,    -1,   222,    -1,   223,    -1,
     224,    -1,   225,    -1,   226,    -1,   231,    -1,   232,    -1,
     233,    -1,   242,    -1,   244,    -1,   245,    -1,   246,    -1,
     247,    -1,   248,    -1,   252,    -1,   255,    -1,   256,    -1,
     257,    -1,   260,    -1,   261,    -1,   262,    -1,   263,    -1,
     264,    -1,   265,    -1,   267,    -1,   268,    -1,   270,    -1,
     271,    -1,   272,    -1,   277,    -1,   278,    -1,   279,    -1,
     280,    -1,   281,    -1,   282,    -1,   283,    -1,   285,    -1,
     287,    -1,   288,    -1,   290,    -1,   293,    -1,   295,    -1,
     296,    -1,   299,    -1,   303,    -1,   304,    -1,   311,    -1,
     312,    -1,   313,    -1,   314,    -1,   315,    -1,   317,    -1,
     321,    -1,   322,    -1,   320,    -1,   324,    -1,   325,    -1,
     326,    -1,   327,    -1,   328,    -1,   329,    -1,   331,    -1,
     332,    -1,   334,    -1,   335,    -1,   336,    -1,   337,    -1,
     338,    -1,   339,    -1,   340,    -1,   341,    -1,   342,    -1,
     343,    -1,   345,    -1,   346,    -1,   348,    -1,   349,    -1,
     351,    -1,   352,    -1,   353,    -1,   354,    -1,   355,    -1,
     356,    -1,   360,    -1,   361,    -1,   362,    -1,   364,    -1,
     366,    -1,   367,    -1,   369,    -1,   372,    -1,   373,    -1,
     374,    -1,   375,    -1,   376,    -1,   377,    -1,   378,    -1,
     379,    -1,   380,    -1,   381,    -1,   383,    -1,   386,    -1,
     385,    -1,   388,    -1,   389,    -1,   390,    -1,   391,    -1,
     392,    -1,   398,    -1,   400,    -1,   403,    -1,   404,    -1,
     405,    -1,   406,    -1,   407,    -1,   410,    -1,   411,    -1,
     412,    -1,   413,    -1,   416,    -1,   417,    -1,   418,    -1,
     419,    -1,   422,    -1,   424,    -1,   425,    -1,   426,    -1,
     429,    -1,   430,    -1,   431,    -1,   432,    -1,   433,    -1,
     434,    -1,   444,    -1,   445,    -1,   101,    -1,   103,    -1,
     115,    -1,   122,    -1,   154,    -1,   155,    -1,   187,    -1,
     190,    -1,   195,    -1,   208,    -1,   229,    -1,   235,    -1,
     237,    -1,   250,    -1,   273,    -1,   275,    -1,   284,    -1,
     292,    -1,   294,    -1,   307,    -1,   310,    -1,   318,    -1,
     319,    -1,   330,    -1,   350,    -1,   365,    -1,   370,    -1,
     382,    -1,   394,    -1,   395,    -1,   399,    -1,   401,    -1,
     421,    -1,   435,    -1,   436,    -1,   437,    -1,   438,    -1,
     439,    -1,   440,    -1,   441,    -1,   442,    -1,    96,    -1,
     100,    -1,   102,    -1,   141,    -1,   200,    -1,   202,    -1,
     216,    -1,   228,    -1,   240,    -1,   241,    -1,   243,    -1,
     251,    -1,   253,    -1,   274,    -1,   289,    -1,   308,    -1,
     309,    -1,   347,    -1,   368,    -1,   423,    -1,    81,    -1,
      85,    -1,    86,    -1,    87,    -1,    88,    -1,    89,    -1,
      90,    -1,    91,    -1,    94,    -1,   105,    -1,   111,    -1,
     112,    -1,   117,    -1,   123,    -1,   124,    -1,   131,    -1,
     137,    -1,   143,    -1,   144,    -1,   146,    -1,   147,    -1,
     145,    -1,   148,    -1,   157,    -1,   159,    -1,   165,    -1,
     169,    -1,   170,    -1,   176,    -1,   180,    -1,   183,    -1,
     191,    -1,   196,    -1,   198,    -1,   201,    -1,   206,    -1,
     209,    -1,   211,    -1,   220,    -1,   227,    -1,   236,    -1,
     238,    -1,   249,    -1,   254,    -1,   276,    -1,   286,    -1,
     291,    -1,   297,    -1,   298,    -1,   300,    -1,   301,    -1,
     302,    -1,   305,    -1,   306,    -1,   323,    -1,   333,    -1,
     344,    -1,   359,    -1,   363,    -1,   371,    -1,   384,    -1,
     387,    -1,   393,    -1,   397,    -1,   402,    -1,   409,    -1,
     414,    -1,   415,    -1,   427,    -1,   428,    -1,  1041,    -1,
    1038,   486,  1041,    -1,    42,    -1,    -1,  1050,    -1,  1045,
    1044,    -1,  1045,    -1,  1045,  1044,    -1,  1045,    -1,  1045,
      -1,    23,  1045,    -1,    23,   896,    -1,   455,    -1,   451,
      -1,   454,    -1,   896,    -1,   932,    -1,  1053,    -1,   479,
     480,    -1,   479,  1049,   480,    -1,  1048,    -1,  1049,  1048,
      -1,  1051,    -1,  1050,   486,  1051,    -1,  1049,    -1,   483,
    1050,   484,    -1,  1053,    -1,   479,    -1,   480,    -1,   486,
      -1,   482,    -1,   451,    -1,   454,    -1,   904,    -1,   905,
      -1,   908,    -1,   472,    -1,   470,    -1,   471,    -1,   473,
      -1,   474,    -1,   291,    -1,    48,    -1,    49,    -1,    50,
      -1,    51,    -1,    52,    -1,    53,    -1,    54,    -1,    55,
      -1,    56,    -1,    57,    -1,    58,    -1,    59,    -1,    61,
      -1,    60,    -1,    62,    -1,    63,    -1,    64,    -1,    65,
      -1,    66,    -1,    67,    -1,    68,    -1,    69,    -1,    71,
      -1,    70,    -1,     5,    -1,   181,    -1,   214,    -1,   234,
      -1,    26,    -1,   266,    -1,   269,    -1,   357,    -1,    36,
      -1,    37,    -1,    44,    -1,    45,    -1,   443,    -1,   114,
      -1,   195,    -1,   396,    -1,   408,    -1,   421,    -1,   477,
      -1,   478,    -1,   466,    -1,   487,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   688,   688,   690,   691,   694,   695,   696,   702,   703,
     704,   705,   706,   709,   722,   723,   724,   725,   726,   727,
     728,   729,   730,   731,   732,   733,   734,   735,   736,   737,
     738,   739,   763,   764,   765,   766,   767,   768,   769,   770,
     771,   772,   773,   774,   775,   776,   777,   778,   779,   780,
     781,   782,   783,   784,   785,   786,   793,   794,   795,   796,
     797,   798,   799,   800,   801,   802,   803,   804,   805,   806,
     807,   808,   809,   810,   811,   812,   813,   814,   815,   816,
     817,   818,   819,   820,   821,   822,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   847,   848,   849,
     850,   851,   852,   853,   854,   855,   861,   871,   875,   883,
     887,   898,   908,   909,   920,   927,   933,   944,   950,   959,
     966,   972,   981,   988,  1009,  1013,  1014,  1023,  1024,  1025,
    1026,  1027,  1028,  1029,  1030,  1031,  1032,  1033,  1034,  1035,
    1036,  1037,  1038,  1039,  1040,  1041,  1042,  1043,  1044,  1054,
    1065,  1069,  1079,  1082,  1092,  1094,  1104,  1106,  1117,  1127,
    1131,  1132,  1141,  1143,  1154,  1156,  1160,  1161,  1164,  1165,
    1172,  1173,  1174,  1175,  1176,  1177,  1190,  1192,  1194,  1199,
    1201,  1203,  1205,  1207,  1210,  1212,  1214,  1216,  1218,  1220,
    1222,  1224,  1228,  1229,  1233,  1235,  1239,  1240,  1241,  1242,
    1245,  1246,  1256,  1259,  1260,  1261,  1262,  1272,  1273,  1274,
    1276,  1278,  1280,  1284,  1285,  1286,  1289,  1290,  1293,  1295,
    1297,  1299,  1301,  1308,  1310,  1312,  1314,  1316,  1322,  1323,
    1326,  1330,  1332,  1336,  1337,  1343,  1347,  1348,  1349,  1350,
    1360,  1362,  1368,  1369,  1373,  1377,  1380,  1383,  1386,  1389,
    1392,  1395,  1398,  1401,  1404,  1407,  1410,  1413,  1416,  1419,
    1422,  1425,  1428,  1431,  1434,  1437,  1440,  1443,  1446,  1449,
    1452,  1454,  1458,  1459,  1465,  1468,  1470,  1472,  1477,  1478,
    1481,  1482,  1483,  1486,  1487,  1497,  1499,  1503,  1515,  1524,
    1525,  1528,  1529,  1530,  1533,  1534,  1537,  1538,  1539,  1541,
    1543,  1544,  1545,  1547,  1549,  1551,  1556,  1557,  1560,  1561,
    1568,  1571,  1574,  1575,  1585,  1588,  1598,  1599,  1600,  1601,
    1602,  1603,  1604,  1608,  1611,  1613,  1615,  1619,  1620,  1621,
    1624,  1628,  1629,  1632,  1634,  1635,  1649,  1651,  1653,  1655,
    1657,  1659,  1661,  1676,  1677,  1678,  1679,  1682,  1686,  1688,
    1692,  1693,  1694,  1695,  1696,  1697,  1704,  1706,  1710,  1712,
    1714,  1716,  1721,  1722,  1725,  1727,  1731,  1734,  1736,  1742,
    1745,  1746,  1747,  1748,  1749,  1752,  1756,  1760,  1761,  1762,
    1763,  1764,  1767,  1770,  1773,  1774,  1775,  1776,  1779,  1780,
    1781,  1782,  1785,  1786,  1789,  1790,  1799,  1798,  1809,  1815,
    1818,  1821,  1823,  1827,  1838,  1842,  1846,  1847,  1850,  1852,
    1854,  1856,  1858,  1860,  1862,  1864,  1866,  1868,  1870,  1874,
    1875,  1886,  1888,  1893,  1894,  1901,  1902,  1905,  1908,  1910,
    1913,  1916,  1918,  1922,  1923,  1933,  1937,  1938,  1952,  1954,
    1967,  1971,  1978,  1979,  1982,  1984,  1986,  1990,  1991,  1992,
    1995,  1998,  2001,  2002,  2005,  2006,  2009,  2011,  2014,  2017,
    2018,  2021,  2022,  2025,  2026,  2033,  2034,  2042,  2047,  2049,
    2053,  2055,  2059,  2061,  2072,  2080,  2095,  2097,  2099,  2101,
    2103,  2105,  2107,  2109,  2111,  2113,  2115,  2119,  2123,  2124,
    2127,  2128,  2132,  2133,  2134,  2135,  2138,  2139,  2142,  2145,
    2146,  2149,  2152,  2153,  2156,  2163,  2164,  2167,  2169,  2171,
    2173,  2175,  2179,  2180,  2183,  2184,  2187,  2188,  2191,  2195,
    2197,  2201,  2202,  2206,  2208,  2212,  2214,  2218,  2220,  2233,
    2238,  2250,  2252,  2256,  2257,  2258,  2259,  2260,  2261,  2262,
    2263,  2264,  2265,  2266,  2267,  2270,  2272,  2276,  2277,  2280,
    2281,  2290,  2305,  2310,  2315,  2320,  2325,  2330,  2335,  2340,
    2345,  2347,  2351,  2352,  2353,  2354,  2355,  2356,  2357,  2358,
    2359,  2360,  2361,  2362,  2363,  2364,  2367,  2378,  2379,  2382,
    2384,  2386,  2388,  2390,  2392,  2394,  2396,  2398,  2400,  2402,
    2404,  2406,  2408,  2410,  2412,  2416,  2417,  2418,  2419,  2420,
    2421,  2422,  2423,  2424,  2425,  2426,  2427,  2430,  2431,  2441,
    2445,  2447,  2451,  2452,  2453,  2456,  2458,  2462,  2463,  2464,
    2465,  2468,  2470,  2472,  2474,  2476,  2478,  2480,  2482,  2486,
    2488,  2492,  2493,  2496,  2501,  2504,  2506,  2510,  2519,  2524,
    2528,  2529,  2532,  2533,  2549,  2552,  2557,  2558,  2561,  2564,
    2567,  2568,  2571,  2573,  2575,  2579,  2580,  2581,  2584,  2585,
    2586,  2589,  2590,  2591,  2594,  2597,  2602,  2603,  2606,  2608,
    2612,  2614,  2618,  2619,  2620,  2621,  2622,  2625,  2626,  2627,
    2628,  2631,  2633,  2637,  2639,  2649,  2651,  2653,  2658,  2660,
    2665,  2667,  2669,  2671,  2673,  2675,  2677,  2679,  2681,  2683,
    2685,  2687,  2689,  2693,  2695,  2697,  2701,  2702,  2706,  2710,
    2711,  2714,  2715,  2728,  2730,  2734,  2736,  2740,  2742,  2746,
    2751,  2753,  2755,  2760,  2762,  2766,  2769,  2774,  2775,  2779,
    2783,  2784,  2794,  2796,  2798,  2802,  2803,  2806,  2807,  2818,
    2820,  2822,  2824,  2826,  2828,  2830,  2832,  2834,  2836,  2838,
    2840,  2842,  2844,  2846,  2848,  2850,  2852,  2854,  2856,  2858,
    2862,  2863,  2873,  2875,  2877,  2879,  2881,  2883,  2893,  2895,
    2897,  2899,  2901,  2903,  2905,  2907,  2909,  2911,  2913,  2915,
    2917,  2919,  2931,  2930,  2940,  2941,  2942,  2946,  2948,  2952,
    2953,  2954,  2955,  2956,  2959,  2960,  2964,  2965,  2966,  2967,
    2970,  2971,  2972,  2975,  2977,  2989,  2993,  2997,  2999,  3012,
    3013,  3014,  3015,  3016,  3017,  3018,  3019,  3020,  3021,  3022,
    3023,  3024,  3025,  3028,  3029,  3030,  3034,  3036,  3037,  3041,
    3042,  3043,  3047,  3048,  3059,  3061,  3070,  3075,  3080,  3086,
    3096,  3108,  3110,  3114,  3116,  3120,  3122,  3124,  3126,  3128,
    3130,  3132,  3134,  3136,  3138,  3140,  3144,  3145,  3156,  3160,
    3165,  3166,  3170,  3180,  3182,  3193,  3200,  3202,  3204,  3206,
    3208,  3212,  3213,  3217,  3222,  3224,  3226,  3228,  3230,  3232,
    3237,  3251,  3253,  3255,  3260,  3261,  3272,  3274,  3276,  3280,
    3282,  3286,  3287,  3290,  3291,  3294,  3295,  3298,  3299,  3302,
    3305,  3316,  3321,  3322,  3323,  3324,  3325,  3326,  3329,  3330,
    3333,  3339,  3348,  3349,  3350,  3351,  3354,  3355,  3358,  3363,
    3368,  3369,  3372,  3373,  3374,  3375,  3385,  3390,  3392,  3394,
    3398,  3400,  3404,  3408,  3409,  3419,  3423,  3424,  3427,  3431,
    3434,  3437,  3438,  3439,  3440,  3441,  3442,  3443,  3444,  3447,
    3448,  3458,  3467,  3468,  3472,  3473,  3477,  3480,  3483,  3486,
    3487,  3496,  3527,  3528,  3529,  3530,  3531,  3535,  3541,  3542,
    3552,  3554,  3558,  3560,  3564,  3566,  3568,  3570,  3574,  3575,
    3578,  3582,  3584,  3586,  3588,  3592,  3597,  3598,  3608,  3610,
    3612,  3614,  3616,  3618,  3620,  3622,  3626,  3627,  3630,  3631,
    3634,  3636,  3638,  3641,  3644,  3645,  3648,  3652,  3653,  3656,
    3658,  3662,  3664,  3666,  3668,  3670,  3677,  3678,  3681,  3682,
    3685,  3695,  3698,  3701,  3704,  3708,  3709,  3713,  3714,  3718,
    3719,  3723,  3725,  3730,  3731,  3734,  3736,  3748,  3749,  3752,
    3753,  3763,  3765,  3767,  3769,  3771,  3773,  3775,  3777,  3782,
    3784,  3786,  3807,  3809,  3811,  3813,  3815,  3817,  3821,  3823,
    3825,  3827,  3831,  3832,  3833,  3834,  3838,  3839,  3849,  3851,
    3855,  3857,  3859,  3861,  3865,  3867,  3869,  3873,  3876,  3877,
    3880,  3881,  3882,  3883,  3886,  3888,  3892,  3905,  3907,  3909,
    3911,  3916,  3922,  3929,  3936,  3937,  3938,  3939,  3940,  3941,
    3942,  3943,  3944,  3947,  3948,  3949,  3950,  3951,  3952,  3954,
    3958,  3959,  3960,  3961,  3964,  3965,  3968,  3969,  3977,  3979,
    3981,  3983,  3985,  3987,  3989,  3991,  3993,  3995,  3997,  4001,
    4004,  4012,  4013,  4016,  4017,  4020,  4024,  4033,  4034,  4037,
    4038,  4041,  4045,  4049,  4051,  4053,  4055,  4057,  4059,  4063,
    4066,  4069,  4072,  4075,  4077,  4079,  4081,  4085,  4089,  4091,
    4094,  4097,  4098,  4099,  4100,  4101,  4102,  4103,  4104,  4105,
    4106,  4107,  4108,  4109,  4110,  4136,  4138,  4140,  4151,  4153,
    4155,  4157,  4159,  4161,  4163,  4165,  4167,  4169,  4171,  4173,
    4175,  4177,  4179,  4181,  4183,  4185,  4187,  4189,  4191,  4193,
    4195,  4197,  4199,  4201,  4203,  4205,  4207,  4209,  4211,  4213,
    4215,  4217,  4228,  4230,  4232,  4234,  4236,  4238,  4240,  4242,
    4244,  4246,  4248,  4250,  4252,  4254,  4256,  4258,  4260,  4262,
    4264,  4266,  4268,  4280,  4282,  4284,  4286,  4288,  4290,  4292,
    4294,  4296,  4298,  4300,  4302,  4304,  4306,  4308,  4310,  4312,
    4314,  4316,  4318,  4320,  4332,  4334,  4336,  4338,  4340,  4342,
    4344,  4346,  4348,  4350,  4352,  4364,  4366,  4368,  4370,  4372,
    4374,  4376,  4378,  4380,  4382,  4384,  4386,  4388,  4390,  4392,
    4394,  4396,  4398,  4400,  4402,  4404,  4406,  4408,  4410,  4413,
    4415,  4417,  4419,  4421,  4423,  4425,  4427,  4429,  4431,  4433,
    4435,  4437,  4439,  4441,  4443,  4445,  4447,  4455,  4457,  4461,
    4463,  4465,  4468,  4471,  4475,  4477,  4481,  4483,  4487,  4488,
    4491,  4492,  4493,  4496,  4498,  4500,  4504,  4505,  4506,  4509,
    4510,  4513,  4514,  4515,  4516,  4517,  4518,  4519,  4520,  4521,
    4524,  4525,  4528,  4529,  4532,  4533,  4534,  4535,  4536,  4537,
    4540,  4542,  4546,  4549,  4552,  4554,  4558,  4559,  4563,  4564,
    4570,  4571,  4572,  4573,  4574,  4575,  4576,  4577,  4581,  4583,
    4588,  4592,  4595,  4598,  4600,  4602,  4604,  4606,  4609,  4612,
    4616,  4620,  4622,  4624,  4628,  4630,  4637,  4641,  4643,  4647,
    4651,  4654,  4657,  4658,  4661,  4662,  4666,  4667,  4668,  4669,
    4672,  4673,  4677,  4678,  4681,  4682,  4686,  4687,  4691,  4692,
    4695,  4703,  4705,  4710,  4712,  4714,  4790,  4791,  4794,  4796,
    4800,  4802,  4806,  4808,  4813,  4814,  4815,  4816,  4817,  4819,
    4821,  4823,  4831,  4833,  4835,  4837,  4839,  4841,  4843,  4845,
    4849,  4850,  4851,  4852,  4853,  4863,  4874,  4885,  4891,  4892,
    4895,  4896,  4899,  4907,  4910,  4918,  4919,  4928,  4937,  4949,
    4950,  4953,  4954,  4955,  4958,  4959,  4960,  4961,  4962,  4965,
    4966,  4969,  4970,  4971,  4972,  4973,  4974,  4975,  4977,  4980,
    4982,  4989,  5005,  5007,  5010,  5012,  5016,  5028,  5044,  5048,
    5059,  5060,  5063,  5075,  5084,  5085,  5088,  5089,  5090,  5093,
    5094,  5097,  5098,  5101,  5102,  5105,  5107,  5109,  5111,  5115,
    5122,  5145,  5178,  5188,  5195,  5232,  5241,  5243,  5244,  5247,
    5249,  5250,  5253,  5254,  5255,  5256,  5257,  5264,  5263,  5273,
    5275,  5277,  5278,  5279,  5282,  5283,  5284,  5285,  5286,  5289,
    5290,  5294,  5293,  5310,  5308,  5323,  5322,  5335,  5341,  5342,
    5345,  5347,  5348,  5351,  5352,  5353,  5354,  5357,  5358,  5361,
    5369,  5386,  5394,  5417,  5515,  5549,  5551,  5553,  5557,  5561,
    5560,  5611,  5613,  5612,  5627,  5633,  5640,  5645,  5648,  5649,
    5652,  5653,  5654,  5655,  5656,  5657,  5658,  5666,  5674,  5677,
    5678,  5679,  5680,  5681,  5682,  5690,  5698,  5699,  5700,  5703,
    5704,  5707,  5709,  5713,  5799,  5800,  5807,  5808,  5809,  5815,
    5824,  5827,  5828,  5829,  5830,  5833,  5834,  5835,  5838,  5839,
    5840,  5841,  5842,  5845,  5847,  5851,  5864,  5871,  5872,  5878,
    5880,  5881,  5884,  5885,  5888,  5895,  5902,  5902,  5904,  5905,
    5908,  5908,  5910,  5920,  5927,  5934,  5941,  5950,  5951,  5963,
    5974,  5985,  5989,  5990,  5993,  5998,  6002,  6003,  6006,  6013,
    6020,  6024,  6025,  6028,  6031,  6035,  6036,  6039,  6046,  6047,
    6048,  6049,  6050,  6051,  6052,  6053,  6054,  6055,  6056,  6057,
    6058,  6059,  6060,  6067,  6068,  6071,  6072,  6079,  6080,  6081,
    6088,  6087,  6104,  6105,  6112,  6111,  6180,  6186,  6192,  6200,
    6206,  6212,  6218,  6224,  6230,  6236,  6242,  6248,  6259,  6260,
    6263,  6264,  6265,  6266,  6267,  6268,  6269,  6270,  6271,  6272,
    6273,  6274,  6275,  6276,  6277,  6278,  6279,  6280,  6281,  6282,
    6283,  6284,  6285,  6286,  6287,  6288,  6291,  6292,  6293,  6294,
    6295,  6296,  6300,  6301,  6302,  6303,  6304,  6305,  6306,  6309,
    6323,  6324,  6325,  6326,  6327,  6328,  6329,  6330,  6334,  6335,
    6336,  6337,  6338,  6339,  6340,  6344,  6345,  6346,  6347,  6348,
    6349,  6355,  6356,  6357,  6358,  6359,  6360,  6361,  6362,  6363,
    6366,  6367,  6368,  6369,  6372,  6373,  6374,  6375,  6378,  6379,
    6380,  6381,  6382,  6383,  6384,  6402,  6402,  6404,  6405,  6406,
    6407,  6408,  6409,  6415,  6416,  6419,  6420,  6421,  6422,  6423,
    6424,  6425,  6426,  6427,  6428,  6429,  6430,  6431,  6432,  6433,
    6434,  6435,  6436,  6437,  6438,  6439,  6440,  6441,  6442,  6443,
    6444,  6445,  6446,  6447,  6448,  6449,  6450,  6452,  6453,  6454,
    6455,  6456,  6457,  6458,  6459,  6460,  6461,  6462,  6463,  6465,
    6466,  6467,  6468,  6469,  6470,  6471,  6472,  6473,  6474,  6475,
    6476,  6477,  6478,  6479,  6480,  6481,  6482,  6484,  6485,  6486,
    6487,  6488,  6489,  6490,  6491,  6492,  6493,  6494,  6495,  6496,
    6497,  6498,  6499,  6500,  6502,  6503,  6504,  6505,  6506,  6507,
    6508,  6509,  6510,  6511,  6512,  6513,  6514,  6515,  6516,  6517,
    6518,  6519,  6520,  6521,  6522,  6523,  6524,  6525,  6526,  6527,
    6528,  6529,  6530,  6532,  6533,  6535,  6536,  6537,  6538,  6539,
    6540,  6541,  6542,  6543,  6544,  6545,  6546,  6547,  6548,  6549,
    6550,  6551,  6552,  6553,  6554,  6555,  6556,  6557,  6558,  6559,
    6560,  6561,  6562,  6563,  6564,  6565,  6566,  6567,  6568,  6569,
    6570,  6571,  6572,  6573,  6574,  6575,  6576,  6577,  6578,  6579,
    6580,  6581,  6582,  6583,  6584,  6585,  6586,  6587,  6588,  6589,
    6590,  6591,  6593,  6594,  6595,  6596,  6597,  6598,  6599,  6600,
    6601,  6602,  6603,  6604,  6605,  6606,  6607,  6608,  6609,  6610,
    6611,  6612,  6613,  6614,  6615,  6616,  6617,  6618,  6619,  6620,
    6621,  6622,  6623,  6624,  6625,  6626,  6627,  6628,  6629,  6630,
    6631,  6632,  6633,  6634,  6635,  6636,  6637,  6638,  6639,  6640,
    6641,  6642,  6643,  6645,  6659,  6660,  6664,  6665,  6666,  6667,
    6668,  6669,  6670,  6671,  6672,  6676,  6677,  6678,  6679,  6680,
    6681,  6682,  6683,  6684,  6685,  6686,  6687,  6688,  6689,  6690,
    6691,  6692,  6693,  6694,  6695,  6696,  6699,  6700,  6701,  6702,
    6703,  6704,  6705,  6706,  6707,  6721,  6722,  6723,  6724,  6725,
    6726,  6727,  6728,  6729,  6730,  6731,  6732,  6733,  6734,  6735,
    6736,  6737,  6738,  6739,  6740,  6750,  6751,  6752,  6753,  6754,
    6755,  6756,  6757,  6758,  6759,  6760,  6761,  6762,  6763,  6764,
    6765,  6766,  6767,  6768,  6769,  6770,  6771,  6772,  6773,  6774,
    6775,  6776,  6777,  6778,  6779,  6780,  6781,  6782,  6783,  6784,
    6785,  6786,  6787,  6788,  6789,  6790,  6791,  6792,  6793,  6794,
    6795,  6796,  6797,  6798,  6799,  6800,  6801,  6802,  6803,  6804,
    6805,  6806,  6807,  6808,  6809,  6810,  6811,  6812,  6816,  6817,
    6821,  6822,  6823,  6824,  6825,  6829,  6829,  6832,  6838,  6839,
    6842,  6844,  6849,  6859,  6866,  6867,  6868,  6871,  6903,  6904,
    6907,  6909,  6917,  6918,  6919,  6923,  6924,  6928,  6929,  6932,
    6933,  6936,  6937,  6938,  6939,  6940,  6943,  6944,  6945,  6946,
    6947,  6948,  6949,  6950,  6951,  6952,  6953,  6954,  6955,  6956,
    6957,  6958,  6959,  6960,  6961,  6962,  6963,  6964,  6965,  6966,
    6967,  6968,  6969,  6970,  6971,  6972,  6973,  6974,  6975,  6976,
    6977,  6978,  6979,  6980,  6981,  6982,  6983,  6984,  6985,  6986,
    6987,  6988,  6989,  6990,  6991,  6992,  6993,  6994,  6995,  6996,
    6997,  6998,  6999
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONTINUE", "SQL_COUNT", "SQL_DATA", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GO", "SQL_GOTO", 
  "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", "SQL_LENGTH", 
  "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN", 
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "TYPECAST", "ABORT_P", "ABSOLUTE_P", 
  "ACCESS", "ACTION", "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", 
  "ALSO", "ALTER", "ALWAYS", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", 
  "AS", "ASC", "ASSERTION", "ASSIGNMENT", "ASYMMETRIC", "AT", 
  "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", 
  "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", 
  "CASCADE", "CASCADED", "CASE", "CAST", "CHAIN", "CHAR_P", "CHARACTER", 
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", 
  "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMIT", "COMMITTED", 
  "CONCURRENTLY", "CONFIGURATION", "CONNECTION", "CONSTRAINT", 
  "CONSTRAINTS", "CONTENT_P", "CONVERSION_P", "COPY", "COST", "CREATE", 
  "CREATEDB", "CREATEROLE", "CREATEUSER", "CROSS", "CSV", "CURRENT_P", 
  "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", 
  "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", "DAY_P", "DEALLOCATE", 
  "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", 
  "DEFERRED", "DEFINER", "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", 
  "DICTIONARY", "DISABLE_P", "DISCARD", "DISTINCT", "DO", "DOCUMENT_P", 
  "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", 
  "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE", "EXCEPT", "EXCLUSIVE", 
  "EXCLUDING", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", 
  "FALSE_P", "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", 
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GET", 
  "GLOBAL", "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", 
  "HAVING", "HEADER_P", "HOLD", "HOUR_P", "IF_P", "ILIKE", "IMMEDIATE", 
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", 
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INNER_P", "INOUT", 
  "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", "INTEGER", 
  "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", 
  "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", "LARGE_P", "LAST_P", 
  "LEADING", "LEAST", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", 
  "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", 
  "MAPPING", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", 
  "MONTH_P", "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", "NCHAR", 
  "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEROLE", "NOCREATEUSER", 
  "NOINHERIT", "NOLOGIN_P", "NONE", "NOSUPERUSER", "NOT", "NOTHING", 
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL", "PASSWORD", "PLACING", 
  "PLANS", "POSITION", "PRECISION", "PRESERVE", "PREPARE", "PREPARED", 
  "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", 
  "READ", "REAL", "REASSIGN", "RECHECK", "REFERENCES", "REINDEX", 
  "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", 
  "RESET", "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", 
  "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", 
  "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", "SECURITY", "SELECT", 
  "SEQUENCE", "SERIALIZABLE", "SESSION", "SESSION_USER", "SET", "SETOF", 
  "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", "STABLE", 
  "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN", "STDOUT", 
  "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SUPERUSER_P", 
  "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE", "TABLESPACE", "TEMP", 
  "TEMPLATE", "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", 
  "TRUNCATE", "TRUSTED", "TYPE_P", "UNCOMMITTED", "UNENCRYPTED", "UNION", 
  "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", "UPDATE", "USER", "USING", 
  "VACUUM", "VALID", "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR", 
  "VARYING", "VERBOSE", "VERSION_P", "VIEW", "VOLATILE", "WHEN", "WHERE", 
  "WHITESPACE_P", "WITH", "WITHOUT", "WORK", "WRITE", "XML_P", 
  "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLFOREST", "XMLPARSE", 
  "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P", "YES_P", "ZONE", 
  "NULLS_FIRST", "NULLS_LAST", "WITH_CASCADED", "WITH_LOCAL", 
  "WITH_CHECK", "IDENT", "SCONST", "Op", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "BCONST", "XCONST", "DOLCONST", "ECONST", "NCONST", 
  "ICONST", "PARAM", "FCONST", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", 
  "'-'", "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", 
  "'.'", "';'", "'{'", "'}'", "\"=\"", "','", "':'", "$accept", "prog", 
  "statements", "statement", "at", "stmt", "CreateRoleStmt", "opt_with", 
  "OptRoleList", "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", 
  "AlterUserStmt", "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", 
  "CreateGroupStmt", "AlterGroupStmt", "add_drop", "DropGroupStmt", 
  "CreateSchemaStmt", "OptSchemaName", "OptSchemaEltList", "schema_stmt", 
  "VariableSetStmt", "set_rest", "var_name", "var_list", "iso_level", 
  "var_value", "opt_boolean", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableShowStmt", "VariableResetStmt", 
  "SetResetClause", "ConstraintsSetStmt", "constraints_set_list", 
  "constraints_set_mode", "CheckPointStmt", "DiscardStmt", 
  "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_rel_cmds", "alter_rel_cmd", "alter_column_default", 
  "opt_drop_behavior", "alter_using", "ClosePortalStmt", "CopyStmt", 
  "copy_from", "copy_file_name", "copy_opt_list", "copy_opt_item", 
  "opt_binary", "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", 
  "OptTemp", "OptTableElementList", "TableElementList", "TableElement", 
  "columnDef", "ColQualList", "ColConstraint", "ColConstraintElem", 
  "ConstraintAttr", "TableLikeClause", "TableLikeOptionList", 
  "TableLikeOption", "TableConstraint", "ConstraintElem", 
  "opt_column_list", "columnList", "columnElem", "key_match", 
  "key_actions", "key_delete", "key_update", "key_action", "OptInherit", 
  "OptWith", "OnCommitOption", "OptTableSpace", "OptConsTableSpace", 
  "CreateAsStmt", "@1", "create_as_target", "OptCreateAs", "CreateAsList", 
  "CreateAsElement", "CreateSeqStmt", "AlterSeqStmt", "OptSeqList", 
  "OptSeqElem", "opt_by", "CreatePLangStmt", "opt_trusted", 
  "handler_name", "opt_validator", "opt_lancompiler", "DropPLangStmt", 
  "opt_procedural", "CreateTableSpaceStmt", "OptTableSpaceOwner", 
  "DropTableSpaceStmt", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition", 
  "old_aggr_list", "old_aggr_elem", "enum_val_list", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_opfamily", 
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt", 
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt", 
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt", 
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt", 
  "FetchStmt", "fetch_direction", "fetch_count", "from_in", "CommentStmt", 
  "comment_type", "comment_text", "GrantStmt", "RevokeStmt", "privileges", 
  "privilege_list", "privilege", "privilege_target", "grantee_list", 
  "grantee", "opt_grant_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "GrantRoleStmt", "RevokeRoleStmt", 
  "opt_grant_admin_option", "opt_granted_by", "IndexStmt", 
  "index_opt_unique", "access_method_clause", "index_params", 
  "index_elem", "opt_class", "opt_asc_desc", "opt_nulls_order", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "opt_definition", "AlterFunctionStmt", 
  "alterfunc_opt_list", "opt_restrict", "RemoveFuncStmt", 
  "RemoveAggrStmt", "RemoveOperStmt", "oper_argtypes", "any_operator", 
  "CreateCastStmt", "cast_context", "DropCastStmt", "opt_if_exists", 
  "ReindexStmt", "reindex_type", "opt_force", "RenameStmt", "opt_column", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleStmt", "@2", 
  "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "PrepareStmt", "PreparableStmt", 
  "prep_type_clause", "ExecuteStmt", "execute_param_clause", 
  "DeallocateStmt", "InsertStmt", "insert_rest", "insert_column_list", 
  "insert_column_item", "returning_clause", "DeleteStmt", "using_clause", 
  "LockStmt", "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", 
  "set_clause_list", "set_clause", "single_set_clause", 
  "multiple_set_clause", "set_target", "set_target_list", 
  "DeclareCursorStmt", "cursor_options", "opt_hold", "SelectStmt", 
  "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_opt_alias", "func_table", 
  "where_clause", "where_or_current_clause", "TableFuncElementList", 
  "TableFuncElement", "Typename", "opt_array_bounds", "Iresult", 
  "SimpleTypename", "ConstTypename", "GenericType", "opt_type_modifiers", 
  "Numeric", "opt_float", "Bit", "ConstBit", "BitWithLength", 
  "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "a_expr", "b_expr", "c_expr", 
  "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "row", "sub_type", 
  "all_Op", "MathOp", "qual_Op", "qual_all_Op", "subquery_Op", 
  "expr_list", "extract_list", "type_list", "array_expr_list", 
  "array_expr", "extract_arg", "overlay_list", "overlay_placing", 
  "position_list", "substr_list", "substr_from", "substr_for", 
  "trim_list", "in_expr", "case_expr", "when_clause_list", "when_clause", 
  "case_default", "case_arg", "columnref", "indirection_el", 
  "indirection", "opt_indirection", "opt_asymmetric", "ctext_expr", 
  "ctext_expr_list", "ctext_row", "target_list", "target_el", 
  "relation_name", "qualified_name_list", "qualified_name", "name_list", 
  "name", "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "Fconst", "Bconst", 
  "Xconst", "Sconst", "PosIntConst", "IntConst", "IntConstVar", 
  "AllConstVar", "StringConst", "PosIntStringConst", "NumConst", 
  "AllConst", "PosAllConst", "RoleId", "SpecialRuleRelation", 
  "ECPGConnect", "connection_target", "opt_database_name", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", 
  "ECPGExecuteImmediateStmt", "ECPGVarDeclaration", 
  "single_vt_declaration", "precision", "opt_scale", "ecpg_interval", 
  "ECPGDeclaration", "@3", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@4", "var_declaration", "@5", "@6", 
  "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@7", "struct_union_type", "@8", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execute_rest", 
  "execstring", "prepared_name", "ECPGFree", "ECPGOpen", "opt_ecpg_using", 
  "ecpg_using", "using_descriptor", "into_descriptor", "opt_sql", 
  "ecpg_into", "using_list", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", "@9", 
  "opt_reference", "ECPGVar", "@10", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ECPGColId", "ColId", "type_function_name", 
  "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "ECPGunreserved_interval", "ECPGunreserved", 
  "ECPGunreserved_con", "col_name_keyword", "type_func_name_keyword", 
  "reserved_keyword", "into_list", "ecpgstart", "c_args", 
  "coutputvariable", "civarind", "civar", "indicator", "cvariable", 
  "ident", "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", 
  "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,    61,    60,    62,   721,
      43,    45,    42,    47,    37,    94,   722,    91,    93,    40,
      41,    46,    59,   123,   125,   723,    44,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   488,   489,   490,   490,   491,   491,   491,   491,   491,
     491,   491,   491,   492,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   494,   495,   495,   496,   496,   496,
     496,   496,   496,   496,   496,   496,   496,   496,   496,   496,
     496,   496,   496,   496,   496,   496,   496,   496,   496,   497,
     498,   499,   500,   501,   502,   502,   503,   503,   504,   505,
     506,   506,   507,   507,   508,   508,   509,   509,   510,   510,
     511,   511,   511,   511,   511,   511,   512,   512,   512,   513,
     513,   513,   513,   513,   513,   513,   513,   513,   513,   513,
     513,   513,   514,   514,   515,   515,   516,   516,   516,   516,
     517,   517,   517,   518,   518,   518,   518,   519,   519,   519,
     519,   519,   519,   520,   520,   520,   521,   521,   522,   522,
     522,   522,   522,   523,   523,   523,   523,   523,   524,   524,
     525,   526,   526,   527,   527,   528,   529,   529,   529,   529,
     530,   530,   531,   531,   532,   532,   532,   532,   532,   532,
     532,   532,   532,   532,   532,   532,   532,   532,   532,   532,
     532,   532,   532,   532,   532,   532,   532,   532,   532,   532,
     532,   532,   533,   533,   534,   534,   534,   534,   535,   535,
     536,   536,   536,   537,   537,   538,   538,   539,   539,   540,
     540,   541,   541,   541,   542,   542,   543,   543,   543,   543,
     543,   543,   543,   543,   543,   543,   544,   544,   545,   545,
     546,   546,   547,   547,   548,   548,   549,   549,   549,   549,
     549,   549,   549,   550,   550,   551,   551,   552,   552,   552,
     553,   554,   554,   555,   555,   555,   556,   556,   556,   556,
     556,   556,   556,   557,   557,   557,   557,   558,   559,   559,
     560,   560,   560,   560,   560,   560,   561,   561,   562,   562,
     562,   562,   563,   563,   564,   564,   565,   566,   566,   566,
     567,   567,   567,   567,   567,   568,   569,   570,   570,   570,
     570,   570,   571,   571,   572,   572,   572,   572,   573,   573,
     573,   573,   574,   574,   575,   575,   577,   576,   578,   579,
     579,   580,   580,   581,   582,   583,   584,   584,   585,   585,
     585,   585,   585,   585,   585,   585,   585,   585,   585,   586,
     586,   587,   587,   588,   588,   589,   589,   590,   590,   591,
     591,   592,   592,   593,   593,   594,   595,   595,   596,   596,
     597,   597,   598,   598,   599,   599,   599,   600,   600,   600,
     601,   601,   602,   602,   603,   603,   604,   604,   604,   605,
     605,   606,   606,   607,   607,   607,   607,   607,   608,   608,
     609,   609,   610,   610,   611,   612,   613,   613,   613,   613,
     613,   613,   613,   613,   613,   613,   613,   614,   615,   615,
     616,   616,   617,   617,   617,   617,   618,   618,   619,   620,
     620,   621,   622,   622,   623,   624,   624,   625,   625,   625,
     625,   625,   626,   626,   627,   627,   628,   628,   629,   630,
     630,   631,   631,   632,   632,   633,   633,   634,   634,   635,
     636,   637,   637,   638,   638,   638,   638,   638,   638,   638,
     638,   638,   638,   638,   638,   639,   639,   640,   640,   641,
     641,   642,   643,   643,   643,   643,   643,   643,   643,   643,
     643,   643,   644,   644,   644,   644,   644,   644,   644,   644,
     644,   644,   644,   644,   644,   644,   645,   646,   646,   647,
     647,   647,   647,   647,   647,   647,   647,   647,   647,   647,
     647,   647,   647,   647,   647,   648,   648,   648,   648,   648,
     648,   648,   648,   648,   648,   648,   648,   649,   649,   650,
     651,   651,   652,   652,   652,   653,   653,   654,   654,   654,
     654,   655,   655,   655,   655,   655,   655,   655,   655,   656,
     656,   657,   657,   658,   658,   659,   659,   660,   661,   662,
     663,   663,   664,   664,   665,   665,   666,   666,   667,   667,
     668,   668,   669,   669,   669,   670,   670,   670,   671,   671,
     671,   672,   672,   672,   673,   673,   674,   674,   675,   675,
     676,   676,   677,   677,   677,   677,   677,   678,   678,   678,
     678,   679,   679,   680,   681,   682,   682,   682,   683,   683,
     684,   684,   684,   684,   684,   684,   684,   684,   684,   684,
     684,   684,   684,   685,   685,   685,   686,   686,   687,   688,
     688,   689,   689,   690,   690,   691,   691,   692,   692,   693,
     693,   693,   693,   694,   694,   695,   695,   696,   696,   697,
     698,   698,   699,   699,   699,   700,   700,   701,   701,   702,
     702,   702,   702,   702,   702,   702,   702,   702,   702,   702,
     702,   702,   702,   702,   702,   702,   702,   702,   702,   702,
     703,   703,   704,   704,   704,   704,   704,   704,   705,   705,
     705,   705,   705,   705,   705,   705,   705,   705,   705,   705,
     705,   705,   707,   706,   708,   708,   708,   709,   709,   710,
     710,   710,   710,   710,   711,   711,   712,   712,   712,   712,
     713,   713,   713,   714,   714,   715,   716,   717,   717,   718,
     718,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   718,   719,   719,   719,   720,   720,   720,   721,
     721,   721,   722,   722,   723,   723,   724,   724,   724,   724,
     725,   726,   726,   727,   727,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   729,   729,   730,   731,
     732,   732,   733,   734,   734,   735,   736,   736,   736,   736,
     736,   737,   737,   738,   739,   739,   739,   739,   739,   739,
     740,   741,   741,   741,   742,   742,   743,   743,   743,   744,
     744,   745,   745,   746,   746,   747,   747,   748,   748,   749,
     749,   750,   751,   751,   751,   751,   751,   751,   752,   752,
     753,   753,   754,   754,   754,   754,   755,   755,   756,   756,
     757,   757,   758,   758,   758,   758,   759,   760,   760,   760,
     761,   761,   762,   763,   763,   764,   765,   765,   766,   767,
     767,   768,   768,   768,   768,   768,   768,   768,   768,   769,
     769,   770,   771,   771,   772,   772,   773,   774,   775,   776,
     776,   777,   778,   778,   778,   778,   778,   779,   779,   779,
     780,   780,   781,   781,   782,   782,   782,   782,   783,   783,
     784,   784,   784,   784,   784,   785,   785,   785,   786,   786,
     786,   786,   786,   786,   786,   786,   787,   787,   788,   788,
     789,   789,   789,   789,   790,   790,   791,   792,   792,   793,
     793,   794,   794,   794,   794,   794,   795,   795,   796,   796,
     797,   798,   798,   799,   799,   800,   800,   801,   801,   802,
     802,   803,   803,   804,   804,   805,   805,   806,   806,   807,
     807,   808,   808,   808,   808,   808,   808,   808,   808,   808,
     808,   808,   809,   809,   809,   809,   809,   809,   810,   810,
     810,   810,   811,   811,   811,   811,   812,   812,   813,   813,
     814,   814,   814,   814,   815,   815,   815,   816,   817,   817,
     818,   818,   818,   818,   819,   819,   820,   821,   821,   821,
     821,   822,   822,   822,   823,   823,   823,   823,   823,   823,
     823,   823,   823,   824,   824,   824,   824,   824,   824,   824,
     825,   825,   825,   825,   826,   826,   827,   827,   828,   828,
     828,   828,   828,   828,   828,   828,   828,   828,   828,   829,
     829,   830,   830,   831,   831,   832,   833,   834,   834,   835,
     835,   836,   837,   838,   838,   838,   838,   838,   838,   839,
     839,   840,   840,   841,   841,   841,   841,   842,   843,   843,
     843,   844,   844,   844,   844,   844,   844,   844,   844,   844,
     844,   844,   844,   844,   844,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   846,   846,   846,   846,   846,   846,   846,
     846,   846,   846,   846,   846,   846,   846,   846,   846,   846,
     846,   846,   846,   846,   847,   847,   847,   847,   847,   847,
     847,   847,   847,   847,   847,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   849,   849,   850,
     850,   850,   850,   851,   852,   852,   853,   853,   854,   854,
     855,   855,   855,   856,   856,   856,   857,   857,   857,   858,
     858,   859,   859,   859,   859,   859,   859,   859,   859,   859,
     860,   860,   861,   861,   862,   862,   862,   862,   862,   862,
     863,   863,   864,   864,   865,   865,   866,   866,   867,   867,
     868,   868,   868,   868,   868,   868,   868,   868,   869,   869,
     870,   871,   871,   872,   872,   872,   872,   872,   872,   873,
     874,   875,   875,   875,   876,   876,   877,   878,   878,   879,
     880,   880,   881,   881,   882,   882,   883,   883,   883,   883,
     884,   884,   885,   885,   886,   886,   887,   887,   888,   888,
     889,   890,   890,   891,   891,   891,   892,   892,   893,   893,
     894,   894,   895,   895,   896,   897,   898,   899,   900,   901,
     902,   902,   903,   903,   903,   903,   903,   903,   903,   903,
     904,   905,   906,   907,   908,   908,   908,   908,   909,   909,
     910,   910,   911,   911,   912,   912,   912,   912,   912,   913,
     913,   914,   914,   914,   915,   915,   915,   915,   915,   916,
     916,   917,   917,   917,   917,   917,   917,   917,   917,   918,
     919,   919,   920,   920,   920,   920,   921,   921,   921,   921,
     922,   922,   923,   924,   925,   925,   926,   926,   926,   927,
     927,   928,   928,   929,   929,   930,   930,   930,   930,   931,
     931,   932,   933,   933,   934,   935,   936,   937,   937,   938,
     939,   939,   940,   940,   940,   940,   940,   942,   941,   943,
     944,   945,   945,   945,   946,   946,   946,   946,   946,   947,
     947,   949,   948,   951,   950,   952,   950,   950,   953,   953,
     954,   954,   954,   955,   955,   955,   955,   956,   956,   957,
     957,   957,   957,   957,   957,   958,   958,   958,   959,   961,
     960,   962,   963,   962,   964,   964,   965,   965,   966,   966,
     967,   967,   967,   967,   967,   967,   967,   967,   967,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   969,
     969,   970,   970,   971,   972,   972,   973,   973,   973,   974,
     975,   976,   976,   976,   976,   977,   977,   977,   978,   978,
     978,   978,   978,   979,   979,   980,   980,   981,   981,   982,
     983,   983,   984,   984,   985,   986,   987,   987,   988,   988,
     989,   989,   990,   990,   991,   991,   991,   992,   992,   993,
     994,   995,   996,   996,   997,   998,   999,   999,  1000,  1001,
    1002,  1003,  1003,  1004,  1005,  1006,  1006,  1007,  1008,  1008,
    1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,
    1008,  1008,  1008,  1009,  1009,  1010,  1010,  1011,  1011,  1011,
    1013,  1012,  1014,  1014,  1016,  1015,  1017,  1017,  1017,  1018,
    1018,  1018,  1018,  1018,  1018,  1018,  1018,  1018,  1019,  1019,
    1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,
    1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,
    1020,  1020,  1020,  1020,  1020,  1020,  1021,  1021,  1021,  1021,
    1021,  1021,  1022,  1022,  1022,  1022,  1022,  1022,  1022,  1023,
    1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1025,  1025,
    1025,  1025,  1025,  1025,  1025,  1026,  1026,  1026,  1026,  1026,
    1026,  1027,  1027,  1027,  1027,  1027,  1027,  1027,  1027,  1027,
    1028,  1028,  1028,  1028,  1029,  1029,  1029,  1029,  1030,  1030,
    1030,  1030,  1030,  1030,  1030,  1031,  1031,  1032,  1032,  1032,
    1032,  1032,  1032,  1033,  1033,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1038,  1038,  1039,  1040,  1040,
    1041,  1041,  1042,  1043,  1044,  1044,  1044,  1045,  1046,  1046,
    1047,  1047,  1048,  1048,  1048,  1049,  1049,  1050,  1050,  1051,
    1051,  1052,  1052,  1052,  1052,  1052,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     1,     0,     2,     2,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     3,     2,     2,     2,     2,     3,     3,     5,
       5,     4,     5,     4,     3,     5,     3,     5,     5,     6,
       1,     1,     3,     5,     6,     4,     1,     0,     2,     0,
       1,     1,     1,     1,     1,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     5,     2,     2,     3,
       3,     3,     1,     3,     1,     3,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       6,     1,     1,     1,     1,     0,     1,     1,     3,     4,
       5,     4,     2,     2,     3,     4,     3,     2,     2,     1,
       4,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       4,     4,     1,     3,     3,     4,     6,     6,     6,     6,
       4,     6,     2,     4,     3,     3,     3,     3,     4,     4,
       3,     3,     3,     3,     3,     3,     4,     4,     3,     2,
       3,     1,     1,     3,     3,     3,     2,     2,     3,     2,
       1,     1,     0,     2,     0,     2,     2,     9,     6,     1,
       1,     1,     1,     1,     2,     0,     1,     1,     3,     3,
       1,     1,     3,     3,     3,     4,     1,     0,     2,     0,
       3,     0,     1,     0,    11,    12,     1,     1,     2,     2,
       2,     2,     0,     1,     0,     1,     3,     1,     1,     1,
       3,     2,     0,     3,     1,     1,     2,     1,     3,     4,
       4,     2,     5,     1,     2,     2,     2,     3,     2,     0,
       2,     2,     2,     2,     2,     2,     3,     1,     4,     6,
       7,    11,     3,     0,     3,     1,     1,     2,     2,     0,
       1,     1,     2,     2,     0,     3,     3,     2,     1,     1,
       2,     2,     4,     0,     2,     2,     2,     0,     3,     4,
       4,     0,     2,     0,     4,     0,     0,     7,     5,     3,
       0,     3,     1,     1,     5,     4,     2,     0,     2,     1,
       2,     3,     2,     2,     2,     2,     3,     3,     3,     1,
       0,     5,     9,     1,     0,     1,     2,     2,     0,     2,
       0,     5,     7,     1,     0,     6,     2,     0,     3,     5,
      14,    19,     1,     1,     1,     3,     5,     1,     1,     1,
       3,     0,     1,     0,     1,     1,     1,     3,     0,     1,
       1,     0,     2,     1,     2,     1,     2,     0,     2,     1,
       2,     2,     6,     8,     8,     3,     5,     4,     4,     4,
       3,     7,     8,     6,     6,     6,     6,     3,     1,     3,
       3,     1,     1,     1,     1,     1,     3,     3,     3,     1,
       3,     3,     1,     3,    13,     1,     3,     4,     7,     4,
       7,     2,     1,     0,     2,     0,     1,     0,     6,     8,
       8,     1,     3,     5,     5,     7,     9,     7,     9,     5,
       6,     6,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     3,     3,     3,     1,     3,     1,     2,     2,
       3,     4,     5,     4,     4,     3,     4,     3,     3,     2,
       4,     2,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     2,     2,     1,     2,     2,     1,     1,     1,     6,
       7,     7,     9,     8,     8,     6,     9,     9,     7,    10,
       7,     8,     8,     8,     8,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     7,
       7,    10,     2,     1,     1,     1,     3,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     2,     2,     1,
       3,     1,     2,     3,     0,     1,     3,     2,     6,     6,
       3,     0,     3,     0,    13,    14,     1,     0,     2,     0,
       1,     3,     4,     4,     6,     1,     2,     0,     1,     1,
       0,     1,     1,     0,     9,     7,     2,     0,     3,     2,
       1,     3,     3,     3,     2,     2,     1,     1,     1,     1,
       2,     1,     3,     1,     1,     1,     4,     5,     1,     2,
       4,     5,     1,     1,     1,     1,     3,     3,     2,     2,
       2,     2,     1,     2,     2,     1,     2,     0,     5,     1,
       2,     1,     0,     5,     7,     5,     7,     7,     9,     1,
       3,     3,     3,     1,     3,    11,    10,     2,     0,     9,
       2,     0,     4,     4,     4,     1,     1,     1,     0,     7,
       6,     6,     6,     6,     7,     9,     9,     6,     6,     6,
       6,     6,     8,     8,     6,     6,     8,     8,     8,     8,
       1,     0,     7,     6,     6,     6,     6,     6,     7,     6,
       6,     6,     6,     7,     9,     9,     9,     6,     6,     6,
       8,     8,     0,    14,     1,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     1,     0,     6,     8,     2,     2,     2,     2,     2,
       3,     3,     2,     2,     2,     2,     3,     2,     5,     4,
       3,     3,     3,     1,     1,     0,     3,     2,     2,     1,
       3,     2,     1,     0,     8,    10,     2,     3,     3,     0,
       2,     5,     3,     1,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     4,     3,     3,     1,     0,     5,     4,
       2,     0,     4,     3,     5,     6,     4,     6,     6,     5,
       7,     1,     0,     6,    11,    11,    11,    13,     9,    11,
      10,     3,     1,     4,     2,     0,     4,     5,     5,     2,
       4,     1,     1,     1,     0,     1,     0,     1,     0,     3,
       0,     4,     1,     1,     1,     1,     1,     1,     1,     0,
       5,     4,     1,     1,     1,     1,     3,     0,     4,     8,
       3,     0,     2,     3,     2,     3,     5,     1,     4,     2,
       3,     1,     2,     2,     0,     6,     2,     0,     5,     3,
       0,     2,     2,     2,     3,     1,     3,     1,     2,     1,
       0,     7,     1,     3,     1,     1,     3,     5,     2,     1,
       3,     7,     0,     2,     2,     2,     3,     0,     2,     2,
       1,     1,     3,     3,     1,     2,     4,     4,     1,     1,
       8,     1,     4,     4,     4,     2,     1,     0,     3,     3,
       4,     4,     4,     4,     2,     1,     1,     0,     1,     0,
       1,     5,     1,     0,     1,     0,     3,     1,     3,     4,
       3,     4,     4,     2,     2,     4,     1,     0,     1,     1,
       1,     3,     0,     2,     0,     1,     3,     1,     0,     1,
       2,     4,     4,     2,     0,     2,     3,     2,     0,     3,
       1,     1,     2,     1,     2,     5,     6,     5,     1,     2,
       1,     4,     3,     4,     5,     4,     5,     4,     5,     2,
       4,     1,     2,     2,     2,     1,     1,     0,     4,     2,
       1,     2,     2,     4,     1,     2,     3,     1,     2,     0,
       2,     4,     4,     0,     1,     3,     2,     2,     3,     5,
       6,     3,     4,     0,     1,     3,     3,     3,     3,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     5,
       1,     1,     1,     1,     2,     3,     3,     0,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     1,     3,
       0,     1,     1,     1,     1,     5,     2,     1,     1,     1,
       1,     5,     2,     2,     2,     1,     3,     3,     2,     1,
       0,     3,     0,     5,     2,     5,     2,     1,     3,     3,
       0,     1,     1,     1,     1,     1,     1,     3,     3,     3,
       3,     3,     3,     3,     0,     1,     3,     5,     2,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       2,     2,     3,     3,     2,     3,     5,     4,     6,     3,
       5,     4,     6,     4,     6,     5,     7,     2,     3,     2,
       4,     3,     3,     4,     3,     4,     3,     4,     5,     6,
       6,     7,     6,     7,     6,     7,     3,     4,     4,     6,
       2,     3,     4,     1,     3,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     2,     5,     6,
       6,     7,     3,     4,     1,     1,     2,     4,     1,     1,
       1,     2,     2,     2,     1,     3,     4,     5,     5,     4,
       1,     1,     4,     1,     4,     1,     4,     1,     4,     1,
       1,     1,     1,     6,     4,     4,     4,     4,     6,     5,
       5,     5,     4,     6,     4,     4,     4,     4,     5,     7,
       7,     9,     4,     6,     5,     7,     7,     2,     3,     3,
       3,     4,     0,     4,     1,     3,     3,     1,     1,     1,
       2,     2,     0,     4,     3,     5,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     1,     4,     1,     4,     1,     2,     1,     2,
       1,     3,     3,     0,     1,     3,     1,     3,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     3,
       2,     3,     0,     3,     3,     2,     2,     1,     0,     2,
       2,     3,     2,     1,     1,     3,     5,     2,     1,     4,
       2,     0,     1,     0,     1,     2,     2,     2,     3,     5,
       1,     2,     0,     2,     1,     0,     1,     1,     1,     3,
       3,     3,     1,     3,     1,     1,     1,     1,     1,     3,
       1,     2,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     2,     3,     6,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     5,     1,     1,
       1,     1,     5,     3,     2,     2,     3,     7,     1,     1,
       1,     0,     2,     2,     1,     0,     1,     3,     1,     2,
       0,     2,     0,     2,     0,     1,     3,     4,     3,     1,
       1,     1,     2,     0,     7,     3,     1,     1,     1,     1,
       2,     0,     1,     3,     3,     3,     3,     0,     4,     5,
       5,     0,     1,     1,     1,     1,     2,     2,     2,     1,
       2,     0,     7,     0,     5,     0,     4,     2,     2,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     5,     2,     1,     3,     2,     2,     3,     0,
       5,     1,     0,     5,     2,     2,     1,     1,     1,     2,
       2,     3,     1,     2,     2,     3,     3,     4,     2,     1,
       2,     1,     1,     2,     2,     3,     1,     1,     1,     1,
       0,     1,     3,     5,     0,     2,     0,     1,     2,     3,
       2,     1,     1,     1,     0,     1,     1,     1,     2,     2,
       1,     1,     0,     1,     1,     1,     1,     2,     2,     3,
       0,     1,     2,     1,     4,     4,     0,     1,     2,     1,
       1,     3,     1,     1,     4,     4,     4,     1,     0,     3,
       3,     4,     1,     3,     3,     4,     1,     3,     3,     1,
       6,     1,     3,     3,     6,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     4,     1,     1,     4,     4,     3,
       0,     7,     1,     0,     0,     7,     3,     4,     3,     1,
       1,     1,     2,     3,     5,     2,     5,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     1,     0,     1,
       2,     1,     2,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     2,     3,     1,     2,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  2221,  2225,  2229,  2230,  2157,  2231,
    2232,  2197,  2198,  2199,  2200,  2201,  2202,  2203,  2204,  2205,
    2206,  2207,  2208,  2210,  2209,  2211,  2212,  2213,  2214,  2215,
    2216,  2217,  2218,  2220,  2219,  2234,  2222,  2235,  2223,  2224,
    2226,  2227,  2196,  2228,  2236,  2237,  2238,  2233,  2186,  1444,
    2187,    10,  1447,  1445,  1446,  1440,  1441,  2241,  2192,  2193,
    2191,  2194,  2195,  2239,  2240,  2182,  2183,  2185,    11,    12,
    2184,  2242,     4,  2188,  2189,  2190,     8,  1527,  1600,     9,
    2181,  1600,     0,  1710,  1711,  1712,     0,  1713,  1714,  1715,
    1716,  1717,  1648,  1614,  1718,     0,  1719,  1720,  1721,  1722,
    1723,  1724,  1725,  1726,     0,  1727,  1728,  1729,  1730,  1599,
    1731,  1732,  1733,  1734,  1735,  1576,  1582,  1694,     0,  1556,
    1557,  1553,  1555,  1554,  1558,  1541,   825,   434,   892,   891,
       0,  2065,   825,  2066,  2024,  2067,  2025,  2026,   235,     0,
     882,  2027,     0,   825,   307,   322,  2068,  1491,     0,  2028,
    2029,     0,     0,     0,   434,   825,     0,     0,  2030,   909,
    2031,     0,  2032,  2069,  2070,     0,     0,  2033,  2071,  2072,
    2034,     0,  2035,  2036,  2073,  2074,  2075,  2037,  2076,  2077,
       0,     0,   997,     0,  2038,  2078,  2039,  2040,     0,  2079,
    2041,  2042,  2043,  2080,  2081,  2044,  2045,  2046,     0,  2047,
       0,     0,     0,     0,     0,  2082,   825,  2048,     0,  1003,
       0,  2049,     0,  2083,  2050,     0,  2051,  2052,  2053,  2054,
    2055,   997,  1690,  1577,     0,     0,   896,     0,  2056,  2084,
    2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,  2168,  2169,
       0,     0,     0,    47,    53,    24,    23,    27,    28,    67,
      72,    42,    18,    62,    48,   101,   102,   103,    34,    30,
      59,    22,    31,    35,    50,    36,    49,    21,    43,    66,
      51,    70,    52,    71,    37,    60,    57,    44,    45,    46,
      63,    64,    65,    86,    69,    97,    76,    33,    77,    92,
      78,    93,    79,    41,    17,    90,    88,    89,    38,    61,
      87,    91,    19,    20,    94,    68,    84,    81,    98,    96,
     104,    82,    54,    14,    15,    73,    40,    16,    26,    25,
      39,    32,   100,    29,   894,    74,    85,    75,    55,    80,
      58,    83,    99,    56,    95,   971,   970,  1005,   974,   981,
     106,   107,   112,     7,  1516,  1517,  1518,  1600,  1551,  1552,
    1545,  1561,  1571,  1560,  1564,  1572,  1559,  1578,     0,   109,
     111,   113,   116,   110,   105,   108,   115,   120,   114,   119,
     117,   118,   121,   122,   123,  1783,  1174,  1781,  1782,  1780,
    1533,     0,  1600,  1535,  1534,     0,  1736,  1737,  1738,  1739,
    1740,  1741,  1788,  1789,  1790,  1791,  1792,  1794,  1793,  1805,
    1806,  1807,  1808,  1809,  1810,  1811,  1812,  1813,  1814,  1815,
    1816,  1817,  1818,  1819,  1820,  1821,  1822,  1823,  1824,  1825,
    1826,  1763,  1827,  1828,  1829,  1830,  1831,  1832,  1833,  1834,
    1835,  1836,  1804,  1837,  1838,  1839,  1840,  1841,  1842,  1843,
    1844,  1845,  1846,  1847,  1848,  1797,  1849,  1850,  1851,  1852,
    1853,  1854,  1855,  1856,  1857,  1858,  1859,  1860,  1861,  1862,
    1863,  1864,  1865,  1866,  1867,  1869,  1868,  1870,  1871,  1872,
    1873,  1874,  1875,  1876,  1877,  1878,  1879,  1880,  1881,  1882,
    1883,  1798,  1884,  1885,  1886,  1887,  1888,  1889,  1890,  1891,
    1892,  1893,  1894,  1895,  1896,  1897,  1898,  1899,  1900,  1901,
    1902,  1903,  1904,  1905,  1906,  1907,  1908,  1909,  1910,  1911,
    1912,  1799,  1913,  1914,  1800,  1915,  1916,  1917,  1918,  1919,
    1920,  1921,  1922,  1923,  1924,  1925,  1926,  1927,  1928,  1929,
    1930,  1931,  1932,  1933,  1934,  1935,  1936,  1937,  1938,  1939,
    1940,  1943,  1941,  1942,  1944,  1945,  1946,  1947,  1948,  1949,
    1950,  1951,  1952,  1953,  1954,  1955,  1956,  1957,  1958,  1959,
    1960,  1961,  1962,  1963,  1964,  1965,  1966,  1967,  1968,  1969,
    1970,  1971,  1801,  1972,  1973,  1974,  1975,  1976,  1977,  1978,
    1979,  1980,  1981,  1982,  1983,  1984,  1985,  1986,  1987,  1988,
    1989,  1991,  1990,  1992,  1993,  1994,  1995,  1996,  1491,  1997,
    1998,  1999,  2000,  2001,  2002,  2003,  2004,  2005,  2006,  2007,
    2008,  2009,  2010,  2011,  1764,  2012,  2013,  2014,  2015,  2016,
    2017,  2018,  2019,  2020,  2021,  1802,  2022,  2023,  2167,  1459,
    1510,  1509,  1484,  1505,  1761,  1708,  1709,  1479,  1762,  1759,
    1795,  1796,  1803,  1760,  1460,  2163,  1758,  1647,     0,     0,
    1613,  1612,  1616,  1615,  1617,  1610,  1611,  1425,  1511,  1628,
    1627,  1424,  1630,  1742,  1743,  1744,  1745,  1747,  1746,  1748,
    2085,  2086,  2087,  2088,  2089,  2090,  2091,  2092,  2093,  2094,
    2095,  2096,  1773,  2097,  2098,  2099,  2100,  2101,  2102,  2103,
    2106,  2104,  2105,  2107,  2108,  2109,  2110,  2111,  2112,  2113,
    2114,  2115,  2116,  2117,  2118,  2119,  2120,  2121,  2122,  2123,
    2124,  1774,  1775,  2125,  2126,  2127,  2128,  2129,  2130,  2131,
    2132,  2133,  2134,  2135,  2136,  2137,  2138,  2139,  2140,  2141,
    2142,  2143,  2144,  2145,  2146,  2147,  1777,  2148,  2149,  1776,
    2150,  2151,  2152,  2153,  2154,  1787,  1772,  1574,  1749,  1784,
    1771,  1778,  1779,  1786,  1785,  1584,  1580,  1588,  1583,     0,
       0,     0,     0,  1600,   824,   823,   809,     0,     0,     0,
       0,     0,     0,     0,     0,   433,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    13,     0,   833,
     286,   285,  1481,  1480,  1420,   885,  1416,  1417,   434,     0,
     812,   306,     0,     0,     0,     0,     0,     0,     0,   512,
       0,     0,     0,     0,     0,     0,     0,   167,     0,   317,
     316,     0,     0,   423,     0,   646,     0,     0,   434,     0,
       0,     0,  1490,  1489,  1485,  1495,     0,  1488,  1758,     0,
     924,  1941,  1625,  1626,   922,  1982,   962,     0,   236,   239,
     237,   238,     0,     0,   731,   539,     0,   538,     0,     0,
     536,     0,     0,     0,     0,   540,   534,   533,     0,     0,
       0,   537,     0,   535,     0,     0,   813,     0,  1566,  1567,
    1885,   921,   908,   894,  1806,   569,   573,   564,   570,   578,
     577,   565,   562,   563,  1953,     0,     0,   568,     0,   559,
    1448,  1450,   576,  1449,     0,   613,   619,   618,   617,     0,
     614,   615,   620,     0,   806,   840,  1429,   996,     0,     0,
     561,   805,  1997,   917,     0,     0,   735,     0,   736,     0,
    1968,   817,   227,  1756,  1974,  2052,  1997,  1757,   223,  1754,
     192,  1755,  1751,  1752,  1753,  1750,     0,     0,   614,     0,
     814,   815,  1002,  1000,     0,     0,     0,     0,  1837,  1906,
     215,  1964,  1974,  2052,  1997,  2021,   176,     0,   222,  1974,
    2052,  1997,     0,   833,     0,     0,  1575,   808,   807,     0,
    1074,     0,  1070,   895,   898,     0,  1035,   979,     0,   825,
       0,     6,   893,   889,   999,   999,     0,   999,     0,   975,
       0,  1543,  1571,  1550,  1606,  1547,     0,     0,  1596,  1592,
    1589,  1597,  1598,  1591,  1579,  1163,  1164,  1165,  1162,  1166,
    1161,     0,  1522,  1563,  1528,     0,  1538,  1537,  1536,  2170,
    2171,  1649,  1483,  1502,     0,     0,     0,     0,     0,  1636,
    1629,  1631,  1633,  1586,  1585,  1581,     0,     0,  1699,     0,
       0,  1700,  1701,     0,  1696,  1698,     0,  1606,     0,     0,
    1761,  1769,  1430,  1762,  1759,  1767,  1758,     0,   547,   126,
       0,     0,   547,     0,     0,     0,     0,  1829,  1873,  1329,
    1339,  1337,  1338,  1331,  1332,  1333,  1336,  1334,  1335,     0,
     723,  1330,     0,   126,     0,     0,   407,     0,     0,     0,
       0,     0,   126,     0,     0,     0,     0,     0,   829,   832,
     810,     0,     0,  1400,  1421,     0,     0,   881,     0,     0,
     595,   604,   596,   601,     0,   598,     0,     0,   606,     0,
     597,   599,   600,   605,     0,     0,   602,   603,     0,     0,
     821,   309,     0,     0,     0,     0,     0,   842,   872,   321,
     320,   126,   319,   318,     0,     0,     0,   666,   126,     0,
     169,   437,     0,     0,   480,   126,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1494,  1500,     0,  1492,  1650,
     925,   923,  1609,     0,   937,  1884,     0,   475,     0,     0,
    1884,   863,  1884,     0,  1884,   162,  1422,     0,     0,     0,
       0,     0,  1884,   154,  1884,     0,  1884,   438,     0,  1884,
       0,  1884,   156,     0,  1884,   282,   545,     0,     0,  2175,
    2179,     0,  2177,  2172,  1565,  1624,  1623,  1515,     0,  1622,
       0,   566,   575,   574,   572,   571,   567,  1451,     0,   557,
     558,  1636,  1639,   555,     0,   612,     0,     0,     0,     0,
     940,  1418,     0,   820,     0,     0,     0,     0,   738,   738,
     738,   816,   226,   224,     0,     0,     0,     0,     0,   822,
       0,     0,     0,  2024,  2025,  1128,  1393,     0,  1763,  2026,
    2027,  1270,  1279,  1271,  1273,  1280,  2028,  2029,  1861,  2030,
    2031,  1437,  2032,  2033,  1118,  2035,  2036,  2037,  1275,  1277,
    2038,  2039,     0,  1438,  2041,  2042,  1933,  2044,  2045,  2047,
    2048,  1281,  2050,  2051,  2052,  2053,  2054,  2055,  1436,     0,
    1282,  2056,  2058,  2059,  2060,  2061,  2062,  2063,  1340,  1442,
    1443,  1402,     0,     0,  1415,     0,  1260,     0,  1110,  1111,
    1133,  1134,  1112,  1139,  1140,  1152,  1113,     0,  1414,  1175,
    1259,  1264,     0,  1258,  1254,   987,  1412,  1394,     0,  1255,
    1473,  1472,  1474,  1475,  1471,  1432,  1439,  1478,  2163,     0,
       0,     0,     0,     0,  1689,   231,     0,   232,  1974,   177,
     214,   187,   213,   188,   217,   216,     0,  1827,   178,     0,
     185,     0,     0,     0,     0,     0,     0,     0,   218,   811,
     282,     0,     0,  1072,     0,  1075,     0,  1071,   897,   894,
    1407,  1406,  1408,     0,   973,   972,     5,   900,   998,     0,
       0,     0,     0,     0,     0,     0,  1028,  1017,  1025,  1029,
    1036,  1606,  1607,     0,  1601,     0,  1600,  1600,  1594,  1593,
    1590,     0,     0,     0,     0,     0,     0,  1465,  1464,  1519,
    1521,  1468,     0,     0,  1504,     0,  1508,  1506,  1636,  1644,
    1636,  1645,  1646,  1637,  1469,  1470,  1642,     0,  1632,  1640,
    1643,  1587,  1600,  1707,     0,  1702,  1705,     0,  1697,     0,
    1431,     0,     0,     0,     0,     0,   548,     0,     0,     0,
     125,   861,   229,   859,     0,     0,     0,   866,     0,     0,
       0,     0,   693,     0,     0,     0,     0,     0,     0,   694,
     692,   695,   702,   709,   712,     0,   637,   160,   161,     0,
       0,     0,     0,     0,     0,   241,   272,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,   405,   761,   761,
       0,     0,   761,     0,     0,     0,   761,     0,   240,   242,
     271,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   153,     0,     0,  1529,     0,   827,   828,     0,
     831,     0,  1397,  1396,  1427,  1401,   883,   884,  1428,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   292,   293,   126,   291,     0,     0,   477,
       0,  1121,  1150,  1150,  1150,  1117,  1117,  1130,  1119,  1157,
       0,  1150,  1117,  1122,     0,  1120,  1160,  1160,  1145,     0,
    1093,  1103,  1105,  1106,  1131,  1132,  1107,  1137,  1138,  1104,
    1174,  1768,  1117,  1770,  1766,  1765,     0,     0,   871,     0,
       0,   513,     0,     0,   478,     0,     0,     0,   165,     0,
       0,     0,     0,     0,     0,   443,   442,     0,     0,   479,
       0,   407,     0,   400,   363,     0,     0,  1835,     0,     0,
       0,  1498,  1493,  1496,     0,  1486,  1500,   963,   967,   964,
       0,   965,     0,  1083,     0,   282,   730,     0,     0,     0,
     282,     0,     0,  1884,     0,  1884,     0,     0,     0,   282,
       0,     0,     0,     0,   544,   542,   541,   543,     0,     0,
       0,     0,   282,     0,   280,   281,     0,   532,  2173,     0,
       0,  2176,  1568,     0,  1350,     0,   918,  1620,  1621,   322,
       0,     0,   901,   907,   903,   905,   904,   906,   902,   556,
     553,   554,     0,  1638,  2155,  2161,     0,  1651,  1652,     0,
    1848,  1878,  1900,  1969,  1972,     0,  1992,     0,   621,   641,
     616,     0,     0,   934,   927,     0,     0,   950,   560,   911,
    1354,     0,     0,     0,   737,   734,   733,   732,   225,   193,
       0,     0,   643,  1968,   819,     0,     0,  1262,  1263,  1149,
    1136,  1392,     0,     0,  1144,  1143,     0,     0,     0,     0,
    1126,  1125,  1124,  1261,  1353,     0,  1123,     0,     0,     0,
       0,  1150,  1150,  1148,  1194,     0,  1127,     0,     0,  1372,
       0,  1378,     0,     0,     0,  1156,     0,  1154,     0,     0,
    1230,     0,     0,     0,     0,     0,     0,  1256,  1178,  1179,
    1764,  1260,  1350,     0,  1433,     0,     0,  1142,     0,  1174,
       0,     0,     0,     0,  1405,  1348,     0,     0,  1207,  1346,
       0,  1209,     0,     0,     0,  1340,  1339,  1337,  1338,  1331,
    1332,  1333,  1336,  1334,  1335,  1344,  1191,     0,     0,  1190,
    1636,     0,  1038,   986,  1395,     0,  1476,     0,  2162,  2164,
    1686,  1685,  1684,  1683,  1659,     0,  1655,  1656,     0,  1687,
    1688,   233,   234,   230,     0,   190,   189,     0,   211,   212,
     184,     0,   207,   208,  1319,  1318,   191,   183,   181,   204,
     206,   205,   203,   179,   194,   200,   201,   202,   182,   180,
     221,   219,     0,   551,  1600,     0,  1076,     0,  1038,   952,
     954,   955,     0,  1402,   886,  1410,     0,     0,   890,   979,
     984,   978,   983,  1006,  1007,   660,   982,     0,  1034,  1034,
    1019,  1013,  1018,  1014,  1020,  1027,   977,  1016,   976,     0,
    1030,     0,  1608,  1546,  1606,  1093,  1600,  1539,  1600,  1595,
    1525,  1168,  1169,  1170,  1171,  1173,  1172,  1526,  1523,  1167,
    1524,  1467,  1466,     0,     0,     0,  1501,     0,  1482,  1507,
       0,     0,  1093,  2158,  1703,  2158,  1093,     0,     0,     0,
       0,     0,     0,     0,   549,     0,     0,     0,   228,   858,
       0,     0,     0,     0,     0,   869,   357,     0,   279,     0,
       0,     0,     0,     0,     0,   700,     0,     0,     0,     0,
     701,   698,   699,  1969,   711,   710,   708,   677,   679,   678,
       0,   669,     0,   670,     0,     0,   676,   685,   683,     0,
       0,     0,     0,   277,     0,   276,     0,     0,     0,     0,
       0,   719,   724,     0,     0,   135,   137,     0,     0,   133,
     139,   136,   138,   134,   140,   132,     0,     0,   131,     0,
       0,     0,     0,   150,     0,     0,     0,     0,     0,   409,
     420,     0,     0,     0,     0,   126,   126,   406,   760,   252,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   269,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   152,     0,
       0,     0,     0,     0,   199,   826,   830,  1398,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   308,   290,   289,     0,   295,
       0,   499,  1765,   476,     0,  1093,     0,     0,     0,  1087,
    1163,  1162,  1161,     0,  1108,  1117,  1114,     0,     0,   857,
     857,   857,   857,   857,   841,   843,   332,   158,     0,     0,
       0,   488,   491,     0,   124,   169,   322,     0,   168,   170,
     172,   173,   174,   171,   175,   436,     0,     0,     0,     0,
       0,   448,   447,   449,     0,   444,     0,     0,   149,   404,
     396,     0,   324,   387,     0,     0,   421,     0,     0,     0,
       0,   782,     0,  1499,     0,     0,     0,     0,   966,     0,
    1048,   936,  1040,  1050,  1041,  1043,  1077,  1420,     0,     0,
     934,     0,   715,     0,   864,     0,   713,   163,  1423,     0,
       0,     0,     0,     0,     0,   529,   155,     0,   282,   439,
       0,   282,   157,     0,   431,   282,   546,  2174,  2180,  2178,
     920,     0,  1618,  1619,     0,   962,   552,     0,     0,  2160,
    1452,     0,  1453,     0,     0,   625,   624,   635,   626,   627,
     623,   622,   628,     0,     0,   643,   929,     0,   931,  1402,
       0,   926,     0,   947,     0,   945,     0,  1419,   949,   938,
     916,     0,   910,   913,   915,   914,   912,     0,     0,   614,
       0,     0,   282,   818,     0,     0,     0,  1356,     0,     0,
    1391,  1388,     0,     0,     0,     0,     0,  1363,  1364,  1365,
    1362,  1366,  1361,     0,     0,  1367,  1360,     0,     0,     0,
       0,     0,  1147,  1146,     0,     0,     0,     0,     0,     0,
    1233,  1264,     0,     0,  1324,     0,  1350,  1377,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1350,  1383,
       0,     0,     0,  1317,     0,  1314,     0,     0,     0,  1403,
    1402,     0,     0,     0,     0,  1434,  1176,  1192,  1413,     0,
    1404,     0,     0,  1199,     0,  1384,  1226,     0,  1231,  1214,
       0,  1208,     0,  1212,  1216,  1195,  1405,  1349,     0,  1347,
       0,     0,  1193,     0,  1188,  1186,  1187,  1180,  1181,  1182,
    1183,  1184,  1185,  1189,  1328,  1326,  1327,     0,     0,     0,
    1211,  1731,  1879,  1906,     0,   997,   997,   985,   995,  1411,
       0,  1079,     0,     0,     0,  1265,     0,  2166,  2165,     0,
       0,     0,     0,     0,  1174,     0,   220,  1093,  1073,   959,
       0,     0,  1083,     0,   958,   888,   887,  1409,     0,     0,
     658,   659,     0,   663,  1026,     0,   950,   950,     0,     0,
       0,  1544,  1602,  1549,  1570,  1540,  1573,  1520,  1562,     0,
    1503,  1634,  1641,  1693,     0,  2159,     0,     0,   497,   496,
       0,     0,     0,   769,   740,   550,   770,   741,     0,   860,
       0,     0,     0,     0,     0,   282,   867,   278,   868,   763,
     771,     0,   696,   697,   772,   742,     0,   764,   680,  1117,
     668,     0,     0,   675,     0,   674,  1117,  1117,   743,   159,
     274,   751,   275,   273,     0,  1426,     0,     0,     0,     0,
     145,     0,     0,     0,     0,   128,   127,   146,   144,     0,
     143,     0,   777,   747,   749,   765,   408,   419,     0,   412,
     413,   410,   414,   415,     0,     0,     0,   244,     0,     0,
     255,   268,   263,   264,   262,   282,   282,     0,     0,     0,
       0,   265,   260,   261,   257,   270,   748,     0,   766,   256,
     254,     0,   243,   779,   755,     0,     0,     0,     0,     0,
       0,     0,   873,     0,     0,     0,   778,   767,   754,   750,
       0,     0,   197,   196,   198,     0,     0,     0,     0,     0,
       0,     0,     0,   608,   585,   607,     0,     0,     0,     0,
       0,     0,     0,   579,   311,   288,   498,     0,     0,     0,
       0,  1088,     0,     0,  1093,     0,     0,  1101,  1094,  1102,
       0,     0,     0,  1115,     0,   857,   856,     0,     0,     0,
       0,     0,   844,   865,     0,   518,   487,     0,     0,   363,
     164,     0,     0,   435,   486,   484,   483,   485,     0,     0,
       0,     0,  1084,     0,     0,     0,     0,     0,     0,   323,
     325,   327,   328,   329,     0,   402,   403,     0,     0,   391,
       0,   365,   366,     0,     0,     0,     0,   649,     0,     0,
       0,   707,   705,   688,     0,  1497,  1491,   968,   969,     0,
     979,     0,  1050,     0,  1049,  1061,     0,     0,  1067,  1065,
       0,  1067,     0,  1067,     0,  1042,     0,  1044,  1061,  1421,
       0,     0,  1080,   935,   282,     0,   282,     0,   282,     0,
     282,     0,   282,     0,   803,     0,   472,   282,   531,  1351,
       0,     0,  1635,  2156,  1660,  1661,     0,  1653,  1654,     0,
       0,   634,   629,   631,     0,   638,     0,     0,   932,   933,
     948,   941,   943,   942,     0,     0,   939,  1355,   530,     0,
     282,     0,   639,  1001,  1358,  1359,     0,     0,     0,     0,
    1387,     0,     0,  1294,  1272,  1274,  1116,  1284,     0,  1129,
    1295,  1296,  1276,  1278,     0,  1341,     0,     0,  1285,  1235,
       0,     0,     0,     0,  1340,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1247,  1246,  1286,  1323,     0,     0,
    1375,  1376,  1287,  1158,  1159,  1160,  1160,     0,     0,  1382,
       0,     0,     0,  1292,  1297,     0,     0,  1302,     0,  1322,
       0,     0,  1257,  1351,  1151,  1152,     0,     0,     0,     0,
       0,     0,     0,     0,  1232,  1215,  1210,     0,  1213,  1217,
       0,     0,     0,     0,  1201,  1227,  1197,     0,     0,  1203,
       0,  1228,   997,   997,   997,   997,   994,     0,     0,  1037,
       0,  1022,     0,     0,  1269,  1266,  1668,  1669,  1670,  1671,
    1672,  1673,  1674,  1676,  1677,  1679,  1680,  1681,  1675,  1678,
    1682,  1664,  1665,     0,  1657,  1658,   186,     0,   209,   195,
    1693,     0,     0,   953,   934,   956,   899,  1008,     0,  1342,
     663,   661,   662,  1010,  1033,  1032,  1031,  1011,  1015,  1012,
       0,  1604,  1530,  1692,  1695,  1706,  1704,  1542,   768,   739,
     762,   857,     0,   356,     0,     0,     0,   870,   690,     0,
    1117,   671,   672,   673,     0,     0,     0,     0,     0,     0,
       0,   721,     0,   722,   720,   141,   129,   148,   147,   130,
     142,   411,   416,   418,   417,   332,     0,     0,     0,   245,
     253,   250,   266,   258,   267,   259,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   773,   744,  1399,
     580,     0,   581,   588,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   590,   312,   126,     0,   296,   300,   872,
     872,     0,   301,   872,   297,   872,   294,   500,     0,  1933,
    1332,   501,   492,   494,   495,   493,   467,     0,     0,     0,
    1091,     0,     0,     0,     0,     0,     0,  1093,  1174,     0,
       0,   852,  1461,  1462,   851,  1463,   848,   847,   855,   854,
     846,   845,   850,   849,     0,     0,     0,   343,     0,     0,
     337,     0,     0,   707,   331,   334,   335,     0,   489,   490,
       0,   322,     0,   451,   445,     0,   502,   481,     0,  1086,
     921,   397,   324,   349,   383,     0,   399,     0,   385,   384,
     386,     0,   393,   362,     0,   839,   428,   425,     0,   649,
       0,     0,   703,   681,   704,     0,   684,     0,   689,   665,
       0,  1513,   961,  1514,  1052,  1059,     0,  1039,     0,  1066,
    1062,     0,  1063,     0,     0,  1064,     0,     0,  1059,     0,
       0,     0,   716,     0,   714,     0,   525,     0,   527,     0,
     717,   282,   282,   432,     0,   400,   967,     0,     0,   636,
     632,     0,     0,   609,   640,   928,   930,   946,   944,     0,
     610,   642,  1357,  1135,     0,  1390,  1386,     0,  1352,     0,
    1370,  1369,  1234,  1371,     0,  1252,     0,     0,  1245,  1244,
    1242,  1243,  1236,  1237,  1238,  1239,  1240,  1241,  1380,  1379,
    1373,  1374,  1155,  1153,     0,  1289,  1290,  1291,  1381,  1298,
       0,  1316,  1315,     0,     0,     0,  1304,     0,     0,  1312,
    1325,  1141,  1174,  1177,     0,     0,  1200,  1385,  1218,     0,
       0,     0,  1196,     0,     0,     0,     0,  1205,  1341,     0,
       0,     0,     0,     0,     0,   989,   988,  1078,     0,  1024,
    1267,  1268,  1477,     0,     0,     0,  1691,     0,   960,   951,
       0,  1009,  1548,     0,  1603,     0,   358,     0,     0,   707,
     691,     0,   686,     0,     0,     0,     0,     0,   519,   505,
       0,     0,   520,   521,     0,     0,     0,   330,     0,     0,
       0,     0,   284,   752,     0,     0,     0,     0,     0,   781,
     759,   780,   757,   756,   758,   753,     0,     0,     0,     0,
     584,   594,   592,   591,   593,   583,   295,     0,     0,     0,
       0,     0,     0,     0,   469,     0,     0,   474,   463,   465,
       0,     0,     0,  1089,  1095,  1096,  1097,  1098,  1099,  1100,
    1092,  1109,   461,   853,     0,     0,   341,   345,   346,   344,
     336,   707,   363,   395,     0,     0,     0,   453,     0,     0,
     482,     0,  1085,   919,     0,   347,     0,   387,   326,   401,
     403,     0,     0,   398,   364,     0,     0,     0,   834,     0,
     430,   426,     0,     0,   648,     0,     0,   707,   706,   798,
     799,   796,   797,     0,     0,  1487,  1051,     0,     0,  1053,
       0,     0,  1055,  1057,     0,     0,     0,     0,     0,  1424,
    1266,  1082,  1081,   282,   282,   282,   282,   804,   473,     0,
       0,     0,  1662,  1663,     0,   630,     0,  1389,  1283,  1293,
    1368,     0,     0,  1253,     0,     0,  1288,  2057,     0,     0,
    1320,  1321,  1303,     0,  1919,  1307,     0,     0,  1435,  1224,
    1222,  1219,     0,  1220,     0,     0,  1202,  1198,     0,  1204,
    1229,   993,   992,   991,   990,     0,     0,   980,  1666,     0,
    1454,  1458,  1455,  1667,  1174,   957,     0,  1605,   862,     0,
     707,   395,   687,   775,   745,     0,     0,   511,     0,     0,
       0,     0,   776,   746,   774,   246,   247,   248,   249,     0,
     251,     0,     0,     0,   878,     0,     0,   586,   587,   582,
     287,   310,   298,   303,     0,   304,   299,   302,   471,   470,
     468,   464,   466,  1090,     0,   728,     0,   467,     0,     0,
     333,   395,   369,     0,   338,     0,   839,   324,   452,     0,
       0,   446,   503,   387,     0,     0,   348,     0,   391,     0,
     388,     0,   392,     0,     0,   836,   427,     0,   422,     0,
       0,     0,     0,   650,   657,   657,   682,   664,     0,  1512,
       0,  1060,  1069,     0,  1056,  1054,  1045,     0,  1047,   729,
     526,   528,   718,     0,   633,   282,  1248,     0,     0,     0,
       0,  1299,     0,  1300,  1305,  1308,     0,  1306,  1221,  1225,
    1223,  1206,  1021,  1023,  1457,  1456,   210,  1343,     0,   395,
     359,     0,     0,   517,   506,     0,     0,   522,   283,     0,
       0,     0,     0,     0,   589,   305,   728,     0,   726,   462,
       0,   340,   339,     0,   374,     0,   515,   835,   454,   455,
     450,     0,   391,   353,   351,   355,   352,   350,   354,     0,
     393,   389,   390,   837,   838,   429,   880,     0,     0,   707,
       0,     0,   655,   660,   660,  1079,  1058,     0,  1046,   611,
    1249,     0,  1250,     0,     0,  1310,  1309,   363,   360,     0,
     509,   516,     0,   507,     0,     0,   874,     0,   875,   876,
     879,   725,   727,     0,   367,   368,     0,   342,   370,   371,
       0,     0,     0,     0,   393,   382,   314,   707,   657,   393,
     651,   656,   663,   663,     0,  1068,  1251,  1313,  1301,  1311,
     369,     0,     0,   524,   523,     0,     0,     0,     0,     0,
     372,     0,   373,   394,   514,     0,   458,   315,   393,   660,
    1079,   653,   652,   802,   374,     0,   517,   877,     0,   379,
       0,   378,     0,   375,   376,   504,     0,   456,     0,   459,
     460,  1079,   663,   644,   801,   800,     0,   467,   510,   508,
       0,   377,   380,   381,   440,     0,     0,   645,   654,   784,
     795,   783,   785,   793,   790,   792,   791,   789,   361,     0,
     457,     0,     0,   794,   788,   979,   970,     0,     0,   786,
     795,   458,   787,     0,   441
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    72,   241,   242,   243,  1491,  2093,   244,
     245,   246,   247,   248,   249,   250,   251,   252,  1520,   253,
     254,  1159,  1648,  2208,   255,  2018,   967,  1923,  2145,  1924,
    1925,  1910,  1381,  1383,   256,  1492,  1512,   258,  1376,  1903,
     259,   260,   261,  1548,  1549,  1525,  1550,  1497,  1717,  3560,
     262,   263,  2168,  1595,  2675,  3086,   802,  1592,  3075,  3076,
     264,  1645,  2728,  2729,  2730,  2731,  2703,  3134,  3135,  3136,
    2732,  3425,  3606,  2733,  2026,  2235,  2740,  2741,  3694,  3757,
    3758,  3759,  3813,  3427,  2739,  3162,  3433,  3594,   265,  2725,
    1662,  2233,  2734,  2735,   266,   267,  1537,  2107,  2598,   268,
     828,  3166,  3440,  3618,   269,   786,   270,  1650,   271,   272,
    1657,  2224,  2225,  3418,  3599,  3700,  3816,  3817,  3587,  3387,
    3388,  3389,   273,   274,   275,   276,  2065,  2200,  2201,  3091,
    1482,  1599,  2170,  2171,  3145,   277,  3338,  3339,   829,  3762,
    3743,   278,   279,  3342,  3343,   280,   281,   282,   283,   284,
     875,  1215,  1216,  1486,   285,   286,   896,   897,   898,   287,
    1139,  2664,   288,   289,   909,  2339,   911,  1757,  2811,  2812,
    3223,  2306,  1073,   290,   291,  2315,  2342,   292,   830,  3171,
    3622,  3623,  3723,  2503,  2983,   293,   831,  1516,  2052,  2053,
    2054,  3172,  2055,  3175,  2056,  2751,  2752,  2753,  3179,   294,
    1514,  2046,   295,   296,   297,  2070,  1089,   298,  3688,   299,
    1189,   300,   929,  1775,   301,  2110,   302,   303,   304,  2754,
    3841,  3852,  3853,  3854,  3453,  3826,   305,  3843,   307,   308,
     309,   789,  1108,  1109,  1110,   310,  3438,   311,   312,  2194,
    2195,  2697,   313,   314,  2019,  2539,   315,   316,   317,  1639,
     318,   319,   320,   321,  1117,   322,   323,   324,   993,   984,
    1409,  1948,   325,  1732,   883,   326,  2332,  1256,   327,  1229,
     328,  3844,  1763,  2317,  2318,  2321,  3845,  1683,   331,  1767,
    2326,  2329,  3846,  1938,  1939,  1940,  1941,  1942,  2490,   333,
    1183,  2247,  3847,  1336,   336,   337,   338,  1882,  2467,   918,
    1419,   954,   998,   999,  1953,  1954,  1426,  1968,  1961,  1963,
    3309,  3527,  1427,  1966,  1428,  1429,  2506,   339,  2471,  2251,
    2252,  2253,  2764,  2774,  3190,  3462,  2254,   981,  2255,  2941,
    2260,  2721,  2722,  2057,  2179,  2686,  1620,  1337,  1621,  2186,
    1338,  1806,  1623,  1339,  1340,  1341,  1626,  1342,  1343,  1344,
    1345,  1790,  1847,  1346,  1347,  1825,  1022,  1724,  2379,  1349,
    1350,  3279,  3507,  3498,  2404,  2405,  1916,  3275,  1351,  2457,
    1875,  1091,  1352,  3093,  1877,  2399,  2363,  2008,  2346,  1788,
    2364,  2377,  2857,  2383,  2388,  2880,  2881,  2400,  2426,  1353,
    2350,  2351,  2841,  1792,  1354,  1113,  1114,  1837,  2422,  1412,
    1413,   986,  1355,  1356,  1357,  1758,   982,  3458,  1196,   653,
    2574,  1573,  1577,   915,  1358,  1359,  1360,  1361,  1362,  1363,
    1364,   901,   902,  2301,  3533,  2665,  3114,  1465,  1926,  1365,
     631,   796,   340,   834,   835,   836,  1175,  1176,  1672,  1675,
    1454,  1998,   632,   633,   843,  3455,   341,   342,   343,   344,
    1450,  1994,  1023,    76,    81,    77,  1024,   381,   382,  1976,
     345,   763,  1977,  1431,  1004,  2991,   347,   348,   349,   350,
     351,   878,   352,  1006,   353,  1007,   354,   355,   356,   357,
    1014,   358,  1433,  1434,  3324,  1435,   359,   360,   655,   656,
    1726,  1227,   881,   361,   362,  1040,  1041,  1042,  1242,  1742,
    1243,  1468,  1469,   363,   649,   364,   365,   366,  1747,  1748,
     367,  1896,  1897,  1898,   368,  2804,  2805,   369,  2961,  2962,
    2963,   370,  1892,   371,   372,   975,  2994,   373,   759,   374,
    1054,   634,   635,   636,  1061,   747,   940,   797,  1062,   748,
     749,   750,   638,   639,   640,   641,   642,   643,  1065,   754,
    1743,    78,  2524,  1744,  1366,  1367,  1888,  1368,   646,  1031,
    1219,  1220,  2525,  1222,    79,  1223
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3466
static const int yypact[] =
{
   -3466,   291, 15102, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, 18230, -3466,
   -3466, 42205,   301, -3466, -3466, -3466, 39476, -3466, -3466, -3466,
   -3466, -3466,   191, 46707, -3466, 57494, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, 61535, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, 43108,   634, -3466,   335, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466,   -95,  4076, -3466, -3466,
   49407, -3466,   190, -3466, -3466, -3466, -3466, -3466, -3466, 57943,
   55698, -3466,    32,   341,    94, 10009, -3466, 40847, 48507, -3466,
   -3466, 61984,   537,   105,  5508,   -95, 16872, 50307, -3466,  1447,
   -3466, 37174, -3466, -3466, -3466,   808, 53004, -3466, -3466, -3466,
   -3466,   667, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   61535,  1919,   567, 37640, -3466, -3466, -3466, -3466, 61535, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, 50757, -3466,
     659,   628, 62433, 62882, 52555, -3466,   630, -3466, 61535,   189,
   41756, -3466, 63331, -3466, -3466,   641, -3466, -3466, -3466, -3466,
   -3466,   567, -3466, 43108, 35323, 53902,   850,   796, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
     528, 18590,   809, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466,   883, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466,  1348, -3466,   549,  1384,   829,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, 71862,  1028, -3466,
   -3466, -3466,   843, -3466,   910, -3466, -3466, -3466,   970, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466,   135, -3466, -3466, -3466,
   -3466,  1362, 42656, -3466, -3466, 51207, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, 39933, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466,   102, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, 61535, 61535,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466,  1029, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466,   183,  1228, -3466, -3466, 43108,
    1461,  1461,  1456, 71862, -3466, -3466, -3466, 43558, 61535, 61535,
   61535, 43558, 61535, 53902, 33476, -3466, 61535, 61535, 53902, 53902,
   61535,  1147, 61535, 61535, 61535, 53902,  1271, -3466,  1518,    56,
   -3466, -3466, -3466, -3466,   928,   430, -3466, -3466,  5778,  1919,
   -3466, -3466, 55698,  1207, 43558, 61535,  1129,  1226, 61535, -3466,
   61535,  1305, 61535,  1427,  1582,  1290, 61535, 61535, 61535, -3466,
   -3466,  1281, 61535, -3466, 61535, -3466, 61535,   768,  1314,  1535,
    1468,    40, -3466, -3466, -3466,  1231,  1224, -3466,  1297, 51207,
   -3466, 49857, -3466, -3466, -3466,   713, -3466, 53902, -3466, -3466,
   -3466, -3466, 44008, 61535,  1560, -3466, 63780, -3466, 44458, 64229,
   -3466,  1041,  1654, 64678, 65127, -3466, -3466, -3466, 65576,  1437,
   66025, -3466, 66474, -3466,  1555, 66923, -3466, 15573, -3466,  1338,
    1284,  1355, -3466,   883,  1047, -3466,   124,    55,   278, -3466,
   -3466,   145,   151,   164,  1047,   867, 56147, -3466, 61535,  1591,
   -3466, -3466, -3466, -3466, 51207,  1519, -3466, -3466, -3466,  1548,
    -133, -3466, -3466, 55698, -3466, -3466, -3466, -3466, 55698,   500,
   -3466, -3466,  1919,    27,  1750, 61535, -3466, 61535, -3466, 55698,
   61535, -3466, -3466, -3466,  1772,  1434,  1645, -3466,  1415, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466,  1601,  1627,   -10,  1919,
    1577, -3466, -3466,  1686, 21359,   -86, 51207, 38567, 54351, 70515,
     687, 40847, 67372,  1499,    56,  1705, -3466,   180, -3466,  1898,
    1552,  1783,    67,    56, 55698, 72311, -3466, -3466, -3466, 30746,
   67821,  1676,  1572, -3466,  1847, 21834, -3466,  1597,  1618,   -95,
    1653, -3466, -3466, 55698,  2028,  2028,  2021,  2028,   973,  1038,
     796, -3466, -3466, -3466,  1685, -3466,  1665,  1708, -3466,   201,
    1953, -3466, -3466, -3466, -3466,  1804,  1807,  1815,  1840, -3466,
    1855,  1360, -3466, -3466, -3466,  2081, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466,  2200,  2191, 40847, 40847,  1895,    -4,    90,
   -3466, -3466, -3466,  2079, -3466, -3466,  2077, 61535, -3466,  1933,
   61535, -3466, -3466, 68270, -3466, -3466,  1461,  1685,   928,  1858,
    1183, -3466, -3466,  1243,  1939, -3466,  2134,    -3,  1860,  1120,
      97,  2032,   -82,  3249,  1870,   187,  1036, 61535, 61535, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,  1881,
   -3466, -3466,  1882,   956,  1236,  1033,   483,  2180,  1264,    51,
    2050,   737,   793,  2033, 61535,  1890,  2123,   401, -3466,    -7,
   -3466, 24684, 34417, -3466,   928, 55698, 61535, -3466, 43558,  1925,
   -3466, -3466, -3466, -3466, 43558, -3466,  2121,  2723, -3466, 61535,
   -3466, -3466, -3466, -3466,  2064, 61535, -3466, -3466,  2160, 61535,
   -3466,  1991,  1455,  1943,  2308, 47158, 61535,  1996,  2337, -3466,
   -3466,  2005, -3466, -3466, 61535, 61535,  1952,   835,  2005,  2344,
    2345,  2130,   284,  1077,    52,  2005, 55698, 55698, 55698,  2197,
   61535, 68719, 43558, 61535, 41304, -3466,  1957,  1231, -3466, -3466,
   -3466, -3466, -3466,   815,  2037,  2260,  1858, -3466,  2266,  1976,
    2270, -3466,  2272,  1870,  2273,  1979, -3466, 69168, 69617,  2275,
    1987, 61535,  2298,  1979,  2299,  2193,  2310, -3466,   581,  2311,
    2202,  2321,  1979,   542,  2323,    73, -3466, 16071, 15573, -3466,
   16389,  1342, -3466, -3466, -3466, -3466, -3466, -3466, 24684,   435,
    1108, -3466, -3466, -3466, -3466, -3466, -3466, -3466, 61535,  1591,
    1591,    92, -3466, -3466,  -112, -3466, 54800, 61535, 55249,     9,
     -59, -3466, 61535, -3466,  1284, 47158,  2403, 61535,  2315,  2315,
    2315, -3466, -3466, -3466,  2253, 61535,  2317, 54800, 61535, -3466,
   70066,  2036,  1505,  2027,  1734, -3466, 24684,  2039,   282,   282,
    2041, -3466, -3466,  2043,  2044, -3466,  1755,  1755,  2205,  2048,
    2056, -3466,  1904,  2058, -3466,  2189,  2111,  2060,  2061,  2062,
    1690,   282, 24684, -3466,  2066,  1755,  2067,  2070,  2075,  2248,
    2085, -3466,  2356,  2086,  1439,  1977,  2090,  2099, -3466,  2048,
   -3466,   328,  2100,  2106,  2109,  2112,  2113,  2114, -3466, -3466,
   -3466, -3466, 24684, 24684, -3466, 22309, -3466,  1919, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466,    28, -3466,  2122,  7670, -3466,
   -3466,  2207, 24684, -3466, -3466,   -28, -3466,   928,  2290, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,   108,   365,
     365,   125, 49407, 49407, -3466, -3466,   762,  2074,  1359, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, 40390,  2439, -3466,  2096,
      -7,   813,  2399, 35776, 36242,  1591,  1591,  2346, -3466, -3466,
     122,  2335, 55698, -3466, 61535, -3466, 32097, -3466, -3466,   883,
   -3466,  9449, -3466,   694, -3466, -3466, -3466,  2118, -3466,   528,
     528, 24684,   528,   -48, 22784, 24684,  2404,  1113,  2406, -3466,
   -3466,  1685,  2132,  1170, -3466, 51657, 71413, 71413,  2372, -3466,
   -3466,   839,   664,  2250,  2339,    63,  1374, -3466, -3466, -3466,
    2125, -3466,  2453, 49407,  2206, 40847, -3466, -3466,  2581, -3466,
    2581, -3466, -3466, -3466, -3466, -3466, -3466,  2605, -3466,  2136,
   -3466, -3466, 71862,  2144, 61535, -3466,  2147,  2148, -3466, 72311,
     928, 34870,   991,  2234,  2238, 43108,  2154,  2240,  2243, 70515,
   -3466, -3466, -3466, -3466,    71,   783,   459, -3466,  2244,  2341,
    1360,  2288, -3466,  2251,  2256,  2370,  1360,   746, 70964, -3466,
   -3466, -3466, -3466, -3466,  1951, 19958, -3466, -3466, -3466,  2276,
    2259,  2278,  2279,  1952,  -109,  2196, -3466,  2262,  2263, 45358,
   33946,  2063, -3466,  2283,  2285,  2292,  2330,  1420,   123,  2562,
    2388,   902,   200,    72, 55698,  2465,    59,   798,  2208, -3466,
   -3466,  2296,  2301, 61535, 61535, 61535, 61535, 53902,  2305,  2351,
    2316,  2063, -3466,  2319,  1274, -3466,  1205, -3466, -3466,    56,
   -3466,  3746, -3466, -3466, -3466, -3466, -3466, -3466, -3466,  1858,
   47158,  1870,  1360, 61535, 61535,  2228,   998,   648,  2410, 61535,
    2473,  2418,   373, -3466, -3466,  2005, -3466, 34870,  1952, -3466,
    2241, -3466,  2307,  2307,  2307,  2242,  2242,  2258, -3466, -3466,
    1690,  2307,  2242, -3466, 48958, -3466,   999,  1004, -3466,  2642,
      79, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
     611, -3466,  1523, -3466, -3466, -3466,  2660,   795, -3466, 47158,
    2063,  2583,  2333, 43108, -3466,  2328,  2063, 61535,   615, 61535,
    2494, 61535, 61535, 61535, 61535, -3466, -3466,    54,   -23, -3466,
    2063, -3466,  2665,   -60,  2280, 40847,  2564, 61535,  2461,  1870,
    2675, -3466, -3466,  2291,   867, -3466,  1957, -3466,  1422, -3466,
    2419, -3466, 27994,  2347, 43558,   179, -3466, 47158, 61535, 43558,
     179, 61535, 61535,  2590,  2369,  2599,  2375, 33946, 45358,   132,
   61535, 61535, 55698, 61535, -3466, -3466, -3466, -3466, 61535, 55698,
   61535,  2600,   179, 61535, -3466, -3466, 61535, -3466, -3466, 16139,
    1521, -3466, -3466, 15573,  9449,  1076, -3466,  1591,  1029,   362,
   61535, 51207, -3466, -3466, -3466, -3466, -3466, -3466, -3466,  1591,
   -3466, -3466,  2775,  2312, -3466,   108,   867,  2313, -3466,  2327,
   61535, 43558, 61535, 61535, 55698, 55698, 61535,  2401,  2074,  -146,
   -3466,  2381, 31648,  2458, -3466,   540, 55698,  2513, -3466, -3466,
   -3466,  1126,    25,  -123, -3466, -3466, -3466, -3466, -3466, -3466,
   53004,  2604,   -32, 61535, -3466, 24684, 23259, -3466, -3466, -3466,
    2331,  9449,  2379, 24684, -3466, -3466, 24684,   867,   867, 24684,
   -3466, -3466, -3466, -3466,  1103,   867, -3466, 24684, 24684,   867,
     867,  2307,  2307, -3466,  3085, 24684, -3466, 33946, 24684, 26109,
   19482, 24684,  2415,  2425,   867, -3466,   867, -3466, 24684, 20884,
   -3466, 24684,  2549, 24684,   813,  2550, 24684,   928,  2750,  2750,
     796,    41,  4355,  2338, -3466,  2459,   867, -3466,   867,   642,
   47158, 24684, 43108,  2431,   103, 24684,  2348,  2223, -3466, 24684,
     155, -3466,  2349, 24684,  2430,   144, 24684, 24684, 24684, 24684,
   24684, 24684, 24684, 24684, 24684, -3466, 26584,   165,   594,   331,
   47607, 21359,  2628, -3466,  1504, 19006, -3466, 51207, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466,   867,  2352, -3466,  2365, -3466,
   -3466, -3466, -3466, -3466,  2439, -3466, -3466,  2434, -3466, -3466,
   -3466,  2264, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466,  2354, -3466, -3466, -3466, -3466, -3466,  2354,
   -3466, -3466,  1591, -3466, 71862,  2355, -3466, 61535,     5, -3466,
   -3466, -3466,  2368, -3466, 53453, -3466, 21834, 61535, -3466, -3466,
    2601, -3466, -3466,  2360, -3466,  6790,  2601,  2539,  2552,  2552,
   -3466,   -90,  9449,  2595,  9449, -3466, -3466, -3466, -3466,   994,
   -3466,  1188, -3466, -3466,  1685,  2373, 17324, -3466, 17777, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466,  1360,  2385,  2818, -3466, 40847, -3466, -3466,
   51207,  1682,  2373, 15573, -3466, 15573,  2373,  2391,  1138,  2472,
    2476,  2519, 61535, 61535, -3466, 43108, 61535, 61535, -3466,  2745,
    2397, 61535,  2633,  2635,  2405, -3466, -3466, 61535, -3466,  2589,
   24684,  2591, 61535, 61535,  2594, -3466,   788, 61535, 61535,  2592,
   -3466, -3466, -3466, 61535, -3466, -3466, -3466,  2584, -3466, -3466,
   48958, -3466,  1141, -3466, 48058, 44908, -3466, -3466,   172, 61535,
   61535, 61535, 61535, -3466, 61535, -3466,  1105, 61535, 61535,  2408,
    2412,  2409, -3466, 61535,  2636, -3466, -3466,  2582,   509, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466,   780, 61535, -3466,   867,
    2585, 61535,  2484, -3466, 61535, 61535, 61535, 61535,  1360, -3466,
    2793,  1360,  1360,   822,  2796,  2005,  2005, -3466, -3466, -3466,
   61535, 61535, 61535, 61535, 56596, 61535, 61535,   909,  1095, 61535,
   57045, -3466, 55698, 61535, 61535, 61535,   138,  1539, 61535, 61535,
     274,   447,  2568,  2569,  2570, 61535, 61535, 61535, -3466, 61535,
    2512,  2514,    84,  2587, -3466, -3466, -3466, -3466, 24684,  2677,
    2829,  2680,  2682,  2508,  2509, 45358,   606, 61535, 61535, 61535,
   61535, 61535, 61535,  2685,   606, -3466, -3466, -3466,  1455, -3466,
    1239, -3466,  2460, -3466, 24684,    87, 47158,  2450, 29812, -3466,
    2533, -3466,  2534,   867, -3466,  1558, -3466,    54,  2678,  2468,
    2468,  2468,  2468,  2468,   795, -3466, -3466, -3466,  2739, 61535,
    1248, -3466,  2470, 55698, -3466, -3466,  1683, 53004, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466,  1275,  1952,  1952,  1952,
    1952, -3466, -3466, -3466,  2637,  2634,  2462, 61535, -3466,  1420,
    2754, 55698, 52106,  1631, 61535,  2852,  2734,  1919,  2645, 55698,
    3653, -3466, 41304, -3466,  2474,  2742,  2743,  2756, -3466, 27534,
   58392,  2477,  1067, -3466, 58392, 58841, -3466,   928,  2480, 23734,
    2458,  1858, -3466,  2876, -3466,  1870, -3466,  1979, -3466, 61535,
   61535, 61535, 61535,  2489,  2492, -3466,  1979,  2673,   179, -3466,
    2674,   179,  1979,  1919, -3466,    73, -3466, -3466, -3466, -3466,
   -3466, 24684, -3466, -3466,  2593, -3466, -3466, 51207,  1297, -3466,
   -3466,  1297, -3466,  1297,  2965,  1979,  2491, -3466,  1979,  1979,
    2074,  2074,  1979, 59290,  2900,  2772, -3466,  1292, -3466, -3466,
   21359, -3466,    66, -3466,   239,   306,  2713, -3466, -3466, -3466,
   -3466, 47158, -3466, -3466, -3466, -3466, -3466, 61535,  2681,  2497,
   59290,  2878,   179, -3466,  1293,  1044,  1091, -3466, 24684, 24684,
      42, -3466,  7829,  1302,  2506,  2507,  1303, -3466, -3466, -3466,
   -3466, -3466, -3466,  2510,  2787, -3466, -3466,  2511,  1311,  1350,
    2515,  2518, -3466, -3466,  3902,  2520,  8090,  2521, 26109,   211,
   -3466, -3466, 26109,  2522, -3466,  1404,  7080,  2503,  2525,  2547,
    2548,  2527,  2530,  8633, 24209, 24684, 24209, 24209,  8839,  2503,
    2532,  1409, 43108,  8809,  1428, -3466, 24684, 43108,  3942, -3466,
   -3466, 24684, 61535,  2535,  2536, -3466, -3466,  3085, -3466,  2554,
   -3466, 26109, 26109,  5105, 22309, -3466, -3466,  2812, -3466, -3466,
    1249, -3466,  2538, -3466, -3466,  5635,   128, 24684,  2348, 24684,
    2598, 33946,  8116, 24684,  3875,  4510,  4510,   118,   118,    60,
      60,    60,  1318,   331, -3466, -3466, -3466,  2540,  2085, 24684,
   -3466,  2998,  1848,  1880, 55698,  5042,  9375, -3466, -3466, -3466,
   27994,  2602, 24684, 24684,  2541, -3466,  1443, -3466, -3466,  2937,
    2965,   867,    56,   867,   642, 36708, -3466,  2373, -3466, -3466,
    1450, 32097,  2347, 21834,   928, -3466, -3466, -3466,  1465, 24684,
   -3466, -3466,  2192,  1643, -3466, 61535,  2513,  2513, 24684, 24684,
   22784, -3466, -3466,  2544, -3466, -3466, -3466, -3466, -3466,  2546,
   -3466, -3466, -3466,  2989,  2542,  2537,  2553,  2555, -3466, -3466,
   61535, 61535, 61535, -3466, -3466, -3466, -3466, -3466,  2778, -3466,
   24684,    68,  2556,  2559, 61535,   179, -3466,  9449, -3466, -3466,
   -3466,  2804, -3466, -3466, -3466, -3466,  2735, -3466, -3466,  1523,
   -3466, 44908, 48058, -3466, 48058, -3466,  1523,  1176, -3466,  1979,
   -3466, -3466, -3466, -3466,  1277, -3466,   156, 47158,  2727, 45808,
    1979,  1047,  1275, 61535, 61535, -3466, -3466,  1979, -3466,  1275,
    1979,  1275, -3466, -3466, -3466, -3466, -3466, -3466,  1360, -3466,
   -3466, -3466, -3466, -3466, 61535,  1360,  1360, -3466, 47158,   514,
   -3466, -3466, -3466, -3466, -3466,   179,   179, 61535, 61535, 61535,
   61535, -3466, -3466, -3466, -3466, -3466, -3466,  2644, -3466, -3466,
   -3466,   834, -3466, -3466, -3466,  2780,  2781,  2782,  2650,  2653,
    2655,  2656, -3466,  2657,  2658,  2659, -3466, -3466, -3466, -3466,
   61535, 61535, -3466, -3466, -3466,  6506,   606, 47158,   606,   606,
   61535, 61535,  2561, -3466, -3466, -3466,  2816,  2817,  2819,  2821,
    2823,  2824,   606, -3466,   126,  1584, -3466,   713, 33006,  4430,
    2596, -3466,  2578,   867,  2373, 30286,  1751, -3466, -3466, -3466,
      30,  2803,  2597, -3466,  2773,  2468, -3466,   356,   371, 59739,
   60188, 60637, -3466,  1522,  2670, -3466, -3466, 43108, 33006,  2280,
     615,  2737,   887, -3466, -3466, -3466, -3466, -3466, 55698,    54,
    1919,  1474, -3466, 47158, 51207,   528,  2603, 55698,  2606,  2608,
   -3466, -3466, -3466, -3466,  1482, -3466, 47158,   349,  2779,  2783,
    1490, -3466, -3466,   528, 61535,  2689, 55698,  2666,  1919, 40847,
   46258,   908, -3466, -3466,  2786, -3466, 61535, -3466, -3466, 31195,
   29363,  1067,  2611, 61535, -3466,  2609, 27994,  2849,  2788, -3466,
   27994,  2788,   974,  2788,  2856, -3466, 32546, -3466,  2616,  1589,
   19006,  2809,  9449, -3466,   179, 47158,   179,  2691,   179,  2692,
     179, 45358,   179, 55698, -3466, 55698, -3466,   179, -3466,  9449,
   55698,   961, -3466, -3466,  2623, -3466,  2652, -3466, -3466, 43558,
   61535,   270, -3466, -3466,  2806, -3466,   528, 61535,   928,  2625,
   -3466, -3466, -3466, -3466,  2935,  2938, -3466, -3466, -3466, 54800,
     143, 61535, -3466, -3466, -3466, -3466,  2639,  1506,  9363, 24684,
   -3466,  2941, 47158, -3466, -3466, -3466, -3466, -3466, 24684, -3466,
   -3466, -3466, -3466, -3466, 24684, -3466, 24684,  2922, -3466,  3053,
   47158, 26109,  1168,  2067, 27059, 26109, 26109, 26109, 26109, 26109,
   26109, 26109, 26109, 26109, -3466,   428, -3466, -3466, 24684, 24684,
    2931,  2922, -3466, -3466, -3466,  1816,  1816, 47158,  2649,  2503,
    2651,  2661, 24684, -3466, -3466,  1510, 43108, -3466, 24684,  7372,
    1528,  2708,   928,  4930, -3466,  3018,  1919, 24684,   255,  1545,
   24684,  1546, 24684,  2934, -3466, -3466, -3466,  2664, -3466, -3466,
   47158, 24684, 26109, 26109,  5952, -3466,  6020, 24684,  2667,  6746,
   22309, -3466,   567,   567,   567,   567, -3466, 55698, 55698,  2477,
   24684,  2928,  1578,  1583, -3466,  1275, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466,  2662, -3466,  2672, -3466, -3466,    -7,  2669, -3466, -3466,
    2989,  2679, 61535, -3466,  2458, -3466, -3466, -3466,  2676, -3466,
    1643, -3466, -3466, -3466,  1979, -3466, -3466, -3466, -3466, -3466,
    2683,  2686, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466,  2468,  5014, -3466, 61535, 61535,  1595, -3466, -3466,  2909,
    1218, -3466, -3466, -3466,  2746,  2748,  2758,   738,    64,  2762,
    2763, -3466,  2764, -3466, -3466, -3466, -3466,  1979,  1979, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466,    91,   482, 47158, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, 61535,  2966,   673,  1061,
   61535, 61535, 61535, 61535, 61535, 61535, 61535, -3466, -3466, -3466,
   -3466,  2684, -3466, -3466,  2921,  2923,  2925,   606,   606,   606,
     606,   606,   606, -3466, -3466,  2005,  3004, -3466, -3466,  2337,
    2337,   692, -3466,  2337, -3466,  2337, -3466, -3466,  2460,  2676,
    1374, -3466, -3466, -3466, -3466, -3466,   935,   867,  1937,  2693,
   -3466,  1623, 30286, 30286, 30286, 30286, 30286,  2373,   642, 55698,
     867, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466,  2694, 61535, 26109, -3466,   905,   109,
   -3466,  2926, 55698,  2747, -3466, -3466, -3466, 47158, -3466, -3466,
    3088,   362, 55698,  2985,  2877,  1599, -3466, -3466, 61535, -3466,
    1355, -3466, 52106, -3466,  2957, 52106, -3466, 61535, -3466, -3466,
   -3466,  3060,  2811, -3466, 61535,  1509,  2774,  1860,  1919,  2666,
   61535,  2721, -3466,  2715, -3466,  3957, -3466,  1952, -3466, -3466,
      50,  2749, -3466, -3466, 58392,  2725, 61535,  1067, 27994, -3466,
   -3466,  1969, -3466, 27994,  2962, -3466, 27994, 61535,  2728, 61535,
    1600, 39017, -3466,  2726, -3466, 61535, -3466, 61535, -3466,  2729,
   -3466,   179,   179, -3466,  3120,  2732,  1422,  1297,  2937, -3466,
   -3466,  3006, 59290, -3466, -3466, -3466, -3466, -3466, -3466,  3012,
   -3466, -3466, -3466, -3466, 24684,  9449, -3466,  2736,  9449,  5136,
    9449,  2931, -3466,  2001,  3013, -3466,   854,  2738,   428,  2001,
     879,   879,   127,   127,    82,    82,    82,  3053,  9449,  9449,
   -3466, -3466, -3466, -3466,  2744, -3466, -3466, -3466,  2503, -3466,
   25159, -3466, -3466,  2794,  2798,  2757, -3466, 24684, 25634,  2752,
   -3466, -3466,   642,  2750, 26109, 26109,  1802, -3466,   241, 24684,
   47158,  1620,  1802,  1646,  1658, 24684, 24684,  7803,   197, 24684,
    5473, 55698, 55698, 55698, 55698, -3466, -3466,  9449,  3109,  3017,
   -3466, -3466, -3466,  2937,  2318,  1919, -3466,   796, -3466, -3466,
   33946, -3466, -3466, 15573, -3466,   867, -3466,  1621,  1622,  2747,
   -3466,  2825, -3466, 61535, 61535,   867,   867, 47158,  2755, -3466,
     867,   867,  2760, -3466, 61535, 61535, 61535,  1522,  2945,  2949,
     867, 61535,  2814, -3466, 61535, 61535, 61535, 61535,  3055, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466,  3007,   606,   606,   606,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466,  1919,  1919,  1275,
    2953, 61535,  1919,  1275, -3466,  1083,  3090, -3466,  3023,   469,
    2776,  3048,  3049, -3466, -3466,  1556,  1556, -3466, -3466, -3466,
   -3466, -3466,  3052, -3466, 24684,  1133,  2001, -3466, -3466, -3466,
   -3466,  2747,  2280,  2840,  2843,   528,   134,  3084,  3074,    54,
   -3466,  1919, -3466, -3466,  2784,   131,  2791,  1631, -3466, -3466,
   -3466,   691, 61535, -3466, -3466,  3146,  3148,  2968, -3466, 61535,
    3028,  2154,  3073,  2799, -3466, 28454,  1919,   908, -3466, -3466,
   -3466, -3466, -3466,  2881, 61535, -3466, -3466, 61535,  1669, -3466,
   24684,  2800, -3466, -3466, 27994,  1969,  1672, 61535,  1692, 47158,
   -3466, -3466, -3466,   179,   179,   179,   179, -3466, -3466,  2754,
   61535,  3086, -3466, -3466,  2980, -3466, 59290,  9449, -3466, -3466,
   -3466, 26109,  3087, -3466,  2810, 26109, -3466,  2813,  1693,  1694,
   -3466, -3466, -3466,  5759,  2866,  9449,  2918,  2815, -3466,   222,
     222,   241,  1695, -3466, 26109, 26109,  1802,  1802, 24684,  1802,
   -3466, -3466, -3466, -3466, -3466, 24684, 24684, -3466, -3466,  1374,
   -3466, -3466, -3466, -3466,   642, -3466,  2820, -3466, -3466,  2960,
    2747,  2840, -3466, -3466, -3466, 28914, 33946, -3466,   738,  2827,
    2828,    64, -3466, -3466, -3466, -3466, -3466, -3466, -3466, 24684,
   -3466,   571,   556,  2864,  1979,  3100,   606, -3466, -3466, -3466,
    1584, -3466, -3466, -3466, 61535,  2822, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, 43558,  3208, 55698,   935,  6064,  3008,
   -3466,  2840,  3038,  3080, -3466, 61535,  1509, 52106, -3466,  1240,
    2977, -3466, -3466,  1631,   954,   967, -3466, 55698,  2783,  2958,
   -3466,  2963, -3466,  3011,  3014, -3466, -3466,  1919, -3466, 61535,
   28454, 24684,  1697, -3466, 61086, 20407, -3466, -3466, 55698, -3466,
    1704, -3466,  9449, 61535, -3466, -3466, -3466,  1718, -3466, -3466,
   -3466, -3466, -3466,   528, -3466,   143,   462, 26109, 26109,   170,
   24684, -3466, 24684, -3466, -3466, -3466,   393, -3466, -3466,   222,
     222,  1802,  2503,  9449, -3466, -3466, -3466, -3466, 55698,  2840,
   -3466, 47158,  1870,   348, -3466, 47158, 47158, -3466,  9449, 61535,
   61535, 61535, 61535, 61535, -3466,  2822,  3208,  3218, -3466, -3466,
    3123, -3466, -3466,   736,  3015,  2936,  3128, -3466, -3466, -3466,
   -3466, 61535,  2783, -3466, -3466, -3466, -3466, -3466, -3466,  1747,
    2811, -3466, -3466, -3466, -3466, -3466, -3466,  1758,  6446,  2747,
   28454, 61535, -3466,   185,   185,  2602, -3466,  1778, -3466, -3466,
     462,   891, -3466,  1782,  1798,  2903, -3466,  2280, -3466,  1799,
   -3466, -3466, 45358, -3466,  1800,  1809,  2837,  2897,  2837, -3466,
    1979, -3466, -3466,  3154, -3466, -3466,    61, -3466,  3029,  3030,
   61535, 61535,  3242,  2855,  2811, -3466, -3466,  2747, 61086,  2811,
   -3466, -3466,  1643,  1643,  3165, -3466, -3466, -3466, -3466, -3466,
    3038, 43558,  2857, -3466, -3466, 61535,  2986,   166,   166,  2927,
   -3466,  3177, -3466, -3466, -3466,   738, 38107, -3466,  2811,   185,
    2602, -3466, -3466,   627,  3015,  1870,  3009, -3466,  3158, -3466,
    3269, -3466,   502, -3466, -3466,  2755,  1813, -3466,  2306, -3466,
    1276,  2602,  1643, -3466, -3466, -3466,   794,   935, -3466, -3466,
    3019, -3466, -3466, -3466, -3466, 38107, 24684, -3466, -3466, -3466,
     800, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, 43558,
   -3466,  1852,  1656, -3466, -3466,  1826,  1618,  2868,  1275, -3466,
     800, 38107, -3466,  1872, -3466
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3466, -3466, -3466, -3466, -3466,  3108, -3466, -1075,  -167, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466,  1143, -3466, -3466,  -124,   116,  1956, -3466,   866,
   -3466, -3466, -3466, -1339, -3466,   589,   436, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466,  1225, -3466,  -996,   744,  -254, -3466,
   -3466, -3466, -3466,  1186,   -20, -3466, -3466, -3466, -3466, -3466,
   -1597,  -135,   203, -3466,   213,  1259,   323, -3466,   -35, -3466,
   -3466, -3466, -3466,  -242,   831, -2621, -2466,   209,  -402,  -425,
    -377,  -375,  -404, -3466, -3189, -3336, -2321, -3276, -3466, -3466,
     587, -3466, -3466,   232, -1587, -3466,  1731, -3466, -3466, -3466,
   -3466,   -46, -3466, -3466, -3466,    -6, -3466, -3466, -3466, -1581,
   -3466,  1209, -2623, -3466, -3466, -3466,  -464,  -436, -3466, -3298,
      11,    10, -3466, -3466, -3466, -3466, -1141, -3466,   695,   693,
   -1077, -3466, -3466,   727, -3466, -3466,  -390,  -142,  1766, -3466,
    -398, -3466, -3466, -3466,  -141, -3466, -3466, -3466, -3466, -3466,
   -3466, -1701,  -671, -1592, -3466, -3466,  3226,   826,   600, -3466,
   -3466, -1786, -1578, -3466,  -173,  1032,  2163, -1230, -2287,   192,
   -3466, -3466, -1718, -3466, -3466, -3466,  1097, -1577, -3466,   244,
    -204,  -303, -3363, -2302, -2906, -3466, -3466, -1191, -3466,   857,
    1365, -3466,  1367, -3466, -1938,   247,  -948, -2649, -3032, -3466,
   -3466, -3466, -3466, -3466, -3466, -1691, -1513, -3466,  -263, -3466,
   -3466, -3466, -3466,   863, -3466,   219, -3466, -3466, -3466, -3466,
   -3466, -3466,  -401,  -434, -3466, -3466, -3466,   668, -3466, -3466,
   -3466,  1253, -1084,  -923,  2451, -1573,  -169, -3466, -3466, -3466,
    1237, -2041, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -1137,
   -3466, -3466, -3466, -3466, -3466, -3466,  1488,  3275,  -775, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,  2209,   285,
   -3466,   -64, -3466, -3466,   623, -2165,   -49, -3466, -3466, -3466,
   -3466,  -117,   -43, -3466,   951, -3466, -3466, -1858, -3466,  2215,
    1151,   231,   -72,   -21,  -239,   173,   552, -3466, -3466,  -199,
    1323, -3466, -3466, -3466, -3466,   949,  2022, -3466,   940,  -113,
   -3466, -3466,  2026, -3466, -3466,  2029,  1497, -3466,  1520,   989,
   -2201,  1212, -2162,   696,  -437,     1,  -175,  2624, -3466, -3465,
     971, -2948,   325,  -409, -1917, -2521, -1488, -3466, -3466, -1172,
    6046, -3466, -3466, -3466,  6596,  8016, -3466, -3466,  9239,  9685,
   -3466, -1106,   569, 11519,  3107, -1276, -1610, 12191,  1008,   626,
   -1560, -3466, -3466, -3466,  -172,   577,  1649, -3466,  1055, -3466,
    -758, -3466, 12440,   978, -3466, -1021, -3466, -1252, -3466, -1709,
   -3466, -3466, -3466, -3466, -3466, -1570, -2723,  -626,  1046, -3466,
   -3466,  1135, -3466, -3466, -3466, -1055, -1009, -1830,  1052, -1846,
   -3466,  -991,  1169,  1619,  5878,  -914,  2195,  -829,  7672,  -139,
   -1970, -1380, -1060, -3466,  -578, -3466,  7643,   158, -3466, -3466,
      -2,   129,   920, -1849, -3466,   -18, -3466,  -957, -1001, -2740,
     193, -3466, -3466,  2904,   747, -3466,  2334, -3466,  1262,  1831,
   -3466, -3466,  1511,  -901,   -65, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466, -3466,  2073,
     119, -3466,   -57, -3466, -3466, -3466, -3466, -3466,  3164,  -321,
   -3466,  2640,  -311, -3466, -3466, -3466, -3466, -3466, -3466, -3466,
   -3466, -3466,  2082,  1540, -3466,  2463, -3466, -3466, -3466,   -68,
   -3466,  2261,  -143, -3466, -3466, -3466, -1119,  1372,  2483,  -898,
    -885,  1517, -3466, -3466, -3466, -3466, -3466, -3466, -3466,  1219,
   -3466, -3466,  1043,  1220, -3466, -3466,   308, -3466, -3466,   214,
     310, -3466,  2159, -3466, -3466, -3466,   561, -3466, -3466, -3466,
    -596,  8655,   100,  -104,   -52,   543, -3466,  2932, 11539,  -714,
      13,  2097,  5543, 11068,   -83,  -102,   -66,    89,   230, -1543,
   -3466,  3152,  1529,  1242,  -958,  9973,  1790,  4411,    -9,  -797,
   -1102,  2324,  -715, -1704, -3466,  3540
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1996
static const short yytable[] =
{
      75,   988,  1690,  1771,  1250,   844,   334,  2274,   832,  1430,
     827,   745,  2285,   753,   329,  1644,  1090,  2072,  1531,  2289,
    2184,   346,   974,  1659,   384,  1570,  1001,  1561,   654,   330,
    1195,   947,   752,  2307,  1203,   332,  1002,  1781,  1466,  1827,
    2185,  1390,  1179,  1212,  1377,  1046,  2479,  1906,  2761,  1480,
     980,  2209,   745,  2830,   753,   923,  1156,   335,  2513,  1575,
    1400,  2210,   787,   746,  1449,   654,  1598,  2211,   630,   379,
    2212,  2213,   379,   752,  3321,  2214,  1640,  2347,  3006,  2489,
    1526,  1470,   837,  1646,   629,  2523,   966,  1398,  3140,  2527,
    1660,   376,  2775,  2777,   376,  2783,  3144,  1067,  2576,  1070,
    2497,  3413,  3178,  1200,   746,  2014,   379,  1244,  1230,  1685,
    1727,  1668,  1101,  2494,  1800,  1801,  2563,  2565,  1721,   745,
     942,   753,  2256,   803,  1034,  1513,  2175,   942,  1463,   942,
    1463,  1887,  1850,  1816,  1456,  1457,  1894,   943,   838,  1148,
     752,  1467,  1658,  1845,   943,   833,   943,   379,   874,  2698,
    2699,  2700,  2701,  1164,  2860,  1853,  2117,  3260,  2226,  1371,
      74,  1765,  1221,   916,  3101,  1055,  1761,   377,  2177,   334,
     377,   746,  1794,  1795,  1494,  2341,  2680,   329,   375,   629,
    1553,   375,  1714,  2108,  2273,  2020,   848,   152,  2020,  1059,
    1850,  1268,   330,  1074,   945,  1813,   801,  2420,   332,  2860,
     383,   945,  2021,   945,   377,  1232,  2470,  1725,  2508,  1043,
    1880,  2652,  3449,  1853,   379,   375,  2221,  1554,  2839,   987,
     335,   647,  2420,  3787,  -979, -1329,  1143,  1438,  1254,  2705,
   -1425,  1714, -1329,  3017,  1460,  1106,  2231,  -979,  3608,  2415,
    2020,  1714,  2860,  1172,  1981,   377,  2454,  2108,  2028,  3466,
    2820,  3468,  1714,  2455,  2021,  2436,   375,   171,  2681,  2629,
    3774, -1117,  3724,  1247,  1517,  3670,  2022,  3340,  3409,  2022,
     952,  1495,  3710,  2337,  1186,  3809,  2500,  -979, -1345,  2064,
    1193,  1957,  3450,  2860,  2314, -1345,  2222,  1015,  1714,  3690,
    -313,     3,   944, -1875,  2860,  -979,  1982,  3541,  1106,   944,
    2788,   944,  2790,   764,  2375,  1241,  1570,  1746,   378,  1483,
    1369,   378,   377,  1850,  1843,  3692,  3604,   385,  1958,   938,
    1030,  2022,  1107,   375,  2108,  1028,  2236,  2860,   972,  1988,
    3018,  2115,  1989,   798,  1484,  3823,  1853,   765,   379,  -979,
    1692,  1827,  3284,   628,  1728,   378,   788,  -979,  1884,  1016,
    2501,  2635,  3605,  1248,  1740,  1741,  3837,  2636,   953,  1234,
     376,  1518, -1819,  1692,  1555,  1959,  3764,  3341,   209,  1585,
    1643,  2437,  1699,   379,   760,  2438,   761,  3348,  2673,  3591,
    1370,  1392,  2063, -1902,   209,  1107,   378,  1983,  1912, -1918,
    2151,  2023,  1173,  3738,  2023,   376,  2509, -1150,  1574,  1485,
    3410,  1017, -1944,  1850,  1018,  3799,  1527,  1528,  2439,  3451,
    2862,  1458,  2118,  1651,  3702,  3627,  1715,  1044,  1759,  2232,
    1990,   648,   849,  2822,  2119,  1575,  1853,  1766,  1773,   227,
    2231,  2861,  2821,  1800,  1801,  1439,   377,  2630,   225,  1782,
    1816,  1556,  1057, -1145,  3810,   227,  2023,   375,  2637,  -979,
    1652,  2862,  1002,   378,  1692,  2123,  2227,  2173,  1881,   832,
    1478,  1496,  2862,  3452,  2662,  1715,  2567,  2223,  3019,  2349,
    1883,   377,  2120,  2863,  3788,  1715,  1248,  2024,  2240,  1569,
    2024, -1996,   375,  1641,  1642,  2146,  1715,  2421,  1762,  2818,
    2653,  2491,  1019,  3020,   850,  2862,   851,  1794,  1795,  1666,
    2860,  1027,  2149,  1720,   240,  1813,  1255,  1846,  3669,  3811,
    1930,  1931,  2922,  3111,  2863, -1329, -1877,  1035,  3490,  3637,
    2169,  1414,  1715,  2440,  1519,  2863,  1694,  1696,  3116,  3848,
    3812,  1643,  2024,   837,  2860,  1874,  2456, -1875,  3327,  3328,
    1579,  3074,    49,  2035,  1895,   628,  1581,   628,  1265,  2040,
      52,    53,    54,    55,  1999,    56,  2178,  2873,  2863,  1716,
    1467,  1446,  2175,   628,  2178,  3187,  2045,   811, -1345,  3191,
    2970,  1857,  1858,   240,  2166,  1036,  1393,   378,  1020,   628,
    2902,  3395,  3396,  3397,  3398,  3399,  2638,    55,   764,   838,
    1871,  1872,  1873,  1874,  1669,   895,   833,  1653,  1076,  2870,
    2871,  2872,  2873,  1095,  1097,  2823, -1819,  2238,  1766,  2293,
    1103,  2639,   378,  3597,  1021,  2322,  2030,  1721,  1692,   813,
    1861,   762,   765,  2864,  3012,  2152,  3013, -1902,  3384,  3222,
    1069,  1071,  2965, -1918,  1944,  2535,  2865,  2866,  2867,  2030,
    2868,  2869,  2870,  2871,  2872,  2873, -1944,  2975,  3158, -1117,
    3732,  1799, -1117,  1485,  3110,   745,  2824,   753, -1117,  3832,
     755,  1265,  1890,   799,  2864,  1394,  1891,   257,  2862,  1147,
     756,  3735,   980,  1241,  1654,  2864,   752,  2865,  2866,  2867,
    3741,  2868,  2869,  2870,  2871,  2872,  2873,  3769,  3036,  2256,
    3064,  3065,  2868,  2869,  2870,  2871,  2872,  2873,  1181,   879,
    3221,   889, -1996,  1567,  1789,  2372,  2373,   746,  2864,  3824,
    1704,  1869,  1870,  1871,  1872,  1873,  1874,  1191,  2583,  2825,
     890,  2865,  2866,  2867,  2323,  2868,  2869,  2870,  2871,  2872,
    2873,  1115,   994,   628, -1150,  3798,  1619, -1150,   847,   764,
    3092,    55, -1150, -1150, -1150,  2031,   306,  1705,   757,   895,
     379,   819,  2206,   820,   379,  3386,  3222,  1711,  1066,  2640,
   -1877, -1150,  1066,  2180,  2344,  2345,   976,  3100,  3349,  2167,
    3092,  1574,  1090,   765,  1030,  2353,   376,  2158,  2356,   925,
   -1145,  1140,  2409, -1145,  2641,   995,  2368,  2369, -1145, -1145,
   -1145,  3592,  1138,  3833,  2180,  1066,  3601,   629,  3178,  2385,
    2387,  1869,  1870,  1871,  1872,  1873,  1874, -1145,    49,  3319,
    2401,   628,  3176,  2032,  2159,  1226,    52,    53,    54,    55,
   -1070,  2207,  1169,    49,   904,  1016,   628,  3742,  1643,  1575,
     257,    52,    53,    54,  1568,  1379,  1182,  3736,  1388,  1030,
    2310,  2311,  2292,  1066,  1380,  1116,  1770, -1070,   377,  1066,
    1039,   926,   377,  3609,  2296,   996,  1016,  2584,  3350,   375,
    3825,  3351,  2267,   375,  2476,  3610,  3801,  3802,   758,  3355,
    3060,  2276,  3062,  3063,  2968,    75,   942,  1017,  3037,   942,
    2181,  2282,  2130,  2131,  2132,  2133,  3073,   209, -1917,  1374,
    2324,  1030,   654,   943,  1706,  3680,   943,  2663,  2868,  2869,
    2870,  2871,  2872,  2873,  1253,   913,  2325,  2041,  1017,   306,
    2256,  2181,  2153,  2154,  2027,  3575,  3838,  1677,  2163,  3038,
     629,  2305,  1901,  2308,  2309,  2188,  1643,  2312,  2928,  2202,
    1984,  1269,  2868,  2869,  2870,  2871,  2872,  2873,  3754,  1090,
    2028,  3335,  1382,  1384,  2458,  1066,  1914,   629,   227,  2552,
     945,  2860,   949,   945,   917,  1407,   152,   997,   629,   629,
    3325,  2160,   152,  2860,  1678,  1075,   379,  3010,  1019,  1093,
     924,  1707,  2601,  2189,  2567,  1008,  1066,  1102,  3380,  1902,
    2217,  2218,  2219,  2220,  1915,  2042,  3681,  3459,  1401,   378,
    2642,  1980,  3463,   378,    49,  3465,  1009,   628,  2748,  1019,
    1466,  3679,    52,    53,    54,  1151,  1010,   240,   745,  1158,
     753,  3611,  3356,  2693,   927,   928,  1499,   630,   630,  1165,
    3381,  1985,  3456,  3492,  1237,  3493,   171,  2553,   764,   752,
    2605,  2606,   171,   629,   629,    74,  2517,  1464,  2161,   973,
     811,  3336,  1692,  1470,  1500,  2286,  1679,  2486,   944,  1558,
    3755,   944,   983,  1981,  2182,  2190,  3819,  1692,    49,  1090,
     746,   628,   765,  1677,   377,  3407,    52,    53,    54,  2029,
    2573,  2585,  1770,  2459,  2786,   375,  2714,  2715,  2716,  2717,
     120,  3839,   188, -1917,  1011,  2182,  3703,  2602,   188,  2603,
    2183,  3219,   813,  1680,  3384,  3819,   988,  1501,   124,  3706,
    3209,  1559,  1066,   379,  2258,  1982,  2261,  2191,  3685,  1066,
    3216,  2265,  3704,  2209,  3318,  1066,  3780,  3337,  2498,  2862,
    2071,  3819,  3408,  2210,  1596,  3707,  1502,  3232,  1166,  2211,
    1560,  2862,  2212,  2213,   203,  3095,  1635,  2214,  2418,    49,
     629,  2596,   628,  1012,  2599,  2600,  1933,    52,    53,    54,
    3494,  2002,  2125,   209,  2749,  1167,  1655,  1489,  1738,   209,
    1197,  1002,  3385,  1066,   238,  3095,  1734,   239, -1917,  1423,
    1681,  2150, -1917,  1074,  1945,  1656,  2768,  1764,  3705,  1448,
    1946,  1735,  2863,  2192,  2784,  2193,  2064,  1736,  1770,  1226,
    3400,  3708,  1679,  1168,  2863,  1712,  1983,  1448,   910,  3645,
    3444,   377,  2769,  2521,  1013,   378,  2256,   225,  2767,   335,
    2256,   629,   375,   225,   227,    75,    75,  3193,    75,  1066,
     227,  3386,  2064,  1490,   819,  2771,   820,  1424,   335,  2126,
    2196,  2569,    49,  1198, -1004,  3474,   948,  3475,  2156,  1680,
      52,    53,    54,  3578,  2580,  1729,  1635,  1166,  2779,   203,
    3124,  1787,  2025,  1505,  2113,  2357,  1199,  3357,  2587,  1506,
    -322,  2617,  2590,  3634,  1730,  2126,  1507,  1066,  1803,  2768,
     152,  1425,  1489,  3840,  3142,   985,  3358,  1643,  2263,   240,
    1509,  3370,  3371,  3372,  3373,  3374,  3375,  3241,  1510,  2071,
    3126,   991, -1004,  1066,  1731,  2769,  2109,   203,  1830,  2157,
    3579,  1574,  2114,  2009,  1899,  1900,   992,   654,   654,  2618,
    2770,  3261,  1168,  1643,  1841,  1000,  1681,  2358,  2771,  1844,
    1489,  2773,   628,  1066,  1066,  1005,  1066,  2837,  2010,  1849,
      55,   745,  2864,   753,  1511,   629, -1004,  3244,  3177,  3245,
     171,  2772,   378,  1066,  2864,   629, -1996, -1996,  1521,  2868,
    2869,  2870,  2871,  2872,  2873,  2011,  1886,  2865,  2866,  2867,
    1958,  2868,  2869,  2870,  2871,  2872,  2873,  1424,  1384,  2359,
    1535,  3776,  2360,  1522,  2889,    74,    74,  1523,    74,   766,
    1913,   745,  2134,   753,   629,  1996,  1490,  1464,   654,  3766,
    1850,  1464,  1464, -1569,  2138,  2693,   800,  1536,  1949,  1949,
    1524,  1949,   752,  2911,     8,  1111,   942,  1959,   876,  1112,
    3174,  1425,  1066,  1853,  2773,  1066,  1066,  1521,  2913,  3589,
    2914,  3772,  3773,   943,  3130,   942,   379,   379,   379,  1822,
    1823,  2262,  1487,   746,  1822,  1823,  2266,   630,  1843,  2409,
    2915,  2416,   943,  3797,  1039,  2275,  1523,  2619,  3800,   376,
     376,  2942,  2943,   629,  3246,  1386,  3131,  1488,  2284,   950,
    2361,   203,  1045,   379,  3247,  3532,  3132,   209,  1047,  1524,
     379,  1048,  1635,  2197,  1056,  1904,   379,  3821,  1824,  2204,
     945,  1049,  1050,  1826,  1489,   376,  2666,  2667,  2668,  2669,
    2670,  2671,  2006,  2228,  1079,  2620,  1238,  3822,  3401,   945,
    2802,  1051,   628,  1099,  1052,  1493,  1635,  1080,  1081,  1082,
      55,  1083,  1084,  1085,  1086,  1087,  1088,  1104,   895,  1252,
    1635,   225,  2834,   988,   377,   377,   377,  2098,   227,  1532,
    2291,  -979,   128,   129,  2142,   375,   375,   375,  1562,   745,
    2916,   753,  3133,  2143,  -979,  2917,  2362,  1448,  1533,  2264,
    1490,  1448,  1448,  1105,   238,    49,  2290,   239,   628,  2966,
     752,   377,  2291,    52,    53,    54,  2144,  -978,   377,  2835,
    2099,  1635,   375,  1534,   377,  3441,  1551,  2836,   944,   375,
    -978,  3567,  3568,  3569,  -979,   375,  2140,   240,  2172,  3015,
    3698,   746,  1950,  1952,  2294,  1956,  3159,   944,  2787,  3229,
    2789,  1552,  -979,  1142,  1992,  1635,  2330,  2338,  1145,  3262,
    3263,  2141,  2331,  2487,  3016,  3699,  1538,  2860,  2529,  3537,
    -978,  2560,  1539,  1002,  2331,  3696,  1146,  2561,  2256,  1157,
    1635,  1053,  3285,  2256,   379, -1768,  2256,  1162,  -978,  3124,
     775,  3031,  2100, -1768, -1768, -1768,  -979,  1384,  3033,  3034,
    3014,  2918,  1973,  3125,  -979,  1799,  1974,  2015,  1448,  2919,
    1540,  2250, -1768,   629,  1448,   378,   378,   378,  3291,  1170,
    2511,  2258,  3508,  1066,  1974,  1066,  2984,  3094,  1635,  3126,
    1066,  3127,  -978,  1090,  1174,  2101,  3077,  2102,  2895,  1635,
    -978,  1171,  3331,  2900,  1149, -1770,  1150,  1799,  2103,  2015,
    2336,  1154,   378, -1770, -1770, -1770,  1541,  3094,  2333,   378,
    1231,  1177,  1233,  1542,  1235,   378,  1543,    75,  2860,  2676,
    1236,    75, -1770,  2334,  1575,  2677,  3078,    49,  2706,  2335,
    2860,  2104,   377,  3514,  2707,    52,    53,    54,  1225,   628,
    1448,   987,  1066,   375,  2979,  3515,  2071,  3079,   745,  3128,
     753,   335,   628, -1417,  3027,  3028,  -979, -1417,  2111,  3200,
    1201,  2116,  2105,  2409,  1544,  2124,  3080,  2682,  2888,   752,
    2890,  2891,  2816,  2833,  1155,  1188,  1066,  1066,  2817,  2291,
    3684,  3081,  2843,  2846,  1066,  2862,  2365,  1066,  2291,  2291,
    1066,  2850,  -978,  1208,  2106,  2366,  3082,  2291,  1066,  1066,
     746,  1213,   629,  2243,  1811,  1812,  1066,  3536,  3129,  1066,
    1066,  1066,  1066,  3130,   807,   628,  1152,  1545,  1153,  1066,
    1066,   877,  1066,    55,  1066,    56,  1722,  1066,  1723,  1241,
    2851,  1446,  1593,  1594,  1228,  2425,  2291,    55,  2693,    56,
    2205,  1635,  1066,   379,  1245,  3131,  1066,  2409,  2863,  1246,
    1066,  1521,  2245,  2246,  1066,  3132,  1257,  1066,  1066,  1066,
    1066,  1066,  1066,  1066,  1066,  1066,  3686,  1066,  1262,  1822,
    1823,  3268,  1066,   378,  1850,  3083,  1066,    74,  2537,  1263,
    1523,    74,  1570,  3084,  2877,  3624,  2862,  1264,   811,  2894,
    2291, -1160,  2258,  2484, -1160,  2291,  1265,  1853,  2862, -1160,
   -1160, -1160,  1854,  2631,  2256,  1266,  -647,    49,  2897,   629,
     628,   745,  3085,   753,  2898,    52,    53,    54,  1824,  2515,
    2979,  2515,  2827,  2945,  3666,   379,  2354,  2355,  1267,  2291,
    2971,  3133,   752,  3032,  2367,  1030,  2972,  1066,  2370,  2371,
     813,   377,  3378,  3379,  1389,  2976,  3382,   376,  3383,  2863,
    2979,  1692,   375,  2391,  3147,  2392, -1431,  3435,  3436,  3437,
    3148,  2863,  3156,   746, -1431, -1431, -1431,   379,  3157,   379,
    3163,  1951,  1951,  1270,  1951,  2413,  3164,  2414,  3746,   630,
    3748,  1111,  1786, -1431,   240,  1112,  3233,  1271,  2711,   376,
    3269,   376,  2291,  2202,  1395,   629,  3270,  1396,  2864,  1464,
    3376,    75,  1799,    75,  1485,  2288,   379,  1723,  3276,  1391,
     988,  2865,  2866,  2867,  3277,  2868,  2869,  2870,  2871,  2872,
    2873,  1066,  1856,   377,  2794,  1397,  3287,  2796,  3104,  3105,
    3106,  2798,  2291,  3673,   375,  1079,  3448,  1799,  3512,  2015,
    1406,  1635,  1857,  1858,  1407,  1635,  1635,  1408,  1080,  1081,
    1082,  3782,  1083,  1084,  1085,  1086,  1087,  1088,  3310,  1499,
    3624,  2737,  2738,  3311,  2291,   377,  1111,   377, -1431,  2291,
    1112,  2712,   819,  2860,   820,  3329,   375,  1414,   375,  3420,
    3470,  3164,   378,   822,  2586,  3421,  2291,  1500,  2832,  2981,
    2982,  1861,   825,  3102,  3103,  3104,  3105,  3106,  1415,  2864,
    3513,  3539,  3540,  3394,   377,  1862,  2331,  3164,  3164,  1418,
    2767,  2864,  2865,  2866,  2867,   375,  2868,  2869,  2870,  2871,
    2872,  2873,  1776,  1777,  2865,  2866,  2867,  1421,  2868,  2869,
    2870,  2871,  2872,  2873,    49,  1416,  3859,   628,  3860,  1066,
    1501,  2073,    52,    53,    54,    55,  1635,    56,  1436,  3631,
    1596,  1448,  3636,  1446,   629,  1692,  1789,  1432,  3148,  1448,
    3624,    74,   629,    74,   378,  1066,   629,  1635,  3021,  1502,
    3024,  2768,  3638,  3651,  3653,  3658,  2687,  3719,  3148,  3652,
    2291,  2331,  3271,  3720,  3726,   988, -1150,  1440,  2258, -1150,
    1692,  1437,  2258,  2074, -1150, -1150, -1150,  2769,  3728,  3035,
    1441,  2075,  2076,  1442,  3148,  2533,   378, -1117,   378,  2536,
   -1117,  1443,  2770, -1150,  2713, -1117, -1117, -1117,  2588,  2745,
    2771,  3102,  3103,  3104,  3105,  3106,  2550,  3765,  2760,  3107,
    2554,  1074,  1030,  1766,  1799,   629,  1444,  2932,  3767,  2933,
    1066,  2862,  2077,  2772,  3720,   378,  1822,  1823,  3061,  3499,
    1066,  1445,  2568,  1908,  2570,  1865,  1448,  1538,  3775,  1448,
    1448,  1452,  3777,  1539,  1692,  2797,  2937,  2938,  2898,  2934,
    3460,  2935,  1869,  1870,  1871,  1872,  1873,  1874,  3778,  3781,
    3783,   629,  1066,  2078,  2291,  2331,  2331,  2592,  2079,  3784,
    1453,  3007,   203,  3834,  2044,  2331,  1505,  1455,   745,  3835,
     753,  1540,  1506,   745,  2863,   753,  1414,  2688,  -971,  1507,
    1458,  1066,  2692,  1471,  3149,  1489,  2773,  1472,  1420,   752,
    1422,  2633,  1635,  1509,   752,  2080,  3535,  3035,  2646,  1474,
    2648,  1510,  3858,  1609,  3192,   795,  3195,  1481,  2291,  1066,
    1066,  1485,  2081,  2082,  1498,  2083,  2084,  1541,  2085,  1515,
     746,  1557,  3864,  1909,  1542,   746, -1130,  1543,  3835, -1130,
    1529,  3040,  3041,  1530, -1130, -1130, -1130,  3391,  3392,  1066,
    1563,    49,  1565,  1066,   628,  1566,  3203,  1511,  2086,    52,
      53,    54,  2071,  1805,  3461,  1066,  1066,  1066,  1066,  2985,
    2986, -1766,  2427,   379,  2428,  2987,  2988,  1066,   379, -1766,
   -1766, -1766,  1066,  1841,  1580,  1544,  1589,  1822,  1823,  1459,
    1461,  2087,  1066,  1066,  2429,  1066,  1582,  2425, -1766,  3739,
    1587,  1591,  1597,  3744,  3745,  1600,  1637,  1638,  1066, -1160,
    1066,  1643, -1160,  3237,  1066,  1490,  2931, -1160, -1160, -1160,
    1647,  -166,  1649,  1665,  1674,  2380,  2088,  1684,  2089,  2250,
    1066,  3242,  1682,  1686,  2864,  1687,  1826,  1688,  1545,  1689,
    1691,  1066,  1697,  1066,  1066,  1692,  1698,  2865,  2866,  2867,
    2090,  2868,  2869,  2870,  2871,  2872,  2873,  2091,  3264, -1121,
    2092,  3740, -1121,  1464,  1066,  1700,  1701, -1121, -1121, -1121,
    1066,   377,  1521,  1772,  1702,  2978,   377,  1703,  1708,  1066,
    1066,  1066,   375,  1709,  3662,  1778,  2813,   375,  1710,  2430,
    1713,  1770,  1774,  1780,  2431,  1785,  1878,  1546,  1793,  2432,
    1796,  1523,  1797,  1798,  1802,  3561,  3562,   240,  3564,  1907,
    3202,  1066,  3204,  2813,  3206,  1804,  3208,  1807,  3210,  1808,
    1809,  1810,  1917,  3213,  1547,  1815,  1817,   238,    49,  1818,
     239,   628,  1635,  1635,  1819,  1635,    52,    53,    54,    55,
    1766,    56,  1090, -1157,  1820,  1821, -1157,  1446,  1635,  1828,
    1635, -1157, -1157, -1157,    49,  1934,  3230,   628,  1829,  1831,
    3026,  3150,    52,    53,    54,  1832, -1765,  3029,  1833,  3030,
   -1157,  1834,  1835,  1836, -1765, -1765, -1765,  1947,  1932,  1635,
    1423,  1848,  1969,   745,  1972,   753,  1979,  1986,  1987,  1995,
    2258,  1993,  2967, -1765,  3828,  2258,  3183,   832,  2258,  1463,
    1997,  2000,  2001,  2003,   752,  2433, -1710,  2005,  3630,  3352,
    2012,  3734,   378,  2434,  2013,  2015,  2016,   378,  3630,  2017,
    2033, -1119,  2034,  1448, -1119,  1079,  2036,  2037,  1635, -1119,
   -1119, -1119,  2038,  3151,   629,   746,   629,   629,  1080,  1081,
    1082,  2039,  1083,  1084,  1085,  1086,  1087,  1088,  3088,  1635,
     629,  3165,  2059,  2060,  2061,  2062,  1464,  2067,  2068,  2094,
    3117,  2095,  2066,  2687,  2097,  3563,  2108,  3182,  2096,  2112,
    2122,   988,  2128,  3709,  2127,  3113,   629,  2129,   379,  1635,
   -1122,  2135,  3146, -1122,   335,  2136,  1464,  2155, -1122, -1122,
   -1122,  2162,  2137,  2164,  1635,  2139,    49,  2165,   629,   628,
    2174,  1799,   335,  2998,    52,    53,    54,  1635,  3414,  1789,
    3173,  1384,  2176,  3301,  3302,  3303,  3304,  1805,   335,  2187,
     809,  1635,    49,  2483,  3225,  2250,   629,   629,  2199,  2250,
      52,    53,    54,  2203,  2216,  2230,  1448,  1066,    49,  2234,
    2237,  1066,  2239,  1448,  1448,  2241,    52,    53,    54,  1885,
      49,  1066,  2242,   628,  2248,  2259,  1635,  2269,    52,    53,
      54,    55,  1635,    56,  2270,  3836,  2271,  2283,  1090,  3529,
    2272,  2297,   745,  2304,   753,   335,   377,  2313,  2298,  2303,
    1066,  2316,  2320,  2328,  3727,  2340,  2349,   375, -1120,  2389,
    2348, -1120,  3099,   752,  2688,  3851, -1120, -1120, -1120,  2390,
    2402,  2407,  1850,  2412,  2411,  2419,  2443,  2424,  2441,  2470,
    1066,  2481,  2482,  1635,  2493,  2488,  1448,   995,  2480,  1066,
    2485,  2504,  1583,  3057,   746,  1066,  2499,  1066,  2505,  2510,
    2178,  1635,  1066,  2519,  3750,  1066,  1066,  1066,  1066,  1066,
    1066,  1066,  1066,  1066,  1066,  2518,  1448,  2258,  2530,  1066,
    1066,  2528,  2531,  2532,  2381,  2538,  2540,  2542,  1635,  2543,
    2546,  1770,  2548,  1066,  2544,  2551,  2258,   379,  3282,  1066,
    2581,  2558,  2578,  2556,  2577,  2579,  2591,  2582,  1066,  2597,
    2589,  1066,  2604,  1066,   629,  2643,  2644,  2645,  2650,  1841,
    2651,  1635,  1066,  1066,  1066,  1584,  2654,  2656,  1066,  2657,
    2658,  1066,  2659,  2660,  2661,  2672,  2678,  2683,  3547,  2690,
    2691,  1066,  2695,  2460,  2696,  2704,  2708,   378,  2718,  2719,
    2724,  2720,  2743,  3312,  2744,  2946,  2746,  2756,  3716,  2947,
    2948,  2949,  2759,  3722,  3722,  2757,  2758,  3477,  3478,  2780,
    2950,  2951,  2952,  2766,  2953,  2954,  2785,  3672,  2791,  2955,
    2956,  2957,  2792,  1096,  2793,  2795,  1894,  2809,  2814,  2341,
    2800,  2826,  2829,  1248,  2831,   377,  2844,  2845,  2848,  2291,
    2847,  2849,  2883,  2884,  2927,  2852,   375,  1141,  2853,  2907,
    2855,  2858,  2876,  3220,  2380,  2882,  1074,  2885,  2380,  3747,
    2886,  3749,  2893,  2912, -1637,  2905,  2906,  2920,   637,  2930,
    2993,  2944,  2995,  1723,  3231,   657,  3009,   661,  2992,  1635,
    2940,  2990,  3001,  2996,  3008,  3004,   661,  2997,  3005,  3022,
    3046,  3066,  2258,  3047,  3048,  3049,  3050,  2380,  2380,  3051,
    3771,  3052,  3053,  3054,  3055,  3056,  3067,  3068,  3098,  3069,
    3149,  3070,   657,  3071,  3072,   629,   629,   629,   629,   629,
     629,   661,  1989,  3097,  3109,  3137,  3141,  3108,  3160,   657,
     661,  3170,  3152,   661,  3161,  3168,  3154,  3180,  3186,   661,
    3794,  3184,  3188,   661,  3155,  3199,  3189,  3722,   912,  3196,
    2687,  2687,  2687,  2687,  2687,  3201,  3205,  3207,  1249,  3217,
    3224,  1881,   914,  1251,  3807,   661,  1786,  1066,  3218,  3227,
     921,  3236,  3228,  2879,  1260,  2860,   378,  2878,  1635,  3265,
     661,  3266,  3278,  1845,   931,  3289,   912,  3308,  3314,  3330,
     951,  3267,  2258,  3290,  3333,  3317,    55,  3298,  3313,  3315,
    3442,  3332,  3323,  1251,  3334,  3320,   978,  1850,  3344,  3345,
    3346,  3367,  3354,  3368,  3366,  3369,   629,  2250,  3377,  1251,
    3411,  3393,  2250,  3404,  1403,  2250,  1079,  3177,  3415,  1066,
    1853,  3417,  3419,  3426,  1066,  1854,  3431,  1066,  1417,  1080,
    1081,  1082,  3439,  1083,  1084,  1085,  1086,  1087,  1088,  3432,
    3445,  3446,  3454,  3805,  3457,  3464,  3473,  3467,  2958,  3476,
    3479,  3480,  3484,  3486,  3491,  3525,  3488,  3495,  3818,  3639,
    3640,  3641,  3642,  3500,  3496,  1066,  3390,  3501,  3526,  3559,
    3542,  2688,  2688,  2688,  2688,  2688,  3555,  3502,  3506,  3403,
    3556,  3548,  3565,  3359,  3574,  3361,  3551,  3566,  1992,  3580,
    3385,  3584,  3585,  3586,  3583,  3593,  2959,  3818,  3595,  3598,
    3600,  1066,  1770,  3613,  3603,  3614,  1770,  1770,  1066,  1066,
    3607,  3857,  3615,  3617,  3619,  1066,  1066,  3628,  3620,  3633,
    1066,  1635,  3643,  3818,  3644,  3655,  1066,  1066,  3647,  3648,
    1066,  3656,  3650,  3668,  3682,  3657,  3683,  3534,  3687,  3410,
    3667,  1855,  3693,  3695,  3701,  1856,  3675,  3676,  3164,  3711,
    1576,  3752,  3531,   629,  3712,  3713,  3756,   661,  3714,  3753,
    3761,    75,  3779,  1716,  3760,  1857,  1858,  3785,  1635,  3786,
    3789,  3791,  3795,  2071,  3796,  3803,  3808,  3806,  1859,  3787,
    3788,  3741,  2960,  3596,  3830,  3831,  3849,  3861,  2710,   990,
    1929,  2969,  2632,  3039,  2674,  3424,  3570,  1499,  3347,  3571,
    3572,  1661,  1663,  1664,  3576,   629,   629,   629,  3428,  2607,
    3590,  1860,  3003,  3434,  1861,   629,   629,  3573,  3804,  3827,
     629,  3577,  3792,  3790,  3814,  1500,  2859,  3214,  1862,  3429,
    2875,  3729,  2229,  3616,   335,  1066,  2694,  3863,  3581,  3850,
    3582,  3139,  3138,  3602,  3087,  3815,  3674,  2198,  3829,   919,
    3677,  1760,  2815,  3443,  3485,  2813,  3717,  3770,  3011,   629,
    2564,  2562,  3447,  3751,  1399,  3842,  3862,  3697,  3626,  2908,
    2909,  2702,  2495,  2381,   882,  3423,  1066,  2381,  1501,  1733,
    3226,  1251,  2973,  2250,   629,  1737,  2801,  3481,  2977,  1967,
    2989,  1066,  1965,  1864,  3538,  1066,  2507,  1970,  2492,  2939,
    1635,  2762,  1251,  2974,  3545,  3546,  3635,  1502,  3194,  3549,
    3550,  1184,  3530,  3422,  3281,  3272,  2381,  2381,  3733,  3557,
    2980,    74,  1066,  2406,  2925,  2840,  1066,  2380,  2923,  2819,
    2380,  2380,  2380,  2380,  2380,  2380,  2380,  2380,  2380,  2380,
    2469,  3025,  1033,  3181,  2755,  1066,  1066,  2244,  2520,  1066,
    1978,  1676,  1003,  1971,  2512,  1769,  1066,  1066,  2522,  1224,
    1479,  1462,  2807,  2964,  2808,  3482,  3543,  3528,  3483,  1893,
     657,  3316,  1975,  1025,  2526,  2299,  1066,  3552,  1865,  3554,
    2803,  1719,    80,     0,     0,     0,     0,     0,  2380,  2380,
    1066,  1866,  1867,  1868,     0,  1869,  1870,  1871,  1872,  1873,
    1874,  1503,     0,     0,   629,     0,     0,     0,     0,     0,
       0,  3182,     0,     0,     0,  1066,     0,     0,     0,     0,
     661,   661,     0,     0,     0,     0,  1504,     0,     0,     0,
     203,     0,     0,     0,  1505,     0,     0,  1935,     0,  3715,
    1506,  3856,     0,     0,     0,     0,     0,  1507,     0,     0,
       0,  1066,  1066,  1508,     0,   629,     0,     0,     0,     0,
       0,  1509,   335,     0,     0,     0,     0,     0,     0,  1510,
       0,     0,     0,     0,     0,     0,     0,     0,  1066,  1066,
       0,  1066,     0,  1066,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1635,     0,     0,     0,  1635,  1635,     0,     0,
       0,     0,     0,     0,     0,  1511,     0,     0,     0,  2813,
       0,     0,     0,     0,     0,     0,     0,  3665,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1068,   657,  1072,     0,   637,     0,  1092,     0,   637,   661,
       0,  1066,   661,     0,   661,  1068,   637,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1635,     0,     0,     0,   661,     0,  2121,
     657,     0,  1068,  2748,   637,     0,     0,     0,   637,  1160,
     661,     0,  2380,     0,   661,     0,  1068,     0,   637,     0,
       0,  1499,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   661,  1066,   661,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   661,     0,  1066,   657,  1500,
       0,   661,     0,     0,     0,   661,   661,     0,     0,     0,
     661,     0,   661,     0,   661,   335,     0,  1068,     0,     0,
       0,     0,     0,     0,     0,     0,  1886,     0,  1850,  3855,
       0,     0,     0,     0,     0,     0,  1066,  1066,   661,     0,
     661,     0,     0,  1851,     0,     0,   661,     0,     0,   335,
    1066,  1853,  1501,     0,     0,     0,  1854,     0,     0,     0,
       0,     0,  1066,     0,     0,     0,  3312,   661,     0,   661,
       0,     0,  1261,     0,     0,     0,     0,     0,     0,  3243,
       0,  1502,  3248,  3249,  3250,  3251,  3252,  3253,  3254,  3255,
    3256,  3257,     0,     0,     0,     0,     0,     0,   661,   657,
       0,     0,     0,  1385,     0,     0,     0,  2278,     0,  2749,
       0,     0,     0,     0,  2281,     0,     0,     0,     0,     0,
    2380,  2380,  1405,     0,     0,     0,  2381,     0,     0,  2381,
    2381,  2381,  2381,  2381,  2381,  2381,  2381,  2381,  2381,     0,
    3293,  3294,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1850,     0,  1251,
    1251,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2327,  1855,     0,     0,     0,  1856,   637,   637,     0,
    1853,     0,     0,     0,  1850,  1854,     0,  2381,  2381,   661,
       0,     0,   661,     0,     0,   661,  1857,  1858,     0,  1851,
       0,     0,     0,     0,   203,     0,     0,  1853,  2750,  1859,
       0,     0,  1854,     0,  1506,     0,     0,     0,     0,  1068,
    1068,  1507,     0,     0,  1850,     0,     0,  1489,     0,     0,
       0,     0,     0,     0,     0,  1509,     0,     0,     0,  1851,
       0,     0,  1860,  1510,     0,  1861,   661,  1853,     0,     0,
       0,     0,  1854,     0,     0,     0,     0,  2748,  1578,  1862,
       0,  1863,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   661,     0,     0,     0,  1499,     0,   661,     0,     0,
       0,   661,     0,     0,     0,  2468,     0,     0,   661,  1511,
       0,     0,     0,     0,     0,     0,  1068,  1068,     0,     0,
       0,  1855,     0,  1500,     0,  1856,     0,     0,     0,     0,
       0,     0,  1068,  1578,     0,   661,  1673,     0,     0,     0,
       0,     0,     0,     0,  1864,  1857,  1858,  2380,  1855,     0,
       0,  2380,  1856,     0,     0,     0,     0,     0,  1859,  1068,
    1068,     0,     0,   661,  3406,     0,     0,     0,     0,  2496,
    2380,  2380,  1857,  1858,     0,     0,  1501,     0,     0,     0,
       0,     0,     0,     0,     0,  1859,   767,     0,  1855,     0,
       0,     0,  1856,     0,  1861,     0,     0,     0,     0,     0,
     661,     0,     0,     0,     0,  1502,     0,     0,  1862,   661,
     912,  2381,  1857,  1858,   661,     0,     0,     0,  1860,   661,
       0,  1861,     0,     0,     0,  1859,     0,  1779,     0,  1865,
     661,     0,  1784,  2749,     0,  1862,     0,  1863,     0,     0,
     768,     0,  1866,  1867,  1868,     0,  1869,  1870,  1871,  1872,
    1873,  1874,     0,     0,  2147,     0,     0,   769,  1860,     0,
       0,  1861,     0,  2148,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1864,     0,  1862,     0,  1863,   770,     0,
       0,     0,  1630,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1864,     0,     0,  2380,  2380,     0,     0,     0,     0,   771,
       0,     0,     0,     0,     0,   772,     0,     0,     0,     0,
       0,     0,  3509,  3510,     0,     0,     0,     0,   203,   773,
       0,     0,  1505,     0,   657,   657,     0,     0,  1506,     0,
    1864,     0,     0,     0,     0,  1507,     0,  2625,  1385,     0,
       0,  1489,     0,     0,     0,  1927,  1927,     0,  1865,  1509,
       0,     0,     0,     0,     0,     0,  1936,  1510,  1943,  2381,
    2381,  1866,  1867,  1868,     0,  1869,  1870,  1871,  1872,  1873,
    1874,     0,     0,     0,     0,  1865,     0,     0,     0,     0,
       0,     0,  1630,     0,     0,     0,     0,     0,  1866,  1867,
    1868,     0,  1869,  1870,  1871,  1872,  1873,  1874,     0,   774,
       0,     0,     0,  1511,     0,   657,     0,   637,  2854,     0,
       0,     0,     0,     0,     0,  1865,     0,     0,  2709,     0,
       0,     0,   775,     0,     0,     0,   661,     0,  1866,  1867,
    1868,     0,  1869,  1870,  1871,  1872,  1873,  1874,     0,     0,
       0,     0,     0,     0,   776,     0,  2726,  1850,  2901,     0,
     777,     0,     0,     0,  2747,     0,   778,     0,     0,     0,
       0,     0,  1851,     0,     0,     0,     0,     0,     0,     0,
    1853,     0,     0,     0,     0,  1854,     0,     0,     0,     0,
       0,     0,  1092,   779,   780,     0,     0,     0,   781,     0,
       0,     0,     0,     0,     0,     0,   782,     0,     0,     0,
       0,   783,     0,     0,     0,  1068,  1068,  1068,  1068,     0,
     784,     0,     0,     0,     0,     0,  1911,   645,     0,  3646,
       0,   785,  1850,  3649,   658,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1068,  1068,  1851,     0,     0,
       0,  1068,  3659,  3660,     0,  1853,     0,     0,     0,     0,
    1854,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   658,     0,     0,     0,     0,  2381,     0,     0,     0,
    2381,     0,     0,     0,     0,     0,     0,     0,   658,   658,
       0,     0,     0,     0,     0,     0,     0,     0,   658,  2381,
    2381,  1855,   645,     0,     0,  1856,     0,     0,     0,   637,
       0,   661,  1850,  1068,  1068,  1068,  1068,     0,  1630,     0,
       0,     0,   645,     0,   645,  1857,  1858,  1385,     0,  1578,
       0,     0,     0,     0,     0,  1853,     0,     0,  1859,   658,
    1854,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     657,     0,  1630,   661,   661,     0,     0,     0,     0,  1092,
       0,     0,   661,   661,     0,   661,  1630,     0,     0,     0,
     661,  1860,   661,     0,  1861,  1068,  1855,     0,  1068,     0,
    1856,     0,     0,     0,     0,  3730,  3731,     0,  1862,  2936,
    1863,     0,   661,   661,     0,     0,     0,     0,     0,     0,
    1857,  1858,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   661,  1859,   661,   661,     0,  1630,   661,     0,
       0,     0,     0,     0,  2319,     0,     0,     0,     0,     0,
       0,     0,  2381,  2381,  1630,     0,     0,     0,     0,     0,
       0,     0,   912,     0,     0,  2343,  1860,     0,     0,  1861,
       0,  1630,     0,  1864,     0,     0,  1855,     0,     0,     0,
    1856,     0,     0,  1862,     0,  1863,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1630,     0,     0,  1092,
    1857,  1858,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1859,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1630,     0,   658,     0,  1864,  1861,
       0,     0,     0,     0,     0,  1630,     0,     0,  1865,     0,
       0,     0,     0,  1862,     0,     0,     0,     0,     0,   661,
       0,  1866,  1867,  1868,     0,  1869,  1870,  1871,  1872,  1873,
    1874,     0,     0,     0,     0,  2410,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1943,
       0,     0,     0,     0,     0,     0,     0,     0,  1864,   661,
       0,     0,     0,  1865,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1866,  1867,  1868,     0,
    1869,  1870,  1871,  1872,  1873,  1874,     0,     0,     0,     0,
    3096,     0,     0,  3143,     0,     0,     0,     0,     0,     0,
       0,     0,  3153,     0,     0,     0,     0,     0,     0,   637,
       0,     0,   661,     0,     0,     0,     0,     0,     0,     0,
       0,  3169,     0,     0,   637,   661,     0,     0,   637,   657,
       0,     0,     0,   661,     0,     0,     0,  1630,     0,   661,
       0,     0,     0,  1865,   661,   637,     0,     0,     0,   637,
     661,     0,     0,     0,     0,   661,     0, -1996, -1996,     0,
    1869,  1870,  1871,  1872,  1873,  1874,     0,     0,  3211,     0,
    3212,   637,   661,   637,   661,  3215,   661,     0,     0,  2575,
    2575,     0,  1850,     0,     0,   661,     0,     0,     0,   658,
       0,     0,     0,     0,     0,     0,     0,  1851,     0,   661,
       0,     0,     0,   661,  1251,  1853,   637,   661,   661,   661,
    1854,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2608,  2609,   661,   661,   661,   661,  2616,     0,
       0,   661,   661,     0,     0,   661,   661,   661,     0,     0,
     637,   661,     0,     0,     0,     0,     0,   637,   661,   637,
       0,   661,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1850,     0,     0,  1068,
    1068,  1068,  1068,  1068,  1068,     0,     0,     0,     0,     0,
       0,  1851,     0,     0,     0,     0,     0,     0,     0,  1853,
    2689,     0,     0,     0,  1854,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2575,  3305,  3306,     0,     0,     0,     0,     0,   912,
       0,     0,     0,     0,     0,     0,  1855,     0,     0,     0,
    1856,     0,     0,     0,     0,     0,     0,  1630,     0,  2723,
       0,  1630,  1630,     0,  2736,     0,  2742,     0,     0,     0,
    1857,  1858,     0,     0,  1673,     0,     0,  1850,     0, -1993,
       0,     0,  2765,  1859,     0,     0,  2765,  2778,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1853,  1068,  2575,  1068,  2575,  1854,     0,     0,  1850,     0,
     645,     0,     0,     0,     0,     0,  1860,     0,     0,  1861,
       0,     0,     0,  1851,     0, -1993,     0,     0,     0,   661,
    1855,  1853,     0,  1862,  1856,  1863,  1854,     0, -1993,     0,
       0,     0,     0, -1993,     0,   637,     0,     0, -1993,  1178,
     658, -1993,   658, -1993,  1857,  1858,     0,     0,     0,     0,
       0,     0,  1630,     0,     0,     0,     0,  1859,     0,   661,
       0,     0,   637,     0,     0,     0,     0,     0, -1993,     0,
       0,     0,     0,  1630,     0,     0,     0,  2910,     0,     0,
       0,   658,     0,     0,     0,   645, -1993,   645,  1864,   645,
    1860,     0,     0,  1861,  3402,   645,   645,     0,     0,     0,
       0,     0,     0,     0,     0,   658,     0,  1862,     0,  1863,
       0, -1996,     0,     0,     0,  1856,     0,  3412,     0,     0,
       0,     0,     0,   645,     0,     0,     0,  3416,     0,     0,
   -1993,     0,     0,     0,  2904,  1857,  1858,     0, -1993,     0,
       0,     0,  1855,     0,     0,     0,  1856,     0, -1996,     0,
     645,     0,     0,     0,     0,     0,     0,   658,   658,     0,
       0,   645,   645,  1092,     0,     0,  1857,  1858,     0,     0,
       0,     0,  1864,  1865,     0,     0, -1993,     0,     0,  1859,
       0,     0,     0,     0,  1861,     0,  1866,  1867,  1868,     0,
    1869,  1870,  1871,  1872,  1873,  1874,     0,     0,  1862,     0,
    3280,     0,     0,     0,     0,     0,     0,  1927,     0,     0,
       0,     0,  1860,  1943,     0,  1861,     0,     0,     0,   917,
       0,     0,   645,     0,     0,     0,     0,   661,  1630,  1862,
       0,  1863,     0,     0,     0,     0,   645,   645,     0,     0,
   -1993,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   637,   661,   661,     0,     0,  1865,     0,     0,
   -1993,     0,     0, -1996,     0,     0,  2742,     0,     0,     0,
    1866,  1867,  1868,     0,  1869,  1870,  1871,  1872,  1873,  1874,
   -1993, -1993, -1993,     0,  3326,     0,  3521,  3522,  3523,  3524,
       0,     0,     0,     0,  1864,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   661,   661,     0,     0, -1993,
       0,     0, -1993, -1993, -1993,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1068,     0,     0,     0,
       0,     0,     0,     0,     0,  1850,     0,     0,     0,   661,
     661,   661,   661,   645,     0,     0,     0,     0,  1865,     0,
    1851,     0,     0,     0,     0,     0,     0,     0,  1853,     0,
       0,     0,     0,  1854,     0,  1869,  1870,  1871,  1872,  1873,
    1874,     0,   637,   661,     0,     0,     0,     0,   852,  1865,
       0,     0,  2575,  2575,     0,     0,     0,     0,     0,     0,
     853,     0,  1866,  1867,  1868,     0,  1869,  1870,  1871,  1872,
    1873,  1874,     0,     0,     0,     0,  3489,  2689,     0,     0,
     854,     0,     0,     0,   645,     0,     0,     0,     0,     0,
       0,   661,   661,   661,     0,     0,     0,     0,     0,     0,
       0,     0,   855,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1745,     0,     0,  1749,   661,     0,   751,   856,
       0,     0,     0,     0,     0,   658,     0,     0,  1630,  1630,
       0,  1630,     0,     0,     0,     0,   661,     0,     0,     0,
     857,  1385,     0,     0,  1630,     0,  1630,     0,   657,  1855,
       0,   661,  2765,  1856,     0,  3185,     0,     0,     0,   751,
       0,     0,     0,     0,     0,     0,     0,  1850,  3198,     0,
       0,   858,     0,  1857,  1858,  1630,     0,   859,     0,     0,
       0,     0,     0,     0,     0,     0,  1859,     0,     0,     0,
    1853,   860,     0,     0,     0,  1854,     0,     0,     0,     0,
       0,     0,   637,     0,     0,     0,   941,     0,   645,  2319,
       0,     0,     0,   941,     0,   941,     0,     0,   645,  1860,
       0,     0,  1861,   637,  1630,     0,   751,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1862,     0,  1863,  1889,
       0,  3689,     0,   658,   658,  1630,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   645,     0,     0,
     645,     0,  1251,     0,   645,   645,     0,     0,     0,     0,
       0,   861,     0,     0,     0,  1630,     0,  2921,     0,   862,
       0,     0,     0,  3725,     0,     0,     0,     0,     0,     0,
    1630,  1850,     0,     0,   775,     0,     0,     0,     0,     0,
       0,  1864,     0,  1630,     0,     0,  1851,     0,     0,     0,
       0, -1996,     0,     0,  1853,  1856,   863,  1630,  1118,  1854,
     864,     0,   865,  3737,   658,     0,   645,     0,   866,     0,
       0,     0,     0,     0,     0,  1857,  1858,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1996,     0,
    1119,     0,  1630,     0,     0,   867,   868,     0,  1630,     0,
     869,     0,  1120,     0,  1943,     0,     0,     0,   870,     0,
       0,   645,  1121,   871,     0,     0,     0,   645,     0,     0,
       0,     0,   872,     0,  1861,     0,  1865,     0,     0,  1122,
       0,     0,     0,   873,     0,     0,  2742,  2742,  1862,  1866,
    1867,  1868,     0,  1869,  1870,  1871,  1872,  1873,  1874,  1630,
    1123,     0,     0,  3520,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1630,     0,     0,
       0,     0,     0,     0,     0,  1855,     0,     0,   661,  1856,
       0,  1124,   637,   661,   637,   661,   661,   661,   661,     0,
       0,     0,     0,   645,  1630,     0,     0,     0,     0,  1857,
    1858,  1125,     0, -1996,     0,     0,     0,     0,     0,     0,
       0,     0,  1859,     0,     0,     0,     0,     0,   794,     0,
       0,     0,     0,     0,  1850,  1126,     0,  1630,     0,     0,
       0,     0,     0,     0,  2689,  2689,  2689,  2689,  2689,     0,
       0,     0,     0,     0,     0,  1860,     0,  1853,  1861,     0,
       0,     0,  1854,     0,     0,     0,     0,   661,     0,     0,
       0,     0,  1862,     0,  1863,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   645,     0,     0,     0,
    2723,  1127,     0,     0,  2608,   645,     0,  2608,  1865,  3430,
       0,     0,  1850,     0,     0,     0,  2742,     0,     0,     0,
       0,     0,  2575,   794,   775,  1869,  1870,  1871,  1872,  1873,
    1874,     0,     0,     0,     0,  1853,  2765,     0,   661,     0,
    1854,     0,     0,     0,     0,     0,  1128,  1864,     0,  2723,
    1129,  3469,  1130,   661,  3295,     0,  1850,  2575,  1131,  2575,
       0,     0,   658,     0,     0,  1630,     0,     0,     0,     0,
       0,  1851,     0,     0,   637,     0,  1889,  2302,     0,  1853,
       0,     0,     0,     0,  1854,  1132,  1133,     0, -1996,     0,
    1134,     0,  1856,     0,     0,     0,     0,     0,  1135,     0,
       0,     0,     0,  1136,     0,     0,     0,     0,     0,     0,
       0,     0,  1857,  1858,     0,     0,     0,     0,     0,     0,
       0,     0,  3296,  1137,     0, -1996,     0,     0,   645,   645,
       0,     0,  1865,     0,     0,   645,   645,     0,     0,     0,
     645,   645,     0,     0,     0,  1866,  1867,  1868,     0,  1869,
    1870,  1871,  1872,  1873,  1874,   645, -1996,   645,     0,  3654,
    1856,  1861,     0,     0,  1630,     0,     0,     0,     0,     0,
       0,     0,  1092,     0,     0,  1862,     0,   645,     0,   645,
    1857,  1858,     0,     0,     0,   637,   661,     0,     0,     0,
       0,     0,     0, -1996,     0,     0,   637,   661,   637,     0,
    1855,     0,     0,  3558,  1856,     0,   661,   661,  1068,   661,
       0,  1745,     0,     0,     0,     0,     0,     0,  2478,     0,
       0,     0,   751,     0,  1857,  1858,  2302,     0,     0,  1861,
    1063,     0,     0,  2742,  1063,     0,     0,  1859,     0,     0,
   -1996,     0,   645,  1862,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1063,     0,     0,
    1860,     0,     0,  1861,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   661,     0,     0,  1862,     0,  1863,
       0,   661,     0,     0,     0,     0,     0,  3625,     0,     0,
       0,     0,     0,     0,     0,     0,  3629,     0, -1996,   661,
       0,     0,     0,     0,     0,  1063,     0,  1630,     0,  3469,
       0,  1063,     0,     0,   645,  1865,     0,     0,   645,     0,
       0,   658,  3430,     0,     0,     0,     0,     0,   637,     0,
       0,     0,  1869,  1870,  1871,  1872,  1873,  1874,     0,     0,
       0,     0,  1864,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1630,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1865,     0,     0,     0,     0,  1092,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1869,  1870,  1871,  1872,  1873,  1874,     0,  1063,     0,     0,
     645,     0,   941,     0,     0,   941,  2742,     0,     0,   645,
       0,     0,   645,   645,     0,     0,     0,  1865,  1850,     0,
       0,     0,     0,     0,     0,     0,     0,  2575,  1063,  2608,
    1866,  1867,  1868,  1851,  1869,  1870,  1871,  1872,  1873,  1874,
       0,  1853,     0,     0,  3691,     0,  1854,     0,     0,     0,
       0,  1068,  3625,     0,     0,     0,  1068,  1068,     0,     0,
       0,     0,     0,     0,     0,   661,     0,   645,     0,     0,
       0,     0,     0,     0,     0,   645,  1630,     0,  1850,   645,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   645,
       0,     0,     0,  1851,   645,     0,     0,     0,     0,     0,
       0,  1853,     0,     0,     0,     0,  1854,     0,     0,     0,
       0,  1068,  1068,  1068,  1068,   661,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   661,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1058,     0,     0,   645,  1058,
       0,   794,  3625,  1068,  1063,   751,   794,   794,     0,     0,
       0,  1063,  1855,   794,     0,     0,  1856,  1063,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     794,     0,  1058,     0,     0,     0,  1857,  1858,  1633,     0,
       0,     0,   661,  1068,   645,     0,     0,     0,     0,  1859,
    1068,     0,     0,     0,     0,     0,     0,     0,   658,  1745,
       0,     0,  2806,     0,  1749,  1063,     0,  1068,     0,     0,
       0,     0,  1855,     0,     0,   794,  1856,     0,  3820,     0,
    1058,     0,  1860,     0,     0,  1861,  1058,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1857,  1858,     0,  1862,
       0,  1863,     0,     0,     0,     0,     0,     0,     0,  1859,
       0,     0,     0,     0,     0,     0,     0,  3820,     0,     0,
       0,  1063,     0,     0,     0,     0,     0,     0,  1630,     0,
       0,     0,  1630,  1630,     0,     0,     0,     0,     0,     0,
       0,   794,  1860,  3820,     0,  1861,   794,     0,  1633,     0,
       0,     0,     0,     0,     0,     0,     0,   794,     0,  1862,
       0,  1863,     0,     0,  1864,     0,     0,     0,  1850,  1063,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   794,     0,     0,     0,
       0,  1853,     0,     0,     0,  1063,  1854,     0,     0,  1630,
       0,     0,   794,     0,     0,     0,     0,   794,     0,     0,
       0,     0,  1850,     0,     0,     0,     0,     0,     0,     0,
       0,   794,     0,     0,  1864,  1063,  1063,  1851,  1063,     0,
       0,  2500,     0,     0,     0,  1853,     0,     0,     0,     0,
    1854,     0,  2302,     0,   645,  1063,   645,     0,     0,  1865,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1866,  1867,  1868,     0,  1869,  1870,  1871,  1872,
    1873,  1874,     0,     0,     0,     0,  3768,     0,  3299,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2501,     0,     0,     0,  1865,
       0,     0, -1996,     0,  1063,     0,  1856,  1063,  1063,     0,
       0,     0,  1866,  1867,  1868,     0,  1869,  1870,  1871,  1872,
    1873,  1874,     0,     0,  3059,     0,  1857,  1858,     0,     0,
       0,     0,   645,   794,     0,     0,  1058,     0,     0, -1996,
       0,     0,  1058,     0,     0,     0,  1855,     0,     0,   645,
    1856,     0,     0,     0,     0,     0,   645,   645,     0,     0,
       0,     0,     0,     0,  1633,     0,     0,     0,   751,     0,
    1857,  1858,   941,     0,     0,  1861,     0,     0,     0,     0,
       0,     0,     0,  1859,   794,   794,   794,     0,     0,  1862,
    1058,   941,     0,     0,     0,     0,     0,     0,  1633,     0,
       0,     0,     0,     0,     0,     0,     0,   645,     0,   645,
     645,     0,  1633,     0,     0,     0,  1860,     0,     0,  1861,
       0,     0,     0,   645,     0,     0,     0,     0,     0,   645,
       0,     0,     0,  1862,   645,  1863,   645,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   645,   645,
       0,     0,     0,     0, -1996,     0,     0,     0,     0,   645,
       0,     0,     0,  1633,   794,     0,     0,     0,     0,     0,
       0,   645,     0,     0,     0,   658,     0,     0,     0,     0,
    1633,     0,     0,     0,     0,   794,     0,     0,     0,     0,
       0,     0,  1850,     0,     0,     0,     0,  1633,  1864,   645,
     645,     0,     0,     0,     0,     0,     0,  1851,     0,     0,
     658,     0,     0,     0,     0,  1853,     0,     0,     0,     0,
    1854,     0,  1633,     0,     0,     0,   751,     0,     0,     0,
       0,  1622,     0,     0,     0,     0,     0,     0,     0,  1865,
       0,     0,     0,     0,     0,  2502,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1869,  1870,  1871,  1872,
    1873,  1874,     0,     0,     0,  1063,     0,  1063,     0,     0,
    1633,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
       0,  1633,     0,  1865,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1866,  1867,  1868,     0,
    1869,  1870,  1871,  1872,  1873,  1874,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2878,     0,     0,     0,
     794,  2879,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1063,     0,  1855,     0,     0,     0,
    1856,  1622,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   645,     0,     0,
    1857,  1858,     0,     0,     0,     0,     0,     0,  1063,  1063,
       0,     0,     0,  1859,     0,     0,  1063,     0,     0,  1063,
       0,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
    1063,  1063,     0,     0,     0,     0,     0,     0,  1063,     0,
       0,  1063,  1063,  1063,  1063,     0,  1860,     0,     0,  1861,
       0,  1063,  1063,     0,  1063,     0,  1063,     0,     0,  1063,
       0,     0,     0,  1862,     0,  1863,     0,     0,     0,     0,
       0,     0,     0,  1633,  1063,   751,     0,     0,  1063,     0,
       0,     0,  1063,     0,     0,     0,  1063,     0,     0,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,     0,  1063,
       0,     0,   794,     0,  1063,     0,     0,     0,  1063,     0,
       0,     0,     0,     0,     0,   794,     0,     0,     0,     0,
       0,     0,     0,     0,  1850,     0,     0,     0,  1864,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1851,
       0,     0,     0,     0,     0,     0,     0,  1853,     0,     0,
       0,     0,  1854,     0,     0,     0,     0,     0,   645,   645,
     645,   645,   645,   645,     0,     0,     0,     0,     0,  1063,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   645,     0,
       0,     0,     0,   645,   645,   645,   645,   645,     0,     0,
       0,   645,     0,     0,     0,     0,     0,  1622,     0,     0,
       0,     0,     0,  1865,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1866,  1867,  1868,     0,
    1869,  1870,  1871,  1872,  1873,  1874,     0,     0,   751,     0,
    2257,  1622,  1058,     0,     0,     0,     0,  1058,     0,     0,
       0,     0,     0,  1063,     0,  1622,     0,     0,     0,   645,
     794,     0,     0,     0,     0,     0,     0,   794,  1855,     0,
       0,     0,  1856,  1633,     0,     0,     0,  1633,  1633,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1857,  1858,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1859,  1622,     0,  2806,  1058,
       0,     0,   794,   794,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1622,   794,    73,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1860,     0,
    1622,  1861,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1862,     0,  1863,     0,     0,
       0,     0,     0,     0,     0,  1622,     0,     0,     0,     0,
       0,  1063,  3273,     0,     0,     0,     0,     0,  1633,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1063,     0,  1633,
       0,     0,     0,     0,     0,  2302,   645,     0,     0,     0,
       0,     0,     0,  1622,     0,     0,   645,     0,     0,     0,
    1864,  1624,  1850,     0,  1622,     0,   645,   645,     0,     0,
       0,   645,   645,  3274,     0,     0,     0,  1851,   794,     0,
    1852,   645,     0,     0,     0,  1853,     0,   660,     0,     0,
    1854,     0,     0,     0,     0,     0,   662,     0,   645,   645,
     645,     0,     0,     0,     0,     0,     0,     0,   645,   645,
       0,     0,  1063,   645,     0,     0,     0,     0,     0,     0,
       0,     0,  1063,     0,   900,     0,     0,     0,     0,     0,
       0,   791,     0,     0,     0,     0,     0,     0,     0,     0,
     842,     0,   794,   846,     0,  1865,   900,     0,     0,   842,
       0,     0,   645,   899,  1063,     0,     0,     0,  1866,  1867,
    1868,     0,  1869,  1870,  1871,  1872,  1873,  1874,     0,     0,
       0,  1624,     0,     0,     0,   920,     0,   645,     0,     0,
       0,     0,     0,  1063,     0,     0,     0,     0,     0,     0,
     842,     0,     0,     0,  1633,  1850,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1855,     0,     0,     0,
    1856,  1063,  1063,     0,     0,     0,  1622,     0,  1853,     0,
       0,  1850,     0,  1854,     0,     0,     0,     0,     0,     0,
    1857,  1858,     0,     0,     0,     0,  1851,     0,     0,  2842,
       0,  1063,     0,  1859,  1853,  1063,     0,     0,     0,  1854,
       0,     0,     0,     0,     0,     0,     0,  1063,  1063,  1063,
    1063,     0,     0,     0,     0,   751,     0,     0,     0,  1063,
     751,     0,     0,     0,  1063,     0,  1860,     0,     0,  1861,
       0,     0,     0,     0,  1063,  1063,     0,  1063,     0,     0,
       0,     0,     0,  1862,     0,  1863,     0,   645,     0,     0,
    1063,     0,  1063,     0,     0,  3518,  1063,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     794,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1063,     0,  1063,  1063,     0,     0, -1996,
       0,     0,     0,  1856,     0,     0,     0,     0,   645,     0,
       0,     0,     0,     0,     0,     0,  1063,     0,  1864,     0,
       0,     0,  1063,  1857,  1858,  1855,     0,     0,     0,  1856,
       0,  1063,  1063,  1063,     0,     0, -1996,  1029,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1857,
    1858,     0,     0,     0,     0,     0,     0,  1624,     0,     0,
       0,   794,  1859,  1063,     0,     0,     0,     0,     0,     0,
       0,     0,  1861,     0,     0,     0,  1622,     0,     0,     0,
    1622,  1622,     0,     0,  1633,  1633,  1862,  1633,     0,   794,
       0,  1624,     0,     0,     0,  1860,     0,   794,  1861,     0,
    1633,     0,  1633,  1865,     0,  1624,     0,  2257,     0,     0,
       0,     0,  1862,     0,  1863,     0,  1866,  1867,  1868,     0,
    1869,  1870,  1871,  1872,  1873,  1874,     0,     0,     0,     0,
       0,  1633,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1850,     0,     0,     0,     0,     0,     0,     0,
       0, -1996,     0,     0,     0,     0,  1624,  1851,     0,     0,
       0,     0,     0,     0,     0,  1853,     0,     0,  1850,     0,
    1854,     0,     0,  1624,     0,     0,     0,  1864,     0,     0,
    1633,  1622,     0,  1851,     0,     0,     0,   645,     0,     0,
    1624,  1853,     0,     0,     0,     0,  1854,     0,     0,     0,
       0,  1633,  1622,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1624,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   645,     0,     0,     0,
     751,  1633,     0,     0,     0,     0,  1865,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1633,     0,     0,     0,
       0,     0,   645,  1869,  1870,  1871,  1872,  1873,  1874,  1633,
       0,     0,  1865,  1624,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1633,  1624,  1866,  1867,  1868,     0,  1869,
    1870,  1871,  1872,  1873,  1874,     0,  1855,     0,     0,  1063,
    1856,     0,     0,  1063,     0,     0,     0,     0,     0,     0,
    1037,  1038,     0,  1063,     0,     0,     0,     0,  1633,     0,
    1857,  1858,  1855,     0,  1633,     0,  1856,     0,     0,     0,
       0,     0,   794,  1859,     0,     0,     0,     0,  2257,     0,
       0,     0,  1063,     0,     0,     0,  1857,  1858,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1859,
       0,     0,     0,     0,     0,     0,  1860,  1622,     0,  1861,
       0,     0,  1063,     0,     0,  1633,     0,     0,     0,     0,
       0,  1063,     0,  1862,     0,  1863,     0,  1063,     0,  1063,
       0,     0,  1860,  1633,  1063,  1861,  2856,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,     0,     0,  1862,
       0,  1063,  1063,     0,     0,     0,     0,     0,     0,     0,
    1633,     0,     0,     0,     0,  1063,     0,     0,     0,   751,
       0,  1063,     0,     0,     0,     0,  1624,     0,     0,  1094,
    1063,     0,  1098,  1063,  1100,  1063,     0,     0,  1864,     0,
       0,     0,     0,  1633,  1063,  1063,  1063,     0,     0,     0,
    1063,     0,     0,  1063,     0,     0,     0,  1144,     0,     0,
       0,     0,     0,  1063,  1864,     0,     0,     0,     0,     0,
    1161,     0,     0,     0,  1163,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1029,     0,   842,     0,     0,     0,     0,     0,     0,
      73,     0,     0,     0,     0,  1187,     0,   900,     0,   900,
       0,   900,     0,     0,     0,     0,  1205,   900,   900,     0,
    1207,     0,  1210,  1865,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1866,  1867,  1868,     0,
    1869,  1870,  1871,  1872,  1873,  1874,     0,     0,  1239,  1865,
    1240,     0,     0,     0,     0,     0,  1029,     0,     0,     0,
       0,  1633,  1866,  1867,  1868,     0,  1869,  1870,  1871,  1872,
    1873,  1874,     0,     0,     0,     0,   794,  1258,     0,  1259,
       0,     0,     0,     0,     0,   794,     0,  1622,  1622,     0,
    1622,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1622,   794,  1622,     0,     0,  1029,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2257,     0,  1624,     0,  2257,     0,
    1624,  1624,     0,     0,  1622,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1447,     0,     0,     0,     0,  1063,
       0,   794,     0,   794,     0,     0,     0,     0,   794,     0,
    1633,     0,  1447,     0,     0,     0,     0,  1058,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1622,     0,  1850,     0,   794,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1473,
    1851,     0,  1475,  2887,  1622,  1477,     0,     0,  1853,     0,
       0,  1063,     0,  1854,     0,     0,  1063,     0,     0,  1063,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1624,     0,     0,  1622,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1622,
       0,     0,  1624,     0,     0,     0,  1564,  1063,     0,     0,
       0,     0,  1622,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1622,     0,     0,     0,
       0,  1586,     0,     0,     0,     0,     0,  1588,     0,     0,
       0,  1590,     0,  1063,     0,   794,   794,     0,  1636,     0,
    1063,  1063,     0,     0,     0,     0,     0,  1063,  1063,     0,
       0,  1622,  1063,  1633,     0,     0,     0,  1622,  1063,  1063,
       0,     0,  1063,     0,     0,  1670,     0,     0,     0,  1855,
       0,     0,     0,  1856,     0,     0,     0,     0,   939,     0,
      73,    73,     0,    73,     0,   939,     0,   939,     0,     0,
       0,     0,     0,  1857,  1858,     0,     0,     0,     0,     0,
    1633,  1850,     0,     0,     0,     0,  1859,     0,  1622,     0,
       0,     0,     0,     0,     0,     0,  1851,     0,     0,  2896,
       0,     0,     0,     0,  1853,     0,  1622,     0,     0,  1854,
    1739,  1850,     0,     0,     0,     0,     0,     0,     0,  1860,
       0,     0,  1861,     0,  1768,     0,  1851,  1624,     0,     0,
       0,     0,     0,  1622,  1853,     0,  1862,     0,  1863,  1854,
       0,     0,     0,     0,     0,     0,     0,  1063,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1622,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   794,  1063,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1864,     0,  1063,     0,     0,     0,  1063,     0,     0,
     794,     0,  1633,     0,     0,     0,     0,     0,     0,     0,
     794,     0,     0,     0,     0,  1855,     0,     0,     0,  1856,
       0,     0,  1447,     0,  1063,     0,  1447,  1447,  1063,     0,
    2892,     0,     0,     0,     0,     0,     0,     0,     0,  1857,
    1858,     0,     0,     0,     0,  1855,     0,  1063,  1063,  1856,
       0,  1063,  1859,     0,     0,     0,  2257,     0,  1063,  1063,
       0,  2257,     0,     0,  2257,     0,     0,     0,     0,  1857,
    1858,     0,     0,     0,  1622,     0,  1865,     0,  1063,  1991,
       0,     0,  1859,     0,     0,  1860,     0,     0,  1861,  1866,
    1867,  1868,  1063,  1869,  1870,  1871,  1872,  1873,  1874,     0,
       0,     0,  1862,     0,  1863,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1860,     0,  1063,  1861,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1862,  1447,  1863,     0,  2004,     0,     0,  1447,
       0,     0,     0,     0,     0,     0,     0,  1624,  1624,     0,
    1624,  1625,     0,  1063,  1063,     0,     0,     0,     0,     0,
       0,     0,     0,  1624,     0,  1624,     0,  1864,     0,   794,
     794,   794,   794,  1622,     0,     0,     0,     0,     0,     0,
    1063,  1063,     0,  1063,     0,  1063,     0,     0,     0,     0,
       0,     0,     0,     0,  1624,     0,     0,  1864,     0,     0,
       0,     0,     0,     0,  1633,     0,     0,     0,  1633,  1633,
       0,     0,     0,     0,     0,  1447,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1624,     0,     0,     0,     0,     0,     0,
       0,     0,  1865,  1063,     0,     0,     0,     0,     0,     0,
       0,  1625,     0,     0,  1624,  1866,  1867,  1868,     0,  1869,
    1870,  1871,  1872,  1873,  1874,  1633,     0,     0,     0,     0,
       0,     0,  1865,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1624,  1866,  1867,  1868,     0,  1869,
    1870,  1871,  1872,  1873,  1874,     0,     0,   900,     0,  1624,
       0,  2215,     0,  1058,  1063,     0,     0,     0,     0,     0,
       0,     0,  1624,     0,     0,     0,  1622,     0,     0,  1063,
       0,     0,  2257,     0,     0,     0,  1624,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    73,     0,  2268,     0,    73,     0,     0,     0,
       0,     0,     0,  2277,     0,  2279,     0,     0,  1063,  1063,
    2280,  1624,     0,  1622,     0,     0,     0,  1624,     0,  2300,
       0,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2295,   842,  1063,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1060,  1058,     0,     0,  1060,     0,     0,     0,
       0,     0,     0,     0,     0,  1850,     0,     0,  1624,     0,
     900,   900,     0,     0,     0,     0,     0,     0,   900,     0,
    1851,     0,   900,   900,     0,     0,  1624,     0,  1853,  1060,
       0,     0,  1058,  1854,   794,     0,     0,   900,     0,   900,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1624,     0,   794,     0,     0,     0,   900,
       0,   900,     0,     0,     0,     0,     0,  1625,  1058,     0,
       0,     0,     0,     0,     0,     0,   794,  1060,     0,     0,
       0,     0, -1995,  1060,     0,  1622,  1624,     0,     0,     0,
       0,  1850,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1625,     0,     0,     0,     0,  1851,     0,  2300,     0,
       0,     0,     0,     0,  1853,  1625,   794,     0,     0,  1854,
       0,     0,     0,     0,     0,     0,     0,     0, -1995,  2477,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1995,     0,     0,     0,     0, -1995,     0,     0,  1855,
       0, -1995,     0,  1856, -1995,     0, -1995,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1625,     0,  1058,     0,
       0,     0,     0,  1857,  1858,     0,     0,     0,     0,  1060,
       0, -1995,     0,  1625,   939,     0,  1859,   939,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1995,
    1625,     0,     0,     0,  1624,     0,  1447,     0,     0,     0,
    1060,     0,     0,     0,  1447,     0,    73,     0,    73,  1860,
       0,     0,  1861,     0,     0,  1625,     0,     0,     0,  1058,
       0,     0,     0,     0,     0,  1855,  1862,     0,  1863,  1856,
       0,     0,  1029, -1995,  1058,     0,     0,     0,     0,     0,
       0, -1995,     0,     0,     0,  2534,     0,     0,     0,  1857,
    1858,     0,     0,  2541,     0,     0,     0,     0,     0,  2545,
       0,     0,  1859,  1625,  2549,     0,     0,     0,     0,     0,
    2555,     0,     0,  1058,  1625,  2557,     0,  1622,     0, -1995,
       0,  1622,  1622,     0,     0,     0,     0,  1058,     0,     0,
       0,  1864,   900,  1624,  2571,  1860,  2572,     0,  1861,  1058,
       0,  1447,     0,     0,  1447,  1447,     0,     0,     0,     0,
       0,     0,  1862,     0,  1863,     0,  3234,     0,     0,     0,
       0,     0,   917,     0,     0,     0,  1060,  2593,  2594,  2595,
       0,     0,     0,  1060,     0,     0,     0,     0,     0,  1060,
       0,     0,     0, -1995,  2610,  2611,  2614,  2615,  1622,     0,
       0,  2621,  2624,     0,     0,  2626,  2627,  2628,     0,     0,
    1631,  2634,     0, -1995,     0,     0,     0,     0,  2647,     0,
       0,  2649,     0,     0,     0,     0,  1865,  1864,     0,     0,
       0,   900,     0, -1995, -1995, -1995,   900,  1060,     0,  1866,
    1867,  1868,     0,  1869,  1870,  1871,  1872,  1873,  1874,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1995,     0,     0, -1995, -1995, -1995,     0,     0,
       0,     0,     0,     0,     0,     0,  1625,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1060,     0,     0,  1624,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1865,     0,     0,     0,     0,     0,     0,     0,
    1631,     0,     0,     0,     0,  1866,  1867,  1868,     0,  1869,
    1870,  1871,  1872,  1873,  1874,     0,     0,     0,     0,     0,
       0,  1060,     0,  1624,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1060,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1029,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1060,  1060,     0,
    1060,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1060,     0,  2828,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   644,
       0,     0,     0,     0,     0,  1624,  1625,     0,     0,     0,
    1625,  1625,     0,     0,     0,     0,  1060,     0,     0,  1060,
    1060,     0,     0,     0,     0,     0,     0,     0,     0,   804,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   805,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   806,     0,     0,  2300,     0,   900,     0,  1447,     0,
       0,     0,     0,     0,   903,     0,  1631,     0,     0,     0,
     807,     0,     0,  -513,   939,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   644,     0,   903,     0,     0,     0,
     808,     0,     0,   939,     0,     0,   809,     0,     0,     0,
    1631,  1625,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   810,     0,     0,  1631,     0,     0,     0,     0,     0,
       0,     0,  1625,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2999,  3000,     0,     0,     0,     0,     0,
       0,     0,  -667,     0,   811,     0,     0,     0,   812,     0,
       0,     0,     0,     0,   900,     0,     0,     0,     0,     0,
       0,     0,  -647,     0,     0,  1631,     0,     0,     0,     0,
       0,  1447,     0,     0,     0,     0,     0,     0,  1447,  1447,
       0,     0,  1631,     0,     0,  -424,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   813,  1624,     0,  1631,
       0,  1624,  1624,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3042,
    3043,  3044,  3045,     0,  1631,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   814,     0,   815,     0,     0,     0,     0,     0,
       0,  1447,     0,  3058,     0,     0,   900,     0,   900,     0,
       0,     0,     0,     0,     0,  -424,     0,  1060,  1624,  1060,
    3112,     0,  1631,     0,  1060,     0,     0,  1625,     0,     0,
       0,  1447,     0,  1631,     0,     0,     0,   816,     0,     0,
       0,  -667,     0,   817,     0,     0,     0,     0,     0,     0,
       0,  3119,  3121,  3123,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1627,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   842,   818,   819,     0,
     820,   821,     0,     0,     0,     0,  1060,     0,     0,   822,
       0,     0,     0,   823,   824,     0,  3167,     0,   825,     0,
       0,     0,     0,   826,     0,     0,     0,     0,     0,     0,
       0,   842,     0,     0,     0,     0,     0,     0,     0,     0,
    1060,  1060,     0,     0,     0,     0,     0,     0,  1060,     0,
       0,  1060,     0,     0,  1060,     0,     0,     0,     0,     0,
       0,     0,  1060,  1060,     0,     0,     0,     0,     0,     0,
    1060,     0,     0,  1060,  1060,  1060,  1060,     0,     0,     0,
       0,     0,     0,  1060,  1060,     0,  1060,     0,  1060,     0,
       0,  1060,     0,     0,  1627,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1631,  1060,     0,     0,     0,
    1060,     0,     0,     0,  1060,     0,     0,     0,  1060,     0,
       0,  1060,  1060,  1060,  1060,  1060,  1060,  1060,  1060,  1060,
       0,  1060,     0,     0,     0,     0,  1060,     0,     0,     0,
    1060,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1625,  1625,     0,
    1625,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1625,     0,  1625,     0,     0,     0,     0,
       0,  1060,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1625,     0,     0,     0,     0,     0,
       0,     0,     0,  3322,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1625,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1060,     0,     0,     0,     0,
       0,     0,     0,     0,  1625,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1631,     0,     0,     0,  1631,
    1631,     0,     0,     0,     0,     0,     0,     0,  3353,     0,
    1627,     0,     0,  3360,  1625,  3362,  3363,  3364,  3365,     0,
       0,     0,     0,  1991,     0,     0,     0,     0,     0,  1625,
     900,     0,     0,     0,     0,   900,   900,   900,   900,   900,
       0,     0,  1625,   900,  1627,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1625,     0,  1627,     0,
       0,     0,   644,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3405,     0,     0,
       0,  1625,     0,  1060,     0,     0,     0,  1625,     0,     0,
    1631,     0,     0,     0,     0,     0,     0,     0,     0,  1627,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1060,
    1628,  1631,     0,     0,     0,     0,  1627,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1627,     0,     0,     0,   903,  1625,   903,
       0,   903,     0,     0,     0,     0,     0,   903,   903,     0,
       0,     0,     0,  3472,     0,     0,  1625,     0,  1627,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   644,     0,     0,     0,     0,
       0,     0,     0,  1625,  1060,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1060,     0,     0,     0,     0,     0,
       0,     0,   644,     0,     0,     0,  1627,     0,     0,     0,
       0,     0,     0,   644,   644,     0,  1625,  1627,     0,     0,
    1628,     0,     0,     0,     0,     0,  1060,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2300,     0,     0,
       0,     0,     0,     0,     0,     0,    73,     0,   900,     0,
       0,     0,     0,     0,     0,  1060,     0,     0,   900,   900,
       0,     0,     0,   900,   900,     0,  1631,     0,     0,     0,
       0,     0,     0,   900,  1451,     0,     0,     0,     0,     0,
       0,     0,     0,  1060,  1060,     0,  3544,     0,   644,   644,
       0,     0,  1451,     0,     0,     0,     0,  3553,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1060,     0,     0,     0,  1060,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1060,
    1060,  1060,  1060,     0,  1625,     0,     0,     0,     0,     0,
       0,  1060,     0,     0,     0,     0,  1060,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1060,  1060,     0,  1060,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1627,
       0,     0,  1060,     0,  1060,     0,     0,     0,  1060,     0,
       0,     0,     0,     0,  3612,     0,     0,     0,     0,     0,
       0,  3167,     0,     0,  1060,   644,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1060,     0,  1060,  1060,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1060,     0,
       0,     0,     0,  1625,  1060,     0,     0,     0,     0,     0,
       0,     0,     0,  1060,  1060,  1060,  1628,     0,     0,     0,
       0,     0,  3664,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   644,     0,     0,     0,
       0,     0,     0,     0,     0,  1060,     0,     0,     0,     0,
    1628,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1628,     0,  1631,  1631,     0,  1631,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1631,     0,  1631,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1631,     0,  1628,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1628,     0,     0,     0,     0,     0,     0,  1627,
       0,     0,     0,  1627,  1627,     0,     0,     0,     0,  1628,
       0,     0,     0,     0,     0,     0,  1625,     0,     0,     0,
     644,     0,  1631,     0,     0,     0,     0,     0,     0,     0,
     644,     0,     0,     0,  1628,     0,     0,     0,     0,     0,
       0,     0,     0,  1631,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1625,     0,     0,     0,     0,     0,   644,
       0,     0,  1451,  1631,     0,     0,  1451,  1451,     0,     0,
       0,     0,  1628,  3763,     0,     0,     0,     0,  1631,     0,
       0,     0,     0,  1628,     0,     0,     0,     0,     0,     0,
       0,  1631,     0,     0,  1627,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1631,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1627,     0,     0,     0,     0,
       0,  1060,     0,     0,     0,  1060,     0,     0,   644,     0,
       0,     0,  3793,     0,     0,  1060,     0,     0,     0,     0,
    1631,     0,     0,     0,     0,     0,  1631,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1060,     0,     0,     0,     0,     0,
       0,     0,     0,  1451,     0,     0,     0,     0,     0,  1451,
       0,     0,     0,     0,     0,  1625,     0,     0,     0,     0,
       0,     0,     0,     0,  1060,     0,     0,  1631,     0,     0,
       0,     0,     0,  1060,     0,     0,     0,     0,     0,  1060,
       0,  1060,     0,     0,     0,  1631,  1060,     0,     0,  1060,
    1060,  1060,  1060,  1060,  1060,  1060,  1060,  1060,  1060,     0,
       0,     0,     0,  1060,  1060,  1628,     0,     0,     0,     0,
       0,     0,  1631,     0,     0,     0,     0,  1060,     0,     0,
       0,     0,     0,  1060,     0,  1451,     0,     0,     0,     0,
       0,     0,  1060,     0,     0,  1060,     0,  1060,     0,     0,
    1627,     0,     0,     0,     0,  1631,  1060,  1060,  1060,     0,
       0,     0,  1060,     0,     0,  1060,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1060,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   644,     0,
       0,     0,     0,     0,     0,     0,     0,   903,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1625,     0,     0,
       0,  1625,  1625,  1631,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1628,     0,     0,     0,  1628,
    1628,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1625,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     903,   903,     0,     0,     0,     0,     0,   644,   903,     0,
       0,  1060,   903,   903,     0,     0,     0,     0,     0,     0,
       0,     0,  1631,     0,     0,     0,     0,   903,     0,   903,
    1627,  1627,     0,  1627,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1627,     0,  1627,   903,
       0,   903,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1064,     0,     0,     0,  1064,
    1628,     0,     0,  1060,     0,     0,     0,  1627,  1060,     0,
       0,  1060,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1628,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1064,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   644,     0,     0,     0,     0,  1060,
       0,     0,     0,     0,     0,     0,  1627,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1627,     0,     0,
    1064,     0,     0,     0,     0,  1060,  1064,     0,     0,     0,
       0,     0,  1060,  1060,     0,     0,     0,     0,     0,  1060,
    1060,     0,     0,     0,  1060,  1631,     0,  1627,     0,     0,
    1060,  1060,     0,     0,  1060,     0,     0,     0,     0,     0,
       0,     0,  1627,     0,     0,     0,  1451,     0,     0,     0,
     644,     0,     0,     0,  1451,  1627,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1627,
       0,     0,  1631,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1628,     0,     0,     0,
       0,     0,  1064,     0,  1627,     0,     0,     0,     0,     0,
    1627,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1064,     0,     0,     0,     0,     0,  1060,
       0,     0,   903,     0,     0,     0,     0,     0,     0,     0,
       0,  1451,     0,     0,  1451,  1451,     0,     0,     0,     0,
       0,  1627,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1627,
    1060,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1060,     0,     0,     0,  1060,
       0,     0,     0,     0,  1631,     0,  1627,     0,     0,   644,
       0,     0,     0,     0,     0,     0,     0,   644,     0,     0,
       0,   644,     0,     0,     0,     0,  1060,     0,     0,     0,
    1060,   903,     0,     0,     0,     0,   903,     0,     0,  1627,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1060,
    1060,     0,     0,  1060,     0,     0,     0,     0,     0,  1064,
    1060,  1060,     0,     0,     0,     0,  1064,     0,     0,     0,
       0,     0,  1064,     0,     0,     0,     0,     0,     0,     0,
    1060,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     644,     0,     0,  1634,  1060,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1060,
    1064,     0,     0,     0,     0,     0,  1628,  1628,     0,  1628,
       0,     0,     0,     0,     0,     0,   644,     0,     0,     0,
       0,     0,  1628,     0,  1628,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1060,  1060,  1627,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1628,     0,     0,  1064,     0,     0,     0,
       0,     0,  1060,  1060,     0,  1060,     0,  1060,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1634,     0,     0,  1631,     0,     0,     0,
    1631,  1631,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1628,     0,  1064,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1628,     0,     0,     0,     0,     0,     0,
    1064,     0,     0,     0,     0,  1060,  1627,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1628,     0,     0,     0,  1631,     0,     0,
    1064,  1064,     0,  1064,     0,     0,     0,     0,  1628,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1064,  1628,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1628,  1060,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1060,     0,     0,     0,     0,   903,     0,  1451,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1628,     0,     0,     0,     0,     0,  1628,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1064,
    1060,  1060,  1064,  1064,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1060,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1060,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1628,     0,  1627,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1628,     0,     0,     0,  1634,
       0,     0,     0,     0,   903,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1451,  1628,     0,     0,     0,  1627,     0,  1451,  1451,
       0,     0,     0,  1634,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1634,     0,     0,
       0,     0,     0,     0,     0,  1628,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   644,
       0,   644,   644,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   644,     0,     0,  1634,     0,
       0,  1451,     0,     0,     0,     0,   903,     0,   903,     0,
       0,     0,     0,     0,  1629,  1634,     0,     0,     0,     0,
    3115,   644,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1451,  1634,     0,  1632,     0,     0,     0,     0,     0,
       0,     0,     0,   644,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1634,  1627,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   644,   644,  1628,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1064,     0,  1064,     0,     0,  1634,     0,  1064,     0,     0,
       0,     0,     0,     0,     0,     0,  1634,     0,     0,     0,
       0,     0,     0,     0,  1629,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1632,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1064,
       0,     0,  1628,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1064,  1064,     0,     0,     0,     0,     0,
       0,  1064,     0,     0,  1064,     0,     0,  1064,     0,     0,
       0,     0,     0,     0,     0,  1064,  1064,     0,     0,   644,
       0,     0,     0,  1064,     0,     0,  1064,  1064,  1064,  1064,
       0,     0,     0,     0,     0,     0,  1064,  1064,     0,  1064,
       0,  1064,     0,     0,  1064,     0,     0,     0,     0,     0,
    1627,     0,     0,     0,  1627,  1627,     0,     0,  1634,  1064,
       0,     0,     0,  1064,     0,     0,     0,  1064,     0,     0,
       0,  1064,     0,     0,  1064,  1064,  1064,  1064,  1064,  1064,
    1064,  1064,  1064,     0,  1064,     0,     0,     0,     0,  1064,
       0,     0,     0,  1064,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1628,     0,     0,     0,     0,
       0,  1627,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1629,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1064,     0,     0,     0,     0,     0,
    1632,     0,  1628,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1629,     0,     0,     0,     0,     0,
     644,   644,   644,   644,   644,   644,     0,     0,  1629,     0,
       0,     0,     0,     0,  2058,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1632,     0,
     903,     0,     0,     0,     0,   903,   903,   903,   903,   903,
       0,     0,     0,   903,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1064,  1629,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1629,     0,  1634,  1632,
       0,     0,  1634,  1634,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1629,     0,     0,  1632,     0,     0,     0,
       0,   644,     0,     0,     0,  1348,     0,     0,     0,     0,
       0,     0,     0,  1632,  1628,     0,     0,     0,  1629,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1411,     0,  1632,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1629,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1064,  1629,     0,     0,
       0,     0,     0,  1634,     0,     0,  1632,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1632,     0,     0,
       0,     0,  1064,     0,  1634,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   644,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   903,     0,
       0,     0,  1571,     0,     0,     0,     0,     0,   903,   903,
       0,     0,     0,   903,   903,     0,     0,  1064,     0,     0,
       0,     0,     0,   903,     0,     0,     0,  1064,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     644,   644,   644,     0,     0,     0,     0,     0,     0,     0,
     644,   644,     0,     0,     0,   644,  1628,     0,     0,  1064,
    1628,  1628,     0,     0,     0,     0,     0,     0,     0,  1629,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1064,  1632,
       0,     0,     0,     0,   644,     0,     0,     0,     0,  1634,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1064,  1064,     0,   644,
       0,     0,     0,     0,     0,     0,     0,  1628,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1064,     0,     0,     0,
    1064,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1064,  1064,  1064,  1064,     0,  1791,     0,     0,
       0,     0,     0,     0,  1064,     0,     0,     0,     0,  1064,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1064,
    1064,     0,  1064,  1814,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1064,     0,  1064,     0,     0,
       0,  1064,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1838,  1839,     0,  1842,  1064,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1064,   644,
    1064,  1064,     0,  1879,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1064,     0,     0,     0,     0,     0,  1064,     0,  1629,
       0,     0,     0,  1629,  1629,     0,  1064,  1064,  1064,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2559,
     644,     0,     0,  2058,  2566,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1064,     0,
       0,     0,  1955,     0,     0,  1962,  1964,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1634,
    1634,     0,  1634,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1634,     0,  1634,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1629,     0,  1634,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1632,  1629,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1632,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1634,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1634,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1634,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1876,     0,
       0,  1634,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1634,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1634,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1064,     0,     0,     0,  1064,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1064,     0,
    1629,  1876,     0,  1634,     0,     0,     0,     0,     0,  1634,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1632,     0,     0,     0,     0,     0,     0,  1064,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1064,     0,     0,
    1634,     0,     0,     0,     0,     0,  1064,     0,     0,     0,
       0,     0,  1064,     0,  1064,     0,     0,     0,  1634,  1064,
       0,     0,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,
    1064,  1064,     0,     0,     0,     0,  1064,  1064,     0,     0,
       0,     0,     0,     0,     0,  1634,     0,     0,     0,     0,
    1064,     0,     0,     0,     0,     0,  1064,     0,     0,     0,
       0,     0,     0,     0,     0,  1064,     0,     0,  1064,     0,
    1064,     0,     0,     0,  2352,     0,     0,     0,  1634,  1064,
    1064,  1064,     0,     0,     0,  1064,     0,     0,  1064,     0,
       0,     0,     0,     0,     0,     0,  2374,     0,  1064,  2376,
       0,  1876,  2386,     0,     0,     0,     0,     0,     0,  2393,
    2398,     0,     0,     0,  2403,     0,     0,  2408,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2417,     0,     0,     0,  2423,     0,     0,     0,
    2435,     0,     0,     0,  2442,     0,     0,  2444,  2445,  2446,
    2447,  2448,  2449,  2450,  2451,  2452,     0,  2453,     0,     0,
       0,     0,  1348,     0,     0,     0,     0,     0,     0,     0,
    1629,  1629,     0,  1629,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1629,     0,  1629,     0,
    2058,  2566,     0,  2566,     0,     0,  1634,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1632,     0,  1632,     0,
       0,     0,     0,     0,     0,     0,     0,  1629,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1411,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1632,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1876,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1629,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1064,     0,  1632,  1629,     0,     0,
       0,     0,     0,     0,     0,  1634,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2566,     0,     0,
       0,  2547,     0,     0,     0,     0,     0,  1629,     0,     0,
       0,  1876,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1629,     0,     0,     0,     0,  2566,     0,     0,
       0,     0,     0,     0,  1876,  1629,  1064,     0,     0,  2382,
       0,  1064,  1632,     0,  1064,     0,     0,     0,     0,  1629,
       0,     0,     0,     0,     0,  1632,     0,     0,  1876,  1876,
       0,     0,  1876,     0,     0,     0,     0,     0,     0,  2566,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1064,     0,  1629,     0,     0,     0,     0,     0,
    1629,     0,     0,     0,     0,     0,     0,     0,     0,  1876,
       0,     0,     0,     0,  1632,     0,     0,     0,     0,     0,
    1632,     0,     0,     0,     0,     0,     0,     0,  1064,  2655,
       0,     0,     0,     0,     0,  1064,  1064,     0,     0,     0,
       0,     0,  1064,  1064,     0,     0,     0,  1064,  1634,     0,
       0,  1629,     0,  1064,  1064,  2679,     0,  1064,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1629,
       0,  1632,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1876,     0,     0,     0,  1632,
       0,     0,  1876,     0,  1876,  1634,  1629,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1632,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1629,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2782,     0,     0,     0,     0,     0,     0,     0,     0,  1632,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1064,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2799,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1348,     0,  1064,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1064,     0,
       0,     0,  1064,     0,     0,     0,     0,  1634,     0,     0,
    2838,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1629,     0,  1064,
       0,     0,     0,  1064,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1632,     0,     0,
       0,     0,  1064,  1064,     0,  2398,  1064,  2398,  2398,     0,
       0,     0,     0,  1064,  1064,     0,     0,  2899,     0,     0,
       0,     0,  2903,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1064,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1064,  2924,     0,
    2926,     0,     0,     0,  2929,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1064,     0,     0,     0,  1629,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1632,     0,     0,     0,
       0,     0,     0,     0,  1411,     0,     0,     0,  1064,  1064,
    1955,     0,     0,     0,     0,     0,     0,     0,     0,  1964,
    1964,  1962,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1064,  1064,     0,  1064,     0,
    1064,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3002,     0,     0,     0,     0,     0,     0,     0,  1634,
       0,     0,     0,  1634,  1634,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1064,     0,
       0,     0,  1876,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1629,
    1634,     0,     0,     0,  1876,     0,  1876,     0,  2382,  2874,
       0,     0,  2382,     0,     0,     0,  1876,     0,     0,  1632,
       0,     0,     0,  1876,     0,     0,     0,     0,  1876,     0,
       0,     0,     0,  1876,     0,     0,     0,     0,  1876,  1064,
       0,     0,     0,     0,     0,     0,  1629,  1876,     0,     0,
       0,  2382,  2382,  1876,  1064,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1876,  1632,     0,     0,     0,
       0,     0,  1876,     0,  1876,  1876,  1876,  1876,  1876,  1876,
    1876,  1876,  1876,  1876,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1064,  1064,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1064,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1064,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1876,  1629,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1632,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3235,     0,     0,     0,     0,     0,     0,     0,     0,  3238,
       0,     0,     0,     0,     0,  3239,     0,  3240,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3258,
    3259,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2403,
       0,     0,     0,     0,     0,  1876,     0,     0,  3283,     0,
       0,  3286,     0,  3288,     0,     0,     0,     4,     0,     0,
       0,     0,  3292,     0,     0,     0,     0,     0,  3297,  1876,
       0,  3300,     0,     0,     0,     0,     0,     0,     5,     0,
       0,  3307,     0,     0,     0,     0,     0,     0,     6,     7,
       0,     0,     0,     0,     8,     0,     9,    10,     0,     0,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1629,     0,     0,     0,  1629,  1629,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1632,     0,     0,     0,  1632,  1632,    35,     0,     0,     0,
       0,     0,  1876,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1876,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1629,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1876,     0,
       0,  1632,     0,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,     0,  2874,
       0,  2382,     0,     0,  2382,  2382,  2382,  2382,  2382,  2382,
    2382,  2382,  2382,  2382,     0,  2874,    38,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    39,     0,     0,  1876,
       0,     0,     0,  1876,     0,     0,     0,     0,  2874,  2874,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2382,  2382,  1876,     0,  1876,     0,    40,  1876,
       0,    41,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3487,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1876,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,     0,     0,     0,     0,     0,  3503,  3505,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3511,     0,     0,     0,     0,     0,  3516,  3517,     0,     0,
    3519,     0,     0,     0,     0,     0,     0,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,     0,
       0,     0,     0,    48,    49,     0,    50,     0,    51,     0,
       0,     0,    52,    53,    54,    55,  2382,    56,    57,     0,
       0,     0,    58,    59,    60,    61,    62,     0,     4,    63,
      64,    65,    66,     0,    67,    68,    69,     0,    70,    71,
       0,     0,     0,     0,     0,  3588,     0,     0,     0,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     6,
       7,     0,     0,     0,     0,     0,     0,     9,    10,     0,
       0,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,     0,     0,     0,     0,     0,
       0,  3632,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1876,     0,     0,  1876,  1876,
    1876,     0,     0,  2874,     0,     0,     0,    35,  2874,  2874,
    2874,  2874,  2874,  2874,  2874,  2874,  2874,  2874,  1876,  1876,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3661,
       0,     0,     0,     0,     0,     0,     0,  3663,     0,     0,
       0,     0,     0,  1876,  2382,  2382,  1876,     0,  1876,     0,
       0,     0,  1876,  2874,  2874,     0,     0,  1876,     0,     0,
    1876,     0,     0,     0,     0,     0,     0,  1876,     0,     0,
    3678,     0,     0,     0,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    38,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    39,     0,     0,
       0,     0,  3718,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    40,
       0,  2403,    41,     0,     0,     0,  2874,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1876,     0,     0,
      43,  2382,     0,     0,     0,  2382,     0,     0,     0,     0,
       0,     0,     0,  1876,     0,  1876,     0,     0,     0,  2874,
    2874,  1876,     0,     0,  2382,  2382,  1876,  1876,     0,  1876,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
       0,     0,     0,     0,    48,    49,     0,    50,  1876,     0,
       0,     0,     0,    52,    53,    54,    55,     0,    56,    57,
       0,     0,     0,    58,    59,    60,    61,    62,     0,     0,
      63,    64,  1217,     0,     0,     0,  1218,     0,     0,     0,
      71,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1876,     0,     0,     0,     4,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2874,  2382,  2382,  2874,
       0,     0,     0,     0,     0,     0,     0,     5,     0,  2874,
    2874,  1876,     0,  1876,     0,     0,     0,     6,     7,     0,
       0,     0,     0,     0,     0,     9,    10,     0,  1876,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,     0,     4,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1876,     0,
       0,     0,     0,     0,     0,     5,     0,     0,     0,     0,
    2874,  2874,     0,     0,     0,     6,     7,     0,     0,     0,
       0,     0,     0,     9,    10,    35,     0,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,    35,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    38,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    39,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,     0,     0,    40,     0,     0,
      41,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    38,     0,     0,     0,     0,     0,     0,
       0,     0,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    39,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     4,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    40,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     6,     7,     0,    43,     0,
      42,     0,     0,     9,    10,     0,     0,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,     0,     0,     0,     0,     0,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    45,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,     0,     0,     0,    43,     0,     0,     0,
       0,     0,     0,    35,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,     0,     0,
       0,     0,    48,    49,     0,    50,     0,     0,     0,     0,
       0,    52,    53,    54,    55,    44,    56,    57,     0,     0,
       0,    58,    59,    60,    61,    62,     0,    45,    63,    64,
    1217,  1718,     0,     0,     0,     0,     0,     0,    71,     0,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,    37,     0,     0,     0,     0,     0,
      48,    49,     0,    50,     0,     0,     0,     0,     0,    52,
      53,    54,    55,    38,    56,    57,     0,     0,     0,    58,
      59,    60,    61,    62,     0,     0,    63,    64,  1217,  2287,
       0,     0,     0,    39,     0,     0,    71,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    40,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    44,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,     0,     0,     0,     0,
      48,    49,     0,    50,     0,     0,     0,     0,     0,    52,
      53,    54,    55,     0,    56,    57,     0,     0,     0,    58,
      59,    60,    61,    62,     0,     0,    63,    64,  1217,     0,
       0,     0,     0,     0,     0,     0,    71,   663,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,   664,   102,
     103,   389,   665,     0,   105,   106,   107,   108,   666,   667,
     110,   111,   112,   113,     0,   114,   668,   669,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   670,   407,   408,   409,   671,   672,   673,
     674,   675,   676,   677,   410,   411,   678,   412,   131,   413,
     414,   415,   133,   134,   135,   136,     0,   679,   416,   417,
       0,   418,   419,   680,   681,   420,   682,   137,   422,   683,
     423,   424,   425,   426,   141,   684,   685,   427,   428,   429,
     430,   431,   432,   686,   433,   434,   435,   436,   437,   687,
     438,   439,   440,   146,   441,   688,   689,   690,   691,   692,
     693,   442,   443,   444,   445,   446,   149,   150,   447,   694,
     448,   695,   449,     0,   450,   451,   452,   696,   453,   454,
     455,   697,   698,   456,   457,   458,   459,   460,   699,   461,
     462,   463,   700,     0,   464,   701,   465,   466,   467,   158,
     468,   469,   160,   702,   470,   471,   472,   162,   703,   473,
     704,   474,   163,   705,   164,   475,     0,   476,   706,   477,
     167,   707,   478,   708,   479,   480,   481,   482,   168,   483,
     484,   485,   709,   486,   487,   488,   489,   490,   491,   710,
     169,   170,   711,   492,   493,   494,   712,   172,   713,   173,
     714,     0,   174,   175,   495,   176,   496,   497,   498,   499,
     500,   715,   177,   178,   501,   179,   716,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,   185,   186,   717,   518,
     519,   520,   521,   522,   523,   524,   187,   525,   718,   526,
     527,   189,   528,   719,   190,   529,   191,   530,   531,   720,
     721,   532,   722,   723,   724,   533,   534,   725,   726,   192,
     193,   194,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,   727,   544,   545,   546,   547,
     548,   549,   199,   550,   551,   728,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,   729,   562,   563,   205,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,   730,   573,   574,   575,   731,   576,   211,   577,   578,
     213,   579,   214,   732,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,   733,   591,   592,   734,
     593,   594,   595,   596,   597,   735,   217,   218,   736,   737,
     599,   219,   600,   220,   738,   601,   602,   603,   604,   605,
     739,   740,   606,   607,   608,   609,   741,   742,   610,   611,
     612,   613,     0,   228,   615,   229,   616,   617,   618,   743,
     744,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,     0,     0,     0,
      83,    84,    85,     0,    87,    88,    89,    90,    91,     0,
       0,     0,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,     0,     0,   877,   105,   106,   107,   108,
       0,   109,   110,   111,   112,   113,     0,   114,   115,   116,
       0,     0,     0,     0,     0,   119,   120,     0,     0,     0,
       0,   121,     0,     0,     0,     0,     0,     0,     0,     0,
     122,     0,   123,     0,   124,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     131,     0,     0,     0,   133,   134,   135,   136,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   137,
       0,     0,     0,     0,     0,     0,   141,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   146,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   149,   150,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   156,     0,     0,     0,     0,
       0,   158,     0,     0,   160,     0,     0,     0,     0,   162,
       0,     0,     0,     0,   163,     0,   164,     0,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,     0,
     168,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   169,   170,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,   174,   175,     0,   176,     0,     0,
       0,     0,     0,     0,   177,   178,     0,   179,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   184,   185,   186,
       0,     0,     0,     0,     0,     0,     0,     0,   187,     0,
       0,     0,     0,   189,     0,     0,   190,     0,   191,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   192,   193,   194,   195,     0,     0,     0,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   199,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   205,     0,     0,   207,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   211,
       0,     0,   213,     0,   214,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   216,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   217,   218,
       0,     0,     0,   219,     0,   220,     0,     0,     0,     0,
       0,     0,   223,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   228,     0,   229,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   230,
     231,   232,   233,   234,   235,   236,   237,     0,     0,     0,
       0,     0,     0,     0,     0,   238,     0,     0,   239,     0,
       0,     0,     0,    83,    84,    85,     0,    87,    88,    89,
      90,    91,     0,     0,     0,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,     0,     0,  2514,   105,
     106,   107,   108,     0,   109,   110,   111,   112,   113,     0,
     114,   115,   116,     0,     0,     0,     0,     0,   119,   120,
       0,     0,     0,     0,   121,     0,     0,     0,     0,     0,
       0,     0,     0,   122,     0,   123,     0,   124,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   131,     0,     0,     0,   133,   134,   135,
     136,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   137,     0,     0,     0,     0,     0,     0,   141,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   146,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   149,   150,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   156,     0,
       0,     0,     0,     0,   158,     0,     0,   160,     0,     0,
       0,     0,   162,     0,     0,     0,     0,   163,     0,   164,
       0,     0,     0,     0,     0,   167,     0,     0,     0,     0,
       0,     0,     0,   168,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   169,   170,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,   174,   175,     0,
     176,     0,     0,     0,     0,     0,     0,   177,   178,     0,
     179,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     184,   185,   186,     0,     0,     0,     0,     0,     0,     0,
       0,   187,     0,     0,     0,     0,   189,     0,     0,   190,
       0,   191,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   192,   193,   194,   195,     0,     0,
       0,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   199,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   205,     0,     0,   207,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   211,     0,     0,   213,     0,   214,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   216,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   217,   218,     0,     0,     0,   219,     0,   220,     0,
       0,     0,     0,     0,     0,   223,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   228,     0,
     229,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   230,   231,   232,   233,   234,   235,   236,   237,
       0,     0,     0,     0,     0,     0,     0,     0,   238,     0,
       0,   239,     0,    82,     0,     0,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,     0,    93,    94,    95,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   104,
       0,  2516,   105,   106,   107,   108,     0,   109,   110,   111,
     112,   113,     0,   114,   115,   116,   117,   118,     0,     0,
       0,   119,   120,     0,     0,     0,     0,   121,     0,     0,
       0,     0,     0,     0,     0,     0,   122,     0,   123,     0,
     124,   125,     0,   126,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   127,     0,   128,   129,     0,     0,     0,
       0,     0,     0,     0,     0,   130,   131,     0,     0,   132,
     133,   134,   135,   136,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   137,     0,     0,   138,     0,
     139,   140,   141,     0,     0,   142,   143,     0,     0,     0,
       0,     0,     0,     0,     0,   144,     0,   145,     0,     0,
       0,   146,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   147,     0,   148,   149,   150,   151,     0,     0,     0,
       0,     0,   152,     0,     0,     0,     0,     0,   153,     0,
       0,     0,     0,     0,   154,     0,     0,     0,     0,     0,
     155,   156,     0,     0,     0,     0,   157,   158,   159,     0,
     160,     0,     0,   161,     0,   162,     0,     0,     0,     0,
     163,     0,   164,     0,   165,     0,   166,     0,   167,     0,
       0,     0,     0,     0,     0,     0,   168,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   169,   170,
       0,     0,   171,     0,     0,   172,     0,   173,     0,     0,
     174,   175,     0,   176,     0,     0,     0,     0,     0,     0,
     177,   178,     0,   179,     0,   180,   181,     0,     0,     0,
       0,   182,     0,     0,     0,     0,     0,     0,     0,     0,
     183,     0,     0,   184,   185,   186,     0,     0,     0,     0,
       0,     0,     0,     0,   187,     0,     0,     0,   188,   189,
       0,     0,   190,     0,   191,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   192,   193,   194,
     195,     0,     0,     0,     0,     0,     0,     0,   196,   197,
       0,   198,     0,     0,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,   203,     0,     0,     0,     0,   204,   205,     0,   206,
     207,     0,     0,   208,     0,     0,     0,     0,     0,   209,
       0,     0,     0,    82,   210,   211,     0,   212,   213,    86,
     214,     0,     0,     0,   215,    92,     0,    93,     0,    95,
       0,     0,   216,     0,     0,     0,     0,     0,     0,   104,
       0,     0,     0,     0,   217,   218,     0,     0,     0,   219,
       0,   220,     0,   221,     0,   222,   117,   118,   223,     0,
       0,   224,     0,   225,     0,     0,   226,     0,     0,     0,
     227,   228,     0,   229,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   126,     0,   230,   231,   232,   233,   234,
     235,   236,   237,   127,     0,   128,   129,     0,     0,     0,
       0,   238,     0,     0,   239,     0,     0,     0,     0,   989,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   138,   240,
     139,   140,     0,     0,     0,   142,   143,     0,     0,     0,
       0,     0,     0,     0,     0,   144,     0,   145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   147,     0,   148,     0,     0,   151,     0,     0,     0,
       0,     0,   152,     0,     0,     0,     0,     0,   153,     0,
       0,     0,     0,     0,   154,     0,     0,     0,     0,     0,
     155,     0,     0,     0,     0,     0,   157,     0,   159,     0,
       0,     0,     0,   161,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   165,     0,   166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   171,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   180,   181,     0,     0,     0,
       0,   182,     0,     0,     0,     0,     0,     0,     0,     0,
     183,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   188,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   198,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,   203,     0,     0,     0,     0,   204,     0,     0,   206,
       0,     0,     0,   208,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   210,     0,     0,   212,     0,     0,
       0,     0,     0,     0,   215,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   221,     0,   222,     0,     0,     0,     0,
       0,   224,     0,   225,     0,     0,   226,     0,     0,     0,
     227,   663,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,   664,   102,   103,   389,   665,     0,   105,   106,
     107,   108,   666,   667,   110,   111,   112,   113,     0,   114,
     668,   669,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,   240,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,  2472,   407,   408,
     409,     0,     0,     0,     0,  1272,     0,     0,   410,   411,
       0,   412,   131,   413,   414,   415,   133,  1273,   135,  1274,
    1275,     0,   416,   417,     0,   418,   419,  1276,  1277,   420,
    1278,  1279,   422,     0,   423,   424,   425,   426,  1280,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,   146,   441,     0,
    1281,  1282,  1283,  1284,  1285,   442,   443,   444,   445,   446,
    1286,  1287,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,  2473,     0,   456,   457,  1288,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,  1289,   468,   469,  1290,  1291,   470,   471,
     472,  1292,     0,   473,     0,   474,   163,     0,   164,   475,
       0,   476,     0,   477,  1293,     0,   478,     0,   479,   480,
     481,   482,   168,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,   169,   170,     0,   492,   493,   494,
    1294,  1295,     0,  1296,     0,     0,   174,   175,   495,   176,
     496,   497,   498,   499,   500,     0,  1297,   178,   501,   179,
       0,   502,   503,   504,  1298,  1299,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,  1300,
     185,  1301,   792,   518,   519,   520,   521,   522,   523,   524,
     187,   525,  1302,   526,   527,   189,   528,  1303,  1304,   529,
    1305,   530,   531,     0,     0,   532,   793,     0,     0,  1306,
     534,     0,     0,   192,   193,   194,  1307,   535,   536,   537,
     538,   539,     0,   540,  1308,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,  1309,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,   205,   564,   565,  1310,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,  1311,
     576,   211,   577,   578,   213,   579,  1312,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,  1313,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
    1314,  1315,     0,     0,   599,  1316,   600,  1317,  1318,   601,
     602,   603,   604,   605,     0,  1319,   606,   607,   608,   609,
    1320,     0,   610,   611,   612,   613,   614,  1321,   615,   229,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,  1322,  1323,  1324,  1325,  1326,  1327,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,    49,  1328,
     239,   628,     0,     0,  1329,  1330,    52,    53,    54,    55,
    1331,    56,     0,     0,     0,     0,  1332,  1333,  2474,     0,
       0,     0,     0,     0,     0,  1335,  2475,   663,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,   664,   102,
     103,   389,   665,     0,   105,   106,   107,   108,   666,   667,
     110,   111,   112,   113,     0,   114,   668,   669,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,  1272,     0,     0,   410,   411,     0,   412,   131,   413,
     414,   415,   133,  1273,   135,  1274,  1275,     0,   416,   417,
       0,   418,   419,  1276,  1277,   420,  1278,  1279,   422,     0,
     423,   424,   425,   426,  1280,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,   146,   441,     0,  1281,  1282,  1283,  1284,
    1285,   442,   443,   444,   445,   446,  1286,  1287,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,  1288,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,  1289,
     468,   469,  1290,  1291,   470,   471,   472,  1292,     0,   473,
       0,   474,   163,     0,   164,   475,     0,   476,     0,   477,
    1293,     0,   478,     0,   479,   480,   481,   482,   168,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
     169,   170,     0,   492,   493,   494,  1294,  1295,     0,  1296,
       0,     0,   174,   175,   495,   176,   496,   497,   498,   499,
     500,     0,  1297,   178,   501,   179,     0,   502,   503,   504,
    1298,  1299,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,  1300,   185,  1301,   792,   518,
     519,   520,   521,   522,   523,   524,   187,   525,  1302,   526,
     527,   189,   528,  1303,  1304,   529,  1305,   530,   531,     0,
       0,   532,   793,     0,     0,  1306,   534,     0,     0,   192,
     193,   194,  1307,   535,   536,   537,   538,   539,     0,   540,
    1308,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,  1309,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,   205,
     564,   565,  1310,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,  1311,   576,   211,   577,   578,
     213,   579,  1312,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,  1313,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,  1314,  1315,     0,     0,
     599,  1316,   600,  1317,  1318,   601,   602,   603,   604,   605,
       0,  1319,   606,   607,   608,   609,  1320,     0,   610,   611,
     612,   613,   614,  1321,   615,   229,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,  1322,  1323,
    1324,  1325,  1326,  1327,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,    49,  1328,   239,   628,     0,     0,
    1329,  1330,    52,    53,    54,    55,  1331,    56,     0,     0,
       0,     0,  1332,  1333,     0,     0,     0,     0,     0,     0,
       0,  1335,  2384,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,   110,   111,   112,   113,
       0,   114,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,   131,   413,   414,   415,   133,  1601,
     135,  1602,  1275,     0,   416,   417,     0,   418,   419,     0,
       0,   420,  1603,  1604,   422,     0,   423,   424,   425,   426,
       0,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,   146,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,  1605,  1606,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,  1288,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,     0,   468,   469,     0,     0,
     470,   471,   472,  1607,     0,   473,     0,   474,   163,     0,
     164,   475,     0,   476,     0,   477,     0,     0,   478,     0,
     479,   480,   481,   482,   168,   483,   484,   485,  2047,   486,
     487,   488,   489,   490,   491,     0,   169,  2048,     0,   492,
     493,   494,  1294,  1608,     0,  1609,     0,     0,   174,   175,
     495,   176,   496,   497,   498,   499,   500,     0,     0,   178,
     501,   179,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,  1610,   185,  1611,     0,   518,   519,   520,   521,   522,
     523,   524,     0,   525,     0,   526,   527,   189,   528,     0,
       0,   529,  1612,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,  2049,   193,   194,     0,   535,
     536,   537,   538,   539,     0,   540,     0,     0,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,  1613,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,   205,   564,   565,     0,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,  2050,   577,   578,   213,   579,  1615,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
       0,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,  1616,  1617,     0,     0,   599,     0,   600,     0,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,     0,  1618,
     615,   229,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,     0,     0,     0,     0,     0,     0,     0,
       0,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,  2051,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,  3721,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1417,     0,     0,     0, -1417,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1272,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,  1273,   135,  1274,  1275,  2394,
     416,   417,     0,   418,   419,  1276,  1277,   420,  1278,  1279,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,  1288,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,  1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,
       0,   473,     0,   474,   163,  2395,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,  1294,  1295,
       0,  1296,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,  2396,  1297,   178,   501,   179,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,  1300,   185,  1301,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
    1302,   526,   527,   189,   528,  1303,  1304,   529,  1305,   530,
     531,     0,     0,   532,   793,     0,     0,  1306,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,  1309,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,  1310,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,  1311,   576,   211,
     577,   578,   213,   579,  1312,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,  1314,  1315,
       0,  2397,   599,  1316,   600,  1317,  1318,   601,   602,   603,
     604,   605,     0,  1319,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,   614,  1321,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,    49,  1328,   239,   628,
       0,     0,  1329,  1330,    52,    53,    54,    55,  1331,    56,
       0,     0,     0,     0,  1332,  1333,     0,     0,     0,     0,
       0,     0,     0,  1335,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,  1272,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
    1273,   135,  1274,  1275,     0,   416,   417,     0,   418,   419,
    1276,  1277,   420,  1278,  1279,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,  1302,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,  1319,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,  1332,
    1333,  1334,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1272,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,  1273,   135,  1274,  1275,     0,
     416,   417,     0,   418,   419,  1276,  1277,   420,  1278,  1279,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,
     447,  1410,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,  1288,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,  1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,  1294,  1295,
       0,  1296,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,   179,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,  1300,   185,  1301,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
    1302,   526,   527,   189,   528,  1303,  1304,   529,  1305,   530,
     531,     0,     0,   532,   793,     0,     0,  1306,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,  1309,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,  1310,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,  1311,   576,   211,
     577,   578,   213,   579,  1312,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,  1314,  1315,
       0,     0,   599,  1316,   600,  1317,  1318,   601,   602,   603,
     604,   605,     0,  1319,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,   614,  1321,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,    49,  1328,   239,   628,
       0,     0,  1329,  1330,    52,    53,    54,    55,  1331,    56,
       0,     0,     0,     0,  1332,  1333,     0,     0,     0,     0,
       0,     0,     0,  1335,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,  1272,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
    1273,   135,  1274,  1275,     0,   416,   417,     0,   418,   419,
    1276,  1277,   420,  1278,  1279,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,  1302,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,   209,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,  1319,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,  1840,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,  1332,
    1333,     0,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,  1960,   407,   408,   409,     0,
       0,     0,     0,  1272,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,  1273,   135,  1274,  1275,     0,
     416,   417,     0,   418,   419,  1276,  1277,   420,  1278,  1279,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,  1288,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,  1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,  1294,  1295,
       0,  1296,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,   179,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,  1300,   185,  1301,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
    1302,   526,   527,   189,   528,  1303,  1304,   529,  1305,   530,
     531,     0,     0,   532,   793,     0,     0,  1306,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,  1309,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,  1310,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,  1311,   576,   211,
     577,   578,   213,   579,  1312,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,  1314,  1315,
       0,     0,   599,  1316,   600,  1317,  1318,   601,   602,   603,
     604,   605,     0,  1319,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,   614,  1321,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,    49,  1328,   239,   628,
       0,     0,  1329,  1330,    52,    53,    54,    55,  1331,    56,
       0,     0,     0,     0,  1332,  1333,     0,     0,     0,     0,
       0,     0,     0,  1335,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,  1272,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
    1273,   135,  1274,  1275,     0,   416,   417,     0,   418,   419,
    1276,  1277,   420,  1278,  1279,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,  1302,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,  1319,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,  1332,
    1333,     0,     0,     0,     0,     0,  1786,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1272,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,  1273,   135,  1274,  1275,     0,
     416,   417,     0,   418,   419,  1276,  1277,   420,  1278,  1279,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,  2781,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,  1288,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,  1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,  1294,  1295,
       0,  1296,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,   179,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,  1300,   185,  1301,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
    1302,   526,   527,   189,   528,  1303,  1304,   529,  1305,   530,
     531,     0,     0,   532,   793,     0,     0,  1306,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,  1309,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,  1310,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,  1311,   576,   211,
     577,   578,   213,   579,  1312,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,  1314,  1315,
       0,     0,   599,  1316,   600,  1317,  1318,   601,   602,   603,
     604,   605,     0,  1319,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,   614,  1321,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,    49,  1328,   239,   628,
       0,     0,  1329,  1330,    52,    53,    54,    55,  1331,    56,
       0,     0,     0,     0,  1332,  1333,     0,     0,     0,     0,
       0,     0,     0,  1335,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,  1272,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
    1273,   135,  1274,  1275,     0,   416,   417,     0,   418,   419,
    1276,  1277,   420,  1278,  1279,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
    2395,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,  1302,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,  1319,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,  1332,
    1333,     0,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1272,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,  1273,   135,  1274,  1275,     0,
     416,   417,     0,   418,   419,  1276,  1277,   420,  1278,  1279,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,  1288,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,  1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,  1294,  1295,
       0,  1296,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,   179,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,  1300,   185,  1301,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
    1302,   526,   527,   189,   528,  1303,  1304,   529,  1305,   530,
     531,     0,     0,   532,   793,     0,     0,  1306,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,  1309,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,  1310,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,  1311,   576,   211,
     577,   578,   213,   579,  1312,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,  1314,  1315,
       0,     0,   599,  1316,   600,  1317,  1318,   601,   602,   603,
     604,   605,     0,  1319,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,   614,  1321,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,    49,  1328,   239,   628,
       0,     0,  1329,  1330,    52,    53,    54,    55,  1331,    56,
       0,     0,     0,     0,  1332,  1333,     0,     0,     0,     0,
       0,     0,     0,  1335,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,  1272,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
    1273,   135,  1274,  1275,     0,   416,   417,     0,   418,   419,
    1276,  1277,   420,  1278,  1279,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,  1302,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,  1319,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,  3497,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,  1332,
    1333,     0,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1272,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,  1273,   135,  1274,  1275,     0,
     416,   417,     0,   418,   419,  1276,  1277,   420,  1278,  1279,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,  1288,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,  1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,  1294,  1295,
       0,  1296,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,   179,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,  1300,   185,  1301,
     792,   518,  3504,   520,   521,   522,   523,   524,   187,   525,
    1302,   526,   527,   189,   528,  1303,  1304,   529,  1305,   530,
     531,     0,     0,   532,   793,     0,     0,  1306,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,  1309,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,  1310,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,  1311,   576,   211,
     577,   578,   213,   579,  1312,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,  1314,  1315,
       0,     0,   599,  1316,   600,  1317,  1318,   601,   602,   603,
     604,   605,     0,  1319,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,   614,  1321,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,    49,  1328,   239,   628,
       0,     0,  1329,  1330,    52,    53,    54,    55,  1331,    56,
       0,     0,     0,     0,  1332,  1333,     0,     0,     0,     0,
       0,     0,     0,  1335,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,  1272,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,   133,
    1273,   135,  1274,  1275,     0,   416,   417,     0,   418,   419,
    1276,  1277,   420,  1278,  1279,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,     0,
    2378,     0,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1272,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,     0,  1273,   135,  1274,  1275,     0,
     416,   417,     0,   418,   419,  1276,  1277,   420,  1278,  1279,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,  1288,   459,   460,
       0,   461,   462,   463,     0,     0,     0,     0,   465,   466,
     467,  1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,  1294,  1295,
       0,  1296,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,     0,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,  1300,   185,  1301,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,   189,   528,  1303,  1304,   529,  1305,   530,
     531,     0,     0,   532,   793,     0,     0,  1306,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,  1309,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,  1310,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,  1311,   576,   211,
     577,   578,     0,   579,  1312,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,  1314,  1315,
       0,     0,   599,  1316,   600,  1317,  1318,   601,   602,   603,
     604,   605,     0,  1319,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,   614,  1321,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,    49,  1328,   239,   628,
       0,     0,  1329,  1330,    52,    53,    54,    55,  1331,    56,
       0,     0,     0,     0,  1332,  1333,     0,     0,     0,     0,
       0,     0,     0,  1335,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,   110,   111,   112,
     113,     0,   114,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,  1272,     0,
       0,   410,   411,     0,   412,   131,   413,   414,   415,     0,
    1273,   135,  1274,  1275,     0,   416,   417,     0,   418,   419,
    1276,  1277,   420,  1278,  1279,   422,     0,   423,   424,   425,
     426,  1280,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,     0,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,     0,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,     0,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,     0,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,     0,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,     0,
    2378,     0,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,   134,   135,   136,     0,     0,
     416,   417,     0,   418,   419,     0,  1277,   420,   421,   137,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,   149,   150,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,  1290,     0,   470,   471,   472,   162,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,   179,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,   185,   186,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,   189,   528,     0,  1304,   529,   191,   530,
     531,     0,     0,   532,   793,     0,   979,   533,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,   209,   573,   574,   575,  1311,   576,   211,
     577,   578,   213,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,  1316,   600,  1317,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,  1840,   228,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,  2249,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,   134,   135,   136,     0,     0,
     416,   417,     0,   418,   419,     0,  1277,   420,   421,   137,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,   149,   150,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,  1290,     0,   470,   471,   472,   162,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,   179,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,   185,   186,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,   189,   528,     0,  1304,   529,   191,   530,
     531,     0,     0,   532,   793,     0,   979,   533,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,  1311,   576,   211,
     577,   578,   213,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,  1316,   600,  1317,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,   614,   228,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,  2249,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,   134,   135,   136,     0,     0,
     416,   417,     0,   418,   419,     0,  1277,   420,   421,   137,
     422,     0,   423,   424,   425,   426,  1280,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,  1281,  1282,
    1283,  1284,  1285,   442,   443,   444,   445,   446,   149,   150,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,  1290,     0,   470,   471,   472,   162,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,  1293,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,  1297,   178,   501,   179,     0,   502,
     503,   504,  1298,  1299,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,   185,   186,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,   189,   528,     0,  1304,   529,   191,   530,
     531,     0,     0,   532,   793,     0,     0,   533,   534,     0,
       0,   192,   193,   194,  1307,   535,   536,   537,   538,   539,
       0,   540,  1308,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,  1311,   576,   211,
     577,   578,   213,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,  1313,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,  1316,   600,  1317,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,  1320,     0,
     610,   611,   612,   613,   614,   228,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
    1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,  3621,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,   110,   111,   112,   113,     0,   114,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
     131,   413,   414,   415,   133,   134,   135,   136,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   137,
     422,     0,   423,   424,   425,   426,   141,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,   146,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,   149,   150,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,   160,     0,   470,   471,   472,   162,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,   167,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,   177,   178,   501,   179,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,   185,   186,
     792,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,   189,   528,     0,   190,   529,   191,   530,
     531,     0,     0,   532,   793,     0,     0,   533,   534,     0,
       0,   192,   193,   194,   195,   535,   536,   537,   538,   539,
       0,   540,   196,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,     0,   576,   211,
     577,   578,   213,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   216,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,   219,   600,   220,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,   614,   228,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
     231,   232,   233,   234,   235,   236,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   389,  3671,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,  2763,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   134,     0,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440, -1048,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0, -1048,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0, -1048,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495, -1048,   496,   497,   498,
     499,   500,     0,   177, -1048,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184, -1048,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
   -1048,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,  1414,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,    49,     0,   239,   628,     0,     0,
       0,     0,    52,    53,    54,    55,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2684,  2685,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   137,   422,     0,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,    49,     0,
     239,   628,     0,     0,     0,     0,    52,    53,    54,    55,
       0,     0,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,  2685,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   137,   422,     0,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,   792,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,   793,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   389,  1402,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,     0,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,     0,   413,   414,   415,     0,   134,     0,   136,     0,
       0,   416,   417,     0,   418,   419,     0,     0,   420,   421,
     137,   422,     0,   423,   424,   425,   426,   141,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   472,
     162,     0,   473,     0,   474,     0,     0,     0,   475,     0,
     476,     0,   477,   167,     0,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   500,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,     0,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,   209,   573,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   217,
     218,     0,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,  1840,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
     628,     0,     0,     0,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   240,   102,   103,   389,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,     0,   413,   414,   415,     0,   134,
       0,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,     0,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,     0,     0,
       0,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,     0,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,     0,     0,
     495,     0,   496,   497,   498,   499,   500,     0,   177,     0,
     501,     0,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,     0,   186,     0,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,     0,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,   192,     0,     0,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,     0,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,   209,   573,   574,
     575,     0,   576,   211,   577,   578,     0,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,  1840,   228,
     615,     0,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,   240,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,  1937,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   137,   422,     0,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   663,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,  3197,    96,    97,    98,    99,
     100,   101,   664,   102,   103,   389,   665,     0,   105,   106,
     107,   108,   666,   667,   110,   111,   112,   113,     0,   114,
     668,   669,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,   670,   407,   408,
     409,   671,   672,   673,   674,   675,   676,   677,   410,   411,
     678,   412,   131,   413,   414,   415,   133,  1601,   135,  1602,
    1275,   679,   416,   417,     0,   418,   419,   680,   681,   420,
    1603,  1604,   422,   683,   423,   424,   425,   426,     0,   684,
     685,   427,   428,   429,   430,   431,   432,   686,   433,   434,
     435,   436,   437,   687,   438,   439,   440,   146,   441,   688,
     689,   690,   691,   692,   693,   442,   443,   444,   445,   446,
    1605,  1606,   447,   694,   448,   695,   449,     0,   450,   451,
     452,   696,   453,   454,   455,   697,   698,   456,   457,  1288,
     459,   460,   699,   461,   462,   463,   700,     0,   464,   701,
     465,   466,   467,     0,   468,   469,     0,   702,   470,   471,
     472,  1607,   703,   473,   704,   474,   163,   705,   164,   475,
       0,   476,   706,   477,     0,   707,   478,   708,   479,   480,
     481,   482,   168,   483,   484,   485,   709,   486,   487,   488,
     489,   490,   491,   710,   169,     0,     0,   492,   493,   494,
    1294,  1608,   713,  1609,   714,     0,   174,   175,   495,   176,
     496,   497,   498,   499,   500,   715,     0,   178,   501,   179,
     716,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,  1610,
     185,  1611,   717,   518,   519,   520,   521,   522,   523,   524,
       0,   525,   718,   526,   527,   189,   528,   719,     0,   529,
    1612,   530,   531,   720,   721,   532,   722,   723,   724,  3089,
     534,   725,   726,     0,   193,   194,     0,   535,   536,   537,
     538,   539,     0,   540,     0,     0,   541,   542,   543,   727,
     544,   545,   546,   547,   548,   549,  1613,   550,   551,   728,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
     729,   562,   563,   205,   564,   565,     0,   566,   567,   568,
     569,   570,   571,   572,     0,   730,   573,   574,   575,   731,
     576,  2050,   577,   578,   213,   579,  1615,   732,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,     0,   590,
     733,   591,   592,   734,   593,   594,   595,   596,   597,   735,
    1616,  1617,     0,   737,   599,     0,   600,     0,   738,   601,
     602,   603,   604,   605,     0,   740,   606,   607,   608,   609,
     741,   742,   610,   611,   612,   613,     0,  1618,   615,   229,
     616,   617,   618,   743,   744,   619,   620,   621,   622,   623,
     624,     0,     0,     0,     0,     0,     0,     0,     0,   625,
     626,   627,     0,     0,     0,     0,     0,   238,    49,  1079,
     239,   628,     0,     0,     0,     0,    52,    53,    54,    55,
       0,    56,  1080,  1081,  1082,     0,  1083,  3090,  1085,  1086,
    1087,  1088,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   137,   422,     0,   423,  1077,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,  1078,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,  1079,
     239,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1080,  1081,  1082,     0,  1083,  1084,  1085,  1086,
    1087,  1088,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   137,   422,     0,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,  1079,
     239,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1080,  1081,  1082,     0,  1083,  1084,  1085,  1086,
    1087,  1088,   663,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,   664,   102,   103,   389,   665,     0,   105,
     106,   107,   108,   666,   667,   110,   111,   112,   113,     0,
     114,   668,   669,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,   670,   407,
     408,   409,   671,   672,   673,   674,   675,   676,   677,   410,
     411,   678,   412,   131,   413,   414,   415,   133,   134,   135,
     136,     0,   679,   416,   417,     0,   418,   419,   680,   681,
     420,   682,   137,   422,   683,   423,   424,   425,   426,   141,
     684,   685,   427,   428,   429,   430,   431,   432,   686,   433,
     434,   435,   436,   437,   687,   438,   439,   440,   146,   441,
     688,   689,   690,   691,   692,   693,   442,   443,   444,   445,
     446,   149,   150,   447,   694,   448,   695,   449,     0,   450,
     451,   452,   696,   453,   454,   455,   697,   698,   456,   457,
     458,   459,   460,   699,   461,   462,   463,   700,     0,   464,
     701,   465,   466,   467,   158,   468,   469,   160,   702,   470,
     471,   472,   162,   703,   473,   704,   474,   163,   705,   164,
     475,     0,   476,   706,   477,   167,   707,   478,   708,   479,
     480,   481,   482,   168,   483,   484,   485,   709,   486,   487,
     488,   489,   490,   491,   710,   169,   170,   711,   492,   493,
     494,   712,   172,   713,   173,   714,     0,   174,   175,   495,
     176,   496,   497,   498,   499,   500,   715,   177,   178,   501,
     179,   716,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,   185,   186,   717,   518,   519,   520,   521,   522,   523,
     524,   187,   525,   718,   526,   527,   189,   528,   719,   190,
     529,   191,   530,   531,   720,   721,   532,   722,   723,   724,
     533,   534,   725,   726,   192,   193,   194,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
     727,   544,   545,   546,   547,   548,   549,   199,   550,   551,
     728,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,   729,   562,   563,   205,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,   730,   573,   574,   575,
     731,   576,   211,   577,   578,   213,   579,   214,   732,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,   733,   591,   592,   734,   593,   594,   595,   596,   597,
     735,   217,   218,   736,   737,   599,   219,   600,   220,   738,
     601,   602,   603,   604,   605,   739,   740,   606,   607,   608,
     609,   741,   742,   610,   611,   612,   613,     0,   228,   615,
     229,   616,   617,   618,   743,   744,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,     0,     0,     0,   663,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,  1572,
      96,    97,    98,    99,   100,   101,   664,   102,   103,   389,
     665,     0,   105,   106,   107,   108,   666,   667,   110,   111,
     112,   113,     0,   114,   668,   669,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,   131,   413,   414,   415,
     133,  1601,   135,  1602,  1275,     0,   416,   417,     0,   418,
     419,     0,     0,   420,  1603,  1604,   422,     0,   423,   424,
     425,   426,     0,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,   436,   437,     0,   438,   439,
     440,   146,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,  1605,  1606,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,  1288,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,     0,   468,   469,
       0,     0,   470,   471,   472,  1607,     0,   473,     0,   474,
     163,     0,   164,   475,     0,   476,     0,   477,     0,     0,
     478,     0,   479,   480,   481,   482,   168,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,   169,     0,
       0,   492,   493,   494,  1294,  1608,     0,  1609,     0,     0,
     174,   175,   495,   176,   496,   497,   498,   499,   500,     0,
       0,   178,   501,   179,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,  1610,   185,  1611,     0,   518,   519,   520,
     521,   522,   523,   524,     0,   525,     0,   526,   527,   189,
     528,     0,     0,   529,  1612,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,     0,   193,   194,
       0,   535,   536,   537,   538,   539,     0,   540,     0,     0,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
    1613,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,   205,   564,   565,
       0,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,  1614,   577,   578,   213,   579,
    1615,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,     0,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,  1616,  1617,     0,     0,   599,     0,
     600,     0,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
       0,  1618,   615,   229,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,     0,     0,     0,     0,     0,
       0,     0,     0,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,     0,     0,     0,     0,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,  2007,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   389,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   134,     0,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,     0,     0,
       0,     0,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,   977,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   137,   422,     0,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,  1918,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,  1919,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,  1920,     0,   532,     0,  1921,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,  1922,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,    49,     0,
     239,   628,     0,     0,     0,     0,    52,    53,    54,    55,
       0,    56,     0,     0,     0,     0,     0,  1446,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,  1928,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,  1919,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,  1920,
       0,   532,     0,  1921,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,  1922,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,    49,     0,   239,   628,     0,     0,
       0,     0,    52,    53,    54,    55,     0,    56,     0,     0,
       0,     0,     0,  1446,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   389,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,     0,   413,   414,   415,     0,   134,
       0,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,     0,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,  1919,
     470,   471,   472,   162,     0,   473,     0,   474,     0,     0,
       0,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,     0,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,     0,     0,
     495,     0,   496,   497,   498,   499,   500,     0,   177,     0,
     501,     0,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,     0,   186,     0,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,     0,   528,     0,
     190,   529,   191,   530,   531,  1920,     0,   532,     0,  1921,
       0,   533,   534,     0,     0,   192,     0,     0,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,     0,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,     0,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
    1922,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,     0,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
      49,     0,   239,   628,     0,     0,     0,     0,    52,    53,
      54,    55,     0,    56,     0,     0,     0,     0,     0,  1446,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   884,   401,
     402,   403,   404,   405,   406,   885,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   886,   414,   415,     0,   134,     0,   136,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   137,
     422,     0,   423,   424,   425,   426,   141,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,     0,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,   149,   150,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,   160,     0,   470,   471,   887,   162,
       0,   473,     0,   888,     0,   889,     0,   475,     0,   476,
       0,   477,   167,     0,   478,     0,   479,   480,   481,   482,
       0,   483,   484,   485,   890,   486,   487,   488,   489,   490,
     491,     0,     0,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,     0,     0,   495,     0,   496,   497,
     498,   499,   891,     0,   177,     0,   501,     0,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,     0,   186,
       0,   892,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,     0,   528,     0,   190,   529,   191,   530,
     531,     0,     0,   532,     0,     0,     0,   533,   534,     0,
       0,   192,     0,     0,   195,   535,   536,   537,   538,   539,
       0,   540,   196,   197,   541,   542,   543,     0,   893,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   894,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,     0,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,     0,   576,   211,
     577,   578,     0,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   216,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,   219,   600,   220,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,   614,   228,   615,     0,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
     231,   232,   233,   234,   235,   236,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,   628,
       0,     0,     0,     0,     0,     0,     0,    55,     0,     0,
       0,     0,     0,     0,     0,   895,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   389,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   884,   401,   402,   403,   404,   405,
     406,   885,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,     0,   886,   414,   415,
       0,   134,     0,   136,     0,     0,   416,   417,     0,   418,
     419,     0,     0,   420,   421,   137,   422,     0,   423,   424,
     425,   426,   141,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   887,   162,     0,   473,     0,   888,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   891,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   892,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   893,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   894,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,   628,     0,     0,     0,     0,
       0,     0,     0,    55,     0,     0,     0,     0,     0,     0,
       0,   895,   663,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,   664,   102,   103,   389,   665,     0,   105,
     106,   107,   108,   666,   667,   110,   111,   112,   113,     0,
     114,   668,   669,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,   131,   413,   414,   415,   133,   134,   135,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,   146,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,   163,     0,   164,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,   168,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,   169,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,   174,   175,   495,
     176,   496,   497,   498,   499,   500,     0,   177,   178,   501,
     179,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,   185,   186,   792,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,   189,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,   793,     0,     0,
     533,   534,     0,     0,   192,   193,   194,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,   205,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,   213,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
     229,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,    49,
       0,   239,   628,     0,     0,  1329,  1330,    52,    53,    54,
      55,     0,    56,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,   652,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,  1372,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,   628,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,  1373,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3471,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   137,   422,     0,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,   598,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,    49,     0,
     239,   628,     0,     0,     0,     0,    52,    53,    54,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   389,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   134,     0,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
    1032,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,    49,     0,   239,   628,     0,
       0,     0,     0,    52,    53,    54,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   389,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,     0,   413,   414,   415,
       0,   134,     0,   136,     0,     0,   416,   417,     0,   418,
     419,     0,     0,   420,   421,   137,   422,     0,   423,   424,
     425,   426,   141,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,  1905,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,    49,     0,   239,   628,     0,     0,     0,     0,
      52,    53,    54,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,    49,
       0,   239,   628,     0,     0,     0,     0,    52,    53,    54,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   413,   414,   415,     0,   134,     0,   136,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   137,
     422,     0,   423,   424,   425,   426,   141,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,     0,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,   149,   150,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,   160,     0,   470,   471,   472,   162,
       0,   473,     0,   474,     0,     0,     0,   475,     0,   476,
       0,   477,   167,     0,   478,     0,   479,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,     0,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,     0,     0,   495,     0,   496,   497,
     498,   499,   500,     0,   177,     0,   501,     0,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,     0,   186,
       0,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,     0,   528,     0,   190,   529,   191,   530,
     531,     0,     0,   532,     0,     0,     0,   533,   534,     0,
       0,   192,     0,     0,   195,   535,   536,   537,   538,   539,
       0,   540,   196,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,     0,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,     0,   576,   211,
     577,   578,     0,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   216,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,   219,   600,   220,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,   614,   228,   615,     0,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
     231,   232,   233,   234,   235,   236,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,     0,
     955,  1671,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,   956,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     933,   137,   422,     0,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   957,     0,   958,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   959,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   960,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   961,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   962,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     963,   218,     0,     0,   964,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   937,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     965,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,    83,    84,    85,     0,    87,    88,    89,    90,    91,
       0,     0,     0,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,     0,     0,     0,   105,   106,   107,
     108,     0,   109,   110,   111,   112,   113, -1531,   114,   115,
     116,     0,     0,     0,     0,     0,   119,   120,     0,     0,
       0,     0,   121,     0,     0,     0,     0,     0,     0,     0,
       0,   122,     0,   123,     0,   124,   125,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   131,     0,     0,     0,   133,   134,   135,   136,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     137,     0,     0,     0,     0,     0,     0,   141,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   146,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   149,
     150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   156,     0,     0,     0,
       0,     0,   158,     0,     0,   160,     0,     0,     0,     0,
     162,     0,     0,     0,     0,   163,     0,   164,     0,     0,
       0,     0,     0,   167,     0,     0,     0,     0,     0,     0,
       0,   168,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   169,   170,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,   174,   175,     0,   176,     0,
       0,     0,     0,     0,     0,   177,   178,     0,   179,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   184,   185,
     186,     0,     0,     0,     0,     0,     0,     0,     0,   187,
       0,     0,     0,     0,   189,     0,     0,   190,     0,   191,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   192,   193,   194,   195,     0,     0,     0,     0,
       0,     0,     0,   196,   197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   199,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   205,     0,     0,   207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     211,     0,     0,   213,     0,   214,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   216,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   217,
     218,     0,     0,     0,   219,     0,   220,     0,     0,     0,
       0,     0,     0,   223,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   228,     0,   229,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     230,   231,   232,   233,   234,   235,   236,   237,     0,     0,
       0,     0,     0,     0,     0,     0,   238,     0,     0,   239,
       0,   380,    83,    84,    85,     0,    87,    88,    89,    90,
      91,     0,     0,     0,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,     0,     0,     0,   105,   106,
     107,   108,     0,   109,   110,   111,   112,   113, -1532,   114,
     115,   116,     0,     0,     0,     0,     0,   119,   120,     0,
       0,     0,     0,   121,     0,     0,     0,     0,     0,     0,
       0,     0,   122,     0,   123,     0,   124,   125,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   131,     0,     0,     0,   133,   134,   135,   136,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   137,     0,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   146,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     149,   150,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   156,     0,     0,
       0,     0,     0,   158,     0,     0,   160,     0,     0,     0,
       0,   162,     0,     0,     0,     0,   163,     0,   164,     0,
       0,     0,     0,     0,   167,     0,     0,     0,     0,     0,
       0,     0,   168,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   169,   170,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,   174,   175,     0,   176,
       0,     0,     0,     0,     0,     0,   177,   178,     0,   179,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   184,
     185,   186,     0,     0,     0,     0,     0,     0,     0,     0,
     187,     0,     0,     0,     0,   189,     0,     0,   190,     0,
     191,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   192,   193,   194,   195,     0,     0,     0,
       0,     0,     0,     0,   196,   197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   199,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   205,     0,     0,   207,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   211,     0,     0,   213,     0,   214,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   216,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     217,   218,     0,     0,     0,   219,     0,   220,     0,     0,
       0,     0,     0,     0,   223,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   228,     0,   229,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   230,   231,   232,   233,   234,   235,   236,   237,     0,
       0,     0,     0,     0,     0,     0,     0,   238,     0,     0,
     239,     0,  1026,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,   110,   111,   112,   113,
       0,   114,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,   670,
     407,   408,   409,   671,   672,   673,   674,   675,   676,   677,
     410,   411,   678,   412,   131,   413,   414,   415,   133,   134,
     135,   136,     0,   679,   416,   417,     0,   418,   419,   680,
     681,   420,   682,   137,   422,   683,   423,   424,   425,   426,
     141,   684,   685,   427,   428,   429,   430,   431,   432,   686,
     433,   434,   435,   436,   437,   687,   438,   439,   440,   146,
     441,   688,   689,   690,   691,   692,   693,   442,   443,   444,
     445,   446,   149,   150,   447,   694,   448,   695,   449,     0,
     450,   451,   452,   696,   453,   454,   455,   697,   698,   456,
     457,   458,   459,   460,   699,   461,   462,   463,   700,     0,
     464,   701,   465,   466,   467,   158,   468,   469,   160,   702,
     470,   471,   472,   162,   703,   473,   704,   474,   163,   705,
     164,   475,     0,   476,   706,   477,   167,   707,   478,   708,
     479,   480,   481,   482,   168,   483,   484,   485,   709,   486,
     487,   488,   489,   490,   491,   710,   169,   170,   711,   492,
     493,   494,   712,   172,   713,   173,   714,     0,   174,   175,
     495,   176,   496,   497,   498,   499,   500,   715,   177,   178,
     501,   179,   716,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,   185,   186,   717,   518,   519,   520,   521,   522,
     523,   524,   187,   525,   718,   526,   527,   189,   528,   719,
     190,   529,   191,   530,   531,   720,   721,   532,   722,   723,
     724,   533,   534,   725,   726,   192,   193,   194,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,   727,   544,   545,   546,   547,   548,   549,   199,   550,
     551,   728,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,   729,   562,   563,   205,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,   730,   573,   574,
     575,   731,   576,   211,   577,   578,   213,   579,   214,   732,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,   733,   591,   592,   734,   593,   594,   595,   596,
     597,   735,   217,   218,   736,   737,   599,   219,   600,   220,
     738,   601,   602,   603,   604,   605,   739,   740,   606,   607,
     608,   609,   741,   742,   610,   611,   612,   613,     0,   228,
     615,   229,   616,   617,   618,   743,   744,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,   110,   111,   112,   113,
       0,   114,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,   131,   413,   414,   415,   133,   134,
     135,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,   146,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,   163,     0,
     164,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,   482,   168,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,   169,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,   174,   175,
     495,   176,   496,   497,   498,   499,   500,     0,   177,   178,
     501,   179,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,   185,   186,   792,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,   189,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,   793,     0,
       0,   533,   534,     0,     0,   192,   193,   194,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,   205,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,   213,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,   229,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,   110,   111,   112,   113,
       0,   114,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,   131,   413,   414,   415,   133,   134,
     135,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,   146,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,   163,     0,
     164,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,  1185,   168,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,   169,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,   174,   175,
     495,   176,   496,   497,   498,   499,   500,     0,   177,   178,
     501,   179,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,   185,   186,   792,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,   189,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,   793,     0,
       0,   533,   534,     0,     0,   192,   193,   194,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,   205,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,   213,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,   229,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,   110,   111,   112,   113,
       0,   114,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,   131,   413,   414,   415,   133,   134,
     135,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,   146,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,   163,     0,
     164,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,  1192,   168,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,   169,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,   174,   175,
     495,   176,   496,   497,   498,   499,   500,     0,   177,   178,
     501,   179,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,   185,   186,   792,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,   189,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,   793,     0,
       0,   533,   534,     0,     0,   192,   193,   194,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,   205,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,   213,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,   229,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,   110,   111,   112,   113,
       0,   114,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,   131,   413,   414,   415,   133,  1601,
     135,  1602,  1275,     0,   416,   417,     0,   418,   419,     0,
       0,   420,  1603,  1604,   422,     0,   423,   424,   425,   426,
       0,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,   146,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,  1605,  1606,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,  1288,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,     0,   468,   469,     0,     0,
     470,   471,   472,  1607,     0,   473,     0,   474,   163,     0,
     164,   475,     0,   476,     0,   477,     0,     0,   478,     0,
     479,   480,   481,   482,   168,   483,   484,   485,  2047,   486,
     487,   488,   489,   490,   491,     0,   169,  2048,     0,   492,
     493,   494,  1294,  1608,     0,  1609,     0,     0,   174,   175,
     495,   176,   496,   497,   498,   499,   500,     0,     0,   178,
     501,   179,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,  1610,   185,  1611,     0,   518,   519,   520,   521,   522,
     523,   524,     0,   525,     0,   526,   527,   189,   528,     0,
       0,   529,  1612,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,  2049,   193,   194,     0,   535,
     536,   537,   538,   539,     0,   540,     0,     0,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,  1613,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,   205,   564,   565,     0,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,  2050,   577,   578,   213,   579,  1615,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
       0,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,  1616,  1617,     0,     0,   599,     0,   600,     0,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,     0,  1618,
     615,   229,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,     0,     0,     0,     0,     0,     0,     0,
       0,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,   110,   111,   112,   113,
       0,   114,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,   131,   413,   414,   415,   133,  1601,
     135,  1602,  1275,     0,   416,   417,     0,   418,   419,     0,
       0,   420,  1603,  1604,   422,     0,   423,   424,   425,   426,
       0,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,   146,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,  1605,  1606,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,  1288,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,     0,   468,   469,     0,     0,
     470,   471,   472,  1607,     0,   473,     0,   474,   163,     0,
     164,   475,     0,   476,     0,   477,     0,     0,   478,     0,
     479,   480,   481,   482,   168,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,   169,     0,     0,   492,
     493,   494,  1294,  1608,     0,  1609,     0,     0,   174,   175,
     495,   176,   496,   497,   498,   499,   500,     0,     0,   178,
     501,   179,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,  1610,   185,  1611,     0,   518,   519,   520,   521,   522,
     523,   524,  2069,   525,     0,   526,   527,   189,   528,     0,
       0,   529,  1612,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,     0,   193,   194,     0,   535,
     536,   537,   538,   539,     0,   540,     0,     0,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,  1613,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,   205,   564,   565,     0,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,  1614,   577,   578,   213,   579,  1615,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
       0,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,  1616,  1617,     0,     0,   599,     0,   600,     0,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,     0,  1618,
     615,   229,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,     0,     0,     0,     0,     0,     0,     0,
       0,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,   110,   111,   112,   113,
       0,   114,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,   131,   413,   414,   415,   133,  1601,
     135,  1602,  1275,     0,   416,   417,     0,   418,   419,     0,
       0,   420,  1603,  1604,   422,     0,   423,   424,   425,   426,
       0,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,   146,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,  1605,  1606,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,  1288,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,     0,   468,   469,     0,     0,
     470,   471,   472,  1607,     0,   473,     0,   474,   163,     0,
     164,   475,     0,   476,     0,   477,     0,     0,   478,     0,
     479,   480,   481,   482,   168,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,   169,     0,     0,   492,
     493,   494,  1294,  1608,     0,  1609,     0,     0,   174,   175,
     495,   176,   496,   497,   498,   499,   500,     0,     0,   178,
     501,   179,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,  1610,   185,  1611,     0,   518,   519,   520,   521,   522,
     523,   524,  3023,   525,     0,   526,   527,   189,   528,     0,
       0,   529,  1612,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,     0,   193,   194,     0,   535,
     536,   537,   538,   539,     0,   540,     0,     0,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,  1613,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,   205,   564,   565,     0,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,  1614,   577,   578,   213,   579,  1615,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
       0,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,  1616,  1617,     0,     0,   599,     0,   600,     0,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,     0,  1618,
     615,   229,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,     0,     0,     0,     0,     0,     0,     0,
       0,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,   110,   111,   112,   113,
       0,   114,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,   131,   413,   414,   415,   133,  1601,
     135,  1602,  1275,     0,   416,   417,     0,   418,   419,     0,
       0,   420,  1603,  1604,   422,     0,   423,   424,   425,   426,
       0,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,   146,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,  1605,  1606,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,  1288,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,     0,   468,   469,     0,     0,
     470,   471,   472,  1607,     0,   473,     0,   474,   163,     0,
     164,   475,     0,   476,     0,   477,     0,     0,   478,     0,
     479,   480,   481,   482,   168,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,   169,     0,     0,   492,
     493,   494,  1294,  1608,     0,  1609,     0,     0,   174,   175,
     495,   176,   496,   497,   498,   499,   500,     0,     0,   178,
     501,   179,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,  1610,   185,  1611,     0,   518,   519,   520,   521,   522,
     523,   524,     0,   525,     0,   526,   527,   189,   528,  2039,
       0,   529,  1612,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,     0,   193,   194,     0,   535,
     536,   537,   538,   539,     0,   540,     0,     0,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,  1613,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,   205,   564,   565,     0,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,  2050,   577,   578,   213,   579,  1615,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
       0,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,  1616,  1617,     0,     0,   599,     0,   600,     0,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,     0,  1618,
     615,   229,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,     0,     0,     0,     0,     0,     0,     0,
       0,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,   650,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
     651,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,   652,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,   628,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,   110,   111,   112,   113,
       0,   114,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,   131,   413,   414,   415,   133,  1601,
     135,  1602,  1275,     0,   416,   417,     0,   418,   419,     0,
       0,   420,  1603,  1604,   422,     0,   423,   424,   425,   426,
       0,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,   146,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,  1605,  1606,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,  1288,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,     0,   468,   469,     0,     0,
     470,   471,   472,  1607,     0,   473,     0,   474,   163,     0,
     164,   475,     0,   476,     0,   477,     0,     0,   478,     0,
     479,   480,   481,   482,   168,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,   169,     0,     0,   492,
     493,   494,  1294,  1608,     0,  1609,     0,     0,   174,   175,
     495,   176,   496,   497,   498,   499,   500,     0,     0,   178,
     501,   179,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,  1610,   185,  1611,     0,   518,   519,   520,   521,   522,
     523,   524,     0,   525,     0,   526,   527,   189,   528,     0,
       0,   529,  1612,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,     0,   193,   194,     0,   535,
     536,   537,   538,   539,     0,   540,     0,     0,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,  1613,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,   205,   564,   565,     0,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,  1614,   577,   578,   213,   579,  1615,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
       0,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,  1616,  1617,     0,     0,   599,     0,   600,     0,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,     0,  1618,
     615,   229,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,     0,     0,     0,     0,     0,     0,     0,
       0,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,  2461,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,  2462,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,  2463,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,   792,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,   793,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,  2464,   593,  2465,   595,  2466,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,   628,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,   110,   111,   112,   113,
       0,   114,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,   131,   413,   414,   415,   133,  1601,
     135,  1602,  1275,     0,   416,   417,     0,   418,   419,     0,
       0,   420,  1603,  1604,   422,     0,   423,   424,   425,   426,
       0,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,   146,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,  1605,  1606,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,  1288,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,     0,   468,   469,     0,     0,
     470,   471,   472,  1607,     0,   473,     0,   474,   163,     0,
     164,   475,     0,   476,     0,   477,     0,     0,   478,     0,
     479,   480,   481,   482,   168,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,   169,     0,     0,   492,
     493,   494,  1294,  1608,     0,  1609,     0,     0,   174,   175,
     495,   176,   496,   497,   498,   499,   500,     0,     0,   178,
     501,   179,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,  1610,   185,  1611,     0,   518,   519,   520,   521,   522,
     523,   524,     0,   525,     0,   526,   527,   189,   528,     0,
       0,   529,  1612,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,     0,   193,   194,     0,   535,
     536,   537,   538,   539,     0,   540,     0,     0,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,  1613,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,   205,   564,   565,     0,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,  2050,   577,   578,   213,   579,  1615,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
       0,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,  1616,  1617,     0,     0,   599,     0,   600,     0,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,     0,  1618,
     615,   229,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,     0,     0,     0,     0,     0,     0,     0,
       0,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,   839,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,   840,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   841,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,   628,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,   110,   111,   112,   113,
       0,   114,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,   131,   413,   414,   415,   133,  1601,
     135,  1602,  1275,     0,   416,   417,     0,   418,   419,     0,
       0,   420,  1603,  1604,   422,     0,   423,   424,   425,   426,
       0,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,   146,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,  1605,  1606,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,  1288,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,     0,   468,   469,     0,     0,
     470,   471,   472,  1607,     0,   473,     0,   474,   163,     0,
     164,   475,     0,   476,     0,   477,     0,     0,   478,     0,
     479,   480,   481,   482,   168,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,   169,     0,     0,   492,
     493,   494,  1294,  1608,     0,  1609,     0,     0,   174,   175,
     495,   176,   496,   497,   498,   499,   500,     0,     0,   178,
     501,   179,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,  1610,   185,  1611,     0,   518,   519,   520,   521,   522,
     523,   524,     0,   525,     0,   526,   527,   189,   528,     0,
       0,   529,  1612,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,     0,   193,   194,     0,   535,
     536,   537,   538,   539,     0,   540,     0,     0,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,  1613,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,   205,   564,   565,     0,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,     0,   577,   578,   213,   579,  1615,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
       0,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,  1616,  1617,     0,     0,   599,     0,   600,     0,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,     0,  1618,
     615,   229,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,     0,     0,     0,     0,     0,     0,     0,
       0,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,   652,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,   628,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,  1180,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,   628,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   880,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,   628,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   922,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,   628,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,   628,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     399,   400,   401,   402,   403,   404,   405,   406,   670,   407,
     408,   409,   671,   672,   673,   674,   675,   676,   677,   410,
     411,   678,   412,   131,   413,   414,   415,   133,   134,   135,
     136,     0,   679,   416,   417,     0,   418,   419,   680,   681,
     420,     0,   137,   422,   683,   423,   424,   425,   426,   141,
     684,   685,   427,   428,   429,   430,   431,   432,   686,   433,
     434,   435,   436,   437,   687,   438,   439,   440,   146,   441,
     688,   689,   690,   691,   692,   693,   442,   443,   444,     0,
     446,   149,   150,   447,   694,   448,   695,   449,     0,   450,
     451,   452,   696,   453,   454,   455,   697,   698,   456,   457,
     458,   459,   460,   699,   461,   462,   463,   700,     0,   464,
     701,   465,   466,   467,   158,   468,   469,   160,   702,   470,
     471,   472,   162,   703,   473,   704,   474,   163,   705,   164,
     475,     0,   476,   706,   477,   167,   707,   478,   708,   479,
     480,     0,   482,   168,   483,   484,   485,   709,   486,   487,
     488,   489,   490,   491,   710,   169,   170,     0,   492,   493,
     494,     0,   172,   713,   173,   714,     0,   174,   175,   495,
     176,   496,   497,   498,   499,   500,   715,   177,   178,   501,
     179,   716,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,     0,   512,   513,     0,   515,   516,   517,
     184,   185,   186,   717,   518,   519,   520,   521,   522,   523,
     524,   187,   525,   718,   526,   527,   189,   528,   719,   190,
     529,   191,   530,   531,   720,   721,   532,   722,   723,   724,
     533,   534,   725,   726,   192,   193,   194,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
     727,   544,   545,   546,   547,   548,   549,   199,   550,   551,
     728,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,   729,   562,   563,   205,   564,   565,   207,   566,   567,
     568,   569,   570,   571,     0,     0,   730,   573,   574,   575,
     731,   576,   211,   577,   578,   213,   579,   214,   732,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,   733,   591,   592,   734,   593,   594,   595,   596,   597,
     735,   217,   218,     0,   737,   599,   219,   600,   220,   738,
     601,   602,   603,   604,   605,     0,   740,   606,   607,   608,
     609,   741,   742,   610,   611,   612,   613,     0,   228,   615,
     229,   616,   617,   618,   743,   744,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
       0,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   137,   422,  2020,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   432,  2021,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,  2022,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,  2727,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,  2023,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,  2024,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   389,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,   905,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,     0,   413,   414,   415,     0,   134,     0,   136,     0,
       0,   416,   417,     0,   418,   419,     0,     0,   420,   421,
     137,   422,     0,   423,   424,   425,   426,   141,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     436,   437,   906,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   472,
     162,     0,   473,     0,   474,     0,     0,     0,   475,     0,
     476,   946,   477,   167,     0,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   500,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,     0,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,   199,   550,   551,   907,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,   908,   573,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   217,
     218,     0,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,   614,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,   905,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   413,   414,   415,     0,   134,     0,   136,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   137,
     422,     0,   423,   424,   425,   426,   141,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,   906,   438,   439,   440,     0,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,   149,   150,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,   160,     0,   470,   471,   472,   162,
       0,   473,     0,   474,     0,     0,     0,   475,     0,   476,
       0,   477,   167,     0,   478,     0,   479,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,     0,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,     0,     0,   495,     0,   496,   497,
     498,   499,   500,     0,   177,     0,   501,     0,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,     0,   186,
       0,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,     0,   528,     0,   190,   529,   191,   530,
     531,     0,     0,   532,     0,     0,     0,   533,   534,     0,
       0,   192,     0,     0,   195,   535,   536,   537,   538,   539,
       0,   540,   196,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,   907,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,     0,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,   908,   573,   574,   575,     0,   576,   211,
     577,   578,     0,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   216,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,   219,   600,   220,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,   614,   228,   615,     0,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
     231,   232,   233,   234,   235,   236,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   389,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,   128,   129,
       0,     0,     0,     0,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   134,     0,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,   792,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,   793,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,   792,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,   793,     0,   979,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,  1375,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   137,   422,     0,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,   792,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,   793,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,     0,     0,   239,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   389,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,     0,   413,   414,   415,
       0,   134,     0,   136,     0,     0,   416,   417,     0,   418,
     419,     0,     0,   420,   421,   137,   422,     0,   423,   424,
     425,   426,   141,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,  1750,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,  1751,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,  1752,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,   792,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
     793,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,  1753,   570,   571,   572,     0,     0,
    1754,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,  1755,  1756,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     134,     0,   136,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   137,   422,     0,   423,   424,   425,
     426,   141,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,   906,   438,   439,   440,
       0,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,   160,
       0,   470,   471,   472,   162,     0,   473,     0,   474,     0,
       0,     0,   475,     0,   476,     0,   477,   167,     0,   478,
       0,   479,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,     0,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,     0,
       0,   495,     0,   496,   497,   498,   499,   500,     0,   177,
       0,   501,     0,     0,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,     0,   186,     0,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,     0,   528,
       0,   190,   529,   191,   530,   531,     0,     0,   532,     0,
       0,     0,   533,   534,     0,     0,   192,     0,     0,   195,
     535,   536,   537,   538,   539,     0,   540,   196,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,   907,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,     0,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,   908,   573,
     574,   575,     0,   576,   211,   577,   578,     0,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   216,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,   219,   600,
     220,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,   614,
     228,   615,     0,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,   231,   232,   233,   234,   235,
     236,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   389,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,     0,   413,   414,   415,     0,   134,
       0,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,     0,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,     0,     0,
       0,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,     0,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,     0,     0,
     495,     0,   496,   497,   498,   499,   500,     0,   177,     0,
     501,     0,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,     0,   186,   792,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,     0,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,   793,     0,
       0,   533,   534,     0,     0,   192,     0,     0,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,     0,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,     0,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,     0,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,   889,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,   890,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,  2612,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   137,   422,     0,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
    2613,     0,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   389,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,  2622,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,     0,   413,   414,   415,     0,   134,     0,   136,     0,
       0,   416,   417,     0,   418,   419,     0,     0,   420,   421,
     137,   422,     0,   423,   424,   425,   426,   141,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   472,
     162,     0,   473,     0,   474,     0,     0,     0,   475,     0,
     476,     0,   477,   167,     0,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   500,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,     0,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   217,
     218,     0,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,  2623,
       0,   610,   611,   612,   613,   614,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,   659,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   413,   414,   415,     0,   134,     0,   136,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   137,
     422,     0,   423,   424,   425,   426,   141,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,     0,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,   149,   150,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,   160,     0,   470,   471,   472,   162,
       0,   473,     0,   474,     0,     0,     0,   475,     0,   476,
       0,   477,   167,     0,   478,     0,   479,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,     0,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,     0,     0,   495,     0,   496,   497,
     498,   499,   500,     0,   177,     0,   501,     0,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,     0,   186,
       0,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,     0,   528,     0,   190,   529,   191,   530,
     531,     0,     0,   532,     0,     0,     0,   533,   534,     0,
       0,   192,     0,     0,   195,   535,   536,   537,   538,   539,
       0,   540,   196,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,     0,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,     0,   576,   211,
     577,   578,     0,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   216,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,   219,   600,   220,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,   614,   228,   615,     0,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
     231,   232,   233,   234,   235,   236,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   389,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,   790,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   134,     0,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,  2763,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,  2776,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   137,   422,     0,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,     0,     0,   239,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   389,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,     0,   413,   414,   415,
       0,   134,     0,   136,     0,     0,   416,   417,     0,   418,
     419,     0,     0,   420,   421,   137,   422,     0,   423,   424,
     425,   426,   141,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,  2810,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     134,     0,   136,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   137,   422,     0,   423,   424,   425,
     426,   141,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
       0,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,   149,   150,   447,  3118,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,   160,
       0,   470,   471,   472,   162,     0,   473,     0,   474,     0,
       0,     0,   475,     0,   476,     0,   477,   167,     0,   478,
       0,   479,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,     0,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,     0,
       0,   495,     0,   496,   497,   498,   499,   500,     0,   177,
       0,   501,     0,     0,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,     0,   186,     0,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,     0,   528,
       0,   190,   529,   191,   530,   531,     0,     0,   532,     0,
       0,     0,   533,   534,     0,     0,   192,     0,     0,   195,
     535,   536,   537,   538,   539,     0,   540,   196,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,     0,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,     0,   576,   211,   577,   578,     0,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   216,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,   219,   600,
     220,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,   614,
     228,   615,     0,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,   231,   232,   233,   234,   235,
     236,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   389,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,     0,   413,   414,   415,     0,   134,
       0,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,     0,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,  3120,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,     0,     0,
       0,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,     0,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,     0,     0,
     495,     0,   496,   497,   498,   499,   500,     0,   177,     0,
     501,     0,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,     0,   186,     0,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,     0,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,   192,     0,     0,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,     0,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,     0,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,     0,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,  3122,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   137,   422,     0,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,  3721,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   389,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,     0,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,     0,   413,   414,   415,     0,   134,     0,   136,     0,
       0,   416,   417,     0,   418,   419,     0,     0,   420,   421,
     137,   422,     0,   423,   424,   425,   426,   141,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   472,
     162,     0,   473,     0,   474,     0,     0,     0,   475,     0,
     476,     0,   477,   167,     0,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   500,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,     0,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   217,
     218,     0,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,   614,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   413,   414,   415,     0,   134,     0,   136,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   137,
     422,     0,   423,   424,   425,   426,   141,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,     0,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,   149,   150,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,   160,     0,   470,   471,   472,   162,
       0,   473,     0,   474,     0,     0,     0,   475,     0,   476,
       0,   477,   167,     0,   478,     0,   479,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,     0,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,     0,     0,   495,     0,   496,   497,
     498,   499,   500,     0,   177,     0,   501,     0,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,     0,   186,
       0,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,     0,   528,     0,   190,   529,   191,   530,
     531,     0,     0,   532,     0,     0,     0,   533,   534,     0,
       0,   192,     0,     0,   195,   535,   536,   537,   538,   539,
       0,   540,   196,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,     0,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,     0,   576,   211,
     577,   578,     0,   579,   214,     0,   580,   581,   582,   845,
     584,   585,   586,   587,   588,   589,   216,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,   219,   600,   220,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,   614,   228,   615,     0,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
     231,   232,   233,   234,   235,   236,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   389,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   134,     0,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   930,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   932,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   933,   137,   422,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,     0,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   934,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   935,   218,     0,     0,
     936,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   937,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,   968,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   933,   137,   422,     0,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,     0,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   969,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   970,   218,     0,     0,   971,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   937,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,     0,     0,   239,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   389,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,     0,   413,   414,   415,
       0,   134,     0,   136,     0,     0,   416,   417,     0,   418,
     419,     0,     0,   420,   421,   137,   422,     0,   423,   424,
     425,   426,   141,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,  1190,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     134,     0,   136,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   137,   422,     0,   423,   424,   425,
     426,   141,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
       0,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,   160,
       0,   470,   471,   472,   162,     0,   473,     0,   474,     0,
       0,     0,   475,     0,   476,     0,   477,   167,     0,   478,
       0,   479,   480,   481,  1194,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,     0,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,     0,
       0,   495,     0,   496,   497,   498,   499,   500,     0,   177,
       0,   501,     0,     0,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,     0,   186,     0,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,     0,   528,
       0,   190,   529,   191,   530,   531,     0,     0,   532,     0,
       0,     0,   533,   534,     0,     0,   192,     0,     0,   195,
     535,   536,   537,   538,   539,     0,   540,   196,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,     0,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,     0,   576,   211,   577,   578,     0,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   216,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,   219,   600,
     220,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,   614,
     228,   615,     0,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,   231,   232,   233,   234,   235,
     236,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   389,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,     0,   413,   414,   415,     0,   134,
       0,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,     0,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,     0,     0,
       0,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,  1202,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,     0,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,     0,     0,
     495,     0,   496,   497,   498,   499,   500,     0,   177,     0,
     501,     0,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,     0,   186,     0,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,     0,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,   192,     0,     0,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,     0,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,     0,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,     0,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,  1204,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   137,   422,     0,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,  1206,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   389,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,     0,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,     0,   413,   414,   415,     0,   134,     0,   136,     0,
       0,   416,   417,     0,   418,   419,     0,     0,   420,   421,
     137,   422,     0,   423,   424,   425,   426,   141,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   472,
     162,     0,   473,     0,   474,     0,     0,     0,   475,     0,
     476,     0,   477,   167,     0,   478,     0,   479,   480,   481,
    1209,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   500,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,     0,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   217,
     218,     0,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,   614,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   413,   414,   415,     0,   134,     0,   136,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   137,
     422,     0,   423,   424,   425,   426,   141,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,     0,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,   149,   150,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,   160,     0,   470,   471,   472,   162,
       0,   473,     0,   474,     0,     0,     0,   475,     0,   476,
       0,   477,   167,     0,   478,     0,   479,   480,   481,  1211,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,     0,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,     0,     0,   495,     0,   496,   497,
     498,   499,   500,     0,   177,     0,   501,     0,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,     0,   186,
       0,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,     0,   528,     0,   190,   529,   191,   530,
     531,     0,     0,   532,     0,     0,     0,   533,   534,     0,
       0,   192,     0,     0,   195,   535,   536,   537,   538,   539,
       0,   540,   196,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,     0,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,     0,   576,   211,
     577,   578,     0,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   216,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,   219,   600,   220,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,   614,   228,   615,     0,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
     231,   232,   233,   234,   235,   236,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   389,     0,     0,   105,   106,   107,   108,     0,
       0,   110,   111,   112,   113,     0,   114,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   134,     0,   136,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   137,   422,
       0,   423,   424,   425,   426,   141,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,  1214,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
     110,   111,   112,   113,     0,   114,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,  1386,   413,
     414,   415,     0,   134,     0,   136,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   933,   137,  1387,     0,
     423,   424,   425,   426,   141,     0,     0,   427,   428,   429,
     430,   431,     0,     0,   433,   434,   435,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   960,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     961,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,  1378,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   963,   218,     0,     0,
     964,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   937,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   965,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,  1404,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   134,     0,   136,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   137,   422,     0,   423,
     424,   425,   426,   141,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,     0,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,     0,     0,   239,  1476,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   389,
       0,     0,   105,   106,   107,   108,     0,     0,   110,   111,
     112,   113,     0,   114,     0,     0,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,     0,   413,   414,   415,
       0,   134,     0,   136,     0,     0,   416,   417,     0,   418,
     419,     0,     0,   420,   421,   137,   422,     0,   423,   424,
     425,   426,   141,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,     0,
       0,   105,   106,   107,   108,     0,     0,   110,   111,   112,
     113,     0,   114,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     134,     0,   136,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   137,   422,     0,   423,   424,   425,
     426,   141,     0,     0,   427,   428,   429,  1667,   431,   432,
       0,   433,   434,   435,   436,   437,     0,   438,   439,   440,
       0,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,   160,
       0,   470,   471,   472,   162,     0,   473,     0,   474,     0,
       0,     0,   475,     0,   476,     0,   477,   167,     0,   478,
       0,   479,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,     0,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,     0,
       0,   495,     0,   496,   497,   498,   499,   500,     0,   177,
       0,   501,     0,     0,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,     0,   186,     0,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,     0,   528,
       0,   190,   529,   191,   530,   531,     0,     0,   532,     0,
       0,     0,   533,   534,     0,     0,   192,     0,     0,   195,
     535,   536,   537,   538,   539,     0,   540,   196,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,     0,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,     0,   576,   211,   577,   578,     0,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   216,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,   219,   600,
     220,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,   614,
     228,   615,     0,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,   231,   232,   233,   234,   235,
     236,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   389,     0,     0,
     105,   106,   107,   108,     0,     0,   110,   111,   112,   113,
       0,   114,     0,     0,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,     0,   413,   414,   415,     0,   134,
       0,   136,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   137,   422,     0,   423,   424,   425,   426,
     141,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   436,   437,     0,   438,   439,   440,     0,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,     0,     0,
       0,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,  1693,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,     0,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,     0,     0,
     495,     0,   496,   497,   498,   499,   500,     0,   177,     0,
     501,     0,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,     0,   186,     0,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,     0,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,   192,     0,     0,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,     0,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,     0,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,     0,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,   110,   111,   112,   113,     0,
     114,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   134,     0,
     136,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   137,   422,     0,   423,   424,   425,   426,   141,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,  1695,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,   110,   111,   112,   113,     0,   114,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   134,     0,   136,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   137,   422,     0,   423,   424,   425,   426,   141,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,  1783,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   389,     0,     0,   105,   106,   107,
     108,     0,     0,   110,   111,   112,   113,     0,   114,     0,
       0,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,     0,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,     0,   413,   414,   415,     0,   134,     0,   136,     0,
       0,   416,   417,     0,   418,   419,     0,     0,   420,   933,
     137,   422,     0,   423,   424,   425,   426,   141,     0,     0,
     427,   428,   429,   430,   431,     0,     0,   433,   434,   435,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   472,
     162,     0,   473,     0,   474,     0,     0,     0,   475,     0,
     476,     0,   477,   167,     0,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   500,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   960,   184,     0,
     186,     0,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   961,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,  1378,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   963,
     218,     0,     0,   964,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,   937,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   965,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,     0,   105,   106,   107,   108,
       0,     0,   110,   111,   112,   113,     0,   114,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   413,   414,   415,     0,   134,     0,   136,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   933,   137,
     422,     0,   423,   424,   425,   426,   141,     0,     0,   427,
     428,   429,   430,   431,     0,     0,   433,   434,   435,   436,
     437,     0,   438,   439,   440,     0,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,   149,   150,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,   160,     0,   470,   471,   472,   162,
       0,   473,     0,   474,     0,     0,     0,   475,     0,   476,
       0,   477,   167,     0,   478,     0,   479,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,     0,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,     0,     0,   495,     0,   496,   497,
     498,   499,   500,     0,   177,     0,   501,     0,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   960,   184,     0,   186,
       0,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,     0,   528,     0,   190,   529,   191,   530,
     531,     0,     0,   532,     0,     0,     0,   533,   534,     0,
       0,   192,     0,     0,   195,   535,   536,   537,   538,   539,
       0,   540,   196,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,     0,   961,   565,   207,   566,   567,   568,  2043,   570,
     571,   572,     0,     0,   573,   574,  1378,     0,   576,   211,
     577,   578,     0,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   216,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   963,   218,
       0,     0,   964,   219,   600,   220,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,   937,   228,   615,     0,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   965,   230,
     231,   232,   233,   234,   235,   236,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,    83,
      84,    85,     0,    87,    88,    89,    90,    91,     0,     0,
       0,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,     0,     0,     0,   105,   106,   107,   108,     0,
     109,   110,   111,   112,   113,     0,   114,   115,   116,     0,
       0,     0,     0,     0,   119,   120,     0,     0,     0,     0,
     121,     0,     0,     0,     0,     0,     0,     0,     0,   122,
       0,   123,     0,   124,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   131,
       0,     0,     0,   133,   134,   135,   136,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   137,     0,
       0,     0,     0,     0,     0,   141,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   146,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   149,   150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   156,     0,     0,     0,     0,     0,
     158,     0,     0,   160,     0,     0,     0,     0,   162,     0,
       0,     0,     0,   163,     0,   164,     0,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   169,   170,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,   174,   175,     0,   176,     0,     0,     0,
       0,     0,     0,   177,   178,     0,   179,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   184,   185,   186,     0,
       0,     0,     0,     0,     0,     0,     0,   187,     0,     0,
       0,     0,   189,     0,     0,   190,     0,   191,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     192,   193,   194,   195,     0,     0,     0,     0,     0,     0,
       0,   196,   197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   199,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     205,     0,     0,   207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   211,     0,
       0,   213,     0,   214,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   216,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   217,   218,     0,
       0,     0,   219,     0,   220,     0,     0,     0,     0,     0,
       0,   223,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   228,     0,   229,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   230,   231,
     232,   233,   234,   235,   236,   237,     0,     0,     0,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,     0,    87,    88,    89,    90,    91,     0,     0,     0,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,     0,     0,     0,   105,   106,   107,   108,     0,   109,
     110,   111,   112,   113,     0,   114,   115,   116,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   131,     0,
       0,     0,   133,   134,   135,   136,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   137,     0,     0,
       0,     0,     0,     0,   141,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   146,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   149,   150,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   156,     0,     0,     0,     0,     0,   158,
       0,     0,   160,     0,     0,     0,     0,   162,     0,     0,
       0,     0,   163,     0,   164,     0,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,     0,   168,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     169,   170,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,   174,   175,     0,   176,     0,     0,     0,     0,
       0,     0,   177,   178,     0,   179,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   184,   185,   186,     0,     0,
       0,     0,     0,     0,     0,     0,   187,     0,     0,     0,
       0,   189,     0,     0,   190,     0,   191,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   192,
     193,   194,   195,     0,     0,     0,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   199,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,     0,   207,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   211,     0,     0,
     213,     0,   214,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   216,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   217,   218,     0,     0,
       0,   219,     0,   220,     0,     0,     0,     0,     0,     0,
     223,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   228,     0,   229,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   230,   231,   232,
     233,   234,   235,   236,   237,     0,     0,     0,     0,     0,
       0,     0,     0,   238,     0,     0,   239,    83,    84,    85,
       0,    87,    88,    89,    90,    91,     0,     0,     0,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
       0,     0,     0,   105,   106,   107,   108,     0,     0,   110,
     111,   112,   113,     0,   114,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   131,     0,     0,
       0,   133,   134,   135,   136,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   137,     0,     0,     0,
       0,     0,     0,   141,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   146,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   149,   150,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   158,     0,
       0,   160,     0,     0,     0,     0,   162,     0,     0,     0,
       0,   163,     0,   164,     0,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,     0,   168,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   169,
     170,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,   174,   175,     0,   176,     0,     0,     0,     0,     0,
       0,   177,   178,     0,   179,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   184,   185,   186,     0,     0,     0,
       0,     0,     0,     0,     0,   187,     0,     0,     0,     0,
     189,     0,     0,   190,     0,   191,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   192,   193,
     194,   195,     0,     0,     0,     0,     0,     0,     0,   196,
     197,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   199,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   205,     0,
       0,   207,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   211,     0,     0,   213,
       0,   214,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   216,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   217,   218,     0,     0,     0,
     219,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   228,     0,   229,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   230,   231,   232,   233,
     234,   235,   236,   237,     0,     0,     0,     0,     0,     0,
       0,     0,   238,     0,     0,   239
};

static const short yycheck[] =
{
       2,   240,  1193,  1255,   918,   148,    78,  1698,   147,  1000,
     145,   115,  1713,   115,    78,  1156,   774,  1530,  1093,  1723,
    1630,    78,   221,  1164,    81,  1109,   347,  1102,    93,    78,
     859,   204,   115,  1751,   863,    78,   347,  1267,  1039,  1315,
    1632,   964,   839,   872,   958,   759,  1895,  1386,  2249,  1058,
     225,  1648,   156,  2340,   156,   198,   814,    78,  1975,  1114,
     974,  1648,   130,   115,  1021,   130,  1143,  1648,    86,    78,
    1648,  1648,    81,   156,  2980,  1648,  1151,  1786,  2544,  1937,
    1076,  1039,   147,  1158,    86,  2002,   210,   972,  2709,  2006,
    1165,    78,  2254,  2255,    81,  2260,  2719,   768,  2068,   770,
    1946,  3133,  2751,   861,   156,  1485,   115,   904,   883,  1186,
    1229,  1171,   783,  1943,  1286,  1287,  2054,  2055,  1220,   223,
     203,   223,  1682,   144,    22,  1073,  1614,   210,    38,   212,
      38,    23,    72,  1305,  1035,  1036,    11,   203,   147,   810,
     223,  1039,    90,   115,   210,   147,   212,   156,   154,  2190,
    2191,  2192,  2193,   824,    72,    95,    84,  2880,   181,   956,
       2,   220,   877,   181,  2685,   761,   157,    78,    89,   241,
      81,   223,  1278,  1279,    77,   207,    89,   241,    78,   181,
     129,    81,   109,   124,  1697,   117,    81,   162,   117,   767,
      72,   201,   241,   771,   203,  1301,   102,    94,   241,    72,
      81,   210,   131,   212,   115,    81,   201,  1228,   298,    26,
     238,   127,   162,    95,   223,   115,   162,   166,   176,   240,
     241,    30,    94,   162,   183,    81,   804,    26,   201,  2199,
     312,   109,    88,    77,   238,   242,   296,   196,  3427,  1849,
     117,   109,    72,   203,   214,   156,    81,   124,   157,  3197,
     184,  3199,   109,    88,   131,   100,   156,   232,  2175,   121,
    3725,    89,  3625,   396,    77,  3541,   198,   203,   159,   198,
      81,   174,  3608,   396,   852,   109,    91,   236,    81,   388,
     858,   329,   232,    72,   430,    88,   232,   152,   109,  3587,
     164,     0,   203,   238,    72,   254,   266,  3329,   242,   210,
    2270,   212,  2272,   398,  1817,   238,  1390,   419,    78,   312,
     396,    81,   223,    72,  1335,  3591,   185,    16,   366,   203,
     385,   198,   329,   223,   124,   382,  1665,    72,   212,   266,
     174,   131,   269,   301,   337,  3800,    95,   432,   347,   298,
     486,  1617,    87,   455,  1229,   115,   156,   306,  1357,   214,
     165,    77,   221,   486,  1239,  1240,  3821,    83,   169,    81,
     347,   174,   238,   486,   313,   413,  3702,   303,   359,  1127,
     479,   216,  1201,   382,    39,   220,    41,   286,  2164,  3411,
     466,   201,  1523,   238,   359,   329,   156,   357,  1389,   238,
    1581,   323,   352,  3669,   323,   382,   486,   115,  1112,   481,
     291,   266,   238,    72,   269,  3768,  1077,  1078,   253,   359,
     240,   415,   340,   129,  3603,  3447,   343,   234,  1247,   479,
     357,   230,   317,   184,   352,  1480,    95,   486,  1257,   420,
     296,   220,   366,  1605,  1606,   234,   347,   299,   413,  1268,
    1612,   390,   763,   115,   278,   420,   323,   347,   174,   408,
     166,   240,   763,   223,   486,   396,   479,  1598,   486,   598,
    1056,   364,   240,   413,  2155,   343,  2058,   413,   312,   427,
    1355,   382,   400,   303,   413,   343,   486,   409,  1669,   486,
     409,   240,   382,  1154,  1155,  1569,   343,   384,   479,  2319,
     406,   486,   357,   337,   389,   240,   391,  1603,  1604,  1170,
      72,   382,  1579,  1218,   479,  1611,   479,   479,  3540,   343,
    1395,  1396,   384,   157,   303,   371,   238,   415,  3241,  3467,
    1595,   480,   343,   368,   337,   303,  1197,  1198,   157,  3827,
     364,   479,   409,   598,    72,   475,   371,   482,  3004,  3005,
    1118,   415,   452,  1500,   419,   455,  1124,   455,   481,  1506,
     460,   461,   462,   463,  1455,   465,   477,   475,   303,   486,
    1458,   471,  2050,   455,   477,  2766,  1514,   205,   371,  2770,
    2487,   240,   241,   479,   201,   473,   396,   347,   443,   455,
    2410,  3102,  3103,  3104,  3105,  3106,   312,   463,   398,   598,
     472,   473,   474,   475,  1172,   471,   598,   313,   773,   472,
     473,   474,   475,   778,   779,   366,   482,  1667,   486,  1728,
     785,   337,   382,   479,   479,    75,   157,  1719,   486,   257,
     289,   286,   432,   453,  2562,  1582,  2564,   482,   159,   486,
     769,   770,  2481,   482,  1409,  2015,   466,   467,   468,   157,
     470,   471,   472,   473,   474,   475,   482,  2493,   299,   477,
     480,   479,   480,   481,  2695,   759,   350,   759,   486,   157,
      26,   481,   297,   322,   453,   485,   301,    78,   240,   808,
      36,   278,   847,   238,   390,   453,   759,   466,   467,   468,
     332,   470,   471,   472,   473,   474,   475,  3719,   174,  2249,
    2660,  2661,   470,   471,   472,   473,   474,   475,   841,   156,
     430,   201,   240,   302,   422,  1811,  1812,   759,   453,    82,
     129,   470,   471,   472,   473,   474,   475,   856,   209,   413,
     220,   466,   467,   468,   184,   470,   471,   472,   473,   474,
     475,   301,   183,   455,   452,  3767,  1145,   455,   201,   398,
    2678,   463,   460,   461,   462,   286,    78,   166,   114,   471,
     759,   389,   137,   391,   763,   286,   486,   215,   767,   312,
     482,   479,   771,   152,  1785,  1786,   223,  2684,   286,   396,
    2708,  1485,  1530,   432,   839,  1796,   763,   129,  1799,   151,
     452,   799,  1837,   455,   337,   236,  1807,  1808,   460,   461,
     462,  3412,   798,   291,   152,   804,  3419,   799,  3447,  1820,
    1821,   470,   471,   472,   473,   474,   475,   479,   452,  2974,
    1831,   455,  2750,   354,   166,   880,   460,   461,   462,   463,
     337,   206,   828,   452,    16,   214,   455,   479,   479,  1884,
     241,   460,   461,   462,   433,   959,   845,   444,   962,   904,
    1754,  1755,  1727,   852,   157,   415,  1255,   364,   759,   858,
     415,   223,   763,   162,  1739,   306,   214,   348,   376,   759,
     233,   379,  1691,   763,  1885,   174,  3772,  3773,   234,   196,
    2656,  1700,  2658,  2659,  2484,   877,   959,   266,   364,   962,
     269,  1710,  1553,  1554,  1555,  1556,  2672,   359,   201,   957,
     350,   956,   957,   959,   313,   339,   962,   291,   470,   471,
     472,   473,   474,   475,   922,   238,   366,   161,   266,   241,
    2470,   269,  1583,  1584,   131,  3381,  3822,   102,  1589,   405,
     922,  1750,   160,  1752,  1753,   130,   479,  1756,  2441,  1643,
     266,   949,   470,   471,   472,   473,   474,   475,   202,  1697,
     157,   203,   960,   961,   350,   954,   133,   949,   420,   161,
     959,    72,   322,   962,   387,   472,   162,   408,   960,   961,
    3001,   313,   162,    72,   149,   772,   975,  2559,   357,   776,
     311,   390,   150,   178,  2566,     5,   985,   784,   286,   217,
    1651,  1652,  1653,  1654,   171,   239,   430,  3188,   975,   759,
    2131,   152,  3193,   763,   452,  3196,    26,   455,    90,   357,
    2001,   430,   460,   461,   462,   812,    36,   479,  1112,   816,
    1112,   320,   339,  2185,   386,   387,   108,  1035,  1036,   826,
     328,   357,  3184,   169,   895,   171,   232,   239,   398,  1112,
    2105,  2106,   232,  1035,  1036,   877,  1993,  1039,   390,   398,
     205,   303,   486,  2001,   136,  1716,   231,  1932,   959,   312,
     314,   962,   202,   214,   443,   260,  3796,   486,   452,  1817,
    1112,   455,   432,   102,   975,   160,   460,   461,   462,   286,
    2066,   291,  1481,   479,  2265,   975,  2217,  2218,  2219,  2220,
      52,   287,   288,   396,   114,   443,   132,   265,   288,   267,
     479,  2809,   257,   278,   159,  3835,  1335,   189,    70,   132,
    2791,   364,  1111,  1112,  1682,   266,  1684,   312,  3574,  1118,
     149,  1689,   158,  2710,  2972,  1124,  3737,   379,  1947,   240,
    1529,  3861,   217,  2710,  1142,   158,   218,  2836,   360,  2710,
     337,   240,  2710,  2710,   341,  2678,  1145,  2710,  1852,   452,
    1142,  2098,   455,   173,  2101,  2102,  1400,   460,   461,   462,
     296,  1472,   354,   359,   246,   387,    79,   364,  1230,   359,
     119,  1472,   227,  1172,   451,  2708,  1230,   454,   481,   196,
     355,  1580,   485,  1751,   480,    98,   202,  1249,   224,  1021,
     486,  1230,   303,   388,  2261,   390,   388,  1230,  1597,  1254,
    3107,   224,   231,   425,   303,  1213,   357,  1039,   166,  3486,
    3170,  1112,   228,  2000,   234,   975,  2766,   413,   141,  1230,
    2770,  1213,  1112,   413,   420,  1217,  1218,   243,  1220,  1228,
     420,   286,   388,   430,   389,   251,   391,   254,  1249,   431,
    1639,  2060,   452,   192,   196,  3205,   204,  3207,   240,   278,
     460,   461,   462,   160,  2073,   137,  1255,   360,  2257,   341,
     117,  1272,  1494,   345,   352,   152,   215,   196,  2087,   351,
     425,   352,  2091,  3464,   156,   431,   358,  1276,  1289,   202,
     162,   298,   364,   479,   387,   479,   215,   479,  1687,   479,
     372,  3067,  3068,  3069,  3070,  3071,  3072,  2857,   380,  1698,
     157,   482,   254,  1302,   186,   228,  1538,   341,  1319,   301,
     217,  2015,   400,   312,  1372,  1373,   423,  1372,  1373,   400,
     243,  2881,   425,   479,  1335,   486,   355,   214,   251,  1337,
     364,   347,   455,  1332,  1333,   482,  1335,  2348,   337,  1347,
     463,  1435,   453,  1435,   426,  1337,   298,   169,   430,   171,
     232,   274,  1112,  1352,   453,  1347,   467,   468,   312,   470,
     471,   472,   473,   474,   475,   364,  1358,   466,   467,   468,
     366,   470,   471,   472,   473,   474,   475,   254,  1386,   266,
     337,   480,   269,   337,  2395,  1217,  1218,   341,  1220,   126,
    1389,  1485,  1557,  1485,  1386,  1453,   430,  1389,  1453,  3710,
      72,  1393,  1394,   483,  1561,  2567,   143,   364,  1419,  1420,
     364,  1422,  1485,  2424,    42,   477,  1489,   413,   155,   481,
    2749,   298,  1421,    95,   347,  1424,  1425,   312,   169,   286,
     171,  3723,  3724,  1489,   291,  1508,  1435,  1436,  1437,   430,
     431,  1685,   312,  1485,   430,   431,  1690,  1455,  2459,  2494,
     191,  1850,  1508,  3764,   415,  1699,   341,   352,  3769,  1436,
    1437,  2472,  2473,  1455,   286,    96,   323,   337,  1712,   206,
     357,   341,   234,  1472,   296,  3314,   333,   359,     7,   364,
    1479,    10,  1481,  1640,    18,   116,  1485,  3798,   479,  1646,
    1489,    20,    21,   479,   364,  1472,  2157,  2158,  2159,  2160,
    2161,  2162,  1479,  1660,   453,   400,   896,  3799,  3108,  1508,
    2297,    40,   455,   356,    43,  1069,  1515,   466,   467,   468,
     463,   470,   471,   472,   473,   474,   475,   246,   471,   919,
    1529,   413,   478,  1762,  1435,  1436,  1437,   107,   420,  1093,
     486,   183,    85,    86,   329,  1435,  1436,  1437,  1102,  1643,
     291,  1643,   409,   338,   196,   296,   443,  1389,   312,  1688,
     430,  1393,  1394,    35,   451,   452,   480,   454,   455,  2482,
    1643,  1472,   486,   460,   461,   462,   361,   183,  1479,   478,
     150,  1580,  1472,   337,  1485,  3167,   312,   486,  1489,  1479,
     196,  3367,  3368,  3369,   236,  1485,   312,   479,  1597,   312,
     350,  1643,  1419,  1420,  1729,  1422,  2737,  1508,  2269,  2829,
    2271,   337,   254,   396,  1446,  1614,   480,  1780,   479,  2885,
    2886,   337,   486,  1934,   337,   375,    77,    72,   480,  3323,
     236,   480,    83,  1934,   486,  3595,   400,   486,  3188,   339,
    1639,   170,    87,  3193,  1643,   452,  3196,   356,   254,   117,
     326,  2598,   222,   460,   461,   462,   298,  1665,  2605,  2606,
     474,   402,   482,   131,   306,   479,   486,   481,  1500,   410,
     121,  1682,   479,  1665,  1506,  1435,  1436,  1437,  2920,   134,
     482,  2249,  3282,  1682,   486,  1684,  2505,  2678,  1687,   157,
    1689,   159,   298,  2441,   453,   265,   102,   267,  2402,  1698,
     306,   223,   474,  2407,   389,   452,   391,   479,   278,   481,
    1772,   119,  1472,   460,   461,   462,   167,  2708,  1772,  1479,
     884,   487,   886,   174,   888,  1485,   177,  1719,    72,   480,
     894,  1723,   479,  1772,  2779,   486,   142,   452,   480,  1772,
      72,   311,  1643,    87,   486,   460,   461,   462,   454,   455,
    1582,  1762,  1751,  1643,  2502,    87,  2155,   163,  1852,   227,
    1852,  1772,   455,   477,  2583,  2584,   408,   481,  1539,  2780,
     106,  1542,   342,  2818,   225,  1546,   182,  2176,  2394,  1852,
    2396,  2397,   480,   480,   192,   215,  1785,  1786,   486,   486,
    3566,   197,   480,   480,  1793,   240,  1804,  1796,   486,   486,
    1799,   480,   408,   356,   374,  1804,   212,   486,  1807,  1808,
    1852,   246,  1804,  1674,   114,   115,  1815,  3320,   286,  1818,
    1819,  1820,  1821,   291,   131,   455,   389,   278,   391,  1828,
    1829,   483,  1831,   463,  1833,   465,   484,  1836,   486,   238,
     480,   471,   377,   378,   479,  1856,   486,   463,  3010,   465,
    1647,  1850,  1851,  1852,   325,   323,  1855,  2902,   303,   301,
    1859,   312,   430,   431,  1863,   333,   106,  1866,  1867,  1868,
    1869,  1870,  1871,  1872,  1873,  1874,  3584,  1876,    96,   430,
     431,  2892,  1881,  1643,    72,   291,  1885,  1719,  2017,   445,
     341,  1723,  2966,   299,   480,  3445,   240,   242,   205,   480,
     486,   452,  2470,  1911,   455,   486,   481,    95,   240,   460,
     461,   462,   100,   364,  3464,   304,   223,   452,   480,  1911,
     455,  2015,   328,  2015,   486,   460,   461,   462,   479,  1976,
    2678,  1978,  2331,   480,  3534,  1934,  1797,  1798,   301,   486,
     480,   409,  2015,  2604,  1805,  2000,   486,  1946,  1809,  1810,
     257,  1852,  3079,  3080,   445,   480,  3083,  1934,  3085,   303,
    2708,   486,  1852,  1824,   480,  1826,   452,   448,   449,   450,
     486,   303,   480,  2015,   460,   461,   462,  1976,   486,  1978,
     480,  1419,  1420,   396,  1422,  1846,   486,  1848,  3679,  1997,
    3681,   477,   477,   479,   479,   481,   480,   301,   305,  1976,
     480,  1978,   486,  2707,    96,  1997,   486,   445,   453,  2001,
    3075,  2003,   479,  2005,   481,   484,  2015,   486,   480,   304,
    2249,   466,   467,   468,   486,   470,   471,   472,   473,   474,
     475,  2030,   220,  1934,  2278,   242,   480,  2281,   472,   473,
     474,  2285,   486,  3546,  1934,   453,  3177,   479,  3290,   481,
     364,  2050,   240,   241,   472,  2054,  2055,   200,   466,   467,
     468,  3742,   470,   471,   472,   473,   474,   475,   480,   108,
    3620,   430,   431,   480,   486,  1976,   477,  1978,   479,   486,
     481,  2206,   389,    72,   391,   480,  1976,   480,  1978,   480,
     480,   486,  1852,   400,  2086,   486,   486,   136,  2342,   446,
     447,   289,   409,   470,   471,   472,   473,   474,   480,   453,
     480,   480,   480,   480,  2015,   303,   486,   486,   486,    81,
     141,   453,   466,   467,   468,  2015,   470,   471,   472,   473,
     474,   475,  1259,  1260,   466,   467,   468,   106,   470,   471,
     472,   473,   474,   475,   452,   482,   480,   455,   482,  2148,
     189,    78,   460,   461,   462,   463,  2155,   465,   483,   480,
    2168,  1993,   480,   471,  2156,   486,   422,   472,   486,  2001,
    3720,  2003,  2164,  2005,  1934,  2174,  2168,  2176,  2577,   218,
    2579,   202,   480,   480,   480,   480,  2178,   480,   486,   486,
     486,   486,  2896,   486,   480,  2424,   452,   234,  2766,   455,
     486,   483,  2770,   130,   460,   461,   462,   228,   480,  2608,
     396,   138,   139,   396,   486,  2012,  1976,   452,  1978,  2016,
     455,   396,   243,   479,  2216,   460,   461,   462,  2089,  2237,
     251,   470,   471,   472,   473,   474,  2033,   480,  2249,   478,
    2037,  2809,  2297,   486,   479,  2237,   396,   389,   480,   391,
    2249,   240,   179,   274,   486,  2015,   430,   431,  2657,  3270,
    2259,   396,  2059,   157,  2061,   453,  2098,    77,   480,  2101,
    2102,   180,   480,    83,   486,  2283,  2465,  2466,   486,   389,
     301,   391,   470,   471,   472,   473,   474,   475,   480,   480,
     480,  2283,  2291,   220,   486,   486,   486,  2094,   225,   480,
      90,  2545,   341,   480,   343,   486,   345,   106,  2402,   486,
    2402,   121,   351,  2407,   303,  2407,   480,  2178,   482,   358,
     415,  2320,  2183,   234,  2723,   364,   347,   240,   995,  2402,
     997,  2128,  2331,   372,  2407,   262,  3317,  2736,  2135,   396,
    2137,   380,   480,   237,  2771,   140,  2773,   479,   486,  2348,
    2349,   481,   279,   280,   312,   282,   283,   167,   285,   479,
    2402,   301,   480,   257,   174,  2407,   452,   177,   486,   455,
     479,  2615,  2616,   481,   460,   461,   462,   430,   431,  2378,
     337,   452,   482,  2382,   455,   252,  2785,   426,   315,   460,
     461,   462,  2791,   479,   415,  2394,  2395,  2396,  2397,  2506,
    2507,   452,   169,  2402,   171,  2508,  2509,  2406,  2407,   460,
     461,   462,  2411,  2424,   479,   225,   246,   430,   431,  1037,
    1038,   348,  2421,  2422,   191,  2424,   295,  2438,   479,  3671,
     356,   430,   479,  3675,  3676,   117,   430,    90,  2437,   452,
    2439,   479,   455,  2842,  2443,   430,  2457,   460,   461,   462,
      96,    96,   312,   246,   487,  1819,   383,   187,   385,  2470,
    2459,  2860,   415,   187,   453,   479,   479,   187,   278,   187,
     187,  2470,   187,  2472,  2473,   486,   479,   466,   467,   468,
     407,   470,   471,   472,   473,   474,   475,   414,  2887,   452,
     417,  3672,   455,  2485,  2493,   187,   187,   460,   461,   462,
    2499,  2402,   312,    90,   301,   303,  2407,   187,   187,  2508,
    2509,  2510,  2402,   301,  3525,   252,  2313,  2407,   187,   286,
     187,  2920,   197,   196,   291,   479,   309,   337,   479,   296,
     479,   341,   479,   479,   319,  3354,  3355,   479,  3357,    90,
    2784,  2540,  2786,  2340,  2788,   479,  2790,   479,  2792,   479,
     479,   479,   143,  2797,   364,   479,   479,   451,   452,   479,
     454,   455,  2561,  2562,   479,  2564,   460,   461,   462,   463,
     486,   465,  3320,   452,   479,   479,   455,   471,  2577,   479,
    2579,   460,   461,   462,   452,   240,  2830,   455,   479,   479,
    2582,  2724,   460,   461,   462,   479,   452,  2589,   479,  2591,
     479,   479,   479,   479,   460,   461,   462,   479,   252,  2608,
     196,   479,   196,  2707,   472,  2707,   234,   357,   269,   156,
    3188,   486,  2483,   479,  3805,  3193,  2759,  2756,  3196,    38,
     414,    16,   486,   479,  2707,   402,   479,   479,  3457,  3038,
     396,  3652,  2402,   410,   396,   481,   396,  2407,  3467,   396,
     396,   452,   301,  2485,   455,   453,   358,   396,  2657,   460,
     461,   462,   396,  2725,  2656,  2707,  2658,  2659,   466,   467,
     468,   291,   470,   471,   472,   473,   474,   475,  2677,  2678,
    2672,  2743,   396,   414,   396,   396,  2678,   415,   415,   396,
    2698,   396,   486,  2685,   354,  3356,   124,  2759,   396,   301,
     225,  2930,   396,  3607,   486,  2697,  2698,   396,  2707,  2708,
     452,   396,  2720,   455,  2725,   354,  2708,   479,   460,   461,
     462,   301,   396,   240,  2723,   396,   452,   299,  2720,   455,
     479,   479,  2743,  2530,   460,   461,   462,  2736,  3137,   422,
    2748,  2749,    90,  2932,  2933,  2934,  2935,   479,  2759,    79,
     157,  2750,   452,   479,  2816,  2766,  2748,  2749,   415,  2770,
     460,   461,   462,   425,   260,    90,  2598,  2766,   452,   479,
     196,  2770,   301,  2605,  2606,    90,   460,   461,   462,   479,
     452,  2780,   481,   455,   355,   428,  2785,   187,   460,   461,
     462,   463,  2791,   465,   415,   479,   187,   187,  3546,   471,
     415,    16,  2896,   466,  2896,  2816,  2707,   396,   486,   486,
    2809,   420,   344,   290,  3633,   201,   427,  2707,   452,   394,
     479,   455,  2683,  2896,  2685,  3836,   460,   461,   462,   394,
     271,   271,    72,   364,   486,   394,   396,   479,   479,   201,
    2839,   466,   398,  2842,   466,   480,  2678,   236,   486,  2848,
     486,   302,   119,  2650,  2896,  2854,   486,  2856,   296,   254,
     477,  2860,  2861,    35,  3683,  2864,  2865,  2866,  2867,  2868,
    2869,  2870,  2871,  2872,  2873,   480,  2708,  3445,   396,  2878,
    2879,   480,   396,   354,  1819,   130,   479,   244,  2887,   244,
     291,  3290,   291,  2892,   479,   291,  3464,  2896,  2906,  2898,
     254,   307,   480,   301,   486,   486,   412,   315,  2907,   106,
     315,  2910,   106,  2912,  2906,   337,   337,   337,   396,  2930,
     396,  2920,  2921,  2922,  2923,   192,   329,   240,  2927,    90,
     240,  2930,   240,   415,   415,   240,   466,   477,  3337,   396,
     396,  2940,   254,  1878,   466,   196,   466,  2707,   301,   305,
     186,   479,    90,  2945,   210,     8,   301,   473,  3619,    12,
      13,    14,   196,  3624,  3625,   213,   213,  3211,  3212,   479,
      23,    24,    25,   486,    27,    28,    90,  3545,   479,    32,
      33,    34,   480,   778,   301,   301,    11,   486,    78,   207,
     387,   268,   301,   486,   106,  2896,   480,   480,   201,   486,
     480,   480,   445,   445,   396,   480,  2896,   802,   480,   445,
     480,   480,   480,  2810,  2378,   480,  3584,   480,  2382,  3680,
     480,  3682,   480,   201,    16,   480,   480,   479,    86,   479,
      31,   480,   480,   486,  2831,    93,   291,    95,   482,  3038,
     428,   487,   254,   480,   230,   479,   104,   482,   479,   312,
     396,   480,  3620,   263,   263,   263,   396,  2421,  2422,   396,
    3721,   396,   396,   396,   396,   396,   240,   240,   480,   240,
    3469,   240,   130,   240,   240,  3067,  3068,  3069,  3070,  3071,
    3072,   139,   269,   477,   301,   405,   339,   480,   299,   147,
     148,   415,   479,   151,   301,   396,   480,   301,   479,   157,
    3761,   480,   243,   161,   486,   479,   308,  3768,   166,   243,
    3102,  3103,  3104,  3105,  3106,   296,   415,   415,   913,   486,
     304,   486,   180,   918,  3785,   183,   477,  3126,   466,   184,
     188,   180,   184,   201,   929,    72,  2896,   196,  3137,   480,
     198,   480,   424,   115,   202,   201,   204,   209,   466,   230,
     208,   480,  3720,   479,   396,   466,   463,   480,   486,   480,
    3168,   405,   466,   958,   396,   479,   224,    72,   396,   396,
     396,   240,   196,   240,   480,   240,  3168,  3188,   164,   974,
     244,   478,  3193,   479,   979,  3196,   453,   430,    90,  3188,
      95,   196,   305,   226,  3193,   100,   126,  3196,   993,   466,
     467,   468,   418,   470,   471,   472,   473,   474,   475,   388,
     479,   486,   453,  3781,   479,   243,   480,   479,   271,   480,
      90,   479,   206,   201,   201,   106,   480,   479,  3796,  3473,
    3474,  3475,  3476,   429,   480,  3234,  3097,   429,   211,   415,
     405,  3102,  3103,  3104,  3105,  3106,   291,   480,   486,  3110,
     291,   486,   187,  3050,   291,  3052,   486,   240,  3090,   159,
     227,   203,   203,   201,   478,   415,   319,  3835,   415,   175,
     186,  3270,  3671,   117,   480,   117,  3675,  3676,  3277,  3278,
     479,  3849,   304,   245,   201,  3284,  3285,   396,   479,   479,
    3289,  3290,   196,  3861,   304,   419,  3295,  3296,   201,   479,
    3299,   373,   479,   333,   430,   480,   196,  3315,    90,   291,
     480,   216,   264,   223,   327,   220,   479,   479,   486,   351,
    1115,    93,  3314,  3315,   351,   304,   301,   385,   304,   196,
     192,  3323,   419,   486,   388,   240,   241,   430,  3337,   175,
     301,   301,    90,  3742,   479,   170,   350,   480,   253,   162,
     413,   332,   405,  3415,   186,    76,   327,   479,  2205,   241,
    1394,  2485,  2127,  2609,  2168,  3152,  3376,   108,  3035,  3377,
    3378,  1166,  1167,  1168,  3382,  3367,  3368,  3369,  3155,  2110,
    3405,   286,  2541,  3164,   289,  3377,  3378,  3379,  3780,  3804,
    3382,  3383,  3759,  3758,  3788,   136,  2378,  2800,   303,  3157,
    2382,  3645,  1661,  3439,  3415,  3404,  2187,  3861,  3388,  3835,
    3389,  2708,  2707,  3421,  2677,  3795,  3548,  1641,  3806,   183,
    3551,  1248,  2315,  3169,  3222,  3222,  3620,  3720,  2561,  3421,
    2055,  2054,  3175,  3686,   973,  3826,  3860,  3596,  3446,  2421,
    2422,  2194,  1944,  2378,   159,  3150,  3445,  2382,   189,  1230,
    2817,  1246,  2491,  3464,  3446,  1230,  2295,  3216,  2499,  1427,
    2510,  3460,  1426,   368,  3325,  3464,  1959,  1428,  1938,  2470,
    3469,  2249,  1267,  2492,  3335,  3336,  3465,   218,  2772,  3340,
    3341,   847,  3314,  3148,  2905,  2898,  2421,  2422,  3650,  3350,
    2502,  3323,  3491,  1834,  2438,  2350,  3495,  2861,  2436,  2320,
    2864,  2865,  2866,  2867,  2868,  2869,  2870,  2871,  2872,  2873,
    1881,  2581,   598,  2756,  2242,  3514,  3515,  1676,  1997,  3518,
    1437,  1177,   348,  1431,  1974,  1254,  3525,  3526,  2001,   879,
    1057,  1038,  2303,  2480,  2304,  3217,  3333,  3313,  3218,  1370,
     598,  2970,  1435,   381,  2005,  1745,  3545,  3344,   453,  3346,
    2298,  1217,     2,    -1,    -1,    -1,    -1,    -1,  2922,  2923,
    3559,   466,   467,   468,    -1,   470,   471,   472,   473,   474,
     475,   312,    -1,    -1,  3566,    -1,    -1,    -1,    -1,    -1,
      -1,  3643,    -1,    -1,    -1,  3584,    -1,    -1,    -1,    -1,
     648,   649,    -1,    -1,    -1,    -1,   337,    -1,    -1,    -1,
     341,    -1,    -1,    -1,   345,    -1,    -1,  1402,    -1,  3617,
     351,  3840,    -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,
      -1,  3620,  3621,   364,    -1,  3617,    -1,    -1,    -1,    -1,
      -1,   372,  3643,    -1,    -1,    -1,    -1,    -1,    -1,   380,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3647,  3648,
      -1,  3650,    -1,  3652,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3671,    -1,    -1,    -1,  3675,  3676,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   426,    -1,    -1,    -1,  3486,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3529,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     768,   769,   770,    -1,   772,    -1,   774,    -1,   776,   777,
      -1,  3720,   780,    -1,   782,   783,   784,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3742,    -1,    -1,    -1,   805,    -1,  1544,
     808,    -1,   810,    90,   812,    -1,    -1,    -1,   816,   817,
     818,    -1,  3126,    -1,   822,    -1,   824,    -1,   826,    -1,
      -1,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   839,  3781,   841,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   853,    -1,  3796,   856,   136,
      -1,   859,    -1,    -1,    -1,   863,   864,    -1,    -1,    -1,
     868,    -1,   870,    -1,   872,  3826,    -1,   875,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3818,    -1,    72,  3840,
      -1,    -1,    -1,    -1,    -1,    -1,  3835,  3836,   896,    -1,
     898,    -1,    -1,    87,    -1,    -1,   904,    -1,    -1,  3860,
    3849,    95,   189,    -1,    -1,    -1,   100,    -1,    -1,    -1,
      -1,    -1,  3861,    -1,    -1,    -1,  3858,   925,    -1,   927,
      -1,    -1,   930,    -1,    -1,    -1,    -1,    -1,    -1,  2861,
      -1,   218,  2864,  2865,  2866,  2867,  2868,  2869,  2870,  2871,
    2872,  2873,    -1,    -1,    -1,    -1,    -1,    -1,   956,   957,
      -1,    -1,    -1,   961,    -1,    -1,    -1,  1702,    -1,   246,
      -1,    -1,    -1,    -1,  1709,    -1,    -1,    -1,    -1,    -1,
    3284,  3285,   980,    -1,    -1,    -1,  2861,    -1,    -1,  2864,
    2865,  2866,  2867,  2868,  2869,  2870,  2871,  2872,  2873,    -1,
    2922,  2923,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,  1754,
    1755,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1766,   216,    -1,    -1,    -1,   220,  1035,  1036,    -1,
      95,    -1,    -1,    -1,    72,   100,    -1,  2922,  2923,  1047,
      -1,    -1,  1050,    -1,    -1,  1053,   240,   241,    -1,    87,
      -1,    -1,    -1,    -1,   341,    -1,    -1,    95,   345,   253,
      -1,    -1,   100,    -1,   351,    -1,    -1,    -1,    -1,  1077,
    1078,   358,    -1,    -1,    72,    -1,    -1,   364,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   372,    -1,    -1,    -1,    87,
      -1,    -1,   286,   380,    -1,   289,  1104,    95,    -1,    -1,
      -1,    -1,   100,    -1,    -1,    -1,    -1,    90,  1116,   303,
      -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1129,    -1,    -1,    -1,   108,    -1,  1135,    -1,    -1,
      -1,  1139,    -1,    -1,    -1,  1880,    -1,    -1,  1146,   426,
      -1,    -1,    -1,    -1,    -1,    -1,  1154,  1155,    -1,    -1,
      -1,   216,    -1,   136,    -1,   220,    -1,    -1,    -1,    -1,
      -1,    -1,  1170,  1171,    -1,  1173,  1174,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   368,   240,   241,  3491,   216,    -1,
      -1,  3495,   220,    -1,    -1,    -1,    -1,    -1,   253,  1197,
    1198,    -1,    -1,  1201,  3126,    -1,    -1,    -1,    -1,  1944,
    3514,  3515,   240,   241,    -1,    -1,   189,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   253,    80,    -1,   216,    -1,
      -1,    -1,   220,    -1,   289,    -1,    -1,    -1,    -1,    -1,
    1238,    -1,    -1,    -1,    -1,   218,    -1,    -1,   303,  1247,
    1248,  3126,   240,   241,  1252,    -1,    -1,    -1,   286,  1257,
      -1,   289,    -1,    -1,    -1,   253,    -1,  1265,    -1,   453,
    1268,    -1,  1270,   246,    -1,   303,    -1,   305,    -1,    -1,
     134,    -1,   466,   467,   468,    -1,   470,   471,   472,   473,
     474,   475,    -1,    -1,   478,    -1,    -1,   151,   286,    -1,
      -1,   289,    -1,   487,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   368,    -1,   303,    -1,   305,   172,    -1,
      -1,    -1,  1145,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     368,    -1,    -1,  3647,  3648,    -1,    -1,    -1,    -1,   203,
      -1,    -1,    -1,    -1,    -1,   209,    -1,    -1,    -1,    -1,
      -1,    -1,  3284,  3285,    -1,    -1,    -1,    -1,   341,   223,
      -1,    -1,   345,    -1,  1372,  1373,    -1,    -1,   351,    -1,
     368,    -1,    -1,    -1,    -1,   358,    -1,  2122,  1386,    -1,
      -1,   364,    -1,    -1,    -1,  1393,  1394,    -1,   453,   372,
      -1,    -1,    -1,    -1,    -1,    -1,  1404,   380,  1406,  3284,
    3285,   466,   467,   468,    -1,   470,   471,   472,   473,   474,
     475,    -1,    -1,    -1,    -1,   453,    -1,    -1,    -1,    -1,
      -1,    -1,  1255,    -1,    -1,    -1,    -1,    -1,   466,   467,
     468,    -1,   470,   471,   472,   473,   474,   475,    -1,   303,
      -1,    -1,    -1,   426,    -1,  1453,    -1,  1455,   486,    -1,
      -1,    -1,    -1,    -1,    -1,   453,    -1,    -1,  2203,    -1,
      -1,    -1,   326,    -1,    -1,    -1,  1474,    -1,   466,   467,
     468,    -1,   470,   471,   472,   473,   474,   475,    -1,    -1,
      -1,    -1,    -1,    -1,   348,    -1,  2231,    72,   486,    -1,
     354,    -1,    -1,    -1,  2239,    -1,   360,    -1,    -1,    -1,
      -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    -1,    -1,    -1,    -1,   100,    -1,    -1,    -1,    -1,
      -1,    -1,  1530,   387,   388,    -1,    -1,    -1,   392,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   400,    -1,    -1,    -1,
      -1,   405,    -1,    -1,    -1,  1553,  1554,  1555,  1556,    -1,
     414,    -1,    -1,    -1,    -1,    -1,  1389,    86,    -1,  3491,
      -1,   425,    72,  3495,    93,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1583,  1584,    87,    -1,    -1,
      -1,  1589,  3514,  3515,    -1,    95,    -1,    -1,    -1,    -1,
     100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   130,    -1,    -1,    -1,    -1,  3491,    -1,    -1,    -1,
    3495,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   147,   148,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   157,  3514,
    3515,   216,   161,    -1,    -1,   220,    -1,    -1,    -1,  1647,
      -1,  1649,    72,  1651,  1652,  1653,  1654,    -1,  1481,    -1,
      -1,    -1,   181,    -1,   183,   240,   241,  1665,    -1,  1667,
      -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,   253,   198,
     100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1688,    -1,  1515,  1691,  1692,    -1,    -1,    -1,    -1,  1697,
      -1,    -1,  1700,  1701,    -1,  1703,  1529,    -1,    -1,    -1,
    1708,   286,  1710,    -1,   289,  1713,   216,    -1,  1716,    -1,
     220,    -1,    -1,    -1,    -1,  3647,  3648,    -1,   303,  2464,
     305,    -1,  1730,  1731,    -1,    -1,    -1,    -1,    -1,    -1,
     240,   241,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1750,   253,  1752,  1753,    -1,  1580,  1756,    -1,
      -1,    -1,    -1,    -1,  1762,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3647,  3648,  1597,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1780,    -1,    -1,  1783,   286,    -1,    -1,   289,
      -1,  1614,    -1,   368,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,   303,    -1,   305,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1639,    -1,    -1,  1817,
     240,   241,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   253,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1687,    -1,   385,    -1,   368,   289,
      -1,    -1,    -1,    -1,    -1,  1698,    -1,    -1,   453,    -1,
      -1,    -1,    -1,   303,    -1,    -1,    -1,    -1,    -1,  1887,
      -1,   466,   467,   468,    -1,   470,   471,   472,   473,   474,
     475,    -1,    -1,    -1,    -1,   480,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1937,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,  1947,
      -1,    -1,    -1,   453,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,    -1,    -1,    -1,    -1,
     480,    -1,    -1,  2718,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2727,    -1,    -1,    -1,    -1,    -1,    -1,  1997,
      -1,    -1,  2000,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2746,    -1,    -1,  2012,  2013,    -1,    -1,  2016,  2017,
      -1,    -1,    -1,  2021,    -1,    -1,    -1,  1850,    -1,  2027,
      -1,    -1,    -1,   453,  2032,  2033,    -1,    -1,    -1,  2037,
    2038,    -1,    -1,    -1,    -1,  2043,    -1,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,    -1,    -1,  2793,    -1,
    2795,  2059,  2060,  2061,  2062,  2800,  2064,    -1,    -1,  2067,
    2068,    -1,    72,    -1,    -1,  2073,    -1,    -1,    -1,   598,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,  2087,
      -1,    -1,    -1,  2091,  2829,    95,  2094,  2095,  2096,  2097,
     100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2110,  2111,  2112,  2113,  2114,  2115,  2116,    -1,
      -1,  2119,  2120,    -1,    -1,  2123,  2124,  2125,    -1,    -1,
    2128,  2129,    -1,    -1,    -1,    -1,    -1,  2135,  2136,  2137,
      -1,  2139,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    -1,  2157,
    2158,  2159,  2160,  2161,  2162,    -1,    -1,    -1,    -1,    -1,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
    2178,    -1,    -1,    -1,   100,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2199,  2937,  2938,    -1,    -1,    -1,    -1,    -1,  2207,
      -1,    -1,    -1,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,    -1,    -1,    -1,  2050,    -1,  2227,
      -1,  2054,  2055,    -1,  2232,    -1,  2234,    -1,    -1,    -1,
     240,   241,    -1,    -1,  2242,    -1,    -1,    72,    -1,   137,
      -1,    -1,  2250,   253,    -1,    -1,  2254,  2255,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,  2269,  2270,  2271,  2272,   100,    -1,    -1,    72,    -1,
     799,    -1,    -1,    -1,    -1,    -1,   286,    -1,    -1,   289,
      -1,    -1,    -1,    87,    -1,   183,    -1,    -1,    -1,  2297,
     216,    95,    -1,   303,   220,   305,   100,    -1,   196,    -1,
      -1,    -1,    -1,   201,    -1,  2313,    -1,    -1,   206,   838,
     839,   209,   841,   211,   240,   241,    -1,    -1,    -1,    -1,
      -1,    -1,  2155,    -1,    -1,    -1,    -1,   253,    -1,  2337,
      -1,    -1,  2340,    -1,    -1,    -1,    -1,    -1,   236,    -1,
      -1,    -1,    -1,  2176,    -1,    -1,    -1,   182,    -1,    -1,
      -1,   880,    -1,    -1,    -1,   884,   254,   886,   368,   888,
     286,    -1,    -1,   289,  3109,   894,   895,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   904,    -1,   303,    -1,   305,
      -1,   216,    -1,    -1,    -1,   220,    -1,  3132,    -1,    -1,
      -1,    -1,    -1,   922,    -1,    -1,    -1,  3142,    -1,    -1,
     298,    -1,    -1,    -1,  2412,   240,   241,    -1,   306,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,   253,    -1,
     949,    -1,    -1,    -1,    -1,    -1,    -1,   956,   957,    -1,
      -1,   960,   961,  2441,    -1,    -1,   240,   241,    -1,    -1,
      -1,    -1,   368,   453,    -1,    -1,   344,    -1,    -1,   253,
      -1,    -1,    -1,    -1,   289,    -1,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,    -1,    -1,   303,    -1,
     480,    -1,    -1,    -1,    -1,    -1,    -1,  2485,    -1,    -1,
      -1,    -1,   286,  2491,    -1,   289,    -1,    -1,    -1,   387,
      -1,    -1,  1021,    -1,    -1,    -1,    -1,  2505,  2331,   303,
      -1,   305,    -1,    -1,    -1,    -1,  1035,  1036,    -1,    -1,
     408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2530,  2531,  2532,    -1,    -1,   453,    -1,    -1,
     428,    -1,    -1,   368,    -1,    -1,  2544,    -1,    -1,    -1,
     466,   467,   468,    -1,   470,   471,   472,   473,   474,   475,
     448,   449,   450,    -1,   480,    -1,  3301,  3302,  3303,  3304,
      -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2583,  2584,    -1,    -1,   477,
      -1,    -1,   480,   481,   482,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2604,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    -1,    -1,  2617,
    2618,  2619,  2620,  1142,    -1,    -1,    -1,    -1,   453,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,
      -1,    -1,    -1,   100,    -1,   470,   471,   472,   473,   474,
     475,    -1,  2650,  2651,    -1,    -1,    -1,    -1,    80,   453,
      -1,    -1,  2660,  2661,    -1,    -1,    -1,    -1,    -1,    -1,
      92,    -1,   466,   467,   468,    -1,   470,   471,   472,   473,
     474,   475,    -1,    -1,    -1,    -1,   480,  2685,    -1,    -1,
     112,    -1,    -1,    -1,  1213,    -1,    -1,    -1,    -1,    -1,
      -1,  2699,  2700,  2701,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   134,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1241,    -1,    -1,  1244,  2724,    -1,   115,   151,
      -1,    -1,    -1,    -1,    -1,  1254,    -1,    -1,  2561,  2562,
      -1,  2564,    -1,    -1,    -1,    -1,  2744,    -1,    -1,    -1,
     172,  2749,    -1,    -1,  2577,    -1,  2579,    -1,  2756,   216,
      -1,  2759,  2760,   220,    -1,  2763,    -1,    -1,    -1,   156,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,  2776,    -1,
      -1,   203,    -1,   240,   241,  2608,    -1,   209,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   253,    -1,    -1,    -1,
      95,   223,    -1,    -1,    -1,   100,    -1,    -1,    -1,    -1,
      -1,    -1,  2810,    -1,    -1,    -1,   203,    -1,  1337,  2817,
      -1,    -1,    -1,   210,    -1,   212,    -1,    -1,  1347,   286,
      -1,    -1,   289,  2831,  2657,    -1,   223,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   303,    -1,   305,  1368,
      -1,  3586,    -1,  1372,  1373,  2678,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1386,    -1,    -1,
    1389,    -1,  3607,    -1,  1393,  1394,    -1,    -1,    -1,    -1,
      -1,   303,    -1,    -1,    -1,  2708,    -1,   182,    -1,   311,
      -1,    -1,    -1,  3628,    -1,    -1,    -1,    -1,    -1,    -1,
    2723,    72,    -1,    -1,   326,    -1,    -1,    -1,    -1,    -1,
      -1,   368,    -1,  2736,    -1,    -1,    87,    -1,    -1,    -1,
      -1,   216,    -1,    -1,    95,   220,   348,  2750,    80,   100,
     352,    -1,   354,  3668,  1453,    -1,  1455,    -1,   360,    -1,
      -1,    -1,    -1,    -1,    -1,   240,   241,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   253,    -1,
     112,    -1,  2785,    -1,    -1,   387,   388,    -1,  2791,    -1,
     392,    -1,   124,    -1,  2972,    -1,    -1,    -1,   400,    -1,
      -1,  1500,   134,   405,    -1,    -1,    -1,  1506,    -1,    -1,
      -1,    -1,   414,    -1,   289,    -1,   453,    -1,    -1,   151,
      -1,    -1,    -1,   425,    -1,    -1,  3004,  3005,   303,   466,
     467,   468,    -1,   470,   471,   472,   473,   474,   475,  2842,
     172,    -1,    -1,   480,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2860,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   216,    -1,    -1,  3046,   220,
      -1,   203,  3050,  3051,  3052,  3053,  3054,  3055,  3056,    -1,
      -1,    -1,    -1,  1582,  2887,    -1,    -1,    -1,    -1,   240,
     241,   223,    -1,   368,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   253,    -1,    -1,    -1,    -1,    -1,   140,    -1,
      -1,    -1,    -1,    -1,    72,   247,    -1,  2920,    -1,    -1,
      -1,    -1,    -1,    -1,  3102,  3103,  3104,  3105,  3106,    -1,
      -1,    -1,    -1,    -1,    -1,   286,    -1,    95,   289,    -1,
      -1,    -1,   100,    -1,    -1,    -1,    -1,  3125,    -1,    -1,
      -1,    -1,   303,    -1,   305,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1665,    -1,    -1,    -1,
    3148,   303,    -1,    -1,  3152,  1674,    -1,  3155,   453,  3157,
      -1,    -1,    72,    -1,    -1,    -1,  3164,    -1,    -1,    -1,
      -1,    -1,  3170,   225,   326,   470,   471,   472,   473,   474,
     475,    -1,    -1,    -1,    -1,    95,  3184,    -1,  3186,    -1,
     100,    -1,    -1,    -1,    -1,    -1,   348,   368,    -1,  3197,
     352,  3199,   354,  3201,   182,    -1,    72,  3205,   360,  3207,
      -1,    -1,  1731,    -1,    -1,  3038,    -1,    -1,    -1,    -1,
      -1,    87,    -1,    -1,  3222,    -1,  1745,  1746,    -1,    95,
      -1,    -1,    -1,    -1,   100,   387,   388,    -1,   216,    -1,
     392,    -1,   220,    -1,    -1,    -1,    -1,    -1,   400,    -1,
      -1,    -1,    -1,   405,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   240,   241,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   425,    -1,   253,    -1,    -1,  1797,  1798,
      -1,    -1,   453,    -1,    -1,  1804,  1805,    -1,    -1,    -1,
    1809,  1810,    -1,    -1,    -1,   466,   467,   468,    -1,   470,
     471,   472,   473,   474,   475,  1824,   216,  1826,    -1,   480,
     220,   289,    -1,    -1,  3137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3320,    -1,    -1,   303,    -1,  1846,    -1,  1848,
     240,   241,    -1,    -1,    -1,  3333,  3334,    -1,    -1,    -1,
      -1,    -1,    -1,   253,    -1,    -1,  3344,  3345,  3346,    -1,
     216,    -1,    -1,  3351,   220,    -1,  3354,  3355,  3356,  3357,
      -1,  1880,    -1,    -1,    -1,    -1,    -1,    -1,  1887,    -1,
      -1,    -1,   759,    -1,   240,   241,  1895,    -1,    -1,   289,
     767,    -1,    -1,  3381,   771,    -1,    -1,   253,    -1,    -1,
     368,    -1,  1911,   303,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   804,    -1,    -1,
     286,    -1,    -1,   289,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3432,    -1,    -1,   303,    -1,   305,
      -1,  3439,    -1,    -1,    -1,    -1,    -1,  3445,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3454,    -1,   368,  3457,
      -1,    -1,    -1,    -1,    -1,   852,    -1,  3290,    -1,  3467,
      -1,   858,    -1,    -1,  1993,   453,    -1,    -1,  1997,    -1,
      -1,  2000,  3480,    -1,    -1,    -1,    -1,    -1,  3486,    -1,
      -1,    -1,   470,   471,   472,   473,   474,   475,    -1,    -1,
      -1,    -1,   368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3337,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   453,    -1,    -1,    -1,    -1,  3546,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     470,   471,   472,   473,   474,   475,    -1,   954,    -1,    -1,
    2089,    -1,   959,    -1,    -1,   962,  3574,    -1,    -1,  2098,
      -1,    -1,  2101,  2102,    -1,    -1,    -1,   453,    72,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3595,   985,  3597,
     466,   467,   468,    87,   470,   471,   472,   473,   474,   475,
      -1,    95,    -1,    -1,   480,    -1,   100,    -1,    -1,    -1,
      -1,  3619,  3620,    -1,    -1,    -1,  3624,  3625,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3633,    -1,  2156,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2164,  3469,    -1,    72,  2168,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2178,
      -1,    -1,    -1,    87,  2183,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    -1,    -1,    -1,    -1,   100,    -1,    -1,    -1,
      -1,  3679,  3680,  3681,  3682,  3683,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3701,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   767,    -1,    -1,  2237,   771,
      -1,   773,  3720,  3721,  1111,  1112,   778,   779,    -1,    -1,
      -1,  1118,   216,   785,    -1,    -1,   220,  1124,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     802,    -1,   804,    -1,    -1,    -1,   240,   241,  1145,    -1,
      -1,    -1,  3760,  3761,  2283,    -1,    -1,    -1,    -1,   253,
    3768,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2297,  2298,
      -1,    -1,  2301,    -1,  2303,  1172,    -1,  3785,    -1,    -1,
      -1,    -1,   216,    -1,    -1,   847,   220,    -1,  3796,    -1,
     852,    -1,   286,    -1,    -1,   289,   858,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   240,   241,    -1,   303,
      -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   253,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3835,    -1,    -1,
      -1,  1228,    -1,    -1,    -1,    -1,    -1,    -1,  3671,    -1,
      -1,    -1,  3675,  3676,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   913,   286,  3861,    -1,   289,   918,    -1,  1255,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   929,    -1,   303,
      -1,   305,    -1,    -1,   368,    -1,    -1,    -1,    72,  1276,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   958,    -1,    -1,    -1,
      -1,    95,    -1,    -1,    -1,  1302,   100,    -1,    -1,  3742,
      -1,    -1,   974,    -1,    -1,    -1,    -1,   979,    -1,    -1,
      -1,    -1,    72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   993,    -1,    -1,   368,  1332,  1333,    87,  1335,    -1,
      -1,    91,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,
     100,    -1,  2481,    -1,  2483,  1352,  2485,    -1,    -1,   453,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,   468,    -1,   470,   471,   472,   473,
     474,   475,    -1,    -1,    -1,    -1,   480,    -1,   182,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   165,    -1,    -1,    -1,   453,
      -1,    -1,   216,    -1,  1421,    -1,   220,  1424,  1425,    -1,
      -1,    -1,   466,   467,   468,    -1,   470,   471,   472,   473,
     474,   475,    -1,    -1,   478,    -1,   240,   241,    -1,    -1,
      -1,    -1,  2581,  1115,    -1,    -1,  1118,    -1,    -1,   253,
      -1,    -1,  1124,    -1,    -1,    -1,   216,    -1,    -1,  2598,
     220,    -1,    -1,    -1,    -1,    -1,  2605,  2606,    -1,    -1,
      -1,    -1,    -1,    -1,  1481,    -1,    -1,    -1,  1485,    -1,
     240,   241,  1489,    -1,    -1,   289,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   253,  1166,  1167,  1168,    -1,    -1,   303,
    1172,  1508,    -1,    -1,    -1,    -1,    -1,    -1,  1515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2656,    -1,  2658,
    2659,    -1,  1529,    -1,    -1,    -1,   286,    -1,    -1,   289,
      -1,    -1,    -1,  2672,    -1,    -1,    -1,    -1,    -1,  2678,
      -1,    -1,    -1,   303,  2683,   305,  2685,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2697,  2698,
      -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,    -1,  2708,
      -1,    -1,    -1,  1580,  1246,    -1,    -1,    -1,    -1,    -1,
      -1,  2720,    -1,    -1,    -1,  2724,    -1,    -1,    -1,    -1,
    1597,    -1,    -1,    -1,    -1,  1267,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    -1,    -1,    -1,  1614,   368,  2748,
    2749,    -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,    -1,
    2759,    -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,
     100,    -1,  1639,    -1,    -1,    -1,  1643,    -1,    -1,    -1,
      -1,  1145,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   453,
      -1,    -1,    -1,    -1,    -1,   415,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   470,   471,   472,   473,
     474,   475,    -1,    -1,    -1,  1682,    -1,  1684,    -1,    -1,
    1687,    -1,  1689,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1698,    -1,   453,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,
    1402,   201,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1751,    -1,   216,    -1,    -1,    -1,
     220,  1255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2906,    -1,    -1,
     240,   241,    -1,    -1,    -1,    -1,    -1,    -1,  1785,  1786,
      -1,    -1,    -1,   253,    -1,    -1,  1793,    -1,    -1,  1796,
      -1,    -1,  1799,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1807,  1808,    -1,    -1,    -1,    -1,    -1,    -1,  1815,    -1,
      -1,  1818,  1819,  1820,  1821,    -1,   286,    -1,    -1,   289,
      -1,  1828,  1829,    -1,  1831,    -1,  1833,    -1,    -1,  1836,
      -1,    -1,    -1,   303,    -1,   305,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1850,  1851,  1852,    -1,    -1,  1855,    -1,
      -1,    -1,  1859,    -1,    -1,    -1,  1863,    -1,    -1,  1866,
    1867,  1868,  1869,  1870,  1871,  1872,  1873,  1874,    -1,  1876,
      -1,    -1,  1544,    -1,  1881,    -1,    -1,    -1,  1885,    -1,
      -1,    -1,    -1,    -1,    -1,  1557,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    -1,    -1,   368,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,
      -1,    -1,   100,    -1,    -1,    -1,    -1,    -1,  3067,  3068,
    3069,  3070,  3071,  3072,    -1,    -1,    -1,    -1,    -1,  1946,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3097,    -1,
      -1,    -1,    -1,  3102,  3103,  3104,  3105,  3106,    -1,    -1,
      -1,  3110,    -1,    -1,    -1,    -1,    -1,  1481,    -1,    -1,
      -1,    -1,    -1,   453,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,    -1,    -1,  2015,    -1,
    1682,  1515,  1684,    -1,    -1,    -1,    -1,  1689,    -1,    -1,
      -1,    -1,    -1,  2030,    -1,  1529,    -1,    -1,    -1,  3168,
    1702,    -1,    -1,    -1,    -1,    -1,    -1,  1709,   216,    -1,
      -1,    -1,   220,  2050,    -1,    -1,    -1,  2054,  2055,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   240,   241,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   253,  1580,    -1,  3217,  1751,
      -1,    -1,  1754,  1755,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1597,  1766,     2,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   286,    -1,
    1614,   289,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   303,    -1,   305,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1639,    -1,    -1,    -1,    -1,
      -1,  2148,   320,    -1,    -1,    -1,    -1,    -1,  2155,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2174,    -1,  2176,
      -1,    -1,    -1,    -1,    -1,  3314,  3315,    -1,    -1,    -1,
      -1,    -1,    -1,  1687,    -1,    -1,  3325,    -1,    -1,    -1,
     368,  1145,    72,    -1,  1698,    -1,  3335,  3336,    -1,    -1,
      -1,  3340,  3341,   381,    -1,    -1,    -1,    87,  1880,    -1,
      90,  3350,    -1,    -1,    -1,    95,    -1,    95,    -1,    -1,
     100,    -1,    -1,    -1,    -1,    -1,   104,    -1,  3367,  3368,
    3369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3377,  3378,
      -1,    -1,  2249,  3382,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2259,    -1,   161,    -1,    -1,    -1,    -1,    -1,
      -1,   139,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     148,    -1,  1944,   151,    -1,   453,   183,    -1,    -1,   157,
      -1,    -1,  3421,   161,  2291,    -1,    -1,    -1,   466,   467,
     468,    -1,   470,   471,   472,   473,   474,   475,    -1,    -1,
      -1,  1255,    -1,    -1,    -1,   183,    -1,  3446,    -1,    -1,
      -1,    -1,    -1,  2320,    -1,    -1,    -1,    -1,    -1,    -1,
     198,    -1,    -1,    -1,  2331,    72,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,  2348,  2349,    -1,    -1,    -1,  1850,    -1,    95,    -1,
      -1,    72,    -1,   100,    -1,    -1,    -1,    -1,    -1,    -1,
     240,   241,    -1,    -1,    -1,    -1,    87,    -1,    -1,    90,
      -1,  2378,    -1,   253,    95,  2382,    -1,    -1,    -1,   100,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2394,  2395,  2396,
    2397,    -1,    -1,    -1,    -1,  2402,    -1,    -1,    -1,  2406,
    2407,    -1,    -1,    -1,  2411,    -1,   286,    -1,    -1,   289,
      -1,    -1,    -1,    -1,  2421,  2422,    -1,  2424,    -1,    -1,
      -1,    -1,    -1,   303,    -1,   305,    -1,  3566,    -1,    -1,
    2437,    -1,  2439,    -1,    -1,   182,  2443,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2122,    -1,  2459,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2470,    -1,  2472,  2473,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,    -1,  3617,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2493,    -1,   368,    -1,
      -1,    -1,  2499,   240,   241,   216,    -1,    -1,    -1,   220,
      -1,  2508,  2509,  2510,    -1,    -1,   253,   385,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,
     241,    -1,    -1,    -1,    -1,    -1,    -1,  1481,    -1,    -1,
      -1,  2203,   253,  2540,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   289,    -1,    -1,    -1,  2050,    -1,    -1,    -1,
    2054,  2055,    -1,    -1,  2561,  2562,   303,  2564,    -1,  2231,
      -1,  1515,    -1,    -1,    -1,   286,    -1,  2239,   289,    -1,
    2577,    -1,  2579,   453,    -1,  1529,    -1,  2249,    -1,    -1,
      -1,    -1,   303,    -1,   305,    -1,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,    -1,    -1,    -1,    -1,
      -1,  2608,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   368,    -1,    -1,    -1,    -1,  1580,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,    72,    -1,
     100,    -1,    -1,  1597,    -1,    -1,    -1,   368,    -1,    -1,
    2657,  2155,    -1,    87,    -1,    -1,    -1,  3796,    -1,    -1,
    1614,    95,    -1,    -1,    -1,    -1,   100,    -1,    -1,    -1,
      -1,  2678,  2176,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1639,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3835,    -1,    -1,    -1,
    2707,  2708,    -1,    -1,    -1,    -1,   453,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2723,    -1,    -1,    -1,
      -1,    -1,  3861,   470,   471,   472,   473,   474,   475,  2736,
      -1,    -1,   453,  1687,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2750,  1698,   466,   467,   468,    -1,   470,
     471,   472,   473,   474,   475,    -1,   216,    -1,    -1,  2766,
     220,    -1,    -1,  2770,    -1,    -1,    -1,    -1,    -1,    -1,
     648,   649,    -1,  2780,    -1,    -1,    -1,    -1,  2785,    -1,
     240,   241,   216,    -1,  2791,    -1,   220,    -1,    -1,    -1,
      -1,    -1,  2464,   253,    -1,    -1,    -1,    -1,  2470,    -1,
      -1,    -1,  2809,    -1,    -1,    -1,   240,   241,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   253,
      -1,    -1,    -1,    -1,    -1,    -1,   286,  2331,    -1,   289,
      -1,    -1,  2839,    -1,    -1,  2842,    -1,    -1,    -1,    -1,
      -1,  2848,    -1,   303,    -1,   305,    -1,  2854,    -1,  2856,
      -1,    -1,   286,  2860,  2861,   289,   316,  2864,  2865,  2866,
    2867,  2868,  2869,  2870,  2871,  2872,  2873,    -1,    -1,   303,
      -1,  2878,  2879,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2887,    -1,    -1,    -1,    -1,  2892,    -1,    -1,    -1,  2896,
      -1,  2898,    -1,    -1,    -1,    -1,  1850,    -1,    -1,   777,
    2907,    -1,   780,  2910,   782,  2912,    -1,    -1,   368,    -1,
      -1,    -1,    -1,  2920,  2921,  2922,  2923,    -1,    -1,    -1,
    2927,    -1,    -1,  2930,    -1,    -1,    -1,   805,    -1,    -1,
      -1,    -1,    -1,  2940,   368,    -1,    -1,    -1,    -1,    -1,
     818,    -1,    -1,    -1,   822,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   839,    -1,   841,    -1,    -1,    -1,    -1,    -1,    -1,
     877,    -1,    -1,    -1,    -1,   853,    -1,   884,    -1,   886,
      -1,   888,    -1,    -1,    -1,    -1,   864,   894,   895,    -1,
     868,    -1,   870,   453,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,    -1,    -1,   896,   453,
     898,    -1,    -1,    -1,    -1,    -1,   904,    -1,    -1,    -1,
      -1,  3038,   466,   467,   468,    -1,   470,   471,   472,   473,
     474,   475,    -1,    -1,    -1,    -1,  2718,   925,    -1,   927,
      -1,    -1,    -1,    -1,    -1,  2727,    -1,  2561,  2562,    -1,
    2564,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2577,  2746,  2579,    -1,    -1,   956,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2766,    -1,  2050,    -1,  2770,    -1,
    2054,  2055,    -1,    -1,  2608,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1021,    -1,    -1,    -1,    -1,  3126,
      -1,  2793,    -1,  2795,    -1,    -1,    -1,    -1,  2800,    -1,
    3137,    -1,  1039,    -1,    -1,    -1,    -1,  2809,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2657,    -1,    72,    -1,  2829,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1047,
      87,    -1,  1050,    90,  2678,  1053,    -1,    -1,    95,    -1,
      -1,  3188,    -1,   100,    -1,    -1,  3193,    -1,    -1,  3196,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2155,    -1,    -1,  2708,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2723,
      -1,    -1,  2176,    -1,    -1,    -1,  1104,  3234,    -1,    -1,
      -1,    -1,  2736,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2750,    -1,    -1,    -1,
      -1,  1129,    -1,    -1,    -1,    -1,    -1,  1135,    -1,    -1,
      -1,  1139,    -1,  3270,    -1,  2937,  2938,    -1,  1146,    -1,
    3277,  3278,    -1,    -1,    -1,    -1,    -1,  3284,  3285,    -1,
      -1,  2785,  3289,  3290,    -1,    -1,    -1,  2791,  3295,  3296,
      -1,    -1,  3299,    -1,    -1,  1173,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,    -1,   203,    -1,
    1217,  1218,    -1,  1220,    -1,   210,    -1,   212,    -1,    -1,
      -1,    -1,    -1,   240,   241,    -1,    -1,    -1,    -1,    -1,
    3337,    72,    -1,    -1,    -1,    -1,   253,    -1,  2842,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,    -1,    90,
      -1,    -1,    -1,    -1,    95,    -1,  2860,    -1,    -1,   100,
    1238,    72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   286,
      -1,    -1,   289,    -1,  1252,    -1,    87,  2331,    -1,    -1,
      -1,    -1,    -1,  2887,    95,    -1,   303,    -1,   305,   100,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3404,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2920,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3109,  3445,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   368,    -1,  3460,    -1,    -1,    -1,  3464,    -1,    -1,
    3132,    -1,  3469,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3142,    -1,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,  1389,    -1,  3491,    -1,  1393,  1394,  3495,    -1,
     201,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,
     241,    -1,    -1,    -1,    -1,   216,    -1,  3514,  3515,   220,
      -1,  3518,   253,    -1,    -1,    -1,  3188,    -1,  3525,  3526,
      -1,  3193,    -1,    -1,  3196,    -1,    -1,    -1,    -1,   240,
     241,    -1,    -1,    -1,  3038,    -1,   453,    -1,  3545,  1446,
      -1,    -1,   253,    -1,    -1,   286,    -1,    -1,   289,   466,
     467,   468,  3559,   470,   471,   472,   473,   474,   475,    -1,
      -1,    -1,   303,    -1,   305,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   286,    -1,  3584,   289,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   303,  1500,   305,    -1,  1474,    -1,    -1,  1506,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2561,  2562,    -1,
    2564,  1145,    -1,  3620,  3621,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2577,    -1,  2579,    -1,   368,    -1,  3301,
    3302,  3303,  3304,  3137,    -1,    -1,    -1,    -1,    -1,    -1,
    3647,  3648,    -1,  3650,    -1,  3652,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2608,    -1,    -1,   368,    -1,    -1,
      -1,    -1,    -1,    -1,  3671,    -1,    -1,    -1,  3675,  3676,
      -1,    -1,    -1,    -1,    -1,  1582,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2657,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   453,  3720,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1255,    -1,    -1,  2678,   466,   467,   468,    -1,   470,
     471,   472,   473,   474,   475,  3742,    -1,    -1,    -1,    -1,
      -1,    -1,   453,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2708,   466,   467,   468,    -1,   470,
     471,   472,   473,   474,   475,    -1,    -1,  1674,    -1,  2723,
      -1,  1649,    -1,  3445,  3781,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2736,    -1,    -1,    -1,  3290,    -1,    -1,  3796,
      -1,    -1,  3464,    -1,    -1,    -1,  2750,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1719,    -1,  1692,    -1,  1723,    -1,    -1,    -1,
      -1,    -1,    -1,  1701,    -1,  1703,    -1,    -1,  3835,  3836,
    1708,  2785,    -1,  3337,    -1,    -1,    -1,  2791,    -1,  1746,
      -1,    -1,  3849,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1730,  1731,  3861,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   767,  3545,    -1,    -1,   771,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    -1,  2842,    -1,
    1797,  1798,    -1,    -1,    -1,    -1,    -1,    -1,  1805,    -1,
      87,    -1,  1809,  1810,    -1,    -1,  2860,    -1,    95,   804,
      -1,    -1,  3584,   100,  3586,    -1,    -1,  1824,    -1,  1826,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2887,    -1,  3607,    -1,    -1,    -1,  1846,
      -1,  1848,    -1,    -1,    -1,    -1,    -1,  1481,  3620,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3628,   852,    -1,    -1,
      -1,    -1,   137,   858,    -1,  3469,  2920,    -1,    -1,    -1,
      -1,    72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1515,    -1,    -1,    -1,    -1,    87,    -1,  1895,    -1,
      -1,    -1,    -1,    -1,    95,  1529,  3668,    -1,    -1,   100,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   183,  1887,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,   216,
      -1,   206,    -1,   220,   209,    -1,   211,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1580,    -1,  3720,    -1,
      -1,    -1,    -1,   240,   241,    -1,    -1,    -1,    -1,   954,
      -1,   236,    -1,  1597,   959,    -1,   253,   962,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   254,
    1614,    -1,    -1,    -1,  3038,    -1,  1993,    -1,    -1,    -1,
     985,    -1,    -1,    -1,  2001,    -1,  2003,    -1,  2005,   286,
      -1,    -1,   289,    -1,    -1,  1639,    -1,    -1,    -1,  3781,
      -1,    -1,    -1,    -1,    -1,   216,   303,    -1,   305,   220,
      -1,    -1,  2000,   298,  3796,    -1,    -1,    -1,    -1,    -1,
      -1,   306,    -1,    -1,    -1,  2013,    -1,    -1,    -1,   240,
     241,    -1,    -1,  2021,    -1,    -1,    -1,    -1,    -1,  2027,
      -1,    -1,   253,  1687,  2032,    -1,    -1,    -1,    -1,    -1,
    2038,    -1,    -1,  3835,  1698,  2043,    -1,  3671,    -1,   344,
      -1,  3675,  3676,    -1,    -1,    -1,    -1,  3849,    -1,    -1,
      -1,   368,  2089,  3137,  2062,   286,  2064,    -1,   289,  3861,
      -1,  2098,    -1,    -1,  2101,  2102,    -1,    -1,    -1,    -1,
      -1,    -1,   303,    -1,   305,    -1,   393,    -1,    -1,    -1,
      -1,    -1,   387,    -1,    -1,    -1,  1111,  2095,  2096,  2097,
      -1,    -1,    -1,  1118,    -1,    -1,    -1,    -1,    -1,  1124,
      -1,    -1,    -1,   408,  2112,  2113,  2114,  2115,  3742,    -1,
      -1,  2119,  2120,    -1,    -1,  2123,  2124,  2125,    -1,    -1,
    1145,  2129,    -1,   428,    -1,    -1,    -1,    -1,  2136,    -1,
      -1,  2139,    -1,    -1,    -1,    -1,   453,   368,    -1,    -1,
      -1,  2178,    -1,   448,   449,   450,  2183,  1172,    -1,   466,
     467,   468,    -1,   470,   471,   472,   473,   474,   475,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   477,    -1,    -1,   480,   481,   482,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1850,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1228,    -1,    -1,  3290,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   453,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1255,    -1,    -1,    -1,    -1,   466,   467,   468,    -1,   470,
     471,   472,   473,   474,   475,    -1,    -1,    -1,    -1,    -1,
      -1,  1276,    -1,  3337,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1302,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2297,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1332,  1333,    -1,
    1335,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1352,    -1,  2337,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,  3469,  2050,    -1,    -1,    -1,
    2054,  2055,    -1,    -1,    -1,    -1,  1421,    -1,    -1,  1424,
    1425,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,    -1,  2481,    -1,  2483,    -1,  2485,    -1,
      -1,    -1,    -1,    -1,   161,    -1,  1481,    -1,    -1,    -1,
     131,    -1,    -1,   134,  1489,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   181,    -1,   183,    -1,    -1,    -1,
     151,    -1,    -1,  1508,    -1,    -1,   157,    -1,    -1,    -1,
    1515,  2155,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   172,    -1,    -1,  1529,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2176,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2531,  2532,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   203,    -1,   205,    -1,    -1,    -1,   209,    -1,
      -1,    -1,    -1,    -1,  2581,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   223,    -1,    -1,  1580,    -1,    -1,    -1,    -1,
      -1,  2598,    -1,    -1,    -1,    -1,    -1,    -1,  2605,  2606,
      -1,    -1,  1597,    -1,    -1,   246,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   257,  3671,    -1,  1614,
      -1,  3675,  3676,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2617,
    2618,  2619,  2620,    -1,  1639,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   303,    -1,   305,    -1,    -1,    -1,    -1,    -1,
      -1,  2678,    -1,  2651,    -1,    -1,  2683,    -1,  2685,    -1,
      -1,    -1,    -1,    -1,    -1,   326,    -1,  1682,  3742,  1684,
    2697,    -1,  1687,    -1,  1689,    -1,    -1,  2331,    -1,    -1,
      -1,  2708,    -1,  1698,    -1,    -1,    -1,   348,    -1,    -1,
      -1,   352,    -1,   354,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2699,  2700,  2701,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1145,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2724,   388,   389,    -1,
     391,   392,    -1,    -1,    -1,    -1,  1751,    -1,    -1,   400,
      -1,    -1,    -1,   404,   405,    -1,  2744,    -1,   409,    -1,
      -1,    -1,    -1,   414,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2759,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1785,  1786,    -1,    -1,    -1,    -1,    -1,    -1,  1793,    -1,
      -1,  1796,    -1,    -1,  1799,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1807,  1808,    -1,    -1,    -1,    -1,    -1,    -1,
    1815,    -1,    -1,  1818,  1819,  1820,  1821,    -1,    -1,    -1,
      -1,    -1,    -1,  1828,  1829,    -1,  1831,    -1,  1833,    -1,
      -1,  1836,    -1,    -1,  1255,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1850,  1851,    -1,    -1,    -1,
    1855,    -1,    -1,    -1,  1859,    -1,    -1,    -1,  1863,    -1,
      -1,  1866,  1867,  1868,  1869,  1870,  1871,  1872,  1873,  1874,
      -1,  1876,    -1,    -1,    -1,    -1,  1881,    -1,    -1,    -1,
    1885,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2561,  2562,    -1,
    2564,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2577,    -1,  2579,    -1,    -1,    -1,    -1,
      -1,  1946,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2608,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2990,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2657,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2030,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2678,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2050,    -1,    -1,    -1,  2054,
    2055,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3046,    -1,
    1481,    -1,    -1,  3051,  2708,  3053,  3054,  3055,  3056,    -1,
      -1,    -1,    -1,  3090,    -1,    -1,    -1,    -1,    -1,  2723,
    3097,    -1,    -1,    -1,    -1,  3102,  3103,  3104,  3105,  3106,
      -1,    -1,  2736,  3110,  1515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2750,    -1,  1529,    -1,
      -1,    -1,   799,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3125,    -1,    -1,
      -1,  2785,    -1,  2148,    -1,    -1,    -1,  2791,    -1,    -1,
    2155,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1580,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2174,
    1145,  2176,    -1,    -1,    -1,    -1,  1597,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1614,    -1,    -1,    -1,   884,  2842,   886,
      -1,   888,    -1,    -1,    -1,    -1,    -1,   894,   895,    -1,
      -1,    -1,    -1,  3201,    -1,    -1,  2860,    -1,  1639,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   922,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2887,  2249,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2259,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   949,    -1,    -1,    -1,  1687,    -1,    -1,    -1,
      -1,    -1,    -1,   960,   961,    -1,  2920,  1698,    -1,    -1,
    1255,    -1,    -1,    -1,    -1,    -1,  2291,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3314,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3323,    -1,  3325,    -1,
      -1,    -1,    -1,    -1,    -1,  2320,    -1,    -1,  3335,  3336,
      -1,    -1,    -1,  3340,  3341,    -1,  2331,    -1,    -1,    -1,
      -1,    -1,    -1,  3350,  1021,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2348,  2349,    -1,  3334,    -1,  1035,  1036,
      -1,    -1,  1039,    -1,    -1,    -1,    -1,  3345,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2378,    -1,    -1,    -1,  2382,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2394,
    2395,  2396,  2397,    -1,  3038,    -1,    -1,    -1,    -1,    -1,
      -1,  2406,    -1,    -1,    -1,    -1,  2411,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2421,  2422,    -1,  2424,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1850,
      -1,    -1,  2437,    -1,  2439,    -1,    -1,    -1,  2443,    -1,
      -1,    -1,    -1,    -1,  3432,    -1,    -1,    -1,    -1,    -1,
      -1,  3439,    -1,    -1,  2459,  1142,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2470,    -1,  2472,  2473,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2493,    -1,
      -1,    -1,    -1,  3137,  2499,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2508,  2509,  2510,  1481,    -1,    -1,    -1,
      -1,    -1,  3529,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1213,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2540,    -1,    -1,    -1,    -1,
    1515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1529,    -1,  2561,  2562,    -1,  2564,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2577,    -1,  2579,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2608,    -1,  1580,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1597,    -1,    -1,    -1,    -1,    -1,    -1,  2050,
      -1,    -1,    -1,  2054,  2055,    -1,    -1,    -1,    -1,  1614,
      -1,    -1,    -1,    -1,    -1,    -1,  3290,    -1,    -1,    -1,
    1337,    -1,  2657,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1347,    -1,    -1,    -1,  1639,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2678,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3337,    -1,    -1,    -1,    -1,    -1,  1386,
      -1,    -1,  1389,  2708,    -1,    -1,  1393,  1394,    -1,    -1,
      -1,    -1,  1687,  3701,    -1,    -1,    -1,    -1,  2723,    -1,
      -1,    -1,    -1,  1698,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2736,    -1,    -1,  2155,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2750,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2176,    -1,    -1,    -1,    -1,
      -1,  2766,    -1,    -1,    -1,  2770,    -1,    -1,  1455,    -1,
      -1,    -1,  3760,    -1,    -1,  2780,    -1,    -1,    -1,    -1,
    2785,    -1,    -1,    -1,    -1,    -1,  2791,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2809,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1500,    -1,    -1,    -1,    -1,    -1,  1506,
      -1,    -1,    -1,    -1,    -1,  3469,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2839,    -1,    -1,  2842,    -1,    -1,
      -1,    -1,    -1,  2848,    -1,    -1,    -1,    -1,    -1,  2854,
      -1,  2856,    -1,    -1,    -1,  2860,  2861,    -1,    -1,  2864,
    2865,  2866,  2867,  2868,  2869,  2870,  2871,  2872,  2873,    -1,
      -1,    -1,    -1,  2878,  2879,  1850,    -1,    -1,    -1,    -1,
      -1,    -1,  2887,    -1,    -1,    -1,    -1,  2892,    -1,    -1,
      -1,    -1,    -1,  2898,    -1,  1582,    -1,    -1,    -1,    -1,
      -1,    -1,  2907,    -1,    -1,  2910,    -1,  2912,    -1,    -1,
    2331,    -1,    -1,    -1,    -1,  2920,  2921,  2922,  2923,    -1,
      -1,    -1,  2927,    -1,    -1,  2930,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2940,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1665,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1674,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3671,    -1,    -1,
      -1,  3675,  3676,  3038,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2050,    -1,    -1,    -1,  2054,
    2055,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3742,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1797,  1798,    -1,    -1,    -1,    -1,    -1,  1804,  1805,    -1,
      -1,  3126,  1809,  1810,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3137,    -1,    -1,    -1,    -1,  1824,    -1,  1826,
    2561,  2562,    -1,  2564,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2577,    -1,  2579,  1846,
      -1,  1848,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   767,    -1,    -1,    -1,   771,
    2155,    -1,    -1,  3188,    -1,    -1,    -1,  2608,  3193,    -1,
      -1,  3196,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2176,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   804,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1911,    -1,    -1,    -1,    -1,  3234,
      -1,    -1,    -1,    -1,    -1,    -1,  2657,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2678,    -1,    -1,
     852,    -1,    -1,    -1,    -1,  3270,   858,    -1,    -1,    -1,
      -1,    -1,  3277,  3278,    -1,    -1,    -1,    -1,    -1,  3284,
    3285,    -1,    -1,    -1,  3289,  3290,    -1,  2708,    -1,    -1,
    3295,  3296,    -1,    -1,  3299,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2723,    -1,    -1,    -1,  1993,    -1,    -1,    -1,
    1997,    -1,    -1,    -1,  2001,  2736,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2750,
      -1,    -1,  3337,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2331,    -1,    -1,    -1,
      -1,    -1,   954,    -1,  2785,    -1,    -1,    -1,    -1,    -1,
    2791,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   985,    -1,    -1,    -1,    -1,    -1,  3404,
      -1,    -1,  2089,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2098,    -1,    -1,  2101,  2102,    -1,    -1,    -1,    -1,
      -1,  2842,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2860,
    3445,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3460,    -1,    -1,    -1,  3464,
      -1,    -1,    -1,    -1,  3469,    -1,  2887,    -1,    -1,  2156,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2164,    -1,    -1,
      -1,  2168,    -1,    -1,    -1,    -1,  3491,    -1,    -1,    -1,
    3495,  2178,    -1,    -1,    -1,    -1,  2183,    -1,    -1,  2920,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3514,
    3515,    -1,    -1,  3518,    -1,    -1,    -1,    -1,    -1,  1111,
    3525,  3526,    -1,    -1,    -1,    -1,  1118,    -1,    -1,    -1,
      -1,    -1,  1124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3545,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2237,    -1,    -1,  1145,  3559,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3584,
    1172,    -1,    -1,    -1,    -1,    -1,  2561,  2562,    -1,  2564,
      -1,    -1,    -1,    -1,    -1,    -1,  2283,    -1,    -1,    -1,
      -1,    -1,  2577,    -1,  2579,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3620,  3621,  3038,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2608,    -1,    -1,  1228,    -1,    -1,    -1,
      -1,    -1,  3647,  3648,    -1,  3650,    -1,  3652,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1255,    -1,    -1,  3671,    -1,    -1,    -1,
    3675,  3676,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2657,    -1,  1276,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2678,    -1,    -1,    -1,    -1,    -1,    -1,
    1302,    -1,    -1,    -1,    -1,  3720,  3137,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2708,    -1,    -1,    -1,  3742,    -1,    -1,
    1332,  1333,    -1,  1335,    -1,    -1,    -1,    -1,  2723,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1352,  2736,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2750,  3781,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3796,    -1,    -1,    -1,    -1,  2483,    -1,  2485,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2785,    -1,    -1,    -1,    -1,    -1,  2791,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1421,
    3835,  3836,  1424,  1425,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3849,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3861,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2842,    -1,  3290,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2860,    -1,    -1,    -1,  1481,
      -1,    -1,    -1,    -1,  2581,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2598,  2887,    -1,    -1,    -1,  3337,    -1,  2605,  2606,
      -1,    -1,    -1,  1515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1529,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2920,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2656,
      -1,  2658,  2659,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2672,    -1,    -1,  1580,    -1,
      -1,  2678,    -1,    -1,    -1,    -1,  2683,    -1,  2685,    -1,
      -1,    -1,    -1,    -1,  1145,  1597,    -1,    -1,    -1,    -1,
    2697,  2698,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2708,  1614,    -1,  1145,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2720,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1639,  3469,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2748,  2749,  3038,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1682,    -1,  1684,    -1,    -1,  1687,    -1,  1689,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1698,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1255,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1255,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1751,
      -1,    -1,  3137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1785,  1786,    -1,    -1,    -1,    -1,    -1,
      -1,  1793,    -1,    -1,  1796,    -1,    -1,  1799,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1807,  1808,    -1,    -1,  2906,
      -1,    -1,    -1,  1815,    -1,    -1,  1818,  1819,  1820,  1821,
      -1,    -1,    -1,    -1,    -1,    -1,  1828,  1829,    -1,  1831,
      -1,  1833,    -1,    -1,  1836,    -1,    -1,    -1,    -1,    -1,
    3671,    -1,    -1,    -1,  3675,  3676,    -1,    -1,  1850,  1851,
      -1,    -1,    -1,  1855,    -1,    -1,    -1,  1859,    -1,    -1,
      -1,  1863,    -1,    -1,  1866,  1867,  1868,  1869,  1870,  1871,
    1872,  1873,  1874,    -1,  1876,    -1,    -1,    -1,    -1,  1881,
      -1,    -1,    -1,  1885,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3290,    -1,    -1,    -1,    -1,
      -1,  3742,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1481,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1946,    -1,    -1,    -1,    -1,    -1,
    1481,    -1,  3337,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1515,    -1,    -1,    -1,    -1,    -1,
    3067,  3068,  3069,  3070,  3071,  3072,    -1,    -1,  1529,    -1,
      -1,    -1,    -1,    -1,  1515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1529,    -1,
    3097,    -1,    -1,    -1,    -1,  3102,  3103,  3104,  3105,  3106,
      -1,    -1,    -1,  3110,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2030,  1580,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1597,    -1,  2050,  1580,
      -1,    -1,  2054,  2055,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1614,    -1,    -1,  1597,    -1,    -1,    -1,
      -1,  3168,    -1,    -1,    -1,   954,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1614,  3469,    -1,    -1,    -1,  1639,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   985,    -1,  1639,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1687,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2148,  1698,    -1,    -1,
      -1,    -1,    -1,  2155,    -1,    -1,  1687,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1698,    -1,    -1,
      -1,    -1,  2174,    -1,  2176,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3315,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3325,    -1,
      -1,    -1,  1111,    -1,    -1,    -1,    -1,    -1,  3335,  3336,
      -1,    -1,    -1,  3340,  3341,    -1,    -1,  2249,    -1,    -1,
      -1,    -1,    -1,  3350,    -1,    -1,    -1,  2259,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3367,  3368,  3369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3377,  3378,    -1,    -1,    -1,  3382,  3671,    -1,    -1,  2291,
    3675,  3676,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1850,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2320,  1850,
      -1,    -1,    -1,    -1,  3421,    -1,    -1,    -1,    -1,  2331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2348,  2349,    -1,  3446,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3742,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2378,    -1,    -1,    -1,
    2382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2394,  2395,  2396,  2397,    -1,  1276,    -1,    -1,
      -1,    -1,    -1,    -1,  2406,    -1,    -1,    -1,    -1,  2411,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2421,
    2422,    -1,  2424,  1302,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2437,    -1,  2439,    -1,    -1,
      -1,  2443,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1332,  1333,    -1,  1335,  2459,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2470,  3566,
    2472,  2473,    -1,  1352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2493,    -1,    -1,    -1,    -1,    -1,  2499,    -1,  2050,
      -1,    -1,    -1,  2054,  2055,    -1,  2508,  2509,  2510,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2050,
    3617,    -1,    -1,  2054,  2055,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2540,    -1,
      -1,    -1,  1421,    -1,    -1,  1424,  1425,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2561,
    2562,    -1,  2564,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2577,    -1,  2579,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2155,    -1,  2608,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2155,  2176,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2176,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2657,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2678,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2708,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1348,    -1,
      -1,  2723,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2736,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2750,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2766,    -1,    -1,    -1,  2770,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2780,    -1,
    2331,  1411,    -1,  2785,    -1,    -1,    -1,    -1,    -1,  2791,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2331,    -1,    -1,    -1,    -1,    -1,    -1,  2809,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2839,    -1,    -1,
    2842,    -1,    -1,    -1,    -1,    -1,  2848,    -1,    -1,    -1,
      -1,    -1,  2854,    -1,  2856,    -1,    -1,    -1,  2860,  2861,
      -1,    -1,  2864,  2865,  2866,  2867,  2868,  2869,  2870,  2871,
    2872,  2873,    -1,    -1,    -1,    -1,  2878,  2879,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2887,    -1,    -1,    -1,    -1,
    2892,    -1,    -1,    -1,    -1,    -1,  2898,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2907,    -1,    -1,  2910,    -1,
    2912,    -1,    -1,    -1,  1793,    -1,    -1,    -1,  2920,  2921,
    2922,  2923,    -1,    -1,    -1,  2927,    -1,    -1,  2930,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1815,    -1,  2940,  1818,
      -1,  1571,  1821,    -1,    -1,    -1,    -1,    -1,    -1,  1828,
    1829,    -1,    -1,    -1,  1833,    -1,    -1,  1836,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1851,    -1,    -1,    -1,  1855,    -1,    -1,    -1,
    1859,    -1,    -1,    -1,  1863,    -1,    -1,  1866,  1867,  1868,
    1869,  1870,  1871,  1872,  1873,  1874,    -1,  1876,    -1,    -1,
      -1,    -1,  1881,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2561,  2562,    -1,  2564,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2577,    -1,  2579,    -1,
    2561,  2562,    -1,  2564,    -1,    -1,  3038,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2577,    -1,  2579,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2608,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1946,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2608,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1724,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2657,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3126,    -1,  2657,  2678,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3137,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2678,    -1,    -1,
      -1,  2030,    -1,    -1,    -1,    -1,    -1,  2708,    -1,    -1,
      -1,  1791,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2723,    -1,    -1,    -1,    -1,  2708,    -1,    -1,
      -1,    -1,    -1,    -1,  1814,  2736,  3188,    -1,    -1,  1819,
      -1,  3193,  2723,    -1,  3196,    -1,    -1,    -1,    -1,  2750,
      -1,    -1,    -1,    -1,    -1,  2736,    -1,    -1,  1838,  1839,
      -1,    -1,  1842,    -1,    -1,    -1,    -1,    -1,    -1,  2750,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3234,    -1,  2785,    -1,    -1,    -1,    -1,    -1,
    2791,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1879,
      -1,    -1,    -1,    -1,  2785,    -1,    -1,    -1,    -1,    -1,
    2791,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3270,  2148,
      -1,    -1,    -1,    -1,    -1,  3277,  3278,    -1,    -1,    -1,
      -1,    -1,  3284,  3285,    -1,    -1,    -1,  3289,  3290,    -1,
      -1,  2842,    -1,  3295,  3296,  2174,    -1,  3299,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2860,
      -1,  2842,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1955,    -1,    -1,    -1,  2860,
      -1,    -1,  1962,    -1,  1964,  3337,  2887,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2887,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2920,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2259,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2920,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3404,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2291,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2320,    -1,  3445,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3460,    -1,
      -1,    -1,  3464,    -1,    -1,    -1,    -1,  3469,    -1,    -1,
    2349,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3038,    -1,  3491,
      -1,    -1,    -1,  3495,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3038,    -1,    -1,
      -1,    -1,  3514,  3515,    -1,  2394,  3518,  2396,  2397,    -1,
      -1,    -1,    -1,  3525,  3526,    -1,    -1,  2406,    -1,    -1,
      -1,    -1,  2411,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3545,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3559,  2437,    -1,
    2439,    -1,    -1,    -1,  2443,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3584,    -1,    -1,    -1,  3137,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3137,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2493,    -1,    -1,    -1,  3620,  3621,
    2499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2508,
    2509,  2510,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3647,  3648,    -1,  3650,    -1,
    3652,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2540,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3671,
      -1,    -1,    -1,  3675,  3676,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3720,    -1,
      -1,    -1,  2352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3290,
    3742,    -1,    -1,    -1,  2374,    -1,  2376,    -1,  2378,  2379,
      -1,    -1,  2382,    -1,    -1,    -1,  2386,    -1,    -1,  3290,
      -1,    -1,    -1,  2393,    -1,    -1,    -1,    -1,  2398,    -1,
      -1,    -1,    -1,  2403,    -1,    -1,    -1,    -1,  2408,  3781,
      -1,    -1,    -1,    -1,    -1,    -1,  3337,  2417,    -1,    -1,
      -1,  2421,  2422,  2423,  3796,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2435,  3337,    -1,    -1,    -1,
      -1,    -1,  2442,    -1,  2444,  2445,  2446,  2447,  2448,  2449,
    2450,  2451,  2452,  2453,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3835,  3836,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3849,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3861,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2547,  3469,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3469,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2839,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2848,
      -1,    -1,    -1,    -1,    -1,  2854,    -1,  2856,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2878,
    2879,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2898,
      -1,    -1,    -1,    -1,    -1,  2655,    -1,    -1,  2907,    -1,
      -1,  2910,    -1,  2912,    -1,    -1,    -1,     5,    -1,    -1,
      -1,    -1,  2921,    -1,    -1,    -1,    -1,    -1,  2927,  2679,
      -1,  2930,    -1,    -1,    -1,    -1,    -1,    -1,    26,    -1,
      -1,  2940,    -1,    -1,    -1,    -1,    -1,    -1,    36,    37,
      -1,    -1,    -1,    -1,    42,    -1,    44,    45,    -1,    -1,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3671,    -1,    -1,    -1,  3675,  3676,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3671,    -1,    -1,    -1,  3675,  3676,   114,    -1,    -1,    -1,
      -1,    -1,  2782,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2799,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3742,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2838,    -1,
      -1,  3742,    -1,   181,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   195,    -1,  2859,
      -1,  2861,    -1,    -1,  2864,  2865,  2866,  2867,  2868,  2869,
    2870,  2871,  2872,  2873,    -1,  2875,   214,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   234,    -1,    -1,  2899,
      -1,    -1,    -1,  2903,    -1,    -1,    -1,    -1,  2908,  2909,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2922,  2923,  2924,    -1,  2926,    -1,   266,  2929,
      -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   291,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3002,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   357,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3277,  3278,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3289,    -1,    -1,    -1,    -1,    -1,  3295,  3296,    -1,    -1,
    3299,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   396,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   421,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   443,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   451,   452,    -1,   454,    -1,   456,    -1,
      -1,    -1,   460,   461,   462,   463,  3126,   465,   466,    -1,
      -1,    -1,   470,   471,   472,   473,   474,    -1,     5,   477,
     478,   479,   480,    -1,   482,   483,   484,    -1,   486,   487,
      -1,    -1,    -1,    -1,    -1,  3404,    -1,    -1,    -1,    26,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    36,
      37,    -1,    -1,    -1,    -1,    -1,    -1,    44,    45,    -1,
      -1,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,
      -1,  3460,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3235,    -1,    -1,  3238,  3239,
    3240,    -1,    -1,  3243,    -1,    -1,    -1,   114,  3248,  3249,
    3250,  3251,  3252,  3253,  3254,  3255,  3256,  3257,  3258,  3259,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3518,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3526,    -1,    -1,
      -1,    -1,    -1,  3283,  3284,  3285,  3286,    -1,  3288,    -1,
      -1,    -1,  3292,  3293,  3294,    -1,    -1,  3297,    -1,    -1,
    3300,    -1,    -1,    -1,    -1,    -1,    -1,  3307,    -1,    -1,
    3559,    -1,    -1,    -1,   181,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   195,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   214,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   234,    -1,    -1,
      -1,    -1,  3621,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   266,
      -1,  3650,   269,    -1,    -1,    -1,  3406,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   291,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3487,    -1,    -1,
     357,  3491,    -1,    -1,    -1,  3495,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3503,    -1,  3505,    -1,    -1,    -1,  3509,
    3510,  3511,    -1,    -1,  3514,  3515,  3516,  3517,    -1,  3519,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   396,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   421,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   443,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   451,   452,    -1,   454,  3588,    -1,
      -1,    -1,    -1,   460,   461,   462,   463,    -1,   465,   466,
      -1,    -1,    -1,   470,   471,   472,   473,   474,    -1,    -1,
     477,   478,   479,    -1,    -1,    -1,   483,    -1,    -1,    -1,
     487,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3632,    -1,    -1,    -1,     5,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3646,  3647,  3648,  3649,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    26,    -1,  3659,
    3660,  3661,    -1,  3663,    -1,    -1,    -1,    36,    37,    -1,
      -1,    -1,    -1,    -1,    -1,    44,    45,    -1,  3678,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    -1,     5,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3718,    -1,
      -1,    -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,    -1,
    3730,  3731,    -1,    -1,    -1,    36,    37,    -1,    -1,    -1,
      -1,    -1,    -1,    44,    45,   114,    -1,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   181,   114,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   195,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   214,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     181,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   195,    -1,    -1,   266,    -1,    -1,
     269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   214,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   291,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   266,    -1,    -1,   269,    -1,
      -1,    -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    36,    37,    -1,   357,    -1,
     291,    -1,    -1,    44,    45,    -1,    -1,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    -1,    -1,    -1,    -1,    -1,    -1,   396,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   408,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   421,    -1,    -1,    -1,   357,    -1,    -1,    -1,
      -1,    -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   443,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   451,   452,    -1,   454,    -1,    -1,    -1,    -1,
      -1,   460,   461,   462,   463,   396,   465,   466,    -1,    -1,
      -1,   470,   471,   472,   473,   474,    -1,   408,   477,   478,
     479,   480,    -1,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     421,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     181,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   443,    -1,   195,    -1,    -1,    -1,    -1,    -1,
     451,   452,    -1,   454,    -1,    -1,    -1,    -1,    -1,   460,
     461,   462,   463,   214,   465,   466,    -1,    -1,    -1,   470,
     471,   472,   473,   474,    -1,    -1,   477,   478,   479,   480,
      -1,    -1,    -1,   234,    -1,    -1,   487,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   266,    -1,    -1,   269,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     291,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   357,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   396,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   408,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     421,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   443,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     451,   452,    -1,   454,    -1,    -1,    -1,    -1,    -1,   460,
     461,   462,   463,    -1,   465,   466,    -1,    -1,    -1,   470,
     471,   472,   473,   474,    -1,    -1,   477,   478,   479,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   487,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,    -1,   105,   106,   107,
      -1,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   180,    -1,   182,   183,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,   197,
     198,   199,   200,   201,   202,   203,    -1,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,    -1,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
      -1,    -1,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,    -1,   317,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,   417,
     418,   419,    -1,   421,   422,   423,   424,   425,   426,   427,
     428,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,    -1,    -1,
      -1,    -1,    -1,   451,    -1,    -1,   454,    -1,    -1,    -1,
       6,     7,     8,    -1,    10,    11,    12,    13,    14,    -1,
      -1,    -1,    18,    -1,    20,    21,    22,    23,    24,    25,
      -1,    27,    28,    -1,    -1,   483,    32,    33,    34,    35,
      -1,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    -1,    -1,    -1,   100,   101,   102,   103,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,
      -1,    -1,    -1,    -1,    -1,    -1,   122,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   154,   155,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   181,    -1,    -1,    -1,    -1,
      -1,   187,    -1,    -1,   190,    -1,    -1,    -1,    -1,   195,
      -1,    -1,    -1,    -1,   200,    -1,   202,    -1,    -1,    -1,
      -1,    -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     216,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   228,   229,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,   240,   241,    -1,   243,    -1,    -1,
      -1,    -1,    -1,    -1,   250,   251,    -1,   253,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   284,    -1,
      -1,    -1,    -1,   289,    -1,    -1,   292,    -1,   294,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   307,   308,   309,   310,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   318,   319,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   330,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   347,    -1,    -1,   350,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   365,
      -1,    -1,   368,    -1,   370,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   382,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   394,   395,
      -1,    -1,    -1,   399,    -1,   401,    -1,    -1,    -1,    -1,
      -1,    -1,   408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   421,    -1,   423,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   435,
     436,   437,   438,   439,   440,   441,   442,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   451,    -1,    -1,   454,    -1,
      -1,    -1,    -1,     6,     7,     8,    -1,    10,    11,    12,
      13,    14,    -1,    -1,    -1,    18,    -1,    20,    21,    22,
      23,    24,    25,    -1,    27,    28,    -1,    -1,   484,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    -1,    -1,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    -1,    -1,    -1,   100,   101,   102,
     103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,    -1,   122,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   141,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   154,   155,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,
      -1,    -1,    -1,    -1,   187,    -1,    -1,   190,    -1,    -1,
      -1,    -1,   195,    -1,    -1,    -1,    -1,   200,    -1,   202,
      -1,    -1,    -1,    -1,    -1,   208,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   216,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   228,   229,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,   240,   241,    -1,
     243,    -1,    -1,    -1,    -1,    -1,    -1,   250,   251,    -1,
     253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   284,    -1,    -1,    -1,    -1,   289,    -1,    -1,   292,
      -1,   294,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   307,   308,   309,   310,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   318,   319,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   330,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   347,    -1,    -1,   350,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   365,    -1,    -1,   368,    -1,   370,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   382,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   394,   395,    -1,    -1,    -1,   399,    -1,   401,    -1,
      -1,    -1,    -1,    -1,    -1,   408,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   421,    -1,
     423,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   435,   436,   437,   438,   439,   440,   441,   442,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   451,    -1,
      -1,   454,    -1,     3,    -1,    -1,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    -1,    27,    28,    29,
      -1,   484,    32,    33,    34,    35,    -1,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    85,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    -1,    99,
     100,   101,   102,   103,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,   118,    -1,
     120,   121,   122,    -1,    -1,   125,   126,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   135,    -1,   137,    -1,    -1,
      -1,   141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   151,    -1,   153,   154,   155,   156,    -1,    -1,    -1,
      -1,    -1,   162,    -1,    -1,    -1,    -1,    -1,   168,    -1,
      -1,    -1,    -1,    -1,   174,    -1,    -1,    -1,    -1,    -1,
     180,   181,    -1,    -1,    -1,    -1,   186,   187,   188,    -1,
     190,    -1,    -1,   193,    -1,   195,    -1,    -1,    -1,    -1,
     200,    -1,   202,    -1,   204,    -1,   206,    -1,   208,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   216,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,    -1,   237,    -1,    -1,
     240,   241,    -1,   243,    -1,    -1,    -1,    -1,    -1,    -1,
     250,   251,    -1,   253,    -1,   255,   256,    -1,    -1,    -1,
      -1,   261,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     270,    -1,    -1,   273,   274,   275,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   284,    -1,    -1,    -1,   288,   289,
      -1,    -1,   292,    -1,   294,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   307,   308,   309,
     310,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   318,   319,
      -1,   321,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     330,   331,    -1,    -1,   334,    -1,   336,    -1,    -1,    -1,
      -1,   341,    -1,    -1,    -1,    -1,   346,   347,    -1,   349,
     350,    -1,    -1,   353,    -1,    -1,    -1,    -1,    -1,   359,
      -1,    -1,    -1,     3,   364,   365,    -1,   367,   368,     9,
     370,    -1,    -1,    -1,   374,    15,    -1,    17,    -1,    19,
      -1,    -1,   382,    -1,    -1,    -1,    -1,    -1,    -1,    29,
      -1,    -1,    -1,    -1,   394,   395,    -1,    -1,    -1,   399,
      -1,   401,    -1,   403,    -1,   405,    46,    47,   408,    -1,
      -1,   411,    -1,   413,    -1,    -1,   416,    -1,    -1,    -1,
     420,   421,    -1,   423,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    73,    -1,   435,   436,   437,   438,   439,
     440,   441,   442,    83,    -1,    85,    86,    -1,    -1,    -1,
      -1,   451,    -1,    -1,   454,    -1,    -1,    -1,    -1,    99,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,   479,
     120,   121,    -1,    -1,    -1,   125,   126,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   135,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,    -1,
      -1,    -1,   162,    -1,    -1,    -1,    -1,    -1,   168,    -1,
      -1,    -1,    -1,    -1,   174,    -1,    -1,    -1,    -1,    -1,
     180,    -1,    -1,    -1,    -1,    -1,   186,    -1,   188,    -1,
      -1,    -1,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   204,    -1,   206,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   255,   256,    -1,    -1,    -1,
      -1,   261,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     270,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   288,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   321,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   331,    -1,    -1,   334,    -1,   336,    -1,    -1,    -1,
      -1,   341,    -1,    -1,    -1,    -1,   346,    -1,    -1,   349,
      -1,    -1,    -1,   353,    -1,    -1,    -1,    -1,    -1,   359,
      -1,    -1,    -1,    -1,   364,    -1,    -1,   367,    -1,    -1,
      -1,    -1,    -1,    -1,   374,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   403,    -1,   405,    -1,    -1,    -1,    -1,
      -1,   411,    -1,   413,    -1,    -1,   416,    -1,    -1,    -1,
     420,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    -1,    17,    18,    -1,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    46,    47,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,   479,
      -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    -1,    -1,    -1,    89,    -1,    -1,    92,    93,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,    -1,   106,   107,    -1,   109,   110,   111,   112,   113,
     114,   115,   116,    -1,   118,   119,   120,   121,   122,    -1,
      -1,   125,   126,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,   136,    -1,   138,   139,   140,   141,   142,    -1,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,    -1,   158,    -1,   160,    -1,   162,   163,
     164,    -1,   166,   167,   168,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,   178,   179,    -1,    -1,   182,    -1,
     184,   185,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,    -1,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,   213,
     214,   215,   216,   217,   218,   219,    -1,   221,   222,   223,
     224,   225,   226,    -1,   228,   229,    -1,   231,   232,   233,
     234,   235,    -1,   237,    -1,    -1,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,   251,   252,   253,
      -1,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
     304,    -1,    -1,   307,   308,   309,   310,   311,   312,   313,
     314,   315,    -1,   317,   318,   319,   320,   321,   322,    -1,
     324,   325,   326,   327,   328,   329,   330,   331,   332,    -1,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
      -1,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,    -1,    -1,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,    -1,   372,   373,
     374,   375,   376,   377,   378,   379,   380,   381,   382,   383,
      -1,   385,   386,    -1,   388,   389,   390,   391,   392,    -1,
     394,   395,    -1,    -1,   398,   399,   400,   401,   402,   403,
     404,   405,   406,   407,    -1,   409,   410,   411,   412,   413,
     414,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,    -1,   429,   430,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
     444,   445,    -1,    -1,    -1,    -1,    -1,   451,   452,   453,
     454,   455,    -1,    -1,   458,   459,   460,   461,   462,   463,
     464,   465,    -1,    -1,    -1,    -1,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,    -1,   106,   107,
      -1,   109,   110,   111,   112,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,    -1,
     138,   139,   140,   141,   142,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,   167,
     168,    -1,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,    -1,    -1,   182,    -1,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,    -1,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,    -1,   210,    -1,   212,   213,   214,   215,   216,   217,
     218,   219,    -1,   221,   222,   223,   224,   225,   226,    -1,
     228,   229,    -1,   231,   232,   233,   234,   235,    -1,   237,
      -1,    -1,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,   304,    -1,    -1,   307,
     308,   309,   310,   311,   312,   313,   314,   315,    -1,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,    -1,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
      -1,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,    -1,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,    -1,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,   394,   395,    -1,    -1,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
      -1,   409,   410,   411,   412,   413,   414,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
      -1,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,    -1,    -1,
      -1,    -1,    -1,   451,   452,   453,   454,   455,    -1,    -1,
     458,   459,   460,   461,   462,   463,   464,   465,    -1,    -1,
      -1,    -1,   470,   471,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    -1,    17,    18,    -1,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,
      -1,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      92,    93,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,    -1,   106,   107,    -1,   109,   110,    -1,
      -1,   113,   114,   115,   116,    -1,   118,   119,   120,   121,
      -1,    -1,    -1,   125,   126,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,   136,    -1,   138,   139,   140,   141,
     142,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,   167,   168,    -1,    -1,   171,
     172,   173,   174,   175,    -1,   177,   178,   179,    -1,    -1,
     182,    -1,   184,   185,   186,    -1,   188,   189,    -1,    -1,
     192,   193,   194,   195,    -1,   197,    -1,   199,   200,    -1,
     202,   203,    -1,   205,    -1,   207,    -1,    -1,   210,    -1,
     212,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,   225,   226,    -1,   228,   229,    -1,   231,
     232,   233,   234,   235,    -1,   237,    -1,    -1,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,    -1,   251,
     252,   253,    -1,   255,   256,   257,    -1,    -1,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,    -1,   277,   278,   279,   280,   281,
     282,   283,    -1,   285,    -1,   287,   288,   289,   290,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,    -1,    -1,
      -1,   303,   304,    -1,    -1,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,    -1,   317,    -1,    -1,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,    -1,   345,   346,   347,   348,   349,    -1,   351,
     352,   353,   354,   355,   356,   357,    -1,    -1,   360,   361,
     362,    -1,   364,   365,   366,   367,   368,   369,   370,    -1,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,   394,   395,    -1,    -1,   398,    -1,   400,    -1,
      -1,   403,   404,   405,   406,   407,    -1,    -1,   410,   411,
     412,   413,    -1,    -1,   416,   417,   418,   419,    -1,   421,
     422,   423,   424,   425,   426,    -1,    -1,   429,   430,   431,
     432,   433,   434,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,
      -1,    -1,   454,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,    -1,    20,    21,    22,
      23,    24,    25,    -1,    27,    28,    29,    -1,   480,    32,
      33,    34,    35,    -1,    -1,    38,    39,    40,    41,    -1,
      43,    -1,    -1,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,
      93,    -1,    95,    -1,    97,    98,    99,    -1,   101,    -1,
     103,    -1,    -1,   106,   107,    -1,   109,   110,    -1,    -1,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,    -1,   138,   139,   140,    -1,   142,
      -1,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,   167,   168,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,    -1,    -1,   182,
      -1,   184,   185,   186,   187,   188,   189,   190,    -1,   192,
     193,   194,   195,    -1,   197,    -1,   199,    -1,    -1,    -1,
     203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,
     213,   214,   215,    -1,   217,   218,   219,    -1,   221,   222,
     223,   224,   225,   226,    -1,    -1,   229,    -1,   231,   232,
     233,    -1,   235,    -1,   237,    -1,    -1,    -1,    -1,   242,
      -1,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
      -1,    -1,   255,   256,   257,    -1,    -1,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,    -1,   275,    -1,   277,   278,   279,   280,   281,   282,
     283,   284,   285,    -1,   287,   288,    -1,   290,    -1,   292,
     293,   294,   295,   296,    -1,    -1,   299,    -1,    -1,    -1,
     303,   304,    -1,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,    -1,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,    -1,   345,   346,    -1,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,    -1,    -1,   360,   361,   362,
      -1,   364,   365,   366,   367,    -1,   369,   370,    -1,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,   394,   395,    -1,    -1,   398,   399,   400,   401,    -1,
     403,   404,   405,   406,   407,    -1,    -1,   410,   411,   412,
     413,    -1,   415,   416,   417,   418,   419,   420,   421,   422,
      -1,   424,   425,   426,    -1,    -1,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,    -1,
      -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   477,    -1,    -1,    -1,   481,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,   201,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,   397,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,    -1,   409,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,   455,
      -1,    -1,   458,   459,   460,   461,   462,   463,   464,   465,
      -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   479,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,    -1,   106,   107,    -1,   109,   110,
     111,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,    -1,   409,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,   452,   453,   454,   455,    -1,    -1,   458,   459,   460,
     461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,   470,
     471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,    -1,   409,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,   455,
      -1,    -1,   458,   459,   460,   461,   462,   463,   464,   465,
      -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   479,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,    -1,   106,   107,    -1,   109,   110,
     111,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,    -1,   409,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,   452,   453,   454,   455,    -1,    -1,   458,   459,   460,
     461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,   470,
     471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,    -1,   409,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,   455,
      -1,    -1,   458,   459,   460,   461,   462,   463,   464,   465,
      -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   479,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,    -1,   106,   107,    -1,   109,   110,
     111,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,    -1,   409,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,   452,   453,   454,   455,    -1,    -1,   458,   459,   460,
     461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,   470,
     471,    -1,    -1,    -1,    -1,    -1,   477,    -1,   479,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,    -1,   409,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,   455,
      -1,    -1,   458,   459,   460,   461,   462,   463,   464,   465,
      -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   479,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,    -1,   106,   107,    -1,   109,   110,
     111,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
     201,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,    -1,   409,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,   452,   453,   454,   455,    -1,    -1,   458,   459,   460,
     461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,   470,
     471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,    -1,   409,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,   455,
      -1,    -1,   458,   459,   460,   461,   462,   463,   464,   465,
      -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   479,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,    -1,   106,   107,    -1,   109,   110,
     111,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,    -1,   409,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,   452,   453,   454,   455,    -1,    -1,   458,   459,   460,
     461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,   470,
     471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,    -1,   409,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,   455,
      -1,    -1,   458,   459,   460,   461,   462,   463,   464,   465,
      -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   479,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,    -1,   106,   107,    -1,   109,   110,
     111,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,    -1,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,    -1,    -1,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,   452,   453,   454,   455,    -1,    -1,   458,   459,   460,
     461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,    -1,
     471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,    -1,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,    -1,    -1,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
      -1,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,    -1,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
      -1,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,    -1,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,   402,   403,   404,   405,
     406,   407,    -1,   409,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,   455,
      -1,    -1,   458,   459,   460,   461,   462,   463,   464,   465,
      -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   479,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,    -1,
     101,   102,   103,   104,    -1,   106,   107,    -1,   109,   110,
     111,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,    -1,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,    -1,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,    -1,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,   234,   235,    -1,   237,    -1,    -1,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,    -1,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,    -1,   304,    -1,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,    -1,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,    -1,    -1,   410,
     411,   412,   413,   414,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,   452,    -1,   454,   455,    -1,    -1,   458,   459,   460,
     461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,    -1,
     471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,    -1,    -1,
     106,   107,    -1,   109,   110,    -1,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,    -1,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,    -1,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
      -1,   287,   288,   289,   290,    -1,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,   302,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,    -1,   403,   404,   405,
     406,   407,    -1,    -1,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,    -1,    -1,   454,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,   479,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,    -1,    -1,
     106,   107,    -1,   109,   110,    -1,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,    -1,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,    -1,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
      -1,   287,   288,   289,   290,    -1,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,   302,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,    -1,   403,   404,   405,
     406,   407,    -1,    -1,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,    -1,    -1,   454,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,   479,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,    -1,    -1,
     106,   107,    -1,   109,   110,    -1,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,    -1,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,    -1,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
      -1,   287,   288,   289,   290,    -1,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,    -1,   403,   404,   405,
     406,   407,    -1,    -1,   410,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,    -1,    -1,   454,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,   479,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,    -1,    -1,
     106,   107,    -1,   109,   110,    -1,    -1,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,    -1,    -1,
      -1,    -1,    -1,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,    -1,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,    -1,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,    -1,   255,
     256,   257,    -1,    -1,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
      -1,   287,   288,   289,   290,    -1,   292,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,    -1,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,   399,   400,   401,    -1,   403,   404,   405,
     406,   407,    -1,    -1,   410,   411,   412,   413,    -1,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,    -1,    -1,   454,     6,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    -1,
      17,    18,    -1,    20,    21,    22,    23,    24,    25,    -1,
      27,    28,    29,   479,    -1,    32,    33,    34,    35,    -1,
      -1,    38,    39,    40,    41,    -1,    43,    -1,    -1,    46,
      47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,
      57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,
      -1,    68,    -1,    70,    71,    -1,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    -1,    -1,
      -1,    -1,    -1,    90,    -1,    92,    93,    -1,    95,    -1,
      97,    98,    99,    -1,   101,    -1,   103,    -1,    -1,   106,
     107,    -1,   109,   110,    -1,    -1,   113,   114,   115,   116,
      -1,   118,   119,   120,   121,   122,    -1,    -1,   125,   126,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,   136,
      -1,   138,   139,   140,   141,   142,    -1,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
     167,   168,    -1,    -1,   171,   172,   173,   174,   175,    -1,
     177,   178,   179,    -1,    -1,   182,    -1,   184,   185,   186,
     187,   188,   189,   190,    -1,   192,   193,   194,   195,    -1,
     197,    -1,   199,    -1,    -1,   202,   203,    -1,   205,    -1,
     207,   208,    -1,   210,    -1,   212,   213,   214,   215,    -1,
     217,   218,   219,    -1,   221,   222,   223,   224,   225,   226,
      -1,   228,   229,    -1,   231,   232,   233,    -1,   235,    -1,
     237,    -1,    -1,    -1,    -1,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,   251,   252,    -1,    -1,   255,   256,
     257,    -1,    -1,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,    -1,
     277,   278,   279,   280,   281,   282,   283,   284,   285,    -1,
     287,   288,    -1,   290,    -1,   292,   293,   294,   295,   296,
      -1,    -1,   299,    -1,    -1,    -1,   303,   304,    -1,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,    -1,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,    -1,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,    -1,    -1,   360,   361,   362,    -1,   364,   365,   366,
     367,    -1,   369,   370,    -1,   372,   373,   374,   375,   376,
     377,   378,   379,   380,   381,   382,   383,    -1,   385,   386,
      -1,   388,   389,   390,   391,   392,    -1,   394,   395,    -1,
      -1,   398,   399,   400,   401,    -1,   403,   404,   405,   406,
     407,    -1,    -1,   410,   411,   412,   413,    -1,    -1,   416,
     417,   418,   419,   420,   421,   422,    -1,   424,   425,   426,
      -1,    -1,   429,   430,   431,   432,   433,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,   444,   445,    -1,
      -1,    -1,    -1,    -1,   451,    -1,    -1,   454,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    -1,    27,
      28,    29,    -1,   480,    32,    33,    34,    35,    -1,    -1,
      38,    39,    40,    41,    -1,    43,    -1,    -1,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    92,    93,    -1,    95,    -1,    97,
      98,    99,    -1,   101,    -1,   103,    -1,    -1,   106,   107,
      -1,   109,   110,    -1,    -1,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,    -1,
     138,   139,   140,    -1,   142,    -1,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,   167,
     168,    -1,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,    -1,    -1,   182,    -1,   184,   185,   186,   187,
     188,   189,   190,    -1,   192,   193,   194,   195,    -1,   197,
      -1,   199,    -1,    -1,    -1,   203,    -1,   205,    -1,   207,
     208,    -1,   210,    -1,   212,   213,   214,   215,    -1,   217,
     218,   219,    -1,   221,   222,   223,   224,   225,   226,    -1,
      -1,   229,    -1,   231,   232,   233,    -1,   235,    -1,   237,
      -1,    -1,    -1,    -1,   242,    -1,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,    -1,    -1,   255,   256,   257,
      -1,    -1,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,    -1,   275,    -1,   277,
     278,   279,   280,   281,   282,   283,   284,   285,    -1,   287,
     288,    -1,   290,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,    -1,    -1,    -1,   303,   304,    -1,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,    -1,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,    -1,   345,   346,    -1,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
      -1,    -1,   360,   361,   362,    -1,   364,   365,   366,   367,
      -1,   369,   370,    -1,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,    -1,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,   394,   395,    -1,    -1,
     398,   399,   400,   401,    -1,   403,   404,   405,   406,   407,
      -1,    -1,   410,   411,   412,   413,    -1,    -1,   416,   417,
     418,   419,   420,   421,   422,    -1,   424,   425,   426,    -1,
      -1,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,    -1,    -1,
      -1,    -1,    -1,   451,   452,    -1,   454,   455,    -1,    -1,
      -1,    -1,   460,   461,   462,   463,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     478,   479,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    -1,    17,    18,    -1,    20,    21,    22,    23,
      24,    25,    -1,    27,    28,    29,    -1,    -1,    32,    33,
      34,    35,    -1,    -1,    38,    39,    40,    41,    -1,    43,
      -1,    -1,    46,    47,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,    93,
      -1,    95,    -1,    97,    98,    99,    -1,   101,    -1,   103,
      -1,    -1,   106,   107,    -1,   109,   110,    -1,    -1,   113,
     114,   115,   116,    -1,   118,   119,   120,   121,   122,    -1,
      -1,   125,   126,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,   136,    -1,   138,   139,   140,    -1,   142,    -1,
      -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,
     154,   155,   156,    -1,   158,    -1,   160,    -1,   162,   163,
     164,    -1,   166,   167,   168,    -1,    -1,   171,   172,   173,
     174,   175,    -1,   177,   178,   179,    -1,    -1,   182,    -1,
     184,   185,   186,   187,   188,   189,   190,    -1,   192,   193,
     194,   195,    -1,   197,    -1,   199,    -1,    -1,    -1,   203,
      -1,   205,    -1,   207,   208,    -1,   210,    -1,   212,   213,
     214,   215,    -1,   217,   218,   219,    -1,   221,   222,   223,
     224,   225,   226,    -1,    -1,   229,    -1,   231,   232,   233,
      -1,   235,    -1,   237,    -1,    -1,    -1,    -1,   242,    -1,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,    -1,
      -1,   255,   256,   257,    -1,    -1,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
      -1,   275,    -1,   277,   278,   279,   280,   281,   282,   283,
     284,   285,    -1,   287,   288,    -1,   290,    -1,   292,   293,
     294,   295,   296,    -1,    -1,   299,    -1,    -1,    -1,   303,
     304,    -1,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,    -1,   317,   318,   319,   320,   321,   322,    -1,
     324,   325,   326,   327,   328,   329,   330,   331,   332,    -1,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
      -1,   345,   346,    -1,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,    -1,    -1,   360,   361,   362,    -1,
     364,   365,   366,   367,    -1,   369,   370,    -1,   372,   373,
     374,   375,   376,   377,   378,   379,   380,   381,   382,   383,
      -1,   385,   386,    -1,   388,   389,   390,   391,   392,    -1,
     394,   395,    -1,    -1,   398,   399,   400,   401,    -1,   403,
     404,   405,   406,   407,    -1,    -1,   410,   411,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,    -1,
     424,   425,   426,    -1,    -1,   429,   430,   43