.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "LOAD" "" "2011-01-27" "SQL - Language Statements" "SQL Commands"
.SH NAME
LOAD \- load a shared library file

.SH SYNOPSIS
.sp
.nf
LOAD '\fIfilename\fR'
.sp
.fi
.SH "DESCRIPTION"
.PP
This command loads a shared library file into the PostgreSQL
server's address space. If the file has been loaded already,
the command does nothing. Shared library files that contain C functions
are automatically loaded whenever one of their functions is called.
Therefore, an explicit \fBLOAD\fR is usually only needed to
load a library that modifies the server's behavior through ``hooks''
rather than providing a set of functions.
.PP
The file name is specified in the same way as for shared library
names in CREATE FUNCTION [\fBcreate_function\fR(l)]; in particular, one
can rely on a search path and automatic addition of the system's standard
shared library file name extension. See in the documentation for
more information on this topic.

.PP
Non-superusers can only apply \fBLOAD\fR to library files
located in \fI$libdir/plugins/\fR \(em the specified
\fIfilename\fR must begin
with exactly that string. (It is the database administrator's
responsibility to ensure that only ``safe'' libraries
are installed there.)
.SH "COMPATIBILITY"
.PP
\fBLOAD\fR is a PostgreSQL
extension.
.SH "SEE ALSO"
.PP
CREATE FUNCTION [\fBcreate_function\fR(l)]
