.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE SEQUENCE" "" "29 March 2001" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE SEQUENCE \- Creates a new sequence number generator
.SH SYNOPSIS
.sp
.nf
CREATE SEQUENCE \fIseqname\fR [ INCREMENT \fIincrement\fR ]
    [ MINVALUE \fIminvalue\fR ] [ MAXVALUE \fImaxvalue\fR ]
    [ START \fIstart\fR ] [ CACHE \fIcache\fR ] [ CYCLE ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIseqname\fB\fR
The name of a sequence to be created.
.TP
\fB\fIincrement\fB\fR
The
\fBINCREMENT \fIincrement\fB\fR
clause is optional. A positive value will make an
ascending sequence, a negative one a descending sequence.
The default value is one (1).
.TP
\fB\fIminvalue\fB\fR
The optional clause \fBMINVALUE
\fIminvalue\fB\fR
determines the minimum value
a sequence can generate. The defaults are 1 and -2147483647 for
ascending and descending sequences, respectively.
.TP
\fB\fImaxvalue\fB\fR
The optional clause \fBMAXVALUE
\fImaxvalue\fB\fR
determines the maximum
value for the sequence. The defaults are 2147483647 and -1 for
ascending and descending sequences, respectively.
.TP
\fB\fIstart\fB\fR
The optional \fBSTART
\fIstart\fB
clause\fR enables the sequence to begin anywhere.
The default starting value is
\fIminvalue\fR
for ascending sequences and
\fImaxvalue\fR
for descending ones.
.TP
\fB\fIcache\fB\fR
The \fBCACHE \fIcache\fB\fR option
enables sequence numbers to be preallocated
and stored in memory for faster access. The minimum
value is 1 (only one value can be generated at a time, i.e., no cache)
and this is also the default.
.TP
\fBCYCLE\fR
The optional CYCLE keyword may be used to enable the sequence
to wrap around when the
\fImaxvalue\fR or
\fIminvalue\fR has been
reached by
an ascending or descending sequence respectively. If the limit is
reached, the next number generated will be the
\fIminvalue\fR or
\fImaxvalue\fR,
respectively.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
Message returned if the command is successful.
.TP
\fBERROR: Relation '\fIseqname\fB' already exists\fR
If the sequence specified already exists.
.TP
\fBERROR: DefineSequence: MINVALUE (\fIstart\fB) can't be >= MAXVALUE (\fImax\fB)\fR
If the specified starting value is out of range.
.TP
\fBERROR: DefineSequence: START value (\fIstart\fB) can't be < MINVALUE (\fImin\fB)\fR
If the specified starting value is out of range.
.TP
\fBERROR: DefineSequence: MINVALUE (\fImin\fB) can't be >= MAXVALUE (\fImax\fB)\fR
If the minimum and maximum values are inconsistent.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE SEQUENCE\fR will enter a new sequence number generator
into the current data base. This involves creating and initializing a
new single-row
table with the name \fIseqname\fR.
The generator will be owned by the user issuing the command.
.PP
After a sequence is created, you may use the function
\fBnextval('\fIseqname\fB')\fR
to get a new number from the sequence.
The function
\fBcurrval('\fIseqname\fB')\fR
may be used to determine the number returned by the last call to
\fBnextval('\fIseqname\fB')\fR
for the specified sequence in the current session.
The function
\fBsetval('\fIseqname\fB',
\fInewvalue\fB)\fR
may be used to set the current value of the specified sequence.
The next call to 
\fBnextval('\fIseqname\fB')\fR
will return the given value plus the sequence increment.
.PP
Use a query like
.sp
.nf
SELECT * FROM \fIseqname\fR;
   
.sp
.fi
to examine the parameters of a sequence.
As an alternative to fetching the
parameters from the original definition as above, you can use
.sp
.nf
SELECT last_value FROM \fIseqname\fR;
   
.sp
.fi
to obtain the last value allocated by any backend.
.PP
To avoid blocking of concurrent transactions
that obtain numbers from the same sequence, a nextval operation
is never rolled back; that is, once a value has been fetched it is
considered used, even if the transaction that did the nextval later
aborts. This means that aborted transactions may leave unused "holes"
in the sequence of assigned values. setval operations are never
rolled back, either.
.sp
.RS
.B "Caution:"
Unexpected results may be obtained if a cache setting greater than one
is used for a sequence object that will be used concurrently by multiple
backends. Each backend will allocate and cache successive sequence values
during one access to the sequence object and increase the sequence
object's last_value accordingly. Then, the next cache-1 uses of nextval
within that backend simply return the preallocated values without touching
the shared object. So, numbers allocated but not used in the current session
will be lost. Furthermore, although multiple backends are guaranteed to
allocate distinct sequence values, the values may be generated out of
sequence when all the backends are considered. (For example, with a cache
setting of 10, backend A might reserve values 1..10 and return nextval=1, 
then
backend B might reserve values 11..20 and return nextval=11 before backend
A has generated nextval=2.) Thus, with a cache setting of one it is safe
to assume that nextval values are generated sequentially; with a cache
setting greater than one you should only assume that the nextval values
are all distinct, not that they are generated purely sequentially.
Also, last_value will reflect the latest value reserved by any backend,
whether or not it has yet been returned by nextval.
Another consideration is that a setval executed on such a sequence
will not be noticed by other backends until they have used up any
preallocated values they have cached.
.RE
.sp
.SS "NOTES"
.PP
Use \fBDROP SEQUENCE\fR to remove a sequence.
.PP
Each backend uses its own cache to store preallocated numbers.
Numbers that are cached but not used in the current session will be
lost, resulting in "holes" in the sequence.
.SH "USAGE"
.PP
Create an ascending sequence called serial, starting at 101:
.sp
.nf
CREATE SEQUENCE serial START 101;
  
.sp
.fi
.PP
Select the next number from this sequence:
.sp
.nf
SELECT NEXTVAL ('serial');
    
nextval
-------
    114
   
.sp
.fi
.PP
Use this sequence in an INSERT:
.sp
.nf
INSERT INTO distributors VALUES (NEXTVAL('serial'),'nothing');
   
.sp
.fi
.PP
Set the sequence value after a COPY FROM:
.sp
.nf
CREATE FUNCTION distributors_id_max() RETURNS INT4
    AS 'SELECT max(id) FROM distributors' 
    LANGUAGE 'sql';
BEGIN;
    COPY distributors FROM 'input_file';
    SELECT setval('serial', distributors_id_max());
END;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBCREATE SEQUENCE\fR is a Postgres
language extension.
There is no \fBCREATE SEQUENCE\fR statement
in SQL92.
