.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CREATE_GROUP" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
CREATE GROUP \- Creates a new group
.SH SYNOPSIS
.sp
.nf
CREATE GROUP \fIname\fR
    [ WITH 
     [ SYSID \fIgid\fR ]
     [ USER  \fIusername\fR [, ...] ] ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of the group.
.TP
\fB\fIgid\fB\fR
The SYSID clause can be used to choose
the Postgres group id of the new
group. It is not necessary to do so, however.

If this is not specified, the highest assigned group id plus one,
starting at 1, will be used as default.
.TP
\fB\fIusername\fB\fR
A list of users to include in the group. The users must already exist.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE GROUP\fR
Message returned if the command completes successfully.
.PP
.SH "DESCRIPTION"
.PP
CREATE GROUP will create a new group in the database installation.
Refer to the adminstrator's guide for information about using groups
for authentication.
You must be a database superuser to use this command.
.PP
Use \fBalter_group\fR(l)
to change a group's membership, and \fBdrop_group\fR(l) to remove a group.
.SH "USAGE"
.PP
Create an empty group:
.sp
.nf
CREATE GROUP staff
.sp
.fi
.PP
Create a group with members:
.sp
.nf
CREATE GROUP marketing WITH USER jonathan, david
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBCREATE GROUP\fR statement in SQL92.
Roles are similar in concept to groups.
