# SPEC file for pg_batch
# Copyright(C) 2009-2010 NIPPON TELEGRAPH AND TELEPHONE CORPORATION

%define _pgdir   /usr/pgsql-9.0
%define _bindir  %{_pgdir}/bin
%define _libdir  %{_pgdir}/lib
%define _datadir %{_pgdir}/share

## Set general information for pg_batch.
Summary:    Parallel SQL Job Executor for PostgreSQL
Name:       pg_batch
Version:    1.2.5
Release:    1%{?dist}
License:    BSD
Group:      Applications/Databases
Source0:    %{name}-%{version}.tar.gz
BuildRoot:  %{_tmppath}/%{name}-%{version}-%{release}-%(%{__id_u} -n)
Vendor:	    NIPPON TELEGRAPH AND TELEPHONE CORPORATION

## We use postgresql-devel package
BuildRequires:  postgresql-devel
Requires:  postgresql90-libs >= 9.0.0

## Description for "pg_batch"
%description
pg_batch provides a method to execute SQL jobs in parallel for PostgreSQL.


## pre work for build pg_batch
%prep
%setup -q -n %{name}-%{version}

## Set variables for build environment
%build
USE_PGXS=1 make %{?_smp_mflags}

## Set variables for install
%install
rm -rf %{buildroot}

USE_PGXS=1 make %{?_smp_mflags} install

install -d %{buildroot}%{_bindir} 
install -m 755 pg_batch %{buildroot}%{_bindir}/pg_batch

install -d %{buildroot}%{_datadir}/contrib/
install -m 644 pg_batch.sql %{buildroot}%{_datadir}/contrib/pg_batch.sql
install -m 644 uninstall_pg_batch.sql %{buildroot}%{_datadir}/contrib/uninstall_pg_batch.sql
install -m 644 pg_batch_vacuum.sql %{buildroot}%{_datadir}/contrib/pg_batch_vacuum.sql

%clean
rm -rf %{buildroot}

%files
%{_bindir}/pg_batch
%{_datadir}/contrib/pg_batch.sql
%{_datadir}/contrib/uninstall_pg_batch.sql
%{_datadir}/contrib/pg_batch_vacuum.sql

# History of pg_batch.
%changelog
* Thu Oct 21 2010 - NTT OSS Center <sakamoto.masahiko@oss.ntt.co.jp> 1.2.5-1
* Wed Sep 22 2010 - NTT OSS Center <sakamoto.masahiko@oss.ntt.co.jp> 1.2.4-1
* Thu Apr 22 2010 - NTT OSS Center <itagaki.takahiro@oss.ntt.co.jp> 1.2.2-1
* Wed Dec  9 2009 - NTT OSS Center <itagaki.takahiro@oss.ntt.co.jp> 1.1.1-1
- Initial cut for 1.1.1

