/* $Id: function.h,v 1.4 2005/10/21 21:54:52 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/fcall.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/fcall.h,v 1.5 2004/10/20 16:00:35 flaw
 *//*
 * Function Call interface; calls to non-Python Postgres Functions
 */
#ifndef PyPg_call_function_H
#define PyPg_call_function_H 0
#ifdef __cplusplus
extern "C" {
#endif
	
#define PyPgFunctionCall_HEAD						\
	PyPgCall_HEAD										\
	struct FunctionCallInfoData	ob_fcinfo;	\
	struct FmgrInfo					ob_flinfo;

typedef struct PyPgFunctionCall {
	PyPgFunctionCall_HEAD
} * PyPgFunctionCall;

#ifndef PyPg_ci_H
extern PyTypeObject PyPgFunctionCall_Type;
PyObj PyPgFunctionCall_Initialize(PyObj, PyObj, PyObj, PyObj);
#else
#	define PyPgFunctionCall_Type (*(PyPgCI._PyPgFunctionCall_Type))
#	define PyPgFunctionCall_Initialize(...) \
		(PyPgCI._PyPgFunctionCall_Initialize(__VA_ARGS__))
#endif

#define PyPgFunctionCall_NEW() \
	(PyObj) PyPgFunctionCall_Type.tp_alloc(&PyPgFunctionCall_Type, 0)
#define PyPgFunctionCall_New(F, A, X) \
	PyPgFunctionCall_Initialize(PyPgFunctionCall_NEW(), F, A, X)

#define PyPgFunctionCall(SELF)	((PyPgFunctionCall) SELF)

#define PyPgFunctionCall_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPgFunctionCall_Type))
#define PyPgFunctionCall_CheckExact(SELF) \
	((SELF)->ob_type == &PyPgFunctionCall_Type)

#define PyPgFunctionCall_FetchFCInfo(SELF)		(&(PyPgFunctionCall(SELF)->ob_fcinfo))
#define PyPgFunctionCall_FetchFMInfo(SELF)		(&(PyPgFunctionCall(SELF)->ob_flinfo))
#define PyPgFunctionCall_FetchRSI(SELF) \
	((ReturnSetInfo *) ((PyPgFunctionCall(SELF)->ob_fcinfo).context))

#define PyPgFunctionCall_SwitchContext(SELF) \
	MemoryContextSwitchTo(PyPgFunctionCall_FetchFMInfo(SELF)->fn_mcxt)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_call_function_H */
/*
 * vim: ts=3:sw=3:noet:
 */
