/* $Id: relation.c,v 1.6 2005/10/21 21:55:03 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/rel.c,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/rel.c,v 1.2 2004/11/19 19:11:52 flaw
 * if/src/rel.c,v 1.20 2004/09/28 15:38:44 flaw
 *//*
 * The Postgres Relation interface
 */
#include <postgres.h>
#include <access/heapam.h>
#include <catalog/pg_type.h>
#include <executor/tstoreReceiver.h>
#include <utils/array.h>
#include <utils/palloc.h>
#include <utils/relcache.h>
#include <pypg/postgres.h>
#include <pypg/environment.h>

#include <Python.h>
#include <structmember.h>
#include <pypg/python.h>

#include <pypg/tupledesc.h>
#include <pypg/heaptuple.h>
#include <pypg/type.h>
#include <pypg/type/object.h>
#include <pypg/type/system.h>
#include <pypg/relation.h>

static int
rel_length(PyPgRelation self)
{
	return(0);
}

static PyObj
rel_concat(PyPgRelation self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_repeat(PyPgRelation self, int item)
{
	RETURN_NONE;
}

static PyObj
rel_item(PyPgRelation self, int item)
{
	RETURN_NONE;
}

static PyObj
rel_slice(PyPgRelation self, int fitem, int titem)
{
	RETURN_NONE;
}

static PyObj
rel_ass_item(PyPgRelation self, int item, PyObj as)
{
	RETURN_NONE;
}

static PyObj
rel_ass_slice(PyPgRelation self, int from, int toi, PyObj as)
{
	RETURN_NONE;
}

static PyObj
rel_contains(PyPgRelation self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_concat(PyPgRelation self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_repeat(PyPgRelation self, int num)
{
	RETURN_NONE;
}

static PySequenceMethods PyPgRelationAsSequence = {
	(inquiry)rel_length,					/* sq_length */
	(binaryfunc)rel_concat,				/* sq_concat */
	(intargfunc)rel_repeat,				/* sq_repeat */
	(intargfunc)rel_item,				/* sq_item */
	(intintargfunc)rel_slice,			/* sq_slice */
	(intobjargproc)rel_ass_item,		/* sq_ass_item */
	(intintobjargproc)rel_ass_slice,	/* sq_ass_slice */
	(objobjproc)rel_contains,			/* sq_contains */
	(binaryfunc)rel_inplace_concat,	/* sq_inplace_concat */
	(intargfunc)rel_inplace_repeat,	/* sq_inplace_repeat */
};

static PyObj
rel_subscript(PyPgRelation self, PyObj sub)
{
	RETURN_NONE;
}

static PyObj
rel_ass_subscript(PyPgRelation self, PyObj sub, PyObj to)
{
	RETURN_NONE;
}

static PyMappingMethods PyPgRelationAsMapping = {
	(inquiry)rel_length,						/* mp_length */
	(binaryfunc)rel_subscript,				/* mp_subscript */
	(objobjargproc)rel_ass_subscript,	/* mp_ass_subscript */
};

static PyObj
rel_add(PyPgRelation self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_subtract(PyPgRelation self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_multiply(PyPgRelation self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_divide(PyPgRelation self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_remainder(PyPgRelation self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_divmod(PyPgRelation self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_power(PyPgRelation self, PyObj with, PyObj andthis)
{
	RETURN_NONE;
}

static PyObj
rel_negative(PyPgRelation self)
{
	RETURN_NONE;
}

static PyObj
rel_positive(PyPgRelation self)
{
	RETURN_NONE;
}

static PyObj
rel_absolute(PyPgRelation self)
{
	RETURN_NONE;
}

static int
rel_nonzero(PyPgRelation self)
{
	return(-1);
}

static PyObj
rel_invert(PyPgRelation self)
{
	RETURN_NONE;
}

static PyObj
rel_lshift(PyPgRelation self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_rshift(PyPgRelation self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_and(PyPgRelation self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_xor(PyPgRelation self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_or(PyPgRelation self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_add(PyPgRelation self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_subtract(PyPgRelation self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_multiply(PyPgRelation self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_divide(PyPgRelation self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_remainder(PyPgRelation self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_power(PyPgRelation self, PyObj ob, PyObj ex)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_lshift(PyPgRelation self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_rshift(PyPgRelation self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_and(PyPgRelation self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_xor(PyPgRelation self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_or(PyPgRelation self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_floor_divide(PyPgRelation self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_true_divide(PyPgRelation self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_floor_divide(PyPgRelation self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_true_divide(PyPgRelation self, PyObj ob)
{
	RETURN_NONE;
}

static PyNumberMethods PyPgRelationAsNumber = {
	(binaryfunc)rel_add,						/* nb_add */
	(binaryfunc)rel_subtract,				/* nb_subtract */
	(binaryfunc)rel_multiply,				/* nb_multiply */
	(binaryfunc)rel_divide,					/* nb_divide */
	(binaryfunc)rel_remainder,				/* nb_remainder */
	(binaryfunc)rel_divmod,					/* nb_divmod */
	(ternaryfunc)rel_power,					/* nb_power */
	(unaryfunc)rel_negative,				/* nb_negative */
	(unaryfunc)rel_positive,				/* nb_positive */
	(unaryfunc)rel_absolute,				/* nb_absolute */
	(inquiry)rel_nonzero,					/* nb_nonzero */
	(unaryfunc)rel_invert,					/* nb_invert */
	(binaryfunc)rel_lshift,					/* nb_lshift */
	(binaryfunc)rel_rshift,					/* nb_rshift */
	(binaryfunc)rel_and,						/* nb_and */
	(binaryfunc)rel_xor,						/* nb_xor */
	(binaryfunc)rel_or,						/* nb_or */
	(coercion)NULL,							/* nb_coerce */
	(unaryfunc)NULL,							/* nb_int */
	(unaryfunc)NULL,							/* nb_long */
	(unaryfunc)NULL,							/* nb_float */
	(unaryfunc)NULL,							/* nb_oct */
	(unaryfunc)NULL,							/* nb_hex */

	(binaryfunc)rel_inplace_add,			/* nb_inplace_add */
	(binaryfunc)rel_inplace_subtract,	/* nb_inplace_subtract */
	(binaryfunc)rel_inplace_multiply,	/* nb_inplace_multiply */
	(binaryfunc)rel_inplace_divide,		/* nb_inplace_divide */
	(binaryfunc)rel_inplace_remainder,	/* nb_inplace_remainder */
	(ternaryfunc)rel_inplace_power,		/* nb_inplace_power */
	(binaryfunc)rel_inplace_lshift,		/* nb_inplace_lshift */
	(binaryfunc)rel_inplace_rshift,		/* nb_inplace_rshift */
	(binaryfunc)rel_inplace_and,			/* nb_inplace_and */
	(binaryfunc)rel_inplace_xor,			/* nb_inplace_xor */
	(binaryfunc)rel_inplace_or,			/* nb_inplace_or */

	(binaryfunc)rel_floor_divide,			/* nb_floor_divide */
	(binaryfunc)rel_true_divide,			/* nb_true_divide */
	(binaryfunc)rel_inplace_floor_divide,/* nb_inplace_floor_divide */
	(binaryfunc)rel_inplace_true_divide,/* nb_inplace_true_divide */
};

static PyMethodDef PyPgRelation_Methods[] = {
	//{"name", (PyCFunction)FunctionRef, flags, "docstring"},
	{NULL}
};

static void
rel_dealloc(PyObj self)
{
	RelationClose(PyPgRelation_FetchRelation(self));
	PyObject_Del(self);
}

static PyObj
rel_getattr(PyObj self, char *attr)
{
	Relation rel = PyPgRelation_FetchRelation(self);
	PyObj rob = NULL;

	if (!strcmp("type", attr))
	{
		rob = PyPgType_FromOid(rel->rd_rel->reltype);
	}
	else if (!strcmp("oid", attr))
	{
		rob = PyPgObject_FromTypeOidAndDatum(OIDOID, rel->rd_id);
	}
#if PGV_MM < 80
	else if (!strcmp("isnew", attr))
	{
		if (rel->rd_isnew)
			rob = Py_True;
		else
			rob = Py_False;
		INCREF(rob);
	}
#endif

	if (rob == NULL)
	{
		PyErr_Format(PyExc_AttributeError,
				"Relation object has no attribute '%s'", attr);
	}
	
	return(rob);
}

static int
rel_compare(PyPgRelation self, PyObj *with)
{
	return(-1);
}

static PyObj
rel_call(PyPgRelation self, PyObj args, PyObj kw)
{
	RETURN_NONE;
}

static PyObj
rel_str(PyPgRelation self)
{
	RETURN_NONE;
}

static PyObj
rel_iter(PyPgRelation self)
{
	RETURN_NONE;
}

static int
rel_clear(PyPgRelation self)
{
	return(-1);
}

static PyObj
rel_richcmp(PyPgRelation self, PyObj ob, int cmp)
{
	RETURN_NONE;
}

static int
rel_init(PyObj self, PyObj args, PyObj kw)
{
	PyObj ob;
	Oid reloid;

	if (!PyPgArg_ParseTypeSource(args, kw, &ob))
		return(-1);

	reloid = Oid_FromPyObject(ob);
	if (reloid == InvalidOid)
		return(-1);

	PyPgRelation_FixRelation(self, RelationIdGetRelation(reloid));
	return(0);
}

const char PyPgRelation_Doc[] =
"Python interface to the Postgres Relation";

PyTypeObject PyPgRelation_Type = {
	PyObject_HEAD_INIT(NULL)
	0,										/* ob_size */
	"Postgres.Relation",				/* tp_name */
	sizeof(struct PyPgRelation),	/* tp_basicsize */
	0,										/* tp_itemsize */
	(destructor) rel_dealloc,		/* tp_dealloc */
	NULL,									/* tp_print */
	(getattrfunc) rel_getattr,		/* tp_getattr */
	(setattrfunc) NULL,				/* tp_setattr */
	(cmpfunc) rel_compare,			/* tp_compare */
	(reprfunc) 0,						/* tp_repr */
	&PyPgRelationAsNumber,			/* tp_as_number */
	&PyPgRelationAsSequence,		/* tp_as_sequence */
	&PyPgRelationAsMapping,			/* tp_as_mapping */
	(hashfunc) NULL,					/* tp_hash */
	(ternaryfunc) rel_call,			/* tp_call */
	(reprfunc) rel_str,				/* tp_str */
	NULL,									/* tp_getattro */
	NULL,									/* tp_setattro */
	NULL,									/* tp_as_buffer */
	Py_TPFLAGS_DEFAULT,			   /* tp_flags */
	(char *) PyPgRelation_Doc,		/* tp_doc */
	(traverseproc) NULL,				/* tp_traverse */
	(inquiry) rel_clear,				/* tp_clear */
	(richcmpfunc) rel_richcmp,		/* tp_richcompare */
	(long) 0,							/* tp_weaklistoffset */
	(getiterfunc) rel_iter,			/* tp_iter */
	(iternextfunc) NULL,				/* tp_iternext */
	PyPgRelation_Methods,			/* tp_methods */
	NULL,									/* tp_members */
	NULL,									/* tp_getset */
	NULL,									/* tp_base */
	NULL,									/* tp_dict */
	NULL,									/* tp_descr_get */
	NULL,									/* tp_descr_set */
	0,										/* tp_dictoffset */
	(initproc) rel_init,				/* tp_init */
	NULL,									/* tp_alloc */
	PyType_GenericNew,				/* tp_new */
};

PyObj
PyPgRelation_Initialize(PyObj self, Relation rel)
{
	if (self == NULL)
		return(NULL);

	PyPgRelation_FixRelation(self, rel);

	return(self);
}
/*
 * vim: ts=3:sw=3:noet:
 */
