/* $Id: postgres.h,v 1.12 2005/12/14 08:22:31 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * Postgres utilities
 */
#ifndef PyPg_postgres_H
#define PyPg_postgres_H 0
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Use a bit of fingerprinting to identify if the Postgres uses the old list
 * implementation. FastLists don't exist in the new implementation, nor does the
 * forboth macro.
 */
#if defined(PG_LIST_H) && defined(FastListInit) && !defined(forboth)
/*
 * In the old list implementation, a ListCell is a List
 */
#	define ListCell List
#	define linitial(LIST) (LIST)
#	define list_length(L)	length(L)
#	define list_copy(L)		listCopy(L)
#	define list_free(L)		freeList(L)
#	define forboth(cell1, list1, cell2, list2)						\
	for (	cell1 = linitial(list1), cell2 = linitial(list2);	\
			cell1 != NULL && cell2 != NULL;							\
			cell1 = lnext(cell1), cell2 = lnext(cell2) )
#	define list_make1(x1) lcons(x1, NIL)
#	define list_make2(x1,x2) lcons(x1, list_make1(x2))
#	define list_make3(x1,x2,x3) lcons(x1, list_make2(x2,x3))
#	define list_make4(x1,x2,x3,x4) lcons(x1, list_make3(x2,x3,x4))
#endif /* USING OLD LISTS */

/* Post 7.5 */
#if (PGV_MM >= 75)
#	define TupleDescInitEntry(DESC,ATTNUM,ATTNAME,TYPOID,TYPMOD,DIM,ISSET) \
		TupleDescInitEntry(DESC,ATTNUM,ATTNAME,TYPOID,TYPMOD,DIM)
#else
#	define work_mem 1024
#	define pg_plan_query(QTREE, PLI) pg_plan_query(QTREE)
#endif

#if !defined(PG_TRY)
#	define PG_TRY() \
	do { \
		sigjmp_buf _saved_sigjmp_buf_; \
		memcpy(&_saved_sigjmp_buf_, &Warn_restart, sizeof(sigjmp_buf)); \
		if (sigsetjmp(Warn_restart, 1) == 0) \
		{ \

#	define PG_CATCH() \
		} \
		else \
		{ \
			memcpy(&Warn_restart, &_saved_sigjmp_buf_, sizeof(sigjmp_buf)) \

#	define PG_END_TRY() \
		} \
		memcpy(&Warn_restart, &_saved_sigjmp_buf_, sizeof(sigjmp_buf)); \
	} while(0)

#	define PG_RE_THROW() siglongjmp(Warn_restart, 1)
#endif /* !defined(PG_TRY) */

#define PythonMemoryContext(CODE) \
do{ \
	MemoryContext _former_mcxt = MemoryContextSwitchTo(PythonMemoryContext); \
	PG_TRY(); { CODE; } PG_CATCH(); { PyErr_SetPgError(); } PG_END_TRY(); \
	MemoryContextSwitchTo(_former_mcxt); \
}while(0)

/*
 * PyPgObject's are exclusively Datums, so a HeapTupleData structure must be
 * filled in when there is a need to use HeapTuple routines.
 */
#define	HeapTupleData_FromHeader(HTD, HEAD) do { \
	(HTD).t_len = (HEAD)->t_choice.t_datum.datum_len; \
	(HTD).t_tableOid = \
		RelationId_FromTypeOid((HEAD)->t_choice.t_datum.datum_typeid); \
	(HTD).t_data = HEAD; \
} while(0)

#define	HeapTupleHeaderStructure(HEAD) \
	((char *) (HEAD) + (HEAD)->t_hoff)

#define	HeapTuple_FetchLength(ht) (ht->t_len)
#define	HeapTuple_FetchTableOid(ht) (ht->t_tableOid)
#define	HeapTuple_FetchOid(ht) HeapTupleGetOid(ht)
#define	HeapTuple_FetchNatts(ht) (ht->t_data->t_natts)
#define	HeapTuple_FetchXmin(ht) HeapTupleHeaderGetXmin(ht->t_data)
#define	HeapTuple_FetchXmax(ht) HeapTupleHeaderGetXmax(ht->t_data)
#define	HeapTuple_FetchXvac(ht) HeapTupleHeaderGetXvac(ht->t_data)
#define	HeapTuple_FetchCmin(ht) HeapTupleHeaderGetCmin(ht->t_data)
#define	HeapTuple_FetchCmax(ht) HeapTupleHeaderGetCmax(ht->t_data)
#define	HeapTuple_FetchTID(ht) (ht->t_data->t_ctid)

#define	HeapTuple_FixOid(ht, oid) HeapTupleSetOid(ht, oid)
#define	HeapTuple_FixTableOid(ht, oid) (ht->t_tableOid = oid)

#define	PROCSTRUCT(V) ((Form_pg_proc) GETSTRUCT(V))
#define	TYPESTRUCT(V) ((Form_pg_type) GETSTRUCT(V))
#define	LANGSTRUCT(V) ((Form_pg_language) GETSTRUCT(V))
#define	OPERSTRUCT(V) ((Form_pg_operator) GETSTRUCT(V))
#define	CASTSTRUCT(V) ((Form_pg_cast) GETSTRUCT(V))

#define	SysRelTupleDesc(F_) (RelationNameGetTupleDesc(F_##RelationName))
#define	SysTupleDesc(_F) (RelationOidGetDescr(RelOid_pg_##_F))

#if PGV_MM < 80
#	define PortalStart(port, pli, snap) PortalStart(port, pli)
#	define CreateQueryDesc(Q,P,S,SC,D,PLI,I) CreateQueryDesc(Q,P,D,PLI,I)
#	define ProcessUtility(PT, PLI, DR, CTAG) ProcessUtility(PT,DR,CTAG)
#endif

#if defined(ASYNC_H) && PGV_MM < 81
#define Async_Listen(relname) Async_Listen(relname, MyProcPid)
#define Async_Unlisten(relname) Async_Unlisten(relname, MyProcPid)
#endif

#ifndef PG_FEATURE_ARRAYNULLS
#	if PGV_MM >= 82
#		define PG_FEATURE_ARRAYNULLS 1
#	else
#		define PG_FeATURE_ARRAYNULLS 0
#	endif
#endif

#ifndef PG_FEATURE_INOUTPARAMS
#	ifdef Anum_pg_proc_proargmodes
#		define PG_FEATURE_INOUTPARAMS 1
#	else
#		define PG_FEATURE_INOUTPARAMS 0
#	endif
#endif

#ifndef PG_FEATURE_ERRORDATA
#	if (PGV_MM >= 75)
#		define PG_FEATURE_ERRORDATA 1
#	else
#		define PG_FEATURE_ERRORDATA 0
#	endif
#endif

#ifndef PG_FEATURE_TABLESPACES
#	if PGV_MM >= 75
#		define PG_FEATURE_TABLESPACES 1
#	else
#		define PG_FEATURE_TABLESPACES 0
#	endif
#endif

#ifndef PG_FEATURE_SAVEPOINTS
#	if PGV_MM >= 75
#		define PG_FEATURE_SAVEPOINTS 1
#	else
#		define PG_FEATURE_SAVEPOINTS 0
#	endif
#endif

#ifndef PG_FEATURE_PROARGNAMES
#	if defined(Anum_pg_proc_proargnames)
#		define PG_FEATURE_PROARGNAMES 1
#	else
#		define PG_FEATURE_PROARGNAMES 0
#	endif
#endif

#ifndef PG_FEATURE_ARRAY_VECTORS
#	if PGV_MM >= 81
#		define PG_FEATURE_ARRAY_VECTORS 1
#	else
#		define PG_FEATURE_ARRAY_VECTORS 0
#	endif
#endif

#if PGV_MM < 81
#define TypeRelationId RelOid_pg_type
#define RelationRelationId RelOid_pg_class
#define ProcedureRelationId RelOid_pg_proc
#define AttributeRelationId RelOid_pg_attribute
#endif

#ifndef PG_TYPE_H
#warning THE HEADER catalog/pg_type.h WAS NOT INCLUDED!!
#endif

#ifdef OIDOID
#define PGTYPE_OID
#define IF_PGTYPE_OID(CODE) CODE
#else
#define IF_PGTYPE_OID(CODE)
#endif

#ifdef RECORDOID
#define PGTYPE_RECORD
#define IF_PGTYPE_RECORD(CODE) CODE
#else
#define IF_PGTYPE_RECORD(CODE)
#endif

#ifdef BOOLOID
#define PGTYPE_BOOL
#define IF_PGTYPE_BOOL(CODE) CODE
#else
#define IF_PGTYPE_BOOL(CODE)
#endif

#ifdef REFCURSOROID
#define PGTYPE_REFCURSOR
#define IF_PGTYPE_REFCURSOR(CODE) CODE
#else
#define IF_PGTYPE_REFCURSOR(CODE)
#endif

#ifdef REGPROCEDUREOID
#define PGTYPE_REGPROCEDURE
#define IF_PGTYPE_REGPROCEDURE(CODE) CODE
#else
#define IF_PGTYPE_REGPROCEDURE(CODE)
#endif

#ifdef REGPROCOID
#define PGTYPE_REGPROC
#define IF_PGTYPE_REGPROC(CODE) CODE
#else
#define IF_PGTYPE_REGPROC(CODE)
#endif

#ifdef REGOPEROID
#define PGTYPE_REGOPER
#define IF_PGTYPE_REGOPER(CODE) CODE
#else
#define IF_PGTYPE_REGOPER(CODE)
#endif

#ifdef REGOPERATOROID
#define PGTYPE_REGOPERATOR
#define IF_PGTYPE_REGOPERATOR(CODE) CODE
#else
#define IF_PGTYPE_REGOPERATOR(CODE)
#endif

#ifdef REGCLASSOID
#define PGTYPE_REGCLASS
#define IF_PGTYPE_REGCLASS(CODE) CODE
#else
#define IF_PGTYPE_REGCLASS(CODE)
#endif

#ifdef REGTYPEOID
#define PGTYPE_REGTYPE
#define IF_PGTYPE_REGTYPE(CODE) CODE
#else
#define IF_PGTYPE_REGTYPE(CODE)
#endif

#ifdef BITOID
#define PGTYPE_BIT
#define IF_PGTYPE_BIT(CODE) CODE
#else
#define IF_PGTYPE_BIT(CODE)
#endif

#ifdef VARBITOID
#define PGTYPE_VARBIT
#define IF_PGTYPE_VARBIT(CODE) CODE
#else
#define IF_PGTYPE_VARBIT(CODE)
#endif

#ifdef ACLITEMOID
#define PGTYPE_ACLITEM
#define IF_PGTYPE_ACLITEM(CODE) CODE
#else
#define IF_PGTYPE_ACLITEM(CODE)
#endif

#ifdef INT2OID
#define PGTYPE_INT2
#define IF_PGTYPE_INT2(CODE) CODE
#else
#define IF_PGTYPE_INT2(CODE)
#endif

#ifdef INT4OID
#define PGTYPE_INT4
#define IF_PGTYPE_INT4(CODE) CODE
#else
#define IF_PGTYPE_INT4(CODE)
#endif

#ifdef INT8OID
#define PGTYPE_INT8
#define IF_PGTYPE_INT8(CODE) CODE
#else
#define IF_PGTYPE_INT8(CODE)
#endif

#ifdef NUMERICOID
#define PGTYPE_NUMERIC
#define IF_PGTYPE_NUMERIC(CODE) CODE
#else
#define IF_PGTYPE_NUMERIC(CODE)
#endif

#ifdef CASHOID
#define PGTYPE_CASH
#define IF_PGTYPE_CASH(CODE) CODE
#else
#define IF_PGTYPE_CASH(CODE)
#endif

#ifdef XIDOID
#define PGTYPE_XID
#define IF_PGTYPE_XID(CODE) CODE
#else
#define IF_PGTYPE_XID(CODE)
#endif

#ifdef CIDOID
#define PGTYPE_CID
#define IF_PGTYPE_CID(CODE) CODE
#else
#define IF_PGTYPE_CID(CODE)
#endif

#ifdef TIDOID
#define PGTYPE_TID
#define IF_PGTYPE_TID(CODE) CODE
#else
#define IF_PGTYPE_TID(CODE)
#endif

#ifdef OIDVECTOROID
#define PGTYPE_OIDVECTOR
#define IF_PGTYPE_OIDVECTOR(CODE) CODE
#else
#define IF_PGTYPE_OIDVECTOR(CODE)
#endif

#ifdef INT2VECTOROID
#define PGTYPE_INT2VECTOR
#define IF_PGTYPE_INT2VECTOR(CODE) CODE
#else
#define IF_PGTYPE_INT2VECTOR(CODE)
#endif

#ifdef FLOAT4OID
#define PGTYPE_FLOAT4
#define IF_PGTYPE_FLOAT4(CODE) CODE
#else
#define IF_PGTYPE_FLOAT4(CODE)
#endif

#ifdef FLOAT8OID
#define PGTYPE_FLOAT8
#define IF_PGTYPE_FLOAT8(CODE) CODE
#else
#define IF_PGTYPE_FLOAT8(CODE)
#endif

#ifdef POINTOID
#define PGTYPE_POINT
#define IF_PGTYPE_POINT(CODE) CODE
#else
#define IF_PGTYPE_POINT(CODE)
#endif

#ifdef LSEGOID
#define PGTYPE_LSEG
#define IF_PGTYPE_LSEG(CODE) CODE
#else
#define IF_PGTYPE_LSEG(CODE)
#endif

#ifdef PATHOID
#define PGTYPE_PATH
#define IF_PGTYPE_PATH(CODE) CODE
#else
#define IF_PGTYPE_PATH(CODE)
#endif

#ifdef BOXOID
#define PGTYPE_BOX
#define IF_PGTYPE_BOX(CODE) CODE
#else
#define IF_PGTYPE_BOX(CODE)
#endif

#ifdef LINEOID
#define PGTYPE_LINE
#define IF_PGTYPE_LINE(CODE) CODE
#else
#define IF_PGTYPE_LINE(CODE)
#endif

#ifdef CIRCLEOID
#define PGTYPE_CIRCLE
#define IF_PGTYPE_CIRCLE(CODE) CODE
#else
#define IF_PGTYPE_CIRCLE(CODE)
#endif

#ifdef ABSTIMEOID
#define PGTYPE_ABSTIME
#define IF_PGTYPE_ABSTIME(CODE) CODE
#else
#define IF_PGTYPE_ABSTIME(CODE)
#endif

#ifdef RELTIMEOID
#define PGTYPE_RELTIME
#define IF_PGTYPE_RELTIME(CODE) CODE
#else
#define IF_PGTYPE_RELTIME(CODE)
#endif

#ifdef TINTERVALOID
#define PGTYPE_TINTERVAL
#define IF_PGTYPE_TINTERVAL(CODE) CODE
#else
#define IF_PGTYPE_TINTERVAL(CODE)
#endif

#ifdef DATEOID
#define PGTYPE_DATE
#define IF_PGTYPE_DATE(CODE) CODE
#else
#define IF_PGTYPE_DATE(CODE)
#endif

#ifdef TIMEOID
#define PGTYPE_TIME
#define IF_PGTYPE_TIME(CODE) CODE
#else
#define IF_PGTYPE_TIME(CODE)
#endif

#ifdef TIMETZOID
#define PGTYPE_TIMETZ
#define IF_PGTYPE_TIMETZ(CODE) CODE
#else
#define IF_PGTYPE_TIMETZ(CODE)
#endif

#ifdef TIMESTAMPOID
#define PGTYPE_TIMESTAMP
#define IF_PGTYPE_TIMESTAMP(CODE) CODE
#else
#define IF_PGTYPE_TIMESTAMP(CODE)
#endif

#ifdef TIMESTAMPTZOID
#define PGTYPE_TIMESTAMPTZ
#define IF_PGTYPE_TIMESTAMPTZ(CODE) CODE
#else
#define IF_PGTYPE_TIMESTAMPTZ(CODE)
#endif

#ifdef INTERVALOID
#define PGTYPE_INTERVAL
#define IF_PGTYPE_INTERVAL(CODE) CODE
#else
#define IF_PGTYPE_INTERVAL(CODE)
#endif

#ifdef BYTEAOID
#define PGTYPE_BYTEA
#define IF_PGTYPE_BYTEA(CODE) CODE
#else
#define IF_PGTYPE_BYTEA(CODE)
#endif

#ifdef CHAROID
#define PGTYPE_CHAR
#define IF_PGTYPE_CHAR(CODE) CODE
#else
#define IF_PGTYPE_CHAR(CODE)
#endif

#ifdef NAMEOID
#define PGTYPE_NAME
#define IF_PGTYPE_NAME(CODE) CODE
#else
#define IF_PGTYPE_NAME(CODE)
#endif

#ifdef BPCHAROID
#define PGTYPE_BPCHAR
#define IF_PGTYPE_BPCHAR(CODE) CODE
#else
#define IF_PGTYPE_BPCHAR(CODE)
#endif

#ifdef VARCHAROID
#define PGTYPE_VARCHAR
#define IF_PGTYPE_VARCHAR(CODE) CODE
#else
#define IF_PGTYPE_VARCHAR(CODE)
#endif

#ifdef TEXTOID
#define PGTYPE_TEXT
#define IF_PGTYPE_TEXT(CODE) CODE
#else
#define IF_PGTYPE_TEXT(CODE)
#endif

#ifdef UNKNOWNOID
#define PGTYPE_UNKNOWN
#define IF_PGTYPE_UNKNOWN(CODE) CODE
#else
#define IF_PGTYPE_UNKNOWN(CODE)
#endif

#ifdef CSTRINGOID
#define PGTYPE_CSTRING
#define IF_PGTYPE_CSTRING(CODE) CODE
#else
#define IF_PGTYPE_CSTRING(CODE)
#endif

#ifdef MACADDROID
#define PGTYPE_MACADDR
#define IF_PGTYPE_MACADDR(CODE) CODE
#else
#define IF_PGTYPE_MACADDR(CODE)
#endif

#ifdef INETOID
#define PGTYPE_INET
#define IF_PGTYPE_INET(CODE) CODE
#else
#define IF_PGTYPE_INET(CODE)
#endif

#ifdef CIDROID
#define PGTYPE_CIDR
#define IF_PGTYPE_CIDR(CODE) CODE
#else
#define IF_PGTYPE_CIDR(CODE)
#endif

#ifdef PG_ATTRIBUTE_RELTYPE_OID
#define PGTYPE_ATTRIBUTE
#define IF_PGTYPE_ATTRIBUTE(CODE) CODE
#else
#define IF_PGTYPE_ATTRIBUTE(CODE)
#endif

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_postgres_H */
/*
 * vim: ts=3:sw=3:noet:
 */
