/* $Id: function.h,v 1.4 2005/05/12 19:29:34 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * imp/src/func.h,v 1.4 2004/12/15 13:05:14 flaw
 * if/src/func.h,v 1.1 2004/09/28 15:40:49 flaw
 *//*
 * Postgres function calling and lookup interface
 */
#ifndef PyPg_function_H
#define PyPg_function_H 0
#ifdef __cplusplus
extern "C" {
#endif

typedef struct PyPgFunction {
	PyPgObject_HEAD
	PGFunction 			fn_pointer;			/* PGFunction */
	PyObj 				fn_code;				/* PyCodeObject, Python */
	PyObj					fn_proargtypes;	/* PyTuple of PyPgType's */
	PyObj					fn_prorettype;		/* PyPgType */

	PyObj					fn_proargnames;	/* PyDict of args with names */
	/*
	 * The dictionary's keys are integer objects specifying
	 * the argument associated with the specified name.
	 */
} * PyPgFunction;

extern PyTypeObject PyPgFunction_Type;

#define PyPgFunction_NEW()  \
	((PyObj) PyPgFunction_Type.tp_alloc(&PyPgFunction_Type, 0))

#define PyPgFunction_Check(SELF) (PyObject_TypeCheck((SELF), &PyPgFunction_Type))
#define PyPgFunction_CheckExact(SELF) ((SELF)->ob_type == &PyPgFunction_Type)

#define PyPgFunction(SELF)	((PyPgFunction) SELF)

#define PyPgFunction_FetchFunction(SELF) \
	(PyPgFunction(SELF)->fn_pointer)
#define PyPgFunction_FetchReturnType(SELF) \
	(PyPgFunction(SELF)->fn_prorettype)
#define PyPgFunction_FetchCode(SELF) \
	(PyPgFunction(SELF)->fn_code)
#define PyPgFunction_FetchProcStruct(SELF) \
	((Form_pg_proc) PyPgObject_FetchStructure(SELF))

#define PyPgFunction_FetchArgNames(SELF)		(PyPgFunction(SELF)->fn_proargnames)

#define PyPgFunction_FetchArgTypes(SELF)		(PyPgFunction(SELF)->fn_proargtypes)
#define PyPgFunction_FetchReturnType(SELF)	(PyPgFunction(SELF)->fn_prorettype)

#define PyPgFunction_FixPGFunction(SELF, PGF) \
	(PyPgFunction(SELF)->fn_pointer = PGF)
#define PyPgFunction_FixCode(SELF, OB) \
	(PyPgFunction(SELF)->fn_code = OB)
#define PyPgFunction_FixArgTypes(SELF, OB) \
	(PyPgFunction(SELF)->fn_proargtypes = OB)
#define PyPgFunction_FixReturnType(SELF, OB) \
	(PyPgFunction(SELF)->fn_prorettype = OB)
#define PyPgFunction_FixArgNames(SELF, OB) \
	(PyPgFunction(SELF)->fn_proargnames = OB)

#define PyPgFunction_IsSRF(SELF) \
	(PyPgFunction_FetchProcStruct(SELF)->proretset)
#define PyPgFunction_IsPython(SELF) \
	(PyPgFunction_FetchCode(SELF) != Py_None)

PyObj PyPgFunction_FromOid(Oid);
PyObj pg_proc_PyPgType(void);

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_function_H */
/*
 * vim: ts=3:sw=3:noet:
 */
