#!/bin/sh

#############
## Purpose ##
#############

# This script generates documentation from the XML Docbook files: html files in
# the doc directory and man page in the src directory.

##################
## Main program ##
##################

echo "Generates documentation (html in doc and man in src)."
echo "Usage: $0"
echo ""

DIR=`dirname $0`"/"

# Generate HTML from XML
for src in `find "$DIR" -name "*.xml"`; do

	# Generate documentation with DocBook and xmlto
	echo "+ xmlto -o $DIR xhtml-nochunks $src"
	xmlto -o "$DIR" xhtml-nochunks "$src"
	
	# Add link to the CSS
	html="${src%.xml}.html"
	echo -n "+ Processing $html... "
	content=`cat "$html" | sed -e 's#</head>#<link rel="stylesheet" type="text/css" href="docbook.css" /></head>#g'`
	echo "$content" > "$html"
	echo -e "done\\n"
done

# Add README to documentation
echo -n "+ Updating INDEX.html with README... "
html="${DIR}/INDEX.html"
README=`cat "${DIR}/../README"`
# Update HTML special chars
README="${README//&/&amp;}"
README="${README//</&lt;}"
README="${README//>/&gt;}"
# Update links
README=`echo -e "$README" | sed -e 's#\(http://www\.[a-zA-Z0-9_]*\.[a-zA-Z0-9_]*\)#<a href="\1" target="_blank">\1</a>#g'`
# Update references
README=`echo -e "$README" | sed -e 's#doc/\([a-zA-Z0-9_]*\.html\)#<a href="\1">\1</a>#g'`
# Remove </body></html> and add README
content=`cat "$html" | sed -e 's#</body></html>##g'`
echo "$content" > "$html"
echo "<pre>" >> "$html"
echo -e "$README" >> "$html"
echo "</pre></body></html>" >> "$html"
echo "" >> "$html"
echo -e "done\\n"

# Prepare man page for pgScript/src
src="${DIR}/USAGE.xml"
echo "+ touch ${DIR}/../src/pgScript.1"
touch "${DIR}/../src/pgScript.1"
echo "+ xmlto -o ${DIR}/../src man $src"
xmlto -o "${DIR}/../src" man "$src"
