#include "connection.h"

/*-----------------------------------------------------------------------------
 * FUNCTION: sock_send
 *-----------------------------------------------------------------------------
 */

int sock_send(Connection* pConnection)
{
	int nToSend, nSent;

	nToSend = pConnection->pOutLast - pConnection->pOutFirst;
	while (nToSend > 0)
	{
		nSent = send(pConnection->socket, pConnection->pOutFirst, nToSend, 0);
		if (nSent < 0)
			return 1;

#ifdef _NEED_LOG /* andyk */
	{
		FILE* file;

		file = fopen("psql_odbc_send.txt", "ab");
		fwrite(pConnection->pOutFirst, 1, nSent, file);
		fclose(file);
	}
#endif

		nToSend -= nSent;
		pConnection->pOutFirst += nSent;
	}
	pConnection->pOutLast  = pConnection->pOutBegin;
	pConnection->pOutFirst = pConnection->pOutBegin;
	return 0;
}

/*-----------------------------------------------------------------------------
 * FUNCTION: sock_recv
 *-----------------------------------------------------------------------------
 */
int sock_recv(Connection* pConnection)
{
	int nReceived;
	memcpy(pConnection->pInBegin, pConnection->pInFirst, pConnection->pInLast-pConnection->pInFirst);
	pConnection->pInLast += pConnection->pInBegin - pConnection->pInFirst;
	pConnection->pInFirst = pConnection->pInBegin;
	nReceived = recv(pConnection->socket, pConnection->pInLast, (pConnection->pInEnd - pConnection->pInLast), 0);
	if (nReceived > 0)
	{
#ifdef _NEED_LOG /* andyk */
	{
		FILE* file;

		file = fopen("psql_odbc_recv.txt", "ab");
		fwrite(pConnection->pInLast, 1, nReceived, file);
		fclose(file);
	}
#endif
		pConnection->pInLast += nReceived;
	}
	return nReceived;
}

/*-----------------------------------------------------------------------------
 * FUNCTION: sock_connect
 *-----------------------------------------------------------------------------
 */
SQLRETURN
sock_connect(Connection* pConnection)
{
	struct hostent* hp;
	int             nRes;
	int             a_type;

	if ('\0' == pConnection->parameters[SERVER_PARAM][0] ||
	    '\0' == pConnection->parameters[PORT_PARAM][0])
	{
		/* ERR_UNKNOWN_HOST or ERR_UNKNOWN_PORT */
		return SQL_ERROR;
	}

#ifdef UNICODE
	{
		char server_name[SERVER_MAX_LENGTH+1];
		WideCharToMultiByte(0, 0, pConnection->parameters[SERVER_PARAM], wcslen(pConnection->parameters[SERVER_PARAM])+1, server_name, sizeof(server_name), NULL, NULL);
		hp = gethostbyname(server_name);
	}
#else
	hp = gethostbyname(pConnection->parameters[SERVER_PARAM]);
#endif /* UNICODE */

	if (hp == NULL)
	{
		SetError(SQL_HANDLE_DBC, pConnection, ERR_UNKNOWN_HOST, pConnection->parameters[SERVER_PARAM], pConnection->parameters[PORT_PARAM], NULL);
		return SQL_ERROR;
	}
	a_type = hp->h_addrtype;
	if (a_type != AF_INET)
	{
		/* */
		return SQL_ERROR;
	}
	pConnection->addr.sin_addr = *(struct in_addr*) hp->h_addr;

	pConnection->addr.sin_family = AF_INET;
	pConnection->addr.sin_port = htons((unsigned short)_ttoi(pConnection->parameters[PORT_PARAM]));

	pConnection->socket = socket(AF_INET, SOCK_STREAM, 0);
	if (pConnection->socket < 0)
	{
		return SQL_ERROR;
	}

	nRes = connect(pConnection->socket, (struct sockaddr*) &pConnection->addr, sizeof(pConnection->addr));
	if (nRes)
	{
		SetError(SQL_HANDLE_DBC, pConnection, ERR_CANT_CONNECT_TO_HOST, pConnection->parameters[SERVER_PARAM], pConnection->parameters[PORT_PARAM], NULL);
		return SQL_ERROR;
	}

	return SQL_SUCCESS;
}

/*-----------------------------------------------------------------------------
 * FUNCTION: sock_close
 *-----------------------------------------------------------------------------
 */
SQLRETURN
sock_close(Connection* pConnection)
{
	closesocket(pConnection->socket);
	pConnection->socket = -1;
	return SQL_SUCCESS;
}
