CREATE SEQUENCE id
  start 10000 increment 1 maxvalue 2147483647 minvalue 1  cache 1 ;
--
SELECT nextval ('id');
--
CREATE TABLE makemodel (
  parts_id int,
  name text
);
--
CREATE TABLE gl (
  id int DEFAULT nextval ( 'id' ),
  source text,
  description text,
  transdate date DEFAULT current_date,
  employee_id int
);
--
CREATE TABLE chart (
  id int DEFAULT nextval ( 'id' ),
  accno text NOT NULL,
  description text,
  charttype char(1) DEFAULT 'A',
  category char(1),
  link text,
  gifi_accno text
);
--
CREATE TABLE gifi (
  accno text,
  description text
);
--
CREATE TABLE defaults (
  inventory_accno_id int,
  income_accno_id int,
  expense_accno_id int,
  fxgain_accno_id int,
  fxloss_accno_id int,
  invnumber text,
  sonumber text,
  yearend varchar(5),
  weightunit varchar(5),
  businessnumber text,
  version varchar(8),
  curr text,
  closedto date,
  revtrans bool DEFAULT 'f',
  ponumber text
);
--
CREATE TABLE acc_trans (
  trans_id int,
  chart_id int,
  amount float,
  transdate date DEFAULT current_date,
  source text,
  cleared bool DEFAULT 'f',
  fx_transaction bool DEFAULT 'f'
);
--
CREATE TABLE invoice (
  id int DEFAULT nextval ( 'id' ),
  trans_id int,
  parts_id int,
  description text,
  qty float4,
  allocated float4,
  sellprice float,
  fxsellprice float,
  discount float4,
  assemblyitem bool DEFAULT 'f',
  unit varchar(5)
);
--
CREATE TABLE vendor (
  id int DEFAULT nextval ( 'id' ),
  name varchar(255),
  addr1 varchar(255),
  addr2 varchar(255),
  addr3 varchar(255),
  addr4 varchar(255),
  contact varchar(255),
  phone varchar(100),
  fax varchar(100),
  email text,
  notes text,
  terms int2 DEFAULT 0,
  taxincluded bool,
  vendornumber text unique
);
--2003-12-10
alter table vendor add column locationcode  varchar(255);
alter table vendor add column salesperson  varchar(255);

CREATE TABLE customer (
  id int DEFAULT nextval ( 'id' ),
  name varchar(255),
  addr1 varchar(255),
  addr2 varchar(255),
  addr3 varchar(255),
  addr4 varchar(255),
  contact varchar(255),
  phone varchar(100),
  fax varchar(100),
  email text,
  notes text,
  discount float4,
  taxincluded bool,
  creditlimit float DEFAULT 0,
  terms int2 DEFAULT 0,
  shiptoname varchar(255),
  shiptoaddr1 varchar(255),
  shiptoaddr2 varchar(255),
  shiptoaddr3 varchar(255),
  shiptoaddr4 varchar(255),
  shiptocontact varchar(255),
  shiptophone varchar(100),
  shiptofax varchar(100),
  shiptoemail text,
  customernumber text unique
);
--2003-12-10
alter table customer add column locationcode  varchar(255);
alter table customer add column salesperson  varchar(255);

CREATE TABLE parts (
  id int DEFAULT nextval ( 'id' ),
  partnumber text,
  description text,
  unit varchar(5),
  listprice float,
  sellprice float,
  lastcost float,
  priceupdate date DEFAULT current_date,
  weight float4,
  onhand float4 DEFAULT 0,
  notes text,
  makemodel bool DEFAULT 'f',
  assembly bool DEFAULT 'f',
  alternate bool DEFAULT 'f',
  rop float4,
  inventory_accno_id int,
  income_accno_id int,
  expense_accno_id int,
  bin text,
  obsolete bool DEFAULT 'f'
);
--
CREATE TABLE assembly (
  id int,
  parts_id int,
  qty float
);
--
CREATE TABLE ar (
  id int DEFAULT nextval ( 'id' ),
  invnumber text,
  transdate date DEFAULT current_date,
  customer_id int,
  taxincluded bool,
  amount float,
  netamount float,
  paid float,
  datepaid date,
  duedate date,
  invoice bool DEFAULT 'f',
  shippingpoint text,
  terms int2 DEFAULT 0,
  notes text,
  curr char(3),
  ordnumber text,
  employee_id int
);
--
--2003-12-07
alter table ar add column salesperson  varchar(255);

CREATE TABLE ap (
  id int DEFAULT nextval ( 'id' ),
  invnumber text,
  transdate date DEFAULT current_date,
  vendor_id int,
  taxincluded bool DEFAULT 'f',
  amount float,
  netamount float,
  paid float,
  datepaid date,
  duedate date,
  invoice bool DEFAULT 'f',
  ordnumber text,
  curr char(3),
  notes text,
  employee_id int
);
alter table ap add column donumber text;
--2003-12-07
alter table ap add column terms int2 ;

--
CREATE TABLE partstax (
  parts_id int,
  chart_id int
);
--
CREATE TABLE tax (
  chart_id int,
  rate float,
  taxnumber text
);
--
CREATE TABLE customertax (
  customer_id int,
  chart_id int
);
--
CREATE TABLE vendortax (
  vendor_id int,
  chart_id int
);
--
CREATE TABLE oe (
  id int default nextval('id'),
  ordnumber text,
  transdate date default current_date,
  vendor_id int,
  customer_id int,
  amount float8,
  netamount float8,
  reqdate date,
  taxincluded bool,
  shippingpoint text,
  notes text,
  curr char(3),
  employee_id int
);
--2003-12-09
alter table oe add column transtype varchar(100);

CREATE TABLE orderitems (
  trans_id int,
  parts_id int,
  description text,
  qty float4,
  sellprice float8,
  discount float4,
  unit varchar(5)
);
--
CREATE TABLE exchangerate (
  curr char(3),
  transdate date,
  buy float8,
  sell float8
);
--
CREATE TABLE employee (
  id int DEFAULT nextval ('id'),
  login text,
  name Varchar(35),
  addr1 varchar(35),
  addr2 varchar(35),
  addr3 varchar(35),
  addr4 varchar(35),
  workphone varchar(20),
  homephone varchar(20),
  startdate date default current_date,
  enddate date,
  notes text
);

--upgrade
alter table gl add column batch varchar(50);
alter table gl add column project varchar(50);
alter table gl add column subb varchar(50);
alter table gl add column transtype text;
alter table gl add column transno text;
alter table gl add column subtransno text;

alter table defaults add adnumber text;

create table adjust(
	id int default nextval('id'),
	adnumber text,
	transdate date,
	employee_id int,
	notes text

);
alter table adjust add column type varchar(255);

create table adjustitems(
	trans_id int,
	parts_id int,
	description text,
	qty float,
	sellprice float,
	discount float,
	unit varchar(5)
);
alter table adjustitems add column lastcost float;

alter table defaults add debitnumber text;
alter table defaults add debitnumbercus text;

CREATE TABLE debitnote (
  id int default nextval('id'),
  ordnumber text,
  transdate date default current_date,
  vendor_id int,
  customer_id int,
  amount float8,
  netamount float8,
  reqdate date,
  taxincluded bool,
  shippingpoint text,
  notes text,
  invoice boolean,
  invnumber text,
  curr char(3),
  employee_id int
);
--
CREATE TABLE debititems (
  trans_id int,
  parts_id int,
  description text,
  qty float4,
  sellprice float8,
  discount float4,
  unit varchar(5)
);

alter table defaults add creditnumber text;
alter table defaults add creditnumbercus text;

CREATE TABLE creditnote (
  id int default nextval('id'),
  ordnumber text,
  transdate date default current_date,
  vendor_id int,
  customer_id int,
  amount float8,
  netamount float8,
  reqdate date,
  taxincluded bool,
  shippingpoint text,
  notes text,
  curr char(3),
  invoice boolean,
  invnumber text,
  employee_id int
);
--
CREATE TABLE credititems (
  trans_id int,
  parts_id int,
  description text,
  qty float4,
  sellprice float8,
  discount float4,
  unit varchar(5)
);





alter table defaults add orid text;

CREATE TABLE oreceipt (
  id int default nextval('id'),
  source text,
  chart_id int,
  ar_chart_id int,
  employee_id int,
  orid text,
  amount float8,
  transdate date

);




CREATE TABLE oreceipt_items (
  trans_id int,
  ar_chart_id int
);

alter table oreceipt_items add column status text;

--2003-06-30
alter table oreceipt add column customernumber varchar(255);
alter table oreceipt add column curr varchar(3);
alter table oreceipt add column exchangerate float4;
alter table oreceipt add column batch varchar(50);
alter table oreceipt add column transtype text;
alter table oreceipt add column transno text;
alter table oreceipt add column subtransno text;
alter table oreceipt_items add column due float4;
alter table oreceipt_items add column amount float4;

create view receipt as
select trans_id,customer_id,customer.name,invnumber,ar.transdate,acc_trans.transdate as paydate,source,
chart_id,chart.accno, chart.description,acc_trans.amount*-1 as amount
from ar ,acc_trans,chart where ar.id=acc_trans.trans_id
and chart.id=chart_id and chart.link like '%AP_paid%'
and customer.id=customer_id;


alter table orderitems add column delivery_date text;
alter table invoice add column delivery_date text;

alter table ar add column batch varchar(50);
alter table ar add column project varchar(50);
alter table ar add column subb varchar(50);
alter table ar add column transtype text;
alter table ar add column transno text;
alter table ar add column subtransno text;
alter table ar add column rowcount int;

alter table ap add column batch varchar(50);
alter table ap add column project varchar(50);
alter table ap add column subb varchar(50);
alter table ap add column transtype text;
alter table ap add column transno text;
alter table ap add column subtransno text;
alter table ap add column rowcount int;

alter table debitnote add column batch varchar(50);
alter table debitnote add column project varchar(50);
alter table debitnote add column subb varchar(50);
alter table debitnote add column transtype text;
alter table debitnote add column transno text;
alter table debitnote add column subtransno text;

alter table creditnote add column batch varchar(50);
alter table creditnote add column project varchar(50);
alter table creditnote add column subb varchar(50);
alter table creditnote add column transtype text;
alter table creditnote add column transno text;
alter table creditnote add column subtransno text;




create table gp(
	id int default nextval('id'),
	transtype text,
	batch text,
	type int,
	chart_id int,
	employee_id int
);

create table gp_trans(
	id int ,
	transno text,
	subtransno text,
	chart_id int,
	amount float8,
	description text,
	source text,
	transdate date

);


create table ou(
	id int default nextval('id'),
	transtype text,
	batch text,
	employee_id int
);

create table ou_trans(
	id int ,
	transno text,
	subtransno text,
	chart_id int,
	amount float8,

	description text,
	source text,
	transdate date
);

alter table gp_trans add column sub text;
alter table gp_trans add column proj text;
alter table ou_trans add column sub text;


alter table vendor add column vendorcode text;
alter table customer add column customercode text;

alter table defaults add column fy text;
--2002-05-27
alter table invoice add column lastcost float;
alter table parts add column  avgcost float ;


----for meiban
alter table invoice add remark2 text;
alter table orderitems add remark2 text;

insert into chart (accno,description,charttype,category,link) values ('9000','Debtors','H','D','');
insert into customer (name,customernumber) values ('CASH','9001');
insert into chart (id,accno,description,charttype,category,link) values ((select id from customer where customernumber='9001'),'9001','CASH','A','D','AR');

insert into chart (accno,description,charttype,category,link) values ('8000','Creditors','H','C','');
insert into vendor (name,vendornumber) values ('CASH','8001');
insert into chart (id,accno,description,charttype,category,link) values ((select id from vendor where vendornumber='8001'),'8001','CASH','A','C','AP');

alter table invoice add column part_ordnumber text;
alter table ar add column invoiceto text;
--smdjb
alter table ar add column member text;
alter table ar add column kp text;

--for max
alter table ap add column desc_1 text;
alter table ap add column desc_2 text;
alter table ap add column desc_3 text;
alter table ap add column desc_4 text;
alter table ap add column desc_5 text;

alter table ap add column qty_1 float;
alter table ap add column qty_2 float;
alter table ap add column qty_3 float;
alter table ap add column qty_4 float;
alter table ap add column qty_5 float;

alter table ap add column amount_1 float;
alter table ap add column amount_2 float;
alter table ap add column amount_3 float;
alter table ap add column amount_4 float;
alter table ap add column amount_5 float;
--end for max



create view invoice_listing1 as
SELECT ar.project,ar.subb,ar.id, ar.invnumber, ar.transdate, parts.partnumber, invoice.description, invoice.qty, invoice.fxsellprice AS price, (invoice.qty * invoice.fxsellprice) AS subtotal, invoice.parts_id, ar.customer_id, ar.employee_id, customernumber, customer.name, employee.login, parts.weight,delivery_date,remark2, parts.onhand,invoice.part_ordnumber as ordnumber FROM invoice, ar, parts, customer WHERE ((((invoice.trans_id = ar.id) AND (invoice.parts_id = parts.id)) AND (ar.customer_id = customer.id)) AND (ar.employee_id = employee.id)) ORDER BY ar.invnumber;

create view invoice_listing2 as
SELECT DISTINCT ON (acc_trans.trans_id) acc_trans.chart_id, chart.accno, acc_trans.trans_id FROM acc_trans, chart WHERE (((acc_trans.amount > 0) AND (chart.id = acc_trans.chart_id)) AND (chart.link = 'AR'::text)) ORDER BY acc_trans.trans_id;


create view invoice_listing as
SELECT v1.project,v1.subb,v1.id, v1.invnumber, v1.ordnumber,delivery_date,remark2, v1.transdate, v1.partnumber, v1.description, v1.qty, v1.price, v1.subtotal AS subtotal1, v1.parts_id, v1.customer_id, v1.employee_id, v1.customernumber as accno , v1.name AS customer, v1.login, v1.weight, (v1.weight * v1.onhand) AS qtykg, v2.chart_id,  v2.trans_id FROM (invoice_listing1 v1 LEFT JOIN (SELECT invoice_listing2.chart_id, invoice_listing2.accno, invoice_listing2.trans_id FROM invoice_listing2) v2 ON ((v1.id = v2.trans_id)));



create view vendor_listing1 as
SELECT ap.project,ap.subb, ap.id, ap.invnumber, ap.transdate, parts.partnumber, invoice.description, invoice.qty, invoice.fxsellprice AS price, (invoice.qty * invoice.fxsellprice) AS subtotal, invoice.parts_id, ap.vendor_id, ap.employee_id, vendornumber, vendor.name, employee.login, parts.weight, parts.onhand , part_ordnumber as ordnumber,delivery_date,remark2 FROM invoice, ap, parts, vendor WHERE ((((invoice.trans_id = ap.id) AND (invoice.parts_id = parts.id)) AND (ap.vendor_id = vendor.id)) AND (ap.employee_id = employee.id)) ORDER BY ap.invnumber;

create view vendor_listing2 as
SELECT DISTINCT ON (acc_trans.trans_id) acc_trans.chart_id, chart.accno, acc_trans.trans_id FROM acc_trans, chart WHERE (((acc_trans.amount > 0) AND (chart.id = acc_trans.chart_id)) AND (chart.link = 'AP'::text)) ORDER BY acc_trans.trans_id;


create view vendor_listing as
SELECT v1.project,v1.subb, v1.id, v1.invnumber, v1.ordnumber ,v1.transdate, v1.partnumber, v1.description, v1.qty, v1.price, v1.subtotal AS subtotal1, v1.parts_id, v1.vendor_id, v1.employee_id,v1.vendornumber as accno , v1.name AS customer, v1.login, v1.weight, (v1.weight * v1.onhand) AS qtykg, v2.chart_id,  v2.trans_id,delivery_date,remark2 FROM (vendor_listing1 v1 LEFT JOIN (SELECT vendor_listing2.chart_id, vendor_listing2.accno, vendor_listing2.trans_id FROM vendor_listing2) v2 ON ((v1.id = v2.trans_id)));



create view sales_listing1 as
SELECT oe.id,delivery_date,remark2, oe.ordnumber, oe.transdate, parts.partnumber, orderitems.description, orderitems.qty, orderitems.sellprice AS price, (orderitems.qty * orderitems.sellprice) AS subtotal, orderitems.parts_id, oe.customer_id, oe.employee_id, customernumber, customer.name, employee.login, parts.weight, parts.onhand FROM orderitems, oe, parts, customer WHERE ((((orderitems.trans_id = oe.id) AND (orderitems.parts_id = parts.id)) AND (oe.customer_id = customer.id)) AND (oe.employee_id = employee.id)) ORDER BY oe.ordnumber;

create view sales_listing2 as
SELECT DISTINCT ON (acc_trans.trans_id) acc_trans.chart_id, chart.accno, acc_trans.trans_id FROM acc_trans, chart WHERE (((acc_trans.amount > 0) AND (chart.id = acc_trans.chart_id)) AND (chart.link = 'AR'::text)) ORDER BY acc_trans.trans_id;


create view sales_listing as
SELECT v1.id,delivery_date,remark2, v1.ordnumber as invnumber, v1.transdate, v1.partnumber, v1.description, v1.qty, v1.price, v1.subtotal AS subtotal1, v1.parts_id, v1.customer_id, v1.employee_id, v1.customernumber as accno, v1.name AS customer, v1.login, v1.weight, (v1.weight * v1.onhand) AS qtykg, v2.chart_id,  v2.trans_id FROM (sales_listing1 v1 LEFT JOIN (SELECT sales_listing2.chart_id, sales_listing2.accno, sales_listing2.trans_id FROM sales_listing2) v2 ON ((v1.id = v2.trans_id)));




create view purchase_listing1 as
SELECT oe.id,delivery_date,remark2, oe.ordnumber, oe.transdate, parts.partnumber, orderitems.description, orderitems.qty, orderitems.sellprice AS price, (orderitems.qty * orderitems.sellprice) AS subtotal, orderitems.parts_id, oe.vendor_id, oe.employee_id, vendornumber, vendor.name, employee.login, parts.weight, parts.onhand FROM orderitems, oe, parts, vendor WHERE ((((orderitems.trans_id = oe.id) AND (orderitems.parts_id = parts.id)) AND (oe.vendor_id = vendor.id)) AND (oe.employee_id = employee.id)) ORDER BY oe.ordnumber;

create view purchase_listing2 as
SELECT DISTINCT ON (acc_trans.trans_id) acc_trans.chart_id, chart.accno, acc_trans.trans_id FROM acc_trans, chart WHERE (((acc_trans.amount > 0) AND (chart.id = acc_trans.chart_id)) AND (chart.link = 'AR'::text)) ORDER BY acc_trans.trans_id;


create view purchase_listing as
SELECT v1.id,delivery_date,remark2, v1.ordnumber as invnumber, v1.transdate, v1.partnumber, v1.description, v1.qty, v1.price, v1.subtotal AS subtotal1, v1.parts_id, v1.vendor_id as customer_id, v1.employee_id, v1.vendornumber, v1.name AS customer, v1.login, v1.weight, (v1.weight * v1.onhand) AS qtykg, v2.chart_id, v2.accno, v2.trans_id FROM (purchase_listing1 v1 LEFT JOIN (SELECT purchase_listing2.chart_id, purchase_listing2.accno, purchase_listing2.trans_id FROM purchase_listing2) v2 ON ((v1.id = v2.trans_id)));


--2003-07-13
alter table defaults add pyid text;

CREATE TABLE payment (
  id int default nextval('id'),
  source text,
  chart_id int,
  ap_chart_id int,
  employee_id int,
  pyid text,
  amount float8,
  transdate date

);


CREATE TABLE payment_items (
  trans_id int,
  ap_chart_id int
);

alter table payment_items add column status text;

alter table payment add column vendornumber varchar(255);
alter table payment add column curr varchar(3);
alter table payment add column exchangerate float4;
alter table payment add column batch varchar(50);
alter table payment add column transtype text;
alter table payment add column transno text;
alter table payment add column subtransno text;
alter table payment_items add column due float4;
alter table payment_items add column amount float4;

create view payment1 as
select trans_id,vendor_id,vendor.name,invnumber,ap.transdate,acc_trans.transdate as paydate,source,
chart_id,chart.accno, chart.description,acc_trans.amount*-1 as amount
from ap ,acc_trans,chart where ap.id=acc_trans.trans_id
and chart.id=chart_id and chart.link like '%AP_paid%'
and vendor.id=vendor_id;

---2003-08-28---stock ledger
create view sl as
 select 'adjust.pl' as module,adnumber,transdate,parts_id,partnumber,adjustitems.description,0 as sin,0 as sout,qty as adjust, adjustitems.lastcost from adjust, adjustitems,parts where adjust.id=adjustitems.trans_id and parts.id=adjustitems.parts_id
 union all
 select  'is.pl' as module,invnumber,transdate,parts_id,partnumber,invoice.description,0,qty,0,invoice.sellprice from ar, invoice,parts where ar.id=invoice.trans_id and parts.id=invoice.parts_id
 union all
 select  'ir.pl' as module,invnumber,transdate,parts_id,partnumber,invoice.description,qty*-1,0,0,invoice.sellprice from ap, invoice,parts where ap.id=invoice.trans_id and parts.id=invoice.parts_id
 union all
 
 select  'creditnote.pl' as module,ordnumber,transdate,parts_id,partnumber,credititems.description,qty,0,0,credititems.sellprice from creditnote, credititems,parts where creditnote.id=credititems.trans_id and parts.id=credititems.parts_id and vendor_id = 0
 union all
 select  'creditnote.pl' as module,ordnumber,transdate,parts_id,partnumber,credititems.description,0,qty,0,credititems.sellprice from creditnote, credititems,parts where creditnote.id=credititems.trans_id and parts.id=credititems.parts_id and customer_id = 0

 ;
 
 alter table vendor add column debitlimit float;
 
 --2003-12-14
 alter table creditnote add column salesperson text;
 alter table debitnote add column salesperson text;


--upgrade 2004-05-24
alter table oe add column yourref text;
alter table oe add column status int;



alter table parts add column combo boolean;

CREATE TABLE combo (
  id int,
  parts_id int

);

alter table gp add column transdate date; 
alter table parts add column taxincluded boolean;
alter table invoice add column taxincluded boolean;
alter table orderitems add column taxincluded boolean;
alter table invoice add column tax float;
alter table orderitems add column tax float;
alter table gp add column project varchar(255);
alter table gp add column sub varchar(255);
alter table ou add column project varchar(255);
alter table ou add column sub varchar(255);
alter table acc_trans add column project varchar(255);
alter table acc_trans add column sub varchar(255);

create view statement2 as
SELECT gl.id, 'gl' AS type, FALSE AS invoice, gl.source,
gl.description, acc_trans.transdate,
acc_trans.amount, chart.accno, chart.description as accdesc,chart.id as chart_id,chart.gifi_accno, transtype, batch,transno,subtransno,acc_trans.project, acc_trans.sub
FROM gl, acc_trans, chart
WHERE 1 = 1
AND acc_trans.chart_id = chart.id
AND gl.id = acc_trans.trans_id
UNION ALL
SELECT ar.id, 'ar' AS type, ar.invoice, ar.invnumber,
ar.notes, acc_trans.transdate,
acc_trans.amount, chart.accno, chart.description as accdesc,chart.id as chart_id,chart.gifi_accno, transtype, batch,transno,subtransno,acc_trans.project, acc_trans.sub
FROM ar, acc_trans, chart, customer
WHERE 1 = 1
AND acc_trans.chart_id = chart.id
AND ar.customer_id = customer.id
AND ar.id = acc_trans.trans_id
UNION ALL
SELECT ap.id, 'ap' AS type, ap.invoice, ap.invnumber,
ap.notes, acc_trans.transdate,
acc_trans.amount, chart.accno, chart.description as accdesc,chart.id as chart_id,chart.gifi_accno,transtype, batch,transno,subtransno,acc_trans.project, acc_trans.sub
FROM ap, acc_trans, chart, vendor
WHERE 1 = 1
AND acc_trans.chart_id = chart.id
AND ap.vendor_id = vendor.id
AND ap.id = acc_trans.trans_id
UNION ALL
SELECT gp.id, 'gp' AS type, FALSE, gp_trans.source,
gp_trans.description as desc, gp_trans.transdate,
gp_trans.amount, chart.accno, chart.description as accdesc,chart.id as chart_id,chart.gifi_accno,transtype, batch,transno,subtransno,gp.project, gp.sub
FROM gp, chart, gp_trans
WHERE 1 = 1
AND gp_trans.chart_id = chart.id

AND gp.id = gp_trans.id
UNION ALL
SELECT ou.id, 'ou' AS type, FALSE, ou_trans.source,
ou_trans.description as desc, ou_trans.transdate,
ou_trans.amount, chart.accno, chart.description as accdesc,chart.id as chart_id,chart.gifi_accno,transtype, batch,transno,subtransno,ou.project, ou.sub
FROM ou, chart, ou_trans
WHERE 1 = 1
AND ou_trans.chart_id = chart.id

AND ou.id = ou_trans.id
UNION ALL
SELECT ar.id, 'dn' AS type, ar.invoice, ar.ordnumber,
customer.name, acc_trans.transdate,
acc_trans.amount, chart.accno, chart.description as accdesc,chart.id as chart_id,chart.gifi_accno, transtype, batch,transno,subtransno,acc_trans.project, acc_trans.sub
FROM debitnote ar, acc_trans, chart, customer
WHERE 1 = 1
AND acc_trans.chart_id = chart.id
AND ar.customer_id = customer.id
AND ar.id = acc_trans.trans_id
UNION ALL
SELECT ap.id, 'dn1' AS type, ap.invoice, ap.ordnumber,
vendor.name, acc_trans.transdate,
acc_trans.amount, chart.accno, chart.description as accdesc,chart.id as chart_id,chart.gifi_accno,transtype, batch,transno,subtransno,acc_trans.project, acc_trans.sub
FROM debitnote ap, acc_trans, chart, vendor
WHERE 1 = 1
AND acc_trans.chart_id = chart.id
AND ap.vendor_id = vendor.id
AND ap.id = acc_trans.trans_id
UNION ALL
SELECT ar.id, 'cn' AS type, ar.invoice, ar.ordnumber,
ar.notes, acc_trans.transdate,
acc_trans.amount, chart.accno, chart.description as accdesc,chart.id as chart_id,chart.gifi_accno, transtype, batch,transno,subtransno,acc_trans.project, acc_trans.sub
FROM creditnote ar, acc_trans, chart, customer
WHERE 1 = 1
AND acc_trans.chart_id = chart.id
AND ar.customer_id = customer.id
AND ar.id = acc_trans.trans_id
UNION ALL
SELECT ap.id, 'cn1' AS type, ap.invoice, ap.ordnumber,
ap.notes, acc_trans.transdate,
acc_trans.amount, chart.accno, chart.description as accdesc,chart.id as chart_id,chart.gifi_accno,transtype, batch,transno,subtransno,acc_trans.project, acc_trans.sub
FROM creditnote ap, acc_trans, chart, vendor
WHERE 1 = 1
AND acc_trans.chart_id = chart.id
AND ap.vendor_id = vendor.id
AND ap.id = acc_trans.trans_id


ORDER BY transdate, transtype, batch, transno, subtransno,  accno, accdesc, project, sub
;

INSERT INTO defaults (version) VALUES ('3.0.0');

