
#=====================================================================
# SQL-Ledger Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Genereal Ledger
#
#======================================================================

$form->{rowcount}=30;

use SL::statement;
use SL::IS;
use SL::IR;
1;
# end of main


# this is for our long dates
# $locale->text('January')
# $locale->text('February')
# $locale->text('March')
# $locale->text('April')
# $locale->text('May ')
# $locale->text('June')
# $locale->text('July')
# $locale->text('August')
# $locale->text('September')
# $locale->text('October')
# $locale->text('November')
# $locale->text('December')

# this is for our short month
# $locale->text('Jan')
# $locale->text('Feb')
# $locale->text('Mar')
# $locale->text('Apr')
# $locale->text('May')
# $locale->text('Jun')
# $locale->text('Jul')
# $locale->text('Aug')
# $locale->text('Sep')
# $locale->text('Oct')
# $locale->text('Nov')
# $locale->text('Dec')


sub generate_report {
     $pagenum=1;
  
  $form->header;
print qq|  
<body bgcolor=ffffff>


|;
  ($customerno, $form->{AR1}) = split(/--/, $form->{AR});
  	   @columns = $form->sort_columns(qw( transtype transdate source  description   debit credit balance ));
	
	  $href = "$callback&sort=$form->{sort}";        # needed for accno
	 # $callback += "&sort=$form->{sort}";        # needed for accno
	
	  foreach $item (@columns) {
	    if ($form->{"l_$item"} eq "Y") {
	      push @column_index, $item;
	
	      # add column to href and callback
	      $callback .= "&l_$item=Y";
	      $href .= "&l_$item=Y";
	    }
	  }
	
	  if ($form->{l_subtotal} eq 'Y') {
	    $callback .= "&l_subtotal=Y";
	    $href .= "&l_subtotal=Y";
	  }
	
	  $callback .= "&category=$form->{category}";
	  $href .= "&category=$form->{category}";
      
	  if(!$form->{AR1} && $form->{AR}){

	  $form->all_vc(\%myconfig, "customer");
	
	  $selection = "";
	
	  foreach $ref (@{ $form->{all_customer} }) {
	    $selection .= "$ref->{customernumber}--$ref->{name}\n";
	  }
	  
	  
  

      foreach $item (split /\n/, $selection) {
	$form->{AR}=$item;
		     $r=0;
	     &generate_report_all;
	     print '<p style="page-break-before: always">&nbsp;</p>';
	     delete $form->{report};
	     delete $form->{report2};
	     delete $form->{statement};
      }
      
      }else{
	&generate_report_all;
	      
      }
      
print qq|  
</body>
</html>
|;	
}

sub generate_report_2 {
		     $pagenum=1;
  $form->header;
print qq|  
<body bgcolor=ffffff>


|;

  ($customerno, $form->{AR1}) = split(/--/, $form->{AR});
  
	   @columns = $form->sort_columns(qw( transtype transdate source  description   debit credit balance ));
	
	  $href = "$callback&sort=$form->{sort}";        # needed for accno
	 # $callback += "&sort=$form->{sort}";        # needed for accno
	
	  foreach $item (@columns) {
	    if ($form->{"l_$item"} eq "Y") {
	      push @column_index, $item;
	
	      # add column to href and callback
	      $callback .= "&l_$item=Y";
	      $href .= "&l_$item=Y";
	    }
	  }
	
	  if ($form->{l_subtotal} eq 'Y') {
	    $callback .= "&l_subtotal=Y";
	    $href .= "&l_subtotal=Y";
	  }
	
	  $callback .= "&category=$form->{category}";
	  $href .= "&category=$form->{category}";

	  
	 	  $form->{stype}=1;
	 
      if(!$form->{AR1} && $form->{AR} ){

	  $form->all_vc(\%myconfig, "customer");
	
	  $selection = "";
	
	  foreach $ref (@{ $form->{all_customer} }) {
	    $selection .= "$ref->{customernumber}--$ref->{name}\n";
	  }
	  
	  
  

	      foreach $item (split /\n/, $selection) {
		$form->{AR}=$item;
		     $r=0;
		     &generate_report_all;
		     
		     delete $form->{report};
		     delete $form->{report2};
		     delete $form->{statement};

	      }
      
      }else{
	&generate_report_all;
	      
      }

print qq|  
</body>
</html>
|;
	
}

sub generate_report_all {
  map { $form->{$_} = $myconfig{$_} } (qw(company address businessnumber nativecurr));
  $form->{address} =~ s/\\n/<br>/g;
   $line = "<hr size=3 noshade>";
   statement->all_transactions(\%myconfig, \%$form);
 
  statement->all_transactions2(\%myconfig, \%$form);

  $callback = "$form->{script}?action=generate_report&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";


  $form->{title} = $locale->text('Statement of Account As At ');




 if ($form->{AR}) {
  ($customerno, $form->{AR1}) = split(/--/, $form->{AR});
 $customer = $form->{AR};
 $customer =~ s/ /%20/g;
  $customer=~ s/"/&quot;/g;
  $callback .= "&AP=$customer";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Customer :')." ".$form->{AR};
    
  $form->{AR}=$customerno;
     IS->get_customerid(\%myconfig, \%$form);
  $form->{customer_id}=$form->{customer_id2};

     IS->customer_details(\%myconfig, \%$form);

    
    $customertext=" ".$form->{AR1}."<br>".$form->{addr1}."<br>".$form->{addr2}."<br>".$form->{addr3}."<br>".$form->{addr4};;
    $accounttext=$locale->text('A/C :')." ".$customerno;
    $datetext=$locale->text('Date :')." ".$form->{date};
  }
  
   if ($form->{AP}) {
  ($customerno, $form->{AP1}) = split(/--/, $form->{AP});
  $customer = $form->{AP};
  $customer =~ s/ /%20/g;
  $customer=~ s/"/&quot;/g;
  $callback .= "&AP=$customer";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Customer :')." ".$form->{AP};
    $customertext=" ".$form->{AP1};
    $accounttext=$locale->text('A/C :')." ".$customerno;
    $datetext=$locale->text('Date :')." ".$form->{date};
  }
  
  if ($form->{transdate}) {
    $callback .= "&transdate=$form->{transdate}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Date as at :')." ".$form->{transdate};
  }


 
  $column_header{transdate} = "<th><font ><hr noshade size=2>".$locale->text('Date')."<hr noshade size=2></th>";
  $column_header{transtype} = "<th><font ><hr noshade size=2>".$locale->text('Trans.')."<hr noshade size=2></th>";
  $column_header{description} = "<th><font ><hr noshade size=2>".$locale->text('Description')."<hr noshade size=2></th>";
  $column_header{source} = "<th><font ><hr noshade size=2>".$locale->text('Source.')."<hr noshade size=2></th>";
  $column_header{debit} = "<th><font ><hr noshade size=2>".$locale->text('Debit')."<hr noshade size=2></th>";
  $column_header{credit} = "<th><font ><hr noshade size=2>".$locale->text('Credit')."<hr noshade size=2></th>";
  $column_header{balance} = "<th><font ><hr noshade size=2>".$locale->text('Balance')."<hr noshade size=2></th>";

  $colspan = $#column_index + 1;


  print  qq|
<table border=0 WIDTH=100%  height=650>
<tr><td valign=top>
<table border=0 WIDTH=100% >
<tr><th  colspan=$colspan><h2>$form->{company}<br>$form->{address}</h1></th></tr>


<tr><td colspan=$colspan valign=top>
<table border=0 WIDTH=100%>
<tr><td width=70%>
	<table border=0 WIDTH=100%>
	<tr>
		<td align=left >$customertext</td>
	</tr>
	</table>
</td><td>
	<table border=0 WIDTH=100%>
	<tr>	
		<td align=left >$accounttext	</td>
	</td>
	<tr>
		<td align=left>$datetext</td>
	</tr>
	<tr>
			<td align=left>Page : $pagenum</td>
	</tr>
	</table>
</td>
</tr>
</table>
	<tr><th  colspan=$colspan><h1>$form->{title} $form->{date}</h1></th></tr>

<tr >
<td colspan=$colspan>
<table width=100% border=0>
<tr>
|;

map { print  "$column_header{$_}\n" } @column_index;

print  "</tr>";

  # add sort to callback
  $callback = $form->escape($callback . "&sort=$form->{sort}");

  # initial item for subtotals
  if (@{ $form->{report} }) {
    $sameitem = $form->{report}->[0]->{$form->{sort}};
#    print  "$sameitem<br>";
 }
    $balance=0;
    $obal = 0;
    $debit=0;
    $credit=0;

 &form_row(\%myconfig, \%$form,"report");
 
 if($form->{l_post}){
		   print  qq|
		   <tr><td></td><td colspan=4><b>Post Dated Statement<hr noshade></td></tr>
		<td></td><td colspan=4><table border=0 width=100%><tr>|;
		  statement->all_transactions3(\%myconfig, \%$form);

		 &form_row2(\%myconfig, \%$form,"report2");
		 
		
		  print  qq|</tr>
		 </table></td>
		 <P>
		|;
 }
 
  &gl_subtotal if ($form->{l_subtotal} eq 'Y');

  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;

   if ( $balance eq 0){
    			$column_data{balance} = "<th align=right><hr noshade size=2>0.00<hr noshade size=2></th>";

    }else{		  $column_data{balance} = "<th align=right><hr noshade size=2>".$form->format_amount(\%myconfig, $balance, 2, "&nbsp;")."<hr noshade size=2></th>";


    }
 # $column_data{debit} = "<th align=right><hr noshade size=2>".$form->format_amount(\%myconfig, $debit, 2, "&nbsp;")."<hr noshade size=2></th>";
#  $column_data{credit} = "<th align=right><hr noshade size=2>".$form->format_amount(\%myconfig, $credit, 2, "&nbsp;")."<hr noshade size=2></th>";

  print  qq|
<tr>|;

  map { print  "$column_data{$_}\n" } @column_index;

  print  qq|</tr>
  </table>
   </td>
   </tr>

 </table>
    </td>
   </tr>

 </table>

 </td>
 </tr>
 </table>
|;

$statement2="";
$statement3="";
$total=0;
  foreach $ref (@{ $form->{statement} }) {
   $ref->{amount}*=-1;
		#$a{$ref->{month}} = $ref->{amount};
		$statement2.="<TD ><FONT><B>$ref->{month}/$ref->{year}</B><br><hr noshade size=2></FONT></TD>";
		$statement3.="<TD >".$form->format_amount(\%myconfig, $ref->{amount}, 2, "0.00")."</TD>";
		$total+=$ref->{amount};
  }
  $lastamount=$form->{lastamount}*-1;
  $total+=$lastamount;
  print qq|

  <p><b>Analysis of Outstanding Balances:</b></p>
<TABLE  BORDER=0 CELLPADDING=1 CELLSPACING=1 WIDTH=100%>

	<TR VALIGN=TOP >
		$statement2 <TD ><FONT><B> 4 month++</B><br><hr noshade size=2></FONT></TD><TD ><FONT><B> Total</B><br><hr noshade size=2></FONT></TD>
	</TR>
	<TR VALIGN=TOP >
		$statement3 <TD> |.$form->format_amount(\%myconfig, $lastamount, 2, "0.00").qq|</TD><TD> |.$form->format_amount(\%myconfig, $total, 2, "0.00").qq|</TD>
	</TR>

</TABLE>



|;
}

sub form_row{
	  my ( $myconfig, $form,$report) = @_;
  foreach $ref (@{ $form->{"$report"} }) {

    # if item ne sort print subtotal
    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ref->{$form->{sort}}) {
	&gl_subtotal;
    #print  "$sameitem<br>";
       }
    }

    $subtotalcredit += $ref->{subtotal1};

    $totalcredit += $ref->{subtotal1};

    $ref->{subtotal1} = $form->format_amount(\%myconfig, $ref->{subtotal1}, 2, "&nbsp;");
    


  # if (($form->{transdate})) {
   #	if( ($ref->{month} eq $form->{month})) {
	   if($ref->{amount} > 0){
		   $ref->{credit}=$ref->{amount};
	   }else{
		   $ref->{debit}=$ref->{amount}*-1;
	   }
		$column_data{transdate} = "<td>$ref->{transdate}</td>";
		$column_data{transtype} = "<td> $ref->{transtype}-$ref->{batch}-$ref->{transno}$ref->{subtransno}</td>";
		$column_data{description} = "<td> $ref->{description}</td>";
		$column_data{source} = "<td>$text $ref->{source}</td>";
#		$column_data{refnumber} = "<td><a href=ic.pl?action=edit&id=$ref->{refnumber}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{refnumber}</a></td>";

  		$ref->{debit1} = $form->format_amount(\%myconfig, $ref->{debit}, 2, "&nbsp;");
  		$ref->{credit1} = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");

		$column_data{debit} = "<td align=right>$ref->{debit1}</td>";
		$column_data{credit} = "<td align=right>$ref->{credit1}</td>";
		$balance += $ref->{debit} ;
		$balance -= $ref->{credit};
		$debit +=$ref->{debit};
		$credit +=$ref->{credit};

  		$balance1 = $form->format_amount(\%myconfig, $balance, 2, "&nbsp;");
    		if ( $balance eq 0){
    			$column_data{balance} = "<td align=right>0.00</td>";

    		}else{		$column_data{balance} = "<td align=right>$balance1</td>";

    		}
		$i++; $i %= 2;$r++;
		print  "<tr >";
		map { print "$column_data{$_}\n" } @column_index;
		print  "</tr>";

	
	#page break

if($form->{rowcount} && $form->{print} && $form->{rowcount} <= $r){

$pagenum++;
    print "<tr $listrow$i onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow$i';\"  >";

    $bal1 = $form->format_amount(\%myconfig, $balance, 2, "0.00");
	
	  map { $column_data{$_} = "<td $listprint >$line&nbsp;</td>" } @column_index;
     $column_data{description} = "<td $listprint >$line SubTotal C/F for Page $pagenum</td>";
    $column_data{balance} = "<td  $listprint align=right>$line $bal1</td>";
#    $column_data{qty} = "<td  $listprint align=right>$line $pagetotaldebit</td>";
 #   $column_data{subtotal1} = "<td  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalcredit, 2, "&nbsp;") . "</td>";
     map { print "\n$column_data{$_}" } @column_index;

     print qq|
     </tr>
  </table>
  </td>
  </tr>

  
  </table>
  </td>
  </tr>

  
  </table>	 
  
    </td>
  </tr>

  
  </table>
  
  <p style="page-break-after: always">&nbsp;</p>

<H1  $listprint align=center >$form->{company}<br>$form->{address}</h1>
<table  $listprint border=0 width=100%  height=650>
<tr><td valign=top>
<table  $listprint border=0 width=100%>
<tr><td colspan=$colspan valign=top>
<table border=0 WIDTH=100%>
<tr><td width=70%>
	<table border=0 WIDTH=100%>
	<tr>
		<td align=left >$customertext</td>
	</tr>
	</table>
</td><td>
	<table border=0 WIDTH=100%>
	<tr>	
		<td align=left >$accounttext	</td>
	</td>
	<tr>
		<td align=left>$datetext</td>
	</tr>
	<tr>
			<td align=left>Page : $pagenum</td>
	</tr>
	</table>
</td>
</tr>
<tr  >
<td valign=top colspan=$colspan>
<table width=100%   border=0>
<tr>

<tr><th  colspan=$colspan><h1>$form->{title} $form->{date}</h1></th></tr>

|;
map { print  "$column_header{$_}\n" } @column_index;




print qq|
</tr><tr>
|;


 	  map { $column_data{$_} = "<td $listprint >&nbsp;</td>" } @column_index;
     $column_data{description} = "<td $listprint >**Subtotal B/F for Page $pagenum </td>";
     $column_data{balance} = "<td  $listprint align=right> $bal1</td>";
   # $column_data{qty} = "<td  $listprint align=right> $pagetotaldebit </td>";
   # $column_data{subtotal1} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotalcredit, 2, "&nbsp;") . "</td>";
    map { print "\n$column_data{$_}" } @column_index;
print qq|
</tr>
|;
$r=0;

}


  }

}

sub form_row2{
	  my ( $myconfig, $form,$report) = @_;
  foreach $ref (@{ $form->{"$report"} }) {

    # if item ne sort print subtotal
    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ref->{$form->{sort}}) {
	&gl_subtotal;
    #print  "$sameitem<br>";
       }
    }

    $subtotalcredit += $ref->{subtotal1};

    $totalcredit += $ref->{subtotal1};

    $ref->{subtotal1} = $form->format_amount(\%myconfig, $ref->{subtotal1}, 2, "&nbsp;");
    

  @column_index = $form->sort_columns(qw(  transdate source  description   debit  ));

  # if (($form->{transdate})) {
   #	if( ($ref->{month} eq $form->{month})) {
	 #  if($ref->{amount} > 0){
	#	   $ref->{credit}=$ref->{amount};
	 #  }else{
	#	   $ref->{debit}=$ref->{amount}*-1;
	 #  }
		$column_data{transdate} = "<td>$ref->{transdate}</td>";
		$column_data{transtype} = "<td> $ref->{transtype}-$ref->{batch}-$ref->{transno}$ref->{subtransno}</td>";
		$column_data{description} = "<td> $ref->{description}</td>";
		$column_data{source} = "<td>$text $ref->{source}</td>";
#		$column_data{refnumber} = "<td><a href=ic.pl?action=edit&id=$ref->{refnumber}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{refnumber}</a></td>";

  		$ref->{debit1} = $form->format_amount(\%myconfig, $ref->{debit}, 2, "&nbsp;");
  		$ref->{credit1} = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");

		$column_data{debit} = "<td align=right>$ref->{amount}</td>";
	#	$column_data{credit} = "<td align=right>$ref->{credit1}</td>";
	#	$balance += $ref->{debit} ;
	#	$balance -= $ref->{credit};
	#	$debit +=$ref->{debit};
	#	$credit +=$ref->{credit};

  		#$balance1 = $form->format_amount(\%myconfig, $balance, 2, "&nbsp;");
    		#if ( $balance eq 0){
    		#	$column_data{balance} = "<td align=right>0.00</td>";

    		#}else{		$column_data{balance} = "<td align=right>$balance1</td>";

    		#}
		$i++; $i %= 2;
		print  "<tr >";
		map { print "$column_data{$_}\n" } @column_index;
		print  "</tr>";


  }

}


sub gl_subtotal {

  $subtotaldebit = $form->format_amount(\%myconfig, $subtotaldebit, 2, "&nbsp;");
  $subtotalcredit = $form->format_amount(\%myconfig, $subtotalcredit, 2, "&nbsp;");

  map { $column_data{$_} = "<td>&nbsp;</td>" } qw(transdate number refnumber  );
  #$column_data{qty} = "<th align=right>$subtotaldebit</font></td>";
  $column_data{subtotal1} = "<th align=right>$subtotalcredit</font></td>";
 #$column_data{qtykg} = "<th align=right>$subtotalqtykg</font></td>";


  print "<tr class=listsubtotal bgcolor=333366>";
  map { print "$column_data{$_}\n" } @column_index;
  print "</tr>";

  $subtotaldebit = 0;
  $subtotalcredit = 0;
  $subtotalqtykg=0;
  $sameitem = $ref->{$form->{sort}};

}




sub update_form {

  @a = ();
  $count = 0;
  @flds = (qw(accno debit credit));

  for $i (1 .. $form->{rowcount}) {
    unless (($form->{"debit_$i"} eq "") && ($form->{"credit_$i"} eq "")) {
      # take accno apart
      ($form->{"accno_$i"}) = split(/--/, $form->{"accno_$i"});
      
      push @a, {};
      $j = $#a;
      
      map { $a[$j]->{$_} = $form->{"${_}_$i"} } @flds;
      $count++;
    }
  }

  for $i (1 .. $count) {
    $j = $i - 1;
    map { $form->{"${_}_$i"} = $a[$j]->{$_} } @flds;
  }

  for $i ($count + 1 .. $form->{rowcount}) {
    map { delete $form->{"${_}_$i"} } @flds;
  }

  $form->{rowcount} = $count;

  &display_form;
  
}


sub display_form {

  &form_header;

  $form->{rowcount}++;
  for $i (1 .. $form->{rowcount}) {
    &form_row($i);
  }

  &form_footer;

}



sub form_header {

  $title = $form->{title};
  $form->{title} = $locale->text("$title General Ledger Transaction");

# $locale->text('Add General Ledger Transaction')
# $locale->text('Edit General Ledger Transaction')

  map { $form->{$_} =~ s/"/&quot;/g } qw(source description chart);

  if (($rows = $form->numtextrows($form->{description}, 50)) > 1) {
    $description = qq|<textarea name=description rows=$rows cols=50 wrap=soft>$form->{description}</textarea>|;
  } else {
    $description = qq|<input name=description size=50 value="$form->{description}">|;
  }


  $colspan = 3;


  $form->header;

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>

<input name=id type=hidden value=$form->{id}>

<input name=chart type=hidden value="$form->{chart}">
<input type=hidden name=closedto value=$form->{closedto}>
<input type=hidden name=locked value=$form->{locked}>
<input type=hidden name=title value="$title">

<table border=1>
<tr><th class=listtop bgcolor=000000 colspan=$colspan>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>
<table border=0>
<tr>

  <th align=right>|.$locale->text('Source').qq|</th>
  <td><input name=source value="$form->{source}"></td>
  <th align=right>|.$locale->text('Date').qq| ($myconfig{dateformat})</th>
  <td><input name=transdate size=11 value=$form->{transdate}></td>

</tr>

<tr>
  <th align=right>|.$locale->text('Batch No.').qq|</th>
  <td><input name=batch value="$form->{batch}"></td>
  <th align=right>|.$locale->text('Project No.').qq|</th>
  <td><input name=project value="$form->{project}"></td>
</tr>

<tr>
  <th align=right>|.$locale->text('Sub No.').qq|</th>
  <td><input name=subb value="$form->{subb}"></td>
</tr>

<tr>

  <th align=right>|.$locale->text('Description').qq|</th>
  <td colspan=3><input name=description size=50 value="$form->{description}"></td>

</tr>

</table>
</td></tr>

<tr class=listheading bgcolor=336666>

  <th>|.$locale->text('Account').qq|</th>
  <th>|.$locale->text('Debit').qq|</th>
  <th>|.$locale->text('Credit').qq|</th>

</tr>
|;

}


sub form_footer {

  print qq|

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<input name=callback type=hidden value="$form->{callback}">

</table>

<br>
|;

  $transdate = $form->datetonum($form->{transdate}, \%myconfig);
  $closedto = $form->datetonum($form->{closedto}, \%myconfig);

  if ($form->{id}) {
    print qq|<input class=submit type=submit name=action value="|.$locale->text('Update Form').qq|">
|;

    if (!$form->{revtrans}) {
      if (!$form->{locked}) {
	print qq|
	<input class=submit type=submit name=action value="|.$locale->text('Post Transaction').qq|">
	<input class=submit type=submit name=action value="|.$locale->text('Delete Transaction').qq|">
|;
      }
    }

    if ($transdate > $closedto) {
      print qq|
      <input class=submit type=submit name=action value="|.$locale->text('Post As New Transaction').qq|">
|;
    }

  } else {
    if ($transdate > $closedto) {
      print qq|<input class=submit type=submit name=action value="|.$locale->text('Update Form').qq|">
      <input class=submit type=submit name=action value="|.$locale->text('Post Transaction').qq|">|;
    }
  }

  print "</form>

</body>
</html>
";
  
}
 
sub create_links1 {

  $form->create_links("AP", \%myconfig, "vendor");

  $taxincluded = $form->{taxincluded};

  # build the popup menus

  # currencies
  @curr = split /:/, $form->{currencies};
  chomp $curr[0];
  $form->{defaultcurrency} = $curr[0];

  map { $form->{selectcurrency} .= "<option>$_\n" } @curr;

  # customers
  foreach $ref (@{ $form->{all_vendor} }) {
    if ($ref->{id} == $form->{vendor_id}) {
      $form->{vendor} = "$ref->{name}--$ref->{id}";
      $duedate = $form->{duedate};              # save duedate, we are using IS
      IR->get_vendor(\%myconfig, \%$form);
      $form->{duedate} = $duedate;              # work-around
    }
    $form->{selectvendor} .= "<option>$ref->{name}--$ref->{id}\n";
  }

  # forex
  $form->{forex} = $form->{exchangerate};

  foreach $key (keys %{ $form->{AP_links} }) {

    foreach $ref (@{ $form->{AP_links}{$key} }) {
      if ($key eq 'AP_tax') {
	$form->{"selectAP_tax_$ref->{accno}"} = "<option>$ref->{accno}--$ref->{description}\n";
	next;
      }
      $form->{"select$key"} .= "<option>$ref->{accno}--$ref->{description}\n";
    }

    # if there is a value we have an old entry
    # $i is only used for paid
    for $i (1 .. scalar @{ $form->{acc_trans}{$key} }) {
      if ($key eq "AP_paid") {
	$form->{"AP_paid_$i"} = "$form->{acc_trans}{$key}->[$i-1]->{accno}--$form->{acc_trans}{$key}->[$i-1]->{description}";
	# reverse paid
	$form->{"paid_$i"} = $form->{acc_trans}{$key}->[$i-1]->{amount} * -1;
	$form->{"datepaid_$i"} = $form->{acc_trans}{$key}->[$i-1]->{transdate};
	$form->{"source_$i"} = $form->{acc_trans}{$key}->[$i-1]->{source};

	if ($form->{"exchangerate_$i"} = $form->{acc_trans}{$key}->[$i-1]->{exchangerate}) {
	  $form->{"forex_$i"} = 1;
	} else {
	  $form->{"exchangerate_$i"} = 1;
	}

	$form->{paidaccounts}++;
      } else {
     
	$akey = $key;
	$akey =~ s/AP_//;
	
        if ($key eq "AP_tax") {

	  $form->{"${key}_$form->{acc_trans}{$key}->[$i-1]->{accno}"} = "$form->{acc_trans}{$key}->[$i-1]->{accno}--$form->{acc_trans}{$key}->[$i-1]->{description}";
	  $form->{"${akey}_$form->{acc_trans}{$key}->[$i-1]->{accno}"} = $form->round_amount($form->{acc_trans}{$key}->[$i-1]->{amount} / $form->{exchangerate}, 2);
	  $totaltax += $form->{"${akey}_$form->{acc_trans}{$key}->[$i-1]->{accno}"};
	} else {
	  $form->{$akey} = $form->round_amount($form->{acc_trans}{$key}->[0]->{amount} / $form->{exchangerate}, 2);
	  $form->{$key} = "$form->{acc_trans}{$key}->[0]->{accno}--$form->{acc_trans}{$key}->[0]->{description}";
	}
      }
    }
  }

  $form->{taxincluded} = $taxincluded if ($form->{id});
  $form->{paidaccounts} = 1 if not defined $form->{paidaccounts};

  $form->{invtotal} = $form->{amount} + $totaltax;
  # amount
  if ($form->{taxincluded}) {
    $form->{amount} += $totaltax;
  }

  $form->{locked} = ($form->datetonum($form->{transdate}, \%myconfig) <= $form->datetonum($form->{closedto}, \%myconfig));

}


sub create_links {

  $form->create_links("AR", \%myconfig, "customer");

  $taxincluded = $form->{taxincluded};

  # build the popup menus

  # currencies
  @curr = split /:/, $form->{currencies};
  chomp $curr[0];
  $form->{defaultcurrency} = $curr[0];

  map { $form->{selectcurrency} .= "<option>$_\n" } @curr;

  # customers
  foreach $ref (@{ $form->{all_customer} }) {
    if ($ref->{id} == $form->{customer_id}) {
      $form->{customer} = "$ref->{name}--$ref->{id}";
      $duedate = $form->{duedate};              # save duedate, we are using IS
      IS->get_customer(\%myconfig, \%$form);
      $form->{duedate} = $duedate;              # work-around
    }
    $form->{selectcustomer} .= "<option>$ref->{name}--$ref->{id}\n";
  }

  # forex
  $form->{forex} = $form->{exchangerate};

  foreach $key (keys %{ $form->{AR_links} }) {

    foreach $ref (@{ $form->{AR_links}{$key} }) {
      if ($key eq 'AR_tax') {
	$form->{"selectAR_tax_$ref->{accno}"} = "<option>$ref->{accno}--$ref->{description}\n";
	next;
      }
      $form->{"select$key"} .= "<option>$ref->{accno}--$ref->{description}\n";
    }

    # if there is a value we have an old entry
    # $i is only used for paid
    for $i (1 .. scalar @{ $form->{acc_trans}{$key} }) {
      if ($key eq "AR_paid") {
	$form->{"AR_paid_$i"} = "$form->{acc_trans}{$key}->[$i-1]->{accno}--$form->{acc_trans}{$key}->[$i-1]->{description}";
	# reverse paid
	$form->{"paid_$i"} = $form->{acc_trans}{$key}->[$i-1]->{amount} * -1;
	$form->{"datepaid_$i"} = $form->{acc_trans}{$key}->[$i-1]->{transdate};
	$form->{"source_$i"} = $form->{acc_trans}{$key}->[$i-1]->{source};

	if ($form->{"exchangerate_$i"} = $form->{acc_trans}{$key}->[$i-1]->{exchangerate}) {
	  $form->{"forex_$i"} = 1;
	} else {
	  $form->{"exchangerate_$i"} = 1;
	}

	$form->{paidaccounts}++;
      } else {
     
	$akey = $key;
	$akey =~ s/AR_//;
	
        if ($key eq "AR_tax") {

	  $form->{"${key}_$form->{acc_trans}{$key}->[$i-1]->{accno}"} = "$form->{acc_trans}{$key}->[$i-1]->{accno}--$form->{acc_trans}{$key}->[$i-1]->{description}";
	  $form->{"${akey}_$form->{acc_trans}{$key}->[$i-1]->{accno}"} = $form->round_amount($form->{acc_trans}{$key}->[$i-1]->{amount} / $form->{exchangerate}, 2);
	  $totaltax += $form->{"${akey}_$form->{acc_trans}{$key}->[$i-1]->{accno}"};
	} else {
	  $form->{$akey} = $form->round_amount($form->{acc_trans}{$key}->[0]->{amount} / $form->{exchangerate}, 2);
	  $form->{$key} = "$form->{acc_trans}{$key}->[0]->{accno}--$form->{acc_trans}{$key}->[0]->{description}";
	}
      }
    }
  }

  $form->{taxincluded} = $taxincluded if ($form->{id});
  $form->{paidaccounts} = 1 if not defined $form->{paidaccounts};

  $form->{invtotal} = $form->{amount} + $totaltax;
  # amount
  if ($form->{taxincluded}) {
    $form->{amount} += $totaltax;
  }

  $form->{locked} = ($form->datetonum($form->{transdate}, \%myconfig) <= $form->datetonum($form->{closedto}, \%myconfig));

}

sub search {

  $form->{"selectAR"} = "<option selected>" . $locale->text('All Customers') . "\n";
&create_links;


  $form->{title} = $locale->text('Statement of Account')." ".$locale->text('Reports');

  $form->header;
 #$form->all_vc(\%myconfig, "customer");


 # foreach $ref (@{ $form->{all_customer} }) {
  #  $selection .= "<option>$ref->{name}--$ref->{id}\n";
  #}

  foreach $item (qw(AR AR_amount customer currency)) {
    $form->{"select$item"} =~ s/ selected//;
    $form->{"select$item"} =~ s/option>\Q$form->{$item}\E/option selected>$form->{$item}/;
  }


  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script} name=search>

<input type=hidden name=sort value=transdate>

<table border=1>
<tr><th class=listtop bgcolor=000000>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>

<tr>
<th align=right>|.$locale->text('Customer').qq|</th>
<td colspan=3><select name=AR>$form->{selectAR}</select></td>
</tr>


<tr>

  <th align=right>|.$locale->text('Date Till').qq| </th>
  <td><input name=date size=40 value=$form->{transdate}>
  <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].date.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
  </td>

</tr>



<tr>

  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>
    <input name="l_transdate" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Date').qq|

    <input name="l_source" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Source').qq|
    <input name="l_transtype" class=checkbox type=checkbox value=Y >&nbsp;|.$locale->text('Trans. Type').qq|
    <input name="l_description" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Description').qq|
    <input name="l_debit" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Debit').qq|

    <input name="l_credit" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Credit').qq|
    <input name="l_balance" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Balance').qq|
    <input name="l_subtotal1" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Total').qq|
    <input name="l_post" class=checkbox type=checkbox value=Y >&nbsp;|.$locale->text('Post Dated').qq|

    </td>

  </tr>

</table>
</td>

</tr>
</table>

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=transdate value=$form->{transdate}>
<input type=hidden name=print value=$form->{print}>
<input type=hidden name=rowcount value=$form->{rowcount}>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Generate Report').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Generate Report 2').qq|">
</form>

<p>
|.$locale->text('Please notify us within 7 days if there is any error in this statement.')
.$locale->text('Payment received after statement date will not be reflected on this statement.')
  .qq|

</body>
</html>
|;
}



sub search1 {
#  $form->{"selectAP"} = "<option selected>" . $locale->text('All Customers') . "\n";

&create_links1;


  $form->{title} = $locale->text('Statement of Account')." ".$locale->text('Reports');

  $form->header;
 $form->all_vc(\%myconfig, "vendor");

  $selection = "<option selected>" . $locale->text('All Vendors') . "\n";

  foreach $ref (@{ $form->{all_vendor} }) {
    $selection .= "<option>$ref->{name}--$ref->{id}\n";
  }

  foreach $item (qw(AP AP_amount vendor currency)) {
    $form->{"select$item"} =~ s/ selected//;
    $form->{"select$item"} =~ s/option>\Q$form->{$item}\E/option selected>$form->{$item}/;
  }


  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>

<input type=hidden name=sort value=transdate>

<table border=1>
<tr><th class=listtop bgcolor=000000>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>

<tr>
<th align=right>|.$locale->text('Vendor').qq|</th>
<td colspan=3><select name=AP>$form->{selectAP}</select></td>
</tr>


<tr>

  <th align=right>|.$locale->text('Date').qq| </th>
  <td><input name=date size=40 value=$form->{transdate}></td>

</tr>



<tr>

  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>
    <input name="l_transdate" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Date').qq|

    <input name="l_source" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Source').qq|
    <input name="l_transtype" class=checkbox type=checkbox value=Y >&nbsp;|.$locale->text('Trans. Type').qq|
    <input name="l_description" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Description').qq|
    <input name="l_debit" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Debit').qq|

    <input name="l_credit" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Credit').qq|
    <input name="l_balance" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Balance').qq|
    <input name="l_subtotal1" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Total').qq|

    </td>

  </tr>

</table>
</td>

</tr>
</table>

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=transdate value=$form->{transdate}>
<input type=hidden name=print value=$form->{print}>
<input type=hidden name=rowcount value=$form->{rowcount}>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Generate Report').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Generate Report 2').qq|">
</form>

<p>
|.$locale->text('Please notify us within 7 days if there is any error in this statement.')
.$locale->text('Payment received after statement date will not be reflected on this statement.')
  .qq|

</body>
</html>
|;
}


sub generate_report_bck {

  statement->all_transactions(\%myconfig, \%$form);
 statement->all_transactions2(\%myconfig, \%$form);

  $callback = "$form->{script}?action=generate_report&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";

  %acctype = ( 'A' => $locale->text('Asset'),
               'L' => $locale->text('Liability'),
	       'Q' => $locale->text('Equity'),
	       'I' => $locale->text('Income'),
	       'E' => $locale->text('Expense'),
	     );

  $form->{title} = $locale->text('Statement of Account');

  unless ($form->{category} eq 'X') {
    $form->{title} .= " : ".$locale->text($acctype{$form->{category}});
  }

 if ($form->{AR}) {
  ($customerno, $form->{AR1}) = split(/--/, $form->{AR});
  $customer = $form->{AR};
  $customer =~ s/ /%20/g;
  $customer=~ s/"/&quot;/g;
  $callback .= "&AR=$customer";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Customer :')." ".$form->{AR};
  }
  if ($form->{month}) {
    $callback .= "&month=$form->{month}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Month :')." ".$form->{month};
  }
 if ($form->{year}) {
    $callback .= "&partnono=$form->{year}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Year :')." ".$form->{year};
  }


  @columns = $form->sort_columns(qw( transdate refnumber description number  debit credit balance ));





  $href = "$callback&sort=$form->{sort}";        # needed for accno
 # $callback += "&sort=$form->{sort}";        # needed for accno

  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
    }
  }

  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
  }

  $callback .= "&category=$form->{category}";
  $href .= "&category=$form->{category}";

  $column_header{transdate} = "<th>".$locale->text('Date')."</th>";
  $column_header{refnumber} = "<th>".$locale->text('Ref')."</th>";
  $column_header{description} = "<th>".$locale->text('Description')."</th>";
  $column_header{number} = "<th>".$locale->text('Source.')."</th>";
  $column_header{debit} = "<th>".$locale->text('Debit')."</th>";
  $column_header{credit} = "<th>".$locale->text('Credit')."</th>";
  $column_header{balance} = "<th>".$locale->text('Balance')."</th>";

  $colspan = $#column_index + 1;

  $form->header;

  print  qq|
<body bgcolor=ffffff>

<table border=1 WIDTH=100%>
<tr><th class=listtop bgcolor=000000 colspan=$colspan>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>$option</td></tr>

<tr class=listheading bgcolor=336666>
|;

map { print  "$column_header{$_}\n" } @column_index;

print  "</tr>";

  # add sort to callback
  $callback = $form->escape($callback . "&sort=$form->{sort}");

  # initial item for subtotals
  if (@{ $form->{report} }) {
    $sameitem = $form->{report}->[0]->{$form->{sort}};
#    print  "$sameitem<br>";
 }
    $balance=0;
    $obal = 0;
    $debit=0;
    $credit=0;

  foreach $ref (@{ $form->{report} }) {

    # if item ne sort print subtotal
    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ref->{$form->{sort}}) {
	&gl_subtotal;
    #print  "$sameitem<br>";
 }
    }

    $subtotalcredit += $ref->{subtotal1};

    $totalcredit += $ref->{subtotal1};

    $ref->{subtotal1} = $form->format_amount(\%myconfig, $ref->{subtotal1}, 2, "&nbsp;");
    
    $text="";
    if ($ref->{type} eq "gl") {
      $text = "GL";
    }

    # ap
    if ($ref->{type} eq "inv") {
      $text = "Invoice no. : ";

    }

    if ($ref->{type} eq "dbn") {
      $text = "Debit no. : ";

    }    if ($ref->{type} eq "cnc") {
      $text = "Credit no. : ";

    }

   if (($form->{month})) {
   	if( ($ref->{month} eq $form->{month})) {
	       if($obal eq 0){
		$column_data{transdate} = "<td>$form->{month}-01-$form->{year}</td>";
		$column_data{refnumber} = "<td>O/Bal at $form->{month}-01-$form->{year}</td>";
		$column_data{description} = "<td> </td>";
		$column_data{number} = "<td> </td>";

		$column_data{debit} = "<td align=right></td>";
		$column_data{credit} = "<td align=right></td>";
  		$balance1 = $form->format_amount(\%myconfig, $balance, 2, "&nbsp;");
		$column_data{balance} = "<td align=right>$balance1</td>";

		$i++; $i %= 2;
		print  "<tr class=listrow$i onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow$i';\" >";
		map { print "$column_data{$_}\n" } @column_index;
		print  "</tr>";
		$obal =1;
	       }
		$column_data{transdate} = "<td>$ref->{transdate}</td>";
		$column_data{refnumber} = "<td>$text $ref->{number}</td>";
		$column_data{description} = "<td> $ref->{description}</td>";
		$column_data{number} = "<td>$ref->{source}</td>";
#		$column_data{refnumber} = "<td><a href=ic.pl?action=edit&id=$ref->{refnumber}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{refnumber}</a></td>";

  		$ref->{debit1} = $form->format_amount(\%myconfig, $ref->{debit}, 2, "&nbsp;");
  		$ref->{credit1} = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");

		$column_data{debit} = "<td align=right>$ref->{debit1}</td>";
		$column_data{credit} = "<td align=right>$ref->{credit1}</td>";
		$balance += $ref->{debit} ;
		$balance -= $ref->{credit};
		$debit +=$ref->{debit};
		$credit +=$ref->{credit};

  		$balance1 = $form->format_amount(\%myconfig, $balance, 2, "&nbsp;");
    		if ( $balance eq 0){
    			$column_data{balance} = "<td align=right>0.00</td>";

    		}else{		$column_data{balance} = "<td align=right>$balance1</td>";

    		}
		$i++; $i %= 2;
		print  "<tr class=listrow$i onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow$i';\" >";
		map { print "$column_data{$_}\n" } @column_index;
		print  "</tr>";


	}else{
		$balance += $ref->{debit} ;
		$balance -= $ref->{credit};
		$debit +=$ref->{debit};
		$credit +=$ref->{credit};

	}

    }else{
    




    $column_data{transdate} = "<td>$ref->{transdate}</td>";
    $column_data{refnumber} = "<td>$text $ref->{number}</td>";
    $column_data{description} = "<td>$ref->{description}</td>";
    $column_data{number} = "<td>$ref->{source} </td>";
  		$ref->{debit1} = $form->format_amount(\%myconfig, $ref->{debit}, 2, "&nbsp;");
  		$ref->{credit1} = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");

 		$balance += $ref->{debit} ;
		$balance -= $ref->{credit};
#		$debit +=$ref->{debit};
#		$credit +=$ref->{credit};

		$balance1 = $form->format_amount(\%myconfig, $balance, 2, "&nbsp;");
   $column_data{debit} = "<td align=right>$ref->{debit1}</td>";
    $column_data{credit} = "<td align=right>$ref->{credit1}</td>";


   		if ( $balance eq 0){
    			$column_data{balance} = "<td align=right>0.00</td>";

    		}else{		$column_data{balance} = "<td align=right>$balance1</td>";

    		}

     $i++; $i %= 2;
    print  "<tr class=listrow$i onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow$i';\" >";
    map { print "$column_data{$_}\n" } @column_index;
    print  "</tr>";

    }

  }

  &gl_subtotal if ($form->{l_subtotal} eq 'Y');

  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;

   if ( $balance eq 0){
    			$column_data{balance} = "<th align=right>0.00</th>";

    }else{		  $column_data{balance} = "<th align=right>".$form->format_amount(\%myconfig, $balance, 2, "&nbsp;")."</th>";


    }
  $column_data{debit} = "<th align=right>".$form->format_amount(\%myconfig, $debit, 2, "&nbsp;")."</th>";
  $column_data{credit} = "<th align=right>".$form->format_amount(\%myconfig, $credit, 2, "&nbsp;")."</th>";

  print  qq|
<tr class=listtotal bgcolor=000000>|;

  map { print  "$column_data{$_}\n" } @column_index;

  print  qq|</tr>
 </table>
 <P>
|;
  foreach $ref (@{ $form->{statement} }) {
		$a{$ref->{date}} = $ref->{total};

  }
  print qq|
<TABLE  BORDER=0 CELLPADDING=1 CELLSPACING=1 WIDTH=100%>

	<TR VALIGN=TOP class=listheading bgcolor=336666>
		<TD >
			<FONT><B>JAN</B></FONT>
		</TD>
		<TD >
			<FONT><B>FEB</B></FONT>
		</TD>
		<TD >
			<FONT><B>MAR</B></FONT>
		</TD>
		<TD >
			<FONT><B>APR</B></FONT>
		</TD>
		<TD >
			<FONT><B>MAY</B></FONT>
		</TD>
		<TD >
			<FONT><B>JUNE</B></FONT>
		</TD>
	</TR>
	<TR VALIGN=TOP class=listrow1>
		<TD >
			$a{1}<BR>


		</TD>
		<TD >
			$a{2}<BR>

		</TD>
		<TD >
			$a{3}<BR>

		</TD>
		<TD >
			$a{4}<BR>

		</TD>
		<TD >
			$a{5}<BR>

		</TD>
		<TD >
			$a{6}<BR>

		</TD>
	</TR>
	<TR VALIGN=TOP class=listheading bgcolor=336666>
		<TD >
			<FONT ><B>JUL</B></FONT>
		</TD>
		<TD >
			<FONT ><B>AUG</B></FONT>
		</TD>
		<TD >
			<FONT ><B>SEP</B></FONT>
		</TD>
		<TD >
			<FONT><B>OCT</B></FONT>
		</TD>
		<TD >
			<FONT ><B>NOV</B></FONT>
		</TD>
		<TD >
			<FONT ><B>DEC</B></FONT>
		</TD>
	</TR>
	<TR VALIGN=TOP  class=listrow1>
		<TD >
			$a{7}<BR>

		</TD>
		<TD >

			$a{8}<BR>
		</TD>
		<TD >

			$a{9}<BR>
		</TD>
		<TD >

			$a{10}<BR>
				</TD>
		<TD >

			$a{11}<BR>
		</TD>
		<TD >
			$a{12}<BR>
		</TD>
	</TR>
</TABLE>
</P>
<p>
|
.$locale->text('Click on "Partnumber" or "INV" to edit transaction')

.qq|

</body>
</html>
|;

}

