
#=====================================================================
# SQL-Ledger Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Genereal Ledger
#
#======================================================================


use SL::report;
$form->{rowcount}=50;

1;
# end of main


# this is for our long dates
# $locale->text('January')
# $locale->text('February')
# $locale->text('March')
# $locale->text('April')
# $locale->text('May ')
# $locale->text('June')
# $locale->text('July')
# $locale->text('August')
# $locale->text('September')
# $locale->text('October')
# $locale->text('November')
# $locale->text('December')

# this is for our short month
# $locale->text('Jan')
# $locale->text('Feb')
# $locale->text('Mar')
# $locale->text('Apr')
# $locale->text('May')
# $locale->text('Jun')
# $locale->text('Jul')
# $locale->text('Aug')
# $locale->text('Sep')
# $locale->text('Oct')
# $locale->text('Nov')
# $locale->text('Dec')


sub print_sales_invoice{
	$form->{print}="true";
 $form->{nextsub}="print_report";
  $form->{module}="is.pl";
   $form->{title} = $locale->text('Invoice Listing - Customer');
 report->all_transactions(\%myconfig, \%$form);
	&generate_report2;
}

	
sub sales_invoice {
  $form->{nextsub}="sales_invoice";
  $form->{module}="is.pl";
  $form->{title} = $locale->text('Invoice Listing - Customer');
  report->all_transactions(\%myconfig, \%$form);

	&generate_report2;

}
sub print_sales_order{
	$form->{print}="true";
  $form->{module}="oe.pl";
  $form->{nextsub}="print_sales_order";
  $form->{vc}="customer";
  $form->{ptitle}="Sales Order";
  $form->{type}="sales_order";
  $form->{title} = $locale->text('Sales Order Listing');
	  report->all_transactions_sales(\%myconfig, \%$form);
	&generate_report2;

}
sub sales_order {
  $form->{nextsub}="sales_order";
  $form->{module}="oe.pl";
  $form->{vc}="customer";
  $form->{ptitle}="Sales Order";
  $form->{type}="sales_order";
  $form->{title} = $locale->text('Sales Order Listing');
  report->all_transactions_sales(\%myconfig, \%$form);
	&generate_report2;

}

	
sub print_purchase_order{
  $form->{module}="oe.pl";
  $form->{vc}="vendor";
  $form->{type}="purchase_order";
  $form->{ptitle}="Purchase Order";
	$form->{print}="true";
  $form->{nextsub}="print_purchase_order";
  $form->{title} = $locale->text('Purchase Order Listing');
  report->all_transactions_purchase(\%myconfig, \%$form);
	&generate_report2;
}
sub purchase_order {
  $form->{nextsub}="purchase_order";
  $form->{type}="purchase_order";
  $form->{module}="oe.pl";
  $form->{vc}="vendor";
  $form->{ptitle}="Purchase Order";
  $form->{title} = $locale->text('Sales Order Listing');
  report->all_transactions_purchase(\%myconfig, \%$form);
	&generate_report2;

}
sub print_vendor_invoice{
  $form->{module}="ir.pl";
	$form->{print}="true";
  $form->{nextsub}="print_vendor_invoice";
  $form->{title} = $locale->text('Invoice Listing - Vendor');
  report->all_transactions_vendor(\%myconfig, \%$form);
	&generate_report2;
}
	
sub vendor_invoice {
  $form->{module}="ir.pl";
  $form->{nextsub}="vendor_invoice";
  $form->{title} = $locale->text('Invoice Listing - Vendor');
  report->all_transactions_vendor(\%myconfig, \%$form);
	&generate_report2;

}
	



sub generate_report2 {
  map { $form->{$_} = $myconfig{$_} } (qw(company address businessnumber nativecurr));

     $file=$form->{nextsub};
 if($form->{print} eq "true"){
   $line = "<hr size=2 noshade>";
    $fontsize="size=1";
   $listheading="class=print";
   $listtop="class=print";
    $listrow="class=print";
    $listtotal="class=print";
    $listsubtotal="class=print";
    $listprint="class=print";
      }else{
    $listheading="class=listheading";
    $listheadingcolor="color=ffffff";
    $listtop="class=listtop";
    $listrow="class=listrow";
    $listtotal="class=listtotal";
    $listsubtotal="class=listsubtotal";
    $lastline=$locale->text('Click on "Partnumber" or "INV" to edit transaction');
   $mouseaction[0]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow0';\"";
    $mouseaction[1]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow1';\"";
   }


  $callback = "$form->{script}?action=$file&print=$form->{print}&type=$form->{type}&vc=$form->{vc}&readonly=$form->{readonly}&rowcount=$form->{rowcount}&type=$form->{type}&print_so_mod=$form->{print_so_mod}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&sort=$form->{sort}";
  $callback .= "&ptitle=".$form->escape($form->{ptitle});

  %acctype = ( 'A' => $locale->text('Asset'),
               'L' => $locale->text('Liability'),
	       'Q' => $locale->text('Equity'),
	       'I' => $locale->text('Income'),
	       'E' => $locale->text('Expense'),
	     );


  unless ($form->{category} eq 'X') {
    $form->{title} .= "  ".$locale->text($acctype{$form->{category}});
  }

 if ($form->{customerno}) {
 # ($customerno, $form->{customer1}) = split(/--/, $form->{customerno});
  $customer = $form->{customerno};
   $option .= "\n<br>" if $option;
    $option .= $locale->text('Customer :')." ".$form->{customerno};
  $customer =~ s/ /%20/g;
  $customer=~ s/&/%amp/g;
  $callback .= "&customerno=$customer";
  }
   if ($form->{vendorno}) {
 # ($customerno, $form->{customer1}) = split(/--/, $form->{customerno});
  $customer = $form->{vendorno};
  $customer =~ s/ /%20/g;
   $option .= "\n<br>" if $option;
    $option .= $locale->text('Vendor :')." ".$form->{vendorno};
  $customer=~ s/&/%amp/g;
  $callback .= "&vendorno=$customer";
  }
  
  if ($form->{loginno}) {
    $callback .= "&loginno=$form->{loginno}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Login :')." ".$form->{loginno};
  }
 if ($form->{partnono}) {
    $callback .= "&partnono=$form->{partnono}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Part Num :')." ".$form->{partnono};
  }
   if ($form->{parts_id}) {
    $callback .= "&parts_id=$form->{parts_id}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Part ID :')." ".$form->{partnono};
  }
 if ($form->{idescno}) {
    $callback .= "&idescno=$form->{idescno}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Item Description :')." ".$form->{idescno};
  }
 if ($form->{invnumber}) {
    $callback .= "&invnumber=$form->{invnumber}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Invoice Number :')." ".$form->{invnumber};
  }
 if ($form->{ordnumber}) {
    $callback .= "&ordnumber=$form->{ordnumber}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Order Number :')." ".$form->{ordnumber};
  }

if ($form->{project}) {
    $callback .= "&project=$form->{project}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Project Number :')." ".$form->{project};
  }
if ($form->{subb}) {
    $callback .= "&subb=$form->{subb}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Sub Number :')." ".$form->{subb};
  }

  if ($form->{datefrom}) {
    $callback .= "&datefrom=$form->{datefrom}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('From :')." ".$locale->date(\%myconfig, $form->{datefrom}, 1);
  }

  if ($form->{dateto}) {
    $callback .= "&dateto=$form->{dateto}";
    if ($form->{datefrom}) {
      $option .= " ";
    } else {
      $option .= "\n<br>" if $option;
    }
    $option .= $locale->text('To :')." ".$locale->date(\%myconfig, $form->{dateto}, 1);
  }
 if ($form->{make}) {
    $callback .= "&make=$form->{make}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Make :')." ".$form->{make};
  }
  
  if ($form->{model}) {
    $callback .= "&model=$form->{model}";
    $option .= "\n<br>" if $option;
    $option .= $locale->text('Model :')." ".$form->{model};
  }


  @columns = $form->sort_columns(qw(parts_id transtype invnumber  project subb transdate accno customer partnumber description qty ordnumber poqty pobalance price tax subtotal1 qtykg  login delivery_date remark2 ));





  $href = "$callback&sort=$form->{sort}";        # needed for accno
 # $callback += "&sort=$form->{sort}";        # needed for accno

  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
         if ($item eq "ordnumber") {
			push @column_index, "poqty";


			push @column_index, "pobalance";


	 }
    }
  }

  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
    
    
    
  @column_index = grep !/$form->{sort}/, @column_index;
  
    if($form->{sort} eq "accno"){
  @column_index = grep !/customer/, @column_index;	  
  }
    if($form->{sort} eq "invnumber"){
  @column_index = grep !/customer/, @column_index;	  
  @column_index = grep !/accno/, @column_index;	  
  }
  
  }
  if ($form->{l_sr} eq 'Y') {
    $callback .= "&l_sr=Y";
    $href .= "&l_sr=Y";
  }

  $callback .= "&category=$form->{category}";
  $href .= "&category=$form->{category}";
  
  $column_title{qtykg} = $locale->text('QTY(kg)');
  $column_title{customer} = $locale->text('Customer');
  $column_title{login} = $locale->text('Employee');
  $column_title{delivery_date} = $locale->text('Delivery Date');
  $column_title{remark2} = $locale->text('R/2');
  $column_title{tax} = $locale->text('Tax');

  $column_title{parts_id} = $locale->text('ID');
   $column_title{invnumber} = $locale->text('INV');
  $column_title{ordnumber} = $locale->text('ORD');
  $column_title{transdate} = $locale->text('Date');
  $column_title{accno} = $locale->text('ACC NO.');
  $column_title{partnumber} =$locale->text('PARTNUMBER');
  $column_title{description} = $locale->text('DESCRIPTION');
  $column_title{qty} = $locale->text('QTY');
 $column_title{poqty} = $locale->text('PO QTY');
  $column_title{pobalance} = $locale->text('PO BAL');
   $column_title{price} =$locale->text('PRICE');
  $column_title{subtotal1} = $locale->text('SUBTOTAL');
 $column_title{project} = $locale->text('Proj');
 $column_title{subb} = $locale->text('Sub');
 $column_title{transtype} = $locale->text('Trans.');

   $column_header{transtype} = "<th $listprint>$line$column_title{transtype}$line</th>";
 $column_header{qtykg} = "<th $listprint>$line$column_title{qtykg}$line</th>";
  $column_header{customer} = "<th $listprint><a $listheading href=$callback&sort=customer>$line$column_title{customer}$line</a></th>";
  $column_header{login} = "<th $listprint><a $listheading href=$callback&sort=login>$line$column_title{login}$line</a></th>";
  $column_header{delivery_date} = "<th $listprint><a $listheading href=$callback&sort=login>$line$column_title{delivery_date}$line</a></th>";
  $column_header{remark2} = "<th $listprint><a $listheading href=$callback&sort=login>$line$column_title{remark2}$line</a></th>";

  
  $column_header{parts_id} = "<th $listprint><a $listheading href=$callback&sort=parts_id>$line$column_title{parts_id}$line</a></th>";
  $column_header{invnumber} = "<th $listprint><a $listheading href=$callback&sort=invnumber>$line$column_title{invnumber}$line</a></th>";
  $column_header{ordnumber} = "<th $listprint><a $listheading href=$callback&sort=ordnumber>$line$column_title{ordnumber}$line</a></th>";
  $column_header{transdate} = "<th $listprint><a $listheading href=$callback&sort=transdate>$line$column_title{transdate}$line</a></th>";
  $column_header{accno} = "<th $listprint><a $listheading href=$callback&sort=accno>$line$column_title{accno}$line</a></th>";
  $column_header{partnumber} = "<th $listprint><a $listheading href=$callback&sort=partnumber>$line$column_title{partnumber}$line</a></th>";
  $column_header{description} = "<th $listprint>$line$column_title{description}$line</th>";
  $column_header{qty} = "<th $listprint>$line$column_title{qty}$line</th>";
 $column_header{poqty} = "<th $listprint>$line$column_title{poqty}$line</a></th>";
  $column_header{pobalance} = "<th $listprint>$line$column_title{pobalance}$line</a></th>";
   $column_header{price} = "<th $listprint>$line$column_title{price}$line</th>";
  $column_header{subtotal1} = "<th $listprint>$line$column_title{subtotal1}$line</th>";
 $column_header{project} = "<th $listprint>$line$column_title{project}$line</th>";
 $column_header{subb} = "<th $listprint>$line$column_title{subb}$line</th>";
 $column_header{tax}= "<th $listprint>$line$column_title{tax}$line</th>";


  $colspan = $#column_index + 1;

  $form->header;
#$option
 $option ='' if(!$form->{l_option})  ;

  print  qq|
<body bgcolor=ffffff $listprint>
<h1 align=center $listprint>$form->{company}<br>$form->{title}</h1><Br>
$option
<table border=0 width=100% $listprint>
|;


  # add sort to callback
  $callback = $form->escape($callback . "&sort=$form->{sort}");

  # initial item for subtotals
  if (@{ $form->{report} }) {
    $sameitem = $form->{report}->[0]->{$form->{sort}};
#    print  "$sameitem<br>";
 }
		&pagetableheader;

  foreach $ref (@{ $form->{report} }) {
	  if(!$stopprintheading){
		  if ($form->{l_subtotal} eq 'Y') {
				 &sortheading;
		  }
		$stopprintheading="true";
	  }

    # if item ne sort print subtotal
    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ref->{$form->{sort}}) {
	&gl_subtotal;
	$sameitem = $ref->{$form->{sort}};
		  if ($form->{l_subtotal} eq 'Y') {
				 &sortheading;
		  }

      #   &pagetableheader;
            $r+=3;

 }
    }

    $subtotalqtykg += $ref->{qtykg};
    $subtotaldebit += $ref->{qty};
    $subtotaltax+= $ref->{tax};
    $subtotalcredit += $ref->{subtotal1};
 #  print  "$subtotalcredit<br>";

    $totalqtykg += $ref->{qtykg};
    $totaldebit += $ref->{qty};
    $totaltax += $ref->{tax};
    $totalcredit += $ref->{subtotal1};

    
    $pagetotaltax += $ref->{tax};
        $pagetotalqtykg += $ref->{qtykg};
    $pagetotaldebit += $ref->{qty};
    $pagetotalcredit += $ref->{subtotal1};

    $form->{qty}=$form->parse_amount(\%myconfig, $ref->{qty});
    $form->{poqty}=$form->parse_amount(\%myconfig, $ref->{poqty});
   $ref->{subtotal1} = $form->format_amount(\%myconfig, $ref->{subtotal1}, 2, "&nbsp;");
    #$ref->{credit} = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");


	if($form->{readonly}){
	    $column_data{invnumber} = "<td $listprint>$ref->{invnumber}</td>";
    $column_data{partnumber} = "<td $listprint>$ref->{partnumber}</td>";
	 }else{
    $column_data{invnumber} = "<td $listprint><a $listprint href=$form->{module}?action=edit&title=".$form->escape($form->{ptitle})."&type=$form->{type}&vc=$form->{vc}&readonly=$form->{readonly}&transtype=$ref->{transtype}&type=$form->{type}&print_so_mod=$form->{print_so_mod}&id=$ref->{id}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{invnumber}</a></td>";
    $column_data{partnumber} = "<td $listprint><a  $listprint href=ic.pl?action=edit&id=$ref->{parts_id}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback&readonly=$form->{readonly}&transdateto=$form->{transdateto}&transdatefrom=$form->{transdatefrom}>$ref->{partnumber}</a></td>";
    }
	    $column_data{transtype} = "<td nowrap>$ref->{transtype}-$ref->{batch}-$ref->{transno}$ref->{subtarnsno}</td>";
	    $column_data{parts_id} = "<td>$ref->{parts_id}</td>";
	    $column_data{ordnumber} = "<td $listprint><a $listprint href=$form->{module}?action=edit&readonly=$form->{readonly}&transtype=$form->{transtype}&type=$form->{type}&print_so_mod=$form->{print_so_mod}&id=$ref->{id}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{ordnumber}</a></td>";
    $column_data{transdate} = "<td $listprint nowrap>$ref->{transdate}</td>";
    $column_data{accno} = "<td $listprint>$ref->{accno}</td>";
   # $column_data{partnumber} = "<td><a href=ic.pl?readonly=$form->{readonly}&action=edit&id=$ref->{parts_id}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{partnumber}</a></td>";
    $column_data{description} = "<td  $listprint>$ref->{description}</td>";
    $column_data{qty} = "<td align=right $listprint> $form->{qty}</td>";
    $column_data{poqty} = "<td $listprint><a $listprint href=$form->{module}?readonly=$form->{readonly}&action=edit&id=$ref->{id}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$form->{poqty}</a></td>";
    $column_data{pobalance} = "<td $listprint><a $listprint href=$form->{module}?readonly=$form->{readonly}&action=edit&id=$ref->{id}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{pobalance}</a></td>";
   $ref->{price}=$form->format_amount(\%myconfig, $ref->{price}, 2, "&nbsp;");
  $column_data{price} = "<td align=right $listprint>$ref->{curr} $ref->{price}</td>";
   $column_data{subtotal1} = "<td align=right $listprint>$ref->{curr} $ref->{subtotal1}</td>";
   $column_data{project} = "<td align=right $listprint> $ref->{project}</td>";
   $column_data{subb} = "<td align=right $listprint>$ref->{subb}</td>";

    $column_data{qtykg} = "<td $listprint>$ref->{qtykg}</td>";
    $column_data{customer} = "<td $listprint>$ref->{customer}</td>";
    $column_data{login} = "<td $listprint>$ref->{login}</td>";

    $column_data{delivery_date} = "<td $listprint>$ref->{delivery_date}</td>";
    $column_data{remark2} = "<td $listprint>$ref->{remark2}</td>";
    $column_data{tax} = "<td align=right $listprint>$ref->{tax}</td>";

    $i++; $i %= 2;$r++;$j++;
    print  "<tr $listrow$i  $mouseaction[$i]>";
            if($form->{l_sr}){

    	print "<td $listprint >$j</td>";
    }
    map { print "$column_data{$_}\n" } @column_index;
    print  "</tr>";

    
           #pagebreak printing
if($form->{rowcount} && $form->{print} && $form->{rowcount} <= $r){
$pagenum++;
    print "<tr $listrow$i >";
if($form->{l_sr}){
	print "<td $listprint >$line&nbsp;</td>";
}
	
	  map { $column_data{$_} = "<th $listprint >$line&nbsp;</th>" } @column_index;
	  if($form->{l_subtotal}){
     $column_data{description} = "<th $listprint >$line SubTotal C/F for Page $pagenum</th>";
    $column_data{qtykg} = "<th  $listprint align=right>$line $subtotalqtykg</th>";
    $column_data{qty} = "<th  $listprint align=right>$line $subtotaldebit </th>";
    $column_data{tax} = "<th  $listprint align=right>$line $subtotaltax</th>";
    $column_data{subtotal1} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $subtotalcredit, 2, "&nbsp;") . "</th>";
	  }else{
	     $column_data{description} = "<th $listprint >$line SubTotal C/F for Page $pagenum</th>";
    $column_data{qtykg} = "<th  $listprint align=right>$line$pagetotalqtykg</th>";
    $column_data{qty} = "<th  $listprint align=right>$line $pagetotaldebit</th>";
    $column_data{tax} = "<th  $listprint align=right>$line $pagetotaltax</th>";
    $column_data{subtotal1} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalcredit, 2, "&nbsp;") . "</th>";
	  
	  }
     map { print "\n$column_data{$_}" } @column_index;

     print qq|
     </tr>
</table>

 <p style="page-break-before: always">F/Y : $form->{fy}</p>
<H1  $listprint align=center >$form->{company}<br>$form->{title}</h1>
<table  $listprint border=0 width=100%>

<tr $listheading >|;


&pagetableheader;
		  if ($form->{l_subtotal} eq 'Y') {
				 &sortheading;
		  }
print qq|
</tr><tr>
|;
if($form->{l_sr}){
	print "<td $listprint >&nbsp;</td>";
}

 	  map { $column_data{$_} = "<td $listprint >&nbsp;</td>" } @column_index;
	  if($form->{l_subtotal}){
     $column_data{description} = "<td $listprint >**Subtotal B/F for Page $pagenum </td>";
     $column_data{qtykg} = "<td  $listprint align=right> $subtotalqtykg</td>";
    $column_data{tax} = "<td  $listprint align=right> $subtotaltax</td>";
     $column_data{qty} = "<td  $listprint align=right> $subtotaldebit</td>";
    $column_data{subtotal1} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $subtotalcredit, 2, "0.00") . "</td>";
	  }else{
     $column_data{description} = "<td $listprint >**Subtotal B/F for Page $pagenum </td>";
     $column_data{qtykg} = "<td  $listprint align=right> $pagetotalqtykg</td>";
    $column_data{tax} = "<td  $listprint align=right> $pagetotaltax</td>";
    $column_data{qty} = "<td  $listprint align=right>$pagetotaldebit</td>";
    $column_data{subtotal1} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotalcredit, 2, "0.00") . "</td>";
	  }
    map { print "\n$column_data{$_}" } @column_index;
print qq|
</tr>
|;
$r=0;


		  
  }
  
  }

  &gl_subtotal if ($form->{l_subtotal} eq 'Y');

  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;

  $column_data{tax} = "<th align=right><font color=ffffff>".$totaltax."</th>";
  $column_data{qty} = "<th align=right><font color=ffffff>".$totaldebit."</th>";
  $column_data{subtotal1} = "<th align=right>$line".$form->format_amount(\%myconfig, $totalcredit, 2, "&nbsp;")."$line</th>";

  print  qq|
<tr $listtotal >|;
if($form->{l_sr}){
	print "<th $listprint >&nbsp;</th>";
}
  map { print  "$column_data{$_}\n" } @column_index;

  print  qq|</tr>
 </table>

<p>

$lastline


</body>
</html>
|;

}

sub sortheading{
 	print qq|<tr>
	<td $listprint colspan=$colspan><br><b>$column_title{"$form->{sort}"} :</b>$ref->{"$form->{sort}"}
|;
if($form->{sort} eq "accno"){
 	  print qq|
	  	&nbsp;&nbsp;&nbsp;&nbsp;<b>$column_title{customer} :</b>$ref->{customer}|;
  }
if($form->{sort} eq "invnumber"){
 	  print qq|
	  	&nbsp;&nbsp;&nbsp;&nbsp;<b>$column_title{accno} :</b>$ref->{accno}&nbsp;&nbsp;&nbsp;&nbsp;<b>$column_title{customer} :</b>$ref->{customer}|;
  } 	
  
  print qq|
	</td>
	</tr>
|;

	
}

sub pagetableheader{
	print qq|
<thead $listheading >
|;


	if($form->{l_sr}){
	print "<th $listprint >$line".$locale->text('SR')."$line</th>";
}
map { print "\n$column_header{$_}" } @column_index;
print  "</thead>";
}


sub gl_subtotal {

  #$subtotaldebit = $form->format_amount(\%myconfig, $subtotaldebit, 2, "&nbsp;");
  $subtotalcredit = $form->format_amount(\%myconfig, $subtotalcredit, 2, "&nbsp;");

  map { $column_data{$_} = "<td  $listprint >&nbsp;</td>" } qw(invnumber project subb ordnumber transdate accno partnumber description qty poqty pobalance price customer login delivery_date remark2);
  $column_data{price} = "<th align=right  $listprint >$line&nbsp;</td>";
  $column_data{qty} = "<th align=right  $listprint >$line$subtotaldebit</td>";
  $column_data{tax} = "<th align=right  $listprint >$line$subtotaltax</td>";
  $column_data{subtotal1} = "<th align=right  $listprint >$line$subtotalcredit</td>";
  $column_data{qtykg} = "<th align=right  $listprint >$line$subtotalqtykg</td>";
 $column_data{description} = "<th align=right  $listprint >$line Subtotal </td>";


  print "<tr $listsubtotal >";
             if($form->{l_sr}){
    	print "<td $listprint >&nbsp;</td>";
    }

  map { print "$column_data{$_}\n" } @column_index;
  print "</tr>";

  $subtotaldebit = 0;
  $subtotalcredit = 0;
  $subtotalqtykg=0;
  $sameitem = $ref->{$form->{sort}};

}







sub search {
$form->{datefrom} =$form->first_day_current_Date(\%myconfig) if $form->{currentdate};

  $form->{title} = $locale->text('Invoice Listing')." ".$locale->text('Reports');

  $form->header;
  if ($form->{vc} eq "customer"){
 $form->all_vc(\%myconfig, "customer") ;

  $selection = "<option selected value=''>" . $locale->text('All Customers') . "\n";

  foreach $ref (@{ $form->{all_customer} }) {
	  $selection .= "<option value='$ref->{customernumber}::$ref->{name}--$ref->{id}'>$ref->{customernumber}--$ref->{name}\n";
  }
  $vc_text=qq|<tr>
<th align=right>|.$locale->text('Customer').qq|</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=customerno onChange="this.form.accno1.value=this.options[this.selectedIndex].value">$selection</select>
		</td>

</tr>|;

}
   
   if ($form->{vc} eq "vendor"){
 $form->all_vc(\%myconfig, "vendor");

  $selectionvc = "<option selected value=''>" . $locale->text('All Vendors') . "\n";

  foreach $ref (@{ $form->{all_vendor} }) {
	  $selectionvc .= "<option value='$ref->{vendornumber}::$ref->{name}--$ref->{id}'>$ref->{vendornumber}--$ref->{name}\n";
  }
$vc_text=qq|  <tr>
<th align=right>|.$locale->text('Vendor').qq|</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=vendorno onChange="this.form.accno2.value=this.options[this.selectedIndex].value">$selectionvc</select>
		</td>

</tr>|;

 } 

if(!$form->{readonly}){
	$str=   "<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=\"l_price\" class=checkbox type=checkbox value=Y $form->{l_price}>&nbsp;".$locale->text('U/Price') ;
	$str=   "<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=\"l_tax\" class=checkbox type=checkbox value=Y $form->{l_tax}>&nbsp;".$locale->text('Tax') ;
   $str.="<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=\"l_subtotal1\" class=checkbox type=checkbox value=Y  $form->{l_subtotal1}>&nbsp;".$locale->text('Total') ;
#    $str.="<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=\"l_subtotal\" class=checkbox type=checkbox value=Y  $form->{l_price}>&nbsp;".$locale->text('Total');

}
  print qq|
  
  <script>
<!--

function autoComplete (field, select, property, forcematch) {
	var found = false;
	for (var i = 0; i < select.options.length; i++) {
	if (select.options[i][property].toUpperCase().indexOf(field.value.toUpperCase()) == 0) {
		found=true; break;
		}
	}
	if (found) { select.selectedIndex = i; }
	else { select.selectedIndex = -1; }
	if (field.createTextRange) {
		if (forcematch && !found) {
			field.value=field.value.substring(0,field.value.length-1); 
			return;
			}
		var cursorKeys ="8;46;37;38;39;40;33;34;35;36;45;";
		if (cursorKeys.indexOf(event.keyCode+";") == -1) {
			var r1 = field.createTextRange();
			var oldValue = r1.text;
			var newValue = found ? select.options[i][property] : oldValue;
			if (newValue != field.value) {
				field.value = newValue;
				var rNew = field.createTextRange();
				rNew.moveStart('character', oldValue.length) ;
				rNew.select();
				}
			}
		}
	}
	
// -->
function stb(){parent.document.title ="$form->{title}";}

</script>

<body bgcolor=ffffff onload=stb()>

<form method=post action=$form->{script}  name=myform>

<input type=hidden name=sort value=partnumber>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>
<tr>

  <th align=right>|.$locale->text('Trans No.').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transtypeno  size=4 value="$form->{transtypeno}">-<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=batchno size=6 value="$form->{batchno}">-<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transnono  size=4 value="$form->{transnono}"><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subtransno  size=2 value="$form->{subtransnono}"></td>

</tr>

$vc_text

<tr>

  <th align=right>|.$locale->text('From').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=datefrom size=11 value ="$form->{datefrom}" title=($myconfig{dateformat})>
  <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
     <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].datefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
  </td>
  <th align=right>|.$locale->text('To').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=dateto size=11 title=($myconfig{dateformat})>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['myform'].dateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>
    
  </td>

</tr>
<tr>

  <th align=right>|.$locale->text('Invoice Number').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=invnumber size=11></td>
  <th align=right>|.$locale->text('Order Number').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ordnumber size=20></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Project No.').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=project size=11></td>
  <th align=right>|.$locale->text('Sub No.').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subb size=20></td>

</tr>


<tr>

  <th align=right>|.$locale->text('Part Number.').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=partnono size=11></td>
  <th align=right>|.$locale->text('Item Description').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=idescno size=20></td>

</tr>



<tr>

  <th align=right>|.$locale->text('Make').qq| </th>
  <td><input name=make size=20></td>
  <th align=right>|.$locale->text('Model').qq|</th>
  <td><input name=model size=20></td>

</tr>


<tr>
<th align=right>|.$locale->text('Employee Login').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=loginno size=20></td>

</tr>

<tr>
<td colspan=4>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq|
</td>
</tr>


<tr>

  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_sr" class=checkbox type=checkbox value=Y $form->{l_invnumber}>&nbsp;|.$locale->text('SR').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transtype" class=checkbox type=checkbox value=Y $form->{l_transtype}>&nbsp;|.$locale->text('Trans').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_invnumber" class=checkbox type=checkbox value=Y $form->{l_invnumber}>&nbsp;|.$locale->text('Invoice').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_project" class=checkbox type=checkbox value=Y  $form->{l_project}>&nbsp;|.$locale->text('Project').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subb" class=checkbox type=checkbox value=Y  $form->{l_subb}>&nbsp;|.$locale->text('Sub').qq|

    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_customer" class=checkbox type=checkbox value=Y  $form->{l_customer}>&nbsp;|.$locale->text('Customer/Vendor').qq|<br>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_qtykg" class=checkbox type=checkbox value=Y  $form->{l_qtykg}>&nbsp;|.$locale->text('Qty(kg)').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_login" class=checkbox type=checkbox value=Y  $form->{l_login}>&nbsp;|.$locale->text('Employee').qq|

    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=checkbox value=Y  $form->{l_transdate}>&nbsp;|.$locale->text('Date').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_partnumber" class=checkbox type=checkbox value=Y  $form->{l_partnumber}>&nbsp;|.$locale->text('Part number').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_accno" class=checkbox type=checkbox value=Y  $form->{l_project}>&nbsp;|.$locale->text('Acc no').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_description" class=checkbox type=checkbox value=Y  $form->{l_description}>&nbsp;|.$locale->text('Description').qq|<br>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_qty" class=checkbox type=checkbox value=Y  $form->{l_qty}>&nbsp;|.$locale->text('Quantity').qq|
     <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_ordnumber" class=checkbox type=checkbox value=Y  $form->{l_ordnumber}>&nbsp;|.$locale->text('Order no').qq|
     <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subtotal" class=checkbox type=checkbox value=Y  $form->{l_subtotal}>&nbsp;|.$locale->text('Sub Total').qq|
     <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_delivery_date" class=checkbox type=checkbox value=Y  $form->{l_delivery_date}>&nbsp;|.$locale->text('Remark').qq|
     <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_remark2" class=checkbox type=checkbox value=Y  $form->{l_remark2}>&nbsp;|.$locale->text('R/2').qq|
    $str
 <input type=hidden name=readonly value=$form->{readonly}>
 <input type=hidden name=rowcount value=$form->{rowcount}>
    </td>

  </tr>

</table>
</td>

</tr>
</table>

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=transtype value=$form->{transtype}>
<input type=hidden name=print_so_mod value=$form->{print_so_mod}>
<input type=hidden name=type value=$form->{type}>
<input type=hidden name=keys >
<input type=hidden name=nextfocus value=$form->{nextfocus}>
<input type=hidden name=vc value=$form->{vc}>
<input type=hidden name=type value=$form->{type}>

<br>
<input class=submit type=submit name=action value="|.$locale->text($form->{submod}).qq|">


<input class=submit type=submit name=action value="|.$locale->text('Print '.$form->{submod}).qq|">


</form>

<p>
|.$locale->text('To display all transactions, leave fields blank')

  .qq|

</body>
</html>
|;
}



sub search_short {
$form->{datefrom} =$form->first_day_current_Date(\%myconfig) if $form->{currentdate};

  $form->{title} = $locale->text('Invoice Listing')." ".$locale->text('Reports');

  $form->header;
  if ($form->{vc} eq "customer"){
 $form->all_vc(\%myconfig, "customer") ;

  $selection = "<option selected value=''>" . $locale->text('All Customers') . "\n";

  foreach $ref (@{ $form->{all_customer} }) {
	  $selection .= "<option value='$ref->{customernumber}::$ref->{name}--$ref->{id}'>$ref->{customernumber}--$ref->{name}\n";
  }
  $vc_text=qq|<tr>
<th align=right>|.$locale->text('Customer').qq|</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=customerno onChange="this.form.accno1.value=this.options[this.selectedIndex].value">$selection</select>
		</td>

</tr>|;

}
   
   if ($form->{vc} eq "vendor"){
 $form->all_vc(\%myconfig, "vendor");

  $selectionvc = "<option selected value=''>" . $locale->text('All Vendors') . "\n";

  foreach $ref (@{ $form->{all_vendor} }) {
	  $selectionvc .= "<option value='$ref->{vendornumber}::$ref->{name}--$ref->{id}'>$ref->{vendornumber}--$ref->{name}\n";
  }
$vc_text=qq|  <tr>
<th align=right>|.$locale->text('Vendor').qq|</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=vendorno onChange="this.form.accno2.value=this.options[this.selectedIndex].value">$selectionvc</select>
		</td>

</tr>|;

 } 

if(!$form->{readonly}){
	$str=   "<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=\"l_price\" class=checkbox type=hidden value=Y $form->{l_price}>&nbsp;" if $form->{l_price};
   $str.="<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=\"l_subtotal1\" class=checkbox type=hidden value=Y  $form->{l_subtotal1}>&nbsp;"if $form->{l_subtotal1};

}
  print qq|
  
  <script>
<!--

function autoComplete (field, select, property, forcematch) {
	var found = false;
	for (var i = 0; i < select.options.length; i++) {
	if (select.options[i][property].toUpperCase().indexOf(field.value.toUpperCase()) == 0) {
		found=true; break;
		}
	}
	if (found) { select.selectedIndex = i; }
	else { select.selectedIndex = -1; }
	if (field.createTextRange) {
		if (forcematch && !found) {
			field.value=field.value.substring(0,field.value.length-1); 
			return;
			}
		var cursorKeys ="8;46;37;38;39;40;33;34;35;36;45;";
		if (cursorKeys.indexOf(event.keyCode+";") == -1) {
			var r1 = field.createTextRange();
			var oldValue = r1.text;
			var newValue = found ? select.options[i][property] : oldValue;
			if (newValue != field.value) {
				field.value = newValue;
				var rNew = field.createTextRange();
				rNew.moveStart('character', oldValue.length) ;
				rNew.select();
				}
			}
		}
	}
	function stb(){parent.document.title ="$form->{title}";}

// -->
</script>

<body bgcolor=ffffff onload=stb()>

<form method=post action=$form->{script}  name=myform>

<input type=hidden name=sort value=partnumber>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>


$vc_text

<tr>

  <th align=right>|.$locale->text('From').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=datefrom size=11 value ="$form->{datefrom}" title=($myconfig{dateformat})>
  <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
     <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].datefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
  </td>
  <th align=right>|.$locale->text('To').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=dateto size=11 title=($myconfig{dateformat})>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['myform'].dateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>
    
  </td>

</tr>
<tr>

  <th align=right>|.$locale->text('Invoice Number').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=invnumber size=11></td>
  <th align=right>|.$locale->text('Order Number').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ordnumber size=20></td>

</tr>



<tr>

  <th align=right>|.$locale->text('Part Number.').qq| </th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=partnono size=11></td>
  <th align=right>|.$locale->text('Item Description').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=idescno size=20></td>

</tr>



<tr>

  <th align=right>|.$locale->text('Make').qq| </th>
  <td><input name=make size=20></td>
  <th align=right>|.$locale->text('Model').qq|</th>
  <td><input name=model size=20></td>

</tr>
<tr>
<td colspan=4>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq|
</td>
</tr>
|;



print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_sr" class=checkbox type=hidden value=Y $form->{l_invnumber}>&nbsp;|if $form->{l_invnumber};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transtype" class=checkbox type=hidden value=Y $form->{l_transtype}>&nbsp;|if $form->{l_transtype};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_invnumber" class=checkbox type=hidden value=Y $form->{l_invnumber}>&nbsp;|if $form->{l_invnumber};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_project" class=checkbox type=hidden value=Y  $form->{l_project}>&nbsp;|if $form->{l_project};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subb" class=checkbox type=hidden value=Y  $form->{l_subb}>&nbsp;|if $form->{l_subb};

 print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_customer" class=checkbox type=hidden value=Y  $form->{l_customer}>&nbsp;|if $form->{l_customer};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_qtykg" class=checkbox type=hidden value=Y  $form->{l_qtykg}>&nbsp;|if $form->{l_qtykg};
 print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_login" class=checkbox type=hidden value=Y  $form->{l_login}>&nbsp;|if $form->{l_login};

 print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=hidden value=Y  $form->{l_transdate}>&nbsp;|if $form->{l_transdate};
 print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_partnumber" class=checkbox type=hidden value=Y  $form->{l_partnumber}>&nbsp;|if $form->{l_partnumber};
 print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_accno" class=checkbox type=hidden value=Y  $form->{l_project}>&nbsp;|if $form->{l_project};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_description" class=checkbox type=hidden value=Y  $form->{l_description}>&nbsp;|if $form->{l_description};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_qty" class=checkbox type=hidden value=Y  $form->{l_qty}>&nbsp;|if $form->{l_qty};
print qq|     <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_ordnumber" class=checkbox type=hidden value=Y  $form->{l_ordnumber}>&nbsp;|if $form->{ll_ordnumber};
print qq|     <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subtotal" class=checkbox type=hidden value=Y  $form->{l_subtotal}>&nbsp;|if $form->{l_subtotal};
print qq|     <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_delivery_date" class=checkbox type=hidden value=Y  $form->{l_delivery_date}>&nbsp;|if $form->{l_delivery_date};
print qq|     <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_remark2" class=checkbox type=hidden value=Y  $form->{l_remark2}>&nbsp;|if $form->{l_remark2};
print qq|
    $str
 <input type=hidden name=readonly value=$form->{readonly}>
 <input type=hidden name=rowcount value=$form->{rowcount}>

</table>
</td>

</tr>
</table>
<input type=hidden name=vc value=$form->{vc}>
<input type=hidden name=type value=$form->{type}>

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=transtype value=$form->{transtype}>
<input type=hidden name=print_so_mod value=$form->{print_so_mod}>
<input type=hidden name=type value=$form->{type}>
<input type=hidden name=keys >
<input type=hidden name=nextfocus value=$form->{nextfocus}>
<input type=hidden name=submod value="$form->{submod}">

<br>
<input class=submit type=submit name=action value="|.$locale->text($form->{submod}).qq|">


<input class=submit type=submit name=action value="|.$locale->text('Print '.$form->{submod}).qq|">
<input class=submit type=submit name=action value="|.$locale->text("more").qq|">


</form>

<p>
|.$locale->text('To display all transactions, leave fields blank')

  .qq|

</body>
</html>
|;
}

sub more{
 @columns = qw(parts_id transtype invnumber  project subb transdate accno customer partnumber description qty ordnumber poqty pobalance price subtotal1 qtykg  login delivery_date remark2 subtotal );
    map { $form->{"l_$_"} = "checked" if $form->{"l_$_"} eq "Y" } @columns;

 &search;
}