######################################################################
# SQL-Ledger, Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#######################################################################
#
# common routines used in is, ir, oe
#
#######################################################################

# any custom scripts for this one
if (-f "$form->{path}/custom_io.pl") {
  eval { require "$form->{path}/custom_io.pl"; };
}
if (-f "$form->{path}/$form->{login}_io.pl") {
  eval { require "$form->{path}/$form->{login}_io.pl"; };
}


1; 
# end of main


# this is for our long dates
# $locale->text('January')
# $locale->text('February')
# $locale->text('March')
# $locale->text('April')
# $locale->text('May ')
# $locale->text('June')
# $locale->text('July')
# $locale->text('August')
# $locale->text('September')
# $locale->text('October')
# $locale->text('November')
# $locale->text('December')

# this is for our short month
# $locale->text('Jan')
# $locale->text('Feb')
# $locale->text('Mar')
# $locale->text('Apr')
# $locale->text('May')
# $locale->text('Jun')
# $locale->text('Jul')
# $locale->text('Aug')
# $locale->text('Sep')
# $locale->text('Oct')
# $locale->text('Nov')
# $locale->text('Dec')


sub display_row {
  my $i = shift;

  
  #####ir.pl/is.pl , sub update() must be updated if  new information is added here 
  if ($form->{script} =~ /is/ ) {
#    @column_index = qw(sr partnumber description qty unit   sellprice  discount tax linetotal po delivery_date  remark2);
    @column_index = qw(sr partnumber description qty unit   sellprice   discount tax  linetotal taxtotal po);
  }
   if ( $form->{type} eq 'quotation' || $form->{transtype} eq 'QO') {
   @column_index = qw(sr  partnumber description qty unit   sellprice  discount ltax inetotal  taxtotal  delivery_date  );
 }

   if ( $form->{type} eq 'do' || $form->{transtype} eq 'DO') {
   @column_index = qw(sr  partnumber description qty unit      delivery_date  );
 }

 if ( $form->{type} eq 'sales_order' || $form->{transtype} eq 'SO') {
   @column_index = qw(sr  partnumber description qty unit   sellprice discount tax linetotal  taxtotal  delivery_date  );
 }
  if ($form->{type} eq 'purchase_order' || $form->{transtype} eq 'PO') {
    @column_index = qw(sr partnumber description qty unit   sellprice tax linetotal  taxtotal delivery_date);
  }
  if ($form->{script} =~ /ir/) {
    @column_index = qw(sr partnumber description qty unit   bin sellprice  tax linetotal taxtotal po);
  }

   if ( $form->{type} eq 'adjust') {
    @column_index = qw(sr partnumber description onhand qty qtybal unit   sellprice lastcost  );
  }

   if ( $form->{type} eq 'os') {
    @column_index = qw(sr partnumber description  qty unit   sellprice lastcost  );
  }
  
  if ($i == 1) {
    $form->{invsubtotal} = 0;

    $column_data{sr} = qq|<th><font color=ffffff>|.$locale->text('No.').qq|</font></th>|;
    $column_data{partnumber} = qq|<th><font color=ffffff>|.$locale->text('Number').qq|</font></th>|;
    $column_data{description} = qq|<th><font color=ffffff>|.$locale->text('Description').qq|</font></th>|;
    $column_data{onhand} = qq|<th><font color=ffffff>|.$locale->text('Onhand').qq|</font></th>|;
    $column_data{qty} = qq|<th><font color=ffffff>|.$locale->text('Qty').qq|</font></th>|;
    $column_data{qtybal} = qq|<th><font color=ffffff>|.$locale->text('Bal').qq|</font></th>|;
    $column_data{unit} = qq|<th><font color=ffffff>|.$locale->text('Unit').qq|</font></th>|;
    $column_data{sellprice} = qq|<th><font color=ffffff>|.$locale->text('Price').qq|</font></th>|;
    $column_data{lastcost} = qq|<th><font color=ffffff>|.$locale->text('Cost').qq|</font></th>|;
    $column_data{discount} = qq|<th><font color=ffffff>|.$locale->text('Disc').qq|<br>(%)</font></th>|;
    $column_data{tax} = qq|<th><font color=ffffff>|.$locale->text('Tax').qq|</font></th>|;
    $column_data{linetotal} = qq|<th><font color=ffffff>|.$locale->text('Amount').qq|</font></th>|;
    $column_data{taxtotal} = qq|<th><font color=ffffff>|.$locale->text('Total').qq|</font></th>|;
    $column_data{bin} = qq|<th><font color=ffffff>|.$locale->text('Bin').qq|</font></th>|;
    $column_data{po} = qq|<th><font color=ffffff>|.$locale->text('Order').qq|</font></th>|;
    $column_data{delivery_date} = qq|<th><font color=ffffff>|.$locale->text('Remark').qq|</font></th>|;
   $column_data{remark2} = qq|<th><font color=ffffff>|.$locale->text('R/2').qq|</font></th>|;
   $column_data{so} = qq|<th><font color=ffffff>|.$locale->text('DO').qq|</font></th>|;

   #####australia modify
    print qq|
<input type=hidden name=page value="$form->{page}">
<input type=hidden name=pagerows value="$form->{pagerows}">
<input type=hidden name=focus value="$form->{focus}">

<tr class=listheading bgcolor=336666>|;

    map { print "\n$column_data{$_}" } @column_index;

    print qq|
</tr>
|;
  }

  # undo formatting
  map { $form->{"${_}_$i"} = $form->parse_amount(\%myconfig, $form->{"${_}_$i"}) } qw(qty discount sellprice);

  ($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
  #($dec1) = ($form->{"lastcost_$i"} =~ /\.(\d+)/);
  $form->{"lastcost_$i"} =~ s/,//g;
  $dec = length $dec;
  #$dec1 = length $dec1;
  
  $decimalplaces = ($dec > 2) ? $dec : 2;
  #$decimalplaces1 = ($dec1 > 2) ? $dec1 : 2;
  
#	$sellprice=0;
 #      if ($form->{"taxincluded_$i"}) {
  #	map {$form->{"sellprice_$i"} = $form->{"sellprice_$i"}  * (1/(1+$form->{"${_}_rate"}));  } (split / /, $form->{"taxaccounts_$i"});
	#$form->{"sellprice_$i"}=$sellprice;
   #   } 
      

  
  $discount = $form->{"sellprice_$i"} * $form->{"discount_$i"}/100;
  $linetotal = $form->{"sellprice_$i"} - $discount,;
  
  
  
  
  	$tax="";
	$taxrate=0;
    if ($form->{"taxincluded_$i"}) {
   # $form->{"sellprice_$i"} =$form->{"sellprice_$i"} +$form->{"tax_$i"} ;
      map { $taxrate += $form->{"${_}_rate"} } split / /, $form->{"taxaccounts_$i"};
	$tax = $linetotal * ($taxrate / (1 + $taxrate)) ;
	#$form->{"sellprice_$i"} = $form->{"sellprice_$i"} * (1 / (1 + $taxrate));
	#$taxtotal+=$tax;
	$linetotal-=$tax;
	$tax*=-1;
	$taxtotal=$linetotal-$tax;
      } else{
      map { $tax += $form->{"${_}_rate"} * $linetotal} (split / /, $form->{"taxaccounts_$i"});
       $taxtotal= $linetotal+$tax;

      }
  
      
      
      
  $linetotal = $form->round_amount($linetotal * $form->{"qty_$i"}, 4);
 $taxtotal = $form->round_amount($taxtotal * $form->{"qty_$i"}, 4);


  # convert " to &quot;
  map { $form->{"${_}_$i"} =~ s/"/&quot;/g } qw(partnumber description unit);

  $column_data{partnumber} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="partnumber_$i" size=10 value="$form->{"partnumber_$i"}"></td>|;

  if (($rows = $form->numtextrows($form->{"description_$i"}, 30, 6)) > 1) {
    $column_data{description} = qq|<td><textarea name="description_$i" rows=$rows cols=30 wrap=soft>$form->{"description_$i"}</textarea></td>|;
  } else {
    $column_data{description} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="description_$i" size=30 value="$form->{"description_$i"}"></td>|;
  }

 # if(!$form->{"part_ordnumber_$i"}){
#  if($form->{"partnumber_$i"}){
 # $form->{"part_ordnumber_$i"} = $form->{"ordnumber"};
 #}
 #}
 
 
 #####check price list
 if ($form->{script} =~ /is/) {
   ( $form->{AR},$null ) = split /--/, $form->{AR};
   if($form->{"id_$i"}){
	    IS->all_price(\%myconfig, \%$form,$i);
	   $form->{"title_$i"}="";
	   $form->{"title2_$i"}="Partnumber : ".$form->{"partnumber_$i"} ."<br><hr>";
	     foreach $ca (@{ $form->{"ALLPRICE_$i"} }) {
		     $form->{"title_$i"}.=$ca->{transdate}." -> ".$ca->{sellprice}."   \n";
		     $form->{"title2_$i"}.=$ca->{transdate}." -> ".$ca->{sellprice}."   <br>\n";
	      }
   }
  }
  
  
   if ( ($form->{type} eq 'sales_order')) {
  ( $form->{AR},$null ) = split /--/, $form->{"accno_2"};
 		 #  $form->dberror($form->{accno_});
  if($form->{"id_$i"}){
	#   if($form->{vc} eq 'customer'){
	    IS->all_price(\%myconfig, \%$form,$i);
	#   }
	   $form->{"title_$i"}="";
	   $form->{"title2_$i"}="Partnumber : ".$form->{"partnumber_$i"} ."<br><hr>";
	     foreach $ca (@{ $form->{"ALLPRICE_$i"} }) {
		     $form->{"title_$i"}.=$ca->{transdate}." -> ".$ca->{sellprice}."   \n";
		     $form->{"title2_$i"}.=$ca->{transdate}." -> ".$ca->{sellprice}."   <br>\n";
	      }
   }
  }
  
   if ($form->{script} =~ /ir/ ) {
    ( $form->{AP},$null ) = split /--/, $form->{AP};
 if($form->{"id_$i"}){
    IR->all_price(\%myconfig, \%$form,$i);
   $form->{"title_$i"}="";
   $form->{"title2_$i"}="Partnumber : ".$form->{"partnumber_$i"} ."<br><hr>";
     foreach $ca (@{ $form->{"ALLPRICE_$i"} }) {
	     $form->{"title_$i"}.=$ca->{transdate}." -> ".$ca->{sellprice}."   \n";
	     $form->{"title2_$i"}.=$ca->{transdate}." -> ".$ca->{sellprice}."   <br>\n";
      }
 }
  } 
  
    if ( ($form->{type} eq 'purchase_order')) {
	    ( $form->{AP},$null ) = split /--/, $form->{"accno_1"};
   if($form->{"id_$i"}){
	 #  if($form->{vc} eq 'vendor'){
	 		   IR->all_price(\%myconfig, \%$form,$i);
	   
	 #  }
	   $form->{"title_$i"}="";
	   $form->{"title2_$i"}="Partnumber : ".$form->{"partnumber_$i"} ."<br><hr>";
	     foreach $ca (@{ $form->{"ALLPRICE_$i"} }) {
		     $form->{"title_$i"}.=$ca->{transdate}." -> ".$ca->{sellprice}."   \n";
		     $form->{"title2_$i"}.=$ca->{transdate}." -> ".$ca->{sellprice}."   <br>\n";
	      }
   }
  }
  
# IS->get_poqty(\%myconfig, \%$form);
####check po qty
$po_details="";
 if($form->{"part_ordnumber_$i"}){
   $form->{i} = $i;
  if ($form->{script} =~ /is/ ) {
	  IS->get_poqty(\%myconfig, \%$form);
  
  	
  }
  if ($form->{script} =~ /ir/) {
	  IS->get_poqty_ap(\%myconfig, \%$form);
  	  
  }
	  
 $lastqty=$form->{"last_parts_qty_$i"}+$form->{"qty_$i"};
  $last_balance=$form->{"ord_parts_qty_$i"}-$lastqty;
 $part_ordnumber =$form->{"part_ordnumber_$i"};
 $ord_parts_qty =  $form->{"ord_parts_qty_$i"};
  $po_details = "P/O NO : $part_ordnumber  \n P/O QTY : $ord_parts_qty \n Acc Qty Divd : $lastqty \n P/O Balance : $last_balance";
 }
 
$linetotal2=$form->format_amount(\%myconfig, $linetotal, 2);

 

####require update IS.pl -- sub update_form
   #####australia modify
   if((($i > (($form->{page}-1)*$form->{pagerows})) && ($i <= ($form->{page} *$form->{pagerows})))|| !$form->{pagebreak}){
	$printtr="true";
  $column_data{sr} = qq|<td align=center><b><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=sr_$i size=2 value="$i"></b><input type=hidden name="sr2_$i" value=$i></td>|;
  $column_data{onhand} = qq|<td align=right><input type=hidden name="onhand_$i" size=5 value="|.$form->parse_amount(\%myconfig, $form->{"onhand_$i"}).qq|">|.$form->format_amount(\%myconfig, $form->{"onhand_$i"}).qq|</td>|;
  $column_data{qty} = qq|<td align=right><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="qty_$i" size=5 value="|.$form->format_amount(\%myconfig, $form->{"qty_$i"}).qq|"></td>|;
  $column_data{qtybal} = qq|<td align=right>|.$form->format_amount(\%myconfig, ($form->{"onhand_$i"}+$form->{"qty_$i"})).qq|</td>|;
  $column_data{unit} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="unit_$i" size=5 maxsize=5 value="$form->{"unit_$i"}"></td>|;
  $column_data{sellprice} = qq|<td align=right><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="sellprice_$i" size=9 title='|.$form->{"title_$i"}.qq|' value="|.$form->format_amount(\%myconfig, $form->{"sellprice_$i"}, $decimalplaces).qq|" ></td>|;
  $column_data{lastcost} = qq|<td align=right><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="lastcost_$i" size=9 value="|.$form->format_amount(\%myconfig, $form->{"lastcost_$i"}, $decimalplaces).qq|"></td>|;
  $column_data{discount} = qq|<td align=right><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="discount_$i" size=3 value="|.$form->format_amount(\%myconfig, $form->{"discount_$i"}).qq|"></td>|;
  $column_data{tax} = qq|<td align=right>|.$form->format_amount(\%myconfig,$tax,2).qq|<input type=hidden name="tax_$i" value="$tax"></td>|;
  $column_data{linetotal} = qq|<td align=right>|.$linetotal2.qq|</td>|;
  $column_data{taxtotal} = qq|<td align=right>|.$form->format_amount(\%myconfig,$taxtotal,2).qq|</td>|;
  $column_data{bin} = qq|<td>$form->{"bin_$i"}</td>|;
  $column_data{po} = qq|<td align=right><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="part_ordnumber_$i" size=10 value="|. $form->{"part_ordnumber_$i"}.qq|" title="$po_details"><br></td>|;
  $column_data{delivery_date} = qq|<td align=right><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="delivery_date_$i" size=10 value="|. $form->{"delivery_date_$i"}.qq|"></td>|;
 $column_data{remark2} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="remark2_$i" size=4 value="$form->{"remark2_$i"}"></td>|;
 $column_data{so} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="so_$i" size=10 value="$form->{"so_$i"}"></td>|;
}else{
  $column_data{sr} = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=sr_$i type=hidden value="$i"><input type=hidden name="sr2_$i" value=$i>|;
  $column_data{partnumber} = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="partnumber_$i" type=hidden value="$form->{"partnumber_$i"}">|;
    $column_data{description} = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="description_$i" type=hidden value="$form->{"description_$i"}">|;
  $column_data{onhand} = qq|<input type=hidden name="onhand_$i" size=5 value="|.$form->format_amount(\%myconfig, $form->{"onhand_$i"}).qq|">|;
  $column_data{qty} = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="qty_$i" type=hidden value="|.$form->format_amount(\%myconfig, $form->{"qty_$i"}).qq|">|;
  $column_data{qtybal} = qq||;
  $column_data{unit} = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="unit_$i" type=hidden maxsize=5 value="$form->{"unit_$i"}">|;
  $column_data{sellprice} = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="sellprice_$i"type=hidden title='|.$form->{"title_$i"}.qq|' value="|.$form->format_amount(\%myconfig, $form->{"sellprice_$i"}, $decimalplaces).qq|" ></td>|;
  $column_data{lastcost} = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="lastcost_$i" type=hidden value="|.$form->format_amount(\%myconfig, $form->{"lastcost_$i"}, $decimalplaces1).qq|">|;
  $column_data{discount} = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="discount_$i" type=hidden value="|.$form->format_amount(\%myconfig, $form->{"discount_$i"}).qq|">|;
  $column_data{tax} = qq||;
  $column_data{linetotal} = qq||;
  $column_data{taxtotal} = qq||;
  $column_data{bin} = qq||;
  $column_data{po} = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="part_ordnumber_$i" type=hidden value="|. $form->{"part_ordnumber_$i"}.qq|" title="$po_details">|;
  $column_data{delivery_date} = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="delivery_date_$i" type=hidden value="|. $form->{"delivery_date_$i"}.qq|">|;
 $column_data{remark2} = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="remark2_$i" type=hidden value="$form->{"remark2_$i"}">|;
 $column_data{so} = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="so_$i" type=hidden value="$form->{"so_$i"}">|;
}


    $mouseaction[0]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = '';\"";


  print qq|
<tr valign=top $mouseaction[o]> |;

 print qq|

<input type=hidden name="lastcost_$i" value="$form->{"lastcost_$i"}">

<input type=hidden name="taxtotal_$i" value="$taxtotal">
<input type=hidden name="linetotal_$i" value="$linetotal">
<input type=hidden name="last_parts_qty_$i" value="$form->{"last_parts_qty_$i"}">
<input type=hidden name="ord_parts_qty_$i" value="$form->{"ord_parts_qty_$i"}">
<input type=hidden name="po_details_$i" value="$po_details">
<input type=hidden name="partnotes_$i" value=$form->{"partnotes_$i"}>
<input type=hidden name="id_$i" value=$form->{"id_$i"}>
<input type=hidden name="inventory_accno_$i" value=$form->{"inventory_accno_$i"}>
<input type=hidden name="bin_$i" value="$form->{"bin_$i"}">
<input type=hidden name="income_accno_$i" value=$form->{"income_accno_$i"}>
<input type=hidden name="expense_accno_$i" value=$form->{"expense_accno_$i"}>
<input type=hidden name="listprice_$i" value="$form->{"listprice_$i"}">
<input type=hidden name="assembly_$i" value="$form->{"assembly_$i"}">
<input type=hidden name="taxaccounts_$i" value="$form->{"taxaccounts_$i"}">
<input type=hidden name="taxincluded_$i" value="$form->{"taxincluded_$i"}">
<input type=hidden name="parts_id_$i" value="$form->{"parts_id_$i"}">

|;

  map { print "\n$column_data{$_}" } @column_index;
#if($printtr){
	
 

print qq|
</tr>|;
#}


  map { $form->{"${_}_base"} += $linetotal } (split / /, $form->{"taxaccounts_$i"});

  $form->{invsubtotal} += $linetotal;
  $form->{taxtotal} += $taxtotal;
}




sub select_item {

  @column_index = qw(cont  partnumber description  lastcost sellprice onhand unit );

  $column_data{ndx} = qq|<th>&nbsp;</th>|;
  $column_data{partnumber} = qq|<th><font color=ffffff>|.$locale->text('Number').qq|</font></th>|;
  $column_data{description} = qq|<th><font color=ffffff>|.$locale->text('Description').qq|</font></th>|;
  $column_data{lastcost} = qq|<th><font color=ffffff>|.$locale->text('Cost').qq|</font></th>|;
  $column_data{sellprice} = qq|<th><font color=ffffff>|.$locale->text('Price').qq|</font></th>|;
  $column_data{onhand} = qq|<th><font color=ffffff>|.$locale->text('Qty').qq|</font></th>|;
  $column_data{unit} = qq|<th><font color=ffffff>|.$locale->text('Unit').qq|</font></th>|;
  $column_data{cont} = qq|<th><font color=ffffff>|.$locale->text('').qq|</font></th>|;


  # list items with radio button on a form
  $form->header(1);

  $title = $locale->text('Select from one of the items below');
  $colspan = $#column_index + 1;

  print qq|

<body bgcolor=ffffff >

<form method=post action=$form->{script} name=myform>
<input type=hidden name=nextsub value=item_selected>

<table border=1>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$title</font></th></tr>

<tr class=listheading bgcolor=336666>|;

  map { print "\n$column_data{$_}" } @column_index;

  print qq|
</tr>|;

  my $i = 0;
  foreach $ref (@{ $form->{item_list} }) {
    $checked = ($i++) ? "" : "checked";

    map { $ref->{$_} =~ s/"/&quot;/g } qw(partnumber description unit);

   $column_data{ndx} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ndx class=radio type=radio value=' $i ' $checked></td>|;
   $column_data{partnumber} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_partnumber_$i" type=hidden value="$ref->{partnumber}">$ref->{partnumber}</td>|;
   $column_data{description} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_description_$i" type=hidden value="$ref->{description}">$ref->{description}</td>|;
   $column_data{lastcost} = qq|<td align=right><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_lastcost_$i" type=hidden value=$ref->{lastcost}>|.$form->format_amount(\%myconfig, $ref->{lastcost}, 2, "&nbsp;").qq|</td>|;
   $column_data{sellprice} = qq|<td align=right><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_sellprice_$i" type=hidden value=$ref->{sellprice}>|.$form->format_amount(\%myconfig, $ref->{sellprice}, 2, "&nbsp;").qq|</td>|;
   $column_data{onhand} = qq|<td align=right><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_onhand_$i" type=hidden value=$ref->{onhand}>|.$form->format_amount(\%myconfig, $ref->{onhand}, 0, "&nbsp;").qq|</td>|;
   $column_data{unit} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_unit_$i" type=hidden value="$ref->{unit}">$ref->{unit}</td>|;
   $column_data{cont} = qq|<td align=right><input class=submit type=submit name=ndx value="|.$i.qq|">
</td>|;

    $j++; $j %= 2;
    print qq|
<tr class=listrow$j>|;

    map { print "\n$column_data{$_}" } @column_index;

    print qq|
    <td>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_lastcost_$i" type=hidden value="$ref->{lastcost}">
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_bin_$i" type=hidden value="$ref->{bin}">
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_listprice_$i" type=hidden value=$ref->{listprice}>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_inventory_accno_$i" type=hidden value=$ref->{inventory_accno}>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_income_accno_$i" type=hidden value=$ref->{income_accno}>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_expense_accno_$i" type=hidden value=$ref->{expense_accno}>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_unit_$i" type=hidden value="$ref->{unit}">
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_assembly_$i" type=hidden value="$ref->{assembly}">
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_taxaccounts_$i" type=hidden value="$ref->{taxaccounts}">
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_taxincluded_$i" type=hidden value="$ref->{taxincluded}">

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_id_$i" type=hidden value=$ref->{id}>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="action" type=hidden value=continue>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="vc" type=hidden value=$form->{vc}>
</td>
    
    </tr>



|;

  }

  print qq|
</table>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=lastndx type=hidden value=$i>

|;

  # delete action variable
  delete $form->{action};
  delete $form->{item_list};
  delete $form->{header};

  # save all other form variables
  foreach $key (keys %${form}) {
    $form->{$key} =~ s/"/&quot;/g;
    print qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=$key type=hidden value="$form->{$key}">\n|;
  }

 #<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
 print qq|

<br>
</form>

</body>
</html>
|;

}

sub item_selected {

  # replace the last row with the checked row
  $i = $form->{rowcount};
  $i = $form->{assembly_rows} if ($form->{item} eq 'assembly');
 $i = $form->{combo_rows} if ($form->{item} eq 'combo');

  # index for new item
  $j = $form->{ndx};

  map { $form->{"${_}_$i"} = $form->{"new_${_}_$j"} } qw(id partnumber description sellprice listprice inventory_accno income_accno expense_accno bin unit weight assembly taxaccounts lastcost onhand);
  
   $form->{"qty_$i"} = $form->{"onhand_$i"} if ($form->{item} eq 'combo');
    
   #$form->dberror($i." ".$form->{"onhand_$i"}."  -   ".$form->{"qty_$i"});

  if($form->{script} eq 'ir.pl' || $form->{vc} eq 'vendor'){
  		$form->{"sellprice_$i"}=$form->{"lastcost_$i"};

  }
  ($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
  ($dec1) = ($form->{"lastcost_$i"} =~ /\.(\d+)/);

  $dec = length $dec;
  $dec1 = length $dec1;
  
  $decimalplaces = ($dec > 2) ? $dec : 2;  
  $decimalplaces1 = ($dec1 > 2) ? $dec1 : 2;

  # if there is an exchange rate adjust sellprice
  if (($form->{exchangerate} * 1) != 0) {
    $form->{"sellprice_$i"} /= $form->{exchangerate};
    $form->{"sellprice_$i"} = $form->round_amount($form->{"sellprice_$i"}, $decimalplaces);
  }

  $form->{sellprice} += ($form->{"sellprice_$i"} * $form->{"qty_$i"});
  $form->{weight} += ($form->{"weight_$i"} * $form->{"qty_$i"});


  # delete all the new_ variables
  for $i (1 .. $form->{lastndx}) {
    map { delete $form->{"new_${_}_$i"} } qw(partnumber description sellprice bin listprice inventory_accno income_accno expense_accno unit assembly taxaccounts id onhand);
    $form->{"parts_id_$i"}=$form->{"id_$i"};
  }

  map { delete $form->{$_} } qw(ndx lastndx nextsub);

  # format amounts
  map { $form->{"${_}_$i"} = $form->format_amount(\%myconfig, $form->{"${_}_$i"}, $decimalplaces) } qw(sellprice listprice);

  &display_form;

}


sub select_oe {

  @column_index = qw(cont  date ordnumber  tax amount status );

  $column_data{ndx} = qq|<th>&nbsp;</th>|;
  $column_data{orddate} = qq|<th><font color=ffffff>|.$locale->text('Date').qq|</font></th>|;
  $column_data{ordnumber} = qq|<th><font color=ffffff>|.$locale->text('Number').qq|</font></th>|;
  $column_data{tax} = qq|<th><font color=ffffff>|.$locale->text('tax').qq|</font></th>|;
  $column_data{amount} = qq|<th><font color=ffffff>|.$locale->text('Amount').qq|</font></th>|;
  $column_data{status} = qq|<th><font color=ffffff>|.$locale->text('Status').qq|</font></th>|;
  $column_data{cont} = qq|<th><font color=ffffff>|.$locale->text('').qq|</font></th>|;


  # list items with radio button on a form
  $form->header;

  $title = $locale->text('Select from one of the items below');
  $colspan = $#column_index + 1;

  print qq|
<script>
<!--

function set(n) 
{
               temp = document.myform.elements.length  ;
                 
               for (i=0; i < temp; i++)
	{   document.myform.elements[i].checked=n;
	   }
} 

function Invers(){

temp = document.myform.elements.length ;
                 
for (i=0; i < temp; i++){

          if(document.myform.elements[i].checked == 1){document.myform.elements[i].checked = 0;}
                else {document.myform.elements[i].checked = 1}
               
              }

}
// -->
</script>
<body bgcolor=ffffff >

<form method=post action=$form->{script} name=myform>
<input type=hidden name=nextsub value=oe_selected>

<table border=1>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$title</font></th></tr>

<tr class=listheading bgcolor=336666>|;

  map { print "\n$column_data{$_}" } @column_index;

  print qq|
</tr>|;

  my $i = 0;
  foreach $ref (@{ $form->{OE} }) {
    $checked = ($i++) ? "" : "checked";

   # map { $ref->{$_} =~ s/"/&quot;/g } qw(partnumber description unit);
    $ref->{status}= $locale->text('Open') if ($ref->{status} eq '1');
    $ref->{status}= $locale->text('Closed') if ($ref->{status} eq '2');
    $ref->{status}= $locale->text('KIV') if ($ref->{status} eq '3');

   $column_data{ndx} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ndx class=radio type=radio value=' $i ' $checked></td>|;
   $column_data{orddate} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_orddate_$i" type=hidden value="$ref->{orddate}">$ref->{orddate}</td>|;
   $column_data{ordnumber} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_ordnumber_$i" type=hidden value="$ref->{ordnumber}">$ref->{ordnumber}</td>|;
   $column_data{tax} = qq|<td align=right><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_tax_$i" type=hidden value=$ref->{tax}> $ref->{lastcost}</td>|;
   $column_data{amount} = qq|<td align=right><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_amount_$i" type=hidden value=$ref->{amount}>|.$form->format_amount(\%myconfig, $ref->{amount}, 2, "&nbsp;").qq|</td>|;
   $column_data{status} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_status_$i" type=hidden value=$ref->{status}> $ref->{status}</td>|;
   $column_data{cont} = qq|<td align=right><input class=checkbox type=checkbox  name=ndx_$i value="|.$i.qq|">
</td>|;

    $j++; $j %= 2;
    print qq|
<tr class=listrow$j>|;

    map { print "\n$column_data{$_}" } @column_index;

    print qq|
    <td>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_id_$i" type=hidden value=$ref->{id}>
</td>
    
    </tr>



|;

  }

  print qq|
</table>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=lastndx type=hidden value=$i>

|;

  # delete action variable
  delete $form->{action};
  delete $form->{OE};

  # save all other form variables
  foreach $key (keys %${form}) {
    $form->{$key} =~ s/"/&quot;/g;
    print qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=$key type=hidden value="$form->{$key}">\n|;
  }

 print qq|
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="vc" type=hidden value=$form->{vc}>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=button onclick=Invers() type=button value="|.$locale->text('Select All').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">

<br>
</form>

</body>
</html>
|;

}

sub oe_selected {

  # replace the last row with the checked row
  $i = $form->{rowcount};
  $i = $form->{assembly_rows} if ($form->{item} eq 'assembly');


  # delete all the new_ variables
  for $a (1 .. $form->{lastndx}) {
	  if($form->{"ndx_$a"}){
		  $form->{oid} = $form->{"new_id_$a"};
		  IS->import_item(\%myconfig, \%$form);

	  }
  }

  map { delete $form->{$_} } qw(ndx lastndx nextsub);
#$form->dberror($form->{"sellprice_1"});
 
  # format amounts
  map { $form->{"${_}_$i"} = $form->format_amount(\%myconfig, $form->{"${_}_$i"}, $decimalplaces) } qw(sellprice listprice);
	$form->{rowcount}--;  

  &display_form;

}


sub new_item {
  if ($form->{language_code} && $form->{"description_$form->{rowcount}"}) {
    $form->error($locale->text('Translation not on file!'));
  }
  
  # change callback
 # $form->{old_callback} = $form->{callback};
 # $form->{callback} = "$form->{script}?action=display_form";
 $form->{old_callback} = $form->escape($form->{callback},1);
  $form->{callback} = $form->escape("$form->{script}?action=display_form",1);

  # delete action
  delete $form->{action};

  # save all other form variables in a previous_form variable
   if (!$form->{previousform}) {
 foreach $key (keys %$form) {
    # escape ampersands
    $form->{$key} =~ s/&/%26/g;
   $form->{$key} =~ s/ /%20/g;
    $form->{previousform} .= qq|$key=$form->{$key}&|;
  }
  
  chop $form->{previousform};
  $form->{previousform} = $form->escape($form->{previousform},1);
}
  $i = $form->{rowcount};
map { $form->{"${_}_$i"} = $form->quote($form->{"${_}_$i"}) } qw(partnumber description);

  $form->header;

  print qq|
<body bgcolor=ffffff>

<h4><font color=red>|.$locale->text('Item not on file!').qq|</font>

<p>
|.$locale->text('What type of item is this?').qq|</h4>

<form method=post action=ic.pl>

<p>

  <input class=radio type=radio name=item value=part checked>&nbsp;|.$locale->text('Part')
.qq|<br>
  <input class=radio type=radio name=item value=service>&nbsp;|.$locale->text('Service')

.qq|
<input type=hidden name=previous_form value="$form->{previousform}">
<input type=hidden name=partnumber value="$form->{"partnumber_$i"}">
<input type=hidden name=description value="$form->{"description_$i"}">
<input type=hidden name=rowcount value=$form->{rowcount}>

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<input type=hidden name=nextsub value=add>

<p>
<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
</form>

</body>
</html>
|;

}



sub display_form {
  if ($form->{display_form}) {
    &{ "$form->{display_form}" };
    exit;
  }
  
  &form_header;
   print qq|
    <tr>
    <td colspan=10>
    <table>
    |;
  $numrows = ++$form->{rowcount};
  $subroutine = "display_row";

  if ($form->{item} eq 'part') {
    $numrows = ++$form->{makemodel_rows};
    $subroutine = "makemodel_row";
  }
  if ($form->{item} eq 'assembly' ) {
    $numrows = ++$form->{assembly_rows};
    $subroutine = "assembly_row";
  }
  if ( $form->{item} eq "combo") {
    $numrows = ++$form->{combo_rows};
    $subroutine = "combo_row";
  }
  if ($form->{item} eq 'service') {
    $numrows = 0;
  }

  # create rows
  map { &{ $subroutine }($_) } (1 .. $numrows);
 print qq|
</table></td></tr>
|;
  &form_footer;

}



sub check_form {

  my @a = ();
  my $count = 0;
  my @flds = (qw(id partnumber description qty sellprice unit discount inventory_accno income_accno expense_accno listprice taxaccounts bin assembly weight part_ordnumber));
  my $numrows;



  # remove any makes or model rows
  if ($form->{item} eq 'part') {
    map { $form->{$_} = $form->parse_amount(\%myconfig, $form->{$_}) } qw(listprice sellprice weight rop);

    for my $i (1 .. ($form->{makemodel_rows})) {
      if (($form->{"make_$i"} ne "") || ($form->{"model_$i"} ne "")) {
	push @a, {};
	my $j = $#a;

	map { $a[$j]->{$_} = $form->{"${_}_$i"} } @flds;
	$count++;
      }
    }

    $numrows = $form->{makemodel_rows};
    $form->{makemodel_rows} = $count;

  } elsif ($form->{item} eq 'assembly') {
    $form->{sellprice} = 0;
    $form->{weight} = 0;
    map { $form->{$_} = $form->parse_amount(\%myconfig, $form->{$_}) } qw(listprice rop);

    for my $i (1 .. ($form->{assembly_rows} - 1)) {
      if ($form->{"qty_$i"}) {
	push @a, {};
	my $j = $#a;

        $form->{"qty_$i"} = $form->parse_amount(\%myconfig, $form->{"qty_$i"});

	map { $a[$j]->{$_} = $form->{"${_}_$i"} } @flds;

	$form->{sellprice} += ($form->{"qty_$i"} * $form->{"sellprice_$i"});
	$form->{weight} += ($form->{"qty_$i"} * $form->{"weight_$i"});
	$count++;
      }
    }

    $form->{sellprice} = $form->round_amount($form->{sellprice}, 2);

    $numrows = $form->{assembly_rows};
    $form->{assembly_rows} = $count;

  }elsif ($form->{item} eq 'combo') {
    $form->{sellprice} = 0;
    $form->{weight} = 0;
    map { $form->{$_} = $form->parse_amount(\%myconfig, $form->{$_}) } qw(listprice rop);

    for my $i (1 .. ($form->{combo_rows} - 1)) {
	    

    if (!$form->{"delete_$i"}) {
	push @a, {};
	my $j = $#a;

        $form->{"qty_$i"} = $form->parse_amount(\%myconfig, $form->{"qty_$i"});

	map { $a[$j]->{$_} = $form->{"${_}_$i"} } @flds;

	$form->{sellprice} += ($form->{"qty_$i"} * $form->{"sellprice_$i"});
	$form->{weight} += ($form->{"qty_$i"} * $form->{"weight_$i"});
	$count++;
      }
    }

    $form->{sellprice} = $form->round_amount($form->{sellprice}, 2);

    $numrows = $form->{combo_rows};
    $form->{combo_rows} = $count;

  } else {

    # remove any empty numbers
    if ($form->{rowcount}) {
      for my $i (1 .. $form->{rowcount} - 1) {
	if ($form->{"partnumber_$i"}) {
	  push @a, {};
	  my $j = $#a;

	  map { $a[$j]->{$_} = $form->{"${_}_$i"} } @flds;
	  $count++;
	}
      }

      $numrows = $form->{rowcount};
      $form->{rowcount} = $count;

    }
  }


  # fill rows
  for $i (1 .. $count) {
   my $j = $i - 1;
    map { $form->{"${_}_$i"} = $a[$j]->{$_} } @flds;
  }

  # delete empty rows
  for $i ($count + 1 .. $numrows) {
    map { delete $form->{"${_}_$i"} } @flds;
  }

  &display_form;

}



sub continue {

  &{ $form->{nextsub} };

}



sub yes {
#	$form->dberror($form->{print_invoice_mod});
  $form->isposted(1);

}


sub no {

  $form->{callback} = qq|login.pl?action=company_logo&login=$form->{login}&sessionid=$form->{sessionid}&path=$form->{path}|;

  $form->redirect;

}


sub validate_items {

  # check if items are valid
  if ($form->{rowcount} == 1) {
    &update_form;
    exit;
  }
    
  for $i (1 .. $form->{rowcount} - 1) {
    $form->isblank("partnumber_$i", $locale->text('Number missing in Row') . " $i");
  }

}


sub keeporder {

  $form->header;
  
  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
  
<h2><font color=blue>|.$locale->text('Confirm!').qq|</font></h2>

<h4>|.$locale->text('Do you want to keep Order Number').qq| $form->{ordnumber}</h4>
<p>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes Keep Order').qq|">
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('No Delete Order').qq|">

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=callback type=hidden value="$form->{callback}">

<input type=hidden name=id value=$form->{orderid}>

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

</form>

</body>
</html>
|;

}



sub create_order {

  $form->{ordnumber} = $form->{invnumber};

  $form->{id} = '';
  $form->{new_form} = '';

  if ($form->{script} eq 'ir.pl') {
    $form->{title} = $locale->text('Add Purchase Order');
    $form->{vc} = 'vendor';
    $form->{type} = 'purchase_order';
  }
  if ($form->{script} eq 'is.pl') {
    $form->{title} = $locale->text('Add Sales Order');
    $form->{vc} = 'customer';
    $form->{type} = 'sales_order';
  }
  $form->{script} = 'oe.pl';

  $form->{rowcount}--;

  require "$form->{path}/$form->{script}";

  map { $form->{"select$_"} = "" } ($form->{vc}, currency);
    
  &order_links;

  &prepare_order;

}



sub vendor_details {

  ($null, $vendor_id) = split /--/, $form->{vendor};
  if ($vendor_id != $form->{vendor_id}) {
    $form->{vendor_id} = $vendor_id;
    IR->get_vendor(\%myconfig, \%$form);
  }

  # get address for vendor
  IR->vendor_details(\%myconfig, \%$form);
  
}



sub customer_details {

 # ($null, $customer_id) = split /--/, $form->{customer};
 # if ($customer_id != $form->{customer_id}) {
 #   $form->{customer_id} = $customer_id;
    IS->get_customer(\%myconfig, \%$form);
 # }

  IS->customer_details(\%myconfig, \%$form);
  
  foreach $key (qw(name addr1 addr2 addr3 addr4)) {
    $form->{"shipto$key"} =~ s/"/&quot;/g;
    unless ($form->{"shipto$key"}) {
      $form->{"shipto$key"} = $form->{$key};
    }
  }
				      
}


sub email_options {

  if (($rows = $form->numtextrows($form->{message}, 60, 8)) < 2) {
    $rows = 2;
  }
  $msg = qq|<textarea name=message rows=$rows cols=60 wrap=soft>$form->{message}</textarea>|;

  print qq|
  <tr>
	<td  align=right nowrap>
	  <b>|.$locale->text('E-mail').qq|</b>
 	</td>
	<td  nowrap>
	  &nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=email size=25 value="$form->{email}">
 	</td>
	<td  align=right nowrap>
	
	  <b>|.$locale->text('Subject').qq|</b>
  	</td>
	<td  nowrap>
	  &nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subject size=30 value="$form->{subject}">
  
  	</td>
  </tr>
  
  <tr><td align=right   nowrap>
    <b>|.$locale->text('Message').qq|</b>
  </td>
	<td  colspan=$colspan nowrap>
  &nbsp;$msg
  </td></tr>

|;

}


 
sub print_options {

  print qq|
  <br>
  <table>
    <tr valign=top>
      <th align=right>|.$locale->text('Document Format').qq|</th>
      <td><input class=radio type=radio name=format value=html $form->{DF}{html}> html|;

  if ($latex) {
    print qq|
    <br><input class=radio type=radio name=format value=postscript $form->{DF}{postscript}> Postscript<br>
    <input class=radio type=radio name=format value=pdf $form->{DF}{pdf}> PDF|;
  }

  print qq|</td>
  
  <th align=right>|.$locale->text('Send to').qq|</th>
  <td><input class=radio type=radio name=media value=screen $form->{OP}{screen}> |.$locale->text('Screen');

  if ($myconfig{printer} && $latex) {
    print qq|
    <br><input class=radio type=radio name=media value=printer $form->{OP}{printer}> |.$locale->text('Printer')
    .qq| (|.$locale->text('Copies')
    .qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=copies size=2 value=$form->{copies}>
	 )|;
  }

  print qq|
  <br><input class=radio type=radio name=media value=email $form->{OP}{email}> |.$locale->text('E-mail')
  .qq| (<input class=radio type=radio name=sendmode value=attachment $form->{SM}{attachment}> |.$locale->text('Attachment')
  .qq| <input class=radio type=radio name=sendmode value=inline $form->{SM}{inline}> |.$locale->text('In-line').qq|)
  </td>
  </tr>
 
  </table>
|;

}



sub print_form {

  if (($form->{format} =~ /(html|pdf)/) && ($form->{media} eq 'printer')) {
    $form->error($locale->text('Select Postscript to print to printer'));
  }

  if ($form->{type} =~ /order$/) {
    $inv = "ord";
    $due = "req";
  } else {
    $inv = "inv";
    $due = "due";
  }

   if ($form->{type} eq "receipt") {
    $inv = "orid";

  }
  $form->isblank("email", $locale->text('E-mail address missing!')) if ($form->{media} eq 'email');
  $form->isblank("${inv}number", $locale->text($form->{label} .' Number missing!'));
  $form->isblank("${inv}date", $locale->text($form->{label} .' Date missing!'));

# $locale->text('Invoice Number missing!')
# $locale->text('Invoice Date missing!')
# $locale->text('Packing List Number missing!')
# $locale->text('Packing List Date missing!')
# $locale->text('Order Number missing!')
# $locale->text('Order Date missing!')
 $form->{printtitle} =~ s/ /&nbsp;/g;
 #$form->dberror($form->{printtitle});
  &validate_items;

  &{ "$form->{vc}_details" };

  @a = ();
  map { push @a, ("partnumber_$_", "description_$_") } (1 .. $form->{rowcount});
  map { push @a, "${_}_description" } split / /, $form->{taxaccounts};
  $form->format_string(@a);
 
  # create the form variables for the invoice, packing list or order
  if ($form->{type} =~ /order$/) {
    OE->order_details(\%myconfig, \%$form);
  } else {
    IS->invoice_details(\%myconfig, \%$form);
  }
 
  #$form->{"${inv}date"} = $locale->date(\%myconfig, $form->{"${inv}date"}, 1);
  #$form->{"${due}date"} = $locale->date(\%myconfig, $form->{"${due}date"}, 1);
  if($form->{invoiceto}){
	 $form->{doheight} = 450;
  }else{
	   $form->{doheight} = 550;
  }
  # some of the stuff could have umlauts so we tranlate them
  @a = qw(name addr1 addr2 addr3 addr4
          shiptoname shiptoaddr1 shiptoaddr2 shiptoaddr3 shiptoaddr4
	  shippingpoint company address signature notes vendorcode invoiceto doheight );

  push @a, ("${inv}date", "${due}date");

  $form->format_string(@a);

  if($form->{debit} eq 1){
    $form->{type} = ($form->{type} eq 'sales_order') ? $locale->text('debit_note') : $locale->text('debit_note');
  }

 if($form->{credit} eq 1){
    $form->{type} = ($form->{type} eq 'sales_order') ? $locale->text('credit_note') : $locale->text('credit_note');
  }

  $form->{templates} = "$myconfig{templates}";
  $form->{IN} = "$form->{type}.html";

  if ($form->{format} eq 'postscript') {
    $form->{postscript} = 1;
    $form->{IN} =~ s/html$/tex/;
  }
  if ($form->{format} eq 'pdf') {
    $form->{pdf} = 1;
    $form->{IN} =~ s/html$/tex/;
  }


  if ($form->{media} eq 'printer') {
    $form->{OUT} = "| $myconfig{printer}";
  }

  if ($form->{media} eq 'email') {
    $form->{subject} = qq|$form->{label} $form->{"${inv}number"}| unless $form->{subject};

    $form->{OUT} = "$sendmail";
  }


  $form->parse_template(\%myconfig, $userspath);

  # if we got back here and we sent
  # to the printer or email let them know
  if ($form->{media} =~ /(printer|email)/) {

    $form->{email} =~ s/(<|>)//g;
    $msg = ($form->{media} eq 'printer') ? $locale->text('sent to printer') : $locale->text('emailed to')." $form->{email}";

    $form->info(qq|$form->{label} $form->{"${inv}number"} $msg|);
  }

}


sub post_as_new_invoice {

  $form->{id} = 0;
  &post_invoice;

}


sub save_as_new_order {

  $form->{id} = 0;
  &save_order;

}



#########2003-07-07
sub check_name {
  my ($name) = @_;

  my ($new_name, $new_id) = split /--/, $form->{$name};
  my $i = 0;

   
   # if we use a selection
  if ($form->{"select$name"}) {
    if ($form->{"old$name"} ne $form->{$name}) {
      # this is needed for is, ir and oe
      map { delete $form->{"${_}_rate"} } (split / /, $form->{taxaccounts});
      
      # for credit calculations
      $form->{oldinvtotal} = 0;
      $form->{oldtotalpaid} = 0;
      
      $form->{"${name}_id"} = $new_id;
      $form->{"old$name"} = "$new_name--$new_id";

      IS->get_customer(\%myconfig, \%$form) if ($name eq 'customer');
      IR->get_vendor(\%myconfig, \%$form) if ($name eq 'vendor');

      $i = 1;
    }
  } else {

    # check name, combine name and id
    if ($form->{"old$name"} ne qq|$form->{$name}--$form->{"${name}_id"}|) {
      # this is needed for is, ir and oe
      map { delete $form->{"${_}_rate"} } (split / /, $form->{taxaccounts});

      # for credit calculations
      $form->{oldinvtotal} = 0;
      $form->{oldtotalpaid} = 0;

      # return one name or a list of names in $form->{name_list}
      if (($i = $form->get_name(\%myconfig, $name)) > 1) {
	&select_name($name);
	exit;
      }

      if ($i == 1) {
	# we got one name
	$form->{"${name}_id"} = $form->{name_list}[0]->{id};
	$form->{$name} = $form->{name_list}[0]->{name};
	$form->{"old$name"} = qq|$form->{$name}--$form->{"${name}_id"}|;
	
	IS->get_customer(\%myconfig, \%$form) if ($name eq 'customer');
	IR->get_vendor(\%myconfig, \%$form) if ($name eq 'vendor');
	
      } else {
	# name is not on file
	$msg = ucfirst $name . " not on file!";
	$form->error($locale->text($msg));
      }
    }
  }

  $i;

}

# $locale->text('Customer not on file!')
# $locale->text('Vendor not on file!')



sub select_name {
  my ($table) = @_;
  
  @column_index = qw(ndx name address);

  $label = ucfirst $table;
  $column_data{ndx} = qq|<th>&nbsp;</th>|;
  $column_data{name} = qq|<th>|.$locale->text($label).qq|</th>|;
  $column_data{address} = qq|<th>|.$locale->text('Address').qq|</th>|;
  
  # list items with radio button on a form
  $form->header;

  $title = $locale->text('Select from one of the names below');

  print qq|
<body>

<form method=post action=$form->{script}>

<table width=100%>
  <tr>
    <th class=listtop>$title</th>
  </tr>
  <tr space=5></tr>
  <tr>
    <td>
      <table width=100%>
	<tr class=listheading>|;

  map { print "\n$column_data{$_}" } @column_index;
  
  print qq|
	</tr>
|;

  my $i = 0;
  foreach $ref (@{ $form->{name_list} }) {
    $checked = ($i++) ? "" : "checked";

    $ref->{name} =~ s/"/&quot;/g;
    
   $column_data{ndx} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ndx class=radio type=radio value=$i $checked></td>|;
   $column_data{name} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_name_$i" type=hidden value="$ref->{name}">$ref->{name}</td>|;
   $column_data{address} = qq|<td>$ref->{address}</td>|;
    
    $j++; $j %= 2;
    print qq|
	<tr class=listrow$j>|;

    map { print "\n$column_data{$_}" } @column_index;

    print qq|
	</tr>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="new_id_$i" type=hidden value=$ref->{id}>

|;

  }
  
  print qq|
      </table>
    </td>
  </tr>
  <tr>
    <td><hr size=3 noshade></td>
  </tr>
</table>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=lastndx type=hidden value=$i>

|;

  # delete action variable
  delete $form->{action};
  delete $form->{name_list};
    
  # save all other form variables
  foreach $key (keys %${form}) {
    $form->{$key} =~ s/"/&quot;/g;
    print qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=$key type=hidden value="$form->{$key}">\n|;
  }

  print qq|
<input type=hidden name=nextsub value=name_selected>

<input type=hidden name=vc value=$table>
<br>
<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
</form>

</body>
</html>
|;

}

