#!/usr/sbin/dtrace -qs

/*
 * Usage      : usr_func_count.d <pid>
 * Description: Count the frequency of each user function call 
 * Author     : Robert Lor
 */

BEGIN
{
	endtime = timestamp + (5 * 1000000000ull);
}

pid$1:libc::entry
{
	@count[probefunc] = count();
}

END
{
        printf("\n%20s %15s\n","Function", "Count");
        printa("%20s %@15d\n",@count);
}

/*
 * Run the script for ~10 secs and exit. Since there is processing time
 * before the probes are enabled and after they are disabled, endtime will be
 * be longer than the specified time, so adjust it accordingly.
 */
tick-1sec
/timestamp >= endtime/
{
	exit(0);
}
