#!/usr/sbin/dtrace -qs

/*
 * Usage      : lwlock_wait.d <pid>
 * Description: Show number and total time of LWLock waits by lock id and mode
 * Author     : Robert Lor
 */

dtrace:::BEGIN
{
	lckmode[0] = "Exclusive";
	lckmode[1] = "Shared";

	lckid[0] = "BufMappingLock";
	lckid[1] = "BufFreelistLock";
	lckid[2] = "ShmemIndexLock";
	lckid[3] = "OidGenLock";
	lckid[4] = "XidGenLock";
	lckid[5] = "ProcArrayLock";
	lckid[6] = "SInvalLock";
	lckid[7] = "FreeSpaceLock";
	lckid[8] = "WALInsertLock";
	lckid[9] = "WALWriteLock";
	lckid[10] = "ControlFileLock";
	lckid[11] = "CheckpointLock";
	lckid[12] = "CheckpointStartLock";
	lckid[13] = "CLogControlLock";
	lckid[14] = "SubtransControlLock";
	lckid[15] = "MultiXactGenLock";
	lckid[16] = "MultiXactOffsetControlLock";
	lckid[17] = "MultiXactMemberControlLock";
	lckid[18] = "RelCacheInitLock";
	lckid[19] = "BgWriterCommLock";
	lckid[20] = "TwoPhaseStateLock";
	lckid[21] = "TablespaceCreateLock";
	lckid[22] = "BtreeVacuumLock";
	lckid[23] = "FirstLockMgrLock";

	endtime = timestamp + (5 * 1000000000ull);
}

postgresql$1:::lwlock-startwait
/arg0 < 24/
{
	self->ts[arg0]=timestamp; 
	@count[lckid[arg0], lckmode[arg1]] = count();
}

postgresql$1:::lwlock-endwait
/(arg0 < 24) && self->ts[arg0]/
{
    @time[lckid[arg0]] = sum (timestamp - self->ts[arg0]);
    self->ts[arg0]=0;
}

dtrace:::END {
        printf("\n%20s %15s %15s\n", "Lock Id", "Mode", "Count");
        printa("%20s %15s %@15d\n",@count);

        printf("\n%20s %20s\n", "Lock Id", "Combined Time (ns)");
        printa("%20s %@20d\n",@time);
}

/*
 * Run the script for ~10 secs and exit. Since there is processing time
 * before the probes are enabled and after they are disabled, endtime will be
 * be longer than the specified time, so adjust it accordingly.
 */
tick-1sec
/timestamp >= endtime/
{
        exit(0);
}
