#include "_int.h"

//#define __DEBUG__
#define __XMLPGXPATH__

/**
 * inner function for xpsql
 */
static bool	inner_int_leftmatch(ArrayType *a, ArrayType *b);
static bool	inner_int_leftnmatch(ArrayType *a, ArrayType *b,int nm);
static bool	inner_int_ancestor_or_self(ArrayType *a, ArrayType *b);

/*
 ** XPath based methods
 */
PG_FUNCTION_INFO_V1( _int_child );
PG_FUNCTION_INFO_V1( _int_descendant );
PG_FUNCTION_INFO_V1( _int_descendant_or_self );
PG_FUNCTION_INFO_V1( _int_following_sibling );
PG_FUNCTION_INFO_V1( _int_following );
PG_FUNCTION_INFO_V1( _int_parent );
PG_FUNCTION_INFO_V1( _int_ancestor );
PG_FUNCTION_INFO_V1( _int_ancestor_or_self );
PG_FUNCTION_INFO_V1( _int_preceding );
PG_FUNCTION_INFO_V1( _int_preceding_sibling );

Datum	_int_child(PG_FUNCTION_ARGS);
Datum	_int_descendant(PG_FUNCTION_ARGS);
Datum	_int_descendant_or_self(PG_FUNCTION_ARGS);
Datum	_int_following_sibling(PG_FUNCTION_ARGS);
Datum	_int_following(PG_FUNCTION_ARGS);
Datum	_int_parent(PG_FUNCTION_ARGS);
Datum	_int_ancestor(PG_FUNCTION_ARGS);
Datum	_int_ancestor_or_self(PG_FUNCTION_ARGS);
Datum	_int_preceding(PG_FUNCTION_ARGS);
Datum	_int_preceding_sibling(PG_FUNCTION_ARGS);

/*
** integer array access method
*/
PG_FUNCTION_INFO_V1(last);
PG_FUNCTION_INFO_V1(next_sibling);
PG_FUNCTION_INFO_V1(previous_sibling);
PG_FUNCTION_INFO_V1( _int_to_numstr);
PG_FUNCTION_INFO_V1( _int_dependant );
PG_FUNCTION_INFO_V1( _int_flagment );
PG_FUNCTION_INFO_V1( _int_vdim );
PG_FUNCTION_INFO_V1( _int_ndim_eq );
PG_FUNCTION_INFO_V1(_int_ge);
PG_FUNCTION_INFO_V1(_int_gt);
PG_FUNCTION_INFO_V1(_int_le);
PG_FUNCTION_INFO_V1(_int_lt);
PG_FUNCTION_INFO_V1(intarray_abs_cmp);

Datum last(PG_FUNCTION_ARGS);
Datum next_sibling(PG_FUNCTION_ARGS);
Datum previous_sibling(PG_FUNCTION_ARGS);
Datum _int_to_numstr(PG_FUNCTION_ARGS);
Datum _int_dependant(PG_FUNCTION_ARGS);
Datum _int_flagment(PG_FUNCTION_ARGS);
Datum _int_vdim(PG_FUNCTION_ARGS);
Datum _int_ndim_eq(PG_FUNCTION_ARGS);
Datum _int_ge(PG_FUNCTION_ARGS);
Datum _int_gt(PG_FUNCTION_ARGS);
Datum _int_le(PG_FUNCTION_ARGS);
Datum _int_lt(PG_FUNCTION_ARGS);
Datum intarray_abs_cmp(PG_FUNCTION_ARGS);


// --
static bool
inner_int_leftmatch(ArrayType *a, ArrayType *b)
{
	int			nb;
	int			i,
				n;
	int		   *da,
			   *db;

	if (ARRISVOID(a) || ARRISVOID(b))
		return FALSE;

	nb = ARRNELEMS(b);
	da = ARRPTR(a);
	db = ARRPTR(b);

	i = n = 0;

	for( ;i<nb;i++){
        if (da[i] == db[i])
        	n++;
    }

	return (n == nb) ? TRUE : FALSE;
}

static bool
inner_int_leftnmatch(ArrayType *a, ArrayType *b,int nm)
{
	int			i,
				n,
				nb;
	int		   *da,
			   *db;

	if (ARRISVOID(a) || ARRISVOID(b))
		return FALSE;

	nb = ARRNELEMS(b);

	if( nb < nm)
		return FALSE;

	da = ARRPTR(a);
	db = ARRPTR(b);

	i = n = 0;

	for( ;i<nm;i++){
        if (da[i] == db[i])
        	n++;
    }

	return (n == nm) ? TRUE : FALSE;
}

static bool
inner_int_ancestor_or_self(ArrayType *a, ArrayType *b)
{
	int			na,
				nb;
	int			i,
				n;
	int		   *da,
			   *db;

	if (ARRISVOID(a) || ARRISVOID(b))
		return FALSE;

	na = ARRNELEMS(a);
	nb = ARRNELEMS(b);

	if(na > nb)
		return FALSE;

	da = ARRPTR(a);
	db = ARRPTR(b);

	i = n = 0;

	for( ;i<na;i++){
        if (da[i] != db[i])
        	return FALSE;
    }

	return TRUE;
}

/*****************************************************************************
 * int array access method
 *****************************************************************************/

Datum
last(PG_FUNCTION_ARGS)
{
	ArrayType  *a = (ArrayType *) DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	int	na = ARRNELEMS(a);
	int	*da = ARRPTR(a);

	PG_RETURN_INT32(da[na-1]);
}

Datum
next_sibling(PG_FUNCTION_ARGS)
{
	ArrayType  *a = (ArrayType *) DatumGetPointer(PG_DETOAST_DATUM_COPY(PG_GETARG_DATUM(0)));
	int	na = ARRNELEMS(a);
	int	*da = ARRPTR(a);

	da[na-1] = da[na-1] + 1;

	PG_RETURN_POINTER(a);
}

Datum
previous_sibling(PG_FUNCTION_ARGS)
{
	ArrayType  *a = (ArrayType *) DatumGetPointer(PG_DETOAST_DATUM_COPY(PG_GETARG_DATUM(0)));
	int	na = ARRNELEMS(a);
	int	*da = ARRPTR(a);

	da[na-1] = da[na-1] - 1;

	PG_RETURN_POINTER(a);
}

Datum
_int_to_numstr(PG_FUNCTION_ARGS)
{
	ArrayType *a = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	int			na,
				i;
	size_t		len;
	int		   *da;
	text	   *result;
	char		tmp[11];
	char	   *ptr;

	if (ARRISVOID(a))
		PG_RETURN_BOOL(FALSE);

	na = ARRNELEMS(a);
	da = ARRPTR(a);

	len = sizeof(tmp) * na + VARHDRSZ;
	result = (text *) palloc(len);

	/* Set size of result string... */
	VARATT_SIZEP(result) = len;

	/* Fill data field of result string... */
	ptr = VARDATA(result);
	for( i=0;i<na;i++){
		sprintf(tmp,"%011d",da[i]);
		memcpy(ptr+i*11, tmp, 11);
    }

	//pfree(a);
	PG_RETURN_TEXT_P(result);
}

Datum
_int_dependant(PG_FUNCTION_ARGS)
{
	ArrayType *a = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType *b = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	bool		res;
	int	na = ARRNELEMS(a);
	int	nb = ARRNELEMS(b);
	int	*da = ARRPTR(a);
	int	*db = ARRPTR(b);
	
	if (ARRISVOID(a) || ARRISVOID(b))
		PG_RETURN_BOOL(FALSE);

	/* document is same? */
	if(da[1] != db[1])
		PG_RETURN_BOOL(FALSE);
	if(na==1 || nb==1)
		PG_RETURN_BOOL(FALSE);

	if( na != nb+1)
		PG_RETURN_BOOL(FALSE);

	/* abount dependant-node */
	if(da[na-1]!=0 || db[nb-1]==0)
		PG_RETURN_BOOL(FALSE);

	res = inner_int_leftmatch(a, b);
	PG_RETURN_BOOL( res );
}

Datum
_int_flagment(PG_FUNCTION_ARGS)
{
	ArrayType *a = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType *b = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	int	na = ARRNELEMS(a);
	int	nb = ARRNELEMS(b);
	int	*da = ARRPTR(a);
	int	*db = ARRPTR(b);
	
	if (ARRISVOID(a) || ARRISVOID(b))
		PG_RETURN_BOOL(FALSE);

#ifdef __XMLPGXPATH__
	if(da[1] != db[1])
		PG_RETURN_BOOL(FALSE);
	if(na==1 || nb==1)
		PG_RETURN_BOOL(FALSE);
#endif

	if( na < nb)
		PG_RETURN_BOOL(FALSE);

	PG_RETURN_BOOL( inner_int_leftmatch(a, b) );
}

Datum
_int_vdim(PG_FUNCTION_ARGS)
{
	ArrayType *a = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	int32 nth = PG_GETARG_INT32(1);
	int	*da = ARRPTR(a);
	
	if( ARRISVOID(a))
		PG_RETURN_NULL();

	if( nth < 1)
		PG_RETURN_NULL();

	if( ARRNELEMS(a) < nth)
		PG_RETURN_NULL();
	
	PG_RETURN_INT32(da[nth-1]);
}

Datum
_int_ndim_eq(PG_FUNCTION_ARGS)
{
	ArrayType *a = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	int32 nth = PG_GETARG_INT32(1);
	int32 cmp = PG_GETARG_INT32(2);
	int	*da = ARRPTR(a);
	
	if( ARRISVOID(a))
		PG_RETURN_BOOL(FALSE);

	if( nth < 1)
		PG_RETURN_BOOL(FALSE);

	if( ARRNELEMS(a) != nth)
		PG_RETURN_BOOL(FALSE);

	if( da[nth-1] != cmp)
		PG_RETURN_BOOL(FALSE);
	
	//pfree(a);
	PG_RETURN_BOOL(TRUE);
}

Datum
_int_gt(PG_FUNCTION_ARGS)
{
	ArrayType  *a = (ArrayType *) DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType  *b = (ArrayType *) DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	int	na = ARRNELEMS(a);
	int	nb = ARRNELEMS(b);
	int	*da = ARRPTR(a);		// target
	int	*db = ARRPTR(b);		// compare with
	int i;
	
#ifdef __DEBUG__
	elog(NOTICE,"_int_gt");
#endif
	
	for(i=0;i<nb;i++)
	{	
		if(na > i)
		{
			if(da[i] < db[i])
				PG_RETURN_BOOL(FALSE);
			if(da[i] > db[i])
				PG_RETURN_BOOL(TRUE);
			// da[i] == db[i]
			if(na <= nb && inner_int_leftnmatch(a,b,na))
				PG_RETURN_BOOL(FALSE);
			//else break;
		}
	}

	PG_RETURN_BOOL(TRUE);
}

Datum
_int_ge(PG_FUNCTION_ARGS)
{
	ArrayType  *a = (ArrayType *) DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType  *b = (ArrayType *) DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	int	na = ARRNELEMS(a);
	int	nb = ARRNELEMS(b);
	int	*da = ARRPTR(a);		// target
	int	*db = ARRPTR(b);		// compare with
	int i;

#ifdef __DEBUG__
	elog(NOTICE,"_int_ge");
#endif

	for(i=0;i<nb;i++)
	{	
		if(na > i)
		{
			if(da[i] < db[i])
				PG_RETURN_BOOL(FALSE);
			if(da[i] > db[i])
				PG_RETURN_BOOL(TRUE);
			// da[i] == db[i]
			if(na < nb && inner_int_leftnmatch(a,b,na))
				PG_RETURN_BOOL(FALSE);
		}
	}

	PG_RETURN_BOOL(TRUE);
}

Datum
_int_lt(PG_FUNCTION_ARGS)
{
	ArrayType  *a = (ArrayType *) DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType  *b = (ArrayType *) DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	int	na = ARRNELEMS(a);		// target
	int	nb = ARRNELEMS(b);		// compare with
	int	*da = ARRPTR(a);
	int	*db = ARRPTR(b);
	int i;

#ifdef __DEBUG__
	elog(NOTICE,"_int_lt");
#endif

	for(i=0;i<nb;i++)
	{		
		if(i<na)
		{
			if(da[i] < db[i])
				PG_RETURN_BOOL(TRUE);
			if(da[i] > db[i])
				PG_RETURN_BOOL(FALSE);
			if(i==nb-1)	// da[i]==db[i]
				PG_RETURN_BOOL(FALSE);
		}
		else
			break;
	}

	PG_RETURN_BOOL(TRUE);
}

Datum
_int_le(PG_FUNCTION_ARGS)
{
	ArrayType  *a = (ArrayType *) DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType  *b = (ArrayType *) DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	int	na = ARRNELEMS(a);		// target 
	int	nb = ARRNELEMS(b);		// compare with
	int	*da = ARRPTR(a);
	int	*db = ARRPTR(b);
	int i;

#ifdef __DEBUG__
	elog(NOTICE,"_int_le");
#endif

	for(i=0;i<nb;i++)
	{		
		if(i<na)
		{
			if(da[i] < db[i])
				PG_RETURN_BOOL(TRUE);
			if(da[i] > db[i])
				PG_RETURN_BOOL(FALSE);
			if(i==nb-1)	// da[i]==db[i]
			{	
				if(na==nb) 
					PG_RETURN_BOOL(TRUE);
				PG_RETURN_BOOL(FALSE);
			}
		}
		else
			break;
			//PG_RETURN_BOOL(FALSE);
	}

	PG_RETURN_BOOL(TRUE);
}

Datum
intarray_abs_cmp(PG_FUNCTION_ARGS)
{
	ArrayType  *a = (ArrayType *) DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType  *b = (ArrayType *) DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	int	na = ARRNELEMS(a);		//compare with
	int	nb = ARRNELEMS(b);		//target
	int	*da = ARRPTR(a);
	int	*db = ARRPTR(b);
	int i;

#ifdef __DEBUG__
	elog(NOTICE,"intarray_abs_cmp");
#endif

	// less than
	// greater than
	for(i=0;i<nb;i++)
	{	
		if(i<na)
		{
			if(da[i] < db[i])
				PG_RETURN_INT32(-1);
			if(da[i] > db[i])
				PG_RETURN_INT32(1);
			/* no more loop is caused */
			if(i==nb-1)	//&& da[i]==db[i]
			{
				if(na==nb)
					PG_RETURN_INT32(0);
				else 	//if(na>nb)
					PG_RETURN_INT32(1);
			}
		}
		else // i>=na
		{
			PG_RETURN_INT32(-1);
		}
	}
	
	// equal
	PG_RETURN_INT32(0);
}

/*****************************************************************************
 * XPath based Function
 *****************************************************************************/
 
Datum
_int_child(PG_FUNCTION_ARGS)
{
	ArrayType *a = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType *b = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	bool		res;
	int	na = ARRNELEMS(a);
	int	nb = ARRNELEMS(b);
	int	*da = ARRPTR(a);
	int	*db = ARRPTR(b);
	
	if (ARRISVOID(a) || ARRISVOID(b))
		PG_RETURN_BOOL(FALSE);

#ifdef __XMLPGXPATH__
	/* document is same? */
	if(da[1] != db[1])
		PG_RETURN_BOOL(FALSE);
	/* is root ? */
	if(na==1 || nb==1)
		PG_RETURN_BOOL(FALSE);
#endif

	if( na != nb+1)
		PG_RETURN_BOOL(FALSE);

#ifdef __XMLPGXPATH__
	/* about dependant-node */
	if(db[nb-1]==0 || da[na-1]==0)
		PG_RETURN_BOOL(FALSE);
#endif

	res = inner_int_leftmatch(a, b);;
	PG_RETURN_BOOL( res );
}

Datum
_int_descendant(PG_FUNCTION_ARGS)
{
	ArrayType *a = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType *b = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	bool		res;
	int	na = ARRNELEMS(a);
	int	nb = ARRNELEMS(b);
	int	*da = ARRPTR(a);
	int	*db = ARRPTR(b);

	if (ARRISVOID(a) || ARRISVOID(b))
		PG_RETURN_BOOL(FALSE);

#ifdef __XMLPGXPATH__
	if(da[1] != db[1])
		PG_RETURN_BOOL(FALSE);
	if(na==1 || nb==1)
		PG_RETURN_BOOL(FALSE);
#endif

	if( na <= nb)
		PG_RETURN_BOOL(FALSE);

#ifdef __XMLPGXPATH__
	if(da[na-1]==0 || db[nb-1]==0)
		PG_RETURN_BOOL(FALSE);
#endif

	res = inner_int_leftmatch(a, b);
	PG_RETURN_BOOL( res );
}

Datum
_int_descendant_or_self(PG_FUNCTION_ARGS)
{
	ArrayType *a = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType *b = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	int	na = ARRNELEMS(a);
	int	nb = ARRNELEMS(b);
	int	*da = ARRPTR(a);
	int	*db = ARRPTR(b);
	
	if (ARRISVOID(a) || ARRISVOID(b))
		PG_RETURN_BOOL(FALSE);

#ifdef __XMLPGXPATH__
	if(da[1] != db[1])
		PG_RETURN_BOOL(FALSE);
	if(na==1 || nb==1)
		PG_RETURN_BOOL(FALSE);
#endif

	if( na < nb)
		PG_RETURN_BOOL(FALSE);

#ifdef __XMLPGXPATH__
	if(na!=nb && da[na-1]==0)
		PG_RETURN_BOOL(FALSE);
#endif

	PG_RETURN_BOOL( inner_int_leftmatch(a, b) );
}

Datum
_int_following_sibling(PG_FUNCTION_ARGS)
{
	ArrayType *a = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType *b = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	int	na = ARRNELEMS(a);
	int	nb = ARRNELEMS(b);
	int		pref = nb-1;
	bool		res;
	int		   *da,
			   *db;

	if (ARRISVOID(a) || ARRISVOID(b))
		PG_RETURN_BOOL(FALSE);

	da = ARRPTR(a);
	db = ARRPTR(b);

#ifdef __XMLPGXPATH__
	if(da[1] != db[1])
		PG_RETURN_BOOL(FALSE);
	if(na==1 || nb==1)
		PG_RETURN_BOOL(FALSE);
#endif

	if( na != nb)
		PG_RETURN_BOOL(FALSE);

#ifdef __XMLPGXPATH__
	if(db[nb-1]==0 || da[na-1]==0)
		PG_RETURN_BOOL(FALSE);
#endif

	if(da[pref] <= db[pref])
		PG_RETURN_BOOL(FALSE);

	res = inner_int_leftnmatch(a, b, pref);
	PG_RETURN_BOOL( res );
}

Datum
_int_following(PG_FUNCTION_ARGS)
{
	ArrayType *a = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType *b = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	int		  na = ARRNELEMS(a);
	int		  nb = ARRNELEMS(b);
	int		   *da,
			   *db;
	bool	res = FALSE;
	int		i;

	if (ARRISVOID(a) || ARRISVOID(b))
		PG_RETURN_BOOL(FALSE);

	da = ARRPTR(a);
	db = ARRPTR(b);

#ifdef __XMLPGXPATH__
	if(da[1] != db[1])
		PG_RETURN_BOOL(FALSE);
	if(na==1 || nb==1)
		PG_RETURN_BOOL(FALSE);

	if(da[na-1]==0)
		PG_RETURN_BOOL(FALSE);
#endif

	for( i=0; i<nb && i<na; i++){
    	if(da[i] > db[i]){
			res = TRUE;
			break;
    	}
    	if(da[i] < db[i]){
    		res = FALSE;
    		break;
    	}
    }

	PG_RETURN_BOOL( res );
}

Datum
_int_parent(PG_FUNCTION_ARGS)
{
	ArrayType *a = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType *b = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	int		  pref = ARRNELEMS(b)-1;
	bool		res;
	int	na = ARRNELEMS(a);
	int	*da = ARRPTR(a);
	int	*db = ARRPTR(b);
	
	if (ARRISVOID(a) || ARRISVOID(b))
		PG_RETURN_BOOL(FALSE);

#ifdef __XMLPGXPATH__
	if(da[1] != db[1])
		PG_RETURN_BOOL(FALSE);
	if(na==1 || ARRNELEMS(b)==1)
		PG_RETURN_BOOL(FALSE);
#endif

	if( na != pref)
		PG_RETURN_BOOL(FALSE);

#ifdef __XMLPGXPATH__
	if(da[na-1]==0)
		PG_RETURN_BOOL(FALSE);
#endif

	res = inner_int_leftnmatch(a, b, pref);
	PG_RETURN_BOOL( res );
}

Datum
_int_ancestor(PG_FUNCTION_ARGS)
{
	ArrayType *a = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType *b = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	bool		res;
	int	na = ARRNELEMS(a);
	int nb = ARRNELEMS(b);
	int	*da = ARRPTR(a);
	int *db = ARRPTR(b);

	if (ARRISVOID(a) || ARRISVOID(b))
		PG_RETURN_BOOL(FALSE);

#ifdef __XMLPGXPATH__
	if(da[1] != db[1])
		PG_RETURN_BOOL(FALSE);
	if(na==1 || nb==1)
		PG_RETURN_BOOL(FALSE);

#endif

	if( na >= nb)
		PG_RETURN_BOOL(FALSE);

#ifdef __XMLPGXPATH__
	if(da[na-1]==0)
		PG_RETURN_BOOL(FALSE);
#endif

	res = inner_int_ancestor_or_self(a, b);
	PG_RETURN_BOOL( res );
}

Datum
_int_ancestor_or_self(PG_FUNCTION_ARGS)
{
	ArrayType *a = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType *b = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	bool		res;
	int	na = ARRNELEMS(a);
	int nb = ARRNELEMS(b);
	int	*da= ARRPTR(a);
	int	*db= ARRPTR(b);
	
	if (ARRISVOID(a) || ARRISVOID(b))
		PG_RETURN_BOOL(FALSE);

#ifdef __XMLPGXPATH__
	if(da[1] != db[1])
		PG_RETURN_BOOL(FALSE);
	if(na==1 || nb==1)
		PG_RETURN_BOOL(FALSE);

#endif

#ifdef __XMLPGXPATH__
	if(na!=nb && da[na-1]==0)
		PG_RETURN_BOOL(FALSE);
#endif

	res = inner_int_ancestor_or_self(a, b);
	PG_RETURN_BOOL( res );
}

Datum
_int_preceding(PG_FUNCTION_ARGS)
{
	ArrayType *a = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType *b = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	int		  na = ARRNELEMS(a);
	int		  nb = ARRNELEMS(b);
	int		   *da,
			   *db;
	bool	res = FALSE;
	int		i;

	if (ARRISVOID(a) || ARRISVOID(b))
		PG_RETURN_BOOL(FALSE);

	da = ARRPTR(a);
	db = ARRPTR(b);

#ifdef __XMLPGXPATH__
	if(da[1] != db[1])
		PG_RETURN_BOOL(FALSE);
	if(na==1 || nb==1)
		PG_RETURN_BOOL(FALSE);
#endif

#ifdef __XMLPGXPATH__
	if(da[na-1]==0)
		PG_RETURN_BOOL(FALSE);
#endif

	for( i=0;i<nb;i++){
        if (na > i){ 
        	if(da[i] < db[i])
				res = TRUE;
	    	if(da[i] > db[i]){
	    		res = FALSE;
	    		break;
	    	}
        }
    }

	PG_RETURN_BOOL( res );
}

Datum
_int_preceding_sibling(PG_FUNCTION_ARGS)
{
	ArrayType *a = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(0)));
	ArrayType *b = (ArrayType *)DatumGetPointer(PG_DETOAST_DATUM(PG_GETARG_DATUM(1)));
	int		  na = ARRNELEMS(a);
	int		  nb = ARRNELEMS(b);
	int		pref = nb-1;
	bool		res;
	int		   *da,
			   *db;

	if (ARRISVOID(a) || ARRISVOID(b))
		PG_RETURN_BOOL(FALSE);

	da = ARRPTR(a);
	db = ARRPTR(b);

#ifdef __XMLPGXPATH__
	if(da[1] != db[1])
		PG_RETURN_BOOL(FALSE);
	if(na==1 || nb==1)
		PG_RETURN_BOOL(FALSE);
#endif

	if( na != nb)
		PG_RETURN_BOOL(FALSE);

#ifdef __XMLPGXPATH__
	if(db[nb-1]==0 || da[na-1]==0)
		PG_RETURN_BOOL(FALSE);
#endif

	if(da[pref] >= db[pref])
		PG_RETURN_BOOL(FALSE);

	res = inner_int_leftnmatch(a, b, pref);
	PG_RETURN_BOOL( res );
}

