/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2002
*
* CLASS TextDataInput v 0.1                                                   
* Descripcion:
* Esta clase se encarga de manejar el dialogo a traves del
* cual se inserta un dato de tipo "text" en una tabla.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class TextDataInput extends JDialog implements ActionListener {
 
 Language idiom;
 JTextArea data;
 String dataText = "";
 boolean wellDone = false;

 public TextDataInput(JDialog dialog, Language leng, String fieldName, String previewStr) {

    super(dialog, true);
    setTitle(fieldName);
    idiom = leng;

    JPanel global = new JPanel();
    global.setLayout(new BoxLayout(global,BoxLayout.Y_AXIS));

    data = new JTextArea(10,35);
    data.setText(previewStr);

    JScrollPane textScroll = new JScrollPane(data);

    JPanel scrollPanel = new JPanel();
    scrollPanel.add(textScroll);

    JButton ok = new JButton(idiom.getWord("OK"));
    ok.setActionCommand("OK");
    ok.addActionListener(this);
    JButton clear = new JButton(idiom.getWord("CLR"));
    clear.setActionCommand("CLEAR");
    clear.addActionListener(this);
    JButton cancel = new JButton(idiom.getWord("CANCEL"));
    cancel.setActionCommand("CANCEL");
    cancel.addActionListener(this);

    JPanel botons = new JPanel();
    botons.setLayout(new FlowLayout(FlowLayout.CENTER));
    botons.add(ok);
    botons.add(clear);
    botons.add(cancel);

    global.add(scrollPanel);
    global.add(botons);

    getContentPane().add(global);
    pack();
    setLocationRelativeTo(dialog);
    setVisible(true);
  }

 public void actionPerformed(java.awt.event.ActionEvent e) {

   if (e.getActionCommand().equals("OK")) {
       dataText = data.getText(); 
       wellDone = true;
       setVisible(false);
    }

   if (e.getActionCommand().equals("CANCEL")) {
       setVisible(false);
    }

   if (e.getActionCommand().equals("CLEAR")) {
       data.setText("");
    }
  }

 public String getValue() {
    return dataText;
  }

 public boolean isWellDone() {
    return wellDone;
  }

}
