/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS Queries v 0.1                                                   
* Descripcion:
* Esta clase se encarga del manejo la pestaa de consultas, incluye 
* mtodos para realizar, guardar, exportar una consulta.           
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*          Angela Sandobal  - angesand@libertad.univalle.edu.co     
*/

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.lang.String;
import java.io.*;
import java.util.Vector;
import javax.swing.border.*;
import java.net.URL;

public class Queries extends JPanel implements ActionListener,SwingConstants,FocusListener,KeyListener {

 JToolBar QueryBar;
 JSplitPane splitQueries;  //Panel redimensionable para consultas
 JMenuBar menuQry;	
 JPanel upBlock;
 JTextField title;
 JTextArea queryX, LogWin;
 JButton newQuery,loadQuery,saveQuery,runQuery,exportResult,functions,hqQuery;
 final JPopupMenu popup = new JPopupMenu();
 final JPopupMenu popup1 = new JPopupMenu();
 PGConnection pgConn;
 JTable table;
 JPanel downComponent;
 JScrollPane windowX;
 Vector resultGlobal;
 Vector columnNamesG;
 Object[] columnNames;
 Object[][] data;
 TitledBorder title1, title2;
 JRadioButton toFile,toReport;
 int exportTo = -1;
 Color currentColor;
 Vector columnas = new Vector();
 Vector datos = new Vector();
 String select = "";
 JFrame app;
 Language idiom;
 String ghostText="";
 boolean copy = false;
 boolean control = false;
 SQLFunctionDataStruc[] funcList;
 SQLFuncBasic[] funcBasicSQL;
 JLabel queryRight,queryLeft;
 Vector queryBag = new Vector();
 int indexR = 0;
 int indexL = 0;

 /**
  * METODO CONSTRUCTOR 
  *
  */
  public Queries (JFrame frame,Language glossary,JTextArea monitor,SQLFunctionDataStruc[] fList,SQLFuncBasic[] fbasic) 
  {
   app = frame;
   idiom = glossary;
   LogWin = monitor;
   funcList = fList;
   funcBasicSQL = fbasic;

   setLayout(new BorderLayout());

   QueryBar = new JToolBar(SwingConstants.VERTICAL);
   menuQry = new JMenuBar();    
   CreateToolBar();

   title = new JTextField(idiom.getWord("QUERYS"));  
   title.setHorizontalAlignment(JTextField.CENTER); 
   title.setEditable(false);

   upBlock = new JPanel();
   upBlock.setLayout(new BorderLayout());  

   JPanel auxBar = new JPanel();        // Panel donde va el toolbar de querys y el menu de funciones
   auxBar.setLayout(new BorderLayout());
   Border margin = BorderFactory.createBevelBorder(BevelBorder.LOWERED);
   auxBar.setBorder(margin);

   QueryBar.setFloatable(false);
   JPanel Space = new JPanel();
   Space.setLayout(new FlowLayout());
   Space.add(QueryBar);

   auxBar.add(Space,BorderLayout.NORTH);
   exportResult = new JButton(idiom.getWord("OK"));
   exportResult.setActionCommand("ButtonExport");
   exportResult.addActionListener(this);
   exportResult.setEnabled(false);
   JPanel tmp = new JPanel();
   tmp.setLayout(new CardLayout());

   toFile = new JRadioButton(idiom.getWord("FILE"));
   toFile.setMnemonic(idiom.getNemo("NEMO-FILE")); 
   toFile.setActionCommand("ExportToFile");
   toFile.addActionListener(this);

   toReport = new JRadioButton(idiom.getWord("REP"));
   toReport.setMnemonic(idiom.getNemo("NEMO-REP")); 
   toReport.setActionCommand("ExportToReport");
   toReport.addActionListener(this);

   JPanel tmp2 = new JPanel();
   tmp2.setLayout(new BoxLayout(tmp2, BoxLayout.Y_AXIS));

   tmp2.add(toFile);
   tmp2.add(toReport);

   tmp.add("Check1",exportResult); 

   JPanel altern = new JPanel();
   altern.setLayout(new BorderLayout());
   altern.add(tmp2,BorderLayout.CENTER);
   altern.add(tmp,BorderLayout.SOUTH);

   Border etched1 = BorderFactory.createEtchedBorder();
   title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("EXPTO"));
   currentColor = title1.getTitleColor();
   altern.setBorder(title1);

   auxBar.add(altern,BorderLayout.SOUTH);

   URL imgURLeft = getClass().getResource("icons/queryLeft.png");
   queryLeft = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURLeft)));
   queryLeft.setEnabled(false);
   queryLeft.setToolTipText(idiom.getWord("QHIST"));

   URL imgURight = getClass().getResource("icons/queryRight.png");
   queryRight = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURight)));
   queryRight.setEnabled(false);
   queryRight.setToolTipText(idiom.getWord("QHIST"));

   JPanel buttonsQ = new JPanel();
   buttonsQ.setLayout(new GridLayout(0,2));
   buttonsQ.add(queryLeft);
   buttonsQ.add(queryRight);

   MouseListener mouseListener = new MouseAdapter()
     {
       public void mousePressed(MouseEvent e)
        {
          if(queryLeft.isEnabled())
           {
            if(indexL==0)
               queryLeft.setEnabled(false);

            String sql = (String) queryBag.elementAt(indexL);

            if(indexL!=0)
              indexL--;

            indexR = indexL + 1;

            if(!newQuery.isEnabled())
             newQuery.setEnabled(true);

            queryX.setText(sql);            

            if(!queryRight.isEnabled() && (queryBag.size()>1) && (indexR < queryBag.size()))
                queryRight.setEnabled(true);

           }
        }
     };

   MouseListener mouseListener2 = new MouseAdapter()
     {
       public void mousePressed(MouseEvent e)
        {
          if(queryRight.isEnabled())
           {
            if(indexR == 1)
             if(!queryLeft.isEnabled())
                 queryLeft.setEnabled(true);

            String sql = (String) queryBag.elementAt(indexR);
            queryX.setText(sql);

            if(indexR == queryBag.size()-1)
             queryRight.setEnabled(false);

            indexL = indexR - 1;
            indexR++;
           }
        }
     };

   queryLeft.addMouseListener(mouseListener);
   queryRight.addMouseListener(mouseListener2);

   JPanel frameButton = new JPanel();
   frameButton.add(buttonsQ);

   upBlock.add(frameButton,BorderLayout.WEST);
   upBlock.add(title,BorderLayout.CENTER);

   JPanel northPanel = new JPanel();
   northPanel.setLayout(new BorderLayout());
   northPanel.add(upBlock);
   title1 = BorderFactory.createTitledBorder(etched1);
   northPanel.setBorder(title1);

   SplitQuery();
   add(northPanel,BorderLayout.NORTH);
   add(auxBar,BorderLayout.EAST);
 }

 /**
  * METODO SplitQuery 
  * Hace el Split Panel de Consultas 
  */
 public void SplitQuery ()
  {  
   queryX = new JTextArea("");
   queryX.setEditable(true);
   queryX.addFocusListener(this); 

   MouseListener mouseListener = new MouseAdapter() {

    public void mousePressed(MouseEvent e) {

       if (e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e)) {

           HotQueries hotQ = new HotQueries(app,idiom);

           if (hotQ.isWellDone()) 
               loadSQL(hotQ.getSQL(),hotQ.isReady());
        }
      }
    };

   queryX.addMouseListener(mouseListener);

   JScrollPane component = new JScrollPane(queryX);
   splitQueries = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
   splitQueries.setTopComponent(component);
   showQueryResult(new Vector(),new Vector());   
   splitQueries.setBottomComponent(downComponent);
   splitQueries.setOneTouchExpandable(true); //el SplitPane muestra controles que permiten al 					   
   add(splitQueries,BorderLayout.CENTER);

  splitQueries.setDividerLocation(135); //Selecciona u obtiene la posicin actual del divisor. 
  splitQueries.setPreferredSize(new Dimension(400,200));
 }

 /**
  * METODO CreateToolBar
  * Crea Barra de Iconos 
  */
 public void CreateToolBar()
 {
  URL imgURL = getClass().getResource(idiom.getWord("ICONNEW"));
  newQuery = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  newQuery.setActionCommand("ButtonNewQuery");
  newQuery.addActionListener(this);
  newQuery.setToolTipText(idiom.getWord("NEWQ") + " [F2]");
  QueryBar.add(newQuery);

  imgURL = getClass().getResource(idiom.getWord("ICONFUNC"));
  functions = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  functions.setToolTipText(idiom.getWord("FUNC") + " [F3]");

  JMenu menuSQL = new JMenu(idiom.getWord("FSQL")); 

  JMenu menuSQLBasic = new JMenu(idiom.getWord("FNTR"));
  JMenu menuCREATE = new JMenu("CREATE");
  JMenu menuALTER = new JMenu("ALTER");
  JMenu menuDROP = new JMenu("DROP");

  String[] funcSQL = {"DELETE","GRANT","REVOKE","SELECT","UPDATE"};

  String[] componentSQL = {"AGGREGATE","CONSTRAINT TRIGGER","DATABASE","FUNCTION","GROUP","INDEX","LANGUAGE","OPERATOR","RULE","SEQUENCE","TABLE","TABLE AS","TRIGGER","TYPE","USER","VIEW"};

  int[] indexALTER = {4,10,14}; 

  int countSKL = 0;

  for(int m=0;m<3;m++)
  {
   JMenuItem Item = new JMenuItem(componentSQL[indexALTER[m]]);
   String action = "SKL" + countSKL;
   countSKL++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuALTER.add(Item);
  }

  menuSQLBasic.add(menuALTER);

  for(int m=0;m<16;m++)
  {
   JMenuItem Item = new JMenuItem(componentSQL[m]);
   String action = "SKL" + countSKL;
   countSKL++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuCREATE.add(Item);
  }

  menuSQLBasic.add(menuCREATE);

  JMenuItem ItemOut = new JMenuItem(funcSQL[0]);
  String actionOut = "SKL" + countSKL;
  //System.out.println("SKL: " + countSKL);
  countSKL++;
  ItemOut.setActionCommand(actionOut);
  ItemOut.addActionListener(this);
  menuSQLBasic.add(ItemOut);

  for(int m=0;m<16;m++)
  {
   if(m != 1 && m != 11)
    {
     JMenuItem Item = new JMenuItem(componentSQL[m]);
     String action = "SKL" + countSKL;
     countSKL++;
     Item.setActionCommand(action);
     Item.addActionListener(this);
     menuDROP.add(Item);
    }
  }

  menuSQLBasic.add(menuDROP);

  for(int m=1;m<5;m++)
  {
   JMenuItem Item = new JMenuItem(funcSQL[m]);
   String action = "SKL" + countSKL;
   countSKL++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuSQLBasic.add(Item);
  }

  int counter = 0;

  JMenu menuSQLAdv = new JMenu(idiom.getWord("FSTR2"));

  String[] funcSQLAdv = {"COALESCE","NULLIF","CASE"};

  for(int m=0;m<3;m++)
  {
   JMenuItem Item = new JMenuItem(funcSQLAdv[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuSQLAdv.add(Item);
  }

  menuSQL.add(menuSQLBasic);
  menuSQL.add(menuSQLAdv);
  popup.add(menuSQL);

  JMenu menuMath = new JMenu(idiom.getWord("FMATH"));

  JMenu menuNoTrans = new JMenu(idiom.getWord("FNTR")); 

  String[] funcNoTrans = {"ABS","DEGREES","EXP","LN","LOG","PI","POW","RADIANS","ROUND","SQRT","CBRT","TRUNC","FLOAT","FLOAT4","INTEGER"};

  for(int m=0;m<15;m++)
  {
   JMenuItem Item = new JMenuItem(funcNoTrans[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuNoTrans.add(Item);
  }

  JMenu menuTrans = new JMenu(idiom.getWord("FTR"));

  String[] funcTrans = {"ACOS","ASIN","ATAN","ATAN2","COS","COT","SIN","TAN"};

  for(int m=0;m<8;m++)
  {
   JMenuItem Item = new JMenuItem(funcTrans[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuTrans.add(Item);
  }

  menuMath.add(menuNoTrans);
  menuMath.add(menuTrans);
  popup.add(menuMath);

  JMenu menuString = new JMenu(idiom.getWord("FSTR"));

  JMenu menu92 = new JMenu(idiom.getWord("FSTR1"));

  String[] funcStrings = {"CHAR_LENGTH","CHARACTER_LENGTH","LOWER","OCTECT_LENGTH","POSITION","SUBSTRING","TRIM","UPPER"};

  for(int m=0;m<8;m++)
  {
   JMenuItem Item = new JMenuItem(funcStrings[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menu92.add(Item);
  }

  JMenu menuOther = new JMenu(idiom.getWord("FSTR2"));

  String[] funcOthers = {"CHAR","INITCAP","LPAD","LTRIM","TEXTPOS","RPAD","RTRIM","SUBSTR","TEXT","TRANSLATE","VARCHAR"};

  for(int m=0;m<11;m++)
  {
   JMenuItem Item = new JMenuItem(funcOthers[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuOther.add(Item);
  }

  menuString.add(menu92);
  menuString.add(menuOther);
  popup.add(menuString);

  JMenu menuDate = new JMenu(idiom.getWord("FDATE"));

  String[] funcDate = {"ABSTIME","AGE","DATE_PART","DATE_TRUNC","INTERVAL","ISFINITE","RELTIME","TIMESTAMP","TO_CHAR"};

  for(int m=0;m<9;m++)
  {
   JMenuItem Item = new JMenuItem(funcDate[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuDate.add(Item);
  }

  popup.add(menuDate);

  JMenu menuFormat = new JMenu(idiom.getWord("FDATEF"));

  String[] funcFormat = {"TO_CHAR","TO_DATE","TO_TIMESTAMP","TO_NUMBER"};

  for(int m=0;m<4;m++)
  {
   JMenuItem Item = new JMenuItem(funcFormat[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuFormat.add(Item);
  }

  popup.add(menuFormat);

  JMenu menuGeo = new JMenu(idiom.getWord("FGEO"));

  JMenu menuBasic = new JMenu(idiom.getWord("FGEO1"));

  String[] funcBasic = {"AREA","BOX","CENTER","DIAMETER","HEIGHT","ISCLOSED","ISOPEN","LENGTH","PCLOSE","NPOINT","POPEN","RADIUS","WIDTH"};

  for(int m=0;m<13;m++)
  {
   JMenuItem Item = new JMenuItem(funcBasic[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuBasic.add(Item);
  }

  JMenu menuTC = new JMenu(idiom.getWord("FGEO2"));

  String[] funcTC = {"BOX","CIRCLE","LSEG","PATH","POINT","POLYGON"};

  for(int m=0;m<6;m++)
  {
   JMenuItem Item = new JMenuItem(funcTC[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuTC.add(Item);
  }

  JMenu menuUpgrade = new JMenu(idiom.getWord("FGEO3"));

  String[] funcUpgrade = {"ISOLDPATH","REVERTPOLY","UPGRADEPATH","UPGRADEPOLY"};

  for(int m=0;m<4;m++)
  {
   JMenuItem Item = new JMenuItem(funcUpgrade[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuUpgrade.add(Item);
  }

  menuGeo.add(menuBasic);
  menuGeo.add(menuTC);
  menuGeo.add(menuUpgrade);

  popup.add(menuGeo);

  JMenu menuIP = new JMenu(idiom.getWord("FIPV4"));

  String[] funcIP = {"BROADCAST","HOST","MASKLEN","NETMASK"};

  for(int m=0;m<4;m++)
  {
   JMenuItem Item = new JMenuItem(funcIP[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuIP.add(Item);
  }

  popup.add(menuIP);

  MouseListener mouseListener = new MouseAdapter() 
     {
       public void mousePressed(MouseEvent e) 
        {
          if (!popup.isVisible())
             popup.show(e.getComponent(),68,0);
        }
     };

  functions.addMouseListener(mouseListener);
  QueryBar.add(functions);

  imgURL = getClass().getResource(idiom.getWord("ICONHQ"));
  hqQuery = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  hqQuery.setActionCommand("ButtonHQuery");
  hqQuery.addActionListener(this);
  hqQuery.setToolTipText(idiom.getWord("HQ") + " [F8]");
  QueryBar.add(hqQuery);

  imgURL = getClass().getResource(idiom.getWord("ICONOPEN"));
  loadQuery = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  loadQuery.setActionCommand("ButtonLoadQuery");
  loadQuery.addActionListener(this);
  loadQuery.setToolTipText(idiom.getWord("OPENQ") + " [F4]");
  QueryBar.add(loadQuery);

  imgURL = getClass().getResource(idiom.getWord("ICONSAVE"));  
  saveQuery = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  saveQuery.setActionCommand("ButtonSaveQuery");
  saveQuery.addActionListener(this);
  saveQuery.setToolTipText(idiom.getWord("SAVEQ") + " [F5]");
  QueryBar.add(saveQuery);
		
  imgURL = getClass().getResource(idiom.getWord("ICONRUN"));
  runQuery = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  runQuery.setActionCommand("ButtonRunQuery");
  runQuery.addActionListener(this);
  runQuery.setToolTipText(idiom.getWord("RUNQ") + " [F9]");
  QueryBar.add(runQuery);
 }		

 public void setNullPanel() {

  title.setText(idiom.getWord("DSCNNTD"));
  newQuery.setEnabled(false); 
  hqQuery.setEnabled(false);
  functions.setEnabled(false);
  loadQuery.setEnabled(false);
  saveQuery.setEnabled(false);
  runQuery.setEnabled(false); 
  exportResult.setEnabled(false);

  queryX.setText("");
  queryX.setEditable(false);
  queryLeft.setEnabled(false);
  queryRight.setEnabled(false);
  showQueryResult(new Vector(),new Vector());
 } 

 public void showQueryResult(Vector rowData,Vector columnNames)
 {
   columnas = columnNames;
   datos = rowData;

   String[] colNames = new String[columnNames.size()];
   Object[][] rowD = new Object[rowData.size()][columnNames.size()];
   String title = "";

   if(columnNames.size()>0)
   {
     for(int p=0;p<columnNames.size();p++)
      {
       Object o = columnNames.elementAt(p);
       colNames[p] = o.toString();
      }

     for(int p=0;p<rowData.size();p++)
     { 
       Vector tempo = (Vector) rowData.elementAt(p);
       for(int j=0;j<columnNames.size();j++)
        {
         Object o = tempo.elementAt(j);
         rowD[p][j] = o;
        }
      }
      String regTitle = idiom.getWord("RECS"); 

      if(rowData.size() == 1)
         regTitle = regTitle.substring(0,regTitle.length()-1);

      title = idiom.getWord("RES2") + " [" + rowData.size() + " " + regTitle + "]";
   }
   else 
     title = idiom.getWord("NORES");
	 
   MyTableModel myModel = new MyTableModel(rowD,colNames);
   table = new JTable(myModel);
   downComponent = new JPanel();
   JLabel titleResult = new JLabel(title,JLabel.CENTER);
   if(title.equals(idiom.getWord("NORES"))) 
    {
      titleResult.setEnabled(false);
      title1.setTitleColor(new Color(153,153,153));
      toFile.setSelected(false);
      toReport.setSelected(false);
      toFile.setEnabled(false);
      toReport.setEnabled(false);
    }
   else 
    {
      title1.setTitleColor(currentColor);
      titleResult.setEnabled(true);
      toFile.setEnabled(true);
      toReport.setEnabled(true);
    }

   updateUI();           
   JPanel upPan = new JPanel();  
   upPan.setLayout(new BorderLayout());
   upPan.add(titleResult,BorderLayout.CENTER);
   JButton buttonEmpty = new JButton(); 
   buttonEmpty.setPreferredSize(new Dimension (132,2)); 
   upPan.add(buttonEmpty,BorderLayout.SOUTH); 
   downComponent.setLayout(new BorderLayout());
   downComponent.add(upPan,BorderLayout.NORTH);
   windowX = new JScrollPane(table); 
   downComponent.add(windowX,BorderLayout.CENTER);
   splitQueries.setBottomComponent(downComponent);
   splitQueries.setDividerLocation(135);
  } 

 public void actionPerformed(java.awt.event.ActionEvent e) {

 if(e.getActionCommand().equals("ExportToFile"))
  {
   if(toFile.isSelected())
     {
      exportTo = 1;
      toReport.setSelected(false);
      exportResult.setEnabled(true);
    }
   else
      toReport.setSelected(true);
   return;
  }

 if(e.getActionCommand().equals("ExportToReport"))
  {
   if(toReport.isSelected())
    {
     exportTo = 2;
     toFile.setSelected(false);
     exportResult.setEnabled(true);
    }
   else 
     toFile.setSelected(true);
   return;
  }

 if(e.getActionCommand().equals("ButtonNewQuery") )
  {
   NewQuery();
   return;
  }

 if(e.getActionCommand().equals("ButtonLoadQuery") )
  {
   LoadQuery();
   return;
  }

 if(e.getActionCommand().equals("ButtonHQuery") )
  {
   HotQueries hotQ = new HotQueries(app,idiom);
   if (hotQ.isWellDone())
       loadSQL(hotQ.getSQL(),hotQ.isReady());

   return;
  }
 
 if(e.getActionCommand().equals("ButtonSaveQuery") )
  {
   SaveQuery();
  return;
 }

 if(e.getActionCommand().equals("ButtonRunQuery") )
  {
    RunQuery(queryX.getText());
    return;
  }

 if(e.getActionCommand().equals("ButtonExport"))
  {
    if(exportTo == 1) {
    ExportSeparatorField little = new ExportSeparatorField(app,idiom);
    little.setSize(260,150);
    little.pack();
    little.setLocationRelativeTo(app);
    little.show();
    if(little.isDone()) 
      {
        String limiter = little.getLimiter();
          
        String s = "file:" + System.getProperty("user.dir");
        File file;
        boolean Rewrite = true;
        String FileName = "";
        JFileChooser fc = new JFileChooser(s);                 
        if(limiter.equals("csv"))
         {
           ExtensionFilter filter = new ExtensionFilter("csv",idiom.getWord("REPCSV")); 
           fc.addChoosableFileFilter(filter);
         }
        int returnVal = fc.showDialog(app,idiom.getWord("EXPTO"));

        if (returnVal == JFileChooser.APPROVE_OPTION) 
          {
           file = fc.getSelectedFile();
           FileName = file.getAbsolutePath(); // Camino Absoluto
           if(file.exists())
             { 
               BoolOption win = new BoolOption(app,idiom.getWord("YES"),idiom.getWord("NO"),idiom.getWord("ADV"),
               idiom.getWord("FILE") + " \"" + FileName + "\" " + idiom.getWord("SEQEXIS2") + " " + idiom.getWord("OVWR"));
               /* win.pack();
               win.setLocationRelativeTo(app);
               win.show(); */
               Rewrite = win.getSelecction();
             } 
           if(Rewrite)
             { 
               try {
                     if(limiter.equals("csv") && !FileName.endsWith(".csv"))
                        FileName += ".csv"; 
                     PrintStream exportFile = new PrintStream(new FileOutputStream(FileName));
          	     printFile(exportFile,resultGlobal,columnNamesG,limiter);
	           }
               catch(Exception ex) 
                   {  
                     System.out.println("Error: " + ex);
                     ex.printStackTrace();
                   }
             }
              
          } 
          else 
           {
            toFile.setSelected(false);
            exportTo = -1;
            exportResult.setEnabled(false);
           }
        }
       else {
             toFile.setSelected(false);
             exportTo = -1;
             exportResult.setEnabled(false);
            }
     }
    else {
           if(exportTo == 2)
            {
             ReportDesigner format = new ReportDesigner(app,columnas,datos,idiom,LogWin,
                                                        getTablesN(select),pgConn);
             exportTo = -1;
             toReport.setSelected(false);
             exportResult.setEnabled(false);
            }
         }

     return;
    }

 if(e.getActionCommand().startsWith("POP")) 
  {
   String number = e.getActionCommand().substring(3);
   int m = new Integer(number).intValue();

   setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
   String html = funcList[m].getHtml(); 
   SQLFunctionDisplay showHelp = new SQLFunctionDisplay(idiom,app,html);
   showHelp.pack();
   showHelp.setLocationRelativeTo(app);
   setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
   showHelp.show();

   if(showHelp.isUsed())
     {
      String text = queryX.getText();
      int lengthText = text.length();

      String funcName = showHelp.getFuncName();
      int pos = queryX.getCaretPosition();
      queryX.insert(funcName,pos);

      if(lengthText < 1)
         newQuery.setEnabled(true);
     } 

   return;
  }

  if(e.getActionCommand().startsWith("SKL"))
  {
   String number = e.getActionCommand().substring(3);
   int m = new Integer(number).intValue();

   setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
   String html = funcBasicSQL[m].getHtml();

   SQLFunctionDisplay showHelp = new SQLFunctionDisplay(idiom,app,html);
   showHelp.pack();
   showHelp.setLocationRelativeTo(app);
   setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
   showHelp.show();

   return;
  }

 }

 public static String clearSpaces (String inS)
  {
   String valid = "";

   if((inS.indexOf("  ") != -1) || (inS.indexOf("\t") != -1) || (inS.indexOf("\n") != -1))
    {
     int x = 0;
     while (x < inS.length()-1)      
      {
        char w = inS.charAt(x);
        if (w == '\t'  && ( inS.charAt(x+1) != ' ') && ( inS.charAt(x+1) != '\t') && ( inS.charAt(x+1) != '\n' ) && (x!=0) && ( inS.charAt(x+1) != ';'))
          valid = valid + " ";
	if (w == '\t'  && (( inS.charAt(x+1) == ' ') || ( inS.charAt(x+1) == '\t') || ( inS.charAt(x+1) == '\n') || ( inS.charAt(x+1) == ';')))
	  valid = valid + "";
        if ( w == ' ' && ( inS.charAt(x+1) != ' ') && ( inS.charAt(x+1) != '\t') && ( inS.charAt(x+1) != '\n') && (x!=0) && ( inS.charAt(x+1) != ';'))
          valid = valid + w;
	if (w == ' '  && ( (x==0) || ( inS.charAt(x+1) == ' ') || ( inS.charAt(x+1) == '\t') || ( inS.charAt(x+1) != '\n') || ( inS.charAt(x+1) == ';')))
	  valid = valid + "";
	if ( w == '\n' && ( inS.charAt(x+1) != ' ') && ( inS.charAt(x+1) != '\t') && ( inS.charAt(x+1) != '\n' ) && ( inS.charAt(x+1) != ';'))
	  valid = valid + " ";
	if ( w == '\n' && (( inS.charAt(x+1) == ' ') || ( inS.charAt(x+1) == '\t') || ( inS.charAt(x+1) == '\n' ) || ( inS.charAt(x+1) == ';')))
	  valid = valid + "";
	if ( w != ' ' && w != '\t' && w != '\n')
	  valid = valid + w;
        x++;
      }
      char w = inS.charAt(inS.length()-1);
      if((w != '\n') && (w != '\t') && (w != ' '))
          valid = valid + w;
     }
     else
       valid = inS;

    while(valid.startsWith(" "))
      valid = valid.substring(1,valid.length());

    while(valid.endsWith(" "))
      valid = valid.substring(0,valid.length()-1);
				       
    return valid; 
 }

 public void setTextLabel(String mxg)
  {
    popup.setEnabled(false);
    title.setText(mxg);
  }

 public void setLabel(String dbName)
  {
   popup.setEnabled(true);
   String mesg = "";
   if(dbName.length()>0)
    mesg = idiom.getWord("QUERYS") + idiom.getWord("IN") + idiom.getWord("DB: "); 
   else
    mesg = idiom.getWord("QUERYS");

    title.setText(mesg + dbName);
  }

 public void focusGained(FocusEvent e) 
  {
    Component tmp = e.getComponent();
    tmp.addKeyListener(this);
  }

 public void focusLost(FocusEvent e) 
  {
    Component tmp = e.getComponent();
    tmp.removeKeyListener(this);
  } 

 public void keyTyped(KeyEvent e) 
  {
  }   

 public void keyPressed(KeyEvent e) 
  {
   String queryString = queryX.getText();

   int keyC = e.getKeyCode();
   String keyS = KeyEvent.getKeyText(keyC);

   if(keyS.equals("F2"))
    {
     if(newQuery.isEnabled())
      {
       NewQuery();
      }
     return;
    }

   if(keyS.equals("F3"))
    {
     if(functions.isEnabled())
      { 
        if (!popup.isVisible())
             popup.show(functions,63,0);
      }
    }

   if(keyS.equals("F4"))
    {
     if(loadQuery.isEnabled())
      {
       LoadQuery();
      }
     return;
    }

   if(keyS.equals("F5"))
    {
     if(saveQuery.isEnabled())
      {
       SaveQuery();
      }
     return;
    }

   if(keyS.equals("F8"))
    {
     HotQueries hotQ = new HotQueries(app,idiom);

     if (hotQ.isWellDone())
         loadSQL(hotQ.getSQL(),hotQ.isReady());

     return;
    }

   if(keyS.equals("F9"))
    {
     if(runQuery.isEnabled())
      {
       RunQuery(queryString);
      }
     return;
    }
  
   int width = queryString.length(); 
   if(width > 15)
    { 
     newQuery.setEnabled(true);
     saveQuery.setEnabled(true);
     runQuery.setEnabled(true);
    } 
   else 
    {  
     saveQuery.setEnabled(false);
     runQuery.setEnabled(false);
     if(width > 0) 
       newQuery.setEnabled(true);
     else
       newQuery.setEnabled(false); 
    } 

  } 

 public void keyReleased(KeyEvent e) 
  {
  } 

 class MyTableModel extends AbstractTableModel 
  {

  public MyTableModel(Object[][] xdata,String[] colN) 
   {
    data = xdata;
    columnNames = colN;
   }
	     
  public String getColumnName(int col) 
   { 
    return columnNames[col].toString(); 
   }

  public int getRowCount() 
   { 
    return data.length; 
   }

  public int getColumnCount() 
   { 
    return columnNames.length; 
   }

  public Object getValueAt(int row, int col) 
   {
    return data[row][col]; 
   }

  public boolean isCellEditable(int row, int col) 
   { 
    return false; 
   }

  public void setValueAt(Object value, int row, int col) 
   {
    data[row][col] = value;
    fireTableCellUpdated(row, col);
   }
 }

public void printFile(PrintStream xfile,Vector registers,Vector FieldNames,String Separator)
 {
   String limit = "";
   boolean isCSV = false; 
   try {
        int TableWidth = FieldNames.size();
        if(Separator.equals("csv"))
         {
           limit = ",";
           isCSV = true;
         }
        else 
         {
          limit = Separator;
          for(int p=0;p<TableWidth;p++) 
           {
            String column = (String) FieldNames.elementAt(p);
            xfile.print(column);
            if(p<TableWidth-1)
              xfile.print(limit);
           }
          xfile.print("\n");
         }

        for(int p=0;p<registers.size();p++) 
          {
           Vector rData = (Vector) registers.elementAt(p); 
           for(int i=0;i<TableWidth;i++) 
            {
             Object o = rData.elementAt(i);
	     String field = o.toString();

             if(isCSV)
	      xfile.print("\"" + field + "\"");
             else
              xfile.print(field);

             if(i<TableWidth-1)
              xfile.print(limit);
            }
           xfile.print("\n");
          }

       }
       catch(Exception e) 
        { 
        }
 }

 public void QuerySaver(PrintStream saveFile,String instructions)
  {
     instructions = clearSpaces(instructions); 
     int k=0;
     int i=0;
     String oneQ = "";
     while(k != -1)
       { 
         k = instructions.indexOf(";",i);	

         if(k!=-1)
           {
            oneQ = instructions.substring(i,k+1);
	    i = k + 1;
            oneQ = oneQ.trim();
           }
          else

            oneQ = instructions.substring(i,instructions.length());
          saveFile.println(oneQ);
       }
     try 
       {
         saveFile.close();
       }
     catch(Exception ex)
       {
       }
  }

 /**
  * Metodo addTextLogMonitor
  * Imprime mensajes en el Monitor de Eventos
  */
 public void addTextLogMonitor(String msg)
 {
  LogWin.append(msg + "\n");	
  int longiT = LogWin.getDocument().getLength();
  if(longiT > 0)
    LogWin.setCaretPosition(longiT - 1);
 }	

 public void RunQuery(String querys) 
  {
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

    String proofStr = clearSpaces(querys);
    int j;
    Vector oneI = new Vector();
    if ( proofStr.endsWith(";"))
     {
       j = 0;
       int k = 0;
       while(true)
        {
          k = proofStr.indexOf(";",j);
          if ( k == -1 )
             break;
          oneI.addElement(proofStr.substring(j,k+1));			     
          j = k + 1;
        } 
     }
    else
     {
      JOptionPane.showMessageDialog(Queries.this,                               
      idiom.getWord("IVIC"),                       
      idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);               
     }

    boolean noMore = false;
    int numSelect = 0;

    for ( int i=0; i < oneI.size(); i++)
    {
      Object o = oneI.elementAt(i);
      String sentence = o.toString().trim();
      String val = "OK";
      String queryLow = sentence.toLowerCase();

      if (sentence.equals(";")) 
          continue;

      if(queryLow.startsWith("select")) 
       {
        resultGlobal = pgConn.TableQuery(sentence);

        if(pgConn.queryFail()) 
         {
          val = pgConn.getProblemString();
          val = val.substring(0,val.length()-1);
         }
       }
      else 
       {
        String result = pgConn.SQL_Instruction(sentence);

        if(!result.equals("OK")) 
            result = result.substring(0,result.length()-1);

        val = result;
       }

      addTextLogMonitor(idiom.getWord("EXEC") + sentence + "\"");
      addTextLogMonitor(idiom.getWord("RES") + val);

      if(queryLow.startsWith("select"))
       {
          numSelect++;

	  if(!noMore)
	  { 
           select = sentence;
           columnNamesG = pgConn.TableHeader;
           showQueryResult(resultGlobal,columnNamesG);
	   noMore = true;
	  }
       }
    }

    if(numSelect>1)
     {
       JOptionPane.showMessageDialog(Queries.this,
       idiom.getWord("SSQ"),
       idiom.getWord("INFO"),JOptionPane.INFORMATION_MESSAGE);
     }

    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

  }

public void NewQuery()
  {
     queryRight.setEnabled(false);
     String sql = queryX.getText();

     if(sql.length()>0)
      {
       String tmp = "";

       if(!queryBag.isEmpty())
        {         
         tmp = (String) queryBag.elementAt(queryBag.size()-1);
        }

       if(!sql.equals(tmp))
        {
         queryBag.addElement(sql);
         indexL = queryBag.size() - 1;
         indexR = indexL;
        }
      }

     queryX.setText("");
     exportResult.setEnabled(false);
     showQueryResult(new Vector(),new Vector());
     newQuery.setEnabled(false);
     saveQuery.setEnabled(false);
     runQuery.setEnabled(false);

     if(!queryLeft.isEnabled())
       queryLeft.setEnabled(true);

     queryX.requestFocus();
  }

public void LoadQuery()
  {
   String xt = "file:" + System.getProperty("user.dir");
   JFileChooser fc = new JFileChooser(xt);
   int returnVal = fc.showOpenDialog(app);
   String s = "file:" + System.getProperty("user.dir") + System.getProperty("file.separator");

   if (returnVal == JFileChooser.APPROVE_OPTION)
    {
      File file = fc.getSelectedFile();
      SQLCompiler analitic = new SQLCompiler(file);
      Vector QueryText = analitic.getInstructions();
      queryX.setText("");

      for(int m=0;m<QueryText.size();m++)
       {
        String tmpQ = "";

        if ( m == QueryText.size()-1)
          tmpQ = (String) QueryText.elementAt(m);
        else
          tmpQ = (String) QueryText.elementAt(m) + "\n";

        int newpos = 0;
        int k = 1;
        queryX.append(tmpQ);
       }

      newQuery.setEnabled(true);
      saveQuery.setEnabled(true);
      runQuery.setEnabled(true);
    }
 }

 public void SaveQuery()
  {
    String instructions =  new String (queryX.getText());
    String s = "file:" + System.getProperty("user.dir");
    File file;
    boolean Rewrite = true;
    String FileName = "";

    JFileChooser fc = new JFileChooser(s);
    ExtensionFilter filter = new ExtensionFilter("sql",idiom.getWord("SQLF"));
    fc.addChoosableFileFilter(filter);

    int returnVal = fc.showDialog(app,idiom.getWord("SAVEQ"));

    if (returnVal == JFileChooser.APPROVE_OPTION) {
           file = fc.getSelectedFile();
           FileName = file.getAbsolutePath(); // Camino Absoluto
           if(file.exists())
            {
              BoolOption win = new BoolOption(app,idiom.getWord("YES"),idiom.getWord("NO"),idiom.getWord("ADV"),
                        idiom.getWord("FILE") + " \"" + FileName + "\" " + idiom.getWord("SEQEXIS2") + " " + idiom.getWord("OVWR"));
              /* win.pack();
              win.setLocationRelativeTo(app);
              win.show(); */
              Rewrite = win.getSelecction();
            }
           if(Rewrite)
           {

             try
              {
                if(!FileName.endsWith(".sql"))
                  FileName += ".sql";

                PrintStream saveFile = new PrintStream(new FileOutputStream(FileName));
                QuerySaver(saveFile,instructions);
              }
             catch(Exception ex) { }
           } // fin if
        } // fin if 
  }

public String getTablesN(String sqlSel) {

     String tmp = sqlSel.substring(6);
     if(tmp.indexOf("select") == -1)
      {
        int p = tmp.indexOf("from");
        int k = tmp.indexOf("where");
        if (k != -1)
         tmp = tmp.substring(p+5,k);
        else
         tmp = tmp.substring(p+5,tmp.length()-1);
      }

     tmp = tmp.trim();
     return tmp;
  }

public void setButtons() {
   newQuery.setEnabled(false);
   functions.setEnabled(true);
   loadQuery.setEnabled(true);
   saveQuery.setEnabled(false);
   runQuery.setEnabled(false);
   queryX.setEditable(true);
 }

public void loadSQL(String sql,boolean run) {
   queryX.setText(sql);
   newQuery.setEnabled(true);
   saveQuery.setEnabled(true);
   runQuery.setEnabled(true);

   if(run)
      RunQuery(queryX.getText());
   else
      showQueryResult(new Vector(),new Vector());
  }

public String getStringQuery() {
   return queryX.getText();
  }

} //Fin de la Clase
