/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS DropTableRecord v 0.1                                                   
* Descripcion:
* Esta clase se encarga de manejar el dialogo mediante el
* cual se elimina un registro en una tabla. 
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.BorderFactory; 
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Vector;

public class DropTableRecord extends JDialog implements ActionListener{

 Table mytable;
 Hashtable hashOp = new Hashtable();
 Hashtable hashText = new Hashtable();
 Hashtable hashBol = new Hashtable();
 boolean[] active;
 String[] fieldName;
 int numFields;
 boolean wellDone=false;
 String delete;
 JFrame myframe;
 Language idiom;

 public DropTableRecord(Table table,JFrame frame,Language leng) 
  {
  super(frame, true);
  idiom = leng;
  setTitle(idiom.getWord("DELREC"));
  mytable = table;
  myframe = frame;
  numFields = mytable.base.NumFields;
  active = new boolean[numFields];

  JPanel global = new JPanel();
  global.setLayout(new BoxLayout(global,BoxLayout.Y_AXIS));
  JPanel base = new JPanel();
  base.setLayout(new GridLayout(0,1));
  JPanel data = new JPanel();
  data.setLayout(new GridLayout(0,1));
  JPanel union = new JPanel();
  union.setLayout(new GridLayout(0,1));
  JPanel operator = new JPanel();
  operator.setLayout(new GridLayout(0,1));

  Vector fields = mytable.base.fields;
  fieldName = new String[numFields];

  String[] ANDOR = {"AND","OR"}; 
  String[] ops = {"=","!=","<",">","<=",">=","like","not like","~","~*","!~","!~*"}; 

  for (int i=0; i<numFields ;i++) 
  {
   active[i] = false;
   String nfield = (String) fields.elementAt(i);
   JTextField area = new JTextField(10);
   JComboBox logical = new JComboBox(ANDOR);

   JCheckBox check = new JCheckBox (nfield);
   String label = "check-" + i;
   check.setActionCommand(label);
   check.addActionListener(this);
   fieldName[i] = nfield;
   JComboBox condition = new JComboBox(ops);
   condition.setEnabled(false);
   area.setEditable(false);
   hashOp.put(label,condition);
   operator.add(condition);
   base.add(check);
   hashText.put(label,area);
   data.add(area);
   if(i<numFields-1) 
    {
      logical.setEnabled(false);
      hashBol.put("" + i,logical);
      union.add(logical);
    }
   else
    {
     JLabel field = new JLabel(" ");
     union.add(field);
    }
                     }

 JLabel title = new JLabel("DELETE FROM " + mytable.Name,JLabel.CENTER);
 JPanel first = new JPanel();
 first.setLayout(new FlowLayout(FlowLayout.CENTER));
 first.add(title);

 Border etched1 = BorderFactory.createEtchedBorder();
 TitledBorder title1 = BorderFactory.createTitledBorder(etched1);
 first.setBorder(title1);

 JPanel center = new JPanel();
 center.setLayout(new BorderLayout());
 center.add(base,BorderLayout.WEST);
 center.add(operator,BorderLayout.CENTER);
 center.add(data,BorderLayout.EAST);

 JPanel up = new JPanel();
 up.setLayout(new FlowLayout(FlowLayout.CENTER));
 up.add(center);
 up.add(union);
 title1 = BorderFactory.createTitledBorder(etched1,"WHERE");
 up.setBorder(title1);

 JButton ok = new JButton(idiom.getWord("DROP"));
 ok.setActionCommand("ButtonOk");
 ok.addActionListener(this);
 JButton cancel = new JButton(idiom.getWord("CANCEL"));
 cancel.setActionCommand("ButtonCancel");
 cancel.addActionListener(this);

 JPanel botons = new JPanel();
 botons.setLayout(new FlowLayout(FlowLayout.CENTER));
 botons.add(ok);
 botons.add(cancel);

 global.add(first);

 if(numFields > 15)
  {
   JScrollPane scroll = new JScrollPane(up);
   scroll.setPreferredSize(new Dimension(400,400));
   global.add(scroll);
  }
 else
   global.add(up);

 global.add(botons);

 getContentPane().add(global);
 pack();
 setLocationRelativeTo(frame);
 setVisible(true);
					
}

 /*** Manejo de eventos ***/
 public void actionPerformed(java.awt.event.ActionEvent e) {

 if(e.getActionCommand().equals("ButtonOk"))
 {
  boolean fail = false;
  delete = "DELETE FROM " + mytable.Name;
  String condition = " WHERE ";
  int t=0;
  for(int k=0;k<numFields;k++) 
    {
     if(active[k])
       {
        t++;
        JTextField areatmp = (JTextField) hashText.get("check-" + k);
        String xtring = areatmp.getText();
        if(!(xtring.length()>0))
         {
          fail = true;
          JOptionPane.showMessageDialog(DropTableRecord.this,idiom.getWord("EFIW") + fieldName[k] + "'.",idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
          break;
         }

        JComboBox tmp = (JComboBox) hashOp.get("check-" + k);
        JComboBox tmpCom = (JComboBox) hashBol.get("" + k);
        String val = ""; 
        if(k != numFields-1 && tmpCom.isEnabled()) 
         {
          val = (String) tmpCom.getSelectedItem();
          val += " ";
         }        
        String op = (String) tmp.getSelectedItem();
        String type = mytable.base.getType(fieldName[k]);
        if(type.startsWith("varchar"))
           xtring = "'" + xtring + "'";         
        condition += fieldName[k] + " " + op + " " + xtring + " " + val;
       }
    } 

    if(!fail)
      {
        boolean ignore = false;
        if(t==0)
         {
          condition = "";
          String mesg = idiom.getWord("E1") + mytable.Name + idiom.getWord("E2");
          BoolOption askhim = new BoolOption(myframe,idiom.getWord("OK"),idiom.getWord("CANCEL"),idiom.getWord("ADV"),mesg);
          askhim.setLocationRelativeTo(DropTableRecord.this);
          askhim.pack();
          askhim.show();
          if(!askhim.getSelecction())
            ignore = true;
         }
        if(!ignore) 
         {
          delete += condition + ";";
          wellDone = true;
          setVisible(false);
         }                
      }

    
  }

if(e.getActionCommand().equals("ButtonCancel")) 
 {
  setVisible(false);
 }

if(e.getActionCommand().startsWith("check-"))
 {
  String cad = e.getActionCommand();
  int num = Integer.parseInt(cad.substring(cad.indexOf("-")+1,cad.length()));
  JCheckBox checktmp = (JCheckBox) e.getSource();
  JComboBox tmp = (JComboBox) hashOp.get(cad);
  JTextField areatmp = (JTextField) hashText.get(cad);
  if(checktmp.isSelected())
   {
    active[num] = true;
    for(int k=num+1;k<numFields;k++) 
    {
     if(active[k])
       {
        JComboBox tmpCom = (JComboBox) hashBol.get("" + num);
        tmpCom.setEnabled(true);
        break;
       }
    } 
    tmp.setEnabled(true);
    areatmp.setEnabled(true);
    areatmp.setEditable(true);
    areatmp.requestFocus();
    if(num>0)
     {
      if(active[num - 1])
       { 
        JComboBox tmpCom = (JComboBox) hashBol.get("" + (num-1));
        tmpCom.setEnabled(true);
       }
      else {
            if((num-2) >= 0)
              for(int j=num-2; j>=0; j--)
               {
                if(active[j])
                {
                 JComboBox tmpCom = (JComboBox) hashBol.get("" + j);
                 tmpCom.setEnabled(true);
                 break;
                }
               }
           } 
     }
   }
  else {
    tmp.setSelectedIndex(0);
    tmp.setEnabled(false);
    areatmp.setText("");
    areatmp.setEditable(false);
    areatmp.setEnabled(false);
    active[num] = false;
    if(num != (numFields - 1))
      {
       JComboBox Com = (JComboBox) hashBol.get("" + num);
       if(Com.isEnabled()) 
        {
         Com.setSelectedIndex(0);
         Com.setEnabled(false);
        }
      }
      boolean deal = false;
      for(int m=num+1;m<numFields;m++)
        {
          if(active[m]) 
           {
             deal = true;
             break;     
           }
        }
      if(!deal)
        {
              for(int j=num-1; j>=0; j--)
               {
                if(active[j])
                {
                 JComboBox tmpCom = (JComboBox) hashBol.get("" + j);
                 tmpCom.setSelectedIndex(0);
                 tmpCom.setEnabled(false);
                 break;
                }
               }
        }
      
        }
}


    }

} // Fin de la Clase
