/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbcx.base;

import com.microsoft.jdbcx.base.BaseImplXAResource;
import com.microsoft.jdbcx.base.BaseXAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class BaseXAResource
implements XAResource {
    private static String footprint = "$Revision:   1.1  $";
    private BaseImplXAResource implXAResource;
    private BaseXAConnection xaConnection;
    private boolean endScan;

    BaseXAResource(BaseXAConnection baseXAConnection, BaseImplXAResource baseImplXAResource) {
        this.xaConnection = baseXAConnection;
        this.implXAResource = baseImplXAResource;
        this.endScan = false;
    }

    private void checkXid(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        byte[] byArray = xid.getGlobalTransactionId();
        if (byArray == null || byArray.length == 0 || byArray.length > 64) {
            throw new XAException(-5);
        }
        byte[] byArray2 = xid.getBranchQualifier();
        if (byArray2 == null || byArray2.length == 0 || byArray2.length > 64) {
            throw new XAException(-5);
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            this.checkXid(xid);
            this.implXAResource.commit(xid, bl);
        }
    }

    public void end(Xid xid, int n) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            this.checkXid(xid);
            this.implXAResource.end(xid, n);
            this.xaConnection.setGlobalTransaction(false);
        }
    }

    public void forget(Xid xid) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            this.checkXid(xid);
            this.implXAResource.forget(xid);
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.implXAResource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            try {
                boolean bl = this.implXAResource.isSameRM(((BaseXAResource)xAResource).implXAResource);
                Object var4_5 = null;
                return bl;
            }
            catch (ClassCastException classCastException) {
                boolean bl = false;
                Object var4_6 = null;
                return bl;
            }
        }
    }

    public int prepare(Xid xid) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            this.checkXid(xid);
            int n = this.implXAResource.prepare(xid);
            Object var4_4 = null;
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Xid[] recover(int n) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            if (n == 0x1000000 || n == 0x1800000) {
                this.endScan = false;
                Xid[] xidArray = this.implXAResource.recover(n);
                if ((n & 0x800000) == 0) return xidArray;
                this.endScan = true;
                return xidArray;
            }
            if (n != 0x800000) {
                if (n != 0) throw new XAException(-5);
            }
            if (this.endScan) {
                throw new XAException(-5);
            }
            Xid[] xidArray = new Xid[]{};
            this.endScan = true;
            return xidArray;
        }
    }

    public void rollback(Xid xid) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            this.checkXid(xid);
            this.implXAResource.rollback(xid);
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return this.implXAResource.setTransactionTimeout(n);
    }

    public void start(Xid xid, int n) throws XAException {
        BaseXAConnection baseXAConnection = this.xaConnection;
        synchronized (baseXAConnection) {
            this.checkXid(xid);
            this.implXAResource.start(xid, n);
            this.xaConnection.setGlobalTransaction(true);
        }
    }
}

