/* $PostgresPy: if/src/datum.h,v 1.16 2004/07/10 15:52:48 flaw Exp $
 * 
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    Header for datum.c
 */
#ifndef PyPg_DATUM_H
#define PyPg_DATUM_H "datum.h"
#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
	PgDatFlag_Void		= 0,
	PgDatFlag_Ref		= 1 << 0,
	PgDatFlag_Final	= 1 << 1
} PyPgDatumFlags;

#define PyPgDatum_HEAD		\
	PyObject_HEAD				\
	Datum				 ob_datum; \
	PyPgDatumFlags	 ob_datum_flags;

typedef struct PyPgDatum {
	PyPgDatum_HEAD
} PyPgDatum, *PgDat;

extern PyTypeObject PyPgDatum_Type;

#define PgDat_NEW() (PyObj)PyPgDatum_Type.tp_alloc(&PyPgDatum_Type, 0)
PyObj PyPgDatum_New(Datum);

Datum Datum_FromPyObjectAndTypeTuple(PyObj, HeapTuple);
Datum Datum_FromPyObjectAndTypeOid(PyObj, Oid);

#define PgDat(OB) ((PgDat)OB)

#define PgDatFlags(OB) (PgDat(OB)->ob_datum_flags)
#define PgDat_IsRef(OB) (PgDatFlags(OB) & PgDatFlag_Ref)

#define PgDat_TypeCheck(OB) (PyObject_TypeCheck(OB, &PyPgDatum_Type))
#define PgDat_TypeCheckExact(OB) (OB->ob_type == &PyPgDatum_Type)

#define PgDat_FetchDatum(OB) (PgDat(OB)->ob_datum)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_DATUM_H */
