/* $PostgresPy: if/src/datum.c,v 1.24 2004/07/25 04:06:46 flaw Exp $
 * 
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    The Datum Python type implementation.
 */
#include <pputils.h>

#include <postgres.h>
#include <utils/syscache.h>
#include <catalog/pg_type.h>
#include <pg.h>

#include <Python.h>
#include <structmember.h>
#include <py.h>

#include "datum.h"

static void
datum_dealloc(PgDat self)
{
	if (PgDat_IsRef(self))
		pfree(DatumGetPointer(self->ob_datum));

	self->ob_datum = 0;
	self->ob_datum_flags = PgDatFlag_Void;
	PyObject_Del(PyObj(self));
}

static int
datum_init(PgDat self, PyObj args, PyObj kw)
{
	PyObj ddata;

	if (PyCFunctionErr_NoKeywordsAllowed(kw))
		return(-1);

	if (PySequence_Length(args) != 1)
	{
		PyErr_Format(PyExc_TypeError,
			"Postgres.Datum() takes only 1 argument(str|int), given %d.",
			PySequence_Length(args)
		);
		return(-1);
	}
	
	ddata = PySequence_GetItem(args, 0);

	if (PyString_CheckExact(ddata))
	{
		Size size = PyString_Size(ddata);
		self->ob_datum = PointerGetDatum(palloc(size));
		PgDatFlags(self) = PgDatFlag_Ref;
		memcpy(DatumGetPointer(self->ob_datum), PYASSTR(ddata), size);
	}
	else if (PyInt_CheckExact(ddata))
	{
		self->ob_datum = PYASINT(ddata);
		PgDatFlags(self) = PgDatFlag_Void;
	}
	else
	{
		PyErr_Format(PyExc_TypeError,
			"Postgres.Datum() takes either a str, or an int, "
			"but was given '%s'.",
			ddata->ob_type->tp_name
		);
		return(-1);
	}

	return(0);
}

static char PyPgDatumType_Doc[] = 
"Python type for a Postgres Datum";

PyTypeObject PyPgDatum_Type = {
	PyObject_HEAD_INIT(NULL)
	0,									/* ob_size */
	"Postgres.Datum",				/* tp_name */
	sizeof(PyPgDatum),			/* tp_basicsize */
	0,									/* tp_itemsize */
	(destructor)datum_dealloc,	/* tp_dealloc */
	NULL,								/* tp_print */
	(getattrfunc)0,				/* tp_getattr */
	(setattrfunc)0,				/* tp_setattr */
	(cmpfunc)0,						/* tp_compare */
	(reprfunc)NULL,				/* tp_repr */
	NULL,								/* tp_as_number */
	NULL,								/* tp_as_sequence */
	NULL,								/* tp_as_mapping */
	(hashfunc)NULL,				/* tp_hash */
	(ternaryfunc)NULL,			/* tp_call */
	(reprfunc)NULL,				/* tp_str */
	NULL,								/* tp_getattro */
	NULL,								/* tp_setattro */
	NULL,								/* tp_as_buffer */
	Py_TPFLAGS_DEFAULT,			/* tp_flags */
	(char*)PyPgDatumType_Doc,	/* tp_doc */
	(traverseproc)NULL,			/* tp_traverse */
	(inquiry)NULL,					/* tp_clear */
	(richcmpfunc)NULL,			/* tp_richcompare */
	(long)NULL,						/* tp_weaklistoffset */
	(getiterfunc)NULL,			/* tp_iter */
	(iternextfunc)NULL,			/* tp_iternext */
	NULL,								/* tp_methods */
	NULL,								/* tp_members */
	NULL,								/* tp_getset */
	NULL,								/* tp_base */
	NULL,								/* tp_dict */
	NULL,								/* tp_descr_get */
	NULL,								/* tp_descr_set */
	NULL,								/* tp_dictoffset */
	(initproc)datum_init,		/* tp_init */
	NULL,								/* tp_alloc */
	PyType_GenericNew,			/* tp_new */
};

PyObj
PyPgDatum_New(Datum datum)
{
	PyObj self;

	self = PgDat_NEW();
	if (self == NULL)
		return(NULL);

	PgDat(self)->ob_datum = datum;

	return(self);
}

Datum
Datum_FromPyObjectAndTypeTuple(PyObj ob, HeapTuple ttup)
{
	Datum rd = 0;
	PyObj obstr = NULL;

	obstr = PyObject_Str(ob);
	rd = OidFunctionCall1(TYPESTRUCT(ttup)->typinput,
					PointerGetDatum(PyString_AS_STRING(obstr)));
	DECREF(obstr);

	return(rd);
}

Datum
Datum_FromPyObjectAndTypeOid(PyObj ob, Oid typoid)
{
	HeapTuple tht = NULL;
	Datum ized = 0;

	tht = SearchSysCache(TYPEOID, ObjectIdGetDatum(typoid),0,0,0);
	ized = Datum_FromPyObjectAndTypeTuple(ob, tht);
	ReleaseSysCache(tht);

	return(ized);
}
