/* $PostgresPy: if/src/constants.c,v 1.7 2004/07/27 09:52:01 flaw Exp $
 * 
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    Flexible source meant to be #include'd into a main
 *    file that #define's TARGET and APFUNC.
 */
#define OBJECTIFY(ARG) (PYINT(ARG))
#define C(V) APFUNC(TARGET, #V, OBJECTIFY(V));
/* elog.h */
	C(DEBUG1)
	C(DEBUG2)
	C(DEBUG3)
	C(DEBUG4)
	C(DEBUG5)
	C(LOG)
	C(INFO)
	C(NOTICE)
	C(WARNING)
	C(ERROR)
	C(FATAL)
	C(PANIC)

/* htup.h */
#define CC(V) C(V##AttributeNumber)
	CC(SelfItemPointer)
	CC(ObjectId)
	CC(MinTransactionId)
	CC(MinCommandId)
	CC(MaxTransactionId)
	CC(MaxCommandId)
	CC(TableOid)
	CC(FirstLowInvalidHeap)

	CC(MaxTuple)
	CC(MaxHeap)
#undef CC

	C(MaxTupleSize)
	C(MaxAttrSize)
	C(MaxSpecialSpace)
	C(HEAPTUPLESIZE)

#define CC(V) C(SizeOfHeap##V)
	CC(Tid)
	CC(Clean)
	CC(Insert)
	CC(Delete)
	CC(Update)
	CC(Header)
#undef CC

#define CC(V) C(XLOG_HEAP_##V)
	CC(INSERT)
	CC(DELETE)
	CC(UPDATE)
	CC(MOVE)
	CC(CLEAN)
	CC(OPMASK)
	CC(INIT_PAGE)
#undef CC

#define CC(V) C(HEAP_##V)
	CC(HASNULL)
	CC(HASVARWIDTH)
	CC(HASEXTERNAL)
	CC(HASCOMPRESSED)
	CC(HASEXTENDED)
	CC(HASOID)
#if (CATALOG_VERSION_NO < 200405000)
	CC(XMAX_IS_XMIN)
#endif
	CC(XMAX_UNLOGGED)
	CC(XMIN_COMMITTED)
	CC(XMIN_INVALID)
	CC(XMAX_COMMITTED)
	CC(XMAX_INVALID)
	CC(MARKED_FOR_UPDATE)
	CC(UPDATED)
	CC(MOVED_OFF)
	CC(MOVED_IN)
	CC(MOVED)
	CC(XACT_MASK)
#undef CC
	C(NAMEDATALEN)
	C(INDEX_MAX_KEYS)
	C(RI_MAX_NUMKEYS)
	C(MAXDIM) // Array Max Dimensions
	C(VARHDRSZ)

#define CC(V) C(STATUS_##V)
	CC(OK)
	CC(ERROR)
	CC(EOF)
	CC(FOUND)
#undef CC

	C(MAXTZLEN)
#define CC(V) C(USE_##V##_DATES)
	CC(POSTGRES)
	CC(ISO)
	CC(SQL)
	CC(GERMAN)
#undef CC

/* trigger.h */
#define CC(V) C(TRIGGER_EVENT_##V)
	CC(INSERT)
	CC(DELETE)
	CC(UPDATE)
	CC(OPMASK)
	CC(ROW)
	CC(BEFORE)
#undef CC

#define CC(V) C(TRIGGER_DEFERRED_##V)
	CC(DONE)
	CC(CANCELED)
	CC(DEFERRABLE)
	CC(INITDEFERRED)
	CC(HAS_BEFORE)
#undef CC
/* syscache.h */
	C(AGGFNOID)
	C(AMNAME)
	C(AMOID)
	C(AMOPOPID)
	C(AMOPSTRATEGY)
	C(AMPROCNUM)
	C(ATTNAME)
	C(ATTNUM)
	C(CASTSOURCETARGET)
	C(CLAAMNAMENSP)
	C(CLAOID)
	C(CONDEFAULT)
	C(CONNAMENSP)
	C(CONOID)
	C(GRONAME)
	C(GROSYSID)
	C(INDEXRELID)
	C(INHRELID)
	C(LANGNAME)
	C(LANGOID)
	C(NAMESPACENAME)
	C(NAMESPACEOID)
	C(OPERNAMENSP)
	C(OPEROID)
	C(PROCNAMENSP)
	C(PROCOID)
	C(RELNAMENSP)
	C(RELOID)
	C(RULERELNAME)
	C(SHADOWNAME)
	C(SHADOWSYSID)
	C(STATRELATT)
	C(TYPENAMENSP)
	C(TYPEOID)
/* End Of ints */
	
#undef OBJECTIFY
#define OBJECTIFY(ARG) (PYSTR(ARG))
	APFUNC(TARGET, "VERSION", OBJECTIFY(PG_VERSION));
	APFUNC(TARGET, "VERSION_STR", OBJECTIFY(PG_VERSION_STR));

/* catname.h */
#define CC(V) C(V##RelationName)
	CC(Aggregate)
	CC(AccessMethod)
	CC(AccessMethodOperator)
	CC(AccessMethodProcedure)
	CC(Attribute)
	CC(Cast)
	CC(Constraint)
	CC(Conversion)
	CC(Database)
	CC(Depend)
	CC(Description)
	CC(Group)
	CC(Index)
	CC(Inherits)
	CC(Language)
	CC(LargeObject)
	CC(Listener)
	CC(Namespace)
	CC(OperatorClass)
	CC(Operator)
	CC(Procedure)
	CC(Relation)
	CC(Rewrite)
	CC(Shadow)
	CC(Statistic)
	CC(Type)
	CC(Version)
	CC(AttrDefault)
	CC(Trigger)
#undef CC
#undef C
