/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import java.util.Arrays;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.SingleRowResultSet;

public class SingleRowWriter
extends SingleRowResultSet {
    private final Object[] m_values;

    public SingleRowWriter(TupleDesc tupleDesc) throws SQLException {
        super(tupleDesc);
        this.m_values = new Object[tupleDesc.size()];
    }

    protected Object getObjectValue(int columnIndex) throws SQLException {
        return this.m_values[columnIndex + 1];
    }

    public boolean rowUpdated() throws SQLException {
        int top = this.m_values.length;
        while (--top >= 0) {
            if (this.m_values[top] == null) continue;
            return true;
        }
        return false;
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.m_values[columnIndex - 1] = x;
    }

    public void cancelRowUpdates() throws SQLException {
        Arrays.fill(this.m_values, null);
    }

    public Tuple getTupleAndClear() throws SQLException {
        Tuple tuple = this.getTupleDesc().formTuple(this.m_values);
        Arrays.fill(this.m_values, null);
        return tuple;
    }
}

